/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr.path;

import org.basex.query.iter.BasicNodeIter;
import org.basex.query.value.node.ANode;
import org.basex.util.Enums;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum Axis {
    ANCESTOR_OR_SELF("ancestor-or-self", false){

        @Override
        BasicNodeIter iter(ANode n) {
            return n.ancestorIter(true);
        }
    }
    ,
    ANCESTOR("ancestor", false){

        @Override
        BasicNodeIter iter(ANode n) {
            return n.ancestorIter(false);
        }
    }
    ,
    ATTRIBUTE("attribute", true){

        @Override
        BasicNodeIter iter(ANode n) {
            return n.attributeIter();
        }
    }
    ,
    CHILD("child", true){

        @Override
        BasicNodeIter iter(ANode n) {
            return n.childIter();
        }
    }
    ,
    DESCENDANT_OR_SELF("descendant-or-self", true){

        @Override
        BasicNodeIter iter(ANode n) {
            return n.descendantIter(true);
        }
    }
    ,
    DESCENDANT("descendant", true){

        @Override
        BasicNodeIter iter(ANode n) {
            return n.descendantIter(false);
        }
    }
    ,
    FOLLOWING_SIBLING_OR_SELF("following-sibling-or-self", false){

        @Override
        BasicNodeIter iter(ANode n) {
            return n.followingSiblingIter(true);
        }
    }
    ,
    FOLLOWING_SIBLING("following-sibling", false){

        @Override
        BasicNodeIter iter(ANode n) {
            return n.followingSiblingIter(false);
        }
    }
    ,
    FOLLOWING_OR_SELF("following-or-self", false){

        @Override
        BasicNodeIter iter(ANode n) {
            return n.followingIter(true);
        }
    }
    ,
    FOLLOWING("following", false){

        @Override
        BasicNodeIter iter(ANode n) {
            return n.followingIter(false);
        }
    }
    ,
    PARENT("parent", false){

        @Override
        BasicNodeIter iter(ANode n) {
            return n.parentIter();
        }
    }
    ,
    PRECEDING_SIBLING_OR_SELF("preceding-sibling-or-self", false){

        @Override
        BasicNodeIter iter(ANode n) {
            return n.precedingSiblingIter(true);
        }
    }
    ,
    PRECEDING_SIBLING("preceding-sibling", false){

        @Override
        BasicNodeIter iter(ANode n) {
            return n.precedingSiblingIter(false);
        }
    }
    ,
    PRECEDING_OR_SELF("preceding-or-self", false){

        @Override
        BasicNodeIter iter(ANode n) {
            return n.precedingIter(true);
        }
    }
    ,
    PRECEDING("preceding", false){

        @Override
        BasicNodeIter iter(ANode n) {
            return n.precedingIter(false);
        }
    }
    ,
    SELF("self", true){

        @Override
        BasicNodeIter iter(ANode n) {
            return n.selfIter();
        }
    };

    public final String name;
    public final boolean down;

    private Axis(String name, boolean down) {
        this.name = name;
        this.down = down;
    }

    abstract BasicNodeIter iter(ANode var1);

    public boolean oneOf(Axis ... candidates) {
        return Enums.oneOf((Enum)this, (Enum[])candidates);
    }

    public String toString() {
        return this.name;
    }

    public final Axis invert() {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case ANCESTOR -> DESCENDANT;
            case ANCESTOR_OR_SELF -> DESCENDANT_OR_SELF;
            case ATTRIBUTE, CHILD -> PARENT;
            case DESCENDANT -> ANCESTOR;
            case DESCENDANT_OR_SELF -> ANCESTOR_OR_SELF;
            case FOLLOWING_SIBLING -> PRECEDING_SIBLING;
            case FOLLOWING_SIBLING_OR_SELF -> PRECEDING_SIBLING_OR_SELF;
            case FOLLOWING -> PRECEDING;
            case FOLLOWING_OR_SELF -> PRECEDING_OR_SELF;
            case PARENT -> CHILD;
            case PRECEDING_SIBLING -> FOLLOWING_SIBLING;
            case PRECEDING_SIBLING_OR_SELF -> FOLLOWING_SIBLING_OR_SELF;
            case PRECEDING -> FOLLOWING;
            case PRECEDING_OR_SELF -> FOLLOWING_OR_SELF;
            case SELF -> SELF;
        };
    }
}

