/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.sql;

import java.io.IOException;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLTimeoutException;
import java.sql.SQLXML;
import java.sql.Statement;
import org.basex.io.IOContent;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryText;
import org.basex.query.func.sql.SqlFn;
import org.basex.query.iter.Iter;
import org.basex.query.value.Value;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.Itr;
import org.basex.query.value.item.QNm;
import org.basex.query.value.node.DBNode;
import org.basex.query.value.node.FBuilder;
import org.basex.query.value.node.FElem;
import org.basex.util.Util;
import org.basex.util.options.NumberOption;
import org.basex.util.options.Options;

public class SqlExecute
extends SqlFn {
    static final QNm Q_ROW = new QNm(QueryText.SQL_PREFIX, "row", QueryText.SQL_URI);
    static final QNm Q_COLUMN = new QNm(QueryText.SQL_PREFIX, "column", QueryText.SQL_URI);
    static final QNm Q_PARAMETERS = new QNm(QueryText.SQL_PREFIX, "parameters", QueryText.SQL_URI);
    static final QNm Q_PARAMETER = new QNm(QueryText.SQL_PREFIX, "parameter", QueryText.SQL_URI);
    static final QNm Q_NAME = new QNm("name");

    @Override
    public Iter iter(QueryContext qc) throws QueryException {
        Connection conn = this.connection(qc);
        String query = this.toString(this.arg(1), qc);
        StatementOptions options = this.toOptions(this.arg(2), new StatementOptions(), qc);
        try {
            Statement stmt = conn.createStatement();
            stmt.setQueryTimeout(options.get(StatementOptions.TIMEOUT));
            return this.iter(stmt, true, stmt.execute(query));
        }
        catch (SQLTimeoutException ex) {
            throw QueryError.SQL_TIMEOUT_X.get(this.info, ex);
        }
        catch (SQLException ex) {
            throw QueryError.SQL_ERROR_X.get(this.info, ex);
        }
    }

    @Override
    public final Value value(QueryContext qc) throws QueryException {
        return this.iter(qc).value(qc, this);
    }

    final Iter iter(final Statement stmt, final boolean close, boolean result) throws QueryException {
        try {
            if (!result) {
                return Itr.get(stmt.getUpdateCount()).iter();
            }
            final ResultSet rs = stmt.getResultSet();
            final ResultSetMetaData md = rs.getMetaData();
            final int cols = md.getColumnCount();
            return new Iter(){

                @Override
                public Item next() throws QueryException {
                    try {
                        if (!rs.next()) {
                            rs.close();
                            if (close) {
                                stmt.close();
                            }
                            return null;
                        }
                        FBuilder row = FElem.build(Q_ROW).declareNS();
                        for (int c = 1; c <= cols; ++c) {
                            String name = md.getColumnLabel(c);
                            Object value = rs.getObject(c);
                            if (value == null) continue;
                            FBuilder column = FElem.build(Q_COLUMN).add(Q_NAME, name);
                            if (value instanceof SQLXML) {
                                SQLXML sxml = (SQLXML)value;
                                String xml = sxml.getString();
                                try {
                                    column.add(new DBNode(new IOContent(xml)).childIter().next());
                                }
                                catch (IOException ex) {
                                    Util.debug(ex);
                                    column.add(xml);
                                }
                            } else if (value instanceof Clob) {
                                Clob clob = (Clob)value;
                                column.add(clob.getSubString(1L, (int)clob.length()));
                            } else {
                                column.add(value);
                            }
                            row.add(column);
                        }
                        return row.finish();
                    }
                    catch (SQLException ex) {
                        throw QueryError.SQL_ERROR_X.get(SqlExecute.this.info, ex);
                    }
                }
            };
        }
        catch (SQLException ex) {
            throw QueryError.SQL_ERROR_X.get(this.info, ex);
        }
    }

    public static class StatementOptions
    extends Options {
        public static final NumberOption TIMEOUT = new NumberOption("timeout", 0);
    }
}

