/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.up.primitives.node;

import org.basex.data.Data;
import org.basex.data.MemData;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.up.NamePool;
import org.basex.query.up.atomic.AtomicUpdateCache;
import org.basex.query.up.primitives.Update;
import org.basex.query.up.primitives.UpdateType;
import org.basex.query.up.primitives.node.NodeUpdate;
import org.basex.query.value.item.QNm;
import org.basex.query.value.node.DBNode;
import org.basex.query.value.type.NodeType;
import org.basex.util.InputInfo;
import org.basex.util.Util;

public final class RenameNode
extends NodeUpdate {
    private final QNm name;

    public RenameNode(int pre, Data data, InputInfo info, QNm name) {
        super(UpdateType.RENAMENODE, pre, data, info);
        this.name = name;
    }

    @Override
    public void prepare(MemData memData, QueryContext qc) {
    }

    @Override
    public void merge(Update update) throws QueryException {
        throw QueryError.UPMULTREN_X.get(this.info, this.node());
    }

    @Override
    public void update(NamePool pool) {
        DBNode node = this.node();
        pool.add(this.name, (NodeType)node.type);
        pool.remove(node);
    }

    public String toString() {
        return Util.className(this) + "[" + String.valueOf(this.node()) + ", " + String.valueOf(this.name) + "]";
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public void addAtomics(AtomicUpdateCache auc) {
        auc.addRename(this.pre, this.name.string(), this.name.uri());
    }
}

