/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core.cmd;

import java.io.IOException;
import org.basex.core.MainOptions;
import org.basex.core.Text;
import org.basex.core.cmd.ACreate;
import org.basex.core.cmd.DropIndex;
import org.basex.core.parse.CmdBuilder;
import org.basex.core.parse.Commands;
import org.basex.core.users.Perm;
import org.basex.data.Data;
import org.basex.index.IndexType;
import org.basex.util.ft.Language;

public final class CreateIndex
extends ACreate {
    public CreateIndex(Object type) {
        super(Perm.WRITE, true, type != null ? type.toString() : null);
    }

    @Override
    protected boolean run() {
        IndexType type;
        Data data = this.context.data();
        Commands.CmdIndex ci = this.getOption(Commands.CmdIndex.class);
        switch (ci) {
            case TEXT: {
                type = IndexType.TEXT;
                data.meta.createtext = true;
                break;
            }
            case ATTRIBUTE: {
                type = IndexType.ATTRIBUTE;
                data.meta.createattr = true;
                break;
            }
            case TOKEN: {
                type = IndexType.TOKEN;
                data.meta.createtoken = true;
                break;
            }
            case FULLTEXT: {
                type = IndexType.FULLTEXT;
                data.meta.createft = true;
                data.meta.stemming = this.options.get(MainOptions.STEMMING);
                data.meta.casesens = this.options.get(MainOptions.CASESENS);
                data.meta.diacritics = this.options.get(MainOptions.DIACRITICS);
                data.meta.language = Language.get(this.options);
                data.meta.stopwords = this.options.get(MainOptions.STOPWORDS);
                break;
            }
            default: {
                return this.error(Text.UNKNOWN_CMD_X, this);
            }
        }
        data.meta.names(type, this.options);
        data.meta.splitsize = this.options.get(MainOptions.SPLITSIZE);
        return this.update(data, () -> {
            CreateIndex.create(type, data, this);
            return this.info(Text.INDEX_CREATED_X_X, new Object[]{type, this.jc().performance});
        });
    }

    @Override
    public void build(CmdBuilder cb) {
        cb.init(String.valueOf((Object)Commands.Cmd.CREATE) + " " + String.valueOf((Object)Commands.CmdCreate.INDEX)).args();
    }

    static void create(Data data, ACreate cmd) throws IOException {
        if (data.meta.createtext) {
            CreateIndex.create(IndexType.TEXT, data, cmd);
        }
        if (data.meta.createattr) {
            CreateIndex.create(IndexType.ATTRIBUTE, data, cmd);
        }
        if (data.meta.createtoken) {
            CreateIndex.create(IndexType.TOKEN, data, cmd);
        }
        if (data.meta.createft) {
            CreateIndex.create(IndexType.FULLTEXT, data, cmd);
        }
    }

    static void create(IndexType type, Data data, ACreate cmd) throws IOException {
        DropIndex.drop(type, data);
        data.createIndex(type, cmd);
        data.meta.index(type, true);
    }
}

