/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.seq;

import java.io.IOException;
import java.util.function.Predicate;
import org.basex.core.Stores;
import org.basex.core.jobs.Job;
import org.basex.data.Data;
import org.basex.io.in.DataInput;
import org.basex.io.out.DataOutput;
import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryPlan;
import org.basex.query.QueryString;
import org.basex.query.expr.Expr;
import org.basex.query.func.Function;
import org.basex.query.value.Value;
import org.basex.query.value.item.Item;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.seq.Seq;
import org.basex.query.value.type.NodeType;
import org.basex.query.value.type.Type;
import org.basex.util.InputInfo;
import org.basex.util.Util;

public final class SingletonSeq
extends Seq {
    private final Value value;

    private SingletonSeq(long size, Value value) {
        super(size, value.type);
        this.value = value;
    }

    public static Value read(DataInput in, Type type, QueryContext qc) throws IOException, QueryException {
        long count = in.readLong();
        Value value = Stores.read(in, qc);
        return SingletonSeq.get(value, count);
    }

    @Override
    public void write(DataOutput out) throws IOException, QueryException {
        out.writeLong(this.count());
        Stores.write(out, this.value);
    }

    @Override
    public void cache(boolean lazy, InputInfo ii) throws QueryException {
        this.value.cache(lazy, ii);
    }

    @Override
    public Value atomValue(QueryContext qc, InputInfo ii) throws QueryException {
        return SingletonSeq.get(this.value.atomValue(qc, ii), this.size);
    }

    @Override
    protected Value subSeq(long pos, long length, Job job) {
        return this.singleItem() ? SingletonSeq.get(this.value, length) : super.subSeq(pos, length, job);
    }

    @Override
    public Value insertValue(long pos, Value val, Job job) {
        return val.equals(this.value) ? SingletonSeq.get(this.value, this.size + 1L) : super.insertValue(pos, val, job);
    }

    @Override
    public Value removeItem(long pos, Job job) {
        return this.singleItem() ? SingletonSeq.get(this.value, this.size - 1L) : super.removeItem(pos, job);
    }

    @Override
    public Value reverse(Job job) {
        return this.singleItem() ? this : SingletonSeq.get(this.value.reverse(job), this.count());
    }

    @Override
    public Item itemAt(long index) {
        return this.value.itemAt(index % this.value.size());
    }

    @Override
    public Expr simplifyFor(CompileContext.Simplify mode, CompileContext cc) throws QueryException {
        Value expr = this;
        if (mode == CompileContext.Simplify.DISTINCT || mode == CompileContext.Simplify.PREDICATE && this.type.isNumber()) {
            expr = this.value;
        } else if (this.type instanceof NodeType && mode.oneOf(CompileContext.Simplify.DATA, CompileContext.Simplify.NUMBER, CompileContext.Simplify.STRING)) {
            expr = SingletonSeq.get((Value)this.value.simplifyFor(mode, cc), this.count());
        }
        return cc.simplify(this, expr, mode);
    }

    @Override
    public Value materialize(Predicate<Data> test, InputInfo ii, QueryContext qc) throws QueryException {
        return this.materialized(test, ii) ? this : SingletonSeq.get(this.value.materialize(test, ii, qc), this.size);
    }

    @Override
    public boolean materialized(Predicate<Data> test, InputInfo ii) throws QueryException {
        return this.value.materialized(test, ii);
    }

    @Override
    public String description() {
        return "singleton " + super.description();
    }

    @Override
    public void toXml(QueryPlan plan) {
        plan.add(plan.create(this, new Object[0]), this.value);
    }

    @Override
    public void toString(QueryString qs) {
        qs.function(Function.REPLICATE, this.value, this.count());
    }

    public boolean singleItem() {
        return this.value.size() == 1L;
    }

    public long count() {
        return this.size / this.value.size();
    }

    @Override
    public Value shrink(Job job) throws QueryException {
        this.value.shrink(job);
        return this;
    }

    public static Value get(Value value, long count) {
        if (count == 1L) {
            return value;
        }
        long vs = value.size();
        long size = vs * count;
        if (size == 0L) {
            return Empty.VALUE;
        }
        if (!Util.inBounds(vs, count)) {
            throw new OutOfMemoryError("Memory limit reached.");
        }
        Value val = value;
        if (val instanceof SingletonSeq) {
            SingletonSeq ss = (SingletonSeq)val;
            val = ss.value;
        } else if (vs > 1L) {
            Item item = val.itemAt(0L);
            int v = 0;
            while ((long)(++v) < vs && item.equals(val.itemAt(v))) {
            }
            if ((long)v == vs) {
                val = item;
            }
        }
        return size == 1L ? val : new SingletonSeq(size, val);
    }
}

