/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.validation.release;

import org.jreleaser.bundle.RB;
import org.jreleaser.model.api.JReleaserContext;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.release.Release;
import org.jreleaser.model.internal.validation.common.Validator;
import org.jreleaser.model.internal.validation.release.CodebergReleaserValidator;
import org.jreleaser.model.internal.validation.release.ForgejoReleaserValidator;
import org.jreleaser.model.internal.validation.release.GenericGitReleaserValidator;
import org.jreleaser.model.internal.validation.release.GiteaReleaserValidator;
import org.jreleaser.model.internal.validation.release.GithubReleaserValidator;
import org.jreleaser.model.internal.validation.release.GitlabReleaserValidator;
import org.jreleaser.util.Errors;

public final class ReleaseValidator {
    private ReleaseValidator() {
    }

    public static void validateRelease(JReleaserContext context, JReleaserContext.Mode mode, Errors errors) {
        context.getLogger().debug("release");
        Release release = context.getModel().getRelease();
        int count = 0;
        Errors incoming = new Errors();
        if (GithubReleaserValidator.validateGithub(context, mode, release.getGithub(), incoming)) {
            count += ReleaseValidator.handleReleaserValidation(context, errors, incoming);
        }
        if (GitlabReleaserValidator.validateGitlab(context, mode, release.getGitlab(), incoming)) {
            count += ReleaseValidator.handleReleaserValidation(context, errors, incoming);
        }
        if (GiteaReleaserValidator.validateGitea(context, mode, release.getGitea(), incoming)) {
            count += ReleaseValidator.handleReleaserValidation(context, errors, incoming);
        }
        if (ForgejoReleaserValidator.validateForgejo(context, mode, release.getForgejo(), incoming)) {
            count += ReleaseValidator.handleReleaserValidation(context, errors, incoming);
        }
        if (CodebergReleaserValidator.validateCodeberg(context, mode, release.getCodeberg(), incoming)) {
            count += ReleaseValidator.handleReleaserValidation(context, errors, incoming);
        }
        if (GenericGitReleaserValidator.validateGeneric(context, mode, release.getGeneric(), incoming)) {
            count += ReleaseValidator.handleReleaserValidation(context, errors, incoming);
        }
        if (!mode.validateStandalone()) {
            if (0 == count) {
                errors.configuration(RB.$((String)"validation_release_no_providers", (Object[])new Object[0]));
                return;
            }
            if (count > 1) {
                errors.configuration(RB.$((String)"validation_release_requirement", (Object[])new Object[]{"release.[github|gitlab|gitea|forgejo|codeberg|generic]"}));
            }
        }
    }

    private static int handleReleaserValidation(JReleaserContext context, Errors errors, Errors incoming) {
        Validator.mergeErrors(context, errors, incoming, null);
        return 1;
    }
}

