/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.util;

import com.github.luben.zstd.Zstd;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileSystemLoopException;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.archivers.ar.ArArchiveEntry;
import org.apache.commons.compress.archivers.ar.ArArchiveOutputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorOutputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorOutputStream;
import org.apache.commons.compress.compressors.xz.XZCompressorInputStream;
import org.apache.commons.compress.compressors.xz.XZCompressorOutputStream;
import org.apache.commons.compress.compressors.zstandard.ZstdCompressorInputStream;
import org.apache.commons.compress.compressors.zstandard.ZstdCompressorOutputStream;
import org.apache.commons.io.IOUtils;
import org.jreleaser.bundle.RB;
import org.jreleaser.logging.JReleaserLogger;
import org.jreleaser.util.Env;
import org.jreleaser.util.FileType;
import org.jreleaser.util.IoUtils;
import org.jreleaser.util.StringUtils;

public final class FileUtils {
    private static final String[] LICENSE_FILE_NAMES = new String[]{"LICENSE", "LICENSE.txt", "LICENSE.md", "LICENSE.adoc"};
    private static final String[] TAR_COMPRESSED_EXTENSIONS = new String[]{FileType.TAR_BZ2.extension(), FileType.TAR_GZ.extension(), FileType.TAR_XZ.extension(), FileType.TAR_ZST.extension(), FileType.TBZ2.extension(), FileType.TGZ.extension(), FileType.TXZ.extension()};

    private FileUtils() {
    }

    public static boolean isHidden(Path path) {
        try {
            return Files.isHidden(path);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void listFilesAndConsume(Path path, Consumer<Stream<Path>> consumer) throws IOException {
        if (!Files.exists(path, new LinkOption[0])) {
            return;
        }
        try (Stream<Path> files = Files.list(path);){
            consumer.accept(files);
        }
    }

    public static <T> Optional<T> listFilesAndProcess(Path path, Function<Stream<Path>, T> function) throws IOException {
        if (!Files.exists(path, new LinkOption[0])) {
            return Optional.empty();
        }
        try (Stream<Path> files = Files.list(path);){
            Optional<T> optional = Optional.ofNullable(function.apply(files));
            return optional;
        }
    }

    public static Optional<Path> findLicenseFile(Path basedir) {
        for (String licenseFilename : LICENSE_FILE_NAMES) {
            Path path = basedir.resolve(licenseFilename);
            if (Files.exists(path, new LinkOption[0])) {
                return Optional.of(path);
            }
            path = basedir.resolve(licenseFilename.toLowerCase(Locale.ENGLISH));
            if (!Files.exists(path, new LinkOption[0])) continue;
            return Optional.of(path);
        }
        return Optional.empty();
    }

    public static Path resolveOutputDirectory(Path basedir, Path outputdir, String baseOutput) {
        String od = Env.resolve("OUTPUT_DIRECTORY", "");
        if (StringUtils.isNotBlank(od)) {
            return basedir.resolve(od).resolve("jreleaser").normalize();
        }
        if (null != outputdir) {
            return basedir.resolve(outputdir).resolve("jreleaser").normalize();
        }
        return basedir.resolve(baseOutput).resolve("jreleaser").normalize();
    }

    public static void zip(Path src, Path dest) throws IOException {
        FileUtils.zip(src, dest, new ArchiveOptions());
    }

    public static void zip(Path src, Path dest, ArchiveOptions options) throws IOException {
        try (ZipArchiveOutputStream out = new ZipArchiveOutputStream(dest.toFile());){
            out.setMethod(8);
            Set<Path> paths = !options.getIncludedPaths().isEmpty() ? options.getIncludedPaths() : FileUtils.collectPaths(src);
            FileTime fileTime = null != options.getTimestamp() ? FileTime.from(options.getTimestamp().toInstant()) : null;
            String rootEntryName = options.getRootEntryName();
            if (null == rootEntryName) {
                rootEntryName = "";
            } else if (!rootEntryName.endsWith("/")) {
                rootEntryName = rootEntryName + "/";
            }
            TreeSet<String> entryNames = new TreeSet<String>();
            for (Path path : paths) {
                Path parentPath;
                String entryName = rootEntryName + src.relativize(path);
                entryNames.add(entryName);
                if (options.isCreateIntermediateDirs() && null != (parentPath = Paths.get(entryName, new String[0]).getParent())) {
                    Iterator<Path> it = parentPath.iterator();
                    ArrayList<String> directories = new ArrayList<String>();
                    while (it.hasNext()) {
                        Path directoryPath = it.next();
                        directories.add(directoryPath.getFileName().toString());
                        String directoryEntryName = String.join((CharSequence)"/", directories) + "/";
                        if ("./".equals(directoryEntryName) || entryNames.contains(directoryEntryName)) continue;
                        ZipArchiveEntry archiveEntry = new ZipArchiveEntry(directoryEntryName);
                        if (null != fileTime) {
                            archiveEntry.setTime(fileTime);
                        }
                        out.putArchiveEntry(archiveEntry);
                        out.closeArchiveEntry();
                        entryNames.add(directoryEntryName);
                    }
                }
                File inputFile = path.toFile();
                ZipArchiveEntry archiveEntry = new ZipArchiveEntry(inputFile, entryName);
                if (null != fileTime) {
                    archiveEntry.setTime(fileTime);
                }
                archiveEntry.setMethod(8);
                if (inputFile.isFile() && Files.isExecutable(path)) {
                    archiveEntry.setUnixMode(33261);
                }
                out.putArchiveEntry(archiveEntry);
                if (inputFile.isFile()) {
                    out.write(Files.readAllBytes(path));
                }
                out.closeArchiveEntry();
            }
        }
    }

    public static void ar(Path src, Path dest) throws IOException {
        FileUtils.ar(src, dest, new ArchiveOptions());
    }

    public static void ar(Path src, Path dest, ArchiveOptions options) throws IOException {
        try (ArArchiveOutputStream out = new ArArchiveOutputStream(Files.newOutputStream(dest, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING));){
            FileUtils.ar(src, out, options);
        }
    }

    public static void tar(Path src, Path dest) throws IOException {
        FileUtils.tar(src, dest, new ArchiveOptions());
    }

    public static void tar(Path src, Path dest, ArchiveOptions options) throws IOException {
        try (TarArchiveOutputStream out = new TarArchiveOutputStream(Files.newOutputStream(dest, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING));){
            FileUtils.tar(src, out, options);
        }
    }

    public static void tgz(Path src, Path dest) throws IOException {
        FileUtils.tgz(src, dest, new ArchiveOptions());
    }

    public static void tgz(Path src, Path dest, ArchiveOptions options) throws IOException {
        try (TarArchiveOutputStream out = new TarArchiveOutputStream((OutputStream)new GzipCompressorOutputStream(Files.newOutputStream(dest, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING)));){
            FileUtils.tar(src, out, options);
        }
    }

    public static void bz2(Path src, Path dest) throws IOException {
        FileUtils.bz2(src, dest, new ArchiveOptions());
    }

    public static void bz2(Path src, Path dest, ArchiveOptions options) throws IOException {
        try (TarArchiveOutputStream out = new TarArchiveOutputStream((OutputStream)new BZip2CompressorOutputStream(Files.newOutputStream(dest, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING)));){
            FileUtils.tar(src, out, options);
        }
    }

    public static void xz(Path src, Path dest) throws IOException {
        FileUtils.xz(src, dest, new ArchiveOptions());
    }

    public static void xz(Path src, Path dest, ArchiveOptions options) throws IOException {
        try (TarArchiveOutputStream out = new TarArchiveOutputStream((OutputStream)new XZCompressorOutputStream(Files.newOutputStream(dest, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING)));){
            FileUtils.tar(src, out, options);
        }
    }

    public static void zst(Path src, Path dest) throws IOException {
        FileUtils.zst(src, dest, new ArchiveOptions());
    }

    public static void zst(Path src, Path dest, ArchiveOptions options) throws IOException {
        try (TarArchiveOutputStream out = new TarArchiveOutputStream((OutputStream)new ZstdCompressorOutputStream(Files.newOutputStream(dest, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING), Zstd.defaultCompressionLevel(), true));){
            FileUtils.tar(src, out, options);
        }
    }

    private static void tar(Path src, TarArchiveOutputStream out, ArchiveOptions options) throws IOException {
        Set<Path> paths = !options.getIncludedPaths().isEmpty() ? options.getIncludedPaths() : FileUtils.collectPaths(src);
        out.setLongFileMode(options.getLongFileMode().toLongFileMode());
        out.setBigNumberMode(options.getBigNumberMode().toBigNumberMode());
        FileTime fileTime = null != options.getTimestamp() ? FileTime.from(options.getTimestamp().toInstant()) : null;
        String rootEntryName = options.getRootEntryName();
        if (null == rootEntryName) {
            rootEntryName = "";
        } else if (!rootEntryName.endsWith("/")) {
            rootEntryName = rootEntryName + "/";
        }
        TreeSet<String> entryNames = new TreeSet<String>();
        for (Path path : paths) {
            Path parentPath;
            String entryName = rootEntryName + src.relativize(path);
            entryNames.add(entryName);
            if (options.isCreateIntermediateDirs() && null != (parentPath = Paths.get(entryName, new String[0]).getParent())) {
                Iterator<Path> it = parentPath.iterator();
                ArrayList<String> directories = new ArrayList<String>();
                while (it.hasNext()) {
                    Path directoryPath = it.next();
                    directories.add(directoryPath.getFileName().toString());
                    String directoryEntryName = String.join((CharSequence)"/", directories) + "/";
                    if ("./".equals(directoryEntryName) || entryNames.contains(directoryEntryName)) continue;
                    TarArchiveEntry archiveEntry = new TarArchiveEntry(directoryEntryName);
                    if (null != fileTime) {
                        archiveEntry.setModTime(fileTime);
                    }
                    out.putArchiveEntry(archiveEntry);
                    out.closeArchiveEntry();
                    entryNames.add(directoryEntryName);
                }
            }
            File inputFile = path.toFile();
            TarArchiveEntry archiveEntry = out.createArchiveEntry(inputFile, entryName);
            if (null != fileTime) {
                archiveEntry.setModTime(fileTime);
            }
            if (inputFile.isFile() && Files.isExecutable(path)) {
                archiveEntry.setMode(33261);
            }
            out.putArchiveEntry(archiveEntry);
            if (inputFile.isFile()) {
                out.write(Files.readAllBytes(path));
            }
            out.closeArchiveEntry();
        }
    }

    private static void ar(Path src, ArArchiveOutputStream out, ArchiveOptions options) throws IOException {
        Set<Path> paths = !options.getIncludedPaths().isEmpty() ? options.getIncludedPaths() : FileUtils.collectPaths(src);
        out.setLongFileMode(options.getLongFileMode().toLongFileMode());
        String rootEntryName = options.getRootEntryName();
        if (null == rootEntryName) {
            rootEntryName = "";
        } else if (!rootEntryName.endsWith("/")) {
            rootEntryName = rootEntryName + "/";
        }
        TreeSet<String> entryNames = new TreeSet<String>();
        for (Path path : paths) {
            Path parentPath;
            String entryName = rootEntryName + src.relativize(path);
            entryNames.add(entryName);
            if (options.isCreateIntermediateDirs() && null != (parentPath = Paths.get(entryName, new String[0]).getParent())) {
                Iterator<Path> it = parentPath.iterator();
                ArrayList<String> directories = new ArrayList<String>();
                while (it.hasNext()) {
                    Path directoryPath = it.next();
                    directories.add(directoryPath.getFileName().toString());
                    String directoryEntryName = String.join((CharSequence)"/", directories) + "/";
                    if ("./".equals(directoryEntryName) || entryNames.contains(directoryEntryName)) continue;
                    ArArchiveEntry archiveEntry = new ArArchiveEntry(directoryEntryName, (long)directoryEntryName.length());
                    out.putArchiveEntry(archiveEntry);
                    out.closeArchiveEntry();
                    entryNames.add(directoryEntryName);
                }
            }
            File inputFile = path.toFile();
            ArArchiveEntry archiveEntry = out.createArchiveEntry(inputFile, entryName);
            out.putArchiveEntry(archiveEntry);
            if (inputFile.isFile()) {
                out.write(Files.readAllBytes(path));
            }
            out.closeArchiveEntry();
        }
    }

    private static TreeSet<Path> collectPaths(Path src) throws IOException {
        final TreeSet<Path> paths = new TreeSet<Path>();
        Files.walkFileTree(src, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                paths.add(file);
                return super.visitFile(file, attrs);
            }
        });
        return paths;
    }

    public static void packArchive(Path src, Path dest) throws IOException {
        FileUtils.packArchive(src, dest, new ArchiveOptions());
    }

    public static void packArchive(Path src, Path dest, ArchiveOptions options) throws IOException {
        String filename = dest.getFileName().toString();
        if (filename.endsWith(FileType.ZIP.extension())) {
            FileUtils.zip(src, dest, options);
        } else if (filename.endsWith(FileType.TAR_BZ2.extension()) || filename.endsWith(FileType.TBZ2.extension())) {
            FileUtils.bz2(src, dest, options);
        } else if (filename.endsWith(FileType.TAR_GZ.extension()) || filename.endsWith(FileType.TGZ.extension())) {
            FileUtils.tgz(src, dest, options);
        } else if (filename.endsWith(FileType.TAR_XZ.extension()) || filename.endsWith(FileType.TXZ.extension())) {
            FileUtils.xz(src, dest, options);
        } else if (filename.endsWith(FileType.TAR_ZST.extension())) {
            FileUtils.zst(src, dest, options);
        } else if (filename.endsWith(FileType.TAR.extension())) {
            FileUtils.tar(src, dest, options);
        }
    }

    public static void unpackArchive(Path src, Path dest) throws IOException {
        FileUtils.unpackArchive(src, dest, true);
    }

    public static void unpackArchive(Path src, Path dest, boolean removeRootEntry) throws IOException {
        FileUtils.unpackArchive(src, dest, removeRootEntry, true);
    }

    public static void unpackArchive(Path src, Path dest, boolean removeRootEntry, boolean cleanDirectory) throws IOException {
        String filename = src.getFileName().toString();
        for (String extension : TAR_COMPRESSED_EXTENSIONS) {
            if (!filename.endsWith(extension)) continue;
            FileUtils.unpackArchiveCompressed(src, dest, removeRootEntry);
            return;
        }
        if (cleanDirectory) {
            FileUtils.deleteFiles(dest, true);
        }
        File destinationDir = dest.toFile();
        String rootEntryName = FileUtils.resolveRootEntryName(src);
        if (filename.endsWith(FileType.ZIP.extension())) {
            try (ZipFile zipFile = ((ZipFile.Builder)ZipFile.builder().setFile(src.toFile())).get();){
                FileUtils.unpackArchive(removeRootEntry ? rootEntryName + "/" : "", destinationDir, zipFile);
            }
            return;
        }
        try (InputStream fi = Files.newInputStream(src, new OpenOption[0]);
             BufferedInputStream bi = new BufferedInputStream(fi);
             ArchiveInputStream in = new ArchiveStreamFactory().createArchiveInputStream((InputStream)bi);){
            FileUtils.unpackArchive(removeRootEntry ? rootEntryName + "/" : "", destinationDir, in);
        }
        catch (ArchiveException e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    public static void unpackArchiveCompressed(Path src, Path dest) throws IOException {
        FileUtils.unpackArchiveCompressed(src, dest, true);
    }

    public static void unpackArchiveCompressed(Path src, Path dest, boolean removeRootEntry) throws IOException {
        FileUtils.unpackArchiveCompressed(src, dest, removeRootEntry, true);
    }

    public static void unpackArchiveCompressed(Path src, Path dest, boolean removeRootEntry, boolean cleanDirectory) throws IOException {
        if (cleanDirectory) {
            FileUtils.deleteFiles(dest, true);
        }
        File destinationDir = dest.toFile();
        String filename = src.getFileName().toString();
        String artifactFileName = StringUtils.getFilename(filename, FileType.getSupportedExtensions());
        String rootEntryName = FileUtils.resolveRootEntryName(src);
        String artifactExtension = filename.substring(artifactFileName.length());
        String artifactFileFormat = artifactExtension.substring(1);
        FileType fileType = FileType.of(artifactFileFormat);
        try (InputStream fi = Files.newInputStream(src, new OpenOption[0]);
             BufferedInputStream bi = new BufferedInputStream(fi);
             InputStream gzi = FileUtils.resolveCompressorInputStream(fileType, bi);
             TarArchiveInputStream in = new TarArchiveInputStream(gzi);){
            FileUtils.unpackArchive(removeRootEntry ? rootEntryName + "/" : "", destinationDir, in);
        }
    }

    private static InputStream resolveCompressorInputStream(FileType fileType, InputStream in) throws IOException {
        switch (fileType) {
            case TGZ: 
            case TAR_GZ: {
                return new GzipCompressorInputStream(in);
            }
            case TBZ2: 
            case TAR_BZ2: {
                return new BZip2CompressorInputStream(in);
            }
            case TXZ: 
            case TAR_XZ: {
                return new XZCompressorInputStream(in);
            }
            case TAR_ZST: {
                return new ZstdCompressorInputStream(in);
            }
        }
        return null;
    }

    private static void unpackArchive(String basename, File destinationDir, ArchiveInputStream<?> in) throws IOException {
        ArchiveEntry entry = null;
        while (null != (entry = in.getNextEntry())) {
            if (!in.canReadEntryData(entry)) continue;
            String entryName = entry.getName();
            if (StringUtils.isNotBlank(basename) && entryName.startsWith(basename) && entryName.length() > basename.length() + 1) {
                entryName = entryName.substring(basename.length());
            }
            File file = new File(destinationDir, entryName);
            String destDirPath = destinationDir.getCanonicalPath();
            String destFilePath = file.getCanonicalPath();
            if (!destFilePath.startsWith(destDirPath + File.separator)) {
                throw new IOException(RB.$((String)"ERROR_files_unpack_outside_target", (Object[])new Object[]{entry.getName()}));
            }
            if (entry.isDirectory()) {
                if (file.isDirectory() || file.mkdirs()) continue;
                throw new IOException(RB.$((String)"ERROR_files_unpack_fail_dir", (Object[])new Object[]{file}));
            }
            File parent = file.getParentFile();
            if (!parent.isDirectory() && !parent.mkdirs()) {
                throw new IOException(RB.$((String)"ERROR_files_unpack_fail_dir", (Object[])new Object[]{parent}));
            }
            if (FileUtils.isSymbolicLink(entry)) {
                Files.createSymbolicLink(file.toPath(), Paths.get(FileUtils.getLinkName(in, entry), new String[0]), new FileAttribute[0]);
                continue;
            }
            OutputStream o = Files.newOutputStream(file.toPath(), new OpenOption[0]);
            try {
                IOUtils.copy(in, (OutputStream)o);
                Files.setLastModifiedTime(file.toPath(), FileTime.from(entry.getLastModifiedDate().toInstant()));
                FileUtils.chmod(file, FileUtils.getEntryMode(entry, file));
            }
            finally {
                if (o == null) continue;
                o.close();
            }
        }
    }

    private static void unpackArchive(String basename, File destinationDir, ZipFile zipFile) throws IOException {
        Enumeration entries = zipFile.getEntries();
        while (entries.hasMoreElements()) {
            ZipArchiveEntry entry = (ZipArchiveEntry)entries.nextElement();
            if (!zipFile.canReadEntryData(entry)) continue;
            String entryName = entry.getName();
            if (StringUtils.isNotBlank(basename) && entryName.startsWith(basename) && entryName.length() > basename.length() + 1) {
                entryName = entryName.substring(basename.length());
            }
            File file = new File(destinationDir, entryName);
            String destDirPath = destinationDir.getCanonicalPath();
            String destFilePath = file.getCanonicalPath();
            if (!destFilePath.startsWith(destDirPath + File.separator)) {
                throw new IOException(RB.$((String)"ERROR_files_unpack_outside_target", (Object[])new Object[]{entry.getName()}));
            }
            if (entry.isDirectory()) {
                if (file.isDirectory() || file.mkdirs()) continue;
                throw new IOException(RB.$((String)"ERROR_files_unpack_fail_dir", (Object[])new Object[]{file}));
            }
            File parent = file.getParentFile();
            if (!parent.isDirectory() && !parent.mkdirs()) {
                throw new IOException(RB.$((String)"ERROR_files_unpack_fail_dir", (Object[])new Object[]{parent}));
            }
            if (entry.isUnixSymlink()) {
                Files.createSymbolicLink(file.toPath(), Paths.get(zipFile.getUnixSymlink(entry), new String[0]), new FileAttribute[0]);
                continue;
            }
            OutputStream o = Files.newOutputStream(file.toPath(), new OpenOption[0]);
            try {
                IOUtils.copy((InputStream)zipFile.getInputStream(entry), (OutputStream)o);
                Files.setLastModifiedTime(file.toPath(), FileTime.from(entry.getLastModifiedDate().toInstant()));
                FileUtils.chmod(file, FileUtils.getEntryMode((ArchiveEntry)entry, file));
            }
            finally {
                if (o == null) continue;
                o.close();
            }
        }
    }

    private static boolean isSymbolicLink(ArchiveEntry entry) {
        if (entry instanceof ZipArchiveEntry) {
            return ((ZipArchiveEntry)entry).isUnixSymlink();
        }
        if (entry instanceof TarArchiveEntry) {
            return ((TarArchiveEntry)entry).isSymbolicLink();
        }
        return false;
    }

    private static String getLinkName(ArchiveInputStream<?> in, ArchiveEntry entry) throws IOException {
        if (entry instanceof ZipArchiveEntry) {
            try (ByteArrayOutputStream o = new ByteArrayOutputStream();){
                IOUtils.copy(in, (OutputStream)o);
                String string = IoUtils.toString(o);
                return string;
            }
        }
        if (entry instanceof TarArchiveEntry) {
            return ((TarArchiveEntry)entry).getLinkName();
        }
        return "";
    }

    private static int getEntryMode(ArchiveEntry entry, File file) {
        if (entry instanceof TarArchiveEntry) {
            return FileUtils.getEntryMode(entry, ((TarArchiveEntry)entry).getMode(), file);
        }
        return FileUtils.getEntryMode(entry, ((ZipArchiveEntry)entry).getUnixMode(), file);
    }

    private static int getEntryMode(ArchiveEntry entry, int mode, File file) {
        int unixMode = mode & 0x1FF;
        if (unixMode == 0) {
            unixMode = entry.isDirectory() ? 493 : ("bin".equalsIgnoreCase(file.getParentFile().getName()) ? 511 : 420);
        }
        return unixMode;
    }

    public static void chmod(File file, int mode) throws IOException {
        FileUtils.chmod(file.toPath(), mode);
    }

    public static void chmod(Path path, int mode) throws IOException {
        if (FileUtils.supportsPosix(path)) {
            PosixFileAttributeView fileAttributeView = Files.getFileAttributeView(path, PosixFileAttributeView.class, new LinkOption[0]);
            fileAttributeView.setPermissions(FileUtils.convertToPermissionsSet(mode));
        } else {
            path.toFile().setExecutable(true);
        }
    }

    private static boolean supportsPosix(Path path) {
        return path.getFileSystem().supportedFileAttributeViews().contains("posix");
    }

    private static Set<PosixFilePermission> convertToPermissionsSet(int mode) {
        EnumSet<PosixFilePermission> result = EnumSet.noneOf(PosixFilePermission.class);
        if ((mode & 0x100) == 256) {
            result.add(PosixFilePermission.OWNER_READ);
        }
        if ((mode & 0x80) == 128) {
            result.add(PosixFilePermission.OWNER_WRITE);
        }
        if ((mode & 0x40) == 64) {
            result.add(PosixFilePermission.OWNER_EXECUTE);
        }
        if ((mode & 0x20) == 32) {
            result.add(PosixFilePermission.GROUP_READ);
        }
        if ((mode & 0x10) == 16) {
            result.add(PosixFilePermission.GROUP_WRITE);
        }
        if ((mode & 8) == 8) {
            result.add(PosixFilePermission.GROUP_EXECUTE);
        }
        if ((mode & 4) == 4) {
            result.add(PosixFilePermission.OTHERS_READ);
        }
        if ((mode & 2) == 2) {
            result.add(PosixFilePermission.OTHERS_WRITE);
        }
        if ((mode & 1) == 1) {
            result.add(PosixFilePermission.OTHERS_EXECUTE);
        }
        return result;
    }

    /*
     * Exception decompiling
     */
    public static List<String> inspectArchive(Path src) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public static String resolveRootEntryName(Path src) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public static String resolveRootEntryNameCompressed(Path src) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static String resolveRootEntryName(ArchiveInputStream<?> in) throws IOException {
        ArchiveEntry entry = null;
        while (null != (entry = in.getNextEntry())) {
            if (!in.canReadEntryData(entry)) continue;
            String entryName = entry.getName();
            return entryName.split("/")[0];
        }
        return "";
    }

    public static CategorizedArchive categorizeUnixArchive(String windowsExtension, Path archive) throws IOException {
        List<String> entries = FileUtils.inspectArchive(archive);
        LinkedHashSet<String> directories = new LinkedHashSet<String>();
        ArrayList<String> binaries = new ArrayList<String>();
        ArrayList<String> files = new ArrayList<String>();
        String rootEntryName = FileUtils.resolveRootEntryName(archive);
        entries.stream().filter(e -> !e.endsWith(windowsExtension)).filter(e -> !e.endsWith("/")).map(e -> e.substring(rootEntryName.length() + 1)).sorted().forEach(entry -> {
            if (FileUtils.isBinaryEntry(entry)) {
                binaries.add((String)entry);
            } else {
                String[] parts = entry.split("/");
                if (parts.length > 1) {
                    directories.add(parts[0]);
                }
                files.add((String)entry);
            }
        });
        return new CategorizedArchive(directories, binaries, files);
    }

    private static boolean isBinaryEntry(String entry) {
        String[] parts = entry.split("/");
        if (parts.length > 1) {
            return "bin".equalsIgnoreCase(parts[parts.length - 2]);
        }
        return false;
    }

    /*
     * Exception decompiling
     */
    public static List<String> inspectArchiveCompressed(Path src) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static List<String> inspectArchive(ArchiveInputStream<?> in) throws IOException {
        ArrayList<String> entries = new ArrayList<String>();
        ArchiveEntry entry = null;
        while (null != (entry = in.getNextEntry())) {
            if (!in.canReadEntryData(entry)) continue;
            entries.add(entry.getName());
        }
        return entries;
    }

    public static void deleteFiles(Path path) throws IOException {
        FileUtils.deleteFiles(path, false);
    }

    public static void deleteFiles(Path path, boolean keepRoot) throws IOException {
        if (Files.exists(path, new LinkOption[0])) {
            try (Stream<Path> stream = Files.walk(path, new FileVisitOption[0]);){
                stream.sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
            }
            if (!keepRoot) {
                Files.deleteIfExists(path);
            }
        }
    }

    public static void createDirectoriesWithFullAccess(Path path) throws IOException {
        FileUtils.createDirectories(path, "rwxrwxrwx");
    }

    public static void createDirectories(Path path, String accessRights) throws IOException {
        if (FileUtils.supportsPosix(path)) {
            Set<PosixFilePermission> perms = PosixFilePermissions.fromString(accessRights);
            FileAttribute<Set<PosixFilePermission>> attr = PosixFilePermissions.asFileAttribute(perms);
            Files.createDirectories(path, attr);
        } else {
            Files.createDirectories(path, new FileAttribute[0]);
        }
    }

    public static void grantFullAccess(Path path) throws IOException {
        FileUtils.grantAccess(path, "rwxrwxrwx");
    }

    public static void grantExecutableAccess(Path path) throws IOException {
        FileUtils.grantAccess(path, "r-xr-xr-x");
    }

    public static void grantAccess(Path path, String accessRights) throws IOException {
        if (FileUtils.supportsPosix(path)) {
            Set<PosixFilePermission> perms = PosixFilePermissions.fromString(accessRights);
            Files.setPosixFilePermissions(path, perms);
        } else if (accessRights.contains("r")) {
            path.toFile().setReadable(true);
        } else if (accessRights.contains("w")) {
            path.toFile().setWritable(true);
        } else if (accessRights.contains("x")) {
            path.toFile().setExecutable(true);
        }
    }

    public static void copyPermissions(Path src, Path dest) throws IOException {
        if (FileUtils.supportsPosix(src)) {
            Set<PosixFilePermission> perms = Files.getPosixFilePermissions(src, new LinkOption[0]);
            Files.setPosixFilePermissions(dest, perms);
        } else {
            File s = src.toFile();
            File d = dest.toFile();
            d.setReadable(s.canRead());
            d.setWritable(s.canWrite());
            d.setExecutable(s.canExecute());
        }
    }

    public static void copyFiles(JReleaserLogger logger, Path source, Path target) throws IOException {
        FileUtils.copyFiles(logger, source, target, (Path path) -> true);
    }

    public static void copyFiles(JReleaserLogger logger, Path source, Path target, Predicate<Path> filter) throws IOException {
        if (!Files.exists(source, new LinkOption[0])) {
            return;
        }
        Predicate<Path> actualFilter = null != filter ? filter : path -> true;
        IOException[] thrown = new IOException[1];
        try (Stream<Path> stream = Files.list(source);){
            Files.createDirectories(target, new FileAttribute[0]);
            stream.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(actualFilter).forEach(child -> {
                block2: {
                    try {
                        Files.copy(child, target.resolve(child.getFileName()), StandardCopyOption.REPLACE_EXISTING);
                    }
                    catch (IOException e) {
                        logger.error(RB.$((String)"ERROR_files_copy", (Object[])new Object[0]), new Object[]{child, e});
                        if (null != thrown[0]) break block2;
                        thrown[0] = e;
                    }
                }
            });
        }
        if (null != thrown[0]) {
            throw thrown[0];
        }
    }

    public static void copyFiles(JReleaserLogger logger, Path source, Path target, Set<Path> paths) throws IOException {
        logger.debug(RB.$((String)"files.copy", (Object[])new Object[]{source, target}));
        for (Path path : paths) {
            Path srcPath = source.resolve(path);
            Path targetPath = target.resolve(path);
            Files.createDirectories(targetPath.getParent(), new FileAttribute[0]);
            Files.copy(srcPath, targetPath, StandardCopyOption.REPLACE_EXISTING);
        }
    }

    public static boolean copyFilesRecursive(JReleaserLogger logger, Path source, Path target) throws IOException {
        return FileUtils.copyFilesRecursive(logger, source, target, null);
    }

    public static boolean copyFilesRecursive(JReleaserLogger logger, Path source, Path target, Predicate<Path> filter) throws IOException {
        FileTreeCopy copier = new FileTreeCopy(logger, source, target, filter);
        Files.walkFileTree(source, copier);
        return copier.isSuccessful();
    }

    public static class ArchiveOptions {
        private final Set<Path> includedPaths = new LinkedHashSet<Path>();
        private String rootEntryName;
        private ZonedDateTime timestamp;
        private TarMode longFileMode = TarMode.ERROR;
        private TarMode bigNumberMode = TarMode.ERROR;
        private boolean createIntermediateDirs;

        public boolean isCreateIntermediateDirs() {
            return this.createIntermediateDirs;
        }

        public String getRootEntryName() {
            return this.rootEntryName;
        }

        public ZonedDateTime getTimestamp() {
            return this.timestamp;
        }

        public TarMode getLongFileMode() {
            return this.longFileMode;
        }

        public TarMode getBigNumberMode() {
            return this.bigNumberMode;
        }

        public Set<Path> getIncludedPaths() {
            return this.includedPaths;
        }

        public ArchiveOptions withCreateIntermediateDirs(boolean createIntermediateDirs) {
            this.createIntermediateDirs = createIntermediateDirs;
            return this;
        }

        public ArchiveOptions withIncludedPath(Path path) {
            this.includedPaths.add(path);
            return this;
        }

        public ArchiveOptions withRootEntryName(String rootEntryName) {
            this.rootEntryName = rootEntryName;
            return this;
        }

        public ArchiveOptions withTimestamp(ZonedDateTime timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public ArchiveOptions withLongFileMode(TarMode longFileMode) {
            if (null != longFileMode) {
                this.longFileMode = longFileMode;
            }
            return this;
        }

        public ArchiveOptions withBigNumberMode(TarMode bigNumberMode) {
            if (null != bigNumberMode) {
                this.bigNumberMode = bigNumberMode;
            }
            return this;
        }

        public static enum TarMode {
            GNU,
            POSIX,
            ERROR,
            TRUNCATE;


            public String formatted() {
                return this.name().toLowerCase(Locale.ENGLISH);
            }

            public static TarMode of(String str) {
                if (StringUtils.isBlank(str)) {
                    return null;
                }
                return TarMode.valueOf(str.toUpperCase(Locale.ENGLISH).trim());
            }

            public int toLongFileMode() {
                switch (this.ordinal()) {
                    case 0: {
                        return 2;
                    }
                    case 1: {
                        return 3;
                    }
                    case 3: {
                        return 1;
                    }
                }
                return 0;
            }

            public int toBigNumberMode() {
                switch (this.ordinal()) {
                    case 0: {
                        return 1;
                    }
                    case 1: {
                        return 2;
                    }
                }
                return 0;
            }
        }
    }

    public static class CategorizedArchive {
        private final Set<String> directories = new LinkedHashSet<String>();
        private final List<String> binaries = new ArrayList<String>();
        private final List<String> files = new ArrayList<String>();

        public CategorizedArchive(Set<String> directories, List<String> binaries, List<String> files) {
            this.directories.addAll(directories);
            this.binaries.addAll(binaries);
            this.files.addAll(files);
        }

        public Set<String> getDirectories() {
            return Collections.unmodifiableSet(this.directories);
        }

        public List<String> getBinaries() {
            return Collections.unmodifiableList(this.binaries);
        }

        public List<String> getFiles() {
            return Collections.unmodifiableList(this.files);
        }
    }

    private static class FileTreeCopy
    implements FileVisitor<Path> {
        private final JReleaserLogger logger;
        private final Path source;
        private final Path target;
        private final Predicate<Path> filter;
        private boolean success = true;

        FileTreeCopy(JReleaserLogger logger, Path source, Path target, Predicate<Path> filter) {
            this.logger = logger;
            this.source = source;
            this.target = target;
            this.filter = filter;
            logger.debug(RB.$((String)"files.copy", (Object[])new Object[]{source, target}));
        }

        private boolean filtered(Path path) {
            if (null != this.filter) {
                return this.filter.test(path);
            }
            return false;
        }

        public boolean isSuccessful() {
            return this.success;
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
            if (this.filtered(dir)) {
                return FileVisitResult.SKIP_SUBTREE;
            }
            Path newdir = this.target.resolve(this.source.relativize(dir));
            try {
                Files.copy(dir, newdir, new CopyOption[0]);
                FileUtils.grantFullAccess(newdir);
            }
            catch (FileAlreadyExistsException fileAlreadyExistsException) {
            }
            catch (IOException e) {
                this.logger.error(RB.$((String)"ERROR_files_create", (Object[])new Object[0]), new Object[]{newdir, e});
                this.success = false;
                return FileVisitResult.SKIP_SUBTREE;
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
            if (this.filtered(file)) {
                return FileVisitResult.CONTINUE;
            }
            try {
                Path newfile = this.target.resolve(this.source.relativize(file));
                Files.copy(file, newfile, StandardCopyOption.REPLACE_EXISTING);
                FileUtils.copyPermissions(file, newfile);
            }
            catch (IOException e) {
                this.logger.error(RB.$((String)"ERROR_files_copy", (Object[])new Object[0]), new Object[]{this.source, e});
                this.success = false;
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
            if (this.filtered(dir)) {
                return FileVisitResult.CONTINUE;
            }
            if (null == exc) {
                Path newdir = this.target.resolve(this.source.relativize(dir));
                try {
                    FileTime time = Files.getLastModifiedTime(dir, new LinkOption[0]);
                    Files.setLastModifiedTime(newdir, time);
                }
                catch (IOException e) {
                    this.logger.warn(RB.$((String)"ERROR_files_copy_attributes", (Object[])new Object[0]), new Object[]{newdir, e});
                }
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFileFailed(Path file, IOException e) {
            if (e instanceof FileSystemLoopException) {
                this.logger.error(RB.$((String)"ERROR_files_cycle", (Object[])new Object[0]), new Object[]{file});
            } else {
                this.logger.error(RB.$((String)"ERROR_files_copy", (Object[])new Object[0]), new Object[]{file, e});
            }
            this.success = false;
            return FileVisitResult.CONTINUE;
        }
    }
}

