#include "localization/gettext.h"
#include <filesystem>
#include <cstdlib>
#include "helpers/stringhelpers.h"
#include "system/environment.h"

using namespace Nickvision::Helpers;
using namespace Nickvision::System;

namespace Nickvision::Localization
{
    static std::string s_domainName;

    bool Gettext::init(const std::string& domainName)
    {
        static bool initialized{ false };
        if(!initialized)
        {
            bool res{ true };
            setlocale(LC_ALL, "");
            s_domainName = StringHelpers::lower(StringHelpers::replace(domainName, " ", ""));
#ifdef _WIN32
            res = res && (wbindtextdomain(s_domainName.c_str(), Environment::getExecutableDirectory().c_str()) != nullptr);
#else
            res = res && (bindtextdomain(s_domainName.c_str(), Environment::getExecutableDirectory().c_str()) != nullptr);
#endif
            res = res && (bind_textdomain_codeset(s_domainName.c_str(), "UTF-8") != nullptr);
            res = res && (textdomain(s_domainName.c_str()) != nullptr);
            initialized = true;
            return res;
        }
        return true;
    }

    const std::string& Gettext::getDomainName()
    {
        return s_domainName;
    }

    const char* Gettext::pgettext(const char* context, const char* msg)
    {
        const char* translation{ dcgettext(s_domainName.c_str(), context, LC_MESSAGES) };
        if (translation == context)
        {
            return msg;
        }
        return translation;
    }

    const char* Gettext::pngettext(const char* context, const char* msg, const char* msgPlural, unsigned long n)
    {
        const char* translation{ dcngettext(s_domainName.c_str(), context, msgPlural, n, LC_MESSAGES) };
        if (translation == context || translation == msgPlural)
        {
            return n == 1 ? msg : msgPlural;
        }
        return translation;
    }
}