/*
 * Copyright 2014 von Karman Institute for Fluid Dynamics (VKI)
 *
 * This file is part of MUlticomponent Thermodynamic And Transport
 * properties for IONized gases in C++ (Mutation++) software package.
 *
 * Mutation++ is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * Mutation++ is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with Mutation++.  If not, see
 * <http://www.gnu.org/licenses/>.
 */

/**
 * @page examples Examples
 *
 * A few working examples are provided with Mutation++ in order to help
 * demonstrate certain features or provide a starting point for a new code.
 * All of the examples listed below can be found in the `examples` directory
 * of the Mutation++ package.  A `Makefile` is provided for both the C++ and
 * FORTRAN examples in order to demonstrate how one might compile a stand-alone
 * code which uses the Mutation++ library.  Be sure that the correct paths and
 * file extensions are setup in the Makefile for your particular system
 * __before__ trying to compile the examples with `make`.
 *
 * __C++ Examples__
 * - @subpage example_equilibrium_air
 * - @subpage example_O2_dissociation
 *
 * __FORTRAN Examples__
 *
 */
