<!--startmeta
custom_edit_url: "https://github.com/netdata/netdata/edit/master/src/go/plugin/go.d/collector/powerdns/README.md"
meta_yaml: "https://github.com/netdata/netdata/edit/master/src/go/plugin/go.d/collector/powerdns/metadata.yaml"
sidebar_label: "PowerDNS Authoritative Server"
learn_status: "Published"
learn_rel_path: "Collecting Metrics/DNS and DHCP Servers"
most_popular: False
message: "DO NOT EDIT THIS FILE DIRECTLY, IT IS GENERATED BY THE COLLECTOR'S metadata.yaml FILE"
endmeta-->

# PowerDNS Authoritative Server


<img src="https://netdata.cloud/img/powerdns.svg" width="150"/>


Plugin: go.d.plugin
Module: powerdns

<img src="https://img.shields.io/badge/maintained%20by-Netdata-%2300ab44" />

## Overview

This collector monitors PowerDNS Authoritative Server instances.
It collects metrics from [the internal webserver](https://doc.powerdns.com/authoritative/http-api/index.html#webserver).

Used endpoints:

- [`/api/v1/servers/localhost/statistics`](https://doc.powerdns.com/authoritative/http-api/statistics.html)




This collector is supported on all platforms.

This collector supports collecting metrics from multiple instances of this integration, including remote instances.


### Default Behavior

#### Auto-Detection

This integration doesn't support auto-detection.

#### Limits

The default configuration for this integration does not impose any limits on data collection.

#### Performance Impact

The default configuration for this integration is not expected to impose a significant performance impact on the system.

## Metrics

Metrics grouped by *scope*.

The scope defines the instance that the metric belongs to. An instance is uniquely identified by a set of labels.



### Per PowerDNS Authoritative Server instance

These metrics refer to the entire monitored application.

This scope has no labels.

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| powerdns.questions_in | udp, tcp | questions/s |
| powerdns.questions_out | udp, tcp | questions/s |
| powerdns.cache_usage | query-cache-hit, query-cache-miss, packetcache-hit, packetcache-miss | events/s |
| powerdns.cache_size | query-cache, packet-cache, key-cache, meta-cache | entries |
| powerdns.latency | latency | microseconds |



## Alerts

There are no alerts configured by default for this integration.


## Setup


You can configure the **powerdns** collector in two ways:

| Method                | Best for                                                                                 | How to                                                                                                                                 |
|-----------------------|------------------------------------------------------------------------------------------|----------------------------------------------------------------------------------------------------------------------------------------|
| [**UI**](#via-ui)     | Fast setup without editing files                                                         | Go to **Nodes → Configure this node → Collectors → Jobs**, search for **powerdns**, then click **+** to add a job. |
| [**File**](#via-file) | If you prefer configuring via file, or need to automate deployments (e.g., with Ansible) | Edit `go.d/powerdns.conf` and add a job.                                                                        |

:::important

UI configuration requires paid Netdata Cloud plan.

:::


### Prerequisites

#### Enable webserver

Follow [webserver](https://doc.powerdns.com/authoritative/http-api/index.html#webserver) documentation.


#### Enable HTTP API

Follow [HTTP API](https://doc.powerdns.com/authoritative/http-api/index.html#enabling-the-api) documentation.



### Configuration

#### Options

The following options can be defined globally: update_every, autodetection_retry.


<details open><summary>Config options</summary>



| Group | Option | Description | Default | Required |
|:------|:-----|:------------|:--------|:---------:|
| **Collection** | update_every | Data collection interval (seconds). | 1 | no |
|  | autodetection_retry | Autodetection retry interval (seconds). Set 0 to disable. | 0 | no |
| **Target** | url | Target endpoint URL. | http://127.0.0.1:8081 | yes |
|  | timeout | HTTP request timeout (seconds). | 1 | no |
| **HTTP Auth** | username | Username for Basic HTTP authentication. |  | no |
|  | password | Password for Basic HTTP authentication. |  | no |
|  | bearer_token_file | Path to a file containing a bearer token (used for `Authorization: Bearer`). |  | no |
| **TLS** | tls_skip_verify | Skip TLS certificate and hostname verification (insecure). | no | no |
|  | tls_ca | Path to CA bundle used to validate the server certificate. |  | no |
|  | tls_cert | Path to client TLS certificate (for mTLS). |  | no |
|  | tls_key | Path to client TLS private key (for mTLS). |  | no |
| **Proxy** | proxy_url | HTTP proxy URL. |  | no |
|  | proxy_username | Username for proxy Basic HTTP authentication. |  | no |
|  | proxy_password | Password for proxy Basic HTTP authentication. |  | no |
| **Request** | method | HTTP method to use. | GET | no |
|  | body | Request body (e.g., for POST/PUT). |  | no |
|  | headers | Additional HTTP headers (one per line as key: value). |  | no |
|  | not_follow_redirects | Do not follow HTTP redirects. | no | no |
|  | force_http2 | Force HTTP/2 (including h2c over TCP). | no | no |
| **Virtual Node** | vnode | Associates this data collection job with a [Virtual Node](https://learn.netdata.cloud/docs/netdata-agent/configuration/organize-systems-metrics-and-alerts#virtual-nodes). |  | no |


</details>


#### via UI

Configure the **powerdns** collector from the Netdata web interface:

1. Go to **Nodes**.
2. Select the node **where you want the powerdns data-collection job to run** and click the :gear: (**Configure this node**). That node will run the data collection.
3. The **Collectors → Jobs** view opens by default.
4. In the Search box, type _powerdns_ (or scroll the list) to locate the **powerdns** collector.
5. Click the **+** next to the **powerdns** collector to add a new job.
6. Fill in the job fields, then click **Test** to verify the configuration and **Submit** to save.
    - **Test** runs the job with the provided settings and shows whether data can be collected.
    - If it fails, an error message appears with details (for example, connection refused, timeout, or command execution errors), so you can adjust and retest.


#### via File

The configuration file name for this integration is `go.d/powerdns.conf`.

The file format is YAML. Generally, the structure is:

```yaml
update_every: 1
autodetection_retry: 0
jobs:
  - name: some_name1
  - name: some_name2
```
You can edit the configuration file using the [`edit-config`](https://github.com/netdata/netdata/blob/master/docs/netdata-agent/configuration/README.md#edit-a-configuration-file-using-edit-config) script from the
Netdata [config directory](https://github.com/netdata/netdata/blob/master/docs/netdata-agent/configuration/README.md#the-netdata-config-directory).

```bash
cd /etc/netdata 2>/dev/null || cd /opt/netdata/etc/netdata
sudo ./edit-config go.d/powerdns.conf
```

##### Examples

###### Basic

An example configuration.

<details open><summary>Config</summary>

```yaml
jobs:
  - name: local
    url: http://127.0.0.1:8081

```
</details>

###### HTTP authentication

Basic HTTP authentication.

<details open><summary>Config</summary>

```yaml
jobs:
  - name: local
    url: http://127.0.0.1:8081
    username: admin
    password: password

```
</details>

###### Multi-instance

> **Note**: When you define multiple jobs, their names must be unique.

Local and remote instances.


<details open><summary>Config</summary>

```yaml
jobs:
  - name: local
    url: http://127.0.0.1:8081

  - name: remote
    url: http://203.0.113.0:8081

```
</details>



## Troubleshooting

### Debug Mode

**Important**: Debug mode is not supported for data collection jobs created via the UI using the Dyncfg feature.

To troubleshoot issues with the `powerdns` collector, run the `go.d.plugin` with the debug option enabled. The output
should give you clues as to why the collector isn't working.

- Navigate to the `plugins.d` directory, usually at `/usr/libexec/netdata/plugins.d/`. If that's not the case on
  your system, open `netdata.conf` and look for the `plugins` setting under `[directories]`.

  ```bash
  cd /usr/libexec/netdata/plugins.d/
  ```

- Switch to the `netdata` user.

  ```bash
  sudo -u netdata -s
  ```

- Run the `go.d.plugin` to debug the collector:

  ```bash
  ./go.d.plugin -d -m powerdns
  ```

  To debug a specific job:

  ```bash
  ./go.d.plugin -d -m powerdns -j jobName
  ```

### Getting Logs

If you're encountering problems with the `powerdns` collector, follow these steps to retrieve logs and identify potential issues:

- **Run the command** specific to your system (systemd, non-systemd, or Docker container).
- **Examine the output** for any warnings or error messages that might indicate issues.  These messages should provide clues about the root cause of the problem.

#### System with systemd

Use the following command to view logs generated since the last Netdata service restart:

```bash
journalctl _SYSTEMD_INVOCATION_ID="$(systemctl show --value --property=InvocationID netdata)" --namespace=netdata --grep powerdns
```

#### System without systemd

Locate the collector log file, typically at `/var/log/netdata/collector.log`, and use `grep` to filter for collector's name:

```bash
grep powerdns /var/log/netdata/collector.log
```

**Note**: This method shows logs from all restarts. Focus on the **latest entries** for troubleshooting current issues.

#### Docker Container

If your Netdata runs in a Docker container named "netdata" (replace if different), use this command:

```bash
docker logs netdata 2>&1 | grep powerdns
```


