/**
 * Codex Command Adapter
 *
 * Formats commands for Codex following its frontmatter specification.
 */
import path from 'path';
/**
 * Codex adapter for command generation.
 * File path: .codex/prompts/opsx-<id>.md
 * Frontmatter: description, argument-hint
 */
export const codexAdapter = {
    toolId: 'codex',
    getFilePath(commandId) {
        return path.join('.codex', 'prompts', `opsx-${commandId}.md`);
    },
    formatFile(content) {
        return `---
description: ${content.description}
argument-hint: command arguments
---

${content.body}
`;
    },
};
//# sourceMappingURL=codex.js.map