import { ICellModel } from '@jupyterlab/cells';
import { IObservableList } from '@jupyterlab/observables';
import { ISharedNotebook } from '@jupyter/ydoc';
import { ISignal } from '@lumino/signaling';
/**
 * A cell list object that supports undo/redo.
 */
export declare class CellList {
    protected model: ISharedNotebook;
    /**
     * Construct the cell list.
     */
    constructor(model: ISharedNotebook);
    /**
     * A signal emitted when the cell list has changed.
     */
    get changed(): ISignal<this, IObservableList.IChangedArgs<ICellModel>>;
    /**
     * Test whether the cell list has been disposed.
     */
    get isDisposed(): boolean;
    /**
     * Get the length of the cell list.
     *
     * @returns The number of cells in the cell list.
     */
    get length(): number;
    /**
     * Create an iterator over the cells in the cell list.
     *
     * @returns A new iterator starting at the front of the cell list.
     */
    [Symbol.iterator](): IterableIterator<ICellModel>;
    /**
     * Dispose of the resources held by the cell list.
     */
    dispose(): void;
    /**
     * Get the cell at the specified index.
     *
     * @param index - The positive integer index of interest.
     *
     * @returns The cell at the specified index.
     */
    get(index: number): ICellModel;
    private _insertCells;
    private _onSharedModelChanged;
    private _cellMap;
    private _changed;
    private _isDisposed;
}
