import { Widget } from '@lumino/widgets';
import { Message } from '@lumino/messaging';
import { Notebook } from './widget';
/**
 * A footer widget added after the last cell of the notebook.
 */
export declare class NotebookFooter extends Widget {
    protected notebook: Notebook;
    /**
     * Construct a footer widget.
     */
    constructor(notebook: Notebook);
    /**
     * Handle incoming events.
     */
    handleEvent(event: Event): void;
    /**
     * On single click (mouse event), insert a cell below (at the end of the notebook as default behavior).
     */
    protected onClick(): void;
    /**
     * On arrow up key pressed (keydown keyboard event).
     * @deprecated To be removed in v5, this is a no-op
     */
    protected onArrowUp(): void;
    protected onAfterAttach(msg: Message): void;
    /**
     * Handle `before-detach` messages for the widget.
     */
    protected onBeforeDetach(msg: Message): void;
}
