'use strict';

const cssTree = require('css-tree');

const STRING = cssTree.tokenTypes.String;
const TILDE = 0x007E; // U+007E TILDE (~)

const name = 'LessEscaping';
const structure = {
    value: 'String'
};
function parse() {
    const start = this.tokenStart;

    this.eatDelim(TILDE);

    return {
        type: 'LessEscaping',
        loc: this.getLocation(start, this.tokenEnd),
        value: this.consume(STRING)
    };
}

exports.name = name;
exports.parse = parse;
exports.structure = structure;
