import React from 'react';
import { LabIcon } from '../icon';
/**
 * InputGroup component properties
 */
export interface IInputGroupProps extends React.InputHTMLAttributes<HTMLInputElement> {
    /**
     * Pass a ref to the input element
     */
    inputRef?: React.RefObject<HTMLInputElement>;
    /**
     * Right icon adornment
     */
    rightIcon?: string | LabIcon;
}
/**
 * InputGroup component
 *
 * @param props Component properties
 * @returns Component
 */
export declare function InputGroup(props: IInputGroupProps): JSX.Element;
