// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
import { Token } from '@lumino/coreutils';
/**
 * The command palette token.
 */
export const ICommandPalette = new Token('@jupyterlab/apputils:ICommandPalette', `A service for the application command palette
  in the left panel. Use this to add commands to the palette.`);
/**
 * The kernel status indicator model.
 */
export const IKernelStatusModel = new Token('@jupyterlab/apputils:IKernelStatusModel', 'A service to register kernel session provider to the kernel status indicator.');
/**
 * The session context dialogs token.
 */
export const ISessionContextDialogs = new Token('@jupyterlab/apputils:ISessionContextDialogs', 'A service for handling the session dialogs.');
/**
 * The theme manager token.
 */
export const IThemeManager = new Token('@jupyterlab/apputils:IThemeManager', 'A service for the theme manager for the application. This is used primarily in theme extensions to register new themes.');
/**
 * The sanitizer token.
 */
export const ISanitizer = new Token('@jupyterlab/apputils:ISanitizer', 'A service for sanitizing HTML strings.');
/**
 * The main menu token.
 */
export const ISplashScreen = new Token('@jupyterlab/apputils:ISplashScreen', `A service for the splash screen for the application.
  Use this if you want to show the splash screen for your own purposes.`);
/**
 * The default window resolver token.
 */
export const IWindowResolver = new Token('@jupyterlab/apputils:IWindowResolver', `A service for a window resolver for the
  application. JupyterLab workspaces are given a name, which are determined using
  the window resolver. Require this if you want to use the name of the current workspace.`);
/**
 * The toolbar registry token.
 */
export const IToolbarWidgetRegistry = new Token('@jupyterlab/apputils:IToolbarWidgetRegistry', `A registry for toolbar widgets. Require this
  if you want to build the toolbar dynamically from a data definition (stored in settings for example).`);
//# sourceMappingURL=tokens.js.map