import { ISignal } from '@lumino/signaling';
/**
 * Convert a signal into a promise for the first emitted value.
 *
 * @param signal - The signal we are listening to.
 * @param timeout - Timeout to wait for signal in ms (not timeout if not defined or 0)
 *
 * @returns a Promise that resolves with a `(sender, args)` pair.
 */
export declare function signalToPromise<T, U>(signal: ISignal<T, U>, timeout?: number): Promise<[T, U]>;
