/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs3.auxiliary.remote;

import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.RMISocketFactory;
import java.util.Properties;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import org.apache.commons.jcs3.auxiliary.remote.RemoteLocation;
import org.apache.commons.jcs3.log.Log;
import org.apache.commons.jcs3.log.LogManager;

public class RemoteUtils {
    private static final Log log = LogManager.getLog(RemoteUtils.class);

    private RemoteUtils() {
    }

    public static Registry createRegistry(int port) {
        Registry registry = null;
        if (port < 1024) {
            log.warn("createRegistry> Port chosen was less than 1024, will use default [{0}] instead.", 1099);
            port = 1099;
        }
        try {
            registry = LocateRegistry.createRegistry(port);
            log.info("createRegistry> Created the registry on port {0}", port);
        }
        catch (RemoteException e) {
            log.warn("createRegistry> Problem creating registry. It may already be started.", e);
        }
        catch (Throwable t) {
            log.error("createRegistry> Problem creating registry.", t);
        }
        if (registry == null) {
            try {
                registry = LocateRegistry.getRegistry(port);
            }
            catch (RemoteException e) {
                log.error("createRegistry> Problem getting a registry reference.", e);
            }
        }
        return registry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties loadProps(String propFile) throws IOException {
        InputStream is = RemoteUtils.class.getResourceAsStream(propFile);
        if (null == is && !propFile.startsWith("/")) {
            is = RemoteUtils.class.getResourceAsStream("/" + propFile);
        }
        if (null == is) {
            Path propPath = Paths.get(propFile, new String[0]);
            is = Files.exists(propPath, new LinkOption[0]) ? Files.newInputStream(propPath, new OpenOption[0]) : new URL(propFile).openStream();
        }
        Properties props = new Properties();
        try {
            props.load(is);
            Supplier[] supplierArray = new Supplier[1];
            supplierArray[0] = props::size;
            log.debug("props.size={0}", supplierArray);
            if (log.isTraceEnabled()) {
                StringBuilder buf = new StringBuilder();
                props.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> buf.append('\n').append(key).append(" = ").append(value)));
                log.trace(buf.toString());
            }
        }
        catch (IOException ex) {
            log.error("Error loading remote properties, for file name [{0}]", propFile, ex);
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
        return props;
    }

    public static void configureGlobalCustomSocketFactory(final int timeoutMillis) {
        block3: {
            try {
                if (timeoutMillis > 0) {
                    log.info("RmiSocketFactoryTimeoutMillis [{0}].  Configuring a custom socket factory.", timeoutMillis);
                    RMISocketFactory.setSocketFactory(new RMISocketFactory(){

                        @Override
                        public Socket createSocket(String host, int port) throws IOException {
                            Socket socket = new Socket();
                            socket.setSoTimeout(timeoutMillis);
                            socket.setSoLinger(false, 0);
                            socket.connect(new InetSocketAddress(host, port), timeoutMillis);
                            return socket;
                        }

                        @Override
                        public ServerSocket createServerSocket(int port) throws IOException {
                            return new ServerSocket(port);
                        }
                    });
                }
            }
            catch (IOException e) {
                RMISocketFactory factoryInUse = RMISocketFactory.getSocketFactory();
                if (factoryInUse == null || factoryInUse.getClass().getName().startsWith("org.apache.commons.jcs3")) break block3;
                Supplier[] supplierArray = new Supplier[2];
                supplierArray[0] = e::getMessage;
                supplierArray[1] = RMISocketFactory::getSocketFactory;
                log.info("Could not create new custom socket factory. {0} Factory in use = {1}", supplierArray);
            }
        }
    }

    public static String getNamingURL(RemoteLocation location, String serviceName) {
        return RemoteUtils.getNamingURL(location.getHost(), location.getPort(), serviceName);
    }

    public static String getNamingURL(String registryHost, int registryPort, String serviceName) {
        if (registryHost.contains(":")) {
            return "//[" + registryHost.replaceFirst("%", "%25") + "]:" + registryPort + "/" + serviceName;
        }
        return "//" + registryHost + ":" + registryPort + "/" + serviceName;
    }
}

