// Copyright 2015-2025 The Khronos Group Inc.
//
// SPDX-License-Identifier: Apache-2.0 OR MIT
//

// This header is generated from the Khronos Vulkan XML API Registry.

#ifndef VULKAN_RAII_HPP
#define VULKAN_RAII_HPP

#include <vulkan/vulkan.hpp>
#if !defined( VULKAN_HPP_CXX_MODULE )
#  include <memory>   // std::unique_ptr
#  include <utility>  // std::forward
#endif

#if !defined( VULKAN_HPP_DISABLE_ENHANCED_MODE )
namespace VULKAN_HPP_NAMESPACE
{
  namespace VULKAN_HPP_RAII_NAMESPACE
  {
    namespace detail
    {
      using PFN_dummy = void ( * )();

      class ContextDispatcher : public ::VULKAN_HPP_NAMESPACE::detail::DispatchLoaderBase
      {
      public:
        ContextDispatcher( PFN_vkGetInstanceProcAddr getProcAddr )
          : vkGetInstanceProcAddr( getProcAddr )
          //=== VK_VERSION_1_0 ===
          , vkCreateInstance( PFN_vkCreateInstance( getProcAddr( NULL, "vkCreateInstance" ) ) )
          , vkEnumerateInstanceExtensionProperties(
              PFN_vkEnumerateInstanceExtensionProperties( getProcAddr( NULL, "vkEnumerateInstanceExtensionProperties" ) ) )
          , vkEnumerateInstanceLayerProperties( PFN_vkEnumerateInstanceLayerProperties( getProcAddr( NULL, "vkEnumerateInstanceLayerProperties" ) ) )
          //=== VK_VERSION_1_1 ===
          , vkEnumerateInstanceVersion( PFN_vkEnumerateInstanceVersion( getProcAddr( NULL, "vkEnumerateInstanceVersion" ) ) )
        {
        }

      public:
        PFN_vkGetInstanceProcAddr vkGetInstanceProcAddr = 0;

        //=== VK_VERSION_1_0 ===
        PFN_vkCreateInstance                       vkCreateInstance                       = 0;
        PFN_vkEnumerateInstanceExtensionProperties vkEnumerateInstanceExtensionProperties = 0;
        PFN_vkEnumerateInstanceLayerProperties     vkEnumerateInstanceLayerProperties     = 0;

        //=== VK_VERSION_1_1 ===
        PFN_vkEnumerateInstanceVersion vkEnumerateInstanceVersion = 0;
      };

      class InstanceDispatcher : public ::VULKAN_HPP_NAMESPACE::detail::DispatchLoaderBase
      {
      public:
        InstanceDispatcher( PFN_vkGetInstanceProcAddr getProcAddr, VkInstance instance ) : vkGetInstanceProcAddr( getProcAddr )
        {
          //=== VK_VERSION_1_0 ===
          vkDestroyInstance           = PFN_vkDestroyInstance( vkGetInstanceProcAddr( instance, "vkDestroyInstance" ) );
          vkEnumeratePhysicalDevices  = PFN_vkEnumeratePhysicalDevices( vkGetInstanceProcAddr( instance, "vkEnumeratePhysicalDevices" ) );
          vkGetPhysicalDeviceFeatures = PFN_vkGetPhysicalDeviceFeatures( vkGetInstanceProcAddr( instance, "vkGetPhysicalDeviceFeatures" ) );
          vkGetPhysicalDeviceFormatProperties =
            PFN_vkGetPhysicalDeviceFormatProperties( vkGetInstanceProcAddr( instance, "vkGetPhysicalDeviceFormatProperties" ) );
          vkGetPhysicalDeviceImageFormatProperties =
            PFN_vkGetPhysicalDeviceImageFormatProperties( vkGetInstanceProcAddr( instance, "vkGetPhysicalDeviceImageFormatProperties" ) );
          vkGetPhysicalDeviceProperties = PFN_vkGetPhysicalDeviceProperties( vkGetInstanceProcAddr( instance, "vkGetPhysicalDeviceProperties" ) );
          vkGetPhysicalDeviceQueueFamilyProperties =
            PFN_vkGetPhysicalDeviceQueueFamilyProperties( vkGetInstanceProcAddr( instance, "vkGetPhysicalDeviceQueueFamilyProperties" ) );
          vkGetPhysicalDeviceMemoryProperties =
            PFN_vkGetPhysicalDeviceMemoryProperties( vkGetInstanceProcAddr( instance, "vkGetPhysicalDeviceMemoryProperties" ) );
          vkCreateDevice = PFN_vkCreateDevice( vkGetInstanceProcAddr( instance, "vkCreateDevice" ) );
          vkEnumerateDeviceExtensionProperties =
            PFN_vkEnumerateDeviceExtensionProperties( vkGetInstanceProcAddr( instance, "vkEnumerateDeviceExtensionProperties" ) );
          vkEnumerateDeviceLayerProperties = PFN_vkEnumerateDeviceLayerProperties( vkGetInstanceProcAddr( instance, "vkEnumerateDeviceLayerProperties" ) );
          vkGetPhysicalDeviceSparseImageFormatProperties =
            PFN_vkGetPhysicalDeviceSparseImageFormatProperties( vkGetInstanceProcAddr( instance, "vkGetPhysicalDeviceSparseImageFormatProperties" ) );

          //=== VK_VERSION_1_1 ===
          vkEnumeratePhysicalDeviceGroups = PFN_vkEnumeratePhysicalDeviceGroups( vkGetInstanceProcAddr( instance, "vkEnumeratePhysicalDeviceGroups" ) );
          vkGetPhysicalDeviceFeatures2    = PFN_vkGetPhysicalDeviceFeatures2( vkGetInstanceProcAddr( instance, "vkGetPhysicalDeviceFeatures2" ) );
          vkGetPhysicalDeviceProperties2  = PFN_vkGetPhysicalDeviceProperties2( vkGetInstanceProcAddr( instance, "vkGetPhysicalDeviceProperties2" ) );
          vkGetPhysicalDeviceFormatProperties2 =
            PFN_vkGetPhysicalDeviceFormatProperties2( vkGetInstanceProcAddr( instance, "vkGetPhysicalDeviceFormatProperties2" ) );
          vkGetPhysicalDeviceImageFormatProperties2 =
            PFN_vkGetPhysicalDeviceImageFormatProperties2( vkGetInstanceProcAddr( instance, "vkGetPhysicalDeviceImageFormatProperties2" ) );
          vkGetPhysicalDeviceQueueFamilyProperties2 =
            PFN_vkGetPhysicalDeviceQueueFamilyProperties2( vkGetInstanceProcAddr( instance, "vkGetPhysicalDeviceQueueFamilyProperties2" ) );
          vkGetPhysicalDeviceMemoryProperties2 =
            PFN_vkGetPhysicalDeviceMemoryProperties2( vkGetInstanceProcAddr( instance, "vkGetPhysicalDeviceMemoryProperties2" ) );
          vkGetPhysicalDeviceSparseImageFormatProperties2 =
            PFN_vkGetPhysicalDeviceSparseImageFormatProperties2( vkGetInstanceProcAddr( instance, "vkGetPhysicalDeviceSparseImageFormatProperties2" ) );
          vkGetPhysicalDeviceExternalBufferProperties =
            PFN_vkGetPhysicalDeviceExternalBufferProperties( vkGetInstanceProcAddr( instance, "vkGetPhysicalDeviceExternalBufferProperties" ) );
          vkGetPhysicalDeviceExternalFenceProperties =
            PFN_vkGetPhysicalDeviceExternalFenceProperties( vkGetInstanceProcAddr( instance, "vkGetPhysicalDeviceExternalFenceProperties" ) );
          vkGetPhysicalDeviceExternalSemaphoreProperties =
            PFN_vkGetPhysicalDeviceExternalSemaphoreProperties( vkGetInstanceProcAddr( instance, "vkGetPhysicalDeviceExternalSemaphoreProperties" ) );

          //=== VK_VERSION_1_3 ===
          vkGetPhysicalDeviceToolProperties = PFN_vkGetPhysicalDeviceToolProperties( vkGetInstanceProcAddr( instance, "vkGetPhysicalDeviceToolProperties" ) );

          //=== VK_KHR_surface ===
          vkDestroySurfaceKHR = PFN_vkDestroySurfaceKHR( vkGetInstanceProcAddr( instance, "vkDestroySurfaceKHR" ) );
          vkGetPhysicalDeviceSurfaceSupportKHR =
            PFN_vkGetPhysicalDeviceSurfaceSupportKHR( vkGetInstanceProcAddr( instance, "vkGetPhysicalDeviceSurfaceSupportKHR" ) );
          vkGetPhysicalDeviceSurfaceCapabilitiesKHR =
            PFN_vkGetPhysicalDeviceSurfaceCapabilitiesKHR( vkGetInstanceProcAddr( instance, "vkGetPhysicalDeviceSurfaceCapabilitiesKHR" ) );
          vkGetPhysicalDeviceSurfaceFormatsKHR =
            PFN_vkGetPhysicalDeviceSurfaceFormatsKHR( vkGetInstanceProcAddr( instance, "vkGetPhysicalDeviceSurfaceFormatsKHR" ) );
          vkGetPhysicalDeviceSurfacePresentModesKHR =
            PFN_vkGetPhysicalDeviceSurfacePresentModesKHR( vkGetInstanceProcAddr( instance, "vkGetPhysicalDeviceSurfacePresentModesKHR" ) );

          //=== VK_KHR_swapchain ===
          vkGetPhysicalDevicePresentRectanglesKHR =
            PFN_vkGetPhysicalDevicePresentRectanglesKHR( vkGetInstanceProcAddr( instance, "vkGetPhysicalDevicePresentRectanglesKHR" ) );

          //=== VK_KHR_display ===
          vkGetPhysicalDeviceDisplayPropertiesKHR =
            PFN_vkGetPhysicalDeviceDisplayPropertiesKHR( vkGetInstanceProcAddr( instance, "vkGetPhysicalDeviceDisplayPropertiesKHR" ) );
          vkGetPhysicalDeviceDisplayPlanePropertiesKHR =
            PFN_vkGetPhysicalDeviceDisplayPlanePropertiesKHR( vkGetInstanceProcAddr( instance, "vkGetPhysicalDeviceDisplayPlanePropertiesKHR" ) );
          vkGetDisplayPlaneSupportedDisplaysKHR =
            PFN_vkGetDisplayPlaneSupportedDisplaysKHR( vkGetInstanceProcAddr( instance, "vkGetDisplayPlaneSupportedDisplaysKHR" ) );
          vkGetDisplayModePropertiesKHR    = PFN_vkGetDisplayModePropertiesKHR( vkGetInstanceProcAddr( instance, "vkGetDisplayModePropertiesKHR" ) );
          vkCreateDisplayModeKHR           = PFN_vkCreateDisplayModeKHR( vkGetInstanceProcAddr( instance, "vkCreateDisplayModeKHR" ) );
          vkGetDisplayPlaneCapabilitiesKHR = PFN_vkGetDisplayPlaneCapabilitiesKHR( vkGetInstanceProcAddr( instance, "vkGetDisplayPlaneCapabilitiesKHR" ) );
          vkCreateDisplayPlaneSurfaceKHR   = PFN_vkCreateDisplayPlaneSurfaceKHR( vkGetInstanceProcAddr( instance, "vkCreateDisplayPlaneSurfaceKHR" ) );

#  if defined( VK_USE_PLATFORM_XLIB_KHR )
          //=== VK_KHR_xlib_surface ===
          vkCreateXlibSurfaceKHR = PFN_vkCreateXlibSurfaceKHR( vkGetInstanceProcAddr( instance, "vkCreateXlibSurfaceKHR" ) );
          vkGetPhysicalDeviceXlibPresentationSupportKHR =
            PFN_vkGetPhysicalDeviceXlibPresentationSupportKHR( vkGetInstanceProcAddr( instance, "vkGetPhysicalDeviceXlibPresentationSupportKHR" ) );
#  endif /*VK_USE_PLATFORM_XLIB_KHR*/

#  if defined( VK_USE_PLATFORM_XCB_KHR )
          //=== VK_KHR_xcb_surface ===
          vkCreateXcbSurfaceKHR = PFN_vkCreateXcbSurfaceKHR( vkGetInstanceProcAddr( instance, "vkCreateXcbSurfaceKHR" ) );
          vkGetPhysicalDeviceXcbPresentationSupportKHR =
            PFN_vkGetPhysicalDeviceXcbPresentationSupportKHR( vkGetInstanceProcAddr( instance, "vkGetPhysicalDeviceXcbPresentationSupportKHR" ) );
#  endif /*VK_USE_PLATFORM_XCB_KHR*/

#  if defined( VK_USE_PLATFORM_WAYLAND_KHR )
          //=== VK_KHR_wayland_surface ===
          vkCreateWaylandSurfaceKHR = PFN_vkCreateWaylandSurfaceKHR( vkGetInstanceProcAddr( instance, "vkCreateWaylandSurfaceKHR" ) );
          vkGetPhysicalDeviceWaylandPresentationSupportKHR =
            PFN_vkGetPhysicalDeviceWaylandPresentationSupportKHR( vkGetInstanceProcAddr( instance, "vkGetPhysicalDeviceWaylandPresentationSupportKHR" ) );
#  endif /*VK_USE_PLATFORM_WAYLAND_KHR*/

#  if defined( VK_USE_PLATFORM_ANDROID_KHR )
          //=== VK_KHR_android_surface ===
          vkCreateAndroidSurfaceKHR = PFN_vkCreateAndroidSurfaceKHR( vkGetInstanceProcAddr( instance, "vkCreateAndroidSurfaceKHR" ) );
#  endif /*VK_USE_PLATFORM_ANDROID_KHR*/

#  if defined( VK_USE_PLATFORM_WIN32_KHR )
          //=== VK_KHR_win32_surface ===
          vkCreateWin32SurfaceKHR = PFN_vkCreateWin32SurfaceKHR( vkGetInstanceProcAddr( instance, "vkCreateWin32SurfaceKHR" ) );
          vkGetPhysicalDeviceWin32PresentationSupportKHR =
            PFN_vkGetPhysicalDeviceWin32PresentationSupportKHR( vkGetInstanceProcAddr( instance, "vkGetPhysicalDeviceWin32PresentationSupportKHR" ) );
#  endif /*VK_USE_PLATFORM_WIN32_KHR*/

          //=== VK_EXT_debug_report ===
          vkCreateDebugReportCallbackEXT  = PFN_vkCreateDebugReportCallbackEXT( vkGetInstanceProcAddr( instance, "vkCreateDebugReportCallbackEXT" ) );
          vkDestroyDebugReportCallbackEXT = PFN_vkDestroyDebugReportCallbackEXT( vkGetInstanceProcAddr( instance, "vkDestroyDebugReportCallbackEXT" ) );
          vkDebugReportMessageEXT         = PFN_vkDebugReportMessageEXT( vkGetInstanceProcAddr( instance, "vkDebugReportMessageEXT" ) );

          //=== VK_KHR_video_queue ===
          vkGetPhysicalDeviceVideoCapabilitiesKHR =
            PFN_vkGetPhysicalDeviceVideoCapabilitiesKHR( vkGetInstanceProcAddr( instance, "vkGetPhysicalDeviceVideoCapabilitiesKHR" ) );
          vkGetPhysicalDeviceVideoFormatPropertiesKHR =
            PFN_vkGetPhysicalDeviceVideoFormatPropertiesKHR( vkGetInstanceProcAddr( instance, "vkGetPhysicalDeviceVideoFormatPropertiesKHR" ) );

#  if defined( VK_USE_PLATFORM_GGP )
          //=== VK_GGP_stream_descriptor_surface ===
          vkCreateStreamDescriptorSurfaceGGP =
            PFN_vkCreateStreamDescriptorSurfaceGGP( vkGetInstanceProcAddr( instance, "vkCreateStreamDescriptorSurfaceGGP" ) );
#  endif /*VK_USE_PLATFORM_GGP*/

          //=== VK_NV_external_memory_capabilities ===
          vkGetPhysicalDeviceExternalImageFormatPropertiesNV =
            PFN_vkGetPhysicalDeviceExternalImageFormatPropertiesNV( vkGetInstanceProcAddr( instance, "vkGetPhysicalDeviceExternalImageFormatPropertiesNV" ) );

          //=== VK_KHR_get_physical_device_properties2 ===
          vkGetPhysicalDeviceFeatures2KHR = PFN_vkGetPhysicalDeviceFeatures2KHR( vkGetInstanceProcAddr( instance, "vkGetPhysicalDeviceFeatures2KHR" ) );
          if ( !vkGetPhysicalDeviceFeatures2 )
            vkGetPhysicalDeviceFeatures2 = vkGetPhysicalDeviceFeatures2KHR;
          vkGetPhysicalDeviceProperties2KHR = PFN_vkGetPhysicalDeviceProperties2KHR( vkGetInstanceProcAddr( instance, "vkGetPhysicalDeviceProperties2KHR" ) );
          if ( !vkGetPhysicalDeviceProperties2 )
            vkGetPhysicalDeviceProperties2 = vkGetPhysicalDeviceProperties2KHR;
          vkGetPhysicalDeviceFormatProperties2KHR =
            PFN_vkGetPhysicalDeviceFormatProperties2KHR( vkGetInstanceProcAddr( instance, "vkGetPhysicalDeviceFormatProperties2KHR" ) );
          if ( !vkGetPhysicalDeviceFormatProperties2 )
            vkGetPhysicalDeviceFormatProperties2 = vkGetPhysicalDeviceFormatProperties2KHR;
          vkGetPhysicalDeviceImageFormatProperties2KHR =
            PFN_vkGetPhysicalDeviceImageFormatProperties2KHR( vkGetInstanceProcAddr( instance, "vkGetPhysicalDeviceImageFormatProperties2KHR" ) );
          if ( !vkGetPhysicalDeviceImageFormatProperties2 )
            vkGetPhysicalDeviceImageFormatProperties2 = vkGetPhysicalDeviceImageFormatProperties2KHR;
          vkGetPhysicalDeviceQueueFamilyProperties2KHR =
            PFN_vkGetPhysicalDeviceQueueFamilyProperties2KHR( vkGetInstanceProcAddr( instance, "vkGetPhysicalDeviceQueueFamilyProperties2KHR" ) );
          if ( !vkGetPhysicalDeviceQueueFamilyProperties2 )
            vkGetPhysicalDeviceQueueFamilyProperties2 = vkGetPhysicalDeviceQueueFamilyProperties2KHR;
          vkGetPhysicalDeviceMemoryProperties2KHR =
            PFN_vkGetPhysicalDeviceMemoryProperties2KHR( vkGetInstanceProcAddr( instance, "vkGetPhysicalDeviceMemoryProperties2KHR" ) );
          if ( !vkGetPhysicalDeviceMemoryProperties2 )
            vkGetPhysicalDeviceMemoryProperties2 = vkGetPhysicalDeviceMemoryProperties2KHR;
          vkGetPhysicalDeviceSparseImageFormatProperties2KHR =
            PFN_vkGetPhysicalDeviceSparseImageFormatProperties2KHR( vkGetInstanceProcAddr( instance, "vkGetPhysicalDeviceSparseImageFormatProperties2KHR" ) );
          if ( !vkGetPhysicalDeviceSparseImageFormatProperties2 )
            vkGetPhysicalDeviceSparseImageFormatProperties2 = vkGetPhysicalDeviceSparseImageFormatProperties2KHR;

#  if defined( VK_USE_PLATFORM_VI_NN )
          //=== VK_NN_vi_surface ===
          vkCreateViSurfaceNN = PFN_vkCreateViSurfaceNN( vkGetInstanceProcAddr( instance, "vkCreateViSurfaceNN" ) );
#  endif /*VK_USE_PLATFORM_VI_NN*/

          //=== VK_KHR_device_group_creation ===
          vkEnumeratePhysicalDeviceGroupsKHR =
            PFN_vkEnumeratePhysicalDeviceGroupsKHR( vkGetInstanceProcAddr( instance, "vkEnumeratePhysicalDeviceGroupsKHR" ) );
          if ( !vkEnumeratePhysicalDeviceGroups )
            vkEnumeratePhysicalDeviceGroups = vkEnumeratePhysicalDeviceGroupsKHR;

          //=== VK_KHR_external_memory_capabilities ===
          vkGetPhysicalDeviceExternalBufferPropertiesKHR =
            PFN_vkGetPhysicalDeviceExternalBufferPropertiesKHR( vkGetInstanceProcAddr( instance, "vkGetPhysicalDeviceExternalBufferPropertiesKHR" ) );
          if ( !vkGetPhysicalDeviceExternalBufferProperties )
            vkGetPhysicalDeviceExternalBufferProperties = vkGetPhysicalDeviceExternalBufferPropertiesKHR;

          //=== VK_KHR_external_semaphore_capabilities ===
          vkGetPhysicalDeviceExternalSemaphorePropertiesKHR =
            PFN_vkGetPhysicalDeviceExternalSemaphorePropertiesKHR( vkGetInstanceProcAddr( instance, "vkGetPhysicalDeviceExternalSemaphorePropertiesKHR" ) );
          if ( !vkGetPhysicalDeviceExternalSemaphoreProperties )
            vkGetPhysicalDeviceExternalSemaphoreProperties = vkGetPhysicalDeviceExternalSemaphorePropertiesKHR;

          //=== VK_EXT_direct_mode_display ===
          vkReleaseDisplayEXT = PFN_vkReleaseDisplayEXT( vkGetInstanceProcAddr( instance, "vkReleaseDisplayEXT" ) );

#  if defined( VK_USE_PLATFORM_XLIB_XRANDR_EXT )
          //=== VK_EXT_acquire_xlib_display ===
          vkAcquireXlibDisplayEXT    = PFN_vkAcquireXlibDisplayEXT( vkGetInstanceProcAddr( instance, "vkAcquireXlibDisplayEXT" ) );
          vkGetRandROutputDisplayEXT = PFN_vkGetRandROutputDisplayEXT( vkGetInstanceProcAddr( instance, "vkGetRandROutputDisplayEXT" ) );
#  endif /*VK_USE_PLATFORM_XLIB_XRANDR_EXT*/

          //=== VK_EXT_display_surface_counter ===
          vkGetPhysicalDeviceSurfaceCapabilities2EXT =
            PFN_vkGetPhysicalDeviceSurfaceCapabilities2EXT( vkGetInstanceProcAddr( instance, "vkGetPhysicalDeviceSurfaceCapabilities2EXT" ) );

          //=== VK_KHR_external_fence_capabilities ===
          vkGetPhysicalDeviceExternalFencePropertiesKHR =
            PFN_vkGetPhysicalDeviceExternalFencePropertiesKHR( vkGetInstanceProcAddr( instance, "vkGetPhysicalDeviceExternalFencePropertiesKHR" ) );
          if ( !vkGetPhysicalDeviceExternalFenceProperties )
            vkGetPhysicalDeviceExternalFenceProperties = vkGetPhysicalDeviceExternalFencePropertiesKHR;

          //=== VK_KHR_performance_query ===
          vkEnumeratePhysicalDeviceQueueFamilyPerformanceQueryCountersKHR = PFN_vkEnumeratePhysicalDeviceQueueFamilyPerformanceQueryCountersKHR(
            vkGetInstanceProcAddr( instance, "vkEnumeratePhysicalDeviceQueueFamilyPerformanceQueryCountersKHR" ) );
          vkGetPhysicalDeviceQueueFamilyPerformanceQueryPassesKHR = PFN_vkGetPhysicalDeviceQueueFamilyPerformanceQueryPassesKHR(
            vkGetInstanceProcAddr( instance, "vkGetPhysicalDeviceQueueFamilyPerformanceQueryPassesKHR" ) );

          //=== VK_KHR_get_surface_capabilities2 ===
          vkGetPhysicalDeviceSurfaceCapabilities2KHR =
            PFN_vkGetPhysicalDeviceSurfaceCapabilities2KHR( vkGetInstanceProcAddr( instance, "vkGetPhysicalDeviceSurfaceCapabilities2KHR" ) );
          vkGetPhysicalDeviceSurfaceFormats2KHR =
            PFN_vkGetPhysicalDeviceSurfaceFormats2KHR( vkGetInstanceProcAddr( instance, "vkGetPhysicalDeviceSurfaceFormats2KHR" ) );

          //=== VK_KHR_get_display_properties2 ===
          vkGetPhysicalDeviceDisplayProperties2KHR =
            PFN_vkGetPhysicalDeviceDisplayProperties2KHR( vkGetInstanceProcAddr( instance, "vkGetPhysicalDeviceDisplayProperties2KHR" ) );
          vkGetPhysicalDeviceDisplayPlaneProperties2KHR =
            PFN_vkGetPhysicalDeviceDisplayPlaneProperties2KHR( vkGetInstanceProcAddr( instance, "vkGetPhysicalDeviceDisplayPlaneProperties2KHR" ) );
          vkGetDisplayModeProperties2KHR    = PFN_vkGetDisplayModeProperties2KHR( vkGetInstanceProcAddr( instance, "vkGetDisplayModeProperties2KHR" ) );
          vkGetDisplayPlaneCapabilities2KHR = PFN_vkGetDisplayPlaneCapabilities2KHR( vkGetInstanceProcAddr( instance, "vkGetDisplayPlaneCapabilities2KHR" ) );

#  if defined( VK_USE_PLATFORM_IOS_MVK )
          //=== VK_MVK_ios_surface ===
          vkCreateIOSSurfaceMVK = PFN_vkCreateIOSSurfaceMVK( vkGetInstanceProcAddr( instance, "vkCreateIOSSurfaceMVK" ) );
#  endif /*VK_USE_PLATFORM_IOS_MVK*/

#  if defined( VK_USE_PLATFORM_MACOS_MVK )
          //=== VK_MVK_macos_surface ===
          vkCreateMacOSSurfaceMVK = PFN_vkCreateMacOSSurfaceMVK( vkGetInstanceProcAddr( instance, "vkCreateMacOSSurfaceMVK" ) );
#  endif /*VK_USE_PLATFORM_MACOS_MVK*/

          //=== VK_EXT_debug_utils ===
          vkCreateDebugUtilsMessengerEXT  = PFN_vkCreateDebugUtilsMessengerEXT( vkGetInstanceProcAddr( instance, "vkCreateDebugUtilsMessengerEXT" ) );
          vkDestroyDebugUtilsMessengerEXT = PFN_vkDestroyDebugUtilsMessengerEXT( vkGetInstanceProcAddr( instance, "vkDestroyDebugUtilsMessengerEXT" ) );
          vkSubmitDebugUtilsMessageEXT    = PFN_vkSubmitDebugUtilsMessageEXT( vkGetInstanceProcAddr( instance, "vkSubmitDebugUtilsMessageEXT" ) );

          //=== VK_EXT_sample_locations ===
          vkGetPhysicalDeviceMultisamplePropertiesEXT =
            PFN_vkGetPhysicalDeviceMultisamplePropertiesEXT( vkGetInstanceProcAddr( instance, "vkGetPhysicalDeviceMultisamplePropertiesEXT" ) );

          //=== VK_EXT_calibrated_timestamps ===
          vkGetPhysicalDeviceCalibrateableTimeDomainsEXT =
            PFN_vkGetPhysicalDeviceCalibrateableTimeDomainsEXT( vkGetInstanceProcAddr( instance, "vkGetPhysicalDeviceCalibrateableTimeDomainsEXT" ) );
          if ( !vkGetPhysicalDeviceCalibrateableTimeDomainsKHR )
            vkGetPhysicalDeviceCalibrateableTimeDomainsKHR = vkGetPhysicalDeviceCalibrateableTimeDomainsEXT;

#  if defined( VK_USE_PLATFORM_FUCHSIA )
          //=== VK_FUCHSIA_imagepipe_surface ===
          vkCreateImagePipeSurfaceFUCHSIA = PFN_vkCreateImagePipeSurfaceFUCHSIA( vkGetInstanceProcAddr( instance, "vkCreateImagePipeSurfaceFUCHSIA" ) );
#  endif /*VK_USE_PLATFORM_FUCHSIA*/

#  if defined( VK_USE_PLATFORM_METAL_EXT )
          //=== VK_EXT_metal_surface ===
          vkCreateMetalSurfaceEXT = PFN_vkCreateMetalSurfaceEXT( vkGetInstanceProcAddr( instance, "vkCreateMetalSurfaceEXT" ) );
#  endif /*VK_USE_PLATFORM_METAL_EXT*/

          //=== VK_KHR_fragment_shading_rate ===
          vkGetPhysicalDeviceFragmentShadingRatesKHR =
            PFN_vkGetPhysicalDeviceFragmentShadingRatesKHR( vkGetInstanceProcAddr( instance, "vkGetPhysicalDeviceFragmentShadingRatesKHR" ) );

          //=== VK_EXT_tooling_info ===
          vkGetPhysicalDeviceToolPropertiesEXT =
            PFN_vkGetPhysicalDeviceToolPropertiesEXT( vkGetInstanceProcAddr( instance, "vkGetPhysicalDeviceToolPropertiesEXT" ) );
          if ( !vkGetPhysicalDeviceToolProperties )
            vkGetPhysicalDeviceToolProperties = vkGetPhysicalDeviceToolPropertiesEXT;

          //=== VK_NV_cooperative_matrix ===
          vkGetPhysicalDeviceCooperativeMatrixPropertiesNV =
            PFN_vkGetPhysicalDeviceCooperativeMatrixPropertiesNV( vkGetInstanceProcAddr( instance, "vkGetPhysicalDeviceCooperativeMatrixPropertiesNV" ) );

          //=== VK_NV_coverage_reduction_mode ===
          vkGetPhysicalDeviceSupportedFramebufferMixedSamplesCombinationsNV = PFN_vkGetPhysicalDeviceSupportedFramebufferMixedSamplesCombinationsNV(
            vkGetInstanceProcAddr( instance, "vkGetPhysicalDeviceSupportedFramebufferMixedSamplesCombinationsNV" ) );

#  if defined( VK_USE_PLATFORM_WIN32_KHR )
          //=== VK_EXT_full_screen_exclusive ===
          vkGetPhysicalDeviceSurfacePresentModes2EXT =
            PFN_vkGetPhysicalDeviceSurfacePresentModes2EXT( vkGetInstanceProcAddr( instance, "vkGetPhysicalDeviceSurfacePresentModes2EXT" ) );
#  endif /*VK_USE_PLATFORM_WIN32_KHR*/

          //=== VK_EXT_headless_surface ===
          vkCreateHeadlessSurfaceEXT = PFN_vkCreateHeadlessSurfaceEXT( vkGetInstanceProcAddr( instance, "vkCreateHeadlessSurfaceEXT" ) );

          //=== VK_EXT_acquire_drm_display ===
          vkAcquireDrmDisplayEXT = PFN_vkAcquireDrmDisplayEXT( vkGetInstanceProcAddr( instance, "vkAcquireDrmDisplayEXT" ) );
          vkGetDrmDisplayEXT     = PFN_vkGetDrmDisplayEXT( vkGetInstanceProcAddr( instance, "vkGetDrmDisplayEXT" ) );

          //=== VK_KHR_video_encode_queue ===
          vkGetPhysicalDeviceVideoEncodeQualityLevelPropertiesKHR = PFN_vkGetPhysicalDeviceVideoEncodeQualityLevelPropertiesKHR(
            vkGetInstanceProcAddr( instance, "vkGetPhysicalDeviceVideoEncodeQualityLevelPropertiesKHR" ) );

#  if defined( VK_USE_PLATFORM_WIN32_KHR )
          //=== VK_NV_acquire_winrt_display ===
          vkAcquireWinrtDisplayNV = PFN_vkAcquireWinrtDisplayNV( vkGetInstanceProcAddr( instance, "vkAcquireWinrtDisplayNV" ) );
          vkGetWinrtDisplayNV     = PFN_vkGetWinrtDisplayNV( vkGetInstanceProcAddr( instance, "vkGetWinrtDisplayNV" ) );
#  endif /*VK_USE_PLATFORM_WIN32_KHR*/

#  if defined( VK_USE_PLATFORM_DIRECTFB_EXT )
          //=== VK_EXT_directfb_surface ===
          vkCreateDirectFBSurfaceEXT = PFN_vkCreateDirectFBSurfaceEXT( vkGetInstanceProcAddr( instance, "vkCreateDirectFBSurfaceEXT" ) );
          vkGetPhysicalDeviceDirectFBPresentationSupportEXT =
            PFN_vkGetPhysicalDeviceDirectFBPresentationSupportEXT( vkGetInstanceProcAddr( instance, "vkGetPhysicalDeviceDirectFBPresentationSupportEXT" ) );
#  endif /*VK_USE_PLATFORM_DIRECTFB_EXT*/

#  if defined( VK_USE_PLATFORM_SCREEN_QNX )
          //=== VK_QNX_screen_surface ===
          vkCreateScreenSurfaceQNX = PFN_vkCreateScreenSurfaceQNX( vkGetInstanceProcAddr( instance, "vkCreateScreenSurfaceQNX" ) );
          vkGetPhysicalDeviceScreenPresentationSupportQNX =
            PFN_vkGetPhysicalDeviceScreenPresentationSupportQNX( vkGetInstanceProcAddr( instance, "vkGetPhysicalDeviceScreenPresentationSupportQNX" ) );
#  endif /*VK_USE_PLATFORM_SCREEN_QNX*/

          //=== VK_ARM_tensors ===
          vkGetPhysicalDeviceExternalTensorPropertiesARM =
            PFN_vkGetPhysicalDeviceExternalTensorPropertiesARM( vkGetInstanceProcAddr( instance, "vkGetPhysicalDeviceExternalTensorPropertiesARM" ) );

          //=== VK_NV_optical_flow ===
          vkGetPhysicalDeviceOpticalFlowImageFormatsNV =
            PFN_vkGetPhysicalDeviceOpticalFlowImageFormatsNV( vkGetInstanceProcAddr( instance, "vkGetPhysicalDeviceOpticalFlowImageFormatsNV" ) );

          //=== VK_NV_cooperative_vector ===
          vkGetPhysicalDeviceCooperativeVectorPropertiesNV =
            PFN_vkGetPhysicalDeviceCooperativeVectorPropertiesNV( vkGetInstanceProcAddr( instance, "vkGetPhysicalDeviceCooperativeVectorPropertiesNV" ) );

          //=== VK_KHR_cooperative_matrix ===
          vkGetPhysicalDeviceCooperativeMatrixPropertiesKHR =
            PFN_vkGetPhysicalDeviceCooperativeMatrixPropertiesKHR( vkGetInstanceProcAddr( instance, "vkGetPhysicalDeviceCooperativeMatrixPropertiesKHR" ) );

          //=== VK_ARM_data_graph ===
          vkGetPhysicalDeviceQueueFamilyDataGraphPropertiesARM = PFN_vkGetPhysicalDeviceQueueFamilyDataGraphPropertiesARM(
            vkGetInstanceProcAddr( instance, "vkGetPhysicalDeviceQueueFamilyDataGraphPropertiesARM" ) );
          vkGetPhysicalDeviceQueueFamilyDataGraphProcessingEnginePropertiesARM = PFN_vkGetPhysicalDeviceQueueFamilyDataGraphProcessingEnginePropertiesARM(
            vkGetInstanceProcAddr( instance, "vkGetPhysicalDeviceQueueFamilyDataGraphProcessingEnginePropertiesARM" ) );

          //=== VK_KHR_calibrated_timestamps ===
          vkGetPhysicalDeviceCalibrateableTimeDomainsKHR =
            PFN_vkGetPhysicalDeviceCalibrateableTimeDomainsKHR( vkGetInstanceProcAddr( instance, "vkGetPhysicalDeviceCalibrateableTimeDomainsKHR" ) );

#  if defined( VK_USE_PLATFORM_OHOS )
          //=== VK_OHOS_surface ===
          vkCreateSurfaceOHOS = PFN_vkCreateSurfaceOHOS( vkGetInstanceProcAddr( instance, "vkCreateSurfaceOHOS" ) );
#  endif /*VK_USE_PLATFORM_OHOS*/

          //=== VK_NV_cooperative_matrix2 ===
          vkGetPhysicalDeviceCooperativeMatrixFlexibleDimensionsPropertiesNV = PFN_vkGetPhysicalDeviceCooperativeMatrixFlexibleDimensionsPropertiesNV(
            vkGetInstanceProcAddr( instance, "vkGetPhysicalDeviceCooperativeMatrixFlexibleDimensionsPropertiesNV" ) );

          //=== VK_ARM_performance_counters_by_region ===
          vkEnumeratePhysicalDeviceQueueFamilyPerformanceCountersByRegionARM = PFN_vkEnumeratePhysicalDeviceQueueFamilyPerformanceCountersByRegionARM(
            vkGetInstanceProcAddr( instance, "vkEnumeratePhysicalDeviceQueueFamilyPerformanceCountersByRegionARM" ) );

          vkGetDeviceProcAddr = PFN_vkGetDeviceProcAddr( vkGetInstanceProcAddr( instance, "vkGetDeviceProcAddr" ) );
        }

      public:
        //=== VK_VERSION_1_0 ===
        PFN_vkDestroyInstance                              vkDestroyInstance                              = 0;
        PFN_vkEnumeratePhysicalDevices                     vkEnumeratePhysicalDevices                     = 0;
        PFN_vkGetPhysicalDeviceFeatures                    vkGetPhysicalDeviceFeatures                    = 0;
        PFN_vkGetPhysicalDeviceFormatProperties            vkGetPhysicalDeviceFormatProperties            = 0;
        PFN_vkGetPhysicalDeviceImageFormatProperties       vkGetPhysicalDeviceImageFormatProperties       = 0;
        PFN_vkGetPhysicalDeviceProperties                  vkGetPhysicalDeviceProperties                  = 0;
        PFN_vkGetPhysicalDeviceQueueFamilyProperties       vkGetPhysicalDeviceQueueFamilyProperties       = 0;
        PFN_vkGetPhysicalDeviceMemoryProperties            vkGetPhysicalDeviceMemoryProperties            = 0;
        PFN_vkGetInstanceProcAddr                          vkGetInstanceProcAddr                          = 0;
        PFN_vkCreateDevice                                 vkCreateDevice                                 = 0;
        PFN_vkEnumerateDeviceExtensionProperties           vkEnumerateDeviceExtensionProperties           = 0;
        PFN_vkEnumerateDeviceLayerProperties               vkEnumerateDeviceLayerProperties               = 0;
        PFN_vkGetPhysicalDeviceSparseImageFormatProperties vkGetPhysicalDeviceSparseImageFormatProperties = 0;

        //=== VK_VERSION_1_1 ===
        PFN_vkEnumeratePhysicalDeviceGroups                 vkEnumeratePhysicalDeviceGroups                 = 0;
        PFN_vkGetPhysicalDeviceFeatures2                    vkGetPhysicalDeviceFeatures2                    = 0;
        PFN_vkGetPhysicalDeviceProperties2                  vkGetPhysicalDeviceProperties2                  = 0;
        PFN_vkGetPhysicalDeviceFormatProperties2            vkGetPhysicalDeviceFormatProperties2            = 0;
        PFN_vkGetPhysicalDeviceImageFormatProperties2       vkGetPhysicalDeviceImageFormatProperties2       = 0;
        PFN_vkGetPhysicalDeviceQueueFamilyProperties2       vkGetPhysicalDeviceQueueFamilyProperties2       = 0;
        PFN_vkGetPhysicalDeviceMemoryProperties2            vkGetPhysicalDeviceMemoryProperties2            = 0;
        PFN_vkGetPhysicalDeviceSparseImageFormatProperties2 vkGetPhysicalDeviceSparseImageFormatProperties2 = 0;
        PFN_vkGetPhysicalDeviceExternalBufferProperties     vkGetPhysicalDeviceExternalBufferProperties     = 0;
        PFN_vkGetPhysicalDeviceExternalFenceProperties      vkGetPhysicalDeviceExternalFenceProperties      = 0;
        PFN_vkGetPhysicalDeviceExternalSemaphoreProperties  vkGetPhysicalDeviceExternalSemaphoreProperties  = 0;

        //=== VK_VERSION_1_3 ===
        PFN_vkGetPhysicalDeviceToolProperties vkGetPhysicalDeviceToolProperties = 0;

        //=== VK_KHR_surface ===
        PFN_vkDestroySurfaceKHR                       vkDestroySurfaceKHR                       = 0;
        PFN_vkGetPhysicalDeviceSurfaceSupportKHR      vkGetPhysicalDeviceSurfaceSupportKHR      = 0;
        PFN_vkGetPhysicalDeviceSurfaceCapabilitiesKHR vkGetPhysicalDeviceSurfaceCapabilitiesKHR = 0;
        PFN_vkGetPhysicalDeviceSurfaceFormatsKHR      vkGetPhysicalDeviceSurfaceFormatsKHR      = 0;
        PFN_vkGetPhysicalDeviceSurfacePresentModesKHR vkGetPhysicalDeviceSurfacePresentModesKHR = 0;

        //=== VK_KHR_swapchain ===
        PFN_vkGetPhysicalDevicePresentRectanglesKHR vkGetPhysicalDevicePresentRectanglesKHR = 0;

        //=== VK_KHR_display ===
        PFN_vkGetPhysicalDeviceDisplayPropertiesKHR      vkGetPhysicalDeviceDisplayPropertiesKHR      = 0;
        PFN_vkGetPhysicalDeviceDisplayPlanePropertiesKHR vkGetPhysicalDeviceDisplayPlanePropertiesKHR = 0;
        PFN_vkGetDisplayPlaneSupportedDisplaysKHR        vkGetDisplayPlaneSupportedDisplaysKHR        = 0;
        PFN_vkGetDisplayModePropertiesKHR                vkGetDisplayModePropertiesKHR                = 0;
        PFN_vkCreateDisplayModeKHR                       vkCreateDisplayModeKHR                       = 0;
        PFN_vkGetDisplayPlaneCapabilitiesKHR             vkGetDisplayPlaneCapabilitiesKHR             = 0;
        PFN_vkCreateDisplayPlaneSurfaceKHR               vkCreateDisplayPlaneSurfaceKHR               = 0;

#  if defined( VK_USE_PLATFORM_XLIB_KHR )
        //=== VK_KHR_xlib_surface ===
        PFN_vkCreateXlibSurfaceKHR                        vkCreateXlibSurfaceKHR                        = 0;
        PFN_vkGetPhysicalDeviceXlibPresentationSupportKHR vkGetPhysicalDeviceXlibPresentationSupportKHR = 0;
#  else
        PFN_dummy vkCreateXlibSurfaceKHR_placeholder                        = 0;
        PFN_dummy vkGetPhysicalDeviceXlibPresentationSupportKHR_placeholder = 0;
#  endif /*VK_USE_PLATFORM_XLIB_KHR*/

#  if defined( VK_USE_PLATFORM_XCB_KHR )
        //=== VK_KHR_xcb_surface ===
        PFN_vkCreateXcbSurfaceKHR                        vkCreateXcbSurfaceKHR                        = 0;
        PFN_vkGetPhysicalDeviceXcbPresentationSupportKHR vkGetPhysicalDeviceXcbPresentationSupportKHR = 0;
#  else
        PFN_dummy vkCreateXcbSurfaceKHR_placeholder                        = 0;
        PFN_dummy vkGetPhysicalDeviceXcbPresentationSupportKHR_placeholder = 0;
#  endif /*VK_USE_PLATFORM_XCB_KHR*/

#  if defined( VK_USE_PLATFORM_WAYLAND_KHR )
        //=== VK_KHR_wayland_surface ===
        PFN_vkCreateWaylandSurfaceKHR                        vkCreateWaylandSurfaceKHR                        = 0;
        PFN_vkGetPhysicalDeviceWaylandPresentationSupportKHR vkGetPhysicalDeviceWaylandPresentationSupportKHR = 0;
#  else
        PFN_dummy vkCreateWaylandSurfaceKHR_placeholder                        = 0;
        PFN_dummy vkGetPhysicalDeviceWaylandPresentationSupportKHR_placeholder = 0;
#  endif /*VK_USE_PLATFORM_WAYLAND_KHR*/

#  if defined( VK_USE_PLATFORM_ANDROID_KHR )
        //=== VK_KHR_android_surface ===
        PFN_vkCreateAndroidSurfaceKHR vkCreateAndroidSurfaceKHR = 0;
#  else
        PFN_dummy vkCreateAndroidSurfaceKHR_placeholder = 0;
#  endif /*VK_USE_PLATFORM_ANDROID_KHR*/

#  if defined( VK_USE_PLATFORM_WIN32_KHR )
        //=== VK_KHR_win32_surface ===
        PFN_vkCreateWin32SurfaceKHR                        vkCreateWin32SurfaceKHR                        = 0;
        PFN_vkGetPhysicalDeviceWin32PresentationSupportKHR vkGetPhysicalDeviceWin32PresentationSupportKHR = 0;
#  else
        PFN_dummy vkCreateWin32SurfaceKHR_placeholder                        = 0;
        PFN_dummy vkGetPhysicalDeviceWin32PresentationSupportKHR_placeholder = 0;
#  endif /*VK_USE_PLATFORM_WIN32_KHR*/

        //=== VK_EXT_debug_report ===
        PFN_vkCreateDebugReportCallbackEXT  vkCreateDebugReportCallbackEXT  = 0;
        PFN_vkDestroyDebugReportCallbackEXT vkDestroyDebugReportCallbackEXT = 0;
        PFN_vkDebugReportMessageEXT         vkDebugReportMessageEXT         = 0;

        //=== VK_KHR_video_queue ===
        PFN_vkGetPhysicalDeviceVideoCapabilitiesKHR     vkGetPhysicalDeviceVideoCapabilitiesKHR     = 0;
        PFN_vkGetPhysicalDeviceVideoFormatPropertiesKHR vkGetPhysicalDeviceVideoFormatPropertiesKHR = 0;

#  if defined( VK_USE_PLATFORM_GGP )
        //=== VK_GGP_stream_descriptor_surface ===
        PFN_vkCreateStreamDescriptorSurfaceGGP vkCreateStreamDescriptorSurfaceGGP = 0;
#  else
        PFN_dummy vkCreateStreamDescriptorSurfaceGGP_placeholder = 0;
#  endif /*VK_USE_PLATFORM_GGP*/

        //=== VK_NV_external_memory_capabilities ===
        PFN_vkGetPhysicalDeviceExternalImageFormatPropertiesNV vkGetPhysicalDeviceExternalImageFormatPropertiesNV = 0;

        //=== VK_KHR_get_physical_device_properties2 ===
        PFN_vkGetPhysicalDeviceFeatures2KHR                    vkGetPhysicalDeviceFeatures2KHR                    = 0;
        PFN_vkGetPhysicalDeviceProperties2KHR                  vkGetPhysicalDeviceProperties2KHR                  = 0;
        PFN_vkGetPhysicalDeviceFormatProperties2KHR            vkGetPhysicalDeviceFormatProperties2KHR            = 0;
        PFN_vkGetPhysicalDeviceImageFormatProperties2KHR       vkGetPhysicalDeviceImageFormatProperties2KHR       = 0;
        PFN_vkGetPhysicalDeviceQueueFamilyProperties2KHR       vkGetPhysicalDeviceQueueFamilyProperties2KHR       = 0;
        PFN_vkGetPhysicalDeviceMemoryProperties2KHR            vkGetPhysicalDeviceMemoryProperties2KHR            = 0;
        PFN_vkGetPhysicalDeviceSparseImageFormatProperties2KHR vkGetPhysicalDeviceSparseImageFormatProperties2KHR = 0;

#  if defined( VK_USE_PLATFORM_VI_NN )
        //=== VK_NN_vi_surface ===
        PFN_vkCreateViSurfaceNN vkCreateViSurfaceNN = 0;
#  else
        PFN_dummy vkCreateViSurfaceNN_placeholder = 0;
#  endif /*VK_USE_PLATFORM_VI_NN*/

        //=== VK_KHR_device_group_creation ===
        PFN_vkEnumeratePhysicalDeviceGroupsKHR vkEnumeratePhysicalDeviceGroupsKHR = 0;

        //=== VK_KHR_external_memory_capabilities ===
        PFN_vkGetPhysicalDeviceExternalBufferPropertiesKHR vkGetPhysicalDeviceExternalBufferPropertiesKHR = 0;

        //=== VK_KHR_external_semaphore_capabilities ===
        PFN_vkGetPhysicalDeviceExternalSemaphorePropertiesKHR vkGetPhysicalDeviceExternalSemaphorePropertiesKHR = 0;

        //=== VK_EXT_direct_mode_display ===
        PFN_vkReleaseDisplayEXT vkReleaseDisplayEXT = 0;

#  if defined( VK_USE_PLATFORM_XLIB_XRANDR_EXT )
        //=== VK_EXT_acquire_xlib_display ===
        PFN_vkAcquireXlibDisplayEXT    vkAcquireXlibDisplayEXT    = 0;
        PFN_vkGetRandROutputDisplayEXT vkGetRandROutputDisplayEXT = 0;
#  else
        PFN_dummy vkAcquireXlibDisplayEXT_placeholder    = 0;
        PFN_dummy vkGetRandROutputDisplayEXT_placeholder = 0;
#  endif /*VK_USE_PLATFORM_XLIB_XRANDR_EXT*/

        //=== VK_EXT_display_surface_counter ===
        PFN_vkGetPhysicalDeviceSurfaceCapabilities2EXT vkGetPhysicalDeviceSurfaceCapabilities2EXT = 0;

        //=== VK_KHR_external_fence_capabilities ===
        PFN_vkGetPhysicalDeviceExternalFencePropertiesKHR vkGetPhysicalDeviceExternalFencePropertiesKHR = 0;

        //=== VK_KHR_performance_query ===
        PFN_vkEnumeratePhysicalDeviceQueueFamilyPerformanceQueryCountersKHR vkEnumeratePhysicalDeviceQueueFamilyPerformanceQueryCountersKHR = 0;
        PFN_vkGetPhysicalDeviceQueueFamilyPerformanceQueryPassesKHR         vkGetPhysicalDeviceQueueFamilyPerformanceQueryPassesKHR         = 0;

        //=== VK_KHR_get_surface_capabilities2 ===
        PFN_vkGetPhysicalDeviceSurfaceCapabilities2KHR vkGetPhysicalDeviceSurfaceCapabilities2KHR = 0;
        PFN_vkGetPhysicalDeviceSurfaceFormats2KHR      vkGetPhysicalDeviceSurfaceFormats2KHR      = 0;

        //=== VK_KHR_get_display_properties2 ===
        PFN_vkGetPhysicalDeviceDisplayProperties2KHR      vkGetPhysicalDeviceDisplayProperties2KHR      = 0;
        PFN_vkGetPhysicalDeviceDisplayPlaneProperties2KHR vkGetPhysicalDeviceDisplayPlaneProperties2KHR = 0;
        PFN_vkGetDisplayModeProperties2KHR                vkGetDisplayModeProperties2KHR                = 0;
        PFN_vkGetDisplayPlaneCapabilities2KHR             vkGetDisplayPlaneCapabilities2KHR             = 0;

#  if defined( VK_USE_PLATFORM_IOS_MVK )
        //=== VK_MVK_ios_surface ===
        PFN_vkCreateIOSSurfaceMVK vkCreateIOSSurfaceMVK = 0;
#  else
        PFN_dummy vkCreateIOSSurfaceMVK_placeholder = 0;
#  endif /*VK_USE_PLATFORM_IOS_MVK*/

#  if defined( VK_USE_PLATFORM_MACOS_MVK )
        //=== VK_MVK_macos_surface ===
        PFN_vkCreateMacOSSurfaceMVK vkCreateMacOSSurfaceMVK = 0;
#  else
        PFN_dummy vkCreateMacOSSurfaceMVK_placeholder = 0;
#  endif /*VK_USE_PLATFORM_MACOS_MVK*/

        //=== VK_EXT_debug_utils ===
        PFN_vkCreateDebugUtilsMessengerEXT  vkCreateDebugUtilsMessengerEXT  = 0;
        PFN_vkDestroyDebugUtilsMessengerEXT vkDestroyDebugUtilsMessengerEXT = 0;
        PFN_vkSubmitDebugUtilsMessageEXT    vkSubmitDebugUtilsMessageEXT    = 0;

        //=== VK_EXT_sample_locations ===
        PFN_vkGetPhysicalDeviceMultisamplePropertiesEXT vkGetPhysicalDeviceMultisamplePropertiesEXT = 0;

        //=== VK_EXT_calibrated_timestamps ===
        PFN_vkGetPhysicalDeviceCalibrateableTimeDomainsEXT vkGetPhysicalDeviceCalibrateableTimeDomainsEXT = 0;

#  if defined( VK_USE_PLATFORM_FUCHSIA )
        //=== VK_FUCHSIA_imagepipe_surface ===
        PFN_vkCreateImagePipeSurfaceFUCHSIA vkCreateImagePipeSurfaceFUCHSIA = 0;
#  else
        PFN_dummy vkCreateImagePipeSurfaceFUCHSIA_placeholder = 0;
#  endif /*VK_USE_PLATFORM_FUCHSIA*/

#  if defined( VK_USE_PLATFORM_METAL_EXT )
        //=== VK_EXT_metal_surface ===
        PFN_vkCreateMetalSurfaceEXT vkCreateMetalSurfaceEXT = 0;
#  else
        PFN_dummy vkCreateMetalSurfaceEXT_placeholder = 0;
#  endif /*VK_USE_PLATFORM_METAL_EXT*/

        //=== VK_KHR_fragment_shading_rate ===
        PFN_vkGetPhysicalDeviceFragmentShadingRatesKHR vkGetPhysicalDeviceFragmentShadingRatesKHR = 0;

        //=== VK_EXT_tooling_info ===
        PFN_vkGetPhysicalDeviceToolPropertiesEXT vkGetPhysicalDeviceToolPropertiesEXT = 0;

        //=== VK_NV_cooperative_matrix ===
        PFN_vkGetPhysicalDeviceCooperativeMatrixPropertiesNV vkGetPhysicalDeviceCooperativeMatrixPropertiesNV = 0;

        //=== VK_NV_coverage_reduction_mode ===
        PFN_vkGetPhysicalDeviceSupportedFramebufferMixedSamplesCombinationsNV vkGetPhysicalDeviceSupportedFramebufferMixedSamplesCombinationsNV = 0;

#  if defined( VK_USE_PLATFORM_WIN32_KHR )
        //=== VK_EXT_full_screen_exclusive ===
        PFN_vkGetPhysicalDeviceSurfacePresentModes2EXT vkGetPhysicalDeviceSurfacePresentModes2EXT = 0;
#  else
        PFN_dummy vkGetPhysicalDeviceSurfacePresentModes2EXT_placeholder = 0;
#  endif /*VK_USE_PLATFORM_WIN32_KHR*/

        //=== VK_EXT_headless_surface ===
        PFN_vkCreateHeadlessSurfaceEXT vkCreateHeadlessSurfaceEXT = 0;

        //=== VK_EXT_acquire_drm_display ===
        PFN_vkAcquireDrmDisplayEXT vkAcquireDrmDisplayEXT = 0;
        PFN_vkGetDrmDisplayEXT     vkGetDrmDisplayEXT     = 0;

        //=== VK_KHR_video_encode_queue ===
        PFN_vkGetPhysicalDeviceVideoEncodeQualityLevelPropertiesKHR vkGetPhysicalDeviceVideoEncodeQualityLevelPropertiesKHR = 0;

#  if defined( VK_USE_PLATFORM_WIN32_KHR )
        //=== VK_NV_acquire_winrt_display ===
        PFN_vkAcquireWinrtDisplayNV vkAcquireWinrtDisplayNV = 0;
        PFN_vkGetWinrtDisplayNV     vkGetWinrtDisplayNV     = 0;
#  else
        PFN_dummy vkAcquireWinrtDisplayNV_placeholder = 0;
        PFN_dummy vkGetWinrtDisplayNV_placeholder     = 0;
#  endif /*VK_USE_PLATFORM_WIN32_KHR*/

#  if defined( VK_USE_PLATFORM_DIRECTFB_EXT )
        //=== VK_EXT_directfb_surface ===
        PFN_vkCreateDirectFBSurfaceEXT                        vkCreateDirectFBSurfaceEXT                        = 0;
        PFN_vkGetPhysicalDeviceDirectFBPresentationSupportEXT vkGetPhysicalDeviceDirectFBPresentationSupportEXT = 0;
#  else
        PFN_dummy vkCreateDirectFBSurfaceEXT_placeholder                        = 0;
        PFN_dummy vkGetPhysicalDeviceDirectFBPresentationSupportEXT_placeholder = 0;
#  endif /*VK_USE_PLATFORM_DIRECTFB_EXT*/

#  if defined( VK_USE_PLATFORM_SCREEN_QNX )
        //=== VK_QNX_screen_surface ===
        PFN_vkCreateScreenSurfaceQNX                        vkCreateScreenSurfaceQNX                        = 0;
        PFN_vkGetPhysicalDeviceScreenPresentationSupportQNX vkGetPhysicalDeviceScreenPresentationSupportQNX = 0;
#  else
        PFN_dummy vkCreateScreenSurfaceQNX_placeholder                        = 0;
        PFN_dummy vkGetPhysicalDeviceScreenPresentationSupportQNX_placeholder = 0;
#  endif /*VK_USE_PLATFORM_SCREEN_QNX*/

        //=== VK_ARM_tensors ===
        PFN_vkGetPhysicalDeviceExternalTensorPropertiesARM vkGetPhysicalDeviceExternalTensorPropertiesARM = 0;

        //=== VK_NV_optical_flow ===
        PFN_vkGetPhysicalDeviceOpticalFlowImageFormatsNV vkGetPhysicalDeviceOpticalFlowImageFormatsNV = 0;

        //=== VK_NV_cooperative_vector ===
        PFN_vkGetPhysicalDeviceCooperativeVectorPropertiesNV vkGetPhysicalDeviceCooperativeVectorPropertiesNV = 0;

        //=== VK_KHR_cooperative_matrix ===
        PFN_vkGetPhysicalDeviceCooperativeMatrixPropertiesKHR vkGetPhysicalDeviceCooperativeMatrixPropertiesKHR = 0;

        //=== VK_ARM_data_graph ===
        PFN_vkGetPhysicalDeviceQueueFamilyDataGraphPropertiesARM                 vkGetPhysicalDeviceQueueFamilyDataGraphPropertiesARM                 = 0;
        PFN_vkGetPhysicalDeviceQueueFamilyDataGraphProcessingEnginePropertiesARM vkGetPhysicalDeviceQueueFamilyDataGraphProcessingEnginePropertiesARM = 0;

        //=== VK_KHR_calibrated_timestamps ===
        PFN_vkGetPhysicalDeviceCalibrateableTimeDomainsKHR vkGetPhysicalDeviceCalibrateableTimeDomainsKHR = 0;

#  if defined( VK_USE_PLATFORM_OHOS )
        //=== VK_OHOS_surface ===
        PFN_vkCreateSurfaceOHOS vkCreateSurfaceOHOS = 0;
#  else
        PFN_dummy vkCreateSurfaceOHOS_placeholder = 0;
#  endif /*VK_USE_PLATFORM_OHOS*/

        //=== VK_NV_cooperative_matrix2 ===
        PFN_vkGetPhysicalDeviceCooperativeMatrixFlexibleDimensionsPropertiesNV vkGetPhysicalDeviceCooperativeMatrixFlexibleDimensionsPropertiesNV = 0;

        //=== VK_ARM_performance_counters_by_region ===
        PFN_vkEnumeratePhysicalDeviceQueueFamilyPerformanceCountersByRegionARM vkEnumeratePhysicalDeviceQueueFamilyPerformanceCountersByRegionARM = 0;

        PFN_vkGetDeviceProcAddr vkGetDeviceProcAddr = 0;
      };

      class DeviceDispatcher : public ::VULKAN_HPP_NAMESPACE::detail::DispatchLoaderBase
      {
      public:
        DeviceDispatcher( PFN_vkGetDeviceProcAddr getProcAddr, VkDevice device ) : vkGetDeviceProcAddr( getProcAddr )
        {
          //=== VK_VERSION_1_0 ===
          vkGetDeviceProcAddr                = PFN_vkGetDeviceProcAddr( vkGetDeviceProcAddr( device, "vkGetDeviceProcAddr" ) );
          vkDestroyDevice                    = PFN_vkDestroyDevice( vkGetDeviceProcAddr( device, "vkDestroyDevice" ) );
          vkGetDeviceQueue                   = PFN_vkGetDeviceQueue( vkGetDeviceProcAddr( device, "vkGetDeviceQueue" ) );
          vkQueueSubmit                      = PFN_vkQueueSubmit( vkGetDeviceProcAddr( device, "vkQueueSubmit" ) );
          vkQueueWaitIdle                    = PFN_vkQueueWaitIdle( vkGetDeviceProcAddr( device, "vkQueueWaitIdle" ) );
          vkDeviceWaitIdle                   = PFN_vkDeviceWaitIdle( vkGetDeviceProcAddr( device, "vkDeviceWaitIdle" ) );
          vkAllocateMemory                   = PFN_vkAllocateMemory( vkGetDeviceProcAddr( device, "vkAllocateMemory" ) );
          vkFreeMemory                       = PFN_vkFreeMemory( vkGetDeviceProcAddr( device, "vkFreeMemory" ) );
          vkMapMemory                        = PFN_vkMapMemory( vkGetDeviceProcAddr( device, "vkMapMemory" ) );
          vkUnmapMemory                      = PFN_vkUnmapMemory( vkGetDeviceProcAddr( device, "vkUnmapMemory" ) );
          vkFlushMappedMemoryRanges          = PFN_vkFlushMappedMemoryRanges( vkGetDeviceProcAddr( device, "vkFlushMappedMemoryRanges" ) );
          vkInvalidateMappedMemoryRanges     = PFN_vkInvalidateMappedMemoryRanges( vkGetDeviceProcAddr( device, "vkInvalidateMappedMemoryRanges" ) );
          vkGetDeviceMemoryCommitment        = PFN_vkGetDeviceMemoryCommitment( vkGetDeviceProcAddr( device, "vkGetDeviceMemoryCommitment" ) );
          vkBindBufferMemory                 = PFN_vkBindBufferMemory( vkGetDeviceProcAddr( device, "vkBindBufferMemory" ) );
          vkBindImageMemory                  = PFN_vkBindImageMemory( vkGetDeviceProcAddr( device, "vkBindImageMemory" ) );
          vkGetBufferMemoryRequirements      = PFN_vkGetBufferMemoryRequirements( vkGetDeviceProcAddr( device, "vkGetBufferMemoryRequirements" ) );
          vkGetImageMemoryRequirements       = PFN_vkGetImageMemoryRequirements( vkGetDeviceProcAddr( device, "vkGetImageMemoryRequirements" ) );
          vkGetImageSparseMemoryRequirements = PFN_vkGetImageSparseMemoryRequirements( vkGetDeviceProcAddr( device, "vkGetImageSparseMemoryRequirements" ) );
          vkQueueBindSparse                  = PFN_vkQueueBindSparse( vkGetDeviceProcAddr( device, "vkQueueBindSparse" ) );
          vkCreateFence                      = PFN_vkCreateFence( vkGetDeviceProcAddr( device, "vkCreateFence" ) );
          vkDestroyFence                     = PFN_vkDestroyFence( vkGetDeviceProcAddr( device, "vkDestroyFence" ) );
          vkResetFences                      = PFN_vkResetFences( vkGetDeviceProcAddr( device, "vkResetFences" ) );
          vkGetFenceStatus                   = PFN_vkGetFenceStatus( vkGetDeviceProcAddr( device, "vkGetFenceStatus" ) );
          vkWaitForFences                    = PFN_vkWaitForFences( vkGetDeviceProcAddr( device, "vkWaitForFences" ) );
          vkCreateSemaphore                  = PFN_vkCreateSemaphore( vkGetDeviceProcAddr( device, "vkCreateSemaphore" ) );
          vkDestroySemaphore                 = PFN_vkDestroySemaphore( vkGetDeviceProcAddr( device, "vkDestroySemaphore" ) );
          vkCreateQueryPool                  = PFN_vkCreateQueryPool( vkGetDeviceProcAddr( device, "vkCreateQueryPool" ) );
          vkDestroyQueryPool                 = PFN_vkDestroyQueryPool( vkGetDeviceProcAddr( device, "vkDestroyQueryPool" ) );
          vkGetQueryPoolResults              = PFN_vkGetQueryPoolResults( vkGetDeviceProcAddr( device, "vkGetQueryPoolResults" ) );
          vkCreateBuffer                     = PFN_vkCreateBuffer( vkGetDeviceProcAddr( device, "vkCreateBuffer" ) );
          vkDestroyBuffer                    = PFN_vkDestroyBuffer( vkGetDeviceProcAddr( device, "vkDestroyBuffer" ) );
          vkCreateImage                      = PFN_vkCreateImage( vkGetDeviceProcAddr( device, "vkCreateImage" ) );
          vkDestroyImage                     = PFN_vkDestroyImage( vkGetDeviceProcAddr( device, "vkDestroyImage" ) );
          vkGetImageSubresourceLayout        = PFN_vkGetImageSubresourceLayout( vkGetDeviceProcAddr( device, "vkGetImageSubresourceLayout" ) );
          vkCreateImageView                  = PFN_vkCreateImageView( vkGetDeviceProcAddr( device, "vkCreateImageView" ) );
          vkDestroyImageView                 = PFN_vkDestroyImageView( vkGetDeviceProcAddr( device, "vkDestroyImageView" ) );
          vkCreateCommandPool                = PFN_vkCreateCommandPool( vkGetDeviceProcAddr( device, "vkCreateCommandPool" ) );
          vkDestroyCommandPool               = PFN_vkDestroyCommandPool( vkGetDeviceProcAddr( device, "vkDestroyCommandPool" ) );
          vkResetCommandPool                 = PFN_vkResetCommandPool( vkGetDeviceProcAddr( device, "vkResetCommandPool" ) );
          vkAllocateCommandBuffers           = PFN_vkAllocateCommandBuffers( vkGetDeviceProcAddr( device, "vkAllocateCommandBuffers" ) );
          vkFreeCommandBuffers               = PFN_vkFreeCommandBuffers( vkGetDeviceProcAddr( device, "vkFreeCommandBuffers" ) );
          vkBeginCommandBuffer               = PFN_vkBeginCommandBuffer( vkGetDeviceProcAddr( device, "vkBeginCommandBuffer" ) );
          vkEndCommandBuffer                 = PFN_vkEndCommandBuffer( vkGetDeviceProcAddr( device, "vkEndCommandBuffer" ) );
          vkResetCommandBuffer               = PFN_vkResetCommandBuffer( vkGetDeviceProcAddr( device, "vkResetCommandBuffer" ) );
          vkCmdCopyBuffer                    = PFN_vkCmdCopyBuffer( vkGetDeviceProcAddr( device, "vkCmdCopyBuffer" ) );
          vkCmdCopyImage                     = PFN_vkCmdCopyImage( vkGetDeviceProcAddr( device, "vkCmdCopyImage" ) );
          vkCmdCopyBufferToImage             = PFN_vkCmdCopyBufferToImage( vkGetDeviceProcAddr( device, "vkCmdCopyBufferToImage" ) );
          vkCmdCopyImageToBuffer             = PFN_vkCmdCopyImageToBuffer( vkGetDeviceProcAddr( device, "vkCmdCopyImageToBuffer" ) );
          vkCmdUpdateBuffer                  = PFN_vkCmdUpdateBuffer( vkGetDeviceProcAddr( device, "vkCmdUpdateBuffer" ) );
          vkCmdFillBuffer                    = PFN_vkCmdFillBuffer( vkGetDeviceProcAddr( device, "vkCmdFillBuffer" ) );
          vkCmdPipelineBarrier               = PFN_vkCmdPipelineBarrier( vkGetDeviceProcAddr( device, "vkCmdPipelineBarrier" ) );
          vkCmdBeginQuery                    = PFN_vkCmdBeginQuery( vkGetDeviceProcAddr( device, "vkCmdBeginQuery" ) );
          vkCmdEndQuery                      = PFN_vkCmdEndQuery( vkGetDeviceProcAddr( device, "vkCmdEndQuery" ) );
          vkCmdResetQueryPool                = PFN_vkCmdResetQueryPool( vkGetDeviceProcAddr( device, "vkCmdResetQueryPool" ) );
          vkCmdWriteTimestamp                = PFN_vkCmdWriteTimestamp( vkGetDeviceProcAddr( device, "vkCmdWriteTimestamp" ) );
          vkCmdCopyQueryPoolResults          = PFN_vkCmdCopyQueryPoolResults( vkGetDeviceProcAddr( device, "vkCmdCopyQueryPoolResults" ) );
          vkCmdExecuteCommands               = PFN_vkCmdExecuteCommands( vkGetDeviceProcAddr( device, "vkCmdExecuteCommands" ) );
          vkCreateEvent                      = PFN_vkCreateEvent( vkGetDeviceProcAddr( device, "vkCreateEvent" ) );
          vkDestroyEvent                     = PFN_vkDestroyEvent( vkGetDeviceProcAddr( device, "vkDestroyEvent" ) );
          vkGetEventStatus                   = PFN_vkGetEventStatus( vkGetDeviceProcAddr( device, "vkGetEventStatus" ) );
          vkSetEvent                         = PFN_vkSetEvent( vkGetDeviceProcAddr( device, "vkSetEvent" ) );
          vkResetEvent                       = PFN_vkResetEvent( vkGetDeviceProcAddr( device, "vkResetEvent" ) );
          vkCreateBufferView                 = PFN_vkCreateBufferView( vkGetDeviceProcAddr( device, "vkCreateBufferView" ) );
          vkDestroyBufferView                = PFN_vkDestroyBufferView( vkGetDeviceProcAddr( device, "vkDestroyBufferView" ) );
          vkCreateShaderModule               = PFN_vkCreateShaderModule( vkGetDeviceProcAddr( device, "vkCreateShaderModule" ) );
          vkDestroyShaderModule              = PFN_vkDestroyShaderModule( vkGetDeviceProcAddr( device, "vkDestroyShaderModule" ) );
          vkCreatePipelineCache              = PFN_vkCreatePipelineCache( vkGetDeviceProcAddr( device, "vkCreatePipelineCache" ) );
          vkDestroyPipelineCache             = PFN_vkDestroyPipelineCache( vkGetDeviceProcAddr( device, "vkDestroyPipelineCache" ) );
          vkGetPipelineCacheData             = PFN_vkGetPipelineCacheData( vkGetDeviceProcAddr( device, "vkGetPipelineCacheData" ) );
          vkMergePipelineCaches              = PFN_vkMergePipelineCaches( vkGetDeviceProcAddr( device, "vkMergePipelineCaches" ) );
          vkCreateComputePipelines           = PFN_vkCreateComputePipelines( vkGetDeviceProcAddr( device, "vkCreateComputePipelines" ) );
          vkDestroyPipeline                  = PFN_vkDestroyPipeline( vkGetDeviceProcAddr( device, "vkDestroyPipeline" ) );
          vkCreatePipelineLayout             = PFN_vkCreatePipelineLayout( vkGetDeviceProcAddr( device, "vkCreatePipelineLayout" ) );
          vkDestroyPipelineLayout            = PFN_vkDestroyPipelineLayout( vkGetDeviceProcAddr( device, "vkDestroyPipelineLayout" ) );
          vkCreateSampler                    = PFN_vkCreateSampler( vkGetDeviceProcAddr( device, "vkCreateSampler" ) );
          vkDestroySampler                   = PFN_vkDestroySampler( vkGetDeviceProcAddr( device, "vkDestroySampler" ) );
          vkCreateDescriptorSetLayout        = PFN_vkCreateDescriptorSetLayout( vkGetDeviceProcAddr( device, "vkCreateDescriptorSetLayout" ) );
          vkDestroyDescriptorSetLayout       = PFN_vkDestroyDescriptorSetLayout( vkGetDeviceProcAddr( device, "vkDestroyDescriptorSetLayout" ) );
          vkCreateDescriptorPool             = PFN_vkCreateDescriptorPool( vkGetDeviceProcAddr( device, "vkCreateDescriptorPool" ) );
          vkDestroyDescriptorPool            = PFN_vkDestroyDescriptorPool( vkGetDeviceProcAddr( device, "vkDestroyDescriptorPool" ) );
          vkResetDescriptorPool              = PFN_vkResetDescriptorPool( vkGetDeviceProcAddr( device, "vkResetDescriptorPool" ) );
          vkAllocateDescriptorSets           = PFN_vkAllocateDescriptorSets( vkGetDeviceProcAddr( device, "vkAllocateDescriptorSets" ) );
          vkFreeDescriptorSets               = PFN_vkFreeDescriptorSets( vkGetDeviceProcAddr( device, "vkFreeDescriptorSets" ) );
          vkUpdateDescriptorSets             = PFN_vkUpdateDescriptorSets( vkGetDeviceProcAddr( device, "vkUpdateDescriptorSets" ) );
          vkCmdBindPipeline                  = PFN_vkCmdBindPipeline( vkGetDeviceProcAddr( device, "vkCmdBindPipeline" ) );
          vkCmdBindDescriptorSets            = PFN_vkCmdBindDescriptorSets( vkGetDeviceProcAddr( device, "vkCmdBindDescriptorSets" ) );
          vkCmdClearColorImage               = PFN_vkCmdClearColorImage( vkGetDeviceProcAddr( device, "vkCmdClearColorImage" ) );
          vkCmdDispatch                      = PFN_vkCmdDispatch( vkGetDeviceProcAddr( device, "vkCmdDispatch" ) );
          vkCmdDispatchIndirect              = PFN_vkCmdDispatchIndirect( vkGetDeviceProcAddr( device, "vkCmdDispatchIndirect" ) );
          vkCmdSetEvent                      = PFN_vkCmdSetEvent( vkGetDeviceProcAddr( device, "vkCmdSetEvent" ) );
          vkCmdResetEvent                    = PFN_vkCmdResetEvent( vkGetDeviceProcAddr( device, "vkCmdResetEvent" ) );
          vkCmdWaitEvents                    = PFN_vkCmdWaitEvents( vkGetDeviceProcAddr( device, "vkCmdWaitEvents" ) );
          vkCmdPushConstants                 = PFN_vkCmdPushConstants( vkGetDeviceProcAddr( device, "vkCmdPushConstants" ) );
          vkCreateGraphicsPipelines          = PFN_vkCreateGraphicsPipelines( vkGetDeviceProcAddr( device, "vkCreateGraphicsPipelines" ) );
          vkCreateFramebuffer                = PFN_vkCreateFramebuffer( vkGetDeviceProcAddr( device, "vkCreateFramebuffer" ) );
          vkDestroyFramebuffer               = PFN_vkDestroyFramebuffer( vkGetDeviceProcAddr( device, "vkDestroyFramebuffer" ) );
          vkCreateRenderPass                 = PFN_vkCreateRenderPass( vkGetDeviceProcAddr( device, "vkCreateRenderPass" ) );
          vkDestroyRenderPass                = PFN_vkDestroyRenderPass( vkGetDeviceProcAddr( device, "vkDestroyRenderPass" ) );
          vkGetRenderAreaGranularity         = PFN_vkGetRenderAreaGranularity( vkGetDeviceProcAddr( device, "vkGetRenderAreaGranularity" ) );
          vkCmdSetViewport                   = PFN_vkCmdSetViewport( vkGetDeviceProcAddr( device, "vkCmdSetViewport" ) );
          vkCmdSetScissor                    = PFN_vkCmdSetScissor( vkGetDeviceProcAddr( device, "vkCmdSetScissor" ) );
          vkCmdSetLineWidth                  = PFN_vkCmdSetLineWidth( vkGetDeviceProcAddr( device, "vkCmdSetLineWidth" ) );
          vkCmdSetDepthBias                  = PFN_vkCmdSetDepthBias( vkGetDeviceProcAddr( device, "vkCmdSetDepthBias" ) );
          vkCmdSetBlendConstants             = PFN_vkCmdSetBlendConstants( vkGetDeviceProcAddr( device, "vkCmdSetBlendConstants" ) );
          vkCmdSetDepthBounds                = PFN_vkCmdSetDepthBounds( vkGetDeviceProcAddr( device, "vkCmdSetDepthBounds" ) );
          vkCmdSetStencilCompareMask         = PFN_vkCmdSetStencilCompareMask( vkGetDeviceProcAddr( device, "vkCmdSetStencilCompareMask" ) );
          vkCmdSetStencilWriteMask           = PFN_vkCmdSetStencilWriteMask( vkGetDeviceProcAddr( device, "vkCmdSetStencilWriteMask" ) );
          vkCmdSetStencilReference           = PFN_vkCmdSetStencilReference( vkGetDeviceProcAddr( device, "vkCmdSetStencilReference" ) );
          vkCmdBindIndexBuffer               = PFN_vkCmdBindIndexBuffer( vkGetDeviceProcAddr( device, "vkCmdBindIndexBuffer" ) );
          vkCmdBindVertexBuffers             = PFN_vkCmdBindVertexBuffers( vkGetDeviceProcAddr( device, "vkCmdBindVertexBuffers" ) );
          vkCmdDraw                          = PFN_vkCmdDraw( vkGetDeviceProcAddr( device, "vkCmdDraw" ) );
          vkCmdDrawIndexed                   = PFN_vkCmdDrawIndexed( vkGetDeviceProcAddr( device, "vkCmdDrawIndexed" ) );
          vkCmdDrawIndirect                  = PFN_vkCmdDrawIndirect( vkGetDeviceProcAddr( device, "vkCmdDrawIndirect" ) );
          vkCmdDrawIndexedIndirect           = PFN_vkCmdDrawIndexedIndirect( vkGetDeviceProcAddr( device, "vkCmdDrawIndexedIndirect" ) );
          vkCmdBlitImage                     = PFN_vkCmdBlitImage( vkGetDeviceProcAddr( device, "vkCmdBlitImage" ) );
          vkCmdClearDepthStencilImage        = PFN_vkCmdClearDepthStencilImage( vkGetDeviceProcAddr( device, "vkCmdClearDepthStencilImage" ) );
          vkCmdClearAttachments              = PFN_vkCmdClearAttachments( vkGetDeviceProcAddr( device, "vkCmdClearAttachments" ) );
          vkCmdResolveImage                  = PFN_vkCmdResolveImage( vkGetDeviceProcAddr( device, "vkCmdResolveImage" ) );
          vkCmdBeginRenderPass               = PFN_vkCmdBeginRenderPass( vkGetDeviceProcAddr( device, "vkCmdBeginRenderPass" ) );
          vkCmdNextSubpass                   = PFN_vkCmdNextSubpass( vkGetDeviceProcAddr( device, "vkCmdNextSubpass" ) );
          vkCmdEndRenderPass                 = PFN_vkCmdEndRenderPass( vkGetDeviceProcAddr( device, "vkCmdEndRenderPass" ) );

          //=== VK_VERSION_1_1 ===
          vkBindBufferMemory2                 = PFN_vkBindBufferMemory2( vkGetDeviceProcAddr( device, "vkBindBufferMemory2" ) );
          vkBindImageMemory2                  = PFN_vkBindImageMemory2( vkGetDeviceProcAddr( device, "vkBindImageMemory2" ) );
          vkGetDeviceGroupPeerMemoryFeatures  = PFN_vkGetDeviceGroupPeerMemoryFeatures( vkGetDeviceProcAddr( device, "vkGetDeviceGroupPeerMemoryFeatures" ) );
          vkCmdSetDeviceMask                  = PFN_vkCmdSetDeviceMask( vkGetDeviceProcAddr( device, "vkCmdSetDeviceMask" ) );
          vkGetImageMemoryRequirements2       = PFN_vkGetImageMemoryRequirements2( vkGetDeviceProcAddr( device, "vkGetImageMemoryRequirements2" ) );
          vkGetBufferMemoryRequirements2      = PFN_vkGetBufferMemoryRequirements2( vkGetDeviceProcAddr( device, "vkGetBufferMemoryRequirements2" ) );
          vkGetImageSparseMemoryRequirements2 = PFN_vkGetImageSparseMemoryRequirements2( vkGetDeviceProcAddr( device, "vkGetImageSparseMemoryRequirements2" ) );
          vkTrimCommandPool                   = PFN_vkTrimCommandPool( vkGetDeviceProcAddr( device, "vkTrimCommandPool" ) );
          vkGetDeviceQueue2                   = PFN_vkGetDeviceQueue2( vkGetDeviceProcAddr( device, "vkGetDeviceQueue2" ) );
          vkCmdDispatchBase                   = PFN_vkCmdDispatchBase( vkGetDeviceProcAddr( device, "vkCmdDispatchBase" ) );
          vkCreateDescriptorUpdateTemplate    = PFN_vkCreateDescriptorUpdateTemplate( vkGetDeviceProcAddr( device, "vkCreateDescriptorUpdateTemplate" ) );
          vkDestroyDescriptorUpdateTemplate   = PFN_vkDestroyDescriptorUpdateTemplate( vkGetDeviceProcAddr( device, "vkDestroyDescriptorUpdateTemplate" ) );
          vkUpdateDescriptorSetWithTemplate   = PFN_vkUpdateDescriptorSetWithTemplate( vkGetDeviceProcAddr( device, "vkUpdateDescriptorSetWithTemplate" ) );
          vkGetDescriptorSetLayoutSupport     = PFN_vkGetDescriptorSetLayoutSupport( vkGetDeviceProcAddr( device, "vkGetDescriptorSetLayoutSupport" ) );
          vkCreateSamplerYcbcrConversion      = PFN_vkCreateSamplerYcbcrConversion( vkGetDeviceProcAddr( device, "vkCreateSamplerYcbcrConversion" ) );
          vkDestroySamplerYcbcrConversion     = PFN_vkDestroySamplerYcbcrConversion( vkGetDeviceProcAddr( device, "vkDestroySamplerYcbcrConversion" ) );

          //=== VK_VERSION_1_2 ===
          vkResetQueryPool                = PFN_vkResetQueryPool( vkGetDeviceProcAddr( device, "vkResetQueryPool" ) );
          vkGetSemaphoreCounterValue      = PFN_vkGetSemaphoreCounterValue( vkGetDeviceProcAddr( device, "vkGetSemaphoreCounterValue" ) );
          vkWaitSemaphores                = PFN_vkWaitSemaphores( vkGetDeviceProcAddr( device, "vkWaitSemaphores" ) );
          vkSignalSemaphore               = PFN_vkSignalSemaphore( vkGetDeviceProcAddr( device, "vkSignalSemaphore" ) );
          vkGetBufferDeviceAddress        = PFN_vkGetBufferDeviceAddress( vkGetDeviceProcAddr( device, "vkGetBufferDeviceAddress" ) );
          vkGetBufferOpaqueCaptureAddress = PFN_vkGetBufferOpaqueCaptureAddress( vkGetDeviceProcAddr( device, "vkGetBufferOpaqueCaptureAddress" ) );
          vkGetDeviceMemoryOpaqueCaptureAddress =
            PFN_vkGetDeviceMemoryOpaqueCaptureAddress( vkGetDeviceProcAddr( device, "vkGetDeviceMemoryOpaqueCaptureAddress" ) );
          vkCmdDrawIndirectCount        = PFN_vkCmdDrawIndirectCount( vkGetDeviceProcAddr( device, "vkCmdDrawIndirectCount" ) );
          vkCmdDrawIndexedIndirectCount = PFN_vkCmdDrawIndexedIndirectCount( vkGetDeviceProcAddr( device, "vkCmdDrawIndexedIndirectCount" ) );
          vkCreateRenderPass2           = PFN_vkCreateRenderPass2( vkGetDeviceProcAddr( device, "vkCreateRenderPass2" ) );
          vkCmdBeginRenderPass2         = PFN_vkCmdBeginRenderPass2( vkGetDeviceProcAddr( device, "vkCmdBeginRenderPass2" ) );
          vkCmdNextSubpass2             = PFN_vkCmdNextSubpass2( vkGetDeviceProcAddr( device, "vkCmdNextSubpass2" ) );
          vkCmdEndRenderPass2           = PFN_vkCmdEndRenderPass2( vkGetDeviceProcAddr( device, "vkCmdEndRenderPass2" ) );

          //=== VK_VERSION_1_3 ===
          vkCreatePrivateDataSlot             = PFN_vkCreatePrivateDataSlot( vkGetDeviceProcAddr( device, "vkCreatePrivateDataSlot" ) );
          vkDestroyPrivateDataSlot            = PFN_vkDestroyPrivateDataSlot( vkGetDeviceProcAddr( device, "vkDestroyPrivateDataSlot" ) );
          vkSetPrivateData                    = PFN_vkSetPrivateData( vkGetDeviceProcAddr( device, "vkSetPrivateData" ) );
          vkGetPrivateData                    = PFN_vkGetPrivateData( vkGetDeviceProcAddr( device, "vkGetPrivateData" ) );
          vkCmdPipelineBarrier2               = PFN_vkCmdPipelineBarrier2( vkGetDeviceProcAddr( device, "vkCmdPipelineBarrier2" ) );
          vkCmdWriteTimestamp2                = PFN_vkCmdWriteTimestamp2( vkGetDeviceProcAddr( device, "vkCmdWriteTimestamp2" ) );
          vkQueueSubmit2                      = PFN_vkQueueSubmit2( vkGetDeviceProcAddr( device, "vkQueueSubmit2" ) );
          vkCmdCopyBuffer2                    = PFN_vkCmdCopyBuffer2( vkGetDeviceProcAddr( device, "vkCmdCopyBuffer2" ) );
          vkCmdCopyImage2                     = PFN_vkCmdCopyImage2( vkGetDeviceProcAddr( device, "vkCmdCopyImage2" ) );
          vkCmdCopyBufferToImage2             = PFN_vkCmdCopyBufferToImage2( vkGetDeviceProcAddr( device, "vkCmdCopyBufferToImage2" ) );
          vkCmdCopyImageToBuffer2             = PFN_vkCmdCopyImageToBuffer2( vkGetDeviceProcAddr( device, "vkCmdCopyImageToBuffer2" ) );
          vkGetDeviceBufferMemoryRequirements = PFN_vkGetDeviceBufferMemoryRequirements( vkGetDeviceProcAddr( device, "vkGetDeviceBufferMemoryRequirements" ) );
          vkGetDeviceImageMemoryRequirements  = PFN_vkGetDeviceImageMemoryRequirements( vkGetDeviceProcAddr( device, "vkGetDeviceImageMemoryRequirements" ) );
          vkGetDeviceImageSparseMemoryRequirements =
            PFN_vkGetDeviceImageSparseMemoryRequirements( vkGetDeviceProcAddr( device, "vkGetDeviceImageSparseMemoryRequirements" ) );
          vkCmdSetEvent2                  = PFN_vkCmdSetEvent2( vkGetDeviceProcAddr( device, "vkCmdSetEvent2" ) );
          vkCmdResetEvent2                = PFN_vkCmdResetEvent2( vkGetDeviceProcAddr( device, "vkCmdResetEvent2" ) );
          vkCmdWaitEvents2                = PFN_vkCmdWaitEvents2( vkGetDeviceProcAddr( device, "vkCmdWaitEvents2" ) );
          vkCmdBlitImage2                 = PFN_vkCmdBlitImage2( vkGetDeviceProcAddr( device, "vkCmdBlitImage2" ) );
          vkCmdResolveImage2              = PFN_vkCmdResolveImage2( vkGetDeviceProcAddr( device, "vkCmdResolveImage2" ) );
          vkCmdBeginRendering             = PFN_vkCmdBeginRendering( vkGetDeviceProcAddr( device, "vkCmdBeginRendering" ) );
          vkCmdEndRendering               = PFN_vkCmdEndRendering( vkGetDeviceProcAddr( device, "vkCmdEndRendering" ) );
          vkCmdSetCullMode                = PFN_vkCmdSetCullMode( vkGetDeviceProcAddr( device, "vkCmdSetCullMode" ) );
          vkCmdSetFrontFace               = PFN_vkCmdSetFrontFace( vkGetDeviceProcAddr( device, "vkCmdSetFrontFace" ) );
          vkCmdSetPrimitiveTopology       = PFN_vkCmdSetPrimitiveTopology( vkGetDeviceProcAddr( device, "vkCmdSetPrimitiveTopology" ) );
          vkCmdSetViewportWithCount       = PFN_vkCmdSetViewportWithCount( vkGetDeviceProcAddr( device, "vkCmdSetViewportWithCount" ) );
          vkCmdSetScissorWithCount        = PFN_vkCmdSetScissorWithCount( vkGetDeviceProcAddr( device, "vkCmdSetScissorWithCount" ) );
          vkCmdBindVertexBuffers2         = PFN_vkCmdBindVertexBuffers2( vkGetDeviceProcAddr( device, "vkCmdBindVertexBuffers2" ) );
          vkCmdSetDepthTestEnable         = PFN_vkCmdSetDepthTestEnable( vkGetDeviceProcAddr( device, "vkCmdSetDepthTestEnable" ) );
          vkCmdSetDepthWriteEnable        = PFN_vkCmdSetDepthWriteEnable( vkGetDeviceProcAddr( device, "vkCmdSetDepthWriteEnable" ) );
          vkCmdSetDepthCompareOp          = PFN_vkCmdSetDepthCompareOp( vkGetDeviceProcAddr( device, "vkCmdSetDepthCompareOp" ) );
          vkCmdSetDepthBoundsTestEnable   = PFN_vkCmdSetDepthBoundsTestEnable( vkGetDeviceProcAddr( device, "vkCmdSetDepthBoundsTestEnable" ) );
          vkCmdSetStencilTestEnable       = PFN_vkCmdSetStencilTestEnable( vkGetDeviceProcAddr( device, "vkCmdSetStencilTestEnable" ) );
          vkCmdSetStencilOp               = PFN_vkCmdSetStencilOp( vkGetDeviceProcAddr( device, "vkCmdSetStencilOp" ) );
          vkCmdSetRasterizerDiscardEnable = PFN_vkCmdSetRasterizerDiscardEnable( vkGetDeviceProcAddr( device, "vkCmdSetRasterizerDiscardEnable" ) );
          vkCmdSetDepthBiasEnable         = PFN_vkCmdSetDepthBiasEnable( vkGetDeviceProcAddr( device, "vkCmdSetDepthBiasEnable" ) );
          vkCmdSetPrimitiveRestartEnable  = PFN_vkCmdSetPrimitiveRestartEnable( vkGetDeviceProcAddr( device, "vkCmdSetPrimitiveRestartEnable" ) );

          //=== VK_VERSION_1_4 ===
          vkMapMemory2                        = PFN_vkMapMemory2( vkGetDeviceProcAddr( device, "vkMapMemory2" ) );
          vkUnmapMemory2                      = PFN_vkUnmapMemory2( vkGetDeviceProcAddr( device, "vkUnmapMemory2" ) );
          vkGetDeviceImageSubresourceLayout   = PFN_vkGetDeviceImageSubresourceLayout( vkGetDeviceProcAddr( device, "vkGetDeviceImageSubresourceLayout" ) );
          vkGetImageSubresourceLayout2        = PFN_vkGetImageSubresourceLayout2( vkGetDeviceProcAddr( device, "vkGetImageSubresourceLayout2" ) );
          vkCopyMemoryToImage                 = PFN_vkCopyMemoryToImage( vkGetDeviceProcAddr( device, "vkCopyMemoryToImage" ) );
          vkCopyImageToMemory                 = PFN_vkCopyImageToMemory( vkGetDeviceProcAddr( device, "vkCopyImageToMemory" ) );
          vkCopyImageToImage                  = PFN_vkCopyImageToImage( vkGetDeviceProcAddr( device, "vkCopyImageToImage" ) );
          vkTransitionImageLayout             = PFN_vkTransitionImageLayout( vkGetDeviceProcAddr( device, "vkTransitionImageLayout" ) );
          vkCmdPushDescriptorSet              = PFN_vkCmdPushDescriptorSet( vkGetDeviceProcAddr( device, "vkCmdPushDescriptorSet" ) );
          vkCmdPushDescriptorSetWithTemplate  = PFN_vkCmdPushDescriptorSetWithTemplate( vkGetDeviceProcAddr( device, "vkCmdPushDescriptorSetWithTemplate" ) );
          vkCmdBindDescriptorSets2            = PFN_vkCmdBindDescriptorSets2( vkGetDeviceProcAddr( device, "vkCmdBindDescriptorSets2" ) );
          vkCmdPushConstants2                 = PFN_vkCmdPushConstants2( vkGetDeviceProcAddr( device, "vkCmdPushConstants2" ) );
          vkCmdPushDescriptorSet2             = PFN_vkCmdPushDescriptorSet2( vkGetDeviceProcAddr( device, "vkCmdPushDescriptorSet2" ) );
          vkCmdPushDescriptorSetWithTemplate2 = PFN_vkCmdPushDescriptorSetWithTemplate2( vkGetDeviceProcAddr( device, "vkCmdPushDescriptorSetWithTemplate2" ) );
          vkCmdSetLineStipple                 = PFN_vkCmdSetLineStipple( vkGetDeviceProcAddr( device, "vkCmdSetLineStipple" ) );
          vkCmdBindIndexBuffer2               = PFN_vkCmdBindIndexBuffer2( vkGetDeviceProcAddr( device, "vkCmdBindIndexBuffer2" ) );
          vkGetRenderingAreaGranularity       = PFN_vkGetRenderingAreaGranularity( vkGetDeviceProcAddr( device, "vkGetRenderingAreaGranularity" ) );
          vkCmdSetRenderingAttachmentLocations =
            PFN_vkCmdSetRenderingAttachmentLocations( vkGetDeviceProcAddr( device, "vkCmdSetRenderingAttachmentLocations" ) );
          vkCmdSetRenderingInputAttachmentIndices =
            PFN_vkCmdSetRenderingInputAttachmentIndices( vkGetDeviceProcAddr( device, "vkCmdSetRenderingInputAttachmentIndices" ) );

          //=== VK_KHR_swapchain ===
          vkCreateSwapchainKHR    = PFN_vkCreateSwapchainKHR( vkGetDeviceProcAddr( device, "vkCreateSwapchainKHR" ) );
          vkDestroySwapchainKHR   = PFN_vkDestroySwapchainKHR( vkGetDeviceProcAddr( device, "vkDestroySwapchainKHR" ) );
          vkGetSwapchainImagesKHR = PFN_vkGetSwapchainImagesKHR( vkGetDeviceProcAddr( device, "vkGetSwapchainImagesKHR" ) );
          vkAcquireNextImageKHR   = PFN_vkAcquireNextImageKHR( vkGetDeviceProcAddr( device, "vkAcquireNextImageKHR" ) );
          vkQueuePresentKHR       = PFN_vkQueuePresentKHR( vkGetDeviceProcAddr( device, "vkQueuePresentKHR" ) );
          vkGetDeviceGroupPresentCapabilitiesKHR =
            PFN_vkGetDeviceGroupPresentCapabilitiesKHR( vkGetDeviceProcAddr( device, "vkGetDeviceGroupPresentCapabilitiesKHR" ) );
          vkGetDeviceGroupSurfacePresentModesKHR =
            PFN_vkGetDeviceGroupSurfacePresentModesKHR( vkGetDeviceProcAddr( device, "vkGetDeviceGroupSurfacePresentModesKHR" ) );
          vkAcquireNextImage2KHR = PFN_vkAcquireNextImage2KHR( vkGetDeviceProcAddr( device, "vkAcquireNextImage2KHR" ) );

          //=== VK_KHR_display_swapchain ===
          vkCreateSharedSwapchainsKHR = PFN_vkCreateSharedSwapchainsKHR( vkGetDeviceProcAddr( device, "vkCreateSharedSwapchainsKHR" ) );

          //=== VK_EXT_debug_marker ===
          vkDebugMarkerSetObjectTagEXT  = PFN_vkDebugMarkerSetObjectTagEXT( vkGetDeviceProcAddr( device, "vkDebugMarkerSetObjectTagEXT" ) );
          vkDebugMarkerSetObjectNameEXT = PFN_vkDebugMarkerSetObjectNameEXT( vkGetDeviceProcAddr( device, "vkDebugMarkerSetObjectNameEXT" ) );
          vkCmdDebugMarkerBeginEXT      = PFN_vkCmdDebugMarkerBeginEXT( vkGetDeviceProcAddr( device, "vkCmdDebugMarkerBeginEXT" ) );
          vkCmdDebugMarkerEndEXT        = PFN_vkCmdDebugMarkerEndEXT( vkGetDeviceProcAddr( device, "vkCmdDebugMarkerEndEXT" ) );
          vkCmdDebugMarkerInsertEXT     = PFN_vkCmdDebugMarkerInsertEXT( vkGetDeviceProcAddr( device, "vkCmdDebugMarkerInsertEXT" ) );

          //=== VK_KHR_video_queue ===
          vkCreateVideoSessionKHR  = PFN_vkCreateVideoSessionKHR( vkGetDeviceProcAddr( device, "vkCreateVideoSessionKHR" ) );
          vkDestroyVideoSessionKHR = PFN_vkDestroyVideoSessionKHR( vkGetDeviceProcAddr( device, "vkDestroyVideoSessionKHR" ) );
          vkGetVideoSessionMemoryRequirementsKHR =
            PFN_vkGetVideoSessionMemoryRequirementsKHR( vkGetDeviceProcAddr( device, "vkGetVideoSessionMemoryRequirementsKHR" ) );
          vkBindVideoSessionMemoryKHR        = PFN_vkBindVideoSessionMemoryKHR( vkGetDeviceProcAddr( device, "vkBindVideoSessionMemoryKHR" ) );
          vkCreateVideoSessionParametersKHR  = PFN_vkCreateVideoSessionParametersKHR( vkGetDeviceProcAddr( device, "vkCreateVideoSessionParametersKHR" ) );
          vkUpdateVideoSessionParametersKHR  = PFN_vkUpdateVideoSessionParametersKHR( vkGetDeviceProcAddr( device, "vkUpdateVideoSessionParametersKHR" ) );
          vkDestroyVideoSessionParametersKHR = PFN_vkDestroyVideoSessionParametersKHR( vkGetDeviceProcAddr( device, "vkDestroyVideoSessionParametersKHR" ) );
          vkCmdBeginVideoCodingKHR           = PFN_vkCmdBeginVideoCodingKHR( vkGetDeviceProcAddr( device, "vkCmdBeginVideoCodingKHR" ) );
          vkCmdEndVideoCodingKHR             = PFN_vkCmdEndVideoCodingKHR( vkGetDeviceProcAddr( device, "vkCmdEndVideoCodingKHR" ) );
          vkCmdControlVideoCodingKHR         = PFN_vkCmdControlVideoCodingKHR( vkGetDeviceProcAddr( device, "vkCmdControlVideoCodingKHR" ) );

          //=== VK_KHR_video_decode_queue ===
          vkCmdDecodeVideoKHR = PFN_vkCmdDecodeVideoKHR( vkGetDeviceProcAddr( device, "vkCmdDecodeVideoKHR" ) );

          //=== VK_EXT_transform_feedback ===
          vkCmdBindTransformFeedbackBuffersEXT =
            PFN_vkCmdBindTransformFeedbackBuffersEXT( vkGetDeviceProcAddr( device, "vkCmdBindTransformFeedbackBuffersEXT" ) );
          vkCmdBeginTransformFeedbackEXT = PFN_vkCmdBeginTransformFeedbackEXT( vkGetDeviceProcAddr( device, "vkCmdBeginTransformFeedbackEXT" ) );
          vkCmdEndTransformFeedbackEXT   = PFN_vkCmdEndTransformFeedbackEXT( vkGetDeviceProcAddr( device, "vkCmdEndTransformFeedbackEXT" ) );
          vkCmdBeginQueryIndexedEXT      = PFN_vkCmdBeginQueryIndexedEXT( vkGetDeviceProcAddr( device, "vkCmdBeginQueryIndexedEXT" ) );
          vkCmdEndQueryIndexedEXT        = PFN_vkCmdEndQueryIndexedEXT( vkGetDeviceProcAddr( device, "vkCmdEndQueryIndexedEXT" ) );
          vkCmdDrawIndirectByteCountEXT  = PFN_vkCmdDrawIndirectByteCountEXT( vkGetDeviceProcAddr( device, "vkCmdDrawIndirectByteCountEXT" ) );

          //=== VK_NVX_binary_import ===
          vkCreateCuModuleNVX    = PFN_vkCreateCuModuleNVX( vkGetDeviceProcAddr( device, "vkCreateCuModuleNVX" ) );
          vkCreateCuFunctionNVX  = PFN_vkCreateCuFunctionNVX( vkGetDeviceProcAddr( device, "vkCreateCuFunctionNVX" ) );
          vkDestroyCuModuleNVX   = PFN_vkDestroyCuModuleNVX( vkGetDeviceProcAddr( device, "vkDestroyCuModuleNVX" ) );
          vkDestroyCuFunctionNVX = PFN_vkDestroyCuFunctionNVX( vkGetDeviceProcAddr( device, "vkDestroyCuFunctionNVX" ) );
          vkCmdCuLaunchKernelNVX = PFN_vkCmdCuLaunchKernelNVX( vkGetDeviceProcAddr( device, "vkCmdCuLaunchKernelNVX" ) );

          //=== VK_NVX_image_view_handle ===
          vkGetImageViewHandleNVX   = PFN_vkGetImageViewHandleNVX( vkGetDeviceProcAddr( device, "vkGetImageViewHandleNVX" ) );
          vkGetImageViewHandle64NVX = PFN_vkGetImageViewHandle64NVX( vkGetDeviceProcAddr( device, "vkGetImageViewHandle64NVX" ) );
          vkGetImageViewAddressNVX  = PFN_vkGetImageViewAddressNVX( vkGetDeviceProcAddr( device, "vkGetImageViewAddressNVX" ) );

          //=== VK_AMD_draw_indirect_count ===
          vkCmdDrawIndirectCountAMD = PFN_vkCmdDrawIndirectCountAMD( vkGetDeviceProcAddr( device, "vkCmdDrawIndirectCountAMD" ) );
          if ( !vkCmdDrawIndirectCount )
            vkCmdDrawIndirectCount = vkCmdDrawIndirectCountAMD;
          vkCmdDrawIndexedIndirectCountAMD = PFN_vkCmdDrawIndexedIndirectCountAMD( vkGetDeviceProcAddr( device, "vkCmdDrawIndexedIndirectCountAMD" ) );
          if ( !vkCmdDrawIndexedIndirectCount )
            vkCmdDrawIndexedIndirectCount = vkCmdDrawIndexedIndirectCountAMD;

          //=== VK_AMD_shader_info ===
          vkGetShaderInfoAMD = PFN_vkGetShaderInfoAMD( vkGetDeviceProcAddr( device, "vkGetShaderInfoAMD" ) );

          //=== VK_KHR_dynamic_rendering ===
          vkCmdBeginRenderingKHR = PFN_vkCmdBeginRenderingKHR( vkGetDeviceProcAddr( device, "vkCmdBeginRenderingKHR" ) );
          if ( !vkCmdBeginRendering )
            vkCmdBeginRendering = vkCmdBeginRenderingKHR;
          vkCmdEndRenderingKHR = PFN_vkCmdEndRenderingKHR( vkGetDeviceProcAddr( device, "vkCmdEndRenderingKHR" ) );
          if ( !vkCmdEndRendering )
            vkCmdEndRendering = vkCmdEndRenderingKHR;

#  if defined( VK_USE_PLATFORM_WIN32_KHR )
          //=== VK_NV_external_memory_win32 ===
          vkGetMemoryWin32HandleNV = PFN_vkGetMemoryWin32HandleNV( vkGetDeviceProcAddr( device, "vkGetMemoryWin32HandleNV" ) );
#  endif /*VK_USE_PLATFORM_WIN32_KHR*/

          //=== VK_KHR_device_group ===
          vkGetDeviceGroupPeerMemoryFeaturesKHR =
            PFN_vkGetDeviceGroupPeerMemoryFeaturesKHR( vkGetDeviceProcAddr( device, "vkGetDeviceGroupPeerMemoryFeaturesKHR" ) );
          if ( !vkGetDeviceGroupPeerMemoryFeatures )
            vkGetDeviceGroupPeerMemoryFeatures = vkGetDeviceGroupPeerMemoryFeaturesKHR;
          vkCmdSetDeviceMaskKHR = PFN_vkCmdSetDeviceMaskKHR( vkGetDeviceProcAddr( device, "vkCmdSetDeviceMaskKHR" ) );
          if ( !vkCmdSetDeviceMask )
            vkCmdSetDeviceMask = vkCmdSetDeviceMaskKHR;
          vkCmdDispatchBaseKHR = PFN_vkCmdDispatchBaseKHR( vkGetDeviceProcAddr( device, "vkCmdDispatchBaseKHR" ) );
          if ( !vkCmdDispatchBase )
            vkCmdDispatchBase = vkCmdDispatchBaseKHR;

          //=== VK_KHR_maintenance1 ===
          vkTrimCommandPoolKHR = PFN_vkTrimCommandPoolKHR( vkGetDeviceProcAddr( device, "vkTrimCommandPoolKHR" ) );
          if ( !vkTrimCommandPool )
            vkTrimCommandPool = vkTrimCommandPoolKHR;

#  if defined( VK_USE_PLATFORM_WIN32_KHR )
          //=== VK_KHR_external_memory_win32 ===
          vkGetMemoryWin32HandleKHR           = PFN_vkGetMemoryWin32HandleKHR( vkGetDeviceProcAddr( device, "vkGetMemoryWin32HandleKHR" ) );
          vkGetMemoryWin32HandlePropertiesKHR = PFN_vkGetMemoryWin32HandlePropertiesKHR( vkGetDeviceProcAddr( device, "vkGetMemoryWin32HandlePropertiesKHR" ) );
#  endif /*VK_USE_PLATFORM_WIN32_KHR*/

          //=== VK_KHR_external_memory_fd ===
          vkGetMemoryFdKHR           = PFN_vkGetMemoryFdKHR( vkGetDeviceProcAddr( device, "vkGetMemoryFdKHR" ) );
          vkGetMemoryFdPropertiesKHR = PFN_vkGetMemoryFdPropertiesKHR( vkGetDeviceProcAddr( device, "vkGetMemoryFdPropertiesKHR" ) );

#  if defined( VK_USE_PLATFORM_WIN32_KHR )
          //=== VK_KHR_external_semaphore_win32 ===
          vkImportSemaphoreWin32HandleKHR = PFN_vkImportSemaphoreWin32HandleKHR( vkGetDeviceProcAddr( device, "vkImportSemaphoreWin32HandleKHR" ) );
          vkGetSemaphoreWin32HandleKHR    = PFN_vkGetSemaphoreWin32HandleKHR( vkGetDeviceProcAddr( device, "vkGetSemaphoreWin32HandleKHR" ) );
#  endif /*VK_USE_PLATFORM_WIN32_KHR*/

          //=== VK_KHR_external_semaphore_fd ===
          vkImportSemaphoreFdKHR = PFN_vkImportSemaphoreFdKHR( vkGetDeviceProcAddr( device, "vkImportSemaphoreFdKHR" ) );
          vkGetSemaphoreFdKHR    = PFN_vkGetSemaphoreFdKHR( vkGetDeviceProcAddr( device, "vkGetSemaphoreFdKHR" ) );

          //=== VK_KHR_push_descriptor ===
          vkCmdPushDescriptorSetKHR = PFN_vkCmdPushDescriptorSetKHR( vkGetDeviceProcAddr( device, "vkCmdPushDescriptorSetKHR" ) );
          if ( !vkCmdPushDescriptorSet )
            vkCmdPushDescriptorSet = vkCmdPushDescriptorSetKHR;
          vkCmdPushDescriptorSetWithTemplateKHR =
            PFN_vkCmdPushDescriptorSetWithTemplateKHR( vkGetDeviceProcAddr( device, "vkCmdPushDescriptorSetWithTemplateKHR" ) );
          if ( !vkCmdPushDescriptorSetWithTemplate )
            vkCmdPushDescriptorSetWithTemplate = vkCmdPushDescriptorSetWithTemplateKHR;

          //=== VK_EXT_conditional_rendering ===
          vkCmdBeginConditionalRenderingEXT = PFN_vkCmdBeginConditionalRenderingEXT( vkGetDeviceProcAddr( device, "vkCmdBeginConditionalRenderingEXT" ) );
          vkCmdEndConditionalRenderingEXT   = PFN_vkCmdEndConditionalRenderingEXT( vkGetDeviceProcAddr( device, "vkCmdEndConditionalRenderingEXT" ) );

          //=== VK_KHR_descriptor_update_template ===
          vkCreateDescriptorUpdateTemplateKHR = PFN_vkCreateDescriptorUpdateTemplateKHR( vkGetDeviceProcAddr( device, "vkCreateDescriptorUpdateTemplateKHR" ) );
          if ( !vkCreateDescriptorUpdateTemplate )
            vkCreateDescriptorUpdateTemplate = vkCreateDescriptorUpdateTemplateKHR;
          vkDestroyDescriptorUpdateTemplateKHR =
            PFN_vkDestroyDescriptorUpdateTemplateKHR( vkGetDeviceProcAddr( device, "vkDestroyDescriptorUpdateTemplateKHR" ) );
          if ( !vkDestroyDescriptorUpdateTemplate )
            vkDestroyDescriptorUpdateTemplate = vkDestroyDescriptorUpdateTemplateKHR;
          vkUpdateDescriptorSetWithTemplateKHR =
            PFN_vkUpdateDescriptorSetWithTemplateKHR( vkGetDeviceProcAddr( device, "vkUpdateDescriptorSetWithTemplateKHR" ) );
          if ( !vkUpdateDescriptorSetWithTemplate )
            vkUpdateDescriptorSetWithTemplate = vkUpdateDescriptorSetWithTemplateKHR;

          //=== VK_NV_clip_space_w_scaling ===
          vkCmdSetViewportWScalingNV = PFN_vkCmdSetViewportWScalingNV( vkGetDeviceProcAddr( device, "vkCmdSetViewportWScalingNV" ) );

          //=== VK_EXT_display_control ===
          vkDisplayPowerControlEXT  = PFN_vkDisplayPowerControlEXT( vkGetDeviceProcAddr( device, "vkDisplayPowerControlEXT" ) );
          vkRegisterDeviceEventEXT  = PFN_vkRegisterDeviceEventEXT( vkGetDeviceProcAddr( device, "vkRegisterDeviceEventEXT" ) );
          vkRegisterDisplayEventEXT = PFN_vkRegisterDisplayEventEXT( vkGetDeviceProcAddr( device, "vkRegisterDisplayEventEXT" ) );
          vkGetSwapchainCounterEXT  = PFN_vkGetSwapchainCounterEXT( vkGetDeviceProcAddr( device, "vkGetSwapchainCounterEXT" ) );

          //=== VK_GOOGLE_display_timing ===
          vkGetRefreshCycleDurationGOOGLE   = PFN_vkGetRefreshCycleDurationGOOGLE( vkGetDeviceProcAddr( device, "vkGetRefreshCycleDurationGOOGLE" ) );
          vkGetPastPresentationTimingGOOGLE = PFN_vkGetPastPresentationTimingGOOGLE( vkGetDeviceProcAddr( device, "vkGetPastPresentationTimingGOOGLE" ) );

          //=== VK_EXT_discard_rectangles ===
          vkCmdSetDiscardRectangleEXT       = PFN_vkCmdSetDiscardRectangleEXT( vkGetDeviceProcAddr( device, "vkCmdSetDiscardRectangleEXT" ) );
          vkCmdSetDiscardRectangleEnableEXT = PFN_vkCmdSetDiscardRectangleEnableEXT( vkGetDeviceProcAddr( device, "vkCmdSetDiscardRectangleEnableEXT" ) );
          vkCmdSetDiscardRectangleModeEXT   = PFN_vkCmdSetDiscardRectangleModeEXT( vkGetDeviceProcAddr( device, "vkCmdSetDiscardRectangleModeEXT" ) );

          //=== VK_EXT_hdr_metadata ===
          vkSetHdrMetadataEXT = PFN_vkSetHdrMetadataEXT( vkGetDeviceProcAddr( device, "vkSetHdrMetadataEXT" ) );

          //=== VK_KHR_create_renderpass2 ===
          vkCreateRenderPass2KHR = PFN_vkCreateRenderPass2KHR( vkGetDeviceProcAddr( device, "vkCreateRenderPass2KHR" ) );
          if ( !vkCreateRenderPass2 )
            vkCreateRenderPass2 = vkCreateRenderPass2KHR;
          vkCmdBeginRenderPass2KHR = PFN_vkCmdBeginRenderPass2KHR( vkGetDeviceProcAddr( device, "vkCmdBeginRenderPass2KHR" ) );
          if ( !vkCmdBeginRenderPass2 )
            vkCmdBeginRenderPass2 = vkCmdBeginRenderPass2KHR;
          vkCmdNextSubpass2KHR = PFN_vkCmdNextSubpass2KHR( vkGetDeviceProcAddr( device, "vkCmdNextSubpass2KHR" ) );
          if ( !vkCmdNextSubpass2 )
            vkCmdNextSubpass2 = vkCmdNextSubpass2KHR;
          vkCmdEndRenderPass2KHR = PFN_vkCmdEndRenderPass2KHR( vkGetDeviceProcAddr( device, "vkCmdEndRenderPass2KHR" ) );
          if ( !vkCmdEndRenderPass2 )
            vkCmdEndRenderPass2 = vkCmdEndRenderPass2KHR;

          //=== VK_KHR_shared_presentable_image ===
          vkGetSwapchainStatusKHR = PFN_vkGetSwapchainStatusKHR( vkGetDeviceProcAddr( device, "vkGetSwapchainStatusKHR" ) );

#  if defined( VK_USE_PLATFORM_WIN32_KHR )
          //=== VK_KHR_external_fence_win32 ===
          vkImportFenceWin32HandleKHR = PFN_vkImportFenceWin32HandleKHR( vkGetDeviceProcAddr( device, "vkImportFenceWin32HandleKHR" ) );
          vkGetFenceWin32HandleKHR    = PFN_vkGetFenceWin32HandleKHR( vkGetDeviceProcAddr( device, "vkGetFenceWin32HandleKHR" ) );
#  endif /*VK_USE_PLATFORM_WIN32_KHR*/

          //=== VK_KHR_external_fence_fd ===
          vkImportFenceFdKHR = PFN_vkImportFenceFdKHR( vkGetDeviceProcAddr( device, "vkImportFenceFdKHR" ) );
          vkGetFenceFdKHR    = PFN_vkGetFenceFdKHR( vkGetDeviceProcAddr( device, "vkGetFenceFdKHR" ) );

          //=== VK_KHR_performance_query ===
          vkAcquireProfilingLockKHR = PFN_vkAcquireProfilingLockKHR( vkGetDeviceProcAddr( device, "vkAcquireProfilingLockKHR" ) );
          vkReleaseProfilingLockKHR = PFN_vkReleaseProfilingLockKHR( vkGetDeviceProcAddr( device, "vkReleaseProfilingLockKHR" ) );

          //=== VK_EXT_debug_utils ===
          vkSetDebugUtilsObjectNameEXT    = PFN_vkSetDebugUtilsObjectNameEXT( vkGetDeviceProcAddr( device, "vkSetDebugUtilsObjectNameEXT" ) );
          vkSetDebugUtilsObjectTagEXT     = PFN_vkSetDebugUtilsObjectTagEXT( vkGetDeviceProcAddr( device, "vkSetDebugUtilsObjectTagEXT" ) );
          vkQueueBeginDebugUtilsLabelEXT  = PFN_vkQueueBeginDebugUtilsLabelEXT( vkGetDeviceProcAddr( device, "vkQueueBeginDebugUtilsLabelEXT" ) );
          vkQueueEndDebugUtilsLabelEXT    = PFN_vkQueueEndDebugUtilsLabelEXT( vkGetDeviceProcAddr( device, "vkQueueEndDebugUtilsLabelEXT" ) );
          vkQueueInsertDebugUtilsLabelEXT = PFN_vkQueueInsertDebugUtilsLabelEXT( vkGetDeviceProcAddr( device, "vkQueueInsertDebugUtilsLabelEXT" ) );
          vkCmdBeginDebugUtilsLabelEXT    = PFN_vkCmdBeginDebugUtilsLabelEXT( vkGetDeviceProcAddr( device, "vkCmdBeginDebugUtilsLabelEXT" ) );
          vkCmdEndDebugUtilsLabelEXT      = PFN_vkCmdEndDebugUtilsLabelEXT( vkGetDeviceProcAddr( device, "vkCmdEndDebugUtilsLabelEXT" ) );
          vkCmdInsertDebugUtilsLabelEXT   = PFN_vkCmdInsertDebugUtilsLabelEXT( vkGetDeviceProcAddr( device, "vkCmdInsertDebugUtilsLabelEXT" ) );

#  if defined( VK_USE_PLATFORM_ANDROID_KHR )
          //=== VK_ANDROID_external_memory_android_hardware_buffer ===
          vkGetAndroidHardwareBufferPropertiesANDROID =
            PFN_vkGetAndroidHardwareBufferPropertiesANDROID( vkGetDeviceProcAddr( device, "vkGetAndroidHardwareBufferPropertiesANDROID" ) );
          vkGetMemoryAndroidHardwareBufferANDROID =
            PFN_vkGetMemoryAndroidHardwareBufferANDROID( vkGetDeviceProcAddr( device, "vkGetMemoryAndroidHardwareBufferANDROID" ) );
#  endif /*VK_USE_PLATFORM_ANDROID_KHR*/

#  if defined( VK_ENABLE_BETA_EXTENSIONS )
          //=== VK_AMDX_shader_enqueue ===
          vkCreateExecutionGraphPipelinesAMDX = PFN_vkCreateExecutionGraphPipelinesAMDX( vkGetDeviceProcAddr( device, "vkCreateExecutionGraphPipelinesAMDX" ) );
          vkGetExecutionGraphPipelineScratchSizeAMDX =
            PFN_vkGetExecutionGraphPipelineScratchSizeAMDX( vkGetDeviceProcAddr( device, "vkGetExecutionGraphPipelineScratchSizeAMDX" ) );
          vkGetExecutionGraphPipelineNodeIndexAMDX =
            PFN_vkGetExecutionGraphPipelineNodeIndexAMDX( vkGetDeviceProcAddr( device, "vkGetExecutionGraphPipelineNodeIndexAMDX" ) );
          vkCmdInitializeGraphScratchMemoryAMDX =
            PFN_vkCmdInitializeGraphScratchMemoryAMDX( vkGetDeviceProcAddr( device, "vkCmdInitializeGraphScratchMemoryAMDX" ) );
          vkCmdDispatchGraphAMDX              = PFN_vkCmdDispatchGraphAMDX( vkGetDeviceProcAddr( device, "vkCmdDispatchGraphAMDX" ) );
          vkCmdDispatchGraphIndirectAMDX      = PFN_vkCmdDispatchGraphIndirectAMDX( vkGetDeviceProcAddr( device, "vkCmdDispatchGraphIndirectAMDX" ) );
          vkCmdDispatchGraphIndirectCountAMDX = PFN_vkCmdDispatchGraphIndirectCountAMDX( vkGetDeviceProcAddr( device, "vkCmdDispatchGraphIndirectCountAMDX" ) );
#  endif /*VK_ENABLE_BETA_EXTENSIONS*/

          //=== VK_EXT_sample_locations ===
          vkCmdSetSampleLocationsEXT = PFN_vkCmdSetSampleLocationsEXT( vkGetDeviceProcAddr( device, "vkCmdSetSampleLocationsEXT" ) );

          //=== VK_KHR_get_memory_requirements2 ===
          vkGetImageMemoryRequirements2KHR = PFN_vkGetImageMemoryRequirements2KHR( vkGetDeviceProcAddr( device, "vkGetImageMemoryRequirements2KHR" ) );
          if ( !vkGetImageMemoryRequirements2 )
            vkGetImageMemoryRequirements2 = vkGetImageMemoryRequirements2KHR;
          vkGetBufferMemoryRequirements2KHR = PFN_vkGetBufferMemoryRequirements2KHR( vkGetDeviceProcAddr( device, "vkGetBufferMemoryRequirements2KHR" ) );
          if ( !vkGetBufferMemoryRequirements2 )
            vkGetBufferMemoryRequirements2 = vkGetBufferMemoryRequirements2KHR;
          vkGetImageSparseMemoryRequirements2KHR =
            PFN_vkGetImageSparseMemoryRequirements2KHR( vkGetDeviceProcAddr( device, "vkGetImageSparseMemoryRequirements2KHR" ) );
          if ( !vkGetImageSparseMemoryRequirements2 )
            vkGetImageSparseMemoryRequirements2 = vkGetImageSparseMemoryRequirements2KHR;

          //=== VK_KHR_acceleration_structure ===
          vkCreateAccelerationStructureKHR    = PFN_vkCreateAccelerationStructureKHR( vkGetDeviceProcAddr( device, "vkCreateAccelerationStructureKHR" ) );
          vkDestroyAccelerationStructureKHR   = PFN_vkDestroyAccelerationStructureKHR( vkGetDeviceProcAddr( device, "vkDestroyAccelerationStructureKHR" ) );
          vkCmdBuildAccelerationStructuresKHR = PFN_vkCmdBuildAccelerationStructuresKHR( vkGetDeviceProcAddr( device, "vkCmdBuildAccelerationStructuresKHR" ) );
          vkCmdBuildAccelerationStructuresIndirectKHR =
            PFN_vkCmdBuildAccelerationStructuresIndirectKHR( vkGetDeviceProcAddr( device, "vkCmdBuildAccelerationStructuresIndirectKHR" ) );
          vkBuildAccelerationStructuresKHR = PFN_vkBuildAccelerationStructuresKHR( vkGetDeviceProcAddr( device, "vkBuildAccelerationStructuresKHR" ) );
          vkCopyAccelerationStructureKHR   = PFN_vkCopyAccelerationStructureKHR( vkGetDeviceProcAddr( device, "vkCopyAccelerationStructureKHR" ) );
          vkCopyAccelerationStructureToMemoryKHR =
            PFN_vkCopyAccelerationStructureToMemoryKHR( vkGetDeviceProcAddr( device, "vkCopyAccelerationStructureToMemoryKHR" ) );
          vkCopyMemoryToAccelerationStructureKHR =
            PFN_vkCopyMemoryToAccelerationStructureKHR( vkGetDeviceProcAddr( device, "vkCopyMemoryToAccelerationStructureKHR" ) );
          vkWriteAccelerationStructuresPropertiesKHR =
            PFN_vkWriteAccelerationStructuresPropertiesKHR( vkGetDeviceProcAddr( device, "vkWriteAccelerationStructuresPropertiesKHR" ) );
          vkCmdCopyAccelerationStructureKHR = PFN_vkCmdCopyAccelerationStructureKHR( vkGetDeviceProcAddr( device, "vkCmdCopyAccelerationStructureKHR" ) );
          vkCmdCopyAccelerationStructureToMemoryKHR =
            PFN_vkCmdCopyAccelerationStructureToMemoryKHR( vkGetDeviceProcAddr( device, "vkCmdCopyAccelerationStructureToMemoryKHR" ) );
          vkCmdCopyMemoryToAccelerationStructureKHR =
            PFN_vkCmdCopyMemoryToAccelerationStructureKHR( vkGetDeviceProcAddr( device, "vkCmdCopyMemoryToAccelerationStructureKHR" ) );
          vkGetAccelerationStructureDeviceAddressKHR =
            PFN_vkGetAccelerationStructureDeviceAddressKHR( vkGetDeviceProcAddr( device, "vkGetAccelerationStructureDeviceAddressKHR" ) );
          vkCmdWriteAccelerationStructuresPropertiesKHR =
            PFN_vkCmdWriteAccelerationStructuresPropertiesKHR( vkGetDeviceProcAddr( device, "vkCmdWriteAccelerationStructuresPropertiesKHR" ) );
          vkGetDeviceAccelerationStructureCompatibilityKHR =
            PFN_vkGetDeviceAccelerationStructureCompatibilityKHR( vkGetDeviceProcAddr( device, "vkGetDeviceAccelerationStructureCompatibilityKHR" ) );
          vkGetAccelerationStructureBuildSizesKHR =
            PFN_vkGetAccelerationStructureBuildSizesKHR( vkGetDeviceProcAddr( device, "vkGetAccelerationStructureBuildSizesKHR" ) );

          //=== VK_KHR_ray_tracing_pipeline ===
          vkCmdTraceRaysKHR              = PFN_vkCmdTraceRaysKHR( vkGetDeviceProcAddr( device, "vkCmdTraceRaysKHR" ) );
          vkCreateRayTracingPipelinesKHR = PFN_vkCreateRayTracingPipelinesKHR( vkGetDeviceProcAddr( device, "vkCreateRayTracingPipelinesKHR" ) );
          vkGetRayTracingShaderGroupHandlesKHR =
            PFN_vkGetRayTracingShaderGroupHandlesKHR( vkGetDeviceProcAddr( device, "vkGetRayTracingShaderGroupHandlesKHR" ) );
          vkGetRayTracingCaptureReplayShaderGroupHandlesKHR =
            PFN_vkGetRayTracingCaptureReplayShaderGroupHandlesKHR( vkGetDeviceProcAddr( device, "vkGetRayTracingCaptureReplayShaderGroupHandlesKHR" ) );
          vkCmdTraceRaysIndirectKHR = PFN_vkCmdTraceRaysIndirectKHR( vkGetDeviceProcAddr( device, "vkCmdTraceRaysIndirectKHR" ) );
          vkGetRayTracingShaderGroupStackSizeKHR =
            PFN_vkGetRayTracingShaderGroupStackSizeKHR( vkGetDeviceProcAddr( device, "vkGetRayTracingShaderGroupStackSizeKHR" ) );
          vkCmdSetRayTracingPipelineStackSizeKHR =
            PFN_vkCmdSetRayTracingPipelineStackSizeKHR( vkGetDeviceProcAddr( device, "vkCmdSetRayTracingPipelineStackSizeKHR" ) );

          //=== VK_KHR_sampler_ycbcr_conversion ===
          vkCreateSamplerYcbcrConversionKHR = PFN_vkCreateSamplerYcbcrConversionKHR( vkGetDeviceProcAddr( device, "vkCreateSamplerYcbcrConversionKHR" ) );
          if ( !vkCreateSamplerYcbcrConversion )
            vkCreateSamplerYcbcrConversion = vkCreateSamplerYcbcrConversionKHR;
          vkDestroySamplerYcbcrConversionKHR = PFN_vkDestroySamplerYcbcrConversionKHR( vkGetDeviceProcAddr( device, "vkDestroySamplerYcbcrConversionKHR" ) );
          if ( !vkDestroySamplerYcbcrConversion )
            vkDestroySamplerYcbcrConversion = vkDestroySamplerYcbcrConversionKHR;

          //=== VK_KHR_bind_memory2 ===
          vkBindBufferMemory2KHR = PFN_vkBindBufferMemory2KHR( vkGetDeviceProcAddr( device, "vkBindBufferMemory2KHR" ) );
          if ( !vkBindBufferMemory2 )
            vkBindBufferMemory2 = vkBindBufferMemory2KHR;
          vkBindImageMemory2KHR = PFN_vkBindImageMemory2KHR( vkGetDeviceProcAddr( device, "vkBindImageMemory2KHR" ) );
          if ( !vkBindImageMemory2 )
            vkBindImageMemory2 = vkBindImageMemory2KHR;

          //=== VK_EXT_image_drm_format_modifier ===
          vkGetImageDrmFormatModifierPropertiesEXT =
            PFN_vkGetImageDrmFormatModifierPropertiesEXT( vkGetDeviceProcAddr( device, "vkGetImageDrmFormatModifierPropertiesEXT" ) );

          //=== VK_EXT_validation_cache ===
          vkCreateValidationCacheEXT  = PFN_vkCreateValidationCacheEXT( vkGetDeviceProcAddr( device, "vkCreateValidationCacheEXT" ) );
          vkDestroyValidationCacheEXT = PFN_vkDestroyValidationCacheEXT( vkGetDeviceProcAddr( device, "vkDestroyValidationCacheEXT" ) );
          vkMergeValidationCachesEXT  = PFN_vkMergeValidationCachesEXT( vkGetDeviceProcAddr( device, "vkMergeValidationCachesEXT" ) );
          vkGetValidationCacheDataEXT = PFN_vkGetValidationCacheDataEXT( vkGetDeviceProcAddr( device, "vkGetValidationCacheDataEXT" ) );

          //=== VK_NV_shading_rate_image ===
          vkCmdBindShadingRateImageNV = PFN_vkCmdBindShadingRateImageNV( vkGetDeviceProcAddr( device, "vkCmdBindShadingRateImageNV" ) );
          vkCmdSetViewportShadingRatePaletteNV =
            PFN_vkCmdSetViewportShadingRatePaletteNV( vkGetDeviceProcAddr( device, "vkCmdSetViewportShadingRatePaletteNV" ) );
          vkCmdSetCoarseSampleOrderNV = PFN_vkCmdSetCoarseSampleOrderNV( vkGetDeviceProcAddr( device, "vkCmdSetCoarseSampleOrderNV" ) );

          //=== VK_NV_ray_tracing ===
          vkCreateAccelerationStructureNV  = PFN_vkCreateAccelerationStructureNV( vkGetDeviceProcAddr( device, "vkCreateAccelerationStructureNV" ) );
          vkDestroyAccelerationStructureNV = PFN_vkDestroyAccelerationStructureNV( vkGetDeviceProcAddr( device, "vkDestroyAccelerationStructureNV" ) );
          vkGetAccelerationStructureMemoryRequirementsNV =
            PFN_vkGetAccelerationStructureMemoryRequirementsNV( vkGetDeviceProcAddr( device, "vkGetAccelerationStructureMemoryRequirementsNV" ) );
          vkBindAccelerationStructureMemoryNV = PFN_vkBindAccelerationStructureMemoryNV( vkGetDeviceProcAddr( device, "vkBindAccelerationStructureMemoryNV" ) );
          vkCmdBuildAccelerationStructureNV   = PFN_vkCmdBuildAccelerationStructureNV( vkGetDeviceProcAddr( device, "vkCmdBuildAccelerationStructureNV" ) );
          vkCmdCopyAccelerationStructureNV    = PFN_vkCmdCopyAccelerationStructureNV( vkGetDeviceProcAddr( device, "vkCmdCopyAccelerationStructureNV" ) );
          vkCmdTraceRaysNV                    = PFN_vkCmdTraceRaysNV( vkGetDeviceProcAddr( device, "vkCmdTraceRaysNV" ) );
          vkCreateRayTracingPipelinesNV       = PFN_vkCreateRayTracingPipelinesNV( vkGetDeviceProcAddr( device, "vkCreateRayTracingPipelinesNV" ) );
          vkGetRayTracingShaderGroupHandlesNV = PFN_vkGetRayTracingShaderGroupHandlesNV( vkGetDeviceProcAddr( device, "vkGetRayTracingShaderGroupHandlesNV" ) );
          if ( !vkGetRayTracingShaderGroupHandlesKHR )
            vkGetRayTracingShaderGroupHandlesKHR = vkGetRayTracingShaderGroupHandlesNV;
          vkGetAccelerationStructureHandleNV = PFN_vkGetAccelerationStructureHandleNV( vkGetDeviceProcAddr( device, "vkGetAccelerationStructureHandleNV" ) );
          vkCmdWriteAccelerationStructuresPropertiesNV =
            PFN_vkCmdWriteAccelerationStructuresPropertiesNV( vkGetDeviceProcAddr( device, "vkCmdWriteAccelerationStructuresPropertiesNV" ) );
          vkCompileDeferredNV = PFN_vkCompileDeferredNV( vkGetDeviceProcAddr( device, "vkCompileDeferredNV" ) );

          //=== VK_KHR_maintenance3 ===
          vkGetDescriptorSetLayoutSupportKHR = PFN_vkGetDescriptorSetLayoutSupportKHR( vkGetDeviceProcAddr( device, "vkGetDescriptorSetLayoutSupportKHR" ) );
          if ( !vkGetDescriptorSetLayoutSupport )
            vkGetDescriptorSetLayoutSupport = vkGetDescriptorSetLayoutSupportKHR;

          //=== VK_KHR_draw_indirect_count ===
          vkCmdDrawIndirectCountKHR = PFN_vkCmdDrawIndirectCountKHR( vkGetDeviceProcAddr( device, "vkCmdDrawIndirectCountKHR" ) );
          if ( !vkCmdDrawIndirectCount )
            vkCmdDrawIndirectCount = vkCmdDrawIndirectCountKHR;
          vkCmdDrawIndexedIndirectCountKHR = PFN_vkCmdDrawIndexedIndirectCountKHR( vkGetDeviceProcAddr( device, "vkCmdDrawIndexedIndirectCountKHR" ) );
          if ( !vkCmdDrawIndexedIndirectCount )
            vkCmdDrawIndexedIndirectCount = vkCmdDrawIndexedIndirectCountKHR;

          //=== VK_EXT_external_memory_host ===
          vkGetMemoryHostPointerPropertiesEXT = PFN_vkGetMemoryHostPointerPropertiesEXT( vkGetDeviceProcAddr( device, "vkGetMemoryHostPointerPropertiesEXT" ) );

          //=== VK_AMD_buffer_marker ===
          vkCmdWriteBufferMarkerAMD  = PFN_vkCmdWriteBufferMarkerAMD( vkGetDeviceProcAddr( device, "vkCmdWriteBufferMarkerAMD" ) );
          vkCmdWriteBufferMarker2AMD = PFN_vkCmdWriteBufferMarker2AMD( vkGetDeviceProcAddr( device, "vkCmdWriteBufferMarker2AMD" ) );

          //=== VK_EXT_calibrated_timestamps ===
          vkGetCalibratedTimestampsEXT = PFN_vkGetCalibratedTimestampsEXT( vkGetDeviceProcAddr( device, "vkGetCalibratedTimestampsEXT" ) );
          if ( !vkGetCalibratedTimestampsKHR )
            vkGetCalibratedTimestampsKHR = vkGetCalibratedTimestampsEXT;

          //=== VK_NV_mesh_shader ===
          vkCmdDrawMeshTasksNV              = PFN_vkCmdDrawMeshTasksNV( vkGetDeviceProcAddr( device, "vkCmdDrawMeshTasksNV" ) );
          vkCmdDrawMeshTasksIndirectNV      = PFN_vkCmdDrawMeshTasksIndirectNV( vkGetDeviceProcAddr( device, "vkCmdDrawMeshTasksIndirectNV" ) );
          vkCmdDrawMeshTasksIndirectCountNV = PFN_vkCmdDrawMeshTasksIndirectCountNV( vkGetDeviceProcAddr( device, "vkCmdDrawMeshTasksIndirectCountNV" ) );

          //=== VK_NV_scissor_exclusive ===
          vkCmdSetExclusiveScissorEnableNV = PFN_vkCmdSetExclusiveScissorEnableNV( vkGetDeviceProcAddr( device, "vkCmdSetExclusiveScissorEnableNV" ) );
          vkCmdSetExclusiveScissorNV       = PFN_vkCmdSetExclusiveScissorNV( vkGetDeviceProcAddr( device, "vkCmdSetExclusiveScissorNV" ) );

          //=== VK_NV_device_diagnostic_checkpoints ===
          vkCmdSetCheckpointNV        = PFN_vkCmdSetCheckpointNV( vkGetDeviceProcAddr( device, "vkCmdSetCheckpointNV" ) );
          vkGetQueueCheckpointDataNV  = PFN_vkGetQueueCheckpointDataNV( vkGetDeviceProcAddr( device, "vkGetQueueCheckpointDataNV" ) );
          vkGetQueueCheckpointData2NV = PFN_vkGetQueueCheckpointData2NV( vkGetDeviceProcAddr( device, "vkGetQueueCheckpointData2NV" ) );

          //=== VK_KHR_timeline_semaphore ===
          vkGetSemaphoreCounterValueKHR = PFN_vkGetSemaphoreCounterValueKHR( vkGetDeviceProcAddr( device, "vkGetSemaphoreCounterValueKHR" ) );
          if ( !vkGetSemaphoreCounterValue )
            vkGetSemaphoreCounterValue = vkGetSemaphoreCounterValueKHR;
          vkWaitSemaphoresKHR = PFN_vkWaitSemaphoresKHR( vkGetDeviceProcAddr( device, "vkWaitSemaphoresKHR" ) );
          if ( !vkWaitSemaphores )
            vkWaitSemaphores = vkWaitSemaphoresKHR;
          vkSignalSemaphoreKHR = PFN_vkSignalSemaphoreKHR( vkGetDeviceProcAddr( device, "vkSignalSemaphoreKHR" ) );
          if ( !vkSignalSemaphore )
            vkSignalSemaphore = vkSignalSemaphoreKHR;

          //=== VK_INTEL_performance_query ===
          vkInitializePerformanceApiINTEL   = PFN_vkInitializePerformanceApiINTEL( vkGetDeviceProcAddr( device, "vkInitializePerformanceApiINTEL" ) );
          vkUninitializePerformanceApiINTEL = PFN_vkUninitializePerformanceApiINTEL( vkGetDeviceProcAddr( device, "vkUninitializePerformanceApiINTEL" ) );
          vkCmdSetPerformanceMarkerINTEL    = PFN_vkCmdSetPerformanceMarkerINTEL( vkGetDeviceProcAddr( device, "vkCmdSetPerformanceMarkerINTEL" ) );
          vkCmdSetPerformanceStreamMarkerINTEL =
            PFN_vkCmdSetPerformanceStreamMarkerINTEL( vkGetDeviceProcAddr( device, "vkCmdSetPerformanceStreamMarkerINTEL" ) );
          vkCmdSetPerformanceOverrideINTEL = PFN_vkCmdSetPerformanceOverrideINTEL( vkGetDeviceProcAddr( device, "vkCmdSetPerformanceOverrideINTEL" ) );
          vkAcquirePerformanceConfigurationINTEL =
            PFN_vkAcquirePerformanceConfigurationINTEL( vkGetDeviceProcAddr( device, "vkAcquirePerformanceConfigurationINTEL" ) );
          vkReleasePerformanceConfigurationINTEL =
            PFN_vkReleasePerformanceConfigurationINTEL( vkGetDeviceProcAddr( device, "vkReleasePerformanceConfigurationINTEL" ) );
          vkQueueSetPerformanceConfigurationINTEL =
            PFN_vkQueueSetPerformanceConfigurationINTEL( vkGetDeviceProcAddr( device, "vkQueueSetPerformanceConfigurationINTEL" ) );
          vkGetPerformanceParameterINTEL = PFN_vkGetPerformanceParameterINTEL( vkGetDeviceProcAddr( device, "vkGetPerformanceParameterINTEL" ) );

          //=== VK_AMD_display_native_hdr ===
          vkSetLocalDimmingAMD = PFN_vkSetLocalDimmingAMD( vkGetDeviceProcAddr( device, "vkSetLocalDimmingAMD" ) );

          //=== VK_KHR_fragment_shading_rate ===
          vkCmdSetFragmentShadingRateKHR = PFN_vkCmdSetFragmentShadingRateKHR( vkGetDeviceProcAddr( device, "vkCmdSetFragmentShadingRateKHR" ) );

          //=== VK_KHR_dynamic_rendering_local_read ===
          vkCmdSetRenderingAttachmentLocationsKHR =
            PFN_vkCmdSetRenderingAttachmentLocationsKHR( vkGetDeviceProcAddr( device, "vkCmdSetRenderingAttachmentLocationsKHR" ) );
          if ( !vkCmdSetRenderingAttachmentLocations )
            vkCmdSetRenderingAttachmentLocations = vkCmdSetRenderingAttachmentLocationsKHR;
          vkCmdSetRenderingInputAttachmentIndicesKHR =
            PFN_vkCmdSetRenderingInputAttachmentIndicesKHR( vkGetDeviceProcAddr( device, "vkCmdSetRenderingInputAttachmentIndicesKHR" ) );
          if ( !vkCmdSetRenderingInputAttachmentIndices )
            vkCmdSetRenderingInputAttachmentIndices = vkCmdSetRenderingInputAttachmentIndicesKHR;

          //=== VK_EXT_buffer_device_address ===
          vkGetBufferDeviceAddressEXT = PFN_vkGetBufferDeviceAddressEXT( vkGetDeviceProcAddr( device, "vkGetBufferDeviceAddressEXT" ) );
          if ( !vkGetBufferDeviceAddress )
            vkGetBufferDeviceAddress = vkGetBufferDeviceAddressEXT;

          //=== VK_KHR_present_wait ===
          vkWaitForPresentKHR = PFN_vkWaitForPresentKHR( vkGetDeviceProcAddr( device, "vkWaitForPresentKHR" ) );

#  if defined( VK_USE_PLATFORM_WIN32_KHR )
          //=== VK_EXT_full_screen_exclusive ===
          vkAcquireFullScreenExclusiveModeEXT = PFN_vkAcquireFullScreenExclusiveModeEXT( vkGetDeviceProcAddr( device, "vkAcquireFullScreenExclusiveModeEXT" ) );
          vkReleaseFullScreenExclusiveModeEXT = PFN_vkReleaseFullScreenExclusiveModeEXT( vkGetDeviceProcAddr( device, "vkReleaseFullScreenExclusiveModeEXT" ) );
          vkGetDeviceGroupSurfacePresentModes2EXT =
            PFN_vkGetDeviceGroupSurfacePresentModes2EXT( vkGetDeviceProcAddr( device, "vkGetDeviceGroupSurfacePresentModes2EXT" ) );
#  endif /*VK_USE_PLATFORM_WIN32_KHR*/

          //=== VK_KHR_buffer_device_address ===
          vkGetBufferDeviceAddressKHR = PFN_vkGetBufferDeviceAddressKHR( vkGetDeviceProcAddr( device, "vkGetBufferDeviceAddressKHR" ) );
          if ( !vkGetBufferDeviceAddress )
            vkGetBufferDeviceAddress = vkGetBufferDeviceAddressKHR;
          vkGetBufferOpaqueCaptureAddressKHR = PFN_vkGetBufferOpaqueCaptureAddressKHR( vkGetDeviceProcAddr( device, "vkGetBufferOpaqueCaptureAddressKHR" ) );
          if ( !vkGetBufferOpaqueCaptureAddress )
            vkGetBufferOpaqueCaptureAddress = vkGetBufferOpaqueCaptureAddressKHR;
          vkGetDeviceMemoryOpaqueCaptureAddressKHR =
            PFN_vkGetDeviceMemoryOpaqueCaptureAddressKHR( vkGetDeviceProcAddr( device, "vkGetDeviceMemoryOpaqueCaptureAddressKHR" ) );
          if ( !vkGetDeviceMemoryOpaqueCaptureAddress )
            vkGetDeviceMemoryOpaqueCaptureAddress = vkGetDeviceMemoryOpaqueCaptureAddressKHR;

          //=== VK_EXT_line_rasterization ===
          vkCmdSetLineStippleEXT = PFN_vkCmdSetLineStippleEXT( vkGetDeviceProcAddr( device, "vkCmdSetLineStippleEXT" ) );
          if ( !vkCmdSetLineStipple )
            vkCmdSetLineStipple = vkCmdSetLineStippleEXT;

          //=== VK_EXT_host_query_reset ===
          vkResetQueryPoolEXT = PFN_vkResetQueryPoolEXT( vkGetDeviceProcAddr( device, "vkResetQueryPoolEXT" ) );
          if ( !vkResetQueryPool )
            vkResetQueryPool = vkResetQueryPoolEXT;

          //=== VK_EXT_extended_dynamic_state ===
          vkCmdSetCullModeEXT = PFN_vkCmdSetCullModeEXT( vkGetDeviceProcAddr( device, "vkCmdSetCullModeEXT" ) );
          if ( !vkCmdSetCullMode )
            vkCmdSetCullMode = vkCmdSetCullModeEXT;
          vkCmdSetFrontFaceEXT = PFN_vkCmdSetFrontFaceEXT( vkGetDeviceProcAddr( device, "vkCmdSetFrontFaceEXT" ) );
          if ( !vkCmdSetFrontFace )
            vkCmdSetFrontFace = vkCmdSetFrontFaceEXT;
          vkCmdSetPrimitiveTopologyEXT = PFN_vkCmdSetPrimitiveTopologyEXT( vkGetDeviceProcAddr( device, "vkCmdSetPrimitiveTopologyEXT" ) );
          if ( !vkCmdSetPrimitiveTopology )
            vkCmdSetPrimitiveTopology = vkCmdSetPrimitiveTopologyEXT;
          vkCmdSetViewportWithCountEXT = PFN_vkCmdSetViewportWithCountEXT( vkGetDeviceProcAddr( device, "vkCmdSetViewportWithCountEXT" ) );
          if ( !vkCmdSetViewportWithCount )
            vkCmdSetViewportWithCount = vkCmdSetViewportWithCountEXT;
          vkCmdSetScissorWithCountEXT = PFN_vkCmdSetScissorWithCountEXT( vkGetDeviceProcAddr( device, "vkCmdSetScissorWithCountEXT" ) );
          if ( !vkCmdSetScissorWithCount )
            vkCmdSetScissorWithCount = vkCmdSetScissorWithCountEXT;
          vkCmdBindVertexBuffers2EXT = PFN_vkCmdBindVertexBuffers2EXT( vkGetDeviceProcAddr( device, "vkCmdBindVertexBuffers2EXT" ) );
          if ( !vkCmdBindVertexBuffers2 )
            vkCmdBindVertexBuffers2 = vkCmdBindVertexBuffers2EXT;
          vkCmdSetDepthTestEnableEXT = PFN_vkCmdSetDepthTestEnableEXT( vkGetDeviceProcAddr( device, "vkCmdSetDepthTestEnableEXT" ) );
          if ( !vkCmdSetDepthTestEnable )
            vkCmdSetDepthTestEnable = vkCmdSetDepthTestEnableEXT;
          vkCmdSetDepthWriteEnableEXT = PFN_vkCmdSetDepthWriteEnableEXT( vkGetDeviceProcAddr( device, "vkCmdSetDepthWriteEnableEXT" ) );
          if ( !vkCmdSetDepthWriteEnable )
            vkCmdSetDepthWriteEnable = vkCmdSetDepthWriteEnableEXT;
          vkCmdSetDepthCompareOpEXT = PFN_vkCmdSetDepthCompareOpEXT( vkGetDeviceProcAddr( device, "vkCmdSetDepthCompareOpEXT" ) );
          if ( !vkCmdSetDepthCompareOp )
            vkCmdSetDepthCompareOp = vkCmdSetDepthCompareOpEXT;
          vkCmdSetDepthBoundsTestEnableEXT = PFN_vkCmdSetDepthBoundsTestEnableEXT( vkGetDeviceProcAddr( device, "vkCmdSetDepthBoundsTestEnableEXT" ) );
          if ( !vkCmdSetDepthBoundsTestEnable )
            vkCmdSetDepthBoundsTestEnable = vkCmdSetDepthBoundsTestEnableEXT;
          vkCmdSetStencilTestEnableEXT = PFN_vkCmdSetStencilTestEnableEXT( vkGetDeviceProcAddr( device, "vkCmdSetStencilTestEnableEXT" ) );
          if ( !vkCmdSetStencilTestEnable )
            vkCmdSetStencilTestEnable = vkCmdSetStencilTestEnableEXT;
          vkCmdSetStencilOpEXT = PFN_vkCmdSetStencilOpEXT( vkGetDeviceProcAddr( device, "vkCmdSetStencilOpEXT" ) );
          if ( !vkCmdSetStencilOp )
            vkCmdSetStencilOp = vkCmdSetStencilOpEXT;

          //=== VK_KHR_deferred_host_operations ===
          vkCreateDeferredOperationKHR  = PFN_vkCreateDeferredOperationKHR( vkGetDeviceProcAddr( device, "vkCreateDeferredOperationKHR" ) );
          vkDestroyDeferredOperationKHR = PFN_vkDestroyDeferredOperationKHR( vkGetDeviceProcAddr( device, "vkDestroyDeferredOperationKHR" ) );
          vkGetDeferredOperationMaxConcurrencyKHR =
            PFN_vkGetDeferredOperationMaxConcurrencyKHR( vkGetDeviceProcAddr( device, "vkGetDeferredOperationMaxConcurrencyKHR" ) );
          vkGetDeferredOperationResultKHR = PFN_vkGetDeferredOperationResultKHR( vkGetDeviceProcAddr( device, "vkGetDeferredOperationResultKHR" ) );
          vkDeferredOperationJoinKHR      = PFN_vkDeferredOperationJoinKHR( vkGetDeviceProcAddr( device, "vkDeferredOperationJoinKHR" ) );

          //=== VK_KHR_pipeline_executable_properties ===
          vkGetPipelineExecutablePropertiesKHR =
            PFN_vkGetPipelineExecutablePropertiesKHR( vkGetDeviceProcAddr( device, "vkGetPipelineExecutablePropertiesKHR" ) );
          vkGetPipelineExecutableStatisticsKHR =
            PFN_vkGetPipelineExecutableStatisticsKHR( vkGetDeviceProcAddr( device, "vkGetPipelineExecutableStatisticsKHR" ) );
          vkGetPipelineExecutableInternalRepresentationsKHR =
            PFN_vkGetPipelineExecutableInternalRepresentationsKHR( vkGetDeviceProcAddr( device, "vkGetPipelineExecutableInternalRepresentationsKHR" ) );

          //=== VK_EXT_host_image_copy ===
          vkCopyMemoryToImageEXT = PFN_vkCopyMemoryToImageEXT( vkGetDeviceProcAddr( device, "vkCopyMemoryToImageEXT" ) );
          if ( !vkCopyMemoryToImage )
            vkCopyMemoryToImage = vkCopyMemoryToImageEXT;
          vkCopyImageToMemoryEXT = PFN_vkCopyImageToMemoryEXT( vkGetDeviceProcAddr( device, "vkCopyImageToMemoryEXT" ) );
          if ( !vkCopyImageToMemory )
            vkCopyImageToMemory = vkCopyImageToMemoryEXT;
          vkCopyImageToImageEXT = PFN_vkCopyImageToImageEXT( vkGetDeviceProcAddr( device, "vkCopyImageToImageEXT" ) );
          if ( !vkCopyImageToImage )
            vkCopyImageToImage = vkCopyImageToImageEXT;
          vkTransitionImageLayoutEXT = PFN_vkTransitionImageLayoutEXT( vkGetDeviceProcAddr( device, "vkTransitionImageLayoutEXT" ) );
          if ( !vkTransitionImageLayout )
            vkTransitionImageLayout = vkTransitionImageLayoutEXT;
          vkGetImageSubresourceLayout2EXT = PFN_vkGetImageSubresourceLayout2EXT( vkGetDeviceProcAddr( device, "vkGetImageSubresourceLayout2EXT" ) );
          if ( !vkGetImageSubresourceLayout2 )
            vkGetImageSubresourceLayout2 = vkGetImageSubresourceLayout2EXT;

          //=== VK_KHR_map_memory2 ===
          vkMapMemory2KHR = PFN_vkMapMemory2KHR( vkGetDeviceProcAddr( device, "vkMapMemory2KHR" ) );
          if ( !vkMapMemory2 )
            vkMapMemory2 = vkMapMemory2KHR;
          vkUnmapMemory2KHR = PFN_vkUnmapMemory2KHR( vkGetDeviceProcAddr( device, "vkUnmapMemory2KHR" ) );
          if ( !vkUnmapMemory2 )
            vkUnmapMemory2 = vkUnmapMemory2KHR;

          //=== VK_EXT_swapchain_maintenance1 ===
          vkReleaseSwapchainImagesEXT = PFN_vkReleaseSwapchainImagesEXT( vkGetDeviceProcAddr( device, "vkReleaseSwapchainImagesEXT" ) );
          if ( !vkReleaseSwapchainImagesKHR )
            vkReleaseSwapchainImagesKHR = vkReleaseSwapchainImagesEXT;

          //=== VK_NV_device_generated_commands ===
          vkGetGeneratedCommandsMemoryRequirementsNV =
            PFN_vkGetGeneratedCommandsMemoryRequirementsNV( vkGetDeviceProcAddr( device, "vkGetGeneratedCommandsMemoryRequirementsNV" ) );
          vkCmdPreprocessGeneratedCommandsNV = PFN_vkCmdPreprocessGeneratedCommandsNV( vkGetDeviceProcAddr( device, "vkCmdPreprocessGeneratedCommandsNV" ) );
          vkCmdExecuteGeneratedCommandsNV    = PFN_vkCmdExecuteGeneratedCommandsNV( vkGetDeviceProcAddr( device, "vkCmdExecuteGeneratedCommandsNV" ) );
          vkCmdBindPipelineShaderGroupNV     = PFN_vkCmdBindPipelineShaderGroupNV( vkGetDeviceProcAddr( device, "vkCmdBindPipelineShaderGroupNV" ) );
          vkCreateIndirectCommandsLayoutNV   = PFN_vkCreateIndirectCommandsLayoutNV( vkGetDeviceProcAddr( device, "vkCreateIndirectCommandsLayoutNV" ) );
          vkDestroyIndirectCommandsLayoutNV  = PFN_vkDestroyIndirectCommandsLayoutNV( vkGetDeviceProcAddr( device, "vkDestroyIndirectCommandsLayoutNV" ) );

          //=== VK_EXT_depth_bias_control ===
          vkCmdSetDepthBias2EXT = PFN_vkCmdSetDepthBias2EXT( vkGetDeviceProcAddr( device, "vkCmdSetDepthBias2EXT" ) );

          //=== VK_EXT_private_data ===
          vkCreatePrivateDataSlotEXT = PFN_vkCreatePrivateDataSlotEXT( vkGetDeviceProcAddr( device, "vkCreatePrivateDataSlotEXT" ) );
          if ( !vkCreatePrivateDataSlot )
            vkCreatePrivateDataSlot = vkCreatePrivateDataSlotEXT;
          vkDestroyPrivateDataSlotEXT = PFN_vkDestroyPrivateDataSlotEXT( vkGetDeviceProcAddr( device, "vkDestroyPrivateDataSlotEXT" ) );
          if ( !vkDestroyPrivateDataSlot )
            vkDestroyPrivateDataSlot = vkDestroyPrivateDataSlotEXT;
          vkSetPrivateDataEXT = PFN_vkSetPrivateDataEXT( vkGetDeviceProcAddr( device, "vkSetPrivateDataEXT" ) );
          if ( !vkSetPrivateData )
            vkSetPrivateData = vkSetPrivateDataEXT;
          vkGetPrivateDataEXT = PFN_vkGetPrivateDataEXT( vkGetDeviceProcAddr( device, "vkGetPrivateDataEXT" ) );
          if ( !vkGetPrivateData )
            vkGetPrivateData = vkGetPrivateDataEXT;

          //=== VK_KHR_video_encode_queue ===
          vkGetEncodedVideoSessionParametersKHR =
            PFN_vkGetEncodedVideoSessionParametersKHR( vkGetDeviceProcAddr( device, "vkGetEncodedVideoSessionParametersKHR" ) );
          vkCmdEncodeVideoKHR = PFN_vkCmdEncodeVideoKHR( vkGetDeviceProcAddr( device, "vkCmdEncodeVideoKHR" ) );

#  if defined( VK_ENABLE_BETA_EXTENSIONS )
          //=== VK_NV_cuda_kernel_launch ===
          vkCreateCudaModuleNV    = PFN_vkCreateCudaModuleNV( vkGetDeviceProcAddr( device, "vkCreateCudaModuleNV" ) );
          vkGetCudaModuleCacheNV  = PFN_vkGetCudaModuleCacheNV( vkGetDeviceProcAddr( device, "vkGetCudaModuleCacheNV" ) );
          vkCreateCudaFunctionNV  = PFN_vkCreateCudaFunctionNV( vkGetDeviceProcAddr( device, "vkCreateCudaFunctionNV" ) );
          vkDestroyCudaModuleNV   = PFN_vkDestroyCudaModuleNV( vkGetDeviceProcAddr( device, "vkDestroyCudaModuleNV" ) );
          vkDestroyCudaFunctionNV = PFN_vkDestroyCudaFunctionNV( vkGetDeviceProcAddr( device, "vkDestroyCudaFunctionNV" ) );
          vkCmdCudaLaunchKernelNV = PFN_vkCmdCudaLaunchKernelNV( vkGetDeviceProcAddr( device, "vkCmdCudaLaunchKernelNV" ) );
#  endif /*VK_ENABLE_BETA_EXTENSIONS*/

          //=== VK_QCOM_tile_shading ===
          vkCmdDispatchTileQCOM          = PFN_vkCmdDispatchTileQCOM( vkGetDeviceProcAddr( device, "vkCmdDispatchTileQCOM" ) );
          vkCmdBeginPerTileExecutionQCOM = PFN_vkCmdBeginPerTileExecutionQCOM( vkGetDeviceProcAddr( device, "vkCmdBeginPerTileExecutionQCOM" ) );
          vkCmdEndPerTileExecutionQCOM   = PFN_vkCmdEndPerTileExecutionQCOM( vkGetDeviceProcAddr( device, "vkCmdEndPerTileExecutionQCOM" ) );

#  if defined( VK_USE_PLATFORM_METAL_EXT )
          //=== VK_EXT_metal_objects ===
          vkExportMetalObjectsEXT = PFN_vkExportMetalObjectsEXT( vkGetDeviceProcAddr( device, "vkExportMetalObjectsEXT" ) );
#  endif /*VK_USE_PLATFORM_METAL_EXT*/

          //=== VK_KHR_synchronization2 ===
          vkCmdSetEvent2KHR = PFN_vkCmdSetEvent2KHR( vkGetDeviceProcAddr( device, "vkCmdSetEvent2KHR" ) );
          if ( !vkCmdSetEvent2 )
            vkCmdSetEvent2 = vkCmdSetEvent2KHR;
          vkCmdResetEvent2KHR = PFN_vkCmdResetEvent2KHR( vkGetDeviceProcAddr( device, "vkCmdResetEvent2KHR" ) );
          if ( !vkCmdResetEvent2 )
            vkCmdResetEvent2 = vkCmdResetEvent2KHR;
          vkCmdWaitEvents2KHR = PFN_vkCmdWaitEvents2KHR( vkGetDeviceProcAddr( device, "vkCmdWaitEvents2KHR" ) );
          if ( !vkCmdWaitEvents2 )
            vkCmdWaitEvents2 = vkCmdWaitEvents2KHR;
          vkCmdPipelineBarrier2KHR = PFN_vkCmdPipelineBarrier2KHR( vkGetDeviceProcAddr( device, "vkCmdPipelineBarrier2KHR" ) );
          if ( !vkCmdPipelineBarrier2 )
            vkCmdPipelineBarrier2 = vkCmdPipelineBarrier2KHR;
          vkCmdWriteTimestamp2KHR = PFN_vkCmdWriteTimestamp2KHR( vkGetDeviceProcAddr( device, "vkCmdWriteTimestamp2KHR" ) );
          if ( !vkCmdWriteTimestamp2 )
            vkCmdWriteTimestamp2 = vkCmdWriteTimestamp2KHR;
          vkQueueSubmit2KHR = PFN_vkQueueSubmit2KHR( vkGetDeviceProcAddr( device, "vkQueueSubmit2KHR" ) );
          if ( !vkQueueSubmit2 )
            vkQueueSubmit2 = vkQueueSubmit2KHR;

          //=== VK_EXT_descriptor_buffer ===
          vkGetDescriptorSetLayoutSizeEXT = PFN_vkGetDescriptorSetLayoutSizeEXT( vkGetDeviceProcAddr( device, "vkGetDescriptorSetLayoutSizeEXT" ) );
          vkGetDescriptorSetLayoutBindingOffsetEXT =
            PFN_vkGetDescriptorSetLayoutBindingOffsetEXT( vkGetDeviceProcAddr( device, "vkGetDescriptorSetLayoutBindingOffsetEXT" ) );
          vkGetDescriptorEXT                 = PFN_vkGetDescriptorEXT( vkGetDeviceProcAddr( device, "vkGetDescriptorEXT" ) );
          vkCmdBindDescriptorBuffersEXT      = PFN_vkCmdBindDescriptorBuffersEXT( vkGetDeviceProcAddr( device, "vkCmdBindDescriptorBuffersEXT" ) );
          vkCmdSetDescriptorBufferOffsetsEXT = PFN_vkCmdSetDescriptorBufferOffsetsEXT( vkGetDeviceProcAddr( device, "vkCmdSetDescriptorBufferOffsetsEXT" ) );
          vkCmdBindDescriptorBufferEmbeddedSamplersEXT =
            PFN_vkCmdBindDescriptorBufferEmbeddedSamplersEXT( vkGetDeviceProcAddr( device, "vkCmdBindDescriptorBufferEmbeddedSamplersEXT" ) );
          vkGetBufferOpaqueCaptureDescriptorDataEXT =
            PFN_vkGetBufferOpaqueCaptureDescriptorDataEXT( vkGetDeviceProcAddr( device, "vkGetBufferOpaqueCaptureDescriptorDataEXT" ) );
          vkGetImageOpaqueCaptureDescriptorDataEXT =
            PFN_vkGetImageOpaqueCaptureDescriptorDataEXT( vkGetDeviceProcAddr( device, "vkGetImageOpaqueCaptureDescriptorDataEXT" ) );
          vkGetImageViewOpaqueCaptureDescriptorDataEXT =
            PFN_vkGetImageViewOpaqueCaptureDescriptorDataEXT( vkGetDeviceProcAddr( device, "vkGetImageViewOpaqueCaptureDescriptorDataEXT" ) );
          vkGetSamplerOpaqueCaptureDescriptorDataEXT =
            PFN_vkGetSamplerOpaqueCaptureDescriptorDataEXT( vkGetDeviceProcAddr( device, "vkGetSamplerOpaqueCaptureDescriptorDataEXT" ) );
          vkGetAccelerationStructureOpaqueCaptureDescriptorDataEXT = PFN_vkGetAccelerationStructureOpaqueCaptureDescriptorDataEXT(
            vkGetDeviceProcAddr( device, "vkGetAccelerationStructureOpaqueCaptureDescriptorDataEXT" ) );

          //=== VK_NV_fragment_shading_rate_enums ===
          vkCmdSetFragmentShadingRateEnumNV = PFN_vkCmdSetFragmentShadingRateEnumNV( vkGetDeviceProcAddr( device, "vkCmdSetFragmentShadingRateEnumNV" ) );

          //=== VK_EXT_mesh_shader ===
          vkCmdDrawMeshTasksEXT              = PFN_vkCmdDrawMeshTasksEXT( vkGetDeviceProcAddr( device, "vkCmdDrawMeshTasksEXT" ) );
          vkCmdDrawMeshTasksIndirectEXT      = PFN_vkCmdDrawMeshTasksIndirectEXT( vkGetDeviceProcAddr( device, "vkCmdDrawMeshTasksIndirectEXT" ) );
          vkCmdDrawMeshTasksIndirectCountEXT = PFN_vkCmdDrawMeshTasksIndirectCountEXT( vkGetDeviceProcAddr( device, "vkCmdDrawMeshTasksIndirectCountEXT" ) );

          //=== VK_KHR_copy_commands2 ===
          vkCmdCopyBuffer2KHR = PFN_vkCmdCopyBuffer2KHR( vkGetDeviceProcAddr( device, "vkCmdCopyBuffer2KHR" ) );
          if ( !vkCmdCopyBuffer2 )
            vkCmdCopyBuffer2 = vkCmdCopyBuffer2KHR;
          vkCmdCopyImage2KHR = PFN_vkCmdCopyImage2KHR( vkGetDeviceProcAddr( device, "vkCmdCopyImage2KHR" ) );
          if ( !vkCmdCopyImage2 )
            vkCmdCopyImage2 = vkCmdCopyImage2KHR;
          vkCmdCopyBufferToImage2KHR = PFN_vkCmdCopyBufferToImage2KHR( vkGetDeviceProcAddr( device, "vkCmdCopyBufferToImage2KHR" ) );
          if ( !vkCmdCopyBufferToImage2 )
            vkCmdCopyBufferToImage2 = vkCmdCopyBufferToImage2KHR;
          vkCmdCopyImageToBuffer2KHR = PFN_vkCmdCopyImageToBuffer2KHR( vkGetDeviceProcAddr( device, "vkCmdCopyImageToBuffer2KHR" ) );
          if ( !vkCmdCopyImageToBuffer2 )
            vkCmdCopyImageToBuffer2 = vkCmdCopyImageToBuffer2KHR;
          vkCmdBlitImage2KHR = PFN_vkCmdBlitImage2KHR( vkGetDeviceProcAddr( device, "vkCmdBlitImage2KHR" ) );
          if ( !vkCmdBlitImage2 )
            vkCmdBlitImage2 = vkCmdBlitImage2KHR;
          vkCmdResolveImage2KHR = PFN_vkCmdResolveImage2KHR( vkGetDeviceProcAddr( device, "vkCmdResolveImage2KHR" ) );
          if ( !vkCmdResolveImage2 )
            vkCmdResolveImage2 = vkCmdResolveImage2KHR;

          //=== VK_EXT_device_fault ===
          vkGetDeviceFaultInfoEXT = PFN_vkGetDeviceFaultInfoEXT( vkGetDeviceProcAddr( device, "vkGetDeviceFaultInfoEXT" ) );

          //=== VK_EXT_vertex_input_dynamic_state ===
          vkCmdSetVertexInputEXT = PFN_vkCmdSetVertexInputEXT( vkGetDeviceProcAddr( device, "vkCmdSetVertexInputEXT" ) );

#  if defined( VK_USE_PLATFORM_FUCHSIA )
          //=== VK_FUCHSIA_external_memory ===
          vkGetMemoryZirconHandleFUCHSIA = PFN_vkGetMemoryZirconHandleFUCHSIA( vkGetDeviceProcAddr( device, "vkGetMemoryZirconHandleFUCHSIA" ) );
          vkGetMemoryZirconHandlePropertiesFUCHSIA =
            PFN_vkGetMemoryZirconHandlePropertiesFUCHSIA( vkGetDeviceProcAddr( device, "vkGetMemoryZirconHandlePropertiesFUCHSIA" ) );
#  endif /*VK_USE_PLATFORM_FUCHSIA*/

#  if defined( VK_USE_PLATFORM_FUCHSIA )
          //=== VK_FUCHSIA_external_semaphore ===
          vkImportSemaphoreZirconHandleFUCHSIA =
            PFN_vkImportSemaphoreZirconHandleFUCHSIA( vkGetDeviceProcAddr( device, "vkImportSemaphoreZirconHandleFUCHSIA" ) );
          vkGetSemaphoreZirconHandleFUCHSIA = PFN_vkGetSemaphoreZirconHandleFUCHSIA( vkGetDeviceProcAddr( device, "vkGetSemaphoreZirconHandleFUCHSIA" ) );
#  endif /*VK_USE_PLATFORM_FUCHSIA*/

#  if defined( VK_USE_PLATFORM_FUCHSIA )
          //=== VK_FUCHSIA_buffer_collection ===
          vkCreateBufferCollectionFUCHSIA = PFN_vkCreateBufferCollectionFUCHSIA( vkGetDeviceProcAddr( device, "vkCreateBufferCollectionFUCHSIA" ) );
          vkSetBufferCollectionImageConstraintsFUCHSIA =
            PFN_vkSetBufferCollectionImageConstraintsFUCHSIA( vkGetDeviceProcAddr( device, "vkSetBufferCollectionImageConstraintsFUCHSIA" ) );
          vkSetBufferCollectionBufferConstraintsFUCHSIA =
            PFN_vkSetBufferCollectionBufferConstraintsFUCHSIA( vkGetDeviceProcAddr( device, "vkSetBufferCollectionBufferConstraintsFUCHSIA" ) );
          vkDestroyBufferCollectionFUCHSIA = PFN_vkDestroyBufferCollectionFUCHSIA( vkGetDeviceProcAddr( device, "vkDestroyBufferCollectionFUCHSIA" ) );
          vkGetBufferCollectionPropertiesFUCHSIA =
            PFN_vkGetBufferCollectionPropertiesFUCHSIA( vkGetDeviceProcAddr( device, "vkGetBufferCollectionPropertiesFUCHSIA" ) );
#  endif /*VK_USE_PLATFORM_FUCHSIA*/

          //=== VK_HUAWEI_subpass_shading ===
          vkGetDeviceSubpassShadingMaxWorkgroupSizeHUAWEI =
            PFN_vkGetDeviceSubpassShadingMaxWorkgroupSizeHUAWEI( vkGetDeviceProcAddr( device, "vkGetDeviceSubpassShadingMaxWorkgroupSizeHUAWEI" ) );
          vkCmdSubpassShadingHUAWEI = PFN_vkCmdSubpassShadingHUAWEI( vkGetDeviceProcAddr( device, "vkCmdSubpassShadingHUAWEI" ) );

          //=== VK_HUAWEI_invocation_mask ===
          vkCmdBindInvocationMaskHUAWEI = PFN_vkCmdBindInvocationMaskHUAWEI( vkGetDeviceProcAddr( device, "vkCmdBindInvocationMaskHUAWEI" ) );

          //=== VK_NV_external_memory_rdma ===
          vkGetMemoryRemoteAddressNV = PFN_vkGetMemoryRemoteAddressNV( vkGetDeviceProcAddr( device, "vkGetMemoryRemoteAddressNV" ) );

          //=== VK_EXT_pipeline_properties ===
          vkGetPipelinePropertiesEXT = PFN_vkGetPipelinePropertiesEXT( vkGetDeviceProcAddr( device, "vkGetPipelinePropertiesEXT" ) );

          //=== VK_EXT_extended_dynamic_state2 ===
          vkCmdSetPatchControlPointsEXT      = PFN_vkCmdSetPatchControlPointsEXT( vkGetDeviceProcAddr( device, "vkCmdSetPatchControlPointsEXT" ) );
          vkCmdSetRasterizerDiscardEnableEXT = PFN_vkCmdSetRasterizerDiscardEnableEXT( vkGetDeviceProcAddr( device, "vkCmdSetRasterizerDiscardEnableEXT" ) );
          if ( !vkCmdSetRasterizerDiscardEnable )
            vkCmdSetRasterizerDiscardEnable = vkCmdSetRasterizerDiscardEnableEXT;
          vkCmdSetDepthBiasEnableEXT = PFN_vkCmdSetDepthBiasEnableEXT( vkGetDeviceProcAddr( device, "vkCmdSetDepthBiasEnableEXT" ) );
          if ( !vkCmdSetDepthBiasEnable )
            vkCmdSetDepthBiasEnable = vkCmdSetDepthBiasEnableEXT;
          vkCmdSetLogicOpEXT                = PFN_vkCmdSetLogicOpEXT( vkGetDeviceProcAddr( device, "vkCmdSetLogicOpEXT" ) );
          vkCmdSetPrimitiveRestartEnableEXT = PFN_vkCmdSetPrimitiveRestartEnableEXT( vkGetDeviceProcAddr( device, "vkCmdSetPrimitiveRestartEnableEXT" ) );
          if ( !vkCmdSetPrimitiveRestartEnable )
            vkCmdSetPrimitiveRestartEnable = vkCmdSetPrimitiveRestartEnableEXT;

          //=== VK_EXT_color_write_enable ===
          vkCmdSetColorWriteEnableEXT = PFN_vkCmdSetColorWriteEnableEXT( vkGetDeviceProcAddr( device, "vkCmdSetColorWriteEnableEXT" ) );

          //=== VK_KHR_ray_tracing_maintenance1 ===
          vkCmdTraceRaysIndirect2KHR = PFN_vkCmdTraceRaysIndirect2KHR( vkGetDeviceProcAddr( device, "vkCmdTraceRaysIndirect2KHR" ) );

          //=== VK_EXT_multi_draw ===
          vkCmdDrawMultiEXT        = PFN_vkCmdDrawMultiEXT( vkGetDeviceProcAddr( device, "vkCmdDrawMultiEXT" ) );
          vkCmdDrawMultiIndexedEXT = PFN_vkCmdDrawMultiIndexedEXT( vkGetDeviceProcAddr( device, "vkCmdDrawMultiIndexedEXT" ) );

          //=== VK_EXT_opacity_micromap ===
          vkCreateMicromapEXT                 = PFN_vkCreateMicromapEXT( vkGetDeviceProcAddr( device, "vkCreateMicromapEXT" ) );
          vkDestroyMicromapEXT                = PFN_vkDestroyMicromapEXT( vkGetDeviceProcAddr( device, "vkDestroyMicromapEXT" ) );
          vkCmdBuildMicromapsEXT              = PFN_vkCmdBuildMicromapsEXT( vkGetDeviceProcAddr( device, "vkCmdBuildMicromapsEXT" ) );
          vkBuildMicromapsEXT                 = PFN_vkBuildMicromapsEXT( vkGetDeviceProcAddr( device, "vkBuildMicromapsEXT" ) );
          vkCopyMicromapEXT                   = PFN_vkCopyMicromapEXT( vkGetDeviceProcAddr( device, "vkCopyMicromapEXT" ) );
          vkCopyMicromapToMemoryEXT           = PFN_vkCopyMicromapToMemoryEXT( vkGetDeviceProcAddr( device, "vkCopyMicromapToMemoryEXT" ) );
          vkCopyMemoryToMicromapEXT           = PFN_vkCopyMemoryToMicromapEXT( vkGetDeviceProcAddr( device, "vkCopyMemoryToMicromapEXT" ) );
          vkWriteMicromapsPropertiesEXT       = PFN_vkWriteMicromapsPropertiesEXT( vkGetDeviceProcAddr( device, "vkWriteMicromapsPropertiesEXT" ) );
          vkCmdCopyMicromapEXT                = PFN_vkCmdCopyMicromapEXT( vkGetDeviceProcAddr( device, "vkCmdCopyMicromapEXT" ) );
          vkCmdCopyMicromapToMemoryEXT        = PFN_vkCmdCopyMicromapToMemoryEXT( vkGetDeviceProcAddr( device, "vkCmdCopyMicromapToMemoryEXT" ) );
          vkCmdCopyMemoryToMicromapEXT        = PFN_vkCmdCopyMemoryToMicromapEXT( vkGetDeviceProcAddr( device, "vkCmdCopyMemoryToMicromapEXT" ) );
          vkCmdWriteMicromapsPropertiesEXT    = PFN_vkCmdWriteMicromapsPropertiesEXT( vkGetDeviceProcAddr( device, "vkCmdWriteMicromapsPropertiesEXT" ) );
          vkGetDeviceMicromapCompatibilityEXT = PFN_vkGetDeviceMicromapCompatibilityEXT( vkGetDeviceProcAddr( device, "vkGetDeviceMicromapCompatibilityEXT" ) );
          vkGetMicromapBuildSizesEXT          = PFN_vkGetMicromapBuildSizesEXT( vkGetDeviceProcAddr( device, "vkGetMicromapBuildSizesEXT" ) );

          //=== VK_HUAWEI_cluster_culling_shader ===
          vkCmdDrawClusterHUAWEI         = PFN_vkCmdDrawClusterHUAWEI( vkGetDeviceProcAddr( device, "vkCmdDrawClusterHUAWEI" ) );
          vkCmdDrawClusterIndirectHUAWEI = PFN_vkCmdDrawClusterIndirectHUAWEI( vkGetDeviceProcAddr( device, "vkCmdDrawClusterIndirectHUAWEI" ) );

          //=== VK_EXT_pageable_device_local_memory ===
          vkSetDeviceMemoryPriorityEXT = PFN_vkSetDeviceMemoryPriorityEXT( vkGetDeviceProcAddr( device, "vkSetDeviceMemoryPriorityEXT" ) );

          //=== VK_KHR_maintenance4 ===
          vkGetDeviceBufferMemoryRequirementsKHR =
            PFN_vkGetDeviceBufferMemoryRequirementsKHR( vkGetDeviceProcAddr( device, "vkGetDeviceBufferMemoryRequirementsKHR" ) );
          if ( !vkGetDeviceBufferMemoryRequirements )
            vkGetDeviceBufferMemoryRequirements = vkGetDeviceBufferMemoryRequirementsKHR;
          vkGetDeviceImageMemoryRequirementsKHR =
            PFN_vkGetDeviceImageMemoryRequirementsKHR( vkGetDeviceProcAddr( device, "vkGetDeviceImageMemoryRequirementsKHR" ) );
          if ( !vkGetDeviceImageMemoryRequirements )
            vkGetDeviceImageMemoryRequirements = vkGetDeviceImageMemoryRequirementsKHR;
          vkGetDeviceImageSparseMemoryRequirementsKHR =
            PFN_vkGetDeviceImageSparseMemoryRequirementsKHR( vkGetDeviceProcAddr( device, "vkGetDeviceImageSparseMemoryRequirementsKHR" ) );
          if ( !vkGetDeviceImageSparseMemoryRequirements )
            vkGetDeviceImageSparseMemoryRequirements = vkGetDeviceImageSparseMemoryRequirementsKHR;

          //=== VK_VALVE_descriptor_set_host_mapping ===
          vkGetDescriptorSetLayoutHostMappingInfoVALVE =
            PFN_vkGetDescriptorSetLayoutHostMappingInfoVALVE( vkGetDeviceProcAddr( device, "vkGetDescriptorSetLayoutHostMappingInfoVALVE" ) );
          vkGetDescriptorSetHostMappingVALVE = PFN_vkGetDescriptorSetHostMappingVALVE( vkGetDeviceProcAddr( device, "vkGetDescriptorSetHostMappingVALVE" ) );

          //=== VK_NV_copy_memory_indirect ===
          vkCmdCopyMemoryIndirectNV        = PFN_vkCmdCopyMemoryIndirectNV( vkGetDeviceProcAddr( device, "vkCmdCopyMemoryIndirectNV" ) );
          vkCmdCopyMemoryToImageIndirectNV = PFN_vkCmdCopyMemoryToImageIndirectNV( vkGetDeviceProcAddr( device, "vkCmdCopyMemoryToImageIndirectNV" ) );

          //=== VK_NV_memory_decompression ===
          vkCmdDecompressMemoryNV = PFN_vkCmdDecompressMemoryNV( vkGetDeviceProcAddr( device, "vkCmdDecompressMemoryNV" ) );
          vkCmdDecompressMemoryIndirectCountNV =
            PFN_vkCmdDecompressMemoryIndirectCountNV( vkGetDeviceProcAddr( device, "vkCmdDecompressMemoryIndirectCountNV" ) );

          //=== VK_NV_device_generated_commands_compute ===
          vkGetPipelineIndirectMemoryRequirementsNV =
            PFN_vkGetPipelineIndirectMemoryRequirementsNV( vkGetDeviceProcAddr( device, "vkGetPipelineIndirectMemoryRequirementsNV" ) );
          vkCmdUpdatePipelineIndirectBufferNV = PFN_vkCmdUpdatePipelineIndirectBufferNV( vkGetDeviceProcAddr( device, "vkCmdUpdatePipelineIndirectBufferNV" ) );
          vkGetPipelineIndirectDeviceAddressNV =
            PFN_vkGetPipelineIndirectDeviceAddressNV( vkGetDeviceProcAddr( device, "vkGetPipelineIndirectDeviceAddressNV" ) );

#  if defined( VK_USE_PLATFORM_OHOS )
          //=== VK_OHOS_external_memory ===
          vkGetNativeBufferPropertiesOHOS = PFN_vkGetNativeBufferPropertiesOHOS( vkGetDeviceProcAddr( device, "vkGetNativeBufferPropertiesOHOS" ) );
          vkGetMemoryNativeBufferOHOS     = PFN_vkGetMemoryNativeBufferOHOS( vkGetDeviceProcAddr( device, "vkGetMemoryNativeBufferOHOS" ) );
#  endif /*VK_USE_PLATFORM_OHOS*/

          //=== VK_EXT_extended_dynamic_state3 ===
          vkCmdSetDepthClampEnableEXT         = PFN_vkCmdSetDepthClampEnableEXT( vkGetDeviceProcAddr( device, "vkCmdSetDepthClampEnableEXT" ) );
          vkCmdSetPolygonModeEXT              = PFN_vkCmdSetPolygonModeEXT( vkGetDeviceProcAddr( device, "vkCmdSetPolygonModeEXT" ) );
          vkCmdSetRasterizationSamplesEXT     = PFN_vkCmdSetRasterizationSamplesEXT( vkGetDeviceProcAddr( device, "vkCmdSetRasterizationSamplesEXT" ) );
          vkCmdSetSampleMaskEXT               = PFN_vkCmdSetSampleMaskEXT( vkGetDeviceProcAddr( device, "vkCmdSetSampleMaskEXT" ) );
          vkCmdSetAlphaToCoverageEnableEXT    = PFN_vkCmdSetAlphaToCoverageEnableEXT( vkGetDeviceProcAddr( device, "vkCmdSetAlphaToCoverageEnableEXT" ) );
          vkCmdSetAlphaToOneEnableEXT         = PFN_vkCmdSetAlphaToOneEnableEXT( vkGetDeviceProcAddr( device, "vkCmdSetAlphaToOneEnableEXT" ) );
          vkCmdSetLogicOpEnableEXT            = PFN_vkCmdSetLogicOpEnableEXT( vkGetDeviceProcAddr( device, "vkCmdSetLogicOpEnableEXT" ) );
          vkCmdSetColorBlendEnableEXT         = PFN_vkCmdSetColorBlendEnableEXT( vkGetDeviceProcAddr( device, "vkCmdSetColorBlendEnableEXT" ) );
          vkCmdSetColorBlendEquationEXT       = PFN_vkCmdSetColorBlendEquationEXT( vkGetDeviceProcAddr( device, "vkCmdSetColorBlendEquationEXT" ) );
          vkCmdSetColorWriteMaskEXT           = PFN_vkCmdSetColorWriteMaskEXT( vkGetDeviceProcAddr( device, "vkCmdSetColorWriteMaskEXT" ) );
          vkCmdSetTessellationDomainOriginEXT = PFN_vkCmdSetTessellationDomainOriginEXT( vkGetDeviceProcAddr( device, "vkCmdSetTessellationDomainOriginEXT" ) );
          vkCmdSetRasterizationStreamEXT      = PFN_vkCmdSetRasterizationStreamEXT( vkGetDeviceProcAddr( device, "vkCmdSetRasterizationStreamEXT" ) );
          vkCmdSetConservativeRasterizationModeEXT =
            PFN_vkCmdSetConservativeRasterizationModeEXT( vkGetDeviceProcAddr( device, "vkCmdSetConservativeRasterizationModeEXT" ) );
          vkCmdSetExtraPrimitiveOverestimationSizeEXT =
            PFN_vkCmdSetExtraPrimitiveOverestimationSizeEXT( vkGetDeviceProcAddr( device, "vkCmdSetExtraPrimitiveOverestimationSizeEXT" ) );
          vkCmdSetDepthClipEnableEXT       = PFN_vkCmdSetDepthClipEnableEXT( vkGetDeviceProcAddr( device, "vkCmdSetDepthClipEnableEXT" ) );
          vkCmdSetSampleLocationsEnableEXT = PFN_vkCmdSetSampleLocationsEnableEXT( vkGetDeviceProcAddr( device, "vkCmdSetSampleLocationsEnableEXT" ) );
          vkCmdSetColorBlendAdvancedEXT    = PFN_vkCmdSetColorBlendAdvancedEXT( vkGetDeviceProcAddr( device, "vkCmdSetColorBlendAdvancedEXT" ) );
          vkCmdSetProvokingVertexModeEXT   = PFN_vkCmdSetProvokingVertexModeEXT( vkGetDeviceProcAddr( device, "vkCmdSetProvokingVertexModeEXT" ) );
          vkCmdSetLineRasterizationModeEXT = PFN_vkCmdSetLineRasterizationModeEXT( vkGetDeviceProcAddr( device, "vkCmdSetLineRasterizationModeEXT" ) );
          vkCmdSetLineStippleEnableEXT     = PFN_vkCmdSetLineStippleEnableEXT( vkGetDeviceProcAddr( device, "vkCmdSetLineStippleEnableEXT" ) );
          vkCmdSetDepthClipNegativeOneToOneEXT =
            PFN_vkCmdSetDepthClipNegativeOneToOneEXT( vkGetDeviceProcAddr( device, "vkCmdSetDepthClipNegativeOneToOneEXT" ) );
          vkCmdSetViewportWScalingEnableNV  = PFN_vkCmdSetViewportWScalingEnableNV( vkGetDeviceProcAddr( device, "vkCmdSetViewportWScalingEnableNV" ) );
          vkCmdSetViewportSwizzleNV         = PFN_vkCmdSetViewportSwizzleNV( vkGetDeviceProcAddr( device, "vkCmdSetViewportSwizzleNV" ) );
          vkCmdSetCoverageToColorEnableNV   = PFN_vkCmdSetCoverageToColorEnableNV( vkGetDeviceProcAddr( device, "vkCmdSetCoverageToColorEnableNV" ) );
          vkCmdSetCoverageToColorLocationNV = PFN_vkCmdSetCoverageToColorLocationNV( vkGetDeviceProcAddr( device, "vkCmdSetCoverageToColorLocationNV" ) );
          vkCmdSetCoverageModulationModeNV  = PFN_vkCmdSetCoverageModulationModeNV( vkGetDeviceProcAddr( device, "vkCmdSetCoverageModulationModeNV" ) );
          vkCmdSetCoverageModulationTableEnableNV =
            PFN_vkCmdSetCoverageModulationTableEnableNV( vkGetDeviceProcAddr( device, "vkCmdSetCoverageModulationTableEnableNV" ) );
          vkCmdSetCoverageModulationTableNV = PFN_vkCmdSetCoverageModulationTableNV( vkGetDeviceProcAddr( device, "vkCmdSetCoverageModulationTableNV" ) );
          vkCmdSetShadingRateImageEnableNV  = PFN_vkCmdSetShadingRateImageEnableNV( vkGetDeviceProcAddr( device, "vkCmdSetShadingRateImageEnableNV" ) );
          vkCmdSetRepresentativeFragmentTestEnableNV =
            PFN_vkCmdSetRepresentativeFragmentTestEnableNV( vkGetDeviceProcAddr( device, "vkCmdSetRepresentativeFragmentTestEnableNV" ) );
          vkCmdSetCoverageReductionModeNV = PFN_vkCmdSetCoverageReductionModeNV( vkGetDeviceProcAddr( device, "vkCmdSetCoverageReductionModeNV" ) );

          //=== VK_ARM_tensors ===
          vkCreateTensorARM                = PFN_vkCreateTensorARM( vkGetDeviceProcAddr( device, "vkCreateTensorARM" ) );
          vkDestroyTensorARM               = PFN_vkDestroyTensorARM( vkGetDeviceProcAddr( device, "vkDestroyTensorARM" ) );
          vkCreateTensorViewARM            = PFN_vkCreateTensorViewARM( vkGetDeviceProcAddr( device, "vkCreateTensorViewARM" ) );
          vkDestroyTensorViewARM           = PFN_vkDestroyTensorViewARM( vkGetDeviceProcAddr( device, "vkDestroyTensorViewARM" ) );
          vkGetTensorMemoryRequirementsARM = PFN_vkGetTensorMemoryRequirementsARM( vkGetDeviceProcAddr( device, "vkGetTensorMemoryRequirementsARM" ) );
          vkBindTensorMemoryARM            = PFN_vkBindTensorMemoryARM( vkGetDeviceProcAddr( device, "vkBindTensorMemoryARM" ) );
          vkGetDeviceTensorMemoryRequirementsARM =
            PFN_vkGetDeviceTensorMemoryRequirementsARM( vkGetDeviceProcAddr( device, "vkGetDeviceTensorMemoryRequirementsARM" ) );
          vkCmdCopyTensorARM = PFN_vkCmdCopyTensorARM( vkGetDeviceProcAddr( device, "vkCmdCopyTensorARM" ) );
          vkGetTensorOpaqueCaptureDescriptorDataARM =
            PFN_vkGetTensorOpaqueCaptureDescriptorDataARM( vkGetDeviceProcAddr( device, "vkGetTensorOpaqueCaptureDescriptorDataARM" ) );
          vkGetTensorViewOpaqueCaptureDescriptorDataARM =
            PFN_vkGetTensorViewOpaqueCaptureDescriptorDataARM( vkGetDeviceProcAddr( device, "vkGetTensorViewOpaqueCaptureDescriptorDataARM" ) );

          //=== VK_EXT_shader_module_identifier ===
          vkGetShaderModuleIdentifierEXT = PFN_vkGetShaderModuleIdentifierEXT( vkGetDeviceProcAddr( device, "vkGetShaderModuleIdentifierEXT" ) );
          vkGetShaderModuleCreateInfoIdentifierEXT =
            PFN_vkGetShaderModuleCreateInfoIdentifierEXT( vkGetDeviceProcAddr( device, "vkGetShaderModuleCreateInfoIdentifierEXT" ) );

          //=== VK_NV_optical_flow ===
          vkCreateOpticalFlowSessionNV    = PFN_vkCreateOpticalFlowSessionNV( vkGetDeviceProcAddr( device, "vkCreateOpticalFlowSessionNV" ) );
          vkDestroyOpticalFlowSessionNV   = PFN_vkDestroyOpticalFlowSessionNV( vkGetDeviceProcAddr( device, "vkDestroyOpticalFlowSessionNV" ) );
          vkBindOpticalFlowSessionImageNV = PFN_vkBindOpticalFlowSessionImageNV( vkGetDeviceProcAddr( device, "vkBindOpticalFlowSessionImageNV" ) );
          vkCmdOpticalFlowExecuteNV       = PFN_vkCmdOpticalFlowExecuteNV( vkGetDeviceProcAddr( device, "vkCmdOpticalFlowExecuteNV" ) );

          //=== VK_KHR_maintenance5 ===
          vkCmdBindIndexBuffer2KHR = PFN_vkCmdBindIndexBuffer2KHR( vkGetDeviceProcAddr( device, "vkCmdBindIndexBuffer2KHR" ) );
          if ( !vkCmdBindIndexBuffer2 )
            vkCmdBindIndexBuffer2 = vkCmdBindIndexBuffer2KHR;
          vkGetRenderingAreaGranularityKHR = PFN_vkGetRenderingAreaGranularityKHR( vkGetDeviceProcAddr( device, "vkGetRenderingAreaGranularityKHR" ) );
          if ( !vkGetRenderingAreaGranularity )
            vkGetRenderingAreaGranularity = vkGetRenderingAreaGranularityKHR;
          vkGetDeviceImageSubresourceLayoutKHR =
            PFN_vkGetDeviceImageSubresourceLayoutKHR( vkGetDeviceProcAddr( device, "vkGetDeviceImageSubresourceLayoutKHR" ) );
          if ( !vkGetDeviceImageSubresourceLayout )
            vkGetDeviceImageSubresourceLayout = vkGetDeviceImageSubresourceLayoutKHR;
          vkGetImageSubresourceLayout2KHR = PFN_vkGetImageSubresourceLayout2KHR( vkGetDeviceProcAddr( device, "vkGetImageSubresourceLayout2KHR" ) );
          if ( !vkGetImageSubresourceLayout2 )
            vkGetImageSubresourceLayout2 = vkGetImageSubresourceLayout2KHR;

          //=== VK_AMD_anti_lag ===
          vkAntiLagUpdateAMD = PFN_vkAntiLagUpdateAMD( vkGetDeviceProcAddr( device, "vkAntiLagUpdateAMD" ) );

          //=== VK_KHR_present_wait2 ===
          vkWaitForPresent2KHR = PFN_vkWaitForPresent2KHR( vkGetDeviceProcAddr( device, "vkWaitForPresent2KHR" ) );

          //=== VK_EXT_shader_object ===
          vkCreateShadersEXT         = PFN_vkCreateShadersEXT( vkGetDeviceProcAddr( device, "vkCreateShadersEXT" ) );
          vkDestroyShaderEXT         = PFN_vkDestroyShaderEXT( vkGetDeviceProcAddr( device, "vkDestroyShaderEXT" ) );
          vkGetShaderBinaryDataEXT   = PFN_vkGetShaderBinaryDataEXT( vkGetDeviceProcAddr( device, "vkGetShaderBinaryDataEXT" ) );
          vkCmdBindShadersEXT        = PFN_vkCmdBindShadersEXT( vkGetDeviceProcAddr( device, "vkCmdBindShadersEXT" ) );
          vkCmdSetDepthClampRangeEXT = PFN_vkCmdSetDepthClampRangeEXT( vkGetDeviceProcAddr( device, "vkCmdSetDepthClampRangeEXT" ) );

          //=== VK_KHR_pipeline_binary ===
          vkCreatePipelineBinariesKHR      = PFN_vkCreatePipelineBinariesKHR( vkGetDeviceProcAddr( device, "vkCreatePipelineBinariesKHR" ) );
          vkDestroyPipelineBinaryKHR       = PFN_vkDestroyPipelineBinaryKHR( vkGetDeviceProcAddr( device, "vkDestroyPipelineBinaryKHR" ) );
          vkGetPipelineKeyKHR              = PFN_vkGetPipelineKeyKHR( vkGetDeviceProcAddr( device, "vkGetPipelineKeyKHR" ) );
          vkGetPipelineBinaryDataKHR       = PFN_vkGetPipelineBinaryDataKHR( vkGetDeviceProcAddr( device, "vkGetPipelineBinaryDataKHR" ) );
          vkReleaseCapturedPipelineDataKHR = PFN_vkReleaseCapturedPipelineDataKHR( vkGetDeviceProcAddr( device, "vkReleaseCapturedPipelineDataKHR" ) );

          //=== VK_QCOM_tile_properties ===
          vkGetFramebufferTilePropertiesQCOM = PFN_vkGetFramebufferTilePropertiesQCOM( vkGetDeviceProcAddr( device, "vkGetFramebufferTilePropertiesQCOM" ) );
          vkGetDynamicRenderingTilePropertiesQCOM =
            PFN_vkGetDynamicRenderingTilePropertiesQCOM( vkGetDeviceProcAddr( device, "vkGetDynamicRenderingTilePropertiesQCOM" ) );

          //=== VK_KHR_swapchain_maintenance1 ===
          vkReleaseSwapchainImagesKHR = PFN_vkReleaseSwapchainImagesKHR( vkGetDeviceProcAddr( device, "vkReleaseSwapchainImagesKHR" ) );

          //=== VK_NV_cooperative_vector ===
          vkConvertCooperativeVectorMatrixNV = PFN_vkConvertCooperativeVectorMatrixNV( vkGetDeviceProcAddr( device, "vkConvertCooperativeVectorMatrixNV" ) );
          vkCmdConvertCooperativeVectorMatrixNV =
            PFN_vkCmdConvertCooperativeVectorMatrixNV( vkGetDeviceProcAddr( device, "vkCmdConvertCooperativeVectorMatrixNV" ) );

          //=== VK_NV_low_latency2 ===
          vkSetLatencySleepModeNV  = PFN_vkSetLatencySleepModeNV( vkGetDeviceProcAddr( device, "vkSetLatencySleepModeNV" ) );
          vkLatencySleepNV         = PFN_vkLatencySleepNV( vkGetDeviceProcAddr( device, "vkLatencySleepNV" ) );
          vkSetLatencyMarkerNV     = PFN_vkSetLatencyMarkerNV( vkGetDeviceProcAddr( device, "vkSetLatencyMarkerNV" ) );
          vkGetLatencyTimingsNV    = PFN_vkGetLatencyTimingsNV( vkGetDeviceProcAddr( device, "vkGetLatencyTimingsNV" ) );
          vkQueueNotifyOutOfBandNV = PFN_vkQueueNotifyOutOfBandNV( vkGetDeviceProcAddr( device, "vkQueueNotifyOutOfBandNV" ) );

          //=== VK_ARM_data_graph ===
          vkCreateDataGraphPipelinesARM       = PFN_vkCreateDataGraphPipelinesARM( vkGetDeviceProcAddr( device, "vkCreateDataGraphPipelinesARM" ) );
          vkCreateDataGraphPipelineSessionARM = PFN_vkCreateDataGraphPipelineSessionARM( vkGetDeviceProcAddr( device, "vkCreateDataGraphPipelineSessionARM" ) );
          vkGetDataGraphPipelineSessionBindPointRequirementsARM =
            PFN_vkGetDataGraphPipelineSessionBindPointRequirementsARM( vkGetDeviceProcAddr( device, "vkGetDataGraphPipelineSessionBindPointRequirementsARM" ) );
          vkGetDataGraphPipelineSessionMemoryRequirementsARM =
            PFN_vkGetDataGraphPipelineSessionMemoryRequirementsARM( vkGetDeviceProcAddr( device, "vkGetDataGraphPipelineSessionMemoryRequirementsARM" ) );
          vkBindDataGraphPipelineSessionMemoryARM =
            PFN_vkBindDataGraphPipelineSessionMemoryARM( vkGetDeviceProcAddr( device, "vkBindDataGraphPipelineSessionMemoryARM" ) );
          vkDestroyDataGraphPipelineSessionARM =
            PFN_vkDestroyDataGraphPipelineSessionARM( vkGetDeviceProcAddr( device, "vkDestroyDataGraphPipelineSessionARM" ) );
          vkCmdDispatchDataGraphARM = PFN_vkCmdDispatchDataGraphARM( vkGetDeviceProcAddr( device, "vkCmdDispatchDataGraphARM" ) );
          vkGetDataGraphPipelineAvailablePropertiesARM =
            PFN_vkGetDataGraphPipelineAvailablePropertiesARM( vkGetDeviceProcAddr( device, "vkGetDataGraphPipelineAvailablePropertiesARM" ) );
          vkGetDataGraphPipelinePropertiesARM = PFN_vkGetDataGraphPipelinePropertiesARM( vkGetDeviceProcAddr( device, "vkGetDataGraphPipelinePropertiesARM" ) );

          //=== VK_EXT_attachment_feedback_loop_dynamic_state ===
          vkCmdSetAttachmentFeedbackLoopEnableEXT =
            PFN_vkCmdSetAttachmentFeedbackLoopEnableEXT( vkGetDeviceProcAddr( device, "vkCmdSetAttachmentFeedbackLoopEnableEXT" ) );

#  if defined( VK_USE_PLATFORM_SCREEN_QNX )
          //=== VK_QNX_external_memory_screen_buffer ===
          vkGetScreenBufferPropertiesQNX = PFN_vkGetScreenBufferPropertiesQNX( vkGetDeviceProcAddr( device, "vkGetScreenBufferPropertiesQNX" ) );
#  endif /*VK_USE_PLATFORM_SCREEN_QNX*/

          //=== VK_KHR_line_rasterization ===
          vkCmdSetLineStippleKHR = PFN_vkCmdSetLineStippleKHR( vkGetDeviceProcAddr( device, "vkCmdSetLineStippleKHR" ) );
          if ( !vkCmdSetLineStipple )
            vkCmdSetLineStipple = vkCmdSetLineStippleKHR;

          //=== VK_KHR_calibrated_timestamps ===
          vkGetCalibratedTimestampsKHR = PFN_vkGetCalibratedTimestampsKHR( vkGetDeviceProcAddr( device, "vkGetCalibratedTimestampsKHR" ) );

          //=== VK_KHR_maintenance6 ===
          vkCmdBindDescriptorSets2KHR = PFN_vkCmdBindDescriptorSets2KHR( vkGetDeviceProcAddr( device, "vkCmdBindDescriptorSets2KHR" ) );
          if ( !vkCmdBindDescriptorSets2 )
            vkCmdBindDescriptorSets2 = vkCmdBindDescriptorSets2KHR;
          vkCmdPushConstants2KHR = PFN_vkCmdPushConstants2KHR( vkGetDeviceProcAddr( device, "vkCmdPushConstants2KHR" ) );
          if ( !vkCmdPushConstants2 )
            vkCmdPushConstants2 = vkCmdPushConstants2KHR;
          vkCmdPushDescriptorSet2KHR = PFN_vkCmdPushDescriptorSet2KHR( vkGetDeviceProcAddr( device, "vkCmdPushDescriptorSet2KHR" ) );
          if ( !vkCmdPushDescriptorSet2 )
            vkCmdPushDescriptorSet2 = vkCmdPushDescriptorSet2KHR;
          vkCmdPushDescriptorSetWithTemplate2KHR =
            PFN_vkCmdPushDescriptorSetWithTemplate2KHR( vkGetDeviceProcAddr( device, "vkCmdPushDescriptorSetWithTemplate2KHR" ) );
          if ( !vkCmdPushDescriptorSetWithTemplate2 )
            vkCmdPushDescriptorSetWithTemplate2 = vkCmdPushDescriptorSetWithTemplate2KHR;
          vkCmdSetDescriptorBufferOffsets2EXT = PFN_vkCmdSetDescriptorBufferOffsets2EXT( vkGetDeviceProcAddr( device, "vkCmdSetDescriptorBufferOffsets2EXT" ) );
          vkCmdBindDescriptorBufferEmbeddedSamplers2EXT =
            PFN_vkCmdBindDescriptorBufferEmbeddedSamplers2EXT( vkGetDeviceProcAddr( device, "vkCmdBindDescriptorBufferEmbeddedSamplers2EXT" ) );

          //=== VK_QCOM_tile_memory_heap ===
          vkCmdBindTileMemoryQCOM = PFN_vkCmdBindTileMemoryQCOM( vkGetDeviceProcAddr( device, "vkCmdBindTileMemoryQCOM" ) );

          //=== VK_KHR_copy_memory_indirect ===
          vkCmdCopyMemoryIndirectKHR        = PFN_vkCmdCopyMemoryIndirectKHR( vkGetDeviceProcAddr( device, "vkCmdCopyMemoryIndirectKHR" ) );
          vkCmdCopyMemoryToImageIndirectKHR = PFN_vkCmdCopyMemoryToImageIndirectKHR( vkGetDeviceProcAddr( device, "vkCmdCopyMemoryToImageIndirectKHR" ) );

          //=== VK_EXT_memory_decompression ===
          vkCmdDecompressMemoryEXT = PFN_vkCmdDecompressMemoryEXT( vkGetDeviceProcAddr( device, "vkCmdDecompressMemoryEXT" ) );
          vkCmdDecompressMemoryIndirectCountEXT =
            PFN_vkCmdDecompressMemoryIndirectCountEXT( vkGetDeviceProcAddr( device, "vkCmdDecompressMemoryIndirectCountEXT" ) );

          //=== VK_NV_external_compute_queue ===
          vkCreateExternalComputeQueueNV  = PFN_vkCreateExternalComputeQueueNV( vkGetDeviceProcAddr( device, "vkCreateExternalComputeQueueNV" ) );
          vkDestroyExternalComputeQueueNV = PFN_vkDestroyExternalComputeQueueNV( vkGetDeviceProcAddr( device, "vkDestroyExternalComputeQueueNV" ) );
          vkGetExternalComputeQueueDataNV = PFN_vkGetExternalComputeQueueDataNV( vkGetDeviceProcAddr( device, "vkGetExternalComputeQueueDataNV" ) );

          //=== VK_NV_cluster_acceleration_structure ===
          vkGetClusterAccelerationStructureBuildSizesNV =
            PFN_vkGetClusterAccelerationStructureBuildSizesNV( vkGetDeviceProcAddr( device, "vkGetClusterAccelerationStructureBuildSizesNV" ) );
          vkCmdBuildClusterAccelerationStructureIndirectNV =
            PFN_vkCmdBuildClusterAccelerationStructureIndirectNV( vkGetDeviceProcAddr( device, "vkCmdBuildClusterAccelerationStructureIndirectNV" ) );

          //=== VK_NV_partitioned_acceleration_structure ===
          vkGetPartitionedAccelerationStructuresBuildSizesNV =
            PFN_vkGetPartitionedAccelerationStructuresBuildSizesNV( vkGetDeviceProcAddr( device, "vkGetPartitionedAccelerationStructuresBuildSizesNV" ) );
          vkCmdBuildPartitionedAccelerationStructuresNV =
            PFN_vkCmdBuildPartitionedAccelerationStructuresNV( vkGetDeviceProcAddr( device, "vkCmdBuildPartitionedAccelerationStructuresNV" ) );

          //=== VK_EXT_device_generated_commands ===
          vkGetGeneratedCommandsMemoryRequirementsEXT =
            PFN_vkGetGeneratedCommandsMemoryRequirementsEXT( vkGetDeviceProcAddr( device, "vkGetGeneratedCommandsMemoryRequirementsEXT" ) );
          vkCmdPreprocessGeneratedCommandsEXT = PFN_vkCmdPreprocessGeneratedCommandsEXT( vkGetDeviceProcAddr( device, "vkCmdPreprocessGeneratedCommandsEXT" ) );
          vkCmdExecuteGeneratedCommandsEXT    = PFN_vkCmdExecuteGeneratedCommandsEXT( vkGetDeviceProcAddr( device, "vkCmdExecuteGeneratedCommandsEXT" ) );
          vkCreateIndirectCommandsLayoutEXT   = PFN_vkCreateIndirectCommandsLayoutEXT( vkGetDeviceProcAddr( device, "vkCreateIndirectCommandsLayoutEXT" ) );
          vkDestroyIndirectCommandsLayoutEXT  = PFN_vkDestroyIndirectCommandsLayoutEXT( vkGetDeviceProcAddr( device, "vkDestroyIndirectCommandsLayoutEXT" ) );
          vkCreateIndirectExecutionSetEXT     = PFN_vkCreateIndirectExecutionSetEXT( vkGetDeviceProcAddr( device, "vkCreateIndirectExecutionSetEXT" ) );
          vkDestroyIndirectExecutionSetEXT    = PFN_vkDestroyIndirectExecutionSetEXT( vkGetDeviceProcAddr( device, "vkDestroyIndirectExecutionSetEXT" ) );
          vkUpdateIndirectExecutionSetPipelineEXT =
            PFN_vkUpdateIndirectExecutionSetPipelineEXT( vkGetDeviceProcAddr( device, "vkUpdateIndirectExecutionSetPipelineEXT" ) );
          vkUpdateIndirectExecutionSetShaderEXT =
            PFN_vkUpdateIndirectExecutionSetShaderEXT( vkGetDeviceProcAddr( device, "vkUpdateIndirectExecutionSetShaderEXT" ) );

#  if defined( VK_USE_PLATFORM_OHOS )
          //=== VK_OHOS_native_buffer ===
          vkGetSwapchainGrallocUsageOHOS = PFN_vkGetSwapchainGrallocUsageOHOS( vkGetDeviceProcAddr( device, "vkGetSwapchainGrallocUsageOHOS" ) );
          vkAcquireImageOHOS             = PFN_vkAcquireImageOHOS( vkGetDeviceProcAddr( device, "vkAcquireImageOHOS" ) );
          vkQueueSignalReleaseImageOHOS  = PFN_vkQueueSignalReleaseImageOHOS( vkGetDeviceProcAddr( device, "vkQueueSignalReleaseImageOHOS" ) );
#  endif /*VK_USE_PLATFORM_OHOS*/

#  if defined( VK_USE_PLATFORM_METAL_EXT )
          //=== VK_EXT_external_memory_metal ===
          vkGetMemoryMetalHandleEXT           = PFN_vkGetMemoryMetalHandleEXT( vkGetDeviceProcAddr( device, "vkGetMemoryMetalHandleEXT" ) );
          vkGetMemoryMetalHandlePropertiesEXT = PFN_vkGetMemoryMetalHandlePropertiesEXT( vkGetDeviceProcAddr( device, "vkGetMemoryMetalHandlePropertiesEXT" ) );
#  endif /*VK_USE_PLATFORM_METAL_EXT*/

          //=== VK_EXT_fragment_density_map_offset ===
          vkCmdEndRendering2EXT = PFN_vkCmdEndRendering2EXT( vkGetDeviceProcAddr( device, "vkCmdEndRendering2EXT" ) );
          if ( !vkCmdEndRendering2KHR )
            vkCmdEndRendering2KHR = vkCmdEndRendering2EXT;

          //=== VK_EXT_custom_resolve ===
          vkCmdBeginCustomResolveEXT = PFN_vkCmdBeginCustomResolveEXT( vkGetDeviceProcAddr( device, "vkCmdBeginCustomResolveEXT" ) );

          //=== VK_KHR_maintenance10 ===
          vkCmdEndRendering2KHR = PFN_vkCmdEndRendering2KHR( vkGetDeviceProcAddr( device, "vkCmdEndRendering2KHR" ) );
        }

      public:
        //=== VK_VERSION_1_0 ===
        PFN_vkGetDeviceProcAddr                vkGetDeviceProcAddr                = 0;
        PFN_vkDestroyDevice                    vkDestroyDevice                    = 0;
        PFN_vkGetDeviceQueue                   vkGetDeviceQueue                   = 0;
        PFN_vkQueueSubmit                      vkQueueSubmit                      = 0;
        PFN_vkQueueWaitIdle                    vkQueueWaitIdle                    = 0;
        PFN_vkDeviceWaitIdle                   vkDeviceWaitIdle                   = 0;
        PFN_vkAllocateMemory                   vkAllocateMemory                   = 0;
        PFN_vkFreeMemory                       vkFreeMemory                       = 0;
        PFN_vkMapMemory                        vkMapMemory                        = 0;
        PFN_vkUnmapMemory                      vkUnmapMemory                      = 0;
        PFN_vkFlushMappedMemoryRanges          vkFlushMappedMemoryRanges          = 0;
        PFN_vkInvalidateMappedMemoryRanges     vkInvalidateMappedMemoryRanges     = 0;
        PFN_vkGetDeviceMemoryCommitment        vkGetDeviceMemoryCommitment        = 0;
        PFN_vkBindBufferMemory                 vkBindBufferMemory                 = 0;
        PFN_vkBindImageMemory                  vkBindImageMemory                  = 0;
        PFN_vkGetBufferMemoryRequirements      vkGetBufferMemoryRequirements      = 0;
        PFN_vkGetImageMemoryRequirements       vkGetImageMemoryRequirements       = 0;
        PFN_vkGetImageSparseMemoryRequirements vkGetImageSparseMemoryRequirements = 0;
        PFN_vkQueueBindSparse                  vkQueueBindSparse                  = 0;
        PFN_vkCreateFence                      vkCreateFence                      = 0;
        PFN_vkDestroyFence                     vkDestroyFence                     = 0;
        PFN_vkResetFences                      vkResetFences                      = 0;
        PFN_vkGetFenceStatus                   vkGetFenceStatus                   = 0;
        PFN_vkWaitForFences                    vkWaitForFences                    = 0;
        PFN_vkCreateSemaphore                  vkCreateSemaphore                  = 0;
        PFN_vkDestroySemaphore                 vkDestroySemaphore                 = 0;
        PFN_vkCreateQueryPool                  vkCreateQueryPool                  = 0;
        PFN_vkDestroyQueryPool                 vkDestroyQueryPool                 = 0;
        PFN_vkGetQueryPoolResults              vkGetQueryPoolResults              = 0;
        PFN_vkCreateBuffer                     vkCreateBuffer                     = 0;
        PFN_vkDestroyBuffer                    vkDestroyBuffer                    = 0;
        PFN_vkCreateImage                      vkCreateImage                      = 0;
        PFN_vkDestroyImage                     vkDestroyImage                     = 0;
        PFN_vkGetImageSubresourceLayout        vkGetImageSubresourceLayout        = 0;
        PFN_vkCreateImageView                  vkCreateImageView                  = 0;
        PFN_vkDestroyImageView                 vkDestroyImageView                 = 0;
        PFN_vkCreateCommandPool                vkCreateCommandPool                = 0;
        PFN_vkDestroyCommandPool               vkDestroyCommandPool               = 0;
        PFN_vkResetCommandPool                 vkResetCommandPool                 = 0;
        PFN_vkAllocateCommandBuffers           vkAllocateCommandBuffers           = 0;
        PFN_vkFreeCommandBuffers               vkFreeCommandBuffers               = 0;
        PFN_vkBeginCommandBuffer               vkBeginCommandBuffer               = 0;
        PFN_vkEndCommandBuffer                 vkEndCommandBuffer                 = 0;
        PFN_vkResetCommandBuffer               vkResetCommandBuffer               = 0;
        PFN_vkCmdCopyBuffer                    vkCmdCopyBuffer                    = 0;
        PFN_vkCmdCopyImage                     vkCmdCopyImage                     = 0;
        PFN_vkCmdCopyBufferToImage             vkCmdCopyBufferToImage             = 0;
        PFN_vkCmdCopyImageToBuffer             vkCmdCopyImageToBuffer             = 0;
        PFN_vkCmdUpdateBuffer                  vkCmdUpdateBuffer                  = 0;
        PFN_vkCmdFillBuffer                    vkCmdFillBuffer                    = 0;
        PFN_vkCmdPipelineBarrier               vkCmdPipelineBarrier               = 0;
        PFN_vkCmdBeginQuery                    vkCmdBeginQuery                    = 0;
        PFN_vkCmdEndQuery                      vkCmdEndQuery                      = 0;
        PFN_vkCmdResetQueryPool                vkCmdResetQueryPool                = 0;
        PFN_vkCmdWriteTimestamp                vkCmdWriteTimestamp                = 0;
        PFN_vkCmdCopyQueryPoolResults          vkCmdCopyQueryPoolResults          = 0;
        PFN_vkCmdExecuteCommands               vkCmdExecuteCommands               = 0;
        PFN_vkCreateEvent                      vkCreateEvent                      = 0;
        PFN_vkDestroyEvent                     vkDestroyEvent                     = 0;
        PFN_vkGetEventStatus                   vkGetEventStatus                   = 0;
        PFN_vkSetEvent                         vkSetEvent                         = 0;
        PFN_vkResetEvent                       vkResetEvent                       = 0;
        PFN_vkCreateBufferView                 vkCreateBufferView                 = 0;
        PFN_vkDestroyBufferView                vkDestroyBufferView                = 0;
        PFN_vkCreateShaderModule               vkCreateShaderModule               = 0;
        PFN_vkDestroyShaderModule              vkDestroyShaderModule              = 0;
        PFN_vkCreatePipelineCache              vkCreatePipelineCache              = 0;
        PFN_vkDestroyPipelineCache             vkDestroyPipelineCache             = 0;
        PFN_vkGetPipelineCacheData             vkGetPipelineCacheData             = 0;
        PFN_vkMergePipelineCaches              vkMergePipelineCaches              = 0;
        PFN_vkCreateComputePipelines           vkCreateComputePipelines           = 0;
        PFN_vkDestroyPipeline                  vkDestroyPipeline                  = 0;
        PFN_vkCreatePipelineLayout             vkCreatePipelineLayout             = 0;
        PFN_vkDestroyPipelineLayout            vkDestroyPipelineLayout            = 0;
        PFN_vkCreateSampler                    vkCreateSampler                    = 0;
        PFN_vkDestroySampler                   vkDestroySampler                   = 0;
        PFN_vkCreateDescriptorSetLayout        vkCreateDescriptorSetLayout        = 0;
        PFN_vkDestroyDescriptorSetLayout       vkDestroyDescriptorSetLayout       = 0;
        PFN_vkCreateDescriptorPool             vkCreateDescriptorPool             = 0;
        PFN_vkDestroyDescriptorPool            vkDestroyDescriptorPool            = 0;
        PFN_vkResetDescriptorPool              vkResetDescriptorPool              = 0;
        PFN_vkAllocateDescriptorSets           vkAllocateDescriptorSets           = 0;
        PFN_vkFreeDescriptorSets               vkFreeDescriptorSets               = 0;
        PFN_vkUpdateDescriptorSets             vkUpdateDescriptorSets             = 0;
        PFN_vkCmdBindPipeline                  vkCmdBindPipeline                  = 0;
        PFN_vkCmdBindDescriptorSets            vkCmdBindDescriptorSets            = 0;
        PFN_vkCmdClearColorImage               vkCmdClearColorImage               = 0;
        PFN_vkCmdDispatch                      vkCmdDispatch                      = 0;
        PFN_vkCmdDispatchIndirect              vkCmdDispatchIndirect              = 0;
        PFN_vkCmdSetEvent                      vkCmdSetEvent                      = 0;
        PFN_vkCmdResetEvent                    vkCmdResetEvent                    = 0;
        PFN_vkCmdWaitEvents                    vkCmdWaitEvents                    = 0;
        PFN_vkCmdPushConstants                 vkCmdPushConstants                 = 0;
        PFN_vkCreateGraphicsPipelines          vkCreateGraphicsPipelines          = 0;
        PFN_vkCreateFramebuffer                vkCreateFramebuffer                = 0;
        PFN_vkDestroyFramebuffer               vkDestroyFramebuffer               = 0;
        PFN_vkCreateRenderPass                 vkCreateRenderPass                 = 0;
        PFN_vkDestroyRenderPass                vkDestroyRenderPass                = 0;
        PFN_vkGetRenderAreaGranularity         vkGetRenderAreaGranularity         = 0;
        PFN_vkCmdSetViewport                   vkCmdSetViewport                   = 0;
        PFN_vkCmdSetScissor                    vkCmdSetScissor                    = 0;
        PFN_vkCmdSetLineWidth                  vkCmdSetLineWidth                  = 0;
        PFN_vkCmdSetDepthBias                  vkCmdSetDepthBias                  = 0;
        PFN_vkCmdSetBlendConstants             vkCmdSetBlendConstants             = 0;
        PFN_vkCmdSetDepthBounds                vkCmdSetDepthBounds                = 0;
        PFN_vkCmdSetStencilCompareMask         vkCmdSetStencilCompareMask         = 0;
        PFN_vkCmdSetStencilWriteMask           vkCmdSetStencilWriteMask           = 0;
        PFN_vkCmdSetStencilReference           vkCmdSetStencilReference           = 0;
        PFN_vkCmdBindIndexBuffer               vkCmdBindIndexBuffer               = 0;
        PFN_vkCmdBindVertexBuffers             vkCmdBindVertexBuffers             = 0;
        PFN_vkCmdDraw                          vkCmdDraw                          = 0;
        PFN_vkCmdDrawIndexed                   vkCmdDrawIndexed                   = 0;
        PFN_vkCmdDrawIndirect                  vkCmdDrawIndirect                  = 0;
        PFN_vkCmdDrawIndexedIndirect           vkCmdDrawIndexedIndirect           = 0;
        PFN_vkCmdBlitImage                     vkCmdBlitImage                     = 0;
        PFN_vkCmdClearDepthStencilImage        vkCmdClearDepthStencilImage        = 0;
        PFN_vkCmdClearAttachments              vkCmdClearAttachments              = 0;
        PFN_vkCmdResolveImage                  vkCmdResolveImage                  = 0;
        PFN_vkCmdBeginRenderPass               vkCmdBeginRenderPass               = 0;
        PFN_vkCmdNextSubpass                   vkCmdNextSubpass                   = 0;
        PFN_vkCmdEndRenderPass                 vkCmdEndRenderPass                 = 0;

        //=== VK_VERSION_1_1 ===
        PFN_vkBindBufferMemory2                 vkBindBufferMemory2                 = 0;
        PFN_vkBindImageMemory2                  vkBindImageMemory2                  = 0;
        PFN_vkGetDeviceGroupPeerMemoryFeatures  vkGetDeviceGroupPeerMemoryFeatures  = 0;
        PFN_vkCmdSetDeviceMask                  vkCmdSetDeviceMask                  = 0;
        PFN_vkGetImageMemoryRequirements2       vkGetImageMemoryRequirements2       = 0;
        PFN_vkGetBufferMemoryRequirements2      vkGetBufferMemoryRequirements2      = 0;
        PFN_vkGetImageSparseMemoryRequirements2 vkGetImageSparseMemoryRequirements2 = 0;
        PFN_vkTrimCommandPool                   vkTrimCommandPool                   = 0;
        PFN_vkGetDeviceQueue2                   vkGetDeviceQueue2                   = 0;
        PFN_vkCmdDispatchBase                   vkCmdDispatchBase                   = 0;
        PFN_vkCreateDescriptorUpdateTemplate    vkCreateDescriptorUpdateTemplate    = 0;
        PFN_vkDestroyDescriptorUpdateTemplate   vkDestroyDescriptorUpdateTemplate   = 0;
        PFN_vkUpdateDescriptorSetWithTemplate   vkUpdateDescriptorSetWithTemplate   = 0;
        PFN_vkGetDescriptorSetLayoutSupport     vkGetDescriptorSetLayoutSupport     = 0;
        PFN_vkCreateSamplerYcbcrConversion      vkCreateSamplerYcbcrConversion      = 0;
        PFN_vkDestroySamplerYcbcrConversion     vkDestroySamplerYcbcrConversion     = 0;

        //=== VK_VERSION_1_2 ===
        PFN_vkResetQueryPool                      vkResetQueryPool                      = 0;
        PFN_vkGetSemaphoreCounterValue            vkGetSemaphoreCounterValue            = 0;
        PFN_vkWaitSemaphores                      vkWaitSemaphores                      = 0;
        PFN_vkSignalSemaphore                     vkSignalSemaphore                     = 0;
        PFN_vkGetBufferDeviceAddress              vkGetBufferDeviceAddress              = 0;
        PFN_vkGetBufferOpaqueCaptureAddress       vkGetBufferOpaqueCaptureAddress       = 0;
        PFN_vkGetDeviceMemoryOpaqueCaptureAddress vkGetDeviceMemoryOpaqueCaptureAddress = 0;
        PFN_vkCmdDrawIndirectCount                vkCmdDrawIndirectCount                = 0;
        PFN_vkCmdDrawIndexedIndirectCount         vkCmdDrawIndexedIndirectCount         = 0;
        PFN_vkCreateRenderPass2                   vkCreateRenderPass2                   = 0;
        PFN_vkCmdBeginRenderPass2                 vkCmdBeginRenderPass2                 = 0;
        PFN_vkCmdNextSubpass2                     vkCmdNextSubpass2                     = 0;
        PFN_vkCmdEndRenderPass2                   vkCmdEndRenderPass2                   = 0;

        //=== VK_VERSION_1_3 ===
        PFN_vkCreatePrivateDataSlot                  vkCreatePrivateDataSlot                  = 0;
        PFN_vkDestroyPrivateDataSlot                 vkDestroyPrivateDataSlot                 = 0;
        PFN_vkSetPrivateData                         vkSetPrivateData                         = 0;
        PFN_vkGetPrivateData                         vkGetPrivateData                         = 0;
        PFN_vkCmdPipelineBarrier2                    vkCmdPipelineBarrier2                    = 0;
        PFN_vkCmdWriteTimestamp2                     vkCmdWriteTimestamp2                     = 0;
        PFN_vkQueueSubmit2                           vkQueueSubmit2                           = 0;
        PFN_vkCmdCopyBuffer2                         vkCmdCopyBuffer2                         = 0;
        PFN_vkCmdCopyImage2                          vkCmdCopyImage2                          = 0;
        PFN_vkCmdCopyBufferToImage2                  vkCmdCopyBufferToImage2                  = 0;
        PFN_vkCmdCopyImageToBuffer2                  vkCmdCopyImageToBuffer2                  = 0;
        PFN_vkGetDeviceBufferMemoryRequirements      vkGetDeviceBufferMemoryRequirements      = 0;
        PFN_vkGetDeviceImageMemoryRequirements       vkGetDeviceImageMemoryRequirements       = 0;
        PFN_vkGetDeviceImageSparseMemoryRequirements vkGetDeviceImageSparseMemoryRequirements = 0;
        PFN_vkCmdSetEvent2                           vkCmdSetEvent2                           = 0;
        PFN_vkCmdResetEvent2                         vkCmdResetEvent2                         = 0;
        PFN_vkCmdWaitEvents2                         vkCmdWaitEvents2                         = 0;
        PFN_vkCmdBlitImage2                          vkCmdBlitImage2                          = 0;
        PFN_vkCmdResolveImage2                       vkCmdResolveImage2                       = 0;
        PFN_vkCmdBeginRendering                      vkCmdBeginRendering                      = 0;
        PFN_vkCmdEndRendering                        vkCmdEndRendering                        = 0;
        PFN_vkCmdSetCullMode                         vkCmdSetCullMode                         = 0;
        PFN_vkCmdSetFrontFace                        vkCmdSetFrontFace                        = 0;
        PFN_vkCmdSetPrimitiveTopology                vkCmdSetPrimitiveTopology                = 0;
        PFN_vkCmdSetViewportWithCount                vkCmdSetViewportWithCount                = 0;
        PFN_vkCmdSetScissorWithCount                 vkCmdSetScissorWithCount                 = 0;
        PFN_vkCmdBindVertexBuffers2                  vkCmdBindVertexBuffers2                  = 0;
        PFN_vkCmdSetDepthTestEnable                  vkCmdSetDepthTestEnable                  = 0;
        PFN_vkCmdSetDepthWriteEnable                 vkCmdSetDepthWriteEnable                 = 0;
        PFN_vkCmdSetDepthCompareOp                   vkCmdSetDepthCompareOp                   = 0;
        PFN_vkCmdSetDepthBoundsTestEnable            vkCmdSetDepthBoundsTestEnable            = 0;
        PFN_vkCmdSetStencilTestEnable                vkCmdSetStencilTestEnable                = 0;
        PFN_vkCmdSetStencilOp                        vkCmdSetStencilOp                        = 0;
        PFN_vkCmdSetRasterizerDiscardEnable          vkCmdSetRasterizerDiscardEnable          = 0;
        PFN_vkCmdSetDepthBiasEnable                  vkCmdSetDepthBiasEnable                  = 0;
        PFN_vkCmdSetPrimitiveRestartEnable           vkCmdSetPrimitiveRestartEnable           = 0;

        //=== VK_VERSION_1_4 ===
        PFN_vkMapMemory2                            vkMapMemory2                            = 0;
        PFN_vkUnmapMemory2                          vkUnmapMemory2                          = 0;
        PFN_vkGetDeviceImageSubresourceLayout       vkGetDeviceImageSubresourceLayout       = 0;
        PFN_vkGetImageSubresourceLayout2            vkGetImageSubresourceLayout2            = 0;
        PFN_vkCopyMemoryToImage                     vkCopyMemoryToImage                     = 0;
        PFN_vkCopyImageToMemory                     vkCopyImageToMemory                     = 0;
        PFN_vkCopyImageToImage                      vkCopyImageToImage                      = 0;
        PFN_vkTransitionImageLayout                 vkTransitionImageLayout                 = 0;
        PFN_vkCmdPushDescriptorSet                  vkCmdPushDescriptorSet                  = 0;
        PFN_vkCmdPushDescriptorSetWithTemplate      vkCmdPushDescriptorSetWithTemplate      = 0;
        PFN_vkCmdBindDescriptorSets2                vkCmdBindDescriptorSets2                = 0;
        PFN_vkCmdPushConstants2                     vkCmdPushConstants2                     = 0;
        PFN_vkCmdPushDescriptorSet2                 vkCmdPushDescriptorSet2                 = 0;
        PFN_vkCmdPushDescriptorSetWithTemplate2     vkCmdPushDescriptorSetWithTemplate2     = 0;
        PFN_vkCmdSetLineStipple                     vkCmdSetLineStipple                     = 0;
        PFN_vkCmdBindIndexBuffer2                   vkCmdBindIndexBuffer2                   = 0;
        PFN_vkGetRenderingAreaGranularity           vkGetRenderingAreaGranularity           = 0;
        PFN_vkCmdSetRenderingAttachmentLocations    vkCmdSetRenderingAttachmentLocations    = 0;
        PFN_vkCmdSetRenderingInputAttachmentIndices vkCmdSetRenderingInputAttachmentIndices = 0;

        //=== VK_KHR_swapchain ===
        PFN_vkCreateSwapchainKHR                   vkCreateSwapchainKHR                   = 0;
        PFN_vkDestroySwapchainKHR                  vkDestroySwapchainKHR                  = 0;
        PFN_vkGetSwapchainImagesKHR                vkGetSwapchainImagesKHR                = 0;
        PFN_vkAcquireNextImageKHR                  vkAcquireNextImageKHR                  = 0;
        PFN_vkQueuePresentKHR                      vkQueuePresentKHR                      = 0;
        PFN_vkGetDeviceGroupPresentCapabilitiesKHR vkGetDeviceGroupPresentCapabilitiesKHR = 0;
        PFN_vkGetDeviceGroupSurfacePresentModesKHR vkGetDeviceGroupSurfacePresentModesKHR = 0;
        PFN_vkAcquireNextImage2KHR                 vkAcquireNextImage2KHR                 = 0;

        //=== VK_KHR_display_swapchain ===
        PFN_vkCreateSharedSwapchainsKHR vkCreateSharedSwapchainsKHR = 0;

        //=== VK_EXT_debug_marker ===
        PFN_vkDebugMarkerSetObjectTagEXT  vkDebugMarkerSetObjectTagEXT  = 0;
        PFN_vkDebugMarkerSetObjectNameEXT vkDebugMarkerSetObjectNameEXT = 0;
        PFN_vkCmdDebugMarkerBeginEXT      vkCmdDebugMarkerBeginEXT      = 0;
        PFN_vkCmdDebugMarkerEndEXT        vkCmdDebugMarkerEndEXT        = 0;
        PFN_vkCmdDebugMarkerInsertEXT     vkCmdDebugMarkerInsertEXT     = 0;

        //=== VK_KHR_video_queue ===
        PFN_vkCreateVideoSessionKHR                vkCreateVideoSessionKHR                = 0;
        PFN_vkDestroyVideoSessionKHR               vkDestroyVideoSessionKHR               = 0;
        PFN_vkGetVideoSessionMemoryRequirementsKHR vkGetVideoSessionMemoryRequirementsKHR = 0;
        PFN_vkBindVideoSessionMemoryKHR            vkBindVideoSessionMemoryKHR            = 0;
        PFN_vkCreateVideoSessionParametersKHR      vkCreateVideoSessionParametersKHR      = 0;
        PFN_vkUpdateVideoSessionParametersKHR      vkUpdateVideoSessionParametersKHR      = 0;
        PFN_vkDestroyVideoSessionParametersKHR     vkDestroyVideoSessionParametersKHR     = 0;
        PFN_vkCmdBeginVideoCodingKHR               vkCmdBeginVideoCodingKHR               = 0;
        PFN_vkCmdEndVideoCodingKHR                 vkCmdEndVideoCodingKHR                 = 0;
        PFN_vkCmdControlVideoCodingKHR             vkCmdControlVideoCodingKHR             = 0;

        //=== VK_KHR_video_decode_queue ===
        PFN_vkCmdDecodeVideoKHR vkCmdDecodeVideoKHR = 0;

        //=== VK_EXT_transform_feedback ===
        PFN_vkCmdBindTransformFeedbackBuffersEXT vkCmdBindTransformFeedbackBuffersEXT = 0;
        PFN_vkCmdBeginTransformFeedbackEXT       vkCmdBeginTransformFeedbackEXT       = 0;
        PFN_vkCmdEndTransformFeedbackEXT         vkCmdEndTransformFeedbackEXT         = 0;
        PFN_vkCmdBeginQueryIndexedEXT            vkCmdBeginQueryIndexedEXT            = 0;
        PFN_vkCmdEndQueryIndexedEXT              vkCmdEndQueryIndexedEXT              = 0;
        PFN_vkCmdDrawIndirectByteCountEXT        vkCmdDrawIndirectByteCountEXT        = 0;

        //=== VK_NVX_binary_import ===
        PFN_vkCreateCuModuleNVX    vkCreateCuModuleNVX    = 0;
        PFN_vkCreateCuFunctionNVX  vkCreateCuFunctionNVX  = 0;
        PFN_vkDestroyCuModuleNVX   vkDestroyCuModuleNVX   = 0;
        PFN_vkDestroyCuFunctionNVX vkDestroyCuFunctionNVX = 0;
        PFN_vkCmdCuLaunchKernelNVX vkCmdCuLaunchKernelNVX = 0;

        //=== VK_NVX_image_view_handle ===
        PFN_vkGetImageViewHandleNVX   vkGetImageViewHandleNVX   = 0;
        PFN_vkGetImageViewHandle64NVX vkGetImageViewHandle64NVX = 0;
        PFN_vkGetImageViewAddressNVX  vkGetImageViewAddressNVX  = 0;

        //=== VK_AMD_draw_indirect_count ===
        PFN_vkCmdDrawIndirectCountAMD        vkCmdDrawIndirectCountAMD        = 0;
        PFN_vkCmdDrawIndexedIndirectCountAMD vkCmdDrawIndexedIndirectCountAMD = 0;

        //=== VK_AMD_shader_info ===
        PFN_vkGetShaderInfoAMD vkGetShaderInfoAMD = 0;

        //=== VK_KHR_dynamic_rendering ===
        PFN_vkCmdBeginRenderingKHR vkCmdBeginRenderingKHR = 0;
        PFN_vkCmdEndRenderingKHR   vkCmdEndRenderingKHR   = 0;

#  if defined( VK_USE_PLATFORM_WIN32_KHR )
        //=== VK_NV_external_memory_win32 ===
        PFN_vkGetMemoryWin32HandleNV vkGetMemoryWin32HandleNV = 0;
#  else
        PFN_dummy vkGetMemoryWin32HandleNV_placeholder = 0;
#  endif /*VK_USE_PLATFORM_WIN32_KHR*/

        //=== VK_KHR_device_group ===
        PFN_vkGetDeviceGroupPeerMemoryFeaturesKHR vkGetDeviceGroupPeerMemoryFeaturesKHR = 0;
        PFN_vkCmdSetDeviceMaskKHR                 vkCmdSetDeviceMaskKHR                 = 0;
        PFN_vkCmdDispatchBaseKHR                  vkCmdDispatchBaseKHR                  = 0;

        //=== VK_KHR_maintenance1 ===
        PFN_vkTrimCommandPoolKHR vkTrimCommandPoolKHR = 0;

#  if defined( VK_USE_PLATFORM_WIN32_KHR )
        //=== VK_KHR_external_memory_win32 ===
        PFN_vkGetMemoryWin32HandleKHR           vkGetMemoryWin32HandleKHR           = 0;
        PFN_vkGetMemoryWin32HandlePropertiesKHR vkGetMemoryWin32HandlePropertiesKHR = 0;
#  else
        PFN_dummy vkGetMemoryWin32HandleKHR_placeholder           = 0;
        PFN_dummy vkGetMemoryWin32HandlePropertiesKHR_placeholder = 0;
#  endif /*VK_USE_PLATFORM_WIN32_KHR*/

        //=== VK_KHR_external_memory_fd ===
        PFN_vkGetMemoryFdKHR           vkGetMemoryFdKHR           = 0;
        PFN_vkGetMemoryFdPropertiesKHR vkGetMemoryFdPropertiesKHR = 0;

#  if defined( VK_USE_PLATFORM_WIN32_KHR )
        //=== VK_KHR_external_semaphore_win32 ===
        PFN_vkImportSemaphoreWin32HandleKHR vkImportSemaphoreWin32HandleKHR = 0;
        PFN_vkGetSemaphoreWin32HandleKHR    vkGetSemaphoreWin32HandleKHR    = 0;
#  else
        PFN_dummy vkImportSemaphoreWin32HandleKHR_placeholder = 0;
        PFN_dummy vkGetSemaphoreWin32HandleKHR_placeholder    = 0;
#  endif /*VK_USE_PLATFORM_WIN32_KHR*/

        //=== VK_KHR_external_semaphore_fd ===
        PFN_vkImportSemaphoreFdKHR vkImportSemaphoreFdKHR = 0;
        PFN_vkGetSemaphoreFdKHR    vkGetSemaphoreFdKHR    = 0;

        //=== VK_KHR_push_descriptor ===
        PFN_vkCmdPushDescriptorSetKHR             vkCmdPushDescriptorSetKHR             = 0;
        PFN_vkCmdPushDescriptorSetWithTemplateKHR vkCmdPushDescriptorSetWithTemplateKHR = 0;

        //=== VK_EXT_conditional_rendering ===
        PFN_vkCmdBeginConditionalRenderingEXT vkCmdBeginConditionalRenderingEXT = 0;
        PFN_vkCmdEndConditionalRenderingEXT   vkCmdEndConditionalRenderingEXT   = 0;

        //=== VK_KHR_descriptor_update_template ===
        PFN_vkCreateDescriptorUpdateTemplateKHR  vkCreateDescriptorUpdateTemplateKHR  = 0;
        PFN_vkDestroyDescriptorUpdateTemplateKHR vkDestroyDescriptorUpdateTemplateKHR = 0;
        PFN_vkUpdateDescriptorSetWithTemplateKHR vkUpdateDescriptorSetWithTemplateKHR = 0;

        //=== VK_NV_clip_space_w_scaling ===
        PFN_vkCmdSetViewportWScalingNV vkCmdSetViewportWScalingNV = 0;

        //=== VK_EXT_display_control ===
        PFN_vkDisplayPowerControlEXT  vkDisplayPowerControlEXT  = 0;
        PFN_vkRegisterDeviceEventEXT  vkRegisterDeviceEventEXT  = 0;
        PFN_vkRegisterDisplayEventEXT vkRegisterDisplayEventEXT = 0;
        PFN_vkGetSwapchainCounterEXT  vkGetSwapchainCounterEXT  = 0;

        //=== VK_GOOGLE_display_timing ===
        PFN_vkGetRefreshCycleDurationGOOGLE   vkGetRefreshCycleDurationGOOGLE   = 0;
        PFN_vkGetPastPresentationTimingGOOGLE vkGetPastPresentationTimingGOOGLE = 0;

        //=== VK_EXT_discard_rectangles ===
        PFN_vkCmdSetDiscardRectangleEXT       vkCmdSetDiscardRectangleEXT       = 0;
        PFN_vkCmdSetDiscardRectangleEnableEXT vkCmdSetDiscardRectangleEnableEXT = 0;
        PFN_vkCmdSetDiscardRectangleModeEXT   vkCmdSetDiscardRectangleModeEXT   = 0;

        //=== VK_EXT_hdr_metadata ===
        PFN_vkSetHdrMetadataEXT vkSetHdrMetadataEXT = 0;

        //=== VK_KHR_create_renderpass2 ===
        PFN_vkCreateRenderPass2KHR   vkCreateRenderPass2KHR   = 0;
        PFN_vkCmdBeginRenderPass2KHR vkCmdBeginRenderPass2KHR = 0;
        PFN_vkCmdNextSubpass2KHR     vkCmdNextSubpass2KHR     = 0;
        PFN_vkCmdEndRenderPass2KHR   vkCmdEndRenderPass2KHR   = 0;

        //=== VK_KHR_shared_presentable_image ===
        PFN_vkGetSwapchainStatusKHR vkGetSwapchainStatusKHR = 0;

#  if defined( VK_USE_PLATFORM_WIN32_KHR )
        //=== VK_KHR_external_fence_win32 ===
        PFN_vkImportFenceWin32HandleKHR vkImportFenceWin32HandleKHR = 0;
        PFN_vkGetFenceWin32HandleKHR    vkGetFenceWin32HandleKHR    = 0;
#  else
        PFN_dummy vkImportFenceWin32HandleKHR_placeholder = 0;
        PFN_dummy vkGetFenceWin32HandleKHR_placeholder    = 0;
#  endif /*VK_USE_PLATFORM_WIN32_KHR*/

        //=== VK_KHR_external_fence_fd ===
        PFN_vkImportFenceFdKHR vkImportFenceFdKHR = 0;
        PFN_vkGetFenceFdKHR    vkGetFenceFdKHR    = 0;

        //=== VK_KHR_performance_query ===
        PFN_vkAcquireProfilingLockKHR vkAcquireProfilingLockKHR = 0;
        PFN_vkReleaseProfilingLockKHR vkReleaseProfilingLockKHR = 0;

        //=== VK_EXT_debug_utils ===
        PFN_vkSetDebugUtilsObjectNameEXT    vkSetDebugUtilsObjectNameEXT    = 0;
        PFN_vkSetDebugUtilsObjectTagEXT     vkSetDebugUtilsObjectTagEXT     = 0;
        PFN_vkQueueBeginDebugUtilsLabelEXT  vkQueueBeginDebugUtilsLabelEXT  = 0;
        PFN_vkQueueEndDebugUtilsLabelEXT    vkQueueEndDebugUtilsLabelEXT    = 0;
        PFN_vkQueueInsertDebugUtilsLabelEXT vkQueueInsertDebugUtilsLabelEXT = 0;
        PFN_vkCmdBeginDebugUtilsLabelEXT    vkCmdBeginDebugUtilsLabelEXT    = 0;
        PFN_vkCmdEndDebugUtilsLabelEXT      vkCmdEndDebugUtilsLabelEXT      = 0;
        PFN_vkCmdInsertDebugUtilsLabelEXT   vkCmdInsertDebugUtilsLabelEXT   = 0;

#  if defined( VK_USE_PLATFORM_ANDROID_KHR )
        //=== VK_ANDROID_external_memory_android_hardware_buffer ===
        PFN_vkGetAndroidHardwareBufferPropertiesANDROID vkGetAndroidHardwareBufferPropertiesANDROID = 0;
        PFN_vkGetMemoryAndroidHardwareBufferANDROID     vkGetMemoryAndroidHardwareBufferANDROID     = 0;
#  else
        PFN_dummy vkGetAndroidHardwareBufferPropertiesANDROID_placeholder = 0;
        PFN_dummy vkGetMemoryAndroidHardwareBufferANDROID_placeholder     = 0;
#  endif /*VK_USE_PLATFORM_ANDROID_KHR*/

#  if defined( VK_ENABLE_BETA_EXTENSIONS )
        //=== VK_AMDX_shader_enqueue ===
        PFN_vkCreateExecutionGraphPipelinesAMDX        vkCreateExecutionGraphPipelinesAMDX        = 0;
        PFN_vkGetExecutionGraphPipelineScratchSizeAMDX vkGetExecutionGraphPipelineScratchSizeAMDX = 0;
        PFN_vkGetExecutionGraphPipelineNodeIndexAMDX   vkGetExecutionGraphPipelineNodeIndexAMDX   = 0;
        PFN_vkCmdInitializeGraphScratchMemoryAMDX      vkCmdInitializeGraphScratchMemoryAMDX      = 0;
        PFN_vkCmdDispatchGraphAMDX                     vkCmdDispatchGraphAMDX                     = 0;
        PFN_vkCmdDispatchGraphIndirectAMDX             vkCmdDispatchGraphIndirectAMDX             = 0;
        PFN_vkCmdDispatchGraphIndirectCountAMDX        vkCmdDispatchGraphIndirectCountAMDX        = 0;
#  else
        PFN_dummy vkCreateExecutionGraphPipelinesAMDX_placeholder        = 0;
        PFN_dummy vkGetExecutionGraphPipelineScratchSizeAMDX_placeholder = 0;
        PFN_dummy vkGetExecutionGraphPipelineNodeIndexAMDX_placeholder   = 0;
        PFN_dummy vkCmdInitializeGraphScratchMemoryAMDX_placeholder      = 0;
        PFN_dummy vkCmdDispatchGraphAMDX_placeholder                     = 0;
        PFN_dummy vkCmdDispatchGraphIndirectAMDX_placeholder             = 0;
        PFN_dummy vkCmdDispatchGraphIndirectCountAMDX_placeholder        = 0;
#  endif /*VK_ENABLE_BETA_EXTENSIONS*/

        //=== VK_EXT_sample_locations ===
        PFN_vkCmdSetSampleLocationsEXT vkCmdSetSampleLocationsEXT = 0;

        //=== VK_KHR_get_memory_requirements2 ===
        PFN_vkGetImageMemoryRequirements2KHR       vkGetImageMemoryRequirements2KHR       = 0;
        PFN_vkGetBufferMemoryRequirements2KHR      vkGetBufferMemoryRequirements2KHR      = 0;
        PFN_vkGetImageSparseMemoryRequirements2KHR vkGetImageSparseMemoryRequirements2KHR = 0;

        //=== VK_KHR_acceleration_structure ===
        PFN_vkCreateAccelerationStructureKHR                 vkCreateAccelerationStructureKHR                 = 0;
        PFN_vkDestroyAccelerationStructureKHR                vkDestroyAccelerationStructureKHR                = 0;
        PFN_vkCmdBuildAccelerationStructuresKHR              vkCmdBuildAccelerationStructuresKHR              = 0;
        PFN_vkCmdBuildAccelerationStructuresIndirectKHR      vkCmdBuildAccelerationStructuresIndirectKHR      = 0;
        PFN_vkBuildAccelerationStructuresKHR                 vkBuildAccelerationStructuresKHR                 = 0;
        PFN_vkCopyAccelerationStructureKHR                   vkCopyAccelerationStructureKHR                   = 0;
        PFN_vkCopyAccelerationStructureToMemoryKHR           vkCopyAccelerationStructureToMemoryKHR           = 0;
        PFN_vkCopyMemoryToAccelerationStructureKHR           vkCopyMemoryToAccelerationStructureKHR           = 0;
        PFN_vkWriteAccelerationStructuresPropertiesKHR       vkWriteAccelerationStructuresPropertiesKHR       = 0;
        PFN_vkCmdCopyAccelerationStructureKHR                vkCmdCopyAccelerationStructureKHR                = 0;
        PFN_vkCmdCopyAccelerationStructureToMemoryKHR        vkCmdCopyAccelerationStructureToMemoryKHR        = 0;
        PFN_vkCmdCopyMemoryToAccelerationStructureKHR        vkCmdCopyMemoryToAccelerationStructureKHR        = 0;
        PFN_vkGetAccelerationStructureDeviceAddressKHR       vkGetAccelerationStructureDeviceAddressKHR       = 0;
        PFN_vkCmdWriteAccelerationStructuresPropertiesKHR    vkCmdWriteAccelerationStructuresPropertiesKHR    = 0;
        PFN_vkGetDeviceAccelerationStructureCompatibilityKHR vkGetDeviceAccelerationStructureCompatibilityKHR = 0;
        PFN_vkGetAccelerationStructureBuildSizesKHR          vkGetAccelerationStructureBuildSizesKHR          = 0;

        //=== VK_KHR_ray_tracing_pipeline ===
        PFN_vkCmdTraceRaysKHR                                 vkCmdTraceRaysKHR                                 = 0;
        PFN_vkCreateRayTracingPipelinesKHR                    vkCreateRayTracingPipelinesKHR                    = 0;
        PFN_vkGetRayTracingShaderGroupHandlesKHR              vkGetRayTracingShaderGroupHandlesKHR              = 0;
        PFN_vkGetRayTracingCaptureReplayShaderGroupHandlesKHR vkGetRayTracingCaptureReplayShaderGroupHandlesKHR = 0;
        PFN_vkCmdTraceRaysIndirectKHR                         vkCmdTraceRaysIndirectKHR                         = 0;
        PFN_vkGetRayTracingShaderGroupStackSizeKHR            vkGetRayTracingShaderGroupStackSizeKHR            = 0;
        PFN_vkCmdSetRayTracingPipelineStackSizeKHR            vkCmdSetRayTracingPipelineStackSizeKHR            = 0;

        //=== VK_KHR_sampler_ycbcr_conversion ===
        PFN_vkCreateSamplerYcbcrConversionKHR  vkCreateSamplerYcbcrConversionKHR  = 0;
        PFN_vkDestroySamplerYcbcrConversionKHR vkDestroySamplerYcbcrConversionKHR = 0;

        //=== VK_KHR_bind_memory2 ===
        PFN_vkBindBufferMemory2KHR vkBindBufferMemory2KHR = 0;
        PFN_vkBindImageMemory2KHR  vkBindImageMemory2KHR  = 0;

        //=== VK_EXT_image_drm_format_modifier ===
        PFN_vkGetImageDrmFormatModifierPropertiesEXT vkGetImageDrmFormatModifierPropertiesEXT = 0;

        //=== VK_EXT_validation_cache ===
        PFN_vkCreateValidationCacheEXT  vkCreateValidationCacheEXT  = 0;
        PFN_vkDestroyValidationCacheEXT vkDestroyValidationCacheEXT = 0;
        PFN_vkMergeValidationCachesEXT  vkMergeValidationCachesEXT  = 0;
        PFN_vkGetValidationCacheDataEXT vkGetValidationCacheDataEXT = 0;

        //=== VK_NV_shading_rate_image ===
        PFN_vkCmdBindShadingRateImageNV          vkCmdBindShadingRateImageNV          = 0;
        PFN_vkCmdSetViewportShadingRatePaletteNV vkCmdSetViewportShadingRatePaletteNV = 0;
        PFN_vkCmdSetCoarseSampleOrderNV          vkCmdSetCoarseSampleOrderNV          = 0;

        //=== VK_NV_ray_tracing ===
        PFN_vkCreateAccelerationStructureNV                vkCreateAccelerationStructureNV                = 0;
        PFN_vkDestroyAccelerationStructureNV               vkDestroyAccelerationStructureNV               = 0;
        PFN_vkGetAccelerationStructureMemoryRequirementsNV vkGetAccelerationStructureMemoryRequirementsNV = 0;
        PFN_vkBindAccelerationStructureMemoryNV            vkBindAccelerationStructureMemoryNV            = 0;
        PFN_vkCmdBuildAccelerationStructureNV              vkCmdBuildAccelerationStructureNV              = 0;
        PFN_vkCmdCopyAccelerationStructureNV               vkCmdCopyAccelerationStructureNV               = 0;
        PFN_vkCmdTraceRaysNV                               vkCmdTraceRaysNV                               = 0;
        PFN_vkCreateRayTracingPipelinesNV                  vkCreateRayTracingPipelinesNV                  = 0;
        PFN_vkGetRayTracingShaderGroupHandlesNV            vkGetRayTracingShaderGroupHandlesNV            = 0;
        PFN_vkGetAccelerationStructureHandleNV             vkGetAccelerationStructureHandleNV             = 0;
        PFN_vkCmdWriteAccelerationStructuresPropertiesNV   vkCmdWriteAccelerationStructuresPropertiesNV   = 0;
        PFN_vkCompileDeferredNV                            vkCompileDeferredNV                            = 0;

        //=== VK_KHR_maintenance3 ===
        PFN_vkGetDescriptorSetLayoutSupportKHR vkGetDescriptorSetLayoutSupportKHR = 0;

        //=== VK_KHR_draw_indirect_count ===
        PFN_vkCmdDrawIndirectCountKHR        vkCmdDrawIndirectCountKHR        = 0;
        PFN_vkCmdDrawIndexedIndirectCountKHR vkCmdDrawIndexedIndirectCountKHR = 0;

        //=== VK_EXT_external_memory_host ===
        PFN_vkGetMemoryHostPointerPropertiesEXT vkGetMemoryHostPointerPropertiesEXT = 0;

        //=== VK_AMD_buffer_marker ===
        PFN_vkCmdWriteBufferMarkerAMD  vkCmdWriteBufferMarkerAMD  = 0;
        PFN_vkCmdWriteBufferMarker2AMD vkCmdWriteBufferMarker2AMD = 0;

        //=== VK_EXT_calibrated_timestamps ===
        PFN_vkGetCalibratedTimestampsEXT vkGetCalibratedTimestampsEXT = 0;

        //=== VK_NV_mesh_shader ===
        PFN_vkCmdDrawMeshTasksNV              vkCmdDrawMeshTasksNV              = 0;
        PFN_vkCmdDrawMeshTasksIndirectNV      vkCmdDrawMeshTasksIndirectNV      = 0;
        PFN_vkCmdDrawMeshTasksIndirectCountNV vkCmdDrawMeshTasksIndirectCountNV = 0;

        //=== VK_NV_scissor_exclusive ===
        PFN_vkCmdSetExclusiveScissorEnableNV vkCmdSetExclusiveScissorEnableNV = 0;
        PFN_vkCmdSetExclusiveScissorNV       vkCmdSetExclusiveScissorNV       = 0;

        //=== VK_NV_device_diagnostic_checkpoints ===
        PFN_vkCmdSetCheckpointNV        vkCmdSetCheckpointNV        = 0;
        PFN_vkGetQueueCheckpointDataNV  vkGetQueueCheckpointDataNV  = 0;
        PFN_vkGetQueueCheckpointData2NV vkGetQueueCheckpointData2NV = 0;

        //=== VK_KHR_timeline_semaphore ===
        PFN_vkGetSemaphoreCounterValueKHR vkGetSemaphoreCounterValueKHR = 0;
        PFN_vkWaitSemaphoresKHR           vkWaitSemaphoresKHR           = 0;
        PFN_vkSignalSemaphoreKHR          vkSignalSemaphoreKHR          = 0;

        //=== VK_INTEL_performance_query ===
        PFN_vkInitializePerformanceApiINTEL         vkInitializePerformanceApiINTEL         = 0;
        PFN_vkUninitializePerformanceApiINTEL       vkUninitializePerformanceApiINTEL       = 0;
        PFN_vkCmdSetPerformanceMarkerINTEL          vkCmdSetPerformanceMarkerINTEL          = 0;
        PFN_vkCmdSetPerformanceStreamMarkerINTEL    vkCmdSetPerformanceStreamMarkerINTEL    = 0;
        PFN_vkCmdSetPerformanceOverrideINTEL        vkCmdSetPerformanceOverrideINTEL        = 0;
        PFN_vkAcquirePerformanceConfigurationINTEL  vkAcquirePerformanceConfigurationINTEL  = 0;
        PFN_vkReleasePerformanceConfigurationINTEL  vkReleasePerformanceConfigurationINTEL  = 0;
        PFN_vkQueueSetPerformanceConfigurationINTEL vkQueueSetPerformanceConfigurationINTEL = 0;
        PFN_vkGetPerformanceParameterINTEL          vkGetPerformanceParameterINTEL          = 0;

        //=== VK_AMD_display_native_hdr ===
        PFN_vkSetLocalDimmingAMD vkSetLocalDimmingAMD = 0;

        //=== VK_KHR_fragment_shading_rate ===
        PFN_vkCmdSetFragmentShadingRateKHR vkCmdSetFragmentShadingRateKHR = 0;

        //=== VK_KHR_dynamic_rendering_local_read ===
        PFN_vkCmdSetRenderingAttachmentLocationsKHR    vkCmdSetRenderingAttachmentLocationsKHR    = 0;
        PFN_vkCmdSetRenderingInputAttachmentIndicesKHR vkCmdSetRenderingInputAttachmentIndicesKHR = 0;

        //=== VK_EXT_buffer_device_address ===
        PFN_vkGetBufferDeviceAddressEXT vkGetBufferDeviceAddressEXT = 0;

        //=== VK_KHR_present_wait ===
        PFN_vkWaitForPresentKHR vkWaitForPresentKHR = 0;

#  if defined( VK_USE_PLATFORM_WIN32_KHR )
        //=== VK_EXT_full_screen_exclusive ===
        PFN_vkAcquireFullScreenExclusiveModeEXT     vkAcquireFullScreenExclusiveModeEXT     = 0;
        PFN_vkReleaseFullScreenExclusiveModeEXT     vkReleaseFullScreenExclusiveModeEXT     = 0;
        PFN_vkGetDeviceGroupSurfacePresentModes2EXT vkGetDeviceGroupSurfacePresentModes2EXT = 0;
#  else
        PFN_dummy vkAcquireFullScreenExclusiveModeEXT_placeholder     = 0;
        PFN_dummy vkReleaseFullScreenExclusiveModeEXT_placeholder     = 0;
        PFN_dummy vkGetDeviceGroupSurfacePresentModes2EXT_placeholder = 0;
#  endif /*VK_USE_PLATFORM_WIN32_KHR*/

        //=== VK_KHR_buffer_device_address ===
        PFN_vkGetBufferDeviceAddressKHR              vkGetBufferDeviceAddressKHR              = 0;
        PFN_vkGetBufferOpaqueCaptureAddressKHR       vkGetBufferOpaqueCaptureAddressKHR       = 0;
        PFN_vkGetDeviceMemoryOpaqueCaptureAddressKHR vkGetDeviceMemoryOpaqueCaptureAddressKHR = 0;

        //=== VK_EXT_line_rasterization ===
        PFN_vkCmdSetLineStippleEXT vkCmdSetLineStippleEXT = 0;

        //=== VK_EXT_host_query_reset ===
        PFN_vkResetQueryPoolEXT vkResetQueryPoolEXT = 0;

        //=== VK_EXT_extended_dynamic_state ===
        PFN_vkCmdSetCullModeEXT              vkCmdSetCullModeEXT              = 0;
        PFN_vkCmdSetFrontFaceEXT             vkCmdSetFrontFaceEXT             = 0;
        PFN_vkCmdSetPrimitiveTopologyEXT     vkCmdSetPrimitiveTopologyEXT     = 0;
        PFN_vkCmdSetViewportWithCountEXT     vkCmdSetViewportWithCountEXT     = 0;
        PFN_vkCmdSetScissorWithCountEXT      vkCmdSetScissorWithCountEXT      = 0;
        PFN_vkCmdBindVertexBuffers2EXT       vkCmdBindVertexBuffers2EXT       = 0;
        PFN_vkCmdSetDepthTestEnableEXT       vkCmdSetDepthTestEnableEXT       = 0;
        PFN_vkCmdSetDepthWriteEnableEXT      vkCmdSetDepthWriteEnableEXT      = 0;
        PFN_vkCmdSetDepthCompareOpEXT        vkCmdSetDepthCompareOpEXT        = 0;
        PFN_vkCmdSetDepthBoundsTestEnableEXT vkCmdSetDepthBoundsTestEnableEXT = 0;
        PFN_vkCmdSetStencilTestEnableEXT     vkCmdSetStencilTestEnableEXT     = 0;
        PFN_vkCmdSetStencilOpEXT             vkCmdSetStencilOpEXT             = 0;

        //=== VK_KHR_deferred_host_operations ===
        PFN_vkCreateDeferredOperationKHR            vkCreateDeferredOperationKHR            = 0;
        PFN_vkDestroyDeferredOperationKHR           vkDestroyDeferredOperationKHR           = 0;
        PFN_vkGetDeferredOperationMaxConcurrencyKHR vkGetDeferredOperationMaxConcurrencyKHR = 0;
        PFN_vkGetDeferredOperationResultKHR         vkGetDeferredOperationResultKHR         = 0;
        PFN_vkDeferredOperationJoinKHR              vkDeferredOperationJoinKHR              = 0;

        //=== VK_KHR_pipeline_executable_properties ===
        PFN_vkGetPipelineExecutablePropertiesKHR              vkGetPipelineExecutablePropertiesKHR              = 0;
        PFN_vkGetPipelineExecutableStatisticsKHR              vkGetPipelineExecutableStatisticsKHR              = 0;
        PFN_vkGetPipelineExecutableInternalRepresentationsKHR vkGetPipelineExecutableInternalRepresentationsKHR = 0;

        //=== VK_EXT_host_image_copy ===
        PFN_vkCopyMemoryToImageEXT          vkCopyMemoryToImageEXT          = 0;
        PFN_vkCopyImageToMemoryEXT          vkCopyImageToMemoryEXT          = 0;
        PFN_vkCopyImageToImageEXT           vkCopyImageToImageEXT           = 0;
        PFN_vkTransitionImageLayoutEXT      vkTransitionImageLayoutEXT      = 0;
        PFN_vkGetImageSubresourceLayout2EXT vkGetImageSubresourceLayout2EXT = 0;

        //=== VK_KHR_map_memory2 ===
        PFN_vkMapMemory2KHR   vkMapMemory2KHR   = 0;
        PFN_vkUnmapMemory2KHR vkUnmapMemory2KHR = 0;

        //=== VK_EXT_swapchain_maintenance1 ===
        PFN_vkReleaseSwapchainImagesEXT vkReleaseSwapchainImagesEXT = 0;

        //=== VK_NV_device_generated_commands ===
        PFN_vkGetGeneratedCommandsMemoryRequirementsNV vkGetGeneratedCommandsMemoryRequirementsNV = 0;
        PFN_vkCmdPreprocessGeneratedCommandsNV         vkCmdPreprocessGeneratedCommandsNV         = 0;
        PFN_vkCmdExecuteGeneratedCommandsNV            vkCmdExecuteGeneratedCommandsNV            = 0;
        PFN_vkCmdBindPipelineShaderGroupNV             vkCmdBindPipelineShaderGroupNV             = 0;
        PFN_vkCreateIndirectCommandsLayoutNV           vkCreateIndirectCommandsLayoutNV           = 0;
        PFN_vkDestroyIndirectCommandsLayoutNV          vkDestroyIndirectCommandsLayoutNV          = 0;

        //=== VK_EXT_depth_bias_control ===
        PFN_vkCmdSetDepthBias2EXT vkCmdSetDepthBias2EXT = 0;

        //=== VK_EXT_private_data ===
        PFN_vkCreatePrivateDataSlotEXT  vkCreatePrivateDataSlotEXT  = 0;
        PFN_vkDestroyPrivateDataSlotEXT vkDestroyPrivateDataSlotEXT = 0;
        PFN_vkSetPrivateDataEXT         vkSetPrivateDataEXT         = 0;
        PFN_vkGetPrivateDataEXT         vkGetPrivateDataEXT         = 0;

        //=== VK_KHR_video_encode_queue ===
        PFN_vkGetEncodedVideoSessionParametersKHR vkGetEncodedVideoSessionParametersKHR = 0;
        PFN_vkCmdEncodeVideoKHR                   vkCmdEncodeVideoKHR                   = 0;

#  if defined( VK_ENABLE_BETA_EXTENSIONS )
        //=== VK_NV_cuda_kernel_launch ===
        PFN_vkCreateCudaModuleNV    vkCreateCudaModuleNV    = 0;
        PFN_vkGetCudaModuleCacheNV  vkGetCudaModuleCacheNV  = 0;
        PFN_vkCreateCudaFunctionNV  vkCreateCudaFunctionNV  = 0;
        PFN_vkDestroyCudaModuleNV   vkDestroyCudaModuleNV   = 0;
        PFN_vkDestroyCudaFunctionNV vkDestroyCudaFunctionNV = 0;
        PFN_vkCmdCudaLaunchKernelNV vkCmdCudaLaunchKernelNV = 0;
#  else
        PFN_dummy vkCreateCudaModuleNV_placeholder    = 0;
        PFN_dummy vkGetCudaModuleCacheNV_placeholder  = 0;
        PFN_dummy vkCreateCudaFunctionNV_placeholder  = 0;
        PFN_dummy vkDestroyCudaModuleNV_placeholder   = 0;
        PFN_dummy vkDestroyCudaFunctionNV_placeholder = 0;
        PFN_dummy vkCmdCudaLaunchKernelNV_placeholder = 0;
#  endif /*VK_ENABLE_BETA_EXTENSIONS*/

        //=== VK_QCOM_tile_shading ===
        PFN_vkCmdDispatchTileQCOM          vkCmdDispatchTileQCOM          = 0;
        PFN_vkCmdBeginPerTileExecutionQCOM vkCmdBeginPerTileExecutionQCOM = 0;
        PFN_vkCmdEndPerTileExecutionQCOM   vkCmdEndPerTileExecutionQCOM   = 0;

#  if defined( VK_USE_PLATFORM_METAL_EXT )
        //=== VK_EXT_metal_objects ===
        PFN_vkExportMetalObjectsEXT vkExportMetalObjectsEXT = 0;
#  else
        PFN_dummy vkExportMetalObjectsEXT_placeholder = 0;
#  endif /*VK_USE_PLATFORM_METAL_EXT*/

        //=== VK_KHR_synchronization2 ===
        PFN_vkCmdSetEvent2KHR        vkCmdSetEvent2KHR        = 0;
        PFN_vkCmdResetEvent2KHR      vkCmdResetEvent2KHR      = 0;
        PFN_vkCmdWaitEvents2KHR      vkCmdWaitEvents2KHR      = 0;
        PFN_vkCmdPipelineBarrier2KHR vkCmdPipelineBarrier2KHR = 0;
        PFN_vkCmdWriteTimestamp2KHR  vkCmdWriteTimestamp2KHR  = 0;
        PFN_vkQueueSubmit2KHR        vkQueueSubmit2KHR        = 0;

        //=== VK_EXT_descriptor_buffer ===
        PFN_vkGetDescriptorSetLayoutSizeEXT                          vkGetDescriptorSetLayoutSizeEXT                          = 0;
        PFN_vkGetDescriptorSetLayoutBindingOffsetEXT                 vkGetDescriptorSetLayoutBindingOffsetEXT                 = 0;
        PFN_vkGetDescriptorEXT                                       vkGetDescriptorEXT                                       = 0;
        PFN_vkCmdBindDescriptorBuffersEXT                            vkCmdBindDescriptorBuffersEXT                            = 0;
        PFN_vkCmdSetDescriptorBufferOffsetsEXT                       vkCmdSetDescriptorBufferOffsetsEXT                       = 0;
        PFN_vkCmdBindDescriptorBufferEmbeddedSamplersEXT             vkCmdBindDescriptorBufferEmbeddedSamplersEXT             = 0;
        PFN_vkGetBufferOpaqueCaptureDescriptorDataEXT                vkGetBufferOpaqueCaptureDescriptorDataEXT                = 0;
        PFN_vkGetImageOpaqueCaptureDescriptorDataEXT                 vkGetImageOpaqueCaptureDescriptorDataEXT                 = 0;
        PFN_vkGetImageViewOpaqueCaptureDescriptorDataEXT             vkGetImageViewOpaqueCaptureDescriptorDataEXT             = 0;
        PFN_vkGetSamplerOpaqueCaptureDescriptorDataEXT               vkGetSamplerOpaqueCaptureDescriptorDataEXT               = 0;
        PFN_vkGetAccelerationStructureOpaqueCaptureDescriptorDataEXT vkGetAccelerationStructureOpaqueCaptureDescriptorDataEXT = 0;

        //=== VK_NV_fragment_shading_rate_enums ===
        PFN_vkCmdSetFragmentShadingRateEnumNV vkCmdSetFragmentShadingRateEnumNV = 0;

        //=== VK_EXT_mesh_shader ===
        PFN_vkCmdDrawMeshTasksEXT              vkCmdDrawMeshTasksEXT              = 0;
        PFN_vkCmdDrawMeshTasksIndirectEXT      vkCmdDrawMeshTasksIndirectEXT      = 0;
        PFN_vkCmdDrawMeshTasksIndirectCountEXT vkCmdDrawMeshTasksIndirectCountEXT = 0;

        //=== VK_KHR_copy_commands2 ===
        PFN_vkCmdCopyBuffer2KHR        vkCmdCopyBuffer2KHR        = 0;
        PFN_vkCmdCopyImage2KHR         vkCmdCopyImage2KHR         = 0;
        PFN_vkCmdCopyBufferToImage2KHR vkCmdCopyBufferToImage2KHR = 0;
        PFN_vkCmdCopyImageToBuffer2KHR vkCmdCopyImageToBuffer2KHR = 0;
        PFN_vkCmdBlitImage2KHR         vkCmdBlitImage2KHR         = 0;
        PFN_vkCmdResolveImage2KHR      vkCmdResolveImage2KHR      = 0;

        //=== VK_EXT_device_fault ===
        PFN_vkGetDeviceFaultInfoEXT vkGetDeviceFaultInfoEXT = 0;

        //=== VK_EXT_vertex_input_dynamic_state ===
        PFN_vkCmdSetVertexInputEXT vkCmdSetVertexInputEXT = 0;

#  if defined( VK_USE_PLATFORM_FUCHSIA )
        //=== VK_FUCHSIA_external_memory ===
        PFN_vkGetMemoryZirconHandleFUCHSIA           vkGetMemoryZirconHandleFUCHSIA           = 0;
        PFN_vkGetMemoryZirconHandlePropertiesFUCHSIA vkGetMemoryZirconHandlePropertiesFUCHSIA = 0;
#  else
        PFN_dummy vkGetMemoryZirconHandleFUCHSIA_placeholder           = 0;
        PFN_dummy vkGetMemoryZirconHandlePropertiesFUCHSIA_placeholder = 0;
#  endif /*VK_USE_PLATFORM_FUCHSIA*/

#  if defined( VK_USE_PLATFORM_FUCHSIA )
        //=== VK_FUCHSIA_external_semaphore ===
        PFN_vkImportSemaphoreZirconHandleFUCHSIA vkImportSemaphoreZirconHandleFUCHSIA = 0;
        PFN_vkGetSemaphoreZirconHandleFUCHSIA    vkGetSemaphoreZirconHandleFUCHSIA    = 0;
#  else
        PFN_dummy vkImportSemaphoreZirconHandleFUCHSIA_placeholder = 0;
        PFN_dummy vkGetSemaphoreZirconHandleFUCHSIA_placeholder    = 0;
#  endif /*VK_USE_PLATFORM_FUCHSIA*/

#  if defined( VK_USE_PLATFORM_FUCHSIA )
        //=== VK_FUCHSIA_buffer_collection ===
        PFN_vkCreateBufferCollectionFUCHSIA               vkCreateBufferCollectionFUCHSIA               = 0;
        PFN_vkSetBufferCollectionImageConstraintsFUCHSIA  vkSetBufferCollectionImageConstraintsFUCHSIA  = 0;
        PFN_vkSetBufferCollectionBufferConstraintsFUCHSIA vkSetBufferCollectionBufferConstraintsFUCHSIA = 0;
        PFN_vkDestroyBufferCollectionFUCHSIA              vkDestroyBufferCollectionFUCHSIA              = 0;
        PFN_vkGetBufferCollectionPropertiesFUCHSIA        vkGetBufferCollectionPropertiesFUCHSIA        = 0;
#  else
        PFN_dummy vkCreateBufferCollectionFUCHSIA_placeholder               = 0;
        PFN_dummy vkSetBufferCollectionImageConstraintsFUCHSIA_placeholder  = 0;
        PFN_dummy vkSetBufferCollectionBufferConstraintsFUCHSIA_placeholder = 0;
        PFN_dummy vkDestroyBufferCollectionFUCHSIA_placeholder              = 0;
        PFN_dummy vkGetBufferCollectionPropertiesFUCHSIA_placeholder        = 0;
#  endif /*VK_USE_PLATFORM_FUCHSIA*/

        //=== VK_HUAWEI_subpass_shading ===
        PFN_vkGetDeviceSubpassShadingMaxWorkgroupSizeHUAWEI vkGetDeviceSubpassShadingMaxWorkgroupSizeHUAWEI = 0;
        PFN_vkCmdSubpassShadingHUAWEI                       vkCmdSubpassShadingHUAWEI                       = 0;

        //=== VK_HUAWEI_invocation_mask ===
        PFN_vkCmdBindInvocationMaskHUAWEI vkCmdBindInvocationMaskHUAWEI = 0;

        //=== VK_NV_external_memory_rdma ===
        PFN_vkGetMemoryRemoteAddressNV vkGetMemoryRemoteAddressNV = 0;

        //=== VK_EXT_pipeline_properties ===
        PFN_vkGetPipelinePropertiesEXT vkGetPipelinePropertiesEXT = 0;

        //=== VK_EXT_extended_dynamic_state2 ===
        PFN_vkCmdSetPatchControlPointsEXT      vkCmdSetPatchControlPointsEXT      = 0;
        PFN_vkCmdSetRasterizerDiscardEnableEXT vkCmdSetRasterizerDiscardEnableEXT = 0;
        PFN_vkCmdSetDepthBiasEnableEXT         vkCmdSetDepthBiasEnableEXT         = 0;
        PFN_vkCmdSetLogicOpEXT                 vkCmdSetLogicOpEXT                 = 0;
        PFN_vkCmdSetPrimitiveRestartEnableEXT  vkCmdSetPrimitiveRestartEnableEXT  = 0;

        //=== VK_EXT_color_write_enable ===
        PFN_vkCmdSetColorWriteEnableEXT vkCmdSetColorWriteEnableEXT = 0;

        //=== VK_KHR_ray_tracing_maintenance1 ===
        PFN_vkCmdTraceRaysIndirect2KHR vkCmdTraceRaysIndirect2KHR = 0;

        //=== VK_EXT_multi_draw ===
        PFN_vkCmdDrawMultiEXT        vkCmdDrawMultiEXT        = 0;
        PFN_vkCmdDrawMultiIndexedEXT vkCmdDrawMultiIndexedEXT = 0;

        //=== VK_EXT_opacity_micromap ===
        PFN_vkCreateMicromapEXT                 vkCreateMicromapEXT                 = 0;
        PFN_vkDestroyMicromapEXT                vkDestroyMicromapEXT                = 0;
        PFN_vkCmdBuildMicromapsEXT              vkCmdBuildMicromapsEXT              = 0;
        PFN_vkBuildMicromapsEXT                 vkBuildMicromapsEXT                 = 0;
        PFN_vkCopyMicromapEXT                   vkCopyMicromapEXT                   = 0;
        PFN_vkCopyMicromapToMemoryEXT           vkCopyMicromapToMemoryEXT           = 0;
        PFN_vkCopyMemoryToMicromapEXT           vkCopyMemoryToMicromapEXT           = 0;
        PFN_vkWriteMicromapsPropertiesEXT       vkWriteMicromapsPropertiesEXT       = 0;
        PFN_vkCmdCopyMicromapEXT                vkCmdCopyMicromapEXT                = 0;
        PFN_vkCmdCopyMicromapToMemoryEXT        vkCmdCopyMicromapToMemoryEXT        = 0;
        PFN_vkCmdCopyMemoryToMicromapEXT        vkCmdCopyMemoryToMicromapEXT        = 0;
        PFN_vkCmdWriteMicromapsPropertiesEXT    vkCmdWriteMicromapsPropertiesEXT    = 0;
        PFN_vkGetDeviceMicromapCompatibilityEXT vkGetDeviceMicromapCompatibilityEXT = 0;
        PFN_vkGetMicromapBuildSizesEXT          vkGetMicromapBuildSizesEXT          = 0;

        //=== VK_HUAWEI_cluster_culling_shader ===
        PFN_vkCmdDrawClusterHUAWEI         vkCmdDrawClusterHUAWEI         = 0;
        PFN_vkCmdDrawClusterIndirectHUAWEI vkCmdDrawClusterIndirectHUAWEI = 0;

        //=== VK_EXT_pageable_device_local_memory ===
        PFN_vkSetDeviceMemoryPriorityEXT vkSetDeviceMemoryPriorityEXT = 0;

        //=== VK_KHR_maintenance4 ===
        PFN_vkGetDeviceBufferMemoryRequirementsKHR      vkGetDeviceBufferMemoryRequirementsKHR      = 0;
        PFN_vkGetDeviceImageMemoryRequirementsKHR       vkGetDeviceImageMemoryRequirementsKHR       = 0;
        PFN_vkGetDeviceImageSparseMemoryRequirementsKHR vkGetDeviceImageSparseMemoryRequirementsKHR = 0;

        //=== VK_VALVE_descriptor_set_host_mapping ===
        PFN_vkGetDescriptorSetLayoutHostMappingInfoVALVE vkGetDescriptorSetLayoutHostMappingInfoVALVE = 0;
        PFN_vkGetDescriptorSetHostMappingVALVE           vkGetDescriptorSetHostMappingVALVE           = 0;

        //=== VK_NV_copy_memory_indirect ===
        PFN_vkCmdCopyMemoryIndirectNV        vkCmdCopyMemoryIndirectNV        = 0;
        PFN_vkCmdCopyMemoryToImageIndirectNV vkCmdCopyMemoryToImageIndirectNV = 0;

        //=== VK_NV_memory_decompression ===
        PFN_vkCmdDecompressMemoryNV              vkCmdDecompressMemoryNV              = 0;
        PFN_vkCmdDecompressMemoryIndirectCountNV vkCmdDecompressMemoryIndirectCountNV = 0;

        //=== VK_NV_device_generated_commands_compute ===
        PFN_vkGetPipelineIndirectMemoryRequirementsNV vkGetPipelineIndirectMemoryRequirementsNV = 0;
        PFN_vkCmdUpdatePipelineIndirectBufferNV       vkCmdUpdatePipelineIndirectBufferNV       = 0;
        PFN_vkGetPipelineIndirectDeviceAddressNV      vkGetPipelineIndirectDeviceAddressNV      = 0;

#  if defined( VK_USE_PLATFORM_OHOS )
        //=== VK_OHOS_external_memory ===
        PFN_vkGetNativeBufferPropertiesOHOS vkGetNativeBufferPropertiesOHOS = 0;
        PFN_vkGetMemoryNativeBufferOHOS     vkGetMemoryNativeBufferOHOS     = 0;
#  else
        PFN_dummy vkGetNativeBufferPropertiesOHOS_placeholder = 0;
        PFN_dummy vkGetMemoryNativeBufferOHOS_placeholder     = 0;
#  endif /*VK_USE_PLATFORM_OHOS*/

        //=== VK_EXT_extended_dynamic_state3 ===
        PFN_vkCmdSetDepthClampEnableEXT                 vkCmdSetDepthClampEnableEXT                 = 0;
        PFN_vkCmdSetPolygonModeEXT                      vkCmdSetPolygonModeEXT                      = 0;
        PFN_vkCmdSetRasterizationSamplesEXT             vkCmdSetRasterizationSamplesEXT             = 0;
        PFN_vkCmdSetSampleMaskEXT                       vkCmdSetSampleMaskEXT                       = 0;
        PFN_vkCmdSetAlphaToCoverageEnableEXT            vkCmdSetAlphaToCoverageEnableEXT            = 0;
        PFN_vkCmdSetAlphaToOneEnableEXT                 vkCmdSetAlphaToOneEnableEXT                 = 0;
        PFN_vkCmdSetLogicOpEnableEXT                    vkCmdSetLogicOpEnableEXT                    = 0;
        PFN_vkCmdSetColorBlendEnableEXT                 vkCmdSetColorBlendEnableEXT                 = 0;
        PFN_vkCmdSetColorBlendEquationEXT               vkCmdSetColorBlendEquationEXT               = 0;
        PFN_vkCmdSetColorWriteMaskEXT                   vkCmdSetColorWriteMaskEXT                   = 0;
        PFN_vkCmdSetTessellationDomainOriginEXT         vkCmdSetTessellationDomainOriginEXT         = 0;
        PFN_vkCmdSetRasterizationStreamEXT              vkCmdSetRasterizationStreamEXT              = 0;
        PFN_vkCmdSetConservativeRasterizationModeEXT    vkCmdSetConservativeRasterizationModeEXT    = 0;
        PFN_vkCmdSetExtraPrimitiveOverestimationSizeEXT vkCmdSetExtraPrimitiveOverestimationSizeEXT = 0;
        PFN_vkCmdSetDepthClipEnableEXT                  vkCmdSetDepthClipEnableEXT                  = 0;
        PFN_vkCmdSetSampleLocationsEnableEXT            vkCmdSetSampleLocationsEnableEXT            = 0;
        PFN_vkCmdSetColorBlendAdvancedEXT               vkCmdSetColorBlendAdvancedEXT               = 0;
        PFN_vkCmdSetProvokingVertexModeEXT              vkCmdSetProvokingVertexModeEXT              = 0;
        PFN_vkCmdSetLineRasterizationModeEXT            vkCmdSetLineRasterizationModeEXT            = 0;
        PFN_vkCmdSetLineStippleEnableEXT                vkCmdSetLineStippleEnableEXT                = 0;
        PFN_vkCmdSetDepthClipNegativeOneToOneEXT        vkCmdSetDepthClipNegativeOneToOneEXT        = 0;
        PFN_vkCmdSetViewportWScalingEnableNV            vkCmdSetViewportWScalingEnableNV            = 0;
        PFN_vkCmdSetViewportSwizzleNV                   vkCmdSetViewportSwizzleNV                   = 0;
        PFN_vkCmdSetCoverageToColorEnableNV             vkCmdSetCoverageToColorEnableNV             = 0;
        PFN_vkCmdSetCoverageToColorLocationNV           vkCmdSetCoverageToColorLocationNV           = 0;
        PFN_vkCmdSetCoverageModulationModeNV            vkCmdSetCoverageModulationModeNV            = 0;
        PFN_vkCmdSetCoverageModulationTableEnableNV     vkCmdSetCoverageModulationTableEnableNV     = 0;
        PFN_vkCmdSetCoverageModulationTableNV           vkCmdSetCoverageModulationTableNV           = 0;
        PFN_vkCmdSetShadingRateImageEnableNV            vkCmdSetShadingRateImageEnableNV            = 0;
        PFN_vkCmdSetRepresentativeFragmentTestEnableNV  vkCmdSetRepresentativeFragmentTestEnableNV  = 0;
        PFN_vkCmdSetCoverageReductionModeNV             vkCmdSetCoverageReductionModeNV             = 0;

        //=== VK_ARM_tensors ===
        PFN_vkCreateTensorARM                             vkCreateTensorARM                             = 0;
        PFN_vkDestroyTensorARM                            vkDestroyTensorARM                            = 0;
        PFN_vkCreateTensorViewARM                         vkCreateTensorViewARM                         = 0;
        PFN_vkDestroyTensorViewARM                        vkDestroyTensorViewARM                        = 0;
        PFN_vkGetTensorMemoryRequirementsARM              vkGetTensorMemoryRequirementsARM              = 0;
        PFN_vkBindTensorMemoryARM                         vkBindTensorMemoryARM                         = 0;
        PFN_vkGetDeviceTensorMemoryRequirementsARM        vkGetDeviceTensorMemoryRequirementsARM        = 0;
        PFN_vkCmdCopyTensorARM                            vkCmdCopyTensorARM                            = 0;
        PFN_vkGetTensorOpaqueCaptureDescriptorDataARM     vkGetTensorOpaqueCaptureDescriptorDataARM     = 0;
        PFN_vkGetTensorViewOpaqueCaptureDescriptorDataARM vkGetTensorViewOpaqueCaptureDescriptorDataARM = 0;

        //=== VK_EXT_shader_module_identifier ===
        PFN_vkGetShaderModuleIdentifierEXT           vkGetShaderModuleIdentifierEXT           = 0;
        PFN_vkGetShaderModuleCreateInfoIdentifierEXT vkGetShaderModuleCreateInfoIdentifierEXT = 0;

        //=== VK_NV_optical_flow ===
        PFN_vkCreateOpticalFlowSessionNV    vkCreateOpticalFlowSessionNV    = 0;
        PFN_vkDestroyOpticalFlowSessionNV   vkDestroyOpticalFlowSessionNV   = 0;
        PFN_vkBindOpticalFlowSessionImageNV vkBindOpticalFlowSessionImageNV = 0;
        PFN_vkCmdOpticalFlowExecuteNV       vkCmdOpticalFlowExecuteNV       = 0;

        //=== VK_KHR_maintenance5 ===
        PFN_vkCmdBindIndexBuffer2KHR             vkCmdBindIndexBuffer2KHR             = 0;
        PFN_vkGetRenderingAreaGranularityKHR     vkGetRenderingAreaGranularityKHR     = 0;
        PFN_vkGetDeviceImageSubresourceLayoutKHR vkGetDeviceImageSubresourceLayoutKHR = 0;
        PFN_vkGetImageSubresourceLayout2KHR      vkGetImageSubresourceLayout2KHR      = 0;

        //=== VK_AMD_anti_lag ===
        PFN_vkAntiLagUpdateAMD vkAntiLagUpdateAMD = 0;

        //=== VK_KHR_present_wait2 ===
        PFN_vkWaitForPresent2KHR vkWaitForPresent2KHR = 0;

        //=== VK_EXT_shader_object ===
        PFN_vkCreateShadersEXT         vkCreateShadersEXT         = 0;
        PFN_vkDestroyShaderEXT         vkDestroyShaderEXT         = 0;
        PFN_vkGetShaderBinaryDataEXT   vkGetShaderBinaryDataEXT   = 0;
        PFN_vkCmdBindShadersEXT        vkCmdBindShadersEXT        = 0;
        PFN_vkCmdSetDepthClampRangeEXT vkCmdSetDepthClampRangeEXT = 0;

        //=== VK_KHR_pipeline_binary ===
        PFN_vkCreatePipelineBinariesKHR      vkCreatePipelineBinariesKHR      = 0;
        PFN_vkDestroyPipelineBinaryKHR       vkDestroyPipelineBinaryKHR       = 0;
        PFN_vkGetPipelineKeyKHR              vkGetPipelineKeyKHR              = 0;
        PFN_vkGetPipelineBinaryDataKHR       vkGetPipelineBinaryDataKHR       = 0;
        PFN_vkReleaseCapturedPipelineDataKHR vkReleaseCapturedPipelineDataKHR = 0;

        //=== VK_QCOM_tile_properties ===
        PFN_vkGetFramebufferTilePropertiesQCOM      vkGetFramebufferTilePropertiesQCOM      = 0;
        PFN_vkGetDynamicRenderingTilePropertiesQCOM vkGetDynamicRenderingTilePropertiesQCOM = 0;

        //=== VK_KHR_swapchain_maintenance1 ===
        PFN_vkReleaseSwapchainImagesKHR vkReleaseSwapchainImagesKHR = 0;

        //=== VK_NV_cooperative_vector ===
        PFN_vkConvertCooperativeVectorMatrixNV    vkConvertCooperativeVectorMatrixNV    = 0;
        PFN_vkCmdConvertCooperativeVectorMatrixNV vkCmdConvertCooperativeVectorMatrixNV = 0;

        //=== VK_NV_low_latency2 ===
        PFN_vkSetLatencySleepModeNV  vkSetLatencySleepModeNV  = 0;
        PFN_vkLatencySleepNV         vkLatencySleepNV         = 0;
        PFN_vkSetLatencyMarkerNV     vkSetLatencyMarkerNV     = 0;
        PFN_vkGetLatencyTimingsNV    vkGetLatencyTimingsNV    = 0;
        PFN_vkQueueNotifyOutOfBandNV vkQueueNotifyOutOfBandNV = 0;

        //=== VK_ARM_data_graph ===
        PFN_vkCreateDataGraphPipelinesARM                         vkCreateDataGraphPipelinesARM                         = 0;
        PFN_vkCreateDataGraphPipelineSessionARM                   vkCreateDataGraphPipelineSessionARM                   = 0;
        PFN_vkGetDataGraphPipelineSessionBindPointRequirementsARM vkGetDataGraphPipelineSessionBindPointRequirementsARM = 0;
        PFN_vkGetDataGraphPipelineSessionMemoryRequirementsARM    vkGetDataGraphPipelineSessionMemoryRequirementsARM    = 0;
        PFN_vkBindDataGraphPipelineSessionMemoryARM               vkBindDataGraphPipelineSessionMemoryARM               = 0;
        PFN_vkDestroyDataGraphPipelineSessionARM                  vkDestroyDataGraphPipelineSessionARM                  = 0;
        PFN_vkCmdDispatchDataGraphARM                             vkCmdDispatchDataGraphARM                             = 0;
        PFN_vkGetDataGraphPipelineAvailablePropertiesARM          vkGetDataGraphPipelineAvailablePropertiesARM          = 0;
        PFN_vkGetDataGraphPipelinePropertiesARM                   vkGetDataGraphPipelinePropertiesARM                   = 0;

        //=== VK_EXT_attachment_feedback_loop_dynamic_state ===
        PFN_vkCmdSetAttachmentFeedbackLoopEnableEXT vkCmdSetAttachmentFeedbackLoopEnableEXT = 0;

#  if defined( VK_USE_PLATFORM_SCREEN_QNX )
        //=== VK_QNX_external_memory_screen_buffer ===
        PFN_vkGetScreenBufferPropertiesQNX vkGetScreenBufferPropertiesQNX = 0;
#  else
        PFN_dummy vkGetScreenBufferPropertiesQNX_placeholder = 0;
#  endif /*VK_USE_PLATFORM_SCREEN_QNX*/

        //=== VK_KHR_line_rasterization ===
        PFN_vkCmdSetLineStippleKHR vkCmdSetLineStippleKHR = 0;

        //=== VK_KHR_calibrated_timestamps ===
        PFN_vkGetCalibratedTimestampsKHR vkGetCalibratedTimestampsKHR = 0;

        //=== VK_KHR_maintenance6 ===
        PFN_vkCmdBindDescriptorSets2KHR                   vkCmdBindDescriptorSets2KHR                   = 0;
        PFN_vkCmdPushConstants2KHR                        vkCmdPushConstants2KHR                        = 0;
        PFN_vkCmdPushDescriptorSet2KHR                    vkCmdPushDescriptorSet2KHR                    = 0;
        PFN_vkCmdPushDescriptorSetWithTemplate2KHR        vkCmdPushDescriptorSetWithTemplate2KHR        = 0;
        PFN_vkCmdSetDescriptorBufferOffsets2EXT           vkCmdSetDescriptorBufferOffsets2EXT           = 0;
        PFN_vkCmdBindDescriptorBufferEmbeddedSamplers2EXT vkCmdBindDescriptorBufferEmbeddedSamplers2EXT = 0;

        //=== VK_QCOM_tile_memory_heap ===
        PFN_vkCmdBindTileMemoryQCOM vkCmdBindTileMemoryQCOM = 0;

        //=== VK_KHR_copy_memory_indirect ===
        PFN_vkCmdCopyMemoryIndirectKHR        vkCmdCopyMemoryIndirectKHR        = 0;
        PFN_vkCmdCopyMemoryToImageIndirectKHR vkCmdCopyMemoryToImageIndirectKHR = 0;

        //=== VK_EXT_memory_decompression ===
        PFN_vkCmdDecompressMemoryEXT              vkCmdDecompressMemoryEXT              = 0;
        PFN_vkCmdDecompressMemoryIndirectCountEXT vkCmdDecompressMemoryIndirectCountEXT = 0;

        //=== VK_NV_external_compute_queue ===
        PFN_vkCreateExternalComputeQueueNV  vkCreateExternalComputeQueueNV  = 0;
        PFN_vkDestroyExternalComputeQueueNV vkDestroyExternalComputeQueueNV = 0;
        PFN_vkGetExternalComputeQueueDataNV vkGetExternalComputeQueueDataNV = 0;

        //=== VK_NV_cluster_acceleration_structure ===
        PFN_vkGetClusterAccelerationStructureBuildSizesNV    vkGetClusterAccelerationStructureBuildSizesNV    = 0;
        PFN_vkCmdBuildClusterAccelerationStructureIndirectNV vkCmdBuildClusterAccelerationStructureIndirectNV = 0;

        //=== VK_NV_partitioned_acceleration_structure ===
        PFN_vkGetPartitionedAccelerationStructuresBuildSizesNV vkGetPartitionedAccelerationStructuresBuildSizesNV = 0;
        PFN_vkCmdBuildPartitionedAccelerationStructuresNV      vkCmdBuildPartitionedAccelerationStructuresNV      = 0;

        //=== VK_EXT_device_generated_commands ===
        PFN_vkGetGeneratedCommandsMemoryRequirementsEXT vkGetGeneratedCommandsMemoryRequirementsEXT = 0;
        PFN_vkCmdPreprocessGeneratedCommandsEXT         vkCmdPreprocessGeneratedCommandsEXT         = 0;
        PFN_vkCmdExecuteGeneratedCommandsEXT            vkCmdExecuteGeneratedCommandsEXT            = 0;
        PFN_vkCreateIndirectCommandsLayoutEXT           vkCreateIndirectCommandsLayoutEXT           = 0;
        PFN_vkDestroyIndirectCommandsLayoutEXT          vkDestroyIndirectCommandsLayoutEXT          = 0;
        PFN_vkCreateIndirectExecutionSetEXT             vkCreateIndirectExecutionSetEXT             = 0;
        PFN_vkDestroyIndirectExecutionSetEXT            vkDestroyIndirectExecutionSetEXT            = 0;
        PFN_vkUpdateIndirectExecutionSetPipelineEXT     vkUpdateIndirectExecutionSetPipelineEXT     = 0;
        PFN_vkUpdateIndirectExecutionSetShaderEXT       vkUpdateIndirectExecutionSetShaderEXT       = 0;

#  if defined( VK_USE_PLATFORM_OHOS )
        //=== VK_OHOS_native_buffer ===
        PFN_vkGetSwapchainGrallocUsageOHOS vkGetSwapchainGrallocUsageOHOS = 0;
        PFN_vkAcquireImageOHOS             vkAcquireImageOHOS             = 0;
        PFN_vkQueueSignalReleaseImageOHOS  vkQueueSignalReleaseImageOHOS  = 0;
#  else
        PFN_dummy vkGetSwapchainGrallocUsageOHOS_placeholder = 0;
        PFN_dummy vkAcquireImageOHOS_placeholder             = 0;
        PFN_dummy vkQueueSignalReleaseImageOHOS_placeholder  = 0;
#  endif /*VK_USE_PLATFORM_OHOS*/

#  if defined( VK_USE_PLATFORM_METAL_EXT )
        //=== VK_EXT_external_memory_metal ===
        PFN_vkGetMemoryMetalHandleEXT           vkGetMemoryMetalHandleEXT           = 0;
        PFN_vkGetMemoryMetalHandlePropertiesEXT vkGetMemoryMetalHandlePropertiesEXT = 0;
#  else
        PFN_dummy vkGetMemoryMetalHandleEXT_placeholder           = 0;
        PFN_dummy vkGetMemoryMetalHandlePropertiesEXT_placeholder = 0;
#  endif /*VK_USE_PLATFORM_METAL_EXT*/

        //=== VK_EXT_fragment_density_map_offset ===
        PFN_vkCmdEndRendering2EXT vkCmdEndRendering2EXT = 0;

        //=== VK_EXT_custom_resolve ===
        PFN_vkCmdBeginCustomResolveEXT vkCmdBeginCustomResolveEXT = 0;

        //=== VK_KHR_maintenance10 ===
        PFN_vkCmdEndRendering2KHR vkCmdEndRendering2KHR = 0;
      };

    }  // namespace detail

    //========================================
    //=== RAII HANDLE forward declarations ===
    //========================================

    //=== VK_VERSION_1_0 ===
    class Instance;
    class PhysicalDevice;
    class Device;
    class Queue;
    class DeviceMemory;
    class Fence;
    class Semaphore;
    class QueryPool;
    class Buffer;
    class Image;
    class ImageView;
    class CommandPool;
    class CommandBuffer;
    class Event;
    class BufferView;
    class ShaderModule;
    class PipelineCache;
    class Pipeline;
    class PipelineLayout;
    class Sampler;
    class DescriptorPool;
    class DescriptorSet;
    class DescriptorSetLayout;
    class Framebuffer;
    class RenderPass;

    //=== VK_VERSION_1_1 ===
    class DescriptorUpdateTemplate;
    class SamplerYcbcrConversion;

    //=== VK_VERSION_1_3 ===
    class PrivateDataSlot;

    //=== VK_KHR_surface ===
    class SurfaceKHR;

    //=== VK_KHR_swapchain ===
    class SwapchainKHR;

    //=== VK_KHR_display ===
    class DisplayKHR;
    class DisplayModeKHR;

    //=== VK_EXT_debug_report ===
    class DebugReportCallbackEXT;

    //=== VK_KHR_video_queue ===
    class VideoSessionKHR;
    class VideoSessionParametersKHR;

    //=== VK_NVX_binary_import ===
    class CuModuleNVX;
    class CuFunctionNVX;

    //=== VK_KHR_descriptor_update_template ===
    using DescriptorUpdateTemplateKHR = DescriptorUpdateTemplate;

    //=== VK_EXT_debug_utils ===
    class DebugUtilsMessengerEXT;

    //=== VK_KHR_acceleration_structure ===
    class AccelerationStructureKHR;

    //=== VK_KHR_sampler_ycbcr_conversion ===
    using SamplerYcbcrConversionKHR = SamplerYcbcrConversion;

    //=== VK_EXT_validation_cache ===
    class ValidationCacheEXT;

    //=== VK_NV_ray_tracing ===
    class AccelerationStructureNV;

    //=== VK_INTEL_performance_query ===
    class PerformanceConfigurationINTEL;

    //=== VK_KHR_deferred_host_operations ===
    class DeferredOperationKHR;

    //=== VK_NV_device_generated_commands ===
    class IndirectCommandsLayoutNV;

    //=== VK_EXT_private_data ===
    using PrivateDataSlotEXT = PrivateDataSlot;

#  if defined( VK_ENABLE_BETA_EXTENSIONS )
    //=== VK_NV_cuda_kernel_launch ===
    class CudaModuleNV;
    class CudaFunctionNV;
#  endif /*VK_ENABLE_BETA_EXTENSIONS*/

#  if defined( VK_USE_PLATFORM_FUCHSIA )
    //=== VK_FUCHSIA_buffer_collection ===
    class BufferCollectionFUCHSIA;
#  endif /*VK_USE_PLATFORM_FUCHSIA*/

    //=== VK_EXT_opacity_micromap ===
    class MicromapEXT;

    //=== VK_ARM_tensors ===
    class TensorARM;
    class TensorViewARM;

    //=== VK_NV_optical_flow ===
    class OpticalFlowSessionNV;

    //=== VK_EXT_shader_object ===
    class ShaderEXT;

    //=== VK_KHR_pipeline_binary ===
    class PipelineBinaryKHR;

    //=== VK_ARM_data_graph ===
    class DataGraphPipelineSessionARM;

    //=== VK_NV_external_compute_queue ===
    class ExternalComputeQueueNV;

    //=== VK_EXT_device_generated_commands ===
    class IndirectCommandsLayoutEXT;
    class IndirectExecutionSetEXT;

    //====================
    //=== RAII HANDLES ===
    //====================

    template <typename Type>
    struct isVulkanRAIIHandleType
    {
      static VULKAN_HPP_CONST_OR_CONSTEXPR bool value = false;
    };

    class Context
    {
    public:
#  if VULKAN_HPP_ENABLE_DYNAMIC_LOADER_TOOL
      Context() : m_dispatcher( new detail::ContextDispatcher( m_dynamicLoader.getProcAddress<PFN_vkGetInstanceProcAddr>( "vkGetInstanceProcAddr" ) ) )
#  else
      Context( PFN_vkGetInstanceProcAddr getInstanceProcAddr ) : m_dispatcher( new detail::ContextDispatcher( getInstanceProcAddr ) )
#  endif
      {
      }

      ~Context() = default;

      Context( Context const & ) = delete;
      Context( Context && rhs ) VULKAN_HPP_NOEXCEPT
#  if VULKAN_HPP_ENABLE_DYNAMIC_LOADER_TOOL
        : m_dynamicLoader( std::move( rhs.m_dynamicLoader ) )
        , m_dispatcher( rhs.m_dispatcher.release() )
#  else
        : m_dispatcher( rhs.m_dispatcher.release() )
#  endif
      {
      }
      Context & operator=( Context const & ) = delete;

      Context & operator=( Context && rhs ) VULKAN_HPP_NOEXCEPT
      {
        if ( this != &rhs )
        {
#  if VULKAN_HPP_ENABLE_DYNAMIC_LOADER_TOOL
          m_dynamicLoader = std::move( rhs.m_dynamicLoader );
#  endif
          m_dispatcher.reset( rhs.m_dispatcher.release() );
        }
        return *this;
      }

      detail::ContextDispatcher const * getDispatcher() const
      {
        VULKAN_HPP_ASSERT( m_dispatcher->getVkHeaderVersion() == VK_HEADER_VERSION );
        return &*m_dispatcher;
      }

      void swap( Context & rhs )
      {
#  if VULKAN_HPP_ENABLE_DYNAMIC_LOADER_TOOL
        std::swap( m_dynamicLoader, rhs.m_dynamicLoader );
#  endif
        m_dispatcher.swap( rhs.m_dispatcher );
      }

      //=== VK_VERSION_1_0 ===

      // wrapper function for command vkCreateInstance, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateInstance.html
      VULKAN_HPP_NODISCARD typename ResultValueType<Instance>::type
        createInstance( InstanceCreateInfo const &          createInfo,
                        Optional<const AllocationCallbacks> allocator = nullptr ) const VULKAN_HPP_NOEXCEPT_WHEN_NO_EXCEPTIONS;

      // wrapper function for command vkEnumerateInstanceExtensionProperties, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkEnumerateInstanceExtensionProperties.html
      VULKAN_HPP_NODISCARD typename ResultValueType<std::vector<ExtensionProperties>>::type
        enumerateInstanceExtensionProperties( Optional<const std::string> layerName VULKAN_HPP_DEFAULT_ASSIGNMENT( nullptr ) ) const;

      // wrapper function for command vkEnumerateInstanceLayerProperties, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkEnumerateInstanceLayerProperties.html
      VULKAN_HPP_NODISCARD typename ResultValueType<std::vector<LayerProperties>>::type enumerateInstanceLayerProperties() const;

      //=== VK_VERSION_1_1 ===

      // wrapper function for command vkEnumerateInstanceVersion, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkEnumerateInstanceVersion.html
      VULKAN_HPP_NODISCARD typename ResultValueType<uint32_t>::type enumerateInstanceVersion() const;

    private:
#  if VULKAN_HPP_ENABLE_DYNAMIC_LOADER_TOOL
      VULKAN_HPP_NAMESPACE::detail::DynamicLoader m_dynamicLoader;
#  endif
      std::unique_ptr<detail::ContextDispatcher> m_dispatcher;
    };

    // wrapper class for handle VkInstance, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkInstance.html
    class Instance
    {
    public:
      using CType   = VkInstance;
      using CppType = VULKAN_HPP_NAMESPACE::Instance;

      static VULKAN_HPP_CONST_OR_CONSTEXPR ObjectType               objectType            = ObjectType::eInstance;
      static VULKAN_HPP_CONST_OR_CONSTEXPR DebugReportObjectTypeEXT debugReportObjectType = DebugReportObjectTypeEXT::eInstance;

    public:
#  if !defined( VULKAN_HPP_NO_EXCEPTIONS )
      Instance( Context const & context, InstanceCreateInfo const & createInfo, Optional<const AllocationCallbacks> allocator = nullptr )
      {
        *this = context.createInstance( createInfo, allocator );
      }
#  endif

      Instance( Context const & context, VkInstance instance, Optional<const AllocationCallbacks> allocator = nullptr )
        : m_instance( instance ), m_allocator( static_cast<const AllocationCallbacks *>( allocator ) )
      {
        m_dispatcher.reset( new detail::InstanceDispatcher( context.getDispatcher()->vkGetInstanceProcAddr, static_cast<VkInstance>( m_instance ) ) );
      }

      Instance( std::nullptr_t ) {}

      ~Instance()
      {
        clear();
      }

      Instance()                   = delete;
      Instance( Instance const & ) = delete;

      Instance( Instance && rhs ) VULKAN_HPP_NOEXCEPT
        : m_instance( exchange( rhs.m_instance, {} ) )
        , m_allocator( exchange( rhs.m_allocator, {} ) )
        , m_dispatcher( rhs.m_dispatcher.release() )
      {
      }

      Instance & operator=( Instance const & ) = delete;

      Instance & operator=( Instance && rhs ) VULKAN_HPP_NOEXCEPT
      {
        if ( this != &rhs )
        {
          std::swap( m_instance, rhs.m_instance );
          std::swap( m_allocator, rhs.m_allocator );
          std::swap( m_dispatcher, rhs.m_dispatcher );
        }
        return *this;
      }

      VULKAN_HPP_NAMESPACE::Instance const & operator*() const & VULKAN_HPP_NOEXCEPT
      {
        return m_instance;
      }

      VULKAN_HPP_NAMESPACE::Instance const && operator*() const && VULKAN_HPP_NOEXCEPT
      {
        return std::move( m_instance );
      }

      operator VULKAN_HPP_NAMESPACE::Instance() const VULKAN_HPP_NOEXCEPT
      {
        return m_instance;
      }

      void clear() VULKAN_HPP_NOEXCEPT
      {
        if ( m_instance )
        {
          getDispatcher()->vkDestroyInstance( static_cast<VkInstance>( m_instance ), reinterpret_cast<const VkAllocationCallbacks *>( m_allocator ) );
        }
        m_instance   = nullptr;
        m_allocator  = nullptr;
        m_dispatcher = nullptr;
      }

      VULKAN_HPP_NAMESPACE::Instance release()
      {
        m_allocator  = nullptr;
        m_dispatcher = nullptr;
        return exchange( m_instance, nullptr );
      }

      detail::InstanceDispatcher const * getDispatcher() const
      {
        VULKAN_HPP_ASSERT( m_dispatcher->getVkHeaderVersion() == VK_HEADER_VERSION );
        return &*m_dispatcher;
      }

      void swap( Instance & rhs ) VULKAN_HPP_NOEXCEPT
      {
        std::swap( m_instance, rhs.m_instance );
        std::swap( m_allocator, rhs.m_allocator );
        std::swap( m_dispatcher, rhs.m_dispatcher );
      }

      //=== VK_VERSION_1_0 ===

      // wrapper function for command vkEnumeratePhysicalDevices, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkEnumeratePhysicalDevices.html
      VULKAN_HPP_NODISCARD typename ResultValueType<std::vector<PhysicalDevice>>::type enumeratePhysicalDevices() const;

      // wrapper function for command vkGetInstanceProcAddr, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetInstanceProcAddr.html
      VULKAN_HPP_NODISCARD PFN_VoidFunction getProcAddr( const std::string & name ) const VULKAN_HPP_NOEXCEPT;

      //=== VK_VERSION_1_1 ===

      // wrapper function for command vkEnumeratePhysicalDeviceGroups, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkEnumeratePhysicalDeviceGroups.html
      VULKAN_HPP_NODISCARD typename ResultValueType<std::vector<PhysicalDeviceGroupProperties>>::type enumeratePhysicalDeviceGroups() const;

      //=== VK_KHR_display ===

      // wrapper function for command vkCreateDisplayPlaneSurfaceKHR, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateDisplayPlaneSurfaceKHR.html
      VULKAN_HPP_NODISCARD typename ResultValueType<SurfaceKHR>::type
        createDisplayPlaneSurfaceKHR( DisplaySurfaceCreateInfoKHR const & createInfo,
                                      Optional<const AllocationCallbacks> allocator = nullptr ) const VULKAN_HPP_NOEXCEPT_WHEN_NO_EXCEPTIONS;

#  if defined( VK_USE_PLATFORM_XLIB_KHR )
      //=== VK_KHR_xlib_surface ===

      // wrapper function for command vkCreateXlibSurfaceKHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateXlibSurfaceKHR.html
      VULKAN_HPP_NODISCARD typename ResultValueType<SurfaceKHR>::type
        createXlibSurfaceKHR( XlibSurfaceCreateInfoKHR const &    createInfo,
                              Optional<const AllocationCallbacks> allocator = nullptr ) const VULKAN_HPP_NOEXCEPT_WHEN_NO_EXCEPTIONS;
#  endif /*VK_USE_PLATFORM_XLIB_KHR*/

#  if defined( VK_USE_PLATFORM_XCB_KHR )
      //=== VK_KHR_xcb_surface ===

      // wrapper function for command vkCreateXcbSurfaceKHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateXcbSurfaceKHR.html
      VULKAN_HPP_NODISCARD typename ResultValueType<SurfaceKHR>::type
        createXcbSurfaceKHR( XcbSurfaceCreateInfoKHR const &     createInfo,
                             Optional<const AllocationCallbacks> allocator = nullptr ) const VULKAN_HPP_NOEXCEPT_WHEN_NO_EXCEPTIONS;
#  endif /*VK_USE_PLATFORM_XCB_KHR*/

#  if defined( VK_USE_PLATFORM_WAYLAND_KHR )
      //=== VK_KHR_wayland_surface ===

      // wrapper function for command vkCreateWaylandSurfaceKHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateWaylandSurfaceKHR.html
      VULKAN_HPP_NODISCARD typename ResultValueType<SurfaceKHR>::type
        createWaylandSurfaceKHR( WaylandSurfaceCreateInfoKHR const & createInfo,
                                 Optional<const AllocationCallbacks> allocator = nullptr ) const VULKAN_HPP_NOEXCEPT_WHEN_NO_EXCEPTIONS;
#  endif /*VK_USE_PLATFORM_WAYLAND_KHR*/

#  if defined( VK_USE_PLATFORM_ANDROID_KHR )
      //=== VK_KHR_android_surface ===

      // wrapper function for command vkCreateAndroidSurfaceKHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateAndroidSurfaceKHR.html
      VULKAN_HPP_NODISCARD typename ResultValueType<SurfaceKHR>::type
        createAndroidSurfaceKHR( AndroidSurfaceCreateInfoKHR const & createInfo,
                                 Optional<const AllocationCallbacks> allocator = nullptr ) const VULKAN_HPP_NOEXCEPT_WHEN_NO_EXCEPTIONS;
#  endif /*VK_USE_PLATFORM_ANDROID_KHR*/

#  if defined( VK_USE_PLATFORM_WIN32_KHR )
      //=== VK_KHR_win32_surface ===

      // wrapper function for command vkCreateWin32SurfaceKHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateWin32SurfaceKHR.html
      VULKAN_HPP_NODISCARD typename ResultValueType<SurfaceKHR>::type
        createWin32SurfaceKHR( Win32SurfaceCreateInfoKHR const &   createInfo,
                               Optional<const AllocationCallbacks> allocator = nullptr ) const VULKAN_HPP_NOEXCEPT_WHEN_NO_EXCEPTIONS;
#  endif /*VK_USE_PLATFORM_WIN32_KHR*/

      //=== VK_EXT_debug_report ===

      // wrapper function for command vkCreateDebugReportCallbackEXT, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateDebugReportCallbackEXT.html
      VULKAN_HPP_NODISCARD typename ResultValueType<DebugReportCallbackEXT>::type
        createDebugReportCallbackEXT( DebugReportCallbackCreateInfoEXT const & createInfo,
                                      Optional<const AllocationCallbacks>      allocator = nullptr ) const VULKAN_HPP_NOEXCEPT_WHEN_NO_EXCEPTIONS;

      // wrapper function for command vkDebugReportMessageEXT, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkDebugReportMessageEXT.html
      void debugReportMessageEXT( DebugReportFlagsEXT      flags,
                                  DebugReportObjectTypeEXT objectType,
                                  uint64_t                 object,
                                  size_t                   location,
                                  int32_t                  messageCode,
                                  const std::string &      layerPrefix,
                                  const std::string &      message ) const VULKAN_HPP_NOEXCEPT;

#  if defined( VK_USE_PLATFORM_GGP )
      //=== VK_GGP_stream_descriptor_surface ===

      // wrapper function for command vkCreateStreamDescriptorSurfaceGGP, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateStreamDescriptorSurfaceGGP.html
      VULKAN_HPP_NODISCARD typename ResultValueType<SurfaceKHR>::type
        createStreamDescriptorSurfaceGGP( StreamDescriptorSurfaceCreateInfoGGP const & createInfo,
                                          Optional<const AllocationCallbacks>          allocator = nullptr ) const VULKAN_HPP_NOEXCEPT_WHEN_NO_EXCEPTIONS;
#  endif /*VK_USE_PLATFORM_GGP*/

#  if defined( VK_USE_PLATFORM_VI_NN )
      //=== VK_NN_vi_surface ===

      // wrapper function for command vkCreateViSurfaceNN, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateViSurfaceNN.html
      VULKAN_HPP_NODISCARD typename ResultValueType<SurfaceKHR>::type
        createViSurfaceNN( ViSurfaceCreateInfoNN const &       createInfo,
                           Optional<const AllocationCallbacks> allocator = nullptr ) const VULKAN_HPP_NOEXCEPT_WHEN_NO_EXCEPTIONS;
#  endif /*VK_USE_PLATFORM_VI_NN*/

      //=== VK_KHR_device_group_creation ===

      // wrapper function for command vkEnumeratePhysicalDeviceGroupsKHR, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkEnumeratePhysicalDeviceGroupsKHR.html
      VULKAN_HPP_NODISCARD typename ResultValueType<std::vector<PhysicalDeviceGroupProperties>>::type enumeratePhysicalDeviceGroupsKHR() const;

#  if defined( VK_USE_PLATFORM_IOS_MVK )
      //=== VK_MVK_ios_surface ===

      // wrapper function for command vkCreateIOSSurfaceMVK, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateIOSSurfaceMVK.html
      VULKAN_HPP_NODISCARD typename ResultValueType<SurfaceKHR>::type
        createIOSSurfaceMVK( IOSSurfaceCreateInfoMVK const &     createInfo,
                             Optional<const AllocationCallbacks> allocator = nullptr ) const VULKAN_HPP_NOEXCEPT_WHEN_NO_EXCEPTIONS;
#  endif /*VK_USE_PLATFORM_IOS_MVK*/

#  if defined( VK_USE_PLATFORM_MACOS_MVK )
      //=== VK_MVK_macos_surface ===

      // wrapper function for command vkCreateMacOSSurfaceMVK, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateMacOSSurfaceMVK.html
      VULKAN_HPP_NODISCARD typename ResultValueType<SurfaceKHR>::type
        createMacOSSurfaceMVK( MacOSSurfaceCreateInfoMVK const &   createInfo,
                               Optional<const AllocationCallbacks> allocator = nullptr ) const VULKAN_HPP_NOEXCEPT_WHEN_NO_EXCEPTIONS;
#  endif /*VK_USE_PLATFORM_MACOS_MVK*/

      //=== VK_EXT_debug_utils ===

      // wrapper function for command vkCreateDebugUtilsMessengerEXT, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateDebugUtilsMessengerEXT.html
      VULKAN_HPP_NODISCARD typename ResultValueType<DebugUtilsMessengerEXT>::type
        createDebugUtilsMessengerEXT( DebugUtilsMessengerCreateInfoEXT const & createInfo,
                                      Optional<const AllocationCallbacks>      allocator = nullptr ) const VULKAN_HPP_NOEXCEPT_WHEN_NO_EXCEPTIONS;

      // wrapper function for command vkSubmitDebugUtilsMessageEXT, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkSubmitDebugUtilsMessageEXT.html
      void submitDebugUtilsMessageEXT( DebugUtilsMessageSeverityFlagBitsEXT       messageSeverity,
                                       DebugUtilsMessageTypeFlagsEXT              messageTypes,
                                       const DebugUtilsMessengerCallbackDataEXT & callbackData ) const VULKAN_HPP_NOEXCEPT;

#  if defined( VK_USE_PLATFORM_FUCHSIA )
      //=== VK_FUCHSIA_imagepipe_surface ===

      // wrapper function for command vkCreateImagePipeSurfaceFUCHSIA, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateImagePipeSurfaceFUCHSIA.html
      VULKAN_HPP_NODISCARD typename ResultValueType<SurfaceKHR>::type
        createImagePipeSurfaceFUCHSIA( ImagePipeSurfaceCreateInfoFUCHSIA const & createInfo,
                                       Optional<const AllocationCallbacks>       allocator = nullptr ) const VULKAN_HPP_NOEXCEPT_WHEN_NO_EXCEPTIONS;
#  endif /*VK_USE_PLATFORM_FUCHSIA*/

#  if defined( VK_USE_PLATFORM_METAL_EXT )
      //=== VK_EXT_metal_surface ===

      // wrapper function for command vkCreateMetalSurfaceEXT, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateMetalSurfaceEXT.html
      VULKAN_HPP_NODISCARD typename ResultValueType<SurfaceKHR>::type
        createMetalSurfaceEXT( MetalSurfaceCreateInfoEXT const &   createInfo,
                               Optional<const AllocationCallbacks> allocator = nullptr ) const VULKAN_HPP_NOEXCEPT_WHEN_NO_EXCEPTIONS;
#  endif /*VK_USE_PLATFORM_METAL_EXT*/

      //=== VK_EXT_headless_surface ===

      // wrapper function for command vkCreateHeadlessSurfaceEXT, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateHeadlessSurfaceEXT.html
      VULKAN_HPP_NODISCARD typename ResultValueType<SurfaceKHR>::type
        createHeadlessSurfaceEXT( HeadlessSurfaceCreateInfoEXT const & createInfo,
                                  Optional<const AllocationCallbacks>  allocator = nullptr ) const VULKAN_HPP_NOEXCEPT_WHEN_NO_EXCEPTIONS;

#  if defined( VK_USE_PLATFORM_DIRECTFB_EXT )
      //=== VK_EXT_directfb_surface ===

      // wrapper function for command vkCreateDirectFBSurfaceEXT, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateDirectFBSurfaceEXT.html
      VULKAN_HPP_NODISCARD typename ResultValueType<SurfaceKHR>::type
        createDirectFBSurfaceEXT( DirectFBSurfaceCreateInfoEXT const & createInfo,
                                  Optional<const AllocationCallbacks>  allocator = nullptr ) const VULKAN_HPP_NOEXCEPT_WHEN_NO_EXCEPTIONS;
#  endif /*VK_USE_PLATFORM_DIRECTFB_EXT*/

#  if defined( VK_USE_PLATFORM_SCREEN_QNX )
      //=== VK_QNX_screen_surface ===

      // wrapper function for command vkCreateScreenSurfaceQNX, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateScreenSurfaceQNX.html
      VULKAN_HPP_NODISCARD typename ResultValueType<SurfaceKHR>::type
        createScreenSurfaceQNX( ScreenSurfaceCreateInfoQNX const &  createInfo,
                                Optional<const AllocationCallbacks> allocator = nullptr ) const VULKAN_HPP_NOEXCEPT_WHEN_NO_EXCEPTIONS;
#  endif /*VK_USE_PLATFORM_SCREEN_QNX*/

#  if defined( VK_USE_PLATFORM_OHOS )
      //=== VK_OHOS_surface ===

      // wrapper function for command vkCreateSurfaceOHOS, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateSurfaceOHOS.html
      VULKAN_HPP_NODISCARD typename ResultValueType<SurfaceKHR>::type
        createSurfaceOHOS( SurfaceCreateInfoOHOS const &       createInfo,
                           Optional<const AllocationCallbacks> allocator = nullptr ) const VULKAN_HPP_NOEXCEPT_WHEN_NO_EXCEPTIONS;
#  endif /*VK_USE_PLATFORM_OHOS*/

    private:
      VULKAN_HPP_NAMESPACE::Instance              m_instance  = {};
      const AllocationCallbacks *                 m_allocator = {};
      std::unique_ptr<detail::InstanceDispatcher> m_dispatcher;
    };

    template <>
    struct isVulkanRAIIHandleType<Instance>
    {
      static VULKAN_HPP_CONST_OR_CONSTEXPR bool value = true;
    };

    // wrapper class for handle VkPhysicalDevice, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkPhysicalDevice.html
    class PhysicalDevice
    {
    public:
      using CType   = VkPhysicalDevice;
      using CppType = VULKAN_HPP_NAMESPACE::PhysicalDevice;

      static VULKAN_HPP_CONST_OR_CONSTEXPR ObjectType               objectType            = ObjectType::ePhysicalDevice;
      static VULKAN_HPP_CONST_OR_CONSTEXPR DebugReportObjectTypeEXT debugReportObjectType = DebugReportObjectTypeEXT::ePhysicalDevice;

    public:
      PhysicalDevice( Instance const & instance, VkPhysicalDevice physicalDevice )
        : m_physicalDevice( physicalDevice ), m_dispatcher( instance.getDispatcher() )
      {
      }

      PhysicalDevice( std::nullptr_t ) {}

      ~PhysicalDevice()
      {
        clear();
      }

      PhysicalDevice() = delete;

      PhysicalDevice( PhysicalDevice const & rhs ) : m_physicalDevice( rhs.m_physicalDevice ), m_dispatcher( rhs.m_dispatcher ) {}

      PhysicalDevice( PhysicalDevice && rhs ) VULKAN_HPP_NOEXCEPT
        : m_physicalDevice( exchange( rhs.m_physicalDevice, {} ) )
        , m_dispatcher( exchange( rhs.m_dispatcher, nullptr ) )
      {
      }

      PhysicalDevice & operator=( PhysicalDevice const & rhs )
      {
        m_physicalDevice = rhs.m_physicalDevice;
        m_dispatcher     = rhs.m_dispatcher;
        return *this;
      }

      PhysicalDevice & operator=( PhysicalDevice && rhs ) VULKAN_HPP_NOEXCEPT
      {
        if ( this != &rhs )
        {
          std::swap( m_physicalDevice, rhs.m_physicalDevice );
          std::swap( m_dispatcher, rhs.m_dispatcher );
        }
        return *this;
      }

      VULKAN_HPP_NAMESPACE::PhysicalDevice const & operator*() const & VULKAN_HPP_NOEXCEPT
      {
        return m_physicalDevice;
      }

      VULKAN_HPP_NAMESPACE::PhysicalDevice const && operator*() const && VULKAN_HPP_NOEXCEPT
      {
        return std::move( m_physicalDevice );
      }

      operator VULKAN_HPP_NAMESPACE::PhysicalDevice() const VULKAN_HPP_NOEXCEPT
      {
        return m_physicalDevice;
      }

      void clear() VULKAN_HPP_NOEXCEPT
      {
        m_physicalDevice = nullptr;
        m_dispatcher     = nullptr;
      }

      VULKAN_HPP_NAMESPACE::PhysicalDevice release()
      {
        m_dispatcher = nullptr;
        return exchange( m_physicalDevice, nullptr );
      }

      detail::InstanceDispatcher const * getDispatcher() const
      {
        VULKAN_HPP_ASSERT( m_dispatcher->getVkHeaderVersion() == VK_HEADER_VERSION );
        return m_dispatcher;
      }

      void swap( PhysicalDevice & rhs ) VULKAN_HPP_NOEXCEPT
      {
        std::swap( m_physicalDevice, rhs.m_physicalDevice );
        std::swap( m_dispatcher, rhs.m_dispatcher );
      }

      //=== VK_VERSION_1_0 ===

      // wrapper function for command vkGetPhysicalDeviceFeatures, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetPhysicalDeviceFeatures.html
      VULKAN_HPP_NODISCARD PhysicalDeviceFeatures getFeatures() const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkGetPhysicalDeviceFormatProperties, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetPhysicalDeviceFormatProperties.html
      VULKAN_HPP_NODISCARD FormatProperties getFormatProperties( Format format ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkGetPhysicalDeviceImageFormatProperties, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetPhysicalDeviceImageFormatProperties.html
      VULKAN_HPP_NODISCARD typename ResultValueType<ImageFormatProperties>::type getImageFormatProperties(
        Format format, ImageType type, ImageTiling tiling, ImageUsageFlags usage, ImageCreateFlags flags VULKAN_HPP_DEFAULT_ASSIGNMENT( {} ) ) const;

      // wrapper function for command vkGetPhysicalDeviceProperties, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetPhysicalDeviceProperties.html
      VULKAN_HPP_NODISCARD PhysicalDeviceProperties getProperties() const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkGetPhysicalDeviceQueueFamilyProperties, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetPhysicalDeviceQueueFamilyProperties.html
      VULKAN_HPP_NODISCARD std::vector<QueueFamilyProperties> getQueueFamilyProperties() const;

      // wrapper function for command vkGetPhysicalDeviceMemoryProperties, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetPhysicalDeviceMemoryProperties.html
      VULKAN_HPP_NODISCARD PhysicalDeviceMemoryProperties getMemoryProperties() const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkCreateDevice, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateDevice.html
      VULKAN_HPP_NODISCARD typename ResultValueType<Device>::type
        createDevice( DeviceCreateInfo const &            createInfo,
                      Optional<const AllocationCallbacks> allocator = nullptr ) const VULKAN_HPP_NOEXCEPT_WHEN_NO_EXCEPTIONS;

      // wrapper function for command vkEnumerateDeviceExtensionProperties, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkEnumerateDeviceExtensionProperties.html
      VULKAN_HPP_NODISCARD typename ResultValueType<std::vector<ExtensionProperties>>::type
        enumerateDeviceExtensionProperties( Optional<const std::string> layerName VULKAN_HPP_DEFAULT_ASSIGNMENT( nullptr ) ) const;

      // wrapper function for command vkEnumerateDeviceLayerProperties, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkEnumerateDeviceLayerProperties.html
      VULKAN_HPP_NODISCARD typename ResultValueType<std::vector<LayerProperties>>::type enumerateDeviceLayerProperties() const;

      // wrapper function for command vkGetPhysicalDeviceSparseImageFormatProperties, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetPhysicalDeviceSparseImageFormatProperties.html
      VULKAN_HPP_NODISCARD std::vector<SparseImageFormatProperties>
        getSparseImageFormatProperties( Format format, ImageType type, SampleCountFlagBits samples, ImageUsageFlags usage, ImageTiling tiling ) const;

      //=== VK_VERSION_1_1 ===

      // wrapper function for command vkGetPhysicalDeviceFeatures2, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetPhysicalDeviceFeatures2.html
      VULKAN_HPP_NODISCARD PhysicalDeviceFeatures2 getFeatures2() const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkGetPhysicalDeviceFeatures2, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetPhysicalDeviceFeatures2.html
      template <typename X, typename Y, typename... Z>
      VULKAN_HPP_NODISCARD StructureChain<X, Y, Z...> getFeatures2() const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkGetPhysicalDeviceProperties2, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetPhysicalDeviceProperties2.html
      VULKAN_HPP_NODISCARD PhysicalDeviceProperties2 getProperties2() const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkGetPhysicalDeviceProperties2, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetPhysicalDeviceProperties2.html
      template <typename X, typename Y, typename... Z>
      VULKAN_HPP_NODISCARD StructureChain<X, Y, Z...> getProperties2() const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkGetPhysicalDeviceFormatProperties2, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetPhysicalDeviceFormatProperties2.html
      VULKAN_HPP_NODISCARD FormatProperties2 getFormatProperties2( Format format ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkGetPhysicalDeviceFormatProperties2, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetPhysicalDeviceFormatProperties2.html
      template <typename X, typename Y, typename... Z>
      VULKAN_HPP_NODISCARD StructureChain<X, Y, Z...> getFormatProperties2( Format format ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkGetPhysicalDeviceImageFormatProperties2, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetPhysicalDeviceImageFormatProperties2.html
      VULKAN_HPP_NODISCARD Result getImageFormatProperties2( const PhysicalDeviceImageFormatInfo2 * pImageFormatInfo,
                                                             ImageFormatProperties2 *               pImageFormatProperties ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkGetPhysicalDeviceImageFormatProperties2, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetPhysicalDeviceImageFormatProperties2.html
      VULKAN_HPP_NODISCARD typename ResultValueType<ImageFormatProperties2>::type
        getImageFormatProperties2( const PhysicalDeviceImageFormatInfo2 & imageFormatInfo ) const;

      // wrapper function for command vkGetPhysicalDeviceImageFormatProperties2, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetPhysicalDeviceImageFormatProperties2.html
      template <typename X, typename Y, typename... Z>
      VULKAN_HPP_NODISCARD typename ResultValueType<StructureChain<X, Y, Z...>>::type
        getImageFormatProperties2( const PhysicalDeviceImageFormatInfo2 & imageFormatInfo ) const;

      // wrapper function for command vkGetPhysicalDeviceQueueFamilyProperties2, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetPhysicalDeviceQueueFamilyProperties2.html
      VULKAN_HPP_NODISCARD std::vector<QueueFamilyProperties2> getQueueFamilyProperties2() const;

      // wrapper function for command vkGetPhysicalDeviceQueueFamilyProperties2, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetPhysicalDeviceQueueFamilyProperties2.html
      template <typename StructureChain>
      VULKAN_HPP_NODISCARD std::vector<StructureChain> getQueueFamilyProperties2() const;

      // wrapper function for command vkGetPhysicalDeviceMemoryProperties2, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetPhysicalDeviceMemoryProperties2.html
      VULKAN_HPP_NODISCARD PhysicalDeviceMemoryProperties2 getMemoryProperties2() const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkGetPhysicalDeviceMemoryProperties2, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetPhysicalDeviceMemoryProperties2.html
      template <typename X, typename Y, typename... Z>
      VULKAN_HPP_NODISCARD StructureChain<X, Y, Z...> getMemoryProperties2() const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkGetPhysicalDeviceSparseImageFormatProperties2, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetPhysicalDeviceSparseImageFormatProperties2.html
      VULKAN_HPP_NODISCARD std::vector<SparseImageFormatProperties2>
                           getSparseImageFormatProperties2( const PhysicalDeviceSparseImageFormatInfo2 & formatInfo ) const;

      // wrapper function for command vkGetPhysicalDeviceExternalBufferProperties, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetPhysicalDeviceExternalBufferProperties.html
      VULKAN_HPP_NODISCARD ExternalBufferProperties
        getExternalBufferProperties( const PhysicalDeviceExternalBufferInfo & externalBufferInfo ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkGetPhysicalDeviceExternalFenceProperties, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetPhysicalDeviceExternalFenceProperties.html
      VULKAN_HPP_NODISCARD ExternalFenceProperties
        getExternalFenceProperties( const PhysicalDeviceExternalFenceInfo & externalFenceInfo ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkGetPhysicalDeviceExternalSemaphoreProperties, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetPhysicalDeviceExternalSemaphoreProperties.html
      VULKAN_HPP_NODISCARD ExternalSemaphoreProperties
        getExternalSemaphoreProperties( const PhysicalDeviceExternalSemaphoreInfo & externalSemaphoreInfo ) const VULKAN_HPP_NOEXCEPT;

      //=== VK_VERSION_1_3 ===

      // wrapper function for command vkGetPhysicalDeviceToolProperties, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetPhysicalDeviceToolProperties.html
      VULKAN_HPP_NODISCARD typename ResultValueType<std::vector<PhysicalDeviceToolProperties>>::type getToolProperties() const;

      //=== VK_KHR_surface ===

      // wrapper function for command vkGetPhysicalDeviceSurfaceSupportKHR, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetPhysicalDeviceSurfaceSupportKHR.html
      VULKAN_HPP_NODISCARD typename ResultValueType<Bool32>::type getSurfaceSupportKHR( uint32_t                         queueFamilyIndex,
                                                                                        VULKAN_HPP_NAMESPACE::SurfaceKHR surface ) const;

      // wrapper function for command vkGetPhysicalDeviceSurfaceCapabilitiesKHR, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetPhysicalDeviceSurfaceCapabilitiesKHR.html
      VULKAN_HPP_NODISCARD typename ResultValueType<SurfaceCapabilitiesKHR>::type getSurfaceCapabilitiesKHR( VULKAN_HPP_NAMESPACE::SurfaceKHR surface ) const;

      // wrapper function for command vkGetPhysicalDeviceSurfaceFormatsKHR, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetPhysicalDeviceSurfaceFormatsKHR.html
      VULKAN_HPP_NODISCARD typename ResultValueType<std::vector<SurfaceFormatKHR>>::type
        getSurfaceFormatsKHR( VULKAN_HPP_NAMESPACE::SurfaceKHR surface VULKAN_HPP_DEFAULT_ASSIGNMENT( {} ) ) const;

      // wrapper function for command vkGetPhysicalDeviceSurfacePresentModesKHR, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetPhysicalDeviceSurfacePresentModesKHR.html
      VULKAN_HPP_NODISCARD typename ResultValueType<std::vector<PresentModeKHR>>::type
        getSurfacePresentModesKHR( VULKAN_HPP_NAMESPACE::SurfaceKHR surface VULKAN_HPP_DEFAULT_ASSIGNMENT( {} ) ) const;

      //=== VK_KHR_swapchain ===

      // wrapper function for command vkGetPhysicalDevicePresentRectanglesKHR, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetPhysicalDevicePresentRectanglesKHR.html
      VULKAN_HPP_NODISCARD typename ResultValueType<std::vector<Rect2D>>::type getPresentRectanglesKHR( VULKAN_HPP_NAMESPACE::SurfaceKHR surface ) const;

      //=== VK_KHR_display ===

      // wrapper function for command vkGetPhysicalDeviceDisplayPropertiesKHR, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetPhysicalDeviceDisplayPropertiesKHR.html
      VULKAN_HPP_NODISCARD typename ResultValueType<std::vector<DisplayPropertiesKHR>>::type getDisplayPropertiesKHR() const;

      // wrapper function for command vkGetPhysicalDeviceDisplayPlanePropertiesKHR, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetPhysicalDeviceDisplayPlanePropertiesKHR.html
      VULKAN_HPP_NODISCARD typename ResultValueType<std::vector<DisplayPlanePropertiesKHR>>::type getDisplayPlanePropertiesKHR() const;

      // wrapper function for command vkGetDisplayPlaneSupportedDisplaysKHR, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetDisplayPlaneSupportedDisplaysKHR.html
      VULKAN_HPP_NODISCARD typename ResultValueType<std::vector<DisplayKHR>>::type getDisplayPlaneSupportedDisplaysKHR( uint32_t planeIndex ) const;

#  if defined( VK_USE_PLATFORM_XLIB_KHR )
      //=== VK_KHR_xlib_surface ===

      // wrapper function for command vkGetPhysicalDeviceXlibPresentationSupportKHR, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetPhysicalDeviceXlibPresentationSupportKHR.html
      VULKAN_HPP_NODISCARD Bool32 getXlibPresentationSupportKHR( uint32_t queueFamilyIndex, Display & dpy, VisualID visualID ) const VULKAN_HPP_NOEXCEPT;
#  endif /*VK_USE_PLATFORM_XLIB_KHR*/

#  if defined( VK_USE_PLATFORM_XCB_KHR )
      //=== VK_KHR_xcb_surface ===

      // wrapper function for command vkGetPhysicalDeviceXcbPresentationSupportKHR, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetPhysicalDeviceXcbPresentationSupportKHR.html
      VULKAN_HPP_NODISCARD Bool32 getXcbPresentationSupportKHR( uint32_t           queueFamilyIndex,
                                                                xcb_connection_t & connection,
                                                                xcb_visualid_t     visual_id ) const VULKAN_HPP_NOEXCEPT;
#  endif /*VK_USE_PLATFORM_XCB_KHR*/

#  if defined( VK_USE_PLATFORM_WAYLAND_KHR )
      //=== VK_KHR_wayland_surface ===

      // wrapper function for command vkGetPhysicalDeviceWaylandPresentationSupportKHR, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetPhysicalDeviceWaylandPresentationSupportKHR.html
      VULKAN_HPP_NODISCARD Bool32 getWaylandPresentationSupportKHR( uint32_t queueFamilyIndex, struct wl_display & display ) const VULKAN_HPP_NOEXCEPT;
#  endif /*VK_USE_PLATFORM_WAYLAND_KHR*/

#  if defined( VK_USE_PLATFORM_WIN32_KHR )
      //=== VK_KHR_win32_surface ===

      // wrapper function for command vkGetPhysicalDeviceWin32PresentationSupportKHR, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetPhysicalDeviceWin32PresentationSupportKHR.html
      VULKAN_HPP_NODISCARD Bool32 getWin32PresentationSupportKHR( uint32_t queueFamilyIndex ) const VULKAN_HPP_NOEXCEPT;
#  endif /*VK_USE_PLATFORM_WIN32_KHR*/

      //=== VK_KHR_video_queue ===

      // wrapper function for command vkGetPhysicalDeviceVideoCapabilitiesKHR, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetPhysicalDeviceVideoCapabilitiesKHR.html
      VULKAN_HPP_NODISCARD Result getVideoCapabilitiesKHR( const VideoProfileInfoKHR * pVideoProfile,
                                                           VideoCapabilitiesKHR *      pCapabilities ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkGetPhysicalDeviceVideoCapabilitiesKHR, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetPhysicalDeviceVideoCapabilitiesKHR.html
      VULKAN_HPP_NODISCARD typename ResultValueType<VideoCapabilitiesKHR>::type getVideoCapabilitiesKHR( const VideoProfileInfoKHR & videoProfile ) const;

      // wrapper function for command vkGetPhysicalDeviceVideoCapabilitiesKHR, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetPhysicalDeviceVideoCapabilitiesKHR.html
      template <typename X, typename Y, typename... Z>
      VULKAN_HPP_NODISCARD typename ResultValueType<StructureChain<X, Y, Z...>>::type getVideoCapabilitiesKHR( const VideoProfileInfoKHR & videoProfile ) const;

      // wrapper function for command vkGetPhysicalDeviceVideoFormatPropertiesKHR, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetPhysicalDeviceVideoFormatPropertiesKHR.html
      VULKAN_HPP_NODISCARD typename ResultValueType<std::vector<VideoFormatPropertiesKHR>>::type
        getVideoFormatPropertiesKHR( const PhysicalDeviceVideoFormatInfoKHR & videoFormatInfo ) const;

      // wrapper function for command vkGetPhysicalDeviceVideoFormatPropertiesKHR, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetPhysicalDeviceVideoFormatPropertiesKHR.html
      template <typename StructureChain>
      VULKAN_HPP_NODISCARD typename ResultValueType<std::vector<StructureChain>>::type
        getVideoFormatPropertiesKHR( const PhysicalDeviceVideoFormatInfoKHR & videoFormatInfo ) const;

      //=== VK_NV_external_memory_capabilities ===

      // wrapper function for command vkGetPhysicalDeviceExternalImageFormatPropertiesNV, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetPhysicalDeviceExternalImageFormatPropertiesNV.html
      VULKAN_HPP_NODISCARD typename ResultValueType<ExternalImageFormatPropertiesNV>::type
        getExternalImageFormatPropertiesNV( Format                                             format,
                                            ImageType                                          type,
                                            ImageTiling                                        tiling,
                                            ImageUsageFlags                                    usage,
                                            ImageCreateFlags flags                             VULKAN_HPP_DEFAULT_ASSIGNMENT( {} ),
                                            ExternalMemoryHandleTypeFlagsNV externalHandleType VULKAN_HPP_DEFAULT_ASSIGNMENT( {} ) ) const;

      //=== VK_KHR_get_physical_device_properties2 ===

      // wrapper function for command vkGetPhysicalDeviceFeatures2KHR, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetPhysicalDeviceFeatures2KHR.html
      VULKAN_HPP_NODISCARD PhysicalDeviceFeatures2 getFeatures2KHR() const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkGetPhysicalDeviceFeatures2KHR, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetPhysicalDeviceFeatures2KHR.html
      template <typename X, typename Y, typename... Z>
      VULKAN_HPP_NODISCARD StructureChain<X, Y, Z...> getFeatures2KHR() const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkGetPhysicalDeviceProperties2KHR, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetPhysicalDeviceProperties2KHR.html
      VULKAN_HPP_NODISCARD PhysicalDeviceProperties2 getProperties2KHR() const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkGetPhysicalDeviceProperties2KHR, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetPhysicalDeviceProperties2KHR.html
      template <typename X, typename Y, typename... Z>
      VULKAN_HPP_NODISCARD StructureChain<X, Y, Z...> getProperties2KHR() const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkGetPhysicalDeviceFormatProperties2KHR, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetPhysicalDeviceFormatProperties2KHR.html
      VULKAN_HPP_NODISCARD FormatProperties2 getFormatProperties2KHR( Format format ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkGetPhysicalDeviceFormatProperties2KHR, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetPhysicalDeviceFormatProperties2KHR.html
      template <typename X, typename Y, typename... Z>
      VULKAN_HPP_NODISCARD StructureChain<X, Y, Z...> getFormatProperties2KHR( Format format ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkGetPhysicalDeviceImageFormatProperties2KHR, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetPhysicalDeviceImageFormatProperties2KHR.html
      VULKAN_HPP_NODISCARD Result getImageFormatProperties2KHR( const PhysicalDeviceImageFormatInfo2 * pImageFormatInfo,
                                                                ImageFormatProperties2 *               pImageFormatProperties ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkGetPhysicalDeviceImageFormatProperties2KHR, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetPhysicalDeviceImageFormatProperties2KHR.html
      VULKAN_HPP_NODISCARD typename ResultValueType<ImageFormatProperties2>::type
        getImageFormatProperties2KHR( const PhysicalDeviceImageFormatInfo2 & imageFormatInfo ) const;

      // wrapper function for command vkGetPhysicalDeviceImageFormatProperties2KHR, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetPhysicalDeviceImageFormatProperties2KHR.html
      template <typename X, typename Y, typename... Z>
      VULKAN_HPP_NODISCARD typename ResultValueType<StructureChain<X, Y, Z...>>::type
        getImageFormatProperties2KHR( const PhysicalDeviceImageFormatInfo2 & imageFormatInfo ) const;

      // wrapper function for command vkGetPhysicalDeviceQueueFamilyProperties2KHR, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetPhysicalDeviceQueueFamilyProperties2KHR.html
      VULKAN_HPP_NODISCARD std::vector<QueueFamilyProperties2> getQueueFamilyProperties2KHR() const;

      // wrapper function for command vkGetPhysicalDeviceQueueFamilyProperties2KHR, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetPhysicalDeviceQueueFamilyProperties2KHR.html
      template <typename StructureChain>
      VULKAN_HPP_NODISCARD std::vector<StructureChain> getQueueFamilyProperties2KHR() const;

      // wrapper function for command vkGetPhysicalDeviceMemoryProperties2KHR, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetPhysicalDeviceMemoryProperties2KHR.html
      VULKAN_HPP_NODISCARD PhysicalDeviceMemoryProperties2 getMemoryProperties2KHR() const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkGetPhysicalDeviceMemoryProperties2KHR, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetPhysicalDeviceMemoryProperties2KHR.html
      template <typename X, typename Y, typename... Z>
      VULKAN_HPP_NODISCARD StructureChain<X, Y, Z...> getMemoryProperties2KHR() const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkGetPhysicalDeviceSparseImageFormatProperties2KHR, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetPhysicalDeviceSparseImageFormatProperties2KHR.html
      VULKAN_HPP_NODISCARD std::vector<SparseImageFormatProperties2>
                           getSparseImageFormatProperties2KHR( const PhysicalDeviceSparseImageFormatInfo2 & formatInfo ) const;

      //=== VK_KHR_external_memory_capabilities ===

      // wrapper function for command vkGetPhysicalDeviceExternalBufferPropertiesKHR, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetPhysicalDeviceExternalBufferPropertiesKHR.html
      VULKAN_HPP_NODISCARD ExternalBufferProperties
        getExternalBufferPropertiesKHR( const PhysicalDeviceExternalBufferInfo & externalBufferInfo ) const VULKAN_HPP_NOEXCEPT;

      //=== VK_KHR_external_semaphore_capabilities ===

      // wrapper function for command vkGetPhysicalDeviceExternalSemaphorePropertiesKHR, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetPhysicalDeviceExternalSemaphorePropertiesKHR.html
      VULKAN_HPP_NODISCARD ExternalSemaphoreProperties
        getExternalSemaphorePropertiesKHR( const PhysicalDeviceExternalSemaphoreInfo & externalSemaphoreInfo ) const VULKAN_HPP_NOEXCEPT;

#  if defined( VK_USE_PLATFORM_XLIB_XRANDR_EXT )
      //=== VK_EXT_acquire_xlib_display ===

      // wrapper function for command vkAcquireXlibDisplayEXT, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkAcquireXlibDisplayEXT.html
      typename ResultValueType<void>::type acquireXlibDisplayEXT( Display & dpy, VULKAN_HPP_NAMESPACE::DisplayKHR display ) const;

      // wrapper function for command vkGetRandROutputDisplayEXT, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetRandROutputDisplayEXT.html
      VULKAN_HPP_NODISCARD typename ResultValueType<DisplayKHR>::type
        getRandROutputDisplayEXT( Display & dpy, RROutput rrOutput ) const VULKAN_HPP_NOEXCEPT_WHEN_NO_EXCEPTIONS;
#  endif /*VK_USE_PLATFORM_XLIB_XRANDR_EXT*/

      //=== VK_EXT_display_surface_counter ===

      // wrapper function for command vkGetPhysicalDeviceSurfaceCapabilities2EXT, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetPhysicalDeviceSurfaceCapabilities2EXT.html
      VULKAN_HPP_NODISCARD typename ResultValueType<SurfaceCapabilities2EXT>::type getSurfaceCapabilities2EXT( VULKAN_HPP_NAMESPACE::SurfaceKHR surface ) const;

      //=== VK_KHR_external_fence_capabilities ===

      // wrapper function for command vkGetPhysicalDeviceExternalFencePropertiesKHR, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetPhysicalDeviceExternalFencePropertiesKHR.html
      VULKAN_HPP_NODISCARD ExternalFenceProperties
        getExternalFencePropertiesKHR( const PhysicalDeviceExternalFenceInfo & externalFenceInfo ) const VULKAN_HPP_NOEXCEPT;

      //=== VK_KHR_performance_query ===

      // wrapper function for command vkEnumeratePhysicalDeviceQueueFamilyPerformanceQueryCountersKHR, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkEnumeratePhysicalDeviceQueueFamilyPerformanceQueryCountersKHR.html
      VULKAN_HPP_NODISCARD typename ResultValueType<std::pair<std::vector<PerformanceCounterKHR>, std::vector<PerformanceCounterDescriptionKHR>>>::type
        enumerateQueueFamilyPerformanceQueryCountersKHR( uint32_t queueFamilyIndex ) const;

      // wrapper function for command vkGetPhysicalDeviceQueueFamilyPerformanceQueryPassesKHR, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetPhysicalDeviceQueueFamilyPerformanceQueryPassesKHR.html
      VULKAN_HPP_NODISCARD uint32_t
        getQueueFamilyPerformanceQueryPassesKHR( const QueryPoolPerformanceCreateInfoKHR & performanceQueryCreateInfo ) const VULKAN_HPP_NOEXCEPT;

      //=== VK_KHR_get_surface_capabilities2 ===

      // wrapper function for command vkGetPhysicalDeviceSurfaceCapabilities2KHR, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetPhysicalDeviceSurfaceCapabilities2KHR.html
      VULKAN_HPP_NODISCARD Result getSurfaceCapabilities2KHR( const PhysicalDeviceSurfaceInfo2KHR * pSurfaceInfo,
                                                              SurfaceCapabilities2KHR *             pSurfaceCapabilities ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkGetPhysicalDeviceSurfaceCapabilities2KHR, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetPhysicalDeviceSurfaceCapabilities2KHR.html
      VULKAN_HPP_NODISCARD typename ResultValueType<SurfaceCapabilities2KHR>::type
        getSurfaceCapabilities2KHR( const PhysicalDeviceSurfaceInfo2KHR & surfaceInfo ) const;

      // wrapper function for command vkGetPhysicalDeviceSurfaceCapabilities2KHR, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetPhysicalDeviceSurfaceCapabilities2KHR.html
      template <typename X, typename Y, typename... Z>
      VULKAN_HPP_NODISCARD typename ResultValueType<StructureChain<X, Y, Z...>>::type
        getSurfaceCapabilities2KHR( const PhysicalDeviceSurfaceInfo2KHR & surfaceInfo ) const;

      // wrapper function for command vkGetPhysicalDeviceSurfaceFormats2KHR, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetPhysicalDeviceSurfaceFormats2KHR.html
      VULKAN_HPP_NODISCARD typename ResultValueType<std::vector<SurfaceFormat2KHR>>::type
        getSurfaceFormats2KHR( const PhysicalDeviceSurfaceInfo2KHR & surfaceInfo ) const;

      // wrapper function for command vkGetPhysicalDeviceSurfaceFormats2KHR, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetPhysicalDeviceSurfaceFormats2KHR.html
      template <typename StructureChain>
      VULKAN_HPP_NODISCARD typename ResultValueType<std::vector<StructureChain>>::type
        getSurfaceFormats2KHR( const PhysicalDeviceSurfaceInfo2KHR & surfaceInfo ) const;

      //=== VK_KHR_get_display_properties2 ===

      // wrapper function for command vkGetPhysicalDeviceDisplayProperties2KHR, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetPhysicalDeviceDisplayProperties2KHR.html
      VULKAN_HPP_NODISCARD typename ResultValueType<std::vector<DisplayProperties2KHR>>::type getDisplayProperties2KHR() const;

      // wrapper function for command vkGetPhysicalDeviceDisplayPlaneProperties2KHR, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetPhysicalDeviceDisplayPlaneProperties2KHR.html
      VULKAN_HPP_NODISCARD typename ResultValueType<std::vector<DisplayPlaneProperties2KHR>>::type getDisplayPlaneProperties2KHR() const;

      // wrapper function for command vkGetDisplayPlaneCapabilities2KHR, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetDisplayPlaneCapabilities2KHR.html
      VULKAN_HPP_NODISCARD typename ResultValueType<DisplayPlaneCapabilities2KHR>::type
        getDisplayPlaneCapabilities2KHR( const DisplayPlaneInfo2KHR & displayPlaneInfo ) const;

      //=== VK_EXT_sample_locations ===

      // wrapper function for command vkGetPhysicalDeviceMultisamplePropertiesEXT, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetPhysicalDeviceMultisamplePropertiesEXT.html
      VULKAN_HPP_NODISCARD MultisamplePropertiesEXT getMultisamplePropertiesEXT( SampleCountFlagBits samples ) const VULKAN_HPP_NOEXCEPT;

      //=== VK_EXT_calibrated_timestamps ===

      // wrapper function for command vkGetPhysicalDeviceCalibrateableTimeDomainsEXT, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetPhysicalDeviceCalibrateableTimeDomainsEXT.html
      VULKAN_HPP_NODISCARD typename ResultValueType<std::vector<TimeDomainKHR>>::type getCalibrateableTimeDomainsEXT() const;

      //=== VK_KHR_fragment_shading_rate ===

      // wrapper function for command vkGetPhysicalDeviceFragmentShadingRatesKHR, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetPhysicalDeviceFragmentShadingRatesKHR.html
      VULKAN_HPP_NODISCARD typename ResultValueType<std::vector<PhysicalDeviceFragmentShadingRateKHR>>::type getFragmentShadingRatesKHR() const;

      //=== VK_EXT_tooling_info ===

      // wrapper function for command vkGetPhysicalDeviceToolPropertiesEXT, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetPhysicalDeviceToolPropertiesEXT.html
      VULKAN_HPP_NODISCARD typename ResultValueType<std::vector<PhysicalDeviceToolProperties>>::type getToolPropertiesEXT() const;

      //=== VK_NV_cooperative_matrix ===

      // wrapper function for command vkGetPhysicalDeviceCooperativeMatrixPropertiesNV, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetPhysicalDeviceCooperativeMatrixPropertiesNV.html
      VULKAN_HPP_NODISCARD typename ResultValueType<std::vector<CooperativeMatrixPropertiesNV>>::type getCooperativeMatrixPropertiesNV() const;

      //=== VK_NV_coverage_reduction_mode ===

      // wrapper function for command vkGetPhysicalDeviceSupportedFramebufferMixedSamplesCombinationsNV, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetPhysicalDeviceSupportedFramebufferMixedSamplesCombinationsNV.html
      VULKAN_HPP_NODISCARD typename ResultValueType<std::vector<FramebufferMixedSamplesCombinationNV>>::type
        getSupportedFramebufferMixedSamplesCombinationsNV() const;

#  if defined( VK_USE_PLATFORM_WIN32_KHR )
      //=== VK_EXT_full_screen_exclusive ===

      // wrapper function for command vkGetPhysicalDeviceSurfacePresentModes2EXT, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetPhysicalDeviceSurfacePresentModes2EXT.html
      VULKAN_HPP_NODISCARD typename ResultValueType<std::vector<PresentModeKHR>>::type
        getSurfacePresentModes2EXT( const PhysicalDeviceSurfaceInfo2KHR & surfaceInfo ) const;
#  endif /*VK_USE_PLATFORM_WIN32_KHR*/

      //=== VK_EXT_acquire_drm_display ===

      // wrapper function for command vkAcquireDrmDisplayEXT, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkAcquireDrmDisplayEXT.html
      typename ResultValueType<void>::type acquireDrmDisplayEXT( int32_t drmFd, VULKAN_HPP_NAMESPACE::DisplayKHR display ) const;

      // wrapper function for command vkGetDrmDisplayEXT, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetDrmDisplayEXT.html
      VULKAN_HPP_NODISCARD typename ResultValueType<DisplayKHR>::type getDrmDisplayEXT( int32_t  drmFd,
                                                                                        uint32_t connectorId ) const VULKAN_HPP_NOEXCEPT_WHEN_NO_EXCEPTIONS;

      //=== VK_KHR_video_encode_queue ===

      // wrapper function for command vkGetPhysicalDeviceVideoEncodeQualityLevelPropertiesKHR, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetPhysicalDeviceVideoEncodeQualityLevelPropertiesKHR.html
      VULKAN_HPP_NODISCARD Result
        getVideoEncodeQualityLevelPropertiesKHR( const PhysicalDeviceVideoEncodeQualityLevelInfoKHR * pQualityLevelInfo,
                                                 VideoEncodeQualityLevelPropertiesKHR *               pQualityLevelProperties ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkGetPhysicalDeviceVideoEncodeQualityLevelPropertiesKHR, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetPhysicalDeviceVideoEncodeQualityLevelPropertiesKHR.html
      VULKAN_HPP_NODISCARD typename ResultValueType<VideoEncodeQualityLevelPropertiesKHR>::type
        getVideoEncodeQualityLevelPropertiesKHR( const PhysicalDeviceVideoEncodeQualityLevelInfoKHR & qualityLevelInfo ) const;

      // wrapper function for command vkGetPhysicalDeviceVideoEncodeQualityLevelPropertiesKHR, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetPhysicalDeviceVideoEncodeQualityLevelPropertiesKHR.html
      template <typename X, typename Y, typename... Z>
      VULKAN_HPP_NODISCARD typename ResultValueType<StructureChain<X, Y, Z...>>::type
        getVideoEncodeQualityLevelPropertiesKHR( const PhysicalDeviceVideoEncodeQualityLevelInfoKHR & qualityLevelInfo ) const;

#  if defined( VK_USE_PLATFORM_WIN32_KHR )
      //=== VK_NV_acquire_winrt_display ===

      // wrapper function for command vkGetWinrtDisplayNV, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetWinrtDisplayNV.html
      VULKAN_HPP_NODISCARD typename ResultValueType<DisplayKHR>::type
        getWinrtDisplayNV( uint32_t deviceRelativeId ) const VULKAN_HPP_NOEXCEPT_WHEN_NO_EXCEPTIONS;
#  endif /*VK_USE_PLATFORM_WIN32_KHR*/

#  if defined( VK_USE_PLATFORM_DIRECTFB_EXT )
      //=== VK_EXT_directfb_surface ===

      // wrapper function for command vkGetPhysicalDeviceDirectFBPresentationSupportEXT, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetPhysicalDeviceDirectFBPresentationSupportEXT.html
      VULKAN_HPP_NODISCARD Bool32 getDirectFBPresentationSupportEXT( uint32_t queueFamilyIndex, IDirectFB & dfb ) const VULKAN_HPP_NOEXCEPT;
#  endif /*VK_USE_PLATFORM_DIRECTFB_EXT*/

#  if defined( VK_USE_PLATFORM_SCREEN_QNX )
      //=== VK_QNX_screen_surface ===

      // wrapper function for command vkGetPhysicalDeviceScreenPresentationSupportQNX, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetPhysicalDeviceScreenPresentationSupportQNX.html
      VULKAN_HPP_NODISCARD Bool32 getScreenPresentationSupportQNX( uint32_t queueFamilyIndex, struct _screen_window & window ) const VULKAN_HPP_NOEXCEPT;
#  endif /*VK_USE_PLATFORM_SCREEN_QNX*/

      //=== VK_ARM_tensors ===

      // wrapper function for command vkGetPhysicalDeviceExternalTensorPropertiesARM, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetPhysicalDeviceExternalTensorPropertiesARM.html
      VULKAN_HPP_NODISCARD ExternalTensorPropertiesARM
        getExternalTensorPropertiesARM( const PhysicalDeviceExternalTensorInfoARM & externalTensorInfo ) const VULKAN_HPP_NOEXCEPT;

      //=== VK_NV_optical_flow ===

      // wrapper function for command vkGetPhysicalDeviceOpticalFlowImageFormatsNV, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetPhysicalDeviceOpticalFlowImageFormatsNV.html
      VULKAN_HPP_NODISCARD typename ResultValueType<std::vector<OpticalFlowImageFormatPropertiesNV>>::type
        getOpticalFlowImageFormatsNV( const OpticalFlowImageFormatInfoNV & opticalFlowImageFormatInfo ) const;

      //=== VK_NV_cooperative_vector ===

      // wrapper function for command vkGetPhysicalDeviceCooperativeVectorPropertiesNV, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetPhysicalDeviceCooperativeVectorPropertiesNV.html
      VULKAN_HPP_NODISCARD typename ResultValueType<std::vector<CooperativeVectorPropertiesNV>>::type getCooperativeVectorPropertiesNV() const;

      //=== VK_KHR_cooperative_matrix ===

      // wrapper function for command vkGetPhysicalDeviceCooperativeMatrixPropertiesKHR, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetPhysicalDeviceCooperativeMatrixPropertiesKHR.html
      VULKAN_HPP_NODISCARD typename ResultValueType<std::vector<CooperativeMatrixPropertiesKHR>>::type getCooperativeMatrixPropertiesKHR() const;

      //=== VK_ARM_data_graph ===

      // wrapper function for command vkGetPhysicalDeviceQueueFamilyDataGraphPropertiesARM, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetPhysicalDeviceQueueFamilyDataGraphPropertiesARM.html
      VULKAN_HPP_NODISCARD typename ResultValueType<std::vector<QueueFamilyDataGraphPropertiesARM>>::type
        getQueueFamilyDataGraphPropertiesARM( uint32_t queueFamilyIndex ) const;

      // wrapper function for command vkGetPhysicalDeviceQueueFamilyDataGraphProcessingEnginePropertiesARM, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetPhysicalDeviceQueueFamilyDataGraphProcessingEnginePropertiesARM.html
      VULKAN_HPP_NODISCARD QueueFamilyDataGraphProcessingEnginePropertiesARM getQueueFamilyDataGraphProcessingEnginePropertiesARM(
        const PhysicalDeviceQueueFamilyDataGraphProcessingEngineInfoARM & queueFamilyDataGraphProcessingEngineInfo ) const VULKAN_HPP_NOEXCEPT;

      //=== VK_KHR_calibrated_timestamps ===

      // wrapper function for command vkGetPhysicalDeviceCalibrateableTimeDomainsKHR, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetPhysicalDeviceCalibrateableTimeDomainsKHR.html
      VULKAN_HPP_NODISCARD typename ResultValueType<std::vector<TimeDomainKHR>>::type getCalibrateableTimeDomainsKHR() const;

      //=== VK_NV_cooperative_matrix2 ===

      // wrapper function for command vkGetPhysicalDeviceCooperativeMatrixFlexibleDimensionsPropertiesNV, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetPhysicalDeviceCooperativeMatrixFlexibleDimensionsPropertiesNV.html
      VULKAN_HPP_NODISCARD typename ResultValueType<std::vector<CooperativeMatrixFlexibleDimensionsPropertiesNV>>::type
        getCooperativeMatrixFlexibleDimensionsPropertiesNV() const;

      //=== VK_ARM_performance_counters_by_region ===

      // wrapper function for command vkEnumeratePhysicalDeviceQueueFamilyPerformanceCountersByRegionARM, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkEnumeratePhysicalDeviceQueueFamilyPerformanceCountersByRegionARM.html
      VULKAN_HPP_NODISCARD typename ResultValueType<std::pair<std::vector<PerformanceCounterARM>, std::vector<PerformanceCounterDescriptionARM>>>::type
        enumerateQueueFamilyPerformanceCountersByRegionARM( uint32_t queueFamilyIndex ) const;

    private:
      VULKAN_HPP_NAMESPACE::PhysicalDevice m_physicalDevice = {};
      detail::InstanceDispatcher const *   m_dispatcher     = nullptr;
    };

    template <>
    struct isVulkanRAIIHandleType<PhysicalDevice>
    {
      static VULKAN_HPP_CONST_OR_CONSTEXPR bool value = true;
    };

    class PhysicalDevices : public std::vector<PhysicalDevice>
    {
    public:
#  if !defined( VULKAN_HPP_NO_EXCEPTIONS )
      PhysicalDevices( Instance const & instance )
      {
        *this = instance.enumeratePhysicalDevices();
      }
#  endif

      PhysicalDevices( std::nullptr_t ) {}

      PhysicalDevices()                                      = delete;
      PhysicalDevices( PhysicalDevices const & )             = delete;
      PhysicalDevices( PhysicalDevices && rhs )              = default;
      PhysicalDevices & operator=( PhysicalDevices const & ) = delete;
      PhysicalDevices & operator=( PhysicalDevices && rhs )  = default;

    private:
      PhysicalDevices( std::vector<PhysicalDevice> && rhs )
      {
        std::swap( *this, rhs );
      }
    };

    // wrapper class for handle VkDevice, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkDevice.html
    class Device
    {
    public:
      using CType   = VkDevice;
      using CppType = VULKAN_HPP_NAMESPACE::Device;

      static VULKAN_HPP_CONST_OR_CONSTEXPR ObjectType               objectType            = ObjectType::eDevice;
      static VULKAN_HPP_CONST_OR_CONSTEXPR DebugReportObjectTypeEXT debugReportObjectType = DebugReportObjectTypeEXT::eDevice;

    public:
#  if !defined( VULKAN_HPP_NO_EXCEPTIONS )
      Device( PhysicalDevice const & physicalDevice, DeviceCreateInfo const & createInfo, Optional<const AllocationCallbacks> allocator = nullptr )
      {
        *this = physicalDevice.createDevice( createInfo, allocator );
      }
#  endif

      Device( PhysicalDevice const & physicalDevice, VkDevice device, Optional<const AllocationCallbacks> allocator = nullptr )
        : m_device( device ), m_allocator( static_cast<const AllocationCallbacks *>( allocator ) )
      {
        m_dispatcher.reset( new detail::DeviceDispatcher( physicalDevice.getDispatcher()->vkGetDeviceProcAddr, static_cast<VkDevice>( m_device ) ) );
      }

      Device( std::nullptr_t ) {}

      ~Device()
      {
        clear();
      }

      Device()                 = delete;
      Device( Device const & ) = delete;

      Device( Device && rhs ) VULKAN_HPP_NOEXCEPT
        : m_device( exchange( rhs.m_device, {} ) )
        , m_allocator( exchange( rhs.m_allocator, {} ) )
        , m_dispatcher( rhs.m_dispatcher.release() )
      {
      }

      Device & operator=( Device const & ) = delete;

      Device & operator=( Device && rhs ) VULKAN_HPP_NOEXCEPT
      {
        if ( this != &rhs )
        {
          std::swap( m_device, rhs.m_device );
          std::swap( m_allocator, rhs.m_allocator );
          std::swap( m_dispatcher, rhs.m_dispatcher );
        }
        return *this;
      }

      VULKAN_HPP_NAMESPACE::Device const & operator*() const & VULKAN_HPP_NOEXCEPT
      {
        return m_device;
      }

      VULKAN_HPP_NAMESPACE::Device const && operator*() const && VULKAN_HPP_NOEXCEPT
      {
        return std::move( m_device );
      }

      operator VULKAN_HPP_NAMESPACE::Device() const VULKAN_HPP_NOEXCEPT
      {
        return m_device;
      }

      void clear() VULKAN_HPP_NOEXCEPT
      {
        if ( m_device )
        {
          getDispatcher()->vkDestroyDevice( static_cast<VkDevice>( m_device ), reinterpret_cast<const VkAllocationCallbacks *>( m_allocator ) );
        }
        m_device     = nullptr;
        m_allocator  = nullptr;
        m_dispatcher = nullptr;
      }

      VULKAN_HPP_NAMESPACE::Device release()
      {
        m_allocator  = nullptr;
        m_dispatcher = nullptr;
        return exchange( m_device, nullptr );
      }

      detail::DeviceDispatcher const * getDispatcher() const
      {
        VULKAN_HPP_ASSERT( m_dispatcher->getVkHeaderVersion() == VK_HEADER_VERSION );
        return &*m_dispatcher;
      }

      void swap( Device & rhs ) VULKAN_HPP_NOEXCEPT
      {
        std::swap( m_device, rhs.m_device );
        std::swap( m_allocator, rhs.m_allocator );
        std::swap( m_dispatcher, rhs.m_dispatcher );
      }

      //=== VK_VERSION_1_0 ===

      // wrapper function for command vkGetDeviceProcAddr, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetDeviceProcAddr.html
      VULKAN_HPP_NODISCARD PFN_VoidFunction getProcAddr( const std::string & name ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkGetDeviceQueue, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetDeviceQueue.html
      VULKAN_HPP_NODISCARD Queue getQueue( uint32_t queueFamilyIndex, uint32_t queueIndex ) const VULKAN_HPP_NOEXCEPT_WHEN_NO_EXCEPTIONS;

      // wrapper function for command vkDeviceWaitIdle, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkDeviceWaitIdle.html
      typename ResultValueType<void>::type waitIdle() const;

      // wrapper function for command vkAllocateMemory, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkAllocateMemory.html
      VULKAN_HPP_NODISCARD typename ResultValueType<DeviceMemory>::type
        allocateMemory( MemoryAllocateInfo const &          allocateInfo,
                        Optional<const AllocationCallbacks> allocator = nullptr ) const VULKAN_HPP_NOEXCEPT_WHEN_NO_EXCEPTIONS;

      // wrapper function for command vkFlushMappedMemoryRanges, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkFlushMappedMemoryRanges.html
      typename ResultValueType<void>::type flushMappedMemoryRanges( ArrayProxy<const MappedMemoryRange> const & memoryRanges ) const;

      // wrapper function for command vkInvalidateMappedMemoryRanges, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkInvalidateMappedMemoryRanges.html
      typename ResultValueType<void>::type invalidateMappedMemoryRanges( ArrayProxy<const MappedMemoryRange> const & memoryRanges ) const;

      // wrapper function for command vkCreateFence, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateFence.html
      VULKAN_HPP_NODISCARD typename ResultValueType<Fence>::type
        createFence( FenceCreateInfo const & createInfo, Optional<const AllocationCallbacks> allocator = nullptr ) const VULKAN_HPP_NOEXCEPT_WHEN_NO_EXCEPTIONS;

      // wrapper function for command vkResetFences, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkResetFences.html
      typename ResultValueType<void>::type resetFences( ArrayProxy<const VULKAN_HPP_NAMESPACE::Fence> const & fences ) const;

      // wrapper function for command vkWaitForFences, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkWaitForFences.html
      VULKAN_HPP_NODISCARD Result waitForFences( ArrayProxy<const VULKAN_HPP_NAMESPACE::Fence> const & fences, Bool32 waitAll, uint64_t timeout ) const;

      // wrapper function for command vkCreateSemaphore, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateSemaphore.html
      VULKAN_HPP_NODISCARD typename ResultValueType<Semaphore>::type
        createSemaphore( SemaphoreCreateInfo const &         createInfo,
                         Optional<const AllocationCallbacks> allocator = nullptr ) const VULKAN_HPP_NOEXCEPT_WHEN_NO_EXCEPTIONS;

      // wrapper function for command vkCreateQueryPool, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateQueryPool.html
      VULKAN_HPP_NODISCARD typename ResultValueType<QueryPool>::type
        createQueryPool( QueryPoolCreateInfo const &         createInfo,
                         Optional<const AllocationCallbacks> allocator = nullptr ) const VULKAN_HPP_NOEXCEPT_WHEN_NO_EXCEPTIONS;

      // wrapper function for command vkCreateBuffer, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateBuffer.html
      VULKAN_HPP_NODISCARD typename ResultValueType<Buffer>::type
        createBuffer( BufferCreateInfo const &            createInfo,
                      Optional<const AllocationCallbacks> allocator = nullptr ) const VULKAN_HPP_NOEXCEPT_WHEN_NO_EXCEPTIONS;

      // wrapper function for command vkCreateImage, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateImage.html
      VULKAN_HPP_NODISCARD typename ResultValueType<Image>::type
        createImage( ImageCreateInfo const & createInfo, Optional<const AllocationCallbacks> allocator = nullptr ) const VULKAN_HPP_NOEXCEPT_WHEN_NO_EXCEPTIONS;

      // wrapper function for command vkCreateImageView, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateImageView.html
      VULKAN_HPP_NODISCARD typename ResultValueType<ImageView>::type
        createImageView( ImageViewCreateInfo const &         createInfo,
                         Optional<const AllocationCallbacks> allocator = nullptr ) const VULKAN_HPP_NOEXCEPT_WHEN_NO_EXCEPTIONS;

      // wrapper function for command vkCreateCommandPool, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateCommandPool.html
      VULKAN_HPP_NODISCARD typename ResultValueType<CommandPool>::type
        createCommandPool( CommandPoolCreateInfo const &       createInfo,
                           Optional<const AllocationCallbacks> allocator = nullptr ) const VULKAN_HPP_NOEXCEPT_WHEN_NO_EXCEPTIONS;

      // wrapper function for command vkAllocateCommandBuffers, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkAllocateCommandBuffers.html
      VULKAN_HPP_NODISCARD typename ResultValueType<std::vector<CommandBuffer>>::type
        allocateCommandBuffers( CommandBufferAllocateInfo const & allocateInfo ) const;

      // wrapper function for command vkCreateEvent, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateEvent.html
      VULKAN_HPP_NODISCARD typename ResultValueType<Event>::type
        createEvent( EventCreateInfo const & createInfo, Optional<const AllocationCallbacks> allocator = nullptr ) const VULKAN_HPP_NOEXCEPT_WHEN_NO_EXCEPTIONS;

      // wrapper function for command vkCreateBufferView, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateBufferView.html
      VULKAN_HPP_NODISCARD typename ResultValueType<BufferView>::type
        createBufferView( BufferViewCreateInfo const &        createInfo,
                          Optional<const AllocationCallbacks> allocator = nullptr ) const VULKAN_HPP_NOEXCEPT_WHEN_NO_EXCEPTIONS;

      // wrapper function for command vkCreateShaderModule, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateShaderModule.html
      VULKAN_HPP_NODISCARD typename ResultValueType<ShaderModule>::type
        createShaderModule( ShaderModuleCreateInfo const &      createInfo,
                            Optional<const AllocationCallbacks> allocator = nullptr ) const VULKAN_HPP_NOEXCEPT_WHEN_NO_EXCEPTIONS;

      // wrapper function for command vkCreatePipelineCache, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreatePipelineCache.html
      VULKAN_HPP_NODISCARD typename ResultValueType<PipelineCache>::type
        createPipelineCache( PipelineCacheCreateInfo const &     createInfo,
                             Optional<const AllocationCallbacks> allocator = nullptr ) const VULKAN_HPP_NOEXCEPT_WHEN_NO_EXCEPTIONS;

      // wrapper function for command vkCreateComputePipelines, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateComputePipelines.html
      VULKAN_HPP_NODISCARD typename ResultValueType<std::vector<Pipeline>>::type
        createComputePipelines( Optional<const PipelineCache> const &         pipelineCache,
                                ArrayProxy<ComputePipelineCreateInfo> const & createInfos,
                                Optional<const AllocationCallbacks>           allocator = nullptr ) const;

      // wrapper function for command vkCreateComputePipelines, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateComputePipelines.html
      VULKAN_HPP_NODISCARD typename ResultValueType<Pipeline>::type
        createComputePipeline( Optional<const PipelineCache> const & pipelineCache,
                               ComputePipelineCreateInfo const &     createInfo,
                               Optional<const AllocationCallbacks>   allocator = nullptr ) const VULKAN_HPP_NOEXCEPT_WHEN_NO_EXCEPTIONS;

      // wrapper function for command vkCreatePipelineLayout, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreatePipelineLayout.html
      VULKAN_HPP_NODISCARD typename ResultValueType<PipelineLayout>::type
        createPipelineLayout( PipelineLayoutCreateInfo const &    createInfo,
                              Optional<const AllocationCallbacks> allocator = nullptr ) const VULKAN_HPP_NOEXCEPT_WHEN_NO_EXCEPTIONS;

      // wrapper function for command vkCreateSampler, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateSampler.html
      VULKAN_HPP_NODISCARD typename ResultValueType<Sampler>::type
        createSampler( SamplerCreateInfo const &           createInfo,
                       Optional<const AllocationCallbacks> allocator = nullptr ) const VULKAN_HPP_NOEXCEPT_WHEN_NO_EXCEPTIONS;

      // wrapper function for command vkCreateDescriptorSetLayout, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateDescriptorSetLayout.html
      VULKAN_HPP_NODISCARD typename ResultValueType<DescriptorSetLayout>::type
        createDescriptorSetLayout( DescriptorSetLayoutCreateInfo const & createInfo,
                                   Optional<const AllocationCallbacks>   allocator = nullptr ) const VULKAN_HPP_NOEXCEPT_WHEN_NO_EXCEPTIONS;

      // wrapper function for command vkCreateDescriptorPool, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateDescriptorPool.html
      VULKAN_HPP_NODISCARD typename ResultValueType<DescriptorPool>::type
        createDescriptorPool( DescriptorPoolCreateInfo const &    createInfo,
                              Optional<const AllocationCallbacks> allocator = nullptr ) const VULKAN_HPP_NOEXCEPT_WHEN_NO_EXCEPTIONS;

      // wrapper function for command vkAllocateDescriptorSets, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkAllocateDescriptorSets.html
      VULKAN_HPP_NODISCARD typename ResultValueType<std::vector<DescriptorSet>>::type
        allocateDescriptorSets( DescriptorSetAllocateInfo const & allocateInfo ) const;

      // wrapper function for command vkUpdateDescriptorSets, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkUpdateDescriptorSets.html
      void updateDescriptorSets( ArrayProxy<const WriteDescriptorSet> const & descriptorWrites,
                                 ArrayProxy<const CopyDescriptorSet> const &  descriptorCopies ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkCreateGraphicsPipelines, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateGraphicsPipelines.html
      VULKAN_HPP_NODISCARD typename ResultValueType<std::vector<Pipeline>>::type
        createGraphicsPipelines( Optional<const PipelineCache> const &          pipelineCache,
                                 ArrayProxy<GraphicsPipelineCreateInfo> const & createInfos,
                                 Optional<const AllocationCallbacks>            allocator = nullptr ) const;

      // wrapper function for command vkCreateGraphicsPipelines, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateGraphicsPipelines.html
      VULKAN_HPP_NODISCARD typename ResultValueType<Pipeline>::type
        createGraphicsPipeline( Optional<const PipelineCache> const & pipelineCache,
                                GraphicsPipelineCreateInfo const &    createInfo,
                                Optional<const AllocationCallbacks>   allocator = nullptr ) const VULKAN_HPP_NOEXCEPT_WHEN_NO_EXCEPTIONS;

      // wrapper function for command vkCreateFramebuffer, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateFramebuffer.html
      VULKAN_HPP_NODISCARD typename ResultValueType<Framebuffer>::type
        createFramebuffer( FramebufferCreateInfo const &       createInfo,
                           Optional<const AllocationCallbacks> allocator = nullptr ) const VULKAN_HPP_NOEXCEPT_WHEN_NO_EXCEPTIONS;

      // wrapper function for command vkCreateRenderPass, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateRenderPass.html
      VULKAN_HPP_NODISCARD typename ResultValueType<RenderPass>::type
        createRenderPass( RenderPassCreateInfo const &        createInfo,
                          Optional<const AllocationCallbacks> allocator = nullptr ) const VULKAN_HPP_NOEXCEPT_WHEN_NO_EXCEPTIONS;

      //=== VK_VERSION_1_1 ===

      // wrapper function for command vkBindBufferMemory2, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkBindBufferMemory2.html
      typename ResultValueType<void>::type bindBufferMemory2( ArrayProxy<const BindBufferMemoryInfo> const & bindInfos ) const;

      // wrapper function for command vkBindImageMemory2, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkBindImageMemory2.html
      typename ResultValueType<void>::type bindImageMemory2( ArrayProxy<const BindImageMemoryInfo> const & bindInfos ) const;

      // wrapper function for command vkGetDeviceGroupPeerMemoryFeatures, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetDeviceGroupPeerMemoryFeatures.html
      VULKAN_HPP_NODISCARD PeerMemoryFeatureFlags getGroupPeerMemoryFeatures( uint32_t heapIndex,
                                                                              uint32_t localDeviceIndex,
                                                                              uint32_t remoteDeviceIndex ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkGetImageMemoryRequirements2, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetImageMemoryRequirements2.html
      VULKAN_HPP_NODISCARD MemoryRequirements2 getImageMemoryRequirements2( const ImageMemoryRequirementsInfo2 & info ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkGetImageMemoryRequirements2, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetImageMemoryRequirements2.html
      template <typename X, typename Y, typename... Z>
      VULKAN_HPP_NODISCARD StructureChain<X, Y, Z...> getImageMemoryRequirements2( const ImageMemoryRequirementsInfo2 & info ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkGetBufferMemoryRequirements2, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetBufferMemoryRequirements2.html
      VULKAN_HPP_NODISCARD MemoryRequirements2 getBufferMemoryRequirements2( const BufferMemoryRequirementsInfo2 & info ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkGetBufferMemoryRequirements2, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetBufferMemoryRequirements2.html
      template <typename X, typename Y, typename... Z>
      VULKAN_HPP_NODISCARD StructureChain<X, Y, Z...> getBufferMemoryRequirements2( const BufferMemoryRequirementsInfo2 & info ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkGetImageSparseMemoryRequirements2, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetImageSparseMemoryRequirements2.html
      VULKAN_HPP_NODISCARD std::vector<SparseImageMemoryRequirements2>
                           getImageSparseMemoryRequirements2( const ImageSparseMemoryRequirementsInfo2 & info ) const;

      // wrapper function for command vkGetDeviceQueue2, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetDeviceQueue2.html
      VULKAN_HPP_NODISCARD Queue getQueue2( DeviceQueueInfo2 const & queueInfo ) const VULKAN_HPP_NOEXCEPT_WHEN_NO_EXCEPTIONS;

      // wrapper function for command vkCreateDescriptorUpdateTemplate, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateDescriptorUpdateTemplate.html
      VULKAN_HPP_NODISCARD typename ResultValueType<DescriptorUpdateTemplate>::type
        createDescriptorUpdateTemplate( DescriptorUpdateTemplateCreateInfo const & createInfo,
                                        Optional<const AllocationCallbacks>        allocator = nullptr ) const VULKAN_HPP_NOEXCEPT_WHEN_NO_EXCEPTIONS;

      // wrapper function for command vkGetDescriptorSetLayoutSupport, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetDescriptorSetLayoutSupport.html
      VULKAN_HPP_NODISCARD DescriptorSetLayoutSupport
        getDescriptorSetLayoutSupport( const DescriptorSetLayoutCreateInfo & createInfo ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkGetDescriptorSetLayoutSupport, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetDescriptorSetLayoutSupport.html
      template <typename X, typename Y, typename... Z>
      VULKAN_HPP_NODISCARD StructureChain<X, Y, Z...>
                           getDescriptorSetLayoutSupport( const DescriptorSetLayoutCreateInfo & createInfo ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkCreateSamplerYcbcrConversion, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateSamplerYcbcrConversion.html
      VULKAN_HPP_NODISCARD typename ResultValueType<SamplerYcbcrConversion>::type
        createSamplerYcbcrConversion( SamplerYcbcrConversionCreateInfo const & createInfo,
                                      Optional<const AllocationCallbacks>      allocator = nullptr ) const VULKAN_HPP_NOEXCEPT_WHEN_NO_EXCEPTIONS;

      //=== VK_VERSION_1_2 ===

      // wrapper function for command vkWaitSemaphores, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkWaitSemaphores.html
      VULKAN_HPP_NODISCARD Result waitSemaphores( const SemaphoreWaitInfo & waitInfo, uint64_t timeout ) const;

      // wrapper function for command vkSignalSemaphore, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkSignalSemaphore.html
      typename ResultValueType<void>::type signalSemaphore( const SemaphoreSignalInfo & signalInfo ) const;

      // wrapper function for command vkGetBufferDeviceAddress, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetBufferDeviceAddress.html
      VULKAN_HPP_NODISCARD DeviceAddress getBufferAddress( const BufferDeviceAddressInfo & info ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkGetBufferOpaqueCaptureAddress, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetBufferOpaqueCaptureAddress.html
      VULKAN_HPP_NODISCARD uint64_t getBufferOpaqueCaptureAddress( const BufferDeviceAddressInfo & info ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkGetDeviceMemoryOpaqueCaptureAddress, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetDeviceMemoryOpaqueCaptureAddress.html
      VULKAN_HPP_NODISCARD uint64_t getMemoryOpaqueCaptureAddress( const DeviceMemoryOpaqueCaptureAddressInfo & info ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkCreateRenderPass2, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateRenderPass2.html
      VULKAN_HPP_NODISCARD typename ResultValueType<RenderPass>::type
        createRenderPass2( RenderPassCreateInfo2 const &       createInfo,
                           Optional<const AllocationCallbacks> allocator = nullptr ) const VULKAN_HPP_NOEXCEPT_WHEN_NO_EXCEPTIONS;

      //=== VK_VERSION_1_3 ===

      // wrapper function for command vkCreatePrivateDataSlot, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreatePrivateDataSlot.html
      VULKAN_HPP_NODISCARD typename ResultValueType<PrivateDataSlot>::type
        createPrivateDataSlot( PrivateDataSlotCreateInfo const &   createInfo,
                               Optional<const AllocationCallbacks> allocator = nullptr ) const VULKAN_HPP_NOEXCEPT_WHEN_NO_EXCEPTIONS;

      // wrapper function for command vkSetPrivateData, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkSetPrivateData.html
      typename ResultValueType<void>::type
        setPrivateData( ObjectType objectType, uint64_t objectHandle, VULKAN_HPP_NAMESPACE::PrivateDataSlot privateDataSlot, uint64_t data ) const;

      // wrapper function for command vkGetPrivateData, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetPrivateData.html
      VULKAN_HPP_NODISCARD uint64_t getPrivateData( ObjectType                            objectType,
                                                    uint64_t                              objectHandle,
                                                    VULKAN_HPP_NAMESPACE::PrivateDataSlot privateDataSlot ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkGetDeviceBufferMemoryRequirements, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetDeviceBufferMemoryRequirements.html
      VULKAN_HPP_NODISCARD MemoryRequirements2 getBufferMemoryRequirements( const DeviceBufferMemoryRequirements & info ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkGetDeviceBufferMemoryRequirements, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetDeviceBufferMemoryRequirements.html
      template <typename X, typename Y, typename... Z>
      VULKAN_HPP_NODISCARD StructureChain<X, Y, Z...> getBufferMemoryRequirements( const DeviceBufferMemoryRequirements & info ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkGetDeviceImageMemoryRequirements, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetDeviceImageMemoryRequirements.html
      VULKAN_HPP_NODISCARD MemoryRequirements2 getImageMemoryRequirements( const DeviceImageMemoryRequirements & info ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkGetDeviceImageMemoryRequirements, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetDeviceImageMemoryRequirements.html
      template <typename X, typename Y, typename... Z>
      VULKAN_HPP_NODISCARD StructureChain<X, Y, Z...> getImageMemoryRequirements( const DeviceImageMemoryRequirements & info ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkGetDeviceImageSparseMemoryRequirements, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetDeviceImageSparseMemoryRequirements.html
      VULKAN_HPP_NODISCARD std::vector<SparseImageMemoryRequirements2> getImageSparseMemoryRequirements( const DeviceImageMemoryRequirements & info ) const;

      //=== VK_VERSION_1_4 ===

      // wrapper function for command vkMapMemory2, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkMapMemory2.html
      VULKAN_HPP_NODISCARD typename ResultValueType<void *>::type mapMemory2( const MemoryMapInfo & memoryMapInfo ) const;

      // wrapper function for command vkUnmapMemory2, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkUnmapMemory2.html
      typename ResultValueType<void>::type unmapMemory2( const MemoryUnmapInfo & memoryUnmapInfo ) const;

      // wrapper function for command vkGetDeviceImageSubresourceLayout, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetDeviceImageSubresourceLayout.html
      VULKAN_HPP_NODISCARD SubresourceLayout2 getImageSubresourceLayout( const DeviceImageSubresourceInfo & info ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkGetDeviceImageSubresourceLayout, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetDeviceImageSubresourceLayout.html
      template <typename X, typename Y, typename... Z>
      VULKAN_HPP_NODISCARD StructureChain<X, Y, Z...> getImageSubresourceLayout( const DeviceImageSubresourceInfo & info ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkCopyMemoryToImage, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCopyMemoryToImage.html
      typename ResultValueType<void>::type copyMemoryToImage( const CopyMemoryToImageInfo & copyMemoryToImageInfo ) const;

      // wrapper function for command vkCopyImageToMemory, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCopyImageToMemory.html
      typename ResultValueType<void>::type copyImageToMemory( const CopyImageToMemoryInfo & copyImageToMemoryInfo ) const;

      // wrapper function for command vkCopyImageToImage, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCopyImageToImage.html
      typename ResultValueType<void>::type copyImageToImage( const CopyImageToImageInfo & copyImageToImageInfo ) const;

      // wrapper function for command vkTransitionImageLayout, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkTransitionImageLayout.html
      typename ResultValueType<void>::type transitionImageLayout( ArrayProxy<const HostImageLayoutTransitionInfo> const & transitions ) const;

      // wrapper function for command vkGetRenderingAreaGranularity, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetRenderingAreaGranularity.html
      VULKAN_HPP_NODISCARD Extent2D getRenderingAreaGranularity( const RenderingAreaInfo & renderingAreaInfo ) const VULKAN_HPP_NOEXCEPT;

      //=== VK_KHR_swapchain ===

      // wrapper function for command vkCreateSwapchainKHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateSwapchainKHR.html
      VULKAN_HPP_NODISCARD typename ResultValueType<SwapchainKHR>::type
        createSwapchainKHR( SwapchainCreateInfoKHR const &      createInfo,
                            Optional<const AllocationCallbacks> allocator = nullptr ) const VULKAN_HPP_NOEXCEPT_WHEN_NO_EXCEPTIONS;

      // wrapper function for command vkGetDeviceGroupPresentCapabilitiesKHR, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetDeviceGroupPresentCapabilitiesKHR.html
      VULKAN_HPP_NODISCARD typename ResultValueType<DeviceGroupPresentCapabilitiesKHR>::type getGroupPresentCapabilitiesKHR() const;

      // wrapper function for command vkGetDeviceGroupSurfacePresentModesKHR, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetDeviceGroupSurfacePresentModesKHR.html
      VULKAN_HPP_NODISCARD typename ResultValueType<DeviceGroupPresentModeFlagsKHR>::type
        getGroupSurfacePresentModesKHR( VULKAN_HPP_NAMESPACE::SurfaceKHR surface ) const;

      // wrapper function for command vkAcquireNextImage2KHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkAcquireNextImage2KHR.html
      VULKAN_HPP_NODISCARD ResultValue<uint32_t> acquireNextImage2KHR( const AcquireNextImageInfoKHR & acquireInfo ) const;

      //=== VK_KHR_display_swapchain ===

      // wrapper function for command vkCreateSharedSwapchainsKHR, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateSharedSwapchainsKHR.html
      VULKAN_HPP_NODISCARD typename ResultValueType<std::vector<SwapchainKHR>>::type
        createSharedSwapchainsKHR( ArrayProxy<SwapchainCreateInfoKHR> const & createInfos, Optional<const AllocationCallbacks> allocator = nullptr ) const;

      // wrapper function for command vkCreateSharedSwapchainsKHR, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateSharedSwapchainsKHR.html
      VULKAN_HPP_NODISCARD typename ResultValueType<SwapchainKHR>::type
        createSharedSwapchainKHR( SwapchainCreateInfoKHR const &      createInfo,
                                  Optional<const AllocationCallbacks> allocator = nullptr ) const VULKAN_HPP_NOEXCEPT_WHEN_NO_EXCEPTIONS;

      //=== VK_EXT_debug_marker ===

      // wrapper function for command vkDebugMarkerSetObjectTagEXT, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkDebugMarkerSetObjectTagEXT.html
      typename ResultValueType<void>::type debugMarkerSetObjectTagEXT( const DebugMarkerObjectTagInfoEXT & tagInfo ) const;

      // wrapper function for command vkDebugMarkerSetObjectNameEXT, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkDebugMarkerSetObjectNameEXT.html
      typename ResultValueType<void>::type debugMarkerSetObjectNameEXT( const DebugMarkerObjectNameInfoEXT & nameInfo ) const;

      //=== VK_KHR_video_queue ===

      // wrapper function for command vkCreateVideoSessionKHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateVideoSessionKHR.html
      VULKAN_HPP_NODISCARD typename ResultValueType<VideoSessionKHR>::type
        createVideoSessionKHR( VideoSessionCreateInfoKHR const &   createInfo,
                               Optional<const AllocationCallbacks> allocator = nullptr ) const VULKAN_HPP_NOEXCEPT_WHEN_NO_EXCEPTIONS;

      // wrapper function for command vkCreateVideoSessionParametersKHR, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateVideoSessionParametersKHR.html
      VULKAN_HPP_NODISCARD typename ResultValueType<VideoSessionParametersKHR>::type
        createVideoSessionParametersKHR( VideoSessionParametersCreateInfoKHR const & createInfo,
                                         Optional<const AllocationCallbacks>         allocator = nullptr ) const VULKAN_HPP_NOEXCEPT_WHEN_NO_EXCEPTIONS;

      //=== VK_NVX_binary_import ===

      // wrapper function for command vkCreateCuModuleNVX, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateCuModuleNVX.html
      VULKAN_HPP_NODISCARD typename ResultValueType<CuModuleNVX>::type
        createCuModuleNVX( CuModuleCreateInfoNVX const &       createInfo,
                           Optional<const AllocationCallbacks> allocator = nullptr ) const VULKAN_HPP_NOEXCEPT_WHEN_NO_EXCEPTIONS;

      // wrapper function for command vkCreateCuFunctionNVX, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateCuFunctionNVX.html
      VULKAN_HPP_NODISCARD typename ResultValueType<CuFunctionNVX>::type
        createCuFunctionNVX( CuFunctionCreateInfoNVX const &     createInfo,
                             Optional<const AllocationCallbacks> allocator = nullptr ) const VULKAN_HPP_NOEXCEPT_WHEN_NO_EXCEPTIONS;

      //=== VK_NVX_image_view_handle ===

      // wrapper function for command vkGetImageViewHandleNVX, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetImageViewHandleNVX.html
      VULKAN_HPP_NODISCARD uint32_t getImageViewHandleNVX( const ImageViewHandleInfoNVX & info ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkGetImageViewHandle64NVX, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetImageViewHandle64NVX.html
      VULKAN_HPP_NODISCARD uint64_t getImageViewHandle64NVX( const ImageViewHandleInfoNVX & info ) const VULKAN_HPP_NOEXCEPT;

      //=== VK_KHR_device_group ===

      // wrapper function for command vkGetDeviceGroupPeerMemoryFeaturesKHR, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetDeviceGroupPeerMemoryFeaturesKHR.html
      VULKAN_HPP_NODISCARD PeerMemoryFeatureFlags getGroupPeerMemoryFeaturesKHR( uint32_t heapIndex,
                                                                                 uint32_t localDeviceIndex,
                                                                                 uint32_t remoteDeviceIndex ) const VULKAN_HPP_NOEXCEPT;

#  if defined( VK_USE_PLATFORM_WIN32_KHR )
      //=== VK_KHR_external_memory_win32 ===

      // wrapper function for command vkGetMemoryWin32HandleKHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetMemoryWin32HandleKHR.html
      VULKAN_HPP_NODISCARD typename ResultValueType<HANDLE>::type getMemoryWin32HandleKHR( const MemoryGetWin32HandleInfoKHR & getWin32HandleInfo ) const;

      // wrapper function for command vkGetMemoryWin32HandlePropertiesKHR, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetMemoryWin32HandlePropertiesKHR.html
      VULKAN_HPP_NODISCARD typename ResultValueType<MemoryWin32HandlePropertiesKHR>::type
        getMemoryWin32HandlePropertiesKHR( ExternalMemoryHandleTypeFlagBits handleType, HANDLE handle ) const;
#  endif /*VK_USE_PLATFORM_WIN32_KHR*/

      //=== VK_KHR_external_memory_fd ===

      // wrapper function for command vkGetMemoryFdKHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetMemoryFdKHR.html
      VULKAN_HPP_NODISCARD typename ResultValueType<int>::type getMemoryFdKHR( const MemoryGetFdInfoKHR & getFdInfo ) const;

      // wrapper function for command vkGetMemoryFdPropertiesKHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetMemoryFdPropertiesKHR.html
      VULKAN_HPP_NODISCARD typename ResultValueType<MemoryFdPropertiesKHR>::type getMemoryFdPropertiesKHR( ExternalMemoryHandleTypeFlagBits handleType,
                                                                                                           int                              fd ) const;

#  if defined( VK_USE_PLATFORM_WIN32_KHR )
      //=== VK_KHR_external_semaphore_win32 ===

      // wrapper function for command vkImportSemaphoreWin32HandleKHR, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkImportSemaphoreWin32HandleKHR.html
      typename ResultValueType<void>::type importSemaphoreWin32HandleKHR( const ImportSemaphoreWin32HandleInfoKHR & importSemaphoreWin32HandleInfo ) const;

      // wrapper function for command vkGetSemaphoreWin32HandleKHR, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetSemaphoreWin32HandleKHR.html
      VULKAN_HPP_NODISCARD typename ResultValueType<HANDLE>::type getSemaphoreWin32HandleKHR( const SemaphoreGetWin32HandleInfoKHR & getWin32HandleInfo ) const;
#  endif /*VK_USE_PLATFORM_WIN32_KHR*/

      //=== VK_KHR_external_semaphore_fd ===

      // wrapper function for command vkImportSemaphoreFdKHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkImportSemaphoreFdKHR.html
      typename ResultValueType<void>::type importSemaphoreFdKHR( const ImportSemaphoreFdInfoKHR & importSemaphoreFdInfo ) const;

      // wrapper function for command vkGetSemaphoreFdKHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetSemaphoreFdKHR.html
      VULKAN_HPP_NODISCARD typename ResultValueType<int>::type getSemaphoreFdKHR( const SemaphoreGetFdInfoKHR & getFdInfo ) const;

      //=== VK_KHR_descriptor_update_template ===

      // wrapper function for command vkCreateDescriptorUpdateTemplateKHR, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateDescriptorUpdateTemplateKHR.html
      VULKAN_HPP_NODISCARD typename ResultValueType<DescriptorUpdateTemplate>::type
        createDescriptorUpdateTemplateKHR( DescriptorUpdateTemplateCreateInfo const & createInfo,
                                           Optional<const AllocationCallbacks>        allocator = nullptr ) const VULKAN_HPP_NOEXCEPT_WHEN_NO_EXCEPTIONS;

      // wrapper function for command vkDestroyDescriptorUpdateTemplateKHR, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkDestroyDescriptorUpdateTemplateKHR.html
      void
        destroyDescriptorUpdateTemplateKHR( VULKAN_HPP_NAMESPACE::DescriptorUpdateTemplate descriptorUpdateTemplate VULKAN_HPP_DEFAULT_ASSIGNMENT( {} ),
                                            Optional<const AllocationCallbacks> allocator VULKAN_HPP_DEFAULT_ASSIGNMENT( nullptr ) ) const VULKAN_HPP_NOEXCEPT;

      //=== VK_EXT_display_control ===

      // wrapper function for command vkDisplayPowerControlEXT, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkDisplayPowerControlEXT.html
      typename ResultValueType<void>::type displayPowerControlEXT( VULKAN_HPP_NAMESPACE::DisplayKHR display,
                                                                   const DisplayPowerInfoEXT &      displayPowerInfo ) const;

      // wrapper function for command vkRegisterDeviceEventEXT, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkRegisterDeviceEventEXT.html
      VULKAN_HPP_NODISCARD typename ResultValueType<Fence>::type
        registerEventEXT( DeviceEventInfoEXT const &          deviceEventInfo,
                          Optional<const AllocationCallbacks> allocator = nullptr ) const VULKAN_HPP_NOEXCEPT_WHEN_NO_EXCEPTIONS;

      // wrapper function for command vkRegisterDisplayEventEXT, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkRegisterDisplayEventEXT.html
      VULKAN_HPP_NODISCARD typename ResultValueType<Fence>::type
        registerDisplayEventEXT( DisplayKHR const &                  display,
                                 DisplayEventInfoEXT const &         displayEventInfo,
                                 Optional<const AllocationCallbacks> allocator = nullptr ) const VULKAN_HPP_NOEXCEPT_WHEN_NO_EXCEPTIONS;

      //=== VK_EXT_hdr_metadata ===

      // wrapper function for command vkSetHdrMetadataEXT, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkSetHdrMetadataEXT.html
      void setHdrMetadataEXT( ArrayProxy<const VULKAN_HPP_NAMESPACE::SwapchainKHR> const & swapchains,
                              ArrayProxy<const HdrMetadataEXT> const &                     metadata ) const;

      //=== VK_KHR_create_renderpass2 ===

      // wrapper function for command vkCreateRenderPass2KHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateRenderPass2KHR.html
      VULKAN_HPP_NODISCARD typename ResultValueType<RenderPass>::type
        createRenderPass2KHR( RenderPassCreateInfo2 const &       createInfo,
                              Optional<const AllocationCallbacks> allocator = nullptr ) const VULKAN_HPP_NOEXCEPT_WHEN_NO_EXCEPTIONS;

#  if defined( VK_USE_PLATFORM_WIN32_KHR )
      //=== VK_KHR_external_fence_win32 ===

      // wrapper function for command vkImportFenceWin32HandleKHR, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkImportFenceWin32HandleKHR.html
      typename ResultValueType<void>::type importFenceWin32HandleKHR( const ImportFenceWin32HandleInfoKHR & importFenceWin32HandleInfo ) const;

      // wrapper function for command vkGetFenceWin32HandleKHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetFenceWin32HandleKHR.html
      VULKAN_HPP_NODISCARD typename ResultValueType<HANDLE>::type getFenceWin32HandleKHR( const FenceGetWin32HandleInfoKHR & getWin32HandleInfo ) const;
#  endif /*VK_USE_PLATFORM_WIN32_KHR*/

      //=== VK_KHR_external_fence_fd ===

      // wrapper function for command vkImportFenceFdKHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkImportFenceFdKHR.html
      typename ResultValueType<void>::type importFenceFdKHR( const ImportFenceFdInfoKHR & importFenceFdInfo ) const;

      // wrapper function for command vkGetFenceFdKHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetFenceFdKHR.html
      VULKAN_HPP_NODISCARD typename ResultValueType<int>::type getFenceFdKHR( const FenceGetFdInfoKHR & getFdInfo ) const;

      //=== VK_KHR_performance_query ===

      // wrapper function for command vkAcquireProfilingLockKHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkAcquireProfilingLockKHR.html
      typename ResultValueType<void>::type acquireProfilingLockKHR( const AcquireProfilingLockInfoKHR & info ) const;

      // wrapper function for command vkReleaseProfilingLockKHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkReleaseProfilingLockKHR.html
      void releaseProfilingLockKHR() const VULKAN_HPP_NOEXCEPT;

      //=== VK_EXT_debug_utils ===

      // wrapper function for command vkSetDebugUtilsObjectNameEXT, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkSetDebugUtilsObjectNameEXT.html
      typename ResultValueType<void>::type setDebugUtilsObjectNameEXT( const DebugUtilsObjectNameInfoEXT & nameInfo ) const;

      // wrapper function for command vkSetDebugUtilsObjectNameEXT, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkSetDebugUtilsObjectNameEXT.html
      template <typename HandleType>
      typename ResultValueType<void>::type setDebugUtilsObjectNameEXT( HandleType const & handle, std::string const & name ) const;

      // wrapper function for command vkSetDebugUtilsObjectTagEXT, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkSetDebugUtilsObjectTagEXT.html
      typename ResultValueType<void>::type setDebugUtilsObjectTagEXT( const DebugUtilsObjectTagInfoEXT & tagInfo ) const;

      // wrapper function for command vkSetDebugUtilsObjectTagEXT, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkSetDebugUtilsObjectTagEXT.html
      template <typename HandleType, typename TagType>
      typename ResultValueType<void>::type setDebugUtilsObjectTagEXT( HandleType const & handle, uint64_t name, TagType const & tag ) const;

#  if defined( VK_USE_PLATFORM_ANDROID_KHR )
      //=== VK_ANDROID_external_memory_android_hardware_buffer ===

      // wrapper function for command vkGetAndroidHardwareBufferPropertiesANDROID, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetAndroidHardwareBufferPropertiesANDROID.html
      VULKAN_HPP_NODISCARD Result getAndroidHardwareBufferPropertiesANDROID( const struct AHardwareBuffer *           buffer,
                                                                             AndroidHardwareBufferPropertiesANDROID * pProperties ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkGetAndroidHardwareBufferPropertiesANDROID, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetAndroidHardwareBufferPropertiesANDROID.html
      VULKAN_HPP_NODISCARD typename ResultValueType<AndroidHardwareBufferPropertiesANDROID>::type
        getAndroidHardwareBufferPropertiesANDROID( const struct AHardwareBuffer & buffer ) const;

      // wrapper function for command vkGetAndroidHardwareBufferPropertiesANDROID, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetAndroidHardwareBufferPropertiesANDROID.html
      template <typename X, typename Y, typename... Z>
      VULKAN_HPP_NODISCARD typename ResultValueType<StructureChain<X, Y, Z...>>::type
        getAndroidHardwareBufferPropertiesANDROID( const struct AHardwareBuffer & buffer ) const;

      // wrapper function for command vkGetMemoryAndroidHardwareBufferANDROID, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetMemoryAndroidHardwareBufferANDROID.html
      VULKAN_HPP_NODISCARD typename ResultValueType<struct AHardwareBuffer *>::type
        getMemoryAndroidHardwareBufferANDROID( const MemoryGetAndroidHardwareBufferInfoANDROID & info ) const;
#  endif /*VK_USE_PLATFORM_ANDROID_KHR*/

#  if defined( VK_ENABLE_BETA_EXTENSIONS )
      //=== VK_AMDX_shader_enqueue ===

      // wrapper function for command vkCreateExecutionGraphPipelinesAMDX, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateExecutionGraphPipelinesAMDX.html
      VULKAN_HPP_NODISCARD typename ResultValueType<std::vector<Pipeline>>::type
        createExecutionGraphPipelinesAMDX( Optional<const PipelineCache> const &                    pipelineCache,
                                           ArrayProxy<ExecutionGraphPipelineCreateInfoAMDX> const & createInfos,
                                           Optional<const AllocationCallbacks>                      allocator = nullptr ) const;

      // wrapper function for command vkCreateExecutionGraphPipelinesAMDX, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateExecutionGraphPipelinesAMDX.html
      VULKAN_HPP_NODISCARD typename ResultValueType<Pipeline>::type
        createExecutionGraphPipelineAMDX( Optional<const PipelineCache> const &        pipelineCache,
                                          ExecutionGraphPipelineCreateInfoAMDX const & createInfo,
                                          Optional<const AllocationCallbacks>          allocator = nullptr ) const VULKAN_HPP_NOEXCEPT_WHEN_NO_EXCEPTIONS;
#  endif /*VK_ENABLE_BETA_EXTENSIONS*/

      //=== VK_KHR_get_memory_requirements2 ===

      // wrapper function for command vkGetImageMemoryRequirements2KHR, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetImageMemoryRequirements2KHR.html
      VULKAN_HPP_NODISCARD MemoryRequirements2 getImageMemoryRequirements2KHR( const ImageMemoryRequirementsInfo2 & info ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkGetImageMemoryRequirements2KHR, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetImageMemoryRequirements2KHR.html
      template <typename X, typename Y, typename... Z>
      VULKAN_HPP_NODISCARD StructureChain<X, Y, Z...> getImageMemoryRequirements2KHR( const ImageMemoryRequirementsInfo2 & info ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkGetBufferMemoryRequirements2KHR, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetBufferMemoryRequirements2KHR.html
      VULKAN_HPP_NODISCARD MemoryRequirements2 getBufferMemoryRequirements2KHR( const BufferMemoryRequirementsInfo2 & info ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkGetBufferMemoryRequirements2KHR, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetBufferMemoryRequirements2KHR.html
      template <typename X, typename Y, typename... Z>
      VULKAN_HPP_NODISCARD StructureChain<X, Y, Z...> getBufferMemoryRequirements2KHR( const BufferMemoryRequirementsInfo2 & info ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkGetImageSparseMemoryRequirements2KHR, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetImageSparseMemoryRequirements2KHR.html
      VULKAN_HPP_NODISCARD std::vector<SparseImageMemoryRequirements2>
                           getImageSparseMemoryRequirements2KHR( const ImageSparseMemoryRequirementsInfo2 & info ) const;

      //=== VK_KHR_acceleration_structure ===

      // wrapper function for command vkCreateAccelerationStructureKHR, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateAccelerationStructureKHR.html
      VULKAN_HPP_NODISCARD typename ResultValueType<AccelerationStructureKHR>::type
        createAccelerationStructureKHR( AccelerationStructureCreateInfoKHR const & createInfo,
                                        Optional<const AllocationCallbacks>        allocator = nullptr ) const VULKAN_HPP_NOEXCEPT_WHEN_NO_EXCEPTIONS;

      // wrapper function for command vkBuildAccelerationStructuresKHR, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkBuildAccelerationStructuresKHR.html
      VULKAN_HPP_NODISCARD Result
        buildAccelerationStructuresKHR( VULKAN_HPP_NAMESPACE::DeferredOperationKHR                               deferredOperation,
                                        ArrayProxy<const AccelerationStructureBuildGeometryInfoKHR> const &      infos,
                                        ArrayProxy<const AccelerationStructureBuildRangeInfoKHR * const> const & pBuildRangeInfos ) const;

      // wrapper function for command vkCopyAccelerationStructureKHR, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCopyAccelerationStructureKHR.html
      VULKAN_HPP_NODISCARD Result copyAccelerationStructureKHR( VULKAN_HPP_NAMESPACE::DeferredOperationKHR deferredOperation,
                                                                const CopyAccelerationStructureInfoKHR &   info ) const;

      // wrapper function for command vkCopyAccelerationStructureToMemoryKHR, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCopyAccelerationStructureToMemoryKHR.html
      VULKAN_HPP_NODISCARD Result copyAccelerationStructureToMemoryKHR( VULKAN_HPP_NAMESPACE::DeferredOperationKHR       deferredOperation,
                                                                        const CopyAccelerationStructureToMemoryInfoKHR & info ) const;

      // wrapper function for command vkCopyMemoryToAccelerationStructureKHR, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCopyMemoryToAccelerationStructureKHR.html
      VULKAN_HPP_NODISCARD Result copyMemoryToAccelerationStructureKHR( VULKAN_HPP_NAMESPACE::DeferredOperationKHR       deferredOperation,
                                                                        const CopyMemoryToAccelerationStructureInfoKHR & info ) const;

      // wrapper function for command vkWriteAccelerationStructuresPropertiesKHR, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkWriteAccelerationStructuresPropertiesKHR.html
      template <typename DataType>
      VULKAN_HPP_NODISCARD typename ResultValueType<std::vector<DataType>>::type
        writeAccelerationStructuresPropertiesKHR( ArrayProxy<const VULKAN_HPP_NAMESPACE::AccelerationStructureKHR> const & accelerationStructures,
                                                  QueryType                                                                queryType,
                                                  size_t                                                                   dataSize,
                                                  size_t                                                                   stride ) const;

      // wrapper function for command vkWriteAccelerationStructuresPropertiesKHR, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkWriteAccelerationStructuresPropertiesKHR.html
      template <typename DataType>
      VULKAN_HPP_NODISCARD typename ResultValueType<DataType>::type writeAccelerationStructuresPropertyKHR(
        ArrayProxy<const VULKAN_HPP_NAMESPACE::AccelerationStructureKHR> const & accelerationStructures, QueryType queryType, size_t stride ) const;

      // wrapper function for command vkGetAccelerationStructureDeviceAddressKHR, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetAccelerationStructureDeviceAddressKHR.html
      VULKAN_HPP_NODISCARD DeviceAddress getAccelerationStructureAddressKHR( const AccelerationStructureDeviceAddressInfoKHR & info ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkGetDeviceAccelerationStructureCompatibilityKHR, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetDeviceAccelerationStructureCompatibilityKHR.html
      VULKAN_HPP_NODISCARD AccelerationStructureCompatibilityKHR
        getAccelerationStructureCompatibilityKHR( const AccelerationStructureVersionInfoKHR & versionInfo ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkGetAccelerationStructureBuildSizesKHR, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetAccelerationStructureBuildSizesKHR.html
      VULKAN_HPP_NODISCARD AccelerationStructureBuildSizesInfoKHR
        getAccelerationStructureBuildSizesKHR( AccelerationStructureBuildTypeKHR                     buildType,
                                               const AccelerationStructureBuildGeometryInfoKHR &     buildInfo,
                                               ArrayProxy<const uint32_t> const & maxPrimitiveCounts VULKAN_HPP_DEFAULT_ASSIGNMENT( nullptr ) ) const;

      //=== VK_KHR_ray_tracing_pipeline ===

      // wrapper function for command vkCreateRayTracingPipelinesKHR, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateRayTracingPipelinesKHR.html
      VULKAN_HPP_NODISCARD typename ResultValueType<std::vector<Pipeline>>::type
        createRayTracingPipelinesKHR( Optional<const DeferredOperationKHR> const &        deferredOperation,
                                      Optional<const PipelineCache> const &               pipelineCache,
                                      ArrayProxy<RayTracingPipelineCreateInfoKHR> const & createInfos,
                                      Optional<const AllocationCallbacks>                 allocator = nullptr ) const;

      // wrapper function for command vkCreateRayTracingPipelinesKHR, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateRayTracingPipelinesKHR.html
      VULKAN_HPP_NODISCARD typename ResultValueType<Pipeline>::type
        createRayTracingPipelineKHR( Optional<const DeferredOperationKHR> const & deferredOperation,
                                     Optional<const PipelineCache> const &        pipelineCache,
                                     RayTracingPipelineCreateInfoKHR const &      createInfo,
                                     Optional<const AllocationCallbacks>          allocator = nullptr ) const VULKAN_HPP_NOEXCEPT_WHEN_NO_EXCEPTIONS;

      //=== VK_KHR_sampler_ycbcr_conversion ===

      // wrapper function for command vkCreateSamplerYcbcrConversionKHR, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateSamplerYcbcrConversionKHR.html
      VULKAN_HPP_NODISCARD typename ResultValueType<SamplerYcbcrConversion>::type
        createSamplerYcbcrConversionKHR( SamplerYcbcrConversionCreateInfo const & createInfo,
                                         Optional<const AllocationCallbacks>      allocator = nullptr ) const VULKAN_HPP_NOEXCEPT_WHEN_NO_EXCEPTIONS;

      // wrapper function for command vkDestroySamplerYcbcrConversionKHR, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkDestroySamplerYcbcrConversionKHR.html
      void destroySamplerYcbcrConversionKHR( VULKAN_HPP_NAMESPACE::SamplerYcbcrConversion ycbcrConversion VULKAN_HPP_DEFAULT_ASSIGNMENT( {} ),
                                             Optional<const AllocationCallbacks> allocator VULKAN_HPP_DEFAULT_ASSIGNMENT( nullptr ) ) const VULKAN_HPP_NOEXCEPT;

      //=== VK_KHR_bind_memory2 ===

      // wrapper function for command vkBindBufferMemory2KHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkBindBufferMemory2KHR.html
      typename ResultValueType<void>::type bindBufferMemory2KHR( ArrayProxy<const BindBufferMemoryInfo> const & bindInfos ) const;

      // wrapper function for command vkBindImageMemory2KHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkBindImageMemory2KHR.html
      typename ResultValueType<void>::type bindImageMemory2KHR( ArrayProxy<const BindImageMemoryInfo> const & bindInfos ) const;

      //=== VK_EXT_validation_cache ===

      // wrapper function for command vkCreateValidationCacheEXT, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateValidationCacheEXT.html
      VULKAN_HPP_NODISCARD typename ResultValueType<ValidationCacheEXT>::type
        createValidationCacheEXT( ValidationCacheCreateInfoEXT const & createInfo,
                                  Optional<const AllocationCallbacks>  allocator = nullptr ) const VULKAN_HPP_NOEXCEPT_WHEN_NO_EXCEPTIONS;

      //=== VK_NV_ray_tracing ===

      // wrapper function for command vkCreateAccelerationStructureNV, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateAccelerationStructureNV.html
      VULKAN_HPP_NODISCARD typename ResultValueType<AccelerationStructureNV>::type
        createAccelerationStructureNV( AccelerationStructureCreateInfoNV const & createInfo,
                                       Optional<const AllocationCallbacks>       allocator = nullptr ) const VULKAN_HPP_NOEXCEPT_WHEN_NO_EXCEPTIONS;

      // wrapper function for command vkGetAccelerationStructureMemoryRequirementsNV, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetAccelerationStructureMemoryRequirementsNV.html
      VULKAN_HPP_NODISCARD MemoryRequirements2KHR
        getAccelerationStructureMemoryRequirementsNV( const AccelerationStructureMemoryRequirementsInfoNV & info ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkGetAccelerationStructureMemoryRequirementsNV, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetAccelerationStructureMemoryRequirementsNV.html
      template <typename X, typename Y, typename... Z>
      VULKAN_HPP_NODISCARD StructureChain<X, Y, Z...>
                           getAccelerationStructureMemoryRequirementsNV( const AccelerationStructureMemoryRequirementsInfoNV & info ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkBindAccelerationStructureMemoryNV, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkBindAccelerationStructureMemoryNV.html
      typename ResultValueType<void>::type bindAccelerationStructureMemoryNV( ArrayProxy<const BindAccelerationStructureMemoryInfoNV> const & bindInfos ) const;

      // wrapper function for command vkCreateRayTracingPipelinesNV, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateRayTracingPipelinesNV.html
      VULKAN_HPP_NODISCARD typename ResultValueType<std::vector<Pipeline>>::type
        createRayTracingPipelinesNV( Optional<const PipelineCache> const &              pipelineCache,
                                     ArrayProxy<RayTracingPipelineCreateInfoNV> const & createInfos,
                                     Optional<const AllocationCallbacks>                allocator = nullptr ) const;

      // wrapper function for command vkCreateRayTracingPipelinesNV, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateRayTracingPipelinesNV.html
      VULKAN_HPP_NODISCARD typename ResultValueType<Pipeline>::type
        createRayTracingPipelineNV( Optional<const PipelineCache> const &  pipelineCache,
                                    RayTracingPipelineCreateInfoNV const & createInfo,
                                    Optional<const AllocationCallbacks>    allocator = nullptr ) const VULKAN_HPP_NOEXCEPT_WHEN_NO_EXCEPTIONS;

      //=== VK_KHR_maintenance3 ===

      // wrapper function for command vkGetDescriptorSetLayoutSupportKHR, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetDescriptorSetLayoutSupportKHR.html
      VULKAN_HPP_NODISCARD DescriptorSetLayoutSupport
        getDescriptorSetLayoutSupportKHR( const DescriptorSetLayoutCreateInfo & createInfo ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkGetDescriptorSetLayoutSupportKHR, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetDescriptorSetLayoutSupportKHR.html
      template <typename X, typename Y, typename... Z>
      VULKAN_HPP_NODISCARD StructureChain<X, Y, Z...>
                           getDescriptorSetLayoutSupportKHR( const DescriptorSetLayoutCreateInfo & createInfo ) const VULKAN_HPP_NOEXCEPT;

      //=== VK_EXT_external_memory_host ===

      // wrapper function for command vkGetMemoryHostPointerPropertiesEXT, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetMemoryHostPointerPropertiesEXT.html
      VULKAN_HPP_NODISCARD typename ResultValueType<MemoryHostPointerPropertiesEXT>::type
        getMemoryHostPointerPropertiesEXT( ExternalMemoryHandleTypeFlagBits handleType, const void * pHostPointer ) const;

      //=== VK_EXT_calibrated_timestamps ===

      // wrapper function for command vkGetCalibratedTimestampsEXT, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetCalibratedTimestampsEXT.html
      VULKAN_HPP_NODISCARD typename ResultValueType<std::pair<std::vector<uint64_t>, uint64_t>>::type
        getCalibratedTimestampsEXT( ArrayProxy<const CalibratedTimestampInfoKHR> const & timestampInfos ) const;

      // wrapper function for command vkGetCalibratedTimestampsEXT, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetCalibratedTimestampsEXT.html
      VULKAN_HPP_NODISCARD typename ResultValueType<std::pair<uint64_t, uint64_t>>::type
        getCalibratedTimestampEXT( const CalibratedTimestampInfoKHR & timestampInfo ) const;

      //=== VK_KHR_timeline_semaphore ===

      // wrapper function for command vkWaitSemaphoresKHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkWaitSemaphoresKHR.html
      VULKAN_HPP_NODISCARD Result waitSemaphoresKHR( const SemaphoreWaitInfo & waitInfo, uint64_t timeout ) const;

      // wrapper function for command vkSignalSemaphoreKHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkSignalSemaphoreKHR.html
      typename ResultValueType<void>::type signalSemaphoreKHR( const SemaphoreSignalInfo & signalInfo ) const;

      //=== VK_INTEL_performance_query ===

      // wrapper function for command vkInitializePerformanceApiINTEL, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkInitializePerformanceApiINTEL.html
      typename ResultValueType<void>::type initializePerformanceApiINTEL( const InitializePerformanceApiInfoINTEL & initializeInfo ) const;

      // wrapper function for command vkUninitializePerformanceApiINTEL, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkUninitializePerformanceApiINTEL.html
      void uninitializePerformanceApiINTEL() const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkAcquirePerformanceConfigurationINTEL, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkAcquirePerformanceConfigurationINTEL.html
      VULKAN_HPP_NODISCARD typename ResultValueType<PerformanceConfigurationINTEL>::type
        acquirePerformanceConfigurationINTEL( PerformanceConfigurationAcquireInfoINTEL const & acquireInfo ) const VULKAN_HPP_NOEXCEPT_WHEN_NO_EXCEPTIONS;

      // wrapper function for command vkGetPerformanceParameterINTEL, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetPerformanceParameterINTEL.html
      VULKAN_HPP_NODISCARD typename ResultValueType<PerformanceValueINTEL>::type getPerformanceParameterINTEL( PerformanceParameterTypeINTEL parameter ) const;

      //=== VK_EXT_buffer_device_address ===

      // wrapper function for command vkGetBufferDeviceAddressEXT, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetBufferDeviceAddressEXT.html
      VULKAN_HPP_NODISCARD DeviceAddress getBufferAddressEXT( const BufferDeviceAddressInfo & info ) const VULKAN_HPP_NOEXCEPT;

#  if defined( VK_USE_PLATFORM_WIN32_KHR )
      //=== VK_EXT_full_screen_exclusive ===

      // wrapper function for command vkGetDeviceGroupSurfacePresentModes2EXT, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetDeviceGroupSurfacePresentModes2EXT.html
      VULKAN_HPP_NODISCARD typename ResultValueType<DeviceGroupPresentModeFlagsKHR>::type
        getGroupSurfacePresentModes2EXT( const PhysicalDeviceSurfaceInfo2KHR & surfaceInfo ) const;
#  endif /*VK_USE_PLATFORM_WIN32_KHR*/

      //=== VK_KHR_buffer_device_address ===

      // wrapper function for command vkGetBufferDeviceAddressKHR, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetBufferDeviceAddressKHR.html
      VULKAN_HPP_NODISCARD DeviceAddress getBufferAddressKHR( const BufferDeviceAddressInfo & info ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkGetBufferOpaqueCaptureAddressKHR, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetBufferOpaqueCaptureAddressKHR.html
      VULKAN_HPP_NODISCARD uint64_t getBufferOpaqueCaptureAddressKHR( const BufferDeviceAddressInfo & info ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkGetDeviceMemoryOpaqueCaptureAddressKHR, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetDeviceMemoryOpaqueCaptureAddressKHR.html
      VULKAN_HPP_NODISCARD uint64_t getMemoryOpaqueCaptureAddressKHR( const DeviceMemoryOpaqueCaptureAddressInfo & info ) const VULKAN_HPP_NOEXCEPT;

      //=== VK_KHR_deferred_host_operations ===

      // wrapper function for command vkCreateDeferredOperationKHR, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateDeferredOperationKHR.html
      VULKAN_HPP_NODISCARD typename ResultValueType<DeferredOperationKHR>::type
        createDeferredOperationKHR( Optional<const AllocationCallbacks> allocator = nullptr ) const VULKAN_HPP_NOEXCEPT_WHEN_NO_EXCEPTIONS;

      //=== VK_KHR_pipeline_executable_properties ===

      // wrapper function for command vkGetPipelineExecutablePropertiesKHR, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetPipelineExecutablePropertiesKHR.html
      VULKAN_HPP_NODISCARD typename ResultValueType<std::vector<PipelineExecutablePropertiesKHR>>::type
        getPipelineExecutablePropertiesKHR( const PipelineInfoKHR & pipelineInfo ) const;

      // wrapper function for command vkGetPipelineExecutableStatisticsKHR, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetPipelineExecutableStatisticsKHR.html
      VULKAN_HPP_NODISCARD typename ResultValueType<std::vector<PipelineExecutableStatisticKHR>>::type
        getPipelineExecutableStatisticsKHR( const PipelineExecutableInfoKHR & executableInfo ) const;

      // wrapper function for command vkGetPipelineExecutableInternalRepresentationsKHR, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetPipelineExecutableInternalRepresentationsKHR.html
      VULKAN_HPP_NODISCARD typename ResultValueType<std::vector<PipelineExecutableInternalRepresentationKHR>>::type
        getPipelineExecutableInternalRepresentationsKHR( const PipelineExecutableInfoKHR & executableInfo ) const;

      //=== VK_EXT_host_image_copy ===

      // wrapper function for command vkCopyMemoryToImageEXT, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCopyMemoryToImageEXT.html
      typename ResultValueType<void>::type copyMemoryToImageEXT( const CopyMemoryToImageInfo & copyMemoryToImageInfo ) const;

      // wrapper function for command vkCopyImageToMemoryEXT, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCopyImageToMemoryEXT.html
      typename ResultValueType<void>::type copyImageToMemoryEXT( const CopyImageToMemoryInfo & copyImageToMemoryInfo ) const;

      // wrapper function for command vkCopyImageToImageEXT, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCopyImageToImageEXT.html
      typename ResultValueType<void>::type copyImageToImageEXT( const CopyImageToImageInfo & copyImageToImageInfo ) const;

      // wrapper function for command vkTransitionImageLayoutEXT, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkTransitionImageLayoutEXT.html
      typename ResultValueType<void>::type transitionImageLayoutEXT( ArrayProxy<const HostImageLayoutTransitionInfo> const & transitions ) const;

      //=== VK_KHR_map_memory2 ===

      // wrapper function for command vkMapMemory2KHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkMapMemory2KHR.html
      VULKAN_HPP_NODISCARD typename ResultValueType<void *>::type mapMemory2KHR( const MemoryMapInfo & memoryMapInfo ) const;

      // wrapper function for command vkUnmapMemory2KHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkUnmapMemory2KHR.html
      typename ResultValueType<void>::type unmapMemory2KHR( const MemoryUnmapInfo & memoryUnmapInfo ) const;

      //=== VK_EXT_swapchain_maintenance1 ===

      // wrapper function for command vkReleaseSwapchainImagesEXT, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkReleaseSwapchainImagesEXT.html
      typename ResultValueType<void>::type releaseSwapchainImagesEXT( const ReleaseSwapchainImagesInfoKHR & releaseInfo ) const;

      //=== VK_NV_device_generated_commands ===

      // wrapper function for command vkGetGeneratedCommandsMemoryRequirementsNV, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetGeneratedCommandsMemoryRequirementsNV.html
      VULKAN_HPP_NODISCARD MemoryRequirements2
        getGeneratedCommandsMemoryRequirementsNV( const GeneratedCommandsMemoryRequirementsInfoNV & info ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkGetGeneratedCommandsMemoryRequirementsNV, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetGeneratedCommandsMemoryRequirementsNV.html
      template <typename X, typename Y, typename... Z>
      VULKAN_HPP_NODISCARD StructureChain<X, Y, Z...>
                           getGeneratedCommandsMemoryRequirementsNV( const GeneratedCommandsMemoryRequirementsInfoNV & info ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkCreateIndirectCommandsLayoutNV, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateIndirectCommandsLayoutNV.html
      VULKAN_HPP_NODISCARD typename ResultValueType<IndirectCommandsLayoutNV>::type
        createIndirectCommandsLayoutNV( IndirectCommandsLayoutCreateInfoNV const & createInfo,
                                        Optional<const AllocationCallbacks>        allocator = nullptr ) const VULKAN_HPP_NOEXCEPT_WHEN_NO_EXCEPTIONS;

      //=== VK_EXT_private_data ===

      // wrapper function for command vkCreatePrivateDataSlotEXT, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreatePrivateDataSlotEXT.html
      VULKAN_HPP_NODISCARD typename ResultValueType<PrivateDataSlot>::type
        createPrivateDataSlotEXT( PrivateDataSlotCreateInfo const &   createInfo,
                                  Optional<const AllocationCallbacks> allocator = nullptr ) const VULKAN_HPP_NOEXCEPT_WHEN_NO_EXCEPTIONS;

      // wrapper function for command vkDestroyPrivateDataSlotEXT, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkDestroyPrivateDataSlotEXT.html
      void destroyPrivateDataSlotEXT( VULKAN_HPP_NAMESPACE::PrivateDataSlot privateDataSlot VULKAN_HPP_DEFAULT_ASSIGNMENT( {} ),
                                      Optional<const AllocationCallbacks> allocator VULKAN_HPP_DEFAULT_ASSIGNMENT( nullptr ) ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkSetPrivateDataEXT, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkSetPrivateDataEXT.html
      typename ResultValueType<void>::type
        setPrivateDataEXT( ObjectType objectType, uint64_t objectHandle, VULKAN_HPP_NAMESPACE::PrivateDataSlot privateDataSlot, uint64_t data ) const;

      // wrapper function for command vkGetPrivateDataEXT, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetPrivateDataEXT.html
      VULKAN_HPP_NODISCARD uint64_t getPrivateDataEXT( ObjectType                            objectType,
                                                       uint64_t                              objectHandle,
                                                       VULKAN_HPP_NAMESPACE::PrivateDataSlot privateDataSlot ) const VULKAN_HPP_NOEXCEPT;

      //=== VK_KHR_video_encode_queue ===

      // wrapper function for command vkGetEncodedVideoSessionParametersKHR, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetEncodedVideoSessionParametersKHR.html
      VULKAN_HPP_NODISCARD typename ResultValueType<std::pair<VideoEncodeSessionParametersFeedbackInfoKHR, std::vector<uint8_t>>>::type
        getEncodedVideoSessionParametersKHR( const VideoEncodeSessionParametersGetInfoKHR & videoSessionParametersInfo ) const;

      // wrapper function for command vkGetEncodedVideoSessionParametersKHR, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetEncodedVideoSessionParametersKHR.html
      template <typename X, typename Y, typename... Z>
      VULKAN_HPP_NODISCARD typename ResultValueType<std::pair<StructureChain<X, Y, Z...>, std::vector<uint8_t>>>::type
        getEncodedVideoSessionParametersKHR( const VideoEncodeSessionParametersGetInfoKHR & videoSessionParametersInfo ) const;

#  if defined( VK_ENABLE_BETA_EXTENSIONS )
      //=== VK_NV_cuda_kernel_launch ===

      // wrapper function for command vkCreateCudaModuleNV, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateCudaModuleNV.html
      VULKAN_HPP_NODISCARD typename ResultValueType<CudaModuleNV>::type
        createCudaModuleNV( CudaModuleCreateInfoNV const &      createInfo,
                            Optional<const AllocationCallbacks> allocator = nullptr ) const VULKAN_HPP_NOEXCEPT_WHEN_NO_EXCEPTIONS;

      // wrapper function for command vkCreateCudaFunctionNV, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateCudaFunctionNV.html
      VULKAN_HPP_NODISCARD typename ResultValueType<CudaFunctionNV>::type
        createCudaFunctionNV( CudaFunctionCreateInfoNV const &    createInfo,
                              Optional<const AllocationCallbacks> allocator = nullptr ) const VULKAN_HPP_NOEXCEPT_WHEN_NO_EXCEPTIONS;
#  endif /*VK_ENABLE_BETA_EXTENSIONS*/

#  if defined( VK_USE_PLATFORM_METAL_EXT )
      //=== VK_EXT_metal_objects ===

      // wrapper function for command vkExportMetalObjectsEXT, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkExportMetalObjectsEXT.html
      void exportMetalObjectsEXT( ExportMetalObjectsInfoEXT & metalObjectsInfo ) const VULKAN_HPP_NOEXCEPT;
#  endif /*VK_USE_PLATFORM_METAL_EXT*/

      //=== VK_EXT_descriptor_buffer ===

      // wrapper function for command vkGetDescriptorEXT, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetDescriptorEXT.html
      void getDescriptorEXT( const DescriptorGetInfoEXT & descriptorInfo, size_t dataSize, void * pDescriptor ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkGetDescriptorEXT, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetDescriptorEXT.html
      template <typename DescriptorType>
      VULKAN_HPP_NODISCARD DescriptorType getDescriptorEXT( const DescriptorGetInfoEXT & descriptorInfo ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkGetBufferOpaqueCaptureDescriptorDataEXT, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetBufferOpaqueCaptureDescriptorDataEXT.html
      template <typename DataType>
      VULKAN_HPP_NODISCARD typename ResultValueType<DataType>::type
        getBufferOpaqueCaptureDescriptorDataEXT( const BufferCaptureDescriptorDataInfoEXT & info ) const;

      // wrapper function for command vkGetImageOpaqueCaptureDescriptorDataEXT, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetImageOpaqueCaptureDescriptorDataEXT.html
      template <typename DataType>
      VULKAN_HPP_NODISCARD typename ResultValueType<DataType>::type
        getImageOpaqueCaptureDescriptorDataEXT( const ImageCaptureDescriptorDataInfoEXT & info ) const;

      // wrapper function for command vkGetImageViewOpaqueCaptureDescriptorDataEXT, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetImageViewOpaqueCaptureDescriptorDataEXT.html
      template <typename DataType>
      VULKAN_HPP_NODISCARD typename ResultValueType<DataType>::type
        getImageViewOpaqueCaptureDescriptorDataEXT( const ImageViewCaptureDescriptorDataInfoEXT & info ) const;

      // wrapper function for command vkGetSamplerOpaqueCaptureDescriptorDataEXT, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetSamplerOpaqueCaptureDescriptorDataEXT.html
      template <typename DataType>
      VULKAN_HPP_NODISCARD typename ResultValueType<DataType>::type
        getSamplerOpaqueCaptureDescriptorDataEXT( const SamplerCaptureDescriptorDataInfoEXT & info ) const;

      // wrapper function for command vkGetAccelerationStructureOpaqueCaptureDescriptorDataEXT, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetAccelerationStructureOpaqueCaptureDescriptorDataEXT.html
      template <typename DataType>
      VULKAN_HPP_NODISCARD typename ResultValueType<DataType>::type
        getAccelerationStructureOpaqueCaptureDescriptorDataEXT( const AccelerationStructureCaptureDescriptorDataInfoEXT & info ) const;

      //=== VK_EXT_device_fault ===

      // wrapper function for command vkGetDeviceFaultInfoEXT, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetDeviceFaultInfoEXT.html
      VULKAN_HPP_NODISCARD Result getFaultInfoEXT( DeviceFaultCountsEXT * pFaultCounts, DeviceFaultInfoEXT * pFaultInfo ) const VULKAN_HPP_NOEXCEPT;

#  if defined( VK_USE_PLATFORM_FUCHSIA )
      //=== VK_FUCHSIA_external_memory ===

      // wrapper function for command vkGetMemoryZirconHandleFUCHSIA, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetMemoryZirconHandleFUCHSIA.html
      VULKAN_HPP_NODISCARD typename ResultValueType<zx_handle_t>::type
        getMemoryZirconHandleFUCHSIA( const MemoryGetZirconHandleInfoFUCHSIA & getZirconHandleInfo ) const;

      // wrapper function for command vkGetMemoryZirconHandlePropertiesFUCHSIA, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetMemoryZirconHandlePropertiesFUCHSIA.html
      VULKAN_HPP_NODISCARD typename ResultValueType<MemoryZirconHandlePropertiesFUCHSIA>::type
        getMemoryZirconHandlePropertiesFUCHSIA( ExternalMemoryHandleTypeFlagBits handleType, zx_handle_t zirconHandle ) const;
#  endif /*VK_USE_PLATFORM_FUCHSIA*/

#  if defined( VK_USE_PLATFORM_FUCHSIA )
      //=== VK_FUCHSIA_external_semaphore ===

      // wrapper function for command vkImportSemaphoreZirconHandleFUCHSIA, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkImportSemaphoreZirconHandleFUCHSIA.html
      typename ResultValueType<void>::type
        importSemaphoreZirconHandleFUCHSIA( const ImportSemaphoreZirconHandleInfoFUCHSIA & importSemaphoreZirconHandleInfo ) const;

      // wrapper function for command vkGetSemaphoreZirconHandleFUCHSIA, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetSemaphoreZirconHandleFUCHSIA.html
      VULKAN_HPP_NODISCARD typename ResultValueType<zx_handle_t>::type
        getSemaphoreZirconHandleFUCHSIA( const SemaphoreGetZirconHandleInfoFUCHSIA & getZirconHandleInfo ) const;
#  endif /*VK_USE_PLATFORM_FUCHSIA*/

#  if defined( VK_USE_PLATFORM_FUCHSIA )
      //=== VK_FUCHSIA_buffer_collection ===

      // wrapper function for command vkCreateBufferCollectionFUCHSIA, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateBufferCollectionFUCHSIA.html
      VULKAN_HPP_NODISCARD typename ResultValueType<BufferCollectionFUCHSIA>::type
        createBufferCollectionFUCHSIA( BufferCollectionCreateInfoFUCHSIA const & createInfo,
                                       Optional<const AllocationCallbacks>       allocator = nullptr ) const VULKAN_HPP_NOEXCEPT_WHEN_NO_EXCEPTIONS;
#  endif /*VK_USE_PLATFORM_FUCHSIA*/

      //=== VK_NV_external_memory_rdma ===

      // wrapper function for command vkGetMemoryRemoteAddressNV, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetMemoryRemoteAddressNV.html
      VULKAN_HPP_NODISCARD typename ResultValueType<RemoteAddressNV>::type
        getMemoryRemoteAddressNV( const MemoryGetRemoteAddressInfoNV & memoryGetRemoteAddressInfo ) const;

      //=== VK_EXT_pipeline_properties ===

      // wrapper function for command vkGetPipelinePropertiesEXT, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetPipelinePropertiesEXT.html
      VULKAN_HPP_NODISCARD typename ResultValueType<BaseOutStructure>::type getPipelinePropertiesEXT( const PipelineInfoEXT & pipelineInfo ) const;

      //=== VK_EXT_opacity_micromap ===

      // wrapper function for command vkCreateMicromapEXT, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateMicromapEXT.html
      VULKAN_HPP_NODISCARD typename ResultValueType<MicromapEXT>::type
        createMicromapEXT( MicromapCreateInfoEXT const &       createInfo,
                           Optional<const AllocationCallbacks> allocator = nullptr ) const VULKAN_HPP_NOEXCEPT_WHEN_NO_EXCEPTIONS;

      // wrapper function for command vkBuildMicromapsEXT, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkBuildMicromapsEXT.html
      VULKAN_HPP_NODISCARD Result buildMicromapsEXT( VULKAN_HPP_NAMESPACE::DeferredOperationKHR     deferredOperation,
                                                     ArrayProxy<const MicromapBuildInfoEXT> const & infos ) const;

      // wrapper function for command vkCopyMicromapEXT, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCopyMicromapEXT.html
      VULKAN_HPP_NODISCARD Result copyMicromapEXT( VULKAN_HPP_NAMESPACE::DeferredOperationKHR deferredOperation, const CopyMicromapInfoEXT & info ) const;

      // wrapper function for command vkCopyMicromapToMemoryEXT, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCopyMicromapToMemoryEXT.html
      VULKAN_HPP_NODISCARD Result copyMicromapToMemoryEXT( VULKAN_HPP_NAMESPACE::DeferredOperationKHR deferredOperation,
                                                           const CopyMicromapToMemoryInfoEXT &        info ) const;

      // wrapper function for command vkCopyMemoryToMicromapEXT, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCopyMemoryToMicromapEXT.html
      VULKAN_HPP_NODISCARD Result copyMemoryToMicromapEXT( VULKAN_HPP_NAMESPACE::DeferredOperationKHR deferredOperation,
                                                           const CopyMemoryToMicromapInfoEXT &        info ) const;

      // wrapper function for command vkWriteMicromapsPropertiesEXT, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkWriteMicromapsPropertiesEXT.html
      template <typename DataType>
      VULKAN_HPP_NODISCARD typename ResultValueType<std::vector<DataType>>::type writeMicromapsPropertiesEXT(
        ArrayProxy<const VULKAN_HPP_NAMESPACE::MicromapEXT> const & micromaps, QueryType queryType, size_t dataSize, size_t stride ) const;

      // wrapper function for command vkWriteMicromapsPropertiesEXT, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkWriteMicromapsPropertiesEXT.html
      template <typename DataType>
      VULKAN_HPP_NODISCARD typename ResultValueType<DataType>::type
        writeMicromapsPropertyEXT( ArrayProxy<const VULKAN_HPP_NAMESPACE::MicromapEXT> const & micromaps, QueryType queryType, size_t stride ) const;

      // wrapper function for command vkGetDeviceMicromapCompatibilityEXT, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetDeviceMicromapCompatibilityEXT.html
      VULKAN_HPP_NODISCARD AccelerationStructureCompatibilityKHR
        getMicromapCompatibilityEXT( const MicromapVersionInfoEXT & versionInfo ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkGetMicromapBuildSizesEXT, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetMicromapBuildSizesEXT.html
      VULKAN_HPP_NODISCARD MicromapBuildSizesInfoEXT getMicromapBuildSizesEXT( AccelerationStructureBuildTypeKHR buildType,
                                                                               const MicromapBuildInfoEXT &      buildInfo ) const VULKAN_HPP_NOEXCEPT;

      //=== VK_KHR_maintenance4 ===

      // wrapper function for command vkGetDeviceBufferMemoryRequirementsKHR, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetDeviceBufferMemoryRequirementsKHR.html
      VULKAN_HPP_NODISCARD MemoryRequirements2 getBufferMemoryRequirementsKHR( const DeviceBufferMemoryRequirements & info ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkGetDeviceBufferMemoryRequirementsKHR, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetDeviceBufferMemoryRequirementsKHR.html
      template <typename X, typename Y, typename... Z>
      VULKAN_HPP_NODISCARD StructureChain<X, Y, Z...> getBufferMemoryRequirementsKHR( const DeviceBufferMemoryRequirements & info ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkGetDeviceImageMemoryRequirementsKHR, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetDeviceImageMemoryRequirementsKHR.html
      VULKAN_HPP_NODISCARD MemoryRequirements2 getImageMemoryRequirementsKHR( const DeviceImageMemoryRequirements & info ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkGetDeviceImageMemoryRequirementsKHR, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetDeviceImageMemoryRequirementsKHR.html
      template <typename X, typename Y, typename... Z>
      VULKAN_HPP_NODISCARD StructureChain<X, Y, Z...> getImageMemoryRequirementsKHR( const DeviceImageMemoryRequirements & info ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkGetDeviceImageSparseMemoryRequirementsKHR, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetDeviceImageSparseMemoryRequirementsKHR.html
      VULKAN_HPP_NODISCARD std::vector<SparseImageMemoryRequirements2> getImageSparseMemoryRequirementsKHR( const DeviceImageMemoryRequirements & info ) const;

      //=== VK_VALVE_descriptor_set_host_mapping ===

      // wrapper function for command vkGetDescriptorSetLayoutHostMappingInfoVALVE, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetDescriptorSetLayoutHostMappingInfoVALVE.html
      VULKAN_HPP_NODISCARD DescriptorSetLayoutHostMappingInfoVALVE
        getDescriptorSetLayoutHostMappingInfoVALVE( const DescriptorSetBindingReferenceVALVE & bindingReference ) const VULKAN_HPP_NOEXCEPT;

      //=== VK_NV_device_generated_commands_compute ===

      // wrapper function for command vkGetPipelineIndirectMemoryRequirementsNV, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetPipelineIndirectMemoryRequirementsNV.html
      VULKAN_HPP_NODISCARD MemoryRequirements2
        getPipelineIndirectMemoryRequirementsNV( const ComputePipelineCreateInfo & createInfo ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkGetPipelineIndirectMemoryRequirementsNV, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetPipelineIndirectMemoryRequirementsNV.html
      template <typename X, typename Y, typename... Z>
      VULKAN_HPP_NODISCARD StructureChain<X, Y, Z...>
                           getPipelineIndirectMemoryRequirementsNV( const ComputePipelineCreateInfo & createInfo ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkGetPipelineIndirectDeviceAddressNV, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetPipelineIndirectDeviceAddressNV.html
      VULKAN_HPP_NODISCARD DeviceAddress getPipelineIndirectAddressNV( const PipelineIndirectDeviceAddressInfoNV & info ) const VULKAN_HPP_NOEXCEPT;

#  if defined( VK_USE_PLATFORM_OHOS )
      //=== VK_OHOS_external_memory ===

      // wrapper function for command vkGetNativeBufferPropertiesOHOS, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetNativeBufferPropertiesOHOS.html
      VULKAN_HPP_NODISCARD Result getNativeBufferPropertiesOHOS( const struct OH_NativeBuffer * buffer,
                                                                 NativeBufferPropertiesOHOS *   pProperties ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkGetNativeBufferPropertiesOHOS, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetNativeBufferPropertiesOHOS.html
      VULKAN_HPP_NODISCARD typename ResultValueType<NativeBufferPropertiesOHOS>::type
        getNativeBufferPropertiesOHOS( const struct OH_NativeBuffer & buffer ) const;

      // wrapper function for command vkGetNativeBufferPropertiesOHOS, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetNativeBufferPropertiesOHOS.html
      template <typename X, typename Y, typename... Z>
      VULKAN_HPP_NODISCARD typename ResultValueType<StructureChain<X, Y, Z...>>::type
        getNativeBufferPropertiesOHOS( const struct OH_NativeBuffer & buffer ) const;

      // wrapper function for command vkGetMemoryNativeBufferOHOS, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetMemoryNativeBufferOHOS.html
      VULKAN_HPP_NODISCARD typename ResultValueType<struct OH_NativeBuffer *>::type
        getMemoryNativeBufferOHOS( const MemoryGetNativeBufferInfoOHOS & info ) const;
#  endif /*VK_USE_PLATFORM_OHOS*/

      //=== VK_ARM_tensors ===

      // wrapper function for command vkCreateTensorARM, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateTensorARM.html
      VULKAN_HPP_NODISCARD typename ResultValueType<TensorARM>::type
        createTensorARM( TensorCreateInfoARM const &         createInfo,
                         Optional<const AllocationCallbacks> allocator = nullptr ) const VULKAN_HPP_NOEXCEPT_WHEN_NO_EXCEPTIONS;

      // wrapper function for command vkCreateTensorViewARM, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateTensorViewARM.html
      VULKAN_HPP_NODISCARD typename ResultValueType<TensorViewARM>::type
        createTensorViewARM( TensorViewCreateInfoARM const &     createInfo,
                             Optional<const AllocationCallbacks> allocator = nullptr ) const VULKAN_HPP_NOEXCEPT_WHEN_NO_EXCEPTIONS;

      // wrapper function for command vkGetTensorMemoryRequirementsARM, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetTensorMemoryRequirementsARM.html
      VULKAN_HPP_NODISCARD MemoryRequirements2 getTensorMemoryRequirementsARM( const TensorMemoryRequirementsInfoARM & info ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkGetTensorMemoryRequirementsARM, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetTensorMemoryRequirementsARM.html
      template <typename X, typename Y, typename... Z>
      VULKAN_HPP_NODISCARD StructureChain<X, Y, Z...> getTensorMemoryRequirementsARM( const TensorMemoryRequirementsInfoARM & info ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkBindTensorMemoryARM, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkBindTensorMemoryARM.html
      typename ResultValueType<void>::type bindTensorMemoryARM( ArrayProxy<const BindTensorMemoryInfoARM> const & bindInfos ) const;

      // wrapper function for command vkGetDeviceTensorMemoryRequirementsARM, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetDeviceTensorMemoryRequirementsARM.html
      VULKAN_HPP_NODISCARD MemoryRequirements2 getTensorMemoryRequirementsARM( const DeviceTensorMemoryRequirementsARM & info ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkGetDeviceTensorMemoryRequirementsARM, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetDeviceTensorMemoryRequirementsARM.html
      template <typename X, typename Y, typename... Z>
      VULKAN_HPP_NODISCARD StructureChain<X, Y, Z...>
                           getTensorMemoryRequirementsARM( const DeviceTensorMemoryRequirementsARM & info ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkGetTensorOpaqueCaptureDescriptorDataARM, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetTensorOpaqueCaptureDescriptorDataARM.html
      template <typename DataType>
      VULKAN_HPP_NODISCARD typename ResultValueType<DataType>::type
        getTensorOpaqueCaptureDescriptorDataARM( const TensorCaptureDescriptorDataInfoARM & info ) const;

      // wrapper function for command vkGetTensorViewOpaqueCaptureDescriptorDataARM, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetTensorViewOpaqueCaptureDescriptorDataARM.html
      template <typename DataType>
      VULKAN_HPP_NODISCARD typename ResultValueType<DataType>::type
        getTensorViewOpaqueCaptureDescriptorDataARM( const TensorViewCaptureDescriptorDataInfoARM & info ) const;

      //=== VK_EXT_shader_module_identifier ===

      // wrapper function for command vkGetShaderModuleCreateInfoIdentifierEXT, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetShaderModuleCreateInfoIdentifierEXT.html
      VULKAN_HPP_NODISCARD ShaderModuleIdentifierEXT
        getShaderModuleCreateInfoIdentifierEXT( const ShaderModuleCreateInfo & createInfo ) const VULKAN_HPP_NOEXCEPT;

      //=== VK_NV_optical_flow ===

      // wrapper function for command vkCreateOpticalFlowSessionNV, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateOpticalFlowSessionNV.html
      VULKAN_HPP_NODISCARD typename ResultValueType<OpticalFlowSessionNV>::type
        createOpticalFlowSessionNV( OpticalFlowSessionCreateInfoNV const & createInfo,
                                    Optional<const AllocationCallbacks>    allocator = nullptr ) const VULKAN_HPP_NOEXCEPT_WHEN_NO_EXCEPTIONS;

      //=== VK_KHR_maintenance5 ===

      // wrapper function for command vkGetRenderingAreaGranularityKHR, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetRenderingAreaGranularityKHR.html
      VULKAN_HPP_NODISCARD Extent2D getRenderingAreaGranularityKHR( const RenderingAreaInfo & renderingAreaInfo ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkGetDeviceImageSubresourceLayoutKHR, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetDeviceImageSubresourceLayoutKHR.html
      VULKAN_HPP_NODISCARD SubresourceLayout2 getImageSubresourceLayoutKHR( const DeviceImageSubresourceInfo & info ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkGetDeviceImageSubresourceLayoutKHR, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetDeviceImageSubresourceLayoutKHR.html
      template <typename X, typename Y, typename... Z>
      VULKAN_HPP_NODISCARD StructureChain<X, Y, Z...> getImageSubresourceLayoutKHR( const DeviceImageSubresourceInfo & info ) const VULKAN_HPP_NOEXCEPT;

      //=== VK_AMD_anti_lag ===

      // wrapper function for command vkAntiLagUpdateAMD, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkAntiLagUpdateAMD.html
      void antiLagUpdateAMD( const AntiLagDataAMD & data ) const VULKAN_HPP_NOEXCEPT;

      //=== VK_EXT_shader_object ===

      // wrapper function for command vkCreateShadersEXT, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateShadersEXT.html
      VULKAN_HPP_NODISCARD typename ResultValueType<std::vector<ShaderEXT>>::type
        createShadersEXT( ArrayProxy<ShaderCreateInfoEXT> const & createInfos, Optional<const AllocationCallbacks> allocator = nullptr ) const;

      // wrapper function for command vkCreateShadersEXT, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateShadersEXT.html
      VULKAN_HPP_NODISCARD typename ResultValueType<ShaderEXT>::type
        createShaderEXT( ShaderCreateInfoEXT const &         createInfo,
                         Optional<const AllocationCallbacks> allocator = nullptr ) const VULKAN_HPP_NOEXCEPT_WHEN_NO_EXCEPTIONS;

      //=== VK_KHR_pipeline_binary ===

      // wrapper function for command vkCreatePipelineBinariesKHR, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreatePipelineBinariesKHR.html
      VULKAN_HPP_NODISCARD typename ResultValueType<std::vector<PipelineBinaryKHR>>::type
        createPipelineBinariesKHR( PipelineBinaryCreateInfoKHR const & createInfo, Optional<const AllocationCallbacks> allocator = nullptr ) const;

      // wrapper function for command vkGetPipelineKeyKHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetPipelineKeyKHR.html
      VULKAN_HPP_NODISCARD typename ResultValueType<PipelineBinaryKeyKHR>::type
        getPipelineKeyKHR( Optional<const PipelineCreateInfoKHR> pipelineCreateInfo VULKAN_HPP_DEFAULT_ASSIGNMENT( nullptr ) ) const;

      // wrapper function for command vkGetPipelineBinaryDataKHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetPipelineBinaryDataKHR.html
      VULKAN_HPP_NODISCARD typename ResultValueType<std::pair<PipelineBinaryKeyKHR, std::vector<uint8_t>>>::type
        getPipelineBinaryDataKHR( const PipelineBinaryDataInfoKHR & info ) const;

      // wrapper function for command vkReleaseCapturedPipelineDataKHR, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkReleaseCapturedPipelineDataKHR.html
      typename ResultValueType<void>::type
        releaseCapturedPipelineDataKHR( const ReleaseCapturedPipelineDataInfoKHR &    info,
                                        Optional<const AllocationCallbacks> allocator VULKAN_HPP_DEFAULT_ASSIGNMENT( nullptr ) ) const;

      //=== VK_QCOM_tile_properties ===

      // wrapper function for command vkGetDynamicRenderingTilePropertiesQCOM, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetDynamicRenderingTilePropertiesQCOM.html
      VULKAN_HPP_NODISCARD typename ResultValueType<TilePropertiesQCOM>::type
        getDynamicRenderingTilePropertiesQCOM( const RenderingInfo & renderingInfo ) const;

      //=== VK_KHR_swapchain_maintenance1 ===

      // wrapper function for command vkReleaseSwapchainImagesKHR, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkReleaseSwapchainImagesKHR.html
      typename ResultValueType<void>::type releaseSwapchainImagesKHR( const ReleaseSwapchainImagesInfoKHR & releaseInfo ) const;

      //=== VK_NV_cooperative_vector ===

      // wrapper function for command vkConvertCooperativeVectorMatrixNV, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkConvertCooperativeVectorMatrixNV.html
      VULKAN_HPP_NODISCARD Result convertCooperativeVectorMatrixNV( const ConvertCooperativeVectorMatrixInfoNV & info ) const;

      //=== VK_ARM_data_graph ===

      // wrapper function for command vkCreateDataGraphPipelinesARM, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateDataGraphPipelinesARM.html
      VULKAN_HPP_NODISCARD typename ResultValueType<std::vector<Pipeline>>::type
        createDataGraphPipelinesARM( Optional<const DeferredOperationKHR> const &       deferredOperation,
                                     Optional<const PipelineCache> const &              pipelineCache,
                                     ArrayProxy<DataGraphPipelineCreateInfoARM> const & createInfos,
                                     Optional<const AllocationCallbacks>                allocator = nullptr ) const;

      // wrapper function for command vkCreateDataGraphPipelinesARM, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateDataGraphPipelinesARM.html
      VULKAN_HPP_NODISCARD typename ResultValueType<Pipeline>::type
        createDataGraphPipelineARM( Optional<const DeferredOperationKHR> const & deferredOperation,
                                    Optional<const PipelineCache> const &        pipelineCache,
                                    DataGraphPipelineCreateInfoARM const &       createInfo,
                                    Optional<const AllocationCallbacks>          allocator = nullptr ) const VULKAN_HPP_NOEXCEPT_WHEN_NO_EXCEPTIONS;

      // wrapper function for command vkCreateDataGraphPipelineSessionARM, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateDataGraphPipelineSessionARM.html
      VULKAN_HPP_NODISCARD typename ResultValueType<DataGraphPipelineSessionARM>::type
        createDataGraphPipelineSessionARM( DataGraphPipelineSessionCreateInfoARM const & createInfo,
                                           Optional<const AllocationCallbacks>           allocator = nullptr ) const VULKAN_HPP_NOEXCEPT_WHEN_NO_EXCEPTIONS;

      // wrapper function for command vkGetDataGraphPipelineSessionBindPointRequirementsARM, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetDataGraphPipelineSessionBindPointRequirementsARM.html
      VULKAN_HPP_NODISCARD typename ResultValueType<std::vector<DataGraphPipelineSessionBindPointRequirementARM>>::type
        getDataGraphPipelineSessionBindPointRequirementsARM( const DataGraphPipelineSessionBindPointRequirementsInfoARM & info ) const;

      // wrapper function for command vkGetDataGraphPipelineSessionMemoryRequirementsARM, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetDataGraphPipelineSessionMemoryRequirementsARM.html
      VULKAN_HPP_NODISCARD MemoryRequirements2
        getDataGraphPipelineSessionMemoryRequirementsARM( const DataGraphPipelineSessionMemoryRequirementsInfoARM & info ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkGetDataGraphPipelineSessionMemoryRequirementsARM, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetDataGraphPipelineSessionMemoryRequirementsARM.html
      template <typename X, typename Y, typename... Z>
      VULKAN_HPP_NODISCARD StructureChain<X, Y, Z...>
        getDataGraphPipelineSessionMemoryRequirementsARM( const DataGraphPipelineSessionMemoryRequirementsInfoARM & info ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkBindDataGraphPipelineSessionMemoryARM, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkBindDataGraphPipelineSessionMemoryARM.html
      typename ResultValueType<void>::type
        bindDataGraphPipelineSessionMemoryARM( ArrayProxy<const BindDataGraphPipelineSessionMemoryInfoARM> const & bindInfos ) const;

      // wrapper function for command vkGetDataGraphPipelineAvailablePropertiesARM, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetDataGraphPipelineAvailablePropertiesARM.html
      VULKAN_HPP_NODISCARD typename ResultValueType<std::vector<DataGraphPipelinePropertyARM>>::type
        getDataGraphPipelineAvailablePropertiesARM( const DataGraphPipelineInfoARM & pipelineInfo ) const;

      // wrapper function for command vkGetDataGraphPipelinePropertiesARM, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetDataGraphPipelinePropertiesARM.html
      VULKAN_HPP_NODISCARD Result getDataGraphPipelinePropertiesARM( const DataGraphPipelineInfoARM *          pPipelineInfo,
                                                                     uint32_t                                  propertiesCount,
                                                                     DataGraphPipelinePropertyQueryResultARM * pProperties ) const VULKAN_HPP_NOEXCEPT;

#  if defined( VK_USE_PLATFORM_SCREEN_QNX )
      //=== VK_QNX_external_memory_screen_buffer ===

      // wrapper function for command vkGetScreenBufferPropertiesQNX, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetScreenBufferPropertiesQNX.html
      VULKAN_HPP_NODISCARD Result getScreenBufferPropertiesQNX( const struct _screen_buffer * buffer,
                                                                ScreenBufferPropertiesQNX *   pProperties ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkGetScreenBufferPropertiesQNX, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetScreenBufferPropertiesQNX.html
      VULKAN_HPP_NODISCARD typename ResultValueType<ScreenBufferPropertiesQNX>::type getScreenBufferPropertiesQNX( const struct _screen_buffer & buffer ) const;

      // wrapper function for command vkGetScreenBufferPropertiesQNX, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetScreenBufferPropertiesQNX.html
      template <typename X, typename Y, typename... Z>
      VULKAN_HPP_NODISCARD typename ResultValueType<StructureChain<X, Y, Z...>>::type
        getScreenBufferPropertiesQNX( const struct _screen_buffer & buffer ) const;
#  endif /*VK_USE_PLATFORM_SCREEN_QNX*/

      //=== VK_KHR_calibrated_timestamps ===

      // wrapper function for command vkGetCalibratedTimestampsKHR, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetCalibratedTimestampsKHR.html
      VULKAN_HPP_NODISCARD typename ResultValueType<std::pair<std::vector<uint64_t>, uint64_t>>::type
        getCalibratedTimestampsKHR( ArrayProxy<const CalibratedTimestampInfoKHR> const & timestampInfos ) const;

      // wrapper function for command vkGetCalibratedTimestampsKHR, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetCalibratedTimestampsKHR.html
      VULKAN_HPP_NODISCARD typename ResultValueType<std::pair<uint64_t, uint64_t>>::type
        getCalibratedTimestampKHR( const CalibratedTimestampInfoKHR & timestampInfo ) const;

      //=== VK_NV_external_compute_queue ===

      // wrapper function for command vkCreateExternalComputeQueueNV, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateExternalComputeQueueNV.html
      VULKAN_HPP_NODISCARD typename ResultValueType<ExternalComputeQueueNV>::type
        createExternalComputeQueueNV( ExternalComputeQueueCreateInfoNV const & createInfo,
                                      Optional<const AllocationCallbacks>      allocator = nullptr ) const VULKAN_HPP_NOEXCEPT_WHEN_NO_EXCEPTIONS;

      //=== VK_NV_cluster_acceleration_structure ===

      // wrapper function for command vkGetClusterAccelerationStructureBuildSizesNV, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetClusterAccelerationStructureBuildSizesNV.html
      VULKAN_HPP_NODISCARD AccelerationStructureBuildSizesInfoKHR
        getClusterAccelerationStructureBuildSizesNV( const ClusterAccelerationStructureInputInfoNV & info ) const VULKAN_HPP_NOEXCEPT;

      //=== VK_NV_partitioned_acceleration_structure ===

      // wrapper function for command vkGetPartitionedAccelerationStructuresBuildSizesNV, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetPartitionedAccelerationStructuresBuildSizesNV.html
      VULKAN_HPP_NODISCARD AccelerationStructureBuildSizesInfoKHR
        getPartitionedAccelerationStructuresBuildSizesNV( const PartitionedAccelerationStructureInstancesInputNV & info ) const VULKAN_HPP_NOEXCEPT;

      //=== VK_EXT_device_generated_commands ===

      // wrapper function for command vkGetGeneratedCommandsMemoryRequirementsEXT, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetGeneratedCommandsMemoryRequirementsEXT.html
      VULKAN_HPP_NODISCARD MemoryRequirements2
        getGeneratedCommandsMemoryRequirementsEXT( const GeneratedCommandsMemoryRequirementsInfoEXT & info ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkGetGeneratedCommandsMemoryRequirementsEXT, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetGeneratedCommandsMemoryRequirementsEXT.html
      template <typename X, typename Y, typename... Z>
      VULKAN_HPP_NODISCARD StructureChain<X, Y, Z...>
                           getGeneratedCommandsMemoryRequirementsEXT( const GeneratedCommandsMemoryRequirementsInfoEXT & info ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkCreateIndirectCommandsLayoutEXT, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateIndirectCommandsLayoutEXT.html
      VULKAN_HPP_NODISCARD typename ResultValueType<IndirectCommandsLayoutEXT>::type
        createIndirectCommandsLayoutEXT( IndirectCommandsLayoutCreateInfoEXT const & createInfo,
                                         Optional<const AllocationCallbacks>         allocator = nullptr ) const VULKAN_HPP_NOEXCEPT_WHEN_NO_EXCEPTIONS;

      // wrapper function for command vkCreateIndirectExecutionSetEXT, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateIndirectExecutionSetEXT.html
      VULKAN_HPP_NODISCARD typename ResultValueType<IndirectExecutionSetEXT>::type
        createIndirectExecutionSetEXT( IndirectExecutionSetCreateInfoEXT const & createInfo,
                                       Optional<const AllocationCallbacks>       allocator = nullptr ) const VULKAN_HPP_NOEXCEPT_WHEN_NO_EXCEPTIONS;

#  if defined( VK_USE_PLATFORM_OHOS )
      //=== VK_OHOS_native_buffer ===

      // wrapper function for command vkGetSwapchainGrallocUsageOHOS, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetSwapchainGrallocUsageOHOS.html
      VULKAN_HPP_NODISCARD typename ResultValueType<uint64_t>::type getSwapchainGrallocUsageOHOS( Format format, ImageUsageFlags imageUsage ) const;
#  endif /*VK_USE_PLATFORM_OHOS*/

#  if defined( VK_USE_PLATFORM_METAL_EXT )
      //=== VK_EXT_external_memory_metal ===

      // wrapper function for command vkGetMemoryMetalHandleEXT, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetMemoryMetalHandleEXT.html
      VULKAN_HPP_NODISCARD typename ResultValueType<void *>::type getMemoryMetalHandleEXT( const MemoryGetMetalHandleInfoEXT & getMetalHandleInfo ) const;

      // wrapper function for command vkGetMemoryMetalHandlePropertiesEXT, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetMemoryMetalHandlePropertiesEXT.html
      template <typename HandleType>
      VULKAN_HPP_NODISCARD typename ResultValueType<MemoryMetalHandlePropertiesEXT>::type
        getMemoryMetalHandlePropertiesEXT( ExternalMemoryHandleTypeFlagBits handleType, HandleType const & handle ) const;
#  endif /*VK_USE_PLATFORM_METAL_EXT*/

    private:
      VULKAN_HPP_NAMESPACE::Device              m_device    = {};
      const AllocationCallbacks *               m_allocator = {};
      std::unique_ptr<detail::DeviceDispatcher> m_dispatcher;
    };

    template <>
    struct isVulkanRAIIHandleType<Device>
    {
      static VULKAN_HPP_CONST_OR_CONSTEXPR bool value = true;
    };

    // wrapper class for handle VkAccelerationStructureKHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkAccelerationStructureKHR.html
    class AccelerationStructureKHR
    {
    public:
      using CType   = VkAccelerationStructureKHR;
      using CppType = VULKAN_HPP_NAMESPACE::AccelerationStructureKHR;

      static VULKAN_HPP_CONST_OR_CONSTEXPR ObjectType               objectType            = ObjectType::eAccelerationStructureKHR;
      static VULKAN_HPP_CONST_OR_CONSTEXPR DebugReportObjectTypeEXT debugReportObjectType = DebugReportObjectTypeEXT::eAccelerationStructureKHR;

    public:
#  if !defined( VULKAN_HPP_NO_EXCEPTIONS )
      AccelerationStructureKHR( Device const &                             device,
                                AccelerationStructureCreateInfoKHR const & createInfo,
                                Optional<const AllocationCallbacks>        allocator = nullptr )
      {
        *this = device.createAccelerationStructureKHR( createInfo, allocator );
      }
#  endif

      AccelerationStructureKHR( Device const &                      device,
                                VkAccelerationStructureKHR          accelerationStructure,
                                Optional<const AllocationCallbacks> allocator = nullptr )
        : m_device( device )
        , m_accelerationStructureKHR( accelerationStructure )
        , m_allocator( static_cast<const AllocationCallbacks *>( allocator ) )
        , m_dispatcher( device.getDispatcher() )
      {
      }

      AccelerationStructureKHR( std::nullptr_t ) {}

      ~AccelerationStructureKHR()
      {
        clear();
      }

      AccelerationStructureKHR()                                   = delete;
      AccelerationStructureKHR( AccelerationStructureKHR const & ) = delete;

      AccelerationStructureKHR( AccelerationStructureKHR && rhs ) VULKAN_HPP_NOEXCEPT
        : m_device( exchange( rhs.m_device, {} ) )
        , m_accelerationStructureKHR( exchange( rhs.m_accelerationStructureKHR, {} ) )
        , m_allocator( exchange( rhs.m_allocator, {} ) )
        , m_dispatcher( exchange( rhs.m_dispatcher, nullptr ) )
      {
      }

      AccelerationStructureKHR & operator=( AccelerationStructureKHR const & ) = delete;

      AccelerationStructureKHR & operator=( AccelerationStructureKHR && rhs ) VULKAN_HPP_NOEXCEPT
      {
        if ( this != &rhs )
        {
          std::swap( m_device, rhs.m_device );
          std::swap( m_accelerationStructureKHR, rhs.m_accelerationStructureKHR );
          std::swap( m_allocator, rhs.m_allocator );
          std::swap( m_dispatcher, rhs.m_dispatcher );
        }
        return *this;
      }

      VULKAN_HPP_NAMESPACE::AccelerationStructureKHR const & operator*() const & VULKAN_HPP_NOEXCEPT
      {
        return m_accelerationStructureKHR;
      }

      VULKAN_HPP_NAMESPACE::AccelerationStructureKHR const && operator*() const && VULKAN_HPP_NOEXCEPT
      {
        return std::move( m_accelerationStructureKHR );
      }

      operator VULKAN_HPP_NAMESPACE::AccelerationStructureKHR() const VULKAN_HPP_NOEXCEPT
      {
        return m_accelerationStructureKHR;
      }

      void clear() VULKAN_HPP_NOEXCEPT
      {
        if ( m_accelerationStructureKHR )
        {
          getDispatcher()->vkDestroyAccelerationStructureKHR( static_cast<VkDevice>( m_device ),
                                                              static_cast<VkAccelerationStructureKHR>( m_accelerationStructureKHR ),
                                                              reinterpret_cast<const VkAllocationCallbacks *>( m_allocator ) );
        }
        m_device                   = nullptr;
        m_accelerationStructureKHR = nullptr;
        m_allocator                = nullptr;
        m_dispatcher               = nullptr;
      }

      VULKAN_HPP_NAMESPACE::AccelerationStructureKHR release()
      {
        m_device     = nullptr;
        m_allocator  = nullptr;
        m_dispatcher = nullptr;
        return exchange( m_accelerationStructureKHR, nullptr );
      }

      VULKAN_HPP_NAMESPACE::Device getDevice() const
      {
        return m_device;
      }

      detail::DeviceDispatcher const * getDispatcher() const
      {
        VULKAN_HPP_ASSERT( m_dispatcher->getVkHeaderVersion() == VK_HEADER_VERSION );
        return m_dispatcher;
      }

      void swap( AccelerationStructureKHR & rhs ) VULKAN_HPP_NOEXCEPT
      {
        std::swap( m_device, rhs.m_device );
        std::swap( m_accelerationStructureKHR, rhs.m_accelerationStructureKHR );
        std::swap( m_allocator, rhs.m_allocator );
        std::swap( m_dispatcher, rhs.m_dispatcher );
      }

    private:
      VULKAN_HPP_NAMESPACE::Device                   m_device                   = {};
      VULKAN_HPP_NAMESPACE::AccelerationStructureKHR m_accelerationStructureKHR = {};
      const AllocationCallbacks *                    m_allocator                = {};
      detail::DeviceDispatcher const *               m_dispatcher               = nullptr;
    };

    template <>
    struct isVulkanRAIIHandleType<AccelerationStructureKHR>
    {
      static VULKAN_HPP_CONST_OR_CONSTEXPR bool value = true;
    };

    // wrapper class for handle VkAccelerationStructureNV, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkAccelerationStructureNV.html
    class AccelerationStructureNV
    {
    public:
      using CType   = VkAccelerationStructureNV;
      using CppType = VULKAN_HPP_NAMESPACE::AccelerationStructureNV;

      static VULKAN_HPP_CONST_OR_CONSTEXPR ObjectType               objectType            = ObjectType::eAccelerationStructureNV;
      static VULKAN_HPP_CONST_OR_CONSTEXPR DebugReportObjectTypeEXT debugReportObjectType = DebugReportObjectTypeEXT::eAccelerationStructureNV;

    public:
#  if !defined( VULKAN_HPP_NO_EXCEPTIONS )
      AccelerationStructureNV( Device const &                            device,
                               AccelerationStructureCreateInfoNV const & createInfo,
                               Optional<const AllocationCallbacks>       allocator = nullptr )
      {
        *this = device.createAccelerationStructureNV( createInfo, allocator );
      }
#  endif

      AccelerationStructureNV( Device const & device, VkAccelerationStructureNV accelerationStructure, Optional<const AllocationCallbacks> allocator = nullptr )
        : m_device( device )
        , m_accelerationStructureNV( accelerationStructure )
        , m_allocator( static_cast<const AllocationCallbacks *>( allocator ) )
        , m_dispatcher( device.getDispatcher() )
      {
      }

      AccelerationStructureNV( std::nullptr_t ) {}

      ~AccelerationStructureNV()
      {
        clear();
      }

      AccelerationStructureNV()                                  = delete;
      AccelerationStructureNV( AccelerationStructureNV const & ) = delete;

      AccelerationStructureNV( AccelerationStructureNV && rhs ) VULKAN_HPP_NOEXCEPT
        : m_device( exchange( rhs.m_device, {} ) )
        , m_accelerationStructureNV( exchange( rhs.m_accelerationStructureNV, {} ) )
        , m_allocator( exchange( rhs.m_allocator, {} ) )
        , m_dispatcher( exchange( rhs.m_dispatcher, nullptr ) )
      {
      }

      AccelerationStructureNV & operator=( AccelerationStructureNV const & ) = delete;

      AccelerationStructureNV & operator=( AccelerationStructureNV && rhs ) VULKAN_HPP_NOEXCEPT
      {
        if ( this != &rhs )
        {
          std::swap( m_device, rhs.m_device );
          std::swap( m_accelerationStructureNV, rhs.m_accelerationStructureNV );
          std::swap( m_allocator, rhs.m_allocator );
          std::swap( m_dispatcher, rhs.m_dispatcher );
        }
        return *this;
      }

      VULKAN_HPP_NAMESPACE::AccelerationStructureNV const & operator*() const & VULKAN_HPP_NOEXCEPT
      {
        return m_accelerationStructureNV;
      }

      VULKAN_HPP_NAMESPACE::AccelerationStructureNV const && operator*() const && VULKAN_HPP_NOEXCEPT
      {
        return std::move( m_accelerationStructureNV );
      }

      operator VULKAN_HPP_NAMESPACE::AccelerationStructureNV() const VULKAN_HPP_NOEXCEPT
      {
        return m_accelerationStructureNV;
      }

      void clear() VULKAN_HPP_NOEXCEPT
      {
        if ( m_accelerationStructureNV )
        {
          getDispatcher()->vkDestroyAccelerationStructureNV( static_cast<VkDevice>( m_device ),
                                                             static_cast<VkAccelerationStructureNV>( m_accelerationStructureNV ),
                                                             reinterpret_cast<const VkAllocationCallbacks *>( m_allocator ) );
        }
        m_device                  = nullptr;
        m_accelerationStructureNV = nullptr;
        m_allocator               = nullptr;
        m_dispatcher              = nullptr;
      }

      VULKAN_HPP_NAMESPACE::AccelerationStructureNV release()
      {
        m_device     = nullptr;
        m_allocator  = nullptr;
        m_dispatcher = nullptr;
        return exchange( m_accelerationStructureNV, nullptr );
      }

      VULKAN_HPP_NAMESPACE::Device getDevice() const
      {
        return m_device;
      }

      detail::DeviceDispatcher const * getDispatcher() const
      {
        VULKAN_HPP_ASSERT( m_dispatcher->getVkHeaderVersion() == VK_HEADER_VERSION );
        return m_dispatcher;
      }

      void swap( AccelerationStructureNV & rhs ) VULKAN_HPP_NOEXCEPT
      {
        std::swap( m_device, rhs.m_device );
        std::swap( m_accelerationStructureNV, rhs.m_accelerationStructureNV );
        std::swap( m_allocator, rhs.m_allocator );
        std::swap( m_dispatcher, rhs.m_dispatcher );
      }

      //=== VK_NV_ray_tracing ===

      // wrapper function for command vkGetAccelerationStructureHandleNV, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetAccelerationStructureHandleNV.html
      template <typename DataType>
      VULKAN_HPP_NODISCARD typename ResultValueType<std::vector<DataType>>::type getHandle( size_t dataSize ) const;

      // wrapper function for command vkGetAccelerationStructureHandleNV, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetAccelerationStructureHandleNV.html
      template <typename DataType>
      VULKAN_HPP_NODISCARD typename ResultValueType<DataType>::type getHandle() const;

    private:
      VULKAN_HPP_NAMESPACE::Device                  m_device                  = {};
      VULKAN_HPP_NAMESPACE::AccelerationStructureNV m_accelerationStructureNV = {};
      const AllocationCallbacks *                   m_allocator               = {};
      detail::DeviceDispatcher const *              m_dispatcher              = nullptr;
    };

    template <>
    struct isVulkanRAIIHandleType<AccelerationStructureNV>
    {
      static VULKAN_HPP_CONST_OR_CONSTEXPR bool value = true;
    };

    // wrapper class for handle VkBuffer, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkBuffer.html
    class Buffer
    {
    public:
      using CType   = VkBuffer;
      using CppType = VULKAN_HPP_NAMESPACE::Buffer;

      static VULKAN_HPP_CONST_OR_CONSTEXPR ObjectType               objectType            = ObjectType::eBuffer;
      static VULKAN_HPP_CONST_OR_CONSTEXPR DebugReportObjectTypeEXT debugReportObjectType = DebugReportObjectTypeEXT::eBuffer;

    public:
#  if !defined( VULKAN_HPP_NO_EXCEPTIONS )
      Buffer( Device const & device, BufferCreateInfo const & createInfo, Optional<const AllocationCallbacks> allocator = nullptr )
      {
        *this = device.createBuffer( createInfo, allocator );
      }
#  endif

      Buffer( Device const & device, VkBuffer buffer, Optional<const AllocationCallbacks> allocator = nullptr )
        : m_device( device ), m_buffer( buffer ), m_allocator( static_cast<const AllocationCallbacks *>( allocator ) ), m_dispatcher( device.getDispatcher() )
      {
      }

      Buffer( std::nullptr_t ) {}

      ~Buffer()
      {
        clear();
      }

      Buffer()                 = delete;
      Buffer( Buffer const & ) = delete;

      Buffer( Buffer && rhs ) VULKAN_HPP_NOEXCEPT
        : m_device( exchange( rhs.m_device, {} ) )
        , m_buffer( exchange( rhs.m_buffer, {} ) )
        , m_allocator( exchange( rhs.m_allocator, {} ) )
        , m_dispatcher( exchange( rhs.m_dispatcher, nullptr ) )
      {
      }

      Buffer & operator=( Buffer const & ) = delete;

      Buffer & operator=( Buffer && rhs ) VULKAN_HPP_NOEXCEPT
      {
        if ( this != &rhs )
        {
          std::swap( m_device, rhs.m_device );
          std::swap( m_buffer, rhs.m_buffer );
          std::swap( m_allocator, rhs.m_allocator );
          std::swap( m_dispatcher, rhs.m_dispatcher );
        }
        return *this;
      }

      VULKAN_HPP_NAMESPACE::Buffer const & operator*() const & VULKAN_HPP_NOEXCEPT
      {
        return m_buffer;
      }

      VULKAN_HPP_NAMESPACE::Buffer const && operator*() const && VULKAN_HPP_NOEXCEPT
      {
        return std::move( m_buffer );
      }

      operator VULKAN_HPP_NAMESPACE::Buffer() const VULKAN_HPP_NOEXCEPT
      {
        return m_buffer;
      }

      void clear() VULKAN_HPP_NOEXCEPT
      {
        if ( m_buffer )
        {
          getDispatcher()->vkDestroyBuffer(
            static_cast<VkDevice>( m_device ), static_cast<VkBuffer>( m_buffer ), reinterpret_cast<const VkAllocationCallbacks *>( m_allocator ) );
        }
        m_device     = nullptr;
        m_buffer     = nullptr;
        m_allocator  = nullptr;
        m_dispatcher = nullptr;
      }

      VULKAN_HPP_NAMESPACE::Buffer release()
      {
        m_device     = nullptr;
        m_allocator  = nullptr;
        m_dispatcher = nullptr;
        return exchange( m_buffer, nullptr );
      }

      VULKAN_HPP_NAMESPACE::Device getDevice() const
      {
        return m_device;
      }

      detail::DeviceDispatcher const * getDispatcher() const
      {
        VULKAN_HPP_ASSERT( m_dispatcher->getVkHeaderVersion() == VK_HEADER_VERSION );
        return m_dispatcher;
      }

      void swap( Buffer & rhs ) VULKAN_HPP_NOEXCEPT
      {
        std::swap( m_device, rhs.m_device );
        std::swap( m_buffer, rhs.m_buffer );
        std::swap( m_allocator, rhs.m_allocator );
        std::swap( m_dispatcher, rhs.m_dispatcher );
      }

      //=== VK_VERSION_1_0 ===

      // wrapper function for command vkBindBufferMemory, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkBindBufferMemory.html
      typename ResultValueType<void>::type bindMemory( VULKAN_HPP_NAMESPACE::DeviceMemory memory, DeviceSize memoryOffset ) const;

      // wrapper function for command vkGetBufferMemoryRequirements, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetBufferMemoryRequirements.html
      VULKAN_HPP_NODISCARD MemoryRequirements getMemoryRequirements() const VULKAN_HPP_NOEXCEPT;

    protected:
      Buffer( VULKAN_HPP_NAMESPACE::Device     device,
              VULKAN_HPP_NAMESPACE::Buffer     buffer,
              const AllocationCallbacks *      allocator,
              detail::DeviceDispatcher const * dispatcher ) VULKAN_HPP_NOEXCEPT
        : m_device( exchange( device, {} ) )
        , m_buffer( exchange( buffer, {} ) )
        , m_allocator( exchange( allocator, {} ) )
        , m_dispatcher( exchange( dispatcher, nullptr ) )
      {
      }

    private:
      VULKAN_HPP_NAMESPACE::Device     m_device     = {};
      VULKAN_HPP_NAMESPACE::Buffer     m_buffer     = {};
      const AllocationCallbacks *      m_allocator  = {};
      detail::DeviceDispatcher const * m_dispatcher = nullptr;
    };

    template <>
    struct isVulkanRAIIHandleType<Buffer>
    {
      static VULKAN_HPP_CONST_OR_CONSTEXPR bool value = true;
    };

    // wrapper class for handle VkBufferCollectionFUCHSIA, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkBufferCollectionFUCHSIA.html
#  if defined( VK_USE_PLATFORM_FUCHSIA )
    class BufferCollectionFUCHSIA
    {
    public:
      using CType   = VkBufferCollectionFUCHSIA;
      using CppType = VULKAN_HPP_NAMESPACE::BufferCollectionFUCHSIA;

      static VULKAN_HPP_CONST_OR_CONSTEXPR ObjectType               objectType            = ObjectType::eBufferCollectionFUCHSIA;
      static VULKAN_HPP_CONST_OR_CONSTEXPR DebugReportObjectTypeEXT debugReportObjectType = DebugReportObjectTypeEXT::eBufferCollectionFUCHSIA;

    public:
#    if !defined( VULKAN_HPP_NO_EXCEPTIONS )
      BufferCollectionFUCHSIA( Device const &                            device,
                               BufferCollectionCreateInfoFUCHSIA const & createInfo,
                               Optional<const AllocationCallbacks>       allocator = nullptr )
      {
        *this = device.createBufferCollectionFUCHSIA( createInfo, allocator );
      }
#    endif

      BufferCollectionFUCHSIA( Device const & device, VkBufferCollectionFUCHSIA collection, Optional<const AllocationCallbacks> allocator = nullptr )
        : m_device( device )
        , m_bufferCollectionFUCHSIA( collection )
        , m_allocator( static_cast<const AllocationCallbacks *>( allocator ) )
        , m_dispatcher( device.getDispatcher() )
      {
      }

      BufferCollectionFUCHSIA( std::nullptr_t ) {}

      ~BufferCollectionFUCHSIA()
      {
        clear();
      }

      BufferCollectionFUCHSIA()                                  = delete;
      BufferCollectionFUCHSIA( BufferCollectionFUCHSIA const & ) = delete;

      BufferCollectionFUCHSIA( BufferCollectionFUCHSIA && rhs ) VULKAN_HPP_NOEXCEPT
        : m_device( exchange( rhs.m_device, {} ) )
        , m_bufferCollectionFUCHSIA( exchange( rhs.m_bufferCollectionFUCHSIA, {} ) )
        , m_allocator( exchange( rhs.m_allocator, {} ) )
        , m_dispatcher( exchange( rhs.m_dispatcher, nullptr ) )
      {
      }

      BufferCollectionFUCHSIA & operator=( BufferCollectionFUCHSIA const & ) = delete;

      BufferCollectionFUCHSIA & operator=( BufferCollectionFUCHSIA && rhs ) VULKAN_HPP_NOEXCEPT
      {
        if ( this != &rhs )
        {
          std::swap( m_device, rhs.m_device );
          std::swap( m_bufferCollectionFUCHSIA, rhs.m_bufferCollectionFUCHSIA );
          std::swap( m_allocator, rhs.m_allocator );
          std::swap( m_dispatcher, rhs.m_dispatcher );
        }
        return *this;
      }

      VULKAN_HPP_NAMESPACE::BufferCollectionFUCHSIA const & operator*() const & VULKAN_HPP_NOEXCEPT
      {
        return m_bufferCollectionFUCHSIA;
      }

      VULKAN_HPP_NAMESPACE::BufferCollectionFUCHSIA const && operator*() const && VULKAN_HPP_NOEXCEPT
      {
        return std::move( m_bufferCollectionFUCHSIA );
      }

      operator VULKAN_HPP_NAMESPACE::BufferCollectionFUCHSIA() const VULKAN_HPP_NOEXCEPT
      {
        return m_bufferCollectionFUCHSIA;
      }

      void clear() VULKAN_HPP_NOEXCEPT
      {
        if ( m_bufferCollectionFUCHSIA )
        {
          getDispatcher()->vkDestroyBufferCollectionFUCHSIA( static_cast<VkDevice>( m_device ),
                                                             static_cast<VkBufferCollectionFUCHSIA>( m_bufferCollectionFUCHSIA ),
                                                             reinterpret_cast<const VkAllocationCallbacks *>( m_allocator ) );
        }
        m_device                  = nullptr;
        m_bufferCollectionFUCHSIA = nullptr;
        m_allocator               = nullptr;
        m_dispatcher              = nullptr;
      }

      VULKAN_HPP_NAMESPACE::BufferCollectionFUCHSIA release()
      {
        m_device     = nullptr;
        m_allocator  = nullptr;
        m_dispatcher = nullptr;
        return exchange( m_bufferCollectionFUCHSIA, nullptr );
      }

      VULKAN_HPP_NAMESPACE::Device getDevice() const
      {
        return m_device;
      }

      detail::DeviceDispatcher const * getDispatcher() const
      {
        VULKAN_HPP_ASSERT( m_dispatcher->getVkHeaderVersion() == VK_HEADER_VERSION );
        return m_dispatcher;
      }

      void swap( BufferCollectionFUCHSIA & rhs ) VULKAN_HPP_NOEXCEPT
      {
        std::swap( m_device, rhs.m_device );
        std::swap( m_bufferCollectionFUCHSIA, rhs.m_bufferCollectionFUCHSIA );
        std::swap( m_allocator, rhs.m_allocator );
        std::swap( m_dispatcher, rhs.m_dispatcher );
      }

      //=== VK_FUCHSIA_buffer_collection ===

      // wrapper function for command vkSetBufferCollectionImageConstraintsFUCHSIA, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkSetBufferCollectionImageConstraintsFUCHSIA.html
      typename ResultValueType<void>::type setImageConstraints( const ImageConstraintsInfoFUCHSIA & imageConstraintsInfo ) const;

      // wrapper function for command vkSetBufferCollectionBufferConstraintsFUCHSIA, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkSetBufferCollectionBufferConstraintsFUCHSIA.html
      typename ResultValueType<void>::type setBufferConstraints( const BufferConstraintsInfoFUCHSIA & bufferConstraintsInfo ) const;

      // wrapper function for command vkGetBufferCollectionPropertiesFUCHSIA, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetBufferCollectionPropertiesFUCHSIA.html
      VULKAN_HPP_NODISCARD typename ResultValueType<BufferCollectionPropertiesFUCHSIA>::type getProperties() const;

    private:
      VULKAN_HPP_NAMESPACE::Device                  m_device                  = {};
      VULKAN_HPP_NAMESPACE::BufferCollectionFUCHSIA m_bufferCollectionFUCHSIA = {};
      const AllocationCallbacks *                   m_allocator               = {};
      detail::DeviceDispatcher const *              m_dispatcher              = nullptr;
    };

    template <>
    struct isVulkanRAIIHandleType<BufferCollectionFUCHSIA>
    {
      static VULKAN_HPP_CONST_OR_CONSTEXPR bool value = true;
    };

#  endif /*VK_USE_PLATFORM_FUCHSIA*/

    // wrapper class for handle VkBufferView, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkBufferView.html
    class BufferView
    {
    public:
      using CType   = VkBufferView;
      using CppType = VULKAN_HPP_NAMESPACE::BufferView;

      static VULKAN_HPP_CONST_OR_CONSTEXPR ObjectType               objectType            = ObjectType::eBufferView;
      static VULKAN_HPP_CONST_OR_CONSTEXPR DebugReportObjectTypeEXT debugReportObjectType = DebugReportObjectTypeEXT::eBufferView;

    public:
#  if !defined( VULKAN_HPP_NO_EXCEPTIONS )
      BufferView( Device const & device, BufferViewCreateInfo const & createInfo, Optional<const AllocationCallbacks> allocator = nullptr )
      {
        *this = device.createBufferView( createInfo, allocator );
      }
#  endif

      BufferView( Device const & device, VkBufferView bufferView, Optional<const AllocationCallbacks> allocator = nullptr )
        : m_device( device )
        , m_bufferView( bufferView )
        , m_allocator( static_cast<const AllocationCallbacks *>( allocator ) )
        , m_dispatcher( device.getDispatcher() )
      {
      }

      BufferView( std::nullptr_t ) {}

      ~BufferView()
      {
        clear();
      }

      BufferView()                     = delete;
      BufferView( BufferView const & ) = delete;

      BufferView( BufferView && rhs ) VULKAN_HPP_NOEXCEPT
        : m_device( exchange( rhs.m_device, {} ) )
        , m_bufferView( exchange( rhs.m_bufferView, {} ) )
        , m_allocator( exchange( rhs.m_allocator, {} ) )
        , m_dispatcher( exchange( rhs.m_dispatcher, nullptr ) )
      {
      }

      BufferView & operator=( BufferView const & ) = delete;

      BufferView & operator=( BufferView && rhs ) VULKAN_HPP_NOEXCEPT
      {
        if ( this != &rhs )
        {
          std::swap( m_device, rhs.m_device );
          std::swap( m_bufferView, rhs.m_bufferView );
          std::swap( m_allocator, rhs.m_allocator );
          std::swap( m_dispatcher, rhs.m_dispatcher );
        }
        return *this;
      }

      VULKAN_HPP_NAMESPACE::BufferView const & operator*() const & VULKAN_HPP_NOEXCEPT
      {
        return m_bufferView;
      }

      VULKAN_HPP_NAMESPACE::BufferView const && operator*() const && VULKAN_HPP_NOEXCEPT
      {
        return std::move( m_bufferView );
      }

      operator VULKAN_HPP_NAMESPACE::BufferView() const VULKAN_HPP_NOEXCEPT
      {
        return m_bufferView;
      }

      void clear() VULKAN_HPP_NOEXCEPT
      {
        if ( m_bufferView )
        {
          getDispatcher()->vkDestroyBufferView(
            static_cast<VkDevice>( m_device ), static_cast<VkBufferView>( m_bufferView ), reinterpret_cast<const VkAllocationCallbacks *>( m_allocator ) );
        }
        m_device     = nullptr;
        m_bufferView = nullptr;
        m_allocator  = nullptr;
        m_dispatcher = nullptr;
      }

      VULKAN_HPP_NAMESPACE::BufferView release()
      {
        m_device     = nullptr;
        m_allocator  = nullptr;
        m_dispatcher = nullptr;
        return exchange( m_bufferView, nullptr );
      }

      VULKAN_HPP_NAMESPACE::Device getDevice() const
      {
        return m_device;
      }

      detail::DeviceDispatcher const * getDispatcher() const
      {
        VULKAN_HPP_ASSERT( m_dispatcher->getVkHeaderVersion() == VK_HEADER_VERSION );
        return m_dispatcher;
      }

      void swap( BufferView & rhs ) VULKAN_HPP_NOEXCEPT
      {
        std::swap( m_device, rhs.m_device );
        std::swap( m_bufferView, rhs.m_bufferView );
        std::swap( m_allocator, rhs.m_allocator );
        std::swap( m_dispatcher, rhs.m_dispatcher );
      }

    private:
      VULKAN_HPP_NAMESPACE::Device     m_device     = {};
      VULKAN_HPP_NAMESPACE::BufferView m_bufferView = {};
      const AllocationCallbacks *      m_allocator  = {};
      detail::DeviceDispatcher const * m_dispatcher = nullptr;
    };

    template <>
    struct isVulkanRAIIHandleType<BufferView>
    {
      static VULKAN_HPP_CONST_OR_CONSTEXPR bool value = true;
    };

    // wrapper class for handle VkCommandPool, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkCommandPool.html
    class CommandPool
    {
    public:
      using CType   = VkCommandPool;
      using CppType = VULKAN_HPP_NAMESPACE::CommandPool;

      static VULKAN_HPP_CONST_OR_CONSTEXPR ObjectType               objectType            = ObjectType::eCommandPool;
      static VULKAN_HPP_CONST_OR_CONSTEXPR DebugReportObjectTypeEXT debugReportObjectType = DebugReportObjectTypeEXT::eCommandPool;

    public:
#  if !defined( VULKAN_HPP_NO_EXCEPTIONS )
      CommandPool( Device const & device, CommandPoolCreateInfo const & createInfo, Optional<const AllocationCallbacks> allocator = nullptr )
      {
        *this = device.createCommandPool( createInfo, allocator );
      }
#  endif

      CommandPool( Device const & device, VkCommandPool commandPool, Optional<const AllocationCallbacks> allocator = nullptr )
        : m_device( device )
        , m_commandPool( commandPool )
        , m_allocator( static_cast<const AllocationCallbacks *>( allocator ) )
        , m_dispatcher( device.getDispatcher() )
      {
      }

      CommandPool( std::nullptr_t ) {}

      ~CommandPool()
      {
        clear();
      }

      CommandPool()                      = delete;
      CommandPool( CommandPool const & ) = delete;

      CommandPool( CommandPool && rhs ) VULKAN_HPP_NOEXCEPT
        : m_device( exchange( rhs.m_device, {} ) )
        , m_commandPool( exchange( rhs.m_commandPool, {} ) )
        , m_allocator( exchange( rhs.m_allocator, {} ) )
        , m_dispatcher( exchange( rhs.m_dispatcher, nullptr ) )
      {
      }

      CommandPool & operator=( CommandPool const & ) = delete;

      CommandPool & operator=( CommandPool && rhs ) VULKAN_HPP_NOEXCEPT
      {
        if ( this != &rhs )
        {
          std::swap( m_device, rhs.m_device );
          std::swap( m_commandPool, rhs.m_commandPool );
          std::swap( m_allocator, rhs.m_allocator );
          std::swap( m_dispatcher, rhs.m_dispatcher );
        }
        return *this;
      }

      VULKAN_HPP_NAMESPACE::CommandPool const & operator*() const & VULKAN_HPP_NOEXCEPT
      {
        return m_commandPool;
      }

      VULKAN_HPP_NAMESPACE::CommandPool const && operator*() const && VULKAN_HPP_NOEXCEPT
      {
        return std::move( m_commandPool );
      }

      operator VULKAN_HPP_NAMESPACE::CommandPool() const VULKAN_HPP_NOEXCEPT
      {
        return m_commandPool;
      }

      void clear() VULKAN_HPP_NOEXCEPT
      {
        if ( m_commandPool )
        {
          getDispatcher()->vkDestroyCommandPool(
            static_cast<VkDevice>( m_device ), static_cast<VkCommandPool>( m_commandPool ), reinterpret_cast<const VkAllocationCallbacks *>( m_allocator ) );
        }
        m_device      = nullptr;
        m_commandPool = nullptr;
        m_allocator   = nullptr;
        m_dispatcher  = nullptr;
      }

      VULKAN_HPP_NAMESPACE::CommandPool release()
      {
        m_device     = nullptr;
        m_allocator  = nullptr;
        m_dispatcher = nullptr;
        return exchange( m_commandPool, nullptr );
      }

      VULKAN_HPP_NAMESPACE::Device getDevice() const
      {
        return m_device;
      }

      detail::DeviceDispatcher const * getDispatcher() const
      {
        VULKAN_HPP_ASSERT( m_dispatcher->getVkHeaderVersion() == VK_HEADER_VERSION );
        return m_dispatcher;
      }

      void swap( CommandPool & rhs ) VULKAN_HPP_NOEXCEPT
      {
        std::swap( m_device, rhs.m_device );
        std::swap( m_commandPool, rhs.m_commandPool );
        std::swap( m_allocator, rhs.m_allocator );
        std::swap( m_dispatcher, rhs.m_dispatcher );
      }

      //=== VK_VERSION_1_0 ===

      // wrapper function for command vkResetCommandPool, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkResetCommandPool.html
      typename ResultValueType<void>::type reset( CommandPoolResetFlags flags VULKAN_HPP_DEFAULT_ASSIGNMENT( {} ) ) const;

      //=== VK_VERSION_1_1 ===

      // wrapper function for command vkTrimCommandPool, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkTrimCommandPool.html
      void trim( CommandPoolTrimFlags flags VULKAN_HPP_DEFAULT_ASSIGNMENT( {} ) ) const VULKAN_HPP_NOEXCEPT;

      //=== VK_KHR_maintenance1 ===

      // wrapper function for command vkTrimCommandPoolKHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkTrimCommandPoolKHR.html
      void trimKHR( CommandPoolTrimFlags flags VULKAN_HPP_DEFAULT_ASSIGNMENT( {} ) ) const VULKAN_HPP_NOEXCEPT;

    private:
      VULKAN_HPP_NAMESPACE::Device      m_device      = {};
      VULKAN_HPP_NAMESPACE::CommandPool m_commandPool = {};
      const AllocationCallbacks *       m_allocator   = {};
      detail::DeviceDispatcher const *  m_dispatcher  = nullptr;
    };

    template <>
    struct isVulkanRAIIHandleType<CommandPool>
    {
      static VULKAN_HPP_CONST_OR_CONSTEXPR bool value = true;
    };

    // wrapper class for handle VkCommandBuffer, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkCommandBuffer.html
    class CommandBuffer
    {
    public:
      using CType   = VkCommandBuffer;
      using CppType = VULKAN_HPP_NAMESPACE::CommandBuffer;

      static VULKAN_HPP_CONST_OR_CONSTEXPR ObjectType               objectType            = ObjectType::eCommandBuffer;
      static VULKAN_HPP_CONST_OR_CONSTEXPR DebugReportObjectTypeEXT debugReportObjectType = DebugReportObjectTypeEXT::eCommandBuffer;

    public:
      CommandBuffer( Device const & device, VkCommandBuffer commandBuffer, VkCommandPool commandPool )
        : m_device( device ), m_commandPool( commandPool ), m_commandBuffer( commandBuffer ), m_dispatcher( device.getDispatcher() )
      {
      }

      CommandBuffer( std::nullptr_t ) {}

      ~CommandBuffer()
      {
        clear();
      }

      CommandBuffer()                        = delete;
      CommandBuffer( CommandBuffer const & ) = delete;

      CommandBuffer( CommandBuffer && rhs ) VULKAN_HPP_NOEXCEPT
        : m_device( exchange( rhs.m_device, {} ) )
        , m_commandPool( exchange( rhs.m_commandPool, {} ) )
        , m_commandBuffer( exchange( rhs.m_commandBuffer, {} ) )
        , m_dispatcher( exchange( rhs.m_dispatcher, nullptr ) )
      {
      }

      CommandBuffer & operator=( CommandBuffer const & ) = delete;

      CommandBuffer & operator=( CommandBuffer && rhs ) VULKAN_HPP_NOEXCEPT
      {
        if ( this != &rhs )
        {
          std::swap( m_device, rhs.m_device );
          std::swap( m_commandPool, rhs.m_commandPool );
          std::swap( m_commandBuffer, rhs.m_commandBuffer );
          std::swap( m_dispatcher, rhs.m_dispatcher );
        }
        return *this;
      }

      VULKAN_HPP_NAMESPACE::CommandBuffer const & operator*() const & VULKAN_HPP_NOEXCEPT
      {
        return m_commandBuffer;
      }

      VULKAN_HPP_NAMESPACE::CommandBuffer const && operator*() const && VULKAN_HPP_NOEXCEPT
      {
        return std::move( m_commandBuffer );
      }

      operator VULKAN_HPP_NAMESPACE::CommandBuffer() const VULKAN_HPP_NOEXCEPT
      {
        return m_commandBuffer;
      }

      void clear() VULKAN_HPP_NOEXCEPT
      {
        if ( m_commandBuffer )
        {
          getDispatcher()->vkFreeCommandBuffers(
            static_cast<VkDevice>( m_device ), static_cast<VkCommandPool>( m_commandPool ), 1, reinterpret_cast<VkCommandBuffer const *>( &m_commandBuffer ) );
        }
        m_device        = nullptr;
        m_commandPool   = nullptr;
        m_commandBuffer = nullptr;
        m_dispatcher    = nullptr;
      }

      VULKAN_HPP_NAMESPACE::CommandBuffer release()
      {
        m_device      = nullptr;
        m_commandPool = nullptr;
        m_dispatcher  = nullptr;
        return exchange( m_commandBuffer, nullptr );
      }

      VULKAN_HPP_NAMESPACE::Device getDevice() const
      {
        return m_device;
      }

      detail::DeviceDispatcher const * getDispatcher() const
      {
        VULKAN_HPP_ASSERT( m_dispatcher->getVkHeaderVersion() == VK_HEADER_VERSION );
        return m_dispatcher;
      }

      void swap( CommandBuffer & rhs ) VULKAN_HPP_NOEXCEPT
      {
        std::swap( m_device, rhs.m_device );
        std::swap( m_commandPool, rhs.m_commandPool );
        std::swap( m_commandBuffer, rhs.m_commandBuffer );
        std::swap( m_dispatcher, rhs.m_dispatcher );
      }

      //=== VK_VERSION_1_0 ===

      // wrapper function for command vkBeginCommandBuffer, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkBeginCommandBuffer.html
      typename ResultValueType<void>::type begin( const CommandBufferBeginInfo & beginInfo ) const;

      // wrapper function for command vkEndCommandBuffer, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkEndCommandBuffer.html
      typename ResultValueType<void>::type end() const;

      // wrapper function for command vkResetCommandBuffer, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkResetCommandBuffer.html
      typename ResultValueType<void>::type reset( CommandBufferResetFlags flags VULKAN_HPP_DEFAULT_ASSIGNMENT( {} ) ) const;

      // wrapper function for command vkCmdCopyBuffer, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdCopyBuffer.html
      void copyBuffer( VULKAN_HPP_NAMESPACE::Buffer         srcBuffer,
                       VULKAN_HPP_NAMESPACE::Buffer         dstBuffer,
                       ArrayProxy<const BufferCopy> const & regions ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkCmdCopyImage, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdCopyImage.html
      void copyImage( VULKAN_HPP_NAMESPACE::Image         srcImage,
                      ImageLayout                         srcImageLayout,
                      VULKAN_HPP_NAMESPACE::Image         dstImage,
                      ImageLayout                         dstImageLayout,
                      ArrayProxy<const ImageCopy> const & regions ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkCmdCopyBufferToImage, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdCopyBufferToImage.html
      void copyBufferToImage( VULKAN_HPP_NAMESPACE::Buffer              srcBuffer,
                              VULKAN_HPP_NAMESPACE::Image               dstImage,
                              ImageLayout                               dstImageLayout,
                              ArrayProxy<const BufferImageCopy> const & regions ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkCmdCopyImageToBuffer, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdCopyImageToBuffer.html
      void copyImageToBuffer( VULKAN_HPP_NAMESPACE::Image               srcImage,
                              ImageLayout                               srcImageLayout,
                              VULKAN_HPP_NAMESPACE::Buffer              dstBuffer,
                              ArrayProxy<const BufferImageCopy> const & regions ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkCmdUpdateBuffer, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdUpdateBuffer.html
      template <typename DataType>
      void updateBuffer( VULKAN_HPP_NAMESPACE::Buffer dstBuffer, DeviceSize dstOffset, ArrayProxy<const DataType> const & data ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkCmdFillBuffer, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdFillBuffer.html
      void fillBuffer( VULKAN_HPP_NAMESPACE::Buffer dstBuffer, DeviceSize dstOffset, DeviceSize size, uint32_t data ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkCmdPipelineBarrier, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdPipelineBarrier.html
      void pipelineBarrier( PipelineStageFlags                            srcStageMask,
                            PipelineStageFlags                            dstStageMask,
                            DependencyFlags                               dependencyFlags,
                            ArrayProxy<const MemoryBarrier> const &       memoryBarriers,
                            ArrayProxy<const BufferMemoryBarrier> const & bufferMemoryBarriers,
                            ArrayProxy<const ImageMemoryBarrier> const &  imageMemoryBarriers ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkCmdBeginQuery, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdBeginQuery.html
      void beginQuery( VULKAN_HPP_NAMESPACE::QueryPool queryPool,
                       uint32_t                        query,
                       QueryControlFlags flags         VULKAN_HPP_DEFAULT_ASSIGNMENT( {} ) ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkCmdEndQuery, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdEndQuery.html
      void endQuery( VULKAN_HPP_NAMESPACE::QueryPool queryPool, uint32_t query ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkCmdResetQueryPool, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdResetQueryPool.html
      void resetQueryPool( VULKAN_HPP_NAMESPACE::QueryPool queryPool, uint32_t firstQuery, uint32_t queryCount ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkCmdWriteTimestamp, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdWriteTimestamp.html
      void writeTimestamp( PipelineStageFlagBits pipelineStage, VULKAN_HPP_NAMESPACE::QueryPool queryPool, uint32_t query ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkCmdCopyQueryPoolResults, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdCopyQueryPoolResults.html
      void copyQueryPoolResults( VULKAN_HPP_NAMESPACE::QueryPool queryPool,
                                 uint32_t                        firstQuery,
                                 uint32_t                        queryCount,
                                 VULKAN_HPP_NAMESPACE::Buffer    dstBuffer,
                                 DeviceSize                      dstOffset,
                                 DeviceSize                      stride,
                                 QueryResultFlags flags          VULKAN_HPP_DEFAULT_ASSIGNMENT( {} ) ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkCmdExecuteCommands, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdExecuteCommands.html
      void executeCommands( ArrayProxy<const VULKAN_HPP_NAMESPACE::CommandBuffer> const & commandBuffers ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkCmdBindPipeline, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdBindPipeline.html
      void bindPipeline( PipelineBindPoint pipelineBindPoint, VULKAN_HPP_NAMESPACE::Pipeline pipeline ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkCmdBindDescriptorSets, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdBindDescriptorSets.html
      void bindDescriptorSets( PipelineBindPoint                                             pipelineBindPoint,
                               VULKAN_HPP_NAMESPACE::PipelineLayout                          layout,
                               uint32_t                                                      firstSet,
                               ArrayProxy<const VULKAN_HPP_NAMESPACE::DescriptorSet> const & descriptorSets,
                               ArrayProxy<const uint32_t> const &                            dynamicOffsets ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkCmdClearColorImage, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdClearColorImage.html
      void clearColorImage( VULKAN_HPP_NAMESPACE::Image                     image,
                            ImageLayout                                     imageLayout,
                            const ClearColorValue &                         color,
                            ArrayProxy<const ImageSubresourceRange> const & ranges ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkCmdDispatch, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdDispatch.html
      void dispatch( uint32_t groupCountX, uint32_t groupCountY, uint32_t groupCountZ ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkCmdDispatchIndirect, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdDispatchIndirect.html
      void dispatchIndirect( VULKAN_HPP_NAMESPACE::Buffer buffer, DeviceSize offset ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkCmdSetEvent, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetEvent.html
      void setEvent( VULKAN_HPP_NAMESPACE::Event event, PipelineStageFlags stageMask VULKAN_HPP_DEFAULT_ASSIGNMENT( {} ) ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkCmdResetEvent, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdResetEvent.html
      void resetEvent( VULKAN_HPP_NAMESPACE::Event event, PipelineStageFlags stageMask VULKAN_HPP_DEFAULT_ASSIGNMENT( {} ) ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkCmdWaitEvents, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdWaitEvents.html
      void waitEvents( ArrayProxy<const VULKAN_HPP_NAMESPACE::Event> const & events,
                       PipelineStageFlags                                    srcStageMask,
                       PipelineStageFlags                                    dstStageMask,
                       ArrayProxy<const MemoryBarrier> const &               memoryBarriers,
                       ArrayProxy<const BufferMemoryBarrier> const &         bufferMemoryBarriers,
                       ArrayProxy<const ImageMemoryBarrier> const &          imageMemoryBarriers ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkCmdPushConstants, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdPushConstants.html
      template <typename ValuesType>
      void pushConstants( VULKAN_HPP_NAMESPACE::PipelineLayout layout,
                          ShaderStageFlags                     stageFlags,
                          uint32_t                             offset,
                          ArrayProxy<const ValuesType> const & values ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkCmdSetViewport, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetViewport.html
      void setViewport( uint32_t firstViewport, ArrayProxy<const Viewport> const & viewports ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkCmdSetScissor, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetScissor.html
      void setScissor( uint32_t firstScissor, ArrayProxy<const Rect2D> const & scissors ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkCmdSetLineWidth, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetLineWidth.html
      void setLineWidth( float lineWidth ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkCmdSetDepthBias, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetDepthBias.html
      void setDepthBias( float depthBiasConstantFactor, float depthBiasClamp, float depthBiasSlopeFactor ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkCmdSetBlendConstants, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetBlendConstants.html
      void setBlendConstants( const float blendConstants[4] ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkCmdSetDepthBounds, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetDepthBounds.html
      void setDepthBounds( float minDepthBounds, float maxDepthBounds ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkCmdSetStencilCompareMask, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetStencilCompareMask.html
      void setStencilCompareMask( StencilFaceFlags faceMask, uint32_t compareMask ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkCmdSetStencilWriteMask, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetStencilWriteMask.html
      void setStencilWriteMask( StencilFaceFlags faceMask, uint32_t writeMask ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkCmdSetStencilReference, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetStencilReference.html
      void setStencilReference( StencilFaceFlags faceMask, uint32_t reference ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkCmdBindIndexBuffer, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdBindIndexBuffer.html
      void bindIndexBuffer( VULKAN_HPP_NAMESPACE::Buffer buffer, DeviceSize offset, IndexType indexType ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkCmdBindVertexBuffers, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdBindVertexBuffers.html
      void bindVertexBuffers( uint32_t                                               firstBinding,
                              ArrayProxy<const VULKAN_HPP_NAMESPACE::Buffer> const & buffers,
                              ArrayProxy<const DeviceSize> const &                   offsets ) const;

      // wrapper function for command vkCmdDraw, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdDraw.html
      void draw( uint32_t vertexCount, uint32_t instanceCount, uint32_t firstVertex, uint32_t firstInstance ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkCmdDrawIndexed, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdDrawIndexed.html
      void
        drawIndexed( uint32_t indexCount, uint32_t instanceCount, uint32_t firstIndex, int32_t vertexOffset, uint32_t firstInstance ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkCmdDrawIndirect, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdDrawIndirect.html
      void drawIndirect( VULKAN_HPP_NAMESPACE::Buffer buffer, DeviceSize offset, uint32_t drawCount, uint32_t stride ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkCmdDrawIndexedIndirect, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdDrawIndexedIndirect.html
      void drawIndexedIndirect( VULKAN_HPP_NAMESPACE::Buffer buffer, DeviceSize offset, uint32_t drawCount, uint32_t stride ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkCmdBlitImage, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdBlitImage.html
      void blitImage( VULKAN_HPP_NAMESPACE::Image         srcImage,
                      ImageLayout                         srcImageLayout,
                      VULKAN_HPP_NAMESPACE::Image         dstImage,
                      ImageLayout                         dstImageLayout,
                      ArrayProxy<const ImageBlit> const & regions,
                      Filter                              filter ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkCmdClearDepthStencilImage, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdClearDepthStencilImage.html
      void clearDepthStencilImage( VULKAN_HPP_NAMESPACE::Image                     image,
                                   ImageLayout                                     imageLayout,
                                   const ClearDepthStencilValue &                  depthStencil,
                                   ArrayProxy<const ImageSubresourceRange> const & ranges ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkCmdClearAttachments, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdClearAttachments.html
      void clearAttachments( ArrayProxy<const ClearAttachment> const & attachments, ArrayProxy<const ClearRect> const & rects ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkCmdResolveImage, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdResolveImage.html
      void resolveImage( VULKAN_HPP_NAMESPACE::Image            srcImage,
                         ImageLayout                            srcImageLayout,
                         VULKAN_HPP_NAMESPACE::Image            dstImage,
                         ImageLayout                            dstImageLayout,
                         ArrayProxy<const ImageResolve> const & regions ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkCmdBeginRenderPass, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdBeginRenderPass.html
      void beginRenderPass( const RenderPassBeginInfo & renderPassBegin, SubpassContents contents ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkCmdNextSubpass, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdNextSubpass.html
      void nextSubpass( SubpassContents contents ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkCmdEndRenderPass, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdEndRenderPass.html
      void endRenderPass() const VULKAN_HPP_NOEXCEPT;

      //=== VK_VERSION_1_1 ===

      // wrapper function for command vkCmdSetDeviceMask, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetDeviceMask.html
      void setDeviceMask( uint32_t deviceMask ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkCmdDispatchBase, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdDispatchBase.html
      void dispatchBase( uint32_t baseGroupX, uint32_t baseGroupY, uint32_t baseGroupZ, uint32_t groupCountX, uint32_t groupCountY, uint32_t groupCountZ ) const
        VULKAN_HPP_NOEXCEPT;

      //=== VK_VERSION_1_2 ===

      // wrapper function for command vkCmdDrawIndirectCount, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdDrawIndirectCount.html
      void drawIndirectCount( VULKAN_HPP_NAMESPACE::Buffer buffer,
                              DeviceSize                   offset,
                              VULKAN_HPP_NAMESPACE::Buffer countBuffer,
                              DeviceSize                   countBufferOffset,
                              uint32_t                     maxDrawCount,
                              uint32_t                     stride ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkCmdDrawIndexedIndirectCount, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdDrawIndexedIndirectCount.html
      void drawIndexedIndirectCount( VULKAN_HPP_NAMESPACE::Buffer buffer,
                                     DeviceSize                   offset,
                                     VULKAN_HPP_NAMESPACE::Buffer countBuffer,
                                     DeviceSize                   countBufferOffset,
                                     uint32_t                     maxDrawCount,
                                     uint32_t                     stride ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkCmdBeginRenderPass2, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdBeginRenderPass2.html
      void beginRenderPass2( const RenderPassBeginInfo & renderPassBegin, const SubpassBeginInfo & subpassBeginInfo ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkCmdNextSubpass2, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdNextSubpass2.html
      void nextSubpass2( const SubpassBeginInfo & subpassBeginInfo, const SubpassEndInfo & subpassEndInfo ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkCmdEndRenderPass2, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdEndRenderPass2.html
      void endRenderPass2( const SubpassEndInfo & subpassEndInfo ) const VULKAN_HPP_NOEXCEPT;

      //=== VK_VERSION_1_3 ===

      // wrapper function for command vkCmdPipelineBarrier2, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdPipelineBarrier2.html
      void pipelineBarrier2( const DependencyInfo & dependencyInfo ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkCmdWriteTimestamp2, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdWriteTimestamp2.html
      void writeTimestamp2( PipelineStageFlags2 stage, VULKAN_HPP_NAMESPACE::QueryPool queryPool, uint32_t query ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkCmdCopyBuffer2, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdCopyBuffer2.html
      void copyBuffer2( const CopyBufferInfo2 & copyBufferInfo ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkCmdCopyImage2, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdCopyImage2.html
      void copyImage2( const CopyImageInfo2 & copyImageInfo ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkCmdCopyBufferToImage2, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdCopyBufferToImage2.html
      void copyBufferToImage2( const CopyBufferToImageInfo2 & copyBufferToImageInfo ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkCmdCopyImageToBuffer2, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdCopyImageToBuffer2.html
      void copyImageToBuffer2( const CopyImageToBufferInfo2 & copyImageToBufferInfo ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkCmdSetEvent2, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetEvent2.html
      void setEvent2( VULKAN_HPP_NAMESPACE::Event event, const DependencyInfo & dependencyInfo ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkCmdResetEvent2, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdResetEvent2.html
      void resetEvent2( VULKAN_HPP_NAMESPACE::Event event, PipelineStageFlags2 stageMask VULKAN_HPP_DEFAULT_ASSIGNMENT( {} ) ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkCmdWaitEvents2, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdWaitEvents2.html
      void waitEvents2( ArrayProxy<const VULKAN_HPP_NAMESPACE::Event> const & events, ArrayProxy<const DependencyInfo> const & dependencyInfos ) const;

      // wrapper function for command vkCmdBlitImage2, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdBlitImage2.html
      void blitImage2( const BlitImageInfo2 & blitImageInfo ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkCmdResolveImage2, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdResolveImage2.html
      void resolveImage2( const ResolveImageInfo2 & resolveImageInfo ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkCmdBeginRendering, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdBeginRendering.html
      void beginRendering( const RenderingInfo & renderingInfo ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkCmdEndRendering, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdEndRendering.html
      void endRendering() const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkCmdSetCullMode, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetCullMode.html
      void setCullMode( CullModeFlags cullMode VULKAN_HPP_DEFAULT_ASSIGNMENT( {} ) ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkCmdSetFrontFace, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetFrontFace.html
      void setFrontFace( FrontFace frontFace ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkCmdSetPrimitiveTopology, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetPrimitiveTopology.html
      void setPrimitiveTopology( PrimitiveTopology primitiveTopology ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkCmdSetViewportWithCount, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetViewportWithCount.html
      void setViewportWithCount( ArrayProxy<const Viewport> const & viewports ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkCmdSetScissorWithCount, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetScissorWithCount.html
      void setScissorWithCount( ArrayProxy<const Rect2D> const & scissors ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkCmdBindVertexBuffers2, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdBindVertexBuffers2.html
      void bindVertexBuffers2( uint32_t                                               firstBinding,
                               ArrayProxy<const VULKAN_HPP_NAMESPACE::Buffer> const & buffers,
                               ArrayProxy<const DeviceSize> const &                   offsets,
                               ArrayProxy<const DeviceSize> const & sizes             VULKAN_HPP_DEFAULT_ASSIGNMENT( nullptr ),
                               ArrayProxy<const DeviceSize> const & strides           VULKAN_HPP_DEFAULT_ASSIGNMENT( nullptr ) ) const;

      // wrapper function for command vkCmdSetDepthTestEnable, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetDepthTestEnable.html
      void setDepthTestEnable( Bool32 depthTestEnable ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkCmdSetDepthWriteEnable, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetDepthWriteEnable.html
      void setDepthWriteEnable( Bool32 depthWriteEnable ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkCmdSetDepthCompareOp, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetDepthCompareOp.html
      void setDepthCompareOp( CompareOp depthCompareOp ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkCmdSetDepthBoundsTestEnable, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetDepthBoundsTestEnable.html
      void setDepthBoundsTestEnable( Bool32 depthBoundsTestEnable ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkCmdSetStencilTestEnable, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetStencilTestEnable.html
      void setStencilTestEnable( Bool32 stencilTestEnable ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkCmdSetStencilOp, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetStencilOp.html
      void setStencilOp( StencilFaceFlags faceMask, StencilOp failOp, StencilOp passOp, StencilOp depthFailOp, CompareOp compareOp ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkCmdSetRasterizerDiscardEnable, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetRasterizerDiscardEnable.html
      void setRasterizerDiscardEnable( Bool32 rasterizerDiscardEnable ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkCmdSetDepthBiasEnable, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetDepthBiasEnable.html
      void setDepthBiasEnable( Bool32 depthBiasEnable ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkCmdSetPrimitiveRestartEnable, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetPrimitiveRestartEnable.html
      void setPrimitiveRestartEnable( Bool32 primitiveRestartEnable ) const VULKAN_HPP_NOEXCEPT;

      //=== VK_VERSION_1_4 ===

      // wrapper function for command vkCmdPushDescriptorSet, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdPushDescriptorSet.html
      void pushDescriptorSet( PipelineBindPoint                            pipelineBindPoint,
                              VULKAN_HPP_NAMESPACE::PipelineLayout         layout,
                              uint32_t                                     set,
                              ArrayProxy<const WriteDescriptorSet> const & descriptorWrites ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkCmdPushDescriptorSetWithTemplate, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdPushDescriptorSetWithTemplate.html
      template <typename DataType>
      void pushDescriptorSetWithTemplate( VULKAN_HPP_NAMESPACE::DescriptorUpdateTemplate descriptorUpdateTemplate,
                                          VULKAN_HPP_NAMESPACE::PipelineLayout           layout,
                                          uint32_t                                       set,
                                          DataType const &                               data ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkCmdBindDescriptorSets2, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdBindDescriptorSets2.html
      void bindDescriptorSets2( const BindDescriptorSetsInfo & bindDescriptorSetsInfo ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkCmdPushConstants2, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdPushConstants2.html
      void pushConstants2( const PushConstantsInfo & pushConstantsInfo ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkCmdPushDescriptorSet2, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdPushDescriptorSet2.html
      void pushDescriptorSet2( const PushDescriptorSetInfo & pushDescriptorSetInfo ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkCmdPushDescriptorSetWithTemplate2, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdPushDescriptorSetWithTemplate2.html
      void pushDescriptorSetWithTemplate2( const PushDescriptorSetWithTemplateInfo & pushDescriptorSetWithTemplateInfo ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkCmdSetLineStipple, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetLineStipple.html
      void setLineStipple( uint32_t lineStippleFactor, uint16_t lineStipplePattern ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkCmdBindIndexBuffer2, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdBindIndexBuffer2.html
      void bindIndexBuffer2( VULKAN_HPP_NAMESPACE::Buffer buffer, DeviceSize offset, DeviceSize size, IndexType indexType ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkCmdSetRenderingAttachmentLocations, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetRenderingAttachmentLocations.html
      void setRenderingAttachmentLocations( const RenderingAttachmentLocationInfo & locationInfo ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkCmdSetRenderingInputAttachmentIndices, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetRenderingInputAttachmentIndices.html
      void setRenderingInputAttachmentIndices( const RenderingInputAttachmentIndexInfo & inputAttachmentIndexInfo ) const VULKAN_HPP_NOEXCEPT;

      //=== VK_EXT_debug_marker ===

      // wrapper function for command vkCmdDebugMarkerBeginEXT, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdDebugMarkerBeginEXT.html
      void debugMarkerBeginEXT( const DebugMarkerMarkerInfoEXT & markerInfo ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkCmdDebugMarkerEndEXT, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdDebugMarkerEndEXT.html
      void debugMarkerEndEXT() const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkCmdDebugMarkerInsertEXT, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdDebugMarkerInsertEXT.html
      void debugMarkerInsertEXT( const DebugMarkerMarkerInfoEXT & markerInfo ) const VULKAN_HPP_NOEXCEPT;

      //=== VK_KHR_video_queue ===

      // wrapper function for command vkCmdBeginVideoCodingKHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdBeginVideoCodingKHR.html
      void beginVideoCodingKHR( const VideoBeginCodingInfoKHR & beginInfo ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkCmdEndVideoCodingKHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdEndVideoCodingKHR.html
      void endVideoCodingKHR( const VideoEndCodingInfoKHR & endCodingInfo ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkCmdControlVideoCodingKHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdControlVideoCodingKHR.html
      void controlVideoCodingKHR( const VideoCodingControlInfoKHR & codingControlInfo ) const VULKAN_HPP_NOEXCEPT;

      //=== VK_KHR_video_decode_queue ===

      // wrapper function for command vkCmdDecodeVideoKHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdDecodeVideoKHR.html
      void decodeVideoKHR( const VideoDecodeInfoKHR & decodeInfo ) const VULKAN_HPP_NOEXCEPT;

      //=== VK_EXT_transform_feedback ===

      // wrapper function for command vkCmdBindTransformFeedbackBuffersEXT, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdBindTransformFeedbackBuffersEXT.html
      void bindTransformFeedbackBuffersEXT( uint32_t                                               firstBinding,
                                            ArrayProxy<const VULKAN_HPP_NAMESPACE::Buffer> const & buffers,
                                            ArrayProxy<const DeviceSize> const &                   offsets,
                                            ArrayProxy<const DeviceSize> const & sizes             VULKAN_HPP_DEFAULT_ASSIGNMENT( nullptr ) ) const;

      // wrapper function for command vkCmdBeginTransformFeedbackEXT, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdBeginTransformFeedbackEXT.html
      void beginTransformFeedbackEXT( uint32_t                                                  firstCounterBuffer,
                                      ArrayProxy<const VULKAN_HPP_NAMESPACE::Buffer> const &    counterBuffers,
                                      ArrayProxy<const DeviceSize> const & counterBufferOffsets VULKAN_HPP_DEFAULT_ASSIGNMENT( nullptr ) ) const;

      // wrapper function for command vkCmdEndTransformFeedbackEXT, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdEndTransformFeedbackEXT.html
      void endTransformFeedbackEXT( uint32_t                                                  firstCounterBuffer,
                                    ArrayProxy<const VULKAN_HPP_NAMESPACE::Buffer> const &    counterBuffers,
                                    ArrayProxy<const DeviceSize> const & counterBufferOffsets VULKAN_HPP_DEFAULT_ASSIGNMENT( nullptr ) ) const;

      // wrapper function for command vkCmdBeginQueryIndexedEXT, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdBeginQueryIndexedEXT.html
      void beginQueryIndexedEXT( VULKAN_HPP_NAMESPACE::QueryPool queryPool, uint32_t query, QueryControlFlags flags, uint32_t index ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkCmdEndQueryIndexedEXT, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdEndQueryIndexedEXT.html
      void endQueryIndexedEXT( VULKAN_HPP_NAMESPACE::QueryPool queryPool, uint32_t query, uint32_t index ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkCmdDrawIndirectByteCountEXT, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdDrawIndirectByteCountEXT.html
      void drawIndirectByteCountEXT( uint32_t                     instanceCount,
                                     uint32_t                     firstInstance,
                                     VULKAN_HPP_NAMESPACE::Buffer counterBuffer,
                                     DeviceSize                   counterBufferOffset,
                                     uint32_t                     counterOffset,
                                     uint32_t                     vertexStride ) const VULKAN_HPP_NOEXCEPT;

      //=== VK_NVX_binary_import ===

      // wrapper function for command vkCmdCuLaunchKernelNVX, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdCuLaunchKernelNVX.html
      void cuLaunchKernelNVX( const CuLaunchInfoNVX & launchInfo ) const VULKAN_HPP_NOEXCEPT;

      //=== VK_AMD_draw_indirect_count ===

      // wrapper function for command vkCmdDrawIndirectCountAMD, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdDrawIndirectCountAMD.html
      void drawIndirectCountAMD( VULKAN_HPP_NAMESPACE::Buffer buffer,
                                 DeviceSize                   offset,
                                 VULKAN_HPP_NAMESPACE::Buffer countBuffer,
                                 DeviceSize                   countBufferOffset,
                                 uint32_t                     maxDrawCount,
                                 uint32_t                     stride ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkCmdDrawIndexedIndirectCountAMD, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdDrawIndexedIndirectCountAMD.html
      void drawIndexedIndirectCountAMD( VULKAN_HPP_NAMESPACE::Buffer buffer,
                                        DeviceSize                   offset,
                                        VULKAN_HPP_NAMESPACE::Buffer countBuffer,
                                        DeviceSize                   countBufferOffset,
                                        uint32_t                     maxDrawCount,
                                        uint32_t                     stride ) const VULKAN_HPP_NOEXCEPT;

      //=== VK_KHR_dynamic_rendering ===

      // wrapper function for command vkCmdBeginRenderingKHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdBeginRenderingKHR.html
      void beginRenderingKHR( const RenderingInfo & renderingInfo ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkCmdEndRenderingKHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdEndRenderingKHR.html
      void endRenderingKHR() const VULKAN_HPP_NOEXCEPT;

      //=== VK_KHR_device_group ===

      // wrapper function for command vkCmdSetDeviceMaskKHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetDeviceMaskKHR.html
      void setDeviceMaskKHR( uint32_t deviceMask ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkCmdDispatchBaseKHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdDispatchBaseKHR.html
      void dispatchBaseKHR( uint32_t baseGroupX, uint32_t baseGroupY, uint32_t baseGroupZ, uint32_t groupCountX, uint32_t groupCountY, uint32_t groupCountZ )
        const VULKAN_HPP_NOEXCEPT;

      //=== VK_KHR_push_descriptor ===

      // wrapper function for command vkCmdPushDescriptorSetKHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdPushDescriptorSetKHR.html
      void pushDescriptorSetKHR( PipelineBindPoint                            pipelineBindPoint,
                                 VULKAN_HPP_NAMESPACE::PipelineLayout         layout,
                                 uint32_t                                     set,
                                 ArrayProxy<const WriteDescriptorSet> const & descriptorWrites ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkCmdPushDescriptorSetWithTemplateKHR, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdPushDescriptorSetWithTemplateKHR.html
      template <typename DataType>
      void pushDescriptorSetWithTemplateKHR( VULKAN_HPP_NAMESPACE::DescriptorUpdateTemplate descriptorUpdateTemplate,
                                             VULKAN_HPP_NAMESPACE::PipelineLayout           layout,
                                             uint32_t                                       set,
                                             DataType const &                               data ) const VULKAN_HPP_NOEXCEPT;

      //=== VK_EXT_conditional_rendering ===

      // wrapper function for command vkCmdBeginConditionalRenderingEXT, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdBeginConditionalRenderingEXT.html
      void beginConditionalRenderingEXT( const ConditionalRenderingBeginInfoEXT & conditionalRenderingBegin ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkCmdEndConditionalRenderingEXT, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdEndConditionalRenderingEXT.html
      void endConditionalRenderingEXT() const VULKAN_HPP_NOEXCEPT;

      //=== VK_NV_clip_space_w_scaling ===

      // wrapper function for command vkCmdSetViewportWScalingNV, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetViewportWScalingNV.html
      void setViewportWScalingNV( uint32_t firstViewport, ArrayProxy<const ViewportWScalingNV> const & viewportWScalings ) const VULKAN_HPP_NOEXCEPT;

      //=== VK_EXT_discard_rectangles ===

      // wrapper function for command vkCmdSetDiscardRectangleEXT, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetDiscardRectangleEXT.html
      void setDiscardRectangleEXT( uint32_t firstDiscardRectangle, ArrayProxy<const Rect2D> const & discardRectangles ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkCmdSetDiscardRectangleEnableEXT, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetDiscardRectangleEnableEXT.html
      void setDiscardRectangleEnableEXT( Bool32 discardRectangleEnable ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkCmdSetDiscardRectangleModeEXT, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetDiscardRectangleModeEXT.html
      void setDiscardRectangleModeEXT( DiscardRectangleModeEXT discardRectangleMode ) const VULKAN_HPP_NOEXCEPT;

      //=== VK_KHR_create_renderpass2 ===

      // wrapper function for command vkCmdBeginRenderPass2KHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdBeginRenderPass2KHR.html
      void beginRenderPass2KHR( const RenderPassBeginInfo & renderPassBegin, const SubpassBeginInfo & subpassBeginInfo ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkCmdNextSubpass2KHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdNextSubpass2KHR.html
      void nextSubpass2KHR( const SubpassBeginInfo & subpassBeginInfo, const SubpassEndInfo & subpassEndInfo ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkCmdEndRenderPass2KHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdEndRenderPass2KHR.html
      void endRenderPass2KHR( const SubpassEndInfo & subpassEndInfo ) const VULKAN_HPP_NOEXCEPT;

      //=== VK_EXT_debug_utils ===

      // wrapper function for command vkCmdBeginDebugUtilsLabelEXT, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdBeginDebugUtilsLabelEXT.html
      void beginDebugUtilsLabelEXT( const DebugUtilsLabelEXT & labelInfo ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkCmdEndDebugUtilsLabelEXT, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdEndDebugUtilsLabelEXT.html
      void endDebugUtilsLabelEXT() const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkCmdInsertDebugUtilsLabelEXT, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdInsertDebugUtilsLabelEXT.html
      void insertDebugUtilsLabelEXT( const DebugUtilsLabelEXT & labelInfo ) const VULKAN_HPP_NOEXCEPT;

#  if defined( VK_ENABLE_BETA_EXTENSIONS )
      //=== VK_AMDX_shader_enqueue ===

      // wrapper function for command vkCmdInitializeGraphScratchMemoryAMDX, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdInitializeGraphScratchMemoryAMDX.html
      void initializeGraphScratchMemoryAMDX( VULKAN_HPP_NAMESPACE::Pipeline executionGraph,
                                             DeviceAddress                  scratch,
                                             DeviceSize                     scratchSize ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkCmdDispatchGraphAMDX, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdDispatchGraphAMDX.html
      void dispatchGraphAMDX( DeviceAddress scratch, DeviceSize scratchSize, const DispatchGraphCountInfoAMDX & countInfo ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkCmdDispatchGraphIndirectAMDX, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdDispatchGraphIndirectAMDX.html
      void dispatchGraphIndirectAMDX( DeviceAddress scratch, DeviceSize scratchSize, const DispatchGraphCountInfoAMDX & countInfo ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkCmdDispatchGraphIndirectCountAMDX, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdDispatchGraphIndirectCountAMDX.html
      void dispatchGraphIndirectCountAMDX( DeviceAddress scratch, DeviceSize scratchSize, DeviceAddress countInfo ) const VULKAN_HPP_NOEXCEPT;
#  endif /*VK_ENABLE_BETA_EXTENSIONS*/

      //=== VK_EXT_sample_locations ===

      // wrapper function for command vkCmdSetSampleLocationsEXT, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetSampleLocationsEXT.html
      void setSampleLocationsEXT( const SampleLocationsInfoEXT & sampleLocationsInfo ) const VULKAN_HPP_NOEXCEPT;

      //=== VK_KHR_acceleration_structure ===

      // wrapper function for command vkCmdBuildAccelerationStructuresKHR, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdBuildAccelerationStructuresKHR.html
      void buildAccelerationStructuresKHR( ArrayProxy<const AccelerationStructureBuildGeometryInfoKHR> const &      infos,
                                           ArrayProxy<const AccelerationStructureBuildRangeInfoKHR * const> const & pBuildRangeInfos ) const;

      // wrapper function for command vkCmdBuildAccelerationStructuresIndirectKHR, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdBuildAccelerationStructuresIndirectKHR.html
      void buildAccelerationStructuresIndirectKHR( ArrayProxy<const AccelerationStructureBuildGeometryInfoKHR> const & infos,
                                                   ArrayProxy<const DeviceAddress> const &                             indirectDeviceAddresses,
                                                   ArrayProxy<const uint32_t> const &                                  indirectStrides,
                                                   ArrayProxy<const uint32_t * const> const &                          pMaxPrimitiveCounts ) const;

      // wrapper function for command vkCmdCopyAccelerationStructureKHR, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdCopyAccelerationStructureKHR.html
      void copyAccelerationStructureKHR( const CopyAccelerationStructureInfoKHR & info ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkCmdCopyAccelerationStructureToMemoryKHR, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdCopyAccelerationStructureToMemoryKHR.html
      void copyAccelerationStructureToMemoryKHR( const CopyAccelerationStructureToMemoryInfoKHR & info ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkCmdCopyMemoryToAccelerationStructureKHR, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdCopyMemoryToAccelerationStructureKHR.html
      void copyMemoryToAccelerationStructureKHR( const CopyMemoryToAccelerationStructureInfoKHR & info ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkCmdWriteAccelerationStructuresPropertiesKHR, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdWriteAccelerationStructuresPropertiesKHR.html
      void writeAccelerationStructuresPropertiesKHR( ArrayProxy<const VULKAN_HPP_NAMESPACE::AccelerationStructureKHR> const & accelerationStructures,
                                                     QueryType                                                                queryType,
                                                     VULKAN_HPP_NAMESPACE::QueryPool                                          queryPool,
                                                     uint32_t firstQuery ) const VULKAN_HPP_NOEXCEPT;

      //=== VK_KHR_ray_tracing_pipeline ===

      // wrapper function for command vkCmdTraceRaysKHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdTraceRaysKHR.html
      void traceRaysKHR( const StridedDeviceAddressRegionKHR & raygenShaderBindingTable,
                         const StridedDeviceAddressRegionKHR & missShaderBindingTable,
                         const StridedDeviceAddressRegionKHR & hitShaderBindingTable,
                         const StridedDeviceAddressRegionKHR & callableShaderBindingTable,
                         uint32_t                              width,
                         uint32_t                              height,
                         uint32_t                              depth ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkCmdTraceRaysIndirectKHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdTraceRaysIndirectKHR.html
      void traceRaysIndirectKHR( const StridedDeviceAddressRegionKHR & raygenShaderBindingTable,
                                 const StridedDeviceAddressRegionKHR & missShaderBindingTable,
                                 const StridedDeviceAddressRegionKHR & hitShaderBindingTable,
                                 const StridedDeviceAddressRegionKHR & callableShaderBindingTable,
                                 DeviceAddress                         indirectDeviceAddress ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkCmdSetRayTracingPipelineStackSizeKHR, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetRayTracingPipelineStackSizeKHR.html
      void setRayTracingPipelineStackSizeKHR( uint32_t pipelineStackSize ) const VULKAN_HPP_NOEXCEPT;

      //=== VK_NV_shading_rate_image ===

      // wrapper function for command vkCmdBindShadingRateImageNV, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdBindShadingRateImageNV.html
      void bindShadingRateImageNV( VULKAN_HPP_NAMESPACE::ImageView imageView, ImageLayout imageLayout ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkCmdSetViewportShadingRatePaletteNV, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetViewportShadingRatePaletteNV.html
      void setViewportShadingRatePaletteNV( uint32_t                                       firstViewport,
                                            ArrayProxy<const ShadingRatePaletteNV> const & shadingRatePalettes ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkCmdSetCoarseSampleOrderNV, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetCoarseSampleOrderNV.html
      void setCoarseSampleOrderNV( CoarseSampleOrderTypeNV                             sampleOrderType,
                                   ArrayProxy<const CoarseSampleOrderCustomNV> const & customSampleOrders ) const VULKAN_HPP_NOEXCEPT;

      //=== VK_NV_ray_tracing ===

      // wrapper function for command vkCmdBuildAccelerationStructureNV, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdBuildAccelerationStructureNV.html
      void buildAccelerationStructureNV( const AccelerationStructureInfoNV &           info,
                                         VULKAN_HPP_NAMESPACE::Buffer                  instanceData,
                                         DeviceSize                                    instanceOffset,
                                         Bool32                                        update,
                                         VULKAN_HPP_NAMESPACE::AccelerationStructureNV dst,
                                         VULKAN_HPP_NAMESPACE::AccelerationStructureNV src,
                                         VULKAN_HPP_NAMESPACE::Buffer                  scratch,
                                         DeviceSize                                    scratchOffset ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkCmdCopyAccelerationStructureNV, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdCopyAccelerationStructureNV.html
      void copyAccelerationStructureNV( VULKAN_HPP_NAMESPACE::AccelerationStructureNV dst,
                                        VULKAN_HPP_NAMESPACE::AccelerationStructureNV src,
                                        CopyAccelerationStructureModeKHR              mode ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkCmdTraceRaysNV, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdTraceRaysNV.html
      void traceRaysNV( VULKAN_HPP_NAMESPACE::Buffer raygenShaderBindingTableBuffer,
                        DeviceSize                   raygenShaderBindingOffset,
                        VULKAN_HPP_NAMESPACE::Buffer missShaderBindingTableBuffer,
                        DeviceSize                   missShaderBindingOffset,
                        DeviceSize                   missShaderBindingStride,
                        VULKAN_HPP_NAMESPACE::Buffer hitShaderBindingTableBuffer,
                        DeviceSize                   hitShaderBindingOffset,
                        DeviceSize                   hitShaderBindingStride,
                        VULKAN_HPP_NAMESPACE::Buffer callableShaderBindingTableBuffer,
                        DeviceSize                   callableShaderBindingOffset,
                        DeviceSize                   callableShaderBindingStride,
                        uint32_t                     width,
                        uint32_t                     height,
                        uint32_t                     depth ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkCmdWriteAccelerationStructuresPropertiesNV, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdWriteAccelerationStructuresPropertiesNV.html
      void writeAccelerationStructuresPropertiesNV( ArrayProxy<const VULKAN_HPP_NAMESPACE::AccelerationStructureNV> const & accelerationStructures,
                                                    QueryType                                                               queryType,
                                                    VULKAN_HPP_NAMESPACE::QueryPool                                         queryPool,
                                                    uint32_t firstQuery ) const VULKAN_HPP_NOEXCEPT;

      //=== VK_KHR_draw_indirect_count ===

      // wrapper function for command vkCmdDrawIndirectCountKHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdDrawIndirectCountKHR.html
      void drawIndirectCountKHR( VULKAN_HPP_NAMESPACE::Buffer buffer,
                                 DeviceSize                   offset,
                                 VULKAN_HPP_NAMESPACE::Buffer countBuffer,
                                 DeviceSize                   countBufferOffset,
                                 uint32_t                     maxDrawCount,
                                 uint32_t                     stride ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkCmdDrawIndexedIndirectCountKHR, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdDrawIndexedIndirectCountKHR.html
      void drawIndexedIndirectCountKHR( VULKAN_HPP_NAMESPACE::Buffer buffer,
                                        DeviceSize                   offset,
                                        VULKAN_HPP_NAMESPACE::Buffer countBuffer,
                                        DeviceSize                   countBufferOffset,
                                        uint32_t                     maxDrawCount,
                                        uint32_t                     stride ) const VULKAN_HPP_NOEXCEPT;

      //=== VK_AMD_buffer_marker ===

      // wrapper function for command vkCmdWriteBufferMarkerAMD, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdWriteBufferMarkerAMD.html
      void writeBufferMarkerAMD( PipelineStageFlagBits        pipelineStage,
                                 VULKAN_HPP_NAMESPACE::Buffer dstBuffer,
                                 DeviceSize                   dstOffset,
                                 uint32_t                     marker ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkCmdWriteBufferMarker2AMD, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdWriteBufferMarker2AMD.html
      void writeBufferMarker2AMD( PipelineStageFlags2          stage,
                                  VULKAN_HPP_NAMESPACE::Buffer dstBuffer,
                                  DeviceSize                   dstOffset,
                                  uint32_t                     marker ) const VULKAN_HPP_NOEXCEPT;

      //=== VK_NV_mesh_shader ===

      // wrapper function for command vkCmdDrawMeshTasksNV, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdDrawMeshTasksNV.html
      void drawMeshTasksNV( uint32_t taskCount, uint32_t firstTask ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkCmdDrawMeshTasksIndirectNV, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdDrawMeshTasksIndirectNV.html
      void drawMeshTasksIndirectNV( VULKAN_HPP_NAMESPACE::Buffer buffer, DeviceSize offset, uint32_t drawCount, uint32_t stride ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkCmdDrawMeshTasksIndirectCountNV, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdDrawMeshTasksIndirectCountNV.html
      void drawMeshTasksIndirectCountNV( VULKAN_HPP_NAMESPACE::Buffer buffer,
                                         DeviceSize                   offset,
                                         VULKAN_HPP_NAMESPACE::Buffer countBuffer,
                                         DeviceSize                   countBufferOffset,
                                         uint32_t                     maxDrawCount,
                                         uint32_t                     stride ) const VULKAN_HPP_NOEXCEPT;

      //=== VK_NV_scissor_exclusive ===

      // wrapper function for command vkCmdSetExclusiveScissorEnableNV, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetExclusiveScissorEnableNV.html
      void setExclusiveScissorEnableNV( uint32_t firstExclusiveScissor, ArrayProxy<const Bool32> const & exclusiveScissorEnables ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkCmdSetExclusiveScissorNV, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetExclusiveScissorNV.html
      void setExclusiveScissorNV( uint32_t firstExclusiveScissor, ArrayProxy<const Rect2D> const & exclusiveScissors ) const VULKAN_HPP_NOEXCEPT;

      //=== VK_NV_device_diagnostic_checkpoints ===

      // wrapper function for command vkCmdSetCheckpointNV, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetCheckpointNV.html
      template <typename CheckpointMarkerType>
      void setCheckpointNV( CheckpointMarkerType const & checkpointMarker ) const VULKAN_HPP_NOEXCEPT;

      //=== VK_INTEL_performance_query ===

      // wrapper function for command vkCmdSetPerformanceMarkerINTEL, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetPerformanceMarkerINTEL.html
      typename ResultValueType<void>::type setPerformanceMarkerINTEL( const PerformanceMarkerInfoINTEL & markerInfo ) const;

      // wrapper function for command vkCmdSetPerformanceStreamMarkerINTEL, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetPerformanceStreamMarkerINTEL.html
      typename ResultValueType<void>::type setPerformanceStreamMarkerINTEL( const PerformanceStreamMarkerInfoINTEL & markerInfo ) const;

      // wrapper function for command vkCmdSetPerformanceOverrideINTEL, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetPerformanceOverrideINTEL.html
      typename ResultValueType<void>::type setPerformanceOverrideINTEL( const PerformanceOverrideInfoINTEL & overrideInfo ) const;

      //=== VK_KHR_fragment_shading_rate ===

      // wrapper function for command vkCmdSetFragmentShadingRateKHR, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetFragmentShadingRateKHR.html
      void setFragmentShadingRateKHR( const Extent2D & fragmentSize, const FragmentShadingRateCombinerOpKHR combinerOps[2] ) const VULKAN_HPP_NOEXCEPT;

      //=== VK_KHR_dynamic_rendering_local_read ===

      // wrapper function for command vkCmdSetRenderingAttachmentLocationsKHR, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetRenderingAttachmentLocationsKHR.html
      void setRenderingAttachmentLocationsKHR( const RenderingAttachmentLocationInfo & locationInfo ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkCmdSetRenderingInputAttachmentIndicesKHR, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetRenderingInputAttachmentIndicesKHR.html
      void setRenderingInputAttachmentIndicesKHR( const RenderingInputAttachmentIndexInfo & inputAttachmentIndexInfo ) const VULKAN_HPP_NOEXCEPT;

      //=== VK_EXT_line_rasterization ===

      // wrapper function for command vkCmdSetLineStippleEXT, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetLineStippleEXT.html
      void setLineStippleEXT( uint32_t lineStippleFactor, uint16_t lineStipplePattern ) const VULKAN_HPP_NOEXCEPT;

      //=== VK_EXT_extended_dynamic_state ===

      // wrapper function for command vkCmdSetCullModeEXT, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetCullModeEXT.html
      void setCullModeEXT( CullModeFlags cullMode VULKAN_HPP_DEFAULT_ASSIGNMENT( {} ) ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkCmdSetFrontFaceEXT, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetFrontFaceEXT.html
      void setFrontFaceEXT( FrontFace frontFace ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkCmdSetPrimitiveTopologyEXT, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetPrimitiveTopologyEXT.html
      void setPrimitiveTopologyEXT( PrimitiveTopology primitiveTopology ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkCmdSetViewportWithCountEXT, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetViewportWithCountEXT.html
      void setViewportWithCountEXT( ArrayProxy<const Viewport> const & viewports ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkCmdSetScissorWithCountEXT, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetScissorWithCountEXT.html
      void setScissorWithCountEXT( ArrayProxy<const Rect2D> const & scissors ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkCmdBindVertexBuffers2EXT, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdBindVertexBuffers2EXT.html
      void bindVertexBuffers2EXT( uint32_t                                               firstBinding,
                                  ArrayProxy<const VULKAN_HPP_NAMESPACE::Buffer> const & buffers,
                                  ArrayProxy<const DeviceSize> const &                   offsets,
                                  ArrayProxy<const DeviceSize> const & sizes             VULKAN_HPP_DEFAULT_ASSIGNMENT( nullptr ),
                                  ArrayProxy<const DeviceSize> const & strides           VULKAN_HPP_DEFAULT_ASSIGNMENT( nullptr ) ) const;

      // wrapper function for command vkCmdSetDepthTestEnableEXT, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetDepthTestEnableEXT.html
      void setDepthTestEnableEXT( Bool32 depthTestEnable ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkCmdSetDepthWriteEnableEXT, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetDepthWriteEnableEXT.html
      void setDepthWriteEnableEXT( Bool32 depthWriteEnable ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkCmdSetDepthCompareOpEXT, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetDepthCompareOpEXT.html
      void setDepthCompareOpEXT( CompareOp depthCompareOp ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkCmdSetDepthBoundsTestEnableEXT, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetDepthBoundsTestEnableEXT.html
      void setDepthBoundsTestEnableEXT( Bool32 depthBoundsTestEnable ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkCmdSetStencilTestEnableEXT, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetStencilTestEnableEXT.html
      void setStencilTestEnableEXT( Bool32 stencilTestEnable ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkCmdSetStencilOpEXT, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetStencilOpEXT.html
      void
        setStencilOpEXT( StencilFaceFlags faceMask, StencilOp failOp, StencilOp passOp, StencilOp depthFailOp, CompareOp compareOp ) const VULKAN_HPP_NOEXCEPT;

      //=== VK_NV_device_generated_commands ===

      // wrapper function for command vkCmdPreprocessGeneratedCommandsNV, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdPreprocessGeneratedCommandsNV.html
      void preprocessGeneratedCommandsNV( const GeneratedCommandsInfoNV & generatedCommandsInfo ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkCmdExecuteGeneratedCommandsNV, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdExecuteGeneratedCommandsNV.html
      void executeGeneratedCommandsNV( Bool32 isPreprocessed, const GeneratedCommandsInfoNV & generatedCommandsInfo ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkCmdBindPipelineShaderGroupNV, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdBindPipelineShaderGroupNV.html
      void bindPipelineShaderGroupNV( PipelineBindPoint              pipelineBindPoint,
                                      VULKAN_HPP_NAMESPACE::Pipeline pipeline,
                                      uint32_t                       groupIndex ) const VULKAN_HPP_NOEXCEPT;

      //=== VK_EXT_depth_bias_control ===

      // wrapper function for command vkCmdSetDepthBias2EXT, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetDepthBias2EXT.html
      void setDepthBias2EXT( const DepthBiasInfoEXT & depthBiasInfo ) const VULKAN_HPP_NOEXCEPT;

      //=== VK_KHR_video_encode_queue ===

      // wrapper function for command vkCmdEncodeVideoKHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdEncodeVideoKHR.html
      void encodeVideoKHR( const VideoEncodeInfoKHR & encodeInfo ) const VULKAN_HPP_NOEXCEPT;

#  if defined( VK_ENABLE_BETA_EXTENSIONS )
      //=== VK_NV_cuda_kernel_launch ===

      // wrapper function for command vkCmdCudaLaunchKernelNV, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdCudaLaunchKernelNV.html
      void cudaLaunchKernelNV( const CudaLaunchInfoNV & launchInfo ) const VULKAN_HPP_NOEXCEPT;
#  endif /*VK_ENABLE_BETA_EXTENSIONS*/

      //=== VK_QCOM_tile_shading ===

      // wrapper function for command vkCmdDispatchTileQCOM, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdDispatchTileQCOM.html
      void dispatchTileQCOM( const DispatchTileInfoQCOM & dispatchTileInfo ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkCmdBeginPerTileExecutionQCOM, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdBeginPerTileExecutionQCOM.html
      void beginPerTileExecutionQCOM( const PerTileBeginInfoQCOM & perTileBeginInfo ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkCmdEndPerTileExecutionQCOM, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdEndPerTileExecutionQCOM.html
      void endPerTileExecutionQCOM( const PerTileEndInfoQCOM & perTileEndInfo ) const VULKAN_HPP_NOEXCEPT;

      //=== VK_KHR_synchronization2 ===

      // wrapper function for command vkCmdSetEvent2KHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetEvent2KHR.html
      void setEvent2KHR( VULKAN_HPP_NAMESPACE::Event event, const DependencyInfo & dependencyInfo ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkCmdResetEvent2KHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdResetEvent2KHR.html
      void resetEvent2KHR( VULKAN_HPP_NAMESPACE::Event event, PipelineStageFlags2 stageMask VULKAN_HPP_DEFAULT_ASSIGNMENT( {} ) ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkCmdWaitEvents2KHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdWaitEvents2KHR.html
      void waitEvents2KHR( ArrayProxy<const VULKAN_HPP_NAMESPACE::Event> const & events, ArrayProxy<const DependencyInfo> const & dependencyInfos ) const;

      // wrapper function for command vkCmdPipelineBarrier2KHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdPipelineBarrier2KHR.html
      void pipelineBarrier2KHR( const DependencyInfo & dependencyInfo ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkCmdWriteTimestamp2KHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdWriteTimestamp2KHR.html
      void writeTimestamp2KHR( PipelineStageFlags2 stage, VULKAN_HPP_NAMESPACE::QueryPool queryPool, uint32_t query ) const VULKAN_HPP_NOEXCEPT;

      //=== VK_EXT_descriptor_buffer ===

      // wrapper function for command vkCmdBindDescriptorBuffersEXT, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdBindDescriptorBuffersEXT.html
      void bindDescriptorBuffersEXT( ArrayProxy<const DescriptorBufferBindingInfoEXT> const & bindingInfos ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkCmdSetDescriptorBufferOffsetsEXT, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetDescriptorBufferOffsetsEXT.html
      void setDescriptorBufferOffsetsEXT( PipelineBindPoint                    pipelineBindPoint,
                                          VULKAN_HPP_NAMESPACE::PipelineLayout layout,
                                          uint32_t                             firstSet,
                                          ArrayProxy<const uint32_t> const &   bufferIndices,
                                          ArrayProxy<const DeviceSize> const & offsets ) const;

      // wrapper function for command vkCmdBindDescriptorBufferEmbeddedSamplersEXT, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdBindDescriptorBufferEmbeddedSamplersEXT.html
      void bindDescriptorBufferEmbeddedSamplersEXT( PipelineBindPoint                    pipelineBindPoint,
                                                    VULKAN_HPP_NAMESPACE::PipelineLayout layout,
                                                    uint32_t                             set ) const VULKAN_HPP_NOEXCEPT;

      //=== VK_NV_fragment_shading_rate_enums ===

      // wrapper function for command vkCmdSetFragmentShadingRateEnumNV, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetFragmentShadingRateEnumNV.html
      void setFragmentShadingRateEnumNV( FragmentShadingRateNV shadingRate, const FragmentShadingRateCombinerOpKHR combinerOps[2] ) const VULKAN_HPP_NOEXCEPT;

      //=== VK_EXT_mesh_shader ===

      // wrapper function for command vkCmdDrawMeshTasksEXT, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdDrawMeshTasksEXT.html
      void drawMeshTasksEXT( uint32_t groupCountX, uint32_t groupCountY, uint32_t groupCountZ ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkCmdDrawMeshTasksIndirectEXT, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdDrawMeshTasksIndirectEXT.html
      void drawMeshTasksIndirectEXT( VULKAN_HPP_NAMESPACE::Buffer buffer, DeviceSize offset, uint32_t drawCount, uint32_t stride ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkCmdDrawMeshTasksIndirectCountEXT, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdDrawMeshTasksIndirectCountEXT.html
      void drawMeshTasksIndirectCountEXT( VULKAN_HPP_NAMESPACE::Buffer buffer,
                                          DeviceSize                   offset,
                                          VULKAN_HPP_NAMESPACE::Buffer countBuffer,
                                          DeviceSize                   countBufferOffset,
                                          uint32_t                     maxDrawCount,
                                          uint32_t                     stride ) const VULKAN_HPP_NOEXCEPT;

      //=== VK_KHR_copy_commands2 ===

      // wrapper function for command vkCmdCopyBuffer2KHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdCopyBuffer2KHR.html
      void copyBuffer2KHR( const CopyBufferInfo2 & copyBufferInfo ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkCmdCopyImage2KHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdCopyImage2KHR.html
      void copyImage2KHR( const CopyImageInfo2 & copyImageInfo ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkCmdCopyBufferToImage2KHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdCopyBufferToImage2KHR.html
      void copyBufferToImage2KHR( const CopyBufferToImageInfo2 & copyBufferToImageInfo ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkCmdCopyImageToBuffer2KHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdCopyImageToBuffer2KHR.html
      void copyImageToBuffer2KHR( const CopyImageToBufferInfo2 & copyImageToBufferInfo ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkCmdBlitImage2KHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdBlitImage2KHR.html
      void blitImage2KHR( const BlitImageInfo2 & blitImageInfo ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkCmdResolveImage2KHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdResolveImage2KHR.html
      void resolveImage2KHR( const ResolveImageInfo2 & resolveImageInfo ) const VULKAN_HPP_NOEXCEPT;

      //=== VK_EXT_vertex_input_dynamic_state ===

      // wrapper function for command vkCmdSetVertexInputEXT, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetVertexInputEXT.html
      void setVertexInputEXT( ArrayProxy<const VertexInputBindingDescription2EXT> const &   vertexBindingDescriptions,
                              ArrayProxy<const VertexInputAttributeDescription2EXT> const & vertexAttributeDescriptions ) const VULKAN_HPP_NOEXCEPT;

      //=== VK_HUAWEI_subpass_shading ===

      // wrapper function for command vkCmdSubpassShadingHUAWEI, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSubpassShadingHUAWEI.html
      void subpassShadingHUAWEI() const VULKAN_HPP_NOEXCEPT;

      //=== VK_HUAWEI_invocation_mask ===

      // wrapper function for command vkCmdBindInvocationMaskHUAWEI, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdBindInvocationMaskHUAWEI.html
      void bindInvocationMaskHUAWEI( VULKAN_HPP_NAMESPACE::ImageView imageView, ImageLayout imageLayout ) const VULKAN_HPP_NOEXCEPT;

      //=== VK_EXT_extended_dynamic_state2 ===

      // wrapper function for command vkCmdSetPatchControlPointsEXT, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetPatchControlPointsEXT.html
      void setPatchControlPointsEXT( uint32_t patchControlPoints ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkCmdSetRasterizerDiscardEnableEXT, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetRasterizerDiscardEnableEXT.html
      void setRasterizerDiscardEnableEXT( Bool32 rasterizerDiscardEnable ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkCmdSetDepthBiasEnableEXT, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetDepthBiasEnableEXT.html
      void setDepthBiasEnableEXT( Bool32 depthBiasEnable ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkCmdSetLogicOpEXT, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetLogicOpEXT.html
      void setLogicOpEXT( LogicOp logicOp ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkCmdSetPrimitiveRestartEnableEXT, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetPrimitiveRestartEnableEXT.html
      void setPrimitiveRestartEnableEXT( Bool32 primitiveRestartEnable ) const VULKAN_HPP_NOEXCEPT;

      //=== VK_EXT_color_write_enable ===

      // wrapper function for command vkCmdSetColorWriteEnableEXT, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetColorWriteEnableEXT.html
      void setColorWriteEnableEXT( ArrayProxy<const Bool32> const & colorWriteEnables ) const VULKAN_HPP_NOEXCEPT;

      //=== VK_KHR_ray_tracing_maintenance1 ===

      // wrapper function for command vkCmdTraceRaysIndirect2KHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdTraceRaysIndirect2KHR.html
      void traceRaysIndirect2KHR( DeviceAddress indirectDeviceAddress ) const VULKAN_HPP_NOEXCEPT;

      //=== VK_EXT_multi_draw ===

      // wrapper function for command vkCmdDrawMultiEXT, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdDrawMultiEXT.html
      void
        drawMultiEXT( StridedArrayProxy<const MultiDrawInfoEXT> const & vertexInfo, uint32_t instanceCount, uint32_t firstInstance ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkCmdDrawMultiIndexedEXT, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdDrawMultiIndexedEXT.html
      void drawMultiIndexedEXT( StridedArrayProxy<const MultiDrawIndexedInfoEXT> const & indexInfo,
                                uint32_t                                                 instanceCount,
                                uint32_t                                                 firstInstance,
                                Optional<const int32_t> vertexOffset                     VULKAN_HPP_DEFAULT_ASSIGNMENT( nullptr ) ) const VULKAN_HPP_NOEXCEPT;

      //=== VK_EXT_opacity_micromap ===

      // wrapper function for command vkCmdBuildMicromapsEXT, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdBuildMicromapsEXT.html
      void buildMicromapsEXT( ArrayProxy<const MicromapBuildInfoEXT> const & infos ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkCmdCopyMicromapEXT, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdCopyMicromapEXT.html
      void copyMicromapEXT( const CopyMicromapInfoEXT & info ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkCmdCopyMicromapToMemoryEXT, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdCopyMicromapToMemoryEXT.html
      void copyMicromapToMemoryEXT( const CopyMicromapToMemoryInfoEXT & info ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkCmdCopyMemoryToMicromapEXT, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdCopyMemoryToMicromapEXT.html
      void copyMemoryToMicromapEXT( const CopyMemoryToMicromapInfoEXT & info ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkCmdWriteMicromapsPropertiesEXT, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdWriteMicromapsPropertiesEXT.html
      void writeMicromapsPropertiesEXT( ArrayProxy<const VULKAN_HPP_NAMESPACE::MicromapEXT> const & micromaps,
                                        QueryType                                                   queryType,
                                        VULKAN_HPP_NAMESPACE::QueryPool                             queryPool,
                                        uint32_t                                                    firstQuery ) const VULKAN_HPP_NOEXCEPT;

      //=== VK_HUAWEI_cluster_culling_shader ===

      // wrapper function for command vkCmdDrawClusterHUAWEI, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdDrawClusterHUAWEI.html
      void drawClusterHUAWEI( uint32_t groupCountX, uint32_t groupCountY, uint32_t groupCountZ ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkCmdDrawClusterIndirectHUAWEI, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdDrawClusterIndirectHUAWEI.html
      void drawClusterIndirectHUAWEI( VULKAN_HPP_NAMESPACE::Buffer buffer, DeviceSize offset ) const VULKAN_HPP_NOEXCEPT;

      //=== VK_NV_copy_memory_indirect ===

      // wrapper function for command vkCmdCopyMemoryIndirectNV, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdCopyMemoryIndirectNV.html
      void copyMemoryIndirectNV( DeviceAddress copyBufferAddress, uint32_t copyCount, uint32_t stride ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkCmdCopyMemoryToImageIndirectNV, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdCopyMemoryToImageIndirectNV.html
      void copyMemoryToImageIndirectNV( DeviceAddress                                    copyBufferAddress,
                                        uint32_t                                         stride,
                                        VULKAN_HPP_NAMESPACE::Image                      dstImage,
                                        ImageLayout                                      dstImageLayout,
                                        ArrayProxy<const ImageSubresourceLayers> const & imageSubresources ) const VULKAN_HPP_NOEXCEPT;

      //=== VK_NV_memory_decompression ===

      // wrapper function for command vkCmdDecompressMemoryNV, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdDecompressMemoryNV.html
      void decompressMemoryNV( ArrayProxy<const DecompressMemoryRegionNV> const & decompressMemoryRegions ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkCmdDecompressMemoryIndirectCountNV, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdDecompressMemoryIndirectCountNV.html
      void decompressMemoryIndirectCountNV( DeviceAddress indirectCommandsAddress,
                                            DeviceAddress indirectCommandsCountAddress,
                                            uint32_t      stride ) const VULKAN_HPP_NOEXCEPT;

      //=== VK_NV_device_generated_commands_compute ===

      // wrapper function for command vkCmdUpdatePipelineIndirectBufferNV, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdUpdatePipelineIndirectBufferNV.html
      void updatePipelineIndirectBufferNV( PipelineBindPoint pipelineBindPoint, VULKAN_HPP_NAMESPACE::Pipeline pipeline ) const VULKAN_HPP_NOEXCEPT;

      //=== VK_EXT_extended_dynamic_state3 ===

      // wrapper function for command vkCmdSetDepthClampEnableEXT, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetDepthClampEnableEXT.html
      void setDepthClampEnableEXT( Bool32 depthClampEnable ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkCmdSetPolygonModeEXT, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetPolygonModeEXT.html
      void setPolygonModeEXT( PolygonMode polygonMode ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkCmdSetRasterizationSamplesEXT, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetRasterizationSamplesEXT.html
      void setRasterizationSamplesEXT( SampleCountFlagBits rasterizationSamples ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkCmdSetSampleMaskEXT, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetSampleMaskEXT.html
      void setSampleMaskEXT( SampleCountFlagBits samples, ArrayProxy<const SampleMask> const & sampleMask VULKAN_HPP_DEFAULT_ASSIGNMENT( nullptr ) ) const;

      // wrapper function for command vkCmdSetAlphaToCoverageEnableEXT, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetAlphaToCoverageEnableEXT.html
      void setAlphaToCoverageEnableEXT( Bool32 alphaToCoverageEnable ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkCmdSetAlphaToOneEnableEXT, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetAlphaToOneEnableEXT.html
      void setAlphaToOneEnableEXT( Bool32 alphaToOneEnable ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkCmdSetLogicOpEnableEXT, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetLogicOpEnableEXT.html
      void setLogicOpEnableEXT( Bool32 logicOpEnable ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkCmdSetColorBlendEnableEXT, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetColorBlendEnableEXT.html
      void setColorBlendEnableEXT( uint32_t firstAttachment, ArrayProxy<const Bool32> const & colorBlendEnables ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkCmdSetColorBlendEquationEXT, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetColorBlendEquationEXT.html
      void setColorBlendEquationEXT( uint32_t firstAttachment, ArrayProxy<const ColorBlendEquationEXT> const & colorBlendEquations ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkCmdSetColorWriteMaskEXT, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetColorWriteMaskEXT.html
      void setColorWriteMaskEXT( uint32_t firstAttachment, ArrayProxy<const ColorComponentFlags> const & colorWriteMasks ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkCmdSetTessellationDomainOriginEXT, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetTessellationDomainOriginEXT.html
      void setTessellationDomainOriginEXT( TessellationDomainOrigin domainOrigin ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkCmdSetRasterizationStreamEXT, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetRasterizationStreamEXT.html
      void setRasterizationStreamEXT( uint32_t rasterizationStream ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkCmdSetConservativeRasterizationModeEXT, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetConservativeRasterizationModeEXT.html
      void setConservativeRasterizationModeEXT( ConservativeRasterizationModeEXT conservativeRasterizationMode ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkCmdSetExtraPrimitiveOverestimationSizeEXT, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetExtraPrimitiveOverestimationSizeEXT.html
      void setExtraPrimitiveOverestimationSizeEXT( float extraPrimitiveOverestimationSize ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkCmdSetDepthClipEnableEXT, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetDepthClipEnableEXT.html
      void setDepthClipEnableEXT( Bool32 depthClipEnable ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkCmdSetSampleLocationsEnableEXT, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetSampleLocationsEnableEXT.html
      void setSampleLocationsEnableEXT( Bool32 sampleLocationsEnable ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkCmdSetColorBlendAdvancedEXT, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetColorBlendAdvancedEXT.html
      void setColorBlendAdvancedEXT( uint32_t firstAttachment, ArrayProxy<const ColorBlendAdvancedEXT> const & colorBlendAdvanced ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkCmdSetProvokingVertexModeEXT, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetProvokingVertexModeEXT.html
      void setProvokingVertexModeEXT( ProvokingVertexModeEXT provokingVertexMode ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkCmdSetLineRasterizationModeEXT, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetLineRasterizationModeEXT.html
      void setLineRasterizationModeEXT( LineRasterizationModeEXT lineRasterizationMode ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkCmdSetLineStippleEnableEXT, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetLineStippleEnableEXT.html
      void setLineStippleEnableEXT( Bool32 stippledLineEnable ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkCmdSetDepthClipNegativeOneToOneEXT, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetDepthClipNegativeOneToOneEXT.html
      void setDepthClipNegativeOneToOneEXT( Bool32 negativeOneToOne ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkCmdSetViewportWScalingEnableNV, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetViewportWScalingEnableNV.html
      void setViewportWScalingEnableNV( Bool32 viewportWScalingEnable ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkCmdSetViewportSwizzleNV, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetViewportSwizzleNV.html
      void setViewportSwizzleNV( uint32_t firstViewport, ArrayProxy<const ViewportSwizzleNV> const & viewportSwizzles ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkCmdSetCoverageToColorEnableNV, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetCoverageToColorEnableNV.html
      void setCoverageToColorEnableNV( Bool32 coverageToColorEnable ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkCmdSetCoverageToColorLocationNV, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetCoverageToColorLocationNV.html
      void setCoverageToColorLocationNV( uint32_t coverageToColorLocation ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkCmdSetCoverageModulationModeNV, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetCoverageModulationModeNV.html
      void setCoverageModulationModeNV( CoverageModulationModeNV coverageModulationMode ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkCmdSetCoverageModulationTableEnableNV, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetCoverageModulationTableEnableNV.html
      void setCoverageModulationTableEnableNV( Bool32 coverageModulationTableEnable ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkCmdSetCoverageModulationTableNV, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetCoverageModulationTableNV.html
      void setCoverageModulationTableNV( ArrayProxy<const float> const & coverageModulationTable ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkCmdSetShadingRateImageEnableNV, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetShadingRateImageEnableNV.html
      void setShadingRateImageEnableNV( Bool32 shadingRateImageEnable ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkCmdSetRepresentativeFragmentTestEnableNV, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetRepresentativeFragmentTestEnableNV.html
      void setRepresentativeFragmentTestEnableNV( Bool32 representativeFragmentTestEnable ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkCmdSetCoverageReductionModeNV, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetCoverageReductionModeNV.html
      void setCoverageReductionModeNV( CoverageReductionModeNV coverageReductionMode ) const VULKAN_HPP_NOEXCEPT;

      //=== VK_ARM_tensors ===

      // wrapper function for command vkCmdCopyTensorARM, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdCopyTensorARM.html
      void copyTensorARM( const CopyTensorInfoARM & copyTensorInfo ) const VULKAN_HPP_NOEXCEPT;

      //=== VK_NV_optical_flow ===

      // wrapper function for command vkCmdOpticalFlowExecuteNV, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdOpticalFlowExecuteNV.html
      void opticalFlowExecuteNV( VULKAN_HPP_NAMESPACE::OpticalFlowSessionNV session, const OpticalFlowExecuteInfoNV & executeInfo ) const VULKAN_HPP_NOEXCEPT;

      //=== VK_KHR_maintenance5 ===

      // wrapper function for command vkCmdBindIndexBuffer2KHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdBindIndexBuffer2KHR.html
      void bindIndexBuffer2KHR( VULKAN_HPP_NAMESPACE::Buffer buffer, DeviceSize offset, DeviceSize size, IndexType indexType ) const VULKAN_HPP_NOEXCEPT;

      //=== VK_EXT_shader_object ===

      // wrapper function for command vkCmdBindShadersEXT, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdBindShadersEXT.html
      void bindShadersEXT( ArrayProxy<const ShaderStageFlagBits> const & stages, ArrayProxy<const VULKAN_HPP_NAMESPACE::ShaderEXT> const & shaders ) const;

      // wrapper function for command vkCmdSetDepthClampRangeEXT, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetDepthClampRangeEXT.html
      void setDepthClampRangeEXT( DepthClampModeEXT                                  depthClampMode,
                                  Optional<const DepthClampRangeEXT> depthClampRange VULKAN_HPP_DEFAULT_ASSIGNMENT( nullptr ) ) const VULKAN_HPP_NOEXCEPT;

      //=== VK_NV_cooperative_vector ===

      // wrapper function for command vkCmdConvertCooperativeVectorMatrixNV, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdConvertCooperativeVectorMatrixNV.html
      void convertCooperativeVectorMatrixNV( ArrayProxy<const ConvertCooperativeVectorMatrixInfoNV> const & infos ) const VULKAN_HPP_NOEXCEPT;

      //=== VK_ARM_data_graph ===

      // wrapper function for command vkCmdDispatchDataGraphARM, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdDispatchDataGraphARM.html
      void dispatchDataGraphARM( VULKAN_HPP_NAMESPACE::DataGraphPipelineSessionARM     session,
                                 Optional<const DataGraphPipelineDispatchInfoARM> info VULKAN_HPP_DEFAULT_ASSIGNMENT( nullptr ) ) const VULKAN_HPP_NOEXCEPT;

      //=== VK_EXT_attachment_feedback_loop_dynamic_state ===

      // wrapper function for command vkCmdSetAttachmentFeedbackLoopEnableEXT, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetAttachmentFeedbackLoopEnableEXT.html
      void setAttachmentFeedbackLoopEnableEXT( ImageAspectFlags aspectMask VULKAN_HPP_DEFAULT_ASSIGNMENT( {} ) ) const VULKAN_HPP_NOEXCEPT;

      //=== VK_KHR_line_rasterization ===

      // wrapper function for command vkCmdSetLineStippleKHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetLineStippleKHR.html
      void setLineStippleKHR( uint32_t lineStippleFactor, uint16_t lineStipplePattern ) const VULKAN_HPP_NOEXCEPT;

      //=== VK_KHR_maintenance6 ===

      // wrapper function for command vkCmdBindDescriptorSets2KHR, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdBindDescriptorSets2KHR.html
      void bindDescriptorSets2KHR( const BindDescriptorSetsInfo & bindDescriptorSetsInfo ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkCmdPushConstants2KHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdPushConstants2KHR.html
      void pushConstants2KHR( const PushConstantsInfo & pushConstantsInfo ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkCmdPushDescriptorSet2KHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdPushDescriptorSet2KHR.html
      void pushDescriptorSet2KHR( const PushDescriptorSetInfo & pushDescriptorSetInfo ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkCmdPushDescriptorSetWithTemplate2KHR, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdPushDescriptorSetWithTemplate2KHR.html
      void pushDescriptorSetWithTemplate2KHR( const PushDescriptorSetWithTemplateInfo & pushDescriptorSetWithTemplateInfo ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkCmdSetDescriptorBufferOffsets2EXT, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetDescriptorBufferOffsets2EXT.html
      void setDescriptorBufferOffsets2EXT( const SetDescriptorBufferOffsetsInfoEXT & setDescriptorBufferOffsetsInfo ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkCmdBindDescriptorBufferEmbeddedSamplers2EXT, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdBindDescriptorBufferEmbeddedSamplers2EXT.html
      void bindDescriptorBufferEmbeddedSamplers2EXT( const BindDescriptorBufferEmbeddedSamplersInfoEXT & bindDescriptorBufferEmbeddedSamplersInfo ) const
        VULKAN_HPP_NOEXCEPT;

      //=== VK_QCOM_tile_memory_heap ===

      // wrapper function for command vkCmdBindTileMemoryQCOM, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdBindTileMemoryQCOM.html
      void bindTileMemoryQCOM( Optional<const TileMemoryBindInfoQCOM> tileMemoryBindInfo VULKAN_HPP_DEFAULT_ASSIGNMENT( nullptr ) ) const VULKAN_HPP_NOEXCEPT;

      //=== VK_KHR_copy_memory_indirect ===

      // wrapper function for command vkCmdCopyMemoryIndirectKHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdCopyMemoryIndirectKHR.html
      void copyMemoryIndirectKHR( const CopyMemoryIndirectInfoKHR & copyMemoryIndirectInfo ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkCmdCopyMemoryToImageIndirectKHR, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdCopyMemoryToImageIndirectKHR.html
      void copyMemoryToImageIndirectKHR( const CopyMemoryToImageIndirectInfoKHR & copyMemoryToImageIndirectInfo ) const VULKAN_HPP_NOEXCEPT;

      //=== VK_EXT_memory_decompression ===

      // wrapper function for command vkCmdDecompressMemoryEXT, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdDecompressMemoryEXT.html
      void decompressMemoryEXT( const DecompressMemoryInfoEXT & decompressMemoryInfoEXT ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkCmdDecompressMemoryIndirectCountEXT, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdDecompressMemoryIndirectCountEXT.html
      void decompressMemoryIndirectCountEXT( MemoryDecompressionMethodFlagsEXT decompressionMethod,
                                             DeviceAddress                     indirectCommandsAddress,
                                             DeviceAddress                     indirectCommandsCountAddress,
                                             uint32_t                          maxDecompressionCount,
                                             uint32_t                          stride ) const VULKAN_HPP_NOEXCEPT;

      //=== VK_NV_cluster_acceleration_structure ===

      // wrapper function for command vkCmdBuildClusterAccelerationStructureIndirectNV, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdBuildClusterAccelerationStructureIndirectNV.html
      void buildClusterAccelerationStructureIndirectNV( const ClusterAccelerationStructureCommandsInfoNV & commandInfos ) const VULKAN_HPP_NOEXCEPT;

      //=== VK_NV_partitioned_acceleration_structure ===

      // wrapper function for command vkCmdBuildPartitionedAccelerationStructuresNV, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdBuildPartitionedAccelerationStructuresNV.html
      void buildPartitionedAccelerationStructuresNV( const BuildPartitionedAccelerationStructureInfoNV & buildInfo ) const VULKAN_HPP_NOEXCEPT;

      //=== VK_EXT_device_generated_commands ===

      // wrapper function for command vkCmdPreprocessGeneratedCommandsEXT, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdPreprocessGeneratedCommandsEXT.html
      void preprocessGeneratedCommandsEXT( const GeneratedCommandsInfoEXT &    generatedCommandsInfo,
                                           VULKAN_HPP_NAMESPACE::CommandBuffer stateCommandBuffer ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkCmdExecuteGeneratedCommandsEXT, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdExecuteGeneratedCommandsEXT.html
      void executeGeneratedCommandsEXT( Bool32 isPreprocessed, const GeneratedCommandsInfoEXT & generatedCommandsInfo ) const VULKAN_HPP_NOEXCEPT;

      //=== VK_EXT_fragment_density_map_offset ===

      // wrapper function for command vkCmdEndRendering2EXT, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdEndRendering2EXT.html
      void endRendering2EXT( Optional<const RenderingEndInfoKHR> renderingEndInfo VULKAN_HPP_DEFAULT_ASSIGNMENT( nullptr ) ) const VULKAN_HPP_NOEXCEPT;

      //=== VK_EXT_custom_resolve ===

      // wrapper function for command vkCmdBeginCustomResolveEXT, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdBeginCustomResolveEXT.html
      void beginCustomResolveEXT( Optional<const BeginCustomResolveInfoEXT> beginCustomResolveInfo VULKAN_HPP_DEFAULT_ASSIGNMENT( nullptr ) ) const
        VULKAN_HPP_NOEXCEPT;

      //=== VK_KHR_maintenance10 ===

      // wrapper function for command vkCmdEndRendering2KHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdEndRendering2KHR.html
      void endRendering2KHR( Optional<const RenderingEndInfoKHR> renderingEndInfo VULKAN_HPP_DEFAULT_ASSIGNMENT( nullptr ) ) const VULKAN_HPP_NOEXCEPT;

    private:
      VULKAN_HPP_NAMESPACE::Device        m_device        = {};
      VULKAN_HPP_NAMESPACE::CommandPool   m_commandPool   = {};
      VULKAN_HPP_NAMESPACE::CommandBuffer m_commandBuffer = {};
      detail::DeviceDispatcher const *    m_dispatcher    = nullptr;
    };

    template <>
    struct isVulkanRAIIHandleType<CommandBuffer>
    {
      static VULKAN_HPP_CONST_OR_CONSTEXPR bool value = true;
    };

    class CommandBuffers : public std::vector<CommandBuffer>
    {
    public:
#  if !defined( VULKAN_HPP_NO_EXCEPTIONS )
      CommandBuffers( Device const & device, CommandBufferAllocateInfo const & allocateInfo )
      {
        *this = device.allocateCommandBuffers( allocateInfo );
      }
#  endif

      CommandBuffers( std::nullptr_t ) {}

      CommandBuffers()                                     = delete;
      CommandBuffers( CommandBuffers const & )             = delete;
      CommandBuffers( CommandBuffers && rhs )              = default;
      CommandBuffers & operator=( CommandBuffers const & ) = delete;
      CommandBuffers & operator=( CommandBuffers && rhs )  = default;

    private:
      CommandBuffers( std::vector<CommandBuffer> && rhs )
      {
        std::swap( *this, rhs );
      }
    };

    // wrapper class for handle VkCuFunctionNVX, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkCuFunctionNVX.html
    class CuFunctionNVX
    {
    public:
      using CType   = VkCuFunctionNVX;
      using CppType = VULKAN_HPP_NAMESPACE::CuFunctionNVX;

      static VULKAN_HPP_CONST_OR_CONSTEXPR ObjectType               objectType            = ObjectType::eCuFunctionNVX;
      static VULKAN_HPP_CONST_OR_CONSTEXPR DebugReportObjectTypeEXT debugReportObjectType = DebugReportObjectTypeEXT::eCuFunctionNVX;

    public:
#  if !defined( VULKAN_HPP_NO_EXCEPTIONS )
      CuFunctionNVX( Device const & device, CuFunctionCreateInfoNVX const & createInfo, Optional<const AllocationCallbacks> allocator = nullptr )
      {
        *this = device.createCuFunctionNVX( createInfo, allocator );
      }
#  endif

      CuFunctionNVX( Device const & device, VkCuFunctionNVX function, Optional<const AllocationCallbacks> allocator = nullptr )
        : m_device( device )
        , m_cuFunctionNVX( function )
        , m_allocator( static_cast<const AllocationCallbacks *>( allocator ) )
        , m_dispatcher( device.getDispatcher() )
      {
      }

      CuFunctionNVX( std::nullptr_t ) {}

      ~CuFunctionNVX()
      {
        clear();
      }

      CuFunctionNVX()                        = delete;
      CuFunctionNVX( CuFunctionNVX const & ) = delete;

      CuFunctionNVX( CuFunctionNVX && rhs ) VULKAN_HPP_NOEXCEPT
        : m_device( exchange( rhs.m_device, {} ) )
        , m_cuFunctionNVX( exchange( rhs.m_cuFunctionNVX, {} ) )
        , m_allocator( exchange( rhs.m_allocator, {} ) )
        , m_dispatcher( exchange( rhs.m_dispatcher, nullptr ) )
      {
      }

      CuFunctionNVX & operator=( CuFunctionNVX const & ) = delete;

      CuFunctionNVX & operator=( CuFunctionNVX && rhs ) VULKAN_HPP_NOEXCEPT
      {
        if ( this != &rhs )
        {
          std::swap( m_device, rhs.m_device );
          std::swap( m_cuFunctionNVX, rhs.m_cuFunctionNVX );
          std::swap( m_allocator, rhs.m_allocator );
          std::swap( m_dispatcher, rhs.m_dispatcher );
        }
        return *this;
      }

      VULKAN_HPP_NAMESPACE::CuFunctionNVX const & operator*() const & VULKAN_HPP_NOEXCEPT
      {
        return m_cuFunctionNVX;
      }

      VULKAN_HPP_NAMESPACE::CuFunctionNVX const && operator*() const && VULKAN_HPP_NOEXCEPT
      {
        return std::move( m_cuFunctionNVX );
      }

      operator VULKAN_HPP_NAMESPACE::CuFunctionNVX() const VULKAN_HPP_NOEXCEPT
      {
        return m_cuFunctionNVX;
      }

      void clear() VULKAN_HPP_NOEXCEPT
      {
        if ( m_cuFunctionNVX )
        {
          getDispatcher()->vkDestroyCuFunctionNVX( static_cast<VkDevice>( m_device ),
                                                   static_cast<VkCuFunctionNVX>( m_cuFunctionNVX ),
                                                   reinterpret_cast<const VkAllocationCallbacks *>( m_allocator ) );
        }
        m_device        = nullptr;
        m_cuFunctionNVX = nullptr;
        m_allocator     = nullptr;
        m_dispatcher    = nullptr;
      }

      VULKAN_HPP_NAMESPACE::CuFunctionNVX release()
      {
        m_device     = nullptr;
        m_allocator  = nullptr;
        m_dispatcher = nullptr;
        return exchange( m_cuFunctionNVX, nullptr );
      }

      VULKAN_HPP_NAMESPACE::Device getDevice() const
      {
        return m_device;
      }

      detail::DeviceDispatcher const * getDispatcher() const
      {
        VULKAN_HPP_ASSERT( m_dispatcher->getVkHeaderVersion() == VK_HEADER_VERSION );
        return m_dispatcher;
      }

      void swap( CuFunctionNVX & rhs ) VULKAN_HPP_NOEXCEPT
      {
        std::swap( m_device, rhs.m_device );
        std::swap( m_cuFunctionNVX, rhs.m_cuFunctionNVX );
        std::swap( m_allocator, rhs.m_allocator );
        std::swap( m_dispatcher, rhs.m_dispatcher );
      }

    private:
      VULKAN_HPP_NAMESPACE::Device        m_device        = {};
      VULKAN_HPP_NAMESPACE::CuFunctionNVX m_cuFunctionNVX = {};
      const AllocationCallbacks *         m_allocator     = {};
      detail::DeviceDispatcher const *    m_dispatcher    = nullptr;
    };

    template <>
    struct isVulkanRAIIHandleType<CuFunctionNVX>
    {
      static VULKAN_HPP_CONST_OR_CONSTEXPR bool value = true;
    };

    // wrapper class for handle VkCuModuleNVX, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkCuModuleNVX.html
    class CuModuleNVX
    {
    public:
      using CType   = VkCuModuleNVX;
      using CppType = VULKAN_HPP_NAMESPACE::CuModuleNVX;

      static VULKAN_HPP_CONST_OR_CONSTEXPR ObjectType               objectType            = ObjectType::eCuModuleNVX;
      static VULKAN_HPP_CONST_OR_CONSTEXPR DebugReportObjectTypeEXT debugReportObjectType = DebugReportObjectTypeEXT::eCuModuleNVX;

    public:
#  if !defined( VULKAN_HPP_NO_EXCEPTIONS )
      CuModuleNVX( Device const & device, CuModuleCreateInfoNVX const & createInfo, Optional<const AllocationCallbacks> allocator = nullptr )
      {
        *this = device.createCuModuleNVX( createInfo, allocator );
      }
#  endif

      CuModuleNVX( Device const & device, VkCuModuleNVX module, Optional<const AllocationCallbacks> allocator = nullptr )
        : m_device( device )
        , m_cuModuleNVX( module )
        , m_allocator( static_cast<const AllocationCallbacks *>( allocator ) )
        , m_dispatcher( device.getDispatcher() )
      {
      }

      CuModuleNVX( std::nullptr_t ) {}

      ~CuModuleNVX()
      {
        clear();
      }

      CuModuleNVX()                      = delete;
      CuModuleNVX( CuModuleNVX const & ) = delete;

      CuModuleNVX( CuModuleNVX && rhs ) VULKAN_HPP_NOEXCEPT
        : m_device( exchange( rhs.m_device, {} ) )
        , m_cuModuleNVX( exchange( rhs.m_cuModuleNVX, {} ) )
        , m_allocator( exchange( rhs.m_allocator, {} ) )
        , m_dispatcher( exchange( rhs.m_dispatcher, nullptr ) )
      {
      }

      CuModuleNVX & operator=( CuModuleNVX const & ) = delete;

      CuModuleNVX & operator=( CuModuleNVX && rhs ) VULKAN_HPP_NOEXCEPT
      {
        if ( this != &rhs )
        {
          std::swap( m_device, rhs.m_device );
          std::swap( m_cuModuleNVX, rhs.m_cuModuleNVX );
          std::swap( m_allocator, rhs.m_allocator );
          std::swap( m_dispatcher, rhs.m_dispatcher );
        }
        return *this;
      }

      VULKAN_HPP_NAMESPACE::CuModuleNVX const & operator*() const & VULKAN_HPP_NOEXCEPT
      {
        return m_cuModuleNVX;
      }

      VULKAN_HPP_NAMESPACE::CuModuleNVX const && operator*() const && VULKAN_HPP_NOEXCEPT
      {
        return std::move( m_cuModuleNVX );
      }

      operator VULKAN_HPP_NAMESPACE::CuModuleNVX() const VULKAN_HPP_NOEXCEPT
      {
        return m_cuModuleNVX;
      }

      void clear() VULKAN_HPP_NOEXCEPT
      {
        if ( m_cuModuleNVX )
        {
          getDispatcher()->vkDestroyCuModuleNVX(
            static_cast<VkDevice>( m_device ), static_cast<VkCuModuleNVX>( m_cuModuleNVX ), reinterpret_cast<const VkAllocationCallbacks *>( m_allocator ) );
        }
        m_device      = nullptr;
        m_cuModuleNVX = nullptr;
        m_allocator   = nullptr;
        m_dispatcher  = nullptr;
      }

      VULKAN_HPP_NAMESPACE::CuModuleNVX release()
      {
        m_device     = nullptr;
        m_allocator  = nullptr;
        m_dispatcher = nullptr;
        return exchange( m_cuModuleNVX, nullptr );
      }

      VULKAN_HPP_NAMESPACE::Device getDevice() const
      {
        return m_device;
      }

      detail::DeviceDispatcher const * getDispatcher() const
      {
        VULKAN_HPP_ASSERT( m_dispatcher->getVkHeaderVersion() == VK_HEADER_VERSION );
        return m_dispatcher;
      }

      void swap( CuModuleNVX & rhs ) VULKAN_HPP_NOEXCEPT
      {
        std::swap( m_device, rhs.m_device );
        std::swap( m_cuModuleNVX, rhs.m_cuModuleNVX );
        std::swap( m_allocator, rhs.m_allocator );
        std::swap( m_dispatcher, rhs.m_dispatcher );
      }

    private:
      VULKAN_HPP_NAMESPACE::Device      m_device      = {};
      VULKAN_HPP_NAMESPACE::CuModuleNVX m_cuModuleNVX = {};
      const AllocationCallbacks *       m_allocator   = {};
      detail::DeviceDispatcher const *  m_dispatcher  = nullptr;
    };

    template <>
    struct isVulkanRAIIHandleType<CuModuleNVX>
    {
      static VULKAN_HPP_CONST_OR_CONSTEXPR bool value = true;
    };

    // wrapper class for handle VkCudaFunctionNV, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkCudaFunctionNV.html
#  if defined( VK_ENABLE_BETA_EXTENSIONS )
    class CudaFunctionNV
    {
    public:
      using CType   = VkCudaFunctionNV;
      using CppType = VULKAN_HPP_NAMESPACE::CudaFunctionNV;

      static VULKAN_HPP_CONST_OR_CONSTEXPR ObjectType               objectType            = ObjectType::eCudaFunctionNV;
      static VULKAN_HPP_CONST_OR_CONSTEXPR DebugReportObjectTypeEXT debugReportObjectType = DebugReportObjectTypeEXT::eCudaFunctionNV;

    public:
#    if !defined( VULKAN_HPP_NO_EXCEPTIONS )
      CudaFunctionNV( Device const & device, CudaFunctionCreateInfoNV const & createInfo, Optional<const AllocationCallbacks> allocator = nullptr )
      {
        *this = device.createCudaFunctionNV( createInfo, allocator );
      }
#    endif

      CudaFunctionNV( Device const & device, VkCudaFunctionNV function, Optional<const AllocationCallbacks> allocator = nullptr )
        : m_device( device )
        , m_cudaFunctionNV( function )
        , m_allocator( static_cast<const AllocationCallbacks *>( allocator ) )
        , m_dispatcher( device.getDispatcher() )
      {
      }

      CudaFunctionNV( std::nullptr_t ) {}

      ~CudaFunctionNV()
      {
        clear();
      }

      CudaFunctionNV()                         = delete;
      CudaFunctionNV( CudaFunctionNV const & ) = delete;

      CudaFunctionNV( CudaFunctionNV && rhs ) VULKAN_HPP_NOEXCEPT
        : m_device( exchange( rhs.m_device, {} ) )
        , m_cudaFunctionNV( exchange( rhs.m_cudaFunctionNV, {} ) )
        , m_allocator( exchange( rhs.m_allocator, {} ) )
        , m_dispatcher( exchange( rhs.m_dispatcher, nullptr ) )
      {
      }

      CudaFunctionNV & operator=( CudaFunctionNV const & ) = delete;

      CudaFunctionNV & operator=( CudaFunctionNV && rhs ) VULKAN_HPP_NOEXCEPT
      {
        if ( this != &rhs )
        {
          std::swap( m_device, rhs.m_device );
          std::swap( m_cudaFunctionNV, rhs.m_cudaFunctionNV );
          std::swap( m_allocator, rhs.m_allocator );
          std::swap( m_dispatcher, rhs.m_dispatcher );
        }
        return *this;
      }

      VULKAN_HPP_NAMESPACE::CudaFunctionNV const & operator*() const & VULKAN_HPP_NOEXCEPT
      {
        return m_cudaFunctionNV;
      }

      VULKAN_HPP_NAMESPACE::CudaFunctionNV const && operator*() const && VULKAN_HPP_NOEXCEPT
      {
        return std::move( m_cudaFunctionNV );
      }

      operator VULKAN_HPP_NAMESPACE::CudaFunctionNV() const VULKAN_HPP_NOEXCEPT
      {
        return m_cudaFunctionNV;
      }

      void clear() VULKAN_HPP_NOEXCEPT
      {
        if ( m_cudaFunctionNV )
        {
          getDispatcher()->vkDestroyCudaFunctionNV( static_cast<VkDevice>( m_device ),
                                                    static_cast<VkCudaFunctionNV>( m_cudaFunctionNV ),
                                                    reinterpret_cast<const VkAllocationCallbacks *>( m_allocator ) );
        }
        m_device         = nullptr;
        m_cudaFunctionNV = nullptr;
        m_allocator      = nullptr;
        m_dispatcher     = nullptr;
      }

      VULKAN_HPP_NAMESPACE::CudaFunctionNV release()
      {
        m_device     = nullptr;
        m_allocator  = nullptr;
        m_dispatcher = nullptr;
        return exchange( m_cudaFunctionNV, nullptr );
      }

      VULKAN_HPP_NAMESPACE::Device getDevice() const
      {
        return m_device;
      }

      detail::DeviceDispatcher const * getDispatcher() const
      {
        VULKAN_HPP_ASSERT( m_dispatcher->getVkHeaderVersion() == VK_HEADER_VERSION );
        return m_dispatcher;
      }

      void swap( CudaFunctionNV & rhs ) VULKAN_HPP_NOEXCEPT
      {
        std::swap( m_device, rhs.m_device );
        std::swap( m_cudaFunctionNV, rhs.m_cudaFunctionNV );
        std::swap( m_allocator, rhs.m_allocator );
        std::swap( m_dispatcher, rhs.m_dispatcher );
      }

    private:
      VULKAN_HPP_NAMESPACE::Device         m_device         = {};
      VULKAN_HPP_NAMESPACE::CudaFunctionNV m_cudaFunctionNV = {};
      const AllocationCallbacks *          m_allocator      = {};
      detail::DeviceDispatcher const *     m_dispatcher     = nullptr;
    };

    template <>
    struct isVulkanRAIIHandleType<CudaFunctionNV>
    {
      static VULKAN_HPP_CONST_OR_CONSTEXPR bool value = true;
    };

#  endif /*VK_ENABLE_BETA_EXTENSIONS*/

    // wrapper class for handle VkCudaModuleNV, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkCudaModuleNV.html
#  if defined( VK_ENABLE_BETA_EXTENSIONS )
    class CudaModuleNV
    {
    public:
      using CType   = VkCudaModuleNV;
      using CppType = VULKAN_HPP_NAMESPACE::CudaModuleNV;

      static VULKAN_HPP_CONST_OR_CONSTEXPR ObjectType               objectType            = ObjectType::eCudaModuleNV;
      static VULKAN_HPP_CONST_OR_CONSTEXPR DebugReportObjectTypeEXT debugReportObjectType = DebugReportObjectTypeEXT::eCudaModuleNV;

    public:
#    if !defined( VULKAN_HPP_NO_EXCEPTIONS )
      CudaModuleNV( Device const & device, CudaModuleCreateInfoNV const & createInfo, Optional<const AllocationCallbacks> allocator = nullptr )
      {
        *this = device.createCudaModuleNV( createInfo, allocator );
      }
#    endif

      CudaModuleNV( Device const & device, VkCudaModuleNV module, Optional<const AllocationCallbacks> allocator = nullptr )
        : m_device( device )
        , m_cudaModuleNV( module )
        , m_allocator( static_cast<const AllocationCallbacks *>( allocator ) )
        , m_dispatcher( device.getDispatcher() )
      {
      }

      CudaModuleNV( std::nullptr_t ) {}

      ~CudaModuleNV()
      {
        clear();
      }

      CudaModuleNV()                       = delete;
      CudaModuleNV( CudaModuleNV const & ) = delete;

      CudaModuleNV( CudaModuleNV && rhs ) VULKAN_HPP_NOEXCEPT
        : m_device( exchange( rhs.m_device, {} ) )
        , m_cudaModuleNV( exchange( rhs.m_cudaModuleNV, {} ) )
        , m_allocator( exchange( rhs.m_allocator, {} ) )
        , m_dispatcher( exchange( rhs.m_dispatcher, nullptr ) )
      {
      }

      CudaModuleNV & operator=( CudaModuleNV const & ) = delete;

      CudaModuleNV & operator=( CudaModuleNV && rhs ) VULKAN_HPP_NOEXCEPT
      {
        if ( this != &rhs )
        {
          std::swap( m_device, rhs.m_device );
          std::swap( m_cudaModuleNV, rhs.m_cudaModuleNV );
          std::swap( m_allocator, rhs.m_allocator );
          std::swap( m_dispatcher, rhs.m_dispatcher );
        }
        return *this;
      }

      VULKAN_HPP_NAMESPACE::CudaModuleNV const & operator*() const & VULKAN_HPP_NOEXCEPT
      {
        return m_cudaModuleNV;
      }

      VULKAN_HPP_NAMESPACE::CudaModuleNV const && operator*() const && VULKAN_HPP_NOEXCEPT
      {
        return std::move( m_cudaModuleNV );
      }

      operator VULKAN_HPP_NAMESPACE::CudaModuleNV() const VULKAN_HPP_NOEXCEPT
      {
        return m_cudaModuleNV;
      }

      void clear() VULKAN_HPP_NOEXCEPT
      {
        if ( m_cudaModuleNV )
        {
          getDispatcher()->vkDestroyCudaModuleNV(
            static_cast<VkDevice>( m_device ), static_cast<VkCudaModuleNV>( m_cudaModuleNV ), reinterpret_cast<const VkAllocationCallbacks *>( m_allocator ) );
        }
        m_device       = nullptr;
        m_cudaModuleNV = nullptr;
        m_allocator    = nullptr;
        m_dispatcher   = nullptr;
      }

      VULKAN_HPP_NAMESPACE::CudaModuleNV release()
      {
        m_device     = nullptr;
        m_allocator  = nullptr;
        m_dispatcher = nullptr;
        return exchange( m_cudaModuleNV, nullptr );
      }

      VULKAN_HPP_NAMESPACE::Device getDevice() const
      {
        return m_device;
      }

      detail::DeviceDispatcher const * getDispatcher() const
      {
        VULKAN_HPP_ASSERT( m_dispatcher->getVkHeaderVersion() == VK_HEADER_VERSION );
        return m_dispatcher;
      }

      void swap( CudaModuleNV & rhs ) VULKAN_HPP_NOEXCEPT
      {
        std::swap( m_device, rhs.m_device );
        std::swap( m_cudaModuleNV, rhs.m_cudaModuleNV );
        std::swap( m_allocator, rhs.m_allocator );
        std::swap( m_dispatcher, rhs.m_dispatcher );
      }

      //=== VK_NV_cuda_kernel_launch ===

      // wrapper function for command vkGetCudaModuleCacheNV, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetCudaModuleCacheNV.html
      VULKAN_HPP_NODISCARD typename ResultValueType<std::vector<uint8_t>>::type getCache() const;

    private:
      VULKAN_HPP_NAMESPACE::Device       m_device       = {};
      VULKAN_HPP_NAMESPACE::CudaModuleNV m_cudaModuleNV = {};
      const AllocationCallbacks *        m_allocator    = {};
      detail::DeviceDispatcher const *   m_dispatcher   = nullptr;
    };

    template <>
    struct isVulkanRAIIHandleType<CudaModuleNV>
    {
      static VULKAN_HPP_CONST_OR_CONSTEXPR bool value = true;
    };

#  endif /*VK_ENABLE_BETA_EXTENSIONS*/

    // wrapper class for handle VkDataGraphPipelineSessionARM, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkDataGraphPipelineSessionARM.html
    class DataGraphPipelineSessionARM
    {
    public:
      using CType   = VkDataGraphPipelineSessionARM;
      using CppType = VULKAN_HPP_NAMESPACE::DataGraphPipelineSessionARM;

      static VULKAN_HPP_CONST_OR_CONSTEXPR ObjectType               objectType            = ObjectType::eDataGraphPipelineSessionARM;
      static VULKAN_HPP_CONST_OR_CONSTEXPR DebugReportObjectTypeEXT debugReportObjectType = DebugReportObjectTypeEXT::eUnknown;

    public:
#  if !defined( VULKAN_HPP_NO_EXCEPTIONS )
      DataGraphPipelineSessionARM( Device const &                                device,
                                   DataGraphPipelineSessionCreateInfoARM const & createInfo,
                                   Optional<const AllocationCallbacks>           allocator = nullptr )
      {
        *this = device.createDataGraphPipelineSessionARM( createInfo, allocator );
      }
#  endif

      DataGraphPipelineSessionARM( Device const & device, VkDataGraphPipelineSessionARM session, Optional<const AllocationCallbacks> allocator = nullptr )
        : m_device( device )
        , m_dataGraphPipelineSessionARM( session )
        , m_allocator( static_cast<const AllocationCallbacks *>( allocator ) )
        , m_dispatcher( device.getDispatcher() )
      {
      }

      DataGraphPipelineSessionARM( std::nullptr_t ) {}

      ~DataGraphPipelineSessionARM()
      {
        clear();
      }

      DataGraphPipelineSessionARM()                                      = delete;
      DataGraphPipelineSessionARM( DataGraphPipelineSessionARM const & ) = delete;

      DataGraphPipelineSessionARM( DataGraphPipelineSessionARM && rhs ) VULKAN_HPP_NOEXCEPT
        : m_device( exchange( rhs.m_device, {} ) )
        , m_dataGraphPipelineSessionARM( exchange( rhs.m_dataGraphPipelineSessionARM, {} ) )
        , m_allocator( exchange( rhs.m_allocator, {} ) )
        , m_dispatcher( exchange( rhs.m_dispatcher, nullptr ) )
      {
      }

      DataGraphPipelineSessionARM & operator=( DataGraphPipelineSessionARM const & ) = delete;

      DataGraphPipelineSessionARM & operator=( DataGraphPipelineSessionARM && rhs ) VULKAN_HPP_NOEXCEPT
      {
        if ( this != &rhs )
        {
          std::swap( m_device, rhs.m_device );
          std::swap( m_dataGraphPipelineSessionARM, rhs.m_dataGraphPipelineSessionARM );
          std::swap( m_allocator, rhs.m_allocator );
          std::swap( m_dispatcher, rhs.m_dispatcher );
        }
        return *this;
      }

      VULKAN_HPP_NAMESPACE::DataGraphPipelineSessionARM const & operator*() const & VULKAN_HPP_NOEXCEPT
      {
        return m_dataGraphPipelineSessionARM;
      }

      VULKAN_HPP_NAMESPACE::DataGraphPipelineSessionARM const && operator*() const && VULKAN_HPP_NOEXCEPT
      {
        return std::move( m_dataGraphPipelineSessionARM );
      }

      operator VULKAN_HPP_NAMESPACE::DataGraphPipelineSessionARM() const VULKAN_HPP_NOEXCEPT
      {
        return m_dataGraphPipelineSessionARM;
      }

      void clear() VULKAN_HPP_NOEXCEPT
      {
        if ( m_dataGraphPipelineSessionARM )
        {
          getDispatcher()->vkDestroyDataGraphPipelineSessionARM( static_cast<VkDevice>( m_device ),
                                                                 static_cast<VkDataGraphPipelineSessionARM>( m_dataGraphPipelineSessionARM ),
                                                                 reinterpret_cast<const VkAllocationCallbacks *>( m_allocator ) );
        }
        m_device                      = nullptr;
        m_dataGraphPipelineSessionARM = nullptr;
        m_allocator                   = nullptr;
        m_dispatcher                  = nullptr;
      }

      VULKAN_HPP_NAMESPACE::DataGraphPipelineSessionARM release()
      {
        m_device     = nullptr;
        m_allocator  = nullptr;
        m_dispatcher = nullptr;
        return exchange( m_dataGraphPipelineSessionARM, nullptr );
      }

      VULKAN_HPP_NAMESPACE::Device getDevice() const
      {
        return m_device;
      }

      detail::DeviceDispatcher const * getDispatcher() const
      {
        VULKAN_HPP_ASSERT( m_dispatcher->getVkHeaderVersion() == VK_HEADER_VERSION );
        return m_dispatcher;
      }

      void swap( DataGraphPipelineSessionARM & rhs ) VULKAN_HPP_NOEXCEPT
      {
        std::swap( m_device, rhs.m_device );
        std::swap( m_dataGraphPipelineSessionARM, rhs.m_dataGraphPipelineSessionARM );
        std::swap( m_allocator, rhs.m_allocator );
        std::swap( m_dispatcher, rhs.m_dispatcher );
      }

    private:
      VULKAN_HPP_NAMESPACE::Device                      m_device                      = {};
      VULKAN_HPP_NAMESPACE::DataGraphPipelineSessionARM m_dataGraphPipelineSessionARM = {};
      const AllocationCallbacks *                       m_allocator                   = {};
      detail::DeviceDispatcher const *                  m_dispatcher                  = nullptr;
    };

    template <>
    struct isVulkanRAIIHandleType<DataGraphPipelineSessionARM>
    {
      static VULKAN_HPP_CONST_OR_CONSTEXPR bool value = true;
    };

    // wrapper class for handle VkDebugReportCallbackEXT, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkDebugReportCallbackEXT.html
    class DebugReportCallbackEXT
    {
    public:
      using CType   = VkDebugReportCallbackEXT;
      using CppType = VULKAN_HPP_NAMESPACE::DebugReportCallbackEXT;

      static VULKAN_HPP_CONST_OR_CONSTEXPR ObjectType               objectType            = ObjectType::eDebugReportCallbackEXT;
      static VULKAN_HPP_CONST_OR_CONSTEXPR DebugReportObjectTypeEXT debugReportObjectType = DebugReportObjectTypeEXT::eDebugReportCallbackEXT;

    public:
#  if !defined( VULKAN_HPP_NO_EXCEPTIONS )
      DebugReportCallbackEXT( Instance const &                         instance,
                              DebugReportCallbackCreateInfoEXT const & createInfo,
                              Optional<const AllocationCallbacks>      allocator = nullptr )
      {
        *this = instance.createDebugReportCallbackEXT( createInfo, allocator );
      }
#  endif

      DebugReportCallbackEXT( Instance const & instance, VkDebugReportCallbackEXT callback, Optional<const AllocationCallbacks> allocator = nullptr )
        : m_instance( instance )
        , m_debugReportCallbackEXT( callback )
        , m_allocator( static_cast<const AllocationCallbacks *>( allocator ) )
        , m_dispatcher( instance.getDispatcher() )
      {
      }

      DebugReportCallbackEXT( std::nullptr_t ) {}

      ~DebugReportCallbackEXT()
      {
        clear();
      }

      DebugReportCallbackEXT()                                 = delete;
      DebugReportCallbackEXT( DebugReportCallbackEXT const & ) = delete;

      DebugReportCallbackEXT( DebugReportCallbackEXT && rhs ) VULKAN_HPP_NOEXCEPT
        : m_instance( exchange( rhs.m_instance, {} ) )
        , m_debugReportCallbackEXT( exchange( rhs.m_debugReportCallbackEXT, {} ) )
        , m_allocator( exchange( rhs.m_allocator, {} ) )
        , m_dispatcher( exchange( rhs.m_dispatcher, nullptr ) )
      {
      }

      DebugReportCallbackEXT & operator=( DebugReportCallbackEXT const & ) = delete;

      DebugReportCallbackEXT & operator=( DebugReportCallbackEXT && rhs ) VULKAN_HPP_NOEXCEPT
      {
        if ( this != &rhs )
        {
          std::swap( m_instance, rhs.m_instance );
          std::swap( m_debugReportCallbackEXT, rhs.m_debugReportCallbackEXT );
          std::swap( m_allocator, rhs.m_allocator );
          std::swap( m_dispatcher, rhs.m_dispatcher );
        }
        return *this;
      }

      VULKAN_HPP_NAMESPACE::DebugReportCallbackEXT const & operator*() const & VULKAN_HPP_NOEXCEPT
      {
        return m_debugReportCallbackEXT;
      }

      VULKAN_HPP_NAMESPACE::DebugReportCallbackEXT const && operator*() const && VULKAN_HPP_NOEXCEPT
      {
        return std::move( m_debugReportCallbackEXT );
      }

      operator VULKAN_HPP_NAMESPACE::DebugReportCallbackEXT() const VULKAN_HPP_NOEXCEPT
      {
        return m_debugReportCallbackEXT;
      }

      void clear() VULKAN_HPP_NOEXCEPT
      {
        if ( m_debugReportCallbackEXT )
        {
          getDispatcher()->vkDestroyDebugReportCallbackEXT( static_cast<VkInstance>( m_instance ),
                                                            static_cast<VkDebugReportCallbackEXT>( m_debugReportCallbackEXT ),
                                                            reinterpret_cast<const VkAllocationCallbacks *>( m_allocator ) );
        }
        m_instance               = nullptr;
        m_debugReportCallbackEXT = nullptr;
        m_allocator              = nullptr;
        m_dispatcher             = nullptr;
      }

      VULKAN_HPP_NAMESPACE::DebugReportCallbackEXT release()
      {
        m_instance   = nullptr;
        m_allocator  = nullptr;
        m_dispatcher = nullptr;
        return exchange( m_debugReportCallbackEXT, nullptr );
      }

      VULKAN_HPP_NAMESPACE::Instance getInstance() const
      {
        return m_instance;
      }

      detail::InstanceDispatcher const * getDispatcher() const
      {
        VULKAN_HPP_ASSERT( m_dispatcher->getVkHeaderVersion() == VK_HEADER_VERSION );
        return m_dispatcher;
      }

      void swap( DebugReportCallbackEXT & rhs ) VULKAN_HPP_NOEXCEPT
      {
        std::swap( m_instance, rhs.m_instance );
        std::swap( m_debugReportCallbackEXT, rhs.m_debugReportCallbackEXT );
        std::swap( m_allocator, rhs.m_allocator );
        std::swap( m_dispatcher, rhs.m_dispatcher );
      }

    private:
      VULKAN_HPP_NAMESPACE::Instance               m_instance               = {};
      VULKAN_HPP_NAMESPACE::DebugReportCallbackEXT m_debugReportCallbackEXT = {};
      const AllocationCallbacks *                  m_allocator              = {};
      detail::InstanceDispatcher const *           m_dispatcher             = nullptr;
    };

    template <>
    struct isVulkanRAIIHandleType<DebugReportCallbackEXT>
    {
      static VULKAN_HPP_CONST_OR_CONSTEXPR bool value = true;
    };

    // wrapper class for handle VkDebugUtilsMessengerEXT, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkDebugUtilsMessengerEXT.html
    class DebugUtilsMessengerEXT
    {
    public:
      using CType   = VkDebugUtilsMessengerEXT;
      using CppType = VULKAN_HPP_NAMESPACE::DebugUtilsMessengerEXT;

      static VULKAN_HPP_CONST_OR_CONSTEXPR ObjectType               objectType            = ObjectType::eDebugUtilsMessengerEXT;
      static VULKAN_HPP_CONST_OR_CONSTEXPR DebugReportObjectTypeEXT debugReportObjectType = DebugReportObjectTypeEXT::eUnknown;

    public:
#  if !defined( VULKAN_HPP_NO_EXCEPTIONS )
      DebugUtilsMessengerEXT( Instance const &                         instance,
                              DebugUtilsMessengerCreateInfoEXT const & createInfo,
                              Optional<const AllocationCallbacks>      allocator = nullptr )
      {
        *this = instance.createDebugUtilsMessengerEXT( createInfo, allocator );
      }
#  endif

      DebugUtilsMessengerEXT( Instance const & instance, VkDebugUtilsMessengerEXT messenger, Optional<const AllocationCallbacks> allocator = nullptr )
        : m_instance( instance )
        , m_debugUtilsMessengerEXT( messenger )
        , m_allocator( static_cast<const AllocationCallbacks *>( allocator ) )
        , m_dispatcher( instance.getDispatcher() )
      {
      }

      DebugUtilsMessengerEXT( std::nullptr_t ) {}

      ~DebugUtilsMessengerEXT()
      {
        clear();
      }

      DebugUtilsMessengerEXT()                                 = delete;
      DebugUtilsMessengerEXT( DebugUtilsMessengerEXT const & ) = delete;

      DebugUtilsMessengerEXT( DebugUtilsMessengerEXT && rhs ) VULKAN_HPP_NOEXCEPT
        : m_instance( exchange( rhs.m_instance, {} ) )
        , m_debugUtilsMessengerEXT( exchange( rhs.m_debugUtilsMessengerEXT, {} ) )
        , m_allocator( exchange( rhs.m_allocator, {} ) )
        , m_dispatcher( exchange( rhs.m_dispatcher, nullptr ) )
      {
      }

      DebugUtilsMessengerEXT & operator=( DebugUtilsMessengerEXT const & ) = delete;

      DebugUtilsMessengerEXT & operator=( DebugUtilsMessengerEXT && rhs ) VULKAN_HPP_NOEXCEPT
      {
        if ( this != &rhs )
        {
          std::swap( m_instance, rhs.m_instance );
          std::swap( m_debugUtilsMessengerEXT, rhs.m_debugUtilsMessengerEXT );
          std::swap( m_allocator, rhs.m_allocator );
          std::swap( m_dispatcher, rhs.m_dispatcher );
        }
        return *this;
      }

      VULKAN_HPP_NAMESPACE::DebugUtilsMessengerEXT const & operator*() const & VULKAN_HPP_NOEXCEPT
      {
        return m_debugUtilsMessengerEXT;
      }

      VULKAN_HPP_NAMESPACE::DebugUtilsMessengerEXT const && operator*() const && VULKAN_HPP_NOEXCEPT
      {
        return std::move( m_debugUtilsMessengerEXT );
      }

      operator VULKAN_HPP_NAMESPACE::DebugUtilsMessengerEXT() const VULKAN_HPP_NOEXCEPT
      {
        return m_debugUtilsMessengerEXT;
      }

      void clear() VULKAN_HPP_NOEXCEPT
      {
        if ( m_debugUtilsMessengerEXT )
        {
          getDispatcher()->vkDestroyDebugUtilsMessengerEXT( static_cast<VkInstance>( m_instance ),
                                                            static_cast<VkDebugUtilsMessengerEXT>( m_debugUtilsMessengerEXT ),
                                                            reinterpret_cast<const VkAllocationCallbacks *>( m_allocator ) );
        }
        m_instance               = nullptr;
        m_debugUtilsMessengerEXT = nullptr;
        m_allocator              = nullptr;
        m_dispatcher             = nullptr;
      }

      VULKAN_HPP_NAMESPACE::DebugUtilsMessengerEXT release()
      {
        m_instance   = nullptr;
        m_allocator  = nullptr;
        m_dispatcher = nullptr;
        return exchange( m_debugUtilsMessengerEXT, nullptr );
      }

      VULKAN_HPP_NAMESPACE::Instance getInstance() const
      {
        return m_instance;
      }

      detail::InstanceDispatcher const * getDispatcher() const
      {
        VULKAN_HPP_ASSERT( m_dispatcher->getVkHeaderVersion() == VK_HEADER_VERSION );
        return m_dispatcher;
      }

      void swap( DebugUtilsMessengerEXT & rhs ) VULKAN_HPP_NOEXCEPT
      {
        std::swap( m_instance, rhs.m_instance );
        std::swap( m_debugUtilsMessengerEXT, rhs.m_debugUtilsMessengerEXT );
        std::swap( m_allocator, rhs.m_allocator );
        std::swap( m_dispatcher, rhs.m_dispatcher );
      }

    private:
      VULKAN_HPP_NAMESPACE::Instance               m_instance               = {};
      VULKAN_HPP_NAMESPACE::DebugUtilsMessengerEXT m_debugUtilsMessengerEXT = {};
      const AllocationCallbacks *                  m_allocator              = {};
      detail::InstanceDispatcher const *           m_dispatcher             = nullptr;
    };

    template <>
    struct isVulkanRAIIHandleType<DebugUtilsMessengerEXT>
    {
      static VULKAN_HPP_CONST_OR_CONSTEXPR bool value = true;
    };

    // wrapper class for handle VkDeferredOperationKHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkDeferredOperationKHR.html
    class DeferredOperationKHR
    {
    public:
      using CType   = VkDeferredOperationKHR;
      using CppType = VULKAN_HPP_NAMESPACE::DeferredOperationKHR;

      static VULKAN_HPP_CONST_OR_CONSTEXPR ObjectType               objectType            = ObjectType::eDeferredOperationKHR;
      static VULKAN_HPP_CONST_OR_CONSTEXPR DebugReportObjectTypeEXT debugReportObjectType = DebugReportObjectTypeEXT::eUnknown;

    public:
#  if !defined( VULKAN_HPP_NO_EXCEPTIONS )
      DeferredOperationKHR( Device const & device, Optional<const AllocationCallbacks> allocator = nullptr )
      {
        *this = device.createDeferredOperationKHR( allocator );
      }
#  endif

      DeferredOperationKHR( Device const & device, VkDeferredOperationKHR operation, Optional<const AllocationCallbacks> allocator = nullptr )
        : m_device( device )
        , m_deferredOperationKHR( operation )
        , m_allocator( static_cast<const AllocationCallbacks *>( allocator ) )
        , m_dispatcher( device.getDispatcher() )
      {
      }

      DeferredOperationKHR( std::nullptr_t ) {}

      ~DeferredOperationKHR()
      {
        clear();
      }

      DeferredOperationKHR()                               = delete;
      DeferredOperationKHR( DeferredOperationKHR const & ) = delete;

      DeferredOperationKHR( DeferredOperationKHR && rhs ) VULKAN_HPP_NOEXCEPT
        : m_device( exchange( rhs.m_device, {} ) )
        , m_deferredOperationKHR( exchange( rhs.m_deferredOperationKHR, {} ) )
        , m_allocator( exchange( rhs.m_allocator, {} ) )
        , m_dispatcher( exchange( rhs.m_dispatcher, nullptr ) )
      {
      }

      DeferredOperationKHR & operator=( DeferredOperationKHR const & ) = delete;

      DeferredOperationKHR & operator=( DeferredOperationKHR && rhs ) VULKAN_HPP_NOEXCEPT
      {
        if ( this != &rhs )
        {
          std::swap( m_device, rhs.m_device );
          std::swap( m_deferredOperationKHR, rhs.m_deferredOperationKHR );
          std::swap( m_allocator, rhs.m_allocator );
          std::swap( m_dispatcher, rhs.m_dispatcher );
        }
        return *this;
      }

      VULKAN_HPP_NAMESPACE::DeferredOperationKHR const & operator*() const & VULKAN_HPP_NOEXCEPT
      {
        return m_deferredOperationKHR;
      }

      VULKAN_HPP_NAMESPACE::DeferredOperationKHR const && operator*() const && VULKAN_HPP_NOEXCEPT
      {
        return std::move( m_deferredOperationKHR );
      }

      operator VULKAN_HPP_NAMESPACE::DeferredOperationKHR() const VULKAN_HPP_NOEXCEPT
      {
        return m_deferredOperationKHR;
      }

      void clear() VULKAN_HPP_NOEXCEPT
      {
        if ( m_deferredOperationKHR )
        {
          getDispatcher()->vkDestroyDeferredOperationKHR( static_cast<VkDevice>( m_device ),
                                                          static_cast<VkDeferredOperationKHR>( m_deferredOperationKHR ),
                                                          reinterpret_cast<const VkAllocationCallbacks *>( m_allocator ) );
        }
        m_device               = nullptr;
        m_deferredOperationKHR = nullptr;
        m_allocator            = nullptr;
        m_dispatcher           = nullptr;
      }

      VULKAN_HPP_NAMESPACE::DeferredOperationKHR release()
      {
        m_device     = nullptr;
        m_allocator  = nullptr;
        m_dispatcher = nullptr;
        return exchange( m_deferredOperationKHR, nullptr );
      }

      VULKAN_HPP_NAMESPACE::Device getDevice() const
      {
        return m_device;
      }

      detail::DeviceDispatcher const * getDispatcher() const
      {
        VULKAN_HPP_ASSERT( m_dispatcher->getVkHeaderVersion() == VK_HEADER_VERSION );
        return m_dispatcher;
      }

      void swap( DeferredOperationKHR & rhs ) VULKAN_HPP_NOEXCEPT
      {
        std::swap( m_device, rhs.m_device );
        std::swap( m_deferredOperationKHR, rhs.m_deferredOperationKHR );
        std::swap( m_allocator, rhs.m_allocator );
        std::swap( m_dispatcher, rhs.m_dispatcher );
      }

      //=== VK_KHR_deferred_host_operations ===

      // wrapper function for command vkGetDeferredOperationMaxConcurrencyKHR, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetDeferredOperationMaxConcurrencyKHR.html
      VULKAN_HPP_NODISCARD uint32_t getMaxConcurrency() const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkGetDeferredOperationResultKHR, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetDeferredOperationResultKHR.html
      VULKAN_HPP_NODISCARD Result getResult() const;

      // wrapper function for command vkDeferredOperationJoinKHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkDeferredOperationJoinKHR.html
      VULKAN_HPP_NODISCARD Result join() const;

    private:
      VULKAN_HPP_NAMESPACE::Device               m_device               = {};
      VULKAN_HPP_NAMESPACE::DeferredOperationKHR m_deferredOperationKHR = {};
      const AllocationCallbacks *                m_allocator            = {};
      detail::DeviceDispatcher const *           m_dispatcher           = nullptr;
    };

    template <>
    struct isVulkanRAIIHandleType<DeferredOperationKHR>
    {
      static VULKAN_HPP_CONST_OR_CONSTEXPR bool value = true;
    };

    // wrapper class for handle VkDescriptorPool, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkDescriptorPool.html
    class DescriptorPool
    {
    public:
      using CType   = VkDescriptorPool;
      using CppType = VULKAN_HPP_NAMESPACE::DescriptorPool;

      static VULKAN_HPP_CONST_OR_CONSTEXPR ObjectType               objectType            = ObjectType::eDescriptorPool;
      static VULKAN_HPP_CONST_OR_CONSTEXPR DebugReportObjectTypeEXT debugReportObjectType = DebugReportObjectTypeEXT::eDescriptorPool;

    public:
#  if !defined( VULKAN_HPP_NO_EXCEPTIONS )
      DescriptorPool( Device const & device, DescriptorPoolCreateInfo const & createInfo, Optional<const AllocationCallbacks> allocator = nullptr )
      {
        *this = device.createDescriptorPool( createInfo, allocator );
      }
#  endif

      DescriptorPool( Device const & device, VkDescriptorPool descriptorPool, Optional<const AllocationCallbacks> allocator = nullptr )
        : m_device( device )
        , m_descriptorPool( descriptorPool )
        , m_allocator( static_cast<const AllocationCallbacks *>( allocator ) )
        , m_dispatcher( device.getDispatcher() )
      {
      }

      DescriptorPool( std::nullptr_t ) {}

      ~DescriptorPool()
      {
        clear();
      }

      DescriptorPool()                         = delete;
      DescriptorPool( DescriptorPool const & ) = delete;

      DescriptorPool( DescriptorPool && rhs ) VULKAN_HPP_NOEXCEPT
        : m_device( exchange( rhs.m_device, {} ) )
        , m_descriptorPool( exchange( rhs.m_descriptorPool, {} ) )
        , m_allocator( exchange( rhs.m_allocator, {} ) )
        , m_dispatcher( exchange( rhs.m_dispatcher, nullptr ) )
      {
      }

      DescriptorPool & operator=( DescriptorPool const & ) = delete;

      DescriptorPool & operator=( DescriptorPool && rhs ) VULKAN_HPP_NOEXCEPT
      {
        if ( this != &rhs )
        {
          std::swap( m_device, rhs.m_device );
          std::swap( m_descriptorPool, rhs.m_descriptorPool );
          std::swap( m_allocator, rhs.m_allocator );
          std::swap( m_dispatcher, rhs.m_dispatcher );
        }
        return *this;
      }

      VULKAN_HPP_NAMESPACE::DescriptorPool const & operator*() const & VULKAN_HPP_NOEXCEPT
      {
        return m_descriptorPool;
      }

      VULKAN_HPP_NAMESPACE::DescriptorPool const && operator*() const && VULKAN_HPP_NOEXCEPT
      {
        return std::move( m_descriptorPool );
      }

      operator VULKAN_HPP_NAMESPACE::DescriptorPool() const VULKAN_HPP_NOEXCEPT
      {
        return m_descriptorPool;
      }

      void clear() VULKAN_HPP_NOEXCEPT
      {
        if ( m_descriptorPool )
        {
          getDispatcher()->vkDestroyDescriptorPool( static_cast<VkDevice>( m_device ),
                                                    static_cast<VkDescriptorPool>( m_descriptorPool ),
                                                    reinterpret_cast<const VkAllocationCallbacks *>( m_allocator ) );
        }
        m_device         = nullptr;
        m_descriptorPool = nullptr;
        m_allocator      = nullptr;
        m_dispatcher     = nullptr;
      }

      VULKAN_HPP_NAMESPACE::DescriptorPool release()
      {
        m_device     = nullptr;
        m_allocator  = nullptr;
        m_dispatcher = nullptr;
        return exchange( m_descriptorPool, nullptr );
      }

      VULKAN_HPP_NAMESPACE::Device getDevice() const
      {
        return m_device;
      }

      detail::DeviceDispatcher const * getDispatcher() const
      {
        VULKAN_HPP_ASSERT( m_dispatcher->getVkHeaderVersion() == VK_HEADER_VERSION );
        return m_dispatcher;
      }

      void swap( DescriptorPool & rhs ) VULKAN_HPP_NOEXCEPT
      {
        std::swap( m_device, rhs.m_device );
        std::swap( m_descriptorPool, rhs.m_descriptorPool );
        std::swap( m_allocator, rhs.m_allocator );
        std::swap( m_dispatcher, rhs.m_dispatcher );
      }

      //=== VK_VERSION_1_0 ===

      // wrapper function for command vkResetDescriptorPool, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkResetDescriptorPool.html
      typename ResultValueType<void>::type reset( DescriptorPoolResetFlags flags VULKAN_HPP_DEFAULT_ASSIGNMENT( {} ) ) const;

    private:
      VULKAN_HPP_NAMESPACE::Device         m_device         = {};
      VULKAN_HPP_NAMESPACE::DescriptorPool m_descriptorPool = {};
      const AllocationCallbacks *          m_allocator      = {};
      detail::DeviceDispatcher const *     m_dispatcher     = nullptr;
    };

    template <>
    struct isVulkanRAIIHandleType<DescriptorPool>
    {
      static VULKAN_HPP_CONST_OR_CONSTEXPR bool value = true;
    };

    // wrapper class for handle VkDescriptorSet, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkDescriptorSet.html
    class DescriptorSet
    {
    public:
      using CType   = VkDescriptorSet;
      using CppType = VULKAN_HPP_NAMESPACE::DescriptorSet;

      static VULKAN_HPP_CONST_OR_CONSTEXPR ObjectType               objectType            = ObjectType::eDescriptorSet;
      static VULKAN_HPP_CONST_OR_CONSTEXPR DebugReportObjectTypeEXT debugReportObjectType = DebugReportObjectTypeEXT::eDescriptorSet;

    public:
      DescriptorSet( Device const & device, VkDescriptorSet descriptorSet, VkDescriptorPool descriptorPool )
        : m_device( device ), m_descriptorPool( descriptorPool ), m_descriptorSet( descriptorSet ), m_dispatcher( device.getDispatcher() )
      {
      }

      DescriptorSet( std::nullptr_t ) {}

      ~DescriptorSet()
      {
        clear();
      }

      DescriptorSet()                        = delete;
      DescriptorSet( DescriptorSet const & ) = delete;

      DescriptorSet( DescriptorSet && rhs ) VULKAN_HPP_NOEXCEPT
        : m_device( exchange( rhs.m_device, {} ) )
        , m_descriptorPool( exchange( rhs.m_descriptorPool, {} ) )
        , m_descriptorSet( exchange( rhs.m_descriptorSet, {} ) )
        , m_dispatcher( exchange( rhs.m_dispatcher, nullptr ) )
      {
      }

      DescriptorSet & operator=( DescriptorSet const & ) = delete;

      DescriptorSet & operator=( DescriptorSet && rhs ) VULKAN_HPP_NOEXCEPT
      {
        if ( this != &rhs )
        {
          std::swap( m_device, rhs.m_device );
          std::swap( m_descriptorPool, rhs.m_descriptorPool );
          std::swap( m_descriptorSet, rhs.m_descriptorSet );
          std::swap( m_dispatcher, rhs.m_dispatcher );
        }
        return *this;
      }

      VULKAN_HPP_NAMESPACE::DescriptorSet const & operator*() const & VULKAN_HPP_NOEXCEPT
      {
        return m_descriptorSet;
      }

      VULKAN_HPP_NAMESPACE::DescriptorSet const && operator*() const && VULKAN_HPP_NOEXCEPT
      {
        return std::move( m_descriptorSet );
      }

      operator VULKAN_HPP_NAMESPACE::DescriptorSet() const VULKAN_HPP_NOEXCEPT
      {
        return m_descriptorSet;
      }

      void clear() VULKAN_HPP_NOEXCEPT
      {
        if ( m_descriptorSet )
        {
          getDispatcher()->vkFreeDescriptorSets( static_cast<VkDevice>( m_device ),
                                                 static_cast<VkDescriptorPool>( m_descriptorPool ),
                                                 1,
                                                 reinterpret_cast<VkDescriptorSet const *>( &m_descriptorSet ) );
        }
        m_device         = nullptr;
        m_descriptorPool = nullptr;
        m_descriptorSet  = nullptr;
        m_dispatcher     = nullptr;
      }

      VULKAN_HPP_NAMESPACE::DescriptorSet release()
      {
        m_device         = nullptr;
        m_descriptorPool = nullptr;
        m_dispatcher     = nullptr;
        return exchange( m_descriptorSet, nullptr );
      }

      VULKAN_HPP_NAMESPACE::Device getDevice() const
      {
        return m_device;
      }

      detail::DeviceDispatcher const * getDispatcher() const
      {
        VULKAN_HPP_ASSERT( m_dispatcher->getVkHeaderVersion() == VK_HEADER_VERSION );
        return m_dispatcher;
      }

      void swap( DescriptorSet & rhs ) VULKAN_HPP_NOEXCEPT
      {
        std::swap( m_device, rhs.m_device );
        std::swap( m_descriptorPool, rhs.m_descriptorPool );
        std::swap( m_descriptorSet, rhs.m_descriptorSet );
        std::swap( m_dispatcher, rhs.m_dispatcher );
      }

      //=== VK_VERSION_1_1 ===

      // wrapper function for command vkUpdateDescriptorSetWithTemplate, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkUpdateDescriptorSetWithTemplate.html
      template <typename DataType>
      void updateWithTemplate( VULKAN_HPP_NAMESPACE::DescriptorUpdateTemplate descriptorUpdateTemplate, DataType const & data ) const VULKAN_HPP_NOEXCEPT;

      //=== VK_KHR_descriptor_update_template ===

      // wrapper function for command vkUpdateDescriptorSetWithTemplateKHR, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkUpdateDescriptorSetWithTemplateKHR.html
      template <typename DataType>
      void updateWithTemplateKHR( VULKAN_HPP_NAMESPACE::DescriptorUpdateTemplate descriptorUpdateTemplate, DataType const & data ) const VULKAN_HPP_NOEXCEPT;

      //=== VK_VALVE_descriptor_set_host_mapping ===

      // wrapper function for command vkGetDescriptorSetHostMappingVALVE, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetDescriptorSetHostMappingVALVE.html
      VULKAN_HPP_NODISCARD void * getHostMappingVALVE() const VULKAN_HPP_NOEXCEPT;

    private:
      VULKAN_HPP_NAMESPACE::Device         m_device         = {};
      VULKAN_HPP_NAMESPACE::DescriptorPool m_descriptorPool = {};
      VULKAN_HPP_NAMESPACE::DescriptorSet  m_descriptorSet  = {};
      detail::DeviceDispatcher const *     m_dispatcher     = nullptr;
    };

    template <>
    struct isVulkanRAIIHandleType<DescriptorSet>
    {
      static VULKAN_HPP_CONST_OR_CONSTEXPR bool value = true;
    };

    class DescriptorSets : public std::vector<DescriptorSet>
    {
    public:
#  if !defined( VULKAN_HPP_NO_EXCEPTIONS )
      DescriptorSets( Device const & device, DescriptorSetAllocateInfo const & allocateInfo )
      {
        *this = device.allocateDescriptorSets( allocateInfo );
      }
#  endif

      DescriptorSets( std::nullptr_t ) {}

      DescriptorSets()                                     = delete;
      DescriptorSets( DescriptorSets const & )             = delete;
      DescriptorSets( DescriptorSets && rhs )              = default;
      DescriptorSets & operator=( DescriptorSets const & ) = delete;
      DescriptorSets & operator=( DescriptorSets && rhs )  = default;

    private:
      DescriptorSets( std::vector<DescriptorSet> && rhs )
      {
        std::swap( *this, rhs );
      }
    };

    // wrapper class for handle VkDescriptorSetLayout, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkDescriptorSetLayout.html
    class DescriptorSetLayout
    {
    public:
      using CType   = VkDescriptorSetLayout;
      using CppType = VULKAN_HPP_NAMESPACE::DescriptorSetLayout;

      static VULKAN_HPP_CONST_OR_CONSTEXPR ObjectType               objectType            = ObjectType::eDescriptorSetLayout;
      static VULKAN_HPP_CONST_OR_CONSTEXPR DebugReportObjectTypeEXT debugReportObjectType = DebugReportObjectTypeEXT::eDescriptorSetLayout;

    public:
#  if !defined( VULKAN_HPP_NO_EXCEPTIONS )
      DescriptorSetLayout( Device const & device, DescriptorSetLayoutCreateInfo const & createInfo, Optional<const AllocationCallbacks> allocator = nullptr )
      {
        *this = device.createDescriptorSetLayout( createInfo, allocator );
      }
#  endif

      DescriptorSetLayout( Device const & device, VkDescriptorSetLayout descriptorSetLayout, Optional<const AllocationCallbacks> allocator = nullptr )
        : m_device( device )
        , m_descriptorSetLayout( descriptorSetLayout )
        , m_allocator( static_cast<const AllocationCallbacks *>( allocator ) )
        , m_dispatcher( device.getDispatcher() )
      {
      }

      DescriptorSetLayout( std::nullptr_t ) {}

      ~DescriptorSetLayout()
      {
        clear();
      }

      DescriptorSetLayout()                              = delete;
      DescriptorSetLayout( DescriptorSetLayout const & ) = delete;

      DescriptorSetLayout( DescriptorSetLayout && rhs ) VULKAN_HPP_NOEXCEPT
        : m_device( exchange( rhs.m_device, {} ) )
        , m_descriptorSetLayout( exchange( rhs.m_descriptorSetLayout, {} ) )
        , m_allocator( exchange( rhs.m_allocator, {} ) )
        , m_dispatcher( exchange( rhs.m_dispatcher, nullptr ) )
      {
      }

      DescriptorSetLayout & operator=( DescriptorSetLayout const & ) = delete;

      DescriptorSetLayout & operator=( DescriptorSetLayout && rhs ) VULKAN_HPP_NOEXCEPT
      {
        if ( this != &rhs )
        {
          std::swap( m_device, rhs.m_device );
          std::swap( m_descriptorSetLayout, rhs.m_descriptorSetLayout );
          std::swap( m_allocator, rhs.m_allocator );
          std::swap( m_dispatcher, rhs.m_dispatcher );
        }
        return *this;
      }

      VULKAN_HPP_NAMESPACE::DescriptorSetLayout const & operator*() const & VULKAN_HPP_NOEXCEPT
      {
        return m_descriptorSetLayout;
      }

      VULKAN_HPP_NAMESPACE::DescriptorSetLayout const && operator*() const && VULKAN_HPP_NOEXCEPT
      {
        return std::move( m_descriptorSetLayout );
      }

      operator VULKAN_HPP_NAMESPACE::DescriptorSetLayout() const VULKAN_HPP_NOEXCEPT
      {
        return m_descriptorSetLayout;
      }

      void clear() VULKAN_HPP_NOEXCEPT
      {
        if ( m_descriptorSetLayout )
        {
          getDispatcher()->vkDestroyDescriptorSetLayout( static_cast<VkDevice>( m_device ),
                                                         static_cast<VkDescriptorSetLayout>( m_descriptorSetLayout ),
                                                         reinterpret_cast<const VkAllocationCallbacks *>( m_allocator ) );
        }
        m_device              = nullptr;
        m_descriptorSetLayout = nullptr;
        m_allocator           = nullptr;
        m_dispatcher          = nullptr;
      }

      VULKAN_HPP_NAMESPACE::DescriptorSetLayout release()
      {
        m_device     = nullptr;
        m_allocator  = nullptr;
        m_dispatcher = nullptr;
        return exchange( m_descriptorSetLayout, nullptr );
      }

      VULKAN_HPP_NAMESPACE::Device getDevice() const
      {
        return m_device;
      }

      detail::DeviceDispatcher const * getDispatcher() const
      {
        VULKAN_HPP_ASSERT( m_dispatcher->getVkHeaderVersion() == VK_HEADER_VERSION );
        return m_dispatcher;
      }

      void swap( DescriptorSetLayout & rhs ) VULKAN_HPP_NOEXCEPT
      {
        std::swap( m_device, rhs.m_device );
        std::swap( m_descriptorSetLayout, rhs.m_descriptorSetLayout );
        std::swap( m_allocator, rhs.m_allocator );
        std::swap( m_dispatcher, rhs.m_dispatcher );
      }

      //=== VK_EXT_descriptor_buffer ===

      // wrapper function for command vkGetDescriptorSetLayoutSizeEXT, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetDescriptorSetLayoutSizeEXT.html
      VULKAN_HPP_NODISCARD DeviceSize getSizeEXT() const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkGetDescriptorSetLayoutBindingOffsetEXT, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetDescriptorSetLayoutBindingOffsetEXT.html
      VULKAN_HPP_NODISCARD DeviceSize getBindingOffsetEXT( uint32_t binding ) const VULKAN_HPP_NOEXCEPT;

    private:
      VULKAN_HPP_NAMESPACE::Device              m_device              = {};
      VULKAN_HPP_NAMESPACE::DescriptorSetLayout m_descriptorSetLayout = {};
      const AllocationCallbacks *               m_allocator           = {};
      detail::DeviceDispatcher const *          m_dispatcher          = nullptr;
    };

    template <>
    struct isVulkanRAIIHandleType<DescriptorSetLayout>
    {
      static VULKAN_HPP_CONST_OR_CONSTEXPR bool value = true;
    };

    // wrapper class for handle VkDescriptorUpdateTemplate, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkDescriptorUpdateTemplate.html
    class DescriptorUpdateTemplate
    {
    public:
      using CType   = VkDescriptorUpdateTemplate;
      using CppType = VULKAN_HPP_NAMESPACE::DescriptorUpdateTemplate;

      static VULKAN_HPP_CONST_OR_CONSTEXPR ObjectType               objectType            = ObjectType::eDescriptorUpdateTemplate;
      static VULKAN_HPP_CONST_OR_CONSTEXPR DebugReportObjectTypeEXT debugReportObjectType = DebugReportObjectTypeEXT::eDescriptorUpdateTemplate;

    public:
#  if !defined( VULKAN_HPP_NO_EXCEPTIONS )
      DescriptorUpdateTemplate( Device const &                             device,
                                DescriptorUpdateTemplateCreateInfo const & createInfo,
                                Optional<const AllocationCallbacks>        allocator = nullptr )
      {
        *this = device.createDescriptorUpdateTemplate( createInfo, allocator );
      }
#  endif

      DescriptorUpdateTemplate( Device const &                      device,
                                VkDescriptorUpdateTemplate          descriptorUpdateTemplate,
                                Optional<const AllocationCallbacks> allocator = nullptr )
        : m_device( device )
        , m_descriptorUpdateTemplate( descriptorUpdateTemplate )
        , m_allocator( static_cast<const AllocationCallbacks *>( allocator ) )
        , m_dispatcher( device.getDispatcher() )
      {
      }

      DescriptorUpdateTemplate( std::nullptr_t ) {}

      ~DescriptorUpdateTemplate()
      {
        clear();
      }

      DescriptorUpdateTemplate()                                   = delete;
      DescriptorUpdateTemplate( DescriptorUpdateTemplate const & ) = delete;

      DescriptorUpdateTemplate( DescriptorUpdateTemplate && rhs ) VULKAN_HPP_NOEXCEPT
        : m_device( exchange( rhs.m_device, {} ) )
        , m_descriptorUpdateTemplate( exchange( rhs.m_descriptorUpdateTemplate, {} ) )
        , m_allocator( exchange( rhs.m_allocator, {} ) )
        , m_dispatcher( exchange( rhs.m_dispatcher, nullptr ) )
      {
      }

      DescriptorUpdateTemplate & operator=( DescriptorUpdateTemplate const & ) = delete;

      DescriptorUpdateTemplate & operator=( DescriptorUpdateTemplate && rhs ) VULKAN_HPP_NOEXCEPT
      {
        if ( this != &rhs )
        {
          std::swap( m_device, rhs.m_device );
          std::swap( m_descriptorUpdateTemplate, rhs.m_descriptorUpdateTemplate );
          std::swap( m_allocator, rhs.m_allocator );
          std::swap( m_dispatcher, rhs.m_dispatcher );
        }
        return *this;
      }

      VULKAN_HPP_NAMESPACE::DescriptorUpdateTemplate const & operator*() const & VULKAN_HPP_NOEXCEPT
      {
        return m_descriptorUpdateTemplate;
      }

      VULKAN_HPP_NAMESPACE::DescriptorUpdateTemplate const && operator*() const && VULKAN_HPP_NOEXCEPT
      {
        return std::move( m_descriptorUpdateTemplate );
      }

      operator VULKAN_HPP_NAMESPACE::DescriptorUpdateTemplate() const VULKAN_HPP_NOEXCEPT
      {
        return m_descriptorUpdateTemplate;
      }

      void clear() VULKAN_HPP_NOEXCEPT
      {
        if ( m_descriptorUpdateTemplate )
        {
          getDispatcher()->vkDestroyDescriptorUpdateTemplate( static_cast<VkDevice>( m_device ),
                                                              static_cast<VkDescriptorUpdateTemplate>( m_descriptorUpdateTemplate ),
                                                              reinterpret_cast<const VkAllocationCallbacks *>( m_allocator ) );
        }
        m_device                   = nullptr;
        m_descriptorUpdateTemplate = nullptr;
        m_allocator                = nullptr;
        m_dispatcher               = nullptr;
      }

      VULKAN_HPP_NAMESPACE::DescriptorUpdateTemplate release()
      {
        m_device     = nullptr;
        m_allocator  = nullptr;
        m_dispatcher = nullptr;
        return exchange( m_descriptorUpdateTemplate, nullptr );
      }

      VULKAN_HPP_NAMESPACE::Device getDevice() const
      {
        return m_device;
      }

      detail::DeviceDispatcher const * getDispatcher() const
      {
        VULKAN_HPP_ASSERT( m_dispatcher->getVkHeaderVersion() == VK_HEADER_VERSION );
        return m_dispatcher;
      }

      void swap( DescriptorUpdateTemplate & rhs ) VULKAN_HPP_NOEXCEPT
      {
        std::swap( m_device, rhs.m_device );
        std::swap( m_descriptorUpdateTemplate, rhs.m_descriptorUpdateTemplate );
        std::swap( m_allocator, rhs.m_allocator );
        std::swap( m_dispatcher, rhs.m_dispatcher );
      }

    private:
      VULKAN_HPP_NAMESPACE::Device                   m_device                   = {};
      VULKAN_HPP_NAMESPACE::DescriptorUpdateTemplate m_descriptorUpdateTemplate = {};
      const AllocationCallbacks *                    m_allocator                = {};
      detail::DeviceDispatcher const *               m_dispatcher               = nullptr;
    };

    template <>
    struct isVulkanRAIIHandleType<DescriptorUpdateTemplate>
    {
      static VULKAN_HPP_CONST_OR_CONSTEXPR bool value = true;
    };

    // wrapper class for handle VkDeviceMemory, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkDeviceMemory.html
    class DeviceMemory
    {
    public:
      using CType   = VkDeviceMemory;
      using CppType = VULKAN_HPP_NAMESPACE::DeviceMemory;

      static VULKAN_HPP_CONST_OR_CONSTEXPR ObjectType               objectType            = ObjectType::eDeviceMemory;
      static VULKAN_HPP_CONST_OR_CONSTEXPR DebugReportObjectTypeEXT debugReportObjectType = DebugReportObjectTypeEXT::eDeviceMemory;

    public:
#  if !defined( VULKAN_HPP_NO_EXCEPTIONS )
      DeviceMemory( Device const & device, MemoryAllocateInfo const & allocateInfo, Optional<const AllocationCallbacks> allocator = nullptr )
      {
        *this = device.allocateMemory( allocateInfo, allocator );
      }
#  endif

      DeviceMemory( Device const & device, VkDeviceMemory memory, Optional<const AllocationCallbacks> allocator = nullptr )
        : m_device( device )
        , m_deviceMemory( memory )
        , m_allocator( static_cast<const AllocationCallbacks *>( allocator ) )
        , m_dispatcher( device.getDispatcher() )
      {
      }

      DeviceMemory( std::nullptr_t ) {}

      ~DeviceMemory()
      {
        clear();
      }

      DeviceMemory()                       = delete;
      DeviceMemory( DeviceMemory const & ) = delete;

      DeviceMemory( DeviceMemory && rhs ) VULKAN_HPP_NOEXCEPT
        : m_device( exchange( rhs.m_device, {} ) )
        , m_deviceMemory( exchange( rhs.m_deviceMemory, {} ) )
        , m_allocator( exchange( rhs.m_allocator, {} ) )
        , m_dispatcher( exchange( rhs.m_dispatcher, nullptr ) )
      {
      }

      DeviceMemory & operator=( DeviceMemory const & ) = delete;

      DeviceMemory & operator=( DeviceMemory && rhs ) VULKAN_HPP_NOEXCEPT
      {
        if ( this != &rhs )
        {
          std::swap( m_device, rhs.m_device );
          std::swap( m_deviceMemory, rhs.m_deviceMemory );
          std::swap( m_allocator, rhs.m_allocator );
          std::swap( m_dispatcher, rhs.m_dispatcher );
        }
        return *this;
      }

      VULKAN_HPP_NAMESPACE::DeviceMemory const & operator*() const & VULKAN_HPP_NOEXCEPT
      {
        return m_deviceMemory;
      }

      VULKAN_HPP_NAMESPACE::DeviceMemory const && operator*() const && VULKAN_HPP_NOEXCEPT
      {
        return std::move( m_deviceMemory );
      }

      operator VULKAN_HPP_NAMESPACE::DeviceMemory() const VULKAN_HPP_NOEXCEPT
      {
        return m_deviceMemory;
      }

      void clear() VULKAN_HPP_NOEXCEPT
      {
        if ( m_deviceMemory )
        {
          getDispatcher()->vkFreeMemory(
            static_cast<VkDevice>( m_device ), static_cast<VkDeviceMemory>( m_deviceMemory ), reinterpret_cast<const VkAllocationCallbacks *>( m_allocator ) );
        }
        m_device       = nullptr;
        m_deviceMemory = nullptr;
        m_allocator    = nullptr;
        m_dispatcher   = nullptr;
      }

      VULKAN_HPP_NAMESPACE::DeviceMemory release()
      {
        m_device     = nullptr;
        m_allocator  = nullptr;
        m_dispatcher = nullptr;
        return exchange( m_deviceMemory, nullptr );
      }

      VULKAN_HPP_NAMESPACE::Device getDevice() const
      {
        return m_device;
      }

      detail::DeviceDispatcher const * getDispatcher() const
      {
        VULKAN_HPP_ASSERT( m_dispatcher->getVkHeaderVersion() == VK_HEADER_VERSION );
        return m_dispatcher;
      }

      void swap( DeviceMemory & rhs ) VULKAN_HPP_NOEXCEPT
      {
        std::swap( m_device, rhs.m_device );
        std::swap( m_deviceMemory, rhs.m_deviceMemory );
        std::swap( m_allocator, rhs.m_allocator );
        std::swap( m_dispatcher, rhs.m_dispatcher );
      }

      //=== VK_VERSION_1_0 ===

      // wrapper function for command vkMapMemory, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkMapMemory.html
      VULKAN_HPP_NODISCARD typename ResultValueType<void *>::type
        mapMemory( DeviceSize offset, DeviceSize size, MemoryMapFlags flags VULKAN_HPP_DEFAULT_ASSIGNMENT( {} ) ) const;

      // wrapper function for command vkUnmapMemory, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkUnmapMemory.html
      void unmapMemory() const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkGetDeviceMemoryCommitment, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetDeviceMemoryCommitment.html
      VULKAN_HPP_NODISCARD DeviceSize getCommitment() const VULKAN_HPP_NOEXCEPT;

#  if defined( VK_USE_PLATFORM_WIN32_KHR )
      //=== VK_NV_external_memory_win32 ===

      // wrapper function for command vkGetMemoryWin32HandleNV, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetMemoryWin32HandleNV.html
      VULKAN_HPP_NODISCARD typename ResultValueType<HANDLE>::type getMemoryWin32HandleNV( ExternalMemoryHandleTypeFlagsNV handleType ) const;
#  endif /*VK_USE_PLATFORM_WIN32_KHR*/

      //=== VK_EXT_pageable_device_local_memory ===

      // wrapper function for command vkSetDeviceMemoryPriorityEXT, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkSetDeviceMemoryPriorityEXT.html
      void setPriorityEXT( float priority ) const VULKAN_HPP_NOEXCEPT;

    private:
      VULKAN_HPP_NAMESPACE::Device       m_device       = {};
      VULKAN_HPP_NAMESPACE::DeviceMemory m_deviceMemory = {};
      const AllocationCallbacks *        m_allocator    = {};
      detail::DeviceDispatcher const *   m_dispatcher   = nullptr;
    };

    template <>
    struct isVulkanRAIIHandleType<DeviceMemory>
    {
      static VULKAN_HPP_CONST_OR_CONSTEXPR bool value = true;
    };

    // wrapper class for handle VkDisplayKHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkDisplayKHR.html
    class DisplayKHR
    {
    public:
      using CType   = VkDisplayKHR;
      using CppType = VULKAN_HPP_NAMESPACE::DisplayKHR;

      static VULKAN_HPP_CONST_OR_CONSTEXPR ObjectType               objectType            = ObjectType::eDisplayKHR;
      static VULKAN_HPP_CONST_OR_CONSTEXPR DebugReportObjectTypeEXT debugReportObjectType = DebugReportObjectTypeEXT::eDisplayKHR;

    public:
#  if !defined( VULKAN_HPP_NO_EXCEPTIONS )
      DisplayKHR( PhysicalDevice const & physicalDevice, int32_t drmFd, uint32_t connectorId )
      {
        *this = physicalDevice.getDrmDisplayEXT( drmFd, connectorId );
      }
#  endif

#  if !defined( VULKAN_HPP_NO_EXCEPTIONS )
#    if defined( VK_USE_PLATFORM_XLIB_XRANDR_EXT )
      DisplayKHR( PhysicalDevice const & physicalDevice, Display & dpy, RROutput rrOutput )
      {
        *this = physicalDevice.getRandROutputDisplayEXT( dpy, rrOutput );
      }
#    endif /*VK_USE_PLATFORM_XLIB_XRANDR_EXT*/
#  endif

#  if !defined( VULKAN_HPP_NO_EXCEPTIONS )
#    if defined( VK_USE_PLATFORM_WIN32_KHR )
      DisplayKHR( PhysicalDevice const & physicalDevice, uint32_t deviceRelativeId )
      {
        *this = physicalDevice.getWinrtDisplayNV( deviceRelativeId );
      }
#    endif /*VK_USE_PLATFORM_WIN32_KHR*/
#  endif

      DisplayKHR( PhysicalDevice const & physicalDevice, VkDisplayKHR display )
        : m_physicalDevice( physicalDevice ), m_displayKHR( display ), m_dispatcher( physicalDevice.getDispatcher() )
      {
      }

      DisplayKHR( std::nullptr_t ) {}

      ~DisplayKHR()
      {
        clear();
      }

      DisplayKHR()                     = delete;
      DisplayKHR( DisplayKHR const & ) = delete;

      DisplayKHR( DisplayKHR && rhs ) VULKAN_HPP_NOEXCEPT
        : m_physicalDevice( exchange( rhs.m_physicalDevice, {} ) )
        , m_displayKHR( exchange( rhs.m_displayKHR, {} ) )
        , m_dispatcher( exchange( rhs.m_dispatcher, nullptr ) )
      {
      }

      DisplayKHR & operator=( DisplayKHR const & ) = delete;

      DisplayKHR & operator=( DisplayKHR && rhs ) VULKAN_HPP_NOEXCEPT
      {
        if ( this != &rhs )
        {
          std::swap( m_physicalDevice, rhs.m_physicalDevice );
          std::swap( m_displayKHR, rhs.m_displayKHR );
          std::swap( m_dispatcher, rhs.m_dispatcher );
        }
        return *this;
      }

      VULKAN_HPP_NAMESPACE::DisplayKHR const & operator*() const & VULKAN_HPP_NOEXCEPT
      {
        return m_displayKHR;
      }

      VULKAN_HPP_NAMESPACE::DisplayKHR const && operator*() const && VULKAN_HPP_NOEXCEPT
      {
        return std::move( m_displayKHR );
      }

      operator VULKAN_HPP_NAMESPACE::DisplayKHR() const VULKAN_HPP_NOEXCEPT
      {
        return m_displayKHR;
      }

      void clear() VULKAN_HPP_NOEXCEPT
      {
        if ( m_displayKHR )
        {
          getDispatcher()->vkReleaseDisplayEXT( static_cast<VkPhysicalDevice>( m_physicalDevice ), static_cast<VkDisplayKHR>( m_displayKHR ) );
        }
        m_physicalDevice = nullptr;
        m_displayKHR     = nullptr;
        m_dispatcher     = nullptr;
      }

      VULKAN_HPP_NAMESPACE::DisplayKHR release()
      {
        m_physicalDevice = nullptr;
        m_dispatcher     = nullptr;
        return exchange( m_displayKHR, nullptr );
      }

      VULKAN_HPP_NAMESPACE::PhysicalDevice getPhysicalDevice() const
      {
        return m_physicalDevice;
      }

      detail::InstanceDispatcher const * getDispatcher() const
      {
        VULKAN_HPP_ASSERT( m_dispatcher->getVkHeaderVersion() == VK_HEADER_VERSION );
        return m_dispatcher;
      }

      void swap( DisplayKHR & rhs ) VULKAN_HPP_NOEXCEPT
      {
        std::swap( m_physicalDevice, rhs.m_physicalDevice );
        std::swap( m_displayKHR, rhs.m_displayKHR );
        std::swap( m_dispatcher, rhs.m_dispatcher );
      }

      //=== VK_KHR_display ===

      // wrapper function for command vkGetDisplayModePropertiesKHR, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetDisplayModePropertiesKHR.html
      VULKAN_HPP_NODISCARD typename ResultValueType<std::vector<DisplayModePropertiesKHR>>::type getModeProperties() const;

      // wrapper function for command vkCreateDisplayModeKHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateDisplayModeKHR.html
      VULKAN_HPP_NODISCARD typename ResultValueType<DisplayModeKHR>::type
        createMode( DisplayModeCreateInfoKHR const &    createInfo,
                    Optional<const AllocationCallbacks> allocator = nullptr ) const VULKAN_HPP_NOEXCEPT_WHEN_NO_EXCEPTIONS;

      //=== VK_KHR_get_display_properties2 ===

      // wrapper function for command vkGetDisplayModeProperties2KHR, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetDisplayModeProperties2KHR.html
      VULKAN_HPP_NODISCARD typename ResultValueType<std::vector<DisplayModeProperties2KHR>>::type getModeProperties2() const;

      // wrapper function for command vkGetDisplayModeProperties2KHR, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetDisplayModeProperties2KHR.html
      template <typename StructureChain>
      VULKAN_HPP_NODISCARD typename ResultValueType<std::vector<StructureChain>>::type getModeProperties2() const;

#  if defined( VK_USE_PLATFORM_WIN32_KHR )
      //=== VK_NV_acquire_winrt_display ===

      // wrapper function for command vkAcquireWinrtDisplayNV, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkAcquireWinrtDisplayNV.html
      typename ResultValueType<void>::type acquireWinrtNV() const;
#  endif /*VK_USE_PLATFORM_WIN32_KHR*/

    private:
      VULKAN_HPP_NAMESPACE::PhysicalDevice m_physicalDevice = {};
      VULKAN_HPP_NAMESPACE::DisplayKHR     m_displayKHR     = {};
      detail::InstanceDispatcher const *   m_dispatcher     = nullptr;
    };

    template <>
    struct isVulkanRAIIHandleType<DisplayKHR>
    {
      static VULKAN_HPP_CONST_OR_CONSTEXPR bool value = true;
    };

    class DisplayKHRs : public std::vector<DisplayKHR>
    {
    public:
#  if !defined( VULKAN_HPP_NO_EXCEPTIONS )
      DisplayKHRs( PhysicalDevice const & physicalDevice, uint32_t planeIndex )
      {
        *this = physicalDevice.getDisplayPlaneSupportedDisplaysKHR( planeIndex );
      }
#  endif

      DisplayKHRs( std::nullptr_t ) {}

      DisplayKHRs()                                  = delete;
      DisplayKHRs( DisplayKHRs const & )             = delete;
      DisplayKHRs( DisplayKHRs && rhs )              = default;
      DisplayKHRs & operator=( DisplayKHRs const & ) = delete;
      DisplayKHRs & operator=( DisplayKHRs && rhs )  = default;

    private:
      DisplayKHRs( std::vector<DisplayKHR> && rhs )
      {
        std::swap( *this, rhs );
      }
    };

    // wrapper class for handle VkDisplayModeKHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkDisplayModeKHR.html
    class DisplayModeKHR
    {
    public:
      using CType   = VkDisplayModeKHR;
      using CppType = VULKAN_HPP_NAMESPACE::DisplayModeKHR;

      static VULKAN_HPP_CONST_OR_CONSTEXPR ObjectType               objectType            = ObjectType::eDisplayModeKHR;
      static VULKAN_HPP_CONST_OR_CONSTEXPR DebugReportObjectTypeEXT debugReportObjectType = DebugReportObjectTypeEXT::eDisplayModeKHR;

    public:
#  if !defined( VULKAN_HPP_NO_EXCEPTIONS )
      DisplayModeKHR( DisplayKHR const & display, DisplayModeCreateInfoKHR const & createInfo, Optional<const AllocationCallbacks> allocator = nullptr )
      {
        *this = display.createMode( createInfo, allocator );
      }
#  endif

      DisplayModeKHR( DisplayKHR const & display, VkDisplayModeKHR displayModeKHR )
        : m_physicalDevice( display.getPhysicalDevice() ), m_displayModeKHR( displayModeKHR ), m_dispatcher( display.getDispatcher() )
      {
      }

      DisplayModeKHR( std::nullptr_t ) {}

      ~DisplayModeKHR()
      {
        clear();
      }

      DisplayModeKHR() = delete;

      DisplayModeKHR( DisplayModeKHR const & rhs ) : m_displayModeKHR( rhs.m_displayModeKHR ), m_dispatcher( rhs.m_dispatcher ) {}

      DisplayModeKHR( DisplayModeKHR && rhs ) VULKAN_HPP_NOEXCEPT
        : m_physicalDevice( exchange( rhs.m_physicalDevice, {} ) )
        , m_displayModeKHR( exchange( rhs.m_displayModeKHR, {} ) )
        , m_dispatcher( exchange( rhs.m_dispatcher, nullptr ) )
      {
      }

      DisplayModeKHR & operator=( DisplayModeKHR const & rhs )
      {
        m_displayModeKHR = rhs.m_displayModeKHR;
        m_dispatcher     = rhs.m_dispatcher;
        return *this;
      }

      DisplayModeKHR & operator=( DisplayModeKHR && rhs ) VULKAN_HPP_NOEXCEPT
      {
        if ( this != &rhs )
        {
          std::swap( m_physicalDevice, rhs.m_physicalDevice );
          std::swap( m_displayModeKHR, rhs.m_displayModeKHR );
          std::swap( m_dispatcher, rhs.m_dispatcher );
        }
        return *this;
      }

      VULKAN_HPP_NAMESPACE::DisplayModeKHR const & operator*() const & VULKAN_HPP_NOEXCEPT
      {
        return m_displayModeKHR;
      }

      VULKAN_HPP_NAMESPACE::DisplayModeKHR const && operator*() const && VULKAN_HPP_NOEXCEPT
      {
        return std::move( m_displayModeKHR );
      }

      operator VULKAN_HPP_NAMESPACE::DisplayModeKHR() const VULKAN_HPP_NOEXCEPT
      {
        return m_displayModeKHR;
      }

      void clear() VULKAN_HPP_NOEXCEPT
      {
        m_physicalDevice = nullptr;
        m_displayModeKHR = nullptr;
        m_dispatcher     = nullptr;
      }

      VULKAN_HPP_NAMESPACE::DisplayModeKHR release()
      {
        m_physicalDevice = nullptr;
        m_dispatcher     = nullptr;
        return exchange( m_displayModeKHR, nullptr );
      }

      detail::InstanceDispatcher const * getDispatcher() const
      {
        VULKAN_HPP_ASSERT( m_dispatcher->getVkHeaderVersion() == VK_HEADER_VERSION );
        return m_dispatcher;
      }

      void swap( DisplayModeKHR & rhs ) VULKAN_HPP_NOEXCEPT
      {
        std::swap( m_physicalDevice, rhs.m_physicalDevice );
        std::swap( m_displayModeKHR, rhs.m_displayModeKHR );
        std::swap( m_dispatcher, rhs.m_dispatcher );
      }

      //=== VK_KHR_display ===

      // wrapper function for command vkGetDisplayPlaneCapabilitiesKHR, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetDisplayPlaneCapabilitiesKHR.html
      VULKAN_HPP_NODISCARD typename ResultValueType<DisplayPlaneCapabilitiesKHR>::type getDisplayPlaneCapabilities( uint32_t planeIndex ) const;

    private:
      VULKAN_HPP_NAMESPACE::PhysicalDevice m_physicalDevice = {};
      VULKAN_HPP_NAMESPACE::DisplayModeKHR m_displayModeKHR = {};
      detail::InstanceDispatcher const *   m_dispatcher     = nullptr;
    };

    template <>
    struct isVulkanRAIIHandleType<DisplayModeKHR>
    {
      static VULKAN_HPP_CONST_OR_CONSTEXPR bool value = true;
    };

    // wrapper class for handle VkEvent, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkEvent.html
    class Event
    {
    public:
      using CType   = VkEvent;
      using CppType = VULKAN_HPP_NAMESPACE::Event;

      static VULKAN_HPP_CONST_OR_CONSTEXPR ObjectType               objectType            = ObjectType::eEvent;
      static VULKAN_HPP_CONST_OR_CONSTEXPR DebugReportObjectTypeEXT debugReportObjectType = DebugReportObjectTypeEXT::eEvent;

    public:
#  if !defined( VULKAN_HPP_NO_EXCEPTIONS )
      Event( Device const & device, EventCreateInfo const & createInfo, Optional<const AllocationCallbacks> allocator = nullptr )
      {
        *this = device.createEvent( createInfo, allocator );
      }
#  endif

      Event( Device const & device, VkEvent event, Optional<const AllocationCallbacks> allocator = nullptr )
        : m_device( device ), m_event( event ), m_allocator( static_cast<const AllocationCallbacks *>( allocator ) ), m_dispatcher( device.getDispatcher() )
      {
      }

      Event( std::nullptr_t ) {}

      ~Event()
      {
        clear();
      }

      Event()                = delete;
      Event( Event const & ) = delete;

      Event( Event && rhs ) VULKAN_HPP_NOEXCEPT
        : m_device( exchange( rhs.m_device, {} ) )
        , m_event( exchange( rhs.m_event, {} ) )
        , m_allocator( exchange( rhs.m_allocator, {} ) )
        , m_dispatcher( exchange( rhs.m_dispatcher, nullptr ) )
      {
      }

      Event & operator=( Event const & ) = delete;

      Event & operator=( Event && rhs ) VULKAN_HPP_NOEXCEPT
      {
        if ( this != &rhs )
        {
          std::swap( m_device, rhs.m_device );
          std::swap( m_event, rhs.m_event );
          std::swap( m_allocator, rhs.m_allocator );
          std::swap( m_dispatcher, rhs.m_dispatcher );
        }
        return *this;
      }

      VULKAN_HPP_NAMESPACE::Event const & operator*() const & VULKAN_HPP_NOEXCEPT
      {
        return m_event;
      }

      VULKAN_HPP_NAMESPACE::Event const && operator*() const && VULKAN_HPP_NOEXCEPT
      {
        return std::move( m_event );
      }

      operator VULKAN_HPP_NAMESPACE::Event() const VULKAN_HPP_NOEXCEPT
      {
        return m_event;
      }

      void clear() VULKAN_HPP_NOEXCEPT
      {
        if ( m_event )
        {
          getDispatcher()->vkDestroyEvent(
            static_cast<VkDevice>( m_device ), static_cast<VkEvent>( m_event ), reinterpret_cast<const VkAllocationCallbacks *>( m_allocator ) );
        }
        m_device     = nullptr;
        m_event      = nullptr;
        m_allocator  = nullptr;
        m_dispatcher = nullptr;
      }

      VULKAN_HPP_NAMESPACE::Event release()
      {
        m_device     = nullptr;
        m_allocator  = nullptr;
        m_dispatcher = nullptr;
        return exchange( m_event, nullptr );
      }

      VULKAN_HPP_NAMESPACE::Device getDevice() const
      {
        return m_device;
      }

      detail::DeviceDispatcher const * getDispatcher() const
      {
        VULKAN_HPP_ASSERT( m_dispatcher->getVkHeaderVersion() == VK_HEADER_VERSION );
        return m_dispatcher;
      }

      void swap( Event & rhs ) VULKAN_HPP_NOEXCEPT
      {
        std::swap( m_device, rhs.m_device );
        std::swap( m_event, rhs.m_event );
        std::swap( m_allocator, rhs.m_allocator );
        std::swap( m_dispatcher, rhs.m_dispatcher );
      }

      //=== VK_VERSION_1_0 ===

      // wrapper function for command vkGetEventStatus, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetEventStatus.html
      VULKAN_HPP_NODISCARD Result getStatus() const;

      // wrapper function for command vkSetEvent, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkSetEvent.html
      typename ResultValueType<void>::type set() const;

      // wrapper function for command vkResetEvent, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkResetEvent.html
      typename ResultValueType<void>::type reset() const;

    private:
      VULKAN_HPP_NAMESPACE::Device     m_device     = {};
      VULKAN_HPP_NAMESPACE::Event      m_event      = {};
      const AllocationCallbacks *      m_allocator  = {};
      detail::DeviceDispatcher const * m_dispatcher = nullptr;
    };

    template <>
    struct isVulkanRAIIHandleType<Event>
    {
      static VULKAN_HPP_CONST_OR_CONSTEXPR bool value = true;
    };

    // wrapper class for handle VkExternalComputeQueueNV, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkExternalComputeQueueNV.html
    class ExternalComputeQueueNV
    {
    public:
      using CType   = VkExternalComputeQueueNV;
      using CppType = VULKAN_HPP_NAMESPACE::ExternalComputeQueueNV;

      static VULKAN_HPP_CONST_OR_CONSTEXPR ObjectType               objectType            = ObjectType::eExternalComputeQueueNV;
      static VULKAN_HPP_CONST_OR_CONSTEXPR DebugReportObjectTypeEXT debugReportObjectType = DebugReportObjectTypeEXT::eUnknown;

    public:
#  if !defined( VULKAN_HPP_NO_EXCEPTIONS )
      ExternalComputeQueueNV( Device const &                           device,
                              ExternalComputeQueueCreateInfoNV const & createInfo,
                              Optional<const AllocationCallbacks>      allocator = nullptr )
      {
        *this = device.createExternalComputeQueueNV( createInfo, allocator );
      }
#  endif

      ExternalComputeQueueNV( Device const & device, VkExternalComputeQueueNV externalQueue, Optional<const AllocationCallbacks> allocator = nullptr )
        : m_device( device )
        , m_externalComputeQueueNV( externalQueue )
        , m_allocator( static_cast<const AllocationCallbacks *>( allocator ) )
        , m_dispatcher( device.getDispatcher() )
      {
      }

      ExternalComputeQueueNV( std::nullptr_t ) {}

      ~ExternalComputeQueueNV()
      {
        clear();
      }

      ExternalComputeQueueNV()                                 = delete;
      ExternalComputeQueueNV( ExternalComputeQueueNV const & ) = delete;

      ExternalComputeQueueNV( ExternalComputeQueueNV && rhs ) VULKAN_HPP_NOEXCEPT
        : m_device( exchange( rhs.m_device, {} ) )
        , m_externalComputeQueueNV( exchange( rhs.m_externalComputeQueueNV, {} ) )
        , m_allocator( exchange( rhs.m_allocator, {} ) )
        , m_dispatcher( exchange( rhs.m_dispatcher, nullptr ) )
      {
      }

      ExternalComputeQueueNV & operator=( ExternalComputeQueueNV const & ) = delete;

      ExternalComputeQueueNV & operator=( ExternalComputeQueueNV && rhs ) VULKAN_HPP_NOEXCEPT
      {
        if ( this != &rhs )
        {
          std::swap( m_device, rhs.m_device );
          std::swap( m_externalComputeQueueNV, rhs.m_externalComputeQueueNV );
          std::swap( m_allocator, rhs.m_allocator );
          std::swap( m_dispatcher, rhs.m_dispatcher );
        }
        return *this;
      }

      VULKAN_HPP_NAMESPACE::ExternalComputeQueueNV const & operator*() const & VULKAN_HPP_NOEXCEPT
      {
        return m_externalComputeQueueNV;
      }

      VULKAN_HPP_NAMESPACE::ExternalComputeQueueNV const && operator*() const && VULKAN_HPP_NOEXCEPT
      {
        return std::move( m_externalComputeQueueNV );
      }

      operator VULKAN_HPP_NAMESPACE::ExternalComputeQueueNV() const VULKAN_HPP_NOEXCEPT
      {
        return m_externalComputeQueueNV;
      }

      void clear() VULKAN_HPP_NOEXCEPT
      {
        if ( m_externalComputeQueueNV )
        {
          getDispatcher()->vkDestroyExternalComputeQueueNV( static_cast<VkDevice>( m_device ),
                                                            static_cast<VkExternalComputeQueueNV>( m_externalComputeQueueNV ),
                                                            reinterpret_cast<const VkAllocationCallbacks *>( m_allocator ) );
        }
        m_device                 = nullptr;
        m_externalComputeQueueNV = nullptr;
        m_allocator              = nullptr;
        m_dispatcher             = nullptr;
      }

      VULKAN_HPP_NAMESPACE::ExternalComputeQueueNV release()
      {
        m_device     = nullptr;
        m_allocator  = nullptr;
        m_dispatcher = nullptr;
        return exchange( m_externalComputeQueueNV, nullptr );
      }

      VULKAN_HPP_NAMESPACE::Device getDevice() const
      {
        return m_device;
      }

      detail::DeviceDispatcher const * getDispatcher() const
      {
        VULKAN_HPP_ASSERT( m_dispatcher->getVkHeaderVersion() == VK_HEADER_VERSION );
        return m_dispatcher;
      }

      void swap( ExternalComputeQueueNV & rhs ) VULKAN_HPP_NOEXCEPT
      {
        std::swap( m_device, rhs.m_device );
        std::swap( m_externalComputeQueueNV, rhs.m_externalComputeQueueNV );
        std::swap( m_allocator, rhs.m_allocator );
        std::swap( m_dispatcher, rhs.m_dispatcher );
      }

      //=== VK_NV_external_compute_queue ===

      // wrapper function for command vkGetExternalComputeQueueDataNV, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetExternalComputeQueueDataNV.html
      template <typename DataType>
      VULKAN_HPP_NODISCARD std::pair<ExternalComputeQueueDataParamsNV, DataType> getData() const VULKAN_HPP_NOEXCEPT;

    private:
      VULKAN_HPP_NAMESPACE::Device                 m_device                 = {};
      VULKAN_HPP_NAMESPACE::ExternalComputeQueueNV m_externalComputeQueueNV = {};
      const AllocationCallbacks *                  m_allocator              = {};
      detail::DeviceDispatcher const *             m_dispatcher             = nullptr;
    };

    template <>
    struct isVulkanRAIIHandleType<ExternalComputeQueueNV>
    {
      static VULKAN_HPP_CONST_OR_CONSTEXPR bool value = true;
    };

    // wrapper class for handle VkFence, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkFence.html
    class Fence
    {
    public:
      using CType   = VkFence;
      using CppType = VULKAN_HPP_NAMESPACE::Fence;

      static VULKAN_HPP_CONST_OR_CONSTEXPR ObjectType               objectType            = ObjectType::eFence;
      static VULKAN_HPP_CONST_OR_CONSTEXPR DebugReportObjectTypeEXT debugReportObjectType = DebugReportObjectTypeEXT::eFence;

    public:
#  if !defined( VULKAN_HPP_NO_EXCEPTIONS )
      Fence( Device const & device, FenceCreateInfo const & createInfo, Optional<const AllocationCallbacks> allocator = nullptr )
      {
        *this = device.createFence( createInfo, allocator );
      }
#  endif

#  if !defined( VULKAN_HPP_NO_EXCEPTIONS )
      Fence( Device const & device, DeviceEventInfoEXT const & deviceEventInfo, Optional<const AllocationCallbacks> allocator = nullptr )
      {
        *this = device.registerEventEXT( deviceEventInfo, allocator );
      }
#  endif

#  if !defined( VULKAN_HPP_NO_EXCEPTIONS )
      Fence( Device const &                      device,
             DisplayKHR const &                  display,
             DisplayEventInfoEXT const &         displayEventInfo,
             Optional<const AllocationCallbacks> allocator = nullptr )
      {
        *this = device.registerDisplayEventEXT( display, displayEventInfo, allocator );
      }
#  endif

      Fence( Device const & device, VkFence fence, Optional<const AllocationCallbacks> allocator = nullptr )
        : m_device( device ), m_fence( fence ), m_allocator( static_cast<const AllocationCallbacks *>( allocator ) ), m_dispatcher( device.getDispatcher() )
      {
      }

      Fence( std::nullptr_t ) {}

      ~Fence()
      {
        clear();
      }

      Fence()                = delete;
      Fence( Fence const & ) = delete;

      Fence( Fence && rhs ) VULKAN_HPP_NOEXCEPT
        : m_device( exchange( rhs.m_device, {} ) )
        , m_fence( exchange( rhs.m_fence, {} ) )
        , m_allocator( exchange( rhs.m_allocator, {} ) )
        , m_dispatcher( exchange( rhs.m_dispatcher, nullptr ) )
      {
      }

      Fence & operator=( Fence const & ) = delete;

      Fence & operator=( Fence && rhs ) VULKAN_HPP_NOEXCEPT
      {
        if ( this != &rhs )
        {
          std::swap( m_device, rhs.m_device );
          std::swap( m_fence, rhs.m_fence );
          std::swap( m_allocator, rhs.m_allocator );
          std::swap( m_dispatcher, rhs.m_dispatcher );
        }
        return *this;
      }

      VULKAN_HPP_NAMESPACE::Fence const & operator*() const & VULKAN_HPP_NOEXCEPT
      {
        return m_fence;
      }

      VULKAN_HPP_NAMESPACE::Fence const && operator*() const && VULKAN_HPP_NOEXCEPT
      {
        return std::move( m_fence );
      }

      operator VULKAN_HPP_NAMESPACE::Fence() const VULKAN_HPP_NOEXCEPT
      {
        return m_fence;
      }

      void clear() VULKAN_HPP_NOEXCEPT
      {
        if ( m_fence )
        {
          getDispatcher()->vkDestroyFence(
            static_cast<VkDevice>( m_device ), static_cast<VkFence>( m_fence ), reinterpret_cast<const VkAllocationCallbacks *>( m_allocator ) );
        }
        m_device     = nullptr;
        m_fence      = nullptr;
        m_allocator  = nullptr;
        m_dispatcher = nullptr;
      }

      VULKAN_HPP_NAMESPACE::Fence release()
      {
        m_device     = nullptr;
        m_allocator  = nullptr;
        m_dispatcher = nullptr;
        return exchange( m_fence, nullptr );
      }

      VULKAN_HPP_NAMESPACE::Device getDevice() const
      {
        return m_device;
      }

      detail::DeviceDispatcher const * getDispatcher() const
      {
        VULKAN_HPP_ASSERT( m_dispatcher->getVkHeaderVersion() == VK_HEADER_VERSION );
        return m_dispatcher;
      }

      void swap( Fence & rhs ) VULKAN_HPP_NOEXCEPT
      {
        std::swap( m_device, rhs.m_device );
        std::swap( m_fence, rhs.m_fence );
        std::swap( m_allocator, rhs.m_allocator );
        std::swap( m_dispatcher, rhs.m_dispatcher );
      }

      //=== VK_VERSION_1_0 ===

      // wrapper function for command vkGetFenceStatus, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetFenceStatus.html
      VULKAN_HPP_NODISCARD Result getStatus() const;

    private:
      VULKAN_HPP_NAMESPACE::Device     m_device     = {};
      VULKAN_HPP_NAMESPACE::Fence      m_fence      = {};
      const AllocationCallbacks *      m_allocator  = {};
      detail::DeviceDispatcher const * m_dispatcher = nullptr;
    };

    template <>
    struct isVulkanRAIIHandleType<Fence>
    {
      static VULKAN_HPP_CONST_OR_CONSTEXPR bool value = true;
    };

    // wrapper class for handle VkFramebuffer, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkFramebuffer.html
    class Framebuffer
    {
    public:
      using CType   = VkFramebuffer;
      using CppType = VULKAN_HPP_NAMESPACE::Framebuffer;

      static VULKAN_HPP_CONST_OR_CONSTEXPR ObjectType               objectType            = ObjectType::eFramebuffer;
      static VULKAN_HPP_CONST_OR_CONSTEXPR DebugReportObjectTypeEXT debugReportObjectType = DebugReportObjectTypeEXT::eFramebuffer;

    public:
#  if !defined( VULKAN_HPP_NO_EXCEPTIONS )
      Framebuffer( Device const & device, FramebufferCreateInfo const & createInfo, Optional<const AllocationCallbacks> allocator = nullptr )
      {
        *this = device.createFramebuffer( createInfo, allocator );
      }
#  endif

      Framebuffer( Device const & device, VkFramebuffer framebuffer, Optional<const AllocationCallbacks> allocator = nullptr )
        : m_device( device )
        , m_framebuffer( framebuffer )
        , m_allocator( static_cast<const AllocationCallbacks *>( allocator ) )
        , m_dispatcher( device.getDispatcher() )
      {
      }

      Framebuffer( std::nullptr_t ) {}

      ~Framebuffer()
      {
        clear();
      }

      Framebuffer()                      = delete;
      Framebuffer( Framebuffer const & ) = delete;

      Framebuffer( Framebuffer && rhs ) VULKAN_HPP_NOEXCEPT
        : m_device( exchange( rhs.m_device, {} ) )
        , m_framebuffer( exchange( rhs.m_framebuffer, {} ) )
        , m_allocator( exchange( rhs.m_allocator, {} ) )
        , m_dispatcher( exchange( rhs.m_dispatcher, nullptr ) )
      {
      }

      Framebuffer & operator=( Framebuffer const & ) = delete;

      Framebuffer & operator=( Framebuffer && rhs ) VULKAN_HPP_NOEXCEPT
      {
        if ( this != &rhs )
        {
          std::swap( m_device, rhs.m_device );
          std::swap( m_framebuffer, rhs.m_framebuffer );
          std::swap( m_allocator, rhs.m_allocator );
          std::swap( m_dispatcher, rhs.m_dispatcher );
        }
        return *this;
      }

      VULKAN_HPP_NAMESPACE::Framebuffer const & operator*() const & VULKAN_HPP_NOEXCEPT
      {
        return m_framebuffer;
      }

      VULKAN_HPP_NAMESPACE::Framebuffer const && operator*() const && VULKAN_HPP_NOEXCEPT
      {
        return std::move( m_framebuffer );
      }

      operator VULKAN_HPP_NAMESPACE::Framebuffer() const VULKAN_HPP_NOEXCEPT
      {
        return m_framebuffer;
      }

      void clear() VULKAN_HPP_NOEXCEPT
      {
        if ( m_framebuffer )
        {
          getDispatcher()->vkDestroyFramebuffer(
            static_cast<VkDevice>( m_device ), static_cast<VkFramebuffer>( m_framebuffer ), reinterpret_cast<const VkAllocationCallbacks *>( m_allocator ) );
        }
        m_device      = nullptr;
        m_framebuffer = nullptr;
        m_allocator   = nullptr;
        m_dispatcher  = nullptr;
      }

      VULKAN_HPP_NAMESPACE::Framebuffer release()
      {
        m_device     = nullptr;
        m_allocator  = nullptr;
        m_dispatcher = nullptr;
        return exchange( m_framebuffer, nullptr );
      }

      VULKAN_HPP_NAMESPACE::Device getDevice() const
      {
        return m_device;
      }

      detail::DeviceDispatcher const * getDispatcher() const
      {
        VULKAN_HPP_ASSERT( m_dispatcher->getVkHeaderVersion() == VK_HEADER_VERSION );
        return m_dispatcher;
      }

      void swap( Framebuffer & rhs ) VULKAN_HPP_NOEXCEPT
      {
        std::swap( m_device, rhs.m_device );
        std::swap( m_framebuffer, rhs.m_framebuffer );
        std::swap( m_allocator, rhs.m_allocator );
        std::swap( m_dispatcher, rhs.m_dispatcher );
      }

      //=== VK_QCOM_tile_properties ===

      // wrapper function for command vkGetFramebufferTilePropertiesQCOM, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetFramebufferTilePropertiesQCOM.html
      VULKAN_HPP_NODISCARD typename ResultValueType<std::vector<TilePropertiesQCOM>>::type getTilePropertiesQCOM() const;

    private:
      VULKAN_HPP_NAMESPACE::Device      m_device      = {};
      VULKAN_HPP_NAMESPACE::Framebuffer m_framebuffer = {};
      const AllocationCallbacks *       m_allocator   = {};
      detail::DeviceDispatcher const *  m_dispatcher  = nullptr;
    };

    template <>
    struct isVulkanRAIIHandleType<Framebuffer>
    {
      static VULKAN_HPP_CONST_OR_CONSTEXPR bool value = true;
    };

    // wrapper class for handle VkImage, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkImage.html
    class Image
    {
    public:
      using CType   = VkImage;
      using CppType = VULKAN_HPP_NAMESPACE::Image;

      static VULKAN_HPP_CONST_OR_CONSTEXPR ObjectType               objectType            = ObjectType::eImage;
      static VULKAN_HPP_CONST_OR_CONSTEXPR DebugReportObjectTypeEXT debugReportObjectType = DebugReportObjectTypeEXT::eImage;

    public:
#  if !defined( VULKAN_HPP_NO_EXCEPTIONS )
      Image( Device const & device, ImageCreateInfo const & createInfo, Optional<const AllocationCallbacks> allocator = nullptr )
      {
        *this = device.createImage( createInfo, allocator );
      }
#  endif

      Image( Device const & device, VkImage image, Optional<const AllocationCallbacks> allocator = nullptr )
        : m_device( device ), m_image( image ), m_allocator( static_cast<const AllocationCallbacks *>( allocator ) ), m_dispatcher( device.getDispatcher() )
      {
      }

      Image( std::nullptr_t ) {}

      ~Image()
      {
        clear();
      }

      Image()                = delete;
      Image( Image const & ) = delete;

      Image( Image && rhs ) VULKAN_HPP_NOEXCEPT
        : m_device( exchange( rhs.m_device, {} ) )
        , m_image( exchange( rhs.m_image, {} ) )
        , m_allocator( exchange( rhs.m_allocator, {} ) )
        , m_dispatcher( exchange( rhs.m_dispatcher, nullptr ) )
      {
      }

      Image & operator=( Image const & ) = delete;

      Image & operator=( Image && rhs ) VULKAN_HPP_NOEXCEPT
      {
        if ( this != &rhs )
        {
          std::swap( m_device, rhs.m_device );
          std::swap( m_image, rhs.m_image );
          std::swap( m_allocator, rhs.m_allocator );
          std::swap( m_dispatcher, rhs.m_dispatcher );
        }
        return *this;
      }

      VULKAN_HPP_NAMESPACE::Image const & operator*() const & VULKAN_HPP_NOEXCEPT
      {
        return m_image;
      }

      VULKAN_HPP_NAMESPACE::Image const && operator*() const && VULKAN_HPP_NOEXCEPT
      {
        return std::move( m_image );
      }

      operator VULKAN_HPP_NAMESPACE::Image() const VULKAN_HPP_NOEXCEPT
      {
        return m_image;
      }

      void clear() VULKAN_HPP_NOEXCEPT
      {
        if ( m_image )
        {
          getDispatcher()->vkDestroyImage(
            static_cast<VkDevice>( m_device ), static_cast<VkImage>( m_image ), reinterpret_cast<const VkAllocationCallbacks *>( m_allocator ) );
        }
        m_device     = nullptr;
        m_image      = nullptr;
        m_allocator  = nullptr;
        m_dispatcher = nullptr;
      }

      VULKAN_HPP_NAMESPACE::Image release()
      {
        m_device     = nullptr;
        m_allocator  = nullptr;
        m_dispatcher = nullptr;
        return exchange( m_image, nullptr );
      }

      VULKAN_HPP_NAMESPACE::Device getDevice() const
      {
        return m_device;
      }

      detail::DeviceDispatcher const * getDispatcher() const
      {
        VULKAN_HPP_ASSERT( m_dispatcher->getVkHeaderVersion() == VK_HEADER_VERSION );
        return m_dispatcher;
      }

      void swap( Image & rhs ) VULKAN_HPP_NOEXCEPT
      {
        std::swap( m_device, rhs.m_device );
        std::swap( m_image, rhs.m_image );
        std::swap( m_allocator, rhs.m_allocator );
        std::swap( m_dispatcher, rhs.m_dispatcher );
      }

      //=== VK_VERSION_1_0 ===

      // wrapper function for command vkBindImageMemory, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkBindImageMemory.html
      typename ResultValueType<void>::type bindMemory( VULKAN_HPP_NAMESPACE::DeviceMemory memory, DeviceSize memoryOffset ) const;

      // wrapper function for command vkGetImageMemoryRequirements, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetImageMemoryRequirements.html
      VULKAN_HPP_NODISCARD MemoryRequirements getMemoryRequirements() const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkGetImageSparseMemoryRequirements, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetImageSparseMemoryRequirements.html
      VULKAN_HPP_NODISCARD std::vector<SparseImageMemoryRequirements> getSparseMemoryRequirements() const;

      // wrapper function for command vkGetImageSubresourceLayout, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetImageSubresourceLayout.html
      VULKAN_HPP_NODISCARD SubresourceLayout getSubresourceLayout( const ImageSubresource & subresource ) const VULKAN_HPP_NOEXCEPT;

      //=== VK_VERSION_1_4 ===

      // wrapper function for command vkGetImageSubresourceLayout2, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetImageSubresourceLayout2.html
      VULKAN_HPP_NODISCARD SubresourceLayout2 getSubresourceLayout2( const ImageSubresource2 & subresource ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkGetImageSubresourceLayout2, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetImageSubresourceLayout2.html
      template <typename X, typename Y, typename... Z>
      VULKAN_HPP_NODISCARD StructureChain<X, Y, Z...> getSubresourceLayout2( const ImageSubresource2 & subresource ) const VULKAN_HPP_NOEXCEPT;

      //=== VK_EXT_image_drm_format_modifier ===

      // wrapper function for command vkGetImageDrmFormatModifierPropertiesEXT, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetImageDrmFormatModifierPropertiesEXT.html
      VULKAN_HPP_NODISCARD typename ResultValueType<ImageDrmFormatModifierPropertiesEXT>::type getDrmFormatModifierPropertiesEXT() const;

      //=== VK_EXT_host_image_copy ===

      // wrapper function for command vkGetImageSubresourceLayout2EXT, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetImageSubresourceLayout2EXT.html
      VULKAN_HPP_NODISCARD SubresourceLayout2 getSubresourceLayout2EXT( const ImageSubresource2 & subresource ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkGetImageSubresourceLayout2EXT, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetImageSubresourceLayout2EXT.html
      template <typename X, typename Y, typename... Z>
      VULKAN_HPP_NODISCARD StructureChain<X, Y, Z...> getSubresourceLayout2EXT( const ImageSubresource2 & subresource ) const VULKAN_HPP_NOEXCEPT;

      //=== VK_KHR_maintenance5 ===

      // wrapper function for command vkGetImageSubresourceLayout2KHR, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetImageSubresourceLayout2KHR.html
      VULKAN_HPP_NODISCARD SubresourceLayout2 getSubresourceLayout2KHR( const ImageSubresource2 & subresource ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkGetImageSubresourceLayout2KHR, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetImageSubresourceLayout2KHR.html
      template <typename X, typename Y, typename... Z>
      VULKAN_HPP_NODISCARD StructureChain<X, Y, Z...> getSubresourceLayout2KHR( const ImageSubresource2 & subresource ) const VULKAN_HPP_NOEXCEPT;

#  if defined( VK_USE_PLATFORM_OHOS )
      //=== VK_OHOS_native_buffer ===

      // wrapper function for command vkAcquireImageOHOS, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkAcquireImageOHOS.html
      typename ResultValueType<void>::type acquireOHOS( int32_t                                   nativeFenceFd,
                                                        VULKAN_HPP_NAMESPACE::Semaphore semaphore VULKAN_HPP_DEFAULT_ASSIGNMENT( {} ),
                                                        VULKAN_HPP_NAMESPACE::Fence fence         VULKAN_HPP_DEFAULT_ASSIGNMENT( {} ) ) const;
#  endif /*VK_USE_PLATFORM_OHOS*/

    protected:
      Image( VULKAN_HPP_NAMESPACE::Device     device,
             VULKAN_HPP_NAMESPACE::Image      image,
             const AllocationCallbacks *      allocator,
             detail::DeviceDispatcher const * dispatcher ) VULKAN_HPP_NOEXCEPT
        : m_device( exchange( device, {} ) )
        , m_image( exchange( image, {} ) )
        , m_allocator( exchange( allocator, {} ) )
        , m_dispatcher( exchange( dispatcher, nullptr ) )
      {
      }

    private:
      VULKAN_HPP_NAMESPACE::Device     m_device     = {};
      VULKAN_HPP_NAMESPACE::Image      m_image      = {};
      const AllocationCallbacks *      m_allocator  = {};
      detail::DeviceDispatcher const * m_dispatcher = nullptr;
    };

    template <>
    struct isVulkanRAIIHandleType<Image>
    {
      static VULKAN_HPP_CONST_OR_CONSTEXPR bool value = true;
    };

    // wrapper class for handle VkImageView, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkImageView.html
    class ImageView
    {
    public:
      using CType   = VkImageView;
      using CppType = VULKAN_HPP_NAMESPACE::ImageView;

      static VULKAN_HPP_CONST_OR_CONSTEXPR ObjectType               objectType            = ObjectType::eImageView;
      static VULKAN_HPP_CONST_OR_CONSTEXPR DebugReportObjectTypeEXT debugReportObjectType = DebugReportObjectTypeEXT::eImageView;

    public:
#  if !defined( VULKAN_HPP_NO_EXCEPTIONS )
      ImageView( Device const & device, ImageViewCreateInfo const & createInfo, Optional<const AllocationCallbacks> allocator = nullptr )
      {
        *this = device.createImageView( createInfo, allocator );
      }
#  endif

      ImageView( Device const & device, VkImageView imageView, Optional<const AllocationCallbacks> allocator = nullptr )
        : m_device( device )
        , m_imageView( imageView )
        , m_allocator( static_cast<const AllocationCallbacks *>( allocator ) )
        , m_dispatcher( device.getDispatcher() )
      {
      }

      ImageView( std::nullptr_t ) {}

      ~ImageView()
      {
        clear();
      }

      ImageView()                    = delete;
      ImageView( ImageView const & ) = delete;

      ImageView( ImageView && rhs ) VULKAN_HPP_NOEXCEPT
        : m_device( exchange( rhs.m_device, {} ) )
        , m_imageView( exchange( rhs.m_imageView, {} ) )
        , m_allocator( exchange( rhs.m_allocator, {} ) )
        , m_dispatcher( exchange( rhs.m_dispatcher, nullptr ) )
      {
      }

      ImageView & operator=( ImageView const & ) = delete;

      ImageView & operator=( ImageView && rhs ) VULKAN_HPP_NOEXCEPT
      {
        if ( this != &rhs )
        {
          std::swap( m_device, rhs.m_device );
          std::swap( m_imageView, rhs.m_imageView );
          std::swap( m_allocator, rhs.m_allocator );
          std::swap( m_dispatcher, rhs.m_dispatcher );
        }
        return *this;
      }

      VULKAN_HPP_NAMESPACE::ImageView const & operator*() const & VULKAN_HPP_NOEXCEPT
      {
        return m_imageView;
      }

      VULKAN_HPP_NAMESPACE::ImageView const && operator*() const && VULKAN_HPP_NOEXCEPT
      {
        return std::move( m_imageView );
      }

      operator VULKAN_HPP_NAMESPACE::ImageView() const VULKAN_HPP_NOEXCEPT
      {
        return m_imageView;
      }

      void clear() VULKAN_HPP_NOEXCEPT
      {
        if ( m_imageView )
        {
          getDispatcher()->vkDestroyImageView(
            static_cast<VkDevice>( m_device ), static_cast<VkImageView>( m_imageView ), reinterpret_cast<const VkAllocationCallbacks *>( m_allocator ) );
        }
        m_device     = nullptr;
        m_imageView  = nullptr;
        m_allocator  = nullptr;
        m_dispatcher = nullptr;
      }

      VULKAN_HPP_NAMESPACE::ImageView release()
      {
        m_device     = nullptr;
        m_allocator  = nullptr;
        m_dispatcher = nullptr;
        return exchange( m_imageView, nullptr );
      }

      VULKAN_HPP_NAMESPACE::Device getDevice() const
      {
        return m_device;
      }

      detail::DeviceDispatcher const * getDispatcher() const
      {
        VULKAN_HPP_ASSERT( m_dispatcher->getVkHeaderVersion() == VK_HEADER_VERSION );
        return m_dispatcher;
      }

      void swap( ImageView & rhs ) VULKAN_HPP_NOEXCEPT
      {
        std::swap( m_device, rhs.m_device );
        std::swap( m_imageView, rhs.m_imageView );
        std::swap( m_allocator, rhs.m_allocator );
        std::swap( m_dispatcher, rhs.m_dispatcher );
      }

      //=== VK_NVX_image_view_handle ===

      // wrapper function for command vkGetImageViewAddressNVX, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetImageViewAddressNVX.html
      VULKAN_HPP_NODISCARD typename ResultValueType<ImageViewAddressPropertiesNVX>::type getAddressNVX() const;

    private:
      VULKAN_HPP_NAMESPACE::Device     m_device     = {};
      VULKAN_HPP_NAMESPACE::ImageView  m_imageView  = {};
      const AllocationCallbacks *      m_allocator  = {};
      detail::DeviceDispatcher const * m_dispatcher = nullptr;
    };

    template <>
    struct isVulkanRAIIHandleType<ImageView>
    {
      static VULKAN_HPP_CONST_OR_CONSTEXPR bool value = true;
    };

    // wrapper class for handle VkIndirectCommandsLayoutEXT, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkIndirectCommandsLayoutEXT.html
    class IndirectCommandsLayoutEXT
    {
    public:
      using CType   = VkIndirectCommandsLayoutEXT;
      using CppType = VULKAN_HPP_NAMESPACE::IndirectCommandsLayoutEXT;

      static VULKAN_HPP_CONST_OR_CONSTEXPR ObjectType               objectType            = ObjectType::eIndirectCommandsLayoutEXT;
      static VULKAN_HPP_CONST_OR_CONSTEXPR DebugReportObjectTypeEXT debugReportObjectType = DebugReportObjectTypeEXT::eUnknown;

    public:
#  if !defined( VULKAN_HPP_NO_EXCEPTIONS )
      IndirectCommandsLayoutEXT( Device const &                              device,
                                 IndirectCommandsLayoutCreateInfoEXT const & createInfo,
                                 Optional<const AllocationCallbacks>         allocator = nullptr )
      {
        *this = device.createIndirectCommandsLayoutEXT( createInfo, allocator );
      }
#  endif

      IndirectCommandsLayoutEXT( Device const &                      device,
                                 VkIndirectCommandsLayoutEXT         indirectCommandsLayout,
                                 Optional<const AllocationCallbacks> allocator = nullptr )
        : m_device( device )
        , m_indirectCommandsLayoutEXT( indirectCommandsLayout )
        , m_allocator( static_cast<const AllocationCallbacks *>( allocator ) )
        , m_dispatcher( device.getDispatcher() )
      {
      }

      IndirectCommandsLayoutEXT( std::nullptr_t ) {}

      ~IndirectCommandsLayoutEXT()
      {
        clear();
      }

      IndirectCommandsLayoutEXT()                                    = delete;
      IndirectCommandsLayoutEXT( IndirectCommandsLayoutEXT const & ) = delete;

      IndirectCommandsLayoutEXT( IndirectCommandsLayoutEXT && rhs ) VULKAN_HPP_NOEXCEPT
        : m_device( exchange( rhs.m_device, {} ) )
        , m_indirectCommandsLayoutEXT( exchange( rhs.m_indirectCommandsLayoutEXT, {} ) )
        , m_allocator( exchange( rhs.m_allocator, {} ) )
        , m_dispatcher( exchange( rhs.m_dispatcher, nullptr ) )
      {
      }

      IndirectCommandsLayoutEXT & operator=( IndirectCommandsLayoutEXT const & ) = delete;

      IndirectCommandsLayoutEXT & operator=( IndirectCommandsLayoutEXT && rhs ) VULKAN_HPP_NOEXCEPT
      {
        if ( this != &rhs )
        {
          std::swap( m_device, rhs.m_device );
          std::swap( m_indirectCommandsLayoutEXT, rhs.m_indirectCommandsLayoutEXT );
          std::swap( m_allocator, rhs.m_allocator );
          std::swap( m_dispatcher, rhs.m_dispatcher );
        }
        return *this;
      }

      VULKAN_HPP_NAMESPACE::IndirectCommandsLayoutEXT const & operator*() const & VULKAN_HPP_NOEXCEPT
      {
        return m_indirectCommandsLayoutEXT;
      }

      VULKAN_HPP_NAMESPACE::IndirectCommandsLayoutEXT const && operator*() const && VULKAN_HPP_NOEXCEPT
      {
        return std::move( m_indirectCommandsLayoutEXT );
      }

      operator VULKAN_HPP_NAMESPACE::IndirectCommandsLayoutEXT() const VULKAN_HPP_NOEXCEPT
      {
        return m_indirectCommandsLayoutEXT;
      }

      void clear() VULKAN_HPP_NOEXCEPT
      {
        if ( m_indirectCommandsLayoutEXT )
        {
          getDispatcher()->vkDestroyIndirectCommandsLayoutEXT( static_cast<VkDevice>( m_device ),
                                                               static_cast<VkIndirectCommandsLayoutEXT>( m_indirectCommandsLayoutEXT ),
                                                               reinterpret_cast<const VkAllocationCallbacks *>( m_allocator ) );
        }
        m_device                    = nullptr;
        m_indirectCommandsLayoutEXT = nullptr;
        m_allocator                 = nullptr;
        m_dispatcher                = nullptr;
      }

      VULKAN_HPP_NAMESPACE::IndirectCommandsLayoutEXT release()
      {
        m_device     = nullptr;
        m_allocator  = nullptr;
        m_dispatcher = nullptr;
        return exchange( m_indirectCommandsLayoutEXT, nullptr );
      }

      VULKAN_HPP_NAMESPACE::Device getDevice() const
      {
        return m_device;
      }

      detail::DeviceDispatcher const * getDispatcher() const
      {
        VULKAN_HPP_ASSERT( m_dispatcher->getVkHeaderVersion() == VK_HEADER_VERSION );
        return m_dispatcher;
      }

      void swap( IndirectCommandsLayoutEXT & rhs ) VULKAN_HPP_NOEXCEPT
      {
        std::swap( m_device, rhs.m_device );
        std::swap( m_indirectCommandsLayoutEXT, rhs.m_indirectCommandsLayoutEXT );
        std::swap( m_allocator, rhs.m_allocator );
        std::swap( m_dispatcher, rhs.m_dispatcher );
      }

    private:
      VULKAN_HPP_NAMESPACE::Device                    m_device                    = {};
      VULKAN_HPP_NAMESPACE::IndirectCommandsLayoutEXT m_indirectCommandsLayoutEXT = {};
      const AllocationCallbacks *                     m_allocator                 = {};
      detail::DeviceDispatcher const *                m_dispatcher                = nullptr;
    };

    template <>
    struct isVulkanRAIIHandleType<IndirectCommandsLayoutEXT>
    {
      static VULKAN_HPP_CONST_OR_CONSTEXPR bool value = true;
    };

    // wrapper class for handle VkIndirectCommandsLayoutNV, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkIndirectCommandsLayoutNV.html
    class IndirectCommandsLayoutNV
    {
    public:
      using CType   = VkIndirectCommandsLayoutNV;
      using CppType = VULKAN_HPP_NAMESPACE::IndirectCommandsLayoutNV;

      static VULKAN_HPP_CONST_OR_CONSTEXPR ObjectType               objectType            = ObjectType::eIndirectCommandsLayoutNV;
      static VULKAN_HPP_CONST_OR_CONSTEXPR DebugReportObjectTypeEXT debugReportObjectType = DebugReportObjectTypeEXT::eUnknown;

    public:
#  if !defined( VULKAN_HPP_NO_EXCEPTIONS )
      IndirectCommandsLayoutNV( Device const &                             device,
                                IndirectCommandsLayoutCreateInfoNV const & createInfo,
                                Optional<const AllocationCallbacks>        allocator = nullptr )
      {
        *this = device.createIndirectCommandsLayoutNV( createInfo, allocator );
      }
#  endif

      IndirectCommandsLayoutNV( Device const &                      device,
                                VkIndirectCommandsLayoutNV          indirectCommandsLayout,
                                Optional<const AllocationCallbacks> allocator = nullptr )
        : m_device( device )
        , m_indirectCommandsLayoutNV( indirectCommandsLayout )
        , m_allocator( static_cast<const AllocationCallbacks *>( allocator ) )
        , m_dispatcher( device.getDispatcher() )
      {
      }

      IndirectCommandsLayoutNV( std::nullptr_t ) {}

      ~IndirectCommandsLayoutNV()
      {
        clear();
      }

      IndirectCommandsLayoutNV()                                   = delete;
      IndirectCommandsLayoutNV( IndirectCommandsLayoutNV const & ) = delete;

      IndirectCommandsLayoutNV( IndirectCommandsLayoutNV && rhs ) VULKAN_HPP_NOEXCEPT
        : m_device( exchange( rhs.m_device, {} ) )
        , m_indirectCommandsLayoutNV( exchange( rhs.m_indirectCommandsLayoutNV, {} ) )
        , m_allocator( exchange( rhs.m_allocator, {} ) )
        , m_dispatcher( exchange( rhs.m_dispatcher, nullptr ) )
      {
      }

      IndirectCommandsLayoutNV & operator=( IndirectCommandsLayoutNV const & ) = delete;

      IndirectCommandsLayoutNV & operator=( IndirectCommandsLayoutNV && rhs ) VULKAN_HPP_NOEXCEPT
      {
        if ( this != &rhs )
        {
          std::swap( m_device, rhs.m_device );
          std::swap( m_indirectCommandsLayoutNV, rhs.m_indirectCommandsLayoutNV );
          std::swap( m_allocator, rhs.m_allocator );
          std::swap( m_dispatcher, rhs.m_dispatcher );
        }
        return *this;
      }

      VULKAN_HPP_NAMESPACE::IndirectCommandsLayoutNV const & operator*() const & VULKAN_HPP_NOEXCEPT
      {
        return m_indirectCommandsLayoutNV;
      }

      VULKAN_HPP_NAMESPACE::IndirectCommandsLayoutNV const && operator*() const && VULKAN_HPP_NOEXCEPT
      {
        return std::move( m_indirectCommandsLayoutNV );
      }

      operator VULKAN_HPP_NAMESPACE::IndirectCommandsLayoutNV() const VULKAN_HPP_NOEXCEPT
      {
        return m_indirectCommandsLayoutNV;
      }

      void clear() VULKAN_HPP_NOEXCEPT
      {
        if ( m_indirectCommandsLayoutNV )
        {
          getDispatcher()->vkDestroyIndirectCommandsLayoutNV( static_cast<VkDevice>( m_device ),
                                                              static_cast<VkIndirectCommandsLayoutNV>( m_indirectCommandsLayoutNV ),
                                                              reinterpret_cast<const VkAllocationCallbacks *>( m_allocator ) );
        }
        m_device                   = nullptr;
        m_indirectCommandsLayoutNV = nullptr;
        m_allocator                = nullptr;
        m_dispatcher               = nullptr;
      }

      VULKAN_HPP_NAMESPACE::IndirectCommandsLayoutNV release()
      {
        m_device     = nullptr;
        m_allocator  = nullptr;
        m_dispatcher = nullptr;
        return exchange( m_indirectCommandsLayoutNV, nullptr );
      }

      VULKAN_HPP_NAMESPACE::Device getDevice() const
      {
        return m_device;
      }

      detail::DeviceDispatcher const * getDispatcher() const
      {
        VULKAN_HPP_ASSERT( m_dispatcher->getVkHeaderVersion() == VK_HEADER_VERSION );
        return m_dispatcher;
      }

      void swap( IndirectCommandsLayoutNV & rhs ) VULKAN_HPP_NOEXCEPT
      {
        std::swap( m_device, rhs.m_device );
        std::swap( m_indirectCommandsLayoutNV, rhs.m_indirectCommandsLayoutNV );
        std::swap( m_allocator, rhs.m_allocator );
        std::swap( m_dispatcher, rhs.m_dispatcher );
      }

    private:
      VULKAN_HPP_NAMESPACE::Device                   m_device                   = {};
      VULKAN_HPP_NAMESPACE::IndirectCommandsLayoutNV m_indirectCommandsLayoutNV = {};
      const AllocationCallbacks *                    m_allocator                = {};
      detail::DeviceDispatcher const *               m_dispatcher               = nullptr;
    };

    template <>
    struct isVulkanRAIIHandleType<IndirectCommandsLayoutNV>
    {
      static VULKAN_HPP_CONST_OR_CONSTEXPR bool value = true;
    };

    // wrapper class for handle VkIndirectExecutionSetEXT, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkIndirectExecutionSetEXT.html
    class IndirectExecutionSetEXT
    {
    public:
      using CType   = VkIndirectExecutionSetEXT;
      using CppType = VULKAN_HPP_NAMESPACE::IndirectExecutionSetEXT;

      static VULKAN_HPP_CONST_OR_CONSTEXPR ObjectType               objectType            = ObjectType::eIndirectExecutionSetEXT;
      static VULKAN_HPP_CONST_OR_CONSTEXPR DebugReportObjectTypeEXT debugReportObjectType = DebugReportObjectTypeEXT::eUnknown;

    public:
#  if !defined( VULKAN_HPP_NO_EXCEPTIONS )
      IndirectExecutionSetEXT( Device const &                            device,
                               IndirectExecutionSetCreateInfoEXT const & createInfo,
                               Optional<const AllocationCallbacks>       allocator = nullptr )
      {
        *this = device.createIndirectExecutionSetEXT( createInfo, allocator );
      }
#  endif

      IndirectExecutionSetEXT( Device const & device, VkIndirectExecutionSetEXT indirectExecutionSet, Optional<const AllocationCallbacks> allocator = nullptr )
        : m_device( device )
        , m_indirectExecutionSetEXT( indirectExecutionSet )
        , m_allocator( static_cast<const AllocationCallbacks *>( allocator ) )
        , m_dispatcher( device.getDispatcher() )
      {
      }

      IndirectExecutionSetEXT( std::nullptr_t ) {}

      ~IndirectExecutionSetEXT()
      {
        clear();
      }

      IndirectExecutionSetEXT()                                  = delete;
      IndirectExecutionSetEXT( IndirectExecutionSetEXT const & ) = delete;

      IndirectExecutionSetEXT( IndirectExecutionSetEXT && rhs ) VULKAN_HPP_NOEXCEPT
        : m_device( exchange( rhs.m_device, {} ) )
        , m_indirectExecutionSetEXT( exchange( rhs.m_indirectExecutionSetEXT, {} ) )
        , m_allocator( exchange( rhs.m_allocator, {} ) )
        , m_dispatcher( exchange( rhs.m_dispatcher, nullptr ) )
      {
      }

      IndirectExecutionSetEXT & operator=( IndirectExecutionSetEXT const & ) = delete;

      IndirectExecutionSetEXT & operator=( IndirectExecutionSetEXT && rhs ) VULKAN_HPP_NOEXCEPT
      {
        if ( this != &rhs )
        {
          std::swap( m_device, rhs.m_device );
          std::swap( m_indirectExecutionSetEXT, rhs.m_indirectExecutionSetEXT );
          std::swap( m_allocator, rhs.m_allocator );
          std::swap( m_dispatcher, rhs.m_dispatcher );
        }
        return *this;
      }

      VULKAN_HPP_NAMESPACE::IndirectExecutionSetEXT const & operator*() const & VULKAN_HPP_NOEXCEPT
      {
        return m_indirectExecutionSetEXT;
      }

      VULKAN_HPP_NAMESPACE::IndirectExecutionSetEXT const && operator*() const && VULKAN_HPP_NOEXCEPT
      {
        return std::move( m_indirectExecutionSetEXT );
      }

      operator VULKAN_HPP_NAMESPACE::IndirectExecutionSetEXT() const VULKAN_HPP_NOEXCEPT
      {
        return m_indirectExecutionSetEXT;
      }

      void clear() VULKAN_HPP_NOEXCEPT
      {
        if ( m_indirectExecutionSetEXT )
        {
          getDispatcher()->vkDestroyIndirectExecutionSetEXT( static_cast<VkDevice>( m_device ),
                                                             static_cast<VkIndirectExecutionSetEXT>( m_indirectExecutionSetEXT ),
                                                             reinterpret_cast<const VkAllocationCallbacks *>( m_allocator ) );
        }
        m_device                  = nullptr;
        m_indirectExecutionSetEXT = nullptr;
        m_allocator               = nullptr;
        m_dispatcher              = nullptr;
      }

      VULKAN_HPP_NAMESPACE::IndirectExecutionSetEXT release()
      {
        m_device     = nullptr;
        m_allocator  = nullptr;
        m_dispatcher = nullptr;
        return exchange( m_indirectExecutionSetEXT, nullptr );
      }

      VULKAN_HPP_NAMESPACE::Device getDevice() const
      {
        return m_device;
      }

      detail::DeviceDispatcher const * getDispatcher() const
      {
        VULKAN_HPP_ASSERT( m_dispatcher->getVkHeaderVersion() == VK_HEADER_VERSION );
        return m_dispatcher;
      }

      void swap( IndirectExecutionSetEXT & rhs ) VULKAN_HPP_NOEXCEPT
      {
        std::swap( m_device, rhs.m_device );
        std::swap( m_indirectExecutionSetEXT, rhs.m_indirectExecutionSetEXT );
        std::swap( m_allocator, rhs.m_allocator );
        std::swap( m_dispatcher, rhs.m_dispatcher );
      }

      //=== VK_EXT_device_generated_commands ===

      // wrapper function for command vkUpdateIndirectExecutionSetPipelineEXT, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkUpdateIndirectExecutionSetPipelineEXT.html
      void updatePipeline( ArrayProxy<const WriteIndirectExecutionSetPipelineEXT> const & executionSetWrites ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkUpdateIndirectExecutionSetShaderEXT, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkUpdateIndirectExecutionSetShaderEXT.html
      void updateShader( ArrayProxy<const WriteIndirectExecutionSetShaderEXT> const & executionSetWrites ) const VULKAN_HPP_NOEXCEPT;

    private:
      VULKAN_HPP_NAMESPACE::Device                  m_device                  = {};
      VULKAN_HPP_NAMESPACE::IndirectExecutionSetEXT m_indirectExecutionSetEXT = {};
      const AllocationCallbacks *                   m_allocator               = {};
      detail::DeviceDispatcher const *              m_dispatcher              = nullptr;
    };

    template <>
    struct isVulkanRAIIHandleType<IndirectExecutionSetEXT>
    {
      static VULKAN_HPP_CONST_OR_CONSTEXPR bool value = true;
    };

    // wrapper class for handle VkMicromapEXT, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkMicromapEXT.html
    class MicromapEXT
    {
    public:
      using CType   = VkMicromapEXT;
      using CppType = VULKAN_HPP_NAMESPACE::MicromapEXT;

      static VULKAN_HPP_CONST_OR_CONSTEXPR ObjectType               objectType            = ObjectType::eMicromapEXT;
      static VULKAN_HPP_CONST_OR_CONSTEXPR DebugReportObjectTypeEXT debugReportObjectType = DebugReportObjectTypeEXT::eUnknown;

    public:
#  if !defined( VULKAN_HPP_NO_EXCEPTIONS )
      MicromapEXT( Device const & device, MicromapCreateInfoEXT const & createInfo, Optional<const AllocationCallbacks> allocator = nullptr )
      {
        *this = device.createMicromapEXT( createInfo, allocator );
      }
#  endif

      MicromapEXT( Device const & device, VkMicromapEXT micromap, Optional<const AllocationCallbacks> allocator = nullptr )
        : m_device( device )
        , m_micromapEXT( micromap )
        , m_allocator( static_cast<const AllocationCallbacks *>( allocator ) )
        , m_dispatcher( device.getDispatcher() )
      {
      }

      MicromapEXT( std::nullptr_t ) {}

      ~MicromapEXT()
      {
        clear();
      }

      MicromapEXT()                      = delete;
      MicromapEXT( MicromapEXT const & ) = delete;

      MicromapEXT( MicromapEXT && rhs ) VULKAN_HPP_NOEXCEPT
        : m_device( exchange( rhs.m_device, {} ) )
        , m_micromapEXT( exchange( rhs.m_micromapEXT, {} ) )
        , m_allocator( exchange( rhs.m_allocator, {} ) )
        , m_dispatcher( exchange( rhs.m_dispatcher, nullptr ) )
      {
      }

      MicromapEXT & operator=( MicromapEXT const & ) = delete;

      MicromapEXT & operator=( MicromapEXT && rhs ) VULKAN_HPP_NOEXCEPT
      {
        if ( this != &rhs )
        {
          std::swap( m_device, rhs.m_device );
          std::swap( m_micromapEXT, rhs.m_micromapEXT );
          std::swap( m_allocator, rhs.m_allocator );
          std::swap( m_dispatcher, rhs.m_dispatcher );
        }
        return *this;
      }

      VULKAN_HPP_NAMESPACE::MicromapEXT const & operator*() const & VULKAN_HPP_NOEXCEPT
      {
        return m_micromapEXT;
      }

      VULKAN_HPP_NAMESPACE::MicromapEXT const && operator*() const && VULKAN_HPP_NOEXCEPT
      {
        return std::move( m_micromapEXT );
      }

      operator VULKAN_HPP_NAMESPACE::MicromapEXT() const VULKAN_HPP_NOEXCEPT
      {
        return m_micromapEXT;
      }

      void clear() VULKAN_HPP_NOEXCEPT
      {
        if ( m_micromapEXT )
        {
          getDispatcher()->vkDestroyMicromapEXT(
            static_cast<VkDevice>( m_device ), static_cast<VkMicromapEXT>( m_micromapEXT ), reinterpret_cast<const VkAllocationCallbacks *>( m_allocator ) );
        }
        m_device      = nullptr;
        m_micromapEXT = nullptr;
        m_allocator   = nullptr;
        m_dispatcher  = nullptr;
      }

      VULKAN_HPP_NAMESPACE::MicromapEXT release()
      {
        m_device     = nullptr;
        m_allocator  = nullptr;
        m_dispatcher = nullptr;
        return exchange( m_micromapEXT, nullptr );
      }

      VULKAN_HPP_NAMESPACE::Device getDevice() const
      {
        return m_device;
      }

      detail::DeviceDispatcher const * getDispatcher() const
      {
        VULKAN_HPP_ASSERT( m_dispatcher->getVkHeaderVersion() == VK_HEADER_VERSION );
        return m_dispatcher;
      }

      void swap( MicromapEXT & rhs ) VULKAN_HPP_NOEXCEPT
      {
        std::swap( m_device, rhs.m_device );
        std::swap( m_micromapEXT, rhs.m_micromapEXT );
        std::swap( m_allocator, rhs.m_allocator );
        std::swap( m_dispatcher, rhs.m_dispatcher );
      }

    private:
      VULKAN_HPP_NAMESPACE::Device      m_device      = {};
      VULKAN_HPP_NAMESPACE::MicromapEXT m_micromapEXT = {};
      const AllocationCallbacks *       m_allocator   = {};
      detail::DeviceDispatcher const *  m_dispatcher  = nullptr;
    };

    template <>
    struct isVulkanRAIIHandleType<MicromapEXT>
    {
      static VULKAN_HPP_CONST_OR_CONSTEXPR bool value = true;
    };

    // wrapper class for handle VkOpticalFlowSessionNV, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkOpticalFlowSessionNV.html
    class OpticalFlowSessionNV
    {
    public:
      using CType   = VkOpticalFlowSessionNV;
      using CppType = VULKAN_HPP_NAMESPACE::OpticalFlowSessionNV;

      static VULKAN_HPP_CONST_OR_CONSTEXPR ObjectType               objectType            = ObjectType::eOpticalFlowSessionNV;
      static VULKAN_HPP_CONST_OR_CONSTEXPR DebugReportObjectTypeEXT debugReportObjectType = DebugReportObjectTypeEXT::eUnknown;

    public:
#  if !defined( VULKAN_HPP_NO_EXCEPTIONS )
      OpticalFlowSessionNV( Device const & device, OpticalFlowSessionCreateInfoNV const & createInfo, Optional<const AllocationCallbacks> allocator = nullptr )
      {
        *this = device.createOpticalFlowSessionNV( createInfo, allocator );
      }
#  endif

      OpticalFlowSessionNV( Device const & device, VkOpticalFlowSessionNV session, Optional<const AllocationCallbacks> allocator = nullptr )
        : m_device( device )
        , m_opticalFlowSessionNV( session )
        , m_allocator( static_cast<const AllocationCallbacks *>( allocator ) )
        , m_dispatcher( device.getDispatcher() )
      {
      }

      OpticalFlowSessionNV( std::nullptr_t ) {}

      ~OpticalFlowSessionNV()
      {
        clear();
      }

      OpticalFlowSessionNV()                               = delete;
      OpticalFlowSessionNV( OpticalFlowSessionNV const & ) = delete;

      OpticalFlowSessionNV( OpticalFlowSessionNV && rhs ) VULKAN_HPP_NOEXCEPT
        : m_device( exchange( rhs.m_device, {} ) )
        , m_opticalFlowSessionNV( exchange( rhs.m_opticalFlowSessionNV, {} ) )
        , m_allocator( exchange( rhs.m_allocator, {} ) )
        , m_dispatcher( exchange( rhs.m_dispatcher, nullptr ) )
      {
      }

      OpticalFlowSessionNV & operator=( OpticalFlowSessionNV const & ) = delete;

      OpticalFlowSessionNV & operator=( OpticalFlowSessionNV && rhs ) VULKAN_HPP_NOEXCEPT
      {
        if ( this != &rhs )
        {
          std::swap( m_device, rhs.m_device );
          std::swap( m_opticalFlowSessionNV, rhs.m_opticalFlowSessionNV );
          std::swap( m_allocator, rhs.m_allocator );
          std::swap( m_dispatcher, rhs.m_dispatcher );
        }
        return *this;
      }

      VULKAN_HPP_NAMESPACE::OpticalFlowSessionNV const & operator*() const & VULKAN_HPP_NOEXCEPT
      {
        return m_opticalFlowSessionNV;
      }

      VULKAN_HPP_NAMESPACE::OpticalFlowSessionNV const && operator*() const && VULKAN_HPP_NOEXCEPT
      {
        return std::move( m_opticalFlowSessionNV );
      }

      operator VULKAN_HPP_NAMESPACE::OpticalFlowSessionNV() const VULKAN_HPP_NOEXCEPT
      {
        return m_opticalFlowSessionNV;
      }

      void clear() VULKAN_HPP_NOEXCEPT
      {
        if ( m_opticalFlowSessionNV )
        {
          getDispatcher()->vkDestroyOpticalFlowSessionNV( static_cast<VkDevice>( m_device ),
                                                          static_cast<VkOpticalFlowSessionNV>( m_opticalFlowSessionNV ),
                                                          reinterpret_cast<const VkAllocationCallbacks *>( m_allocator ) );
        }
        m_device               = nullptr;
        m_opticalFlowSessionNV = nullptr;
        m_allocator            = nullptr;
        m_dispatcher           = nullptr;
      }

      VULKAN_HPP_NAMESPACE::OpticalFlowSessionNV release()
      {
        m_device     = nullptr;
        m_allocator  = nullptr;
        m_dispatcher = nullptr;
        return exchange( m_opticalFlowSessionNV, nullptr );
      }

      VULKAN_HPP_NAMESPACE::Device getDevice() const
      {
        return m_device;
      }

      detail::DeviceDispatcher const * getDispatcher() const
      {
        VULKAN_HPP_ASSERT( m_dispatcher->getVkHeaderVersion() == VK_HEADER_VERSION );
        return m_dispatcher;
      }

      void swap( OpticalFlowSessionNV & rhs ) VULKAN_HPP_NOEXCEPT
      {
        std::swap( m_device, rhs.m_device );
        std::swap( m_opticalFlowSessionNV, rhs.m_opticalFlowSessionNV );
        std::swap( m_allocator, rhs.m_allocator );
        std::swap( m_dispatcher, rhs.m_dispatcher );
      }

      //=== VK_NV_optical_flow ===

      // wrapper function for command vkBindOpticalFlowSessionImageNV, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkBindOpticalFlowSessionImageNV.html
      typename ResultValueType<void>::type
        bindImage( OpticalFlowSessionBindingPointNV bindingPoint, VULKAN_HPP_NAMESPACE::ImageView view, ImageLayout layout ) const;

    private:
      VULKAN_HPP_NAMESPACE::Device               m_device               = {};
      VULKAN_HPP_NAMESPACE::OpticalFlowSessionNV m_opticalFlowSessionNV = {};
      const AllocationCallbacks *                m_allocator            = {};
      detail::DeviceDispatcher const *           m_dispatcher           = nullptr;
    };

    template <>
    struct isVulkanRAIIHandleType<OpticalFlowSessionNV>
    {
      static VULKAN_HPP_CONST_OR_CONSTEXPR bool value = true;
    };

    // wrapper class for handle VkPerformanceConfigurationINTEL, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/VkPerformanceConfigurationINTEL.html
    class PerformanceConfigurationINTEL
    {
    public:
      using CType   = VkPerformanceConfigurationINTEL;
      using CppType = VULKAN_HPP_NAMESPACE::PerformanceConfigurationINTEL;

      static VULKAN_HPP_CONST_OR_CONSTEXPR ObjectType               objectType            = ObjectType::ePerformanceConfigurationINTEL;
      static VULKAN_HPP_CONST_OR_CONSTEXPR DebugReportObjectTypeEXT debugReportObjectType = DebugReportObjectTypeEXT::eUnknown;

    public:
#  if !defined( VULKAN_HPP_NO_EXCEPTIONS )
      PerformanceConfigurationINTEL( Device const & device, PerformanceConfigurationAcquireInfoINTEL const & acquireInfo )
      {
        *this = device.acquirePerformanceConfigurationINTEL( acquireInfo );
      }
#  endif

      PerformanceConfigurationINTEL( Device const & device, VkPerformanceConfigurationINTEL configuration )
        : m_device( device ), m_performanceConfigurationINTEL( configuration ), m_dispatcher( device.getDispatcher() )
      {
      }

      PerformanceConfigurationINTEL( std::nullptr_t ) {}

      ~PerformanceConfigurationINTEL()
      {
        clear();
      }

      PerformanceConfigurationINTEL()                                        = delete;
      PerformanceConfigurationINTEL( PerformanceConfigurationINTEL const & ) = delete;

      PerformanceConfigurationINTEL( PerformanceConfigurationINTEL && rhs ) VULKAN_HPP_NOEXCEPT
        : m_device( exchange( rhs.m_device, {} ) )
        , m_performanceConfigurationINTEL( exchange( rhs.m_performanceConfigurationINTEL, {} ) )
        , m_dispatcher( exchange( rhs.m_dispatcher, nullptr ) )
      {
      }

      PerformanceConfigurationINTEL & operator=( PerformanceConfigurationINTEL const & ) = delete;

      PerformanceConfigurationINTEL & operator=( PerformanceConfigurationINTEL && rhs ) VULKAN_HPP_NOEXCEPT
      {
        if ( this != &rhs )
        {
          std::swap( m_device, rhs.m_device );
          std::swap( m_performanceConfigurationINTEL, rhs.m_performanceConfigurationINTEL );
          std::swap( m_dispatcher, rhs.m_dispatcher );
        }
        return *this;
      }

      VULKAN_HPP_NAMESPACE::PerformanceConfigurationINTEL const & operator*() const & VULKAN_HPP_NOEXCEPT
      {
        return m_performanceConfigurationINTEL;
      }

      VULKAN_HPP_NAMESPACE::PerformanceConfigurationINTEL const && operator*() const && VULKAN_HPP_NOEXCEPT
      {
        return std::move( m_performanceConfigurationINTEL );
      }

      operator VULKAN_HPP_NAMESPACE::PerformanceConfigurationINTEL() const VULKAN_HPP_NOEXCEPT
      {
        return m_performanceConfigurationINTEL;
      }

      void clear() VULKAN_HPP_NOEXCEPT
      {
        if ( m_performanceConfigurationINTEL )
        {
          getDispatcher()->vkReleasePerformanceConfigurationINTEL( static_cast<VkDevice>( m_device ),
                                                                   static_cast<VkPerformanceConfigurationINTEL>( m_performanceConfigurationINTEL ) );
        }
        m_device                        = nullptr;
        m_performanceConfigurationINTEL = nullptr;
        m_dispatcher                    = nullptr;
      }

      VULKAN_HPP_NAMESPACE::PerformanceConfigurationINTEL release()
      {
        m_device     = nullptr;
        m_dispatcher = nullptr;
        return exchange( m_performanceConfigurationINTEL, nullptr );
      }

      VULKAN_HPP_NAMESPACE::Device getDevice() const
      {
        return m_device;
      }

      detail::DeviceDispatcher const * getDispatcher() const
      {
        VULKAN_HPP_ASSERT( m_dispatcher->getVkHeaderVersion() == VK_HEADER_VERSION );
        return m_dispatcher;
      }

      void swap( PerformanceConfigurationINTEL & rhs ) VULKAN_HPP_NOEXCEPT
      {
        std::swap( m_device, rhs.m_device );
        std::swap( m_performanceConfigurationINTEL, rhs.m_performanceConfigurationINTEL );
        std::swap( m_dispatcher, rhs.m_dispatcher );
      }

    private:
      VULKAN_HPP_NAMESPACE::Device                        m_device                        = {};
      VULKAN_HPP_NAMESPACE::PerformanceConfigurationINTEL m_performanceConfigurationINTEL = {};
      detail::DeviceDispatcher const *                    m_dispatcher                    = nullptr;
    };

    template <>
    struct isVulkanRAIIHandleType<PerformanceConfigurationINTEL>
    {
      static VULKAN_HPP_CONST_OR_CONSTEXPR bool value = true;
    };

    // wrapper class for handle VkPipelineCache, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkPipelineCache.html
    class PipelineCache
    {
    public:
      using CType   = VkPipelineCache;
      using CppType = VULKAN_HPP_NAMESPACE::PipelineCache;

      static VULKAN_HPP_CONST_OR_CONSTEXPR ObjectType               objectType            = ObjectType::ePipelineCache;
      static VULKAN_HPP_CONST_OR_CONSTEXPR DebugReportObjectTypeEXT debugReportObjectType = DebugReportObjectTypeEXT::ePipelineCache;

    public:
#  if !defined( VULKAN_HPP_NO_EXCEPTIONS )
      PipelineCache( Device const & device, PipelineCacheCreateInfo const & createInfo, Optional<const AllocationCallbacks> allocator = nullptr )
      {
        *this = device.createPipelineCache( createInfo, allocator );
      }
#  endif

      PipelineCache( Device const & device, VkPipelineCache pipelineCache, Optional<const AllocationCallbacks> allocator = nullptr )
        : m_device( device )
        , m_pipelineCache( pipelineCache )
        , m_allocator( static_cast<const AllocationCallbacks *>( allocator ) )
        , m_dispatcher( device.getDispatcher() )
      {
      }

      PipelineCache( std::nullptr_t ) {}

      ~PipelineCache()
      {
        clear();
      }

      PipelineCache()                        = delete;
      PipelineCache( PipelineCache const & ) = delete;

      PipelineCache( PipelineCache && rhs ) VULKAN_HPP_NOEXCEPT
        : m_device( exchange( rhs.m_device, {} ) )
        , m_pipelineCache( exchange( rhs.m_pipelineCache, {} ) )
        , m_allocator( exchange( rhs.m_allocator, {} ) )
        , m_dispatcher( exchange( rhs.m_dispatcher, nullptr ) )
      {
      }

      PipelineCache & operator=( PipelineCache const & ) = delete;

      PipelineCache & operator=( PipelineCache && rhs ) VULKAN_HPP_NOEXCEPT
      {
        if ( this != &rhs )
        {
          std::swap( m_device, rhs.m_device );
          std::swap( m_pipelineCache, rhs.m_pipelineCache );
          std::swap( m_allocator, rhs.m_allocator );
          std::swap( m_dispatcher, rhs.m_dispatcher );
        }
        return *this;
      }

      VULKAN_HPP_NAMESPACE::PipelineCache const & operator*() const & VULKAN_HPP_NOEXCEPT
      {
        return m_pipelineCache;
      }

      VULKAN_HPP_NAMESPACE::PipelineCache const && operator*() const && VULKAN_HPP_NOEXCEPT
      {
        return std::move( m_pipelineCache );
      }

      operator VULKAN_HPP_NAMESPACE::PipelineCache() const VULKAN_HPP_NOEXCEPT
      {
        return m_pipelineCache;
      }

      void clear() VULKAN_HPP_NOEXCEPT
      {
        if ( m_pipelineCache )
        {
          getDispatcher()->vkDestroyPipelineCache( static_cast<VkDevice>( m_device ),
                                                   static_cast<VkPipelineCache>( m_pipelineCache ),
                                                   reinterpret_cast<const VkAllocationCallbacks *>( m_allocator ) );
        }
        m_device        = nullptr;
        m_pipelineCache = nullptr;
        m_allocator     = nullptr;
        m_dispatcher    = nullptr;
      }

      VULKAN_HPP_NAMESPACE::PipelineCache release()
      {
        m_device     = nullptr;
        m_allocator  = nullptr;
        m_dispatcher = nullptr;
        return exchange( m_pipelineCache, nullptr );
      }

      VULKAN_HPP_NAMESPACE::Device getDevice() const
      {
        return m_device;
      }

      detail::DeviceDispatcher const * getDispatcher() const
      {
        VULKAN_HPP_ASSERT( m_dispatcher->getVkHeaderVersion() == VK_HEADER_VERSION );
        return m_dispatcher;
      }

      void swap( PipelineCache & rhs ) VULKAN_HPP_NOEXCEPT
      {
        std::swap( m_device, rhs.m_device );
        std::swap( m_pipelineCache, rhs.m_pipelineCache );
        std::swap( m_allocator, rhs.m_allocator );
        std::swap( m_dispatcher, rhs.m_dispatcher );
      }

      //=== VK_VERSION_1_0 ===

      // wrapper function for command vkGetPipelineCacheData, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetPipelineCacheData.html
      VULKAN_HPP_NODISCARD typename ResultValueType<std::vector<uint8_t>>::type getData() const;

      // wrapper function for command vkMergePipelineCaches, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkMergePipelineCaches.html
      typename ResultValueType<void>::type merge( ArrayProxy<const VULKAN_HPP_NAMESPACE::PipelineCache> const & srcCaches ) const;

    private:
      VULKAN_HPP_NAMESPACE::Device        m_device        = {};
      VULKAN_HPP_NAMESPACE::PipelineCache m_pipelineCache = {};
      const AllocationCallbacks *         m_allocator     = {};
      detail::DeviceDispatcher const *    m_dispatcher    = nullptr;
    };

    template <>
    struct isVulkanRAIIHandleType<PipelineCache>
    {
      static VULKAN_HPP_CONST_OR_CONSTEXPR bool value = true;
    };

    // wrapper class for handle VkPipeline, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkPipeline.html
    class Pipeline
    {
    public:
      using CType   = VkPipeline;
      using CppType = VULKAN_HPP_NAMESPACE::Pipeline;

      static VULKAN_HPP_CONST_OR_CONSTEXPR ObjectType               objectType            = ObjectType::ePipeline;
      static VULKAN_HPP_CONST_OR_CONSTEXPR DebugReportObjectTypeEXT debugReportObjectType = DebugReportObjectTypeEXT::ePipeline;

    public:
#  if !defined( VULKAN_HPP_NO_EXCEPTIONS )
      Pipeline( Device const &                        device,
                Optional<const PipelineCache> const & pipelineCache,
                ComputePipelineCreateInfo const &     createInfo,
                Optional<const AllocationCallbacks>   allocator = nullptr )
      {
        *this = device.createComputePipeline( pipelineCache, createInfo, allocator );
      }
#  endif

#  if !defined( VULKAN_HPP_NO_EXCEPTIONS )
      Pipeline( Device const &                               device,
                Optional<const DeferredOperationKHR> const & deferredOperation,
                Optional<const PipelineCache> const &        pipelineCache,
                DataGraphPipelineCreateInfoARM const &       createInfo,
                Optional<const AllocationCallbacks>          allocator = nullptr )
      {
        *this = device.createDataGraphPipelineARM( deferredOperation, pipelineCache, createInfo, allocator );
      }
#  endif

#  if !defined( VULKAN_HPP_NO_EXCEPTIONS )
#    if defined( VK_ENABLE_BETA_EXTENSIONS )
      Pipeline( Device const &                               device,
                Optional<const PipelineCache> const &        pipelineCache,
                ExecutionGraphPipelineCreateInfoAMDX const & createInfo,
                Optional<const AllocationCallbacks>          allocator = nullptr )
      {
        *this = device.createExecutionGraphPipelineAMDX( pipelineCache, createInfo, allocator );
      }
#    endif /*VK_ENABLE_BETA_EXTENSIONS*/
#  endif

#  if !defined( VULKAN_HPP_NO_EXCEPTIONS )
      Pipeline( Device const &                        device,
                Optional<const PipelineCache> const & pipelineCache,
                GraphicsPipelineCreateInfo const &    createInfo,
                Optional<const AllocationCallbacks>   allocator = nullptr )
      {
        *this = device.createGraphicsPipeline( pipelineCache, createInfo, allocator );
      }
#  endif

#  if !defined( VULKAN_HPP_NO_EXCEPTIONS )
      Pipeline( Device const &                               device,
                Optional<const DeferredOperationKHR> const & deferredOperation,
                Optional<const PipelineCache> const &        pipelineCache,
                RayTracingPipelineCreateInfoKHR const &      createInfo,
                Optional<const AllocationCallbacks>          allocator = nullptr )
      {
        *this = device.createRayTracingPipelineKHR( deferredOperation, pipelineCache, createInfo, allocator );
      }
#  endif

#  if !defined( VULKAN_HPP_NO_EXCEPTIONS )
      Pipeline( Device const &                         device,
                Optional<const PipelineCache> const &  pipelineCache,
                RayTracingPipelineCreateInfoNV const & createInfo,
                Optional<const AllocationCallbacks>    allocator = nullptr )
      {
        *this = device.createRayTracingPipelineNV( pipelineCache, createInfo, allocator );
      }
#  endif

      Pipeline( Device const & device, VkPipeline pipeline, Optional<const AllocationCallbacks> allocator = nullptr, Result successCode = Result::eSuccess )
        : m_device( device )
        , m_pipeline( pipeline )
        , m_allocator( static_cast<const AllocationCallbacks *>( allocator ) )
        , m_constructorSuccessCode( successCode )
        , m_dispatcher( device.getDispatcher() )
      {
      }

      Pipeline( std::nullptr_t ) {}

      ~Pipeline()
      {
        clear();
      }

      Pipeline()                   = delete;
      Pipeline( Pipeline const & ) = delete;

      Pipeline( Pipeline && rhs ) VULKAN_HPP_NOEXCEPT
        : m_device( exchange( rhs.m_device, {} ) )
        , m_pipeline( exchange( rhs.m_pipeline, {} ) )
        , m_allocator( exchange( rhs.m_allocator, {} ) )
        , m_constructorSuccessCode( exchange( rhs.m_constructorSuccessCode, {} ) )
        , m_dispatcher( exchange( rhs.m_dispatcher, nullptr ) )
      {
      }

      Pipeline & operator=( Pipeline const & ) = delete;

      Pipeline & operator=( Pipeline && rhs ) VULKAN_HPP_NOEXCEPT
      {
        if ( this != &rhs )
        {
          std::swap( m_device, rhs.m_device );
          std::swap( m_pipeline, rhs.m_pipeline );
          std::swap( m_allocator, rhs.m_allocator );
          std::swap( m_constructorSuccessCode, rhs.m_constructorSuccessCode );
          std::swap( m_dispatcher, rhs.m_dispatcher );
        }
        return *this;
      }

      VULKAN_HPP_NAMESPACE::Pipeline const & operator*() const & VULKAN_HPP_NOEXCEPT
      {
        return m_pipeline;
      }

      VULKAN_HPP_NAMESPACE::Pipeline const && operator*() const && VULKAN_HPP_NOEXCEPT
      {
        return std::move( m_pipeline );
      }

      operator VULKAN_HPP_NAMESPACE::Pipeline() const VULKAN_HPP_NOEXCEPT
      {
        return m_pipeline;
      }

      void clear() VULKAN_HPP_NOEXCEPT
      {
        if ( m_pipeline )
        {
          getDispatcher()->vkDestroyPipeline(
            static_cast<VkDevice>( m_device ), static_cast<VkPipeline>( m_pipeline ), reinterpret_cast<const VkAllocationCallbacks *>( m_allocator ) );
        }
        m_device                 = nullptr;
        m_pipeline               = nullptr;
        m_allocator              = nullptr;
        m_constructorSuccessCode = Result::eErrorUnknown;
        m_dispatcher             = nullptr;
      }

      VULKAN_HPP_NAMESPACE::Pipeline release()
      {
        m_device                 = nullptr;
        m_allocator              = nullptr;
        m_constructorSuccessCode = Result::eErrorUnknown;
        m_dispatcher             = nullptr;
        return exchange( m_pipeline, nullptr );
      }

      Result getConstructorSuccessCode() const
      {
        return m_constructorSuccessCode;
      }

      VULKAN_HPP_NAMESPACE::Device getDevice() const
      {
        return m_device;
      }

      detail::DeviceDispatcher const * getDispatcher() const
      {
        VULKAN_HPP_ASSERT( m_dispatcher->getVkHeaderVersion() == VK_HEADER_VERSION );
        return m_dispatcher;
      }

      void swap( Pipeline & rhs ) VULKAN_HPP_NOEXCEPT
      {
        std::swap( m_device, rhs.m_device );
        std::swap( m_pipeline, rhs.m_pipeline );
        std::swap( m_allocator, rhs.m_allocator );
        std::swap( m_constructorSuccessCode, rhs.m_constructorSuccessCode );
        std::swap( m_dispatcher, rhs.m_dispatcher );
      }

      //=== VK_AMD_shader_info ===

      // wrapper function for command vkGetShaderInfoAMD, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetShaderInfoAMD.html
      VULKAN_HPP_NODISCARD typename ResultValueType<std::vector<uint8_t>>::type getShaderInfoAMD( ShaderStageFlagBits shaderStage,
                                                                                                  ShaderInfoTypeAMD   infoType ) const;

#  if defined( VK_ENABLE_BETA_EXTENSIONS )
      //=== VK_AMDX_shader_enqueue ===

      // wrapper function for command vkGetExecutionGraphPipelineScratchSizeAMDX, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetExecutionGraphPipelineScratchSizeAMDX.html
      VULKAN_HPP_NODISCARD typename ResultValueType<ExecutionGraphPipelineScratchSizeAMDX>::type getExecutionGraphScratchSizeAMDX() const;

      // wrapper function for command vkGetExecutionGraphPipelineNodeIndexAMDX, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetExecutionGraphPipelineNodeIndexAMDX.html
      VULKAN_HPP_NODISCARD typename ResultValueType<uint32_t>::type
        getExecutionGraphNodeIndexAMDX( const PipelineShaderStageNodeCreateInfoAMDX & nodeInfo ) const;
#  endif /*VK_ENABLE_BETA_EXTENSIONS*/

      //=== VK_KHR_ray_tracing_pipeline ===

      // wrapper function for command vkGetRayTracingShaderGroupHandlesKHR, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetRayTracingShaderGroupHandlesKHR.html
      template <typename DataType>
      VULKAN_HPP_NODISCARD typename ResultValueType<std::vector<DataType>>::type
        getRayTracingShaderGroupHandlesKHR( uint32_t firstGroup, uint32_t groupCount, size_t dataSize ) const;

      // wrapper function for command vkGetRayTracingShaderGroupHandlesKHR, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetRayTracingShaderGroupHandlesKHR.html
      template <typename DataType>
      VULKAN_HPP_NODISCARD typename ResultValueType<DataType>::type getRayTracingShaderGroupHandleKHR( uint32_t firstGroup, uint32_t groupCount ) const;

      // wrapper function for command vkGetRayTracingCaptureReplayShaderGroupHandlesKHR, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetRayTracingCaptureReplayShaderGroupHandlesKHR.html
      template <typename DataType>
      VULKAN_HPP_NODISCARD typename ResultValueType<std::vector<DataType>>::type
        getRayTracingCaptureReplayShaderGroupHandlesKHR( uint32_t firstGroup, uint32_t groupCount, size_t dataSize ) const;

      // wrapper function for command vkGetRayTracingCaptureReplayShaderGroupHandlesKHR, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetRayTracingCaptureReplayShaderGroupHandlesKHR.html
      template <typename DataType>
      VULKAN_HPP_NODISCARD typename ResultValueType<DataType>::type getRayTracingCaptureReplayShaderGroupHandleKHR( uint32_t firstGroup,
                                                                                                                    uint32_t groupCount ) const;

      // wrapper function for command vkGetRayTracingShaderGroupStackSizeKHR, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetRayTracingShaderGroupStackSizeKHR.html
      VULKAN_HPP_NODISCARD DeviceSize getRayTracingShaderGroupStackSizeKHR( uint32_t group, ShaderGroupShaderKHR groupShader ) const VULKAN_HPP_NOEXCEPT;

      //=== VK_NV_ray_tracing ===

      // wrapper function for command vkGetRayTracingShaderGroupHandlesNV, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetRayTracingShaderGroupHandlesNV.html
      template <typename DataType>
      VULKAN_HPP_NODISCARD typename ResultValueType<std::vector<DataType>>::type
        getRayTracingShaderGroupHandlesNV( uint32_t firstGroup, uint32_t groupCount, size_t dataSize ) const;

      // wrapper function for command vkGetRayTracingShaderGroupHandlesNV, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetRayTracingShaderGroupHandlesNV.html
      template <typename DataType>
      VULKAN_HPP_NODISCARD typename ResultValueType<DataType>::type getRayTracingShaderGroupHandleNV( uint32_t firstGroup, uint32_t groupCount ) const;

      // wrapper function for command vkCompileDeferredNV, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCompileDeferredNV.html
      typename ResultValueType<void>::type compileDeferredNV( uint32_t shader ) const;

    private:
      VULKAN_HPP_NAMESPACE::Device     m_device                 = {};
      VULKAN_HPP_NAMESPACE::Pipeline   m_pipeline               = {};
      const AllocationCallbacks *      m_allocator              = {};
      Result                           m_constructorSuccessCode = Result::eErrorUnknown;
      detail::DeviceDispatcher const * m_dispatcher             = nullptr;
    };

    template <>
    struct isVulkanRAIIHandleType<Pipeline>
    {
      static VULKAN_HPP_CONST_OR_CONSTEXPR bool value = true;
    };

    class Pipelines : public std::vector<Pipeline>
    {
    public:
#  if !defined( VULKAN_HPP_NO_EXCEPTIONS )
      Pipelines( Device const &                                device,
                 Optional<const PipelineCache> const &         pipelineCache,
                 ArrayProxy<ComputePipelineCreateInfo> const & createInfos,
                 Optional<const AllocationCallbacks>           allocator = nullptr )
      {
        *this = device.createComputePipelines( pipelineCache, createInfos, allocator );
      }
#  endif

#  if !defined( VULKAN_HPP_NO_EXCEPTIONS )
      Pipelines( Device const &                                     device,
                 Optional<const DeferredOperationKHR> const &       deferredOperation,
                 Optional<const PipelineCache> const &              pipelineCache,
                 ArrayProxy<DataGraphPipelineCreateInfoARM> const & createInfos,
                 Optional<const AllocationCallbacks>                allocator = nullptr )
      {
        *this = device.createDataGraphPipelinesARM( deferredOperation, pipelineCache, createInfos, allocator );
      }
#  endif

#  if !defined( VULKAN_HPP_NO_EXCEPTIONS )
#    if defined( VK_ENABLE_BETA_EXTENSIONS )
      Pipelines( Device const &                                           device,
                 Optional<const PipelineCache> const &                    pipelineCache,
                 ArrayProxy<ExecutionGraphPipelineCreateInfoAMDX> const & createInfos,
                 Optional<const AllocationCallbacks>                      allocator = nullptr )
      {
        *this = device.createExecutionGraphPipelinesAMDX( pipelineCache, createInfos, allocator );
      }
#    endif /*VK_ENABLE_BETA_EXTENSIONS*/
#  endif

#  if !defined( VULKAN_HPP_NO_EXCEPTIONS )
      Pipelines( Device const &                                 device,
                 Optional<const PipelineCache> const &          pipelineCache,
                 ArrayProxy<GraphicsPipelineCreateInfo> const & createInfos,
                 Optional<const AllocationCallbacks>            allocator = nullptr )
      {
        *this = device.createGraphicsPipelines( pipelineCache, createInfos, allocator );
      }
#  endif

#  if !defined( VULKAN_HPP_NO_EXCEPTIONS )
      Pipelines( Device const &                                      device,
                 Optional<const DeferredOperationKHR> const &        deferredOperation,
                 Optional<const PipelineCache> const &               pipelineCache,
                 ArrayProxy<RayTracingPipelineCreateInfoKHR> const & createInfos,
                 Optional<const AllocationCallbacks>                 allocator = nullptr )
      {
        *this = device.createRayTracingPipelinesKHR( deferredOperation, pipelineCache, createInfos, allocator );
      }
#  endif

#  if !defined( VULKAN_HPP_NO_EXCEPTIONS )
      Pipelines( Device const &                                     device,
                 Optional<const PipelineCache> const &              pipelineCache,
                 ArrayProxy<RayTracingPipelineCreateInfoNV> const & createInfos,
                 Optional<const AllocationCallbacks>                allocator = nullptr )
      {
        *this = device.createRayTracingPipelinesNV( pipelineCache, createInfos, allocator );
      }
#  endif

      Pipelines( std::nullptr_t ) {}

      Pipelines()                                = delete;
      Pipelines( Pipelines const & )             = delete;
      Pipelines( Pipelines && rhs )              = default;
      Pipelines & operator=( Pipelines const & ) = delete;
      Pipelines & operator=( Pipelines && rhs )  = default;

    private:
      Pipelines( std::vector<Pipeline> && rhs )
      {
        std::swap( *this, rhs );
      }
    };

    // wrapper class for handle VkPipelineBinaryKHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkPipelineBinaryKHR.html
    class PipelineBinaryKHR
    {
    public:
      using CType   = VkPipelineBinaryKHR;
      using CppType = VULKAN_HPP_NAMESPACE::PipelineBinaryKHR;

      static VULKAN_HPP_CONST_OR_CONSTEXPR ObjectType               objectType            = ObjectType::ePipelineBinaryKHR;
      static VULKAN_HPP_CONST_OR_CONSTEXPR DebugReportObjectTypeEXT debugReportObjectType = DebugReportObjectTypeEXT::eUnknown;

    public:
      PipelineBinaryKHR( Device const &                      device,
                         VkPipelineBinaryKHR                 pipelineBinary,
                         Optional<const AllocationCallbacks> allocator   = nullptr,
                         Result                              successCode = Result::eSuccess )
        : m_device( device )
        , m_pipelineBinaryKHR( pipelineBinary )
        , m_allocator( static_cast<const AllocationCallbacks *>( allocator ) )
        , m_constructorSuccessCode( successCode )
        , m_dispatcher( device.getDispatcher() )
      {
      }

      PipelineBinaryKHR( std::nullptr_t ) {}

      ~PipelineBinaryKHR()
      {
        clear();
      }

      PipelineBinaryKHR()                            = delete;
      PipelineBinaryKHR( PipelineBinaryKHR const & ) = delete;

      PipelineBinaryKHR( PipelineBinaryKHR && rhs ) VULKAN_HPP_NOEXCEPT
        : m_device( exchange( rhs.m_device, {} ) )
        , m_pipelineBinaryKHR( exchange( rhs.m_pipelineBinaryKHR, {} ) )
        , m_allocator( exchange( rhs.m_allocator, {} ) )
        , m_constructorSuccessCode( exchange( rhs.m_constructorSuccessCode, {} ) )
        , m_dispatcher( exchange( rhs.m_dispatcher, nullptr ) )
      {
      }

      PipelineBinaryKHR & operator=( PipelineBinaryKHR const & ) = delete;

      PipelineBinaryKHR & operator=( PipelineBinaryKHR && rhs ) VULKAN_HPP_NOEXCEPT
      {
        if ( this != &rhs )
        {
          std::swap( m_device, rhs.m_device );
          std::swap( m_pipelineBinaryKHR, rhs.m_pipelineBinaryKHR );
          std::swap( m_allocator, rhs.m_allocator );
          std::swap( m_constructorSuccessCode, rhs.m_constructorSuccessCode );
          std::swap( m_dispatcher, rhs.m_dispatcher );
        }
        return *this;
      }

      VULKAN_HPP_NAMESPACE::PipelineBinaryKHR const & operator*() const & VULKAN_HPP_NOEXCEPT
      {
        return m_pipelineBinaryKHR;
      }

      VULKAN_HPP_NAMESPACE::PipelineBinaryKHR const && operator*() const && VULKAN_HPP_NOEXCEPT
      {
        return std::move( m_pipelineBinaryKHR );
      }

      operator VULKAN_HPP_NAMESPACE::PipelineBinaryKHR() const VULKAN_HPP_NOEXCEPT
      {
        return m_pipelineBinaryKHR;
      }

      void clear() VULKAN_HPP_NOEXCEPT
      {
        if ( m_pipelineBinaryKHR )
        {
          getDispatcher()->vkDestroyPipelineBinaryKHR( static_cast<VkDevice>( m_device ),
                                                       static_cast<VkPipelineBinaryKHR>( m_pipelineBinaryKHR ),
                                                       reinterpret_cast<const VkAllocationCallbacks *>( m_allocator ) );
        }
        m_device                 = nullptr;
        m_pipelineBinaryKHR      = nullptr;
        m_allocator              = nullptr;
        m_constructorSuccessCode = Result::eErrorUnknown;
        m_dispatcher             = nullptr;
      }

      VULKAN_HPP_NAMESPACE::PipelineBinaryKHR release()
      {
        m_device                 = nullptr;
        m_allocator              = nullptr;
        m_constructorSuccessCode = Result::eErrorUnknown;
        m_dispatcher             = nullptr;
        return exchange( m_pipelineBinaryKHR, nullptr );
      }

      Result getConstructorSuccessCode() const
      {
        return m_constructorSuccessCode;
      }

      VULKAN_HPP_NAMESPACE::Device getDevice() const
      {
        return m_device;
      }

      detail::DeviceDispatcher const * getDispatcher() const
      {
        VULKAN_HPP_ASSERT( m_dispatcher->getVkHeaderVersion() == VK_HEADER_VERSION );
        return m_dispatcher;
      }

      void swap( PipelineBinaryKHR & rhs ) VULKAN_HPP_NOEXCEPT
      {
        std::swap( m_device, rhs.m_device );
        std::swap( m_pipelineBinaryKHR, rhs.m_pipelineBinaryKHR );
        std::swap( m_allocator, rhs.m_allocator );
        std::swap( m_constructorSuccessCode, rhs.m_constructorSuccessCode );
        std::swap( m_dispatcher, rhs.m_dispatcher );
      }

    private:
      VULKAN_HPP_NAMESPACE::Device            m_device                 = {};
      VULKAN_HPP_NAMESPACE::PipelineBinaryKHR m_pipelineBinaryKHR      = {};
      const AllocationCallbacks *             m_allocator              = {};
      Result                                  m_constructorSuccessCode = Result::eErrorUnknown;
      detail::DeviceDispatcher const *        m_dispatcher             = nullptr;
    };

    template <>
    struct isVulkanRAIIHandleType<PipelineBinaryKHR>
    {
      static VULKAN_HPP_CONST_OR_CONSTEXPR bool value = true;
    };

    class PipelineBinaryKHRs : public std::vector<PipelineBinaryKHR>
    {
    public:
#  if !defined( VULKAN_HPP_NO_EXCEPTIONS )
      PipelineBinaryKHRs( Device const & device, PipelineBinaryCreateInfoKHR const & createInfo, Optional<const AllocationCallbacks> allocator = nullptr )
      {
        *this = device.createPipelineBinariesKHR( createInfo, allocator );
      }
#  endif

      PipelineBinaryKHRs( std::nullptr_t ) {}

      PipelineBinaryKHRs()                                         = delete;
      PipelineBinaryKHRs( PipelineBinaryKHRs const & )             = delete;
      PipelineBinaryKHRs( PipelineBinaryKHRs && rhs )              = default;
      PipelineBinaryKHRs & operator=( PipelineBinaryKHRs const & ) = delete;
      PipelineBinaryKHRs & operator=( PipelineBinaryKHRs && rhs )  = default;

    private:
      PipelineBinaryKHRs( std::vector<PipelineBinaryKHR> && rhs )
      {
        std::swap( *this, rhs );
      }
    };

    // wrapper class for handle VkPipelineLayout, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkPipelineLayout.html
    class PipelineLayout
    {
    public:
      using CType   = VkPipelineLayout;
      using CppType = VULKAN_HPP_NAMESPACE::PipelineLayout;

      static VULKAN_HPP_CONST_OR_CONSTEXPR ObjectType               objectType            = ObjectType::ePipelineLayout;
      static VULKAN_HPP_CONST_OR_CONSTEXPR DebugReportObjectTypeEXT debugReportObjectType = DebugReportObjectTypeEXT::ePipelineLayout;

    public:
#  if !defined( VULKAN_HPP_NO_EXCEPTIONS )
      PipelineLayout( Device const & device, PipelineLayoutCreateInfo const & createInfo, Optional<const AllocationCallbacks> allocator = nullptr )
      {
        *this = device.createPipelineLayout( createInfo, allocator );
      }
#  endif

      PipelineLayout( Device const & device, VkPipelineLayout pipelineLayout, Optional<const AllocationCallbacks> allocator = nullptr )
        : m_device( device )
        , m_pipelineLayout( pipelineLayout )
        , m_allocator( static_cast<const AllocationCallbacks *>( allocator ) )
        , m_dispatcher( device.getDispatcher() )
      {
      }

      PipelineLayout( std::nullptr_t ) {}

      ~PipelineLayout()
      {
        clear();
      }

      PipelineLayout()                         = delete;
      PipelineLayout( PipelineLayout const & ) = delete;

      PipelineLayout( PipelineLayout && rhs ) VULKAN_HPP_NOEXCEPT
        : m_device( exchange( rhs.m_device, {} ) )
        , m_pipelineLayout( exchange( rhs.m_pipelineLayout, {} ) )
        , m_allocator( exchange( rhs.m_allocator, {} ) )
        , m_dispatcher( exchange( rhs.m_dispatcher, nullptr ) )
      {
      }

      PipelineLayout & operator=( PipelineLayout const & ) = delete;

      PipelineLayout & operator=( PipelineLayout && rhs ) VULKAN_HPP_NOEXCEPT
      {
        if ( this != &rhs )
        {
          std::swap( m_device, rhs.m_device );
          std::swap( m_pipelineLayout, rhs.m_pipelineLayout );
          std::swap( m_allocator, rhs.m_allocator );
          std::swap( m_dispatcher, rhs.m_dispatcher );
        }
        return *this;
      }

      VULKAN_HPP_NAMESPACE::PipelineLayout const & operator*() const & VULKAN_HPP_NOEXCEPT
      {
        return m_pipelineLayout;
      }

      VULKAN_HPP_NAMESPACE::PipelineLayout const && operator*() const && VULKAN_HPP_NOEXCEPT
      {
        return std::move( m_pipelineLayout );
      }

      operator VULKAN_HPP_NAMESPACE::PipelineLayout() const VULKAN_HPP_NOEXCEPT
      {
        return m_pipelineLayout;
      }

      void clear() VULKAN_HPP_NOEXCEPT
      {
        if ( m_pipelineLayout )
        {
          getDispatcher()->vkDestroyPipelineLayout( static_cast<VkDevice>( m_device ),
                                                    static_cast<VkPipelineLayout>( m_pipelineLayout ),
                                                    reinterpret_cast<const VkAllocationCallbacks *>( m_allocator ) );
        }
        m_device         = nullptr;
        m_pipelineLayout = nullptr;
        m_allocator      = nullptr;
        m_dispatcher     = nullptr;
      }

      VULKAN_HPP_NAMESPACE::PipelineLayout release()
      {
        m_device     = nullptr;
        m_allocator  = nullptr;
        m_dispatcher = nullptr;
        return exchange( m_pipelineLayout, nullptr );
      }

      VULKAN_HPP_NAMESPACE::Device getDevice() const
      {
        return m_device;
      }

      detail::DeviceDispatcher const * getDispatcher() const
      {
        VULKAN_HPP_ASSERT( m_dispatcher->getVkHeaderVersion() == VK_HEADER_VERSION );
        return m_dispatcher;
      }

      void swap( PipelineLayout & rhs ) VULKAN_HPP_NOEXCEPT
      {
        std::swap( m_device, rhs.m_device );
        std::swap( m_pipelineLayout, rhs.m_pipelineLayout );
        std::swap( m_allocator, rhs.m_allocator );
        std::swap( m_dispatcher, rhs.m_dispatcher );
      }

    private:
      VULKAN_HPP_NAMESPACE::Device         m_device         = {};
      VULKAN_HPP_NAMESPACE::PipelineLayout m_pipelineLayout = {};
      const AllocationCallbacks *          m_allocator      = {};
      detail::DeviceDispatcher const *     m_dispatcher     = nullptr;
    };

    template <>
    struct isVulkanRAIIHandleType<PipelineLayout>
    {
      static VULKAN_HPP_CONST_OR_CONSTEXPR bool value = true;
    };

    // wrapper class for handle VkPrivateDataSlot, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkPrivateDataSlot.html
    class PrivateDataSlot
    {
    public:
      using CType   = VkPrivateDataSlot;
      using CppType = VULKAN_HPP_NAMESPACE::PrivateDataSlot;

      static VULKAN_HPP_CONST_OR_CONSTEXPR ObjectType               objectType            = ObjectType::ePrivateDataSlot;
      static VULKAN_HPP_CONST_OR_CONSTEXPR DebugReportObjectTypeEXT debugReportObjectType = DebugReportObjectTypeEXT::eUnknown;

    public:
#  if !defined( VULKAN_HPP_NO_EXCEPTIONS )
      PrivateDataSlot( Device const & device, PrivateDataSlotCreateInfo const & createInfo, Optional<const AllocationCallbacks> allocator = nullptr )
      {
        *this = device.createPrivateDataSlot( createInfo, allocator );
      }
#  endif

      PrivateDataSlot( Device const & device, VkPrivateDataSlot privateDataSlot, Optional<const AllocationCallbacks> allocator = nullptr )
        : m_device( device )
        , m_privateDataSlot( privateDataSlot )
        , m_allocator( static_cast<const AllocationCallbacks *>( allocator ) )
        , m_dispatcher( device.getDispatcher() )
      {
      }

      PrivateDataSlot( std::nullptr_t ) {}

      ~PrivateDataSlot()
      {
        clear();
      }

      PrivateDataSlot()                          = delete;
      PrivateDataSlot( PrivateDataSlot const & ) = delete;

      PrivateDataSlot( PrivateDataSlot && rhs ) VULKAN_HPP_NOEXCEPT
        : m_device( exchange( rhs.m_device, {} ) )
        , m_privateDataSlot( exchange( rhs.m_privateDataSlot, {} ) )
        , m_allocator( exchange( rhs.m_allocator, {} ) )
        , m_dispatcher( exchange( rhs.m_dispatcher, nullptr ) )
      {
      }

      PrivateDataSlot & operator=( PrivateDataSlot const & ) = delete;

      PrivateDataSlot & operator=( PrivateDataSlot && rhs ) VULKAN_HPP_NOEXCEPT
      {
        if ( this != &rhs )
        {
          std::swap( m_device, rhs.m_device );
          std::swap( m_privateDataSlot, rhs.m_privateDataSlot );
          std::swap( m_allocator, rhs.m_allocator );
          std::swap( m_dispatcher, rhs.m_dispatcher );
        }
        return *this;
      }

      VULKAN_HPP_NAMESPACE::PrivateDataSlot const & operator*() const & VULKAN_HPP_NOEXCEPT
      {
        return m_privateDataSlot;
      }

      VULKAN_HPP_NAMESPACE::PrivateDataSlot const && operator*() const && VULKAN_HPP_NOEXCEPT
      {
        return std::move( m_privateDataSlot );
      }

      operator VULKAN_HPP_NAMESPACE::PrivateDataSlot() const VULKAN_HPP_NOEXCEPT
      {
        return m_privateDataSlot;
      }

      void clear() VULKAN_HPP_NOEXCEPT
      {
        if ( m_privateDataSlot )
        {
          getDispatcher()->vkDestroyPrivateDataSlot( static_cast<VkDevice>( m_device ),
                                                     static_cast<VkPrivateDataSlot>( m_privateDataSlot ),
                                                     reinterpret_cast<const VkAllocationCallbacks *>( m_allocator ) );
        }
        m_device          = nullptr;
        m_privateDataSlot = nullptr;
        m_allocator       = nullptr;
        m_dispatcher      = nullptr;
      }

      VULKAN_HPP_NAMESPACE::PrivateDataSlot release()
      {
        m_device     = nullptr;
        m_allocator  = nullptr;
        m_dispatcher = nullptr;
        return exchange( m_privateDataSlot, nullptr );
      }

      VULKAN_HPP_NAMESPACE::Device getDevice() const
      {
        return m_device;
      }

      detail::DeviceDispatcher const * getDispatcher() const
      {
        VULKAN_HPP_ASSERT( m_dispatcher->getVkHeaderVersion() == VK_HEADER_VERSION );
        return m_dispatcher;
      }

      void swap( PrivateDataSlot & rhs ) VULKAN_HPP_NOEXCEPT
      {
        std::swap( m_device, rhs.m_device );
        std::swap( m_privateDataSlot, rhs.m_privateDataSlot );
        std::swap( m_allocator, rhs.m_allocator );
        std::swap( m_dispatcher, rhs.m_dispatcher );
      }

    private:
      VULKAN_HPP_NAMESPACE::Device          m_device          = {};
      VULKAN_HPP_NAMESPACE::PrivateDataSlot m_privateDataSlot = {};
      const AllocationCallbacks *           m_allocator       = {};
      detail::DeviceDispatcher const *      m_dispatcher      = nullptr;
    };

    template <>
    struct isVulkanRAIIHandleType<PrivateDataSlot>
    {
      static VULKAN_HPP_CONST_OR_CONSTEXPR bool value = true;
    };

    // wrapper class for handle VkQueryPool, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkQueryPool.html
    class QueryPool
    {
    public:
      using CType   = VkQueryPool;
      using CppType = VULKAN_HPP_NAMESPACE::QueryPool;

      static VULKAN_HPP_CONST_OR_CONSTEXPR ObjectType               objectType            = ObjectType::eQueryPool;
      static VULKAN_HPP_CONST_OR_CONSTEXPR DebugReportObjectTypeEXT debugReportObjectType = DebugReportObjectTypeEXT::eQueryPool;

    public:
#  if !defined( VULKAN_HPP_NO_EXCEPTIONS )
      QueryPool( Device const & device, QueryPoolCreateInfo const & createInfo, Optional<const AllocationCallbacks> allocator = nullptr )
      {
        *this = device.createQueryPool( createInfo, allocator );
      }
#  endif

      QueryPool( Device const & device, VkQueryPool queryPool, Optional<const AllocationCallbacks> allocator = nullptr )
        : m_device( device )
        , m_queryPool( queryPool )
        , m_allocator( static_cast<const AllocationCallbacks *>( allocator ) )
        , m_dispatcher( device.getDispatcher() )
      {
      }

      QueryPool( std::nullptr_t ) {}

      ~QueryPool()
      {
        clear();
      }

      QueryPool()                    = delete;
      QueryPool( QueryPool const & ) = delete;

      QueryPool( QueryPool && rhs ) VULKAN_HPP_NOEXCEPT
        : m_device( exchange( rhs.m_device, {} ) )
        , m_queryPool( exchange( rhs.m_queryPool, {} ) )
        , m_allocator( exchange( rhs.m_allocator, {} ) )
        , m_dispatcher( exchange( rhs.m_dispatcher, nullptr ) )
      {
      }

      QueryPool & operator=( QueryPool const & ) = delete;

      QueryPool & operator=( QueryPool && rhs ) VULKAN_HPP_NOEXCEPT
      {
        if ( this != &rhs )
        {
          std::swap( m_device, rhs.m_device );
          std::swap( m_queryPool, rhs.m_queryPool );
          std::swap( m_allocator, rhs.m_allocator );
          std::swap( m_dispatcher, rhs.m_dispatcher );
        }
        return *this;
      }

      VULKAN_HPP_NAMESPACE::QueryPool const & operator*() const & VULKAN_HPP_NOEXCEPT
      {
        return m_queryPool;
      }

      VULKAN_HPP_NAMESPACE::QueryPool const && operator*() const && VULKAN_HPP_NOEXCEPT
      {
        return std::move( m_queryPool );
      }

      operator VULKAN_HPP_NAMESPACE::QueryPool() const VULKAN_HPP_NOEXCEPT
      {
        return m_queryPool;
      }

      void clear() VULKAN_HPP_NOEXCEPT
      {
        if ( m_queryPool )
        {
          getDispatcher()->vkDestroyQueryPool(
            static_cast<VkDevice>( m_device ), static_cast<VkQueryPool>( m_queryPool ), reinterpret_cast<const VkAllocationCallbacks *>( m_allocator ) );
        }
        m_device     = nullptr;
        m_queryPool  = nullptr;
        m_allocator  = nullptr;
        m_dispatcher = nullptr;
      }

      VULKAN_HPP_NAMESPACE::QueryPool release()
      {
        m_device     = nullptr;
        m_allocator  = nullptr;
        m_dispatcher = nullptr;
        return exchange( m_queryPool, nullptr );
      }

      VULKAN_HPP_NAMESPACE::Device getDevice() const
      {
        return m_device;
      }

      detail::DeviceDispatcher const * getDispatcher() const
      {
        VULKAN_HPP_ASSERT( m_dispatcher->getVkHeaderVersion() == VK_HEADER_VERSION );
        return m_dispatcher;
      }

      void swap( QueryPool & rhs ) VULKAN_HPP_NOEXCEPT
      {
        std::swap( m_device, rhs.m_device );
        std::swap( m_queryPool, rhs.m_queryPool );
        std::swap( m_allocator, rhs.m_allocator );
        std::swap( m_dispatcher, rhs.m_dispatcher );
      }

      //=== VK_VERSION_1_0 ===

      // wrapper function for command vkGetQueryPoolResults, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetQueryPoolResults.html
      template <typename DataType>
      VULKAN_HPP_NODISCARD ResultValue<std::vector<DataType>> getResults(
        uint32_t firstQuery, uint32_t queryCount, size_t dataSize, DeviceSize stride, QueryResultFlags flags VULKAN_HPP_DEFAULT_ASSIGNMENT( {} ) ) const;

      // wrapper function for command vkGetQueryPoolResults, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetQueryPoolResults.html
      template <typename DataType>
      VULKAN_HPP_NODISCARD ResultValue<DataType>
        getResult( uint32_t firstQuery, uint32_t queryCount, DeviceSize stride, QueryResultFlags flags VULKAN_HPP_DEFAULT_ASSIGNMENT( {} ) ) const;

      //=== VK_VERSION_1_2 ===

      // wrapper function for command vkResetQueryPool, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkResetQueryPool.html
      void reset( uint32_t firstQuery, uint32_t queryCount ) const VULKAN_HPP_NOEXCEPT;

      //=== VK_EXT_host_query_reset ===

      // wrapper function for command vkResetQueryPoolEXT, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkResetQueryPoolEXT.html
      void resetEXT( uint32_t firstQuery, uint32_t queryCount ) const VULKAN_HPP_NOEXCEPT;

    private:
      VULKAN_HPP_NAMESPACE::Device     m_device     = {};
      VULKAN_HPP_NAMESPACE::QueryPool  m_queryPool  = {};
      const AllocationCallbacks *      m_allocator  = {};
      detail::DeviceDispatcher const * m_dispatcher = nullptr;
    };

    template <>
    struct isVulkanRAIIHandleType<QueryPool>
    {
      static VULKAN_HPP_CONST_OR_CONSTEXPR bool value = true;
    };

    // wrapper class for handle VkQueue, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkQueue.html
    class Queue
    {
    public:
      using CType   = VkQueue;
      using CppType = VULKAN_HPP_NAMESPACE::Queue;

      static VULKAN_HPP_CONST_OR_CONSTEXPR ObjectType               objectType            = ObjectType::eQueue;
      static VULKAN_HPP_CONST_OR_CONSTEXPR DebugReportObjectTypeEXT debugReportObjectType = DebugReportObjectTypeEXT::eQueue;

    public:
#  if !defined( VULKAN_HPP_NO_EXCEPTIONS )
      Queue( Device const & device, uint32_t queueFamilyIndex, uint32_t queueIndex )
      {
        *this = device.getQueue( queueFamilyIndex, queueIndex );
      }
#  endif

#  if !defined( VULKAN_HPP_NO_EXCEPTIONS )
      Queue( Device const & device, DeviceQueueInfo2 const & queueInfo )
      {
        *this = device.getQueue2( queueInfo );
      }
#  endif

      Queue( Device const & device, VkQueue queue ) : m_queue( queue ), m_dispatcher( device.getDispatcher() ) {}

      Queue( std::nullptr_t ) {}

      ~Queue()
      {
        clear();
      }

      Queue() = delete;

      Queue( Queue const & rhs ) : m_queue( rhs.m_queue ), m_dispatcher( rhs.m_dispatcher ) {}

      Queue( Queue && rhs ) VULKAN_HPP_NOEXCEPT
        : m_queue( exchange( rhs.m_queue, {} ) )
        , m_dispatcher( exchange( rhs.m_dispatcher, nullptr ) )
      {
      }

      Queue & operator=( Queue const & rhs )
      {
        m_queue      = rhs.m_queue;
        m_dispatcher = rhs.m_dispatcher;
        return *this;
      }

      Queue & operator=( Queue && rhs ) VULKAN_HPP_NOEXCEPT
      {
        if ( this != &rhs )
        {
          std::swap( m_queue, rhs.m_queue );
          std::swap( m_dispatcher, rhs.m_dispatcher );
        }
        return *this;
      }

      VULKAN_HPP_NAMESPACE::Queue const & operator*() const & VULKAN_HPP_NOEXCEPT
      {
        return m_queue;
      }

      VULKAN_HPP_NAMESPACE::Queue const && operator*() const && VULKAN_HPP_NOEXCEPT
      {
        return std::move( m_queue );
      }

      operator VULKAN_HPP_NAMESPACE::Queue() const VULKAN_HPP_NOEXCEPT
      {
        return m_queue;
      }

      void clear() VULKAN_HPP_NOEXCEPT
      {
        m_queue      = nullptr;
        m_dispatcher = nullptr;
      }

      VULKAN_HPP_NAMESPACE::Queue release()
      {
        m_dispatcher = nullptr;
        return exchange( m_queue, nullptr );
      }

      detail::DeviceDispatcher const * getDispatcher() const
      {
        VULKAN_HPP_ASSERT( m_dispatcher->getVkHeaderVersion() == VK_HEADER_VERSION );
        return m_dispatcher;
      }

      void swap( Queue & rhs ) VULKAN_HPP_NOEXCEPT
      {
        std::swap( m_queue, rhs.m_queue );
        std::swap( m_dispatcher, rhs.m_dispatcher );
      }

      //=== VK_VERSION_1_0 ===

      // wrapper function for command vkQueueSubmit, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkQueueSubmit.html
      typename ResultValueType<void>::type submit( ArrayProxy<const SubmitInfo> const & submits,
                                                   VULKAN_HPP_NAMESPACE::Fence fence    VULKAN_HPP_DEFAULT_ASSIGNMENT( {} ) ) const;

      // wrapper function for command vkQueueWaitIdle, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkQueueWaitIdle.html
      typename ResultValueType<void>::type waitIdle() const;

      // wrapper function for command vkQueueBindSparse, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkQueueBindSparse.html
      typename ResultValueType<void>::type bindSparse( ArrayProxy<const BindSparseInfo> const & bindInfo,
                                                       VULKAN_HPP_NAMESPACE::Fence fence        VULKAN_HPP_DEFAULT_ASSIGNMENT( {} ) ) const;

      //=== VK_VERSION_1_3 ===

      // wrapper function for command vkQueueSubmit2, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkQueueSubmit2.html
      typename ResultValueType<void>::type submit2( ArrayProxy<const SubmitInfo2> const & submits,
                                                    VULKAN_HPP_NAMESPACE::Fence fence     VULKAN_HPP_DEFAULT_ASSIGNMENT( {} ) ) const;

      //=== VK_KHR_swapchain ===

      // wrapper function for command vkQueuePresentKHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkQueuePresentKHR.html
      VULKAN_HPP_NODISCARD Result presentKHR( const PresentInfoKHR & presentInfo ) const;

      //=== VK_EXT_debug_utils ===

      // wrapper function for command vkQueueBeginDebugUtilsLabelEXT, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkQueueBeginDebugUtilsLabelEXT.html
      void beginDebugUtilsLabelEXT( const DebugUtilsLabelEXT & labelInfo ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkQueueEndDebugUtilsLabelEXT, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkQueueEndDebugUtilsLabelEXT.html
      void endDebugUtilsLabelEXT() const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkQueueInsertDebugUtilsLabelEXT, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkQueueInsertDebugUtilsLabelEXT.html
      void insertDebugUtilsLabelEXT( const DebugUtilsLabelEXT & labelInfo ) const VULKAN_HPP_NOEXCEPT;

      //=== VK_NV_device_diagnostic_checkpoints ===

      // wrapper function for command vkGetQueueCheckpointDataNV, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetQueueCheckpointDataNV.html
      VULKAN_HPP_NODISCARD std::vector<CheckpointDataNV> getCheckpointDataNV() const;

      // wrapper function for command vkGetQueueCheckpointData2NV, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetQueueCheckpointData2NV.html
      VULKAN_HPP_NODISCARD std::vector<CheckpointData2NV> getCheckpointData2NV() const;

      //=== VK_INTEL_performance_query ===

      // wrapper function for command vkQueueSetPerformanceConfigurationINTEL, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkQueueSetPerformanceConfigurationINTEL.html
      typename ResultValueType<void>::type setPerformanceConfigurationINTEL( VULKAN_HPP_NAMESPACE::PerformanceConfigurationINTEL configuration ) const;

      //=== VK_KHR_synchronization2 ===

      // wrapper function for command vkQueueSubmit2KHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkQueueSubmit2KHR.html
      typename ResultValueType<void>::type submit2KHR( ArrayProxy<const SubmitInfo2> const & submits,
                                                       VULKAN_HPP_NAMESPACE::Fence fence     VULKAN_HPP_DEFAULT_ASSIGNMENT( {} ) ) const;

      //=== VK_NV_low_latency2 ===

      // wrapper function for command vkQueueNotifyOutOfBandNV, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkQueueNotifyOutOfBandNV.html
      void notifyOutOfBandNV( const OutOfBandQueueTypeInfoNV & queueTypeInfo ) const VULKAN_HPP_NOEXCEPT;

#  if defined( VK_USE_PLATFORM_OHOS )
      //=== VK_OHOS_native_buffer ===

      // wrapper function for command vkQueueSignalReleaseImageOHOS, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkQueueSignalReleaseImageOHOS.html
      VULKAN_HPP_NODISCARD typename ResultValueType<int32_t>::type
        signalReleaseImageOHOS( ArrayProxy<const VULKAN_HPP_NAMESPACE::Semaphore> const & waitSemaphores, VULKAN_HPP_NAMESPACE::Image image ) const;
#  endif /*VK_USE_PLATFORM_OHOS*/

    private:
      VULKAN_HPP_NAMESPACE::Queue      m_queue      = {};
      detail::DeviceDispatcher const * m_dispatcher = nullptr;
    };

    template <>
    struct isVulkanRAIIHandleType<Queue>
    {
      static VULKAN_HPP_CONST_OR_CONSTEXPR bool value = true;
    };

    // wrapper class for handle VkRenderPass, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkRenderPass.html
    class RenderPass
    {
    public:
      using CType   = VkRenderPass;
      using CppType = VULKAN_HPP_NAMESPACE::RenderPass;

      static VULKAN_HPP_CONST_OR_CONSTEXPR ObjectType               objectType            = ObjectType::eRenderPass;
      static VULKAN_HPP_CONST_OR_CONSTEXPR DebugReportObjectTypeEXT debugReportObjectType = DebugReportObjectTypeEXT::eRenderPass;

    public:
#  if !defined( VULKAN_HPP_NO_EXCEPTIONS )
      RenderPass( Device const & device, RenderPassCreateInfo const & createInfo, Optional<const AllocationCallbacks> allocator = nullptr )
      {
        *this = device.createRenderPass( createInfo, allocator );
      }
#  endif

#  if !defined( VULKAN_HPP_NO_EXCEPTIONS )
      RenderPass( Device const & device, RenderPassCreateInfo2 const & createInfo, Optional<const AllocationCallbacks> allocator = nullptr )
      {
        *this = device.createRenderPass2( createInfo, allocator );
      }
#  endif

      RenderPass( Device const & device, VkRenderPass renderPass, Optional<const AllocationCallbacks> allocator = nullptr )
        : m_device( device )
        , m_renderPass( renderPass )
        , m_allocator( static_cast<const AllocationCallbacks *>( allocator ) )
        , m_dispatcher( device.getDispatcher() )
      {
      }

      RenderPass( std::nullptr_t ) {}

      ~RenderPass()
      {
        clear();
      }

      RenderPass()                     = delete;
      RenderPass( RenderPass const & ) = delete;

      RenderPass( RenderPass && rhs ) VULKAN_HPP_NOEXCEPT
        : m_device( exchange( rhs.m_device, {} ) )
        , m_renderPass( exchange( rhs.m_renderPass, {} ) )
        , m_allocator( exchange( rhs.m_allocator, {} ) )
        , m_dispatcher( exchange( rhs.m_dispatcher, nullptr ) )
      {
      }

      RenderPass & operator=( RenderPass const & ) = delete;

      RenderPass & operator=( RenderPass && rhs ) VULKAN_HPP_NOEXCEPT
      {
        if ( this != &rhs )
        {
          std::swap( m_device, rhs.m_device );
          std::swap( m_renderPass, rhs.m_renderPass );
          std::swap( m_allocator, rhs.m_allocator );
          std::swap( m_dispatcher, rhs.m_dispatcher );
        }
        return *this;
      }

      VULKAN_HPP_NAMESPACE::RenderPass const & operator*() const & VULKAN_HPP_NOEXCEPT
      {
        return m_renderPass;
      }

      VULKAN_HPP_NAMESPACE::RenderPass const && operator*() const && VULKAN_HPP_NOEXCEPT
      {
        return std::move( m_renderPass );
      }

      operator VULKAN_HPP_NAMESPACE::RenderPass() const VULKAN_HPP_NOEXCEPT
      {
        return m_renderPass;
      }

      void clear() VULKAN_HPP_NOEXCEPT
      {
        if ( m_renderPass )
        {
          getDispatcher()->vkDestroyRenderPass(
            static_cast<VkDevice>( m_device ), static_cast<VkRenderPass>( m_renderPass ), reinterpret_cast<const VkAllocationCallbacks *>( m_allocator ) );
        }
        m_device     = nullptr;
        m_renderPass = nullptr;
        m_allocator  = nullptr;
        m_dispatcher = nullptr;
      }

      VULKAN_HPP_NAMESPACE::RenderPass release()
      {
        m_device     = nullptr;
        m_allocator  = nullptr;
        m_dispatcher = nullptr;
        return exchange( m_renderPass, nullptr );
      }

      VULKAN_HPP_NAMESPACE::Device getDevice() const
      {
        return m_device;
      }

      detail::DeviceDispatcher const * getDispatcher() const
      {
        VULKAN_HPP_ASSERT( m_dispatcher->getVkHeaderVersion() == VK_HEADER_VERSION );
        return m_dispatcher;
      }

      void swap( RenderPass & rhs ) VULKAN_HPP_NOEXCEPT
      {
        std::swap( m_device, rhs.m_device );
        std::swap( m_renderPass, rhs.m_renderPass );
        std::swap( m_allocator, rhs.m_allocator );
        std::swap( m_dispatcher, rhs.m_dispatcher );
      }

      //=== VK_VERSION_1_0 ===

      // wrapper function for command vkGetRenderAreaGranularity, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetRenderAreaGranularity.html
      VULKAN_HPP_NODISCARD Extent2D getRenderAreaGranularity() const VULKAN_HPP_NOEXCEPT;

      //=== VK_HUAWEI_subpass_shading ===

      // wrapper function for command vkGetDeviceSubpassShadingMaxWorkgroupSizeHUAWEI, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetDeviceSubpassShadingMaxWorkgroupSizeHUAWEI.html
      VULKAN_HPP_NODISCARD typename ResultValueType<Extent2D>::type getSubpassShadingMaxWorkgroupSizeHUAWEI() const;

    private:
      VULKAN_HPP_NAMESPACE::Device     m_device     = {};
      VULKAN_HPP_NAMESPACE::RenderPass m_renderPass = {};
      const AllocationCallbacks *      m_allocator  = {};
      detail::DeviceDispatcher const * m_dispatcher = nullptr;
    };

    template <>
    struct isVulkanRAIIHandleType<RenderPass>
    {
      static VULKAN_HPP_CONST_OR_CONSTEXPR bool value = true;
    };

    // wrapper class for handle VkSampler, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkSampler.html
    class Sampler
    {
    public:
      using CType   = VkSampler;
      using CppType = VULKAN_HPP_NAMESPACE::Sampler;

      static VULKAN_HPP_CONST_OR_CONSTEXPR ObjectType               objectType            = ObjectType::eSampler;
      static VULKAN_HPP_CONST_OR_CONSTEXPR DebugReportObjectTypeEXT debugReportObjectType = DebugReportObjectTypeEXT::eSampler;

    public:
#  if !defined( VULKAN_HPP_NO_EXCEPTIONS )
      Sampler( Device const & device, SamplerCreateInfo const & createInfo, Optional<const AllocationCallbacks> allocator = nullptr )
      {
        *this = device.createSampler( createInfo, allocator );
      }
#  endif

      Sampler( Device const & device, VkSampler sampler, Optional<const AllocationCallbacks> allocator = nullptr )
        : m_device( device ), m_sampler( sampler ), m_allocator( static_cast<const AllocationCallbacks *>( allocator ) ), m_dispatcher( device.getDispatcher() )
      {
      }

      Sampler( std::nullptr_t ) {}

      ~Sampler()
      {
        clear();
      }

      Sampler()                  = delete;
      Sampler( Sampler const & ) = delete;

      Sampler( Sampler && rhs ) VULKAN_HPP_NOEXCEPT
        : m_device( exchange( rhs.m_device, {} ) )
        , m_sampler( exchange( rhs.m_sampler, {} ) )
        , m_allocator( exchange( rhs.m_allocator, {} ) )
        , m_dispatcher( exchange( rhs.m_dispatcher, nullptr ) )
      {
      }

      Sampler & operator=( Sampler const & ) = delete;

      Sampler & operator=( Sampler && rhs ) VULKAN_HPP_NOEXCEPT
      {
        if ( this != &rhs )
        {
          std::swap( m_device, rhs.m_device );
          std::swap( m_sampler, rhs.m_sampler );
          std::swap( m_allocator, rhs.m_allocator );
          std::swap( m_dispatcher, rhs.m_dispatcher );
        }
        return *this;
      }

      VULKAN_HPP_NAMESPACE::Sampler const & operator*() const & VULKAN_HPP_NOEXCEPT
      {
        return m_sampler;
      }

      VULKAN_HPP_NAMESPACE::Sampler const && operator*() const && VULKAN_HPP_NOEXCEPT
      {
        return std::move( m_sampler );
      }

      operator VULKAN_HPP_NAMESPACE::Sampler() const VULKAN_HPP_NOEXCEPT
      {
        return m_sampler;
      }

      void clear() VULKAN_HPP_NOEXCEPT
      {
        if ( m_sampler )
        {
          getDispatcher()->vkDestroySampler(
            static_cast<VkDevice>( m_device ), static_cast<VkSampler>( m_sampler ), reinterpret_cast<const VkAllocationCallbacks *>( m_allocator ) );
        }
        m_device     = nullptr;
        m_sampler    = nullptr;
        m_allocator  = nullptr;
        m_dispatcher = nullptr;
      }

      VULKAN_HPP_NAMESPACE::Sampler release()
      {
        m_device     = nullptr;
        m_allocator  = nullptr;
        m_dispatcher = nullptr;
        return exchange( m_sampler, nullptr );
      }

      VULKAN_HPP_NAMESPACE::Device getDevice() const
      {
        return m_device;
      }

      detail::DeviceDispatcher const * getDispatcher() const
      {
        VULKAN_HPP_ASSERT( m_dispatcher->getVkHeaderVersion() == VK_HEADER_VERSION );
        return m_dispatcher;
      }

      void swap( Sampler & rhs ) VULKAN_HPP_NOEXCEPT
      {
        std::swap( m_device, rhs.m_device );
        std::swap( m_sampler, rhs.m_sampler );
        std::swap( m_allocator, rhs.m_allocator );
        std::swap( m_dispatcher, rhs.m_dispatcher );
      }

    private:
      VULKAN_HPP_NAMESPACE::Device     m_device     = {};
      VULKAN_HPP_NAMESPACE::Sampler    m_sampler    = {};
      const AllocationCallbacks *      m_allocator  = {};
      detail::DeviceDispatcher const * m_dispatcher = nullptr;
    };

    template <>
    struct isVulkanRAIIHandleType<Sampler>
    {
      static VULKAN_HPP_CONST_OR_CONSTEXPR bool value = true;
    };

    // wrapper class for handle VkSamplerYcbcrConversion, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkSamplerYcbcrConversion.html
    class SamplerYcbcrConversion
    {
    public:
      using CType   = VkSamplerYcbcrConversion;
      using CppType = VULKAN_HPP_NAMESPACE::SamplerYcbcrConversion;

      static VULKAN_HPP_CONST_OR_CONSTEXPR ObjectType               objectType            = ObjectType::eSamplerYcbcrConversion;
      static VULKAN_HPP_CONST_OR_CONSTEXPR DebugReportObjectTypeEXT debugReportObjectType = DebugReportObjectTypeEXT::eSamplerYcbcrConversion;

    public:
#  if !defined( VULKAN_HPP_NO_EXCEPTIONS )
      SamplerYcbcrConversion( Device const &                           device,
                              SamplerYcbcrConversionCreateInfo const & createInfo,
                              Optional<const AllocationCallbacks>      allocator = nullptr )
      {
        *this = device.createSamplerYcbcrConversion( createInfo, allocator );
      }
#  endif

      SamplerYcbcrConversion( Device const & device, VkSamplerYcbcrConversion ycbcrConversion, Optional<const AllocationCallbacks> allocator = nullptr )
        : m_device( device )
        , m_samplerYcbcrConversion( ycbcrConversion )
        , m_allocator( static_cast<const AllocationCallbacks *>( allocator ) )
        , m_dispatcher( device.getDispatcher() )
      {
      }

      SamplerYcbcrConversion( std::nullptr_t ) {}

      ~SamplerYcbcrConversion()
      {
        clear();
      }

      SamplerYcbcrConversion()                                 = delete;
      SamplerYcbcrConversion( SamplerYcbcrConversion const & ) = delete;

      SamplerYcbcrConversion( SamplerYcbcrConversion && rhs ) VULKAN_HPP_NOEXCEPT
        : m_device( exchange( rhs.m_device, {} ) )
        , m_samplerYcbcrConversion( exchange( rhs.m_samplerYcbcrConversion, {} ) )
        , m_allocator( exchange( rhs.m_allocator, {} ) )
        , m_dispatcher( exchange( rhs.m_dispatcher, nullptr ) )
      {
      }

      SamplerYcbcrConversion & operator=( SamplerYcbcrConversion const & ) = delete;

      SamplerYcbcrConversion & operator=( SamplerYcbcrConversion && rhs ) VULKAN_HPP_NOEXCEPT
      {
        if ( this != &rhs )
        {
          std::swap( m_device, rhs.m_device );
          std::swap( m_samplerYcbcrConversion, rhs.m_samplerYcbcrConversion );
          std::swap( m_allocator, rhs.m_allocator );
          std::swap( m_dispatcher, rhs.m_dispatcher );
        }
        return *this;
      }

      VULKAN_HPP_NAMESPACE::SamplerYcbcrConversion const & operator*() const & VULKAN_HPP_NOEXCEPT
      {
        return m_samplerYcbcrConversion;
      }

      VULKAN_HPP_NAMESPACE::SamplerYcbcrConversion const && operator*() const && VULKAN_HPP_NOEXCEPT
      {
        return std::move( m_samplerYcbcrConversion );
      }

      operator VULKAN_HPP_NAMESPACE::SamplerYcbcrConversion() const VULKAN_HPP_NOEXCEPT
      {
        return m_samplerYcbcrConversion;
      }

      void clear() VULKAN_HPP_NOEXCEPT
      {
        if ( m_samplerYcbcrConversion )
        {
          getDispatcher()->vkDestroySamplerYcbcrConversion( static_cast<VkDevice>( m_device ),
                                                            static_cast<VkSamplerYcbcrConversion>( m_samplerYcbcrConversion ),
                                                            reinterpret_cast<const VkAllocationCallbacks *>( m_allocator ) );
        }
        m_device                 = nullptr;
        m_samplerYcbcrConversion = nullptr;
        m_allocator              = nullptr;
        m_dispatcher             = nullptr;
      }

      VULKAN_HPP_NAMESPACE::SamplerYcbcrConversion release()
      {
        m_device     = nullptr;
        m_allocator  = nullptr;
        m_dispatcher = nullptr;
        return exchange( m_samplerYcbcrConversion, nullptr );
      }

      VULKAN_HPP_NAMESPACE::Device getDevice() const
      {
        return m_device;
      }

      detail::DeviceDispatcher const * getDispatcher() const
      {
        VULKAN_HPP_ASSERT( m_dispatcher->getVkHeaderVersion() == VK_HEADER_VERSION );
        return m_dispatcher;
      }

      void swap( SamplerYcbcrConversion & rhs ) VULKAN_HPP_NOEXCEPT
      {
        std::swap( m_device, rhs.m_device );
        std::swap( m_samplerYcbcrConversion, rhs.m_samplerYcbcrConversion );
        std::swap( m_allocator, rhs.m_allocator );
        std::swap( m_dispatcher, rhs.m_dispatcher );
      }

    private:
      VULKAN_HPP_NAMESPACE::Device                 m_device                 = {};
      VULKAN_HPP_NAMESPACE::SamplerYcbcrConversion m_samplerYcbcrConversion = {};
      const AllocationCallbacks *                  m_allocator              = {};
      detail::DeviceDispatcher const *             m_dispatcher             = nullptr;
    };

    template <>
    struct isVulkanRAIIHandleType<SamplerYcbcrConversion>
    {
      static VULKAN_HPP_CONST_OR_CONSTEXPR bool value = true;
    };

    // wrapper class for handle VkSemaphore, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkSemaphore.html
    class Semaphore
    {
    public:
      using CType   = VkSemaphore;
      using CppType = VULKAN_HPP_NAMESPACE::Semaphore;

      static VULKAN_HPP_CONST_OR_CONSTEXPR ObjectType               objectType            = ObjectType::eSemaphore;
      static VULKAN_HPP_CONST_OR_CONSTEXPR DebugReportObjectTypeEXT debugReportObjectType = DebugReportObjectTypeEXT::eSemaphore;

    public:
#  if !defined( VULKAN_HPP_NO_EXCEPTIONS )
      Semaphore( Device const & device, SemaphoreCreateInfo const & createInfo, Optional<const AllocationCallbacks> allocator = nullptr )
      {
        *this = device.createSemaphore( createInfo, allocator );
      }
#  endif

      Semaphore( Device const & device, VkSemaphore semaphore, Optional<const AllocationCallbacks> allocator = nullptr )
        : m_device( device )
        , m_semaphore( semaphore )
        , m_allocator( static_cast<const AllocationCallbacks *>( allocator ) )
        , m_dispatcher( device.getDispatcher() )
      {
      }

      Semaphore( std::nullptr_t ) {}

      ~Semaphore()
      {
        clear();
      }

      Semaphore()                    = delete;
      Semaphore( Semaphore const & ) = delete;

      Semaphore( Semaphore && rhs ) VULKAN_HPP_NOEXCEPT
        : m_device( exchange( rhs.m_device, {} ) )
        , m_semaphore( exchange( rhs.m_semaphore, {} ) )
        , m_allocator( exchange( rhs.m_allocator, {} ) )
        , m_dispatcher( exchange( rhs.m_dispatcher, nullptr ) )
      {
      }

      Semaphore & operator=( Semaphore const & ) = delete;

      Semaphore & operator=( Semaphore && rhs ) VULKAN_HPP_NOEXCEPT
      {
        if ( this != &rhs )
        {
          std::swap( m_device, rhs.m_device );
          std::swap( m_semaphore, rhs.m_semaphore );
          std::swap( m_allocator, rhs.m_allocator );
          std::swap( m_dispatcher, rhs.m_dispatcher );
        }
        return *this;
      }

      VULKAN_HPP_NAMESPACE::Semaphore const & operator*() const & VULKAN_HPP_NOEXCEPT
      {
        return m_semaphore;
      }

      VULKAN_HPP_NAMESPACE::Semaphore const && operator*() const && VULKAN_HPP_NOEXCEPT
      {
        return std::move( m_semaphore );
      }

      operator VULKAN_HPP_NAMESPACE::Semaphore() const VULKAN_HPP_NOEXCEPT
      {
        return m_semaphore;
      }

      void clear() VULKAN_HPP_NOEXCEPT
      {
        if ( m_semaphore )
        {
          getDispatcher()->vkDestroySemaphore(
            static_cast<VkDevice>( m_device ), static_cast<VkSemaphore>( m_semaphore ), reinterpret_cast<const VkAllocationCallbacks *>( m_allocator ) );
        }
        m_device     = nullptr;
        m_semaphore  = nullptr;
        m_allocator  = nullptr;
        m_dispatcher = nullptr;
      }

      VULKAN_HPP_NAMESPACE::Semaphore release()
      {
        m_device     = nullptr;
        m_allocator  = nullptr;
        m_dispatcher = nullptr;
        return exchange( m_semaphore, nullptr );
      }

      VULKAN_HPP_NAMESPACE::Device getDevice() const
      {
        return m_device;
      }

      detail::DeviceDispatcher const * getDispatcher() const
      {
        VULKAN_HPP_ASSERT( m_dispatcher->getVkHeaderVersion() == VK_HEADER_VERSION );
        return m_dispatcher;
      }

      void swap( Semaphore & rhs ) VULKAN_HPP_NOEXCEPT
      {
        std::swap( m_device, rhs.m_device );
        std::swap( m_semaphore, rhs.m_semaphore );
        std::swap( m_allocator, rhs.m_allocator );
        std::swap( m_dispatcher, rhs.m_dispatcher );
      }

      //=== VK_VERSION_1_2 ===

      // wrapper function for command vkGetSemaphoreCounterValue, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetSemaphoreCounterValue.html
      VULKAN_HPP_NODISCARD typename ResultValueType<uint64_t>::type getCounterValue() const;

      //=== VK_KHR_timeline_semaphore ===

      // wrapper function for command vkGetSemaphoreCounterValueKHR, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetSemaphoreCounterValueKHR.html
      VULKAN_HPP_NODISCARD typename ResultValueType<uint64_t>::type getCounterValueKHR() const;

    private:
      VULKAN_HPP_NAMESPACE::Device     m_device     = {};
      VULKAN_HPP_NAMESPACE::Semaphore  m_semaphore  = {};
      const AllocationCallbacks *      m_allocator  = {};
      detail::DeviceDispatcher const * m_dispatcher = nullptr;
    };

    template <>
    struct isVulkanRAIIHandleType<Semaphore>
    {
      static VULKAN_HPP_CONST_OR_CONSTEXPR bool value = true;
    };

    // wrapper class for handle VkShaderEXT, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkShaderEXT.html
    class ShaderEXT
    {
    public:
      using CType   = VkShaderEXT;
      using CppType = VULKAN_HPP_NAMESPACE::ShaderEXT;

      static VULKAN_HPP_CONST_OR_CONSTEXPR ObjectType               objectType            = ObjectType::eShaderEXT;
      static VULKAN_HPP_CONST_OR_CONSTEXPR DebugReportObjectTypeEXT debugReportObjectType = DebugReportObjectTypeEXT::eUnknown;

    public:
#  if !defined( VULKAN_HPP_NO_EXCEPTIONS )
      ShaderEXT( Device const & device, ShaderCreateInfoEXT const & createInfo, Optional<const AllocationCallbacks> allocator = nullptr )
      {
        *this = device.createShaderEXT( createInfo, allocator );
      }
#  endif

      ShaderEXT( Device const & device, VkShaderEXT shader, Optional<const AllocationCallbacks> allocator = nullptr, Result successCode = Result::eSuccess )
        : m_device( device )
        , m_shaderEXT( shader )
        , m_allocator( static_cast<const AllocationCallbacks *>( allocator ) )
        , m_constructorSuccessCode( successCode )
        , m_dispatcher( device.getDispatcher() )
      {
      }

      ShaderEXT( std::nullptr_t ) {}

      ~ShaderEXT()
      {
        clear();
      }

      ShaderEXT()                    = delete;
      ShaderEXT( ShaderEXT const & ) = delete;

      ShaderEXT( ShaderEXT && rhs ) VULKAN_HPP_NOEXCEPT
        : m_device( exchange( rhs.m_device, {} ) )
        , m_shaderEXT( exchange( rhs.m_shaderEXT, {} ) )
        , m_allocator( exchange( rhs.m_allocator, {} ) )
        , m_constructorSuccessCode( exchange( rhs.m_constructorSuccessCode, {} ) )
        , m_dispatcher( exchange( rhs.m_dispatcher, nullptr ) )
      {
      }

      ShaderEXT & operator=( ShaderEXT const & ) = delete;

      ShaderEXT & operator=( ShaderEXT && rhs ) VULKAN_HPP_NOEXCEPT
      {
        if ( this != &rhs )
        {
          std::swap( m_device, rhs.m_device );
          std::swap( m_shaderEXT, rhs.m_shaderEXT );
          std::swap( m_allocator, rhs.m_allocator );
          std::swap( m_constructorSuccessCode, rhs.m_constructorSuccessCode );
          std::swap( m_dispatcher, rhs.m_dispatcher );
        }
        return *this;
      }

      VULKAN_HPP_NAMESPACE::ShaderEXT const & operator*() const & VULKAN_HPP_NOEXCEPT
      {
        return m_shaderEXT;
      }

      VULKAN_HPP_NAMESPACE::ShaderEXT const && operator*() const && VULKAN_HPP_NOEXCEPT
      {
        return std::move( m_shaderEXT );
      }

      operator VULKAN_HPP_NAMESPACE::ShaderEXT() const VULKAN_HPP_NOEXCEPT
      {
        return m_shaderEXT;
      }

      void clear() VULKAN_HPP_NOEXCEPT
      {
        if ( m_shaderEXT )
        {
          getDispatcher()->vkDestroyShaderEXT(
            static_cast<VkDevice>( m_device ), static_cast<VkShaderEXT>( m_shaderEXT ), reinterpret_cast<const VkAllocationCallbacks *>( m_allocator ) );
        }
        m_device                 = nullptr;
        m_shaderEXT              = nullptr;
        m_allocator              = nullptr;
        m_constructorSuccessCode = Result::eErrorUnknown;
        m_dispatcher             = nullptr;
      }

      VULKAN_HPP_NAMESPACE::ShaderEXT release()
      {
        m_device                 = nullptr;
        m_allocator              = nullptr;
        m_constructorSuccessCode = Result::eErrorUnknown;
        m_dispatcher             = nullptr;
        return exchange( m_shaderEXT, nullptr );
      }

      Result getConstructorSuccessCode() const
      {
        return m_constructorSuccessCode;
      }

      VULKAN_HPP_NAMESPACE::Device getDevice() const
      {
        return m_device;
      }

      detail::DeviceDispatcher const * getDispatcher() const
      {
        VULKAN_HPP_ASSERT( m_dispatcher->getVkHeaderVersion() == VK_HEADER_VERSION );
        return m_dispatcher;
      }

      void swap( ShaderEXT & rhs ) VULKAN_HPP_NOEXCEPT
      {
        std::swap( m_device, rhs.m_device );
        std::swap( m_shaderEXT, rhs.m_shaderEXT );
        std::swap( m_allocator, rhs.m_allocator );
        std::swap( m_constructorSuccessCode, rhs.m_constructorSuccessCode );
        std::swap( m_dispatcher, rhs.m_dispatcher );
      }

      //=== VK_EXT_shader_object ===

      // wrapper function for command vkGetShaderBinaryDataEXT, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetShaderBinaryDataEXT.html
      VULKAN_HPP_NODISCARD typename ResultValueType<std::vector<uint8_t>>::type getBinaryData() const;

    private:
      VULKAN_HPP_NAMESPACE::Device     m_device                 = {};
      VULKAN_HPP_NAMESPACE::ShaderEXT  m_shaderEXT              = {};
      const AllocationCallbacks *      m_allocator              = {};
      Result                           m_constructorSuccessCode = Result::eErrorUnknown;
      detail::DeviceDispatcher const * m_dispatcher             = nullptr;
    };

    template <>
    struct isVulkanRAIIHandleType<ShaderEXT>
    {
      static VULKAN_HPP_CONST_OR_CONSTEXPR bool value = true;
    };

    class ShaderEXTs : public std::vector<ShaderEXT>
    {
    public:
#  if !defined( VULKAN_HPP_NO_EXCEPTIONS )
      ShaderEXTs( Device const & device, ArrayProxy<ShaderCreateInfoEXT> const & createInfos, Optional<const AllocationCallbacks> allocator = nullptr )
      {
        *this = device.createShadersEXT( createInfos, allocator );
      }
#  endif

      ShaderEXTs( std::nullptr_t ) {}

      ShaderEXTs()                                 = delete;
      ShaderEXTs( ShaderEXTs const & )             = delete;
      ShaderEXTs( ShaderEXTs && rhs )              = default;
      ShaderEXTs & operator=( ShaderEXTs const & ) = delete;
      ShaderEXTs & operator=( ShaderEXTs && rhs )  = default;

    private:
      ShaderEXTs( std::vector<ShaderEXT> && rhs )
      {
        std::swap( *this, rhs );
      }
    };

    // wrapper class for handle VkShaderModule, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkShaderModule.html
    class ShaderModule
    {
    public:
      using CType   = VkShaderModule;
      using CppType = VULKAN_HPP_NAMESPACE::ShaderModule;

      static VULKAN_HPP_CONST_OR_CONSTEXPR ObjectType               objectType            = ObjectType::eShaderModule;
      static VULKAN_HPP_CONST_OR_CONSTEXPR DebugReportObjectTypeEXT debugReportObjectType = DebugReportObjectTypeEXT::eShaderModule;

    public:
#  if !defined( VULKAN_HPP_NO_EXCEPTIONS )
      ShaderModule( Device const & device, ShaderModuleCreateInfo const & createInfo, Optional<const AllocationCallbacks> allocator = nullptr )
      {
        *this = device.createShaderModule( createInfo, allocator );
      }
#  endif

      ShaderModule( Device const & device, VkShaderModule shaderModule, Optional<const AllocationCallbacks> allocator = nullptr )
        : m_device( device )
        , m_shaderModule( shaderModule )
        , m_allocator( static_cast<const AllocationCallbacks *>( allocator ) )
        , m_dispatcher( device.getDispatcher() )
      {
      }

      ShaderModule( std::nullptr_t ) {}

      ~ShaderModule()
      {
        clear();
      }

      ShaderModule()                       = delete;
      ShaderModule( ShaderModule const & ) = delete;

      ShaderModule( ShaderModule && rhs ) VULKAN_HPP_NOEXCEPT
        : m_device( exchange( rhs.m_device, {} ) )
        , m_shaderModule( exchange( rhs.m_shaderModule, {} ) )
        , m_allocator( exchange( rhs.m_allocator, {} ) )
        , m_dispatcher( exchange( rhs.m_dispatcher, nullptr ) )
      {
      }

      ShaderModule & operator=( ShaderModule const & ) = delete;

      ShaderModule & operator=( ShaderModule && rhs ) VULKAN_HPP_NOEXCEPT
      {
        if ( this != &rhs )
        {
          std::swap( m_device, rhs.m_device );
          std::swap( m_shaderModule, rhs.m_shaderModule );
          std::swap( m_allocator, rhs.m_allocator );
          std::swap( m_dispatcher, rhs.m_dispatcher );
        }
        return *this;
      }

      VULKAN_HPP_NAMESPACE::ShaderModule const & operator*() const & VULKAN_HPP_NOEXCEPT
      {
        return m_shaderModule;
      }

      VULKAN_HPP_NAMESPACE::ShaderModule const && operator*() const && VULKAN_HPP_NOEXCEPT
      {
        return std::move( m_shaderModule );
      }

      operator VULKAN_HPP_NAMESPACE::ShaderModule() const VULKAN_HPP_NOEXCEPT
      {
        return m_shaderModule;
      }

      void clear() VULKAN_HPP_NOEXCEPT
      {
        if ( m_shaderModule )
        {
          getDispatcher()->vkDestroyShaderModule(
            static_cast<VkDevice>( m_device ), static_cast<VkShaderModule>( m_shaderModule ), reinterpret_cast<const VkAllocationCallbacks *>( m_allocator ) );
        }
        m_device       = nullptr;
        m_shaderModule = nullptr;
        m_allocator    = nullptr;
        m_dispatcher   = nullptr;
      }

      VULKAN_HPP_NAMESPACE::ShaderModule release()
      {
        m_device     = nullptr;
        m_allocator  = nullptr;
        m_dispatcher = nullptr;
        return exchange( m_shaderModule, nullptr );
      }

      VULKAN_HPP_NAMESPACE::Device getDevice() const
      {
        return m_device;
      }

      detail::DeviceDispatcher const * getDispatcher() const
      {
        VULKAN_HPP_ASSERT( m_dispatcher->getVkHeaderVersion() == VK_HEADER_VERSION );
        return m_dispatcher;
      }

      void swap( ShaderModule & rhs ) VULKAN_HPP_NOEXCEPT
      {
        std::swap( m_device, rhs.m_device );
        std::swap( m_shaderModule, rhs.m_shaderModule );
        std::swap( m_allocator, rhs.m_allocator );
        std::swap( m_dispatcher, rhs.m_dispatcher );
      }

      //=== VK_EXT_shader_module_identifier ===

      // wrapper function for command vkGetShaderModuleIdentifierEXT, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetShaderModuleIdentifierEXT.html
      VULKAN_HPP_NODISCARD ShaderModuleIdentifierEXT getIdentifierEXT() const VULKAN_HPP_NOEXCEPT;

    private:
      VULKAN_HPP_NAMESPACE::Device       m_device       = {};
      VULKAN_HPP_NAMESPACE::ShaderModule m_shaderModule = {};
      const AllocationCallbacks *        m_allocator    = {};
      detail::DeviceDispatcher const *   m_dispatcher   = nullptr;
    };

    template <>
    struct isVulkanRAIIHandleType<ShaderModule>
    {
      static VULKAN_HPP_CONST_OR_CONSTEXPR bool value = true;
    };

    // wrapper class for handle VkSurfaceKHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkSurfaceKHR.html
    class SurfaceKHR
    {
    public:
      using CType   = VkSurfaceKHR;
      using CppType = VULKAN_HPP_NAMESPACE::SurfaceKHR;

      static VULKAN_HPP_CONST_OR_CONSTEXPR ObjectType               objectType            = ObjectType::eSurfaceKHR;
      static VULKAN_HPP_CONST_OR_CONSTEXPR DebugReportObjectTypeEXT debugReportObjectType = DebugReportObjectTypeEXT::eSurfaceKHR;

    public:
#  if !defined( VULKAN_HPP_NO_EXCEPTIONS )
#    if defined( VK_USE_PLATFORM_ANDROID_KHR )
      SurfaceKHR( Instance const & instance, AndroidSurfaceCreateInfoKHR const & createInfo, Optional<const AllocationCallbacks> allocator = nullptr )
      {
        *this = instance.createAndroidSurfaceKHR( createInfo, allocator );
      }
#    endif /*VK_USE_PLATFORM_ANDROID_KHR*/
#  endif

#  if !defined( VULKAN_HPP_NO_EXCEPTIONS )
#    if defined( VK_USE_PLATFORM_DIRECTFB_EXT )
      SurfaceKHR( Instance const & instance, DirectFBSurfaceCreateInfoEXT const & createInfo, Optional<const AllocationCallbacks> allocator = nullptr )
      {
        *this = instance.createDirectFBSurfaceEXT( createInfo, allocator );
      }
#    endif /*VK_USE_PLATFORM_DIRECTFB_EXT*/
#  endif

#  if !defined( VULKAN_HPP_NO_EXCEPTIONS )
      SurfaceKHR( Instance const & instance, DisplaySurfaceCreateInfoKHR const & createInfo, Optional<const AllocationCallbacks> allocator = nullptr )
      {
        *this = instance.createDisplayPlaneSurfaceKHR( createInfo, allocator );
      }
#  endif

#  if !defined( VULKAN_HPP_NO_EXCEPTIONS )
      SurfaceKHR( Instance const & instance, HeadlessSurfaceCreateInfoEXT const & createInfo, Optional<const AllocationCallbacks> allocator = nullptr )
      {
        *this = instance.createHeadlessSurfaceEXT( createInfo, allocator );
      }
#  endif

#  if !defined( VULKAN_HPP_NO_EXCEPTIONS )
#    if defined( VK_USE_PLATFORM_IOS_MVK )
      SurfaceKHR( Instance const & instance, IOSSurfaceCreateInfoMVK const & createInfo, Optional<const AllocationCallbacks> allocator = nullptr )
      {
        *this = instance.createIOSSurfaceMVK( createInfo, allocator );
      }
#    endif /*VK_USE_PLATFORM_IOS_MVK*/
#  endif

#  if !defined( VULKAN_HPP_NO_EXCEPTIONS )
#    if defined( VK_USE_PLATFORM_FUCHSIA )
      SurfaceKHR( Instance const & instance, ImagePipeSurfaceCreateInfoFUCHSIA const & createInfo, Optional<const AllocationCallbacks> allocator = nullptr )
      {
        *this = instance.createImagePipeSurfaceFUCHSIA( createInfo, allocator );
      }
#    endif /*VK_USE_PLATFORM_FUCHSIA*/
#  endif

#  if !defined( VULKAN_HPP_NO_EXCEPTIONS )
#    if defined( VK_USE_PLATFORM_MACOS_MVK )
      SurfaceKHR( Instance const & instance, MacOSSurfaceCreateInfoMVK const & createInfo, Optional<const AllocationCallbacks> allocator = nullptr )
      {
        *this = instance.createMacOSSurfaceMVK( createInfo, allocator );
      }
#    endif /*VK_USE_PLATFORM_MACOS_MVK*/
#  endif

#  if !defined( VULKAN_HPP_NO_EXCEPTIONS )
#    if defined( VK_USE_PLATFORM_METAL_EXT )
      SurfaceKHR( Instance const & instance, MetalSurfaceCreateInfoEXT const & createInfo, Optional<const AllocationCallbacks> allocator = nullptr )
      {
        *this = instance.createMetalSurfaceEXT( createInfo, allocator );
      }
#    endif /*VK_USE_PLATFORM_METAL_EXT*/
#  endif

#  if !defined( VULKAN_HPP_NO_EXCEPTIONS )
#    if defined( VK_USE_PLATFORM_SCREEN_QNX )
      SurfaceKHR( Instance const & instance, ScreenSurfaceCreateInfoQNX const & createInfo, Optional<const AllocationCallbacks> allocator = nullptr )
      {
        *this = instance.createScreenSurfaceQNX( createInfo, allocator );
      }
#    endif /*VK_USE_PLATFORM_SCREEN_QNX*/
#  endif

#  if !defined( VULKAN_HPP_NO_EXCEPTIONS )
#    if defined( VK_USE_PLATFORM_GGP )
      SurfaceKHR( Instance const & instance, StreamDescriptorSurfaceCreateInfoGGP const & createInfo, Optional<const AllocationCallbacks> allocator = nullptr )
      {
        *this = instance.createStreamDescriptorSurfaceGGP( createInfo, allocator );
      }
#    endif /*VK_USE_PLATFORM_GGP*/
#  endif

#  if !defined( VULKAN_HPP_NO_EXCEPTIONS )
#    if defined( VK_USE_PLATFORM_OHOS )
      SurfaceKHR( Instance const & instance, SurfaceCreateInfoOHOS const & createInfo, Optional<const AllocationCallbacks> allocator = nullptr )
      {
        *this = instance.createSurfaceOHOS( createInfo, allocator );
      }
#    endif /*VK_USE_PLATFORM_OHOS*/
#  endif

#  if !defined( VULKAN_HPP_NO_EXCEPTIONS )
#    if defined( VK_USE_PLATFORM_VI_NN )
      SurfaceKHR( Instance const & instance, ViSurfaceCreateInfoNN const & createInfo, Optional<const AllocationCallbacks> allocator = nullptr )
      {
        *this = instance.createViSurfaceNN( createInfo, allocator );
      }
#    endif /*VK_USE_PLATFORM_VI_NN*/
#  endif

#  if !defined( VULKAN_HPP_NO_EXCEPTIONS )
#    if defined( VK_USE_PLATFORM_WAYLAND_KHR )
      SurfaceKHR( Instance const & instance, WaylandSurfaceCreateInfoKHR const & createInfo, Optional<const AllocationCallbacks> allocator = nullptr )
      {
        *this = instance.createWaylandSurfaceKHR( createInfo, allocator );
      }
#    endif /*VK_USE_PLATFORM_WAYLAND_KHR*/
#  endif

#  if !defined( VULKAN_HPP_NO_EXCEPTIONS )
#    if defined( VK_USE_PLATFORM_WIN32_KHR )
      SurfaceKHR( Instance const & instance, Win32SurfaceCreateInfoKHR const & createInfo, Optional<const AllocationCallbacks> allocator = nullptr )
      {
        *this = instance.createWin32SurfaceKHR( createInfo, allocator );
      }
#    endif /*VK_USE_PLATFORM_WIN32_KHR*/
#  endif

#  if !defined( VULKAN_HPP_NO_EXCEPTIONS )
#    if defined( VK_USE_PLATFORM_XCB_KHR )
      SurfaceKHR( Instance const & instance, XcbSurfaceCreateInfoKHR const & createInfo, Optional<const AllocationCallbacks> allocator = nullptr )
      {
        *this = instance.createXcbSurfaceKHR( createInfo, allocator );
      }
#    endif /*VK_USE_PLATFORM_XCB_KHR*/
#  endif

#  if !defined( VULKAN_HPP_NO_EXCEPTIONS )
#    if defined( VK_USE_PLATFORM_XLIB_KHR )
      SurfaceKHR( Instance const & instance, XlibSurfaceCreateInfoKHR const & createInfo, Optional<const AllocationCallbacks> allocator = nullptr )
      {
        *this = instance.createXlibSurfaceKHR( createInfo, allocator );
      }
#    endif /*VK_USE_PLATFORM_XLIB_KHR*/
#  endif

      SurfaceKHR( Instance const & instance, VkSurfaceKHR surface, Optional<const AllocationCallbacks> allocator = nullptr )
        : m_instance( instance )
        , m_surfaceKHR( surface )
        , m_allocator( static_cast<const AllocationCallbacks *>( allocator ) )
        , m_dispatcher( instance.getDispatcher() )
      {
      }

      SurfaceKHR( std::nullptr_t ) {}

      ~SurfaceKHR()
      {
        clear();
      }

      SurfaceKHR()                     = delete;
      SurfaceKHR( SurfaceKHR const & ) = delete;

      SurfaceKHR( SurfaceKHR && rhs ) VULKAN_HPP_NOEXCEPT
        : m_instance( exchange( rhs.m_instance, {} ) )
        , m_surfaceKHR( exchange( rhs.m_surfaceKHR, {} ) )
        , m_allocator( exchange( rhs.m_allocator, {} ) )
        , m_dispatcher( exchange( rhs.m_dispatcher, nullptr ) )
      {
      }

      SurfaceKHR & operator=( SurfaceKHR const & ) = delete;

      SurfaceKHR & operator=( SurfaceKHR && rhs ) VULKAN_HPP_NOEXCEPT
      {
        if ( this != &rhs )
        {
          std::swap( m_instance, rhs.m_instance );
          std::swap( m_surfaceKHR, rhs.m_surfaceKHR );
          std::swap( m_allocator, rhs.m_allocator );
          std::swap( m_dispatcher, rhs.m_dispatcher );
        }
        return *this;
      }

      VULKAN_HPP_NAMESPACE::SurfaceKHR const & operator*() const & VULKAN_HPP_NOEXCEPT
      {
        return m_surfaceKHR;
      }

      VULKAN_HPP_NAMESPACE::SurfaceKHR const && operator*() const && VULKAN_HPP_NOEXCEPT
      {
        return std::move( m_surfaceKHR );
      }

      operator VULKAN_HPP_NAMESPACE::SurfaceKHR() const VULKAN_HPP_NOEXCEPT
      {
        return m_surfaceKHR;
      }

      void clear() VULKAN_HPP_NOEXCEPT
      {
        if ( m_surfaceKHR )
        {
          getDispatcher()->vkDestroySurfaceKHR(
            static_cast<VkInstance>( m_instance ), static_cast<VkSurfaceKHR>( m_surfaceKHR ), reinterpret_cast<const VkAllocationCallbacks *>( m_allocator ) );
        }
        m_instance   = nullptr;
        m_surfaceKHR = nullptr;
        m_allocator  = nullptr;
        m_dispatcher = nullptr;
      }

      VULKAN_HPP_NAMESPACE::SurfaceKHR release()
      {
        m_instance   = nullptr;
        m_allocator  = nullptr;
        m_dispatcher = nullptr;
        return exchange( m_surfaceKHR, nullptr );
      }

      VULKAN_HPP_NAMESPACE::Instance getInstance() const
      {
        return m_instance;
      }

      detail::InstanceDispatcher const * getDispatcher() const
      {
        VULKAN_HPP_ASSERT( m_dispatcher->getVkHeaderVersion() == VK_HEADER_VERSION );
        return m_dispatcher;
      }

      void swap( SurfaceKHR & rhs ) VULKAN_HPP_NOEXCEPT
      {
        std::swap( m_instance, rhs.m_instance );
        std::swap( m_surfaceKHR, rhs.m_surfaceKHR );
        std::swap( m_allocator, rhs.m_allocator );
        std::swap( m_dispatcher, rhs.m_dispatcher );
      }

    private:
      VULKAN_HPP_NAMESPACE::Instance     m_instance   = {};
      VULKAN_HPP_NAMESPACE::SurfaceKHR   m_surfaceKHR = {};
      const AllocationCallbacks *        m_allocator  = {};
      detail::InstanceDispatcher const * m_dispatcher = nullptr;
    };

    template <>
    struct isVulkanRAIIHandleType<SurfaceKHR>
    {
      static VULKAN_HPP_CONST_OR_CONSTEXPR bool value = true;
    };

    // wrapper class for handle VkSwapchainKHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkSwapchainKHR.html
    class SwapchainKHR
    {
    public:
      using CType   = VkSwapchainKHR;
      using CppType = VULKAN_HPP_NAMESPACE::SwapchainKHR;

      static VULKAN_HPP_CONST_OR_CONSTEXPR ObjectType               objectType            = ObjectType::eSwapchainKHR;
      static VULKAN_HPP_CONST_OR_CONSTEXPR DebugReportObjectTypeEXT debugReportObjectType = DebugReportObjectTypeEXT::eSwapchainKHR;

    public:
#  if !defined( VULKAN_HPP_NO_EXCEPTIONS )
      SwapchainKHR( Device const & device, SwapchainCreateInfoKHR const & createInfo, Optional<const AllocationCallbacks> allocator = nullptr )
      {
        *this = device.createSwapchainKHR( createInfo, allocator );
      }
#  endif

      SwapchainKHR( Device const & device, VkSwapchainKHR swapchain, Optional<const AllocationCallbacks> allocator = nullptr )
        : m_device( device )
        , m_swapchainKHR( swapchain )
        , m_allocator( static_cast<const AllocationCallbacks *>( allocator ) )
        , m_dispatcher( device.getDispatcher() )
      {
      }

      SwapchainKHR( std::nullptr_t ) {}

      ~SwapchainKHR()
      {
        clear();
      }

      SwapchainKHR()                       = delete;
      SwapchainKHR( SwapchainKHR const & ) = delete;

      SwapchainKHR( SwapchainKHR && rhs ) VULKAN_HPP_NOEXCEPT
        : m_device( exchange( rhs.m_device, {} ) )
        , m_swapchainKHR( exchange( rhs.m_swapchainKHR, {} ) )
        , m_allocator( exchange( rhs.m_allocator, {} ) )
        , m_dispatcher( exchange( rhs.m_dispatcher, nullptr ) )
      {
      }

      SwapchainKHR & operator=( SwapchainKHR const & ) = delete;

      SwapchainKHR & operator=( SwapchainKHR && rhs ) VULKAN_HPP_NOEXCEPT
      {
        if ( this != &rhs )
        {
          std::swap( m_device, rhs.m_device );
          std::swap( m_swapchainKHR, rhs.m_swapchainKHR );
          std::swap( m_allocator, rhs.m_allocator );
          std::swap( m_dispatcher, rhs.m_dispatcher );
        }
        return *this;
      }

      VULKAN_HPP_NAMESPACE::SwapchainKHR const & operator*() const & VULKAN_HPP_NOEXCEPT
      {
        return m_swapchainKHR;
      }

      VULKAN_HPP_NAMESPACE::SwapchainKHR const && operator*() const && VULKAN_HPP_NOEXCEPT
      {
        return std::move( m_swapchainKHR );
      }

      operator VULKAN_HPP_NAMESPACE::SwapchainKHR() const VULKAN_HPP_NOEXCEPT
      {
        return m_swapchainKHR;
      }

      void clear() VULKAN_HPP_NOEXCEPT
      {
        if ( m_swapchainKHR )
        {
          getDispatcher()->vkDestroySwapchainKHR(
            static_cast<VkDevice>( m_device ), static_cast<VkSwapchainKHR>( m_swapchainKHR ), reinterpret_cast<const VkAllocationCallbacks *>( m_allocator ) );
        }
        m_device       = nullptr;
        m_swapchainKHR = nullptr;
        m_allocator    = nullptr;
        m_dispatcher   = nullptr;
      }

      VULKAN_HPP_NAMESPACE::SwapchainKHR release()
      {
        m_device     = nullptr;
        m_allocator  = nullptr;
        m_dispatcher = nullptr;
        return exchange( m_swapchainKHR, nullptr );
      }

      VULKAN_HPP_NAMESPACE::Device getDevice() const
      {
        return m_device;
      }

      detail::DeviceDispatcher const * getDispatcher() const
      {
        VULKAN_HPP_ASSERT( m_dispatcher->getVkHeaderVersion() == VK_HEADER_VERSION );
        return m_dispatcher;
      }

      void swap( SwapchainKHR & rhs ) VULKAN_HPP_NOEXCEPT
      {
        std::swap( m_device, rhs.m_device );
        std::swap( m_swapchainKHR, rhs.m_swapchainKHR );
        std::swap( m_allocator, rhs.m_allocator );
        std::swap( m_dispatcher, rhs.m_dispatcher );
      }

      //=== VK_KHR_swapchain ===

      // wrapper function for command vkGetSwapchainImagesKHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetSwapchainImagesKHR.html
      VULKAN_HPP_NODISCARD typename ResultValueType<std::vector<VULKAN_HPP_NAMESPACE::Image>>::type getImages() const;

      // wrapper function for command vkAcquireNextImageKHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkAcquireNextImageKHR.html
      VULKAN_HPP_NODISCARD ResultValue<uint32_t> acquireNextImage( uint64_t                                  timeout,
                                                                   VULKAN_HPP_NAMESPACE::Semaphore semaphore VULKAN_HPP_DEFAULT_ASSIGNMENT( {} ),
                                                                   VULKAN_HPP_NAMESPACE::Fence fence         VULKAN_HPP_DEFAULT_ASSIGNMENT( {} ) ) const;

      //=== VK_EXT_display_control ===

      // wrapper function for command vkGetSwapchainCounterEXT, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetSwapchainCounterEXT.html
      VULKAN_HPP_NODISCARD
#  if defined( VULKAN_HPP_HANDLE_ERROR_OUT_OF_DATE_AS_SUCCESS )
      ResultValue<uint64_t>
#  else
      typename ResultValueType<uint64_t>::type
#  endif
        getCounterEXT( SurfaceCounterFlagBitsEXT counter ) const;

      //=== VK_GOOGLE_display_timing ===

      // wrapper function for command vkGetRefreshCycleDurationGOOGLE, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetRefreshCycleDurationGOOGLE.html
      VULKAN_HPP_NODISCARD typename ResultValueType<RefreshCycleDurationGOOGLE>::type getRefreshCycleDurationGOOGLE() const;

      // wrapper function for command vkGetPastPresentationTimingGOOGLE, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetPastPresentationTimingGOOGLE.html
      VULKAN_HPP_NODISCARD
#  if defined( VULKAN_HPP_HANDLE_ERROR_OUT_OF_DATE_AS_SUCCESS )
      ResultValue<std::vector<PastPresentationTimingGOOGLE>>
#  else
      typename ResultValueType<std::vector<PastPresentationTimingGOOGLE>>::type
#  endif
        getPastPresentationTimingGOOGLE() const;

      //=== VK_KHR_shared_presentable_image ===

      // wrapper function for command vkGetSwapchainStatusKHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetSwapchainStatusKHR.html
      VULKAN_HPP_NODISCARD Result getStatus() const;

      //=== VK_AMD_display_native_hdr ===

      // wrapper function for command vkSetLocalDimmingAMD, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkSetLocalDimmingAMD.html
      void setLocalDimmingAMD( Bool32 localDimmingEnable ) const VULKAN_HPP_NOEXCEPT;

      //=== VK_KHR_present_wait ===

      // wrapper function for command vkWaitForPresentKHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkWaitForPresentKHR.html
      VULKAN_HPP_NODISCARD Result waitForPresent( uint64_t presentId, uint64_t timeout ) const;

#  if defined( VK_USE_PLATFORM_WIN32_KHR )
      //=== VK_EXT_full_screen_exclusive ===

      // wrapper function for command vkAcquireFullScreenExclusiveModeEXT, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkAcquireFullScreenExclusiveModeEXT.html
      typename ResultValueType<void>::type acquireFullScreenExclusiveModeEXT() const;

      // wrapper function for command vkReleaseFullScreenExclusiveModeEXT, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkReleaseFullScreenExclusiveModeEXT.html
      typename ResultValueType<void>::type releaseFullScreenExclusiveModeEXT() const;
#  endif /*VK_USE_PLATFORM_WIN32_KHR*/

      //=== VK_KHR_present_wait2 ===

      // wrapper function for command vkWaitForPresent2KHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkWaitForPresent2KHR.html
      VULKAN_HPP_NODISCARD Result waitForPresent2( const PresentWait2InfoKHR & presentWait2Info ) const;

      //=== VK_NV_low_latency2 ===

      // wrapper function for command vkSetLatencySleepModeNV, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkSetLatencySleepModeNV.html
      typename ResultValueType<void>::type setLatencySleepModeNV( const LatencySleepModeInfoNV & sleepModeInfo ) const;

      // wrapper function for command vkLatencySleepNV, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkLatencySleepNV.html
      typename ResultValueType<void>::type latencySleepNV( const LatencySleepInfoNV & sleepInfo ) const;

      // wrapper function for command vkSetLatencyMarkerNV, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkSetLatencyMarkerNV.html
      void setLatencyMarkerNV( const SetLatencyMarkerInfoNV & latencyMarkerInfo ) const VULKAN_HPP_NOEXCEPT;

      // wrapper function for command vkGetLatencyTimingsNV, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetLatencyTimingsNV.html
      VULKAN_HPP_NODISCARD std::vector<VULKAN_HPP_NAMESPACE::LatencyTimingsFrameReportNV> getLatencyTimingsNV() const;

    private:
      VULKAN_HPP_NAMESPACE::Device       m_device       = {};
      VULKAN_HPP_NAMESPACE::SwapchainKHR m_swapchainKHR = {};
      const AllocationCallbacks *        m_allocator    = {};
      detail::DeviceDispatcher const *   m_dispatcher   = nullptr;
    };

    template <>
    struct isVulkanRAIIHandleType<SwapchainKHR>
    {
      static VULKAN_HPP_CONST_OR_CONSTEXPR bool value = true;
    };

    class SwapchainKHRs : public std::vector<SwapchainKHR>
    {
    public:
#  if !defined( VULKAN_HPP_NO_EXCEPTIONS )
      SwapchainKHRs( Device const & device, ArrayProxy<SwapchainCreateInfoKHR> const & createInfos, Optional<const AllocationCallbacks> allocator = nullptr )
      {
        *this = device.createSharedSwapchainsKHR( createInfos, allocator );
      }
#  endif

      SwapchainKHRs( std::nullptr_t ) {}

      SwapchainKHRs()                                    = delete;
      SwapchainKHRs( SwapchainKHRs const & )             = delete;
      SwapchainKHRs( SwapchainKHRs && rhs )              = default;
      SwapchainKHRs & operator=( SwapchainKHRs const & ) = delete;
      SwapchainKHRs & operator=( SwapchainKHRs && rhs )  = default;

    private:
      SwapchainKHRs( std::vector<SwapchainKHR> && rhs )
      {
        std::swap( *this, rhs );
      }
    };

    // wrapper class for handle VkTensorARM, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkTensorARM.html
    class TensorARM
    {
    public:
      using CType   = VkTensorARM;
      using CppType = VULKAN_HPP_NAMESPACE::TensorARM;

      static VULKAN_HPP_CONST_OR_CONSTEXPR ObjectType               objectType            = ObjectType::eTensorARM;
      static VULKAN_HPP_CONST_OR_CONSTEXPR DebugReportObjectTypeEXT debugReportObjectType = DebugReportObjectTypeEXT::eUnknown;

    public:
#  if !defined( VULKAN_HPP_NO_EXCEPTIONS )
      TensorARM( Device const & device, TensorCreateInfoARM const & createInfo, Optional<const AllocationCallbacks> allocator = nullptr )
      {
        *this = device.createTensorARM( createInfo, allocator );
      }
#  endif

      TensorARM( Device const & device, VkTensorARM tensor, Optional<const AllocationCallbacks> allocator = nullptr )
        : m_device( device )
        , m_tensorARM( tensor )
        , m_allocator( static_cast<const AllocationCallbacks *>( allocator ) )
        , m_dispatcher( device.getDispatcher() )
      {
      }

      TensorARM( std::nullptr_t ) {}

      ~TensorARM()
      {
        clear();
      }

      TensorARM()                    = delete;
      TensorARM( TensorARM const & ) = delete;

      TensorARM( TensorARM && rhs ) VULKAN_HPP_NOEXCEPT
        : m_device( exchange( rhs.m_device, {} ) )
        , m_tensorARM( exchange( rhs.m_tensorARM, {} ) )
        , m_allocator( exchange( rhs.m_allocator, {} ) )
        , m_dispatcher( exchange( rhs.m_dispatcher, nullptr ) )
      {
      }

      TensorARM & operator=( TensorARM const & ) = delete;

      TensorARM & operator=( TensorARM && rhs ) VULKAN_HPP_NOEXCEPT
      {
        if ( this != &rhs )
        {
          std::swap( m_device, rhs.m_device );
          std::swap( m_tensorARM, rhs.m_tensorARM );
          std::swap( m_allocator, rhs.m_allocator );
          std::swap( m_dispatcher, rhs.m_dispatcher );
        }
        return *this;
      }

      VULKAN_HPP_NAMESPACE::TensorARM const & operator*() const & VULKAN_HPP_NOEXCEPT
      {
        return m_tensorARM;
      }

      VULKAN_HPP_NAMESPACE::TensorARM const && operator*() const && VULKAN_HPP_NOEXCEPT
      {
        return std::move( m_tensorARM );
      }

      operator VULKAN_HPP_NAMESPACE::TensorARM() const VULKAN_HPP_NOEXCEPT
      {
        return m_tensorARM;
      }

      void clear() VULKAN_HPP_NOEXCEPT
      {
        if ( m_tensorARM )
        {
          getDispatcher()->vkDestroyTensorARM(
            static_cast<VkDevice>( m_device ), static_cast<VkTensorARM>( m_tensorARM ), reinterpret_cast<const VkAllocationCallbacks *>( m_allocator ) );
        }
        m_device     = nullptr;
        m_tensorARM  = nullptr;
        m_allocator  = nullptr;
        m_dispatcher = nullptr;
      }

      VULKAN_HPP_NAMESPACE::TensorARM release()
      {
        m_device     = nullptr;
        m_allocator  = nullptr;
        m_dispatcher = nullptr;
        return exchange( m_tensorARM, nullptr );
      }

      VULKAN_HPP_NAMESPACE::Device getDevice() const
      {
        return m_device;
      }

      detail::DeviceDispatcher const * getDispatcher() const
      {
        VULKAN_HPP_ASSERT( m_dispatcher->getVkHeaderVersion() == VK_HEADER_VERSION );
        return m_dispatcher;
      }

      void swap( TensorARM & rhs ) VULKAN_HPP_NOEXCEPT
      {
        std::swap( m_device, rhs.m_device );
        std::swap( m_tensorARM, rhs.m_tensorARM );
        std::swap( m_allocator, rhs.m_allocator );
        std::swap( m_dispatcher, rhs.m_dispatcher );
      }

    private:
      VULKAN_HPP_NAMESPACE::Device     m_device     = {};
      VULKAN_HPP_NAMESPACE::TensorARM  m_tensorARM  = {};
      const AllocationCallbacks *      m_allocator  = {};
      detail::DeviceDispatcher const * m_dispatcher = nullptr;
    };

    template <>
    struct isVulkanRAIIHandleType<TensorARM>
    {
      static VULKAN_HPP_CONST_OR_CONSTEXPR bool value = true;
    };

    // wrapper class for handle VkTensorViewARM, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkTensorViewARM.html
    class TensorViewARM
    {
    public:
      using CType   = VkTensorViewARM;
      using CppType = VULKAN_HPP_NAMESPACE::TensorViewARM;

      static VULKAN_HPP_CONST_OR_CONSTEXPR ObjectType               objectType            = ObjectType::eTensorViewARM;
      static VULKAN_HPP_CONST_OR_CONSTEXPR DebugReportObjectTypeEXT debugReportObjectType = DebugReportObjectTypeEXT::eUnknown;

    public:
#  if !defined( VULKAN_HPP_NO_EXCEPTIONS )
      TensorViewARM( Device const & device, TensorViewCreateInfoARM const & createInfo, Optional<const AllocationCallbacks> allocator = nullptr )
      {
        *this = device.createTensorViewARM( createInfo, allocator );
      }
#  endif

      TensorViewARM( Device const & device, VkTensorViewARM tensorView, Optional<const AllocationCallbacks> allocator = nullptr )
        : m_device( device )
        , m_tensorViewARM( tensorView )
        , m_allocator( static_cast<const AllocationCallbacks *>( allocator ) )
        , m_dispatcher( device.getDispatcher() )
      {
      }

      TensorViewARM( std::nullptr_t ) {}

      ~TensorViewARM()
      {
        clear();
      }

      TensorViewARM()                        = delete;
      TensorViewARM( TensorViewARM const & ) = delete;

      TensorViewARM( TensorViewARM && rhs ) VULKAN_HPP_NOEXCEPT
        : m_device( exchange( rhs.m_device, {} ) )
        , m_tensorViewARM( exchange( rhs.m_tensorViewARM, {} ) )
        , m_allocator( exchange( rhs.m_allocator, {} ) )
        , m_dispatcher( exchange( rhs.m_dispatcher, nullptr ) )
      {
      }

      TensorViewARM & operator=( TensorViewARM const & ) = delete;

      TensorViewARM & operator=( TensorViewARM && rhs ) VULKAN_HPP_NOEXCEPT
      {
        if ( this != &rhs )
        {
          std::swap( m_device, rhs.m_device );
          std::swap( m_tensorViewARM, rhs.m_tensorViewARM );
          std::swap( m_allocator, rhs.m_allocator );
          std::swap( m_dispatcher, rhs.m_dispatcher );
        }
        return *this;
      }

      VULKAN_HPP_NAMESPACE::TensorViewARM const & operator*() const & VULKAN_HPP_NOEXCEPT
      {
        return m_tensorViewARM;
      }

      VULKAN_HPP_NAMESPACE::TensorViewARM const && operator*() const && VULKAN_HPP_NOEXCEPT
      {
        return std::move( m_tensorViewARM );
      }

      operator VULKAN_HPP_NAMESPACE::TensorViewARM() const VULKAN_HPP_NOEXCEPT
      {
        return m_tensorViewARM;
      }

      void clear() VULKAN_HPP_NOEXCEPT
      {
        if ( m_tensorViewARM )
        {
          getDispatcher()->vkDestroyTensorViewARM( static_cast<VkDevice>( m_device ),
                                                   static_cast<VkTensorViewARM>( m_tensorViewARM ),
                                                   reinterpret_cast<const VkAllocationCallbacks *>( m_allocator ) );
        }
        m_device        = nullptr;
        m_tensorViewARM = nullptr;
        m_allocator     = nullptr;
        m_dispatcher    = nullptr;
      }

      VULKAN_HPP_NAMESPACE::TensorViewARM release()
      {
        m_device     = nullptr;
        m_allocator  = nullptr;
        m_dispatcher = nullptr;
        return exchange( m_tensorViewARM, nullptr );
      }

      VULKAN_HPP_NAMESPACE::Device getDevice() const
      {
        return m_device;
      }

      detail::DeviceDispatcher const * getDispatcher() const
      {
        VULKAN_HPP_ASSERT( m_dispatcher->getVkHeaderVersion() == VK_HEADER_VERSION );
        return m_dispatcher;
      }

      void swap( TensorViewARM & rhs ) VULKAN_HPP_NOEXCEPT
      {
        std::swap( m_device, rhs.m_device );
        std::swap( m_tensorViewARM, rhs.m_tensorViewARM );
        std::swap( m_allocator, rhs.m_allocator );
        std::swap( m_dispatcher, rhs.m_dispatcher );
      }

    private:
      VULKAN_HPP_NAMESPACE::Device        m_device        = {};
      VULKAN_HPP_NAMESPACE::TensorViewARM m_tensorViewARM = {};
      const AllocationCallbacks *         m_allocator     = {};
      detail::DeviceDispatcher const *    m_dispatcher    = nullptr;
    };

    template <>
    struct isVulkanRAIIHandleType<TensorViewARM>
    {
      static VULKAN_HPP_CONST_OR_CONSTEXPR bool value = true;
    };

    // wrapper class for handle VkValidationCacheEXT, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkValidationCacheEXT.html
    class ValidationCacheEXT
    {
    public:
      using CType   = VkValidationCacheEXT;
      using CppType = VULKAN_HPP_NAMESPACE::ValidationCacheEXT;

      static VULKAN_HPP_CONST_OR_CONSTEXPR ObjectType               objectType            = ObjectType::eValidationCacheEXT;
      static VULKAN_HPP_CONST_OR_CONSTEXPR DebugReportObjectTypeEXT debugReportObjectType = DebugReportObjectTypeEXT::eValidationCacheEXT;

    public:
#  if !defined( VULKAN_HPP_NO_EXCEPTIONS )
      ValidationCacheEXT( Device const & device, ValidationCacheCreateInfoEXT const & createInfo, Optional<const AllocationCallbacks> allocator = nullptr )
      {
        *this = device.createValidationCacheEXT( createInfo, allocator );
      }
#  endif

      ValidationCacheEXT( Device const & device, VkValidationCacheEXT validationCache, Optional<const AllocationCallbacks> allocator = nullptr )
        : m_device( device )
        , m_validationCacheEXT( validationCache )
        , m_allocator( static_cast<const AllocationCallbacks *>( allocator ) )
        , m_dispatcher( device.getDispatcher() )
      {
      }

      ValidationCacheEXT( std::nullptr_t ) {}

      ~ValidationCacheEXT()
      {
        clear();
      }

      ValidationCacheEXT()                             = delete;
      ValidationCacheEXT( ValidationCacheEXT const & ) = delete;

      ValidationCacheEXT( ValidationCacheEXT && rhs ) VULKAN_HPP_NOEXCEPT
        : m_device( exchange( rhs.m_device, {} ) )
        , m_validationCacheEXT( exchange( rhs.m_validationCacheEXT, {} ) )
        , m_allocator( exchange( rhs.m_allocator, {} ) )
        , m_dispatcher( exchange( rhs.m_dispatcher, nullptr ) )
      {
      }

      ValidationCacheEXT & operator=( ValidationCacheEXT const & ) = delete;

      ValidationCacheEXT & operator=( ValidationCacheEXT && rhs ) VULKAN_HPP_NOEXCEPT
      {
        if ( this != &rhs )
        {
          std::swap( m_device, rhs.m_device );
          std::swap( m_validationCacheEXT, rhs.m_validationCacheEXT );
          std::swap( m_allocator, rhs.m_allocator );
          std::swap( m_dispatcher, rhs.m_dispatcher );
        }
        return *this;
      }

      VULKAN_HPP_NAMESPACE::ValidationCacheEXT const & operator*() const & VULKAN_HPP_NOEXCEPT
      {
        return m_validationCacheEXT;
      }

      VULKAN_HPP_NAMESPACE::ValidationCacheEXT const && operator*() const && VULKAN_HPP_NOEXCEPT
      {
        return std::move( m_validationCacheEXT );
      }

      operator VULKAN_HPP_NAMESPACE::ValidationCacheEXT() const VULKAN_HPP_NOEXCEPT
      {
        return m_validationCacheEXT;
      }

      void clear() VULKAN_HPP_NOEXCEPT
      {
        if ( m_validationCacheEXT )
        {
          getDispatcher()->vkDestroyValidationCacheEXT( static_cast<VkDevice>( m_device ),
                                                        static_cast<VkValidationCacheEXT>( m_validationCacheEXT ),
                                                        reinterpret_cast<const VkAllocationCallbacks *>( m_allocator ) );
        }
        m_device             = nullptr;
        m_validationCacheEXT = nullptr;
        m_allocator          = nullptr;
        m_dispatcher         = nullptr;
      }

      VULKAN_HPP_NAMESPACE::ValidationCacheEXT release()
      {
        m_device     = nullptr;
        m_allocator  = nullptr;
        m_dispatcher = nullptr;
        return exchange( m_validationCacheEXT, nullptr );
      }

      VULKAN_HPP_NAMESPACE::Device getDevice() const
      {
        return m_device;
      }

      detail::DeviceDispatcher const * getDispatcher() const
      {
        VULKAN_HPP_ASSERT( m_dispatcher->getVkHeaderVersion() == VK_HEADER_VERSION );
        return m_dispatcher;
      }

      void swap( ValidationCacheEXT & rhs ) VULKAN_HPP_NOEXCEPT
      {
        std::swap( m_device, rhs.m_device );
        std::swap( m_validationCacheEXT, rhs.m_validationCacheEXT );
        std::swap( m_allocator, rhs.m_allocator );
        std::swap( m_dispatcher, rhs.m_dispatcher );
      }

      //=== VK_EXT_validation_cache ===

      // wrapper function for command vkMergeValidationCachesEXT, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkMergeValidationCachesEXT.html
      typename ResultValueType<void>::type merge( ArrayProxy<const VULKAN_HPP_NAMESPACE::ValidationCacheEXT> const & srcCaches ) const;

      // wrapper function for command vkGetValidationCacheDataEXT, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetValidationCacheDataEXT.html
      VULKAN_HPP_NODISCARD typename ResultValueType<std::vector<uint8_t>>::type getData() const;

    private:
      VULKAN_HPP_NAMESPACE::Device             m_device             = {};
      VULKAN_HPP_NAMESPACE::ValidationCacheEXT m_validationCacheEXT = {};
      const AllocationCallbacks *              m_allocator          = {};
      detail::DeviceDispatcher const *         m_dispatcher         = nullptr;
    };

    template <>
    struct isVulkanRAIIHandleType<ValidationCacheEXT>
    {
      static VULKAN_HPP_CONST_OR_CONSTEXPR bool value = true;
    };

    // wrapper class for handle VkVideoSessionKHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkVideoSessionKHR.html
    class VideoSessionKHR
    {
    public:
      using CType   = VkVideoSessionKHR;
      using CppType = VULKAN_HPP_NAMESPACE::VideoSessionKHR;

      static VULKAN_HPP_CONST_OR_CONSTEXPR ObjectType               objectType            = ObjectType::eVideoSessionKHR;
      static VULKAN_HPP_CONST_OR_CONSTEXPR DebugReportObjectTypeEXT debugReportObjectType = DebugReportObjectTypeEXT::eUnknown;

    public:
#  if !defined( VULKAN_HPP_NO_EXCEPTIONS )
      VideoSessionKHR( Device const & device, VideoSessionCreateInfoKHR const & createInfo, Optional<const AllocationCallbacks> allocator = nullptr )
      {
        *this = device.createVideoSessionKHR( createInfo, allocator );
      }
#  endif

      VideoSessionKHR( Device const & device, VkVideoSessionKHR videoSession, Optional<const AllocationCallbacks> allocator = nullptr )
        : m_device( device )
        , m_videoSessionKHR( videoSession )
        , m_allocator( static_cast<const AllocationCallbacks *>( allocator ) )
        , m_dispatcher( device.getDispatcher() )
      {
      }

      VideoSessionKHR( std::nullptr_t ) {}

      ~VideoSessionKHR()
      {
        clear();
      }

      VideoSessionKHR()                          = delete;
      VideoSessionKHR( VideoSessionKHR const & ) = delete;

      VideoSessionKHR( VideoSessionKHR && rhs ) VULKAN_HPP_NOEXCEPT
        : m_device( exchange( rhs.m_device, {} ) )
        , m_videoSessionKHR( exchange( rhs.m_videoSessionKHR, {} ) )
        , m_allocator( exchange( rhs.m_allocator, {} ) )
        , m_dispatcher( exchange( rhs.m_dispatcher, nullptr ) )
      {
      }

      VideoSessionKHR & operator=( VideoSessionKHR const & ) = delete;

      VideoSessionKHR & operator=( VideoSessionKHR && rhs ) VULKAN_HPP_NOEXCEPT
      {
        if ( this != &rhs )
        {
          std::swap( m_device, rhs.m_device );
          std::swap( m_videoSessionKHR, rhs.m_videoSessionKHR );
          std::swap( m_allocator, rhs.m_allocator );
          std::swap( m_dispatcher, rhs.m_dispatcher );
        }
        return *this;
      }

      VULKAN_HPP_NAMESPACE::VideoSessionKHR const & operator*() const & VULKAN_HPP_NOEXCEPT
      {
        return m_videoSessionKHR;
      }

      VULKAN_HPP_NAMESPACE::VideoSessionKHR const && operator*() const && VULKAN_HPP_NOEXCEPT
      {
        return std::move( m_videoSessionKHR );
      }

      operator VULKAN_HPP_NAMESPACE::VideoSessionKHR() const VULKAN_HPP_NOEXCEPT
      {
        return m_videoSessionKHR;
      }

      void clear() VULKAN_HPP_NOEXCEPT
      {
        if ( m_videoSessionKHR )
        {
          getDispatcher()->vkDestroyVideoSessionKHR( static_cast<VkDevice>( m_device ),
                                                     static_cast<VkVideoSessionKHR>( m_videoSessionKHR ),
                                                     reinterpret_cast<const VkAllocationCallbacks *>( m_allocator ) );
        }
        m_device          = nullptr;
        m_videoSessionKHR = nullptr;
        m_allocator       = nullptr;
        m_dispatcher      = nullptr;
      }

      VULKAN_HPP_NAMESPACE::VideoSessionKHR release()
      {
        m_device     = nullptr;
        m_allocator  = nullptr;
        m_dispatcher = nullptr;
        return exchange( m_videoSessionKHR, nullptr );
      }

      VULKAN_HPP_NAMESPACE::Device getDevice() const
      {
        return m_device;
      }

      detail::DeviceDispatcher const * getDispatcher() const
      {
        VULKAN_HPP_ASSERT( m_dispatcher->getVkHeaderVersion() == VK_HEADER_VERSION );
        return m_dispatcher;
      }

      void swap( VideoSessionKHR & rhs ) VULKAN_HPP_NOEXCEPT
      {
        std::swap( m_device, rhs.m_device );
        std::swap( m_videoSessionKHR, rhs.m_videoSessionKHR );
        std::swap( m_allocator, rhs.m_allocator );
        std::swap( m_dispatcher, rhs.m_dispatcher );
      }

      //=== VK_KHR_video_queue ===

      // wrapper function for command vkGetVideoSessionMemoryRequirementsKHR, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetVideoSessionMemoryRequirementsKHR.html
      VULKAN_HPP_NODISCARD typename ResultValueType<std::vector<VideoSessionMemoryRequirementsKHR>>::type getMemoryRequirements() const;

      // wrapper function for command vkBindVideoSessionMemoryKHR, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkBindVideoSessionMemoryKHR.html
      typename ResultValueType<void>::type bindMemory( ArrayProxy<const BindVideoSessionMemoryInfoKHR> const & bindSessionMemoryInfos ) const;

    private:
      VULKAN_HPP_NAMESPACE::Device          m_device          = {};
      VULKAN_HPP_NAMESPACE::VideoSessionKHR m_videoSessionKHR = {};
      const AllocationCallbacks *           m_allocator       = {};
      detail::DeviceDispatcher const *      m_dispatcher      = nullptr;
    };

    template <>
    struct isVulkanRAIIHandleType<VideoSessionKHR>
    {
      static VULKAN_HPP_CONST_OR_CONSTEXPR bool value = true;
    };

    // wrapper class for handle VkVideoSessionParametersKHR, see https://registry.khronos.org/vulkan/specs/latest/man/html/VkVideoSessionParametersKHR.html
    class VideoSessionParametersKHR
    {
    public:
      using CType   = VkVideoSessionParametersKHR;
      using CppType = VULKAN_HPP_NAMESPACE::VideoSessionParametersKHR;

      static VULKAN_HPP_CONST_OR_CONSTEXPR ObjectType               objectType            = ObjectType::eVideoSessionParametersKHR;
      static VULKAN_HPP_CONST_OR_CONSTEXPR DebugReportObjectTypeEXT debugReportObjectType = DebugReportObjectTypeEXT::eUnknown;

    public:
#  if !defined( VULKAN_HPP_NO_EXCEPTIONS )
      VideoSessionParametersKHR( Device const &                              device,
                                 VideoSessionParametersCreateInfoKHR const & createInfo,
                                 Optional<const AllocationCallbacks>         allocator = nullptr )
      {
        *this = device.createVideoSessionParametersKHR( createInfo, allocator );
      }
#  endif

      VideoSessionParametersKHR( Device const &                      device,
                                 VkVideoSessionParametersKHR         videoSessionParameters,
                                 Optional<const AllocationCallbacks> allocator = nullptr )
        : m_device( device )
        , m_videoSessionParametersKHR( videoSessionParameters )
        , m_allocator( static_cast<const AllocationCallbacks *>( allocator ) )
        , m_dispatcher( device.getDispatcher() )
      {
      }

      VideoSessionParametersKHR( std::nullptr_t ) {}

      ~VideoSessionParametersKHR()
      {
        clear();
      }

      VideoSessionParametersKHR()                                    = delete;
      VideoSessionParametersKHR( VideoSessionParametersKHR const & ) = delete;

      VideoSessionParametersKHR( VideoSessionParametersKHR && rhs ) VULKAN_HPP_NOEXCEPT
        : m_device( exchange( rhs.m_device, {} ) )
        , m_videoSessionParametersKHR( exchange( rhs.m_videoSessionParametersKHR, {} ) )
        , m_allocator( exchange( rhs.m_allocator, {} ) )
        , m_dispatcher( exchange( rhs.m_dispatcher, nullptr ) )
      {
      }

      VideoSessionParametersKHR & operator=( VideoSessionParametersKHR const & ) = delete;

      VideoSessionParametersKHR & operator=( VideoSessionParametersKHR && rhs ) VULKAN_HPP_NOEXCEPT
      {
        if ( this != &rhs )
        {
          std::swap( m_device, rhs.m_device );
          std::swap( m_videoSessionParametersKHR, rhs.m_videoSessionParametersKHR );
          std::swap( m_allocator, rhs.m_allocator );
          std::swap( m_dispatcher, rhs.m_dispatcher );
        }
        return *this;
      }

      VULKAN_HPP_NAMESPACE::VideoSessionParametersKHR const & operator*() const & VULKAN_HPP_NOEXCEPT
      {
        return m_videoSessionParametersKHR;
      }

      VULKAN_HPP_NAMESPACE::VideoSessionParametersKHR const && operator*() const && VULKAN_HPP_NOEXCEPT
      {
        return std::move( m_videoSessionParametersKHR );
      }

      operator VULKAN_HPP_NAMESPACE::VideoSessionParametersKHR() const VULKAN_HPP_NOEXCEPT
      {
        return m_videoSessionParametersKHR;
      }

      void clear() VULKAN_HPP_NOEXCEPT
      {
        if ( m_videoSessionParametersKHR )
        {
          getDispatcher()->vkDestroyVideoSessionParametersKHR( static_cast<VkDevice>( m_device ),
                                                               static_cast<VkVideoSessionParametersKHR>( m_videoSessionParametersKHR ),
                                                               reinterpret_cast<const VkAllocationCallbacks *>( m_allocator ) );
        }
        m_device                    = nullptr;
        m_videoSessionParametersKHR = nullptr;
        m_allocator                 = nullptr;
        m_dispatcher                = nullptr;
      }

      VULKAN_HPP_NAMESPACE::VideoSessionParametersKHR release()
      {
        m_device     = nullptr;
        m_allocator  = nullptr;
        m_dispatcher = nullptr;
        return exchange( m_videoSessionParametersKHR, nullptr );
      }

      VULKAN_HPP_NAMESPACE::Device getDevice() const
      {
        return m_device;
      }

      detail::DeviceDispatcher const * getDispatcher() const
      {
        VULKAN_HPP_ASSERT( m_dispatcher->getVkHeaderVersion() == VK_HEADER_VERSION );
        return m_dispatcher;
      }

      void swap( VideoSessionParametersKHR & rhs ) VULKAN_HPP_NOEXCEPT
      {
        std::swap( m_device, rhs.m_device );
        std::swap( m_videoSessionParametersKHR, rhs.m_videoSessionParametersKHR );
        std::swap( m_allocator, rhs.m_allocator );
        std::swap( m_dispatcher, rhs.m_dispatcher );
      }

      //=== VK_KHR_video_queue ===

      // wrapper function for command vkUpdateVideoSessionParametersKHR, see
      // https://registry.khronos.org/vulkan/specs/latest/man/html/vkUpdateVideoSessionParametersKHR.html
      typename ResultValueType<void>::type update( const VideoSessionParametersUpdateInfoKHR & updateInfo ) const;

    private:
      VULKAN_HPP_NAMESPACE::Device                    m_device                    = {};
      VULKAN_HPP_NAMESPACE::VideoSessionParametersKHR m_videoSessionParametersKHR = {};
      const AllocationCallbacks *                     m_allocator                 = {};
      detail::DeviceDispatcher const *                m_dispatcher                = nullptr;
    };

    template <>
    struct isVulkanRAIIHandleType<VideoSessionParametersKHR>
    {
      static VULKAN_HPP_CONST_OR_CONSTEXPR bool value = true;
    };

    // operators to compare VULKAN_HPP_NAMESPACE::raii-handles
#  if defined( VULKAN_HPP_HAS_SPACESHIP_OPERATOR )
    template <typename T, typename std::enable_if<isVulkanRAIIHandleType<T>::value, bool>::type = 0>
    auto operator<=>( T const & a, T const & b ) VULKAN_HPP_NOEXCEPT
    {
      return *a <=> *b;
    }
#  else
    template <typename T, typename std::enable_if<isVulkanRAIIHandleType<T>::value, bool>::type = 0>
    bool operator<( T const & a, T const & b ) VULKAN_HPP_NOEXCEPT
    {
      return *a < *b;
    }
#  endif

    template <typename T, typename std::enable_if<isVulkanRAIIHandleType<T>::value, bool>::type = 0>
    bool operator==( T const & a, T const & b ) VULKAN_HPP_NOEXCEPT
    {
      return *a == *b;
    }

    template <typename T, typename std::enable_if<isVulkanRAIIHandleType<T>::value, bool>::type = 0>
    bool operator!=( T const & a, T const & b ) VULKAN_HPP_NOEXCEPT
    {
      return *a != *b;
    }

    template <typename T, typename std::enable_if<isVulkanRAIIHandleType<T>::value, bool>::type = 0>
    bool operator==( const T & v, std::nullptr_t ) VULKAN_HPP_NOEXCEPT
    {
      return !*v;
    }

    template <typename T, typename std::enable_if<isVulkanRAIIHandleType<T>::value, bool>::type = 0>
    bool operator==( std::nullptr_t, const T & v ) VULKAN_HPP_NOEXCEPT
    {
      return !*v;
    }

    template <typename T, typename std::enable_if<isVulkanRAIIHandleType<T>::value, bool>::type = 0>
    bool operator!=( const T & v, std::nullptr_t ) VULKAN_HPP_NOEXCEPT
    {
      return *v;
    }

    template <typename T, typename std::enable_if<isVulkanRAIIHandleType<T>::value, bool>::type = 0>
    bool operator!=( std::nullptr_t, const T & v ) VULKAN_HPP_NOEXCEPT
    {
      return *v;
    }

    //===========================
    //=== COMMAND Definitions ===
    //===========================

    //=== VK_VERSION_1_0 ===

    // wrapper function for command vkCreateInstance, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateInstance.html
    VULKAN_HPP_NODISCARD VULKAN_HPP_INLINE typename ResultValueType<Instance>::type
                         Context::createInstance( InstanceCreateInfo const &          createInfo,
                               Optional<const AllocationCallbacks> allocator ) const VULKAN_HPP_NOEXCEPT_WHEN_NO_EXCEPTIONS
    {
      VULKAN_HPP_NAMESPACE::Instance instance;
      Result result = static_cast<Result>( getDispatcher()->vkCreateInstance( reinterpret_cast<const VkInstanceCreateInfo *>( &createInfo ),
                                                                              reinterpret_cast<const VkAllocationCallbacks *>( allocator.get() ),
                                                                              reinterpret_cast<VkInstance *>( &instance ) ) );
      VULKAN_HPP_NAMESPACE::detail::resultCheck( result, VULKAN_HPP_RAII_NAMESPACE_STRING "::Context::createInstance" );
      return VULKAN_HPP_NAMESPACE::detail::createResultValueType( result, Instance( *this, *reinterpret_cast<VkInstance *>( &instance ), allocator ) );
    }

    // wrapper function for command vkEnumeratePhysicalDevices, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkEnumeratePhysicalDevices.html
    VULKAN_HPP_NODISCARD VULKAN_HPP_INLINE typename ResultValueType<std::vector<PhysicalDevice>>::type Instance::enumeratePhysicalDevices() const
    {
      std::vector<VULKAN_HPP_NAMESPACE::PhysicalDevice> physicalDevices;
      uint32_t                                          physicalDeviceCount;
      Result                                            result;
      do
      {
        result = static_cast<Result>( getDispatcher()->vkEnumeratePhysicalDevices( static_cast<VkInstance>( m_instance ), &physicalDeviceCount, nullptr ) );
        if ( ( result == Result::eSuccess ) && physicalDeviceCount )
        {
          physicalDevices.resize( physicalDeviceCount );
          result = static_cast<Result>( getDispatcher()->vkEnumeratePhysicalDevices(
            static_cast<VkInstance>( m_instance ), &physicalDeviceCount, reinterpret_cast<VkPhysicalDevice *>( physicalDevices.data() ) ) );
        }
      } while ( result == Result::eIncomplete );
      VULKAN_HPP_NAMESPACE::detail::resultCheck( result, VULKAN_HPP_RAII_NAMESPACE_STRING "::Instance::enumeratePhysicalDevices" );
      std::vector<PhysicalDevice> physicalDevicesRAII;
      if ( result == Result::eSuccess )
      {
        physicalDevicesRAII.reserve( physicalDevices.size() );
        for ( auto & physicalDevice : physicalDevices )
        {
          physicalDevicesRAII.emplace_back( *this, *reinterpret_cast<VkPhysicalDevice *>( &physicalDevice ) );
        }
      }
      return VULKAN_HPP_NAMESPACE::detail::createResultValueType( result, std::move( physicalDevicesRAII ) );
    }

    // wrapper function for command vkGetPhysicalDeviceFeatures, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetPhysicalDeviceFeatures.html
    VULKAN_HPP_NODISCARD VULKAN_HPP_INLINE PhysicalDeviceFeatures PhysicalDevice::getFeatures() const VULKAN_HPP_NOEXCEPT
    {
      VULKAN_HPP_ASSERT( getDispatcher()->vkGetPhysicalDeviceFeatures && "Function <vkGetPhysicalDeviceFeatures> requires <VK_VERSION_1_0>" );

      PhysicalDeviceFeatures features;
      getDispatcher()->vkGetPhysicalDeviceFeatures( static_cast<VkPhysicalDevice>( m_physicalDevice ),
                                                    reinterpret_cast<VkPhysicalDeviceFeatures *>( &features ) );

      return features;
    }

    // wrapper function for command vkGetPhysicalDeviceFormatProperties, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetPhysicalDeviceFormatProperties.html
    VULKAN_HPP_NODISCARD VULKAN_HPP_INLINE FormatProperties PhysicalDevice::getFormatProperties( Format format ) const VULKAN_HPP_NOEXCEPT
    {
      VULKAN_HPP_ASSERT( getDispatcher()->vkGetPhysicalDeviceFormatProperties && "Function <vkGetPhysicalDeviceFormatProperties> requires <VK_VERSION_1_0>" );

      FormatProperties formatProperties;
      getDispatcher()->vkGetPhysicalDeviceFormatProperties(
        static_cast<VkPhysicalDevice>( m_physicalDevice ), static_cast<VkFormat>( format ), reinterpret_cast<VkFormatProperties *>( &formatProperties ) );

      return formatProperties;
    }

    // wrapper function for command vkGetPhysicalDeviceImageFormatProperties, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetPhysicalDeviceImageFormatProperties.html
    VULKAN_HPP_NODISCARD VULKAN_HPP_INLINE typename ResultValueType<ImageFormatProperties>::type
      PhysicalDevice::getImageFormatProperties( Format format, ImageType type, ImageTiling tiling, ImageUsageFlags usage, ImageCreateFlags flags ) const
    {
      VULKAN_HPP_ASSERT( getDispatcher()->vkGetPhysicalDeviceImageFormatProperties &&
                         "Function <vkGetPhysicalDeviceImageFormatProperties> requires <VK_VERSION_1_0>" );

      ImageFormatProperties imageFormatProperties;
      Result                result = static_cast<Result>(
        getDispatcher()->vkGetPhysicalDeviceImageFormatProperties( static_cast<VkPhysicalDevice>( m_physicalDevice ),
                                                                   static_cast<VkFormat>( format ),
                                                                   static_cast<VkImageType>( type ),
                                                                   static_cast<VkImageTiling>( tiling ),
                                                                   static_cast<VkImageUsageFlags>( usage ),
                                                                   static_cast<VkImageCreateFlags>( flags ),
                                                                   reinterpret_cast<VkImageFormatProperties *>( &imageFormatProperties ) ) );
      VULKAN_HPP_NAMESPACE::detail::resultCheck( result, VULKAN_HPP_RAII_NAMESPACE_STRING "::PhysicalDevice::getImageFormatProperties" );

      return VULKAN_HPP_NAMESPACE::detail::createResultValueType( result, std::move( imageFormatProperties ) );
    }

    // wrapper function for command vkGetPhysicalDeviceProperties, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetPhysicalDeviceProperties.html
    VULKAN_HPP_NODISCARD VULKAN_HPP_INLINE PhysicalDeviceProperties PhysicalDevice::getProperties() const VULKAN_HPP_NOEXCEPT
    {
      VULKAN_HPP_ASSERT( getDispatcher()->vkGetPhysicalDeviceProperties && "Function <vkGetPhysicalDeviceProperties> requires <VK_VERSION_1_0>" );

      PhysicalDeviceProperties properties;
      getDispatcher()->vkGetPhysicalDeviceProperties( static_cast<VkPhysicalDevice>( m_physicalDevice ),
                                                      reinterpret_cast<VkPhysicalDeviceProperties *>( &properties ) );

      return properties;
    }

    // wrapper function for command vkGetPhysicalDeviceQueueFamilyProperties, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetPhysicalDeviceQueueFamilyProperties.html
    VULKAN_HPP_NODISCARD VULKAN_HPP_INLINE std::vector<QueueFamilyProperties> PhysicalDevice::getQueueFamilyProperties() const
    {
      VULKAN_HPP_ASSERT( getDispatcher()->vkGetPhysicalDeviceQueueFamilyProperties &&
                         "Function <vkGetPhysicalDeviceQueueFamilyProperties> requires <VK_VERSION_1_0>" );

      std::vector<QueueFamilyProperties> queueFamilyProperties;
      uint32_t                           queueFamilyPropertyCount;
      getDispatcher()->vkGetPhysicalDeviceQueueFamilyProperties( static_cast<VkPhysicalDevice>( m_physicalDevice ), &queueFamilyPropertyCount, nullptr );
      queueFamilyProperties.resize( queueFamilyPropertyCount );
      getDispatcher()->vkGetPhysicalDeviceQueueFamilyProperties( static_cast<VkPhysicalDevice>( m_physicalDevice ),
                                                                 &queueFamilyPropertyCount,
                                                                 reinterpret_cast<VkQueueFamilyProperties *>( queueFamilyProperties.data() ) );

      VULKAN_HPP_ASSERT( queueFamilyPropertyCount <= queueFamilyProperties.size() );
      if ( queueFamilyPropertyCount < queueFamilyProperties.size() )
      {
        queueFamilyProperties.resize( queueFamilyPropertyCount );
      }
      return queueFamilyProperties;
    }

    // wrapper function for command vkGetPhysicalDeviceMemoryProperties, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetPhysicalDeviceMemoryProperties.html
    VULKAN_HPP_NODISCARD VULKAN_HPP_INLINE PhysicalDeviceMemoryProperties PhysicalDevice::getMemoryProperties() const VULKAN_HPP_NOEXCEPT
    {
      VULKAN_HPP_ASSERT( getDispatcher()->vkGetPhysicalDeviceMemoryProperties && "Function <vkGetPhysicalDeviceMemoryProperties> requires <VK_VERSION_1_0>" );

      PhysicalDeviceMemoryProperties memoryProperties;
      getDispatcher()->vkGetPhysicalDeviceMemoryProperties( static_cast<VkPhysicalDevice>( m_physicalDevice ),
                                                            reinterpret_cast<VkPhysicalDeviceMemoryProperties *>( &memoryProperties ) );

      return memoryProperties;
    }

    // wrapper function for command vkGetInstanceProcAddr, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetInstanceProcAddr.html
    VULKAN_HPP_NODISCARD VULKAN_HPP_INLINE PFN_VoidFunction Instance::getProcAddr( const std::string & name ) const VULKAN_HPP_NOEXCEPT
    {
      VULKAN_HPP_ASSERT( getDispatcher()->vkGetInstanceProcAddr && "Function <vkGetInstanceProcAddr> requires <VK_VERSION_1_0>" );

      PFN_vkVoidFunction result = getDispatcher()->vkGetInstanceProcAddr( static_cast<VkInstance>( m_instance ), name.c_str() );

      return result;
    }

    // wrapper function for command vkGetDeviceProcAddr, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetDeviceProcAddr.html
    VULKAN_HPP_NODISCARD VULKAN_HPP_INLINE PFN_VoidFunction Device::getProcAddr( const std::string & name ) const VULKAN_HPP_NOEXCEPT
    {
      VULKAN_HPP_ASSERT( getDispatcher()->vkGetDeviceProcAddr && "Function <vkGetDeviceProcAddr> requires <VK_VERSION_1_0>" );

      PFN_vkVoidFunction result = getDispatcher()->vkGetDeviceProcAddr( static_cast<VkDevice>( m_device ), name.c_str() );

      return result;
    }

    // wrapper function for command vkCreateDevice, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateDevice.html
    VULKAN_HPP_NODISCARD VULKAN_HPP_INLINE typename ResultValueType<Device>::type
                         PhysicalDevice::createDevice( DeviceCreateInfo const &            createInfo,
                                    Optional<const AllocationCallbacks> allocator ) const VULKAN_HPP_NOEXCEPT_WHEN_NO_EXCEPTIONS
    {
      VULKAN_HPP_NAMESPACE::Device device;
      Result                       result = static_cast<Result>( getDispatcher()->vkCreateDevice( static_cast<VkPhysicalDevice>( m_physicalDevice ),
                                                                            reinterpret_cast<const VkDeviceCreateInfo *>( &createInfo ),
                                                                            reinterpret_cast<const VkAllocationCallbacks *>( allocator.get() ),
                                                                            reinterpret_cast<VkDevice *>( &device ) ) );
      VULKAN_HPP_NAMESPACE::detail::resultCheck( result, VULKAN_HPP_RAII_NAMESPACE_STRING "::PhysicalDevice::createDevice" );
      return VULKAN_HPP_NAMESPACE::detail::createResultValueType( result, Device( *this, *reinterpret_cast<VkDevice *>( &device ), allocator ) );
    }

    // wrapper function for command vkEnumerateInstanceExtensionProperties, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkEnumerateInstanceExtensionProperties.html
    VULKAN_HPP_NODISCARD VULKAN_HPP_INLINE typename ResultValueType<std::vector<ExtensionProperties>>::type
                         Context::enumerateInstanceExtensionProperties( Optional<const std::string> layerName ) const
    {
      VULKAN_HPP_ASSERT( getDispatcher()->vkEnumerateInstanceExtensionProperties &&
                         "Function <vkEnumerateInstanceExtensionProperties> requires <VK_VERSION_1_0>" );

      std::vector<ExtensionProperties> properties;
      uint32_t                         propertyCount;
      Result                           result;
      do
      {
        result =
          static_cast<Result>( getDispatcher()->vkEnumerateInstanceExtensionProperties( layerName ? layerName->c_str() : nullptr, &propertyCount, nullptr ) );
        if ( ( result == Result::eSuccess ) && propertyCount )
        {
          properties.resize( propertyCount );
          result = static_cast<Result>( getDispatcher()->vkEnumerateInstanceExtensionProperties(
            layerName ? layerName->c_str() : nullptr, &propertyCount, reinterpret_cast<VkExtensionProperties *>( properties.data() ) ) );
        }
      } while ( result == Result::eIncomplete );
      VULKAN_HPP_NAMESPACE::detail::resultCheck( result, VULKAN_HPP_RAII_NAMESPACE_STRING "::Context::enumerateInstanceExtensionProperties" );
      VULKAN_HPP_ASSERT( propertyCount <= properties.size() );
      if ( propertyCount < properties.size() )
      {
        properties.resize( propertyCount );
      }
      return VULKAN_HPP_NAMESPACE::detail::createResultValueType( result, std::move( properties ) );
    }

    // wrapper function for command vkEnumerateDeviceExtensionProperties, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkEnumerateDeviceExtensionProperties.html
    VULKAN_HPP_NODISCARD VULKAN_HPP_INLINE typename ResultValueType<std::vector<ExtensionProperties>>::type
                         PhysicalDevice::enumerateDeviceExtensionProperties( Optional<const std::string> layerName ) const
    {
      VULKAN_HPP_ASSERT( getDispatcher()->vkEnumerateDeviceExtensionProperties && "Function <vkEnumerateDeviceExtensionProperties> requires <VK_VERSION_1_0>" );

      std::vector<ExtensionProperties> properties;
      uint32_t                         propertyCount;
      Result                           result;
      do
      {
        result = static_cast<Result>( getDispatcher()->vkEnumerateDeviceExtensionProperties(
          static_cast<VkPhysicalDevice>( m_physicalDevice ), layerName ? layerName->c_str() : nullptr, &propertyCount, nullptr ) );
        if ( ( result == Result::eSuccess ) && propertyCount )
        {
          properties.resize( propertyCount );
          result =
            static_cast<Result>( getDispatcher()->vkEnumerateDeviceExtensionProperties( static_cast<VkPhysicalDevice>( m_physicalDevice ),
                                                                                        layerName ? layerName->c_str() : nullptr,
                                                                                        &propertyCount,
                                                                                        reinterpret_cast<VkExtensionProperties *>( properties.data() ) ) );
        }
      } while ( result == Result::eIncomplete );
      VULKAN_HPP_NAMESPACE::detail::resultCheck( result, VULKAN_HPP_RAII_NAMESPACE_STRING "::PhysicalDevice::enumerateDeviceExtensionProperties" );
      VULKAN_HPP_ASSERT( propertyCount <= properties.size() );
      if ( propertyCount < properties.size() )
      {
        properties.resize( propertyCount );
      }
      return VULKAN_HPP_NAMESPACE::detail::createResultValueType( result, std::move( properties ) );
    }

    // wrapper function for command vkEnumerateInstanceLayerProperties, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkEnumerateInstanceLayerProperties.html
    VULKAN_HPP_NODISCARD VULKAN_HPP_INLINE typename ResultValueType<std::vector<LayerProperties>>::type Context::enumerateInstanceLayerProperties() const
    {
      VULKAN_HPP_ASSERT( getDispatcher()->vkEnumerateInstanceLayerProperties && "Function <vkEnumerateInstanceLayerProperties> requires <VK_VERSION_1_0>" );

      std::vector<LayerProperties> properties;
      uint32_t                     propertyCount;
      Result                       result;
      do
      {
        result = static_cast<Result>( getDispatcher()->vkEnumerateInstanceLayerProperties( &propertyCount, nullptr ) );
        if ( ( result == Result::eSuccess ) && propertyCount )
        {
          properties.resize( propertyCount );
          result = static_cast<Result>(
            getDispatcher()->vkEnumerateInstanceLayerProperties( &propertyCount, reinterpret_cast<VkLayerProperties *>( properties.data() ) ) );
        }
      } while ( result == Result::eIncomplete );
      VULKAN_HPP_NAMESPACE::detail::resultCheck( result, VULKAN_HPP_RAII_NAMESPACE_STRING "::Context::enumerateInstanceLayerProperties" );
      VULKAN_HPP_ASSERT( propertyCount <= properties.size() );
      if ( propertyCount < properties.size() )
      {
        properties.resize( propertyCount );
      }
      return VULKAN_HPP_NAMESPACE::detail::createResultValueType( result, std::move( properties ) );
    }

    // wrapper function for command vkEnumerateDeviceLayerProperties, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkEnumerateDeviceLayerProperties.html
    VULKAN_HPP_NODISCARD VULKAN_HPP_INLINE typename ResultValueType<std::vector<LayerProperties>>::type PhysicalDevice::enumerateDeviceLayerProperties() const
    {
      VULKAN_HPP_ASSERT( getDispatcher()->vkEnumerateDeviceLayerProperties && "Function <vkEnumerateDeviceLayerProperties> requires <VK_VERSION_1_0>" );

      std::vector<LayerProperties> properties;
      uint32_t                     propertyCount;
      Result                       result;
      do
      {
        result = static_cast<Result>(
          getDispatcher()->vkEnumerateDeviceLayerProperties( static_cast<VkPhysicalDevice>( m_physicalDevice ), &propertyCount, nullptr ) );
        if ( ( result == Result::eSuccess ) && propertyCount )
        {
          properties.resize( propertyCount );
          result = static_cast<Result>( getDispatcher()->vkEnumerateDeviceLayerProperties(
            static_cast<VkPhysicalDevice>( m_physicalDevice ), &propertyCount, reinterpret_cast<VkLayerProperties *>( properties.data() ) ) );
        }
      } while ( result == Result::eIncomplete );
      VULKAN_HPP_NAMESPACE::detail::resultCheck( result, VULKAN_HPP_RAII_NAMESPACE_STRING "::PhysicalDevice::enumerateDeviceLayerProperties" );
      VULKAN_HPP_ASSERT( propertyCount <= properties.size() );
      if ( propertyCount < properties.size() )
      {
        properties.resize( propertyCount );
      }
      return VULKAN_HPP_NAMESPACE::detail::createResultValueType( result, std::move( properties ) );
    }

    // wrapper function for command vkGetDeviceQueue, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetDeviceQueue.html
    VULKAN_HPP_NODISCARD VULKAN_HPP_INLINE Queue Device::getQueue( uint32_t queueFamilyIndex, uint32_t queueIndex ) const VULKAN_HPP_NOEXCEPT_WHEN_NO_EXCEPTIONS
    {
      VULKAN_HPP_NAMESPACE::Queue queue;
      getDispatcher()->vkGetDeviceQueue( static_cast<VkDevice>( m_device ), queueFamilyIndex, queueIndex, reinterpret_cast<VkQueue *>( &queue ) );

      return Queue( *this, *reinterpret_cast<VkQueue *>( &queue ) );
    }

    // wrapper function for command vkQueueSubmit, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkQueueSubmit.html
    VULKAN_HPP_INLINE typename ResultValueType<void>::type Queue::submit( ArrayProxy<const SubmitInfo> const & submits,
                                                                          VULKAN_HPP_NAMESPACE::Fence          fence ) const
    {
      VULKAN_HPP_ASSERT( getDispatcher()->vkQueueSubmit && "Function <vkQueueSubmit> requires <VK_VERSION_1_0>" );

      Result result = static_cast<Result>( getDispatcher()->vkQueueSubmit(
        static_cast<VkQueue>( m_queue ), submits.size(), reinterpret_cast<const VkSubmitInfo *>( submits.data() ), static_cast<VkFence>( fence ) ) );
      VULKAN_HPP_NAMESPACE::detail::resultCheck( result, VULKAN_HPP_RAII_NAMESPACE_STRING "::Queue::submit" );

      return VULKAN_HPP_NAMESPACE::detail::createResultValueType( result );
    }

    // wrapper function for command vkQueueWaitIdle, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkQueueWaitIdle.html
    VULKAN_HPP_INLINE typename ResultValueType<void>::type Queue::waitIdle() const
    {
      VULKAN_HPP_ASSERT( getDispatcher()->vkQueueWaitIdle && "Function <vkQueueWaitIdle> requires <VK_VERSION_1_0>" );

      Result result = static_cast<Result>( getDispatcher()->vkQueueWaitIdle( static_cast<VkQueue>( m_queue ) ) );
      VULKAN_HPP_NAMESPACE::detail::resultCheck( result, VULKAN_HPP_RAII_NAMESPACE_STRING "::Queue::waitIdle" );

      return VULKAN_HPP_NAMESPACE::detail::createResultValueType( result );
    }

    // wrapper function for command vkDeviceWaitIdle, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkDeviceWaitIdle.html
    VULKAN_HPP_INLINE typename ResultValueType<void>::type Device::waitIdle() const
    {
      VULKAN_HPP_ASSERT( getDispatcher()->vkDeviceWaitIdle && "Function <vkDeviceWaitIdle> requires <VK_VERSION_1_0>" );

      Result result = static_cast<Result>( getDispatcher()->vkDeviceWaitIdle( static_cast<VkDevice>( m_device ) ) );
      VULKAN_HPP_NAMESPACE::detail::resultCheck( result, VULKAN_HPP_RAII_NAMESPACE_STRING "::Device::waitIdle" );

      return VULKAN_HPP_NAMESPACE::detail::createResultValueType( result );
    }

    // wrapper function for command vkAllocateMemory, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkAllocateMemory.html
    VULKAN_HPP_NODISCARD VULKAN_HPP_INLINE typename ResultValueType<DeviceMemory>::type
                         Device::allocateMemory( MemoryAllocateInfo const &          allocateInfo,
                              Optional<const AllocationCallbacks> allocator ) const VULKAN_HPP_NOEXCEPT_WHEN_NO_EXCEPTIONS
    {
      VULKAN_HPP_NAMESPACE::DeviceMemory memory;
      Result                             result = static_cast<Result>( getDispatcher()->vkAllocateMemory( static_cast<VkDevice>( m_device ),
                                                                              reinterpret_cast<const VkMemoryAllocateInfo *>( &allocateInfo ),
                                                                              reinterpret_cast<const VkAllocationCallbacks *>( allocator.get() ),
                                                                              reinterpret_cast<VkDeviceMemory *>( &memory ) ) );
      VULKAN_HPP_NAMESPACE::detail::resultCheck( result, VULKAN_HPP_RAII_NAMESPACE_STRING "::Device::allocateMemory" );
      return VULKAN_HPP_NAMESPACE::detail::createResultValueType( result, DeviceMemory( *this, *reinterpret_cast<VkDeviceMemory *>( &memory ), allocator ) );
    }

    // wrapper function for command vkMapMemory, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkMapMemory.html
    VULKAN_HPP_NODISCARD VULKAN_HPP_INLINE typename ResultValueType<void *>::type
                         DeviceMemory::mapMemory( DeviceSize offset, DeviceSize size, MemoryMapFlags flags ) const
    {
      VULKAN_HPP_ASSERT( getDispatcher()->vkMapMemory && "Function <vkMapMemory> requires <VK_VERSION_1_0>" );

      void * pData;
      Result result = static_cast<Result>( getDispatcher()->vkMapMemory( static_cast<VkDevice>( m_device ),
                                                                         static_cast<VkDeviceMemory>( m_deviceMemory ),
                                                                         static_cast<VkDeviceSize>( offset ),
                                                                         static_cast<VkDeviceSize>( size ),
                                                                         static_cast<VkMemoryMapFlags>( flags ),
                                                                         &pData ) );
      VULKAN_HPP_NAMESPACE::detail::resultCheck( result, VULKAN_HPP_RAII_NAMESPACE_STRING "::DeviceMemory::mapMemory" );

      return VULKAN_HPP_NAMESPACE::detail::createResultValueType( result, std::move( pData ) );
    }

    // wrapper function for command vkUnmapMemory, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkUnmapMemory.html
    VULKAN_HPP_INLINE void DeviceMemory::unmapMemory() const VULKAN_HPP_NOEXCEPT
    {
      VULKAN_HPP_ASSERT( getDispatcher()->vkUnmapMemory && "Function <vkUnmapMemory> requires <VK_VERSION_1_0>" );

      getDispatcher()->vkUnmapMemory( static_cast<VkDevice>( m_device ), static_cast<VkDeviceMemory>( m_deviceMemory ) );
    }

    // wrapper function for command vkFlushMappedMemoryRanges, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkFlushMappedMemoryRanges.html
    VULKAN_HPP_INLINE typename ResultValueType<void>::type Device::flushMappedMemoryRanges( ArrayProxy<const MappedMemoryRange> const & memoryRanges ) const
    {
      VULKAN_HPP_ASSERT( getDispatcher()->vkFlushMappedMemoryRanges && "Function <vkFlushMappedMemoryRanges> requires <VK_VERSION_1_0>" );

      Result result = static_cast<Result>( getDispatcher()->vkFlushMappedMemoryRanges(
        static_cast<VkDevice>( m_device ), memoryRanges.size(), reinterpret_cast<const VkMappedMemoryRange *>( memoryRanges.data() ) ) );
      VULKAN_HPP_NAMESPACE::detail::resultCheck( result, VULKAN_HPP_RAII_NAMESPACE_STRING "::Device::flushMappedMemoryRanges" );

      return VULKAN_HPP_NAMESPACE::detail::createResultValueType( result );
    }

    // wrapper function for command vkInvalidateMappedMemoryRanges, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkInvalidateMappedMemoryRanges.html
    VULKAN_HPP_INLINE typename ResultValueType<void>::type
      Device::invalidateMappedMemoryRanges( ArrayProxy<const MappedMemoryRange> const & memoryRanges ) const
    {
      VULKAN_HPP_ASSERT( getDispatcher()->vkInvalidateMappedMemoryRanges && "Function <vkInvalidateMappedMemoryRanges> requires <VK_VERSION_1_0>" );

      Result result = static_cast<Result>( getDispatcher()->vkInvalidateMappedMemoryRanges(
        static_cast<VkDevice>( m_device ), memoryRanges.size(), reinterpret_cast<const VkMappedMemoryRange *>( memoryRanges.data() ) ) );
      VULKAN_HPP_NAMESPACE::detail::resultCheck( result, VULKAN_HPP_RAII_NAMESPACE_STRING "::Device::invalidateMappedMemoryRanges" );

      return VULKAN_HPP_NAMESPACE::detail::createResultValueType( result );
    }

    // wrapper function for command vkGetDeviceMemoryCommitment, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetDeviceMemoryCommitment.html
    VULKAN_HPP_NODISCARD VULKAN_HPP_INLINE DeviceSize DeviceMemory::getCommitment() const VULKAN_HPP_NOEXCEPT
    {
      VULKAN_HPP_ASSERT( getDispatcher()->vkGetDeviceMemoryCommitment && "Function <vkGetDeviceMemoryCommitment> requires <VK_VERSION_1_0>" );

      DeviceSize committedMemoryInBytes;
      getDispatcher()->vkGetDeviceMemoryCommitment(
        static_cast<VkDevice>( m_device ), static_cast<VkDeviceMemory>( m_deviceMemory ), reinterpret_cast<VkDeviceSize *>( &committedMemoryInBytes ) );

      return committedMemoryInBytes;
    }

    // wrapper function for command vkBindBufferMemory, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkBindBufferMemory.html
    VULKAN_HPP_INLINE typename ResultValueType<void>::type Buffer::bindMemory( VULKAN_HPP_NAMESPACE::DeviceMemory memory, DeviceSize memoryOffset ) const
    {
      VULKAN_HPP_ASSERT( getDispatcher()->vkBindBufferMemory && "Function <vkBindBufferMemory> requires <VK_VERSION_1_0>" );

      Result result = static_cast<Result>( getDispatcher()->vkBindBufferMemory( static_cast<VkDevice>( m_device ),
                                                                                static_cast<VkBuffer>( m_buffer ),
                                                                                static_cast<VkDeviceMemory>( memory ),
                                                                                static_cast<VkDeviceSize>( memoryOffset ) ) );
      VULKAN_HPP_NAMESPACE::detail::resultCheck( result, VULKAN_HPP_RAII_NAMESPACE_STRING "::Buffer::bindMemory" );

      return VULKAN_HPP_NAMESPACE::detail::createResultValueType( result );
    }

    // wrapper function for command vkBindImageMemory, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkBindImageMemory.html
    VULKAN_HPP_INLINE typename ResultValueType<void>::type Image::bindMemory( VULKAN_HPP_NAMESPACE::DeviceMemory memory, DeviceSize memoryOffset ) const
    {
      VULKAN_HPP_ASSERT( getDispatcher()->vkBindImageMemory && "Function <vkBindImageMemory> requires <VK_VERSION_1_0>" );

      Result result = static_cast<Result>( getDispatcher()->vkBindImageMemory( static_cast<VkDevice>( m_device ),
                                                                               static_cast<VkImage>( m_image ),
                                                                               static_cast<VkDeviceMemory>( memory ),
                                                                               static_cast<VkDeviceSize>( memoryOffset ) ) );
      VULKAN_HPP_NAMESPACE::detail::resultCheck( result, VULKAN_HPP_RAII_NAMESPACE_STRING "::Image::bindMemory" );

      return VULKAN_HPP_NAMESPACE::detail::createResultValueType( result );
    }

    // wrapper function for command vkGetBufferMemoryRequirements, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetBufferMemoryRequirements.html
    VULKAN_HPP_NODISCARD VULKAN_HPP_INLINE MemoryRequirements Buffer::getMemoryRequirements() const VULKAN_HPP_NOEXCEPT
    {
      VULKAN_HPP_ASSERT( getDispatcher()->vkGetBufferMemoryRequirements && "Function <vkGetBufferMemoryRequirements> requires <VK_VERSION_1_0>" );

      MemoryRequirements memoryRequirements;
      getDispatcher()->vkGetBufferMemoryRequirements(
        static_cast<VkDevice>( m_device ), static_cast<VkBuffer>( m_buffer ), reinterpret_cast<VkMemoryRequirements *>( &memoryRequirements ) );

      return memoryRequirements;
    }

    // wrapper function for command vkGetImageMemoryRequirements, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetImageMemoryRequirements.html
    VULKAN_HPP_NODISCARD VULKAN_HPP_INLINE MemoryRequirements Image::getMemoryRequirements() const VULKAN_HPP_NOEXCEPT
    {
      VULKAN_HPP_ASSERT( getDispatcher()->vkGetImageMemoryRequirements && "Function <vkGetImageMemoryRequirements> requires <VK_VERSION_1_0>" );

      MemoryRequirements memoryRequirements;
      getDispatcher()->vkGetImageMemoryRequirements(
        static_cast<VkDevice>( m_device ), static_cast<VkImage>( m_image ), reinterpret_cast<VkMemoryRequirements *>( &memoryRequirements ) );

      return memoryRequirements;
    }

    // wrapper function for command vkGetImageSparseMemoryRequirements, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetImageSparseMemoryRequirements.html
    VULKAN_HPP_NODISCARD VULKAN_HPP_INLINE std::vector<SparseImageMemoryRequirements> Image::getSparseMemoryRequirements() const
    {
      VULKAN_HPP_ASSERT( getDispatcher()->vkGetImageSparseMemoryRequirements && "Function <vkGetImageSparseMemoryRequirements> requires <VK_VERSION_1_0>" );

      std::vector<SparseImageMemoryRequirements> sparseMemoryRequirements;
      uint32_t                                   sparseMemoryRequirementCount;
      getDispatcher()->vkGetImageSparseMemoryRequirements(
        static_cast<VkDevice>( m_device ), static_cast<VkImage>( m_image ), &sparseMemoryRequirementCount, nullptr );
      sparseMemoryRequirements.resize( sparseMemoryRequirementCount );
      getDispatcher()->vkGetImageSparseMemoryRequirements( static_cast<VkDevice>( m_device ),
                                                           static_cast<VkImage>( m_image ),
                                                           &sparseMemoryRequirementCount,
                                                           reinterpret_cast<VkSparseImageMemoryRequirements *>( sparseMemoryRequirements.data() ) );

      VULKAN_HPP_ASSERT( sparseMemoryRequirementCount <= sparseMemoryRequirements.size() );
      if ( sparseMemoryRequirementCount < sparseMemoryRequirements.size() )
      {
        sparseMemoryRequirements.resize( sparseMemoryRequirementCount );
      }
      return sparseMemoryRequirements;
    }

    // wrapper function for command vkGetPhysicalDeviceSparseImageFormatProperties, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetPhysicalDeviceSparseImageFormatProperties.html
    VULKAN_HPP_NODISCARD VULKAN_HPP_INLINE std::vector<SparseImageFormatProperties> PhysicalDevice::getSparseImageFormatProperties(
      Format format, ImageType type, SampleCountFlagBits samples, ImageUsageFlags usage, ImageTiling tiling ) const
    {
      VULKAN_HPP_ASSERT( getDispatcher()->vkGetPhysicalDeviceSparseImageFormatProperties &&
                         "Function <vkGetPhysicalDeviceSparseImageFormatProperties> requires <VK_VERSION_1_0>" );

      std::vector<SparseImageFormatProperties> properties;
      uint32_t                                 propertyCount;
      getDispatcher()->vkGetPhysicalDeviceSparseImageFormatProperties( static_cast<VkPhysicalDevice>( m_physicalDevice ),
                                                                       static_cast<VkFormat>( format ),
                                                                       static_cast<VkImageType>( type ),
                                                                       static_cast<VkSampleCountFlagBits>( samples ),
                                                                       static_cast<VkImageUsageFlags>( usage ),
                                                                       static_cast<VkImageTiling>( tiling ),
                                                                       &propertyCount,
                                                                       nullptr );
      properties.resize( propertyCount );
      getDispatcher()->vkGetPhysicalDeviceSparseImageFormatProperties( static_cast<VkPhysicalDevice>( m_physicalDevice ),
                                                                       static_cast<VkFormat>( format ),
                                                                       static_cast<VkImageType>( type ),
                                                                       static_cast<VkSampleCountFlagBits>( samples ),
                                                                       static_cast<VkImageUsageFlags>( usage ),
                                                                       static_cast<VkImageTiling>( tiling ),
                                                                       &propertyCount,
                                                                       reinterpret_cast<VkSparseImageFormatProperties *>( properties.data() ) );

      VULKAN_HPP_ASSERT( propertyCount <= properties.size() );
      if ( propertyCount < properties.size() )
      {
        properties.resize( propertyCount );
      }
      return properties;
    }

    // wrapper function for command vkQueueBindSparse, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkQueueBindSparse.html
    VULKAN_HPP_INLINE typename ResultValueType<void>::type Queue::bindSparse( ArrayProxy<const BindSparseInfo> const & bindInfo,
                                                                              VULKAN_HPP_NAMESPACE::Fence              fence ) const
    {
      VULKAN_HPP_ASSERT( getDispatcher()->vkQueueBindSparse && "Function <vkQueueBindSparse> requires <VK_VERSION_1_0>" );

      Result result = static_cast<Result>( getDispatcher()->vkQueueBindSparse(
        static_cast<VkQueue>( m_queue ), bindInfo.size(), reinterpret_cast<const VkBindSparseInfo *>( bindInfo.data() ), static_cast<VkFence>( fence ) ) );
      VULKAN_HPP_NAMESPACE::detail::resultCheck( result, VULKAN_HPP_RAII_NAMESPACE_STRING "::Queue::bindSparse" );

      return VULKAN_HPP_NAMESPACE::detail::createResultValueType( result );
    }

    // wrapper function for command vkCreateFence, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateFence.html
    VULKAN_HPP_NODISCARD VULKAN_HPP_INLINE typename ResultValueType<Fence>::type
      Device::createFence( FenceCreateInfo const & createInfo, Optional<const AllocationCallbacks> allocator ) const VULKAN_HPP_NOEXCEPT_WHEN_NO_EXCEPTIONS
    {
      VULKAN_HPP_NAMESPACE::Fence fence;
      Result                      result = static_cast<Result>( getDispatcher()->vkCreateFence( static_cast<VkDevice>( m_device ),
                                                                           reinterpret_cast<const VkFenceCreateInfo *>( &createInfo ),
                                                                           reinterpret_cast<const VkAllocationCallbacks *>( allocator.get() ),
                                                                           reinterpret_cast<VkFence *>( &fence ) ) );
      VULKAN_HPP_NAMESPACE::detail::resultCheck( result, VULKAN_HPP_RAII_NAMESPACE_STRING "::Device::createFence" );
      return VULKAN_HPP_NAMESPACE::detail::createResultValueType( result, Fence( *this, *reinterpret_cast<VkFence *>( &fence ), allocator ) );
    }

    // wrapper function for command vkResetFences, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkResetFences.html
    VULKAN_HPP_INLINE typename ResultValueType<void>::type Device::resetFences( ArrayProxy<const VULKAN_HPP_NAMESPACE::Fence> const & fences ) const
    {
      VULKAN_HPP_ASSERT( getDispatcher()->vkResetFences && "Function <vkResetFences> requires <VK_VERSION_1_0>" );

      Result result = static_cast<Result>(
        getDispatcher()->vkResetFences( static_cast<VkDevice>( m_device ), fences.size(), reinterpret_cast<const VkFence *>( fences.data() ) ) );
      VULKAN_HPP_NAMESPACE::detail::resultCheck( result, VULKAN_HPP_RAII_NAMESPACE_STRING "::Device::resetFences" );

      return VULKAN_HPP_NAMESPACE::detail::createResultValueType( result );
    }

    // wrapper function for command vkGetFenceStatus, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetFenceStatus.html
    VULKAN_HPP_NODISCARD VULKAN_HPP_INLINE Result Fence::getStatus() const
    {
      VULKAN_HPP_ASSERT( getDispatcher()->vkGetFenceStatus && "Function <vkGetFenceStatus> requires <VK_VERSION_1_0>" );

      Result result = static_cast<Result>( getDispatcher()->vkGetFenceStatus( static_cast<VkDevice>( m_device ), static_cast<VkFence>( m_fence ) ) );
      VULKAN_HPP_NAMESPACE::detail::resultCheck( result, VULKAN_HPP_RAII_NAMESPACE_STRING "::Fence::getStatus", { Result::eSuccess, Result::eNotReady } );

      return static_cast<Result>( result );
    }

    // wrapper function for command vkWaitForFences, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkWaitForFences.html
    VULKAN_HPP_NODISCARD VULKAN_HPP_INLINE Result Device::waitForFences( ArrayProxy<const VULKAN_HPP_NAMESPACE::Fence> const & fences,
                                                                         Bool32                                                waitAll,
                                                                         uint64_t                                              timeout ) const
    {
      VULKAN_HPP_ASSERT( getDispatcher()->vkWaitForFences && "Function <vkWaitForFences> requires <VK_VERSION_1_0>" );

      Result result = static_cast<Result>( getDispatcher()->vkWaitForFences(
        static_cast<VkDevice>( m_device ), fences.size(), reinterpret_cast<const VkFence *>( fences.data() ), static_cast<VkBool32>( waitAll ), timeout ) );
      VULKAN_HPP_NAMESPACE::detail::resultCheck( result, VULKAN_HPP_RAII_NAMESPACE_STRING "::Device::waitForFences", { Result::eSuccess, Result::eTimeout } );

      return static_cast<Result>( result );
    }

    // wrapper function for command vkCreateSemaphore, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateSemaphore.html
    VULKAN_HPP_NODISCARD VULKAN_HPP_INLINE typename ResultValueType<Semaphore>::type
                         Device::createSemaphore( SemaphoreCreateInfo const &         createInfo,
                               Optional<const AllocationCallbacks> allocator ) const VULKAN_HPP_NOEXCEPT_WHEN_NO_EXCEPTIONS
    {
      VULKAN_HPP_NAMESPACE::Semaphore semaphore;
      Result                          result = static_cast<Result>( getDispatcher()->vkCreateSemaphore( static_cast<VkDevice>( m_device ),
                                                                               reinterpret_cast<const VkSemaphoreCreateInfo *>( &createInfo ),
                                                                               reinterpret_cast<const VkAllocationCallbacks *>( allocator.get() ),
                                                                               reinterpret_cast<VkSemaphore *>( &semaphore ) ) );
      VULKAN_HPP_NAMESPACE::detail::resultCheck( result, VULKAN_HPP_RAII_NAMESPACE_STRING "::Device::createSemaphore" );
      return VULKAN_HPP_NAMESPACE::detail::createResultValueType( result, Semaphore( *this, *reinterpret_cast<VkSemaphore *>( &semaphore ), allocator ) );
    }

    // wrapper function for command vkCreateQueryPool, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateQueryPool.html
    VULKAN_HPP_NODISCARD VULKAN_HPP_INLINE typename ResultValueType<QueryPool>::type
                         Device::createQueryPool( QueryPoolCreateInfo const &         createInfo,
                               Optional<const AllocationCallbacks> allocator ) const VULKAN_HPP_NOEXCEPT_WHEN_NO_EXCEPTIONS
    {
      VULKAN_HPP_NAMESPACE::QueryPool queryPool;
      Result                          result = static_cast<Result>( getDispatcher()->vkCreateQueryPool( static_cast<VkDevice>( m_device ),
                                                                               reinterpret_cast<const VkQueryPoolCreateInfo *>( &createInfo ),
                                                                               reinterpret_cast<const VkAllocationCallbacks *>( allocator.get() ),
                                                                               reinterpret_cast<VkQueryPool *>( &queryPool ) ) );
      VULKAN_HPP_NAMESPACE::detail::resultCheck( result, VULKAN_HPP_RAII_NAMESPACE_STRING "::Device::createQueryPool" );
      return VULKAN_HPP_NAMESPACE::detail::createResultValueType( result, QueryPool( *this, *reinterpret_cast<VkQueryPool *>( &queryPool ), allocator ) );
    }

    // wrapper function for command vkGetQueryPoolResults, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetQueryPoolResults.html
    template <typename DataType>
    VULKAN_HPP_NODISCARD VULKAN_HPP_INLINE ResultValue<std::vector<DataType>>
      QueryPool::getResults( uint32_t firstQuery, uint32_t queryCount, size_t dataSize, DeviceSize stride, QueryResultFlags flags ) const
    {
      VULKAN_HPP_ASSERT( getDispatcher()->vkGetQueryPoolResults && "Function <vkGetQueryPoolResults> requires <VK_VERSION_1_0>" );

      VULKAN_HPP_ASSERT( dataSize % sizeof( DataType ) == 0 );
      std::vector<DataType> data( dataSize / sizeof( DataType ) );
      Result                result = static_cast<Result>( getDispatcher()->vkGetQueryPoolResults( static_cast<VkDevice>( m_device ),
                                                                                   static_cast<VkQueryPool>( m_queryPool ),
                                                                                   firstQuery,
                                                                                   queryCount,
                                                                                   data.size() * sizeof( DataType ),
                                                                                   reinterpret_cast<void *>( data.data() ),
                                                                                   static_cast<VkDeviceSize>( stride ),
                                                                                   static_cast<VkQueryResultFlags>( flags ) ) );
      VULKAN_HPP_NAMESPACE::detail::resultCheck( result, VULKAN_HPP_RAII_NAMESPACE_STRING "::QueryPool::getResults", { Result::eSuccess, Result::eNotReady } );

      return ResultValue<std::vector<DataType>>( result, std::move( data ) );
    }

    // wrapper function for command vkGetQueryPoolResults, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetQueryPoolResults.html
    template <typename DataType>
    VULKAN_HPP_NODISCARD VULKAN_HPP_INLINE ResultValue<DataType>
                                           QueryPool::getResult( uint32_t firstQuery, uint32_t queryCount, DeviceSize stride, QueryResultFlags flags ) const
    {
      VULKAN_HPP_ASSERT( getDispatcher()->vkGetQueryPoolResults && "Function <vkGetQueryPoolResults> requires <VK_VERSION_1_0>" );

      DataType data;
      Result   result = static_cast<Result>( getDispatcher()->vkGetQueryPoolResults( static_cast<VkDevice>( m_device ),
                                                                                   static_cast<VkQueryPool>( m_queryPool ),
                                                                                   firstQuery,
                                                                                   queryCount,
                                                                                   sizeof( DataType ),
                                                                                   reinterpret_cast<void *>( &data ),
                                                                                   static_cast<VkDeviceSize>( stride ),
                                                                                   static_cast<VkQueryResultFlags>( flags ) ) );
      VULKAN_HPP_NAMESPACE::detail::resultCheck( result, VULKAN_HPP_RAII_NAMESPACE_STRING "::QueryPool::getResult", { Result::eSuccess, Result::eNotReady } );

      return ResultValue<DataType>( result, std::move( data ) );
    }

    // wrapper function for command vkCreateBuffer, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateBuffer.html
    VULKAN_HPP_NODISCARD VULKAN_HPP_INLINE typename ResultValueType<Buffer>::type
      Device::createBuffer( BufferCreateInfo const & createInfo, Optional<const AllocationCallbacks> allocator ) const VULKAN_HPP_NOEXCEPT_WHEN_NO_EXCEPTIONS
    {
      VULKAN_HPP_NAMESPACE::Buffer buffer;
      Result                       result = static_cast<Result>( getDispatcher()->vkCreateBuffer( static_cast<VkDevice>( m_device ),
                                                                            reinterpret_cast<const VkBufferCreateInfo *>( &createInfo ),
                                                                            reinterpret_cast<const VkAllocationCallbacks *>( allocator.get() ),
                                                                            reinterpret_cast<VkBuffer *>( &buffer ) ) );
      VULKAN_HPP_NAMESPACE::detail::resultCheck( result, VULKAN_HPP_RAII_NAMESPACE_STRING "::Device::createBuffer" );
      return VULKAN_HPP_NAMESPACE::detail::createResultValueType( result, Buffer( *this, *reinterpret_cast<VkBuffer *>( &buffer ), allocator ) );
    }

    // wrapper function for command vkCreateImage, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateImage.html
    VULKAN_HPP_NODISCARD VULKAN_HPP_INLINE typename ResultValueType<Image>::type
      Device::createImage( ImageCreateInfo const & createInfo, Optional<const AllocationCallbacks> allocator ) const VULKAN_HPP_NOEXCEPT_WHEN_NO_EXCEPTIONS
    {
      VULKAN_HPP_NAMESPACE::Image image;
      Result                      result = static_cast<Result>( getDispatcher()->vkCreateImage( static_cast<VkDevice>( m_device ),
                                                                           reinterpret_cast<const VkImageCreateInfo *>( &createInfo ),
                                                                           reinterpret_cast<const VkAllocationCallbacks *>( allocator.get() ),
                                                                           reinterpret_cast<VkImage *>( &image ) ) );
      VULKAN_HPP_NAMESPACE::detail::resultCheck( result, VULKAN_HPP_RAII_NAMESPACE_STRING "::Device::createImage" );
      return VULKAN_HPP_NAMESPACE::detail::createResultValueType( result, Image( *this, *reinterpret_cast<VkImage *>( &image ), allocator ) );
    }

    // wrapper function for command vkGetImageSubresourceLayout, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetImageSubresourceLayout.html
    VULKAN_HPP_NODISCARD VULKAN_HPP_INLINE SubresourceLayout Image::getSubresourceLayout( const ImageSubresource & subresource ) const VULKAN_HPP_NOEXCEPT
    {
      VULKAN_HPP_ASSERT( getDispatcher()->vkGetImageSubresourceLayout && "Function <vkGetImageSubresourceLayout> requires <VK_VERSION_1_0>" );

      SubresourceLayout layout;
      getDispatcher()->vkGetImageSubresourceLayout( static_cast<VkDevice>( m_device ),
                                                    static_cast<VkImage>( m_image ),
                                                    reinterpret_cast<const VkImageSubresource *>( &subresource ),
                                                    reinterpret_cast<VkSubresourceLayout *>( &layout ) );

      return layout;
    }

    // wrapper function for command vkCreateImageView, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateImageView.html
    VULKAN_HPP_NODISCARD VULKAN_HPP_INLINE typename ResultValueType<ImageView>::type
                         Device::createImageView( ImageViewCreateInfo const &         createInfo,
                               Optional<const AllocationCallbacks> allocator ) const VULKAN_HPP_NOEXCEPT_WHEN_NO_EXCEPTIONS
    {
      VULKAN_HPP_NAMESPACE::ImageView view;
      Result                          result = static_cast<Result>( getDispatcher()->vkCreateImageView( static_cast<VkDevice>( m_device ),
                                                                               reinterpret_cast<const VkImageViewCreateInfo *>( &createInfo ),
                                                                               reinterpret_cast<const VkAllocationCallbacks *>( allocator.get() ),
                                                                               reinterpret_cast<VkImageView *>( &view ) ) );
      VULKAN_HPP_NAMESPACE::detail::resultCheck( result, VULKAN_HPP_RAII_NAMESPACE_STRING "::Device::createImageView" );
      return VULKAN_HPP_NAMESPACE::detail::createResultValueType( result, ImageView( *this, *reinterpret_cast<VkImageView *>( &view ), allocator ) );
    }

    // wrapper function for command vkCreateCommandPool, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateCommandPool.html
    VULKAN_HPP_NODISCARD VULKAN_HPP_INLINE typename ResultValueType<CommandPool>::type
                         Device::createCommandPool( CommandPoolCreateInfo const &       createInfo,
                                 Optional<const AllocationCallbacks> allocator ) const VULKAN_HPP_NOEXCEPT_WHEN_NO_EXCEPTIONS
    {
      VULKAN_HPP_NAMESPACE::CommandPool commandPool;
      Result                            result = static_cast<Result>( getDispatcher()->vkCreateCommandPool( static_cast<VkDevice>( m_device ),
                                                                                 reinterpret_cast<const VkCommandPoolCreateInfo *>( &createInfo ),
                                                                                 reinterpret_cast<const VkAllocationCallbacks *>( allocator.get() ),
                                                                                 reinterpret_cast<VkCommandPool *>( &commandPool ) ) );
      VULKAN_HPP_NAMESPACE::detail::resultCheck( result, VULKAN_HPP_RAII_NAMESPACE_STRING "::Device::createCommandPool" );
      return VULKAN_HPP_NAMESPACE::detail::createResultValueType( result, CommandPool( *this, *reinterpret_cast<VkCommandPool *>( &commandPool ), allocator ) );
    }

    // wrapper function for command vkResetCommandPool, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkResetCommandPool.html
    VULKAN_HPP_INLINE typename ResultValueType<void>::type CommandPool::reset( CommandPoolResetFlags flags ) const
    {
      VULKAN_HPP_ASSERT( getDispatcher()->vkResetCommandPool && "Function <vkResetCommandPool> requires <VK_VERSION_1_0>" );

      Result result = static_cast<Result>( getDispatcher()->vkResetCommandPool(
        static_cast<VkDevice>( m_device ), static_cast<VkCommandPool>( m_commandPool ), static_cast<VkCommandPoolResetFlags>( flags ) ) );
      VULKAN_HPP_NAMESPACE::detail::resultCheck( result, VULKAN_HPP_RAII_NAMESPACE_STRING "::CommandPool::reset" );

      return VULKAN_HPP_NAMESPACE::detail::createResultValueType( result );
    }

    // wrapper function for command vkAllocateCommandBuffers, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkAllocateCommandBuffers.html
    VULKAN_HPP_NODISCARD VULKAN_HPP_INLINE typename ResultValueType<std::vector<CommandBuffer>>::type
                         Device::allocateCommandBuffers( CommandBufferAllocateInfo const & allocateInfo ) const
    {
      std::vector<VULKAN_HPP_NAMESPACE::CommandBuffer> commandBuffers( allocateInfo.commandBufferCount );
      Result result = static_cast<Result>( getDispatcher()->vkAllocateCommandBuffers( static_cast<VkDevice>( m_device ),
                                                                                      reinterpret_cast<const VkCommandBufferAllocateInfo *>( &allocateInfo ),
                                                                                      reinterpret_cast<VkCommandBuffer *>( commandBuffers.data() ) ) );
      VULKAN_HPP_NAMESPACE::detail::resultCheck( result, VULKAN_HPP_RAII_NAMESPACE_STRING "::Device::allocateCommandBuffers" );
      std::vector<CommandBuffer> commandBuffersRAII;
      if ( result == Result::eSuccess )
      {
        commandBuffersRAII.reserve( commandBuffers.size() );
        for ( auto & commandBuffer : commandBuffers )
        {
          commandBuffersRAII.emplace_back(
            *this, *reinterpret_cast<VkCommandBuffer *>( &commandBuffer ), static_cast<VkCommandPool>( allocateInfo.commandPool ) );
        }
      }
      return VULKAN_HPP_NAMESPACE::detail::createResultValueType( result, std::move( commandBuffersRAII ) );
    }

    // wrapper function for command vkBeginCommandBuffer, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkBeginCommandBuffer.html
    VULKAN_HPP_INLINE typename ResultValueType<void>::type CommandBuffer::begin( const CommandBufferBeginInfo & beginInfo ) const
    {
      VULKAN_HPP_ASSERT( getDispatcher()->vkBeginCommandBuffer && "Function <vkBeginCommandBuffer> requires <VK_VERSION_1_0>" );

      Result result = static_cast<Result>( getDispatcher()->vkBeginCommandBuffer( static_cast<VkCommandBuffer>( m_commandBuffer ),
                                                                                  reinterpret_cast<const VkCommandBufferBeginInfo *>( &beginInfo ) ) );
      VULKAN_HPP_NAMESPACE::detail::resultCheck( result, VULKAN_HPP_RAII_NAMESPACE_STRING "::CommandBuffer::begin" );

      return VULKAN_HPP_NAMESPACE::detail::createResultValueType( result );
    }

    // wrapper function for command vkEndCommandBuffer, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkEndCommandBuffer.html
    VULKAN_HPP_INLINE typename ResultValueType<void>::type CommandBuffer::end() const
    {
      VULKAN_HPP_ASSERT( getDispatcher()->vkEndCommandBuffer && "Function <vkEndCommandBuffer> requires <VK_VERSION_1_0>" );

      Result result = static_cast<Result>( getDispatcher()->vkEndCommandBuffer( static_cast<VkCommandBuffer>( m_commandBuffer ) ) );
      VULKAN_HPP_NAMESPACE::detail::resultCheck( result, VULKAN_HPP_RAII_NAMESPACE_STRING "::CommandBuffer::end" );

      return VULKAN_HPP_NAMESPACE::detail::createResultValueType( result );
    }

    // wrapper function for command vkResetCommandBuffer, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkResetCommandBuffer.html
    VULKAN_HPP_INLINE typename ResultValueType<void>::type CommandBuffer::reset( CommandBufferResetFlags flags ) const
    {
      VULKAN_HPP_ASSERT( getDispatcher()->vkResetCommandBuffer && "Function <vkResetCommandBuffer> requires <VK_VERSION_1_0>" );

      Result result = static_cast<Result>(
        getDispatcher()->vkResetCommandBuffer( static_cast<VkCommandBuffer>( m_commandBuffer ), static_cast<VkCommandBufferResetFlags>( flags ) ) );
      VULKAN_HPP_NAMESPACE::detail::resultCheck( result, VULKAN_HPP_RAII_NAMESPACE_STRING "::CommandBuffer::reset" );

      return VULKAN_HPP_NAMESPACE::detail::createResultValueType( result );
    }

    // wrapper function for command vkCmdCopyBuffer, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdCopyBuffer.html
    VULKAN_HPP_INLINE void CommandBuffer::copyBuffer( VULKAN_HPP_NAMESPACE::Buffer         srcBuffer,
                                                      VULKAN_HPP_NAMESPACE::Buffer         dstBuffer,
                                                      ArrayProxy<const BufferCopy> const & regions ) const VULKAN_HPP_NOEXCEPT
    {
      VULKAN_HPP_ASSERT( getDispatcher()->vkCmdCopyBuffer && "Function <vkCmdCopyBuffer> requires <VK_VERSION_1_0>" );

      getDispatcher()->vkCmdCopyBuffer( static_cast<VkCommandBuffer>( m_commandBuffer ),
                                        static_cast<VkBuffer>( srcBuffer ),
                                        static_cast<VkBuffer>( dstBuffer ),
                                        regions.size(),
                                        reinterpret_cast<const VkBufferCopy *>( regions.data() ) );
    }

    // wrapper function for command vkCmdCopyImage, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdCopyImage.html
    VULKAN_HPP_INLINE void CommandBuffer::copyImage( VULKAN_HPP_NAMESPACE::Image         srcImage,
                                                     ImageLayout                         srcImageLayout,
                                                     VULKAN_HPP_NAMESPACE::Image         dstImage,
                                                     ImageLayout                         dstImageLayout,
                                                     ArrayProxy<const ImageCopy> const & regions ) const VULKAN_HPP_NOEXCEPT
    {
      VULKAN_HPP_ASSERT( getDispatcher()->vkCmdCopyImage && "Function <vkCmdCopyImage> requires <VK_VERSION_1_0>" );

      getDispatcher()->vkCmdCopyImage( static_cast<VkCommandBuffer>( m_commandBuffer ),
                                       static_cast<VkImage>( srcImage ),
                                       static_cast<VkImageLayout>( srcImageLayout ),
                                       static_cast<VkImage>( dstImage ),
                                       static_cast<VkImageLayout>( dstImageLayout ),
                                       regions.size(),
                                       reinterpret_cast<const VkImageCopy *>( regions.data() ) );
    }

    // wrapper function for command vkCmdCopyBufferToImage, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdCopyBufferToImage.html
    VULKAN_HPP_INLINE void CommandBuffer::copyBufferToImage( VULKAN_HPP_NAMESPACE::Buffer              srcBuffer,
                                                             VULKAN_HPP_NAMESPACE::Image               dstImage,
                                                             ImageLayout                               dstImageLayout,
                                                             ArrayProxy<const BufferImageCopy> const & regions ) const VULKAN_HPP_NOEXCEPT
    {
      VULKAN_HPP_ASSERT( getDispatcher()->vkCmdCopyBufferToImage && "Function <vkCmdCopyBufferToImage> requires <VK_VERSION_1_0>" );

      getDispatcher()->vkCmdCopyBufferToImage( static_cast<VkCommandBuffer>( m_commandBuffer ),
                                               static_cast<VkBuffer>( srcBuffer ),
                                               static_cast<VkImage>( dstImage ),
                                               static_cast<VkImageLayout>( dstImageLayout ),
                                               regions.size(),
                                               reinterpret_cast<const VkBufferImageCopy *>( regions.data() ) );
    }

    // wrapper function for command vkCmdCopyImageToBuffer, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdCopyImageToBuffer.html
    VULKAN_HPP_INLINE void CommandBuffer::copyImageToBuffer( VULKAN_HPP_NAMESPACE::Image               srcImage,
                                                             ImageLayout                               srcImageLayout,
                                                             VULKAN_HPP_NAMESPACE::Buffer              dstBuffer,
                                                             ArrayProxy<const BufferImageCopy> const & regions ) const VULKAN_HPP_NOEXCEPT
    {
      VULKAN_HPP_ASSERT( getDispatcher()->vkCmdCopyImageToBuffer && "Function <vkCmdCopyImageToBuffer> requires <VK_VERSION_1_0>" );

      getDispatcher()->vkCmdCopyImageToBuffer( static_cast<VkCommandBuffer>( m_commandBuffer ),
                                               static_cast<VkImage>( srcImage ),
                                               static_cast<VkImageLayout>( srcImageLayout ),
                                               static_cast<VkBuffer>( dstBuffer ),
                                               regions.size(),
                                               reinterpret_cast<const VkBufferImageCopy *>( regions.data() ) );
    }

    // wrapper function for command vkCmdUpdateBuffer, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdUpdateBuffer.html
    template <typename DataType>
    VULKAN_HPP_INLINE void CommandBuffer::updateBuffer( VULKAN_HPP_NAMESPACE::Buffer       dstBuffer,
                                                        DeviceSize                         dstOffset,
                                                        ArrayProxy<const DataType> const & data ) const VULKAN_HPP_NOEXCEPT
    {
      VULKAN_HPP_ASSERT( getDispatcher()->vkCmdUpdateBuffer && "Function <vkCmdUpdateBuffer> requires <VK_VERSION_1_0>" );

      getDispatcher()->vkCmdUpdateBuffer( static_cast<VkCommandBuffer>( m_commandBuffer ),
                                          static_cast<VkBuffer>( dstBuffer ),
                                          static_cast<VkDeviceSize>( dstOffset ),
                                          data.size() * sizeof( DataType ),
                                          reinterpret_cast<const void *>( data.data() ) );
    }

    // wrapper function for command vkCmdFillBuffer, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdFillBuffer.html
    VULKAN_HPP_INLINE void
      CommandBuffer::fillBuffer( VULKAN_HPP_NAMESPACE::Buffer dstBuffer, DeviceSize dstOffset, DeviceSize size, uint32_t data ) const VULKAN_HPP_NOEXCEPT
    {
      VULKAN_HPP_ASSERT( getDispatcher()->vkCmdFillBuffer && "Function <vkCmdFillBuffer> requires <VK_VERSION_1_0>" );

      getDispatcher()->vkCmdFillBuffer( static_cast<VkCommandBuffer>( m_commandBuffer ),
                                        static_cast<VkBuffer>( dstBuffer ),
                                        static_cast<VkDeviceSize>( dstOffset ),
                                        static_cast<VkDeviceSize>( size ),
                                        data );
    }

    // wrapper function for command vkCmdPipelineBarrier, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdPipelineBarrier.html
    VULKAN_HPP_INLINE void CommandBuffer::pipelineBarrier( PipelineStageFlags                            srcStageMask,
                                                           PipelineStageFlags                            dstStageMask,
                                                           DependencyFlags                               dependencyFlags,
                                                           ArrayProxy<const MemoryBarrier> const &       memoryBarriers,
                                                           ArrayProxy<const BufferMemoryBarrier> const & bufferMemoryBarriers,
                                                           ArrayProxy<const ImageMemoryBarrier> const &  imageMemoryBarriers ) const VULKAN_HPP_NOEXCEPT
    {
      VULKAN_HPP_ASSERT( getDispatcher()->vkCmdPipelineBarrier && "Function <vkCmdPipelineBarrier> requires <VK_VERSION_1_0>" );

      getDispatcher()->vkCmdPipelineBarrier( static_cast<VkCommandBuffer>( m_commandBuffer ),
                                             static_cast<VkPipelineStageFlags>( srcStageMask ),
                                             static_cast<VkPipelineStageFlags>( dstStageMask ),
                                             static_cast<VkDependencyFlags>( dependencyFlags ),
                                             memoryBarriers.size(),
                                             reinterpret_cast<const VkMemoryBarrier *>( memoryBarriers.data() ),
                                             bufferMemoryBarriers.size(),
                                             reinterpret_cast<const VkBufferMemoryBarrier *>( bufferMemoryBarriers.data() ),
                                             imageMemoryBarriers.size(),
                                             reinterpret_cast<const VkImageMemoryBarrier *>( imageMemoryBarriers.data() ) );
    }

    // wrapper function for command vkCmdBeginQuery, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdBeginQuery.html
    VULKAN_HPP_INLINE void
      CommandBuffer::beginQuery( VULKAN_HPP_NAMESPACE::QueryPool queryPool, uint32_t query, QueryControlFlags flags ) const VULKAN_HPP_NOEXCEPT
    {
      VULKAN_HPP_ASSERT( getDispatcher()->vkCmdBeginQuery && "Function <vkCmdBeginQuery> requires <VK_VERSION_1_0>" );

      getDispatcher()->vkCmdBeginQuery(
        static_cast<VkCommandBuffer>( m_commandBuffer ), static_cast<VkQueryPool>( queryPool ), query, static_cast<VkQueryControlFlags>( flags ) );
    }

    // wrapper function for command vkCmdEndQuery, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdEndQuery.html
    VULKAN_HPP_INLINE void CommandBuffer::endQuery( VULKAN_HPP_NAMESPACE::QueryPool queryPool, uint32_t query ) const VULKAN_HPP_NOEXCEPT
    {
      VULKAN_HPP_ASSERT( getDispatcher()->vkCmdEndQuery && "Function <vkCmdEndQuery> requires <VK_VERSION_1_0>" );

      getDispatcher()->vkCmdEndQuery( static_cast<VkCommandBuffer>( m_commandBuffer ), static_cast<VkQueryPool>( queryPool ), query );
    }

    // wrapper function for command vkCmdResetQueryPool, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdResetQueryPool.html
    VULKAN_HPP_INLINE void
      CommandBuffer::resetQueryPool( VULKAN_HPP_NAMESPACE::QueryPool queryPool, uint32_t firstQuery, uint32_t queryCount ) const VULKAN_HPP_NOEXCEPT
    {
      VULKAN_HPP_ASSERT( getDispatcher()->vkCmdResetQueryPool && "Function <vkCmdResetQueryPool> requires <VK_VERSION_1_0>" );

      getDispatcher()->vkCmdResetQueryPool( static_cast<VkCommandBuffer>( m_commandBuffer ), static_cast<VkQueryPool>( queryPool ), firstQuery, queryCount );
    }

    // wrapper function for command vkCmdWriteTimestamp, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdWriteTimestamp.html
    VULKAN_HPP_INLINE void
      CommandBuffer::writeTimestamp( PipelineStageFlagBits pipelineStage, VULKAN_HPP_NAMESPACE::QueryPool queryPool, uint32_t query ) const VULKAN_HPP_NOEXCEPT
    {
      VULKAN_HPP_ASSERT( getDispatcher()->vkCmdWriteTimestamp && "Function <vkCmdWriteTimestamp> requires <VK_VERSION_1_0>" );

      getDispatcher()->vkCmdWriteTimestamp(
        static_cast<VkCommandBuffer>( m_commandBuffer ), static_cast<VkPipelineStageFlagBits>( pipelineStage ), static_cast<VkQueryPool>( queryPool ), query );
    }

    // wrapper function for command vkCmdCopyQueryPoolResults, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdCopyQueryPoolResults.html
    VULKAN_HPP_INLINE void CommandBuffer::copyQueryPoolResults( VULKAN_HPP_NAMESPACE::QueryPool queryPool,
                                                                uint32_t                        firstQuery,
                                                                uint32_t                        queryCount,
                                                                VULKAN_HPP_NAMESPACE::Buffer    dstBuffer,
                                                                DeviceSize                      dstOffset,
                                                                DeviceSize                      stride,
                                                                QueryResultFlags                flags ) const VULKAN_HPP_NOEXCEPT
    {
      VULKAN_HPP_ASSERT( getDispatcher()->vkCmdCopyQueryPoolResults && "Function <vkCmdCopyQueryPoolResults> requires <VK_VERSION_1_0>" );

      getDispatcher()->vkCmdCopyQueryPoolResults( static_cast<VkCommandBuffer>( m_commandBuffer ),
                                                  static_cast<VkQueryPool>( queryPool ),
                                                  firstQuery,
                                                  queryCount,
                                                  static_cast<VkBuffer>( dstBuffer ),
                                                  static_cast<VkDeviceSize>( dstOffset ),
                                                  static_cast<VkDeviceSize>( stride ),
                                                  static_cast<VkQueryResultFlags>( flags ) );
    }

    // wrapper function for command vkCmdExecuteCommands, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdExecuteCommands.html
    VULKAN_HPP_INLINE void
      CommandBuffer::executeCommands( ArrayProxy<const VULKAN_HPP_NAMESPACE::CommandBuffer> const & commandBuffers ) const VULKAN_HPP_NOEXCEPT
    {
      VULKAN_HPP_ASSERT( getDispatcher()->vkCmdExecuteCommands && "Function <vkCmdExecuteCommands> requires <VK_VERSION_1_0>" );

      getDispatcher()->vkCmdExecuteCommands(
        static_cast<VkCommandBuffer>( m_commandBuffer ), commandBuffers.size(), reinterpret_cast<const VkCommandBuffer *>( commandBuffers.data() ) );
    }

    // wrapper function for command vkCreateEvent, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateEvent.html
    VULKAN_HPP_NODISCARD VULKAN_HPP_INLINE typename ResultValueType<Event>::type
      Device::createEvent( EventCreateInfo const & createInfo, Optional<const AllocationCallbacks> allocator ) const VULKAN_HPP_NOEXCEPT_WHEN_NO_EXCEPTIONS
    {
      VULKAN_HPP_NAMESPACE::Event event;
      Result                      result = static_cast<Result>( getDispatcher()->vkCreateEvent( static_cast<VkDevice>( m_device ),
                                                                           reinterpret_cast<const VkEventCreateInfo *>( &createInfo ),
                                                                           reinterpret_cast<const VkAllocationCallbacks *>( allocator.get() ),
                                                                           reinterpret_cast<VkEvent *>( &event ) ) );
      VULKAN_HPP_NAMESPACE::detail::resultCheck( result, VULKAN_HPP_RAII_NAMESPACE_STRING "::Device::createEvent" );
      return VULKAN_HPP_NAMESPACE::detail::createResultValueType( result, Event( *this, *reinterpret_cast<VkEvent *>( &event ), allocator ) );
    }

    // wrapper function for command vkGetEventStatus, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetEventStatus.html
    VULKAN_HPP_NODISCARD VULKAN_HPP_INLINE Result Event::getStatus() const
    {
      VULKAN_HPP_ASSERT( getDispatcher()->vkGetEventStatus && "Function <vkGetEventStatus> requires <VK_VERSION_1_0>" );

      Result result = static_cast<Result>( getDispatcher()->vkGetEventStatus( static_cast<VkDevice>( m_device ), static_cast<VkEvent>( m_event ) ) );
      VULKAN_HPP_NAMESPACE::detail::resultCheck( result, VULKAN_HPP_RAII_NAMESPACE_STRING "::Event::getStatus", { Result::eEventSet, Result::eEventReset } );

      return static_cast<Result>( result );
    }

    // wrapper function for command vkSetEvent, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkSetEvent.html
    VULKAN_HPP_INLINE typename ResultValueType<void>::type Event::set() const
    {
      VULKAN_HPP_ASSERT( getDispatcher()->vkSetEvent && "Function <vkSetEvent> requires <VK_VERSION_1_0>" );

      Result result = static_cast<Result>( getDispatcher()->vkSetEvent( static_cast<VkDevice>( m_device ), static_cast<VkEvent>( m_event ) ) );
      VULKAN_HPP_NAMESPACE::detail::resultCheck( result, VULKAN_HPP_RAII_NAMESPACE_STRING "::Event::set" );

      return VULKAN_HPP_NAMESPACE::detail::createResultValueType( result );
    }

    // wrapper function for command vkResetEvent, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkResetEvent.html
    VULKAN_HPP_INLINE typename ResultValueType<void>::type Event::reset() const
    {
      VULKAN_HPP_ASSERT( getDispatcher()->vkResetEvent && "Function <vkResetEvent> requires <VK_VERSION_1_0>" );

      Result result = static_cast<Result>( getDispatcher()->vkResetEvent( static_cast<VkDevice>( m_device ), static_cast<VkEvent>( m_event ) ) );
      VULKAN_HPP_NAMESPACE::detail::resultCheck( result, VULKAN_HPP_RAII_NAMESPACE_STRING "::Event::reset" );

      return VULKAN_HPP_NAMESPACE::detail::createResultValueType( result );
    }

    // wrapper function for command vkCreateBufferView, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateBufferView.html
    VULKAN_HPP_NODISCARD VULKAN_HPP_INLINE typename ResultValueType<BufferView>::type
                         Device::createBufferView( BufferViewCreateInfo const &        createInfo,
                                Optional<const AllocationCallbacks> allocator ) const VULKAN_HPP_NOEXCEPT_WHEN_NO_EXCEPTIONS
    {
      VULKAN_HPP_NAMESPACE::BufferView view;
      Result                           result = static_cast<Result>( getDispatcher()->vkCreateBufferView( static_cast<VkDevice>( m_device ),
                                                                                reinterpret_cast<const VkBufferViewCreateInfo *>( &createInfo ),
                                                                                reinterpret_cast<const VkAllocationCallbacks *>( allocator.get() ),
                                                                                reinterpret_cast<VkBufferView *>( &view ) ) );
      VULKAN_HPP_NAMESPACE::detail::resultCheck( result, VULKAN_HPP_RAII_NAMESPACE_STRING "::Device::createBufferView" );
      return VULKAN_HPP_NAMESPACE::detail::createResultValueType( result, BufferView( *this, *reinterpret_cast<VkBufferView *>( &view ), allocator ) );
    }

    // wrapper function for command vkCreateShaderModule, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateShaderModule.html
    VULKAN_HPP_NODISCARD VULKAN_HPP_INLINE typename ResultValueType<ShaderModule>::type
                         Device::createShaderModule( ShaderModuleCreateInfo const &      createInfo,
                                  Optional<const AllocationCallbacks> allocator ) const VULKAN_HPP_NOEXCEPT_WHEN_NO_EXCEPTIONS
    {
      VULKAN_HPP_NAMESPACE::ShaderModule shaderModule;
      Result                             result = static_cast<Result>( getDispatcher()->vkCreateShaderModule( static_cast<VkDevice>( m_device ),
                                                                                  reinterpret_cast<const VkShaderModuleCreateInfo *>( &createInfo ),
                                                                                  reinterpret_cast<const VkAllocationCallbacks *>( allocator.get() ),
                                                                                  reinterpret_cast<VkShaderModule *>( &shaderModule ) ) );
      VULKAN_HPP_NAMESPACE::detail::resultCheck( result, VULKAN_HPP_RAII_NAMESPACE_STRING "::Device::createShaderModule" );
      return VULKAN_HPP_NAMESPACE::detail::createResultValueType( result,
                                                                  ShaderModule( *this, *reinterpret_cast<VkShaderModule *>( &shaderModule ), allocator ) );
    }

    // wrapper function for command vkCreatePipelineCache, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreatePipelineCache.html
    VULKAN_HPP_NODISCARD VULKAN_HPP_INLINE typename ResultValueType<PipelineCache>::type
                         Device::createPipelineCache( PipelineCacheCreateInfo const &     createInfo,
                                   Optional<const AllocationCallbacks> allocator ) const VULKAN_HPP_NOEXCEPT_WHEN_NO_EXCEPTIONS
    {
      VULKAN_HPP_NAMESPACE::PipelineCache pipelineCache;
      Result                              result = static_cast<Result>( getDispatcher()->vkCreatePipelineCache( static_cast<VkDevice>( m_device ),
                                                                                   reinterpret_cast<const VkPipelineCacheCreateInfo *>( &createInfo ),
                                                                                   reinterpret_cast<const VkAllocationCallbacks *>( allocator.get() ),
                                                                                   reinterpret_cast<VkPipelineCache *>( &pipelineCache ) ) );
      VULKAN_HPP_NAMESPACE::detail::resultCheck( result, VULKAN_HPP_RAII_NAMESPACE_STRING "::Device::createPipelineCache" );
      return VULKAN_HPP_NAMESPACE::detail::createResultValueType( result,
                                                                  PipelineCache( *this, *reinterpret_cast<VkPipelineCache *>( &pipelineCache ), allocator ) );
    }

    // wrapper function for command vkGetPipelineCacheData, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetPipelineCacheData.html
    VULKAN_HPP_NODISCARD VULKAN_HPP_INLINE typename ResultValueType<std::vector<uint8_t>>::type PipelineCache::getData() const
    {
      VULKAN_HPP_ASSERT( getDispatcher()->vkGetPipelineCacheData && "Function <vkGetPipelineCacheData> requires <VK_VERSION_1_0>" );

      std::vector<uint8_t> data;
      size_t               dataSize;
      Result               result;
      do
      {
        result = static_cast<Result>(
          getDispatcher()->vkGetPipelineCacheData( static_cast<VkDevice>( m_device ), static_cast<VkPipelineCache>( m_pipelineCache ), &dataSize, nullptr ) );
        if ( ( result == Result::eSuccess ) && dataSize )
        {
          data.resize( dataSize );
          result = static_cast<Result>( getDispatcher()->vkGetPipelineCacheData(
            static_cast<VkDevice>( m_device ), static_cast<VkPipelineCache>( m_pipelineCache ), &dataSize, reinterpret_cast<void *>( data.data() ) ) );
        }
      } while ( result == Result::eIncomplete );
      VULKAN_HPP_NAMESPACE::detail::resultCheck( result, VULKAN_HPP_RAII_NAMESPACE_STRING "::PipelineCache::getData" );
      VULKAN_HPP_ASSERT( dataSize <= data.size() );
      if ( dataSize < data.size() )
      {
        data.resize( dataSize );
      }
      return VULKAN_HPP_NAMESPACE::detail::createResultValueType( result, std::move( data ) );
    }

    // wrapper function for command vkMergePipelineCaches, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkMergePipelineCaches.html
    VULKAN_HPP_INLINE typename ResultValueType<void>::type PipelineCache::merge( ArrayProxy<const VULKAN_HPP_NAMESPACE::PipelineCache> const & srcCaches ) const
    {
      VULKAN_HPP_ASSERT( getDispatcher()->vkMergePipelineCaches && "Function <vkMergePipelineCaches> requires <VK_VERSION_1_0>" );

      Result result = static_cast<Result>( getDispatcher()->vkMergePipelineCaches( static_cast<VkDevice>( m_device ),
                                                                                   static_cast<VkPipelineCache>( m_pipelineCache ),
                                                                                   srcCaches.size(),
                                                                                   reinterpret_cast<const VkPipelineCache *>( srcCaches.data() ) ) );
      VULKAN_HPP_NAMESPACE::detail::resultCheck( result, VULKAN_HPP_RAII_NAMESPACE_STRING "::PipelineCache::merge" );

      return VULKAN_HPP_NAMESPACE::detail::createResultValueType( result );
    }

    // wrapper function for command vkCreateComputePipelines, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateComputePipelines.html
    VULKAN_HPP_NODISCARD VULKAN_HPP_INLINE typename ResultValueType<std::vector<Pipeline>>::type
                         Device::createComputePipelines( Optional<const PipelineCache> const &         pipelineCache,
                                      ArrayProxy<ComputePipelineCreateInfo> const & createInfos,
                                      Optional<const AllocationCallbacks>           allocator ) const
    {
      std::vector<VULKAN_HPP_NAMESPACE::Pipeline> pipelines( createInfos.size() );
      Result                                      result =
        static_cast<Result>( getDispatcher()->vkCreateComputePipelines( static_cast<VkDevice>( m_device ),
                                                                        pipelineCache ? static_cast<VkPipelineCache>( **pipelineCache ) : 0,
                                                                        createInfos.size(),
                                                                        reinterpret_cast<const VkComputePipelineCreateInfo *>( createInfos.data() ),
                                                                        reinterpret_cast<const VkAllocationCallbacks *>( allocator.get() ),
                                                                        reinterpret_cast<VkPipeline *>( pipelines.data() ) ) );
      VULKAN_HPP_NAMESPACE::detail::resultCheck(
        result, VULKAN_HPP_RAII_NAMESPACE_STRING "::Device::createComputePipelines", { Result::eSuccess, Result::ePipelineCompileRequiredEXT } );
      std::vector<Pipeline> pipelinesRAII;
      if ( result == Result::eSuccess )
      {
        pipelinesRAII.reserve( pipelines.size() );
        for ( auto & pipeline : pipelines )
        {
          pipelinesRAII.emplace_back( *this, *reinterpret_cast<VkPipeline *>( &pipeline ), allocator, result );
        }
      }
      return VULKAN_HPP_NAMESPACE::detail::createResultValueType( result, std::move( pipelinesRAII ) );
    }

    // wrapper function for command vkCreateComputePipelines, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateComputePipelines.html
    VULKAN_HPP_NODISCARD VULKAN_HPP_INLINE typename ResultValueType<Pipeline>::type
                         Device::createComputePipeline( Optional<const PipelineCache> const & pipelineCache,
                                     ComputePipelineCreateInfo const &     createInfo,
                                     Optional<const AllocationCallbacks>   allocator ) const VULKAN_HPP_NOEXCEPT_WHEN_NO_EXCEPTIONS
    {
      VULKAN_HPP_NAMESPACE::Pipeline pipeline;
      Result                         result = static_cast<Result>( getDispatcher()->vkCreateComputePipelines( static_cast<VkDevice>( m_device ),
                                                                                      pipelineCache ? static_cast<VkPipelineCache>( **pipelineCache ) : 0,
                                                                                      1,
                                                                                      reinterpret_cast<const VkComputePipelineCreateInfo *>( &createInfo ),
                                                                                      reinterpret_cast<const VkAllocationCallbacks *>( allocator.get() ),
                                                                                      reinterpret_cast<VkPipeline *>( &pipeline ) ) );
      VULKAN_HPP_NAMESPACE::detail::resultCheck(
        result, VULKAN_HPP_RAII_NAMESPACE_STRING "::Device::createComputePipeline", { Result::eSuccess, Result::ePipelineCompileRequiredEXT } );
      return VULKAN_HPP_NAMESPACE::detail::createResultValueType( result, Pipeline( *this, *reinterpret_cast<VkPipeline *>( &pipeline ), allocator, result ) );
    }

    // wrapper function for command vkCreatePipelineLayout, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreatePipelineLayout.html
    VULKAN_HPP_NODISCARD VULKAN_HPP_INLINE typename ResultValueType<PipelineLayout>::type
                         Device::createPipelineLayout( PipelineLayoutCreateInfo const &    createInfo,
                                    Optional<const AllocationCallbacks> allocator ) const VULKAN_HPP_NOEXCEPT_WHEN_NO_EXCEPTIONS
    {
      VULKAN_HPP_NAMESPACE::PipelineLayout pipelineLayout;
      Result                               result = static_cast<Result>( getDispatcher()->vkCreatePipelineLayout( static_cast<VkDevice>( m_device ),
                                                                                    reinterpret_cast<const VkPipelineLayoutCreateInfo *>( &createInfo ),
                                                                                    reinterpret_cast<const VkAllocationCallbacks *>( allocator.get() ),
                                                                                    reinterpret_cast<VkPipelineLayout *>( &pipelineLayout ) ) );
      VULKAN_HPP_NAMESPACE::detail::resultCheck( result, VULKAN_HPP_RAII_NAMESPACE_STRING "::Device::createPipelineLayout" );
      return VULKAN_HPP_NAMESPACE::detail::createResultValueType(
        result, PipelineLayout( *this, *reinterpret_cast<VkPipelineLayout *>( &pipelineLayout ), allocator ) );
    }

    // wrapper function for command vkCreateSampler, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateSampler.html
    VULKAN_HPP_NODISCARD VULKAN_HPP_INLINE typename ResultValueType<Sampler>::type
      Device::createSampler( SamplerCreateInfo const & createInfo, Optional<const AllocationCallbacks> allocator ) const VULKAN_HPP_NOEXCEPT_WHEN_NO_EXCEPTIONS
    {
      VULKAN_HPP_NAMESPACE::Sampler sampler;
      Result                        result = static_cast<Result>( getDispatcher()->vkCreateSampler( static_cast<VkDevice>( m_device ),
                                                                             reinterpret_cast<const VkSamplerCreateInfo *>( &createInfo ),
                                                                             reinterpret_cast<const VkAllocationCallbacks *>( allocator.get() ),
                                                                             reinterpret_cast<VkSampler *>( &sampler ) ) );
      VULKAN_HPP_NAMESPACE::detail::resultCheck( result, VULKAN_HPP_RAII_NAMESPACE_STRING "::Device::createSampler" );
      return VULKAN_HPP_NAMESPACE::detail::createResultValueType( result, Sampler( *this, *reinterpret_cast<VkSampler *>( &sampler ), allocator ) );
    }

    // wrapper function for command vkCreateDescriptorSetLayout, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateDescriptorSetLayout.html
    VULKAN_HPP_NODISCARD VULKAN_HPP_INLINE typename ResultValueType<DescriptorSetLayout>::type
                         Device::createDescriptorSetLayout( DescriptorSetLayoutCreateInfo const & createInfo,
                                         Optional<const AllocationCallbacks>   allocator ) const VULKAN_HPP_NOEXCEPT_WHEN_NO_EXCEPTIONS
    {
      VULKAN_HPP_NAMESPACE::DescriptorSetLayout setLayout;
      Result                                    result =
        static_cast<Result>( getDispatcher()->vkCreateDescriptorSetLayout( static_cast<VkDevice>( m_device ),
                                                                           reinterpret_cast<const VkDescriptorSetLayoutCreateInfo *>( &createInfo ),
                                                                           reinterpret_cast<const VkAllocationCallbacks *>( allocator.get() ),
                                                                           reinterpret_cast<VkDescriptorSetLayout *>( &setLayout ) ) );
      VULKAN_HPP_NAMESPACE::detail::resultCheck( result, VULKAN_HPP_RAII_NAMESPACE_STRING "::Device::createDescriptorSetLayout" );
      return VULKAN_HPP_NAMESPACE::detail::createResultValueType(
        result, DescriptorSetLayout( *this, *reinterpret_cast<VkDescriptorSetLayout *>( &setLayout ), allocator ) );
    }

    // wrapper function for command vkCreateDescriptorPool, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateDescriptorPool.html
    VULKAN_HPP_NODISCARD VULKAN_HPP_INLINE typename ResultValueType<DescriptorPool>::type
                         Device::createDescriptorPool( DescriptorPoolCreateInfo const &    createInfo,
                                    Optional<const AllocationCallbacks> allocator ) const VULKAN_HPP_NOEXCEPT_WHEN_NO_EXCEPTIONS
    {
      VULKAN_HPP_NAMESPACE::DescriptorPool descriptorPool;
      Result                               result = static_cast<Result>( getDispatcher()->vkCreateDescriptorPool( static_cast<VkDevice>( m_device ),
                                                                                    reinterpret_cast<const VkDescriptorPoolCreateInfo *>( &createInfo ),
                                                                                    reinterpret_cast<const VkAllocationCallbacks *>( allocator.get() ),
                                                                                    reinterpret_cast<VkDescriptorPool *>( &descriptorPool ) ) );
      VULKAN_HPP_NAMESPACE::detail::resultCheck( result, VULKAN_HPP_RAII_NAMESPACE_STRING "::Device::createDescriptorPool" );
      return VULKAN_HPP_NAMESPACE::detail::createResultValueType(
        result, DescriptorPool( *this, *reinterpret_cast<VkDescriptorPool *>( &descriptorPool ), allocator ) );
    }

    // wrapper function for command vkResetDescriptorPool, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkResetDescriptorPool.html
    VULKAN_HPP_INLINE typename ResultValueType<void>::type DescriptorPool::reset( DescriptorPoolResetFlags flags ) const
    {
      VULKAN_HPP_ASSERT( getDispatcher()->vkResetDescriptorPool && "Function <vkResetDescriptorPool> requires <VK_VERSION_1_0>" );

      Result result = static_cast<Result>( getDispatcher()->vkResetDescriptorPool(
        static_cast<VkDevice>( m_device ), static_cast<VkDescriptorPool>( m_descriptorPool ), static_cast<VkDescriptorPoolResetFlags>( flags ) ) );
      VULKAN_HPP_NAMESPACE::detail::resultCheck( result, VULKAN_HPP_RAII_NAMESPACE_STRING "::DescriptorPool::reset" );

      return VULKAN_HPP_NAMESPACE::detail::createResultValueType( result );
    }

    // wrapper function for command vkAllocateDescriptorSets, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkAllocateDescriptorSets.html
    VULKAN_HPP_NODISCARD VULKAN_HPP_INLINE typename ResultValueType<std::vector<DescriptorSet>>::type
                         Device::allocateDescriptorSets( DescriptorSetAllocateInfo const & allocateInfo ) const
    {
      std::vector<VULKAN_HPP_NAMESPACE::DescriptorSet> descriptorSets( allocateInfo.descriptorSetCount );
      Result result = static_cast<Result>( getDispatcher()->vkAllocateDescriptorSets( static_cast<VkDevice>( m_device ),
                                                                                      reinterpret_cast<const VkDescriptorSetAllocateInfo *>( &allocateInfo ),
                                                                                      reinterpret_cast<VkDescriptorSet *>( descriptorSets.data() ) ) );
      VULKAN_HPP_NAMESPACE::detail::resultCheck( result, VULKAN_HPP_RAII_NAMESPACE_STRING "::Device::allocateDescriptorSets" );
      std::vector<DescriptorSet> descriptorSetsRAII;
      if ( result == Result::eSuccess )
      {
        descriptorSetsRAII.reserve( descriptorSets.size() );
        for ( auto & descriptorSet : descriptorSets )
        {
          descriptorSetsRAII.emplace_back(
            *this, *reinterpret_cast<VkDescriptorSet *>( &descriptorSet ), static_cast<VkDescriptorPool>( allocateInfo.descriptorPool ) );
        }
      }
      return VULKAN_HPP_NAMESPACE::detail::createResultValueType( result, std::move( descriptorSetsRAII ) );
    }

    // wrapper function for command vkUpdateDescriptorSets, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkUpdateDescriptorSets.html
    VULKAN_HPP_INLINE void Device::updateDescriptorSets( ArrayProxy<const WriteDescriptorSet> const & descriptorWrites,
                                                         ArrayProxy<const CopyDescriptorSet> const &  descriptorCopies ) const VULKAN_HPP_NOEXCEPT
    {
      VULKAN_HPP_ASSERT( getDispatcher()->vkUpdateDescriptorSets && "Function <vkUpdateDescriptorSets> requires <VK_VERSION_1_0>" );

      getDispatcher()->vkUpdateDescriptorSets( static_cast<VkDevice>( m_device ),
                                               descriptorWrites.size(),
                                               reinterpret_cast<const VkWriteDescriptorSet *>( descriptorWrites.data() ),
                                               descriptorCopies.size(),
                                               reinterpret_cast<const VkCopyDescriptorSet *>( descriptorCopies.data() ) );
    }

    // wrapper function for command vkCmdBindPipeline, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdBindPipeline.html
    VULKAN_HPP_INLINE void CommandBuffer::bindPipeline( PipelineBindPoint pipelineBindPoint, VULKAN_HPP_NAMESPACE::Pipeline pipeline ) const VULKAN_HPP_NOEXCEPT
    {
      VULKAN_HPP_ASSERT( getDispatcher()->vkCmdBindPipeline && "Function <vkCmdBindPipeline> requires <VK_VERSION_1_0>" );

      getDispatcher()->vkCmdBindPipeline(
        static_cast<VkCommandBuffer>( m_commandBuffer ), static_cast<VkPipelineBindPoint>( pipelineBindPoint ), static_cast<VkPipeline>( pipeline ) );
    }

    // wrapper function for command vkCmdBindDescriptorSets, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdBindDescriptorSets.html
    VULKAN_HPP_INLINE void CommandBuffer::bindDescriptorSets( PipelineBindPoint                                             pipelineBindPoint,
                                                              VULKAN_HPP_NAMESPACE::PipelineLayout                          layout,
                                                              uint32_t                                                      firstSet,
                                                              ArrayProxy<const VULKAN_HPP_NAMESPACE::DescriptorSet> const & descriptorSets,
                                                              ArrayProxy<const uint32_t> const & dynamicOffsets ) const VULKAN_HPP_NOEXCEPT
    {
      VULKAN_HPP_ASSERT( getDispatcher()->vkCmdBindDescriptorSets && "Function <vkCmdBindDescriptorSets> requires <VK_VERSION_1_0>" );

      getDispatcher()->vkCmdBindDescriptorSets( static_cast<VkCommandBuffer>( m_commandBuffer ),
                                                static_cast<VkPipelineBindPoint>( pipelineBindPoint ),
                                                static_cast<VkPipelineLayout>( layout ),
                                                firstSet,
                                                descriptorSets.size(),
                                                reinterpret_cast<const VkDescriptorSet *>( descriptorSets.data() ),
                                                dynamicOffsets.size(),
                                                dynamicOffsets.data() );
    }

    // wrapper function for command vkCmdClearColorImage, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdClearColorImage.html
    VULKAN_HPP_INLINE void CommandBuffer::clearColorImage( VULKAN_HPP_NAMESPACE::Image                     image,
                                                           ImageLayout                                     imageLayout,
                                                           const ClearColorValue &                         color,
                                                           ArrayProxy<const ImageSubresourceRange> const & ranges ) const VULKAN_HPP_NOEXCEPT
    {
      VULKAN_HPP_ASSERT( getDispatcher()->vkCmdClearColorImage && "Function <vkCmdClearColorImage> requires <VK_VERSION_1_0>" );

      getDispatcher()->vkCmdClearColorImage( static_cast<VkCommandBuffer>( m_commandBuffer ),
                                             static_cast<VkImage>( image ),
                                             static_cast<VkImageLayout>( imageLayout ),
                                             reinterpret_cast<const VkClearColorValue *>( &color ),
                                             ranges.size(),
                                             reinterpret_cast<const VkImageSubresourceRange *>( ranges.data() ) );
    }

    // wrapper function for command vkCmdDispatch, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdDispatch.html
    VULKAN_HPP_INLINE void CommandBuffer::dispatch( uint32_t groupCountX, uint32_t groupCountY, uint32_t groupCountZ ) const VULKAN_HPP_NOEXCEPT
    {
      VULKAN_HPP_ASSERT( getDispatcher()->vkCmdDispatch && "Function <vkCmdDispatch> requires <VK_VERSION_1_0>" );

      getDispatcher()->vkCmdDispatch( static_cast<VkCommandBuffer>( m_commandBuffer ), groupCountX, groupCountY, groupCountZ );
    }

    // wrapper function for command vkCmdDispatchIndirect, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdDispatchIndirect.html
    VULKAN_HPP_INLINE void CommandBuffer::dispatchIndirect( VULKAN_HPP_NAMESPACE::Buffer buffer, DeviceSize offset ) const VULKAN_HPP_NOEXCEPT
    {
      VULKAN_HPP_ASSERT( getDispatcher()->vkCmdDispatchIndirect && "Function <vkCmdDispatchIndirect> requires <VK_VERSION_1_0>" );

      getDispatcher()->vkCmdDispatchIndirect(
        static_cast<VkCommandBuffer>( m_commandBuffer ), static_cast<VkBuffer>( buffer ), static_cast<VkDeviceSize>( offset ) );
    }

    // wrapper function for command vkCmdSetEvent, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetEvent.html
    VULKAN_HPP_INLINE void CommandBuffer::setEvent( VULKAN_HPP_NAMESPACE::Event event, PipelineStageFlags stageMask ) const VULKAN_HPP_NOEXCEPT
    {
      VULKAN_HPP_ASSERT( getDispatcher()->vkCmdSetEvent && "Function <vkCmdSetEvent> requires <VK_VERSION_1_0>" );

      getDispatcher()->vkCmdSetEvent(
        static_cast<VkCommandBuffer>( m_commandBuffer ), static_cast<VkEvent>( event ), static_cast<VkPipelineStageFlags>( stageMask ) );
    }

    // wrapper function for command vkCmdResetEvent, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdResetEvent.html
    VULKAN_HPP_INLINE void CommandBuffer::resetEvent( VULKAN_HPP_NAMESPACE::Event event, PipelineStageFlags stageMask ) const VULKAN_HPP_NOEXCEPT
    {
      VULKAN_HPP_ASSERT( getDispatcher()->vkCmdResetEvent && "Function <vkCmdResetEvent> requires <VK_VERSION_1_0>" );

      getDispatcher()->vkCmdResetEvent(
        static_cast<VkCommandBuffer>( m_commandBuffer ), static_cast<VkEvent>( event ), static_cast<VkPipelineStageFlags>( stageMask ) );
    }

    // wrapper function for command vkCmdWaitEvents, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdWaitEvents.html
    VULKAN_HPP_INLINE void CommandBuffer::waitEvents( ArrayProxy<const VULKAN_HPP_NAMESPACE::Event> const & events,
                                                      PipelineStageFlags                                    srcStageMask,
                                                      PipelineStageFlags                                    dstStageMask,
                                                      ArrayProxy<const MemoryBarrier> const &               memoryBarriers,
                                                      ArrayProxy<const BufferMemoryBarrier> const &         bufferMemoryBarriers,
                                                      ArrayProxy<const ImageMemoryBarrier> const &          imageMemoryBarriers ) const VULKAN_HPP_NOEXCEPT
    {
      VULKAN_HPP_ASSERT( getDispatcher()->vkCmdWaitEvents && "Function <vkCmdWaitEvents> requires <VK_VERSION_1_0>" );

      getDispatcher()->vkCmdWaitEvents( static_cast<VkCommandBuffer>( m_commandBuffer ),
                                        events.size(),
                                        reinterpret_cast<const VkEvent *>( events.data() ),
                                        static_cast<VkPipelineStageFlags>( srcStageMask ),
                                        static_cast<VkPipelineStageFlags>( dstStageMask ),
                                        memoryBarriers.size(),
                                        reinterpret_cast<const VkMemoryBarrier *>( memoryBarriers.data() ),
                                        bufferMemoryBarriers.size(),
                                        reinterpret_cast<const VkBufferMemoryBarrier *>( bufferMemoryBarriers.data() ),
                                        imageMemoryBarriers.size(),
                                        reinterpret_cast<const VkImageMemoryBarrier *>( imageMemoryBarriers.data() ) );
    }

    // wrapper function for command vkCmdPushConstants, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdPushConstants.html
    template <typename ValuesType>
    VULKAN_HPP_INLINE void CommandBuffer::pushConstants( VULKAN_HPP_NAMESPACE::PipelineLayout layout,
                                                         ShaderStageFlags                     stageFlags,
                                                         uint32_t                             offset,
                                                         ArrayProxy<const ValuesType> const & values ) const VULKAN_HPP_NOEXCEPT
    {
      VULKAN_HPP_ASSERT( getDispatcher()->vkCmdPushConstants && "Function <vkCmdPushConstants> requires <VK_VERSION_1_0>" );

      getDispatcher()->vkCmdPushConstants( static_cast<VkCommandBuffer>( m_commandBuffer ),
                                           static_cast<VkPipelineLayout>( layout ),
                                           static_cast<VkShaderStageFlags>( stageFlags ),
                                           offset,
                                           values.size() * sizeof( ValuesType ),
                                           reinterpret_cast<const void *>( values.data() ) );
    }

    // wrapper function for command vkCreateGraphicsPipelines, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateGraphicsPipelines.html
    VULKAN_HPP_NODISCARD VULKAN_HPP_INLINE typename ResultValueType<std::vector<Pipeline>>::type
                         Device::createGraphicsPipelines( Optional<const PipelineCache> const &          pipelineCache,
                                       ArrayProxy<GraphicsPipelineCreateInfo> const & createInfos,
                                       Optional<const AllocationCallbacks>            allocator ) const
    {
      std::vector<VULKAN_HPP_NAMESPACE::Pipeline> pipelines( createInfos.size() );
      Result                                      result =
        static_cast<Result>( getDispatcher()->vkCreateGraphicsPipelines( static_cast<VkDevice>( m_device ),
                                                                         pipelineCache ? static_cast<VkPipelineCache>( **pipelineCache ) : 0,
                                                                         createInfos.size(),
                                                                         reinterpret_cast<const VkGraphicsPipelineCreateInfo *>( createInfos.data() ),
                                                                         reinterpret_cast<const VkAllocationCallbacks *>( allocator.get() ),
                                                                         reinterpret_cast<VkPipeline *>( pipelines.data() ) ) );
      VULKAN_HPP_NAMESPACE::detail::resultCheck(
        result, VULKAN_HPP_RAII_NAMESPACE_STRING "::Device::createGraphicsPipelines", { Result::eSuccess, Result::ePipelineCompileRequiredEXT } );
      std::vector<Pipeline> pipelinesRAII;
      if ( result == Result::eSuccess )
      {
        pipelinesRAII.reserve( pipelines.size() );
        for ( auto & pipeline : pipelines )
        {
          pipelinesRAII.emplace_back( *this, *reinterpret_cast<VkPipeline *>( &pipeline ), allocator, result );
        }
      }
      return VULKAN_HPP_NAMESPACE::detail::createResultValueType( result, std::move( pipelinesRAII ) );
    }

    // wrapper function for command vkCreateGraphicsPipelines, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateGraphicsPipelines.html
    VULKAN_HPP_NODISCARD VULKAN_HPP_INLINE typename ResultValueType<Pipeline>::type
                         Device::createGraphicsPipeline( Optional<const PipelineCache> const & pipelineCache,
                                      GraphicsPipelineCreateInfo const &    createInfo,
                                      Optional<const AllocationCallbacks>   allocator ) const VULKAN_HPP_NOEXCEPT_WHEN_NO_EXCEPTIONS
    {
      VULKAN_HPP_NAMESPACE::Pipeline pipeline;
      Result                         result = static_cast<Result>( getDispatcher()->vkCreateGraphicsPipelines( static_cast<VkDevice>( m_device ),
                                                                                       pipelineCache ? static_cast<VkPipelineCache>( **pipelineCache ) : 0,
                                                                                       1,
                                                                                       reinterpret_cast<const VkGraphicsPipelineCreateInfo *>( &createInfo ),
                                                                                       reinterpret_cast<const VkAllocationCallbacks *>( allocator.get() ),
                                                                                       reinterpret_cast<VkPipeline *>( &pipeline ) ) );
      VULKAN_HPP_NAMESPACE::detail::resultCheck(
        result, VULKAN_HPP_RAII_NAMESPACE_STRING "::Device::createGraphicsPipeline", { Result::eSuccess, Result::ePipelineCompileRequiredEXT } );
      return VULKAN_HPP_NAMESPACE::detail::createResultValueType( result, Pipeline( *this, *reinterpret_cast<VkPipeline *>( &pipeline ), allocator, result ) );
    }

    // wrapper function for command vkCreateFramebuffer, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateFramebuffer.html
    VULKAN_HPP_NODISCARD VULKAN_HPP_INLINE typename ResultValueType<Framebuffer>::type
                         Device::createFramebuffer( FramebufferCreateInfo const &       createInfo,
                                 Optional<const AllocationCallbacks> allocator ) const VULKAN_HPP_NOEXCEPT_WHEN_NO_EXCEPTIONS
    {
      VULKAN_HPP_NAMESPACE::Framebuffer framebuffer;
      Result                            result = static_cast<Result>( getDispatcher()->vkCreateFramebuffer( static_cast<VkDevice>( m_device ),
                                                                                 reinterpret_cast<const VkFramebufferCreateInfo *>( &createInfo ),
                                                                                 reinterpret_cast<const VkAllocationCallbacks *>( allocator.get() ),
                                                                                 reinterpret_cast<VkFramebuffer *>( &framebuffer ) ) );
      VULKAN_HPP_NAMESPACE::detail::resultCheck( result, VULKAN_HPP_RAII_NAMESPACE_STRING "::Device::createFramebuffer" );
      return VULKAN_HPP_NAMESPACE::detail::createResultValueType( result, Framebuffer( *this, *reinterpret_cast<VkFramebuffer *>( &framebuffer ), allocator ) );
    }

    // wrapper function for command vkCreateRenderPass, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateRenderPass.html
    VULKAN_HPP_NODISCARD VULKAN_HPP_INLINE typename ResultValueType<RenderPass>::type
                         Device::createRenderPass( RenderPassCreateInfo const &        createInfo,
                                Optional<const AllocationCallbacks> allocator ) const VULKAN_HPP_NOEXCEPT_WHEN_NO_EXCEPTIONS
    {
      VULKAN_HPP_NAMESPACE::RenderPass renderPass;
      Result                           result = static_cast<Result>( getDispatcher()->vkCreateRenderPass( static_cast<VkDevice>( m_device ),
                                                                                reinterpret_cast<const VkRenderPassCreateInfo *>( &createInfo ),
                                                                                reinterpret_cast<const VkAllocationCallbacks *>( allocator.get() ),
                                                                                reinterpret_cast<VkRenderPass *>( &renderPass ) ) );
      VULKAN_HPP_NAMESPACE::detail::resultCheck( result, VULKAN_HPP_RAII_NAMESPACE_STRING "::Device::createRenderPass" );
      return VULKAN_HPP_NAMESPACE::detail::createResultValueType( result, RenderPass( *this, *reinterpret_cast<VkRenderPass *>( &renderPass ), allocator ) );
    }

    // wrapper function for command vkGetRenderAreaGranularity, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetRenderAreaGranularity.html
    VULKAN_HPP_NODISCARD VULKAN_HPP_INLINE Extent2D RenderPass::getRenderAreaGranularity() const VULKAN_HPP_NOEXCEPT
    {
      VULKAN_HPP_ASSERT( getDispatcher()->vkGetRenderAreaGranularity && "Function <vkGetRenderAreaGranularity> requires <VK_VERSION_1_0>" );

      Extent2D granularity;
      getDispatcher()->vkGetRenderAreaGranularity(
        static_cast<VkDevice>( m_device ), static_cast<VkRenderPass>( m_renderPass ), reinterpret_cast<VkExtent2D *>( &granularity ) );

      return granularity;
    }

    // wrapper function for command vkCmdSetViewport, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetViewport.html
    VULKAN_HPP_INLINE void CommandBuffer::setViewport( uint32_t firstViewport, ArrayProxy<const Viewport> const & viewports ) const VULKAN_HPP_NOEXCEPT
    {
      VULKAN_HPP_ASSERT( getDispatcher()->vkCmdSetViewport && "Function <vkCmdSetViewport> requires <VK_VERSION_1_0>" );

      getDispatcher()->vkCmdSetViewport(
        static_cast<VkCommandBuffer>( m_commandBuffer ), firstViewport, viewports.size(), reinterpret_cast<const VkViewport *>( viewports.data() ) );
    }

    // wrapper function for command vkCmdSetScissor, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetScissor.html
    VULKAN_HPP_INLINE void CommandBuffer::setScissor( uint32_t firstScissor, ArrayProxy<const Rect2D> const & scissors ) const VULKAN_HPP_NOEXCEPT
    {
      VULKAN_HPP_ASSERT( getDispatcher()->vkCmdSetScissor && "Function <vkCmdSetScissor> requires <VK_VERSION_1_0>" );

      getDispatcher()->vkCmdSetScissor(
        static_cast<VkCommandBuffer>( m_commandBuffer ), firstScissor, scissors.size(), reinterpret_cast<const VkRect2D *>( scissors.data() ) );
    }

    // wrapper function for command vkCmdSetLineWidth, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetLineWidth.html
    VULKAN_HPP_INLINE void CommandBuffer::setLineWidth( float lineWidth ) const VULKAN_HPP_NOEXCEPT
    {
      VULKAN_HPP_ASSERT( getDispatcher()->vkCmdSetLineWidth && "Function <vkCmdSetLineWidth> requires <VK_VERSION_1_0>" );

      getDispatcher()->vkCmdSetLineWidth( static_cast<VkCommandBuffer>( m_commandBuffer ), lineWidth );
    }

    // wrapper function for command vkCmdSetDepthBias, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetDepthBias.html
    VULKAN_HPP_INLINE void
      CommandBuffer::setDepthBias( float depthBiasConstantFactor, float depthBiasClamp, float depthBiasSlopeFactor ) const VULKAN_HPP_NOEXCEPT
    {
      VULKAN_HPP_ASSERT( getDispatcher()->vkCmdSetDepthBias && "Function <vkCmdSetDepthBias> requires <VK_VERSION_1_0>" );

      getDispatcher()->vkCmdSetDepthBias( static_cast<VkCommandBuffer>( m_commandBuffer ), depthBiasConstantFactor, depthBiasClamp, depthBiasSlopeFactor );
    }

    // wrapper function for command vkCmdSetBlendConstants, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetBlendConstants.html
    VULKAN_HPP_INLINE void CommandBuffer::setBlendConstants( const float blendConstants[4] ) const VULKAN_HPP_NOEXCEPT
    {
      VULKAN_HPP_ASSERT( getDispatcher()->vkCmdSetBlendConstants && "Function <vkCmdSetBlendConstants> requires <VK_VERSION_1_0>" );

      getDispatcher()->vkCmdSetBlendConstants( static_cast<VkCommandBuffer>( m_commandBuffer ), blendConstants );
    }

    // wrapper function for command vkCmdSetDepthBounds, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetDepthBounds.html
    VULKAN_HPP_INLINE void CommandBuffer::setDepthBounds( float minDepthBounds, float maxDepthBounds ) const VULKAN_HPP_NOEXCEPT
    {
      VULKAN_HPP_ASSERT( getDispatcher()->vkCmdSetDepthBounds && "Function <vkCmdSetDepthBounds> requires <VK_VERSION_1_0>" );

      getDispatcher()->vkCmdSetDepthBounds( static_cast<VkCommandBuffer>( m_commandBuffer ), minDepthBounds, maxDepthBounds );
    }

    // wrapper function for command vkCmdSetStencilCompareMask, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetStencilCompareMask.html
    VULKAN_HPP_INLINE void CommandBuffer::setStencilCompareMask( StencilFaceFlags faceMask, uint32_t compareMask ) const VULKAN_HPP_NOEXCEPT
    {
      VULKAN_HPP_ASSERT( getDispatcher()->vkCmdSetStencilCompareMask && "Function <vkCmdSetStencilCompareMask> requires <VK_VERSION_1_0>" );

      getDispatcher()->vkCmdSetStencilCompareMask( static_cast<VkCommandBuffer>( m_commandBuffer ), static_cast<VkStencilFaceFlags>( faceMask ), compareMask );
    }

    // wrapper function for command vkCmdSetStencilWriteMask, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetStencilWriteMask.html
    VULKAN_HPP_INLINE void CommandBuffer::setStencilWriteMask( StencilFaceFlags faceMask, uint32_t writeMask ) const VULKAN_HPP_NOEXCEPT
    {
      VULKAN_HPP_ASSERT( getDispatcher()->vkCmdSetStencilWriteMask && "Function <vkCmdSetStencilWriteMask> requires <VK_VERSION_1_0>" );

      getDispatcher()->vkCmdSetStencilWriteMask( static_cast<VkCommandBuffer>( m_commandBuffer ), static_cast<VkStencilFaceFlags>( faceMask ), writeMask );
    }

    // wrapper function for command vkCmdSetStencilReference, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetStencilReference.html
    VULKAN_HPP_INLINE void CommandBuffer::setStencilReference( StencilFaceFlags faceMask, uint32_t reference ) const VULKAN_HPP_NOEXCEPT
    {
      VULKAN_HPP_ASSERT( getDispatcher()->vkCmdSetStencilReference && "Function <vkCmdSetStencilReference> requires <VK_VERSION_1_0>" );

      getDispatcher()->vkCmdSetStencilReference( static_cast<VkCommandBuffer>( m_commandBuffer ), static_cast<VkStencilFaceFlags>( faceMask ), reference );
    }

    // wrapper function for command vkCmdBindIndexBuffer, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdBindIndexBuffer.html
    VULKAN_HPP_INLINE void
      CommandBuffer::bindIndexBuffer( VULKAN_HPP_NAMESPACE::Buffer buffer, DeviceSize offset, IndexType indexType ) const VULKAN_HPP_NOEXCEPT
    {
      VULKAN_HPP_ASSERT( getDispatcher()->vkCmdBindIndexBuffer && "Function <vkCmdBindIndexBuffer> requires <VK_VERSION_1_0>" );

      getDispatcher()->vkCmdBindIndexBuffer( static_cast<VkCommandBuffer>( m_commandBuffer ),
                                             static_cast<VkBuffer>( buffer ),
                                             static_cast<VkDeviceSize>( offset ),
                                             static_cast<VkIndexType>( indexType ) );
    }

    // wrapper function for command vkCmdBindVertexBuffers, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdBindVertexBuffers.html
    VULKAN_HPP_INLINE void CommandBuffer::bindVertexBuffers( uint32_t                                               firstBinding,
                                                             ArrayProxy<const VULKAN_HPP_NAMESPACE::Buffer> const & buffers,
                                                             ArrayProxy<const DeviceSize> const &                   offsets ) const
    {
      VULKAN_HPP_ASSERT( getDispatcher()->vkCmdBindVertexBuffers && "Function <vkCmdBindVertexBuffers> requires <VK_VERSION_1_0>" );
#  ifdef VULKAN_HPP_NO_EXCEPTIONS
      VULKAN_HPP_ASSERT( buffers.size() == offsets.size() );
#  else
      if ( buffers.size() != offsets.size() )
      {
        throw LogicError( VULKAN_HPP_NAMESPACE_STRING "::CommandBuffer::bindVertexBuffers: buffers.size() != offsets.size()" );
      }
#  endif /*VULKAN_HPP_NO_EXCEPTIONS*/

      getDispatcher()->vkCmdBindVertexBuffers( static_cast<VkCommandBuffer>( m_commandBuffer ),
                                               firstBinding,
                                               buffers.size(),
                                               reinterpret_cast<const VkBuffer *>( buffers.data() ),
                                               reinterpret_cast<const VkDeviceSize *>( offsets.data() ) );
    }

    // wrapper function for command vkCmdDraw, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdDraw.html
    VULKAN_HPP_INLINE void
      CommandBuffer::draw( uint32_t vertexCount, uint32_t instanceCount, uint32_t firstVertex, uint32_t firstInstance ) const VULKAN_HPP_NOEXCEPT
    {
      VULKAN_HPP_ASSERT( getDispatcher()->vkCmdDraw && "Function <vkCmdDraw> requires <VK_VERSION_1_0>" );

      getDispatcher()->vkCmdDraw( static_cast<VkCommandBuffer>( m_commandBuffer ), vertexCount, instanceCount, firstVertex, firstInstance );
    }

    // wrapper function for command vkCmdDrawIndexed, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdDrawIndexed.html
    VULKAN_HPP_INLINE void CommandBuffer::drawIndexed(
      uint32_t indexCount, uint32_t instanceCount, uint32_t firstIndex, int32_t vertexOffset, uint32_t firstInstance ) const VULKAN_HPP_NOEXCEPT
    {
      VULKAN_HPP_ASSERT( getDispatcher()->vkCmdDrawIndexed && "Function <vkCmdDrawIndexed> requires <VK_VERSION_1_0>" );

      getDispatcher()->vkCmdDrawIndexed( static_cast<VkCommandBuffer>( m_commandBuffer ), indexCount, instanceCount, firstIndex, vertexOffset, firstInstance );
    }

    // wrapper function for command vkCmdDrawIndirect, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdDrawIndirect.html
    VULKAN_HPP_INLINE void
      CommandBuffer::drawIndirect( VULKAN_HPP_NAMESPACE::Buffer buffer, DeviceSize offset, uint32_t drawCount, uint32_t stride ) const VULKAN_HPP_NOEXCEPT
    {
      VULKAN_HPP_ASSERT( getDispatcher()->vkCmdDrawIndirect && "Function <vkCmdDrawIndirect> requires <VK_VERSION_1_0>" );

      getDispatcher()->vkCmdDrawIndirect(
        static_cast<VkCommandBuffer>( m_commandBuffer ), static_cast<VkBuffer>( buffer ), static_cast<VkDeviceSize>( offset ), drawCount, stride );
    }

    // wrapper function for command vkCmdDrawIndexedIndirect, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdDrawIndexedIndirect.html
    VULKAN_HPP_INLINE void CommandBuffer::drawIndexedIndirect( VULKAN_HPP_NAMESPACE::Buffer buffer,
                                                               DeviceSize                   offset,
                                                               uint32_t                     drawCount,
                                                               uint32_t                     stride ) const VULKAN_HPP_NOEXCEPT
    {
      VULKAN_HPP_ASSERT( getDispatcher()->vkCmdDrawIndexedIndirect && "Function <vkCmdDrawIndexedIndirect> requires <VK_VERSION_1_0>" );

      getDispatcher()->vkCmdDrawIndexedIndirect(
        static_cast<VkCommandBuffer>( m_commandBuffer ), static_cast<VkBuffer>( buffer ), static_cast<VkDeviceSize>( offset ), drawCount, stride );
    }

    // wrapper function for command vkCmdBlitImage, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdBlitImage.html
    VULKAN_HPP_INLINE void CommandBuffer::blitImage( VULKAN_HPP_NAMESPACE::Image         srcImage,
                                                     ImageLayout                         srcImageLayout,
                                                     VULKAN_HPP_NAMESPACE::Image         dstImage,
                                                     ImageLayout                         dstImageLayout,
                                                     ArrayProxy<const ImageBlit> const & regions,
                                                     Filter                              filter ) const VULKAN_HPP_NOEXCEPT
    {
      VULKAN_HPP_ASSERT( getDispatcher()->vkCmdBlitImage && "Function <vkCmdBlitImage> requires <VK_VERSION_1_0>" );

      getDispatcher()->vkCmdBlitImage( static_cast<VkCommandBuffer>( m_commandBuffer ),
                                       static_cast<VkImage>( srcImage ),
                                       static_cast<VkImageLayout>( srcImageLayout ),
                                       static_cast<VkImage>( dstImage ),
                                       static_cast<VkImageLayout>( dstImageLayout ),
                                       regions.size(),
                                       reinterpret_cast<const VkImageBlit *>( regions.data() ),
                                       static_cast<VkFilter>( filter ) );
    }

    // wrapper function for command vkCmdClearDepthStencilImage, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdClearDepthStencilImage.html
    VULKAN_HPP_INLINE void CommandBuffer::clearDepthStencilImage( VULKAN_HPP_NAMESPACE::Image                     image,
                                                                  ImageLayout                                     imageLayout,
                                                                  const ClearDepthStencilValue &                  depthStencil,
                                                                  ArrayProxy<const ImageSubresourceRange> const & ranges ) const VULKAN_HPP_NOEXCEPT
    {
      VULKAN_HPP_ASSERT( getDispatcher()->vkCmdClearDepthStencilImage && "Function <vkCmdClearDepthStencilImage> requires <VK_VERSION_1_0>" );

      getDispatcher()->vkCmdClearDepthStencilImage( static_cast<VkCommandBuffer>( m_commandBuffer ),
                                                    static_cast<VkImage>( image ),
                                                    static_cast<VkImageLayout>( imageLayout ),
                                                    reinterpret_cast<const VkClearDepthStencilValue *>( &depthStencil ),
                                                    ranges.size(),
                                                    reinterpret_cast<const VkImageSubresourceRange *>( ranges.data() ) );
    }

    // wrapper function for command vkCmdClearAttachments, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdClearAttachments.html
    VULKAN_HPP_INLINE void CommandBuffer::clearAttachments( ArrayProxy<const ClearAttachment> const & attachments,
                                                            ArrayProxy<const ClearRect> const &       rects ) const VULKAN_HPP_NOEXCEPT
    {
      VULKAN_HPP_ASSERT( getDispatcher()->vkCmdClearAttachments && "Function <vkCmdClearAttachments> requires <VK_VERSION_1_0>" );

      getDispatcher()->vkCmdClearAttachments( static_cast<VkCommandBuffer>( m_commandBuffer ),
                                              attachments.size(),
                                              reinterpret_cast<const VkClearAttachment *>( attachments.data() ),
                                              rects.size(),
                                              reinterpret_cast<const VkClearRect *>( rects.data() ) );
    }

    // wrapper function for command vkCmdResolveImage, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdResolveImage.html
    VULKAN_HPP_INLINE void CommandBuffer::resolveImage( VULKAN_HPP_NAMESPACE::Image            srcImage,
                                                        ImageLayout                            srcImageLayout,
                                                        VULKAN_HPP_NAMESPACE::Image            dstImage,
                                                        ImageLayout                            dstImageLayout,
                                                        ArrayProxy<const ImageResolve> const & regions ) const VULKAN_HPP_NOEXCEPT
    {
      VULKAN_HPP_ASSERT( getDispatcher()->vkCmdResolveImage && "Function <vkCmdResolveImage> requires <VK_VERSION_1_0>" );

      getDispatcher()->vkCmdResolveImage( static_cast<VkCommandBuffer>( m_commandBuffer ),
                                          static_cast<VkImage>( srcImage ),
                                          static_cast<VkImageLayout>( srcImageLayout ),
                                          static_cast<VkImage>( dstImage ),
                                          static_cast<VkImageLayout>( dstImageLayout ),
                                          regions.size(),
                                          reinterpret_cast<const VkImageResolve *>( regions.data() ) );
    }

    // wrapper function for command vkCmdBeginRenderPass, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdBeginRenderPass.html
    VULKAN_HPP_INLINE void CommandBuffer::beginRenderPass( const RenderPassBeginInfo & renderPassBegin, SubpassContents contents ) const VULKAN_HPP_NOEXCEPT
    {
      VULKAN_HPP_ASSERT( getDispatcher()->vkCmdBeginRenderPass && "Function <vkCmdBeginRenderPass> requires <VK_VERSION_1_0>" );

      getDispatcher()->vkCmdBeginRenderPass( static_cast<VkCommandBuffer>( m_commandBuffer ),
                                             reinterpret_cast<const VkRenderPassBeginInfo *>( &renderPassBegin ),
                                             static_cast<VkSubpassContents>( contents ) );
    }

    // wrapper function for command vkCmdNextSubpass, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdNextSubpass.html
    VULKAN_HPP_INLINE void CommandBuffer::nextSubpass( SubpassContents contents ) const VULKAN_HPP_NOEXCEPT
    {
      VULKAN_HPP_ASSERT( getDispatcher()->vkCmdNextSubpass && "Function <vkCmdNextSubpass> requires <VK_VERSION_1_0>" );

      getDispatcher()->vkCmdNextSubpass( static_cast<VkCommandBuffer>( m_commandBuffer ), static_cast<VkSubpassContents>( contents ) );
    }

    // wrapper function for command vkCmdEndRenderPass, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdEndRenderPass.html
    VULKAN_HPP_INLINE void CommandBuffer::endRenderPass() const VULKAN_HPP_NOEXCEPT
    {
      VULKAN_HPP_ASSERT( getDispatcher()->vkCmdEndRenderPass && "Function <vkCmdEndRenderPass> requires <VK_VERSION_1_0>" );

      getDispatcher()->vkCmdEndRenderPass( static_cast<VkCommandBuffer>( m_commandBuffer ) );
    }

    //=== VK_VERSION_1_1 ===

    // wrapper function for command vkEnumerateInstanceVersion, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkEnumerateInstanceVersion.html
    VULKAN_HPP_NODISCARD VULKAN_HPP_INLINE typename ResultValueType<uint32_t>::type Context::enumerateInstanceVersion() const
    {
      VULKAN_HPP_ASSERT( getDispatcher()->vkEnumerateInstanceVersion && "Function <vkEnumerateInstanceVersion> requires <VK_VERSION_1_1>" );

      uint32_t apiVersion;
      Result   result = static_cast<Result>( getDispatcher()->vkEnumerateInstanceVersion( &apiVersion ) );
      VULKAN_HPP_NAMESPACE::detail::resultCheck( result, VULKAN_HPP_RAII_NAMESPACE_STRING "::Context::enumerateInstanceVersion" );

      return VULKAN_HPP_NAMESPACE::detail::createResultValueType( result, std::move( apiVersion ) );
    }

    // wrapper function for command vkBindBufferMemory2, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkBindBufferMemory2.html
    VULKAN_HPP_INLINE typename ResultValueType<void>::type Device::bindBufferMemory2( ArrayProxy<const BindBufferMemoryInfo> const & bindInfos ) const
    {
      VULKAN_HPP_ASSERT( getDispatcher()->vkBindBufferMemory2 && "Function <vkBindBufferMemory2> requires <VK_KHR_bind_memory2> or <VK_VERSION_1_1>" );

      Result result = static_cast<Result>( getDispatcher()->vkBindBufferMemory2(
        static_cast<VkDevice>( m_device ), bindInfos.size(), reinterpret_cast<const VkBindBufferMemoryInfo *>( bindInfos.data() ) ) );
      VULKAN_HPP_NAMESPACE::detail::resultCheck( result, VULKAN_HPP_RAII_NAMESPACE_STRING "::Device::bindBufferMemory2" );

      return VULKAN_HPP_NAMESPACE::detail::createResultValueType( result );
    }

    // wrapper function for command vkBindImageMemory2, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkBindImageMemory2.html
    VULKAN_HPP_INLINE typename ResultValueType<void>::type Device::bindImageMemory2( ArrayProxy<const BindImageMemoryInfo> const & bindInfos ) const
    {
      VULKAN_HPP_ASSERT( getDispatcher()->vkBindImageMemory2 && "Function <vkBindImageMemory2> requires <VK_KHR_bind_memory2> or <VK_VERSION_1_1>" );

      Result result = static_cast<Result>( getDispatcher()->vkBindImageMemory2(
        static_cast<VkDevice>( m_device ), bindInfos.size(), reinterpret_cast<const VkBindImageMemoryInfo *>( bindInfos.data() ) ) );
      VULKAN_HPP_NAMESPACE::detail::resultCheck( result, VULKAN_HPP_RAII_NAMESPACE_STRING "::Device::bindImageMemory2" );

      return VULKAN_HPP_NAMESPACE::detail::createResultValueType( result );
    }

    // wrapper function for command vkGetDeviceGroupPeerMemoryFeatures, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetDeviceGroupPeerMemoryFeatures.html
    VULKAN_HPP_NODISCARD VULKAN_HPP_INLINE PeerMemoryFeatureFlags Device::getGroupPeerMemoryFeatures( uint32_t heapIndex,
                                                                                                      uint32_t localDeviceIndex,
                                                                                                      uint32_t remoteDeviceIndex ) const VULKAN_HPP_NOEXCEPT
    {
      VULKAN_HPP_ASSERT( getDispatcher()->vkGetDeviceGroupPeerMemoryFeatures &&
                         "Function <vkGetDeviceGroupPeerMemoryFeatures> requires <VK_KHR_device_group> or <VK_VERSION_1_1>" );

      PeerMemoryFeatureFlags peerMemoryFeatures;
      getDispatcher()->vkGetDeviceGroupPeerMemoryFeatures( static_cast<VkDevice>( m_device ),
                                                           heapIndex,
                                                           localDeviceIndex,
                                                           remoteDeviceIndex,
                                                           reinterpret_cast<VkPeerMemoryFeatureFlags *>( &peerMemoryFeatures ) );

      return peerMemoryFeatures;
    }

    // wrapper function for command vkCmdSetDeviceMask, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdSetDeviceMask.html
    VULKAN_HPP_INLINE void CommandBuffer::setDeviceMask( uint32_t deviceMask ) const VULKAN_HPP_NOEXCEPT
    {
      VULKAN_HPP_ASSERT( getDispatcher()->vkCmdSetDeviceMask && "Function <vkCmdSetDeviceMask> requires <VK_KHR_device_group> or <VK_VERSION_1_1>" );

      getDispatcher()->vkCmdSetDeviceMask( static_cast<VkCommandBuffer>( m_commandBuffer ), deviceMask );
    }

    // wrapper function for command vkEnumeratePhysicalDeviceGroups, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkEnumeratePhysicalDeviceGroups.html
    VULKAN_HPP_NODISCARD VULKAN_HPP_INLINE typename ResultValueType<std::vector<PhysicalDeviceGroupProperties>>::type
                         Instance::enumeratePhysicalDeviceGroups() const
    {
      VULKAN_HPP_ASSERT( getDispatcher()->vkEnumeratePhysicalDeviceGroups &&
                         "Function <vkEnumeratePhysicalDeviceGroups> requires <VK_KHR_device_group_creation> or <VK_VERSION_1_1>" );

      std::vector<PhysicalDeviceGroupProperties> physicalDeviceGroupProperties;
      uint32_t                                   physicalDeviceGroupCount;
      Result                                     result;
      do
      {
        result =
          static_cast<Result>( getDispatcher()->vkEnumeratePhysicalDeviceGroups( static_cast<VkInstance>( m_instance ), &physicalDeviceGroupCount, nullptr ) );
        if ( ( result == Result::eSuccess ) && physicalDeviceGroupCount )
        {
          physicalDeviceGroupProperties.resize( physicalDeviceGroupCount );
          result = static_cast<Result>(
            getDispatcher()->vkEnumeratePhysicalDeviceGroups( static_cast<VkInstance>( m_instance ),
                                                              &physicalDeviceGroupCount,
                                                              reinterpret_cast<VkPhysicalDeviceGroupProperties *>( physicalDeviceGroupProperties.data() ) ) );
        }
      } while ( result == Result::eIncomplete );
      VULKAN_HPP_NAMESPACE::detail::resultCheck( result, VULKAN_HPP_RAII_NAMESPACE_STRING "::Instance::enumeratePhysicalDeviceGroups" );
      VULKAN_HPP_ASSERT( physicalDeviceGroupCount <= physicalDeviceGroupProperties.size() );
      if ( physicalDeviceGroupCount < physicalDeviceGroupProperties.size() )
      {
        physicalDeviceGroupProperties.resize( physicalDeviceGroupCount );
      }
      return VULKAN_HPP_NAMESPACE::detail::createResultValueType( result, std::move( physicalDeviceGroupProperties ) );
    }

    // wrapper function for command vkGetImageMemoryRequirements2, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetImageMemoryRequirements2.html
    VULKAN_HPP_NODISCARD VULKAN_HPP_INLINE MemoryRequirements2
      Device::getImageMemoryRequirements2( const ImageMemoryRequirementsInfo2 & info ) const VULKAN_HPP_NOEXCEPT
    {
      VULKAN_HPP_ASSERT( getDispatcher()->vkGetImageMemoryRequirements2 &&
                         "Function <vkGetImageMemoryRequirements2> requires <VK_KHR_get_memory_requirements2> or <VK_VERSION_1_1>" );

      MemoryRequirements2 memoryRequirements;
      getDispatcher()->vkGetImageMemoryRequirements2( static_cast<VkDevice>( m_device ),
                                                      reinterpret_cast<const VkImageMemoryRequirementsInfo2 *>( &info ),
                                                      reinterpret_cast<VkMemoryRequirements2 *>( &memoryRequirements ) );

      return memoryRequirements;
    }

    // wrapper function for command vkGetImageMemoryRequirements2, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetImageMemoryRequirements2.html
    template <typename X, typename Y, typename... Z>
    VULKAN_HPP_NODISCARD VULKAN_HPP_INLINE StructureChain<X, Y, Z...>
                                           Device::getImageMemoryRequirements2( const ImageMemoryRequirementsInfo2 & info ) const VULKAN_HPP_NOEXCEPT
    {
      VULKAN_HPP_ASSERT( getDispatcher()->vkGetImageMemoryRequirements2 &&
                         "Function <vkGetImageMemoryRequirements2> requires <VK_KHR_get_memory_requirements2> or <VK_VERSION_1_1>" );

      StructureChain<X, Y, Z...> structureChain;
      MemoryRequirements2 &      memoryRequirements = structureChain.template get<MemoryRequirements2>();
      getDispatcher()->vkGetImageMemoryRequirements2( static_cast<VkDevice>( m_device ),
                                                      reinterpret_cast<const VkImageMemoryRequirementsInfo2 *>( &info ),
                                                      reinterpret_cast<VkMemoryRequirements2 *>( &memoryRequirements ) );

      return structureChain;
    }

    // wrapper function for command vkGetBufferMemoryRequirements2, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetBufferMemoryRequirements2.html
    VULKAN_HPP_NODISCARD VULKAN_HPP_INLINE MemoryRequirements2
      Device::getBufferMemoryRequirements2( const BufferMemoryRequirementsInfo2 & info ) const VULKAN_HPP_NOEXCEPT
    {
      VULKAN_HPP_ASSERT( getDispatcher()->vkGetBufferMemoryRequirements2 &&
                         "Function <vkGetBufferMemoryRequirements2> requires <VK_KHR_get_memory_requirements2> or <VK_VERSION_1_1>" );

      MemoryRequirements2 memoryRequirements;
      getDispatcher()->vkGetBufferMemoryRequirements2( static_cast<VkDevice>( m_device ),
                                                       reinterpret_cast<const VkBufferMemoryRequirementsInfo2 *>( &info ),
                                                       reinterpret_cast<VkMemoryRequirements2 *>( &memoryRequirements ) );

      return memoryRequirements;
    }

    // wrapper function for command vkGetBufferMemoryRequirements2, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetBufferMemoryRequirements2.html
    template <typename X, typename Y, typename... Z>
    VULKAN_HPP_NODISCARD VULKAN_HPP_INLINE StructureChain<X, Y, Z...>
                                           Device::getBufferMemoryRequirements2( const BufferMemoryRequirementsInfo2 & info ) const VULKAN_HPP_NOEXCEPT
    {
      VULKAN_HPP_ASSERT( getDispatcher()->vkGetBufferMemoryRequirements2 &&
                         "Function <vkGetBufferMemoryRequirements2> requires <VK_KHR_get_memory_requirements2> or <VK_VERSION_1_1>" );

      StructureChain<X, Y, Z...> structureChain;
      MemoryRequirements2 &      memoryRequirements = structureChain.template get<MemoryRequirements2>();
      getDispatcher()->vkGetBufferMemoryRequirements2( static_cast<VkDevice>( m_device ),
                                                       reinterpret_cast<const VkBufferMemoryRequirementsInfo2 *>( &info ),
                                                       reinterpret_cast<VkMemoryRequirements2 *>( &memoryRequirements ) );

      return structureChain;
    }

    // wrapper function for command vkGetImageSparseMemoryRequirements2, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetImageSparseMemoryRequirements2.html
    VULKAN_HPP_NODISCARD VULKAN_HPP_INLINE std::vector<SparseImageMemoryRequirements2>
                                           Device::getImageSparseMemoryRequirements2( const ImageSparseMemoryRequirementsInfo2 & info ) const
    {
      VULKAN_HPP_ASSERT( getDispatcher()->vkGetImageSparseMemoryRequirements2 &&
                         "Function <vkGetImageSparseMemoryRequirements2> requires <VK_KHR_get_memory_requirements2> or <VK_VERSION_1_1>" );

      std::vector<SparseImageMemoryRequirements2> sparseMemoryRequirements;
      uint32_t                                    sparseMemoryRequirementCount;
      getDispatcher()->vkGetImageSparseMemoryRequirements2(
        static_cast<VkDevice>( m_device ), reinterpret_cast<const VkImageSparseMemoryRequirementsInfo2 *>( &info ), &sparseMemoryRequirementCount, nullptr );
      sparseMemoryRequirements.resize( sparseMemoryRequirementCount );
      getDispatcher()->vkGetImageSparseMemoryRequirements2( static_cast<VkDevice>( m_device ),
                                                            reinterpret_cast<const VkImageSparseMemoryRequirementsInfo2 *>( &info ),
                                                            &sparseMemoryRequirementCount,
                                                            reinterpret_cast<VkSparseImageMemoryRequirements2 *>( sparseMemoryRequirements.data() ) );

      VULKAN_HPP_ASSERT( sparseMemoryRequirementCount <= sparseMemoryRequirements.size() );
      if ( sparseMemoryRequirementCount < sparseMemoryRequirements.size() )
      {
        sparseMemoryRequirements.resize( sparseMemoryRequirementCount );
      }
      return sparseMemoryRequirements;
    }

    // wrapper function for command vkGetPhysicalDeviceFeatures2, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetPhysicalDeviceFeatures2.html
    VULKAN_HPP_NODISCARD VULKAN_HPP_INLINE PhysicalDeviceFeatures2 PhysicalDevice::getFeatures2() const VULKAN_HPP_NOEXCEPT
    {
      VULKAN_HPP_ASSERT( getDispatcher()->vkGetPhysicalDeviceFeatures2 &&
                         "Function <vkGetPhysicalDeviceFeatures2> requires <VK_KHR_get_physical_device_properties2> or <VK_VERSION_1_1>" );

      PhysicalDeviceFeatures2 features;
      getDispatcher()->vkGetPhysicalDeviceFeatures2( static_cast<VkPhysicalDevice>( m_physicalDevice ),
                                                     reinterpret_cast<VkPhysicalDeviceFeatures2 *>( &features ) );

      return features;
    }

    // wrapper function for command vkGetPhysicalDeviceFeatures2, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetPhysicalDeviceFeatures2.html
    template <typename X, typename Y, typename... Z>
    VULKAN_HPP_NODISCARD VULKAN_HPP_INLINE StructureChain<X, Y, Z...> PhysicalDevice::getFeatures2() const VULKAN_HPP_NOEXCEPT
    {
      VULKAN_HPP_ASSERT( getDispatcher()->vkGetPhysicalDeviceFeatures2 &&
                         "Function <vkGetPhysicalDeviceFeatures2> requires <VK_KHR_get_physical_device_properties2> or <VK_VERSION_1_1>" );

      StructureChain<X, Y, Z...> structureChain;
      PhysicalDeviceFeatures2 &  features = structureChain.template get<PhysicalDeviceFeatures2>();
      getDispatcher()->vkGetPhysicalDeviceFeatures2( static_cast<VkPhysicalDevice>( m_physicalDevice ),
                                                     reinterpret_cast<VkPhysicalDeviceFeatures2 *>( &features ) );

      return structureChain;
    }

    // wrapper function for command vkGetPhysicalDeviceProperties2, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetPhysicalDeviceProperties2.html
    VULKAN_HPP_NODISCARD VULKAN_HPP_INLINE PhysicalDeviceProperties2 PhysicalDevice::getProperties2() const VULKAN_HPP_NOEXCEPT
    {
      VULKAN_HPP_ASSERT( getDispatcher()->vkGetPhysicalDeviceProperties2 &&
                         "Function <vkGetPhysicalDeviceProperties2> requires <VK_KHR_get_physical_device_properties2> or <VK_VERSION_1_1>" );

      PhysicalDeviceProperties2 properties;
      getDispatcher()->vkGetPhysicalDeviceProperties2( static_cast<VkPhysicalDevice>( m_physicalDevice ),
                                                       reinterpret_cast<VkPhysicalDeviceProperties2 *>( &properties ) );

      return properties;
    }

    // wrapper function for command vkGetPhysicalDeviceProperties2, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetPhysicalDeviceProperties2.html
    template <typename X, typename Y, typename... Z>
    VULKAN_HPP_NODISCARD VULKAN_HPP_INLINE StructureChain<X, Y, Z...> PhysicalDevice::getProperties2() const VULKAN_HPP_NOEXCEPT
    {
      VULKAN_HPP_ASSERT( getDispatcher()->vkGetPhysicalDeviceProperties2 &&
                         "Function <vkGetPhysicalDeviceProperties2> requires <VK_KHR_get_physical_device_properties2> or <VK_VERSION_1_1>" );

      StructureChain<X, Y, Z...>  structureChain;
      PhysicalDeviceProperties2 & properties = structureChain.template get<PhysicalDeviceProperties2>();
      getDispatcher()->vkGetPhysicalDeviceProperties2( static_cast<VkPhysicalDevice>( m_physicalDevice ),
                                                       reinterpret_cast<VkPhysicalDeviceProperties2 *>( &properties ) );

      return structureChain;
    }

    // wrapper function for command vkGetPhysicalDeviceFormatProperties2, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetPhysicalDeviceFormatProperties2.html
    VULKAN_HPP_NODISCARD VULKAN_HPP_INLINE FormatProperties2 PhysicalDevice::getFormatProperties2( Format format ) const VULKAN_HPP_NOEXCEPT
    {
      VULKAN_HPP_ASSERT( getDispatcher()->vkGetPhysicalDeviceFormatProperties2 &&
                         "Function <vkGetPhysicalDeviceFormatProperties2> requires <VK_KHR_get_physical_device_properties2> or <VK_VERSION_1_1>" );

      FormatProperties2 formatProperties;
      getDispatcher()->vkGetPhysicalDeviceFormatProperties2(
        static_cast<VkPhysicalDevice>( m_physicalDevice ), static_cast<VkFormat>( format ), reinterpret_cast<VkFormatProperties2 *>( &formatProperties ) );

      return formatProperties;
    }

    // wrapper function for command vkGetPhysicalDeviceFormatProperties2, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetPhysicalDeviceFormatProperties2.html
    template <typename X, typename Y, typename... Z>
    VULKAN_HPP_NODISCARD VULKAN_HPP_INLINE StructureChain<X, Y, Z...> PhysicalDevice::getFormatProperties2( Format format ) const VULKAN_HPP_NOEXCEPT
    {
      VULKAN_HPP_ASSERT( getDispatcher()->vkGetPhysicalDeviceFormatProperties2 &&
                         "Function <vkGetPhysicalDeviceFormatProperties2> requires <VK_KHR_get_physical_device_properties2> or <VK_VERSION_1_1>" );

      StructureChain<X, Y, Z...> structureChain;
      FormatProperties2 &        formatProperties = structureChain.template get<FormatProperties2>();
      getDispatcher()->vkGetPhysicalDeviceFormatProperties2(
        static_cast<VkPhysicalDevice>( m_physicalDevice ), static_cast<VkFormat>( format ), reinterpret_cast<VkFormatProperties2 *>( &formatProperties ) );

      return structureChain;
    }

    // wrapper function for command vkGetPhysicalDeviceImageFormatProperties2, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetPhysicalDeviceImageFormatProperties2.html
    VULKAN_HPP_NODISCARD VULKAN_HPP_INLINE Result PhysicalDevice::getImageFormatProperties2(
      const PhysicalDeviceImageFormatInfo2 * pImageFormatInfo, ImageFormatProperties2 * pImageFormatProperties ) const VULKAN_HPP_NOEXCEPT
    {
      VULKAN_HPP_ASSERT( getDispatcher()->vkGetPhysicalDeviceImageFormatProperties2 &&
                         "Function <vkGetPhysicalDeviceImageFormatProperties2> requires <VK_KHR_get_physical_device_properties2> or <VK_VERSION_1_1>" );
      return static_cast<Result>(
        getDispatcher()->vkGetPhysicalDeviceImageFormatProperties2( static_cast<VkPhysicalDevice>( m_physicalDevice ),
                                                                    reinterpret_cast<const VkPhysicalDeviceImageFormatInfo2 *>( pImageFormatInfo ),
                                                                    reinterpret_cast<VkImageFormatProperties2 *>( pImageFormatProperties ) ) );
    }

    // wrapper function for command vkGetPhysicalDeviceImageFormatProperties2, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetPhysicalDeviceImageFormatProperties2.html
    VULKAN_HPP_NODISCARD VULKAN_HPP_INLINE typename ResultValueType<ImageFormatProperties2>::type
                         PhysicalDevice::getImageFormatProperties2( const PhysicalDeviceImageFormatInfo2 & imageFormatInfo ) const
    {
      VULKAN_HPP_ASSERT( getDispatcher()->vkGetPhysicalDeviceImageFormatProperties2 &&
                         "Function <vkGetPhysicalDeviceImageFormatProperties2> requires <VK_KHR_get_physical_device_properties2> or <VK_VERSION_1_1>" );

      ImageFormatProperties2 imageFormatProperties;
      Result                 result = static_cast<Result>(
        getDispatcher()->vkGetPhysicalDeviceImageFormatProperties2( static_cast<VkPhysicalDevice>( m_physicalDevice ),
                                                                    reinterpret_cast<const VkPhysicalDeviceImageFormatInfo2 *>( &imageFormatInfo ),
                                                                    reinterpret_cast<VkImageFormatProperties2 *>( &imageFormatProperties ) ) );
      VULKAN_HPP_NAMESPACE::detail::resultCheck( result, VULKAN_HPP_RAII_NAMESPACE_STRING "::PhysicalDevice::getImageFormatProperties2" );

      return VULKAN_HPP_NAMESPACE::detail::createResultValueType( result, std::move( imageFormatProperties ) );
    }

    // wrapper function for command vkGetPhysicalDeviceImageFormatProperties2, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetPhysicalDeviceImageFormatProperties2.html
    template <typename X, typename Y, typename... Z>
    VULKAN_HPP_NODISCARD VULKAN_HPP_INLINE typename ResultValueType<StructureChain<X, Y, Z...>>::type
                         PhysicalDevice::getImageFormatProperties2( const PhysicalDeviceImageFormatInfo2 & imageFormatInfo ) const
    {
      VULKAN_HPP_ASSERT( getDispatcher()->vkGetPhysicalDeviceImageFormatProperties2 &&
                         "Function <vkGetPhysicalDeviceImageFormatProperties2> requires <VK_KHR_get_physical_device_properties2> or <VK_VERSION_1_1>" );

      StructureChain<X, Y, Z...> structureChain;
      ImageFormatProperties2 &   imageFormatProperties = structureChain.template get<ImageFormatProperties2>();
      Result                     result                = static_cast<Result>(
        getDispatcher()->vkGetPhysicalDeviceImageFormatProperties2( static_cast<VkPhysicalDevice>( m_physicalDevice ),
                                                                    reinterpret_cast<const VkPhysicalDeviceImageFormatInfo2 *>( &imageFormatInfo ),
                                                                    reinterpret_cast<VkImageFormatProperties2 *>( &imageFormatProperties ) ) );
      VULKAN_HPP_NAMESPACE::detail::resultCheck( result, VULKAN_HPP_RAII_NAMESPACE_STRING "::PhysicalDevice::getImageFormatProperties2" );

      return VULKAN_HPP_NAMESPACE::detail::createResultValueType( result, std::move( structureChain ) );
    }

    // wrapper function for command vkGetPhysicalDeviceQueueFamilyProperties2, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetPhysicalDeviceQueueFamilyProperties2.html
    VULKAN_HPP_NODISCARD VULKAN_HPP_INLINE std::vector<QueueFamilyProperties2> PhysicalDevice::getQueueFamilyProperties2() const
    {
      VULKAN_HPP_ASSERT( getDispatcher()->vkGetPhysicalDeviceQueueFamilyProperties2 &&
                         "Function <vkGetPhysicalDeviceQueueFamilyProperties2> requires <VK_KHR_get_physical_device_properties2> or <VK_VERSION_1_1>" );

      std::vector<QueueFamilyProperties2> queueFamilyProperties;
      uint32_t                            queueFamilyPropertyCount;
      getDispatcher()->vkGetPhysicalDeviceQueueFamilyProperties2( static_cast<VkPhysicalDevice>( m_physicalDevice ), &queueFamilyPropertyCount, nullptr );
      queueFamilyProperties.resize( queueFamilyPropertyCount );
      getDispatcher()->vkGetPhysicalDeviceQueueFamilyProperties2( static_cast<VkPhysicalDevice>( m_physicalDevice ),
                                                                  &queueFamilyPropertyCount,
                                                                  reinterpret_cast<VkQueueFamilyProperties2 *>( queueFamilyProperties.data() ) );

      VULKAN_HPP_ASSERT( queueFamilyPropertyCount <= queueFamilyProperties.size() );
      if ( queueFamilyPropertyCount < queueFamilyProperties.size() )
      {
        queueFamilyProperties.resize( queueFamilyPropertyCount );
      }
      return queueFamilyProperties;
    }

    // wrapper function for command vkGetPhysicalDeviceQueueFamilyProperties2, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetPhysicalDeviceQueueFamilyProperties2.html
    template <typename StructureChain>
    VULKAN_HPP_NODISCARD VULKAN_HPP_INLINE std::vector<StructureChain> PhysicalDevice::getQueueFamilyProperties2() const
    {
      VULKAN_HPP_ASSERT( getDispatcher()->vkGetPhysicalDeviceQueueFamilyProperties2 &&
                         "Function <vkGetPhysicalDeviceQueueFamilyProperties2> requires <VK_KHR_get_physical_device_properties2> or <VK_VERSION_1_1>" );

      std::vector<StructureChain>         structureChains;
      std::vector<QueueFamilyProperties2> queueFamilyProperties;
      uint32_t                            queueFamilyPropertyCount;
      getDispatcher()->vkGetPhysicalDeviceQueueFamilyProperties2( static_cast<VkPhysicalDevice>( m_physicalDevice ), &queueFamilyPropertyCount, nullptr );
      structureChains.resize( queueFamilyPropertyCount );
      queueFamilyProperties.resize( queueFamilyPropertyCount );
      for ( uint32_t i = 0; i < queueFamilyPropertyCount; i++ )
      {
        queueFamilyProperties[i].pNext = structureChains[i].template get<QueueFamilyProperties2>().pNext;
      }
      getDispatcher()->vkGetPhysicalDeviceQueueFamilyProperties2( static_cast<VkPhysicalDevice>( m_physicalDevice ),
                                                                  &queueFamilyPropertyCount,
                                                                  reinterpret_cast<VkQueueFamilyProperties2 *>( queueFamilyProperties.data() ) );

      VULKAN_HPP_ASSERT( queueFamilyPropertyCount <= queueFamilyProperties.size() );
      if ( queueFamilyPropertyCount < queueFamilyProperties.size() )
      {
        structureChains.resize( queueFamilyPropertyCount );
      }
      for ( uint32_t i = 0; i < queueFamilyPropertyCount; i++ )
      {
        structureChains[i].template get<QueueFamilyProperties2>() = queueFamilyProperties[i];
      }
      return structureChains;
    }

    // wrapper function for command vkGetPhysicalDeviceMemoryProperties2, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetPhysicalDeviceMemoryProperties2.html
    VULKAN_HPP_NODISCARD VULKAN_HPP_INLINE PhysicalDeviceMemoryProperties2 PhysicalDevice::getMemoryProperties2() const VULKAN_HPP_NOEXCEPT
    {
      VULKAN_HPP_ASSERT( getDispatcher()->vkGetPhysicalDeviceMemoryProperties2 &&
                         "Function <vkGetPhysicalDeviceMemoryProperties2> requires <VK_KHR_get_physical_device_properties2> or <VK_VERSION_1_1>" );

      PhysicalDeviceMemoryProperties2 memoryProperties;
      getDispatcher()->vkGetPhysicalDeviceMemoryProperties2( static_cast<VkPhysicalDevice>( m_physicalDevice ),
                                                             reinterpret_cast<VkPhysicalDeviceMemoryProperties2 *>( &memoryProperties ) );

      return memoryProperties;
    }

    // wrapper function for command vkGetPhysicalDeviceMemoryProperties2, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetPhysicalDeviceMemoryProperties2.html
    template <typename X, typename Y, typename... Z>
    VULKAN_HPP_NODISCARD VULKAN_HPP_INLINE StructureChain<X, Y, Z...> PhysicalDevice::getMemoryProperties2() const VULKAN_HPP_NOEXCEPT
    {
      VULKAN_HPP_ASSERT( getDispatcher()->vkGetPhysicalDeviceMemoryProperties2 &&
                         "Function <vkGetPhysicalDeviceMemoryProperties2> requires <VK_KHR_get_physical_device_properties2> or <VK_VERSION_1_1>" );

      StructureChain<X, Y, Z...>        structureChain;
      PhysicalDeviceMemoryProperties2 & memoryProperties = structureChain.template get<PhysicalDeviceMemoryProperties2>();
      getDispatcher()->vkGetPhysicalDeviceMemoryProperties2( static_cast<VkPhysicalDevice>( m_physicalDevice ),
                                                             reinterpret_cast<VkPhysicalDeviceMemoryProperties2 *>( &memoryProperties ) );

      return structureChain;
    }

    // wrapper function for command vkGetPhysicalDeviceSparseImageFormatProperties2, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetPhysicalDeviceSparseImageFormatProperties2.html
    VULKAN_HPP_NODISCARD VULKAN_HPP_INLINE std::vector<SparseImageFormatProperties2>
                                           PhysicalDevice::getSparseImageFormatProperties2( const PhysicalDeviceSparseImageFormatInfo2 & formatInfo ) const
    {
      VULKAN_HPP_ASSERT( getDispatcher()->vkGetPhysicalDeviceSparseImageFormatProperties2 &&
                         "Function <vkGetPhysicalDeviceSparseImageFormatProperties2> requires <VK_KHR_get_physical_device_properties2> or <VK_VERSION_1_1>" );

      std::vector<SparseImageFormatProperties2> properties;
      uint32_t                                  propertyCount;
      getDispatcher()->vkGetPhysicalDeviceSparseImageFormatProperties2( static_cast<VkPhysicalDevice>( m_physicalDevice ),
                                                                        reinterpret_cast<const VkPhysicalDeviceSparseImageFormatInfo2 *>( &formatInfo ),
                                                                        &propertyCount,
                                                                        nullptr );
      properties.resize( propertyCount );
      getDispatcher()->vkGetPhysicalDeviceSparseImageFormatProperties2( static_cast<VkPhysicalDevice>( m_physicalDevice ),
                                                                        reinterpret_cast<const VkPhysicalDeviceSparseImageFormatInfo2 *>( &formatInfo ),
                                                                        &propertyCount,
                                                                        reinterpret_cast<VkSparseImageFormatProperties2 *>( properties.data() ) );

      VULKAN_HPP_ASSERT( propertyCount <= properties.size() );
      if ( propertyCount < properties.size() )
      {
        properties.resize( propertyCount );
      }
      return properties;
    }

    // wrapper function for command vkTrimCommandPool, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkTrimCommandPool.html
    VULKAN_HPP_INLINE void CommandPool::trim( CommandPoolTrimFlags flags ) const VULKAN_HPP_NOEXCEPT
    {
      VULKAN_HPP_ASSERT( getDispatcher()->vkTrimCommandPool && "Function <vkTrimCommandPool> requires <VK_KHR_maintenance1> or <VK_VERSION_1_1>" );

      getDispatcher()->vkTrimCommandPool(
        static_cast<VkDevice>( m_device ), static_cast<VkCommandPool>( m_commandPool ), static_cast<VkCommandPoolTrimFlags>( flags ) );
    }

    // wrapper function for command vkGetDeviceQueue2, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetDeviceQueue2.html
    VULKAN_HPP_NODISCARD VULKAN_HPP_INLINE Queue Device::getQueue2( DeviceQueueInfo2 const & queueInfo ) const VULKAN_HPP_NOEXCEPT_WHEN_NO_EXCEPTIONS
    {
      VULKAN_HPP_NAMESPACE::Queue queue;
      getDispatcher()->vkGetDeviceQueue2(
        static_cast<VkDevice>( m_device ), reinterpret_cast<const VkDeviceQueueInfo2 *>( &queueInfo ), reinterpret_cast<VkQueue *>( &queue ) );

      return Queue( *this, *reinterpret_cast<VkQueue *>( &queue ) );
    }

    // wrapper function for command vkGetPhysicalDeviceExternalBufferProperties, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetPhysicalDeviceExternalBufferProperties.html
    VULKAN_HPP_NODISCARD VULKAN_HPP_INLINE ExternalBufferProperties
      PhysicalDevice::getExternalBufferProperties( const PhysicalDeviceExternalBufferInfo & externalBufferInfo ) const VULKAN_HPP_NOEXCEPT
    {
      VULKAN_HPP_ASSERT( getDispatcher()->vkGetPhysicalDeviceExternalBufferProperties &&
                         "Function <vkGetPhysicalDeviceExternalBufferProperties> requires <VK_KHR_external_memory_capabilities> or <VK_VERSION_1_1>" );

      ExternalBufferProperties externalBufferProperties;
      getDispatcher()->vkGetPhysicalDeviceExternalBufferProperties( static_cast<VkPhysicalDevice>( m_physicalDevice ),
                                                                    reinterpret_cast<const VkPhysicalDeviceExternalBufferInfo *>( &externalBufferInfo ),
                                                                    reinterpret_cast<VkExternalBufferProperties *>( &externalBufferProperties ) );

      return externalBufferProperties;
    }

    // wrapper function for command vkGetPhysicalDeviceExternalFenceProperties, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetPhysicalDeviceExternalFenceProperties.html
    VULKAN_HPP_NODISCARD VULKAN_HPP_INLINE ExternalFenceProperties
      PhysicalDevice::getExternalFenceProperties( const PhysicalDeviceExternalFenceInfo & externalFenceInfo ) const VULKAN_HPP_NOEXCEPT
    {
      VULKAN_HPP_ASSERT( getDispatcher()->vkGetPhysicalDeviceExternalFenceProperties &&
                         "Function <vkGetPhysicalDeviceExternalFenceProperties> requires <VK_KHR_external_fence_capabilities> or <VK_VERSION_1_1>" );

      ExternalFenceProperties externalFenceProperties;
      getDispatcher()->vkGetPhysicalDeviceExternalFenceProperties( static_cast<VkPhysicalDevice>( m_physicalDevice ),
                                                                   reinterpret_cast<const VkPhysicalDeviceExternalFenceInfo *>( &externalFenceInfo ),
                                                                   reinterpret_cast<VkExternalFenceProperties *>( &externalFenceProperties ) );

      return externalFenceProperties;
    }

    // wrapper function for command vkGetPhysicalDeviceExternalSemaphoreProperties, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetPhysicalDeviceExternalSemaphoreProperties.html
    VULKAN_HPP_NODISCARD VULKAN_HPP_INLINE ExternalSemaphoreProperties
      PhysicalDevice::getExternalSemaphoreProperties( const PhysicalDeviceExternalSemaphoreInfo & externalSemaphoreInfo ) const VULKAN_HPP_NOEXCEPT
    {
      VULKAN_HPP_ASSERT( getDispatcher()->vkGetPhysicalDeviceExternalSemaphoreProperties &&
                         "Function <vkGetPhysicalDeviceExternalSemaphoreProperties> requires <VK_KHR_external_semaphore_capabilities> or <VK_VERSION_1_1>" );

      ExternalSemaphoreProperties externalSemaphoreProperties;
      getDispatcher()->vkGetPhysicalDeviceExternalSemaphoreProperties(
        static_cast<VkPhysicalDevice>( m_physicalDevice ),
        reinterpret_cast<const VkPhysicalDeviceExternalSemaphoreInfo *>( &externalSemaphoreInfo ),
        reinterpret_cast<VkExternalSemaphoreProperties *>( &externalSemaphoreProperties ) );

      return externalSemaphoreProperties;
    }

    // wrapper function for command vkCmdDispatchBase, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdDispatchBase.html
    VULKAN_HPP_INLINE void CommandBuffer::dispatchBase( uint32_t baseGroupX,
                                                        uint32_t baseGroupY,
                                                        uint32_t baseGroupZ,
                                                        uint32_t groupCountX,
                                                        uint32_t groupCountY,
                                                        uint32_t groupCountZ ) const VULKAN_HPP_NOEXCEPT
    {
      VULKAN_HPP_ASSERT( getDispatcher()->vkCmdDispatchBase && "Function <vkCmdDispatchBase> requires <VK_KHR_device_group> or <VK_VERSION_1_1>" );

      getDispatcher()->vkCmdDispatchBase(
        static_cast<VkCommandBuffer>( m_commandBuffer ), baseGroupX, baseGroupY, baseGroupZ, groupCountX, groupCountY, groupCountZ );
    }

    // wrapper function for command vkCreateDescriptorUpdateTemplate, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateDescriptorUpdateTemplate.html
    VULKAN_HPP_NODISCARD VULKAN_HPP_INLINE typename ResultValueType<DescriptorUpdateTemplate>::type
                         Device::createDescriptorUpdateTemplate( DescriptorUpdateTemplateCreateInfo const & createInfo,
                                              Optional<const AllocationCallbacks>        allocator ) const VULKAN_HPP_NOEXCEPT_WHEN_NO_EXCEPTIONS
    {
      VULKAN_HPP_NAMESPACE::DescriptorUpdateTemplate descriptorUpdateTemplate;
      Result                                         result =
        static_cast<Result>( getDispatcher()->vkCreateDescriptorUpdateTemplate( static_cast<VkDevice>( m_device ),
                                                                                reinterpret_cast<const VkDescriptorUpdateTemplateCreateInfo *>( &createInfo ),
                                                                                reinterpret_cast<const VkAllocationCallbacks *>( allocator.get() ),
                                                                                reinterpret_cast<VkDescriptorUpdateTemplate *>( &descriptorUpdateTemplate ) ) );
      VULKAN_HPP_NAMESPACE::detail::resultCheck( result, VULKAN_HPP_RAII_NAMESPACE_STRING "::Device::createDescriptorUpdateTemplate" );
      return VULKAN_HPP_NAMESPACE::detail::createResultValueType(
        result, DescriptorUpdateTemplate( *this, *reinterpret_cast<VkDescriptorUpdateTemplate *>( &descriptorUpdateTemplate ), allocator ) );
    }

    // wrapper function for command vkUpdateDescriptorSetWithTemplate, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkUpdateDescriptorSetWithTemplate.html
    template <typename DataType>
    VULKAN_HPP_INLINE void DescriptorSet::updateWithTemplate( VULKAN_HPP_NAMESPACE::DescriptorUpdateTemplate descriptorUpdateTemplate,
                                                              DataType const &                               data ) const VULKAN_HPP_NOEXCEPT
    {
      VULKAN_HPP_ASSERT( getDispatcher()->vkUpdateDescriptorSetWithTemplate &&
                         "Function <vkUpdateDescriptorSetWithTemplate> requires <VK_KHR_descriptor_update_template> or <VK_VERSION_1_1>" );

      getDispatcher()->vkUpdateDescriptorSetWithTemplate( static_cast<VkDevice>( m_device ),
                                                          static_cast<VkDescriptorSet>( m_descriptorSet ),
                                                          static_cast<VkDescriptorUpdateTemplate>( descriptorUpdateTemplate ),
                                                          reinterpret_cast<const void *>( &data ) );
    }

    // wrapper function for command vkGetDescriptorSetLayoutSupport, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetDescriptorSetLayoutSupport.html
    VULKAN_HPP_NODISCARD VULKAN_HPP_INLINE DescriptorSetLayoutSupport
      Device::getDescriptorSetLayoutSupport( const DescriptorSetLayoutCreateInfo & createInfo ) const VULKAN_HPP_NOEXCEPT
    {
      VULKAN_HPP_ASSERT( getDispatcher()->vkGetDescriptorSetLayoutSupport &&
                         "Function <vkGetDescriptorSetLayoutSupport> requires <VK_KHR_maintenance3> or <VK_VERSION_1_1>" );

      DescriptorSetLayoutSupport support;
      getDispatcher()->vkGetDescriptorSetLayoutSupport( static_cast<VkDevice>( m_device ),
                                                        reinterpret_cast<const VkDescriptorSetLayoutCreateInfo *>( &createInfo ),
                                                        reinterpret_cast<VkDescriptorSetLayoutSupport *>( &support ) );

      return support;
    }

    // wrapper function for command vkGetDescriptorSetLayoutSupport, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetDescriptorSetLayoutSupport.html
    template <typename X, typename Y, typename... Z>
    VULKAN_HPP_NODISCARD VULKAN_HPP_INLINE StructureChain<X, Y, Z...>
                                           Device::getDescriptorSetLayoutSupport( const DescriptorSetLayoutCreateInfo & createInfo ) const VULKAN_HPP_NOEXCEPT
    {
      VULKAN_HPP_ASSERT( getDispatcher()->vkGetDescriptorSetLayoutSupport &&
                         "Function <vkGetDescriptorSetLayoutSupport> requires <VK_KHR_maintenance3> or <VK_VERSION_1_1>" );

      StructureChain<X, Y, Z...>   structureChain;
      DescriptorSetLayoutSupport & support = structureChain.template get<DescriptorSetLayoutSupport>();
      getDispatcher()->vkGetDescriptorSetLayoutSupport( static_cast<VkDevice>( m_device ),
                                                        reinterpret_cast<const VkDescriptorSetLayoutCreateInfo *>( &createInfo ),
                                                        reinterpret_cast<VkDescriptorSetLayoutSupport *>( &support ) );

      return structureChain;
    }

    // wrapper function for command vkCreateSamplerYcbcrConversion, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateSamplerYcbcrConversion.html
    VULKAN_HPP_NODISCARD VULKAN_HPP_INLINE typename ResultValueType<SamplerYcbcrConversion>::type
                         Device::createSamplerYcbcrConversion( SamplerYcbcrConversionCreateInfo const & createInfo,
                                            Optional<const AllocationCallbacks>      allocator ) const VULKAN_HPP_NOEXCEPT_WHEN_NO_EXCEPTIONS
    {
      VULKAN_HPP_NAMESPACE::SamplerYcbcrConversion ycbcrConversion;
      Result                                       result =
        static_cast<Result>( getDispatcher()->vkCreateSamplerYcbcrConversion( static_cast<VkDevice>( m_device ),
                                                                              reinterpret_cast<const VkSamplerYcbcrConversionCreateInfo *>( &createInfo ),
                                                                              reinterpret_cast<const VkAllocationCallbacks *>( allocator.get() ),
                                                                              reinterpret_cast<VkSamplerYcbcrConversion *>( &ycbcrConversion ) ) );
      VULKAN_HPP_NAMESPACE::detail::resultCheck( result, VULKAN_HPP_RAII_NAMESPACE_STRING "::Device::createSamplerYcbcrConversion" );
      return VULKAN_HPP_NAMESPACE::detail::createResultValueType(
        result, SamplerYcbcrConversion( *this, *reinterpret_cast<VkSamplerYcbcrConversion *>( &ycbcrConversion ), allocator ) );
    }

    //=== VK_VERSION_1_2 ===

    // wrapper function for command vkResetQueryPool, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkResetQueryPool.html
    VULKAN_HPP_INLINE void QueryPool::reset( uint32_t firstQuery, uint32_t queryCount ) const VULKAN_HPP_NOEXCEPT
    {
      VULKAN_HPP_ASSERT( getDispatcher()->vkResetQueryPool && "Function <vkResetQueryPool> requires <VK_EXT_host_query_reset> or <VK_VERSION_1_2>" );

      getDispatcher()->vkResetQueryPool( static_cast<VkDevice>( m_device ), static_cast<VkQueryPool>( m_queryPool ), firstQuery, queryCount );
    }

    // wrapper function for command vkGetSemaphoreCounterValue, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetSemaphoreCounterValue.html
    VULKAN_HPP_NODISCARD VULKAN_HPP_INLINE typename ResultValueType<uint64_t>::type Semaphore::getCounterValue() const
    {
      VULKAN_HPP_ASSERT( getDispatcher()->vkGetSemaphoreCounterValue &&
                         "Function <vkGetSemaphoreCounterValue> requires <VK_KHR_timeline_semaphore> or <VK_VERSION_1_2>" );

      uint64_t value;
      Result   result = static_cast<Result>(
        getDispatcher()->vkGetSemaphoreCounterValue( static_cast<VkDevice>( m_device ), static_cast<VkSemaphore>( m_semaphore ), &value ) );
      VULKAN_HPP_NAMESPACE::detail::resultCheck( result, VULKAN_HPP_RAII_NAMESPACE_STRING "::Semaphore::getCounterValue" );

      return VULKAN_HPP_NAMESPACE::detail::createResultValueType( result, std::move( value ) );
    }

    // wrapper function for command vkWaitSemaphores, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkWaitSemaphores.html
    VULKAN_HPP_NODISCARD VULKAN_HPP_INLINE Result Device::waitSemaphores( const SemaphoreWaitInfo & waitInfo, uint64_t timeout ) const
    {
      VULKAN_HPP_ASSERT( getDispatcher()->vkWaitSemaphores && "Function <vkWaitSemaphores> requires <VK_KHR_timeline_semaphore> or <VK_VERSION_1_2>" );

      Result result = static_cast<Result>(
        getDispatcher()->vkWaitSemaphores( static_cast<VkDevice>( m_device ), reinterpret_cast<const VkSemaphoreWaitInfo *>( &waitInfo ), timeout ) );
      VULKAN_HPP_NAMESPACE::detail::resultCheck( result, VULKAN_HPP_RAII_NAMESPACE_STRING "::Device::waitSemaphores", { Result::eSuccess, Result::eTimeout } );

      return static_cast<Result>( result );
    }

    // wrapper function for command vkSignalSemaphore, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkSignalSemaphore.html
    VULKAN_HPP_INLINE typename ResultValueType<void>::type Device::signalSemaphore( const SemaphoreSignalInfo & signalInfo ) const
    {
      VULKAN_HPP_ASSERT( getDispatcher()->vkSignalSemaphore && "Function <vkSignalSemaphore> requires <VK_KHR_timeline_semaphore> or <VK_VERSION_1_2>" );

      Result result = static_cast<Result>(
        getDispatcher()->vkSignalSemaphore( static_cast<VkDevice>( m_device ), reinterpret_cast<const VkSemaphoreSignalInfo *>( &signalInfo ) ) );
      VULKAN_HPP_NAMESPACE::detail::resultCheck( result, VULKAN_HPP_RAII_NAMESPACE_STRING "::Device::signalSemaphore" );

      return VULKAN_HPP_NAMESPACE::detail::createResultValueType( result );
    }

    // wrapper function for command vkGetBufferDeviceAddress, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetBufferDeviceAddress.html
    VULKAN_HPP_NODISCARD VULKAN_HPP_INLINE DeviceAddress Device::getBufferAddress( const BufferDeviceAddressInfo & info ) const VULKAN_HPP_NOEXCEPT
    {
      VULKAN_HPP_ASSERT( getDispatcher()->vkGetBufferDeviceAddress &&
                         "Function <vkGetBufferDeviceAddress> requires <VK_EXT_buffer_device_address> or <VK_KHR_buffer_device_address> or <VK_VERSION_1_2>" );

      VkDeviceAddress result =
        getDispatcher()->vkGetBufferDeviceAddress( static_cast<VkDevice>( m_device ), reinterpret_cast<const VkBufferDeviceAddressInfo *>( &info ) );

      return static_cast<DeviceAddress>( result );
    }

    // wrapper function for command vkGetBufferOpaqueCaptureAddress, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetBufferOpaqueCaptureAddress.html
    VULKAN_HPP_NODISCARD VULKAN_HPP_INLINE uint64_t Device::getBufferOpaqueCaptureAddress( const BufferDeviceAddressInfo & info ) const VULKAN_HPP_NOEXCEPT
    {
      VULKAN_HPP_ASSERT( getDispatcher()->vkGetBufferOpaqueCaptureAddress &&
                         "Function <vkGetBufferOpaqueCaptureAddress> requires <VK_KHR_buffer_device_address> or <VK_VERSION_1_2>" );

      uint64_t result =
        getDispatcher()->vkGetBufferOpaqueCaptureAddress( static_cast<VkDevice>( m_device ), reinterpret_cast<const VkBufferDeviceAddressInfo *>( &info ) );

      return result;
    }

    // wrapper function for command vkGetDeviceMemoryOpaqueCaptureAddress, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetDeviceMemoryOpaqueCaptureAddress.html
    VULKAN_HPP_NODISCARD VULKAN_HPP_INLINE uint64_t
      Device::getMemoryOpaqueCaptureAddress( const DeviceMemoryOpaqueCaptureAddressInfo & info ) const VULKAN_HPP_NOEXCEPT
    {
      VULKAN_HPP_ASSERT( getDispatcher()->vkGetDeviceMemoryOpaqueCaptureAddress &&
                         "Function <vkGetDeviceMemoryOpaqueCaptureAddress> requires <VK_KHR_buffer_device_address> or <VK_VERSION_1_2>" );

      uint64_t result = getDispatcher()->vkGetDeviceMemoryOpaqueCaptureAddress( static_cast<VkDevice>( m_device ),
                                                                                reinterpret_cast<const VkDeviceMemoryOpaqueCaptureAddressInfo *>( &info ) );

      return result;
    }

    // wrapper function for command vkCmdDrawIndirectCount, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdDrawIndirectCount.html
    VULKAN_HPP_INLINE void CommandBuffer::drawIndirectCount( VULKAN_HPP_NAMESPACE::Buffer buffer,
                                                             DeviceSize                   offset,
                                                             VULKAN_HPP_NAMESPACE::Buffer countBuffer,
                                                             DeviceSize                   countBufferOffset,
                                                             uint32_t                     maxDrawCount,
                                                             uint32_t                     stride ) const VULKAN_HPP_NOEXCEPT
    {
      VULKAN_HPP_ASSERT( getDispatcher()->vkCmdDrawIndirectCount &&
                         "Function <vkCmdDrawIndirectCount> requires <VK_AMD_draw_indirect_count> or <VK_KHR_draw_indirect_count> or <VK_VERSION_1_2>" );

      getDispatcher()->vkCmdDrawIndirectCount( static_cast<VkCommandBuffer>( m_commandBuffer ),
                                               static_cast<VkBuffer>( buffer ),
                                               static_cast<VkDeviceSize>( offset ),
                                               static_cast<VkBuffer>( countBuffer ),
                                               static_cast<VkDeviceSize>( countBufferOffset ),
                                               maxDrawCount,
                                               stride );
    }

    // wrapper function for command vkCmdDrawIndexedIndirectCount, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdDrawIndexedIndirectCount.html
    VULKAN_HPP_INLINE void CommandBuffer::drawIndexedIndirectCount( VULKAN_HPP_NAMESPACE::Buffer buffer,
                                                                    DeviceSize                   offset,
                                                                    VULKAN_HPP_NAMESPACE::Buffer countBuffer,
                                                                    DeviceSize                   countBufferOffset,
                                                                    uint32_t                     maxDrawCount,
                                                                    uint32_t                     stride ) const VULKAN_HPP_NOEXCEPT
    {
      VULKAN_HPP_ASSERT( getDispatcher()->vkCmdDrawIndexedIndirectCount &&
                         "Function <vkCmdDrawIndexedIndirectCount> requires <VK_AMD_draw_indirect_count> or <VK_KHR_draw_indirect_count> or <VK_VERSION_1_2>" );

      getDispatcher()->vkCmdDrawIndexedIndirectCount( static_cast<VkCommandBuffer>( m_commandBuffer ),
                                                      static_cast<VkBuffer>( buffer ),
                                                      static_cast<VkDeviceSize>( offset ),
                                                      static_cast<VkBuffer>( countBuffer ),
                                                      static_cast<VkDeviceSize>( countBufferOffset ),
                                                      maxDrawCount,
                                                      stride );
    }

    // wrapper function for command vkCreateRenderPass2, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreateRenderPass2.html
    VULKAN_HPP_NODISCARD VULKAN_HPP_INLINE typename ResultValueType<RenderPass>::type
                         Device::createRenderPass2( RenderPassCreateInfo2 const &       createInfo,
                                 Optional<const AllocationCallbacks> allocator ) const VULKAN_HPP_NOEXCEPT_WHEN_NO_EXCEPTIONS
    {
      VULKAN_HPP_NAMESPACE::RenderPass renderPass;
      Result                           result = static_cast<Result>( getDispatcher()->vkCreateRenderPass2( static_cast<VkDevice>( m_device ),
                                                                                 reinterpret_cast<const VkRenderPassCreateInfo2 *>( &createInfo ),
                                                                                 reinterpret_cast<const VkAllocationCallbacks *>( allocator.get() ),
                                                                                 reinterpret_cast<VkRenderPass *>( &renderPass ) ) );
      VULKAN_HPP_NAMESPACE::detail::resultCheck( result, VULKAN_HPP_RAII_NAMESPACE_STRING "::Device::createRenderPass2" );
      return VULKAN_HPP_NAMESPACE::detail::createResultValueType( result, RenderPass( *this, *reinterpret_cast<VkRenderPass *>( &renderPass ), allocator ) );
    }

    // wrapper function for command vkCmdBeginRenderPass2, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdBeginRenderPass2.html
    VULKAN_HPP_INLINE void CommandBuffer::beginRenderPass2( const RenderPassBeginInfo & renderPassBegin,
                                                            const SubpassBeginInfo &    subpassBeginInfo ) const VULKAN_HPP_NOEXCEPT
    {
      VULKAN_HPP_ASSERT( getDispatcher()->vkCmdBeginRenderPass2 &&
                         "Function <vkCmdBeginRenderPass2> requires <VK_KHR_create_renderpass2> or <VK_VERSION_1_2>" );

      getDispatcher()->vkCmdBeginRenderPass2( static_cast<VkCommandBuffer>( m_commandBuffer ),
                                              reinterpret_cast<const VkRenderPassBeginInfo *>( &renderPassBegin ),
                                              reinterpret_cast<const VkSubpassBeginInfo *>( &subpassBeginInfo ) );
    }

    // wrapper function for command vkCmdNextSubpass2, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdNextSubpass2.html
    VULKAN_HPP_INLINE void CommandBuffer::nextSubpass2( const SubpassBeginInfo & subpassBeginInfo,
                                                        const SubpassEndInfo &   subpassEndInfo ) const VULKAN_HPP_NOEXCEPT
    {
      VULKAN_HPP_ASSERT( getDispatcher()->vkCmdNextSubpass2 && "Function <vkCmdNextSubpass2> requires <VK_KHR_create_renderpass2> or <VK_VERSION_1_2>" );

      getDispatcher()->vkCmdNextSubpass2( static_cast<VkCommandBuffer>( m_commandBuffer ),
                                          reinterpret_cast<const VkSubpassBeginInfo *>( &subpassBeginInfo ),
                                          reinterpret_cast<const VkSubpassEndInfo *>( &subpassEndInfo ) );
    }

    // wrapper function for command vkCmdEndRenderPass2, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdEndRenderPass2.html
    VULKAN_HPP_INLINE void CommandBuffer::endRenderPass2( const SubpassEndInfo & subpassEndInfo ) const VULKAN_HPP_NOEXCEPT
    {
      VULKAN_HPP_ASSERT( getDispatcher()->vkCmdEndRenderPass2 && "Function <vkCmdEndRenderPass2> requires <VK_KHR_create_renderpass2> or <VK_VERSION_1_2>" );

      getDispatcher()->vkCmdEndRenderPass2( static_cast<VkCommandBuffer>( m_commandBuffer ), reinterpret_cast<const VkSubpassEndInfo *>( &subpassEndInfo ) );
    }

    //=== VK_VERSION_1_3 ===

    // wrapper function for command vkGetPhysicalDeviceToolProperties, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetPhysicalDeviceToolProperties.html
    VULKAN_HPP_NODISCARD VULKAN_HPP_INLINE typename ResultValueType<std::vector<PhysicalDeviceToolProperties>>::type PhysicalDevice::getToolProperties() const
    {
      VULKAN_HPP_ASSERT( getDispatcher()->vkGetPhysicalDeviceToolProperties &&
                         "Function <vkGetPhysicalDeviceToolProperties> requires <VK_EXT_tooling_info> or <VK_VERSION_1_3>" );

      std::vector<PhysicalDeviceToolProperties> toolProperties;
      uint32_t                                  toolCount;
      Result                                    result;
      do
      {
        result =
          static_cast<Result>( getDispatcher()->vkGetPhysicalDeviceToolProperties( static_cast<VkPhysicalDevice>( m_physicalDevice ), &toolCount, nullptr ) );
        if ( ( result == Result::eSuccess ) && toolCount )
        {
          toolProperties.resize( toolCount );
          result = static_cast<Result>( getDispatcher()->vkGetPhysicalDeviceToolProperties(
            static_cast<VkPhysicalDevice>( m_physicalDevice ), &toolCount, reinterpret_cast<VkPhysicalDeviceToolProperties *>( toolProperties.data() ) ) );
        }
      } while ( result == Result::eIncomplete );
      VULKAN_HPP_NAMESPACE::detail::resultCheck( result, VULKAN_HPP_RAII_NAMESPACE_STRING "::PhysicalDevice::getToolProperties" );
      VULKAN_HPP_ASSERT( toolCount <= toolProperties.size() );
      if ( toolCount < toolProperties.size() )
      {
        toolProperties.resize( toolCount );
      }
      return VULKAN_HPP_NAMESPACE::detail::createResultValueType( result, std::move( toolProperties ) );
    }

    // wrapper function for command vkCreatePrivateDataSlot, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCreatePrivateDataSlot.html
    VULKAN_HPP_NODISCARD VULKAN_HPP_INLINE typename ResultValueType<PrivateDataSlot>::type
                         Device::createPrivateDataSlot( PrivateDataSlotCreateInfo const &   createInfo,
                                     Optional<const AllocationCallbacks> allocator ) const VULKAN_HPP_NOEXCEPT_WHEN_NO_EXCEPTIONS
    {
      VULKAN_HPP_NAMESPACE::PrivateDataSlot privateDataSlot;
      Result                                result = static_cast<Result>( getDispatcher()->vkCreatePrivateDataSlot( static_cast<VkDevice>( m_device ),
                                                                                     reinterpret_cast<const VkPrivateDataSlotCreateInfo *>( &createInfo ),
                                                                                     reinterpret_cast<const VkAllocationCallbacks *>( allocator.get() ),
                                                                                     reinterpret_cast<VkPrivateDataSlot *>( &privateDataSlot ) ) );
      VULKAN_HPP_NAMESPACE::detail::resultCheck( result, VULKAN_HPP_RAII_NAMESPACE_STRING "::Device::createPrivateDataSlot" );
      return VULKAN_HPP_NAMESPACE::detail::createResultValueType(
        result, PrivateDataSlot( *this, *reinterpret_cast<VkPrivateDataSlot *>( &privateDataSlot ), allocator ) );
    }

    // wrapper function for command vkSetPrivateData, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkSetPrivateData.html
    VULKAN_HPP_INLINE typename ResultValueType<void>::type
      Device::setPrivateData( ObjectType objectType_, uint64_t objectHandle, VULKAN_HPP_NAMESPACE::PrivateDataSlot privateDataSlot, uint64_t data ) const
    {
      VULKAN_HPP_ASSERT( getDispatcher()->vkSetPrivateData && "Function <vkSetPrivateData> requires <VK_EXT_private_data> or <VK_VERSION_1_3>" );

      Result result = static_cast<Result>( getDispatcher()->vkSetPrivateData(
        static_cast<VkDevice>( m_device ), static_cast<VkObjectType>( objectType_ ), objectHandle, static_cast<VkPrivateDataSlot>( privateDataSlot ), data ) );
      VULKAN_HPP_NAMESPACE::detail::resultCheck( result, VULKAN_HPP_RAII_NAMESPACE_STRING "::Device::setPrivateData" );

      return VULKAN_HPP_NAMESPACE::detail::createResultValueType( result );
    }

    // wrapper function for command vkGetPrivateData, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetPrivateData.html
    VULKAN_HPP_NODISCARD VULKAN_HPP_INLINE uint64_t Device::getPrivateData( ObjectType                            objectType_,
                                                                            uint64_t                              objectHandle,
                                                                            VULKAN_HPP_NAMESPACE::PrivateDataSlot privateDataSlot ) const VULKAN_HPP_NOEXCEPT
    {
      VULKAN_HPP_ASSERT( getDispatcher()->vkGetPrivateData && "Function <vkGetPrivateData> requires <VK_EXT_private_data> or <VK_VERSION_1_3>" );

      uint64_t data;
      getDispatcher()->vkGetPrivateData(
        static_cast<VkDevice>( m_device ), static_cast<VkObjectType>( objectType_ ), objectHandle, static_cast<VkPrivateDataSlot>( privateDataSlot ), &data );

      return data;
    }

    // wrapper function for command vkCmdPipelineBarrier2, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdPipelineBarrier2.html
    VULKAN_HPP_INLINE void CommandBuffer::pipelineBarrier2( const DependencyInfo & dependencyInfo ) const VULKAN_HPP_NOEXCEPT
    {
      VULKAN_HPP_ASSERT( getDispatcher()->vkCmdPipelineBarrier2 && "Function <vkCmdPipelineBarrier2> requires <VK_KHR_synchronization2> or <VK_VERSION_1_3>" );

      getDispatcher()->vkCmdPipelineBarrier2( static_cast<VkCommandBuffer>( m_commandBuffer ), reinterpret_cast<const VkDependencyInfo *>( &dependencyInfo ) );
    }

    // wrapper function for command vkCmdWriteTimestamp2, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdWriteTimestamp2.html
    VULKAN_HPP_INLINE void
      CommandBuffer::writeTimestamp2( PipelineStageFlags2 stage, VULKAN_HPP_NAMESPACE::QueryPool queryPool, uint32_t query ) const VULKAN_HPP_NOEXCEPT
    {
      VULKAN_HPP_ASSERT( getDispatcher()->vkCmdWriteTimestamp2 && "Function <vkCmdWriteTimestamp2> requires <VK_KHR_synchronization2> or <VK_VERSION_1_3>" );

      getDispatcher()->vkCmdWriteTimestamp2(
        static_cast<VkCommandBuffer>( m_commandBuffer ), static_cast<VkPipelineStageFlags2>( stage ), static_cast<VkQueryPool>( queryPool ), query );
    }

    // wrapper function for command vkQueueSubmit2, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkQueueSubmit2.html
    VULKAN_HPP_INLINE typename ResultValueType<void>::type Queue::submit2( ArrayProxy<const SubmitInfo2> const & submits,
                                                                           VULKAN_HPP_NAMESPACE::Fence           fence ) const
    {
      VULKAN_HPP_ASSERT( getDispatcher()->vkQueueSubmit2 && "Function <vkQueueSubmit2> requires <VK_KHR_synchronization2> or <VK_VERSION_1_3>" );

      Result result = static_cast<Result>( getDispatcher()->vkQueueSubmit2(
        static_cast<VkQueue>( m_queue ), submits.size(), reinterpret_cast<const VkSubmitInfo2 *>( submits.data() ), static_cast<VkFence>( fence ) ) );
      VULKAN_HPP_NAMESPACE::detail::resultCheck( result, VULKAN_HPP_RAII_NAMESPACE_STRING "::Queue::submit2" );

      return VULKAN_HPP_NAMESPACE::detail::createResultValueType( result );
    }

    // wrapper function for command vkCmdCopyBuffer2, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdCopyBuffer2.html
    VULKAN_HPP_INLINE void CommandBuffer::copyBuffer2( const CopyBufferInfo2 & copyBufferInfo ) const VULKAN_HPP_NOEXCEPT
    {
      VULKAN_HPP_ASSERT( getDispatcher()->vkCmdCopyBuffer2 && "Function <vkCmdCopyBuffer2> requires <VK_KHR_copy_commands2> or <VK_VERSION_1_3>" );

      getDispatcher()->vkCmdCopyBuffer2( static_cast<VkCommandBuffer>( m_commandBuffer ), reinterpret_cast<const VkCopyBufferInfo2 *>( &copyBufferInfo ) );
    }

    // wrapper function for command vkCmdCopyImage2, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdCopyImage2.html
    VULKAN_HPP_INLINE void CommandBuffer::copyImage2( const CopyImageInfo2 & copyImageInfo ) const VULKAN_HPP_NOEXCEPT
    {
      VULKAN_HPP_ASSERT( getDispatcher()->vkCmdCopyImage2 && "Function <vkCmdCopyImage2> requires <VK_KHR_copy_commands2> or <VK_VERSION_1_3>" );

      getDispatcher()->vkCmdCopyImage2( static_cast<VkCommandBuffer>( m_commandBuffer ), reinterpret_cast<const VkCopyImageInfo2 *>( &copyImageInfo ) );
    }

    // wrapper function for command vkCmdCopyBufferToImage2, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdCopyBufferToImage2.html
    VULKAN_HPP_INLINE void CommandBuffer::copyBufferToImage2( const CopyBufferToImageInfo2 & copyBufferToImageInfo ) const VULKAN_HPP_NOEXCEPT
    {
      VULKAN_HPP_ASSERT( getDispatcher()->vkCmdCopyBufferToImage2 &&
                         "Function <vkCmdCopyBufferToImage2> requires <VK_KHR_copy_commands2> or <VK_VERSION_1_3>" );

      getDispatcher()->vkCmdCopyBufferToImage2( static_cast<VkCommandBuffer>( m_commandBuffer ),
                                                reinterpret_cast<const VkCopyBufferToImageInfo2 *>( &copyBufferToImageInfo ) );
    }

    // wrapper function for command vkCmdCopyImageToBuffer2, see https://registry.khronos.org/vulkan/specs/latest/man/html/vkCmdCopyImageToBuffer2.html
    VULKAN_HPP_INLINE void CommandBuffer::copyImageToBuffer2( const CopyImageToBufferInfo2 & copyImageToBufferInfo ) const VULKAN_HPP_NOEXCEPT
    {
      VULKAN_HPP_ASSERT( getDispatcher()->vkCmdCopyImageToBuffer2 &&
                         "Function <vkCmdCopyImageToBuffer2> requires <VK_KHR_copy_commands2> or <VK_VERSION_1_3>" );

      getDispatcher()->vkCmdCopyImageToBuffer2( static_cast<VkCommandBuffer>( m_commandBuffer ),
                                                reinterpret_cast<const VkCopyImageToBufferInfo2 *>( &copyImageToBufferInfo ) );
    }

    // wrapper function for command vkGetDeviceBufferMemoryRequirements, see
    // https://registry.khronos.org/vulkan/specs/latest/man/html/vkGetDeviceBufferMemoryRequirements.html
    VULKAN_HPP_NODISCARD VULKAN_HPP_INLINE MemoryRequirements2
      Device::getBufferMemoryRequirements( const DeviceBufferMemoryRequirements & info ) const VULKAN_HPP_NOEXCEPT
    {
      VULKAN_HPP_ASSERT( getDispatcher()->vkGetDeviceBufferMemoryRequirements &&
                         "Function <vkGetDeviceBufferMemoryRequirements> requires <VK_KHR_maintenance4