/*===- TableGen'erated file -------------------------------------*- C++ -*-===*\
|*                                                                            *|
|* Global Instruction Selector for the Mips target                            *|
|*                                                                            *|
|* Automatically generated file, do not edit!                                 *|
|*                                                                            *|
\*===----------------------------------------------------------------------===*/

#ifdef GET_GLOBALISEL_PREDICATE_BITSET
const unsigned MAX_SUBTARGET_PREDICATES = 44;
using PredicateBitset = llvm::PredicateBitsetImpl<MAX_SUBTARGET_PREDICATES>;
#endif // ifdef GET_GLOBALISEL_PREDICATE_BITSET

#ifdef GET_GLOBALISEL_TEMPORARIES_DECL
  mutable MatcherState State;
  typedef ComplexRendererFns(MipsInstructionSelector::*ComplexMatcherMemFn)(MachineOperand &) const;
  typedef void(MipsInstructionSelector::*CustomRendererFn)(MachineInstrBuilder &, const MachineInstr&, int) const;
  const ISelInfoTy<PredicateBitset, ComplexMatcherMemFn, CustomRendererFn> ISelInfo;
  static MipsInstructionSelector::ComplexMatcherMemFn ComplexPredicateFns[];
  static MipsInstructionSelector::CustomRendererFn CustomRenderers[];
  bool testImmPredicate_I64(unsigned PredicateID, int64_t Imm) const override;
  bool testImmPredicate_APInt(unsigned PredicateID, const APInt &Imm) const override;
  bool testImmPredicate_APFloat(unsigned PredicateID, const APFloat &Imm) const override;
  const int64_t *getMatchTable() const override;
  bool testMIPredicate_MI(unsigned PredicateID, const MachineInstr &MI) const override;
#endif // ifdef GET_GLOBALISEL_TEMPORARIES_DECL

#ifdef GET_GLOBALISEL_TEMPORARIES_INIT
, State(0),
ISelInfo(TypeObjects, NumTypeObjects, FeatureBitsets, ComplexPredicateFns, CustomRenderers)
#endif // ifdef GET_GLOBALISEL_TEMPORARIES_INIT

#ifdef GET_GLOBALISEL_IMPL
// Bits for subtarget features that participate in instruction matching.
enum SubtargetFeatureBits : uint8_t {
  Feature_HasMips2Bit = 7,
  Feature_HasMips3Bit = 17,
  Feature_HasMips4_32Bit = 27,
  Feature_NotMips4_32Bit = 28,
  Feature_HasMips4_32r2Bit = 18,
  Feature_HasMips32Bit = 3,
  Feature_HasMips32r2Bit = 6,
  Feature_HasMips32r6Bit = 29,
  Feature_NotMips32r6Bit = 4,
  Feature_IsGP64bitBit = 22,
  Feature_IsPTR64bitBit = 24,
  Feature_HasMips64Bit = 25,
  Feature_HasMips64r2Bit = 23,
  Feature_HasMips64r6Bit = 30,
  Feature_NotMips64r6Bit = 5,
  Feature_InMips16ModeBit = 31,
  Feature_NotInMips16ModeBit = 0,
  Feature_HasCnMipsBit = 26,
  Feature_NotCnMipsBit = 8,
  Feature_IsSym32Bit = 38,
  Feature_IsSym64Bit = 39,
  Feature_IsN64Bit = 40,
  Feature_RelocNotPICBit = 9,
  Feature_RelocPICBit = 37,
  Feature_NoNaNsFPMathBit = 21,
  Feature_UseAbsBit = 14,
  Feature_HasStdEncBit = 1,
  Feature_NotDSPBit = 11,
  Feature_InMicroMipsBit = 35,
  Feature_NotInMicroMipsBit = 2,
  Feature_IsLEBit = 42,
  Feature_IsBEBit = 43,
  Feature_IsNotNaClBit = 19,
  Feature_HasEVABit = 36,
  Feature_HasMSABit = 34,
  Feature_HasMadd4Bit = 20,
  Feature_UseIndirectJumpsHazardBit = 12,
  Feature_NoIndirectJumpGuardsBit = 10,
  Feature_AllowFPOpFusionBit = 41,
  Feature_IsFP64bitBit = 16,
  Feature_NotFP64bitBit = 15,
  Feature_IsNotSoftFloatBit = 13,
  Feature_HasDSPBit = 32,
  Feature_HasDSPR2Bit = 33,
};

PredicateBitset MipsInstructionSelector::
computeAvailableModuleFeatures(const MipsSubtarget *Subtarget) const {
  PredicateBitset Features;
  if (Subtarget->hasMips2())
    Features.set(Feature_HasMips2Bit);
  if (Subtarget->hasMips3())
    Features.set(Feature_HasMips3Bit);
  if (Subtarget->hasMips4_32())
    Features.set(Feature_HasMips4_32Bit);
  if (!Subtarget->hasMips4_32())
    Features.set(Feature_NotMips4_32Bit);
  if (Subtarget->hasMips4_32r2())
    Features.set(Feature_HasMips4_32r2Bit);
  if (Subtarget->hasMips32())
    Features.set(Feature_HasMips32Bit);
  if (Subtarget->hasMips32r2())
    Features.set(Feature_HasMips32r2Bit);
  if (Subtarget->hasMips32r6())
    Features.set(Feature_HasMips32r6Bit);
  if (!Subtarget->hasMips32r6())
    Features.set(Feature_NotMips32r6Bit);
  if (Subtarget->isGP64bit())
    Features.set(Feature_IsGP64bitBit);
  if (Subtarget->isABI_N64())
    Features.set(Feature_IsPTR64bitBit);
  if (Subtarget->hasMips64())
    Features.set(Feature_HasMips64Bit);
  if (Subtarget->hasMips64r2())
    Features.set(Feature_HasMips64r2Bit);
  if (Subtarget->hasMips64r6())
    Features.set(Feature_HasMips64r6Bit);
  if (!Subtarget->hasMips64r6())
    Features.set(Feature_NotMips64r6Bit);
  if (Subtarget->inMips16Mode())
    Features.set(Feature_InMips16ModeBit);
  if (!Subtarget->inMips16Mode())
    Features.set(Feature_NotInMips16ModeBit);
  if (Subtarget->hasCnMips())
    Features.set(Feature_HasCnMipsBit);
  if (!Subtarget->hasCnMips())
    Features.set(Feature_NotCnMipsBit);
  if (Subtarget->hasSym32())
    Features.set(Feature_IsSym32Bit);
  if (!Subtarget->hasSym32())
    Features.set(Feature_IsSym64Bit);
  if (Subtarget->isABI_N64())
    Features.set(Feature_IsN64Bit);
  if (!TM.isPositionIndependent())
    Features.set(Feature_RelocNotPICBit);
  if (TM.isPositionIndependent())
    Features.set(Feature_RelocPICBit);
  if (TM.Options.NoNaNsFPMath)
    Features.set(Feature_NoNaNsFPMathBit);
  if (Subtarget->inAbs2008Mode() ||TM.Options.NoNaNsFPMath)
    Features.set(Feature_UseAbsBit);
  if (Subtarget->hasStandardEncoding())
    Features.set(Feature_HasStdEncBit);
  if (!Subtarget->hasDSP())
    Features.set(Feature_NotDSPBit);
  if (Subtarget->inMicroMipsMode())
    Features.set(Feature_InMicroMipsBit);
  if (!Subtarget->inMicroMipsMode())
    Features.set(Feature_NotInMicroMipsBit);
  if (Subtarget->isLittle())
    Features.set(Feature_IsLEBit);
  if (!Subtarget->isLittle())
    Features.set(Feature_IsBEBit);
  if (!Subtarget->isTargetNaCl())
    Features.set(Feature_IsNotNaClBit);
  if (Subtarget->hasEVA())
    Features.set(Feature_HasEVABit);
  if (Subtarget->hasMSA())
    Features.set(Feature_HasMSABit);
  if (!Subtarget->disableMadd4())
    Features.set(Feature_HasMadd4Bit);
  if (Subtarget->useIndirectJumpsHazard())
    Features.set(Feature_UseIndirectJumpsHazardBit);
  if (!Subtarget->useIndirectJumpsHazard())
    Features.set(Feature_NoIndirectJumpGuardsBit);
  if (TM.Options.AllowFPOpFusion == FPOpFusion::Fast)
    Features.set(Feature_AllowFPOpFusionBit);
  if (Subtarget->isFP64bit())
    Features.set(Feature_IsFP64bitBit);
  if (!Subtarget->isFP64bit())
    Features.set(Feature_NotFP64bitBit);
  if (!Subtarget->useSoftFloat())
    Features.set(Feature_IsNotSoftFloatBit);
  if (Subtarget->hasDSP())
    Features.set(Feature_HasDSPBit);
  if (Subtarget->hasDSPR2())
    Features.set(Feature_HasDSPR2Bit);
  return Features;
}

void MipsInstructionSelector::setupGeneratedPerFunctionState(MachineFunction &MF) {
  AvailableFunctionFeatures = computeAvailableFunctionFeatures((const MipsSubtarget*)&MF.getSubtarget(), &MF);
}
PredicateBitset MipsInstructionSelector::
computeAvailableFunctionFeatures(const MipsSubtarget *Subtarget, const MachineFunction *MF) const {
  PredicateBitset Features;
  return Features;
}

// LLT Objects.
enum {
  GILLT_s16,
  GILLT_s32,
  GILLT_s64,
  GILLT_v2s16,
  GILLT_v2s64,
  GILLT_v4s8,
  GILLT_v4s32,
  GILLT_v8s16,
  GILLT_v16s8,
};
const static size_t NumTypeObjects = 9;
const static LLT TypeObjects[] = {
  LLT::scalar(16),
  LLT::scalar(32),
  LLT::scalar(64),
  LLT::vector(2, 16),
  LLT::vector(2, 64),
  LLT::vector(4, 8),
  LLT::vector(4, 32),
  LLT::vector(8, 16),
  LLT::vector(16, 8),
};

// Feature bitsets.
enum {
  GIFBS_Invalid,
  GIFBS_HasCnMips,
  GIFBS_HasDSP,
  GIFBS_HasDSPR2,
  GIFBS_HasMSA,
  GIFBS_InMicroMips,
  GIFBS_InMips16Mode,
  GIFBS_IsFP64bit,
  GIFBS_NotFP64bit,
  GIFBS_HasDSP_InMicroMips,
  GIFBS_HasDSP_NotInMicroMips,
  GIFBS_HasDSPR2_InMicroMips,
  GIFBS_HasMSA_HasStdEnc,
  GIFBS_HasMSA_IsBE,
  GIFBS_HasMSA_IsLE,
  GIFBS_HasMips32r6_HasStdEnc,
  GIFBS_HasMips32r6_InMicroMips,
  GIFBS_HasMips64r2_HasStdEnc,
  GIFBS_HasMips64r6_HasStdEnc,
  GIFBS_HasStdEnc_IsNotSoftFloat,
  GIFBS_HasStdEnc_NotInMicroMips,
  GIFBS_HasStdEnc_NotMips4_32,
  GIFBS_InMicroMips_IsFP64bit,
  GIFBS_InMicroMips_IsNotSoftFloat,
  GIFBS_InMicroMips_NotFP64bit,
  GIFBS_InMicroMips_NotMips32r6,
  GIFBS_IsGP64bit_NotInMips16Mode,
  GIFBS_AllowFPOpFusion_HasMSA_HasStdEnc,
  GIFBS_HasMSA_HasMips64_HasStdEnc,
  GIFBS_HasMips3_HasStdEnc_IsGP64bit,
  GIFBS_HasMips3_HasStdEnc_NotInMicroMips,
  GIFBS_HasMips32r2_HasStdEnc_NotInMicroMips,
  GIFBS_HasMips32r6_HasStdEnc_NotInMicroMips,
  GIFBS_HasMips32r6_InMicroMips_IsNotSoftFloat,
  GIFBS_HasMips64r6_HasStdEnc_NotInMicroMips,
  GIFBS_HasStdEnc_IsFP64bit_NotInMicroMips,
  GIFBS_HasStdEnc_IsFP64bit_NotMips4_32,
  GIFBS_HasStdEnc_IsNotSoftFloat_NotInMicroMips,
  GIFBS_HasStdEnc_NotFP64bit_NotInMicroMips,
  GIFBS_HasStdEnc_NotFP64bit_NotMips4_32,
  GIFBS_HasStdEnc_NotInMicroMips_RelocNotPIC,
  GIFBS_InMicroMips_IsFP64bit_IsNotSoftFloat,
  GIFBS_InMicroMips_IsNotSoftFloat_NotFP64bit,
  GIFBS_InMicroMips_IsNotSoftFloat_UseAbs,
  GIFBS_InMicroMips_NotFP64bit_NotMips32r6,
  GIFBS_InMicroMips_NotMips32r6_RelocNotPIC,
  GIFBS_InMicroMips_NotMips32r6_RelocPIC,
  GIFBS_HasMips2_HasStdEnc_IsNotSoftFloat_NotInMicroMips,
  GIFBS_HasMips3_HasStdEnc_IsGP64bit_NotInMicroMips,
  GIFBS_HasMips3_HasStdEnc_IsNotSoftFloat_NotInMicroMips,
  GIFBS_HasMips32r6_HasStdEnc_IsNotSoftFloat_NotInMicroMips,
  GIFBS_HasMips4_32_HasStdEnc_NotMips32r6_NotMips64r6,
  GIFBS_HasMips64r2_HasStdEnc_IsGP64bit_NotInMicroMips,
  GIFBS_HasStdEnc_IsFP64bit_IsNotSoftFloat_NotInMicroMips,
  GIFBS_HasStdEnc_IsNotSoftFloat_NotFP64bit_NotInMicroMips,
  GIFBS_HasStdEnc_IsNotSoftFloat_NotInMicroMips_UseAbs,
  GIFBS_HasMips2_HasStdEnc_IsFP64bit_IsNotSoftFloat_NotInMicroMips,
  GIFBS_HasMips2_HasStdEnc_IsNotSoftFloat_NotFP64bit_NotInMicroMips,
  GIFBS_HasMips32_HasStdEnc_NotInMicroMips_NotMips32r6_NotMips64r6,
  GIFBS_HasMips4_32_HasStdEnc_NotInMicroMips_NotMips32r6_NotMips64r6,
  GIFBS_HasMips64_HasStdEnc_IsGP64bit_NotInMicroMips_NotMips64r6,
  GIFBS_HasStdEnc_IsFP64bit_IsNotSoftFloat_NotInMicroMips_UseAbs,
  GIFBS_HasStdEnc_IsNotSoftFloat_NotFP64bit_NotInMicroMips_UseAbs,
  GIFBS_HasMadd4_InMicroMips_InMicroMips_NoNaNsFPMath_NotMips32r6_NotMips32r6,
  GIFBS_HasMips4_32_HasStdEnc_IsFP64bit_NotInMicroMips_NotMips32r6_NotMips64r6,
  GIFBS_HasMips4_32_HasStdEnc_IsGP64bit_NotInMicroMips_NotMips32r6_NotMips64r6,
  GIFBS_HasMips4_32_HasStdEnc_NotFP64bit_NotInMicroMips_NotMips32r6_NotMips64r6,
  GIFBS_HasMadd4_HasMips4_32r2_HasStdEnc_IsNotSoftFloat_NotInMicroMips_NotMips32r6_NotMips64r6,
  GIFBS_HasMadd4_HasMips4_32r2_HasStdEnc_NoNaNsFPMath_NotInMicroMips_NotMips32r6_NotMips64r6,
  GIFBS_HasMadd4_InMicroMips_InMicroMips_NoNaNsFPMath_NotFP64bit_NotMips32r6_NotMips32r6,
  GIFBS_HasMadd4_HasMips4_32r2_HasStdEnc_IsFP64bit_IsNotSoftFloat_NotInMicroMips_NotMips32r6_NotMips64r6,
  GIFBS_HasMadd4_HasMips4_32r2_HasStdEnc_IsFP64bit_NoNaNsFPMath_NotInMicroMips_NotMips32r6_NotMips64r6,
  GIFBS_HasMadd4_HasMips4_32r2_HasStdEnc_IsNotSoftFloat_NotFP64bit_NotInMicroMips_NotMips32r6_NotMips64r6,
  GIFBS_HasMadd4_HasMips4_32r2_HasStdEnc_NoNaNsFPMath_NotFP64bit_NotInMicroMips_NotMips32r6_NotMips64r6,
};
const static PredicateBitset FeatureBitsets[] {
  {}, // GIFBS_Invalid
  {Feature_HasCnMipsBit, },
  {Feature_HasDSPBit, },
  {Feature_HasDSPR2Bit, },
  {Feature_HasMSABit, },
  {Feature_InMicroMipsBit, },
  {Feature_InMips16ModeBit, },
  {Feature_IsFP64bitBit, },
  {Feature_NotFP64bitBit, },
  {Feature_HasDSPBit, Feature_InMicroMipsBit, },
  {Feature_HasDSPBit, Feature_NotInMicroMipsBit, },
  {Feature_HasDSPR2Bit, Feature_InMicroMipsBit, },
  {Feature_HasMSABit, Feature_HasStdEncBit, },
  {Feature_HasMSABit, Feature_IsBEBit, },
  {Feature_HasMSABit, Feature_IsLEBit, },
  {Feature_HasMips32r6Bit, Feature_HasStdEncBit, },
  {Feature_HasMips32r6Bit, Feature_InMicroMipsBit, },
  {Feature_HasMips64r2Bit, Feature_HasStdEncBit, },
  {Feature_HasMips64r6Bit, Feature_HasStdEncBit, },
  {Feature_HasStdEncBit, Feature_IsNotSoftFloatBit, },
  {Feature_HasStdEncBit, Feature_NotInMicroMipsBit, },
  {Feature_HasStdEncBit, Feature_NotMips4_32Bit, },
  {Feature_InMicroMipsBit, Feature_IsFP64bitBit, },
  {Feature_InMicroMipsBit, Feature_IsNotSoftFloatBit, },
  {Feature_InMicroMipsBit, Feature_NotFP64bitBit, },
  {Feature_InMicroMipsBit, Feature_NotMips32r6Bit, },
  {Feature_IsGP64bitBit, Feature_NotInMips16ModeBit, },
  {Feature_AllowFPOpFusionBit, Feature_HasMSABit, Feature_HasStdEncBit, },
  {Feature_HasMSABit, Feature_HasMips64Bit, Feature_HasStdEncBit, },
  {Feature_HasMips3Bit, Feature_HasStdEncBit, Feature_IsGP64bitBit, },
  {Feature_HasMips3Bit, Feature_HasStdEncBit, Feature_NotInMicroMipsBit, },
  {Feature_HasMips32r2Bit, Feature_HasStdEncBit, Feature_NotInMicroMipsBit, },
  {Feature_HasMips32r6Bit, Feature_HasStdEncBit, Feature_NotInMicroMipsBit, },
  {Feature_HasMips32r6Bit, Feature_InMicroMipsBit, Feature_IsNotSoftFloatBit, },
  {Feature_HasMips64r6Bit, Feature_HasStdEncBit, Feature_NotInMicroMipsBit, },
  {Feature_HasStdEncBit, Feature_IsFP64bitBit, Feature_NotInMicroMipsBit, },
  {Feature_HasStdEncBit, Feature_IsFP64bitBit, Feature_NotMips4_32Bit, },
  {Feature_HasStdEncBit, Feature_IsNotSoftFloatBit, Feature_NotInMicroMipsBit, },
  {Feature_HasStdEncBit, Feature_NotFP64bitBit, Feature_NotInMicroMipsBit, },
  {Feature_HasStdEncBit, Feature_NotFP64bitBit, Feature_NotMips4_32Bit, },
  {Feature_HasStdEncBit, Feature_NotInMicroMipsBit, Feature_RelocNotPICBit, },
  {Feature_InMicroMipsBit, Feature_IsFP64bitBit, Feature_IsNotSoftFloatBit, },
  {Feature_InMicroMipsBit, Feature_IsNotSoftFloatBit, Feature_NotFP64bitBit, },
  {Feature_InMicroMipsBit, Feature_IsNotSoftFloatBit, Feature_UseAbsBit, },
  {Feature_InMicroMipsBit, Feature_NotFP64bitBit, Feature_NotMips32r6Bit, },
  {Feature_InMicroMipsBit, Feature_NotMips32r6Bit, Feature_RelocNotPICBit, },
  {Feature_InMicroMipsBit, Feature_NotMips32r6Bit, Feature_RelocPICBit, },
  {Feature_HasMips2Bit, Feature_HasStdEncBit, Feature_IsNotSoftFloatBit, Feature_NotInMicroMipsBit, },
  {Feature_HasMips3Bit, Feature_HasStdEncBit, Feature_IsGP64bitBit, Feature_NotInMicroMipsBit, },
  {Feature_HasMips3Bit, Feature_HasStdEncBit, Feature_IsNotSoftFloatBit, Feature_NotInMicroMipsBit, },
  {Feature_HasMips32r6Bit, Feature_HasStdEncBit, Feature_IsNotSoftFloatBit, Feature_NotInMicroMipsBit, },
  {Feature_HasMips4_32Bit, Feature_HasStdEncBit, Feature_NotMips32r6Bit, Feature_NotMips64r6Bit, },
  {Feature_HasMips64r2Bit, Feature_HasStdEncBit, Feature_IsGP64bitBit, Feature_NotInMicroMipsBit, },
  {Feature_HasStdEncBit, Feature_IsFP64bitBit, Feature_IsNotSoftFloatBit, Feature_NotInMicroMipsBit, },
  {Feature_HasStdEncBit, Feature_IsNotSoftFloatBit, Feature_NotFP64bitBit, Feature_NotInMicroMipsBit, },
  {Feature_HasStdEncBit, Feature_IsNotSoftFloatBit, Feature_NotInMicroMipsBit, Feature_UseAbsBit, },
  {Feature_HasMips2Bit, Feature_HasStdEncBit, Feature_IsFP64bitBit, Feature_IsNotSoftFloatBit, Feature_NotInMicroMipsBit, },
  {Feature_HasMips2Bit, Feature_HasStdEncBit, Feature_IsNotSoftFloatBit, Feature_NotFP64bitBit, Feature_NotInMicroMipsBit, },
  {Feature_HasMips32Bit, Feature_HasStdEncBit, Feature_NotInMicroMipsBit, Feature_NotMips32r6Bit, Feature_NotMips64r6Bit, },
  {Feature_HasMips4_32Bit, Feature_HasStdEncBit, Feature_NotInMicroMipsBit, Feature_NotMips32r6Bit, Feature_NotMips64r6Bit, },
  {Feature_HasMips64Bit, Feature_HasStdEncBit, Feature_IsGP64bitBit, Feature_NotInMicroMipsBit, Feature_NotMips64r6Bit, },
  {Feature_HasStdEncBit, Feature_IsFP64bitBit, Feature_IsNotSoftFloatBit, Feature_NotInMicroMipsBit, Feature_UseAbsBit, },
  {Feature_HasStdEncBit, Feature_IsNotSoftFloatBit, Feature_NotFP64bitBit, Feature_NotInMicroMipsBit, Feature_UseAbsBit, },
  {Feature_HasMadd4Bit, Feature_InMicroMipsBit, Feature_InMicroMipsBit, Feature_NoNaNsFPMathBit, Feature_NotMips32r6Bit, Feature_NotMips32r6Bit, },
  {Feature_HasMips4_32Bit, Feature_HasStdEncBit, Feature_IsFP64bitBit, Feature_NotInMicroMipsBit, Feature_NotMips32r6Bit, Feature_NotMips64r6Bit, },
  {Feature_HasMips4_32Bit, Feature_HasStdEncBit, Feature_IsGP64bitBit, Feature_NotInMicroMipsBit, Feature_NotMips32r6Bit, Feature_NotMips64r6Bit, },
  {Feature_HasMips4_32Bit, Feature_HasStdEncBit, Feature_NotFP64bitBit, Feature_NotInMicroMipsBit, Feature_NotMips32r6Bit, Feature_NotMips64r6Bit, },
  {Feature_HasMadd4Bit, Feature_HasMips4_32r2Bit, Feature_HasStdEncBit, Feature_IsNotSoftFloatBit, Feature_NotInMicroMipsBit, Feature_NotMips32r6Bit, Feature_NotMips64r6Bit, },
  {Feature_HasMadd4Bit, Feature_HasMips4_32r2Bit, Feature_HasStdEncBit, Feature_NoNaNsFPMathBit, Feature_NotInMicroMipsBit, Feature_NotMips32r6Bit, Feature_NotMips64r6Bit, },
  {Feature_HasMadd4Bit, Feature_InMicroMipsBit, Feature_InMicroMipsBit, Feature_NoNaNsFPMathBit, Feature_NotFP64bitBit, Feature_NotMips32r6Bit, Feature_NotMips32r6Bit, },
  {Feature_HasMadd4Bit, Feature_HasMips4_32r2Bit, Feature_HasStdEncBit, Feature_IsFP64bitBit, Feature_IsNotSoftFloatBit, Feature_NotInMicroMipsBit, Feature_NotMips32r6Bit, Feature_NotMips64r6Bit, },
  {Feature_HasMadd4Bit, Feature_HasMips4_32r2Bit, Feature_HasStdEncBit, Feature_IsFP64bitBit, Feature_NoNaNsFPMathBit, Feature_NotInMicroMipsBit, Feature_NotMips32r6Bit, Feature_NotMips64r6Bit, },
  {Feature_HasMadd4Bit, Feature_HasMips4_32r2Bit, Feature_HasStdEncBit, Feature_IsNotSoftFloatBit, Feature_NotFP64bitBit, Feature_NotInMicroMipsBit, Feature_NotMips32r6Bit, Feature_NotMips64r6Bit, },
  {Feature_HasMadd4Bit, Feature_HasMips4_32r2Bit, Feature_HasStdEncBit, Feature_NoNaNsFPMathBit, Feature_NotFP64bitBit, Feature_NotInMicroMipsBit, Feature_NotMips32r6Bit, Feature_NotMips64r6Bit, },
};

// ComplexPattern predicates.
enum {
  GICP_Invalid,
};
// See constructor for table contents

// PatFrag predicates.
enum {
  GIPFP_I64_Predicate_immLi16 = GIPFP_I64_Invalid + 1,
  GIPFP_I64_Predicate_immSExt10,
  GIPFP_I64_Predicate_immSExt6,
  GIPFP_I64_Predicate_immSExtAddiur2,
  GIPFP_I64_Predicate_immSExtAddius5,
  GIPFP_I64_Predicate_immZExt1,
  GIPFP_I64_Predicate_immZExt10,
  GIPFP_I64_Predicate_immZExt1Ptr,
  GIPFP_I64_Predicate_immZExt2,
  GIPFP_I64_Predicate_immZExt2Lsa,
  GIPFP_I64_Predicate_immZExt2Ptr,
  GIPFP_I64_Predicate_immZExt2Shift,
  GIPFP_I64_Predicate_immZExt3,
  GIPFP_I64_Predicate_immZExt3Ptr,
  GIPFP_I64_Predicate_immZExt4,
  GIPFP_I64_Predicate_immZExt4Ptr,
  GIPFP_I64_Predicate_immZExt5,
  GIPFP_I64_Predicate_immZExt5_64,
  GIPFP_I64_Predicate_immZExt6,
  GIPFP_I64_Predicate_immZExt8,
  GIPFP_I64_Predicate_immZExtAndi16,
  GIPFP_I64_Predicate_immi32Cst15,
  GIPFP_I64_Predicate_immi32Cst31,
  GIPFP_I64_Predicate_immi32Cst7,
  GIPFP_I64_Predicate_timmSExt6,
  GIPFP_I64_Predicate_timmZExt1,
  GIPFP_I64_Predicate_timmZExt10,
  GIPFP_I64_Predicate_timmZExt1Ptr,
  GIPFP_I64_Predicate_timmZExt2,
  GIPFP_I64_Predicate_timmZExt2Ptr,
  GIPFP_I64_Predicate_timmZExt3,
  GIPFP_I64_Predicate_timmZExt3Ptr,
  GIPFP_I64_Predicate_timmZExt4,
  GIPFP_I64_Predicate_timmZExt4Ptr,
  GIPFP_I64_Predicate_timmZExt5,
  GIPFP_I64_Predicate_timmZExt6,
  GIPFP_I64_Predicate_timmZExt8,
};
bool MipsInstructionSelector::testImmPredicate_I64(unsigned PredicateID, int64_t Imm) const {
  switch (PredicateID) {
  case GIPFP_I64_Predicate_immLi16: {
    return Imm >= -1 && Imm <= 126;
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_immSExt10: {
    return isInt<10>(Imm);
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_immSExt6: {
    return isInt<6>(Imm);
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_immSExtAddiur2: {
    return Imm == 1 || Imm == -1 ||
                                           ((Imm % 4 == 0) &&
                                            Imm < 28 && Imm > 0);
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_immSExtAddius5: {
    return Imm >= -8 && Imm <= 7;
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_immZExt1: {
    return isUInt<1>(Imm);
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_immZExt10: {
    return isUInt<10>(Imm);
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_immZExt1Ptr: {
    return isUInt<1>(Imm);
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_immZExt2: {
    return isUInt<2>(Imm);
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_immZExt2Lsa: {
    return isUInt<2>(Imm - 1);
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_immZExt2Ptr: {
    return isUInt<2>(Imm);
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_immZExt2Shift: {
    return Imm >= 1 && Imm <= 8;
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_immZExt3: {
    return isUInt<3>(Imm);
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_immZExt3Ptr: {
    return isUInt<3>(Imm);
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_immZExt4: {
    return isUInt<4>(Imm);
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_immZExt4Ptr: {
    return isUInt<4>(Imm);
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_immZExt5: {
    return Imm == (Imm & 0x1f);
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_immZExt5_64: {
     return Imm == (Imm & 0x1f); 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_immZExt6: {
    return Imm == (Imm & 0x3f);
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_immZExt8: {
    return isUInt<8>(Imm);
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_immZExtAndi16: {
    return (Imm == 128 || (Imm >= 1 && Imm <= 4) || Imm == 7 || Imm == 8 ||
            Imm == 15 || Imm == 16 || Imm == 31 || Imm == 32 || Imm == 63 ||
            Imm == 64 || Imm == 255 || Imm == 32768 || Imm == 65535 );
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_immi32Cst15: {
    return isUInt<32>(Imm) && Imm == 15;
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_immi32Cst31: {
    return isUInt<32>(Imm) && Imm == 31;
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_immi32Cst7: {
    return isUInt<32>(Imm) && Imm == 7;
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_timmSExt6: {
    return isInt<6>(Imm);
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_timmZExt1: {
    return isUInt<1>(Imm);
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_timmZExt10: {
    return isUInt<10>(Imm);
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_timmZExt1Ptr: {
    return isUInt<1>(Imm);
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_timmZExt2: {
    return isUInt<2>(Imm);
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_timmZExt2Ptr: {
    return isUInt<2>(Imm);
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_timmZExt3: {
    return isUInt<3>(Imm);
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_timmZExt3Ptr: {
    return isUInt<3>(Imm);
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_timmZExt4: {
    return isUInt<4>(Imm);
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_timmZExt4Ptr: {
    return isUInt<4>(Imm);
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_timmZExt5: {
    return Imm == (Imm & 0x1f);
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_timmZExt6: {
    return Imm == (Imm & 0x3f);
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_timmZExt8: {
    return isUInt<8>(Imm);
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  }
  llvm_unreachable("Unknown predicate");
  return false;
}
bool MipsInstructionSelector::testImmPredicate_APFloat(unsigned PredicateID, const APFloat & Imm) const {
  llvm_unreachable("Unknown predicate");
  return false;
}
// PatFrag predicates.
enum {
  GIPFP_APInt_Predicate_imm32SExt16 = GIPFP_APInt_Invalid + 1,
  GIPFP_APInt_Predicate_imm32ZExt16,
};
bool MipsInstructionSelector::testImmPredicate_APInt(unsigned PredicateID, const APInt & Imm) const {
  switch (PredicateID) {
  case GIPFP_APInt_Predicate_imm32SExt16: {
     return isInt<16>(Imm.getSExtValue()); 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_APInt_Predicate_imm32ZExt16: {
    
  return (uint32_t)Imm.getZExtValue() == (unsigned short)Imm.getZExtValue();

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  }
  llvm_unreachable("Unknown predicate");
  return false;
}
bool MipsInstructionSelector::testMIPredicate_MI(unsigned PredicateID, const MachineInstr & MI) const {
  const MachineFunction &MF = *MI.getParent()->getParent();
  const MachineRegisterInfo &MRI = MF.getRegInfo();
  (void)MRI;
  llvm_unreachable("Unknown predicate");
  return false;
}

MipsInstructionSelector::ComplexMatcherMemFn
MipsInstructionSelector::ComplexPredicateFns[] = {
  nullptr, // GICP_Invalid
};

// Custom renderers.
enum {
  GICR_Invalid,
};
MipsInstructionSelector::CustomRendererFn
MipsInstructionSelector::CustomRenderers[] = {
  nullptr, // GICR_Invalid
};

bool MipsInstructionSelector::selectImpl(MachineInstr &I, CodeGenCoverage &CoverageInfo) const {
  MachineFunction &MF = *I.getParent()->getParent();
  MachineRegisterInfo &MRI = MF.getRegInfo();
  const PredicateBitset AvailableFeatures = getAvailableFeatures();
  NewMIVector OutMIs;
  State.MIs.clear();
  State.MIs.push_back(&I);

  if (executeMatchTable(*this, OutMIs, State, ISelInfo, getMatchTable(), TII, MRI, TRI, RBI, AvailableFeatures, CoverageInfo)) {
    return true;
  }

  return false;
}

const int64_t *MipsInstructionSelector::getMatchTable() const {
  constexpr static int64_t MatchTable0[] = {
    GIM_SwitchOpcode, /*MI*/0, /*[*/35, 170, /*)*//*default:*//*Label 55*/ 59850,
    /*TargetOpcode::G_ADD*//*Label 0*/ 140,
    /*TargetOpcode::G_SUB*//*Label 1*/ 1360,
    /*TargetOpcode::G_MUL*//*Label 2*/ 1972,
    /*TargetOpcode::G_SDIV*//*Label 3*/ 2348,
    /*TargetOpcode::G_UDIV*//*Label 4*/ 2569,
    /*TargetOpcode::G_SREM*//*Label 5*/ 2790,
    /*TargetOpcode::G_UREM*//*Label 6*/ 3011,
    /*TargetOpcode::G_AND*//*Label 7*/ 3232,
    /*TargetOpcode::G_OR*//*Label 8*/ 3719,
    /*TargetOpcode::G_XOR*//*Label 9*/ 4064, 0, 0, 0, 0, 0, 0, 0, 0,
    /*TargetOpcode::G_BUILD_VECTOR*//*Label 10*/ 4904, 0, 0, 0, 0,
    /*TargetOpcode::G_BITCAST*//*Label 11*/ 5265, 0, 0, 0,
    /*TargetOpcode::G_LOAD*//*Label 12*/ 8918,
    /*TargetOpcode::G_SEXTLOAD*//*Label 13*/ 8984,
    /*TargetOpcode::G_ZEXTLOAD*//*Label 14*/ 9050, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    /*TargetOpcode::G_INTRINSIC*//*Label 15*/ 9116,
    /*TargetOpcode::G_INTRINSIC_W_SIDE_EFFECTS*//*Label 16*/ 25275,
    /*TargetOpcode::G_ANYEXT*//*Label 17*/ 30251,
    /*TargetOpcode::G_TRUNC*//*Label 18*/ 30317,
    /*TargetOpcode::G_CONSTANT*//*Label 19*/ 30380, 0, 0, 0,
    /*TargetOpcode::G_SEXT*//*Label 20*/ 30440, 0,
    /*TargetOpcode::G_ZEXT*//*Label 21*/ 31698,
    /*TargetOpcode::G_SHL*//*Label 22*/ 31892,
    /*TargetOpcode::G_LSHR*//*Label 23*/ 33645,
    /*TargetOpcode::G_ASHR*//*Label 24*/ 35398,
    /*TargetOpcode::G_ICMP*//*Label 25*/ 37108,
    /*TargetOpcode::G_FCMP*//*Label 26*/ 39612,
    /*TargetOpcode::G_SELECT*//*Label 27*/ 41332, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    /*TargetOpcode::G_UMULH*//*Label 28*/ 53612,
    /*TargetOpcode::G_SMULH*//*Label 29*/ 53699,
    /*TargetOpcode::G_FADD*//*Label 30*/ 53786,
    /*TargetOpcode::G_FSUB*//*Label 31*/ 54665,
    /*TargetOpcode::G_FMUL*//*Label 32*/ 55241,
    /*TargetOpcode::G_FMA*//*Label 33*/ 55678, 0,
    /*TargetOpcode::G_FDIV*//*Label 34*/ 55768, 0, 0, 0,
    /*TargetOpcode::G_FEXP2*//*Label 35*/ 56019, 0,
    /*TargetOpcode::G_FLOG2*//*Label 36*/ 56077, 0,
    /*TargetOpcode::G_FNEG*//*Label 37*/ 56135,
    /*TargetOpcode::G_FPEXT*//*Label 38*/ 57431,
    /*TargetOpcode::G_FPTRUNC*//*Label 39*/ 57580,
    /*TargetOpcode::G_FPTOSI*//*Label 40*/ 57708,
    /*TargetOpcode::G_FPTOUI*//*Label 41*/ 57766,
    /*TargetOpcode::G_SITOFP*//*Label 42*/ 57824,
    /*TargetOpcode::G_UITOFP*//*Label 43*/ 57977,
    /*TargetOpcode::G_FABS*//*Label 44*/ 58035, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    /*TargetOpcode::G_SMIN*//*Label 45*/ 58218,
    /*TargetOpcode::G_SMAX*//*Label 46*/ 58358,
    /*TargetOpcode::G_UMIN*//*Label 47*/ 58498,
    /*TargetOpcode::G_UMAX*//*Label 48*/ 58638,
    /*TargetOpcode::G_BR*//*Label 49*/ 58778, 0, 0, 0, 0, 0, 0,
    /*TargetOpcode::G_CTLZ*//*Label 50*/ 58863, 0,
    /*TargetOpcode::G_CTPOP*//*Label 51*/ 59298,
    /*TargetOpcode::G_BSWAP*//*Label 52*/ 59457, 0, 0, 0, 0,
    /*TargetOpcode::G_FSQRT*//*Label 53*/ 59609, 0,
    /*TargetOpcode::G_FRINT*//*Label 54*/ 59792,
    // Label 0: @140
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 9, /*)*//*default:*//*Label 64*/ 1359,
    /*GILLT_s32*//*Label 56*/ 154,
    /*GILLT_s64*//*Label 57*/ 546,
    /*GILLT_v2s16*//*Label 58*/ 709,
    /*GILLT_v2s64*//*Label 59*/ 736,
    /*GILLT_v4s8*//*Label 60*/ 885,
    /*GILLT_v4s32*//*Label 61*/ 912,
    /*GILLT_v8s16*//*Label 62*/ 1061,
    /*GILLT_v16s8*//*Label 63*/ 1210,
    // Label 56: @154
    GIM_Try, /*On fail goto*//*Label 65*/ 545,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 66*/ 232, // Rule ID 2348 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SHL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/Mips::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIPFP_I64_Predicate_immZExt2Lsa,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[i32] } (shl:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, (imm:{ *:[i32] })<<P:Predicate_immZExt2Lsa>>:$sa), GPR32Opnd:{ *:[i32] }:$rt)  =>  (LSA:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt, (imm:{ *:[i32] }):$sa)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::LSA,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rt
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // sa
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2348,
        GIR_Done,
      // Label 66: @232
      GIM_Try, /*On fail goto*//*Label 67*/ 300, // Rule ID 818 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SHL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/Mips::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIPFP_I64_Predicate_immZExt2Lsa,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rt, (shl:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, (imm:{ *:[i32] })<<P:Predicate_immZExt2Lsa>>:$sa))  =>  (LSA:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt, (imm:{ *:[i32] }):$sa)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::LSA,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rt
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // sa
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 818,
        GIR_Done,
      // Label 67: @300
      GIM_Try, /*On fail goto*//*Label 68*/ 343, // Rule ID 40 //
        GIM_CheckFeatures, GIFBS_HasStdEnc_NotInMicroMips,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckAPIntImmPredicate, /*MI*/1, /*Predicate*/GIPFP_APInt_Predicate_imm32SExt16,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, (imm:{ *:[i32] })<<P:Predicate_imm32SExt16>>:$imm16)  =>  (ADDiu:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, (imm:{ *:[i32] }):$imm16)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::ADDiu,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm16
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 40,
        GIR_Done,
      // Label 68: @343
      GIM_Try, /*On fail goto*//*Label 69*/ 386, // Rule ID 2117 //
        GIM_CheckFeatures, GIFBS_InMicroMips,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPRMM16RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::GPRMM16RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_immSExtAddiur2,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i32] } GPRMM16:{ *:[i32] }:$src, (imm:{ *:[i32] })<<P:Predicate_immSExtAddiur2>>:$imm)  =>  (ADDIUR2_MM:{ *:[i32] } GPRMM16:{ *:[i32] }:$src, (imm:{ *:[i32] })<<P:Predicate_immSExtAddiur2>>:$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::ADDIUR2_MM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2117,
        GIR_Done,
      // Label 69: @386
      GIM_Try, /*On fail goto*//*Label 70*/ 429, // Rule ID 2118 //
        GIM_CheckFeatures, GIFBS_InMicroMips,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_immSExtAddius5,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i32] } GPR32:{ *:[i32] }:$src, (imm:{ *:[i32] })<<P:Predicate_immSExtAddius5>>:$imm)  =>  (ADDIUS5_MM:{ *:[i32] } GPR32:{ *:[i32] }:$src, (imm:{ *:[i32] })<<P:Predicate_immSExtAddius5>>:$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::ADDIUS5_MM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2118,
        GIR_Done,
      // Label 70: @429
      GIM_Try, /*On fail goto*//*Label 71*/ 452, // Rule ID 1190 //
        GIM_CheckFeatures, GIFBS_HasMips32r6_InMicroMips,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPRMM16RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::GPRMM16RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPRMM16RegClassID,
        // (add:{ *:[i32] } GPRMM16Opnd:{ *:[i32] }:$rs, GPRMM16Opnd:{ *:[i32] }:$rt)  =>  (ADDU16_MMR6:{ *:[i32] } GPRMM16Opnd:{ *:[i32] }:$rs, GPRMM16Opnd:{ *:[i32] }:$rt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::ADDU16_MMR6,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1190,
        GIR_Done,
      // Label 71: @452
      GIM_Try, /*On fail goto*//*Label 72*/ 475, // Rule ID 46 //
        GIM_CheckFeatures, GIFBS_HasStdEnc_NotInMicroMips,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR32RegClassID,
        // (add:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (ADDu:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::ADDu,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46,
        GIR_Done,
      // Label 72: @475
      GIM_Try, /*On fail goto*//*Label 73*/ 498, // Rule ID 1044 //
        GIM_CheckFeatures, GIFBS_InMicroMips_NotMips32r6,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPRMM16RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::GPRMM16RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPRMM16RegClassID,
        // (add:{ *:[i32] } GPRMM16Opnd:{ *:[i32] }:$rs, GPRMM16Opnd:{ *:[i32] }:$rt)  =>  (ADDU16_MM:{ *:[i32] } GPRMM16Opnd:{ *:[i32] }:$rs, GPRMM16Opnd:{ *:[i32] }:$rt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::ADDU16_MM,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1044,
        GIR_Done,
      // Label 73: @498
      GIM_Try, /*On fail goto*//*Label 74*/ 521, // Rule ID 1056 //
        GIM_CheckFeatures, GIFBS_InMicroMips_NotMips32r6,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR32RegClassID,
        // (add:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (ADDu_MM:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::ADDu_MM,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1056,
        GIR_Done,
      // Label 74: @521
      GIM_Try, /*On fail goto*//*Label 75*/ 544, // Rule ID 1777 //
        GIM_CheckFeatures, GIFBS_InMips16Mode,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::CPU16RegsRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::CPU16RegsRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::CPU16RegsRegClassID,
        // (add:{ *:[i32] } CPU16Regs:{ *:[i32] }:$l, CPU16Regs:{ *:[i32] }:$r)  =>  (AdduRxRyRz16:{ *:[i32] } CPU16Regs:{ *:[i32] }:$l, CPU16Regs:{ *:[i32] }:$r)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::AdduRxRyRz16,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1777,
        GIR_Done,
      // Label 75: @544
      GIM_Reject,
    // Label 65: @545
    GIM_Reject,
    // Label 57: @546
    GIM_Try, /*On fail goto*//*Label 76*/ 708,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR64RegClassID,
      GIM_Try, /*On fail goto*//*Label 77*/ 624, // Rule ID 2349 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasMips64_HasStdEnc,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SHL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/Mips::GPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIPFP_I64_Predicate_immZExt2Lsa,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[i64] } (shl:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rs, (imm:{ *:[i32] })<<P:Predicate_immZExt2Lsa>>:$sa), GPR64Opnd:{ *:[i64] }:$rt)  =>  (DLSA:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rs, GPR64Opnd:{ *:[i64] }:$rt, (imm:{ *:[i32] }):$sa)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::DLSA,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rt
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // sa
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2349,
        GIR_Done,
      // Label 77: @624
      GIM_Try, /*On fail goto*//*Label 78*/ 688, // Rule ID 819 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasMips64_HasStdEnc,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::GPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SHL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/Mips::GPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIPFP_I64_Predicate_immZExt2Lsa,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rt, (shl:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rs, (imm:{ *:[i32] })<<P:Predicate_immZExt2Lsa>>:$sa))  =>  (DLSA:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rs, GPR64Opnd:{ *:[i64] }:$rt, (imm:{ *:[i32] }):$sa)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::DLSA,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rt
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // sa
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 819,
        GIR_Done,
      // Label 78: @688
      GIM_Try, /*On fail goto*//*Label 79*/ 707, // Rule ID 196 //
        GIM_CheckFeatures, GIFBS_HasMips3_HasStdEnc_NotInMicroMips,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::GPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR64RegClassID,
        // (add:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rs, GPR64Opnd:{ *:[i64] }:$rt)  =>  (DADDu:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rs, GPR64Opnd:{ *:[i64] }:$rt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::DADDu,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 196,
        GIR_Done,
      // Label 79: @707
      GIM_Reject,
    // Label 76: @708
    GIM_Reject,
    // Label 58: @709
    GIM_Try, /*On fail goto*//*Label 80*/ 735, // Rule ID 1876 //
      GIM_CheckFeatures, GIFBS_HasDSP,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
      // (add:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$a, v2i16:{ *:[v2i16] }:$b)  =>  (ADDQ_PH:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$a, v2i16:{ *:[v2i16] }:$b)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::ADDQ_PH,
      GIR_AddImplicitDef, /*InsnID*/0, Mips::DSPOutFlag20,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1876,
      GIR_Done,
    // Label 80: @735
    GIM_Reject,
    // Label 59: @736
    GIM_Try, /*On fail goto*//*Label 81*/ 884,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
      GIM_Try, /*On fail goto*//*Label 82*/ 807, // Rule ID 2353 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v2i64] } (mul:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt), MSA128DOpnd:{ *:[v2i64] }:$wd_in)  =>  (MADDV_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$wd_in, MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::MADDV_D,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // wd_in
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2353,
        GIR_Done,
      // Label 82: @807
      GIM_Try, /*On fail goto*//*Label 83*/ 864, // Rule ID 827 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::MSA128DRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$wd_in, (mul:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt))  =>  (MADDV_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$wd_in, MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::MADDV_D,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // wd_in
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 827,
        GIR_Done,
      // Label 83: @864
      GIM_Try, /*On fail goto*//*Label 84*/ 883, // Rule ID 494 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128DRegClassID,
        // (add:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)  =>  (ADDV_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::ADDV_D,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 494,
        GIR_Done,
      // Label 84: @883
      GIM_Reject,
    // Label 81: @884
    GIM_Reject,
    // Label 60: @885
    GIM_Try, /*On fail goto*//*Label 85*/ 911, // Rule ID 1882 //
      GIM_CheckFeatures, GIFBS_HasDSP,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
      // (add:{ *:[v4i8] } v4i8:{ *:[v4i8] }:$a, v4i8:{ *:[v4i8] }:$b)  =>  (ADDU_QB:{ *:[v4i8] } v4i8:{ *:[v4i8] }:$a, v4i8:{ *:[v4i8] }:$b)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::ADDU_QB,
      GIR_AddImplicitDef, /*InsnID*/0, Mips::DSPOutFlag20,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1882,
      GIR_Done,
    // Label 85: @911
    GIM_Reject,
    // Label 61: @912
    GIM_Try, /*On fail goto*//*Label 86*/ 1060,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
      GIM_Try, /*On fail goto*//*Label 87*/ 983, // Rule ID 2352 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v4i32] } (mul:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt), MSA128WOpnd:{ *:[v4i32] }:$wd_in)  =>  (MADDV_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$wd_in, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::MADDV_W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // wd_in
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2352,
        GIR_Done,
      // Label 87: @983
      GIM_Try, /*On fail goto*//*Label 88*/ 1040, // Rule ID 826 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::MSA128WRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$wd_in, (mul:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt))  =>  (MADDV_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$wd_in, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::MADDV_W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // wd_in
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 826,
        GIR_Done,
      // Label 88: @1040
      GIM_Try, /*On fail goto*//*Label 89*/ 1059, // Rule ID 493 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128WRegClassID,
        // (add:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (ADDV_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::ADDV_W,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 493,
        GIR_Done,
      // Label 89: @1059
      GIM_Reject,
    // Label 86: @1060
    GIM_Reject,
    // Label 62: @1061
    GIM_Try, /*On fail goto*//*Label 90*/ 1209,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128HRegClassID,
      GIM_Try, /*On fail goto*//*Label 91*/ 1132, // Rule ID 2351 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v8i16] } (mul:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt), MSA128HOpnd:{ *:[v8i16] }:$wd_in)  =>  (MADDV_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$wd_in, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::MADDV_H,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // wd_in
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2351,
        GIR_Done,
      // Label 91: @1132
      GIM_Try, /*On fail goto*//*Label 92*/ 1189, // Rule ID 825 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::MSA128HRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$wd_in, (mul:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt))  =>  (MADDV_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$wd_in, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::MADDV_H,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // wd_in
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 825,
        GIR_Done,
      // Label 92: @1189
      GIM_Try, /*On fail goto*//*Label 93*/ 1208, // Rule ID 492 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128HRegClassID,
        // (add:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (ADDV_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::ADDV_H,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 492,
        GIR_Done,
      // Label 93: @1208
      GIM_Reject,
    // Label 90: @1209
    GIM_Reject,
    // Label 63: @1210
    GIM_Try, /*On fail goto*//*Label 94*/ 1358,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128BRegClassID,
      GIM_Try, /*On fail goto*//*Label 95*/ 1281, // Rule ID 2350 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/Mips::MSA128BRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/Mips::MSA128BRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128BRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v16i8] } (mul:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt), MSA128BOpnd:{ *:[v16i8] }:$wd_in)  =>  (MADDV_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$wd_in, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::MADDV_B,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // wd_in
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2350,
        GIR_Done,
      // Label 95: @1281
      GIM_Try, /*On fail goto*//*Label 96*/ 1338, // Rule ID 824 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::MSA128BRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/Mips::MSA128BRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/Mips::MSA128BRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$wd_in, (mul:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt))  =>  (MADDV_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$wd_in, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::MADDV_B,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // wd_in
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 824,
        GIR_Done,
      // Label 96: @1338
      GIM_Try, /*On fail goto*//*Label 97*/ 1357, // Rule ID 491 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::MSA128BRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128BRegClassID,
        // (add:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (ADDV_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::ADDV_B,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 491,
        GIR_Done,
      // Label 97: @1357
      GIM_Reject,
    // Label 94: @1358
    GIM_Reject,
    // Label 64: @1359
    GIM_Reject,
    // Label 1: @1360
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 9, /*)*//*default:*//*Label 106*/ 1971,
    /*GILLT_s32*//*Label 98*/ 1374,
    /*GILLT_s64*//*Label 99*/ 1533,
    /*GILLT_v2s16*//*Label 100*/ 1565,
    /*GILLT_v2s64*//*Label 101*/ 1592,
    /*GILLT_v4s8*//*Label 102*/ 1680,
    /*GILLT_v4s32*//*Label 103*/ 1707,
    /*GILLT_v8s16*//*Label 104*/ 1795,
    /*GILLT_v16s8*//*Label 105*/ 1883,
    // Label 98: @1374
    GIM_Try, /*On fail goto*//*Label 107*/ 1532,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 108*/ 1416, // Rule ID 1776 //
        GIM_CheckFeatures, GIFBS_InMips16Mode,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::CPU16RegsRegClassID,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/1, 0,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::CPU16RegsRegClassID,
        // (sub:{ *:[i32] } 0:{ *:[i32] }, CPU16Regs:{ *:[i32] }:$r)  =>  (NegRxRy16:{ *:[i32] } CPU16Regs:{ *:[i32] }:$r)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::NegRxRy16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rx
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // r
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1776,
        GIR_Done,
      // Label 108: @1416
      GIM_Try, /*On fail goto*//*Label 109*/ 1439, // Rule ID 1192 //
        GIM_CheckFeatures, GIFBS_HasMips32r6_InMicroMips,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPRMM16RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::GPRMM16RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPRMM16RegClassID,
        // (sub:{ *:[i32] } GPRMM16Opnd:{ *:[i32] }:$rs, GPRMM16Opnd:{ *:[i32] }:$rt)  =>  (SUBU16_MMR6:{ *:[i32] } GPRMM16Opnd:{ *:[i32] }:$rs, GPRMM16Opnd:{ *:[i32] }:$rt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::SUBU16_MMR6,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1192,
        GIR_Done,
      // Label 109: @1439
      GIM_Try, /*On fail goto*//*Label 110*/ 1462, // Rule ID 47 //
        GIM_CheckFeatures, GIFBS_HasStdEnc_NotInMicroMips,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR32RegClassID,
        // (sub:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (SUBu:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::SUBu,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 47,
        GIR_Done,
      // Label 110: @1462
      GIM_Try, /*On fail goto*//*Label 111*/ 1485, // Rule ID 1048 //
        GIM_CheckFeatures, GIFBS_InMicroMips_NotMips32r6,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPRMM16RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::GPRMM16RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPRMM16RegClassID,
        // (sub:{ *:[i32] } GPRMM16Opnd:{ *:[i32] }:$rs, GPRMM16Opnd:{ *:[i32] }:$rt)  =>  (SUBU16_MM:{ *:[i32] } GPRMM16Opnd:{ *:[i32] }:$rs, GPRMM16Opnd:{ *:[i32] }:$rt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::SUBU16_MM,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1048,
        GIR_Done,
      // Label 111: @1485
      GIM_Try, /*On fail goto*//*Label 112*/ 1508, // Rule ID 1057 //
        GIM_CheckFeatures, GIFBS_InMicroMips_NotMips32r6,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR32RegClassID,
        // (sub:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (SUBu_MM:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::SUBu_MM,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1057,
        GIR_Done,
      // Label 112: @1508
      GIM_Try, /*On fail goto*//*Label 113*/ 1531, // Rule ID 1781 //
        GIM_CheckFeatures, GIFBS_InMips16Mode,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::CPU16RegsRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::CPU16RegsRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::CPU16RegsRegClassID,
        // (sub:{ *:[i32] } CPU16Regs:{ *:[i32] }:$l, CPU16Regs:{ *:[i32] }:$r)  =>  (SubuRxRyRz16:{ *:[i32] } CPU16Regs:{ *:[i32] }:$l, CPU16Regs:{ *:[i32] }:$r)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::SubuRxRyRz16,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1781,
        GIR_Done,
      // Label 113: @1531
      GIM_Reject,
    // Label 107: @1532
    GIM_Reject,
    // Label 99: @1533
    GIM_Try, /*On fail goto*//*Label 114*/ 1564, // Rule ID 197 //
      GIM_CheckFeatures, GIFBS_HasMips3_HasStdEnc_NotInMicroMips,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::GPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR64RegClassID,
      // (sub:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rs, GPR64Opnd:{ *:[i64] }:$rt)  =>  (DSUBu:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rs, GPR64Opnd:{ *:[i64] }:$rt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::DSUBu,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 197,
      GIR_Done,
    // Label 114: @1564
    GIM_Reject,
    // Label 100: @1565
    GIM_Try, /*On fail goto*//*Label 115*/ 1591, // Rule ID 1878 //
      GIM_CheckFeatures, GIFBS_HasDSP,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
      // (sub:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$a, v2i16:{ *:[v2i16] }:$b)  =>  (SUBQ_PH:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$a, v2i16:{ *:[v2i16] }:$b)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::SUBQ_PH,
      GIR_AddImplicitDef, /*InsnID*/0, Mips::DSPOutFlag20,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1878,
      GIR_Done,
    // Label 115: @1591
    GIM_Reject,
    // Label 101: @1592
    GIM_Try, /*On fail goto*//*Label 116*/ 1679,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::MSA128DRegClassID,
      GIM_Try, /*On fail goto*//*Label 117*/ 1663, // Rule ID 883 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sub:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$wd_in, (mul:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt))  =>  (MSUBV_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$wd_in, MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::MSUBV_D,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // wd_in
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 883,
        GIR_Done,
      // Label 117: @1663
      GIM_Try, /*On fail goto*//*Label 118*/ 1678, // Rule ID 1012 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128DRegClassID,
        // (sub:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)  =>  (SUBV_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::SUBV_D,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1012,
        GIR_Done,
      // Label 118: @1678
      GIM_Reject,
    // Label 116: @1679
    GIM_Reject,
    // Label 102: @1680
    GIM_Try, /*On fail goto*//*Label 119*/ 1706, // Rule ID 1884 //
      GIM_CheckFeatures, GIFBS_HasDSP,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
      // (sub:{ *:[v4i8] } v4i8:{ *:[v4i8] }:$a, v4i8:{ *:[v4i8] }:$b)  =>  (SUBU_QB:{ *:[v4i8] } v4i8:{ *:[v4i8] }:$a, v4i8:{ *:[v4i8] }:$b)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::SUBU_QB,
      GIR_AddImplicitDef, /*InsnID*/0, Mips::DSPOutFlag20,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1884,
      GIR_Done,
    // Label 119: @1706
    GIM_Reject,
    // Label 103: @1707
    GIM_Try, /*On fail goto*//*Label 120*/ 1794,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::MSA128WRegClassID,
      GIM_Try, /*On fail goto*//*Label 121*/ 1778, // Rule ID 882 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sub:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$wd_in, (mul:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt))  =>  (MSUBV_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$wd_in, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::MSUBV_W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // wd_in
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 882,
        GIR_Done,
      // Label 121: @1778
      GIM_Try, /*On fail goto*//*Label 122*/ 1793, // Rule ID 1011 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128WRegClassID,
        // (sub:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (SUBV_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::SUBV_W,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1011,
        GIR_Done,
      // Label 122: @1793
      GIM_Reject,
    // Label 120: @1794
    GIM_Reject,
    // Label 104: @1795
    GIM_Try, /*On fail goto*//*Label 123*/ 1882,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128HRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::MSA128HRegClassID,
      GIM_Try, /*On fail goto*//*Label 124*/ 1866, // Rule ID 881 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sub:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$wd_in, (mul:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt))  =>  (MSUBV_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$wd_in, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::MSUBV_H,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // wd_in
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 881,
        GIR_Done,
      // Label 124: @1866
      GIM_Try, /*On fail goto*//*Label 125*/ 1881, // Rule ID 1010 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128HRegClassID,
        // (sub:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (SUBV_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::SUBV_H,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1010,
        GIR_Done,
      // Label 125: @1881
      GIM_Reject,
    // Label 123: @1882
    GIM_Reject,
    // Label 105: @1883
    GIM_Try, /*On fail goto*//*Label 126*/ 1970,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128BRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::MSA128BRegClassID,
      GIM_Try, /*On fail goto*//*Label 127*/ 1954, // Rule ID 880 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/Mips::MSA128BRegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/Mips::MSA128BRegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sub:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$wd_in, (mul:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt))  =>  (MSUBV_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$wd_in, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::MSUBV_B,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // wd_in
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 880,
        GIR_Done,
      // Label 127: @1954
      GIM_Try, /*On fail goto*//*Label 128*/ 1969, // Rule ID 1009 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128BRegClassID,
        // (sub:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (SUBV_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::SUBV_B,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1009,
        GIR_Done,
      // Label 128: @1969
      GIM_Reject,
    // Label 126: @1970
    GIM_Reject,
    // Label 106: @1971
    GIM_Reject,
    // Label 2: @1972
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 9, /*)*//*default:*//*Label 136*/ 2347,
    /*GILLT_s32*//*Label 129*/ 1986,
    /*GILLT_s64*//*Label 130*/ 2131,
    /*GILLT_v2s16*//*Label 131*/ 2192,
    /*GILLT_v2s64*//*Label 132*/ 2219, 0,
    /*GILLT_v4s32*//*Label 133*/ 2251,
    /*GILLT_v8s16*//*Label 134*/ 2283,
    /*GILLT_v16s8*//*Label 135*/ 2315,
    // Label 129: @1986
    GIM_Try, /*On fail goto*//*Label 137*/ 2130,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 138*/ 2025, // Rule ID 48 //
        GIM_CheckFeatures, GIFBS_HasMips32_HasStdEnc_NotInMicroMips_NotMips32r6_NotMips64r6,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR32RegClassID,
        // (mul:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (MUL:{ *:[i32] }:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::MUL,
        GIR_AddImplicitDef, /*InsnID*/0, Mips::HI0,
        GIR_AddImplicitDef, /*InsnID*/0, Mips::LO0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 48,
        GIR_Done,
      // Label 138: @2025
      GIM_Try, /*On fail goto*//*Label 139*/ 2048, // Rule ID 320 //
        GIM_CheckFeatures, GIFBS_HasMips32r6_HasStdEnc_NotInMicroMips,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR32RegClassID,
        // (mul:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (MUL_R6:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::MUL_R6,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 320,
        GIR_Done,
      // Label 139: @2048
      GIM_Try, /*On fail goto*//*Label 140*/ 2077, // Rule ID 1058 //
        GIM_CheckFeatures, GIFBS_InMicroMips_NotMips32r6,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR32RegClassID,
        // (mul:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (MUL_MM:{ *:[i32] }:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::MUL_MM,
        GIR_AddImplicitDef, /*InsnID*/0, Mips::HI0,
        GIR_AddImplicitDef, /*InsnID*/0, Mips::LO0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1058,
        GIR_Done,
      // Label 140: @2077
      GIM_Try, /*On fail goto*//*Label 141*/ 2100, // Rule ID 1161 //
        GIM_CheckFeatures, GIFBS_HasMips32r6_InMicroMips,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR32RegClassID,
        // (mul:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (MUL_MMR6:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::MUL_MMR6,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1161,
        GIR_Done,
      // Label 141: @2100
      GIM_Try, /*On fail goto*//*Label 142*/ 2129, // Rule ID 1779 //
        GIM_CheckFeatures, GIFBS_InMips16Mode,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::CPU16RegsRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::CPU16RegsRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::CPU16RegsRegClassID,
        // (mul:{ *:[i32] } CPU16Regs:{ *:[i32] }:$l, CPU16Regs:{ *:[i32] }:$r)  =>  (MultRxRyRz16:{ *:[i32] }:{ *:[i32] } CPU16Regs:{ *:[i32] }:$l, CPU16Regs:{ *:[i32] }:$r)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::MultRxRyRz16,
        GIR_AddImplicitDef, /*InsnID*/0, Mips::HI0,
        GIR_AddImplicitDef, /*InsnID*/0, Mips::LO0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1779,
        GIR_Done,
      // Label 142: @2129
      GIM_Reject,
    // Label 137: @2130
    GIM_Reject,
    // Label 130: @2131
    GIM_Try, /*On fail goto*//*Label 143*/ 2191,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::GPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR64RegClassID,
      GIM_Try, /*On fail goto*//*Label 144*/ 2179, // Rule ID 262 //
        GIM_CheckFeatures, GIFBS_HasCnMips,
        // (mul:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rs, GPR64Opnd:{ *:[i64] }:$rt)  =>  (DMUL:{ *:[i64] }:{ *:[i32] } GPR64Opnd:{ *:[i64] }:$rs, GPR64Opnd:{ *:[i64] }:$rt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::DMUL,
        GIR_AddImplicitDef, /*InsnID*/0, Mips::HI0,
        GIR_AddImplicitDef, /*InsnID*/0, Mips::LO0,
        GIR_AddImplicitDef, /*InsnID*/0, Mips::P0,
        GIR_AddImplicitDef, /*InsnID*/0, Mips::P1,
        GIR_AddImplicitDef, /*InsnID*/0, Mips::P2,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 262,
        GIR_Done,
      // Label 144: @2179
      GIM_Try, /*On fail goto*//*Label 145*/ 2190, // Rule ID 335 //
        GIM_CheckFeatures, GIFBS_HasMips64r6_HasStdEnc_NotInMicroMips,
        // (mul:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rs, GPR64Opnd:{ *:[i64] }:$rt)  =>  (DMUL_R6:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rs, GPR64Opnd:{ *:[i64] }:$rt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::DMUL_R6,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 335,
        GIR_Done,
      // Label 145: @2190
      GIM_Reject,
    // Label 143: @2191
    GIM_Reject,
    // Label 131: @2192
    GIM_Try, /*On fail goto*//*Label 146*/ 2218, // Rule ID 1880 //
      GIM_CheckFeatures, GIFBS_HasDSPR2,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
      // (mul:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$a, v2i16:{ *:[v2i16] }:$b)  =>  (MUL_PH:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$a, v2i16:{ *:[v2i16] }:$b)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::MUL_PH,
      GIR_AddImplicitDef, /*InsnID*/0, Mips::DSPOutFlag21,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1880,
      GIR_Done,
    // Label 146: @2218
    GIM_Reject,
    // Label 132: @2219
    GIM_Try, /*On fail goto*//*Label 147*/ 2250, // Rule ID 891 //
      GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::MSA128DRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128DRegClassID,
      // (mul:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)  =>  (MULV_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::MULV_D,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 891,
      GIR_Done,
    // Label 147: @2250
    GIM_Reject,
    // Label 133: @2251
    GIM_Try, /*On fail goto*//*Label 148*/ 2282, // Rule ID 890 //
      GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::MSA128WRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128WRegClassID,
      // (mul:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (MULV_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::MULV_W,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 890,
      GIR_Done,
    // Label 148: @2282
    GIM_Reject,
    // Label 134: @2283
    GIM_Try, /*On fail goto*//*Label 149*/ 2314, // Rule ID 889 //
      GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128HRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::MSA128HRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128HRegClassID,
      // (mul:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (MULV_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::MULV_H,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 889,
      GIR_Done,
    // Label 149: @2314
    GIM_Reject,
    // Label 135: @2315
    GIM_Try, /*On fail goto*//*Label 150*/ 2346, // Rule ID 888 //
      GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128BRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::MSA128BRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128BRegClassID,
      // (mul:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (MULV_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::MULV_B,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 888,
      GIR_Done,
    // Label 150: @2346
    GIM_Reject,
    // Label 136: @2347
    GIM_Reject,
    // Label 3: @2348
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 9, /*)*//*default:*//*Label 157*/ 2568,
    /*GILLT_s32*//*Label 151*/ 2362,
    /*GILLT_s64*//*Label 152*/ 2408, 0,
    /*GILLT_v2s64*//*Label 153*/ 2440, 0,
    /*GILLT_v4s32*//*Label 154*/ 2472,
    /*GILLT_v8s16*//*Label 155*/ 2504,
    /*GILLT_v16s8*//*Label 156*/ 2536,
    // Label 151: @2362
    GIM_Try, /*On fail goto*//*Label 158*/ 2407,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::GPR32RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR32RegClassID,
      GIM_Try, /*On fail goto*//*Label 159*/ 2395, // Rule ID 314 //
        GIM_CheckFeatures, GIFBS_HasMips32r6_HasStdEnc_NotInMicroMips,
        // (sdiv:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (DIV:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::DIV,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 314,
        GIR_Done,
      // Label 159: @2395
      GIM_Try, /*On fail goto*//*Label 160*/ 2406, // Rule ID 1154 //
        GIM_CheckFeatures, GIFBS_HasMips32r6_InMicroMips,
        // (sdiv:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (DIV_MMR6:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::DIV_MMR6,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1154,
        GIR_Done,
      // Label 160: @2406
      GIM_Reject,
    // Label 158: @2407
    GIM_Reject,
    // Label 152: @2408
    GIM_Try, /*On fail goto*//*Label 161*/ 2439, // Rule ID 329 //
      GIM_CheckFeatures, GIFBS_HasMips64r6_HasStdEnc_NotInMicroMips,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::GPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR64RegClassID,
      // (sdiv:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rs, GPR64Opnd:{ *:[i64] }:$rt)  =>  (DDIV:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rs, GPR64Opnd:{ *:[i64] }:$rt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::DDIV,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 329,
      GIR_Done,
    // Label 161: @2439
    GIM_Reject,
    // Label 153: @2440
    GIM_Try, /*On fail goto*//*Label 162*/ 2471, // Rule ID 631 //
      GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::MSA128DRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128DRegClassID,
      // (sdiv:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)  =>  (DIV_S_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::DIV_S_D,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 631,
      GIR_Done,
    // Label 162: @2471
    GIM_Reject,
    // Label 154: @2472
    GIM_Try, /*On fail goto*//*Label 163*/ 2503, // Rule ID 630 //
      GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::MSA128WRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128WRegClassID,
      // (sdiv:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (DIV_S_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::DIV_S_W,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 630,
      GIR_Done,
    // Label 163: @2503
    GIM_Reject,
    // Label 155: @2504
    GIM_Try, /*On fail goto*//*Label 164*/ 2535, // Rule ID 629 //
      GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128HRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::MSA128HRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128HRegClassID,
      // (sdiv:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (DIV_S_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::DIV_S_H,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 629,
      GIR_Done,
    // Label 164: @2535
    GIM_Reject,
    // Label 156: @2536
    GIM_Try, /*On fail goto*//*Label 165*/ 2567, // Rule ID 628 //
      GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128BRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::MSA128BRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128BRegClassID,
      // (sdiv:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (DIV_S_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::DIV_S_B,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 628,
      GIR_Done,
    // Label 165: @2567
    GIM_Reject,
    // Label 157: @2568
    GIM_Reject,
    // Label 4: @2569
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 9, /*)*//*default:*//*Label 172*/ 2789,
    /*GILLT_s32*//*Label 166*/ 2583,
    /*GILLT_s64*//*Label 167*/ 2629, 0,
    /*GILLT_v2s64*//*Label 168*/ 2661, 0,
    /*GILLT_v4s32*//*Label 169*/ 2693,
    /*GILLT_v8s16*//*Label 170*/ 2725,
    /*GILLT_v16s8*//*Label 171*/ 2757,
    // Label 166: @2583
    GIM_Try, /*On fail goto*//*Label 173*/ 2628,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::GPR32RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR32RegClassID,
      GIM_Try, /*On fail goto*//*Label 174*/ 2616, // Rule ID 315 //
        GIM_CheckFeatures, GIFBS_HasMips32r6_HasStdEnc_NotInMicroMips,
        // (udiv:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (DIVU:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::DIVU,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 315,
        GIR_Done,
      // Label 174: @2616
      GIM_Try, /*On fail goto*//*Label 175*/ 2627, // Rule ID 1155 //
        GIM_CheckFeatures, GIFBS_HasMips32r6_InMicroMips,
        // (udiv:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (DIVU_MMR6:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::DIVU_MMR6,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1155,
        GIR_Done,
      // Label 175: @2627
      GIM_Reject,
    // Label 173: @2628
    GIM_Reject,
    // Label 167: @2629
    GIM_Try, /*On fail goto*//*Label 176*/ 2660, // Rule ID 330 //
      GIM_CheckFeatures, GIFBS_HasMips64r6_HasStdEnc_NotInMicroMips,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::GPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR64RegClassID,
      // (udiv:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rs, GPR64Opnd:{ *:[i64] }:$rt)  =>  (DDIVU:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rs, GPR64Opnd:{ *:[i64] }:$rt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::DDIVU,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 330,
      GIR_Done,
    // Label 176: @2660
    GIM_Reject,
    // Label 168: @2661
    GIM_Try, /*On fail goto*//*Label 177*/ 2692, // Rule ID 635 //
      GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::MSA128DRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128DRegClassID,
      // (udiv:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)  =>  (DIV_U_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::DIV_U_D,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 635,
      GIR_Done,
    // Label 177: @2692
    GIM_Reject,
    // Label 169: @2693
    GIM_Try, /*On fail goto*//*Label 178*/ 2724, // Rule ID 634 //
      GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::MSA128WRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128WRegClassID,
      // (udiv:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (DIV_U_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::DIV_U_W,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 634,
      GIR_Done,
    // Label 178: @2724
    GIM_Reject,
    // Label 170: @2725
    GIM_Try, /*On fail goto*//*Label 179*/ 2756, // Rule ID 633 //
      GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128HRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::MSA128HRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128HRegClassID,
      // (udiv:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (DIV_U_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::DIV_U_H,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 633,
      GIR_Done,
    // Label 179: @2756
    GIM_Reject,
    // Label 171: @2757
    GIM_Try, /*On fail goto*//*Label 180*/ 2788, // Rule ID 632 //
      GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128BRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::MSA128BRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128BRegClassID,
      // (udiv:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (DIV_U_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::DIV_U_B,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 632,
      GIR_Done,
    // Label 180: @2788
    GIM_Reject,
    // Label 172: @2789
    GIM_Reject,
    // Label 5: @2790
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 9, /*)*//*default:*//*Label 187*/ 3010,
    /*GILLT_s32*//*Label 181*/ 2804,
    /*GILLT_s64*//*Label 182*/ 2850, 0,
    /*GILLT_v2s64*//*Label 183*/ 2882, 0,
    /*GILLT_v4s32*//*Label 184*/ 2914,
    /*GILLT_v8s16*//*Label 185*/ 2946,
    /*GILLT_v16s8*//*Label 186*/ 2978,
    // Label 181: @2804
    GIM_Try, /*On fail goto*//*Label 188*/ 2849,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::GPR32RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR32RegClassID,
      GIM_Try, /*On fail goto*//*Label 189*/ 2837, // Rule ID 316 //
        GIM_CheckFeatures, GIFBS_HasMips32r6_HasStdEnc_NotInMicroMips,
        // (srem:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (MOD:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::MOD,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 316,
        GIR_Done,
      // Label 189: @2837
      GIM_Try, /*On fail goto*//*Label 190*/ 2848, // Rule ID 1159 //
        GIM_CheckFeatures, GIFBS_HasMips32r6_InMicroMips,
        // (srem:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (MOD_MMR6:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::MOD_MMR6,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1159,
        GIR_Done,
      // Label 190: @2848
      GIM_Reject,
    // Label 188: @2849
    GIM_Reject,
    // Label 182: @2850
    GIM_Try, /*On fail goto*//*Label 191*/ 2881, // Rule ID 331 //
      GIM_CheckFeatures, GIFBS_HasMips64r6_HasStdEnc_NotInMicroMips,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::GPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR64RegClassID,
      // (srem:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rs, GPR64Opnd:{ *:[i64] }:$rt)  =>  (DMOD:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rs, GPR64Opnd:{ *:[i64] }:$rt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::DMOD,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 331,
      GIR_Done,
    // Label 191: @2881
    GIM_Reject,
    // Label 183: @2882
    GIM_Try, /*On fail goto*//*Label 192*/ 2913, // Rule ID 871 //
      GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::MSA128DRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128DRegClassID,
      // (srem:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)  =>  (MOD_S_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::MOD_S_D,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 871,
      GIR_Done,
    // Label 192: @2913
    GIM_Reject,
    // Label 184: @2914
    GIM_Try, /*On fail goto*//*Label 193*/ 2945, // Rule ID 870 //
      GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::MSA128WRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128WRegClassID,
      // (srem:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (MOD_S_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::MOD_S_W,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 870,
      GIR_Done,
    // Label 193: @2945
    GIM_Reject,
    // Label 185: @2946
    GIM_Try, /*On fail goto*//*Label 194*/ 2977, // Rule ID 869 //
      GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128HRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::MSA128HRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128HRegClassID,
      // (srem:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (MOD_S_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::MOD_S_H,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 869,
      GIR_Done,
    // Label 194: @2977
    GIM_Reject,
    // Label 186: @2978
    GIM_Try, /*On fail goto*//*Label 195*/ 3009, // Rule ID 868 //
      GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128BRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::MSA128BRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128BRegClassID,
      // (srem:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (MOD_S_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::MOD_S_B,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 868,
      GIR_Done,
    // Label 195: @3009
    GIM_Reject,
    // Label 187: @3010
    GIM_Reject,
    // Label 6: @3011
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 9, /*)*//*default:*//*Label 202*/ 3231,
    /*GILLT_s32*//*Label 196*/ 3025,
    /*GILLT_s64*//*Label 197*/ 3071, 0,
    /*GILLT_v2s64*//*Label 198*/ 3103, 0,
    /*GILLT_v4s32*//*Label 199*/ 3135,
    /*GILLT_v8s16*//*Label 200*/ 3167,
    /*GILLT_v16s8*//*Label 201*/ 3199,
    // Label 196: @3025
    GIM_Try, /*On fail goto*//*Label 203*/ 3070,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::GPR32RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR32RegClassID,
      GIM_Try, /*On fail goto*//*Label 204*/ 3058, // Rule ID 317 //
        GIM_CheckFeatures, GIFBS_HasMips32r6_HasStdEnc_NotInMicroMips,
        // (urem:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (MODU:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::MODU,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 317,
        GIR_Done,
      // Label 204: @3058
      GIM_Try, /*On fail goto*//*Label 205*/ 3069, // Rule ID 1160 //
        GIM_CheckFeatures, GIFBS_HasMips32r6_InMicroMips,
        // (urem:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (MODU_MMR6:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::MODU_MMR6,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1160,
        GIR_Done,
      // Label 205: @3069
      GIM_Reject,
    // Label 203: @3070
    GIM_Reject,
    // Label 197: @3071
    GIM_Try, /*On fail goto*//*Label 206*/ 3102, // Rule ID 332 //
      GIM_CheckFeatures, GIFBS_HasMips64r6_HasStdEnc_NotInMicroMips,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::GPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR64RegClassID,
      // (urem:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rs, GPR64Opnd:{ *:[i64] }:$rt)  =>  (DMODU:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rs, GPR64Opnd:{ *:[i64] }:$rt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::DMODU,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 332,
      GIR_Done,
    // Label 206: @3102
    GIM_Reject,
    // Label 198: @3103
    GIM_Try, /*On fail goto*//*Label 207*/ 3134, // Rule ID 875 //
      GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::MSA128DRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128DRegClassID,
      // (urem:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)  =>  (MOD_U_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::MOD_U_D,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 875,
      GIR_Done,
    // Label 207: @3134
    GIM_Reject,
    // Label 199: @3135
    GIM_Try, /*On fail goto*//*Label 208*/ 3166, // Rule ID 874 //
      GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::MSA128WRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128WRegClassID,
      // (urem:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (MOD_U_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::MOD_U_W,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 874,
      GIR_Done,
    // Label 208: @3166
    GIM_Reject,
    // Label 200: @3167
    GIM_Try, /*On fail goto*//*Label 209*/ 3198, // Rule ID 873 //
      GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128HRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::MSA128HRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128HRegClassID,
      // (urem:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (MOD_U_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::MOD_U_H,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 873,
      GIR_Done,
    // Label 209: @3198
    GIM_Reject,
    // Label 201: @3199
    GIM_Try, /*On fail goto*//*Label 210*/ 3230, // Rule ID 872 //
      GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128BRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::MSA128BRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128BRegClassID,
      // (urem:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (MOD_U_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::MOD_U_B,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 872,
      GIR_Done,
    // Label 210: @3230
    GIM_Reject,
    // Label 202: @3231
    GIM_Reject,
    // Label 7: @3232
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 9, /*)*//*default:*//*Label 217*/ 3718,
    /*GILLT_s32*//*Label 211*/ 3246,
    /*GILLT_s64*//*Label 212*/ 3502, 0,
    /*GILLT_v2s64*//*Label 213*/ 3590, 0,
    /*GILLT_v4s32*//*Label 214*/ 3622,
    /*GILLT_v8s16*//*Label 215*/ 3654,
    /*GILLT_v16s8*//*Label 216*/ 3686,
    // Label 211: @3246
    GIM_Try, /*On fail goto*//*Label 218*/ 3501,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 219*/ 3299, // Rule ID 41 //
        GIM_CheckFeatures, GIFBS_HasStdEnc_NotInMicroMips,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckAPIntImmPredicate, /*MI*/1, /*Predicate*/GIPFP_APInt_Predicate_imm32ZExt16,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (and:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, (imm:{ *:[i32] })<<P:Predicate_imm32ZExt16>>:$imm16)  =>  (ANDi:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, (imm:{ *:[i32] }):$imm16)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::ANDi,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm16
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 41,
        GIR_Done,
      // Label 219: @3299
      GIM_Try, /*On fail goto*//*Label 220*/ 3342, // Rule ID 2120 //
        GIM_CheckFeatures, GIFBS_InMicroMips,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPRMM16RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::GPRMM16RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_immZExtAndi16,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (and:{ *:[i32] } GPRMM16:{ *:[i32] }:$src, (imm:{ *:[i32] })<<P:Predicate_immZExtAndi16>>:$imm)  =>  (ANDI16_MM:{ *:[i32] } GPRMM16:{ *:[i32] }:$src, (imm:{ *:[i32] })<<P:Predicate_immZExtAndi16>>:$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::ANDI16_MM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2120,
        GIR_Done,
      // Label 220: @3342
      GIM_Try, /*On fail goto*//*Label 221*/ 3385, // Rule ID 2277 //
        GIM_CheckFeatures, GIFBS_HasMips32r6_InMicroMips,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPRMM16RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::GPRMM16RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_immZExtAndi16,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (and:{ *:[i32] } GPRMM16:{ *:[i32] }:$src, (imm:{ *:[i32] })<<P:Predicate_immZExtAndi16>>:$imm)  =>  (ANDI16_MMR6:{ *:[i32] } GPRMM16:{ *:[i32] }:$src, (imm:{ *:[i32] })<<P:Predicate_immZExtAndi16>>:$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::ANDI16_MMR6,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2277,
        GIR_Done,
      // Label 221: @3385
      GIM_Try, /*On fail goto*//*Label 222*/ 3408, // Rule ID 51 //
        GIM_CheckFeatures, GIFBS_HasStdEnc_NotInMicroMips,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR32RegClassID,
        // (and:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (AND:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::AND,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51,
        GIR_Done,
      // Label 222: @3408
      GIM_Try, /*On fail goto*//*Label 223*/ 3431, // Rule ID 1045 //
        GIM_CheckFeatures, GIFBS_InMicroMips_NotMips32r6,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPRMM16RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::GPRMM16RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPRMM16RegClassID,
        // (and:{ *:[i32] } GPRMM16Opnd:{ *:[i32] }:$rs, GPRMM16Opnd:{ *:[i32] }:$rt)  =>  (AND16_MM:{ *:[i32] } GPRMM16Opnd:{ *:[i32] }:$rs, GPRMM16Opnd:{ *:[i32] }:$rt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::AND16_MM,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1045,
        GIR_Done,
      // Label 223: @3431
      GIM_Try, /*On fail goto*//*Label 224*/ 3454, // Rule ID 1061 //
        GIM_CheckFeatures, GIFBS_InMicroMips_NotMips32r6,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR32RegClassID,
        // (and:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (AND_MM:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::AND_MM,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1061,
        GIR_Done,
      // Label 224: @3454
      GIM_Try, /*On fail goto*//*Label 225*/ 3477, // Rule ID 1152 //
        GIM_CheckFeatures, GIFBS_HasMips32r6_InMicroMips,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR32RegClassID,
        // (and:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (AND_MMR6:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::AND_MMR6,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1152,
        GIR_Done,
      // Label 225: @3477
      GIM_Try, /*On fail goto*//*Label 226*/ 3500, // Rule ID 1778 //
        GIM_CheckFeatures, GIFBS_InMips16Mode,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::CPU16RegsRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::CPU16RegsRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::CPU16RegsRegClassID,
        // (and:{ *:[i32] } CPU16Regs:{ *:[i32] }:$l, CPU16Regs:{ *:[i32] }:$r)  =>  (AndRxRxRy16:{ *:[i32] } CPU16Regs:{ *:[i32] }:$l, CPU16Regs:{ *:[i32] }:$r)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::AndRxRxRy16,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1778,
        GIR_Done,
      // Label 226: @3500
      GIM_Reject,
    // Label 218: @3501
    GIM_Reject,
    // Label 212: @3502
    GIM_Try, /*On fail goto*//*Label 227*/ 3589,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR64RegClassID,
      GIM_Try, /*On fail goto*//*Label 228*/ 3569, // Rule ID 257 //
        GIM_CheckFeatures, GIFBS_HasCnMips,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ADD,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/Mips::GPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/Mips::GPR64RegClassID,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, 255,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (and:{ *:[i64] } (add:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rs, GPR64Opnd:{ *:[i64] }:$rt), 255:{ *:[i64] })  =>  (BADDu:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rs, GPR64Opnd:{ *:[i64] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::BADDu,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 257,
        GIR_Done,
      // Label 228: @3569
      GIM_Try, /*On fail goto*//*Label 229*/ 3588, // Rule ID 200 //
        GIM_CheckFeatures, GIFBS_IsGP64bit_NotInMips16Mode,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::GPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR64RegClassID,
        // (and:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rs, GPR64Opnd:{ *:[i64] }:$rt)  =>  (AND64:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rs, GPR64Opnd:{ *:[i64] }:$rt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::AND64,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 200,
        GIR_Done,
      // Label 229: @3588
      GIM_Reject,
    // Label 227: @3589
    GIM_Reject,
    // Label 213: @3590
    GIM_Try, /*On fail goto*//*Label 230*/ 3621, // Rule ID 502 //
      GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::MSA128DRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128DRegClassID,
      // (and:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)  =>  (AND_V_D_PSEUDO:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::AND_V_D_PSEUDO,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 502,
      GIR_Done,
    // Label 230: @3621
    GIM_Reject,
    // Label 214: @3622
    GIM_Try, /*On fail goto*//*Label 231*/ 3653, // Rule ID 501 //
      GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::MSA128WRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128WRegClassID,
      // (and:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (AND_V_W_PSEUDO:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::AND_V_W_PSEUDO,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 501,
      GIR_Done,
    // Label 231: @3653
    GIM_Reject,
    // Label 215: @3654
    GIM_Try, /*On fail goto*//*Label 232*/ 3685, // Rule ID 500 //
      GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128HRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::MSA128HRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128HRegClassID,
      // (and:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (AND_V_H_PSEUDO:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::AND_V_H_PSEUDO,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 500,
      GIR_Done,
    // Label 232: @3685
    GIM_Reject,
    // Label 216: @3686
    GIM_Try, /*On fail goto*//*Label 233*/ 3717, // Rule ID 499 //
      GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128BRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::MSA128BRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128BRegClassID,
      // (and:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (AND_V:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::AND_V,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 499,
      GIR_Done,
    // Label 233: @3717
    GIM_Reject,
    // Label 217: @3718
    GIM_Reject,
    // Label 8: @3719
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 9, /*)*//*default:*//*Label 240*/ 4063,
    /*GILLT_s32*//*Label 234*/ 3733,
    /*GILLT_s64*//*Label 235*/ 3903, 0,
    /*GILLT_v2s64*//*Label 236*/ 3935, 0,
    /*GILLT_v4s32*//*Label 237*/ 3967,
    /*GILLT_v8s16*//*Label 238*/ 3999,
    /*GILLT_v16s8*//*Label 239*/ 4031,
    // Label 234: @3733
    GIM_Try, /*On fail goto*//*Label 241*/ 3902,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 242*/ 3786, // Rule ID 42 //
        GIM_CheckFeatures, GIFBS_HasStdEnc_NotInMicroMips,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckAPIntImmPredicate, /*MI*/1, /*Predicate*/GIPFP_APInt_Predicate_imm32ZExt16,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (or:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, (imm:{ *:[i32] })<<P:Predicate_imm32ZExt16>>:$imm16)  =>  (ORi:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, (imm:{ *:[i32] }):$imm16)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::ORi,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm16
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 42,
        GIR_Done,
      // Label 242: @3786
      GIM_Try, /*On fail goto*//*Label 243*/ 3809, // Rule ID 52 //
        GIM_CheckFeatures, GIFBS_HasStdEnc_NotInMicroMips,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR32RegClassID,
        // (or:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (OR:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::OR,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 52,
        GIR_Done,
      // Label 243: @3809
      GIM_Try, /*On fail goto*//*Label 244*/ 3832, // Rule ID 1047 //
        GIM_CheckFeatures, GIFBS_InMicroMips_NotMips32r6,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPRMM16RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::GPRMM16RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPRMM16RegClassID,
        // (or:{ *:[i32] } GPRMM16Opnd:{ *:[i32] }:$rs, GPRMM16Opnd:{ *:[i32] }:$rt)  =>  (OR16_MM:{ *:[i32] } GPRMM16Opnd:{ *:[i32] }:$rs, GPRMM16Opnd:{ *:[i32] }:$rt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::OR16_MM,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1047,
        GIR_Done,
      // Label 244: @3832
      GIM_Try, /*On fail goto*//*Label 245*/ 3855, // Rule ID 1062 //
        GIM_CheckFeatures, GIFBS_InMicroMips_NotMips32r6,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR32RegClassID,
        // (or:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (OR_MM:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::OR_MM,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1062,
        GIR_Done,
      // Label 245: @3855
      GIM_Try, /*On fail goto*//*Label 246*/ 3878, // Rule ID 1165 //
        GIM_CheckFeatures, GIFBS_HasMips32r6_InMicroMips,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR32RegClassID,
        // (or:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (OR_MMR6:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::OR_MMR6,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1165,
        GIR_Done,
      // Label 246: @3878
      GIM_Try, /*On fail goto*//*Label 247*/ 3901, // Rule ID 1780 //
        GIM_CheckFeatures, GIFBS_InMips16Mode,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::CPU16RegsRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::CPU16RegsRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::CPU16RegsRegClassID,
        // (or:{ *:[i32] } CPU16Regs:{ *:[i32] }:$l, CPU16Regs:{ *:[i32] }:$r)  =>  (OrRxRxRy16:{ *:[i32] } CPU16Regs:{ *:[i32] }:$l, CPU16Regs:{ *:[i32] }:$r)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::OrRxRxRy16,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1780,
        GIR_Done,
      // Label 247: @3901
      GIM_Reject,
    // Label 241: @3902
    GIM_Reject,
    // Label 235: @3903
    GIM_Try, /*On fail goto*//*Label 248*/ 3934, // Rule ID 201 //
      GIM_CheckFeatures, GIFBS_IsGP64bit_NotInMips16Mode,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::GPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR64RegClassID,
      // (or:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rs, GPR64Opnd:{ *:[i64] }:$rt)  =>  (OR64:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rs, GPR64Opnd:{ *:[i64] }:$rt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::OR64,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 201,
      GIR_Done,
    // Label 248: @3934
    GIM_Reject,
    // Label 236: @3935
    GIM_Try, /*On fail goto*//*Label 249*/ 3966, // Rule ID 908 //
      GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::MSA128DRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128DRegClassID,
      // (or:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)  =>  (OR_V_D_PSEUDO:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::OR_V_D_PSEUDO,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 908,
      GIR_Done,
    // Label 249: @3966
    GIM_Reject,
    // Label 237: @3967
    GIM_Try, /*On fail goto*//*Label 250*/ 3998, // Rule ID 907 //
      GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::MSA128WRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128WRegClassID,
      // (or:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (OR_V_W_PSEUDO:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::OR_V_W_PSEUDO,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 907,
      GIR_Done,
    // Label 250: @3998
    GIM_Reject,
    // Label 238: @3999
    GIM_Try, /*On fail goto*//*Label 251*/ 4030, // Rule ID 906 //
      GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128HRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::MSA128HRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128HRegClassID,
      // (or:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (OR_V_H_PSEUDO:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::OR_V_H_PSEUDO,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 906,
      GIR_Done,
    // Label 251: @4030
    GIM_Reject,
    // Label 239: @4031
    GIM_Try, /*On fail goto*//*Label 252*/ 4062, // Rule ID 905 //
      GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128BRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::MSA128BRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128BRegClassID,
      // (or:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (OR_V:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::OR_V,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 905,
      GIR_Done,
    // Label 252: @4062
    GIM_Reject,
    // Label 240: @4063
    GIM_Reject,
    // Label 9: @4064
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 9, /*)*//*default:*//*Label 259*/ 4903,
    /*GILLT_s32*//*Label 253*/ 4078,
    /*GILLT_s64*//*Label 254*/ 4687, 0,
    /*GILLT_v2s64*//*Label 255*/ 4775, 0,
    /*GILLT_v4s32*//*Label 256*/ 4807,
    /*GILLT_v8s16*//*Label 257*/ 4839,
    /*GILLT_v16s8*//*Label 258*/ 4871,
    // Label 253: @4078
    GIM_Try, /*On fail goto*//*Label 260*/ 4686,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 261*/ 4145, // Rule ID 54 //
        GIM_CheckFeatures, GIFBS_HasStdEnc_NotInMicroMips,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_OR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[i32] } (or:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt), -1:{ *:[i32] })  =>  (NOR:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::NOR,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 54,
        GIR_Done,
      // Label 261: @4145
      GIM_Try, /*On fail goto*//*Label 262*/ 4202, // Rule ID 1064 //
        GIM_CheckFeatures, GIFBS_InMicroMips_NotMips32r6,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_OR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[i32] } (or:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt), -1:{ *:[i32] })  =>  (NOR_MM:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::NOR_MM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1064,
        GIR_Done,
      // Label 262: @4202
      GIM_Try, /*On fail goto*//*Label 263*/ 4259, // Rule ID 1164 //
        GIM_CheckFeatures, GIFBS_HasMips32r6_InMicroMips,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_OR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[i32] } (or:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt), -1:{ *:[i32] })  =>  (NOR_MMR6:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::NOR_MMR6,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1164,
        GIR_Done,
      // Label 263: @4259
      GIM_Try, /*On fail goto*//*Label 264*/ 4291, // Rule ID 1191 //
        GIM_CheckFeatures, GIFBS_HasMips32r6_InMicroMips,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPRMM16RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::GPRMM16RegClassID,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, -1,
        // (xor:{ *:[i32] } GPRMM16Opnd:{ *:[i32] }:$rs, -1:{ *:[i32] })  =>  (NOT16_MMR6:{ *:[i32] } GPRMM16Opnd:{ *:[i32] }:$rs)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::NOT16_MMR6,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1191,
        GIR_Done,
      // Label 264: @4291
      GIM_Try, /*On fail goto*//*Label 265*/ 4323, // Rule ID 1046 //
        GIM_CheckFeatures, GIFBS_InMicroMips_NotMips32r6,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPRMM16RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::GPRMM16RegClassID,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, -1,
        // (xor:{ *:[i32] } GPRMM16Opnd:{ *:[i32] }:$rs, -1:{ *:[i32] })  =>  (NOT16_MM:{ *:[i32] } GPRMM16Opnd:{ *:[i32] }:$rs)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::NOT16_MM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1046,
        GIR_Done,
      // Label 265: @4323
      GIM_Try, /*On fail goto*//*Label 266*/ 4359, // Rule ID 1379 //
        GIM_CheckFeatures, GIFBS_HasStdEnc_NotInMicroMips,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, -1,
        // (xor:{ *:[i32] } GPR32:{ *:[i32] }:$in, -1:{ *:[i32] })  =>  (NOR:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$in, ZERO:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::NOR,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // in
        GIR_AddRegister, /*InsnID*/0, Mips::ZERO, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1379,
        GIR_Done,
      // Label 266: @4359
      GIM_Try, /*On fail goto*//*Label 267*/ 4391, // Rule ID 1775 //
        GIM_CheckFeatures, GIFBS_InMips16Mode,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::CPU16RegsRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::CPU16RegsRegClassID,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, -1,
        // (xor:{ *:[i32] } CPU16Regs:{ *:[i32] }:$r, -1:{ *:[i32] })  =>  (NotRxRy16:{ *:[i32] } CPU16Regs:{ *:[i32] }:$r)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::NotRxRy16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rx
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // r
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1775,
        GIR_Done,
      // Label 267: @4391
      GIM_Try, /*On fail goto*//*Label 268*/ 4423, // Rule ID 2115 //
        GIM_CheckFeatures, GIFBS_InMicroMips,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPRMM16RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::GPRMM16RegClassID,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, -1,
        // (xor:{ *:[i32] } GPRMM16:{ *:[i32] }:$in, -1:{ *:[i32] })  =>  (NOT16_MM:{ *:[i32] } GPRMM16:{ *:[i32] }:$in)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::NOT16_MM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // in
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2115,
        GIR_Done,
      // Label 268: @4423
      GIM_Try, /*On fail goto*//*Label 269*/ 4459, // Rule ID 2116 //
        GIM_CheckFeatures, GIFBS_InMicroMips,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, -1,
        // (xor:{ *:[i32] } GPR32:{ *:[i32] }:$in, -1:{ *:[i32] })  =>  (NOR_MM:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$in, ZERO:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::NOR_MM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // in
        GIR_AddRegister, /*InsnID*/0, Mips::ZERO, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2116,
        GIR_Done,
      // Label 269: @4459
      GIM_Try, /*On fail goto*//*Label 270*/ 4491, // Rule ID 2280 //
        GIM_CheckFeatures, GIFBS_HasMips32r6_InMicroMips,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPRMM16RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::GPRMM16RegClassID,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, -1,
        // (xor:{ *:[i32] } GPRMM16:{ *:[i32] }:$in, -1:{ *:[i32] })  =>  (NOT16_MMR6:{ *:[i32] } GPRMM16:{ *:[i32] }:$in)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::NOT16_MMR6,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // in
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2280,
        GIR_Done,
      // Label 270: @4491
      GIM_Try, /*On fail goto*//*Label 271*/ 4527, // Rule ID 2281 //
        GIM_CheckFeatures, GIFBS_HasMips32r6_InMicroMips,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, -1,
        // (xor:{ *:[i32] } GPR32:{ *:[i32] }:$in, -1:{ *:[i32] })  =>  (NOR_MMR6:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$in, ZERO:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::NOR_MMR6,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // in
        GIR_AddRegister, /*InsnID*/0, Mips::ZERO, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2281,
        GIR_Done,
      // Label 271: @4527
      GIM_Try, /*On fail goto*//*Label 272*/ 4570, // Rule ID 43 //
        GIM_CheckFeatures, GIFBS_HasStdEnc_NotInMicroMips,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckAPIntImmPredicate, /*MI*/1, /*Predicate*/GIPFP_APInt_Predicate_imm32ZExt16,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, (imm:{ *:[i32] })<<P:Predicate_imm32ZExt16>>:$imm16)  =>  (XORi:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, (imm:{ *:[i32] }):$imm16)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::XORi,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm16
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 43,
        GIR_Done,
      // Label 272: @4570
      GIM_Try, /*On fail goto*//*Label 273*/ 4593, // Rule ID 53 //
        GIM_CheckFeatures, GIFBS_HasStdEnc_NotInMicroMips,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR32RegClassID,
        // (xor:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (XOR:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::XOR,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 53,
        GIR_Done,
      // Label 273: @4593
      GIM_Try, /*On fail goto*//*Label 274*/ 4616, // Rule ID 1049 //
        GIM_CheckFeatures, GIFBS_InMicroMips_NotMips32r6,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPRMM16RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::GPRMM16RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPRMM16RegClassID,
        // (xor:{ *:[i32] } GPRMM16Opnd:{ *:[i32] }:$rs, GPRMM16Opnd:{ *:[i32] }:$rt)  =>  (XOR16_MM:{ *:[i32] } GPRMM16Opnd:{ *:[i32] }:$rs, GPRMM16Opnd:{ *:[i32] }:$rt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::XOR16_MM,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1049,
        GIR_Done,
      // Label 274: @4616
      GIM_Try, /*On fail goto*//*Label 275*/ 4639, // Rule ID 1063 //
        GIM_CheckFeatures, GIFBS_InMicroMips_NotMips32r6,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR32RegClassID,
        // (xor:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (XOR_MM:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::XOR_MM,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1063,
        GIR_Done,
      // Label 275: @4639
      GIM_Try, /*On fail goto*//*Label 276*/ 4662, // Rule ID 1168 //
        GIM_CheckFeatures, GIFBS_HasMips32r6_InMicroMips,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR32RegClassID,
        // (xor:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (XOR_MMR6:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::XOR_MMR6,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1168,
        GIR_Done,
      // Label 276: @4662
      GIM_Try, /*On fail goto*//*Label 277*/ 4685, // Rule ID 1782 //
        GIM_CheckFeatures, GIFBS_InMips16Mode,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::CPU16RegsRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::CPU16RegsRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::CPU16RegsRegClassID,
        // (xor:{ *:[i32] } CPU16Regs:{ *:[i32] }:$l, CPU16Regs:{ *:[i32] }:$r)  =>  (XorRxRxRy16:{ *:[i32] } CPU16Regs:{ *:[i32] }:$l, CPU16Regs:{ *:[i32] }:$r)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::XorRxRxRy16,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1782,
        GIR_Done,
      // Label 277: @4685
      GIM_Reject,
    // Label 260: @4686
    GIM_Reject,
    // Label 254: @4687
    GIM_Try, /*On fail goto*//*Label 278*/ 4774,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR64RegClassID,
      GIM_Try, /*On fail goto*//*Label 279*/ 4754, // Rule ID 203 //
        GIM_CheckFeatures, GIFBS_IsGP64bit_NotInMips16Mode,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_OR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/Mips::GPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/Mips::GPR64RegClassID,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[i64] } (or:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rs, GPR64Opnd:{ *:[i64] }:$rt), -1:{ *:[i64] })  =>  (NOR64:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rs, GPR64Opnd:{ *:[i64] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::NOR64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 203,
        GIR_Done,
      // Label 279: @4754
      GIM_Try, /*On fail goto*//*Label 280*/ 4773, // Rule ID 202 //
        GIM_CheckFeatures, GIFBS_IsGP64bit_NotInMips16Mode,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::GPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR64RegClassID,
        // (xor:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rs, GPR64Opnd:{ *:[i64] }:$rt)  =>  (XOR64:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rs, GPR64Opnd:{ *:[i64] }:$rt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::XOR64,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 202,
        GIR_Done,
      // Label 280: @4773
      GIM_Reject,
    // Label 278: @4774
    GIM_Reject,
    // Label 255: @4775
    GIM_Try, /*On fail goto*//*Label 281*/ 4806, // Rule ID 1024 //
      GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::MSA128DRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128DRegClassID,
      // (xor:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)  =>  (XOR_V_D_PSEUDO:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::XOR_V_D_PSEUDO,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1024,
      GIR_Done,
    // Label 281: @4806
    GIM_Reject,
    // Label 256: @4807
    GIM_Try, /*On fail goto*//*Label 282*/ 4838, // Rule ID 1023 //
      GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::MSA128WRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128WRegClassID,
      // (xor:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (XOR_V_W_PSEUDO:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::XOR_V_W_PSEUDO,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1023,
      GIR_Done,
    // Label 282: @4838
    GIM_Reject,
    // Label 257: @4839
    GIM_Try, /*On fail goto*//*Label 283*/ 4870, // Rule ID 1022 //
      GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128HRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::MSA128HRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128HRegClassID,
      // (xor:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (XOR_V_H_PSEUDO:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::XOR_V_H_PSEUDO,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1022,
      GIR_Done,
    // Label 283: @4870
    GIM_Reject,
    // Label 258: @4871
    GIM_Try, /*On fail goto*//*Label 284*/ 4902, // Rule ID 1021 //
      GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128BRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::MSA128BRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128BRegClassID,
      // (xor:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (XOR_V:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::XOR_V,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1021,
      GIR_Done,
    // Label 284: @4902
    GIM_Reject,
    // Label 259: @4903
    GIM_Reject,
    // Label 10: @4904
    GIM_Try, /*On fail goto*//*Label 285*/ 4980,
      GIM_CheckNumOperands, /*MI*/0, /*Expected*/3,
      GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
      GIM_Try, /*On fail goto*//*Label 286*/ 4950, // Rule ID 703 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasMips64_HasStdEnc,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::GPR64RegClassID,
        // MIs[0] rs
        GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/2, /*OtherMI*/0, /*OtherOpIdx*/1,
        // (build_vector:{ *:[v2i64] } GPR64Opnd:{ *:[i64] }:$rs, GPR64Opnd:{ *:[i64] }:$rs)  =>  (FILL_D:{ *:[v2i64] } GPR64Opnd:{ *:[i64] }:$rs)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::FILL_D,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 703,
        GIR_Done,
      // Label 286: @4950
      GIM_Try, /*On fail goto*//*Label 287*/ 4979, // Rule ID 705 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::FGR64RegClassID,
        // MIs[0] fs
        GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/2, /*OtherMI*/0, /*OtherOpIdx*/1,
        // (build_vector:{ *:[v2f64] } FGR64:{ *:[f64] }:$fs, FGR64:{ *:[f64] }:$fs)  =>  (FILL_FD_PSEUDO:{ *:[v2f64] } FGR64:{ *:[f64] }:$fs)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::FILL_FD_PSEUDO,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // fs
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 705,
        GIR_Done,
      // Label 287: @4979
      GIM_Reject,
    // Label 285: @4980
    GIM_Try, /*On fail goto*//*Label 288*/ 5076,
      GIM_CheckNumOperands, /*MI*/0, /*Expected*/5,
      GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
      GIM_Try, /*On fail goto*//*Label 289*/ 5036, // Rule ID 702 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::GPR32RegClassID,
        // MIs[0] rs
        GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/2, /*OtherMI*/0, /*OtherOpIdx*/1,
        // MIs[0] rs
        GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/3, /*OtherMI*/0, /*OtherOpIdx*/1,
        // MIs[0] rs
        GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/4, /*OtherMI*/0, /*OtherOpIdx*/1,
        // (build_vector:{ *:[v4i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rs)  =>  (FILL_W:{ *:[v4i32] } GPR32Opnd:{ *:[i32] }:$rs)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::FILL_W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 702,
        GIR_Done,
      // Label 289: @5036
      GIM_Try, /*On fail goto*//*Label 290*/ 5075, // Rule ID 704 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::FGR32RegClassID,
        // MIs[0] fs
        GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/2, /*OtherMI*/0, /*OtherOpIdx*/1,
        // MIs[0] fs
        GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/3, /*OtherMI*/0, /*OtherOpIdx*/1,
        // MIs[0] fs
        GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/4, /*OtherMI*/0, /*OtherOpIdx*/1,
        // (build_vector:{ *:[v4f32] } FGR32:{ *:[f32] }:$fs, FGR32:{ *:[f32] }:$fs, FGR32:{ *:[f32] }:$fs, FGR32:{ *:[f32] }:$fs)  =>  (FILL_FW_PSEUDO:{ *:[v4f32] } FGR32:{ *:[f32] }:$fs)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::FILL_FW_PSEUDO,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // fs
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 704,
        GIR_Done,
      // Label 290: @5075
      GIM_Reject,
    // Label 288: @5076
    GIM_Try, /*On fail goto*//*Label 291*/ 5150, // Rule ID 701 //
      GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
      GIM_CheckNumOperands, /*MI*/0, /*Expected*/9,
      GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128HRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::GPR32RegClassID,
      // MIs[0] rs
      GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/2, /*OtherMI*/0, /*OtherOpIdx*/1,
      // MIs[0] rs
      GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/3, /*OtherMI*/0, /*OtherOpIdx*/1,
      // MIs[0] rs
      GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/4, /*OtherMI*/0, /*OtherOpIdx*/1,
      // MIs[0] rs
      GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/5, /*OtherMI*/0, /*OtherOpIdx*/1,
      // MIs[0] rs
      GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/6, /*OtherMI*/0, /*OtherOpIdx*/1,
      // MIs[0] rs
      GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/7, /*OtherMI*/0, /*OtherOpIdx*/1,
      // MIs[0] rs
      GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/8, /*OtherMI*/0, /*OtherOpIdx*/1,
      // (build_vector:{ *:[v8i16] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rs)  =>  (FILL_H:{ *:[v8i16] } GPR32Opnd:{ *:[i32] }:$rs)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::FILL_H,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 701,
      GIR_Done,
    // Label 291: @5150
    GIM_Try, /*On fail goto*//*Label 292*/ 5264, // Rule ID 700 //
      GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
      GIM_CheckNumOperands, /*MI*/0, /*Expected*/17,
      GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128BRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::GPR32RegClassID,
      // MIs[0] rs
      GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/2, /*OtherMI*/0, /*OtherOpIdx*/1,
      // MIs[0] rs
      GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/3, /*OtherMI*/0, /*OtherOpIdx*/1,
      // MIs[0] rs
      GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/4, /*OtherMI*/0, /*OtherOpIdx*/1,
      // MIs[0] rs
      GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/5, /*OtherMI*/0, /*OtherOpIdx*/1,
      // MIs[0] rs
      GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/6, /*OtherMI*/0, /*OtherOpIdx*/1,
      // MIs[0] rs
      GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/7, /*OtherMI*/0, /*OtherOpIdx*/1,
      // MIs[0] rs
      GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/8, /*OtherMI*/0, /*OtherOpIdx*/1,
      // MIs[0] rs
      GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/9, /*OtherMI*/0, /*OtherOpIdx*/1,
      // MIs[0] rs
      GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/10, /*OtherMI*/0, /*OtherOpIdx*/1,
      // MIs[0] rs
      GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/11, /*OtherMI*/0, /*OtherOpIdx*/1,
      // MIs[0] rs
      GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/12, /*OtherMI*/0, /*OtherOpIdx*/1,
      // MIs[0] rs
      GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/13, /*OtherMI*/0, /*OtherOpIdx*/1,
      // MIs[0] rs
      GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/14, /*OtherMI*/0, /*OtherOpIdx*/1,
      // MIs[0] rs
      GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/15, /*OtherMI*/0, /*OtherOpIdx*/1,
      // MIs[0] rs
      GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/16, /*OtherMI*/0, /*OtherOpIdx*/1,
      // (build_vector:{ *:[v16i8] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rs)  =>  (FILL_B:{ *:[v16i8] } GPR32Opnd:{ *:[i32] }:$rs)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::FILL_B,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 700,
      GIR_Done,
    // Label 292: @5264
    GIM_Reject,
    // Label 11: @5265
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 9, /*)*//*default:*//*Label 301*/ 8917,
    /*GILLT_s32*//*Label 293*/ 5279,
    /*GILLT_s64*//*Label 294*/ 5518,
    /*GILLT_v2s16*//*Label 295*/ 5564,
    /*GILLT_v2s64*//*Label 296*/ 5610,
    /*GILLT_v4s8*//*Label 297*/ 6583,
    /*GILLT_v4s32*//*Label 298*/ 6629,
    /*GILLT_v8s16*//*Label 299*/ 7532,
    /*GILLT_v16s8*//*Label 300*/ 8330,
    // Label 293: @5279
    GIM_Try, /*On fail goto*//*Label 302*/ 5302, // Rule ID 129 //
      GIM_CheckFeatures, GIFBS_HasStdEnc_IsNotSoftFloat_NotInMicroMips,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::FGR32RegClassID,
      // (bitconvert:{ *:[i32] } FGR32Opnd:{ *:[f32] }:$fs)  =>  (MFC1:{ *:[i32] } FGR32Opnd:{ *:[f32] }:$fs)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::MFC1,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 129,
      GIR_Done,
    // Label 302: @5302
    GIM_Try, /*On fail goto*//*Label 303*/ 5325, // Rule ID 130 //
      GIM_CheckFeatures, GIFBS_HasStdEnc_IsNotSoftFloat_NotInMicroMips,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::FGR32RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::GPR32RegClassID,
      // (bitconvert:{ *:[f32] } GPR32Opnd:{ *:[i32] }:$rt)  =>  (MTC1:{ *:[f32] } GPR32Opnd:{ *:[i32] }:$rt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::MTC1,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 130,
      GIR_Done,
    // Label 303: @5325
    GIM_Try, /*On fail goto*//*Label 304*/ 5348, // Rule ID 1144 //
      GIM_CheckFeatures, GIFBS_InMicroMips_IsNotSoftFloat,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::FGR32RegClassID,
      // (bitconvert:{ *:[i32] } FGR32Opnd:{ *:[f32] }:$fs)  =>  (MFC1_MM:{ *:[i32] } FGR32Opnd:{ *:[f32] }:$fs)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::MFC1_MM,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1144,
      GIR_Done,
    // Label 304: @5348
    GIM_Try, /*On fail goto*//*Label 305*/ 5371, // Rule ID 1145 //
      GIM_CheckFeatures, GIFBS_InMicroMips_IsNotSoftFloat,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::FGR32RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::GPR32RegClassID,
      // (bitconvert:{ *:[f32] } GPR32Opnd:{ *:[i32] }:$rt)  =>  (MTC1_MM:{ *:[f32] } GPR32Opnd:{ *:[i32] }:$rt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::MTC1_MM,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1145,
      GIR_Done,
    // Label 305: @5371
    GIM_Try, /*On fail goto*//*Label 306*/ 5394, // Rule ID 1157 //
      GIM_CheckFeatures, GIFBS_HasMips32r6_InMicroMips_IsNotSoftFloat,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::FGR32RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::GPR32RegClassID,
      // (bitconvert:{ *:[f32] } GPR32Opnd:{ *:[i32] }:$rt)  =>  (MTC1_MMR6:{ *:[f32] } GPR32Opnd:{ *:[i32] }:$rt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::MTC1_MMR6,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1157,
      GIR_Done,
    // Label 306: @5394
    GIM_Try, /*On fail goto*//*Label 307*/ 5417, // Rule ID 1158 //
      GIM_CheckFeatures, GIFBS_HasMips32r6_InMicroMips_IsNotSoftFloat,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::FGR32RegClassID,
      // (bitconvert:{ *:[i32] } FGR32Opnd:{ *:[f32] }:$fs)  =>  (MFC1_MMR6:{ *:[i32] } FGR32Opnd:{ *:[f32] }:$fs)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::MFC1_MMR6,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1158,
      GIR_Done,
    // Label 307: @5417
    GIM_Try, /*On fail goto*//*Label 308*/ 5442, // Rule ID 1863 //
      GIM_CheckFeatures, GIFBS_HasDSP,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::DSPRRegClassID,
      // (bitconvert:{ *:[i32] } DSPR:{ *:[v2i16] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[i32] } DSPR:{ *:[v2i16] }:$src, GPR32:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC GPR32*/8,
      // GIR_Coverage, 1863,
      GIR_Done,
    // Label 308: @5442
    GIM_Try, /*On fail goto*//*Label 309*/ 5467, // Rule ID 1864 //
      GIM_CheckFeatures, GIFBS_HasDSP,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::DSPRRegClassID,
      // (bitconvert:{ *:[i32] } DSPR:{ *:[v4i8] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[i32] } DSPR:{ *:[v4i8] }:$src, GPR32:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC GPR32*/8,
      // GIR_Coverage, 1864,
      GIR_Done,
    // Label 309: @5467
    GIM_Try, /*On fail goto*//*Label 310*/ 5492, // Rule ID 1867 //
      GIM_CheckFeatures, GIFBS_HasDSP,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::FGR32RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::DSPRRegClassID,
      // (bitconvert:{ *:[f32] } DSPR:{ *:[v2i16] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[f32] } DSPR:{ *:[v2i16] }:$src, FGR32:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FGR32*/6,
      // GIR_Coverage, 1867,
      GIR_Done,
    // Label 310: @5492
    GIM_Try, /*On fail goto*//*Label 311*/ 5517, // Rule ID 1868 //
      GIM_CheckFeatures, GIFBS_HasDSP,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::FGR32RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::DSPRRegClassID,
      // (bitconvert:{ *:[f32] } DSPR:{ *:[v4i8] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[f32] } DSPR:{ *:[v4i8] }:$src, FGR32:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC FGR32*/6,
      // GIR_Coverage, 1868,
      GIR_Done,
    // Label 311: @5517
    GIM_Reject,
    // Label 294: @5518
    GIM_Try, /*On fail goto*//*Label 312*/ 5563,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_Try, /*On fail goto*//*Label 313*/ 5543, // Rule ID 131 //
        GIM_CheckFeatures, GIFBS_HasMips3_HasStdEnc_IsNotSoftFloat_NotInMicroMips,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::FGR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::GPR64RegClassID,
        // (bitconvert:{ *:[f64] } GPR64Opnd:{ *:[i64] }:$rt)  =>  (DMTC1:{ *:[f64] } GPR64Opnd:{ *:[i64] }:$rt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::DMTC1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 131,
        GIR_Done,
      // Label 313: @5543
      GIM_Try, /*On fail goto*//*Label 314*/ 5562, // Rule ID 132 //
        GIM_CheckFeatures, GIFBS_HasMips3_HasStdEnc_IsNotSoftFloat_NotInMicroMips,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::FGR64RegClassID,
        // (bitconvert:{ *:[i64] } FGR64Opnd:{ *:[f64] }:$fs)  =>  (DMFC1:{ *:[i64] } FGR64Opnd:{ *:[f64] }:$fs)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::DMFC1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 132,
        GIR_Done,
      // Label 314: @5562
      GIM_Reject,
    // Label 312: @5563
    GIM_Reject,
    // Label 295: @5564
    GIM_Try, /*On fail goto*//*Label 315*/ 5609,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
      GIM_Try, /*On fail goto*//*Label 316*/ 5591, // Rule ID 1865 //
        GIM_CheckFeatures, GIFBS_HasDSP,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::GPR32RegClassID,
        // (bitconvert:{ *:[v2i16] } GPR32:{ *:[i32] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v2i16] } GPR32:{ *:[i32] }:$src, DSPR:{ *:[i32] })
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/TargetOpcode::COPY,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC DSPR*/5,
        // GIR_Coverage, 1865,
        GIR_Done,
      // Label 316: @5591
      GIM_Try, /*On fail goto*//*Label 317*/ 5608, // Rule ID 1869 //
        GIM_CheckFeatures, GIFBS_HasDSP,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::FGR32RegClassID,
        // (bitconvert:{ *:[v2i16] } FGR32:{ *:[f32] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v2i16] } FGR32:{ *:[f32] }:$src, DSPR:{ *:[i32] })
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/TargetOpcode::COPY,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC DSPR*/5,
        // GIR_Coverage, 1869,
        GIR_Done,
      // Label 317: @5608
      GIM_Reject,
    // Label 315: @5609
    GIM_Reject,
    // Label 296: @5610
    GIM_Try, /*On fail goto*//*Label 318*/ 5631, // Rule ID 1950 //
      GIM_CheckFeatures, GIFBS_HasMSA,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
      // (bitconvert:{ *:[v2i64] } v2f64:{ *:[v2f64] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v2i64] } v2f64:{ *:[v2f64] }:$src, MSA128D:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC MSA128D*/65,
      // GIR_Coverage, 1950,
      GIR_Done,
    // Label 318: @5631
    GIM_Try, /*On fail goto*//*Label 319*/ 5652, // Rule ID 1953 //
      GIM_CheckFeatures, GIFBS_HasMSA,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
      // (bitconvert:{ *:[v2f64] } v2i64:{ *:[v2i64] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v2f64] } v2i64:{ *:[v2i64] }:$src, MSA128D:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC MSA128D*/65,
      // GIR_Coverage, 1953,
      GIR_Done,
    // Label 319: @5652
    GIM_Try, /*On fail goto*//*Label 320*/ 5673, // Rule ID 1970 //
      GIM_CheckFeatures, GIFBS_HasMSA_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
      // (bitconvert:{ *:[v2i64] } v16i8:{ *:[v16i8] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v2i64] } v16i8:{ *:[v16i8] }:$src, MSA128D:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC MSA128D*/65,
      // GIR_Coverage, 1970,
      GIR_Done,
    // Label 320: @5673
    GIM_Try, /*On fail goto*//*Label 321*/ 5694, // Rule ID 1971 //
      GIM_CheckFeatures, GIFBS_HasMSA_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
      // (bitconvert:{ *:[v2i64] } v8i16:{ *:[v8i16] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v2i64] } v8i16:{ *:[v8i16] }:$src, MSA128D:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC MSA128D*/65,
      // GIR_Coverage, 1971,
      GIR_Done,
    // Label 321: @5694
    GIM_Try, /*On fail goto*//*Label 322*/ 5715, // Rule ID 1972 //
      GIM_CheckFeatures, GIFBS_HasMSA_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
      // (bitconvert:{ *:[v2i64] } v4i32:{ *:[v4i32] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v2i64] } v4i32:{ *:[v4i32] }:$src, MSA128D:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC MSA128D*/65,
      // GIR_Coverage, 1972,
      GIR_Done,
    // Label 322: @5715
    GIM_Try, /*On fail goto*//*Label 323*/ 5736, // Rule ID 1973 //
      GIM_CheckFeatures, GIFBS_HasMSA_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
      // (bitconvert:{ *:[v2i64] } v8f16:{ *:[v8f16] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v2i64] } v8f16:{ *:[v8f16] }:$src, MSA128D:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC MSA128D*/65,
      // GIR_Coverage, 1973,
      GIR_Done,
    // Label 323: @5736
    GIM_Try, /*On fail goto*//*Label 324*/ 5757, // Rule ID 1974 //
      GIM_CheckFeatures, GIFBS_HasMSA_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
      // (bitconvert:{ *:[v2i64] } v4f32:{ *:[v4f32] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v2i64] } v4f32:{ *:[v4f32] }:$src, MSA128D:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC MSA128D*/65,
      // GIR_Coverage, 1974,
      GIR_Done,
    // Label 324: @5757
    GIM_Try, /*On fail goto*//*Label 325*/ 5778, // Rule ID 1980 //
      GIM_CheckFeatures, GIFBS_HasMSA_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
      // (bitconvert:{ *:[v2f64] } v16i8:{ *:[v16i8] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v2f64] } v16i8:{ *:[v16i8] }:$src, MSA128D:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC MSA128D*/65,
      // GIR_Coverage, 1980,
      GIR_Done,
    // Label 325: @5778
    GIM_Try, /*On fail goto*//*Label 326*/ 5799, // Rule ID 1981 //
      GIM_CheckFeatures, GIFBS_HasMSA_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
      // (bitconvert:{ *:[v2f64] } v8i16:{ *:[v8i16] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v2f64] } v8i16:{ *:[v8i16] }:$src, MSA128D:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC MSA128D*/65,
      // GIR_Coverage, 1981,
      GIR_Done,
    // Label 326: @5799
    GIM_Try, /*On fail goto*//*Label 327*/ 5820, // Rule ID 1982 //
      GIM_CheckFeatures, GIFBS_HasMSA_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
      // (bitconvert:{ *:[v2f64] } v4i32:{ *:[v4i32] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v2f64] } v4i32:{ *:[v4i32] }:$src, MSA128D:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC MSA128D*/65,
      // GIR_Coverage, 1982,
      GIR_Done,
    // Label 327: @5820
    GIM_Try, /*On fail goto*//*Label 328*/ 5841, // Rule ID 1983 //
      GIM_CheckFeatures, GIFBS_HasMSA_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
      // (bitconvert:{ *:[v2f64] } v8f16:{ *:[v8f16] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v2f64] } v8f16:{ *:[v8f16] }:$src, MSA128D:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC MSA128D*/65,
      // GIR_Coverage, 1983,
      GIR_Done,
    // Label 328: @5841
    GIM_Try, /*On fail goto*//*Label 329*/ 5862, // Rule ID 1984 //
      GIM_CheckFeatures, GIFBS_HasMSA_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
      // (bitconvert:{ *:[v2f64] } v4f32:{ *:[v4f32] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v2f64] } v4f32:{ *:[v4f32] }:$src, MSA128D:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC MSA128D*/65,
      // GIR_Coverage, 1984,
      GIR_Done,
    // Label 329: @5862
    GIM_Try, /*On fail goto*//*Label 330*/ 5962, // Rule ID 1989 //
      GIM_CheckFeatures, GIFBS_HasMSA_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
      // (bitconvert:{ *:[v2i64] } v16i8:{ *:[v16i8] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v2i64] } (SHF_W:{ *:[v4i32] } (COPY_TO_REGCLASS:{ *:[v4i32] } (SHF_B:{ *:[v16i8] } (COPY_TO_REGCLASS:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$src, MSA128B:{ *:[i32] }), 27:{ *:[i32] }), MSA128W:{ *:[i32] }), 177:{ *:[i32] }), MSA128D:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
      GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v16s8,
      GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_v16s8,
      GIR_BuildMI, /*InsnID*/4, /*Opcode*/TargetOpcode::COPY,
      GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/RegState::Define,
      GIR_Copy, /*NewInsnID*/4, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/4,
      GIR_BuildMI, /*InsnID*/3, /*Opcode*/Mips::SHF_B,
      GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
      GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/3, /*TempRegFlags*/0,
      GIR_AddImm, /*InsnID*/3, /*Imm*/27,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/2, /*TempRegFlags*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/Mips::SHF_W,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
      GIR_AddImm, /*InsnID*/1, /*Imm*/177,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC MSA128D*/65,
      // GIR_Coverage, 1989,
      GIR_Done,
    // Label 330: @5962
    GIM_Try, /*On fail goto*//*Label 331*/ 6062, // Rule ID 1990 //
      GIM_CheckFeatures, GIFBS_HasMSA_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
      // (bitconvert:{ *:[v2f64] } v16i8:{ *:[v16i8] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v2f64] } (SHF_W:{ *:[v4i32] } (COPY_TO_REGCLASS:{ *:[v4i32] } (SHF_B:{ *:[v16i8] } (COPY_TO_REGCLASS:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$src, MSA128B:{ *:[i32] }), 27:{ *:[i32] }), MSA128W:{ *:[i32] }), 177:{ *:[i32] }), MSA128D:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
      GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v16s8,
      GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_v16s8,
      GIR_BuildMI, /*InsnID*/4, /*Opcode*/TargetOpcode::COPY,
      GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/RegState::Define,
      GIR_Copy, /*NewInsnID*/4, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/4,
      GIR_BuildMI, /*InsnID*/3, /*Opcode*/Mips::SHF_B,
      GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
      GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/3, /*TempRegFlags*/0,
      GIR_AddImm, /*InsnID*/3, /*Imm*/27,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/2, /*TempRegFlags*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/Mips::SHF_W,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
      GIR_AddImm, /*InsnID*/1, /*Imm*/177,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC MSA128D*/65,
      // GIR_Coverage, 1990,
      GIR_Done,
    // Label 331: @6062
    GIM_Try, /*On fail goto*//*Label 332*/ 6127, // Rule ID 1994 //
      GIM_CheckFeatures, GIFBS_HasMSA_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
      // (bitconvert:{ *:[v2i64] } v8i16:{ *:[v8i16] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v2i64] } (SHF_H:{ *:[v8i16] } (COPY_TO_REGCLASS:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$src, MSA128H:{ *:[i32] }), 27:{ *:[i32] }), MSA128D:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v8s16,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v8s16,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/Mips::SHF_H,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
      GIR_AddImm, /*InsnID*/1, /*Imm*/27,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC MSA128D*/65,
      // GIR_Coverage, 1994,
      GIR_Done,
    // Label 332: @6127
    GIM_Try, /*On fail goto*//*Label 333*/ 6192, // Rule ID 1995 //
      GIM_CheckFeatures, GIFBS_HasMSA_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
      // (bitconvert:{ *:[v2f64] } v8i16:{ *:[v8i16] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v2f64] } (SHF_H:{ *:[v8i16] } (COPY_TO_REGCLASS:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$src, MSA128H:{ *:[i32] }), 27:{ *:[i32] }), MSA128D:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v8s16,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v8s16,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/Mips::SHF_H,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
      GIR_AddImm, /*InsnID*/1, /*Imm*/27,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC MSA128D*/65,
      // GIR_Coverage, 1995,
      GIR_Done,
    // Label 333: @6192
    GIM_Try, /*On fail goto*//*Label 334*/ 6257, // Rule ID 1999 //
      GIM_CheckFeatures, GIFBS_HasMSA_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
      // (bitconvert:{ *:[v2i64] } v8f16:{ *:[v8f16] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v2i64] } (SHF_H:{ *:[v8i16] } (COPY_TO_REGCLASS:{ *:[v8i16] } v8f16:{ *:[v8f16] }:$src, MSA128H:{ *:[i32] }), 27:{ *:[i32] }), MSA128D:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v8s16,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v8s16,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/Mips::SHF_H,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
      GIR_AddImm, /*InsnID*/1, /*Imm*/27,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC MSA128D*/65,
      // GIR_Coverage, 1999,
      GIR_Done,
    // Label 334: @6257
    GIM_Try, /*On fail goto*//*Label 335*/ 6322, // Rule ID 2000 //
      GIM_CheckFeatures, GIFBS_HasMSA_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
      // (bitconvert:{ *:[v2f64] } v8f16:{ *:[v8f16] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v2f64] } (SHF_H:{ *:[v8i16] } (COPY_TO_REGCLASS:{ *:[v8i16] } v8f16:{ *:[v8f16] }:$src, MSA128H:{ *:[i32] }), 27:{ *:[i32] }), MSA128D:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v8s16,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v8s16,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/Mips::SHF_H,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
      GIR_AddImm, /*InsnID*/1, /*Imm*/27,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC MSA128D*/65,
      // GIR_Coverage, 2000,
      GIR_Done,
    // Label 335: @6322
    GIM_Try, /*On fail goto*//*Label 336*/ 6387, // Rule ID 2004 //
      GIM_CheckFeatures, GIFBS_HasMSA_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
      // (bitconvert:{ *:[v2i64] } v4i32:{ *:[v4i32] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v2i64] } (SHF_W:{ *:[v4i32] } (COPY_TO_REGCLASS:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$src, MSA128W:{ *:[i32] }), 177:{ *:[i32] }), MSA128D:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/Mips::SHF_W,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
      GIR_AddImm, /*InsnID*/1, /*Imm*/177,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC MSA128D*/65,
      // GIR_Coverage, 2004,
      GIR_Done,
    // Label 336: @6387
    GIM_Try, /*On fail goto*//*Label 337*/ 6452, // Rule ID 2005 //
      GIM_CheckFeatures, GIFBS_HasMSA_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
      // (bitconvert:{ *:[v2f64] } v4i32:{ *:[v4i32] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v2f64] } (SHF_W:{ *:[v4i32] } (COPY_TO_REGCLASS:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$src, MSA128W:{ *:[i32] }), 177:{ *:[i32] }), MSA128D:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/Mips::SHF_W,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
      GIR_AddImm, /*InsnID*/1, /*Imm*/177,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC MSA128D*/65,
      // GIR_Coverage, 2005,
      GIR_Done,
    // Label 337: @6452
    GIM_Try, /*On fail goto*//*Label 338*/ 6517, // Rule ID 2009 //
      GIM_CheckFeatures, GIFBS_HasMSA_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
      // (bitconvert:{ *:[v2i64] } v4f32:{ *:[v4f32] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v2i64] } (SHF_W:{ *:[v4i32] } (COPY_TO_REGCLASS:{ *:[v4i32] } v4f32:{ *:[v4f32] }:$src, MSA128W:{ *:[i32] }), 177:{ *:[i32] }), MSA128D:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/Mips::SHF_W,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
      GIR_AddImm, /*InsnID*/1, /*Imm*/177,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC MSA128D*/65,
      // GIR_Coverage, 2009,
      GIR_Done,
    // Label 338: @6517
    GIM_Try, /*On fail goto*//*Label 339*/ 6582, // Rule ID 2010 //
      GIM_CheckFeatures, GIFBS_HasMSA_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
      // (bitconvert:{ *:[v2f64] } v4f32:{ *:[v4f32] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v2f64] } (SHF_W:{ *:[v4i32] } (COPY_TO_REGCLASS:{ *:[v4i32] } v4f32:{ *:[v4f32] }:$src, MSA128W:{ *:[i32] }), 177:{ *:[i32] }), MSA128D:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/Mips::SHF_W,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
      GIR_AddImm, /*InsnID*/1, /*Imm*/177,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC MSA128D*/65,
      // GIR_Coverage, 2010,
      GIR_Done,
    // Label 339: @6582
    GIM_Reject,
    // Label 297: @6583
    GIM_Try, /*On fail goto*//*Label 340*/ 6628,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
      GIM_Try, /*On fail goto*//*Label 341*/ 6610, // Rule ID 1866 //
        GIM_CheckFeatures, GIFBS_HasDSP,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::GPR32RegClassID,
        // (bitconvert:{ *:[v4i8] } GPR32:{ *:[i32] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v4i8] } GPR32:{ *:[i32] }:$src, DSPR:{ *:[i32] })
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/TargetOpcode::COPY,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC DSPR*/5,
        // GIR_Coverage, 1866,
        GIR_Done,
      // Label 341: @6610
      GIM_Try, /*On fail goto*//*Label 342*/ 6627, // Rule ID 1870 //
        GIM_CheckFeatures, GIFBS_HasDSP,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::FGR32RegClassID,
        // (bitconvert:{ *:[v4i8] } FGR32:{ *:[f32] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v4i8] } FGR32:{ *:[f32] }:$src, DSPR:{ *:[i32] })
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/TargetOpcode::COPY,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC DSPR*/5,
        // GIR_Coverage, 1870,
        GIR_Done,
      // Label 342: @6627
      GIM_Reject,
    // Label 340: @6628
    GIM_Reject,
    // Label 298: @6629
    GIM_Try, /*On fail goto*//*Label 343*/ 6650, // Rule ID 1949 //
      GIM_CheckFeatures, GIFBS_HasMSA,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
      // (bitconvert:{ *:[v4i32] } v4f32:{ *:[v4f32] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v4i32] } v4f32:{ *:[v4f32] }:$src, MSA128W:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC MSA128W*/67,
      // GIR_Coverage, 1949,
      GIR_Done,
    // Label 343: @6650
    GIM_Try, /*On fail goto*//*Label 344*/ 6671, // Rule ID 1952 //
      GIM_CheckFeatures, GIFBS_HasMSA,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
      // (bitconvert:{ *:[v4f32] } v4i32:{ *:[v4i32] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v4f32] } v4i32:{ *:[v4i32] }:$src, MSA128W:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC MSA128W*/67,
      // GIR_Coverage, 1952,
      GIR_Done,
    // Label 344: @6671
    GIM_Try, /*On fail goto*//*Label 345*/ 6692, // Rule ID 1965 //
      GIM_CheckFeatures, GIFBS_HasMSA_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
      // (bitconvert:{ *:[v4i32] } v16i8:{ *:[v16i8] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v4i32] } v16i8:{ *:[v16i8] }:$src, MSA128W:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC MSA128W*/67,
      // GIR_Coverage, 1965,
      GIR_Done,
    // Label 345: @6692
    GIM_Try, /*On fail goto*//*Label 346*/ 6713, // Rule ID 1966 //
      GIM_CheckFeatures, GIFBS_HasMSA_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
      // (bitconvert:{ *:[v4i32] } v8i16:{ *:[v8i16] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v4i32] } v8i16:{ *:[v8i16] }:$src, MSA128W:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC MSA128W*/67,
      // GIR_Coverage, 1966,
      GIR_Done,
    // Label 346: @6713
    GIM_Try, /*On fail goto*//*Label 347*/ 6734, // Rule ID 1967 //
      GIM_CheckFeatures, GIFBS_HasMSA_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
      // (bitconvert:{ *:[v4i32] } v2i64:{ *:[v2i64] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v4i32] } v2i64:{ *:[v2i64] }:$src, MSA128W:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC MSA128W*/67,
      // GIR_Coverage, 1967,
      GIR_Done,
    // Label 347: @6734
    GIM_Try, /*On fail goto*//*Label 348*/ 6755, // Rule ID 1968 //
      GIM_CheckFeatures, GIFBS_HasMSA_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
      // (bitconvert:{ *:[v4i32] } v8f16:{ *:[v8f16] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v4i32] } v8f16:{ *:[v8f16] }:$src, MSA128W:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC MSA128W*/67,
      // GIR_Coverage, 1968,
      GIR_Done,
    // Label 348: @6755
    GIM_Try, /*On fail goto*//*Label 349*/ 6776, // Rule ID 1969 //
      GIM_CheckFeatures, GIFBS_HasMSA_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
      // (bitconvert:{ *:[v4i32] } v2f64:{ *:[v2f64] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v4i32] } v2f64:{ *:[v2f64] }:$src, MSA128W:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC MSA128W*/67,
      // GIR_Coverage, 1969,
      GIR_Done,
    // Label 349: @6776
    GIM_Try, /*On fail goto*//*Label 350*/ 6797, // Rule ID 1975 //
      GIM_CheckFeatures, GIFBS_HasMSA_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
      // (bitconvert:{ *:[v4f32] } v16i8:{ *:[v16i8] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v4f32] } v16i8:{ *:[v16i8] }:$src, MSA128W:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC MSA128W*/67,
      // GIR_Coverage, 1975,
      GIR_Done,
    // Label 350: @6797
    GIM_Try, /*On fail goto*//*Label 351*/ 6818, // Rule ID 1976 //
      GIM_CheckFeatures, GIFBS_HasMSA_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
      // (bitconvert:{ *:[v4f32] } v8i16:{ *:[v8i16] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v4f32] } v8i16:{ *:[v8i16] }:$src, MSA128W:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC MSA128W*/67,
      // GIR_Coverage, 1976,
      GIR_Done,
    // Label 351: @6818
    GIM_Try, /*On fail goto*//*Label 352*/ 6839, // Rule ID 1977 //
      GIM_CheckFeatures, GIFBS_HasMSA_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
      // (bitconvert:{ *:[v4f32] } v2i64:{ *:[v2i64] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v4f32] } v2i64:{ *:[v2i64] }:$src, MSA128W:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC MSA128W*/67,
      // GIR_Coverage, 1977,
      GIR_Done,
    // Label 352: @6839
    GIM_Try, /*On fail goto*//*Label 353*/ 6860, // Rule ID 1978 //
      GIM_CheckFeatures, GIFBS_HasMSA_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
      // (bitconvert:{ *:[v4f32] } v8f16:{ *:[v8f16] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v4f32] } v8f16:{ *:[v8f16] }:$src, MSA128W:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC MSA128W*/67,
      // GIR_Coverage, 1978,
      GIR_Done,
    // Label 353: @6860
    GIM_Try, /*On fail goto*//*Label 354*/ 6881, // Rule ID 1979 //
      GIM_CheckFeatures, GIFBS_HasMSA_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
      // (bitconvert:{ *:[v4f32] } v2f64:{ *:[v2f64] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v4f32] } v2f64:{ *:[v2f64] }:$src, MSA128W:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC MSA128W*/67,
      // GIR_Coverage, 1979,
      GIR_Done,
    // Label 354: @6881
    GIM_Try, /*On fail goto*//*Label 355*/ 6946, // Rule ID 1987 //
      GIM_CheckFeatures, GIFBS_HasMSA_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
      // (bitconvert:{ *:[v4i32] } v16i8:{ *:[v16i8] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v4i32] } (SHF_B:{ *:[v16i8] } (COPY_TO_REGCLASS:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$src, MSA128B:{ *:[i32] }), 27:{ *:[i32] }), MSA128W:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v16s8,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v16s8,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/Mips::SHF_B,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
      GIR_AddImm, /*InsnID*/1, /*Imm*/27,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC MSA128W*/67,
      // GIR_Coverage, 1987,
      GIR_Done,
    // Label 355: @6946
    GIM_Try, /*On fail goto*//*Label 356*/ 7011, // Rule ID 1988 //
      GIM_CheckFeatures, GIFBS_HasMSA_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
      // (bitconvert:{ *:[v4f32] } v16i8:{ *:[v16i8] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v4f32] } (SHF_B:{ *:[v16i8] } (COPY_TO_REGCLASS:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$src, MSA128B:{ *:[i32] }), 27:{ *:[i32] }), MSA128W:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v16s8,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v16s8,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/Mips::SHF_B,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
      GIR_AddImm, /*InsnID*/1, /*Imm*/27,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC MSA128W*/67,
      // GIR_Coverage, 1988,
      GIR_Done,
    // Label 356: @7011
    GIM_Try, /*On fail goto*//*Label 357*/ 7076, // Rule ID 1992 //
      GIM_CheckFeatures, GIFBS_HasMSA_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
      // (bitconvert:{ *:[v4i32] } v8i16:{ *:[v8i16] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v4i32] } (SHF_H:{ *:[v8i16] } (COPY_TO_REGCLASS:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$src, MSA128H:{ *:[i32] }), 177:{ *:[i32] }), MSA128W:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v8s16,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v8s16,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/Mips::SHF_H,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
      GIR_AddImm, /*InsnID*/1, /*Imm*/177,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC MSA128W*/67,
      // GIR_Coverage, 1992,
      GIR_Done,
    // Label 357: @7076
    GIM_Try, /*On fail goto*//*Label 358*/ 7141, // Rule ID 1993 //
      GIM_CheckFeatures, GIFBS_HasMSA_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
      // (bitconvert:{ *:[v4f32] } v8i16:{ *:[v8i16] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v4f32] } (SHF_H:{ *:[v8i16] } (COPY_TO_REGCLASS:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$src, MSA128H:{ *:[i32] }), 177:{ *:[i32] }), MSA128W:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v8s16,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v8s16,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/Mips::SHF_H,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
      GIR_AddImm, /*InsnID*/1, /*Imm*/177,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC MSA128W*/67,
      // GIR_Coverage, 1993,
      GIR_Done,
    // Label 358: @7141
    GIM_Try, /*On fail goto*//*Label 359*/ 7206, // Rule ID 1997 //
      GIM_CheckFeatures, GIFBS_HasMSA_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
      // (bitconvert:{ *:[v4i32] } v8f16:{ *:[v8f16] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v4i32] } (SHF_H:{ *:[v8i16] } (COPY_TO_REGCLASS:{ *:[v8i16] } v8f16:{ *:[v8f16] }:$src, MSA128H:{ *:[i32] }), 177:{ *:[i32] }), MSA128W:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v8s16,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v8s16,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/Mips::SHF_H,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
      GIR_AddImm, /*InsnID*/1, /*Imm*/177,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC MSA128W*/67,
      // GIR_Coverage, 1997,
      GIR_Done,
    // Label 359: @7206
    GIM_Try, /*On fail goto*//*Label 360*/ 7271, // Rule ID 1998 //
      GIM_CheckFeatures, GIFBS_HasMSA_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
      // (bitconvert:{ *:[v4f32] } v8f16:{ *:[v8f16] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v4f32] } (SHF_H:{ *:[v8i16] } (COPY_TO_REGCLASS:{ *:[v8i16] } v8f16:{ *:[v8f16] }:$src, MSA128H:{ *:[i32] }), 177:{ *:[i32] }), MSA128W:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v8s16,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v8s16,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/Mips::SHF_H,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
      GIR_AddImm, /*InsnID*/1, /*Imm*/177,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC MSA128W*/67,
      // GIR_Coverage, 1998,
      GIR_Done,
    // Label 360: @7271
    GIM_Try, /*On fail goto*//*Label 361*/ 7336, // Rule ID 2014 //
      GIM_CheckFeatures, GIFBS_HasMSA_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
      // (bitconvert:{ *:[v4i32] } v2i64:{ *:[v2i64] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v4i32] } (SHF_W:{ *:[v4i32] } (COPY_TO_REGCLASS:{ *:[v4i32] } v2i64:{ *:[v2i64] }:$src, MSA128W:{ *:[i32] }), 177:{ *:[i32] }), MSA128W:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/Mips::SHF_W,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
      GIR_AddImm, /*InsnID*/1, /*Imm*/177,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC MSA128W*/67,
      // GIR_Coverage, 2014,
      GIR_Done,
    // Label 361: @7336
    GIM_Try, /*On fail goto*//*Label 362*/ 7401, // Rule ID 2015 //
      GIM_CheckFeatures, GIFBS_HasMSA_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
      // (bitconvert:{ *:[v4f32] } v2i64:{ *:[v2i64] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v4f32] } (SHF_W:{ *:[v4i32] } (COPY_TO_REGCLASS:{ *:[v4i32] } v2i64:{ *:[v2i64] }:$src, MSA128W:{ *:[i32] }), 177:{ *:[i32] }), MSA128W:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/Mips::SHF_W,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
      GIR_AddImm, /*InsnID*/1, /*Imm*/177,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC MSA128W*/67,
      // GIR_Coverage, 2015,
      GIR_Done,
    // Label 362: @7401
    GIM_Try, /*On fail goto*//*Label 363*/ 7466, // Rule ID 2019 //
      GIM_CheckFeatures, GIFBS_HasMSA_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
      // (bitconvert:{ *:[v4i32] } v2f64:{ *:[v2f64] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v4i32] } (SHF_W:{ *:[v4i32] } (COPY_TO_REGCLASS:{ *:[v4i32] } v2f64:{ *:[v2f64] }:$src, MSA128W:{ *:[i32] }), 177:{ *:[i32] }), MSA128W:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/Mips::SHF_W,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
      GIR_AddImm, /*InsnID*/1, /*Imm*/177,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC MSA128W*/67,
      // GIR_Coverage, 2019,
      GIR_Done,
    // Label 363: @7466
    GIM_Try, /*On fail goto*//*Label 364*/ 7531, // Rule ID 2020 //
      GIM_CheckFeatures, GIFBS_HasMSA_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
      // (bitconvert:{ *:[v4f32] } v2f64:{ *:[v2f64] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v4f32] } (SHF_W:{ *:[v4i32] } (COPY_TO_REGCLASS:{ *:[v4i32] } v2f64:{ *:[v2f64] }:$src, MSA128W:{ *:[i32] }), 177:{ *:[i32] }), MSA128W:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/Mips::SHF_W,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
      GIR_AddImm, /*InsnID*/1, /*Imm*/177,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC MSA128W*/67,
      // GIR_Coverage, 2020,
      GIR_Done,
    // Label 364: @7531
    GIM_Reject,
    // Label 299: @7532
    GIM_Try, /*On fail goto*//*Label 365*/ 7553, // Rule ID 1948 //
      GIM_CheckFeatures, GIFBS_HasMSA,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128HRegClassID,
      // (bitconvert:{ *:[v8i16] } v8f16:{ *:[v8f16] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v8i16] } v8f16:{ *:[v8f16] }:$src, MSA128H:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC MSA128H*/66,
      // GIR_Coverage, 1948,
      GIR_Done,
    // Label 365: @7553
    GIM_Try, /*On fail goto*//*Label 366*/ 7574, // Rule ID 1951 //
      GIM_CheckFeatures, GIFBS_HasMSA,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128HRegClassID,
      // (bitconvert:{ *:[v8f16] } v8i16:{ *:[v8i16] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v8f16] } v8i16:{ *:[v8i16] }:$src, MSA128H:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC MSA128H*/66,
      // GIR_Coverage, 1951,
      GIR_Done,
    // Label 366: @7574
    GIM_Try, /*On fail goto*//*Label 367*/ 7595, // Rule ID 1960 //
      GIM_CheckFeatures, GIFBS_HasMSA_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128HRegClassID,
      // (bitconvert:{ *:[v8i16] } v16i8:{ *:[v16i8] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v8i16] } v16i8:{ *:[v16i8] }:$src, MSA128H:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC MSA128H*/66,
      // GIR_Coverage, 1960,
      GIR_Done,
    // Label 367: @7595
    GIM_Try, /*On fail goto*//*Label 368*/ 7616, // Rule ID 1961 //
      GIM_CheckFeatures, GIFBS_HasMSA_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128HRegClassID,
      // (bitconvert:{ *:[v8i16] } v4i32:{ *:[v4i32] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v8i16] } v4i32:{ *:[v4i32] }:$src, MSA128H:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC MSA128H*/66,
      // GIR_Coverage, 1961,
      GIR_Done,
    // Label 368: @7616
    GIM_Try, /*On fail goto*//*Label 369*/ 7637, // Rule ID 1962 //
      GIM_CheckFeatures, GIFBS_HasMSA_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128HRegClassID,
      // (bitconvert:{ *:[v8i16] } v2i64:{ *:[v2i64] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v8i16] } v2i64:{ *:[v2i64] }:$src, MSA128H:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC MSA128H*/66,
      // GIR_Coverage, 1962,
      GIR_Done,
    // Label 369: @7637
    GIM_Try, /*On fail goto*//*Label 370*/ 7658, // Rule ID 1963 //
      GIM_CheckFeatures, GIFBS_HasMSA_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128HRegClassID,
      // (bitconvert:{ *:[v8i16] } v4f32:{ *:[v4f32] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v8i16] } v4f32:{ *:[v4f32] }:$src, MSA128H:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC MSA128H*/66,
      // GIR_Coverage, 1963,
      GIR_Done,
    // Label 370: @7658
    GIM_Try, /*On fail goto*//*Label 371*/ 7679, // Rule ID 1964 //
      GIM_CheckFeatures, GIFBS_HasMSA_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128HRegClassID,
      // (bitconvert:{ *:[v8i16] } v2f64:{ *:[v2f64] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v8i16] } v2f64:{ *:[v2f64] }:$src, MSA128H:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC MSA128H*/66,
      // GIR_Coverage, 1964,
      GIR_Done,
    // Label 371: @7679
    GIM_Try, /*On fail goto*//*Label 372*/ 7744, // Rule ID 1985 //
      GIM_CheckFeatures, GIFBS_HasMSA_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128HRegClassID,
      // (bitconvert:{ *:[v8i16] } v16i8:{ *:[v16i8] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v8i16] } (SHF_B:{ *:[v16i8] } (COPY_TO_REGCLASS:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$src, MSA128B:{ *:[i32] }), 177:{ *:[i32] }), MSA128H:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v16s8,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v16s8,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/Mips::SHF_B,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
      GIR_AddImm, /*InsnID*/1, /*Imm*/177,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC MSA128H*/66,
      // GIR_Coverage, 1985,
      GIR_Done,
    // Label 372: @7744
    GIM_Try, /*On fail goto*//*Label 373*/ 7809, // Rule ID 1986 //
      GIM_CheckFeatures, GIFBS_HasMSA_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128HRegClassID,
      // (bitconvert:{ *:[v8f16] } v16i8:{ *:[v16i8] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v8f16] } (SHF_B:{ *:[v16i8] } (COPY_TO_REGCLASS:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$src, MSA128B:{ *:[i32] }), 177:{ *:[i32] }), MSA128H:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v16s8,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v16s8,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/Mips::SHF_B,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
      GIR_AddImm, /*InsnID*/1, /*Imm*/177,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC MSA128H*/66,
      // GIR_Coverage, 1986,
      GIR_Done,
    // Label 373: @7809
    GIM_Try, /*On fail goto*//*Label 374*/ 7874, // Rule ID 2002 //
      GIM_CheckFeatures, GIFBS_HasMSA_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128HRegClassID,
      // (bitconvert:{ *:[v8i16] } v4i32:{ *:[v4i32] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v8i16] } (SHF_H:{ *:[v8i16] } (COPY_TO_REGCLASS:{ *:[v8i16] } v4i32:{ *:[v4i32] }:$src, MSA128H:{ *:[i32] }), 177:{ *:[i32] }), MSA128H:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v8s16,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v8s16,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/Mips::SHF_H,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
      GIR_AddImm, /*InsnID*/1, /*Imm*/177,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC MSA128H*/66,
      // GIR_Coverage, 2002,
      GIR_Done,
    // Label 374: @7874
    GIM_Try, /*On fail goto*//*Label 375*/ 7939, // Rule ID 2003 //
      GIM_CheckFeatures, GIFBS_HasMSA_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128HRegClassID,
      // (bitconvert:{ *:[v8f16] } v4i32:{ *:[v4i32] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v8f16] } (SHF_H:{ *:[v8i16] } (COPY_TO_REGCLASS:{ *:[v8i16] } v4i32:{ *:[v4i32] }:$src, MSA128H:{ *:[i32] }), 177:{ *:[i32] }), MSA128H:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v8s16,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v8s16,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/Mips::SHF_H,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
      GIR_AddImm, /*InsnID*/1, /*Imm*/177,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC MSA128H*/66,
      // GIR_Coverage, 2003,
      GIR_Done,
    // Label 375: @7939
    GIM_Try, /*On fail goto*//*Label 376*/ 8004, // Rule ID 2007 //
      GIM_CheckFeatures, GIFBS_HasMSA_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128HRegClassID,
      // (bitconvert:{ *:[v8i16] } v4f32:{ *:[v4f32] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v8i16] } (SHF_H:{ *:[v8i16] } (COPY_TO_REGCLASS:{ *:[v8i16] } v4f32:{ *:[v4f32] }:$src, MSA128H:{ *:[i32] }), 177:{ *:[i32] }), MSA128H:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v8s16,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v8s16,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/Mips::SHF_H,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
      GIR_AddImm, /*InsnID*/1, /*Imm*/177,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC MSA128H*/66,
      // GIR_Coverage, 2007,
      GIR_Done,
    // Label 376: @8004
    GIM_Try, /*On fail goto*//*Label 377*/ 8069, // Rule ID 2008 //
      GIM_CheckFeatures, GIFBS_HasMSA_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128HRegClassID,
      // (bitconvert:{ *:[v8f16] } v4f32:{ *:[v4f32] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v8f16] } (SHF_H:{ *:[v8i16] } (COPY_TO_REGCLASS:{ *:[v8i16] } v4f32:{ *:[v4f32] }:$src, MSA128H:{ *:[i32] }), 177:{ *:[i32] }), MSA128H:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v8s16,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v8s16,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/Mips::SHF_H,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
      GIR_AddImm, /*InsnID*/1, /*Imm*/177,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC MSA128H*/66,
      // GIR_Coverage, 2008,
      GIR_Done,
    // Label 377: @8069
    GIM_Try, /*On fail goto*//*Label 378*/ 8134, // Rule ID 2012 //
      GIM_CheckFeatures, GIFBS_HasMSA_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128HRegClassID,
      // (bitconvert:{ *:[v8i16] } v2i64:{ *:[v2i64] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v8i16] } (SHF_H:{ *:[v8i16] } (COPY_TO_REGCLASS:{ *:[v8i16] } v2i64:{ *:[v2i64] }:$src, MSA128H:{ *:[i32] }), 27:{ *:[i32] }), MSA128H:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v8s16,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v8s16,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/Mips::SHF_H,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
      GIR_AddImm, /*InsnID*/1, /*Imm*/27,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC MSA128H*/66,
      // GIR_Coverage, 2012,
      GIR_Done,
    // Label 378: @8134
    GIM_Try, /*On fail goto*//*Label 379*/ 8199, // Rule ID 2013 //
      GIM_CheckFeatures, GIFBS_HasMSA_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128HRegClassID,
      // (bitconvert:{ *:[v8f16] } v2i64:{ *:[v2i64] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v8f16] } (SHF_H:{ *:[v8i16] } (COPY_TO_REGCLASS:{ *:[v8i16] } v2i64:{ *:[v2i64] }:$src, MSA128H:{ *:[i32] }), 27:{ *:[i32] }), MSA128H:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v8s16,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v8s16,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/Mips::SHF_H,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
      GIR_AddImm, /*InsnID*/1, /*Imm*/27,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC MSA128H*/66,
      // GIR_Coverage, 2013,
      GIR_Done,
    // Label 379: @8199
    GIM_Try, /*On fail goto*//*Label 380*/ 8264, // Rule ID 2017 //
      GIM_CheckFeatures, GIFBS_HasMSA_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128HRegClassID,
      // (bitconvert:{ *:[v8i16] } v2f64:{ *:[v2f64] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v8i16] } (SHF_H:{ *:[v8i16] } (COPY_TO_REGCLASS:{ *:[v8i16] } v2f64:{ *:[v2f64] }:$src, MSA128H:{ *:[i32] }), 27:{ *:[i32] }), MSA128H:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v8s16,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v8s16,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/Mips::SHF_H,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
      GIR_AddImm, /*InsnID*/1, /*Imm*/27,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC MSA128H*/66,
      // GIR_Coverage, 2017,
      GIR_Done,
    // Label 380: @8264
    GIM_Try, /*On fail goto*//*Label 381*/ 8329, // Rule ID 2018 //
      GIM_CheckFeatures, GIFBS_HasMSA_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128HRegClassID,
      // (bitconvert:{ *:[v8f16] } v2f64:{ *:[v2f64] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v8f16] } (SHF_H:{ *:[v8i16] } (COPY_TO_REGCLASS:{ *:[v8i16] } v2f64:{ *:[v2f64] }:$src, MSA128H:{ *:[i32] }), 27:{ *:[i32] }), MSA128H:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v8s16,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v8s16,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/Mips::SHF_H,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
      GIR_AddImm, /*InsnID*/1, /*Imm*/27,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC MSA128H*/66,
      // GIR_Coverage, 2018,
      GIR_Done,
    // Label 381: @8329
    GIM_Reject,
    // Label 300: @8330
    GIM_Try, /*On fail goto*//*Label 382*/ 8351, // Rule ID 1954 //
      GIM_CheckFeatures, GIFBS_HasMSA_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128BRegClassID,
      // (bitconvert:{ *:[v16i8] } v8i16:{ *:[v8i16] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v16i8] } v8i16:{ *:[v8i16] }:$src, MSA128B:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC MSA128B*/64,
      // GIR_Coverage, 1954,
      GIR_Done,
    // Label 382: @8351
    GIM_Try, /*On fail goto*//*Label 383*/ 8372, // Rule ID 1955 //
      GIM_CheckFeatures, GIFBS_HasMSA_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128BRegClassID,
      // (bitconvert:{ *:[v16i8] } v4i32:{ *:[v4i32] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v16i8] } v4i32:{ *:[v4i32] }:$src, MSA128B:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC MSA128B*/64,
      // GIR_Coverage, 1955,
      GIR_Done,
    // Label 383: @8372
    GIM_Try, /*On fail goto*//*Label 384*/ 8393, // Rule ID 1956 //
      GIM_CheckFeatures, GIFBS_HasMSA_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128BRegClassID,
      // (bitconvert:{ *:[v16i8] } v2i64:{ *:[v2i64] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v16i8] } v2i64:{ *:[v2i64] }:$src, MSA128B:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC MSA128B*/64,
      // GIR_Coverage, 1956,
      GIR_Done,
    // Label 384: @8393
    GIM_Try, /*On fail goto*//*Label 385*/ 8414, // Rule ID 1957 //
      GIM_CheckFeatures, GIFBS_HasMSA_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128BRegClassID,
      // (bitconvert:{ *:[v16i8] } v8f16:{ *:[v8f16] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v16i8] } v8f16:{ *:[v8f16] }:$src, MSA128B:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC MSA128B*/64,
      // GIR_Coverage, 1957,
      GIR_Done,
    // Label 385: @8414
    GIM_Try, /*On fail goto*//*Label 386*/ 8435, // Rule ID 1958 //
      GIM_CheckFeatures, GIFBS_HasMSA_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128BRegClassID,
      // (bitconvert:{ *:[v16i8] } v4f32:{ *:[v4f32] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v16i8] } v4f32:{ *:[v4f32] }:$src, MSA128B:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC MSA128B*/64,
      // GIR_Coverage, 1958,
      GIR_Done,
    // Label 386: @8435
    GIM_Try, /*On fail goto*//*Label 387*/ 8456, // Rule ID 1959 //
      GIM_CheckFeatures, GIFBS_HasMSA_IsLE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128BRegClassID,
      // (bitconvert:{ *:[v16i8] } v2f64:{ *:[v2f64] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v16i8] } v2f64:{ *:[v2f64] }:$src, MSA128B:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC MSA128B*/64,
      // GIR_Coverage, 1959,
      GIR_Done,
    // Label 387: @8456
    GIM_Try, /*On fail goto*//*Label 388*/ 8521, // Rule ID 1991 //
      GIM_CheckFeatures, GIFBS_HasMSA_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128BRegClassID,
      // (bitconvert:{ *:[v16i8] } v8i16:{ *:[v8i16] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v16i8] } (SHF_B:{ *:[v16i8] } (COPY_TO_REGCLASS:{ *:[v16i8] } v8i16:{ *:[v8i16] }:$src, MSA128B:{ *:[i32] }), 177:{ *:[i32] }), MSA128B:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v16s8,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v16s8,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/Mips::SHF_B,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
      GIR_AddImm, /*InsnID*/1, /*Imm*/177,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC MSA128B*/64,
      // GIR_Coverage, 1991,
      GIR_Done,
    // Label 388: @8521
    GIM_Try, /*On fail goto*//*Label 389*/ 8586, // Rule ID 1996 //
      GIM_CheckFeatures, GIFBS_HasMSA_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128BRegClassID,
      // (bitconvert:{ *:[v16i8] } v8f16:{ *:[v8f16] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v16i8] } (SHF_B:{ *:[v16i8] } (COPY_TO_REGCLASS:{ *:[v16i8] } v8f16:{ *:[v8f16] }:$src, MSA128B:{ *:[i32] }), 177:{ *:[i32] }), MSA128B:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v16s8,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v16s8,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/Mips::SHF_B,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
      GIR_AddImm, /*InsnID*/1, /*Imm*/177,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC MSA128B*/64,
      // GIR_Coverage, 1996,
      GIR_Done,
    // Label 389: @8586
    GIM_Try, /*On fail goto*//*Label 390*/ 8651, // Rule ID 2001 //
      GIM_CheckFeatures, GIFBS_HasMSA_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128BRegClassID,
      // (bitconvert:{ *:[v16i8] } v4i32:{ *:[v4i32] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v16i8] } (SHF_B:{ *:[v16i8] } (COPY_TO_REGCLASS:{ *:[v16i8] } v4i32:{ *:[v4i32] }:$src, MSA128B:{ *:[i32] }), 27:{ *:[i32] }), MSA128B:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v16s8,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v16s8,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/Mips::SHF_B,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
      GIR_AddImm, /*InsnID*/1, /*Imm*/27,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC MSA128B*/64,
      // GIR_Coverage, 2001,
      GIR_Done,
    // Label 390: @8651
    GIM_Try, /*On fail goto*//*Label 391*/ 8716, // Rule ID 2006 //
      GIM_CheckFeatures, GIFBS_HasMSA_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128BRegClassID,
      // (bitconvert:{ *:[v16i8] } v4f32:{ *:[v4f32] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v16i8] } (SHF_B:{ *:[v16i8] } (COPY_TO_REGCLASS:{ *:[v16i8] } v4f32:{ *:[v4f32] }:$src, MSA128B:{ *:[i32] }), 27:{ *:[i32] }), MSA128B:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v16s8,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v16s8,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/Mips::SHF_B,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
      GIR_AddImm, /*InsnID*/1, /*Imm*/27,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC MSA128B*/64,
      // GIR_Coverage, 2006,
      GIR_Done,
    // Label 391: @8716
    GIM_Try, /*On fail goto*//*Label 392*/ 8816, // Rule ID 2011 //
      GIM_CheckFeatures, GIFBS_HasMSA_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128BRegClassID,
      // (bitconvert:{ *:[v16i8] } v2i64:{ *:[v2i64] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v16i8] } (SHF_W:{ *:[v4i32] } (COPY_TO_REGCLASS:{ *:[v4i32] } (SHF_B:{ *:[v16i8] } (COPY_TO_REGCLASS:{ *:[v16i8] } v2i64:{ *:[v2i64] }:$src, MSA128B:{ *:[i32] }), 27:{ *:[i32] }), MSA128W:{ *:[i32] }), 177:{ *:[i32] }), MSA128B:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
      GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v16s8,
      GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_v16s8,
      GIR_BuildMI, /*InsnID*/4, /*Opcode*/TargetOpcode::COPY,
      GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/RegState::Define,
      GIR_Copy, /*NewInsnID*/4, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/4,
      GIR_BuildMI, /*InsnID*/3, /*Opcode*/Mips::SHF_B,
      GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
      GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/3, /*TempRegFlags*/0,
      GIR_AddImm, /*InsnID*/3, /*Imm*/27,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/2, /*TempRegFlags*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/Mips::SHF_W,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
      GIR_AddImm, /*InsnID*/1, /*Imm*/177,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC MSA128B*/64,
      // GIR_Coverage, 2011,
      GIR_Done,
    // Label 392: @8816
    GIM_Try, /*On fail goto*//*Label 393*/ 8916, // Rule ID 2016 //
      GIM_CheckFeatures, GIFBS_HasMSA_IsBE,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128BRegClassID,
      // (bitconvert:{ *:[v16i8] } v2f64:{ *:[v2f64] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v16i8] } (SHF_W:{ *:[v4i32] } (COPY_TO_REGCLASS:{ *:[v4i32] } (SHF_B:{ *:[v16i8] } (COPY_TO_REGCLASS:{ *:[v16i8] } v2f64:{ *:[v2f64] }:$src, MSA128B:{ *:[i32] }), 27:{ *:[i32] }), MSA128W:{ *:[i32] }), 177:{ *:[i32] }), MSA128B:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
      GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v16s8,
      GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_v16s8,
      GIR_BuildMI, /*InsnID*/4, /*Opcode*/TargetOpcode::COPY,
      GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/RegState::Define,
      GIR_Copy, /*NewInsnID*/4, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/4,
      GIR_BuildMI, /*InsnID*/3, /*Opcode*/Mips::SHF_B,
      GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
      GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/3, /*TempRegFlags*/0,
      GIR_AddImm, /*InsnID*/3, /*Imm*/27,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/2, /*TempRegFlags*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/Mips::SHF_W,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
      GIR_AddImm, /*InsnID*/1, /*Imm*/177,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC MSA128B*/64,
      // GIR_Coverage, 2016,
      GIR_Done,
    // Label 393: @8916
    GIM_Reject,
    // Label 301: @8917
    GIM_Reject,
    // Label 12: @8918
    GIM_Try, /*On fail goto*//*Label 394*/ 8983, // Rule ID 1939 //
      GIM_CheckFeatures, GIFBS_HasDSP,
      GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
      // MIs[0] Operand 1
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
      GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
      GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ADD,
      GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckIsSafeToFold, /*InsnID*/1,
      // (ld:{ *:[i32] } (add:{ *:[i32] } i32:{ *:[i32] }:$base, i32:{ *:[i32] }:$index))<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (LWX:{ *:[i32] } i32:{ *:[i32] }:$base, i32:{ *:[i32] }:$index)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::LWX,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // base
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // index
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, 1, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1939,
      GIR_Done,
    // Label 394: @8983
    GIM_Reject,
    // Label 13: @8984
    GIM_Try, /*On fail goto*//*Label 395*/ 9049, // Rule ID 1938 //
      GIM_CheckFeatures, GIFBS_HasDSP,
      GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/2,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
      // MIs[0] Operand 1
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
      GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
      GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ADD,
      GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckIsSafeToFold, /*InsnID*/1,
      // (ld:{ *:[i32] } (add:{ *:[i32] } i32:{ *:[i32] }:$base, i32:{ *:[i32] }:$index))<<P:Predicate_unindexedload>><<P:Predicate_sextload>><<P:Predicate_sextloadi16>>  =>  (LHX:{ *:[i32] } i32:{ *:[i32] }:$base, i32:{ *:[i32] }:$index)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::LHX,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // base
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // index
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, 1, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1938,
      GIR_Done,
    // Label 395: @9049
    GIM_Reject,
    // Label 14: @9050
    GIM_Try, /*On fail goto*//*Label 396*/ 9115, // Rule ID 1937 //
      GIM_CheckFeatures, GIFBS_HasDSP,
      GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/1,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
      // MIs[0] Operand 1
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
      GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
      GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ADD,
      GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckIsSafeToFold, /*InsnID*/1,
      // (ld:{ *:[i32] } (add:{ *:[i32] } i32:{ *:[i32] }:$base, i32:{ *:[i32] }:$index))<<P:Predicate_unindexedload>><<P:Predicate_zextload>><<P:Predicate_zextloadi8>>  =>  (LBUX:{ *:[i32] } i32:{ *:[i32] }:$base, i32:{ *:[i32] }:$index)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::LBUX,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // base
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // index
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, 1, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1937,
      GIR_Done,
    // Label 396: @9115
    GIM_Reject,
    // Label 15: @9116
    GIM_Try, /*On fail goto*//*Label 397*/ 11310,
      GIM_CheckNumOperands, /*MI*/0, /*Expected*/3,
      GIM_Try, /*On fail goto*//*Label 398*/ 9168, // Rule ID 416 //
        GIM_CheckFeatures, GIFBS_HasDSP,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_repl_qb,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_immZExt8,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_wo_chain:{ *:[v4i8] } 4174:{ *:[iPTR] }, (imm:{ *:[i32] })<<P:Predicate_immZExt8>>:$imm)  =>  (REPL_QB:{ *:[v4i8] } (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::REPL_QB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 416,
        GIR_Done,
      // Label 398: @9168
      GIM_Try, /*On fail goto*//*Label 399*/ 9215, // Rule ID 417 //
        GIM_CheckFeatures, GIFBS_HasDSP,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_repl_ph,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_immSExt10,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_wo_chain:{ *:[v2i16] } 4173:{ *:[iPTR] }, (imm:{ *:[i32] })<<P:Predicate_immSExt10>>:$imm)  =>  (REPL_PH:{ *:[v2i16] } (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::REPL_PH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 417,
        GIR_Done,
      // Label 399: @9215
      GIM_Try, /*On fail goto*//*Label 400*/ 9262, // Rule ID 1270 //
        GIM_CheckFeatures, GIFBS_HasDSP_InMicroMips,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_repl_ph,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_immSExt10,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_wo_chain:{ *:[v2i16] } 4173:{ *:[iPTR] }, (imm:{ *:[i32] })<<P:Predicate_immSExt10>>:$imm)  =>  (REPL_PH_MM:{ *:[v2i16] } (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::REPL_PH_MM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1270,
        GIR_Done,
      // Label 400: @9262
      GIM_Try, /*On fail goto*//*Label 401*/ 9309, // Rule ID 1271 //
        GIM_CheckFeatures, GIFBS_HasDSP_InMicroMips,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_repl_qb,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_immZExt8,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_wo_chain:{ *:[v4i8] } 4174:{ *:[iPTR] }, (imm:{ *:[i32] })<<P:Predicate_immZExt8>>:$imm)  =>  (REPL_QB_MM:{ *:[v4i8] } (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::REPL_QB_MM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rt
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1271,
        GIR_Done,
      // Label 401: @9309
      GIM_Try, /*On fail goto*//*Label 402*/ 9349, // Rule ID 350 //
        GIM_CheckFeatures, GIFBS_HasDSP,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_raddu_w_qb,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 4171:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs)  =>  (RADDU_W_QB:{ *:[i32] } DSPROpnd:{ *:[v4i8] }:$rs)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::RADDU_W_QB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 350,
        GIR_Done,
      // Label 402: @9349
      GIM_Try, /*On fail goto*//*Label 403*/ 9389, // Rule ID 357 //
        GIM_CheckFeatures, GIFBS_HasDSP,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_preceq_w_phl,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 4153:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (PRECEQ_W_PHL:{ *:[i32] } DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::PRECEQ_W_PHL,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 357,
        GIR_Done,
      // Label 403: @9389
      GIM_Try, /*On fail goto*//*Label 404*/ 9429, // Rule ID 358 //
        GIM_CheckFeatures, GIFBS_HasDSP,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_preceq_w_phr,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 4154:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (PRECEQ_W_PHR:{ *:[i32] } DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::PRECEQ_W_PHR,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 358,
        GIR_Done,
      // Label 404: @9429
      GIM_Try, /*On fail goto*//*Label 405*/ 9469, // Rule ID 359 //
        GIM_CheckFeatures, GIFBS_HasDSP,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_precequ_ph_qbl,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i16] } 4155:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (PRECEQU_PH_QBL:{ *:[v2i16] } DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::PRECEQU_PH_QBL,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 359,
        GIR_Done,
      // Label 405: @9469
      GIM_Try, /*On fail goto*//*Label 406*/ 9509, // Rule ID 360 //
        GIM_CheckFeatures, GIFBS_HasDSP,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_precequ_ph_qbr,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i16] } 4157:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (PRECEQU_PH_QBR:{ *:[v2i16] } DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::PRECEQU_PH_QBR,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 360,
        GIR_Done,
      // Label 406: @9509
      GIM_Try, /*On fail goto*//*Label 407*/ 9549, // Rule ID 361 //
        GIM_CheckFeatures, GIFBS_HasDSP,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_precequ_ph_qbla,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i16] } 4156:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (PRECEQU_PH_QBLA:{ *:[v2i16] } DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::PRECEQU_PH_QBLA,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 361,
        GIR_Done,
      // Label 407: @9549
      GIM_Try, /*On fail goto*//*Label 408*/ 9589, // Rule ID 362 //
        GIM_CheckFeatures, GIFBS_HasDSP,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_precequ_ph_qbra,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i16] } 4158:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (PRECEQU_PH_QBRA:{ *:[v2i16] } DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::PRECEQU_PH_QBRA,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 362,
        GIR_Done,
      // Label 408: @9589
      GIM_Try, /*On fail goto*//*Label 409*/ 9629, // Rule ID 363 //
        GIM_CheckFeatures, GIFBS_HasDSP,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_preceu_ph_qbl,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i16] } 4159:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (PRECEU_PH_QBL:{ *:[v2i16] } DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::PRECEU_PH_QBL,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 363,
        GIR_Done,
      // Label 409: @9629
      GIM_Try, /*On fail goto*//*Label 410*/ 9669, // Rule ID 364 //
        GIM_CheckFeatures, GIFBS_HasDSP,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_preceu_ph_qbr,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i16] } 4161:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (PRECEU_PH_QBR:{ *:[v2i16] } DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::PRECEU_PH_QBR,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 364,
        GIR_Done,
      // Label 410: @9669
      GIM_Try, /*On fail goto*//*Label 411*/ 9709, // Rule ID 365 //
        GIM_CheckFeatures, GIFBS_HasDSP,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_preceu_ph_qbla,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i16] } 4160:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (PRECEU_PH_QBLA:{ *:[v2i16] } DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::PRECEU_PH_QBLA,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 365,
        GIR_Done,
      // Label 411: @9709
      GIM_Try, /*On fail goto*//*Label 412*/ 9749, // Rule ID 366 //
        GIM_CheckFeatures, GIFBS_HasDSP,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_preceu_ph_qbra,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i16] } 4162:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (PRECEU_PH_QBRA:{ *:[v2i16] } DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::PRECEU_PH_QBRA,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 366,
        GIR_Done,
      // Label 412: @9749
      GIM_Try, /*On fail goto*//*Label 413*/ 9789, // Rule ID 414 //
        GIM_CheckFeatures, GIFBS_HasDSP,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_bitrev,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR32RegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 3729:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rt)  =>  (BITREV:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::BITREV,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 414,
        GIR_Done,
      // Label 413: @9789
      GIM_Try, /*On fail goto*//*Label 414*/ 9829, // Rule ID 418 //
        GIM_CheckFeatures, GIFBS_HasDSP,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_repl_qb,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR32RegClassID,
        // (intrinsic_wo_chain:{ *:[v4i8] } 4174:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rt)  =>  (REPLV_QB:{ *:[v4i8] } GPR32Opnd:{ *:[i32] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::REPLV_QB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 418,
        GIR_Done,
      // Label 414: @9829
      GIM_Try, /*On fail goto*//*Label 415*/ 9869, // Rule ID 419 //
        GIM_CheckFeatures, GIFBS_HasDSP,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_repl_ph,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR32RegClassID,
        // (intrinsic_wo_chain:{ *:[v2i16] } 4173:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rt)  =>  (REPLV_PH:{ *:[v2i16] } GPR32Opnd:{ *:[i32] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::REPLV_PH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 419,
        GIR_Done,
      // Label 415: @9869
      GIM_Try, /*On fail goto*//*Label 416*/ 9909, // Rule ID 664 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_fclass_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128WRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 3881:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4f32] }:$ws)  =>  (FCLASS_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4f32] }:$ws)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::FCLASS_W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 664,
        GIR_Done,
      // Label 416: @9909
      GIM_Try, /*On fail goto*//*Label 417*/ 9949, // Rule ID 665 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_fclass_d,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128DRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 3880:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2f64] }:$ws)  =>  (FCLASS_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2f64] }:$ws)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::FCLASS_D,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 665,
        GIR_Done,
      // Label 417: @9949
      GIM_Try, /*On fail goto*//*Label 418*/ 9989, // Rule ID 688 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_fexupl_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128HRegClassID,
        // (intrinsic_wo_chain:{ *:[v4f32] } 3907:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8f16] }:$ws)  =>  (FEXUPL_W:{ *:[v4f32] } MSA128HOpnd:{ *:[v8f16] }:$ws)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::FEXUPL_W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 688,
        GIR_Done,
      // Label 418: @9989
      GIM_Try, /*On fail goto*//*Label 419*/ 10029, // Rule ID 689 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_fexupl_d,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128WRegClassID,
        // (intrinsic_wo_chain:{ *:[v2f64] } 3906:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4f32] }:$ws)  =>  (FEXUPL_D:{ *:[v2f64] } MSA128WOpnd:{ *:[v4f32] }:$ws)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::FEXUPL_D,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 689,
        GIR_Done,
      // Label 419: @10029
      GIM_Try, /*On fail goto*//*Label 420*/ 10069, // Rule ID 690 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_fexupr_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128HRegClassID,
        // (intrinsic_wo_chain:{ *:[v4f32] } 3909:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8f16] }:$ws)  =>  (FEXUPR_W:{ *:[v4f32] } MSA128HOpnd:{ *:[v8f16] }:$ws)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::FEXUPR_W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 690,
        GIR_Done,
      // Label 420: @10069
      GIM_Try, /*On fail goto*//*Label 421*/ 10109, // Rule ID 691 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_fexupr_d,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128WRegClassID,
        // (intrinsic_wo_chain:{ *:[v2f64] } 3908:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4f32] }:$ws)  =>  (FEXUPR_D:{ *:[v2f64] } MSA128WOpnd:{ *:[v4f32] }:$ws)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::FEXUPR_D,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 691,
        GIR_Done,
      // Label 421: @10109
      GIM_Try, /*On fail goto*//*Label 422*/ 10149, // Rule ID 696 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_ffql_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128HRegClassID,
        // (intrinsic_wo_chain:{ *:[v4f32] } 3915:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$ws)  =>  (FFQL_W:{ *:[v4f32] } MSA128HOpnd:{ *:[v8i16] }:$ws)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::FFQL_W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 696,
        GIR_Done,
      // Label 422: @10149
      GIM_Try, /*On fail goto*//*Label 423*/ 10189, // Rule ID 697 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_ffql_d,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128WRegClassID,
        // (intrinsic_wo_chain:{ *:[v2f64] } 3914:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$ws)  =>  (FFQL_D:{ *:[v2f64] } MSA128WOpnd:{ *:[v4i32] }:$ws)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::FFQL_D,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 697,
        GIR_Done,
      // Label 423: @10189
      GIM_Try, /*On fail goto*//*Label 424*/ 10229, // Rule ID 698 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_ffqr_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128HRegClassID,
        // (intrinsic_wo_chain:{ *:[v4f32] } 3917:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$ws)  =>  (FFQR_W:{ *:[v4f32] } MSA128HOpnd:{ *:[v8i16] }:$ws)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::FFQR_W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 698,
        GIR_Done,
      // Label 424: @10229
      GIM_Try, /*On fail goto*//*Label 425*/ 10269, // Rule ID 699 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_ffqr_d,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128WRegClassID,
        // (intrinsic_wo_chain:{ *:[v2f64] } 3916:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$ws)  =>  (FFQR_D:{ *:[v2f64] } MSA128WOpnd:{ *:[v4i32] }:$ws)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::FFQR_D,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 699,
        GIR_Done,
      // Label 425: @10269
      GIM_Try, /*On fail goto*//*Label 426*/ 10309, // Rule ID 724 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_frcp_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128WRegClassID,
        // (intrinsic_wo_chain:{ *:[v4f32] } 3939:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4f32] }:$ws)  =>  (FRCP_W:{ *:[v4f32] } MSA128WOpnd:{ *:[v4f32] }:$ws)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::FRCP_W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 724,
        GIR_Done,
      // Label 426: @10309
      GIM_Try, /*On fail goto*//*Label 427*/ 10349, // Rule ID 725 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_frcp_d,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128DRegClassID,
        // (intrinsic_wo_chain:{ *:[v2f64] } 3938:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2f64] }:$ws)  =>  (FRCP_D:{ *:[v2f64] } MSA128DOpnd:{ *:[v2f64] }:$ws)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::FRCP_D,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 725,
        GIR_Done,
      // Label 427: @10349
      GIM_Try, /*On fail goto*//*Label 428*/ 10389, // Rule ID 726 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_frsqrt_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128WRegClassID,
        // (intrinsic_wo_chain:{ *:[v4f32] } 3943:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4f32] }:$ws)  =>  (FRSQRT_W:{ *:[v4f32] } MSA128WOpnd:{ *:[v4f32] }:$ws)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::FRSQRT_W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 726,
        GIR_Done,
      // Label 428: @10389
      GIM_Try, /*On fail goto*//*Label 429*/ 10429, // Rule ID 727 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_frsqrt_d,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128DRegClassID,
        // (intrinsic_wo_chain:{ *:[v2f64] } 3942:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2f64] }:$ws)  =>  (FRSQRT_D:{ *:[v2f64] } MSA128DOpnd:{ *:[v2f64] }:$ws)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::FRSQRT_D,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 727,
        GIR_Done,
      // Label 429: @10429
      GIM_Try, /*On fail goto*//*Label 430*/ 10469, // Rule ID 754 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_ftint_s_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128WRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 3971:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4f32] }:$ws)  =>  (FTINT_S_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4f32] }:$ws)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::FTINT_S_W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 754,
        GIR_Done,
      // Label 430: @10469
      GIM_Try, /*On fail goto*//*Label 431*/ 10509, // Rule ID 755 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_ftint_s_d,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128DRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 3970:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2f64] }:$ws)  =>  (FTINT_S_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2f64] }:$ws)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::FTINT_S_D,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 755,
        GIR_Done,
      // Label 431: @10509
      GIM_Try, /*On fail goto*//*Label 432*/ 10549, // Rule ID 756 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_ftint_u_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128WRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 3973:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4f32] }:$ws)  =>  (FTINT_U_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4f32] }:$ws)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::FTINT_U_W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 756,
        GIR_Done,
      // Label 432: @10549
      GIM_Try, /*On fail goto*//*Label 433*/ 10589, // Rule ID 757 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_ftint_u_d,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128DRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 3972:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2f64] }:$ws)  =>  (FTINT_U_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2f64] }:$ws)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::FTINT_U_D,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 757,
        GIR_Done,
      // Label 433: @10589
      GIM_Try, /*On fail goto*//*Label 434*/ 10629, // Rule ID 892 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_nloc_b,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128BRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128BRegClassID,
        // (intrinsic_wo_chain:{ *:[v16i8] } 4126:{ *:[iPTR] }, MSA128BOpnd:{ *:[v16i8] }:$ws)  =>  (NLOC_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::NLOC_B,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 892,
        GIR_Done,
      // Label 434: @10629
      GIM_Try, /*On fail goto*//*Label 435*/ 10669, // Rule ID 893 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_nloc_h,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128HRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 4128:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$ws)  =>  (NLOC_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::NLOC_H,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 893,
        GIR_Done,
      // Label 435: @10669
      GIM_Try, /*On fail goto*//*Label 436*/ 10709, // Rule ID 894 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_nloc_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128WRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 4129:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$ws)  =>  (NLOC_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::NLOC_W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 894,
        GIR_Done,
      // Label 436: @10709
      GIM_Try, /*On fail goto*//*Label 437*/ 10749, // Rule ID 895 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_nloc_d,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128DRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 4127:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2i64] }:$ws)  =>  (NLOC_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::NLOC_D,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 895,
        GIR_Done,
      // Label 437: @10749
      GIM_Try, /*On fail goto*//*Label 438*/ 10789, // Rule ID 1233 //
        GIM_CheckFeatures, GIFBS_HasDSP_InMicroMips,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_preceq_w_phl,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 4153:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs)  =>  (PRECEQ_W_PHL_MM:{ *:[i32] } DSPROpnd:{ *:[v2i16] }:$rs)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::PRECEQ_W_PHL_MM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1233,
        GIR_Done,
      // Label 438: @10789
      GIM_Try, /*On fail goto*//*Label 439*/ 10829, // Rule ID 1234 //
        GIM_CheckFeatures, GIFBS_HasDSP_InMicroMips,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_preceq_w_phr,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 4154:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs)  =>  (PRECEQ_W_PHR_MM:{ *:[i32] } DSPROpnd:{ *:[v2i16] }:$rs)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::PRECEQ_W_PHR_MM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1234,
        GIR_Done,
      // Label 439: @10829
      GIM_Try, /*On fail goto*//*Label 440*/ 10869, // Rule ID 1235 //
        GIM_CheckFeatures, GIFBS_HasDSP_InMicroMips,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_precequ_ph_qbl,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i16] } 4155:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs)  =>  (PRECEQU_PH_QBL_MM:{ *:[v2i16] } DSPROpnd:{ *:[v4i8] }:$rs)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::PRECEQU_PH_QBL_MM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1235,
        GIR_Done,
      // Label 440: @10869
      GIM_Try, /*On fail goto*//*Label 441*/ 10909, // Rule ID 1236 //
        GIM_CheckFeatures, GIFBS_HasDSP_InMicroMips,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_precequ_ph_qbla,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i16] } 4156:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs)  =>  (PRECEQU_PH_QBLA_MM:{ *:[v2i16] } DSPROpnd:{ *:[v4i8] }:$rs)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::PRECEQU_PH_QBLA_MM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1236,
        GIR_Done,
      // Label 441: @10909
      GIM_Try, /*On fail goto*//*Label 442*/ 10949, // Rule ID 1237 //
        GIM_CheckFeatures, GIFBS_HasDSP_InMicroMips,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_precequ_ph_qbr,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i16] } 4157:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs)  =>  (PRECEQU_PH_QBR_MM:{ *:[v2i16] } DSPROpnd:{ *:[v4i8] }:$rs)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::PRECEQU_PH_QBR_MM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1237,
        GIR_Done,
      // Label 442: @10949
      GIM_Try, /*On fail goto*//*Label 443*/ 10989, // Rule ID 1238 //
        GIM_CheckFeatures, GIFBS_HasDSP_InMicroMips,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_precequ_ph_qbra,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i16] } 4158:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs)  =>  (PRECEQU_PH_QBRA_MM:{ *:[v2i16] } DSPROpnd:{ *:[v4i8] }:$rs)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::PRECEQU_PH_QBRA_MM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1238,
        GIR_Done,
      // Label 443: @10989
      GIM_Try, /*On fail goto*//*Label 444*/ 11029, // Rule ID 1239 //
        GIM_CheckFeatures, GIFBS_HasDSP_InMicroMips,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_preceu_ph_qbl,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i16] } 4159:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs)  =>  (PRECEU_PH_QBL_MM:{ *:[v2i16] } DSPROpnd:{ *:[v4i8] }:$rs)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::PRECEU_PH_QBL_MM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1239,
        GIR_Done,
      // Label 444: @11029
      GIM_Try, /*On fail goto*//*Label 445*/ 11069, // Rule ID 1240 //
        GIM_CheckFeatures, GIFBS_HasDSP_InMicroMips,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_preceu_ph_qbla,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i16] } 4160:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs)  =>  (PRECEU_PH_QBLA_MM:{ *:[v2i16] } DSPROpnd:{ *:[v4i8] }:$rs)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::PRECEU_PH_QBLA_MM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1240,
        GIR_Done,
      // Label 445: @11069
      GIM_Try, /*On fail goto*//*Label 446*/ 11109, // Rule ID 1241 //
        GIM_CheckFeatures, GIFBS_HasDSP_InMicroMips,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_preceu_ph_qbr,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i16] } 4161:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs)  =>  (PRECEU_PH_QBR_MM:{ *:[v2i16] } DSPROpnd:{ *:[v4i8] }:$rs)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::PRECEU_PH_QBR_MM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1241,
        GIR_Done,
      // Label 446: @11109
      GIM_Try, /*On fail goto*//*Label 447*/ 11149, // Rule ID 1242 //
        GIM_CheckFeatures, GIFBS_HasDSP_InMicroMips,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_preceu_ph_qbra,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i16] } 4162:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs)  =>  (PRECEU_PH_QBRA_MM:{ *:[v2i16] } DSPROpnd:{ *:[v4i8] }:$rs)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::PRECEU_PH_QBRA_MM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1242,
        GIR_Done,
      // Label 447: @11149
      GIM_Try, /*On fail goto*//*Label 448*/ 11189, // Rule ID 1268 //
        GIM_CheckFeatures, GIFBS_HasDSP_InMicroMips,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_raddu_w_qb,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 4171:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs)  =>  (RADDU_W_QB_MM:{ *:[i32] } DSPROpnd:{ *:[v4i8] }:$rs)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::RADDU_W_QB_MM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1268,
        GIR_Done,
      // Label 448: @11189
      GIM_Try, /*On fail goto*//*Label 449*/ 11229, // Rule ID 1272 //
        GIM_CheckFeatures, GIFBS_HasDSP_InMicroMips,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_repl_ph,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR32RegClassID,
        // (intrinsic_wo_chain:{ *:[v2i16] } 4173:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rs)  =>  (REPLV_PH_MM:{ *:[v2i16] } GPR32Opnd:{ *:[i32] }:$rs)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::REPLV_PH_MM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1272,
        GIR_Done,
      // Label 449: @11229
      GIM_Try, /*On fail goto*//*Label 450*/ 11269, // Rule ID 1273 //
        GIM_CheckFeatures, GIFBS_HasDSP_InMicroMips,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_repl_qb,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR32RegClassID,
        // (intrinsic_wo_chain:{ *:[v4i8] } 4174:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rs)  =>  (REPLV_QB_MM:{ *:[v4i8] } GPR32Opnd:{ *:[i32] }:$rs)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::REPLV_QB_MM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1273,
        GIR_Done,
      // Label 450: @11269
      GIM_Try, /*On fail goto*//*Label 451*/ 11309, // Rule ID 1283 //
        GIM_CheckFeatures, GIFBS_HasDSP_InMicroMips,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_bitrev,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR32RegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 3729:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rs)  =>  (BITREV_MM:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::BITREV_MM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1283,
        GIR_Done,
      // Label 451: @11309
      GIM_Reject,
    // Label 397: @11310
    GIM_Try, /*On fail goto*//*Label 452*/ 22386,
      GIM_CheckNumOperands, /*MI*/0, /*Expected*/4,
      GIM_Try, /*On fail goto*//*Label 453*/ 11374, // Rule ID 373 //
        GIM_CheckFeatures, GIFBS_HasDSP,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_shra_r_ph,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_immZExt4,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_wo_chain:{ *:[v2i16] } 4193:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rt, (imm:{ *:[i32] })<<P:Predicate_immZExt4>>:$rs_sa)  =>  (SHRA_R_PH:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rt, (imm:{ *:[i32] }):$rs_sa)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SHRA_R_PH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rt
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // rs_sa
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 373,
        GIR_Done,
      // Label 453: @11374
      GIM_Try, /*On fail goto*//*Label 454*/ 11433, // Rule ID 377 //
        GIM_CheckFeatures, GIFBS_HasDSP,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_shra_r_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_immZExt5,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_wo_chain:{ *:[i32] } 4195:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rt, (imm:{ *:[i32] })<<P:Predicate_immZExt5>>:$rs_sa)  =>  (SHRA_R_W:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rt, (imm:{ *:[i32] }):$rs_sa)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SHRA_R_W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rt
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // rs_sa
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 377,
        GIR_Done,
      // Label 454: @11433
      GIM_Try, /*On fail goto*//*Label 455*/ 11492, // Rule ID 468 //
        GIM_CheckFeatures, GIFBS_HasDSPR2,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_shra_r_qb,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_immZExt3,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_wo_chain:{ *:[v4i8] } 4194:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rt, (imm:{ *:[i32] })<<P:Predicate_immZExt3>>:$rs_sa)  =>  (SHRA_R_QB:{ *:[v4i8] } DSPROpnd:{ *:[v4i8] }:$rt, (imm:{ *:[i32] }):$rs_sa)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SHRA_R_QB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rt
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // rs_sa
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 468,
        GIR_Done,
      // Label 455: @11492
      GIM_Try, /*On fail goto*//*Label 456*/ 11551, // Rule ID 1227 //
        GIM_CheckFeatures, GIFBS_HasDSP_InMicroMips,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_shra_r_ph,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_immZExt4,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_wo_chain:{ *:[v2i16] } 4193:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, (imm:{ *:[i32] })<<P:Predicate_immZExt4>>:$sa)  =>  (SHRA_R_PH_MM:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rs, (imm:{ *:[i32] }):$sa)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SHRA_R_PH_MM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // sa
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1227,
        GIR_Done,
      // Label 456: @11551
      GIM_Try, /*On fail goto*//*Label 457*/ 11610, // Rule ID 1231 //
        GIM_CheckFeatures, GIFBS_HasDSP_InMicroMips,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_shra_r_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_immZExt5,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_wo_chain:{ *:[i32] } 4195:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rs, (imm:{ *:[i32] })<<P:Predicate_immZExt5>>:$sa)  =>  (SHRA_R_W_MM:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, (imm:{ *:[i32] }):$sa)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SHRA_R_W_MM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // sa
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1231,
        GIR_Done,
      // Label 457: @11610
      GIM_Try, /*On fail goto*//*Label 458*/ 11669, // Rule ID 1306 //
        GIM_CheckFeatures, GIFBS_HasDSPR2_InMicroMips,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_shra_r_qb,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_immZExt3,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_wo_chain:{ *:[v4i8] } 4194:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs, (imm:{ *:[i32] })<<P:Predicate_immZExt3>>:$sa)  =>  (SHRA_R_QB_MMR2:{ *:[v4i8] } DSPROpnd:{ *:[v4i8] }:$rs, (imm:{ *:[i32] }):$sa)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SHRA_R_QB_MMR2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // sa
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1306,
        GIR_Done,
      // Label 458: @11669
      GIM_Try, /*On fail goto*//*Label 459*/ 11716, // Rule ID 922 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_sat_s_b,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128BRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128BRegClassID,
        // MIs[0] m
        GIM_CheckIsImm, /*MI*/0, /*Op*/3,
        // (intrinsic_wo_chain:{ *:[v16i8] } 4175:{ *:[iPTR] }, MSA128BOpnd:{ *:[v16i8] }:$ws, (timm:{ *:[i32] })<<P:Predicate_timmZExt3>>:$m)  =>  (SAT_S_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, (timm:{ *:[i32] }):$m)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SAT_S_B,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // m
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 922,
        GIR_Done,
      // Label 459: @11716
      GIM_Try, /*On fail goto*//*Label 460*/ 11763, // Rule ID 923 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_sat_s_h,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128HRegClassID,
        // MIs[0] m
        GIM_CheckIsImm, /*MI*/0, /*Op*/3,
        // (intrinsic_wo_chain:{ *:[v8i16] } 4177:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$ws, (timm:{ *:[i32] })<<P:Predicate_timmZExt4>>:$m)  =>  (SAT_S_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, (timm:{ *:[i32] }):$m)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SAT_S_H,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // m
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 923,
        GIR_Done,
      // Label 460: @11763
      GIM_Try, /*On fail goto*//*Label 461*/ 11810, // Rule ID 924 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_sat_s_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128WRegClassID,
        // MIs[0] m
        GIM_CheckIsImm, /*MI*/0, /*Op*/3,
        // (intrinsic_wo_chain:{ *:[v4i32] } 4178:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$ws, (timm:{ *:[i32] })<<P:Predicate_timmZExt5>>:$m)  =>  (SAT_S_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, (timm:{ *:[i32] }):$m)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SAT_S_W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // m
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 924,
        GIR_Done,
      // Label 461: @11810
      GIM_Try, /*On fail goto*//*Label 462*/ 11857, // Rule ID 925 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_sat_s_d,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128DRegClassID,
        // MIs[0] m
        GIM_CheckIsImm, /*MI*/0, /*Op*/3,
        // (intrinsic_wo_chain:{ *:[v2i64] } 4176:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2i64] }:$ws, (timm:{ *:[i32] })<<P:Predicate_timmZExt6>>:$m)  =>  (SAT_S_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, (timm:{ *:[i32] }):$m)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SAT_S_D,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // m
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 925,
        GIR_Done,
      // Label 462: @11857
      GIM_Try, /*On fail goto*//*Label 463*/ 11904, // Rule ID 926 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_sat_u_b,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128BRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128BRegClassID,
        // MIs[0] m
        GIM_CheckIsImm, /*MI*/0, /*Op*/3,
        // (intrinsic_wo_chain:{ *:[v16i8] } 4179:{ *:[iPTR] }, MSA128BOpnd:{ *:[v16i8] }:$ws, (timm:{ *:[i32] })<<P:Predicate_timmZExt3>>:$m)  =>  (SAT_U_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, (timm:{ *:[i32] }):$m)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SAT_U_B,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // m
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 926,
        GIR_Done,
      // Label 463: @11904
      GIM_Try, /*On fail goto*//*Label 464*/ 11951, // Rule ID 927 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_sat_u_h,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128HRegClassID,
        // MIs[0] m
        GIM_CheckIsImm, /*MI*/0, /*Op*/3,
        // (intrinsic_wo_chain:{ *:[v8i16] } 4181:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$ws, (timm:{ *:[i32] })<<P:Predicate_timmZExt4>>:$m)  =>  (SAT_U_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, (timm:{ *:[i32] }):$m)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SAT_U_H,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // m
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 927,
        GIR_Done,
      // Label 464: @11951
      GIM_Try, /*On fail goto*//*Label 465*/ 11998, // Rule ID 928 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_sat_u_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128WRegClassID,
        // MIs[0] m
        GIM_CheckIsImm, /*MI*/0, /*Op*/3,
        // (intrinsic_wo_chain:{ *:[v4i32] } 4182:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$ws, (timm:{ *:[i32] })<<P:Predicate_timmZExt5>>:$m)  =>  (SAT_U_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, (timm:{ *:[i32] }):$m)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SAT_U_W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // m
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 928,
        GIR_Done,
      // Label 465: @11998
      GIM_Try, /*On fail goto*//*Label 466*/ 12045, // Rule ID 929 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_sat_u_d,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128DRegClassID,
        // MIs[0] m
        GIM_CheckIsImm, /*MI*/0, /*Op*/3,
        // (intrinsic_wo_chain:{ *:[v2i64] } 4180:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2i64] }:$ws, (timm:{ *:[i32] })<<P:Predicate_timmZExt6>>:$m)  =>  (SAT_U_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, (timm:{ *:[i32] }):$m)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SAT_U_D,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // m
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 929,
        GIR_Done,
      // Label 466: @12045
      GIM_Try, /*On fail goto*//*Label 467*/ 12092, // Rule ID 969 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_srari_b,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128BRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128BRegClassID,
        // MIs[0] m
        GIM_CheckIsImm, /*MI*/0, /*Op*/3,
        // (intrinsic_wo_chain:{ *:[v16i8] } 4234:{ *:[iPTR] }, MSA128BOpnd:{ *:[v16i8] }:$ws, (timm:{ *:[i32] })<<P:Predicate_timmZExt3>>:$m)  =>  (SRARI_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, (timm:{ *:[i32] }):$m)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SRARI_B,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // m
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 969,
        GIR_Done,
      // Label 467: @12092
      GIM_Try, /*On fail goto*//*Label 468*/ 12139, // Rule ID 970 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_srari_h,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128HRegClassID,
        // MIs[0] m
        GIM_CheckIsImm, /*MI*/0, /*Op*/3,
        // (intrinsic_wo_chain:{ *:[v8i16] } 4236:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$ws, (timm:{ *:[i32] })<<P:Predicate_timmZExt4>>:$m)  =>  (SRARI_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, (timm:{ *:[i32] }):$m)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SRARI_H,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // m
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 970,
        GIR_Done,
      // Label 468: @12139
      GIM_Try, /*On fail goto*//*Label 469*/ 12186, // Rule ID 971 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_srari_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128WRegClassID,
        // MIs[0] m
        GIM_CheckIsImm, /*MI*/0, /*Op*/3,
        // (intrinsic_wo_chain:{ *:[v4i32] } 4237:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$ws, (timm:{ *:[i32] })<<P:Predicate_timmZExt5>>:$m)  =>  (SRARI_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, (timm:{ *:[i32] }):$m)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SRARI_W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // m
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 971,
        GIR_Done,
      // Label 469: @12186
      GIM_Try, /*On fail goto*//*Label 470*/ 12233, // Rule ID 972 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_srari_d,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128DRegClassID,
        // MIs[0] m
        GIM_CheckIsImm, /*MI*/0, /*Op*/3,
        // (intrinsic_wo_chain:{ *:[v2i64] } 4235:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2i64] }:$ws, (timm:{ *:[i32] })<<P:Predicate_timmZExt6>>:$m)  =>  (SRARI_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, (timm:{ *:[i32] }):$m)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SRARI_D,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // m
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 972,
        GIR_Done,
      // Label 470: @12233
      GIM_Try, /*On fail goto*//*Label 471*/ 12280, // Rule ID 985 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_srlri_b,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128BRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128BRegClassID,
        // MIs[0] m
        GIM_CheckIsImm, /*MI*/0, /*Op*/3,
        // (intrinsic_wo_chain:{ *:[v16i8] } 4250:{ *:[iPTR] }, MSA128BOpnd:{ *:[v16i8] }:$ws, (timm:{ *:[i32] })<<P:Predicate_timmZExt3>>:$m)  =>  (SRLRI_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, (timm:{ *:[i32] }):$m)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SRLRI_B,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // m
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 985,
        GIR_Done,
      // Label 471: @12280
      GIM_Try, /*On fail goto*//*Label 472*/ 12327, // Rule ID 986 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_srlri_h,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128HRegClassID,
        // MIs[0] m
        GIM_CheckIsImm, /*MI*/0, /*Op*/3,
        // (intrinsic_wo_chain:{ *:[v8i16] } 4252:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$ws, (timm:{ *:[i32] })<<P:Predicate_timmZExt4>>:$m)  =>  (SRLRI_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, (timm:{ *:[i32] }):$m)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SRLRI_H,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // m
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 986,
        GIR_Done,
      // Label 472: @12327
      GIM_Try, /*On fail goto*//*Label 473*/ 12374, // Rule ID 987 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_srlri_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128WRegClassID,
        // MIs[0] m
        GIM_CheckIsImm, /*MI*/0, /*Op*/3,
        // (intrinsic_wo_chain:{ *:[v4i32] } 4253:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$ws, (timm:{ *:[i32] })<<P:Predicate_timmZExt5>>:$m)  =>  (SRLRI_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, (timm:{ *:[i32] }):$m)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SRLRI_W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // m
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 987,
        GIR_Done,
      // Label 473: @12374
      GIM_Try, /*On fail goto*//*Label 474*/ 12421, // Rule ID 988 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_srlri_d,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128DRegClassID,
        // MIs[0] m
        GIM_CheckIsImm, /*MI*/0, /*Op*/3,
        // (intrinsic_wo_chain:{ *:[v2i64] } 4251:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2i64] }:$ws, (timm:{ *:[i32] })<<P:Predicate_timmZExt6>>:$m)  =>  (SRLRI_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, (timm:{ *:[i32] }):$m)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SRLRI_D,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // m
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 988,
        GIR_Done,
      // Label 474: @12421
      GIM_Try, /*On fail goto*//*Label 475*/ 12476, // Rule ID 1893 //
        GIM_CheckFeatures, GIFBS_HasDSP,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_shra_ph,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_immZExt4,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_wo_chain:{ *:[v2i16] } 4191:{ *:[iPTR] }, v2i16:{ *:[v2i16] }:$a, (imm:{ *:[i32] })<<P:Predicate_immZExt4>>:$shamt)  =>  (SHRA_PH:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$a, (imm:{ *:[i32] })<<P:Predicate_immZExt4>>:$shamt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SHRA_PH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // a
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // shamt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1893,
        GIR_Done,
      // Label 475: @12476
      GIM_Try, /*On fail goto*//*Label 476*/ 12531, // Rule ID 1894 //
        GIM_CheckFeatures, GIFBS_HasDSPR2,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_shrl_ph,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_immZExt4,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_wo_chain:{ *:[v2i16] } 4196:{ *:[iPTR] }, v2i16:{ *:[v2i16] }:$a, (imm:{ *:[i32] })<<P:Predicate_immZExt4>>:$shamt)  =>  (SHRL_PH:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$a, (imm:{ *:[i32] })<<P:Predicate_immZExt4>>:$shamt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SHRL_PH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // a
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // shamt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1894,
        GIR_Done,
      // Label 476: @12531
      GIM_Try, /*On fail goto*//*Label 477*/ 12586, // Rule ID 1899 //
        GIM_CheckFeatures, GIFBS_HasDSPR2,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_shra_qb,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_immZExt3,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_wo_chain:{ *:[v4i8] } 4192:{ *:[iPTR] }, v4i8:{ *:[v4i8] }:$a, (imm:{ *:[i32] })<<P:Predicate_immZExt3>>:$shamt)  =>  (SHRA_QB:{ *:[v4i8] } v4i8:{ *:[v4i8] }:$a, (imm:{ *:[i32] })<<P:Predicate_immZExt3>>:$shamt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SHRA_QB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // a
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // shamt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1899,
        GIR_Done,
      // Label 477: @12586
      GIM_Try, /*On fail goto*//*Label 478*/ 12641, // Rule ID 1900 //
        GIM_CheckFeatures, GIFBS_HasDSP,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_shrl_qb,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_immZExt3,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_wo_chain:{ *:[v4i8] } 4197:{ *:[iPTR] }, v4i8:{ *:[v4i8] }:$a, (imm:{ *:[i32] })<<P:Predicate_immZExt3>>:$shamt)  =>  (SHRL_QB:{ *:[v4i8] } v4i8:{ *:[v4i8] }:$a, (imm:{ *:[i32] })<<P:Predicate_immZExt3>>:$shamt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SHRL_QB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // a
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // shamt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1900,
        GIR_Done,
      // Label 478: @12641
      GIM_Try, /*On fail goto*//*Label 479*/ 12693, // Rule ID 343 //
        GIM_CheckFeatures, GIFBS_HasDSP,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_addu_s_qb,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i8] } 3665:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (ADDU_S_QB:{ *:[v4i8] } DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::ADDU_S_QB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 343,
        GIR_Done,
      // Label 479: @12693
      GIM_Try, /*On fail goto*//*Label 480*/ 12745, // Rule ID 344 //
        GIM_CheckFeatures, GIFBS_HasDSP,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_subu_s_qb,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i8] } 4284:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (SUBU_S_QB:{ *:[v4i8] } DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SUBU_S_QB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 344,
        GIR_Done,
      // Label 480: @12745
      GIM_Try, /*On fail goto*//*Label 481*/ 12797, // Rule ID 345 //
        GIM_CheckFeatures, GIFBS_HasDSP,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_addq_s_ph,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i16] } 3643:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (ADDQ_S_PH:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::ADDQ_S_PH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 345,
        GIR_Done,
      // Label 481: @12797
      GIM_Try, /*On fail goto*//*Label 482*/ 12849, // Rule ID 346 //
        GIM_CheckFeatures, GIFBS_HasDSP,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_subq_s_ph,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i16] } 4259:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (SUBQ_S_PH:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SUBQ_S_PH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 346,
        GIR_Done,
      // Label 482: @12849
      GIM_Try, /*On fail goto*//*Label 483*/ 12901, // Rule ID 349 //
        GIM_CheckFeatures, GIFBS_HasDSP,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_modsub,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::GPR32RegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 4091:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (MODSUB:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::MODSUB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 349,
        GIR_Done,
      // Label 483: @12901
      GIM_Try, /*On fail goto*//*Label 484*/ 12953, // Rule ID 353 //
        GIM_CheckFeatures, GIFBS_HasDSP,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_precrq_qb_ph,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i8] } 4167:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (PRECRQ_QB_PH:{ *:[v4i8] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::PRECRQ_QB_PH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 353,
        GIR_Done,
      // Label 484: @12953
      GIM_Try, /*On fail goto*//*Label 485*/ 13005, // Rule ID 354 //
        GIM_CheckFeatures, GIFBS_HasDSP,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_precrq_ph_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::GPR32RegClassID,
        // (intrinsic_wo_chain:{ *:[v2i16] } 4166:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (PRECRQ_PH_W:{ *:[v2i16] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::PRECRQ_PH_W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 354,
        GIR_Done,
      // Label 485: @13005
      GIM_Try, /*On fail goto*//*Label 486*/ 13057, // Rule ID 368 //
        GIM_CheckFeatures, GIFBS_HasDSP,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_shrl_qb,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::GPR32RegClassID,
        // (intrinsic_wo_chain:{ *:[v4i8] } 4197:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rt, GPR32Opnd:{ *:[i32] }:$rs_sa)  =>  (SHRLV_QB:{ *:[v4i8] } DSPROpnd:{ *:[v4i8] }:$rt, GPR32Opnd:{ *:[i32] }:$rs_sa)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SHRLV_QB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rs_sa
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 368,
        GIR_Done,
      // Label 486: @13057
      GIM_Try, /*On fail goto*//*Label 487*/ 13109, // Rule ID 372 //
        GIM_CheckFeatures, GIFBS_HasDSP,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_shra_ph,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::GPR32RegClassID,
        // (intrinsic_wo_chain:{ *:[v2i16] } 4191:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rt, GPR32Opnd:{ *:[i32] }:$rs_sa)  =>  (SHRAV_PH:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rt, GPR32Opnd:{ *:[i32] }:$rs_sa)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SHRAV_PH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rs_sa
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 372,
        GIR_Done,
      // Label 487: @13109
      GIM_Try, /*On fail goto*//*Label 488*/ 13161, // Rule ID 374 //
        GIM_CheckFeatures, GIFBS_HasDSP,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_shra_r_ph,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::GPR32RegClassID,
        // (intrinsic_wo_chain:{ *:[v2i16] } 4193:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rt, GPR32Opnd:{ *:[i32] }:$rs_sa)  =>  (SHRAV_R_PH:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rt, GPR32Opnd:{ *:[i32] }:$rs_sa)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SHRAV_R_PH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rs_sa
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 374,
        GIR_Done,
      // Label 488: @13161
      GIM_Try, /*On fail goto*//*Label 489*/ 13213, // Rule ID 378 //
        GIM_CheckFeatures, GIFBS_HasDSP,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_shra_r_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::GPR32RegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 4195:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rt, GPR32Opnd:{ *:[i32] }:$rs_sa)  =>  (SHRAV_R_W:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rt, GPR32Opnd:{ *:[i32] }:$rs_sa)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SHRAV_R_W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rs_sa
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 378,
        GIR_Done,
      // Label 489: @13213
      GIM_Try, /*On fail goto*//*Label 490*/ 13265, // Rule ID 415 //
        GIM_CheckFeatures, GIFBS_HasDSP,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_packrl_ph,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i16] } 4138:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (PACKRL_PH:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::PACKRL_PH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 415,
        GIR_Done,
      // Label 490: @13265
      GIM_Try, /*On fail goto*//*Label 491*/ 13317, // Rule ID 439 //
        GIM_CheckFeatures, GIFBS_HasDSPR2,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_adduh_qb,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i8] } 3666:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (ADDUH_QB:{ *:[v4i8] } DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::ADDUH_QB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 439,
        GIR_Done,
      // Label 491: @13317
      GIM_Try, /*On fail goto*//*Label 492*/ 13369, // Rule ID 440 //
        GIM_CheckFeatures, GIFBS_HasDSPR2,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_adduh_r_qb,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i8] } 3667:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (ADDUH_R_QB:{ *:[v4i8] } DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::ADDUH_R_QB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 440,
        GIR_Done,
      // Label 492: @13369
      GIM_Try, /*On fail goto*//*Label 493*/ 13421, // Rule ID 441 //
        GIM_CheckFeatures, GIFBS_HasDSPR2,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_subuh_qb,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i8] } 4285:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (SUBUH_QB:{ *:[v4i8] } DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SUBUH_QB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 441,
        GIR_Done,
      // Label 493: @13421
      GIM_Try, /*On fail goto*//*Label 494*/ 13473, // Rule ID 442 //
        GIM_CheckFeatures, GIFBS_HasDSPR2,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_subuh_r_qb,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i8] } 4286:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (SUBUH_R_QB:{ *:[v4i8] } DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SUBUH_R_QB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 442,
        GIR_Done,
      // Label 494: @13473
      GIM_Try, /*On fail goto*//*Label 495*/ 13525, // Rule ID 443 //
        GIM_CheckFeatures, GIFBS_HasDSPR2,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_addqh_ph,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i16] } 3645:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (ADDQH_PH:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::ADDQH_PH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 443,
        GIR_Done,
      // Label 495: @13525
      GIM_Try, /*On fail goto*//*Label 496*/ 13577, // Rule ID 444 //
        GIM_CheckFeatures, GIFBS_HasDSPR2,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_addqh_r_ph,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i16] } 3646:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (ADDQH_R_PH:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::ADDQH_R_PH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 444,
        GIR_Done,
      // Label 496: @13577
      GIM_Try, /*On fail goto*//*Label 497*/ 13629, // Rule ID 445 //
        GIM_CheckFeatures, GIFBS_HasDSPR2,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_subqh_ph,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i16] } 4261:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (SUBQH_PH:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SUBQH_PH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 445,
        GIR_Done,
      // Label 497: @13629
      GIM_Try, /*On fail goto*//*Label 498*/ 13681, // Rule ID 446 //
        GIM_CheckFeatures, GIFBS_HasDSPR2,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_subqh_r_ph,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i16] } 4262:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (SUBQH_R_PH:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SUBQH_R_PH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 446,
        GIR_Done,
      // Label 498: @13681
      GIM_Try, /*On fail goto*//*Label 499*/ 13733, // Rule ID 447 //
        GIM_CheckFeatures, GIFBS_HasDSPR2,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_addqh_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::GPR32RegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 3648:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (ADDQH_W:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::ADDQH_W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 447,
        GIR_Done,
      // Label 499: @13733
      GIM_Try, /*On fail goto*//*Label 500*/ 13785, // Rule ID 448 //
        GIM_CheckFeatures, GIFBS_HasDSPR2,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_addqh_r_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::GPR32RegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 3647:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (ADDQH_R_W:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::ADDQH_R_W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 448,
        GIR_Done,
      // Label 500: @13785
      GIM_Try, /*On fail goto*//*Label 501*/ 13837, // Rule ID 449 //
        GIM_CheckFeatures, GIFBS_HasDSPR2,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_subqh_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::GPR32RegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 4264:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (SUBQH_W:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SUBQH_W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 449,
        GIR_Done,
      // Label 501: @13837
      GIM_Try, /*On fail goto*//*Label 502*/ 13889, // Rule ID 450 //
        GIM_CheckFeatures, GIFBS_HasDSPR2,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_subqh_r_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::GPR32RegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 4263:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (SUBQH_R_W:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SUBQH_R_W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 450,
        GIR_Done,
      // Label 502: @13889
      GIM_Try, /*On fail goto*//*Label 503*/ 13941, // Rule ID 467 //
        GIM_CheckFeatures, GIFBS_HasDSPR2,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_shra_qb,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::GPR32RegClassID,
        // (intrinsic_wo_chain:{ *:[v4i8] } 4192:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rt, GPR32Opnd:{ *:[i32] }:$rs_sa)  =>  (SHRAV_QB:{ *:[v4i8] } DSPROpnd:{ *:[v4i8] }:$rt, GPR32Opnd:{ *:[i32] }:$rs_sa)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SHRAV_QB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rs_sa
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 467,
        GIR_Done,
      // Label 503: @13941
      GIM_Try, /*On fail goto*//*Label 504*/ 13993, // Rule ID 469 //
        GIM_CheckFeatures, GIFBS_HasDSPR2,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_shra_r_qb,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::GPR32RegClassID,
        // (intrinsic_wo_chain:{ *:[v4i8] } 4194:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rt, GPR32Opnd:{ *:[i32] }:$rs_sa)  =>  (SHRAV_R_QB:{ *:[v4i8] } DSPROpnd:{ *:[v4i8] }:$rt, GPR32Opnd:{ *:[i32] }:$rs_sa)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SHRAV_R_QB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rs_sa
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 469,
        GIR_Done,
      // Label 504: @13993
      GIM_Try, /*On fail goto*//*Label 505*/ 14045, // Rule ID 470 //
        GIM_CheckFeatures, GIFBS_HasDSPR2,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_shrl_ph,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::GPR32RegClassID,
        // (intrinsic_wo_chain:{ *:[v2i16] } 4196:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rt, GPR32Opnd:{ *:[i32] }:$rs_sa)  =>  (SHRLV_PH:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rt, GPR32Opnd:{ *:[i32] }:$rs_sa)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SHRLV_PH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rs_sa
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 470,
        GIR_Done,
      // Label 505: @14045
      GIM_Try, /*On fail goto*//*Label 506*/ 14097, // Rule ID 475 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_add_a_b,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128BRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128BRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128BRegClassID,
        // (intrinsic_wo_chain:{ *:[v16i8] } 3638:{ *:[iPTR] }, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (ADD_A_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::ADD_A_B,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 475,
        GIR_Done,
      // Label 506: @14097
      GIM_Try, /*On fail goto*//*Label 507*/ 14149, // Rule ID 476 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_add_a_h,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128HRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 3640:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (ADD_A_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::ADD_A_H,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 476,
        GIR_Done,
      // Label 507: @14149
      GIM_Try, /*On fail goto*//*Label 508*/ 14201, // Rule ID 477 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_add_a_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128WRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 3641:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (ADD_A_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::ADD_A_W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 477,
        GIR_Done,
      // Label 508: @14201
      GIM_Try, /*On fail goto*//*Label 509*/ 14253, // Rule ID 478 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_add_a_d,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128DRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 3639:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)  =>  (ADD_A_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::ADD_A_D,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 478,
        GIR_Done,
      // Label 509: @14253
      GIM_Try, /*On fail goto*//*Label 510*/ 14305, // Rule ID 479 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_adds_a_b,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128BRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128BRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128BRegClassID,
        // (intrinsic_wo_chain:{ *:[v16i8] } 3649:{ *:[iPTR] }, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (ADDS_A_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::ADDS_A_B,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 479,
        GIR_Done,
      // Label 510: @14305
      GIM_Try, /*On fail goto*//*Label 511*/ 14357, // Rule ID 480 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_adds_a_h,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128HRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 3651:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (ADDS_A_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::ADDS_A_H,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 480,
        GIR_Done,
      // Label 511: @14357
      GIM_Try, /*On fail goto*//*Label 512*/ 14409, // Rule ID 481 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_adds_a_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128WRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 3652:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (ADDS_A_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::ADDS_A_W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 481,
        GIR_Done,
      // Label 512: @14409
      GIM_Try, /*On fail goto*//*Label 513*/ 14461, // Rule ID 482 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_adds_a_d,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128DRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 3650:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)  =>  (ADDS_A_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::ADDS_A_D,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 482,
        GIR_Done,
      // Label 513: @14461
      GIM_Try, /*On fail goto*//*Label 514*/ 14513, // Rule ID 483 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_adds_s_b,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128BRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128BRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128BRegClassID,
        // (intrinsic_wo_chain:{ *:[v16i8] } 3653:{ *:[iPTR] }, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (ADDS_S_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::ADDS_S_B,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 483,
        GIR_Done,
      // Label 514: @14513
      GIM_Try, /*On fail goto*//*Label 515*/ 14565, // Rule ID 484 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_adds_s_h,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128HRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 3655:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (ADDS_S_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::ADDS_S_H,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 484,
        GIR_Done,
      // Label 515: @14565
      GIM_Try, /*On fail goto*//*Label 516*/ 14617, // Rule ID 485 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_adds_s_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128WRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 3656:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (ADDS_S_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::ADDS_S_W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 485,
        GIR_Done,
      // Label 516: @14617
      GIM_Try, /*On fail goto*//*Label 517*/ 14669, // Rule ID 486 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_adds_s_d,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128DRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 3654:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)  =>  (ADDS_S_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::ADDS_S_D,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 486,
        GIR_Done,
      // Label 517: @14669
      GIM_Try, /*On fail goto*//*Label 518*/ 14721, // Rule ID 487 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_adds_u_b,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128BRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128BRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128BRegClassID,
        // (intrinsic_wo_chain:{ *:[v16i8] } 3657:{ *:[iPTR] }, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (ADDS_U_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::ADDS_U_B,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 487,
        GIR_Done,
      // Label 518: @14721
      GIM_Try, /*On fail goto*//*Label 519*/ 14773, // Rule ID 488 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_adds_u_h,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128HRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 3659:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (ADDS_U_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::ADDS_U_H,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 488,
        GIR_Done,
      // Label 519: @14773
      GIM_Try, /*On fail goto*//*Label 520*/ 14825, // Rule ID 489 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_adds_u_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128WRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 3660:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (ADDS_U_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::ADDS_U_W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 489,
        GIR_Done,
      // Label 520: @14825
      GIM_Try, /*On fail goto*//*Label 521*/ 14877, // Rule ID 490 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_adds_u_d,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128DRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 3658:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)  =>  (ADDS_U_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::ADDS_U_D,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 490,
        GIR_Done,
      // Label 521: @14877
      GIM_Try, /*On fail goto*//*Label 522*/ 14929, // Rule ID 504 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_asub_s_b,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128BRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128BRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128BRegClassID,
        // (intrinsic_wo_chain:{ *:[v16i8] } 3680:{ *:[iPTR] }, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (ASUB_S_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::ASUB_S_B,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 504,
        GIR_Done,
      // Label 522: @14929
      GIM_Try, /*On fail goto*//*Label 523*/ 14981, // Rule ID 505 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_asub_s_h,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128HRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 3682:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (ASUB_S_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::ASUB_S_H,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 505,
        GIR_Done,
      // Label 523: @14981
      GIM_Try, /*On fail goto*//*Label 524*/ 15033, // Rule ID 506 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_asub_s_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128WRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 3683:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (ASUB_S_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::ASUB_S_W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 506,
        GIR_Done,
      // Label 524: @15033
      GIM_Try, /*On fail goto*//*Label 525*/ 15085, // Rule ID 507 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_asub_s_d,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128DRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 3681:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)  =>  (ASUB_S_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::ASUB_S_D,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 507,
        GIR_Done,
      // Label 525: @15085
      GIM_Try, /*On fail goto*//*Label 526*/ 15137, // Rule ID 508 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_asub_u_b,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128BRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128BRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128BRegClassID,
        // (intrinsic_wo_chain:{ *:[v16i8] } 3684:{ *:[iPTR] }, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (ASUB_U_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::ASUB_U_B,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 508,
        GIR_Done,
      // Label 526: @15137
      GIM_Try, /*On fail goto*//*Label 527*/ 15189, // Rule ID 509 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_asub_u_h,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128HRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 3686:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (ASUB_U_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::ASUB_U_H,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 509,
        GIR_Done,
      // Label 527: @15189
      GIM_Try, /*On fail goto*//*Label 528*/ 15241, // Rule ID 510 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_asub_u_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128WRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 3687:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (ASUB_U_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::ASUB_U_W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 510,
        GIR_Done,
      // Label 528: @15241
      GIM_Try, /*On fail goto*//*Label 529*/ 15293, // Rule ID 511 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_asub_u_d,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128DRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 3685:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)  =>  (ASUB_U_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::ASUB_U_D,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 511,
        GIR_Done,
      // Label 529: @15293
      GIM_Try, /*On fail goto*//*Label 530*/ 15345, // Rule ID 512 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_ave_s_b,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128BRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128BRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128BRegClassID,
        // (intrinsic_wo_chain:{ *:[v16i8] } 3688:{ *:[iPTR] }, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (AVE_S_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::AVE_S_B,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 512,
        GIR_Done,
      // Label 530: @15345
      GIM_Try, /*On fail goto*//*Label 531*/ 15397, // Rule ID 513 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_ave_s_h,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128HRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 3690:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (AVE_S_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::AVE_S_H,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 513,
        GIR_Done,
      // Label 531: @15397
      GIM_Try, /*On fail goto*//*Label 532*/ 15449, // Rule ID 514 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_ave_s_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128WRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 3691:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (AVE_S_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::AVE_S_W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 514,
        GIR_Done,
      // Label 532: @15449
      GIM_Try, /*On fail goto*//*Label 533*/ 15501, // Rule ID 515 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_ave_s_d,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128DRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 3689:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)  =>  (AVE_S_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::AVE_S_D,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 515,
        GIR_Done,
      // Label 533: @15501
      GIM_Try, /*On fail goto*//*Label 534*/ 15553, // Rule ID 516 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_ave_u_b,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128BRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128BRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128BRegClassID,
        // (intrinsic_wo_chain:{ *:[v16i8] } 3692:{ *:[iPTR] }, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (AVE_U_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::AVE_U_B,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 516,
        GIR_Done,
      // Label 534: @15553
      GIM_Try, /*On fail goto*//*Label 535*/ 15605, // Rule ID 517 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_ave_u_h,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128HRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 3694:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (AVE_U_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::AVE_U_H,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 517,
        GIR_Done,
      // Label 535: @15605
      GIM_Try, /*On fail goto*//*Label 536*/ 15657, // Rule ID 518 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_ave_u_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128WRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 3695:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (AVE_U_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::AVE_U_W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 518,
        GIR_Done,
      // Label 536: @15657
      GIM_Try, /*On fail goto*//*Label 537*/ 15709, // Rule ID 519 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_ave_u_d,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128DRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 3693:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)  =>  (AVE_U_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::AVE_U_D,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 519,
        GIR_Done,
      // Label 537: @15709
      GIM_Try, /*On fail goto*//*Label 538*/ 15761, // Rule ID 520 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_aver_s_b,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128BRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128BRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128BRegClassID,
        // (intrinsic_wo_chain:{ *:[v16i8] } 3696:{ *:[iPTR] }, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (AVER_S_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::AVER_S_B,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 520,
        GIR_Done,
      // Label 538: @15761
      GIM_Try, /*On fail goto*//*Label 539*/ 15813, // Rule ID 521 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_aver_s_h,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128HRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 3698:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (AVER_S_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::AVER_S_H,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 521,
        GIR_Done,
      // Label 539: @15813
      GIM_Try, /*On fail goto*//*Label 540*/ 15865, // Rule ID 522 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_aver_s_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128WRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 3699:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (AVER_S_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::AVER_S_W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 522,
        GIR_Done,
      // Label 540: @15865
      GIM_Try, /*On fail goto*//*Label 541*/ 15917, // Rule ID 523 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_aver_s_d,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128DRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 3697:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)  =>  (AVER_S_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::AVER_S_D,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 523,
        GIR_Done,
      // Label 541: @15917
      GIM_Try, /*On fail goto*//*Label 542*/ 15969, // Rule ID 524 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_aver_u_b,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128BRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128BRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128BRegClassID,
        // (intrinsic_wo_chain:{ *:[v16i8] } 3700:{ *:[iPTR] }, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (AVER_U_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::AVER_U_B,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 524,
        GIR_Done,
      // Label 542: @15969
      GIM_Try, /*On fail goto*//*Label 543*/ 16021, // Rule ID 525 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_aver_u_h,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128HRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 3702:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (AVER_U_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::AVER_U_H,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 525,
        GIR_Done,
      // Label 543: @16021
      GIM_Try, /*On fail goto*//*Label 544*/ 16073, // Rule ID 526 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_aver_u_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128WRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 3703:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (AVER_U_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::AVER_U_W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 526,
        GIR_Done,
      // Label 544: @16073
      GIM_Try, /*On fail goto*//*Label 545*/ 16125, // Rule ID 527 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_aver_u_d,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128DRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 3701:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)  =>  (AVER_U_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::AVER_U_D,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 527,
        GIR_Done,
      // Label 545: @16125
      GIM_Try, /*On fail goto*//*Label 546*/ 16177, // Rule ID 636 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_dotp_s_h,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128BRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128BRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 3835:{ *:[iPTR] }, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (DOTP_S_H:{ *:[v8i16] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::DOTP_S_H,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 636,
        GIR_Done,
      // Label 546: @16177
      GIM_Try, /*On fail goto*//*Label 547*/ 16229, // Rule ID 637 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_dotp_s_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128HRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 3836:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (DOTP_S_W:{ *:[v4i32] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::DOTP_S_W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 637,
        GIR_Done,
      // Label 547: @16229
      GIM_Try, /*On fail goto*//*Label 548*/ 16281, // Rule ID 638 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_dotp_s_d,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128WRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 3834:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (DOTP_S_D:{ *:[v2i64] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::DOTP_S_D,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 638,
        GIR_Done,
      // Label 548: @16281
      GIM_Try, /*On fail goto*//*Label 549*/ 16333, // Rule ID 639 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_dotp_u_h,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128BRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128BRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 3838:{ *:[iPTR] }, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (DOTP_U_H:{ *:[v8i16] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::DOTP_U_H,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 639,
        GIR_Done,
      // Label 549: @16333
      GIM_Try, /*On fail goto*//*Label 550*/ 16385, // Rule ID 640 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_dotp_u_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128HRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 3839:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (DOTP_U_W:{ *:[v4i32] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::DOTP_U_W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 640,
        GIR_Done,
      // Label 550: @16385
      GIM_Try, /*On fail goto*//*Label 551*/ 16437, // Rule ID 641 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_dotp_u_d,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128WRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 3837:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (DOTP_U_D:{ *:[v2i64] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::DOTP_U_D,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 641,
        GIR_Done,
      // Label 551: @16437
      GIM_Try, /*On fail goto*//*Label 552*/ 16489, // Rule ID 656 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_fcaf_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128WRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 3877:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)  =>  (FCAF_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::FCAF_W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 656,
        GIR_Done,
      // Label 552: @16489
      GIM_Try, /*On fail goto*//*Label 553*/ 16541, // Rule ID 657 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_fcaf_d,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128DRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 3876:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)  =>  (FCAF_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::FCAF_D,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 657,
        GIR_Done,
      // Label 553: @16541
      GIM_Try, /*On fail goto*//*Label 554*/ 16593, // Rule ID 682 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_fexdo_h,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128WRegClassID,
        // (intrinsic_wo_chain:{ *:[v8f16] } 3902:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)  =>  (FEXDO_H:{ *:[v8f16] } MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::FEXDO_H,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 682,
        GIR_Done,
      // Label 554: @16593
      GIM_Try, /*On fail goto*//*Label 555*/ 16645, // Rule ID 683 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_fexdo_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128DRegClassID,
        // (intrinsic_wo_chain:{ *:[v4f32] } 3903:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)  =>  (FEXDO_W:{ *:[v4f32] } MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::FEXDO_W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 683,
        GIR_Done,
      // Label 555: @16645
      GIM_Try, /*On fail goto*//*Label 556*/ 16697, // Rule ID 710 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_fmax_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128WRegClassID,
        // (intrinsic_wo_chain:{ *:[v4f32] } 3929:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)  =>  (FMAX_W:{ *:[v4f32] } MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::FMAX_W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 710,
        GIR_Done,
      // Label 556: @16697
      GIM_Try, /*On fail goto*//*Label 557*/ 16749, // Rule ID 711 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_fmax_d,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128DRegClassID,
        // (intrinsic_wo_chain:{ *:[v2f64] } 3928:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)  =>  (FMAX_D:{ *:[v2f64] } MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::FMAX_D,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 711,
        GIR_Done,
      // Label 557: @16749
      GIM_Try, /*On fail goto*//*Label 558*/ 16801, // Rule ID 712 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_fmax_a_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128WRegClassID,
        // (intrinsic_wo_chain:{ *:[v4f32] } 3927:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)  =>  (FMAX_A_W:{ *:[v4f32] } MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::FMAX_A_W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 712,
        GIR_Done,
      // Label 558: @16801
      GIM_Try, /*On fail goto*//*Label 559*/ 16853, // Rule ID 713 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_fmax_a_d,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128DRegClassID,
        // (intrinsic_wo_chain:{ *:[v2f64] } 3926:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)  =>  (FMAX_A_D:{ *:[v2f64] } MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::FMAX_A_D,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 713,
        GIR_Done,
      // Label 559: @16853
      GIM_Try, /*On fail goto*//*Label 560*/ 16905, // Rule ID 714 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_fmin_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128WRegClassID,
        // (intrinsic_wo_chain:{ *:[v4f32] } 3933:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)  =>  (FMIN_W:{ *:[v4f32] } MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::FMIN_W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 714,
        GIR_Done,
      // Label 560: @16905
      GIM_Try, /*On fail goto*//*Label 561*/ 16957, // Rule ID 715 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_fmin_d,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128DRegClassID,
        // (intrinsic_wo_chain:{ *:[v2f64] } 3932:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)  =>  (FMIN_D:{ *:[v2f64] } MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::FMIN_D,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 715,
        GIR_Done,
      // Label 561: @16957
      GIM_Try, /*On fail goto*//*Label 562*/ 17009, // Rule ID 716 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_fmin_a_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128WRegClassID,
        // (intrinsic_wo_chain:{ *:[v4f32] } 3931:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)  =>  (FMIN_A_W:{ *:[v4f32] } MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::FMIN_A_W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 716,
        GIR_Done,
      // Label 562: @17009
      GIM_Try, /*On fail goto*//*Label 563*/ 17061, // Rule ID 717 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_fmin_a_d,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128DRegClassID,
        // (intrinsic_wo_chain:{ *:[v2f64] } 3930:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)  =>  (FMIN_A_D:{ *:[v2f64] } MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::FMIN_A_D,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 717,
        GIR_Done,
      // Label 563: @17061
      GIM_Try, /*On fail goto*//*Label 564*/ 17113, // Rule ID 728 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_fsaf_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128WRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 3945:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)  =>  (FSAF_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::FSAF_W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 728,
        GIR_Done,
      // Label 564: @17113
      GIM_Try, /*On fail goto*//*Label 565*/ 17165, // Rule ID 729 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_fsaf_d,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128DRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 3944:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)  =>  (FSAF_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::FSAF_D,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 729,
        GIR_Done,
      // Label 565: @17165
      GIM_Try, /*On fail goto*//*Label 566*/ 17217, // Rule ID 730 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_fseq_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128WRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 3947:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)  =>  (FSEQ_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::FSEQ_W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 730,
        GIR_Done,
      // Label 566: @17217
      GIM_Try, /*On fail goto*//*Label 567*/ 17269, // Rule ID 731 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_fseq_d,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128DRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 3946:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)  =>  (FSEQ_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::FSEQ_D,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 731,
        GIR_Done,
      // Label 567: @17269
      GIM_Try, /*On fail goto*//*Label 568*/ 17321, // Rule ID 732 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_fsle_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128WRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 3949:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)  =>  (FSLE_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::FSLE_W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 732,
        GIR_Done,
      // Label 568: @17321
      GIM_Try, /*On fail goto*//*Label 569*/ 17373, // Rule ID 733 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_fsle_d,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128DRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 3948:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)  =>  (FSLE_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::FSLE_D,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 733,
        GIR_Done,
      // Label 569: @17373
      GIM_Try, /*On fail goto*//*Label 570*/ 17425, // Rule ID 734 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_fslt_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128WRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 3951:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)  =>  (FSLT_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::FSLT_W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 734,
        GIR_Done,
      // Label 570: @17425
      GIM_Try, /*On fail goto*//*Label 571*/ 17477, // Rule ID 735 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_fslt_d,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128DRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 3950:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)  =>  (FSLT_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::FSLT_D,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 735,
        GIR_Done,
      // Label 571: @17477
      GIM_Try, /*On fail goto*//*Label 572*/ 17529, // Rule ID 736 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_fsne_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128WRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 3953:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)  =>  (FSNE_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::FSNE_W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 736,
        GIR_Done,
      // Label 572: @17529
      GIM_Try, /*On fail goto*//*Label 573*/ 17581, // Rule ID 737 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_fsne_d,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128DRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 3952:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)  =>  (FSNE_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::FSNE_D,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 737,
        GIR_Done,
      // Label 573: @17581
      GIM_Try, /*On fail goto*//*Label 574*/ 17633, // Rule ID 738 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_fsor_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128WRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 3955:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)  =>  (FSOR_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::FSOR_W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 738,
        GIR_Done,
      // Label 574: @17633
      GIM_Try, /*On fail goto*//*Label 575*/ 17685, // Rule ID 739 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_fsor_d,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128DRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 3954:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)  =>  (FSOR_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::FSOR_D,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 739,
        GIR_Done,
      // Label 575: @17685
      GIM_Try, /*On fail goto*//*Label 576*/ 17737, // Rule ID 744 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_fsueq_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128WRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 3961:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)  =>  (FSUEQ_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::FSUEQ_W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 744,
        GIR_Done,
      // Label 576: @17737
      GIM_Try, /*On fail goto*//*Label 577*/ 17789, // Rule ID 745 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_fsueq_d,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128DRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 3960:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)  =>  (FSUEQ_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::FSUEQ_D,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 745,
        GIR_Done,
      // Label 577: @17789
      GIM_Try, /*On fail goto*//*Label 578*/ 17841, // Rule ID 746 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_fsule_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128WRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 3963:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)  =>  (FSULE_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::FSULE_W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 746,
        GIR_Done,
      // Label 578: @17841
      GIM_Try, /*On fail goto*//*Label 579*/ 17893, // Rule ID 747 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_fsule_d,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128DRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 3962:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)  =>  (FSULE_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::FSULE_D,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 747,
        GIR_Done,
      // Label 579: @17893
      GIM_Try, /*On fail goto*//*Label 580*/ 17945, // Rule ID 748 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_fsult_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128WRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 3965:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)  =>  (FSULT_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::FSULT_W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 748,
        GIR_Done,
      // Label 580: @17945
      GIM_Try, /*On fail goto*//*Label 581*/ 17997, // Rule ID 749 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_fsult_d,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128DRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 3964:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)  =>  (FSULT_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::FSULT_D,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 749,
        GIR_Done,
      // Label 581: @17997
      GIM_Try, /*On fail goto*//*Label 582*/ 18049, // Rule ID 750 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_fsun_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128WRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 3967:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)  =>  (FSUN_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::FSUN_W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 750,
        GIR_Done,
      // Label 582: @18049
      GIM_Try, /*On fail goto*//*Label 583*/ 18101, // Rule ID 751 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_fsun_d,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128DRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 3966:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)  =>  (FSUN_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::FSUN_D,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 751,
        GIR_Done,
      // Label 583: @18101
      GIM_Try, /*On fail goto*//*Label 584*/ 18153, // Rule ID 752 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_fsune_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128WRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 3969:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)  =>  (FSUNE_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::FSUNE_W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 752,
        GIR_Done,
      // Label 584: @18153
      GIM_Try, /*On fail goto*//*Label 585*/ 18205, // Rule ID 753 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_fsune_d,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128DRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 3968:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)  =>  (FSUNE_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::FSUNE_D,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 753,
        GIR_Done,
      // Label 585: @18205
      GIM_Try, /*On fail goto*//*Label 586*/ 18257, // Rule ID 758 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_ftq_h,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128WRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 3974:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)  =>  (FTQ_H:{ *:[v8i16] } MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::FTQ_H,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 758,
        GIR_Done,
      // Label 586: @18257
      GIM_Try, /*On fail goto*//*Label 587*/ 18309, // Rule ID 759 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_ftq_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128DRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 3975:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)  =>  (FTQ_W:{ *:[v4i32] } MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::FTQ_W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 759,
        GIR_Done,
      // Label 587: @18309
      GIM_Try, /*On fail goto*//*Label 588*/ 18361, // Rule ID 764 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_hadd_s_h,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128BRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128BRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 3981:{ *:[iPTR] }, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (HADD_S_H:{ *:[v8i16] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::HADD_S_H,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 764,
        GIR_Done,
      // Label 588: @18361
      GIM_Try, /*On fail goto*//*Label 589*/ 18413, // Rule ID 765 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_hadd_s_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128HRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 3982:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (HADD_S_W:{ *:[v4i32] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::HADD_S_W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 765,
        GIR_Done,
      // Label 589: @18413
      GIM_Try, /*On fail goto*//*Label 590*/ 18465, // Rule ID 766 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_hadd_s_d,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128WRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 3980:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (HADD_S_D:{ *:[v2i64] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::HADD_S_D,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 766,
        GIR_Done,
      // Label 590: @18465
      GIM_Try, /*On fail goto*//*Label 591*/ 18517, // Rule ID 767 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_hadd_u_h,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128BRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128BRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 3984:{ *:[iPTR] }, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (HADD_U_H:{ *:[v8i16] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::HADD_U_H,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 767,
        GIR_Done,
      // Label 591: @18517
      GIM_Try, /*On fail goto*//*Label 592*/ 18569, // Rule ID 768 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_hadd_u_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128HRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 3985:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (HADD_U_W:{ *:[v4i32] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::HADD_U_W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 768,
        GIR_Done,
      // Label 592: @18569
      GIM_Try, /*On fail goto*//*Label 593*/ 18621, // Rule ID 769 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_hadd_u_d,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128WRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 3983:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (HADD_U_D:{ *:[v2i64] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::HADD_U_D,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 769,
        GIR_Done,
      // Label 593: @18621
      GIM_Try, /*On fail goto*//*Label 594*/ 18673, // Rule ID 770 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_hsub_s_h,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128BRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128BRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 3987:{ *:[iPTR] }, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (HSUB_S_H:{ *:[v8i16] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::HSUB_S_H,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 770,
        GIR_Done,
      // Label 594: @18673
      GIM_Try, /*On fail goto*//*Label 595*/ 18725, // Rule ID 771 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_hsub_s_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128HRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 3988:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (HSUB_S_W:{ *:[v4i32] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::HSUB_S_W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 771,
        GIR_Done,
      // Label 595: @18725
      GIM_Try, /*On fail goto*//*Label 596*/ 18777, // Rule ID 772 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_hsub_s_d,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128WRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 3986:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (HSUB_S_D:{ *:[v2i64] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::HSUB_S_D,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 772,
        GIR_Done,
      // Label 596: @18777
      GIM_Try, /*On fail goto*//*Label 597*/ 18829, // Rule ID 773 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_hsub_u_h,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128BRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128BRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 3990:{ *:[iPTR] }, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (HSUB_U_H:{ *:[v8i16] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::HSUB_U_H,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 773,
        GIR_Done,
      // Label 597: @18829
      GIM_Try, /*On fail goto*//*Label 598*/ 18881, // Rule ID 774 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_hsub_u_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128HRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 3991:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (HSUB_U_W:{ *:[v4i32] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::HSUB_U_W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 774,
        GIR_Done,
      // Label 598: @18881
      GIM_Try, /*On fail goto*//*Label 599*/ 18933, // Rule ID 775 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_hsub_u_d,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128WRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 3989:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (HSUB_U_D:{ *:[v2i64] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::HSUB_U_D,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 775,
        GIR_Done,
      // Label 599: @18933
      GIM_Try, /*On fail goto*//*Label 600*/ 18985, // Rule ID 828 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_max_a_b,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128BRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128BRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128BRegClassID,
        // (intrinsic_wo_chain:{ *:[v16i8] } 4043:{ *:[iPTR] }, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (MAX_A_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::MAX_A_B,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 828,
        GIR_Done,
      // Label 600: @18985
      GIM_Try, /*On fail goto*//*Label 601*/ 19037, // Rule ID 829 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_max_a_h,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128HRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 4045:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (MAX_A_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::MAX_A_H,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 829,
        GIR_Done,
      // Label 601: @19037
      GIM_Try, /*On fail goto*//*Label 602*/ 19089, // Rule ID 830 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_max_a_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128WRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 4046:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (MAX_A_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::MAX_A_W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 830,
        GIR_Done,
      // Label 602: @19089
      GIM_Try, /*On fail goto*//*Label 603*/ 19141, // Rule ID 831 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_max_a_d,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128DRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 4044:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)  =>  (MAX_A_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::MAX_A_D,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 831,
        GIR_Done,
      // Label 603: @19141
      GIM_Try, /*On fail goto*//*Label 604*/ 19193, // Rule ID 848 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_min_a_b,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128BRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128BRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128BRegClassID,
        // (intrinsic_wo_chain:{ *:[v16i8] } 4063:{ *:[iPTR] }, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (MIN_A_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::MIN_A_B,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 848,
        GIR_Done,
      // Label 604: @19193
      GIM_Try, /*On fail goto*//*Label 605*/ 19245, // Rule ID 849 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_min_a_h,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128HRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 4065:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (MIN_A_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::MIN_A_H,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 849,
        GIR_Done,
      // Label 605: @19245
      GIM_Try, /*On fail goto*//*Label 606*/ 19297, // Rule ID 850 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_min_a_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128WRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 4066:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (MIN_A_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::MIN_A_W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 850,
        GIR_Done,
      // Label 606: @19297
      GIM_Try, /*On fail goto*//*Label 607*/ 19349, // Rule ID 851 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_min_a_d,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128DRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 4064:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)  =>  (MIN_A_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::MIN_A_D,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 851,
        GIR_Done,
      // Label 607: @19349
      GIM_Try, /*On fail goto*//*Label 608*/ 19401, // Rule ID 884 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_mul_q_h,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128HRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 4105:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (MUL_Q_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::MUL_Q_H,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 884,
        GIR_Done,
      // Label 608: @19401
      GIM_Try, /*On fail goto*//*Label 609*/ 19453, // Rule ID 885 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_mul_q_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128WRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 4106:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (MUL_Q_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::MUL_Q_W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 885,
        GIR_Done,
      // Label 609: @19453
      GIM_Try, /*On fail goto*//*Label 610*/ 19505, // Rule ID 886 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_mulr_q_h,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128HRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 4116:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (MULR_Q_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::MULR_Q_H,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 886,
        GIR_Done,
      // Label 610: @19505
      GIM_Try, /*On fail goto*//*Label 611*/ 19557, // Rule ID 887 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_mulr_q_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128WRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 4117:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (MULR_Q_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::MULR_Q_W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 887,
        GIR_Done,
      // Label 611: @19557
      GIM_Try, /*On fail goto*//*Label 612*/ 19609, // Rule ID 965 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_srar_b,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128BRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128BRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128BRegClassID,
        // (intrinsic_wo_chain:{ *:[v16i8] } 4230:{ *:[iPTR] }, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (SRAR_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SRAR_B,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 965,
        GIR_Done,
      // Label 612: @19609
      GIM_Try, /*On fail goto*//*Label 613*/ 19661, // Rule ID 966 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_srar_h,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128HRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 4232:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (SRAR_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SRAR_H,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 966,
        GIR_Done,
      // Label 613: @19661
      GIM_Try, /*On fail goto*//*Label 614*/ 19713, // Rule ID 967 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_srar_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128WRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 4233:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (SRAR_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SRAR_W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 967,
        GIR_Done,
      // Label 614: @19713
      GIM_Try, /*On fail goto*//*Label 615*/ 19765, // Rule ID 968 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_srar_d,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128DRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 4231:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)  =>  (SRAR_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SRAR_D,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 968,
        GIR_Done,
      // Label 615: @19765
      GIM_Try, /*On fail goto*//*Label 616*/ 19817, // Rule ID 981 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_srlr_b,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128BRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128BRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128BRegClassID,
        // (intrinsic_wo_chain:{ *:[v16i8] } 4246:{ *:[iPTR] }, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (SRLR_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SRLR_B,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 981,
        GIR_Done,
      // Label 616: @19817
      GIM_Try, /*On fail goto*//*Label 617*/ 19869, // Rule ID 982 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_srlr_h,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128HRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 4248:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (SRLR_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SRLR_H,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 982,
        GIR_Done,
      // Label 617: @19869
      GIM_Try, /*On fail goto*//*Label 618*/ 19921, // Rule ID 983 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_srlr_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128WRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 4249:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (SRLR_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SRLR_W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 983,
        GIR_Done,
      // Label 618: @19921
      GIM_Try, /*On fail goto*//*Label 619*/ 19973, // Rule ID 984 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_srlr_d,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128DRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 4247:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)  =>  (SRLR_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SRLR_D,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 984,
        GIR_Done,
      // Label 619: @19973
      GIM_Try, /*On fail goto*//*Label 620*/ 20025, // Rule ID 993 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_subs_s_b,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128BRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128BRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128BRegClassID,
        // (intrinsic_wo_chain:{ *:[v16i8] } 4265:{ *:[iPTR] }, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (SUBS_S_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SUBS_S_B,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 993,
        GIR_Done,
      // Label 620: @20025
      GIM_Try, /*On fail goto*//*Label 621*/ 20077, // Rule ID 994 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_subs_s_h,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128HRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 4267:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (SUBS_S_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SUBS_S_H,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 994,
        GIR_Done,
      // Label 621: @20077
      GIM_Try, /*On fail goto*//*Label 622*/ 20129, // Rule ID 995 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_subs_s_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128WRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 4268:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (SUBS_S_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SUBS_S_W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 995,
        GIR_Done,
      // Label 622: @20129
      GIM_Try, /*On fail goto*//*Label 623*/ 20181, // Rule ID 996 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_subs_s_d,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128DRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 4266:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)  =>  (SUBS_S_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SUBS_S_D,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 996,
        GIR_Done,
      // Label 623: @20181
      GIM_Try, /*On fail goto*//*Label 624*/ 20233, // Rule ID 997 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_subs_u_b,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128BRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128BRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128BRegClassID,
        // (intrinsic_wo_chain:{ *:[v16i8] } 4269:{ *:[iPTR] }, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (SUBS_U_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SUBS_U_B,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 997,
        GIR_Done,
      // Label 624: @20233
      GIM_Try, /*On fail goto*//*Label 625*/ 20285, // Rule ID 998 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_subs_u_h,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128HRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 4271:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (SUBS_U_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SUBS_U_H,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 998,
        GIR_Done,
      // Label 625: @20285
      GIM_Try, /*On fail goto*//*Label 626*/ 20337, // Rule ID 999 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_subs_u_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128WRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 4272:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (SUBS_U_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SUBS_U_W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 999,
        GIR_Done,
      // Label 626: @20337
      GIM_Try, /*On fail goto*//*Label 627*/ 20389, // Rule ID 1000 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_subs_u_d,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128DRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 4270:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)  =>  (SUBS_U_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SUBS_U_D,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1000,
        GIR_Done,
      // Label 627: @20389
      GIM_Try, /*On fail goto*//*Label 628*/ 20441, // Rule ID 1001 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_subsus_u_b,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128BRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128BRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128BRegClassID,
        // (intrinsic_wo_chain:{ *:[v16i8] } 4273:{ *:[iPTR] }, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (SUBSUS_U_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SUBSUS_U_B,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1001,
        GIR_Done,
      // Label 628: @20441
      GIM_Try, /*On fail goto*//*Label 629*/ 20493, // Rule ID 1002 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_subsus_u_h,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128HRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 4275:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (SUBSUS_U_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SUBSUS_U_H,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1002,
        GIR_Done,
      // Label 629: @20493
      GIM_Try, /*On fail goto*//*Label 630*/ 20545, // Rule ID 1003 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_subsus_u_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128WRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 4276:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (SUBSUS_U_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SUBSUS_U_W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1003,
        GIR_Done,
      // Label 630: @20545
      GIM_Try, /*On fail goto*//*Label 631*/ 20597, // Rule ID 1004 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_subsus_u_d,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128DRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 4274:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)  =>  (SUBSUS_U_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SUBSUS_U_D,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1004,
        GIR_Done,
      // Label 631: @20597
      GIM_Try, /*On fail goto*//*Label 632*/ 20649, // Rule ID 1005 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_subsuu_s_b,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128BRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128BRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128BRegClassID,
        // (intrinsic_wo_chain:{ *:[v16i8] } 4277:{ *:[iPTR] }, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (SUBSUU_S_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SUBSUU_S_B,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1005,
        GIR_Done,
      // Label 632: @20649
      GIM_Try, /*On fail goto*//*Label 633*/ 20701, // Rule ID 1006 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_subsuu_s_h,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128HRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 4279:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (SUBSUU_S_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SUBSUU_S_H,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1006,
        GIR_Done,
      // Label 633: @20701
      GIM_Try, /*On fail goto*//*Label 634*/ 20753, // Rule ID 1007 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_subsuu_s_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128WRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 4280:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (SUBSUU_S_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SUBSUU_S_W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1007,
        GIR_Done,
      // Label 634: @20753
      GIM_Try, /*On fail goto*//*Label 635*/ 20805, // Rule ID 1008 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_subsuu_s_d,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128DRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 4278:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)  =>  (SUBSUU_S_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SUBSUU_S_D,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1008,
        GIR_Done,
      // Label 635: @20805
      GIM_Try, /*On fail goto*//*Label 636*/ 20857, // Rule ID 1205 //
        GIM_CheckFeatures, GIFBS_HasDSP_InMicroMips,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_addq_s_ph,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i16] } 3643:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (ADDQ_S_PH_MM:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::ADDQ_S_PH_MM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1205,
        GIR_Done,
      // Label 636: @20857
      GIM_Try, /*On fail goto*//*Label 637*/ 20909, // Rule ID 1207 //
        GIM_CheckFeatures, GIFBS_HasDSP_InMicroMips,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_addu_s_qb,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i8] } 3665:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (ADDU_S_QB_MM:{ *:[v4i8] } DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::ADDU_S_QB_MM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1207,
        GIR_Done,
      // Label 637: @20909
      GIM_Try, /*On fail goto*//*Label 638*/ 20961, // Rule ID 1228 //
        GIM_CheckFeatures, GIFBS_HasDSP_InMicroMips,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_shra_ph,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::GPR32RegClassID,
        // (intrinsic_wo_chain:{ *:[v2i16] } 4191:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rt, GPR32Opnd:{ *:[i32] }:$rs)  =>  (SHRAV_PH_MM:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rt, GPR32Opnd:{ *:[i32] }:$rs)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SHRAV_PH_MM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rs
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1228,
        GIR_Done,
      // Label 638: @20961
      GIM_Try, /*On fail goto*//*Label 639*/ 21013, // Rule ID 1229 //
        GIM_CheckFeatures, GIFBS_HasDSP_InMicroMips,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_shra_r_ph,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::GPR32RegClassID,
        // (intrinsic_wo_chain:{ *:[v2i16] } 4193:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rt, GPR32Opnd:{ *:[i32] }:$rs)  =>  (SHRAV_R_PH_MM:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rt, GPR32Opnd:{ *:[i32] }:$rs)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SHRAV_R_PH_MM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rs
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1229,
        GIR_Done,
      // Label 639: @21013
      GIM_Try, /*On fail goto*//*Label 640*/ 21065, // Rule ID 1230 //
        GIM_CheckFeatures, GIFBS_HasDSP_InMicroMips,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_shra_r_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::GPR32RegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 4195:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rt, GPR32Opnd:{ *:[i32] }:$rs)  =>  (SHRAV_R_W_MM:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rt, GPR32Opnd:{ *:[i32] }:$rs)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SHRAV_R_W_MM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rs
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1230,
        GIR_Done,
      // Label 640: @21065
      GIM_Try, /*On fail goto*//*Label 641*/ 21117, // Rule ID 1232 //
        GIM_CheckFeatures, GIFBS_HasDSP_InMicroMips,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_shrl_qb,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::GPR32RegClassID,
        // (intrinsic_wo_chain:{ *:[v4i8] } 4197:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rt, GPR32Opnd:{ *:[i32] }:$rs)  =>  (SHRLV_QB_MM:{ *:[v4i8] } DSPROpnd:{ *:[v4i8] }:$rt, GPR32Opnd:{ *:[i32] }:$rs)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SHRLV_QB_MM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rs
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1232,
        GIR_Done,
      // Label 641: @21117
      GIM_Try, /*On fail goto*//*Label 642*/ 21169, // Rule ID 1243 //
        GIM_CheckFeatures, GIFBS_HasDSP_InMicroMips,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_subq_s_ph,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i16] } 4259:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (SUBQ_S_PH_MM:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SUBQ_S_PH_MM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1243,
        GIR_Done,
      // Label 642: @21169
      GIM_Try, /*On fail goto*//*Label 643*/ 21221, // Rule ID 1245 //
        GIM_CheckFeatures, GIFBS_HasDSP_InMicroMips,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_subu_s_qb,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i8] } 4284:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (SUBU_S_QB_MM:{ *:[v4i8] } DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SUBU_S_QB_MM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1245,
        GIR_Done,
      // Label 643: @21221
      GIM_Try, /*On fail goto*//*Label 644*/ 21273, // Rule ID 1255 //
        GIM_CheckFeatures, GIFBS_HasDSP_InMicroMips,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_precrq_ph_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::GPR32RegClassID,
        // (intrinsic_wo_chain:{ *:[v2i16] } 4166:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (PRECRQ_PH_W_MM:{ *:[v2i16] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::PRECRQ_PH_W_MM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1255,
        GIR_Done,
      // Label 644: @21273
      GIM_Try, /*On fail goto*//*Label 645*/ 21325, // Rule ID 1256 //
        GIM_CheckFeatures, GIFBS_HasDSP_InMicroMips,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_precrq_qb_ph,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i8] } 4167:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (PRECRQ_QB_PH_MM:{ *:[v4i8] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::PRECRQ_QB_PH_MM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1256,
        GIR_Done,
      // Label 645: @21325
      GIM_Try, /*On fail goto*//*Label 646*/ 21377, // Rule ID 1275 //
        GIM_CheckFeatures, GIFBS_HasDSP_InMicroMips,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_packrl_ph,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i16] } 4138:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (PACKRL_PH_MM:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::PACKRL_PH_MM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1275,
        GIR_Done,
      // Label 646: @21377
      GIM_Try, /*On fail goto*//*Label 647*/ 21429, // Rule ID 1281 //
        GIM_CheckFeatures, GIFBS_HasDSP_InMicroMips,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_modsub,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::GPR32RegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 4091:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (MODSUB_MM:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::MODSUB_MM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1281,
        GIR_Done,
      // Label 647: @21429
      GIM_Try, /*On fail goto*//*Label 648*/ 21481, // Rule ID 1294 //
        GIM_CheckFeatures, GIFBS_HasDSPR2_InMicroMips,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_addqh_ph,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i16] } 3645:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (ADDQH_PH_MMR2:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::ADDQH_PH_MMR2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1294,
        GIR_Done,
      // Label 648: @21481
      GIM_Try, /*On fail goto*//*Label 649*/ 21533, // Rule ID 1295 //
        GIM_CheckFeatures, GIFBS_HasDSPR2_InMicroMips,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_addqh_r_ph,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i16] } 3646:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (ADDQH_R_PH_MMR2:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::ADDQH_R_PH_MMR2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1295,
        GIR_Done,
      // Label 649: @21533
      GIM_Try, /*On fail goto*//*Label 650*/ 21585, // Rule ID 1296 //
        GIM_CheckFeatures, GIFBS_HasDSPR2_InMicroMips,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_addqh_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::GPR32RegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 3648:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (ADDQH_W_MMR2:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::ADDQH_W_MMR2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1296,
        GIR_Done,
      // Label 650: @21585
      GIM_Try, /*On fail goto*//*Label 651*/ 21637, // Rule ID 1297 //
        GIM_CheckFeatures, GIFBS_HasDSPR2_InMicroMips,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_addqh_r_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::GPR32RegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 3647:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (ADDQH_R_W_MMR2:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::ADDQH_R_W_MMR2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1297,
        GIR_Done,
      // Label 651: @21637
      GIM_Try, /*On fail goto*//*Label 652*/ 21689, // Rule ID 1300 //
        GIM_CheckFeatures, GIFBS_HasDSPR2_InMicroMips,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_adduh_qb,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i8] } 3666:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (ADDUH_QB_MMR2:{ *:[v4i8] } DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::ADDUH_QB_MMR2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1300,
        GIR_Done,
      // Label 652: @21689
      GIM_Try, /*On fail goto*//*Label 653*/ 21741, // Rule ID 1301 //
        GIM_CheckFeatures, GIFBS_HasDSPR2_InMicroMips,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_adduh_r_qb,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i8] } 3667:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (ADDUH_R_QB_MMR2:{ *:[v4i8] } DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::ADDUH_R_QB_MMR2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1301,
        GIR_Done,
      // Label 653: @21741
      GIM_Try, /*On fail goto*//*Label 654*/ 21793, // Rule ID 1307 //
        GIM_CheckFeatures, GIFBS_HasDSPR2_InMicroMips,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_shra_qb,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::GPR32RegClassID,
        // (intrinsic_wo_chain:{ *:[v4i8] } 4192:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rt, GPR32Opnd:{ *:[i32] }:$rs)  =>  (SHRAV_QB_MMR2:{ *:[v4i8] } DSPROpnd:{ *:[v4i8] }:$rt, GPR32Opnd:{ *:[i32] }:$rs)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SHRAV_QB_MMR2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rs
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1307,
        GIR_Done,
      // Label 654: @21793
      GIM_Try, /*On fail goto*//*Label 655*/ 21845, // Rule ID 1308 //
        GIM_CheckFeatures, GIFBS_HasDSPR2_InMicroMips,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_shra_r_qb,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::GPR32RegClassID,
        // (intrinsic_wo_chain:{ *:[v4i8] } 4194:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rt, GPR32Opnd:{ *:[i32] }:$rs)  =>  (SHRAV_R_QB_MMR2:{ *:[v4i8] } DSPROpnd:{ *:[v4i8] }:$rt, GPR32Opnd:{ *:[i32] }:$rs)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SHRAV_R_QB_MMR2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rs
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1308,
        GIR_Done,
      // Label 655: @21845
      GIM_Try, /*On fail goto*//*Label 656*/ 21897, // Rule ID 1313 //
        GIM_CheckFeatures, GIFBS_HasDSPR2_InMicroMips,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_shrl_ph,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::GPR32RegClassID,
        // (intrinsic_wo_chain:{ *:[v2i16] } 4196:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rt, GPR32Opnd:{ *:[i32] }:$rs)  =>  (SHRLV_PH_MMR2:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rt, GPR32Opnd:{ *:[i32] }:$rs)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SHRLV_PH_MMR2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rs
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1313,
        GIR_Done,
      // Label 656: @21897
      GIM_Try, /*On fail goto*//*Label 657*/ 21949, // Rule ID 1314 //
        GIM_CheckFeatures, GIFBS_HasDSPR2_InMicroMips,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_subqh_ph,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i16] } 4261:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (SUBQH_PH_MMR2:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SUBQH_PH_MMR2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1314,
        GIR_Done,
      // Label 657: @21949
      GIM_Try, /*On fail goto*//*Label 658*/ 22001, // Rule ID 1315 //
        GIM_CheckFeatures, GIFBS_HasDSPR2_InMicroMips,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_subqh_r_ph,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i16] } 4262:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (SUBQH_R_PH_MMR2:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SUBQH_R_PH_MMR2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1315,
        GIR_Done,
      // Label 658: @22001
      GIM_Try, /*On fail goto*//*Label 659*/ 22053, // Rule ID 1316 //
        GIM_CheckFeatures, GIFBS_HasDSPR2_InMicroMips,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_subqh_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::GPR32RegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 4264:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (SUBQH_W_MMR2:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SUBQH_W_MMR2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1316,
        GIR_Done,
      // Label 659: @22053
      GIM_Try, /*On fail goto*//*Label 660*/ 22105, // Rule ID 1317 //
        GIM_CheckFeatures, GIFBS_HasDSPR2_InMicroMips,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_subqh_r_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::GPR32RegClassID,
        // (intrinsic_wo_chain:{ *:[i32] } 4263:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (SUBQH_R_W_MMR2:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SUBQH_R_W_MMR2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1317,
        GIR_Done,
      // Label 660: @22105
      GIM_Try, /*On fail goto*//*Label 661*/ 22157, // Rule ID 1320 //
        GIM_CheckFeatures, GIFBS_HasDSPR2_InMicroMips,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_subuh_qb,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i8] } 4285:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (SUBUH_QB_MMR2:{ *:[v4i8] } DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SUBUH_QB_MMR2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1320,
        GIR_Done,
      // Label 661: @22157
      GIM_Try, /*On fail goto*//*Label 662*/ 22209, // Rule ID 1321 //
        GIM_CheckFeatures, GIFBS_HasDSPR2_InMicroMips,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_subuh_r_qb,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i8] } 4286:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (SUBUH_R_QB_MMR2:{ *:[v4i8] } DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SUBUH_R_QB_MMR2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1321,
        GIR_Done,
      // Label 662: @22209
      GIM_Try, /*On fail goto*//*Label 663*/ 22253, // Rule ID 1875 //
        GIM_CheckFeatures, GIFBS_HasDSP,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_addq_ph,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i16] } 3642:{ *:[iPTR] }, v2i16:{ *:[v2i16] }:$a, v2i16:{ *:[v2i16] }:$b)  =>  (ADDQ_PH:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$a, v2i16:{ *:[v2i16] }:$b)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::ADDQ_PH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // a
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // b
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1875,
        GIR_Done,
      // Label 663: @22253
      GIM_Try, /*On fail goto*//*Label 664*/ 22297, // Rule ID 1877 //
        GIM_CheckFeatures, GIFBS_HasDSP,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_subq_ph,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i16] } 4258:{ *:[iPTR] }, v2i16:{ *:[v2i16] }:$a, v2i16:{ *:[v2i16] }:$b)  =>  (SUBQ_PH:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$a, v2i16:{ *:[v2i16] }:$b)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SUBQ_PH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // a
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // b
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1877,
        GIR_Done,
      // Label 664: @22297
      GIM_Try, /*On fail goto*//*Label 665*/ 22341, // Rule ID 1881 //
        GIM_CheckFeatures, GIFBS_HasDSP,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_addu_qb,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i8] } 3663:{ *:[iPTR] }, v4i8:{ *:[v4i8] }:$a, v4i8:{ *:[v4i8] }:$b)  =>  (ADDU_QB:{ *:[v4i8] } v4i8:{ *:[v4i8] }:$a, v4i8:{ *:[v4i8] }:$b)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::ADDU_QB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // a
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // b
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1881,
        GIR_Done,
      // Label 665: @22341
      GIM_Try, /*On fail goto*//*Label 666*/ 22385, // Rule ID 1883 //
        GIM_CheckFeatures, GIFBS_HasDSP,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_subu_qb,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i8] } 4282:{ *:[iPTR] }, v4i8:{ *:[v4i8] }:$a, v4i8:{ *:[v4i8] }:$b)  =>  (SUBU_QB:{ *:[v4i8] } v4i8:{ *:[v4i8] }:$a, v4i8:{ *:[v4i8] }:$b)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SUBU_QB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // a
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // b
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1883,
        GIR_Done,
      // Label 666: @22385
      GIM_Reject,
    // Label 452: @22386
    GIM_Try, /*On fail goto*//*Label 667*/ 25274,
      GIM_CheckNumOperands, /*MI*/0, /*Expected*/5,
      GIM_Try, /*On fail goto*//*Label 668*/ 22450, // Rule ID 465 //
        GIM_CheckFeatures, GIFBS_HasDSPR2,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_precr_sra_ph_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::GPR32RegClassID,
        // MIs[0] sa
        GIM_CheckIsImm, /*MI*/0, /*Op*/4,
        // (intrinsic_wo_chain:{ *:[v2i16] } 4164:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$src, GPR32Opnd:{ *:[i32] }:$rs, (timm:{ *:[i32] })<<P:Predicate_timmZExt5>>:$sa)  =>  (PRECR_SRA_PH_W:{ *:[v2i16] } GPR32Opnd:{ *:[i32] }:$rs, (timm:{ *:[i32] }):$sa, GPR32Opnd:{ *:[i32] }:$src)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::PRECR_SRA_PH_W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // sa
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 465,
        GIR_Done,
      // Label 668: @22450
      GIM_Try, /*On fail goto*//*Label 669*/ 22509, // Rule ID 466 //
        GIM_CheckFeatures, GIFBS_HasDSPR2,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_precr_sra_r_ph_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::GPR32RegClassID,
        // MIs[0] sa
        GIM_CheckIsImm, /*MI*/0, /*Op*/4,
        // (intrinsic_wo_chain:{ *:[v2i16] } 4165:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$src, GPR32Opnd:{ *:[i32] }:$rs, (timm:{ *:[i32] })<<P:Predicate_timmZExt5>>:$sa)  =>  (PRECR_SRA_R_PH_W:{ *:[v2i16] } GPR32Opnd:{ *:[i32] }:$rs, (timm:{ *:[i32] }):$sa, GPR32Opnd:{ *:[i32] }:$src)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::PRECR_SRA_R_PH_W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // sa
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 466,
        GIR_Done,
      // Label 669: @22509
      GIM_Try, /*On fail goto*//*Label 670*/ 22568, // Rule ID 471 //
        GIM_CheckFeatures, GIFBS_HasDSPR2,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_append,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::GPR32RegClassID,
        // MIs[0] sa
        GIM_CheckIsImm, /*MI*/0, /*Op*/4,
        // (intrinsic_wo_chain:{ *:[i32] } 3679:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$src, GPR32Opnd:{ *:[i32] }:$rs, (timm:{ *:[i32] })<<P:Predicate_timmZExt5>>:$sa)  =>  (APPEND:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, (timm:{ *:[i32] }):$sa, GPR32Opnd:{ *:[i32] }:$src)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::APPEND,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // sa
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 471,
        GIR_Done,
      // Label 670: @22568
      GIM_Try, /*On fail goto*//*Label 671*/ 22627, // Rule ID 472 //
        GIM_CheckFeatures, GIFBS_HasDSPR2,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_balign,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::GPR32RegClassID,
        // MIs[0] sa
        GIM_CheckIsImm, /*MI*/0, /*Op*/4,
        // (intrinsic_wo_chain:{ *:[i32] } 3704:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$src, GPR32Opnd:{ *:[i32] }:$rs, (timm:{ *:[i32] })<<P:Predicate_timmZExt2>>:$sa)  =>  (BALIGN:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, (timm:{ *:[i32] }):$sa, GPR32Opnd:{ *:[i32] }:$src)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::BALIGN,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // sa
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 472,
        GIR_Done,
      // Label 671: @22627
      GIM_Try, /*On fail goto*//*Label 672*/ 22686, // Rule ID 473 //
        GIM_CheckFeatures, GIFBS_HasDSPR2,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_prepend,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::GPR32RegClassID,
        // MIs[0] sa
        GIM_CheckIsImm, /*MI*/0, /*Op*/4,
        // (intrinsic_wo_chain:{ *:[i32] } 4170:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$src, GPR32Opnd:{ *:[i32] }:$rs, (timm:{ *:[i32] })<<P:Predicate_timmZExt5>>:$sa)  =>  (PREPEND:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, (timm:{ *:[i32] }):$sa, GPR32Opnd:{ *:[i32] }:$src)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::PREPEND,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // sa
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 473,
        GIR_Done,
      // Label 672: @22686
      GIM_Try, /*On fail goto*//*Label 673*/ 22745, // Rule ID 937 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_sldi_b,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128BRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128BRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128BRegClassID,
        // MIs[0] n
        GIM_CheckIsImm, /*MI*/0, /*Op*/4,
        // (intrinsic_wo_chain:{ *:[v16i8] } 4202:{ *:[iPTR] }, MSA128BOpnd:{ *:[v16i8] }:$wd_in, MSA128BOpnd:{ *:[v16i8] }:$ws, (timm:{ *:[i32] })<<P:Predicate_timmZExt4>>:$n)  =>  (SLDI_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$wd_in, MSA128BOpnd:{ *:[v16i8] }:$ws, (timm:{ *:[i32] }):$n)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SLDI_B,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // wd_in
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // n
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 937,
        GIR_Done,
      // Label 673: @22745
      GIM_Try, /*On fail goto*//*Label 674*/ 22804, // Rule ID 938 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_sldi_h,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128HRegClassID,
        // MIs[0] n
        GIM_CheckIsImm, /*MI*/0, /*Op*/4,
        // (intrinsic_wo_chain:{ *:[v8i16] } 4204:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$wd_in, MSA128HOpnd:{ *:[v8i16] }:$ws, (timm:{ *:[i32] })<<P:Predicate_timmZExt3>>:$n)  =>  (SLDI_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$wd_in, MSA128HOpnd:{ *:[v8i16] }:$ws, (timm:{ *:[i32] }):$n)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SLDI_H,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // wd_in
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // n
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 938,
        GIR_Done,
      // Label 674: @22804
      GIM_Try, /*On fail goto*//*Label 675*/ 22863, // Rule ID 939 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_sldi_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128WRegClassID,
        // MIs[0] n
        GIM_CheckIsImm, /*MI*/0, /*Op*/4,
        // (intrinsic_wo_chain:{ *:[v4i32] } 4205:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$wd_in, MSA128WOpnd:{ *:[v4i32] }:$ws, (timm:{ *:[i32] })<<P:Predicate_timmZExt2>>:$n)  =>  (SLDI_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$wd_in, MSA128WOpnd:{ *:[v4i32] }:$ws, (timm:{ *:[i32] }):$n)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SLDI_W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // wd_in
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // n
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 939,
        GIR_Done,
      // Label 675: @22863
      GIM_Try, /*On fail goto*//*Label 676*/ 22922, // Rule ID 940 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_sldi_d,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128DRegClassID,
        // MIs[0] n
        GIM_CheckIsImm, /*MI*/0, /*Op*/4,
        // (intrinsic_wo_chain:{ *:[v2i64] } 4203:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2i64] }:$wd_in, MSA128DOpnd:{ *:[v2i64] }:$ws, (timm:{ *:[i32] })<<P:Predicate_timmZExt1>>:$n)  =>  (SLDI_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$wd_in, MSA128DOpnd:{ *:[v2i64] }:$ws, (timm:{ *:[i32] }):$n)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SLDI_D,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // wd_in
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // n
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 940,
        GIR_Done,
      // Label 676: @22922
      GIM_Try, /*On fail goto*//*Label 677*/ 22981, // Rule ID 1331 //
        GIM_CheckFeatures, GIFBS_HasDSPR2_InMicroMips,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_precr_sra_ph_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::GPR32RegClassID,
        // MIs[0] sa
        GIM_CheckIsImm, /*MI*/0, /*Op*/4,
        // (intrinsic_wo_chain:{ *:[v2i16] } 4164:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$src, GPR32Opnd:{ *:[i32] }:$rs, (timm:{ *:[i32] })<<P:Predicate_timmZExt5>>:$sa)  =>  (PRECR_SRA_PH_W_MMR2:{ *:[v2i16] } GPR32Opnd:{ *:[i32] }:$rs, (timm:{ *:[i32] }):$sa, GPR32Opnd:{ *:[i32] }:$src)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::PRECR_SRA_PH_W_MMR2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // sa
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1331,
        GIR_Done,
      // Label 677: @22981
      GIM_Try, /*On fail goto*//*Label 678*/ 23040, // Rule ID 1332 //
        GIM_CheckFeatures, GIFBS_HasDSPR2_InMicroMips,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_precr_sra_r_ph_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::GPR32RegClassID,
        // MIs[0] sa
        GIM_CheckIsImm, /*MI*/0, /*Op*/4,
        // (intrinsic_wo_chain:{ *:[v2i16] } 4165:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$src, GPR32Opnd:{ *:[i32] }:$rs, (timm:{ *:[i32] })<<P:Predicate_timmZExt5>>:$sa)  =>  (PRECR_SRA_R_PH_W_MMR2:{ *:[v2i16] } GPR32Opnd:{ *:[i32] }:$rs, (timm:{ *:[i32] }):$sa, GPR32Opnd:{ *:[i32] }:$src)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::PRECR_SRA_R_PH_W_MMR2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // sa
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1332,
        GIR_Done,
      // Label 678: @23040
      GIM_Try, /*On fail goto*//*Label 679*/ 23099, // Rule ID 1333 //
        GIM_CheckFeatures, GIFBS_HasDSPR2_InMicroMips,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_prepend,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::GPR32RegClassID,
        // MIs[0] sa
        GIM_CheckIsImm, /*MI*/0, /*Op*/4,
        // (intrinsic_wo_chain:{ *:[i32] } 4170:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$src, GPR32Opnd:{ *:[i32] }:$rs, (timm:{ *:[i32] })<<P:Predicate_timmZExt5>>:$sa)  =>  (PREPEND_MMR2:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, (timm:{ *:[i32] }):$sa, GPR32Opnd:{ *:[i32] }:$src)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::PREPEND_MMR2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // sa
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1333,
        GIR_Done,
      // Label 679: @23099
      GIM_Try, /*On fail goto*//*Label 680*/ 23158, // Rule ID 1334 //
        GIM_CheckFeatures, GIFBS_HasDSPR2_InMicroMips,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_append,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::GPR32RegClassID,
        // MIs[0] sa
        GIM_CheckIsImm, /*MI*/0, /*Op*/4,
        // (intrinsic_wo_chain:{ *:[i32] } 3679:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$src, GPR32Opnd:{ *:[i32] }:$rs, (timm:{ *:[i32] })<<P:Predicate_timmZExt5>>:$sa)  =>  (APPEND_MMR2:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, (timm:{ *:[i32] }):$sa, GPR32Opnd:{ *:[i32] }:$src)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::APPEND_MMR2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // sa
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1334,
        GIR_Done,
      // Label 680: @23158
      GIM_Try, /*On fail goto*//*Label 681*/ 23225, // Rule ID 1309 //
        GIM_CheckFeatures, GIFBS_HasDSPR2_InMicroMips,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_balign,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::GPR32RegClassID,
        // MIs[0] bp
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/4, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_immZExt2,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_wo_chain:{ *:[i32] } 3704:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$src, GPR32Opnd:{ *:[i32] }:$rs, (imm:{ *:[i32] })<<P:Predicate_immZExt2>>:$bp)  =>  (BALIGN_MMR2:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, (imm:{ *:[i32] }):$bp, GPR32Opnd:{ *:[i32] }:$src)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::BALIGN_MMR2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rs
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // bp
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1309,
        GIR_Done,
      // Label 681: @23225
      GIM_Try, /*On fail goto*//*Label 682*/ 23289, // Rule ID 536 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_binsl_b,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128BRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128BRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128BRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/4, /*RC*/Mips::MSA128BRegClassID,
        // (intrinsic_wo_chain:{ *:[v16i8] } 3713:{ *:[iPTR] }, MSA128BOpnd:{ *:[v16i8] }:$wd_in, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (BINSL_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$wd_in, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::BINSL_B,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // wd_in
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 536,
        GIR_Done,
      // Label 682: @23289
      GIM_Try, /*On fail goto*//*Label 683*/ 23353, // Rule ID 537 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_binsl_h,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/4, /*RC*/Mips::MSA128HRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 3715:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$wd_in, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (BINSL_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$wd_in, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::BINSL_H,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // wd_in
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 537,
        GIR_Done,
      // Label 683: @23353
      GIM_Try, /*On fail goto*//*Label 684*/ 23417, // Rule ID 538 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_binsl_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/4, /*RC*/Mips::MSA128WRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 3716:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$wd_in, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (BINSL_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$wd_in, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::BINSL_W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // wd_in
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 538,
        GIR_Done,
      // Label 684: @23417
      GIM_Try, /*On fail goto*//*Label 685*/ 23481, // Rule ID 539 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_binsl_d,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/4, /*RC*/Mips::MSA128DRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 3714:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2i64] }:$wd_in, MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)  =>  (BINSL_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$wd_in, MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::BINSL_D,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // wd_in
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 539,
        GIR_Done,
      // Label 685: @23481
      GIM_Try, /*On fail goto*//*Label 686*/ 23545, // Rule ID 544 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_binsr_b,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128BRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128BRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128BRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/4, /*RC*/Mips::MSA128BRegClassID,
        // (intrinsic_wo_chain:{ *:[v16i8] } 3721:{ *:[iPTR] }, MSA128BOpnd:{ *:[v16i8] }:$wd_in, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (BINSR_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$wd_in, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::BINSR_B,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // wd_in
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 544,
        GIR_Done,
      // Label 686: @23545
      GIM_Try, /*On fail goto*//*Label 687*/ 23609, // Rule ID 545 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_binsr_h,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/4, /*RC*/Mips::MSA128HRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 3723:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$wd_in, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (BINSR_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$wd_in, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::BINSR_H,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // wd_in
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 545,
        GIR_Done,
      // Label 687: @23609
      GIM_Try, /*On fail goto*//*Label 688*/ 23673, // Rule ID 546 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_binsr_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/4, /*RC*/Mips::MSA128WRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 3724:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$wd_in, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (BINSR_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$wd_in, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::BINSR_W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // wd_in
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 546,
        GIR_Done,
      // Label 688: @23673
      GIM_Try, /*On fail goto*//*Label 689*/ 23737, // Rule ID 547 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_binsr_d,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/4, /*RC*/Mips::MSA128DRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 3722:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2i64] }:$wd_in, MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)  =>  (BINSR_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$wd_in, MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::BINSR_D,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // wd_in
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 547,
        GIR_Done,
      // Label 689: @23737
      GIM_Try, /*On fail goto*//*Label 690*/ 23801, // Rule ID 642 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_dpadd_s_h,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128BRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/4, /*RC*/Mips::MSA128BRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 3842:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$wd_in, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (DPADD_S_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$wd_in, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::DPADD_S_H,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // wd_in
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 642,
        GIR_Done,
      // Label 690: @23801
      GIM_Try, /*On fail goto*//*Label 691*/ 23865, // Rule ID 643 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_dpadd_s_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/4, /*RC*/Mips::MSA128HRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 3843:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$wd_in, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (DPADD_S_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$wd_in, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::DPADD_S_W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // wd_in
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 643,
        GIR_Done,
      // Label 691: @23865
      GIM_Try, /*On fail goto*//*Label 692*/ 23929, // Rule ID 644 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_dpadd_s_d,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/4, /*RC*/Mips::MSA128WRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 3841:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2i64] }:$wd_in, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (DPADD_S_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$wd_in, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::DPADD_S_D,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // wd_in
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 644,
        GIR_Done,
      // Label 692: @23929
      GIM_Try, /*On fail goto*//*Label 693*/ 23993, // Rule ID 645 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_dpadd_u_h,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128BRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/4, /*RC*/Mips::MSA128BRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 3845:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$wd_in, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (DPADD_U_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$wd_in, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::DPADD_U_H,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // wd_in
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 645,
        GIR_Done,
      // Label 693: @23993
      GIM_Try, /*On fail goto*//*Label 694*/ 24057, // Rule ID 646 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_dpadd_u_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/4, /*RC*/Mips::MSA128HRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 3846:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$wd_in, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (DPADD_U_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$wd_in, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::DPADD_U_W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // wd_in
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 646,
        GIR_Done,
      // Label 694: @24057
      GIM_Try, /*On fail goto*//*Label 695*/ 24121, // Rule ID 647 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_dpadd_u_d,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/4, /*RC*/Mips::MSA128WRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 3844:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2i64] }:$wd_in, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (DPADD_U_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$wd_in, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::DPADD_U_D,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // wd_in
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 647,
        GIR_Done,
      // Label 695: @24121
      GIM_Try, /*On fail goto*//*Label 696*/ 24185, // Rule ID 648 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_dpsub_s_h,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128BRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/4, /*RC*/Mips::MSA128BRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 3862:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$wd_in, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (DPSUB_S_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$wd_in, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::DPSUB_S_H,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // wd_in
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 648,
        GIR_Done,
      // Label 696: @24185
      GIM_Try, /*On fail goto*//*Label 697*/ 24249, // Rule ID 649 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_dpsub_s_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/4, /*RC*/Mips::MSA128HRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 3863:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$wd_in, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (DPSUB_S_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$wd_in, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::DPSUB_S_W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // wd_in
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 649,
        GIR_Done,
      // Label 697: @24249
      GIM_Try, /*On fail goto*//*Label 698*/ 24313, // Rule ID 650 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_dpsub_s_d,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/4, /*RC*/Mips::MSA128WRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 3861:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2i64] }:$wd_in, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (DPSUB_S_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$wd_in, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::DPSUB_S_D,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // wd_in
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 650,
        GIR_Done,
      // Label 698: @24313
      GIM_Try, /*On fail goto*//*Label 699*/ 24377, // Rule ID 651 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_dpsub_u_h,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128BRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/4, /*RC*/Mips::MSA128BRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 3865:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$wd_in, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (DPSUB_U_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$wd_in, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::DPSUB_U_H,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // wd_in
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 651,
        GIR_Done,
      // Label 699: @24377
      GIM_Try, /*On fail goto*//*Label 700*/ 24441, // Rule ID 652 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_dpsub_u_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/4, /*RC*/Mips::MSA128HRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 3866:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$wd_in, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (DPSUB_U_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$wd_in, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::DPSUB_U_W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // wd_in
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 652,
        GIR_Done,
      // Label 700: @24441
      GIM_Try, /*On fail goto*//*Label 701*/ 24505, // Rule ID 653 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_dpsub_u_d,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/4, /*RC*/Mips::MSA128WRegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 3864:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2i64] }:$wd_in, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (DPSUB_U_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$wd_in, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::DPSUB_U_D,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // wd_in
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 653,
        GIR_Done,
      // Label 701: @24505
      GIM_Try, /*On fail goto*//*Label 702*/ 24569, // Rule ID 820 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_madd_q_h,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/4, /*RC*/Mips::MSA128HRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 4030:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$wd_in, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (MADD_Q_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$wd_in, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::MADD_Q_H,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // wd_in
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 820,
        GIR_Done,
      // Label 702: @24569
      GIM_Try, /*On fail goto*//*Label 703*/ 24633, // Rule ID 821 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_madd_q_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/4, /*RC*/Mips::MSA128WRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 4031:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$wd_in, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (MADD_Q_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$wd_in, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::MADD_Q_W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // wd_in
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 821,
        GIR_Done,
      // Label 703: @24633
      GIM_Try, /*On fail goto*//*Label 704*/ 24697, // Rule ID 822 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_maddr_q_h,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/4, /*RC*/Mips::MSA128HRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 4032:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$wd_in, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (MADDR_Q_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$wd_in, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::MADDR_Q_H,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // wd_in
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 822,
        GIR_Done,
      // Label 704: @24697
      GIM_Try, /*On fail goto*//*Label 705*/ 24761, // Rule ID 823 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_maddr_q_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/4, /*RC*/Mips::MSA128WRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 4033:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$wd_in, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (MADDR_Q_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$wd_in, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::MADDR_Q_W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // wd_in
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 823,
        GIR_Done,
      // Label 705: @24761
      GIM_Try, /*On fail goto*//*Label 706*/ 24825, // Rule ID 876 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_msub_q_h,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/4, /*RC*/Mips::MSA128HRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 4094:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$wd_in, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (MSUB_Q_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$wd_in, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::MSUB_Q_H,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // wd_in
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 876,
        GIR_Done,
      // Label 706: @24825
      GIM_Try, /*On fail goto*//*Label 707*/ 24889, // Rule ID 877 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_msub_q_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/4, /*RC*/Mips::MSA128WRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 4095:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$wd_in, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (MSUB_Q_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$wd_in, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::MSUB_Q_W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // wd_in
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 877,
        GIR_Done,
      // Label 707: @24889
      GIM_Try, /*On fail goto*//*Label 708*/ 24953, // Rule ID 878 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_msubr_q_h,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/4, /*RC*/Mips::MSA128HRegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 4096:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$wd_in, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (MSUBR_Q_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$wd_in, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::MSUBR_Q_H,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // wd_in
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 878,
        GIR_Done,
      // Label 708: @24953
      GIM_Try, /*On fail goto*//*Label 709*/ 25017, // Rule ID 879 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_msubr_q_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/4, /*RC*/Mips::MSA128WRegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 4097:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$wd_in, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (MSUBR_Q_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$wd_in, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::MSUBR_Q_W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // wd_in
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 879,
        GIR_Done,
      // Label 709: @25017
      GIM_Try, /*On fail goto*//*Label 710*/ 25081, // Rule ID 933 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_sld_b,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128BRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128BRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128BRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/4, /*RC*/Mips::GPR32RegClassID,
        // (intrinsic_wo_chain:{ *:[v16i8] } 4198:{ *:[iPTR] }, MSA128BOpnd:{ *:[v16i8] }:$wd_in, MSA128BOpnd:{ *:[v16i8] }:$ws, GPR32Opnd:{ *:[i32] }:$rt)  =>  (SLD_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$wd_in, MSA128BOpnd:{ *:[v16i8] }:$ws, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SLD_B,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // wd_in
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // rt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 933,
        GIR_Done,
      // Label 710: @25081
      GIM_Try, /*On fail goto*//*Label 711*/ 25145, // Rule ID 934 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_sld_h,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/4, /*RC*/Mips::GPR32RegClassID,
        // (intrinsic_wo_chain:{ *:[v8i16] } 4200:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$wd_in, MSA128HOpnd:{ *:[v8i16] }:$ws, GPR32Opnd:{ *:[i32] }:$rt)  =>  (SLD_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$wd_in, MSA128HOpnd:{ *:[v8i16] }:$ws, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SLD_H,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // wd_in
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // rt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 934,
        GIR_Done,
      // Label 711: @25145
      GIM_Try, /*On fail goto*//*Label 712*/ 25209, // Rule ID 935 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_sld_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/4, /*RC*/Mips::GPR32RegClassID,
        // (intrinsic_wo_chain:{ *:[v4i32] } 4201:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$wd_in, MSA128WOpnd:{ *:[v4i32] }:$ws, GPR32Opnd:{ *:[i32] }:$rt)  =>  (SLD_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$wd_in, MSA128WOpnd:{ *:[v4i32] }:$ws, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SLD_W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // wd_in
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // rt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 935,
        GIR_Done,
      // Label 712: @25209
      GIM_Try, /*On fail goto*//*Label 713*/ 25273, // Rule ID 936 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_sld_d,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::MSA128DRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/4, /*RC*/Mips::GPR32RegClassID,
        // (intrinsic_wo_chain:{ *:[v2i64] } 4199:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2i64] }:$wd_in, MSA128DOpnd:{ *:[v2i64] }:$ws, GPR32Opnd:{ *:[i32] }:$rt)  =>  (SLD_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$wd_in, MSA128DOpnd:{ *:[v2i64] }:$ws, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SLD_D,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // wd_in
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // rt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 936,
        GIR_Done,
      // Label 713: @25273
      GIM_Reject,
    // Label 667: @25274
    GIM_Reject,
    // Label 16: @25275
    GIM_Try, /*On fail goto*//*Label 714*/ 25308, // Rule ID 342 //
      GIM_CheckNumOperands, /*MI*/0, /*Expected*/2,
      GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_bposge32,
      GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
      // (intrinsic_w_chain:{ *:[i32] } 3747:{ *:[iPTR] })  =>  (BPOSGE32_PSEUDO:{ *:[i32] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::BPOSGE32_PSEUDO,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 342,
      GIR_Done,
    // Label 714: @25308
    GIM_Try, /*On fail goto*//*Label 715*/ 26262,
      GIM_CheckNumOperands, /*MI*/0, /*Expected*/3,
      GIM_Try, /*On fail goto*//*Label 716*/ 25352, // Rule ID 429 //
        GIM_CheckFeatures, GIFBS_HasDSP,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_rddsp,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        // MIs[0] mask
        GIM_CheckIsImm, /*MI*/0, /*Op*/2,
        // (intrinsic_w_chain:{ *:[i32] } 4172:{ *:[iPTR] }, (timm:{ *:[i32] })<<P:Predicate_timmZExt10>>:$mask)  =>  (RDDSP:{ *:[i32] } (timm:{ *:[i32] }):$mask)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::RDDSP,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // mask
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 429,
        GIR_Done,
      // Label 716: @25352
      GIM_Try, /*On fail goto*//*Label 717*/ 25391, // Rule ID 1269 //
        GIM_CheckFeatures, GIFBS_HasDSP_InMicroMips,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_rddsp,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        // MIs[0] mask
        GIM_CheckIsImm, /*MI*/0, /*Op*/2,
        // (intrinsic_w_chain:{ *:[i32] } 4172:{ *:[iPTR] }, (timm:{ *:[i32] })<<P:Predicate_timmZExt7>>:$mask)  =>  (RDDSP_MM:{ *:[i32] } (timm:{ *:[i32] }):$mask)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::RDDSP_MM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // mask
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1269,
        GIR_Done,
      // Label 717: @25391
      GIM_Try, /*On fail goto*//*Label 718*/ 25430, // Rule ID 430 //
        GIM_CheckFeatures, GIFBS_HasDSP_NotInMicroMips,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, Intrinsic::mips_wrdsp,
        GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::GPR32RegClassID,
        // MIs[0] mask
        GIM_CheckIsImm, /*MI*/0, /*Op*/2,
        // (intrinsic_void 4299:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rs, (timm:{ *:[i32] })<<P:Predicate_timmZExt10>>:$mask)  =>  (WRDSP GPR32Opnd:{ *:[i32] }:$rs, (timm:{ *:[i32] }):$mask)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::WRDSP,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // mask
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 430,
        GIR_Done,
      // Label 718: @25430
      GIM_Try, /*On fail goto*//*Label 719*/ 25469, // Rule ID 1280 //
        GIM_CheckFeatures, GIFBS_HasDSP_InMicroMips,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, Intrinsic::mips_wrdsp,
        GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::GPR32RegClassID,
        // MIs[0] mask
        GIM_CheckIsImm, /*MI*/0, /*Op*/2,
        // (intrinsic_void 4299:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rt, (timm:{ *:[i32] })<<P:Predicate_timmZExt7>>:$mask)  =>  (WRDSP_MM GPR32Opnd:{ *:[i32] }:$rt, (timm:{ *:[i32] }):$mask)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::WRDSP_MM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // mask
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1280,
        GIR_Done,
      // Label 719: @25469
      GIM_Try, /*On fail goto*//*Label 720*/ 25513, // Rule ID 351 //
        GIM_CheckFeatures, GIFBS_HasDSP,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_absq_s_ph,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_w_chain:{ *:[v2i16] } 3635:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (ABSQ_S_PH:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::ABSQ_S_PH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rt
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 351,
        GIR_Done,
      // Label 720: @25513
      GIM_Try, /*On fail goto*//*Label 721*/ 25557, // Rule ID 352 //
        GIM_CheckFeatures, GIFBS_HasDSP,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_absq_s_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR32RegClassID,
        // (intrinsic_w_chain:{ *:[i32] } 3637:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rt)  =>  (ABSQ_S_W:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::ABSQ_S_W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rt
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 352,
        GIR_Done,
      // Label 721: @25557
      GIM_Try, /*On fail goto*//*Label 722*/ 25601, // Rule ID 438 //
        GIM_CheckFeatures, GIFBS_HasDSPR2,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_absq_s_qb,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_w_chain:{ *:[v4i8] } 3636:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (ABSQ_S_QB:{ *:[v4i8] } DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::ABSQ_S_QB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rt
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 438,
        GIR_Done,
      // Label 722: @25601
      GIM_Try, /*On fail goto*//*Label 723*/ 25645, // Rule ID 1212 //
        GIM_CheckFeatures, GIFBS_HasDSP_InMicroMips,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_absq_s_ph,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_w_chain:{ *:[v2i16] } 3635:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs)  =>  (ABSQ_S_PH_MM:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rs)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::ABSQ_S_PH_MM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1212,
        GIR_Done,
      // Label 723: @25645
      GIM_Try, /*On fail goto*//*Label 724*/ 25689, // Rule ID 1213 //
        GIM_CheckFeatures, GIFBS_HasDSP_InMicroMips,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_absq_s_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR32RegClassID,
        // (intrinsic_w_chain:{ *:[i32] } 3637:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rs)  =>  (ABSQ_S_W_MM:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::ABSQ_S_W_MM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1213,
        GIR_Done,
      // Label 724: @25689
      GIM_Try, /*On fail goto*//*Label 725*/ 25733, // Rule ID 1293 //
        GIM_CheckFeatures, GIFBS_HasDSPR2_InMicroMips,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_absq_s_qb,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_w_chain:{ *:[v4i8] } 3636:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs)  =>  (ABSQ_S_QB_MMR2:{ *:[v4i8] } DSPROpnd:{ *:[v4i8] }:$rs)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::ABSQ_S_QB_MMR2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1293,
        GIR_Done,
      // Label 725: @25733
      GIM_Try, /*On fail goto*//*Label 726*/ 25777, // Rule ID 405 //
        GIM_CheckFeatures, GIFBS_HasDSP,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, Intrinsic::mips_cmpu_eq_qb,
        GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_void 3813:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (CMPU_EQ_QB DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::CMPU_EQ_QB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rt
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 405,
        GIR_Done,
      // Label 726: @25777
      GIM_Try, /*On fail goto*//*Label 727*/ 25821, // Rule ID 406 //
        GIM_CheckFeatures, GIFBS_HasDSP,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, Intrinsic::mips_cmpu_lt_qb,
        GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_void 3815:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (CMPU_LT_QB DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::CMPU_LT_QB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rt
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 406,
        GIR_Done,
      // Label 727: @25821
      GIM_Try, /*On fail goto*//*Label 728*/ 25865, // Rule ID 407 //
        GIM_CheckFeatures, GIFBS_HasDSP,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, Intrinsic::mips_cmpu_le_qb,
        GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_void 3814:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (CMPU_LE_QB DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::CMPU_LE_QB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rt
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 407,
        GIR_Done,
      // Label 728: @25865
      GIM_Try, /*On fail goto*//*Label 729*/ 25909, // Rule ID 411 //
        GIM_CheckFeatures, GIFBS_HasDSP,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, Intrinsic::mips_cmp_eq_ph,
        GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_void 3804:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (CMP_EQ_PH DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::CMP_EQ_PH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rt
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 411,
        GIR_Done,
      // Label 729: @25909
      GIM_Try, /*On fail goto*//*Label 730*/ 25953, // Rule ID 412 //
        GIM_CheckFeatures, GIFBS_HasDSP,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, Intrinsic::mips_cmp_lt_ph,
        GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_void 3806:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (CMP_LT_PH DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::CMP_LT_PH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rt
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 412,
        GIR_Done,
      // Label 730: @25953
      GIM_Try, /*On fail goto*//*Label 731*/ 25997, // Rule ID 413 //
        GIM_CheckFeatures, GIFBS_HasDSP,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, Intrinsic::mips_cmp_le_ph,
        GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_void 3805:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (CMP_LE_PH DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::CMP_LE_PH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rt
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 413,
        GIR_Done,
      // Label 731: @25997
      GIM_Try, /*On fail goto*//*Label 732*/ 26041, // Rule ID 1284 //
        GIM_CheckFeatures, GIFBS_HasDSP_InMicroMips,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, Intrinsic::mips_cmp_eq_ph,
        GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_void 3804:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (CMP_EQ_PH_MM DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::CMP_EQ_PH_MM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rt
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1284,
        GIR_Done,
      // Label 732: @26041
      GIM_Try, /*On fail goto*//*Label 733*/ 26085, // Rule ID 1285 //
        GIM_CheckFeatures, GIFBS_HasDSP_InMicroMips,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, Intrinsic::mips_cmp_lt_ph,
        GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_void 3806:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (CMP_LT_PH_MM DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::CMP_LT_PH_MM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rt
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1285,
        GIR_Done,
      // Label 733: @26085
      GIM_Try, /*On fail goto*//*Label 734*/ 26129, // Rule ID 1286 //
        GIM_CheckFeatures, GIFBS_HasDSP_InMicroMips,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, Intrinsic::mips_cmp_le_ph,
        GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_void 3805:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (CMP_LE_PH_MM DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::CMP_LE_PH_MM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rt
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1286,
        GIR_Done,
      // Label 734: @26129
      GIM_Try, /*On fail goto*//*Label 735*/ 26173, // Rule ID 1290 //
        GIM_CheckFeatures, GIFBS_HasDSP_InMicroMips,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, Intrinsic::mips_cmpu_eq_qb,
        GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_void 3813:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (CMPU_EQ_QB_MM DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::CMPU_EQ_QB_MM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rt
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1290,
        GIR_Done,
      // Label 735: @26173
      GIM_Try, /*On fail goto*//*Label 736*/ 26217, // Rule ID 1291 //
        GIM_CheckFeatures, GIFBS_HasDSP_InMicroMips,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, Intrinsic::mips_cmpu_lt_qb,
        GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_void 3815:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (CMPU_LT_QB_MM DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::CMPU_LT_QB_MM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rt
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1291,
        GIR_Done,
      // Label 736: @26217
      GIM_Try, /*On fail goto*//*Label 737*/ 26261, // Rule ID 1292 //
        GIM_CheckFeatures, GIFBS_HasDSP_InMicroMips,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, Intrinsic::mips_cmpu_le_qb,
        GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_void 3814:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (CMPU_LE_QB_MM DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::CMPU_LE_QB_MM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rt
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1292,
        GIR_Done,
      // Label 737: @26261
      GIM_Reject,
    // Label 715: @26262
    GIM_Try, /*On fail goto*//*Label 738*/ 30250,
      GIM_CheckNumOperands, /*MI*/0, /*Expected*/4,
      GIM_Try, /*On fail goto*//*Label 739*/ 26331, // Rule ID 370 //
        GIM_CheckFeatures, GIFBS_HasDSP,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_shll_s_ph,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_immZExt4,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_w_chain:{ *:[v2i16] } 4189:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rt, (imm:{ *:[i32] })<<P:Predicate_immZExt4>>:$rs_sa)  =>  (SHLL_S_PH:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rt, (imm:{ *:[i32] }):$rs_sa)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SHLL_S_PH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rt
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // rs_sa
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, 1, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 370,
        GIR_Done,
      // Label 739: @26331
      GIM_Try, /*On fail goto*//*Label 740*/ 26395, // Rule ID 375 //
        GIM_CheckFeatures, GIFBS_HasDSP,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_shll_s_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_immZExt5,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_w_chain:{ *:[i32] } 4190:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rt, (imm:{ *:[i32] })<<P:Predicate_immZExt5>>:$rs_sa)  =>  (SHLL_S_W:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rt, (imm:{ *:[i32] }):$rs_sa)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SHLL_S_W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rt
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // rs_sa
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, 1, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 375,
        GIR_Done,
      // Label 740: @26395
      GIM_Try, /*On fail goto*//*Label 741*/ 26459, // Rule ID 1221 //
        GIM_CheckFeatures, GIFBS_HasDSP_InMicroMips,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_shll_s_ph,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_immZExt4,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_w_chain:{ *:[v2i16] } 4189:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, (imm:{ *:[i32] })<<P:Predicate_immZExt4>>:$sa)  =>  (SHLL_S_PH_MM:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rs, (imm:{ *:[i32] }):$sa)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SHLL_S_PH_MM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // sa
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, 1, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1221,
        GIR_Done,
      // Label 741: @26459
      GIM_Try, /*On fail goto*//*Label 742*/ 26523, // Rule ID 1226 //
        GIM_CheckFeatures, GIFBS_HasDSP_InMicroMips,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_shll_s_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_immZExt5,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_w_chain:{ *:[i32] } 4190:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rs, (imm:{ *:[i32] })<<P:Predicate_immZExt5>>:$sa)  =>  (SHLL_S_W_MM:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, (imm:{ *:[i32] }):$sa)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SHLL_S_W_MM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // sa
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, 1, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1226,
        GIR_Done,
      // Label 742: @26523
      GIM_Try, /*On fail goto*//*Label 743*/ 26578, // Rule ID 1892 //
        GIM_CheckFeatures, GIFBS_HasDSP,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_shll_ph,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_immZExt4,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_w_chain:{ *:[v2i16] } 4187:{ *:[iPTR] }, v2i16:{ *:[v2i16] }:$a, (imm:{ *:[i32] })<<P:Predicate_immZExt4>>:$shamt)  =>  (SHLL_PH:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$a, (imm:{ *:[i32] })<<P:Predicate_immZExt4>>:$shamt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SHLL_PH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // a
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // shamt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1892,
        GIR_Done,
      // Label 743: @26578
      GIM_Try, /*On fail goto*//*Label 744*/ 26633, // Rule ID 1898 //
        GIM_CheckFeatures, GIFBS_HasDSP,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_shll_qb,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_immZExt3,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_w_chain:{ *:[v4i8] } 4188:{ *:[iPTR] }, v4i8:{ *:[v4i8] }:$a, (imm:{ *:[i32] })<<P:Predicate_immZExt3>>:$shamt)  =>  (SHLL_QB:{ *:[v4i8] } v4i8:{ *:[v4i8] }:$a, (imm:{ *:[i32] })<<P:Predicate_immZExt3>>:$shamt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SHLL_QB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // a
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // shamt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1898,
        GIR_Done,
      // Label 744: @26633
      GIM_Try, /*On fail goto*//*Label 745*/ 26689, // Rule ID 347 //
        GIM_CheckFeatures, GIFBS_HasDSP,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_addq_s_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::GPR32RegClassID,
        // (intrinsic_w_chain:{ *:[i32] } 3644:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (ADDQ_S_W:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::ADDQ_S_W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 347,
        GIR_Done,
      // Label 745: @26689
      GIM_Try, /*On fail goto*//*Label 746*/ 26745, // Rule ID 348 //
        GIM_CheckFeatures, GIFBS_HasDSP,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_subq_s_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::GPR32RegClassID,
        // (intrinsic_w_chain:{ *:[i32] } 4260:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (SUBQ_S_W:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SUBQ_S_W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 348,
        GIR_Done,
      // Label 746: @26745
      GIM_Try, /*On fail goto*//*Label 747*/ 26801, // Rule ID 355 //
        GIM_CheckFeatures, GIFBS_HasDSP,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_precrq_rs_ph_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::GPR32RegClassID,
        // (intrinsic_w_chain:{ *:[v2i16] } 4168:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (PRECRQ_RS_PH_W:{ *:[v2i16] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::PRECRQ_RS_PH_W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 355,
        GIR_Done,
      // Label 747: @26801
      GIM_Try, /*On fail goto*//*Label 748*/ 26857, // Rule ID 356 //
        GIM_CheckFeatures, GIFBS_HasDSP,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_precrqu_s_qb_ph,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_w_chain:{ *:[v4i8] } 4169:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (PRECRQU_S_QB_PH:{ *:[v4i8] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::PRECRQU_S_QB_PH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 356,
        GIR_Done,
      // Label 748: @26857
      GIM_Try, /*On fail goto*//*Label 749*/ 26913, // Rule ID 367 //
        GIM_CheckFeatures, GIFBS_HasDSP,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_shll_qb,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::GPR32RegClassID,
        // (intrinsic_w_chain:{ *:[v4i8] } 4188:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rt, GPR32Opnd:{ *:[i32] }:$rs_sa)  =>  (SHLLV_QB:{ *:[v4i8] } DSPROpnd:{ *:[v4i8] }:$rt, GPR32Opnd:{ *:[i32] }:$rs_sa)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SHLLV_QB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rs_sa
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 367,
        GIR_Done,
      // Label 749: @26913
      GIM_Try, /*On fail goto*//*Label 750*/ 26969, // Rule ID 369 //
        GIM_CheckFeatures, GIFBS_HasDSP,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_shll_ph,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::GPR32RegClassID,
        // (intrinsic_w_chain:{ *:[v2i16] } 4187:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rt, GPR32Opnd:{ *:[i32] }:$rs_sa)  =>  (SHLLV_PH:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rt, GPR32Opnd:{ *:[i32] }:$rs_sa)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SHLLV_PH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rs_sa
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 369,
        GIR_Done,
      // Label 750: @26969
      GIM_Try, /*On fail goto*//*Label 751*/ 27025, // Rule ID 371 //
        GIM_CheckFeatures, GIFBS_HasDSP,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_shll_s_ph,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::GPR32RegClassID,
        // (intrinsic_w_chain:{ *:[v2i16] } 4189:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rt, GPR32Opnd:{ *:[i32] }:$rs_sa)  =>  (SHLLV_S_PH:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rt, GPR32Opnd:{ *:[i32] }:$rs_sa)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SHLLV_S_PH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rs_sa
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 371,
        GIR_Done,
      // Label 751: @27025
      GIM_Try, /*On fail goto*//*Label 752*/ 27081, // Rule ID 376 //
        GIM_CheckFeatures, GIFBS_HasDSP,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_shll_s_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::GPR32RegClassID,
        // (intrinsic_w_chain:{ *:[i32] } 4190:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rt, GPR32Opnd:{ *:[i32] }:$rs_sa)  =>  (SHLLV_S_W:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rt, GPR32Opnd:{ *:[i32] }:$rs_sa)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SHLLV_S_W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rs_sa
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 376,
        GIR_Done,
      // Label 752: @27081
      GIM_Try, /*On fail goto*//*Label 753*/ 27137, // Rule ID 379 //
        GIM_CheckFeatures, GIFBS_HasDSP,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_muleu_s_ph_qbl,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_w_chain:{ *:[v2i16] } 4110:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (MULEU_S_PH_QBL:{ *:[v2i16] } DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::MULEU_S_PH_QBL,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 379,
        GIR_Done,
      // Label 753: @27137
      GIM_Try, /*On fail goto*//*Label 754*/ 27193, // Rule ID 380 //
        GIM_CheckFeatures, GIFBS_HasDSP,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_muleu_s_ph_qbr,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_w_chain:{ *:[v2i16] } 4111:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (MULEU_S_PH_QBR:{ *:[v2i16] } DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::MULEU_S_PH_QBR,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 380,
        GIR_Done,
      // Label 754: @27193
      GIM_Try, /*On fail goto*//*Label 755*/ 27249, // Rule ID 381 //
        GIM_CheckFeatures, GIFBS_HasDSP,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_muleq_s_w_phl,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_w_chain:{ *:[i32] } 4108:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (MULEQ_S_W_PHL:{ *:[i32] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::MULEQ_S_W_PHL,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 381,
        GIR_Done,
      // Label 755: @27249
      GIM_Try, /*On fail goto*//*Label 756*/ 27305, // Rule ID 382 //
        GIM_CheckFeatures, GIFBS_HasDSP,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_muleq_s_w_phr,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_w_chain:{ *:[i32] } 4109:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (MULEQ_S_W_PHR:{ *:[i32] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::MULEQ_S_W_PHR,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 382,
        GIR_Done,
      // Label 756: @27305
      GIM_Try, /*On fail goto*//*Label 757*/ 27361, // Rule ID 383 //
        GIM_CheckFeatures, GIFBS_HasDSP,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_mulq_rs_ph,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_w_chain:{ *:[v2i16] } 4112:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (MULQ_RS_PH:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::MULQ_RS_PH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 383,
        GIR_Done,
      // Label 757: @27361
      GIM_Try, /*On fail goto*//*Label 758*/ 27417, // Rule ID 408 //
        GIM_CheckFeatures, GIFBS_HasDSP,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_cmpgu_eq_qb,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_w_chain:{ *:[i32] } 3810:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (CMPGU_EQ_QB:{ *:[i32] } DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::CMPGU_EQ_QB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 408,
        GIR_Done,
      // Label 758: @27417
      GIM_Try, /*On fail goto*//*Label 759*/ 27473, // Rule ID 409 //
        GIM_CheckFeatures, GIFBS_HasDSP,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_cmpgu_lt_qb,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_w_chain:{ *:[i32] } 3812:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (CMPGU_LT_QB:{ *:[i32] } DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::CMPGU_LT_QB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 409,
        GIR_Done,
      // Label 759: @27473
      GIM_Try, /*On fail goto*//*Label 760*/ 27529, // Rule ID 410 //
        GIM_CheckFeatures, GIFBS_HasDSP,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_cmpgu_le_qb,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_w_chain:{ *:[i32] } 3811:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (CMPGU_LE_QB:{ *:[i32] } DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::CMPGU_LE_QB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 410,
        GIR_Done,
      // Label 760: @27529
      GIM_Try, /*On fail goto*//*Label 761*/ 27585, // Rule ID 420 //
        GIM_CheckFeatures, GIFBS_HasDSP,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_pick_qb,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_w_chain:{ *:[v4i8] } 4152:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (PICK_QB:{ *:[v4i8] } DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::PICK_QB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 420,
        GIR_Done,
      // Label 761: @27585
      GIM_Try, /*On fail goto*//*Label 762*/ 27641, // Rule ID 421 //
        GIM_CheckFeatures, GIFBS_HasDSP,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_pick_ph,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_w_chain:{ *:[v2i16] } 4151:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (PICK_PH:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::PICK_PH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 421,
        GIR_Done,
      // Label 762: @27641
      GIM_Try, /*On fail goto*//*Label 763*/ 27697, // Rule ID 425 //
        GIM_CheckFeatures, GIFBS_HasDSP,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_insv,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::GPR32RegClassID,
        // (intrinsic_w_chain:{ *:[i32] } 4012:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$src, GPR32Opnd:{ *:[i32] }:$rs)  =>  (INSV:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$src, GPR32Opnd:{ *:[i32] }:$rs)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::INSV,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rs
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 425,
        GIR_Done,
      // Label 763: @27697
      GIM_Try, /*On fail goto*//*Label 764*/ 27753, // Rule ID 431 //
        GIM_CheckFeatures, GIFBS_HasDSPR2,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_addu_ph,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_w_chain:{ *:[v2i16] } 3662:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (ADDU_PH:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::ADDU_PH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 431,
        GIR_Done,
      // Label 764: @27753
      GIM_Try, /*On fail goto*//*Label 765*/ 27809, // Rule ID 432 //
        GIM_CheckFeatures, GIFBS_HasDSPR2,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_addu_s_ph,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_w_chain:{ *:[v2i16] } 3664:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (ADDU_S_PH:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::ADDU_S_PH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 432,
        GIR_Done,
      // Label 765: @27809
      GIM_Try, /*On fail goto*//*Label 766*/ 27865, // Rule ID 433 //
        GIM_CheckFeatures, GIFBS_HasDSPR2,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_subu_ph,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_w_chain:{ *:[v2i16] } 4281:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (SUBU_PH:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SUBU_PH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 433,
        GIR_Done,
      // Label 766: @27865
      GIM_Try, /*On fail goto*//*Label 767*/ 27921, // Rule ID 434 //
        GIM_CheckFeatures, GIFBS_HasDSPR2,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_subu_s_ph,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_w_chain:{ *:[v2i16] } 4283:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (SUBU_S_PH:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SUBU_S_PH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 434,
        GIR_Done,
      // Label 767: @27921
      GIM_Try, /*On fail goto*//*Label 768*/ 27977, // Rule ID 435 //
        GIM_CheckFeatures, GIFBS_HasDSPR2,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_cmpgdu_eq_qb,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_w_chain:{ *:[i32] } 3807:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (CMPGDU_EQ_QB:{ *:[i32] } DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::CMPGDU_EQ_QB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 435,
        GIR_Done,
      // Label 768: @27977
      GIM_Try, /*On fail goto*//*Label 769*/ 28033, // Rule ID 436 //
        GIM_CheckFeatures, GIFBS_HasDSPR2,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_cmpgdu_lt_qb,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_w_chain:{ *:[i32] } 3809:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (CMPGDU_LT_QB:{ *:[i32] } DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::CMPGDU_LT_QB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 436,
        GIR_Done,
      // Label 769: @28033
      GIM_Try, /*On fail goto*//*Label 770*/ 28089, // Rule ID 437 //
        GIM_CheckFeatures, GIFBS_HasDSPR2,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_cmpgdu_le_qb,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_w_chain:{ *:[i32] } 3808:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (CMPGDU_LE_QB:{ *:[i32] } DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::CMPGDU_LE_QB,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 437,
        GIR_Done,
      // Label 770: @28089
      GIM_Try, /*On fail goto*//*Label 771*/ 28145, // Rule ID 451 //
        GIM_CheckFeatures, GIFBS_HasDSPR2,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_mul_s_ph,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_w_chain:{ *:[v2i16] } 4107:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (MUL_S_PH:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::MUL_S_PH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 451,
        GIR_Done,
      // Label 771: @28145
      GIM_Try, /*On fail goto*//*Label 772*/ 28201, // Rule ID 452 //
        GIM_CheckFeatures, GIFBS_HasDSPR2,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_mulq_s_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::GPR32RegClassID,
        // (intrinsic_w_chain:{ *:[i32] } 4115:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (MULQ_S_W:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::MULQ_S_W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 452,
        GIR_Done,
      // Label 772: @28201
      GIM_Try, /*On fail goto*//*Label 773*/ 28257, // Rule ID 453 //
        GIM_CheckFeatures, GIFBS_HasDSPR2,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_mulq_rs_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::GPR32RegClassID,
        // (intrinsic_w_chain:{ *:[i32] } 4113:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (MULQ_RS_W:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::MULQ_RS_W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 453,
        GIR_Done,
      // Label 773: @28257
      GIM_Try, /*On fail goto*//*Label 774*/ 28313, // Rule ID 454 //
        GIM_CheckFeatures, GIFBS_HasDSPR2,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_mulq_s_ph,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_w_chain:{ *:[v2i16] } 4114:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (MULQ_S_PH:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::MULQ_S_PH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 454,
        GIR_Done,
      // Label 774: @28313
      GIM_Try, /*On fail goto*//*Label 775*/ 28369, // Rule ID 464 //
        GIM_CheckFeatures, GIFBS_HasDSPR2,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_precr_qb_ph,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_w_chain:{ *:[v4i8] } 4163:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (PRECR_QB_PH:{ *:[v4i8] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::PRECR_QB_PH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 464,
        GIR_Done,
      // Label 775: @28369
      GIM_Try, /*On fail goto*//*Label 776*/ 28425, // Rule ID 1206 //
        GIM_CheckFeatures, GIFBS_HasDSP_InMicroMips,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_addq_s_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::GPR32RegClassID,
        // (intrinsic_w_chain:{ *:[i32] } 3644:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (ADDQ_S_W_MM:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::ADDQ_S_W_MM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1206,
        GIR_Done,
      // Label 776: @28425
      GIM_Try, /*On fail goto*//*Label 777*/ 28481, // Rule ID 1214 //
        GIM_CheckFeatures, GIFBS_HasDSP_InMicroMips,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_insv,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::GPR32RegClassID,
        // (intrinsic_w_chain:{ *:[i32] } 4012:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$src, GPR32Opnd:{ *:[i32] }:$rs)  =>  (INSV_MM:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$src, GPR32Opnd:{ *:[i32] }:$rs)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::INSV_MM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rs
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1214,
        GIR_Done,
      // Label 777: @28481
      GIM_Try, /*On fail goto*//*Label 778*/ 28537, // Rule ID 1222 //
        GIM_CheckFeatures, GIFBS_HasDSP_InMicroMips,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_shll_ph,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::GPR32RegClassID,
        // (intrinsic_w_chain:{ *:[v2i16] } 4187:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rt, GPR32Opnd:{ *:[i32] }:$rs)  =>  (SHLLV_PH_MM:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rt, GPR32Opnd:{ *:[i32] }:$rs)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SHLLV_PH_MM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rs
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1222,
        GIR_Done,
      // Label 778: @28537
      GIM_Try, /*On fail goto*//*Label 779*/ 28593, // Rule ID 1223 //
        GIM_CheckFeatures, GIFBS_HasDSP_InMicroMips,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_shll_s_ph,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::GPR32RegClassID,
        // (intrinsic_w_chain:{ *:[v2i16] } 4189:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rt, GPR32Opnd:{ *:[i32] }:$rs)  =>  (SHLLV_S_PH_MM:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rt, GPR32Opnd:{ *:[i32] }:$rs)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SHLLV_S_PH_MM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rs
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1223,
        GIR_Done,
      // Label 779: @28593
      GIM_Try, /*On fail goto*//*Label 780*/ 28649, // Rule ID 1224 //
        GIM_CheckFeatures, GIFBS_HasDSP_InMicroMips,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_shll_qb,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::GPR32RegClassID,
        // (intrinsic_w_chain:{ *:[v4i8] } 4188:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rt, GPR32Opnd:{ *:[i32] }:$rs)  =>  (SHLLV_QB_MM:{ *:[v4i8] } DSPROpnd:{ *:[v4i8] }:$rt, GPR32Opnd:{ *:[i32] }:$rs)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SHLLV_QB_MM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rs
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1224,
        GIR_Done,
      // Label 780: @28649
      GIM_Try, /*On fail goto*//*Label 781*/ 28705, // Rule ID 1225 //
        GIM_CheckFeatures, GIFBS_HasDSP_InMicroMips,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_shll_s_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::GPR32RegClassID,
        // (intrinsic_w_chain:{ *:[i32] } 4190:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rt, GPR32Opnd:{ *:[i32] }:$rs)  =>  (SHLLV_S_W_MM:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rt, GPR32Opnd:{ *:[i32] }:$rs)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SHLLV_S_W_MM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rs
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1225,
        GIR_Done,
      // Label 781: @28705
      GIM_Try, /*On fail goto*//*Label 782*/ 28761, // Rule ID 1244 //
        GIM_CheckFeatures, GIFBS_HasDSP_InMicroMips,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_subq_s_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::GPR32RegClassID,
        // (intrinsic_w_chain:{ *:[i32] } 4260:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (SUBQ_S_W_MM:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SUBQ_S_W_MM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1244,
        GIR_Done,
      // Label 782: @28761
      GIM_Try, /*On fail goto*//*Label 783*/ 28817, // Rule ID 1250 //
        GIM_CheckFeatures, GIFBS_HasDSP_InMicroMips,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_muleq_s_w_phl,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_w_chain:{ *:[i32] } 4108:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (MULEQ_S_W_PHL_MM:{ *:[i32] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::MULEQ_S_W_PHL_MM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1250,
        GIR_Done,
      // Label 783: @28817
      GIM_Try, /*On fail goto*//*Label 784*/ 28873, // Rule ID 1251 //
        GIM_CheckFeatures, GIFBS_HasDSP_InMicroMips,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_muleq_s_w_phr,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_w_chain:{ *:[i32] } 4109:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (MULEQ_S_W_PHR_MM:{ *:[i32] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::MULEQ_S_W_PHR_MM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1251,
        GIR_Done,
      // Label 784: @28873
      GIM_Try, /*On fail goto*//*Label 785*/ 28929, // Rule ID 1252 //
        GIM_CheckFeatures, GIFBS_HasDSP_InMicroMips,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_muleu_s_ph_qbl,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_w_chain:{ *:[v2i16] } 4110:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (MULEU_S_PH_QBL_MM:{ *:[v2i16] } DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::MULEU_S_PH_QBL_MM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1252,
        GIR_Done,
      // Label 785: @28929
      GIM_Try, /*On fail goto*//*Label 786*/ 28985, // Rule ID 1253 //
        GIM_CheckFeatures, GIFBS_HasDSP_InMicroMips,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_muleu_s_ph_qbr,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_w_chain:{ *:[v2i16] } 4111:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (MULEU_S_PH_QBR_MM:{ *:[v2i16] } DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::MULEU_S_PH_QBR_MM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1253,
        GIR_Done,
      // Label 786: @28985
      GIM_Try, /*On fail goto*//*Label 787*/ 29041, // Rule ID 1254 //
        GIM_CheckFeatures, GIFBS_HasDSP_InMicroMips,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_mulq_rs_ph,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_w_chain:{ *:[v2i16] } 4112:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (MULQ_RS_PH_MM:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::MULQ_RS_PH_MM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1254,
        GIR_Done,
      // Label 787: @29041
      GIM_Try, /*On fail goto*//*Label 788*/ 29097, // Rule ID 1257 //
        GIM_CheckFeatures, GIFBS_HasDSP_InMicroMips,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_precrqu_s_qb_ph,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_w_chain:{ *:[v4i8] } 4169:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (PRECRQU_S_QB_PH_MM:{ *:[v4i8] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::PRECRQU_S_QB_PH_MM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1257,
        GIR_Done,
      // Label 788: @29097
      GIM_Try, /*On fail goto*//*Label 789*/ 29153, // Rule ID 1258 //
        GIM_CheckFeatures, GIFBS_HasDSP_InMicroMips,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_precrq_rs_ph_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::GPR32RegClassID,
        // (intrinsic_w_chain:{ *:[v2i16] } 4168:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (PRECRQ_RS_PH_W_MM:{ *:[v2i16] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::PRECRQ_RS_PH_W_MM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1258,
        GIR_Done,
      // Label 789: @29153
      GIM_Try, /*On fail goto*//*Label 790*/ 29209, // Rule ID 1276 //
        GIM_CheckFeatures, GIFBS_HasDSP_InMicroMips,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_pick_ph,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_w_chain:{ *:[v2i16] } 4151:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (PICK_PH_MM:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::PICK_PH_MM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1276,
        GIR_Done,
      // Label 790: @29209
      GIM_Try, /*On fail goto*//*Label 791*/ 29265, // Rule ID 1277 //
        GIM_CheckFeatures, GIFBS_HasDSP_InMicroMips,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_pick_qb,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_w_chain:{ *:[v4i8] } 4152:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (PICK_QB_MM:{ *:[v4i8] } DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::PICK_QB_MM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1277,
        GIR_Done,
      // Label 791: @29265
      GIM_Try, /*On fail goto*//*Label 792*/ 29321, // Rule ID 1287 //
        GIM_CheckFeatures, GIFBS_HasDSP_InMicroMips,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_cmpgu_eq_qb,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_w_chain:{ *:[i32] } 3810:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (CMPGU_EQ_QB_MM:{ *:[i32] } DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::CMPGU_EQ_QB_MM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1287,
        GIR_Done,
      // Label 792: @29321
      GIM_Try, /*On fail goto*//*Label 793*/ 29377, // Rule ID 1288 //
        GIM_CheckFeatures, GIFBS_HasDSP_InMicroMips,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_cmpgu_lt_qb,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_w_chain:{ *:[i32] } 3812:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (CMPGU_LT_QB_MM:{ *:[i32] } DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::CMPGU_LT_QB_MM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1288,
        GIR_Done,
      // Label 793: @29377
      GIM_Try, /*On fail goto*//*Label 794*/ 29433, // Rule ID 1289 //
        GIM_CheckFeatures, GIFBS_HasDSP_InMicroMips,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_cmpgu_le_qb,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_w_chain:{ *:[i32] } 3811:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (CMPGU_LE_QB_MM:{ *:[i32] } DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::CMPGU_LE_QB_MM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1289,
        GIR_Done,
      // Label 794: @29433
      GIM_Try, /*On fail goto*//*Label 795*/ 29489, // Rule ID 1298 //
        GIM_CheckFeatures, GIFBS_HasDSPR2_InMicroMips,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_addu_ph,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_w_chain:{ *:[v2i16] } 3662:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (ADDU_PH_MMR2:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::ADDU_PH_MMR2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1298,
        GIR_Done,
      // Label 795: @29489
      GIM_Try, /*On fail goto*//*Label 796*/ 29545, // Rule ID 1299 //
        GIM_CheckFeatures, GIFBS_HasDSPR2_InMicroMips,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_addu_s_ph,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_w_chain:{ *:[v2i16] } 3664:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (ADDU_S_PH_MMR2:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::ADDU_S_PH_MMR2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1299,
        GIR_Done,
      // Label 796: @29545
      GIM_Try, /*On fail goto*//*Label 797*/ 29601, // Rule ID 1310 //
        GIM_CheckFeatures, GIFBS_HasDSPR2_InMicroMips,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_cmpgdu_eq_qb,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_w_chain:{ *:[i32] } 3807:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (CMPGDU_EQ_QB_MMR2:{ *:[i32] } DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::CMPGDU_EQ_QB_MMR2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1310,
        GIR_Done,
      // Label 797: @29601
      GIM_Try, /*On fail goto*//*Label 798*/ 29657, // Rule ID 1311 //
        GIM_CheckFeatures, GIFBS_HasDSPR2_InMicroMips,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_cmpgdu_lt_qb,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_w_chain:{ *:[i32] } 3809:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (CMPGDU_LT_QB_MMR2:{ *:[i32] } DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::CMPGDU_LT_QB_MMR2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1311,
        GIR_Done,
      // Label 798: @29657
      GIM_Try, /*On fail goto*//*Label 799*/ 29713, // Rule ID 1312 //
        GIM_CheckFeatures, GIFBS_HasDSPR2_InMicroMips,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_cmpgdu_le_qb,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_w_chain:{ *:[i32] } 3808:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (CMPGDU_LE_QB_MMR2:{ *:[i32] } DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::CMPGDU_LE_QB_MMR2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1312,
        GIR_Done,
      // Label 799: @29713
      GIM_Try, /*On fail goto*//*Label 800*/ 29769, // Rule ID 1318 //
        GIM_CheckFeatures, GIFBS_HasDSPR2_InMicroMips,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_subu_ph,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_w_chain:{ *:[v2i16] } 4281:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (SUBU_PH_MMR2:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SUBU_PH_MMR2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1318,
        GIR_Done,
      // Label 800: @29769
      GIM_Try, /*On fail goto*//*Label 801*/ 29825, // Rule ID 1319 //
        GIM_CheckFeatures, GIFBS_HasDSPR2_InMicroMips,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_subu_s_ph,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_w_chain:{ *:[v2i16] } 4283:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (SUBU_S_PH_MMR2:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SUBU_S_PH_MMR2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1319,
        GIR_Done,
      // Label 801: @29825
      GIM_Try, /*On fail goto*//*Label 802*/ 29881, // Rule ID 1326 //
        GIM_CheckFeatures, GIFBS_HasDSPR2_InMicroMips,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_mul_s_ph,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_w_chain:{ *:[v2i16] } 4107:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (MUL_S_PH_MMR2:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::MUL_S_PH_MMR2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1326,
        GIR_Done,
      // Label 802: @29881
      GIM_Try, /*On fail goto*//*Label 803*/ 29937, // Rule ID 1327 //
        GIM_CheckFeatures, GIFBS_HasDSPR2_InMicroMips,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_mulq_rs_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::GPR32RegClassID,
        // (intrinsic_w_chain:{ *:[i32] } 4113:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (MULQ_RS_W_MMR2:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::MULQ_RS_W_MMR2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1327,
        GIR_Done,
      // Label 803: @29937
      GIM_Try, /*On fail goto*//*Label 804*/ 29993, // Rule ID 1328 //
        GIM_CheckFeatures, GIFBS_HasDSPR2_InMicroMips,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_mulq_s_ph,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_w_chain:{ *:[v2i16] } 4114:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (MULQ_S_PH_MMR2:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::MULQ_S_PH_MMR2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1328,
        GIR_Done,
      // Label 804: @29993
      GIM_Try, /*On fail goto*//*Label 805*/ 30049, // Rule ID 1329 //
        GIM_CheckFeatures, GIFBS_HasDSPR2_InMicroMips,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_mulq_s_w,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::GPR32RegClassID,
        // (intrinsic_w_chain:{ *:[i32] } 4115:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (MULQ_S_W_MMR2:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::MULQ_S_W_MMR2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1329,
        GIR_Done,
      // Label 805: @30049
      GIM_Try, /*On fail goto*//*Label 806*/ 30105, // Rule ID 1330 //
        GIM_CheckFeatures, GIFBS_HasDSPR2_InMicroMips,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_precr_qb_ph,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::DSPRRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_w_chain:{ *:[v4i8] } 4163:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (PRECR_QB_PH_MMR2:{ *:[v4i8] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::PRECR_QB_PH_MMR2,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1330,
        GIR_Done,
      // Label 806: @30105
      GIM_Try, /*On fail goto*//*Label 807*/ 30153, // Rule ID 1879 //
        GIM_CheckFeatures, GIFBS_HasDSPR2,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_mul_ph,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::DSPRRegClassID,
        // (intrinsic_w_chain:{ *:[v2i16] } 4104:{ *:[iPTR] }, v2i16:{ *:[v2i16] }:$a, v2i16:{ *:[v2i16] }:$b)  =>  (MUL_PH:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$a, v2i16:{ *:[v2i16] }:$b)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::MUL_PH,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // a
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // b
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1879,
        GIR_Done,
      // Label 807: @30153
      GIM_Try, /*On fail goto*//*Label 808*/ 30201, // Rule ID 1885 //
        GIM_CheckFeatures, GIFBS_HasDSP,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_addsc,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        // (intrinsic_w_chain:{ *:[i32] } 3661:{ *:[iPTR] }, i32:{ *:[i32] }:$a, i32:{ *:[i32] }:$b)  =>  (ADDSC:{ *:[i32] } i32:{ *:[i32] }:$a, i32:{ *:[i32] }:$b)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::ADDSC,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // a
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // b
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1885,
        GIR_Done,
      // Label 808: @30201
      GIM_Try, /*On fail goto*//*Label 809*/ 30249, // Rule ID 1887 //
        GIM_CheckFeatures, GIFBS_HasDSP,
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, Intrinsic::mips_addwc,
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        // (intrinsic_w_chain:{ *:[i32] } 3676:{ *:[iPTR] }, i32:{ *:[i32] }:$a, i32:{ *:[i32] }:$b)  =>  (ADDWC:{ *:[i32] } i32:{ *:[i32] }:$a, i32:{ *:[i32] }:$b)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::ADDWC,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // a
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // b
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1887,
        GIR_Done,
      // Label 809: @30249
      GIM_Reject,
    // Label 738: @30250
    GIM_Reject,
    // Label 17: @30251
    GIM_Try, /*On fail goto*//*Label 810*/ 30316, // Rule ID 1560 //
      GIM_CheckFeatures, GIFBS_HasMips3_HasStdEnc_IsGP64bit,
      GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::GPR32RegClassID,
      // (anyext:{ *:[i64] } GPR32:{ *:[i32] }:$src)  =>  (INSERT_SUBREG:{ *:[i64] } (IMPLICIT_DEF:{ *:[i64] }), GPR32:{ *:[i32] }:$src, sub_32:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::INSERT_SUBREG,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm, /*InsnID*/0, /*Imm*/1,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC GPR64*/38,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, /*RC GPR64*/38,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/2, /*RC GPR32*/8,
      // GIR_Coverage, 1560,
      GIR_Done,
    // Label 810: @30316
    GIM_Reject,
    // Label 18: @30317
    GIM_Try, /*On fail goto*//*Label 811*/ 30379, // Rule ID 1555 //
      GIM_CheckFeatures, GIFBS_HasMips3_HasStdEnc_IsGP64bit,
      GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::GPR64RegClassID,
      // (trunc:{ *:[i32] } GPR64:{ *:[i64] }:$src)  =>  (SLL:{ *:[i32] } (EXTRACT_SUBREG:{ *:[i32] } GPR64:{ *:[i64] }:$src, sub_32:{ *:[i32] }), 0:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_CopySubReg, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, /*SubRegIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, /*RC GPR32*/8,
      GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, /*RC GPR64*/38,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SLL,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1555,
      GIR_Done,
    // Label 811: @30379
    GIM_Reject,
    // Label 19: @30380
    GIM_Try, /*On fail goto*//*Label 812*/ 30439,
      GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 813*/ 30412, // Rule ID 2110 //
        GIM_CheckFeatures, GIFBS_InMicroMips,
        GIM_CheckI64ImmPredicate, /*MI*/0, /*Predicate*/GIPFP_I64_Predicate_immLi16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPRMM16RegClassID,
        // MIs[0] Operand 1
        // No operand predicates
        // (imm:{ *:[i32] })<<P:Predicate_immLi16>>:$imm  =>  (LI16_MM:{ *:[i32] } (imm:{ *:[i32] })<<P:Predicate_immLi16>>:$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::LI16_MM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/0, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2110,
        GIR_Done,
      // Label 813: @30412
      GIM_Try, /*On fail goto*//*Label 814*/ 30438, // Rule ID 1803 //
        GIM_CheckFeatures, GIFBS_InMips16Mode,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::CPU16RegsRegClassID,
        // MIs[0] Operand 1
        // No operand predicates
        // (imm:{ *:[i32] }):$imm  =>  (LwConstant32:{ *:[i32] } (imm:{ *:[i32] }):$imm, -1:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::LwConstant32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rx
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/0, // imm
        GIR_AddImm, /*InsnID*/0, /*Imm*/-1,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1803,
        GIR_Done,
      // Label 814: @30438
      GIM_Reject,
    // Label 812: @30439
    GIM_Reject,
    // Label 20: @30440
    GIM_Try, /*On fail goto*//*Label 815*/ 31697,
      GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR64RegClassID,
      GIM_Try, /*On fail goto*//*Label 816*/ 30553, // Rule ID 1594 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ASHR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/Mips::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIPFP_I64_Predicate_immZExt5,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (sext:{ *:[i64] } (sra:{ *:[i32] } GPR32:{ *:[i32] }:$src, (imm:{ *:[i32] })<<P:Predicate_immZExt5>>:$imm5))  =>  (INSERT_SUBREG:{ *:[i64] } (IMPLICIT_DEF:{ *:[i64] }), (SRA:{ *:[i32] } GPR32:{ *:[i32] }:$src, (imm:{ *:[i32] })<<P:Predicate_immZExt5>>:$imm5), sub_32:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/Mips::SRA,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/1, // src
        GIR_CopyConstantAsSImm, /*NewInsnID*/2, /*OldInsnID*/2, // imm5
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::INSERT_SUBREG,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/0, /*Imm*/1,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC GPR64*/38,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, /*RC GPR64*/38,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/2, /*RC GPR32*/8,
        // GIR_Coverage, 1594,
        GIR_Done,
      // Label 816: @30553
      GIM_Try, /*On fail goto*//*Label 817*/ 30652, // Rule ID 1592 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_LSHR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/Mips::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIPFP_I64_Predicate_immZExt5,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (sext:{ *:[i64] } (srl:{ *:[i32] } GPR32:{ *:[i32] }:$src, (imm:{ *:[i32] })<<P:Predicate_immZExt5>>:$imm5))  =>  (INSERT_SUBREG:{ *:[i64] } (IMPLICIT_DEF:{ *:[i64] }), (SRL:{ *:[i32] } GPR32:{ *:[i32] }:$src, (imm:{ *:[i32] })<<P:Predicate_immZExt5>>:$imm5), sub_32:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/Mips::SRL,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/1, // src
        GIR_CopyConstantAsSImm, /*NewInsnID*/2, /*OldInsnID*/2, // imm5
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::INSERT_SUBREG,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/0, /*Imm*/1,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC GPR64*/38,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, /*RC GPR64*/38,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/2, /*RC GPR32*/8,
        // GIR_Coverage, 1592,
        GIR_Done,
      // Label 817: @30652
      GIM_Try, /*On fail goto*//*Label 818*/ 30751, // Rule ID 1590 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SHL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/Mips::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIPFP_I64_Predicate_immZExt5,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (sext:{ *:[i64] } (shl:{ *:[i32] } GPR32:{ *:[i32] }:$src, (imm:{ *:[i32] })<<P:Predicate_immZExt5>>:$imm5))  =>  (INSERT_SUBREG:{ *:[i64] } (IMPLICIT_DEF:{ *:[i64] }), (SLL:{ *:[i32] } GPR32:{ *:[i32] }:$src, (imm:{ *:[i32] })<<P:Predicate_immZExt5>>:$imm5), sub_32:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/Mips::SLL,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/1, // src
        GIR_CopyConstantAsSImm, /*NewInsnID*/2, /*OldInsnID*/2, // imm5
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::INSERT_SUBREG,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/0, /*Imm*/1,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC GPR64*/38,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, /*RC GPR64*/38,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/2, /*RC GPR32*/8,
        // GIR_Coverage, 1590,
        GIR_Done,
      // Label 818: @30751
      GIM_Try, /*On fail goto*//*Label 819*/ 30843, // Rule ID 1585 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ADD,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sext:{ *:[i64] } (add:{ *:[i32] } GPR32:{ *:[i32] }:$src, GPR32:{ *:[i32] }:$src2))  =>  (INSERT_SUBREG:{ *:[i64] } (IMPLICIT_DEF:{ *:[i64] }), (ADDu:{ *:[i32] } GPR32:{ *:[i32] }:$src, GPR32:{ *:[i32] }:$src2), sub_32:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/Mips::ADDu,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/1, // src
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/2, // src2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::INSERT_SUBREG,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/0, /*Imm*/1,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC GPR64*/38,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, /*RC GPR64*/38,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/2, /*RC GPR32*/8,
        // GIR_Coverage, 1585,
        GIR_Done,
      // Label 819: @30843
      GIM_Try, /*On fail goto*//*Label 820*/ 30935, // Rule ID 1595 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ASHR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sext:{ *:[i64] } (sra:{ *:[i32] } GPR32:{ *:[i32] }:$src, GPR32:{ *:[i32] }:$src2))  =>  (INSERT_SUBREG:{ *:[i64] } (IMPLICIT_DEF:{ *:[i64] }), (SRAV:{ *:[i32] } GPR32:{ *:[i32] }:$src, GPR32:{ *:[i32] }:$src2), sub_32:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/Mips::SRAV,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/1, // src
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/2, // src2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::INSERT_SUBREG,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/0, /*Imm*/1,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC GPR64*/38,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, /*RC GPR64*/38,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/2, /*RC GPR32*/8,
        // GIR_Coverage, 1595,
        GIR_Done,
      // Label 820: @30935
      GIM_Try, /*On fail goto*//*Label 821*/ 31027, // Rule ID 1593 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_LSHR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sext:{ *:[i64] } (srl:{ *:[i32] } GPR32:{ *:[i32] }:$src, GPR32:{ *:[i32] }:$src2))  =>  (INSERT_SUBREG:{ *:[i64] } (IMPLICIT_DEF:{ *:[i64] }), (SRLV:{ *:[i32] } GPR32:{ *:[i32] }:$src, GPR32:{ *:[i32] }:$src2), sub_32:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/Mips::SRLV,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/1, // src
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/2, // src2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::INSERT_SUBREG,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/0, /*Imm*/1,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC GPR64*/38,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, /*RC GPR64*/38,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/2, /*RC GPR32*/8,
        // GIR_Coverage, 1593,
        GIR_Done,
      // Label 821: @31027
      GIM_Try, /*On fail goto*//*Label 822*/ 31121, // Rule ID 1770 //
        GIM_CheckFeatures, GIFBS_HasMips64r6_HasStdEnc,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sext:{ *:[i64] } (mul:{ *:[i32] } GPR32:{ *:[i32] }:$src, GPR32:{ *:[i32] }:$src2))  =>  (INSERT_SUBREG:{ *:[i64] } (IMPLICIT_DEF:{ *:[i64] }), (MUL_R6:{ *:[i32] } GPR32:{ *:[i32] }:$src, GPR32:{ *:[i32] }:$src2), sub_32:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/Mips::MUL_R6,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/1, // src
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/2, // src2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::INSERT_SUBREG,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/0, /*Imm*/1,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC GPR64*/38,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, /*RC GPR64*/38,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/2, /*RC GPR32*/8,
        // GIR_Coverage, 1770,
        GIR_Done,
      // Label 822: @31121
      GIM_Try, /*On fail goto*//*Label 823*/ 31215, // Rule ID 1771 //
        GIM_CheckFeatures, GIFBS_HasMips64r6_HasStdEnc,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SDIV,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sext:{ *:[i64] } (sdiv:{ *:[i32] } GPR32:{ *:[i32] }:$src, GPR32:{ *:[i32] }:$src2))  =>  (INSERT_SUBREG:{ *:[i64] } (IMPLICIT_DEF:{ *:[i64] }), (DIV:{ *:[i32] } GPR32:{ *:[i32] }:$src, GPR32:{ *:[i32] }:$src2), sub_32:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/Mips::DIV,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/1, // src
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/2, // src2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::INSERT_SUBREG,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/0, /*Imm*/1,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC GPR64*/38,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, /*RC GPR64*/38,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/2, /*RC GPR32*/8,
        // GIR_Coverage, 1771,
        GIR_Done,
      // Label 823: @31215
      GIM_Try, /*On fail goto*//*Label 824*/ 31307, // Rule ID 1591 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SHL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sext:{ *:[i64] } (shl:{ *:[i32] } GPR32:{ *:[i32] }:$src, GPR32:{ *:[i32] }:$src2))  =>  (INSERT_SUBREG:{ *:[i64] } (IMPLICIT_DEF:{ *:[i64] }), (SLLV:{ *:[i32] } GPR32:{ *:[i32] }:$src, GPR32:{ *:[i32] }:$src2), sub_32:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/Mips::SLLV,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/1, // src
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/2, // src2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::INSERT_SUBREG,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/0, /*Imm*/1,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC GPR64*/38,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, /*RC GPR64*/38,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/2, /*RC GPR32*/8,
        // GIR_Coverage, 1591,
        GIR_Done,
      // Label 824: @31307
      GIM_Try, /*On fail goto*//*Label 825*/ 31401, // Rule ID 1773 //
        GIM_CheckFeatures, GIFBS_HasMips64r6_HasStdEnc,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SREM,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sext:{ *:[i64] } (srem:{ *:[i32] } GPR32:{ *:[i32] }:$src, GPR32:{ *:[i32] }:$src2))  =>  (INSERT_SUBREG:{ *:[i64] } (IMPLICIT_DEF:{ *:[i64] }), (MOD:{ *:[i32] } GPR32:{ *:[i32] }:$src, GPR32:{ *:[i32] }:$src2), sub_32:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/Mips::MOD,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/1, // src
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/2, // src2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::INSERT_SUBREG,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/0, /*Imm*/1,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC GPR64*/38,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, /*RC GPR64*/38,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/2, /*RC GPR32*/8,
        // GIR_Coverage, 1773,
        GIR_Done,
      // Label 825: @31401
      GIM_Try, /*On fail goto*//*Label 826*/ 31493, // Rule ID 1586 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SUB,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sext:{ *:[i64] } (sub:{ *:[i32] } GPR32:{ *:[i32] }:$src, GPR32:{ *:[i32] }:$src2))  =>  (INSERT_SUBREG:{ *:[i64] } (IMPLICIT_DEF:{ *:[i64] }), (SUBu:{ *:[i32] } GPR32:{ *:[i32] }:$src, GPR32:{ *:[i32] }:$src2), sub_32:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/Mips::SUBu,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/1, // src
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/2, // src2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::INSERT_SUBREG,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/0, /*Imm*/1,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC GPR64*/38,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, /*RC GPR64*/38,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/2, /*RC GPR32*/8,
        // GIR_Coverage, 1586,
        GIR_Done,
      // Label 826: @31493
      GIM_Try, /*On fail goto*//*Label 827*/ 31587, // Rule ID 1772 //
        GIM_CheckFeatures, GIFBS_HasMips64r6_HasStdEnc,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_UDIV,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sext:{ *:[i64] } (udiv:{ *:[i32] } GPR32:{ *:[i32] }:$src, GPR32:{ *:[i32] }:$src2))  =>  (INSERT_SUBREG:{ *:[i64] } (IMPLICIT_DEF:{ *:[i64] }), (DIVU:{ *:[i32] } GPR32:{ *:[i32] }:$src, GPR32:{ *:[i32] }:$src2), sub_32:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/Mips::DIVU,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/1, // src
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/2, // src2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::INSERT_SUBREG,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/0, /*Imm*/1,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC GPR64*/38,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, /*RC GPR64*/38,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/2, /*RC GPR32*/8,
        // GIR_Coverage, 1772,
        GIR_Done,
      // Label 827: @31587
      GIM_Try, /*On fail goto*//*Label 828*/ 31681, // Rule ID 1774 //
        GIM_CheckFeatures, GIFBS_HasMips64r6_HasStdEnc,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_UREM,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sext:{ *:[i64] } (urem:{ *:[i32] } GPR32:{ *:[i32] }:$src, GPR32:{ *:[i32] }:$src2))  =>  (INSERT_SUBREG:{ *:[i64] } (IMPLICIT_DEF:{ *:[i64] }), (MODU:{ *:[i32] } GPR32:{ *:[i32] }:$src, GPR32:{ *:[i32] }:$src2), sub_32:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/Mips::MODU,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/1, // src
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/2, // src2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::INSERT_SUBREG,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/0, /*Imm*/1,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, /*RC GPR64*/38,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, /*RC GPR64*/38,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/2, /*RC GPR32*/8,
        // GIR_Coverage, 1774,
        GIR_Done,
      // Label 828: @31681
      GIM_Try, /*On fail goto*//*Label 829*/ 31696, // Rule ID 1562 //
        GIM_CheckFeatures, GIFBS_HasMips3_HasStdEnc_IsGP64bit,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::GPR32RegClassID,
        // (sext:{ *:[i64] } GPR32:{ *:[i32] }:$src)  =>  (SLL64_32:{ *:[i64] } GPR32:{ *:[i32] }:$src)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::SLL64_32,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1562,
        GIR_Done,
      // Label 829: @31696
      GIM_Reject,
    // Label 815: @31697
    GIM_Reject,
    // Label 21: @31698
    GIM_Try, /*On fail goto*//*Label 830*/ 31891,
      GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR64RegClassID,
      GIM_Try, /*On fail goto*//*Label 831*/ 31765, // Rule ID 268 //
        GIM_CheckFeatures, GIFBS_HasCnMips,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ICMP,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s64,
        // MIs[1] Operand 1
        GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/CmpInst::ICMP_EQ,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/Mips::GPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/Mips::GPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (zext:{ *:[i64] } (setcc:{ *:[i32] } GPR64Opnd:{ *:[i64] }:$rs, GPR64Opnd:{ *:[i64] }:$rt, SETEQ:{ *:[Other] }))  =>  (SEQ:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rs, GPR64Opnd:{ *:[i64] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SEQ,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // rt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 268,
        GIR_Done,
      // Label 831: @31765
      GIM_Try, /*On fail goto*//*Label 832*/ 31818, // Rule ID 270 //
        GIM_CheckFeatures, GIFBS_HasCnMips,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ICMP,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s64,
        // MIs[1] Operand 1
        GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/CmpInst::ICMP_NE,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/Mips::GPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/Mips::GPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (zext:{ *:[i64] } (setcc:{ *:[i32] } GPR64Opnd:{ *:[i64] }:$rs, GPR64Opnd:{ *:[i64] }:$rt, SETNE:{ *:[Other] }))  =>  (SNE:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rs, GPR64Opnd:{ *:[i64] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SNE,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // rt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 270,
        GIR_Done,
      // Label 832: @31818
      GIM_Try, /*On fail goto*//*Label 833*/ 31890,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::GPR32RegClassID,
        GIM_Try, /*On fail goto*//*Label 834*/ 31863, // Rule ID 1561 //
          GIM_CheckFeatures, GIFBS_HasMips3_HasStdEnc_IsGP64bit,
          // (zext:{ *:[i64] } GPR32:{ *:[i32] }:$src)  =>  (DSRL:{ *:[i64] } (DSLL64_32:{ *:[i64] } GPR32:{ *:[i32] }:$src), 32:{ *:[i32] })
          GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
          GIR_BuildMI, /*InsnID*/1, /*Opcode*/Mips::DSLL64_32,
          GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
          GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // src
          GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
          GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::DSRL,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
          GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
          GIR_AddImm, /*InsnID*/0, /*Imm*/32,
          GIR_EraseFromParent, /*InsnID*/0,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
          // GIR_Coverage, 1561,
          GIR_Done,
        // Label 834: @31863
        GIM_Try, /*On fail goto*//*Label 835*/ 31889, // Rule ID 1563 //
          GIM_CheckFeatures, GIFBS_HasMips64r2_HasStdEnc_IsGP64bit_NotInMicroMips,
          // (zext:{ *:[i64] } GPR32:{ *:[i32] }:$src)  =>  (DEXT64_32:{ *:[i64] } GPR32:{ *:[i32] }:$src, 0:{ *:[i32] }, 32:{ *:[i32] })
          GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::DEXT64_32,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rt
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
          GIR_AddImm, /*InsnID*/0, /*Imm*/0,
          GIR_AddImm, /*InsnID*/0, /*Imm*/32,
          GIR_EraseFromParent, /*InsnID*/0,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
          // GIR_Coverage, 1563,
          GIR_Done,
        // Label 835: @31889
        GIM_Reject,
      // Label 833: @31890
      GIM_Reject,
    // Label 830: @31891
    GIM_Reject,
    // Label 22: @31892
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 9, /*)*//*default:*//*Label 842*/ 33644,
    /*GILLT_s32*//*Label 836*/ 31906,
    /*GILLT_s64*//*Label 837*/ 32159, 0,
    /*GILLT_v2s64*//*Label 838*/ 32293, 0,
    /*GILLT_v4s32*//*Label 839*/ 32325,
    /*GILLT_v8s16*//*Label 840*/ 32594,
    /*GILLT_v16s8*//*Label 841*/ 32991,
    // Label 836: @31906
    GIM_Try, /*On fail goto*//*Label 843*/ 32158,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 844*/ 31959, // Rule ID 55 //
        GIM_CheckFeatures, GIFBS_HasStdEnc_NotInMicroMips,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_immZExt5,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (shl:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rt, (imm:{ *:[i32] })<<P:Predicate_immZExt5>>:$shamt)  =>  (SLL:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rt, (imm:{ *:[i32] }):$shamt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SLL,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rt
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // shamt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 55,
        GIR_Done,
      // Label 844: @31959
      GIM_Try, /*On fail goto*//*Label 845*/ 32002, // Rule ID 1785 //
        GIM_CheckFeatures, GIFBS_InMips16Mode,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::CPU16RegsRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::CPU16RegsRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_immZExt5,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (shl:{ *:[i32] } CPU16Regs:{ *:[i32] }:$in, (imm:{ *:[i32] })<<P:Predicate_immZExt5>>:$imm)  =>  (SllX16:{ *:[i32] } CPU16Regs:{ *:[i32] }:$in, (imm:{ *:[i32] })<<P:Predicate_immZExt5>>:$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SllX16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rx
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // in
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1785,
        GIR_Done,
      // Label 845: @32002
      GIM_Try, /*On fail goto*//*Label 846*/ 32045, // Rule ID 2122 //
        GIM_CheckFeatures, GIFBS_InMicroMips,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPRMM16RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::GPRMM16RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_immZExt2Shift,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (shl:{ *:[i32] } GPRMM16:{ *:[i32] }:$src, (imm:{ *:[i32] })<<P:Predicate_immZExt2Shift>>:$imm)  =>  (SLL16_MM:{ *:[i32] } GPRMM16:{ *:[i32] }:$src, (imm:{ *:[i32] })<<P:Predicate_immZExt2Shift>>:$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SLL16_MM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2122,
        GIR_Done,
      // Label 846: @32045
      GIM_Try, /*On fail goto*//*Label 847*/ 32088, // Rule ID 2123 //
        GIM_CheckFeatures, GIFBS_InMicroMips,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_immZExt5,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (shl:{ *:[i32] } GPR32:{ *:[i32] }:$src, (imm:{ *:[i32] })<<P:Predicate_immZExt5>>:$imm)  =>  (SLL_MM:{ *:[i32] } GPR32:{ *:[i32] }:$src, (imm:{ *:[i32] })<<P:Predicate_immZExt5>>:$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SLL_MM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2123,
        GIR_Done,
      // Label 847: @32088
      GIM_Try, /*On fail goto*//*Label 848*/ 32111, // Rule ID 58 //
        GIM_CheckFeatures, GIFBS_HasStdEnc_NotInMicroMips,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR32RegClassID,
        // (shl:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rt, GPR32Opnd:{ *:[i32] }:$rs)  =>  (SLLV:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rt, GPR32Opnd:{ *:[i32] }:$rs)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::SLLV,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 58,
        GIR_Done,
      // Label 848: @32111
      GIM_Try, /*On fail goto*//*Label 849*/ 32134, // Rule ID 1788 //
        GIM_CheckFeatures, GIFBS_InMips16Mode,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::CPU16RegsRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::CPU16RegsRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::CPU16RegsRegClassID,
        // (shl:{ *:[i32] } CPU16Regs:{ *:[i32] }:$r, CPU16Regs:{ *:[i32] }:$ra)  =>  (SllvRxRy16:{ *:[i32] } CPU16Regs:{ *:[i32] }:$r, CPU16Regs:{ *:[i32] }:$ra)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::SllvRxRy16,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1788,
        GIR_Done,
      // Label 849: @32134
      GIM_Try, /*On fail goto*//*Label 850*/ 32157, // Rule ID 2124 //
        GIM_CheckFeatures, GIFBS_InMicroMips,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR32RegClassID,
        // (shl:{ *:[i32] } GPR32:{ *:[i32] }:$lhs, GPR32:{ *:[i32] }:$rhs)  =>  (SLLV_MM:{ *:[i32] } GPR32:{ *:[i32] }:$lhs, GPR32:{ *:[i32] }:$rhs)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::SLLV_MM,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2124,
        GIR_Done,
      // Label 850: @32157
      GIM_Reject,
    // Label 843: @32158
    GIM_Reject,
    // Label 837: @32159
    GIM_Try, /*On fail goto*//*Label 851*/ 32292,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::GPR64RegClassID,
      GIM_Try, /*On fail goto*//*Label 852*/ 32212, // Rule ID 204 //
        GIM_CheckFeatures, GIFBS_HasMips3_HasStdEnc_NotInMicroMips,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_immZExt6,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (shl:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rt, (imm:{ *:[i32] })<<P:Predicate_immZExt6>>:$shamt)  =>  (DSLL:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rt, (imm:{ *:[i32] }):$shamt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::DSLL,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rt
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // shamt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 204,
        GIR_Done,
      // Label 852: @32212
      GIM_Try, /*On fail goto*//*Label 853*/ 32276, // Rule ID 1556 //
        GIM_CheckFeatures, GIFBS_HasMips3_HasStdEnc_IsGP64bit,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_TRUNC,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/Mips::GPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (shl:{ *:[i64] } GPR64:{ *:[i64] }:$rt, (trunc:{ *:[i32] } GPR64:{ *:[i64] }:$rs))  =>  (DSLLV:{ *:[i64] } GPR64:{ *:[i64] }:$rt, (EXTRACT_SUBREG:{ *:[i32] } GPR64:{ *:[i64] }:$rs, sub_32:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/1, // rs
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, /*RC GPR32*/8,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, /*RC GPR64*/38,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::DSLLV,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rt
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1556,
        GIR_Done,
      // Label 853: @32276
      GIM_Try, /*On fail goto*//*Label 854*/ 32291, // Rule ID 207 //
        GIM_CheckFeatures, GIFBS_HasMips3_HasStdEnc_NotInMicroMips,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR32RegClassID,
        // (shl:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rt, GPR32Opnd:{ *:[i32] }:$rs)  =>  (DSLLV:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rt, GPR32Opnd:{ *:[i32] }:$rs)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::DSLLV,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 207,
        GIR_Done,
      // Label 854: @32291
      GIM_Reject,
    // Label 851: @32292
    GIM_Reject,
    // Label 838: @32293
    GIM_Try, /*On fail goto*//*Label 855*/ 32324, // Rule ID 944 //
      GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::MSA128DRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128DRegClassID,
      // (shl:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)  =>  (SLL_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::SLL_D,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 944,
      GIR_Done,
    // Label 855: @32324
    GIM_Reject,
    // Label 839: @32325
    GIM_Try, /*On fail goto*//*Label 856*/ 32593,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
      GIM_Try, /*On fail goto*//*Label 857*/ 32456, // Rule ID 2414 //
        GIM_CheckFeatures, GIFBS_HasMSA,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_BUILD_VECTOR,
        GIM_CheckNumOperands, /*MI*/2, /*Expected*/5,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/4, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIPFP_I64_Predicate_immi32Cst31,
        // MIs[3] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/2, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/4, /*Predicate*/GIPFP_I64_Predicate_immi32Cst31,
        // MIs[4] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/2, /*OpIdx*/3, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/5, /*Predicate*/GIPFP_I64_Predicate_immi32Cst31,
        // MIs[5] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/2, /*OpIdx*/4, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/6, /*Predicate*/GIPFP_I64_Predicate_immi32Cst31,
        // MIs[6] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        GIM_CheckIsSafeToFold, /*InsnID*/5,
        GIM_CheckIsSafeToFold, /*InsnID*/6,
        // (shl:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$ws, (and:{ *:[v4i32] } (build_vector:{ *:[v4i32] } (imm:{ *:[i32] })<<P:Predicate_immi32Cst31>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst31>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst31>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst31>>), v4i32:{ *:[v4i32] }:$wt))  =>  (SLL_W:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$ws, v4i32:{ *:[v4i32] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SLL_W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2414,
        GIR_Done,
      // Label 857: @32456
      GIM_Try, /*On fail goto*//*Label 858*/ 32573, // Rule ID 2025 //
        GIM_CheckFeatures, GIFBS_HasMSA,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_BUILD_VECTOR,
        GIM_CheckNumOperands, /*MI*/2, /*Expected*/5,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/4, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIPFP_I64_Predicate_immi32Cst31,
        // MIs[3] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/2, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/4, /*Predicate*/GIPFP_I64_Predicate_immi32Cst31,
        // MIs[4] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/2, /*OpIdx*/3, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/5, /*Predicate*/GIPFP_I64_Predicate_immi32Cst31,
        // MIs[5] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/2, /*OpIdx*/4, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/6, /*Predicate*/GIPFP_I64_Predicate_immi32Cst31,
        // MIs[6] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        GIM_CheckIsSafeToFold, /*InsnID*/5,
        GIM_CheckIsSafeToFold, /*InsnID*/6,
        // (shl:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$ws, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$wt, (build_vector:{ *:[v4i32] } (imm:{ *:[i32] })<<P:Predicate_immi32Cst31>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst31>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst31>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst31>>)))  =>  (SLL_W:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$ws, v4i32:{ *:[v4i32] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SLL_W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2025,
        GIR_Done,
      // Label 858: @32573
      GIM_Try, /*On fail goto*//*Label 859*/ 32592, // Rule ID 943 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128WRegClassID,
        // (shl:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (SLL_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::SLL_W,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 943,
        GIR_Done,
      // Label 859: @32592
      GIM_Reject,
    // Label 856: @32593
    GIM_Reject,
    // Label 840: @32594
    GIM_Try, /*On fail goto*//*Label 860*/ 32990,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128HRegClassID,
      GIM_Try, /*On fail goto*//*Label 861*/ 32789, // Rule ID 2413 //
        GIM_CheckFeatures, GIFBS_HasMSA,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_BUILD_VECTOR,
        GIM_CheckNumOperands, /*MI*/2, /*Expected*/9,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/4, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/5, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/6, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/7, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/8, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIPFP_I64_Predicate_immi32Cst15,
        // MIs[3] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/2, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/4, /*Predicate*/GIPFP_I64_Predicate_immi32Cst15,
        // MIs[4] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/2, /*OpIdx*/3, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/5, /*Predicate*/GIPFP_I64_Predicate_immi32Cst15,
        // MIs[5] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/2, /*OpIdx*/4, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/6, /*Predicate*/GIPFP_I64_Predicate_immi32Cst15,
        // MIs[6] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/7, /*MI*/2, /*OpIdx*/5, // MIs[7]
        GIM_CheckOpcode, /*MI*/7, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/7, /*Predicate*/GIPFP_I64_Predicate_immi32Cst15,
        // MIs[7] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/8, /*MI*/2, /*OpIdx*/6, // MIs[8]
        GIM_CheckOpcode, /*MI*/8, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/8, /*Predicate*/GIPFP_I64_Predicate_immi32Cst15,
        // MIs[8] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/9, /*MI*/2, /*OpIdx*/7, // MIs[9]
        GIM_CheckOpcode, /*MI*/9, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/9, /*Predicate*/GIPFP_I64_Predicate_immi32Cst15,
        // MIs[9] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/10, /*MI*/2, /*OpIdx*/8, // MIs[10]
        GIM_CheckOpcode, /*MI*/10, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/10, /*Predicate*/GIPFP_I64_Predicate_immi32Cst15,
        // MIs[10] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        GIM_CheckIsSafeToFold, /*InsnID*/5,
        GIM_CheckIsSafeToFold, /*InsnID*/6,
        GIM_CheckIsSafeToFold, /*InsnID*/7,
        GIM_CheckIsSafeToFold, /*InsnID*/8,
        GIM_CheckIsSafeToFold, /*InsnID*/9,
        GIM_CheckIsSafeToFold, /*InsnID*/10,
        // (shl:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$ws, (and:{ *:[v8i16] } (build_vector:{ *:[v8i16] } (imm:{ *:[i32] })<<P:Predicate_immi32Cst15>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst15>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst15>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst15>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst15>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst15>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst15>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst15>>), v8i16:{ *:[v8i16] }:$wt))  =>  (SLL_H:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$ws, v8i16:{ *:[v8i16] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SLL_H,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2413,
        GIR_Done,
      // Label 861: @32789
      GIM_Try, /*On fail goto*//*Label 862*/ 32970, // Rule ID 2024 //
        GIM_CheckFeatures, GIFBS_HasMSA,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_BUILD_VECTOR,
        GIM_CheckNumOperands, /*MI*/2, /*Expected*/9,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/4, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/5, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/6, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/7, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/8, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIPFP_I64_Predicate_immi32Cst15,
        // MIs[3] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/2, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/4, /*Predicate*/GIPFP_I64_Predicate_immi32Cst15,
        // MIs[4] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/2, /*OpIdx*/3, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/5, /*Predicate*/GIPFP_I64_Predicate_immi32Cst15,
        // MIs[5] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/2, /*OpIdx*/4, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/6, /*Predicate*/GIPFP_I64_Predicate_immi32Cst15,
        // MIs[6] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/7, /*MI*/2, /*OpIdx*/5, // MIs[7]
        GIM_CheckOpcode, /*MI*/7, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/7, /*Predicate*/GIPFP_I64_Predicate_immi32Cst15,
        // MIs[7] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/8, /*MI*/2, /*OpIdx*/6, // MIs[8]
        GIM_CheckOpcode, /*MI*/8, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/8, /*Predicate*/GIPFP_I64_Predicate_immi32Cst15,
        // MIs[8] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/9, /*MI*/2, /*OpIdx*/7, // MIs[9]
        GIM_CheckOpcode, /*MI*/9, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/9, /*Predicate*/GIPFP_I64_Predicate_immi32Cst15,
        // MIs[9] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/10, /*MI*/2, /*OpIdx*/8, // MIs[10]
        GIM_CheckOpcode, /*MI*/10, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/10, /*Predicate*/GIPFP_I64_Predicate_immi32Cst15,
        // MIs[10] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        GIM_CheckIsSafeToFold, /*InsnID*/5,
        GIM_CheckIsSafeToFold, /*InsnID*/6,
        GIM_CheckIsSafeToFold, /*InsnID*/7,
        GIM_CheckIsSafeToFold, /*InsnID*/8,
        GIM_CheckIsSafeToFold, /*InsnID*/9,
        GIM_CheckIsSafeToFold, /*InsnID*/10,
        // (shl:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$ws, (and:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$wt, (build_vector:{ *:[v8i16] } (imm:{ *:[i32] })<<P:Predicate_immi32Cst15>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst15>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst15>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst15>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst15>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst15>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst15>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst15>>)))  =>  (SLL_H:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$ws, v8i16:{ *:[v8i16] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SLL_H,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2024,
        GIR_Done,
      // Label 862: @32970
      GIM_Try, /*On fail goto*//*Label 863*/ 32989, // Rule ID 942 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128HRegClassID,
        // (shl:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (SLL_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::SLL_H,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 942,
        GIR_Done,
      // Label 863: @32989
      GIM_Reject,
    // Label 860: @32990
    GIM_Reject,
    // Label 841: @32991
    GIM_Try, /*On fail goto*//*Label 864*/ 33643,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128BRegClassID,
      GIM_Try, /*On fail goto*//*Label 865*/ 33314, // Rule ID 2412 //
        GIM_CheckFeatures, GIFBS_HasMSA,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_BUILD_VECTOR,
        GIM_CheckNumOperands, /*MI*/2, /*Expected*/17,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/4, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/5, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/6, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/7, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/8, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/9, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/10, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/11, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/12, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/13, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/14, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/15, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/16, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIPFP_I64_Predicate_immi32Cst7,
        // MIs[3] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/2, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/4, /*Predicate*/GIPFP_I64_Predicate_immi32Cst7,
        // MIs[4] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/2, /*OpIdx*/3, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/5, /*Predicate*/GIPFP_I64_Predicate_immi32Cst7,
        // MIs[5] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/2, /*OpIdx*/4, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/6, /*Predicate*/GIPFP_I64_Predicate_immi32Cst7,
        // MIs[6] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/7, /*MI*/2, /*OpIdx*/5, // MIs[7]
        GIM_CheckOpcode, /*MI*/7, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/7, /*Predicate*/GIPFP_I64_Predicate_immi32Cst7,
        // MIs[7] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/8, /*MI*/2, /*OpIdx*/6, // MIs[8]
        GIM_CheckOpcode, /*MI*/8, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/8, /*Predicate*/GIPFP_I64_Predicate_immi32Cst7,
        // MIs[8] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/9, /*MI*/2, /*OpIdx*/7, // MIs[9]
        GIM_CheckOpcode, /*MI*/9, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/9, /*Predicate*/GIPFP_I64_Predicate_immi32Cst7,
        // MIs[9] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/10, /*MI*/2, /*OpIdx*/8, // MIs[10]
        GIM_CheckOpcode, /*MI*/10, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/10, /*Predicate*/GIPFP_I64_Predicate_immi32Cst7,
        // MIs[10] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/11, /*MI*/2, /*OpIdx*/9, // MIs[11]
        GIM_CheckOpcode, /*MI*/11, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/11, /*Predicate*/GIPFP_I64_Predicate_immi32Cst7,
        // MIs[11] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/12, /*MI*/2, /*OpIdx*/10, // MIs[12]
        GIM_CheckOpcode, /*MI*/12, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/12, /*Predicate*/GIPFP_I64_Predicate_immi32Cst7,
        // MIs[12] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/13, /*MI*/2, /*OpIdx*/11, // MIs[13]
        GIM_CheckOpcode, /*MI*/13, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/13, /*Predicate*/GIPFP_I64_Predicate_immi32Cst7,
        // MIs[13] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/14, /*MI*/2, /*OpIdx*/12, // MIs[14]
        GIM_CheckOpcode, /*MI*/14, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/14, /*Predicate*/GIPFP_I64_Predicate_immi32Cst7,
        // MIs[14] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/15, /*MI*/2, /*OpIdx*/13, // MIs[15]
        GIM_CheckOpcode, /*MI*/15, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/15, /*Predicate*/GIPFP_I64_Predicate_immi32Cst7,
        // MIs[15] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/16, /*MI*/2, /*OpIdx*/14, // MIs[16]
        GIM_CheckOpcode, /*MI*/16, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/16, /*Predicate*/GIPFP_I64_Predicate_immi32Cst7,
        // MIs[16] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/17, /*MI*/2, /*OpIdx*/15, // MIs[17]
        GIM_CheckOpcode, /*MI*/17, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/17, /*Predicate*/GIPFP_I64_Predicate_immi32Cst7,
        // MIs[17] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/18, /*MI*/2, /*OpIdx*/16, // MIs[18]
        GIM_CheckOpcode, /*MI*/18, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/18, /*Predicate*/GIPFP_I64_Predicate_immi32Cst7,
        // MIs[18] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        GIM_CheckIsSafeToFold, /*InsnID*/5,
        GIM_CheckIsSafeToFold, /*InsnID*/6,
        GIM_CheckIsSafeToFold, /*InsnID*/7,
        GIM_CheckIsSafeToFold, /*InsnID*/8,
        GIM_CheckIsSafeToFold, /*InsnID*/9,
        GIM_CheckIsSafeToFold, /*InsnID*/10,
        GIM_CheckIsSafeToFold, /*InsnID*/11,
        GIM_CheckIsSafeToFold, /*InsnID*/12,
        GIM_CheckIsSafeToFold, /*InsnID*/13,
        GIM_CheckIsSafeToFold, /*InsnID*/14,
        GIM_CheckIsSafeToFold, /*InsnID*/15,
        GIM_CheckIsSafeToFold, /*InsnID*/16,
        GIM_CheckIsSafeToFold, /*InsnID*/17,
        GIM_CheckIsSafeToFold, /*InsnID*/18,
        // (shl:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$ws, (and:{ *:[v16i8] } (build_vector:{ *:[v16i8] } (imm:{ *:[i32] })<<P:Predicate_immi32Cst7>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst7>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst7>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst7>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst7>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst7>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst7>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst7>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst7>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst7>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst7>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst7>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst7>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst7>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst7>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst7>>), v16i8:{ *:[v16i8] }:$wt))  =>  (SLL_B:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$ws, v16i8:{ *:[v16i8] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SLL_B,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2412,
        GIR_Done,
      // Label 865: @33314
      GIM_Try, /*On fail goto*//*Label 866*/ 33623, // Rule ID 2023 //
        GIM_CheckFeatures, GIFBS_HasMSA,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_BUILD_VECTOR,
        GIM_CheckNumOperands, /*MI*/2, /*Expected*/17,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/4, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/5, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/6, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/7, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/8, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/9, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/10, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/11, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/12, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/13, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/14, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/15, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/16, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIPFP_I64_Predicate_immi32Cst7,
        // MIs[3] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/2, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/4, /*Predicate*/GIPFP_I64_Predicate_immi32Cst7,
        // MIs[4] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/2, /*OpIdx*/3, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/5, /*Predicate*/GIPFP_I64_Predicate_immi32Cst7,
        // MIs[5] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/2, /*OpIdx*/4, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/6, /*Predicate*/GIPFP_I64_Predicate_immi32Cst7,
        // MIs[6] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/7, /*MI*/2, /*OpIdx*/5, // MIs[7]
        GIM_CheckOpcode, /*MI*/7, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/7, /*Predicate*/GIPFP_I64_Predicate_immi32Cst7,
        // MIs[7] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/8, /*MI*/2, /*OpIdx*/6, // MIs[8]
        GIM_CheckOpcode, /*MI*/8, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/8, /*Predicate*/GIPFP_I64_Predicate_immi32Cst7,
        // MIs[8] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/9, /*MI*/2, /*OpIdx*/7, // MIs[9]
        GIM_CheckOpcode, /*MI*/9, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/9, /*Predicate*/GIPFP_I64_Predicate_immi32Cst7,
        // MIs[9] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/10, /*MI*/2, /*OpIdx*/8, // MIs[10]
        GIM_CheckOpcode, /*MI*/10, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/10, /*Predicate*/GIPFP_I64_Predicate_immi32Cst7,
        // MIs[10] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/11, /*MI*/2, /*OpIdx*/9, // MIs[11]
        GIM_CheckOpcode, /*MI*/11, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/11, /*Predicate*/GIPFP_I64_Predicate_immi32Cst7,
        // MIs[11] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/12, /*MI*/2, /*OpIdx*/10, // MIs[12]
        GIM_CheckOpcode, /*MI*/12, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/12, /*Predicate*/GIPFP_I64_Predicate_immi32Cst7,
        // MIs[12] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/13, /*MI*/2, /*OpIdx*/11, // MIs[13]
        GIM_CheckOpcode, /*MI*/13, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/13, /*Predicate*/GIPFP_I64_Predicate_immi32Cst7,
        // MIs[13] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/14, /*MI*/2, /*OpIdx*/12, // MIs[14]
        GIM_CheckOpcode, /*MI*/14, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/14, /*Predicate*/GIPFP_I64_Predicate_immi32Cst7,
        // MIs[14] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/15, /*MI*/2, /*OpIdx*/13, // MIs[15]
        GIM_CheckOpcode, /*MI*/15, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/15, /*Predicate*/GIPFP_I64_Predicate_immi32Cst7,
        // MIs[15] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/16, /*MI*/2, /*OpIdx*/14, // MIs[16]
        GIM_CheckOpcode, /*MI*/16, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/16, /*Predicate*/GIPFP_I64_Predicate_immi32Cst7,
        // MIs[16] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/17, /*MI*/2, /*OpIdx*/15, // MIs[17]
        GIM_CheckOpcode, /*MI*/17, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/17, /*Predicate*/GIPFP_I64_Predicate_immi32Cst7,
        // MIs[17] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/18, /*MI*/2, /*OpIdx*/16, // MIs[18]
        GIM_CheckOpcode, /*MI*/18, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/18, /*Predicate*/GIPFP_I64_Predicate_immi32Cst7,
        // MIs[18] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        GIM_CheckIsSafeToFold, /*InsnID*/5,
        GIM_CheckIsSafeToFold, /*InsnID*/6,
        GIM_CheckIsSafeToFold, /*InsnID*/7,
        GIM_CheckIsSafeToFold, /*InsnID*/8,
        GIM_CheckIsSafeToFold, /*InsnID*/9,
        GIM_CheckIsSafeToFold, /*InsnID*/10,
        GIM_CheckIsSafeToFold, /*InsnID*/11,
        GIM_CheckIsSafeToFold, /*InsnID*/12,
        GIM_CheckIsSafeToFold, /*InsnID*/13,
        GIM_CheckIsSafeToFold, /*InsnID*/14,
        GIM_CheckIsSafeToFold, /*InsnID*/15,
        GIM_CheckIsSafeToFold, /*InsnID*/16,
        GIM_CheckIsSafeToFold, /*InsnID*/17,
        GIM_CheckIsSafeToFold, /*InsnID*/18,
        // (shl:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$ws, (and:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$wt, (build_vector:{ *:[v16i8] } (imm:{ *:[i32] })<<P:Predicate_immi32Cst7>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst7>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst7>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst7>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst7>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst7>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst7>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst7>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst7>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst7>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst7>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst7>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst7>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst7>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst7>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst7>>)))  =>  (SLL_B:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$ws, v16i8:{ *:[v16i8] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SLL_B,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2023,
        GIR_Done,
      // Label 866: @33623
      GIM_Try, /*On fail goto*//*Label 867*/ 33642, // Rule ID 941 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::MSA128BRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128BRegClassID,
        // (shl:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (SLL_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::SLL_B,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 941,
        GIR_Done,
      // Label 867: @33642
      GIM_Reject,
    // Label 864: @33643
    GIM_Reject,
    // Label 842: @33644
    GIM_Reject,
    // Label 23: @33645
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 9, /*)*//*default:*//*Label 874*/ 35397,
    /*GILLT_s32*//*Label 868*/ 33659,
    /*GILLT_s64*//*Label 869*/ 33912, 0,
    /*GILLT_v2s64*//*Label 870*/ 34046, 0,
    /*GILLT_v4s32*//*Label 871*/ 34078,
    /*GILLT_v8s16*//*Label 872*/ 34347,
    /*GILLT_v16s8*//*Label 873*/ 34744,
    // Label 868: @33659
    GIM_Try, /*On fail goto*//*Label 875*/ 33911,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 876*/ 33712, // Rule ID 56 //
        GIM_CheckFeatures, GIFBS_HasStdEnc_NotInMicroMips,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_immZExt5,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (srl:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rt, (imm:{ *:[i32] })<<P:Predicate_immZExt5>>:$shamt)  =>  (SRL:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rt, (imm:{ *:[i32] }):$shamt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SRL,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rt
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // shamt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 56,
        GIR_Done,
      // Label 876: @33712
      GIM_Try, /*On fail goto*//*Label 877*/ 33755, // Rule ID 1786 //
        GIM_CheckFeatures, GIFBS_InMips16Mode,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::CPU16RegsRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::CPU16RegsRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_immZExt5,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (srl:{ *:[i32] } CPU16Regs:{ *:[i32] }:$in, (imm:{ *:[i32] })<<P:Predicate_immZExt5>>:$imm)  =>  (SrlX16:{ *:[i32] } CPU16Regs:{ *:[i32] }:$in, (imm:{ *:[i32] })<<P:Predicate_immZExt5>>:$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SrlX16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rx
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // in
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1786,
        GIR_Done,
      // Label 877: @33755
      GIM_Try, /*On fail goto*//*Label 878*/ 33798, // Rule ID 2125 //
        GIM_CheckFeatures, GIFBS_InMicroMips,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPRMM16RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::GPRMM16RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_immZExt2Shift,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (srl:{ *:[i32] } GPRMM16:{ *:[i32] }:$src, (imm:{ *:[i32] })<<P:Predicate_immZExt2Shift>>:$imm)  =>  (SRL16_MM:{ *:[i32] } GPRMM16:{ *:[i32] }:$src, (imm:{ *:[i32] })<<P:Predicate_immZExt2Shift>>:$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SRL16_MM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2125,
        GIR_Done,
      // Label 878: @33798
      GIM_Try, /*On fail goto*//*Label 879*/ 33841, // Rule ID 2126 //
        GIM_CheckFeatures, GIFBS_InMicroMips,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_immZExt5,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (srl:{ *:[i32] } GPR32:{ *:[i32] }:$src, (imm:{ *:[i32] })<<P:Predicate_immZExt5>>:$imm)  =>  (SRL_MM:{ *:[i32] } GPR32:{ *:[i32] }:$src, (imm:{ *:[i32] })<<P:Predicate_immZExt5>>:$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SRL_MM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2126,
        GIR_Done,
      // Label 879: @33841
      GIM_Try, /*On fail goto*//*Label 880*/ 33864, // Rule ID 59 //
        GIM_CheckFeatures, GIFBS_HasStdEnc_NotInMicroMips,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR32RegClassID,
        // (srl:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rt, GPR32Opnd:{ *:[i32] }:$rs)  =>  (SRLV:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rt, GPR32Opnd:{ *:[i32] }:$rs)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::SRLV,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 59,
        GIR_Done,
      // Label 880: @33864
      GIM_Try, /*On fail goto*//*Label 881*/ 33887, // Rule ID 1790 //
        GIM_CheckFeatures, GIFBS_InMips16Mode,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::CPU16RegsRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::CPU16RegsRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::CPU16RegsRegClassID,
        // (srl:{ *:[i32] } CPU16Regs:{ *:[i32] }:$r, CPU16Regs:{ *:[i32] }:$ra)  =>  (SrlvRxRy16:{ *:[i32] } CPU16Regs:{ *:[i32] }:$r, CPU16Regs:{ *:[i32] }:$ra)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::SrlvRxRy16,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1790,
        GIR_Done,
      // Label 881: @33887
      GIM_Try, /*On fail goto*//*Label 882*/ 33910, // Rule ID 2127 //
        GIM_CheckFeatures, GIFBS_InMicroMips,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR32RegClassID,
        // (srl:{ *:[i32] } GPR32:{ *:[i32] }:$lhs, GPR32:{ *:[i32] }:$rhs)  =>  (SRLV_MM:{ *:[i32] } GPR32:{ *:[i32] }:$lhs, GPR32:{ *:[i32] }:$rhs)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::SRLV_MM,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2127,
        GIR_Done,
      // Label 882: @33910
      GIM_Reject,
    // Label 875: @33911
    GIM_Reject,
    // Label 869: @33912
    GIM_Try, /*On fail goto*//*Label 883*/ 34045,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::GPR64RegClassID,
      GIM_Try, /*On fail goto*//*Label 884*/ 33965, // Rule ID 205 //
        GIM_CheckFeatures, GIFBS_HasMips3_HasStdEnc_NotInMicroMips,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_immZExt6,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (srl:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rt, (imm:{ *:[i32] })<<P:Predicate_immZExt6>>:$shamt)  =>  (DSRL:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rt, (imm:{ *:[i32] }):$shamt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::DSRL,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rt
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // shamt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 205,
        GIR_Done,
      // Label 884: @33965
      GIM_Try, /*On fail goto*//*Label 885*/ 34029, // Rule ID 1557 //
        GIM_CheckFeatures, GIFBS_HasMips3_HasStdEnc_IsGP64bit,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_TRUNC,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/Mips::GPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (srl:{ *:[i64] } GPR64:{ *:[i64] }:$rt, (trunc:{ *:[i32] } GPR64:{ *:[i64] }:$rs))  =>  (DSRLV:{ *:[i64] } GPR64:{ *:[i64] }:$rt, (EXTRACT_SUBREG:{ *:[i32] } GPR64:{ *:[i64] }:$rs, sub_32:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/1, // rs
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, /*RC GPR32*/8,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, /*RC GPR64*/38,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::DSRLV,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rt
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1557,
        GIR_Done,
      // Label 885: @34029
      GIM_Try, /*On fail goto*//*Label 886*/ 34044, // Rule ID 209 //
        GIM_CheckFeatures, GIFBS_HasMips3_HasStdEnc_NotInMicroMips,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR32RegClassID,
        // (srl:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rt, GPR32Opnd:{ *:[i32] }:$rs)  =>  (DSRLV:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rt, GPR32Opnd:{ *:[i32] }:$rs)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::DSRLV,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 209,
        GIR_Done,
      // Label 886: @34044
      GIM_Reject,
    // Label 883: @34045
    GIM_Reject,
    // Label 870: @34046
    GIM_Try, /*On fail goto*//*Label 887*/ 34077, // Rule ID 976 //
      GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::MSA128DRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128DRegClassID,
      // (srl:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)  =>  (SRL_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::SRL_D,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 976,
      GIR_Done,
    // Label 887: @34077
    GIM_Reject,
    // Label 871: @34078
    GIM_Try, /*On fail goto*//*Label 888*/ 34346,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
      GIM_Try, /*On fail goto*//*Label 889*/ 34209, // Rule ID 2430 //
        GIM_CheckFeatures, GIFBS_HasMSA,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_BUILD_VECTOR,
        GIM_CheckNumOperands, /*MI*/2, /*Expected*/5,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/4, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIPFP_I64_Predicate_immi32Cst31,
        // MIs[3] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/2, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/4, /*Predicate*/GIPFP_I64_Predicate_immi32Cst31,
        // MIs[4] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/2, /*OpIdx*/3, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/5, /*Predicate*/GIPFP_I64_Predicate_immi32Cst31,
        // MIs[5] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/2, /*OpIdx*/4, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/6, /*Predicate*/GIPFP_I64_Predicate_immi32Cst31,
        // MIs[6] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        GIM_CheckIsSafeToFold, /*InsnID*/5,
        GIM_CheckIsSafeToFold, /*InsnID*/6,
        // (srl:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$ws, (and:{ *:[v4i32] } (build_vector:{ *:[v4i32] } (imm:{ *:[i32] })<<P:Predicate_immi32Cst31>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst31>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst31>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst31>>), v4i32:{ *:[v4i32] }:$wt))  =>  (SRL_W:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$ws, v4i32:{ *:[v4i32] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SRL_W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2430,
        GIR_Done,
      // Label 889: @34209
      GIM_Try, /*On fail goto*//*Label 890*/ 34326, // Rule ID 2033 //
        GIM_CheckFeatures, GIFBS_HasMSA,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_BUILD_VECTOR,
        GIM_CheckNumOperands, /*MI*/2, /*Expected*/5,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/4, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIPFP_I64_Predicate_immi32Cst31,
        // MIs[3] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/2, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/4, /*Predicate*/GIPFP_I64_Predicate_immi32Cst31,
        // MIs[4] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/2, /*OpIdx*/3, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/5, /*Predicate*/GIPFP_I64_Predicate_immi32Cst31,
        // MIs[5] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/2, /*OpIdx*/4, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/6, /*Predicate*/GIPFP_I64_Predicate_immi32Cst31,
        // MIs[6] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        GIM_CheckIsSafeToFold, /*InsnID*/5,
        GIM_CheckIsSafeToFold, /*InsnID*/6,
        // (srl:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$ws, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$wt, (build_vector:{ *:[v4i32] } (imm:{ *:[i32] })<<P:Predicate_immi32Cst31>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst31>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst31>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst31>>)))  =>  (SRL_W:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$ws, v4i32:{ *:[v4i32] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SRL_W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2033,
        GIR_Done,
      // Label 890: @34326
      GIM_Try, /*On fail goto*//*Label 891*/ 34345, // Rule ID 975 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128WRegClassID,
        // (srl:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (SRL_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::SRL_W,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 975,
        GIR_Done,
      // Label 891: @34345
      GIM_Reject,
    // Label 888: @34346
    GIM_Reject,
    // Label 872: @34347
    GIM_Try, /*On fail goto*//*Label 892*/ 34743,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128HRegClassID,
      GIM_Try, /*On fail goto*//*Label 893*/ 34542, // Rule ID 2429 //
        GIM_CheckFeatures, GIFBS_HasMSA,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_BUILD_VECTOR,
        GIM_CheckNumOperands, /*MI*/2, /*Expected*/9,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/4, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/5, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/6, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/7, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/8, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIPFP_I64_Predicate_immi32Cst15,
        // MIs[3] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/2, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/4, /*Predicate*/GIPFP_I64_Predicate_immi32Cst15,
        // MIs[4] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/2, /*OpIdx*/3, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/5, /*Predicate*/GIPFP_I64_Predicate_immi32Cst15,
        // MIs[5] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/2, /*OpIdx*/4, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/6, /*Predicate*/GIPFP_I64_Predicate_immi32Cst15,
        // MIs[6] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/7, /*MI*/2, /*OpIdx*/5, // MIs[7]
        GIM_CheckOpcode, /*MI*/7, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/7, /*Predicate*/GIPFP_I64_Predicate_immi32Cst15,
        // MIs[7] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/8, /*MI*/2, /*OpIdx*/6, // MIs[8]
        GIM_CheckOpcode, /*MI*/8, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/8, /*Predicate*/GIPFP_I64_Predicate_immi32Cst15,
        // MIs[8] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/9, /*MI*/2, /*OpIdx*/7, // MIs[9]
        GIM_CheckOpcode, /*MI*/9, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/9, /*Predicate*/GIPFP_I64_Predicate_immi32Cst15,
        // MIs[9] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/10, /*MI*/2, /*OpIdx*/8, // MIs[10]
        GIM_CheckOpcode, /*MI*/10, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/10, /*Predicate*/GIPFP_I64_Predicate_immi32Cst15,
        // MIs[10] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        GIM_CheckIsSafeToFold, /*InsnID*/5,
        GIM_CheckIsSafeToFold, /*InsnID*/6,
        GIM_CheckIsSafeToFold, /*InsnID*/7,
        GIM_CheckIsSafeToFold, /*InsnID*/8,
        GIM_CheckIsSafeToFold, /*InsnID*/9,
        GIM_CheckIsSafeToFold, /*InsnID*/10,
        // (srl:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$ws, (and:{ *:[v8i16] } (build_vector:{ *:[v8i16] } (imm:{ *:[i32] })<<P:Predicate_immi32Cst15>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst15>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst15>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst15>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst15>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst15>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst15>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst15>>), v8i16:{ *:[v8i16] }:$wt))  =>  (SRL_H:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$ws, v8i16:{ *:[v8i16] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SRL_H,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2429,
        GIR_Done,
      // Label 893: @34542
      GIM_Try, /*On fail goto*//*Label 894*/ 34723, // Rule ID 2032 //
        GIM_CheckFeatures, GIFBS_HasMSA,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_BUILD_VECTOR,
        GIM_CheckNumOperands, /*MI*/2, /*Expected*/9,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/4, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/5, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/6, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/7, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/8, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIPFP_I64_Predicate_immi32Cst15,
        // MIs[3] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/2, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/4, /*Predicate*/GIPFP_I64_Predicate_immi32Cst15,
        // MIs[4] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/2, /*OpIdx*/3, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/5, /*Predicate*/GIPFP_I64_Predicate_immi32Cst15,
        // MIs[5] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/2, /*OpIdx*/4, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/6, /*Predicate*/GIPFP_I64_Predicate_immi32Cst15,
        // MIs[6] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/7, /*MI*/2, /*OpIdx*/5, // MIs[7]
        GIM_CheckOpcode, /*MI*/7, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/7, /*Predicate*/GIPFP_I64_Predicate_immi32Cst15,
        // MIs[7] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/8, /*MI*/2, /*OpIdx*/6, // MIs[8]
        GIM_CheckOpcode, /*MI*/8, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/8, /*Predicate*/GIPFP_I64_Predicate_immi32Cst15,
        // MIs[8] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/9, /*MI*/2, /*OpIdx*/7, // MIs[9]
        GIM_CheckOpcode, /*MI*/9, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/9, /*Predicate*/GIPFP_I64_Predicate_immi32Cst15,
        // MIs[9] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/10, /*MI*/2, /*OpIdx*/8, // MIs[10]
        GIM_CheckOpcode, /*MI*/10, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/10, /*Predicate*/GIPFP_I64_Predicate_immi32Cst15,
        // MIs[10] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        GIM_CheckIsSafeToFold, /*InsnID*/5,
        GIM_CheckIsSafeToFold, /*InsnID*/6,
        GIM_CheckIsSafeToFold, /*InsnID*/7,
        GIM_CheckIsSafeToFold, /*InsnID*/8,
        GIM_CheckIsSafeToFold, /*InsnID*/9,
        GIM_CheckIsSafeToFold, /*InsnID*/10,
        // (srl:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$ws, (and:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$wt, (build_vector:{ *:[v8i16] } (imm:{ *:[i32] })<<P:Predicate_immi32Cst15>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst15>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst15>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst15>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst15>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst15>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst15>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst15>>)))  =>  (SRL_H:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$ws, v8i16:{ *:[v8i16] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SRL_H,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2032,
        GIR_Done,
      // Label 894: @34723
      GIM_Try, /*On fail goto*//*Label 895*/ 34742, // Rule ID 974 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128HRegClassID,
        // (srl:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (SRL_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::SRL_H,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 974,
        GIR_Done,
      // Label 895: @34742
      GIM_Reject,
    // Label 892: @34743
    GIM_Reject,
    // Label 873: @34744
    GIM_Try, /*On fail goto*//*Label 896*/ 35396,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128BRegClassID,
      GIM_Try, /*On fail goto*//*Label 897*/ 35067, // Rule ID 2428 //
        GIM_CheckFeatures, GIFBS_HasMSA,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_BUILD_VECTOR,
        GIM_CheckNumOperands, /*MI*/2, /*Expected*/17,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/4, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/5, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/6, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/7, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/8, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/9, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/10, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/11, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/12, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/13, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/14, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/15, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/16, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIPFP_I64_Predicate_immi32Cst7,
        // MIs[3] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/2, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/4, /*Predicate*/GIPFP_I64_Predicate_immi32Cst7,
        // MIs[4] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/2, /*OpIdx*/3, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/5, /*Predicate*/GIPFP_I64_Predicate_immi32Cst7,
        // MIs[5] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/2, /*OpIdx*/4, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/6, /*Predicate*/GIPFP_I64_Predicate_immi32Cst7,
        // MIs[6] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/7, /*MI*/2, /*OpIdx*/5, // MIs[7]
        GIM_CheckOpcode, /*MI*/7, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/7, /*Predicate*/GIPFP_I64_Predicate_immi32Cst7,
        // MIs[7] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/8, /*MI*/2, /*OpIdx*/6, // MIs[8]
        GIM_CheckOpcode, /*MI*/8, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/8, /*Predicate*/GIPFP_I64_Predicate_immi32Cst7,
        // MIs[8] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/9, /*MI*/2, /*OpIdx*/7, // MIs[9]
        GIM_CheckOpcode, /*MI*/9, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/9, /*Predicate*/GIPFP_I64_Predicate_immi32Cst7,
        // MIs[9] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/10, /*MI*/2, /*OpIdx*/8, // MIs[10]
        GIM_CheckOpcode, /*MI*/10, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/10, /*Predicate*/GIPFP_I64_Predicate_immi32Cst7,
        // MIs[10] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/11, /*MI*/2, /*OpIdx*/9, // MIs[11]
        GIM_CheckOpcode, /*MI*/11, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/11, /*Predicate*/GIPFP_I64_Predicate_immi32Cst7,
        // MIs[11] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/12, /*MI*/2, /*OpIdx*/10, // MIs[12]
        GIM_CheckOpcode, /*MI*/12, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/12, /*Predicate*/GIPFP_I64_Predicate_immi32Cst7,
        // MIs[12] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/13, /*MI*/2, /*OpIdx*/11, // MIs[13]
        GIM_CheckOpcode, /*MI*/13, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/13, /*Predicate*/GIPFP_I64_Predicate_immi32Cst7,
        // MIs[13] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/14, /*MI*/2, /*OpIdx*/12, // MIs[14]
        GIM_CheckOpcode, /*MI*/14, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/14, /*Predicate*/GIPFP_I64_Predicate_immi32Cst7,
        // MIs[14] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/15, /*MI*/2, /*OpIdx*/13, // MIs[15]
        GIM_CheckOpcode, /*MI*/15, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/15, /*Predicate*/GIPFP_I64_Predicate_immi32Cst7,
        // MIs[15] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/16, /*MI*/2, /*OpIdx*/14, // MIs[16]
        GIM_CheckOpcode, /*MI*/16, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/16, /*Predicate*/GIPFP_I64_Predicate_immi32Cst7,
        // MIs[16] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/17, /*MI*/2, /*OpIdx*/15, // MIs[17]
        GIM_CheckOpcode, /*MI*/17, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/17, /*Predicate*/GIPFP_I64_Predicate_immi32Cst7,
        // MIs[17] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/18, /*MI*/2, /*OpIdx*/16, // MIs[18]
        GIM_CheckOpcode, /*MI*/18, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/18, /*Predicate*/GIPFP_I64_Predicate_immi32Cst7,
        // MIs[18] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        GIM_CheckIsSafeToFold, /*InsnID*/5,
        GIM_CheckIsSafeToFold, /*InsnID*/6,
        GIM_CheckIsSafeToFold, /*InsnID*/7,
        GIM_CheckIsSafeToFold, /*InsnID*/8,
        GIM_CheckIsSafeToFold, /*InsnID*/9,
        GIM_CheckIsSafeToFold, /*InsnID*/10,
        GIM_CheckIsSafeToFold, /*InsnID*/11,
        GIM_CheckIsSafeToFold, /*InsnID*/12,
        GIM_CheckIsSafeToFold, /*InsnID*/13,
        GIM_CheckIsSafeToFold, /*InsnID*/14,
        GIM_CheckIsSafeToFold, /*InsnID*/15,
        GIM_CheckIsSafeToFold, /*InsnID*/16,
        GIM_CheckIsSafeToFold, /*InsnID*/17,
        GIM_CheckIsSafeToFold, /*InsnID*/18,
        // (srl:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$ws, (and:{ *:[v16i8] } (build_vector:{ *:[v16i8] } (imm:{ *:[i32] })<<P:Predicate_immi32Cst7>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst7>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst7>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst7>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst7>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst7>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst7>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst7>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst7>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst7>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst7>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst7>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst7>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst7>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst7>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst7>>), v16i8:{ *:[v16i8] }:$wt))  =>  (SRL_B:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$ws, v16i8:{ *:[v16i8] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SRL_B,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2428,
        GIR_Done,
      // Label 897: @35067
      GIM_Try, /*On fail goto*//*Label 898*/ 35376, // Rule ID 2031 //
        GIM_CheckFeatures, GIFBS_HasMSA,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_BUILD_VECTOR,
        GIM_CheckNumOperands, /*MI*/2, /*Expected*/17,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/4, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/5, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/6, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/7, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/8, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/9, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/10, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/11, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/12, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/13, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/14, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/15, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/16, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIPFP_I64_Predicate_immi32Cst7,
        // MIs[3] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/2, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/4, /*Predicate*/GIPFP_I64_Predicate_immi32Cst7,
        // MIs[4] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/2, /*OpIdx*/3, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/5, /*Predicate*/GIPFP_I64_Predicate_immi32Cst7,
        // MIs[5] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/2, /*OpIdx*/4, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/6, /*Predicate*/GIPFP_I64_Predicate_immi32Cst7,
        // MIs[6] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/7, /*MI*/2, /*OpIdx*/5, // MIs[7]
        GIM_CheckOpcode, /*MI*/7, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/7, /*Predicate*/GIPFP_I64_Predicate_immi32Cst7,
        // MIs[7] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/8, /*MI*/2, /*OpIdx*/6, // MIs[8]
        GIM_CheckOpcode, /*MI*/8, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/8, /*Predicate*/GIPFP_I64_Predicate_immi32Cst7,
        // MIs[8] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/9, /*MI*/2, /*OpIdx*/7, // MIs[9]
        GIM_CheckOpcode, /*MI*/9, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/9, /*Predicate*/GIPFP_I64_Predicate_immi32Cst7,
        // MIs[9] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/10, /*MI*/2, /*OpIdx*/8, // MIs[10]
        GIM_CheckOpcode, /*MI*/10, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/10, /*Predicate*/GIPFP_I64_Predicate_immi32Cst7,
        // MIs[10] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/11, /*MI*/2, /*OpIdx*/9, // MIs[11]
        GIM_CheckOpcode, /*MI*/11, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/11, /*Predicate*/GIPFP_I64_Predicate_immi32Cst7,
        // MIs[11] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/12, /*MI*/2, /*OpIdx*/10, // MIs[12]
        GIM_CheckOpcode, /*MI*/12, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/12, /*Predicate*/GIPFP_I64_Predicate_immi32Cst7,
        // MIs[12] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/13, /*MI*/2, /*OpIdx*/11, // MIs[13]
        GIM_CheckOpcode, /*MI*/13, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/13, /*Predicate*/GIPFP_I64_Predicate_immi32Cst7,
        // MIs[13] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/14, /*MI*/2, /*OpIdx*/12, // MIs[14]
        GIM_CheckOpcode, /*MI*/14, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/14, /*Predicate*/GIPFP_I64_Predicate_immi32Cst7,
        // MIs[14] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/15, /*MI*/2, /*OpIdx*/13, // MIs[15]
        GIM_CheckOpcode, /*MI*/15, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/15, /*Predicate*/GIPFP_I64_Predicate_immi32Cst7,
        // MIs[15] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/16, /*MI*/2, /*OpIdx*/14, // MIs[16]
        GIM_CheckOpcode, /*MI*/16, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/16, /*Predicate*/GIPFP_I64_Predicate_immi32Cst7,
        // MIs[16] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/17, /*MI*/2, /*OpIdx*/15, // MIs[17]
        GIM_CheckOpcode, /*MI*/17, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/17, /*Predicate*/GIPFP_I64_Predicate_immi32Cst7,
        // MIs[17] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/18, /*MI*/2, /*OpIdx*/16, // MIs[18]
        GIM_CheckOpcode, /*MI*/18, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/18, /*Predicate*/GIPFP_I64_Predicate_immi32Cst7,
        // MIs[18] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        GIM_CheckIsSafeToFold, /*InsnID*/5,
        GIM_CheckIsSafeToFold, /*InsnID*/6,
        GIM_CheckIsSafeToFold, /*InsnID*/7,
        GIM_CheckIsSafeToFold, /*InsnID*/8,
        GIM_CheckIsSafeToFold, /*InsnID*/9,
        GIM_CheckIsSafeToFold, /*InsnID*/10,
        GIM_CheckIsSafeToFold, /*InsnID*/11,
        GIM_CheckIsSafeToFold, /*InsnID*/12,
        GIM_CheckIsSafeToFold, /*InsnID*/13,
        GIM_CheckIsSafeToFold, /*InsnID*/14,
        GIM_CheckIsSafeToFold, /*InsnID*/15,
        GIM_CheckIsSafeToFold, /*InsnID*/16,
        GIM_CheckIsSafeToFold, /*InsnID*/17,
        GIM_CheckIsSafeToFold, /*InsnID*/18,
        // (srl:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$ws, (and:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$wt, (build_vector:{ *:[v16i8] } (imm:{ *:[i32] })<<P:Predicate_immi32Cst7>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst7>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst7>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst7>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst7>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst7>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst7>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst7>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst7>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst7>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst7>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst7>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst7>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst7>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst7>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst7>>)))  =>  (SRL_B:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$ws, v16i8:{ *:[v16i8] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SRL_B,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2031,
        GIR_Done,
      // Label 898: @35376
      GIM_Try, /*On fail goto*//*Label 899*/ 35395, // Rule ID 973 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::MSA128BRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128BRegClassID,
        // (srl:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (SRL_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::SRL_B,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 973,
        GIR_Done,
      // Label 899: @35395
      GIM_Reject,
    // Label 896: @35396
    GIM_Reject,
    // Label 874: @35397
    GIM_Reject,
    // Label 24: @35398
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 9, /*)*//*default:*//*Label 906*/ 37107,
    /*GILLT_s32*//*Label 900*/ 35412,
    /*GILLT_s64*//*Label 901*/ 35622, 0,
    /*GILLT_v2s64*//*Label 902*/ 35756, 0,
    /*GILLT_v4s32*//*Label 903*/ 35788,
    /*GILLT_v8s16*//*Label 904*/ 36057,
    /*GILLT_v16s8*//*Label 905*/ 36454,
    // Label 900: @35412
    GIM_Try, /*On fail goto*//*Label 907*/ 35621,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 908*/ 35465, // Rule ID 57 //
        GIM_CheckFeatures, GIFBS_HasStdEnc_NotInMicroMips,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_immZExt5,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sra:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rt, (imm:{ *:[i32] })<<P:Predicate_immZExt5>>:$shamt)  =>  (SRA:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rt, (imm:{ *:[i32] }):$shamt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SRA,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rt
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // shamt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 57,
        GIR_Done,
      // Label 908: @35465
      GIM_Try, /*On fail goto*//*Label 909*/ 35508, // Rule ID 1787 //
        GIM_CheckFeatures, GIFBS_InMips16Mode,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::CPU16RegsRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::CPU16RegsRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_immZExt5,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sra:{ *:[i32] } CPU16Regs:{ *:[i32] }:$in, (imm:{ *:[i32] })<<P:Predicate_immZExt5>>:$imm)  =>  (SraX16:{ *:[i32] } CPU16Regs:{ *:[i32] }:$in, (imm:{ *:[i32] })<<P:Predicate_immZExt5>>:$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SraX16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rx
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // in
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1787,
        GIR_Done,
      // Label 909: @35508
      GIM_Try, /*On fail goto*//*Label 910*/ 35551, // Rule ID 2128 //
        GIM_CheckFeatures, GIFBS_InMicroMips,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_immZExt5,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sra:{ *:[i32] } GPR32:{ *:[i32] }:$src, (imm:{ *:[i32] })<<P:Predicate_immZExt5>>:$imm)  =>  (SRA_MM:{ *:[i32] } GPR32:{ *:[i32] }:$src, (imm:{ *:[i32] })<<P:Predicate_immZExt5>>:$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SRA_MM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2128,
        GIR_Done,
      // Label 910: @35551
      GIM_Try, /*On fail goto*//*Label 911*/ 35574, // Rule ID 60 //
        GIM_CheckFeatures, GIFBS_HasStdEnc_NotInMicroMips,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR32RegClassID,
        // (sra:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rt, GPR32Opnd:{ *:[i32] }:$rs)  =>  (SRAV:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rt, GPR32Opnd:{ *:[i32] }:$rs)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::SRAV,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 60,
        GIR_Done,
      // Label 911: @35574
      GIM_Try, /*On fail goto*//*Label 912*/ 35597, // Rule ID 1789 //
        GIM_CheckFeatures, GIFBS_InMips16Mode,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::CPU16RegsRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::CPU16RegsRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::CPU16RegsRegClassID,
        // (sra:{ *:[i32] } CPU16Regs:{ *:[i32] }:$r, CPU16Regs:{ *:[i32] }:$ra)  =>  (SravRxRy16:{ *:[i32] } CPU16Regs:{ *:[i32] }:$r, CPU16Regs:{ *:[i32] }:$ra)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::SravRxRy16,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1789,
        GIR_Done,
      // Label 912: @35597
      GIM_Try, /*On fail goto*//*Label 913*/ 35620, // Rule ID 2129 //
        GIM_CheckFeatures, GIFBS_InMicroMips,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR32RegClassID,
        // (sra:{ *:[i32] } GPR32:{ *:[i32] }:$lhs, GPR32:{ *:[i32] }:$rhs)  =>  (SRAV_MM:{ *:[i32] } GPR32:{ *:[i32] }:$lhs, GPR32:{ *:[i32] }:$rhs)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::SRAV_MM,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2129,
        GIR_Done,
      // Label 913: @35620
      GIM_Reject,
    // Label 907: @35621
    GIM_Reject,
    // Label 901: @35622
    GIM_Try, /*On fail goto*//*Label 914*/ 35755,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::GPR64RegClassID,
      GIM_Try, /*On fail goto*//*Label 915*/ 35675, // Rule ID 206 //
        GIM_CheckFeatures, GIFBS_HasMips3_HasStdEnc_NotInMicroMips,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_immZExt6,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sra:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rt, (imm:{ *:[i32] })<<P:Predicate_immZExt6>>:$shamt)  =>  (DSRA:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rt, (imm:{ *:[i32] }):$shamt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::DSRA,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rt
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // shamt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 206,
        GIR_Done,
      // Label 915: @35675
      GIM_Try, /*On fail goto*//*Label 916*/ 35739, // Rule ID 1558 //
        GIM_CheckFeatures, GIFBS_HasMips3_HasStdEnc_IsGP64bit,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_TRUNC,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/Mips::GPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sra:{ *:[i64] } GPR64:{ *:[i64] }:$rt, (trunc:{ *:[i32] } GPR64:{ *:[i64] }:$rs))  =>  (DSRAV:{ *:[i64] } GPR64:{ *:[i64] }:$rt, (EXTRACT_SUBREG:{ *:[i32] } GPR64:{ *:[i64] }:$rs, sub_32:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/1, // rs
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, /*RC GPR32*/8,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, /*RC GPR64*/38,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::DSRAV,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rt
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1558,
        GIR_Done,
      // Label 916: @35739
      GIM_Try, /*On fail goto*//*Label 917*/ 35754, // Rule ID 208 //
        GIM_CheckFeatures, GIFBS_HasMips3_HasStdEnc_NotInMicroMips,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR32RegClassID,
        // (sra:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rt, GPR32Opnd:{ *:[i32] }:$rs)  =>  (DSRAV:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rt, GPR32Opnd:{ *:[i32] }:$rs)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::DSRAV,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 208,
        GIR_Done,
      // Label 917: @35754
      GIM_Reject,
    // Label 914: @35755
    GIM_Reject,
    // Label 902: @35756
    GIM_Try, /*On fail goto*//*Label 918*/ 35787, // Rule ID 960 //
      GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128DRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::MSA128DRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128DRegClassID,
      // (sra:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)  =>  (SRA_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::SRA_D,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 960,
      GIR_Done,
    // Label 918: @35787
    GIM_Reject,
    // Label 903: @35788
    GIM_Try, /*On fail goto*//*Label 919*/ 36056,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128WRegClassID,
      GIM_Try, /*On fail goto*//*Label 920*/ 35919, // Rule ID 2434 //
        GIM_CheckFeatures, GIFBS_HasMSA,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_BUILD_VECTOR,
        GIM_CheckNumOperands, /*MI*/2, /*Expected*/5,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/4, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIPFP_I64_Predicate_immi32Cst31,
        // MIs[3] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/2, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/4, /*Predicate*/GIPFP_I64_Predicate_immi32Cst31,
        // MIs[4] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/2, /*OpIdx*/3, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/5, /*Predicate*/GIPFP_I64_Predicate_immi32Cst31,
        // MIs[5] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/2, /*OpIdx*/4, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/6, /*Predicate*/GIPFP_I64_Predicate_immi32Cst31,
        // MIs[6] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        GIM_CheckIsSafeToFold, /*InsnID*/5,
        GIM_CheckIsSafeToFold, /*InsnID*/6,
        // (sra:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$ws, (and:{ *:[v4i32] } (build_vector:{ *:[v4i32] } (imm:{ *:[i32] })<<P:Predicate_immi32Cst31>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst31>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst31>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst31>>), v4i32:{ *:[v4i32] }:$wt))  =>  (SRA_W:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$ws, v4i32:{ *:[v4i32] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SRA_W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2434,
        GIR_Done,
      // Label 920: @35919
      GIM_Try, /*On fail goto*//*Label 921*/ 36036, // Rule ID 2037 //
        GIM_CheckFeatures, GIFBS_HasMSA,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_BUILD_VECTOR,
        GIM_CheckNumOperands, /*MI*/2, /*Expected*/5,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/4, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIPFP_I64_Predicate_immi32Cst31,
        // MIs[3] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/2, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/4, /*Predicate*/GIPFP_I64_Predicate_immi32Cst31,
        // MIs[4] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/2, /*OpIdx*/3, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/5, /*Predicate*/GIPFP_I64_Predicate_immi32Cst31,
        // MIs[5] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/2, /*OpIdx*/4, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/6, /*Predicate*/GIPFP_I64_Predicate_immi32Cst31,
        // MIs[6] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        GIM_CheckIsSafeToFold, /*InsnID*/5,
        GIM_CheckIsSafeToFold, /*InsnID*/6,
        // (sra:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$ws, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$wt, (build_vector:{ *:[v4i32] } (imm:{ *:[i32] })<<P:Predicate_immi32Cst31>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst31>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst31>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst31>>)))  =>  (SRA_W:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$ws, v4i32:{ *:[v4i32] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SRA_W,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2037,
        GIR_Done,
      // Label 921: @36036
      GIM_Try, /*On fail goto*//*Label 922*/ 36055, // Rule ID 959 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::MSA128WRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128WRegClassID,
        // (sra:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (SRA_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::SRA_W,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 959,
        GIR_Done,
      // Label 922: @36055
      GIM_Reject,
    // Label 919: @36056
    GIM_Reject,
    // Label 904: @36057
    GIM_Try, /*On fail goto*//*Label 923*/ 36453,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128HRegClassID,
      GIM_Try, /*On fail goto*//*Label 924*/ 36252, // Rule ID 2433 //
        GIM_CheckFeatures, GIFBS_HasMSA,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_BUILD_VECTOR,
        GIM_CheckNumOperands, /*MI*/2, /*Expected*/9,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/4, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/5, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/6, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/7, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/8, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIPFP_I64_Predicate_immi32Cst15,
        // MIs[3] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/2, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/4, /*Predicate*/GIPFP_I64_Predicate_immi32Cst15,
        // MIs[4] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/2, /*OpIdx*/3, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/5, /*Predicate*/GIPFP_I64_Predicate_immi32Cst15,
        // MIs[5] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/2, /*OpIdx*/4, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/6, /*Predicate*/GIPFP_I64_Predicate_immi32Cst15,
        // MIs[6] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/7, /*MI*/2, /*OpIdx*/5, // MIs[7]
        GIM_CheckOpcode, /*MI*/7, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/7, /*Predicate*/GIPFP_I64_Predicate_immi32Cst15,
        // MIs[7] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/8, /*MI*/2, /*OpIdx*/6, // MIs[8]
        GIM_CheckOpcode, /*MI*/8, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/8, /*Predicate*/GIPFP_I64_Predicate_immi32Cst15,
        // MIs[8] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/9, /*MI*/2, /*OpIdx*/7, // MIs[9]
        GIM_CheckOpcode, /*MI*/9, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/9, /*Predicate*/GIPFP_I64_Predicate_immi32Cst15,
        // MIs[9] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/10, /*MI*/2, /*OpIdx*/8, // MIs[10]
        GIM_CheckOpcode, /*MI*/10, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/10, /*Predicate*/GIPFP_I64_Predicate_immi32Cst15,
        // MIs[10] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        GIM_CheckIsSafeToFold, /*InsnID*/5,
        GIM_CheckIsSafeToFold, /*InsnID*/6,
        GIM_CheckIsSafeToFold, /*InsnID*/7,
        GIM_CheckIsSafeToFold, /*InsnID*/8,
        GIM_CheckIsSafeToFold, /*InsnID*/9,
        GIM_CheckIsSafeToFold, /*InsnID*/10,
        // (sra:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$ws, (and:{ *:[v8i16] } (build_vector:{ *:[v8i16] } (imm:{ *:[i32] })<<P:Predicate_immi32Cst15>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst15>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst15>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst15>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst15>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst15>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst15>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst15>>), v8i16:{ *:[v8i16] }:$wt))  =>  (SRA_H:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$ws, v8i16:{ *:[v8i16] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SRA_H,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2433,
        GIR_Done,
      // Label 924: @36252
      GIM_Try, /*On fail goto*//*Label 925*/ 36433, // Rule ID 2036 //
        GIM_CheckFeatures, GIFBS_HasMSA,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_BUILD_VECTOR,
        GIM_CheckNumOperands, /*MI*/2, /*Expected*/9,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/4, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/5, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/6, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/7, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/8, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIPFP_I64_Predicate_immi32Cst15,
        // MIs[3] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/2, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/4, /*Predicate*/GIPFP_I64_Predicate_immi32Cst15,
        // MIs[4] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/2, /*OpIdx*/3, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/5, /*Predicate*/GIPFP_I64_Predicate_immi32Cst15,
        // MIs[5] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/2, /*OpIdx*/4, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/6, /*Predicate*/GIPFP_I64_Predicate_immi32Cst15,
        // MIs[6] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/7, /*MI*/2, /*OpIdx*/5, // MIs[7]
        GIM_CheckOpcode, /*MI*/7, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/7, /*Predicate*/GIPFP_I64_Predicate_immi32Cst15,
        // MIs[7] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/8, /*MI*/2, /*OpIdx*/6, // MIs[8]
        GIM_CheckOpcode, /*MI*/8, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/8, /*Predicate*/GIPFP_I64_Predicate_immi32Cst15,
        // MIs[8] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/9, /*MI*/2, /*OpIdx*/7, // MIs[9]
        GIM_CheckOpcode, /*MI*/9, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/9, /*Predicate*/GIPFP_I64_Predicate_immi32Cst15,
        // MIs[9] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/10, /*MI*/2, /*OpIdx*/8, // MIs[10]
        GIM_CheckOpcode, /*MI*/10, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/10, /*Predicate*/GIPFP_I64_Predicate_immi32Cst15,
        // MIs[10] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        GIM_CheckIsSafeToFold, /*InsnID*/5,
        GIM_CheckIsSafeToFold, /*InsnID*/6,
        GIM_CheckIsSafeToFold, /*InsnID*/7,
        GIM_CheckIsSafeToFold, /*InsnID*/8,
        GIM_CheckIsSafeToFold, /*InsnID*/9,
        GIM_CheckIsSafeToFold, /*InsnID*/10,
        // (sra:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$ws, (and:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$wt, (build_vector:{ *:[v8i16] } (imm:{ *:[i32] })<<P:Predicate_immi32Cst15>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst15>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst15>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst15>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst15>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst15>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst15>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst15>>)))  =>  (SRA_H:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$ws, v8i16:{ *:[v8i16] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SRA_H,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2036,
        GIR_Done,
      // Label 925: @36433
      GIM_Try, /*On fail goto*//*Label 926*/ 36452, // Rule ID 958 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::MSA128HRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128HRegClassID,
        // (sra:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (SRA_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::SRA_H,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 958,
        GIR_Done,
      // Label 926: @36452
      GIM_Reject,
    // Label 923: @36453
    GIM_Reject,
    // Label 905: @36454
    GIM_Try, /*On fail goto*//*Label 927*/ 37106,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::MSA128BRegClassID,
      GIM_Try, /*On fail goto*//*Label 928*/ 36777, // Rule ID 2432 //
        GIM_CheckFeatures, GIFBS_HasMSA,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_BUILD_VECTOR,
        GIM_CheckNumOperands, /*MI*/2, /*Expected*/17,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/4, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/5, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/6, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/7, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/8, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/9, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/10, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/11, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/12, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/13, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/14, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/15, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/16, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIPFP_I64_Predicate_immi32Cst7,
        // MIs[3] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/2, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/4, /*Predicate*/GIPFP_I64_Predicate_immi32Cst7,
        // MIs[4] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/2, /*OpIdx*/3, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/5, /*Predicate*/GIPFP_I64_Predicate_immi32Cst7,
        // MIs[5] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/2, /*OpIdx*/4, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/6, /*Predicate*/GIPFP_I64_Predicate_immi32Cst7,
        // MIs[6] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/7, /*MI*/2, /*OpIdx*/5, // MIs[7]
        GIM_CheckOpcode, /*MI*/7, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/7, /*Predicate*/GIPFP_I64_Predicate_immi32Cst7,
        // MIs[7] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/8, /*MI*/2, /*OpIdx*/6, // MIs[8]
        GIM_CheckOpcode, /*MI*/8, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/8, /*Predicate*/GIPFP_I64_Predicate_immi32Cst7,
        // MIs[8] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/9, /*MI*/2, /*OpIdx*/7, // MIs[9]
        GIM_CheckOpcode, /*MI*/9, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/9, /*Predicate*/GIPFP_I64_Predicate_immi32Cst7,
        // MIs[9] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/10, /*MI*/2, /*OpIdx*/8, // MIs[10]
        GIM_CheckOpcode, /*MI*/10, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/10, /*Predicate*/GIPFP_I64_Predicate_immi32Cst7,
        // MIs[10] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/11, /*MI*/2, /*OpIdx*/9, // MIs[11]
        GIM_CheckOpcode, /*MI*/11, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/11, /*Predicate*/GIPFP_I64_Predicate_immi32Cst7,
        // MIs[11] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/12, /*MI*/2, /*OpIdx*/10, // MIs[12]
        GIM_CheckOpcode, /*MI*/12, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/12, /*Predicate*/GIPFP_I64_Predicate_immi32Cst7,
        // MIs[12] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/13, /*MI*/2, /*OpIdx*/11, // MIs[13]
        GIM_CheckOpcode, /*MI*/13, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/13, /*Predicate*/GIPFP_I64_Predicate_immi32Cst7,
        // MIs[13] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/14, /*MI*/2, /*OpIdx*/12, // MIs[14]
        GIM_CheckOpcode, /*MI*/14, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/14, /*Predicate*/GIPFP_I64_Predicate_immi32Cst7,
        // MIs[14] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/15, /*MI*/2, /*OpIdx*/13, // MIs[15]
        GIM_CheckOpcode, /*MI*/15, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/15, /*Predicate*/GIPFP_I64_Predicate_immi32Cst7,
        // MIs[15] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/16, /*MI*/2, /*OpIdx*/14, // MIs[16]
        GIM_CheckOpcode, /*MI*/16, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/16, /*Predicate*/GIPFP_I64_Predicate_immi32Cst7,
        // MIs[16] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/17, /*MI*/2, /*OpIdx*/15, // MIs[17]
        GIM_CheckOpcode, /*MI*/17, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/17, /*Predicate*/GIPFP_I64_Predicate_immi32Cst7,
        // MIs[17] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/18, /*MI*/2, /*OpIdx*/16, // MIs[18]
        GIM_CheckOpcode, /*MI*/18, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/18, /*Predicate*/GIPFP_I64_Predicate_immi32Cst7,
        // MIs[18] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        GIM_CheckIsSafeToFold, /*InsnID*/5,
        GIM_CheckIsSafeToFold, /*InsnID*/6,
        GIM_CheckIsSafeToFold, /*InsnID*/7,
        GIM_CheckIsSafeToFold, /*InsnID*/8,
        GIM_CheckIsSafeToFold, /*InsnID*/9,
        GIM_CheckIsSafeToFold, /*InsnID*/10,
        GIM_CheckIsSafeToFold, /*InsnID*/11,
        GIM_CheckIsSafeToFold, /*InsnID*/12,
        GIM_CheckIsSafeToFold, /*InsnID*/13,
        GIM_CheckIsSafeToFold, /*InsnID*/14,
        GIM_CheckIsSafeToFold, /*InsnID*/15,
        GIM_CheckIsSafeToFold, /*InsnID*/16,
        GIM_CheckIsSafeToFold, /*InsnID*/17,
        GIM_CheckIsSafeToFold, /*InsnID*/18,
        // (sra:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$ws, (and:{ *:[v16i8] } (build_vector:{ *:[v16i8] } (imm:{ *:[i32] })<<P:Predicate_immi32Cst7>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst7>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst7>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst7>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst7>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst7>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst7>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst7>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst7>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst7>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst7>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst7>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst7>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst7>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst7>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst7>>), v16i8:{ *:[v16i8] }:$wt))  =>  (SRA_B:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$ws, v16i8:{ *:[v16i8] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SRA_B,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2432,
        GIR_Done,
      // Label 928: @36777
      GIM_Try, /*On fail goto*//*Label 929*/ 37086, // Rule ID 2035 //
        GIM_CheckFeatures, GIFBS_HasMSA,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_BUILD_VECTOR,
        GIM_CheckNumOperands, /*MI*/2, /*Expected*/17,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/4, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/5, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/6, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/7, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/8, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/9, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/10, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/11, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/12, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/13, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/14, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/15, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/16, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIPFP_I64_Predicate_immi32Cst7,
        // MIs[3] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/2, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/4, /*Predicate*/GIPFP_I64_Predicate_immi32Cst7,
        // MIs[4] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/2, /*OpIdx*/3, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/5, /*Predicate*/GIPFP_I64_Predicate_immi32Cst7,
        // MIs[5] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/2, /*OpIdx*/4, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/6, /*Predicate*/GIPFP_I64_Predicate_immi32Cst7,
        // MIs[6] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/7, /*MI*/2, /*OpIdx*/5, // MIs[7]
        GIM_CheckOpcode, /*MI*/7, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/7, /*Predicate*/GIPFP_I64_Predicate_immi32Cst7,
        // MIs[7] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/8, /*MI*/2, /*OpIdx*/6, // MIs[8]
        GIM_CheckOpcode, /*MI*/8, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/8, /*Predicate*/GIPFP_I64_Predicate_immi32Cst7,
        // MIs[8] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/9, /*MI*/2, /*OpIdx*/7, // MIs[9]
        GIM_CheckOpcode, /*MI*/9, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/9, /*Predicate*/GIPFP_I64_Predicate_immi32Cst7,
        // MIs[9] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/10, /*MI*/2, /*OpIdx*/8, // MIs[10]
        GIM_CheckOpcode, /*MI*/10, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/10, /*Predicate*/GIPFP_I64_Predicate_immi32Cst7,
        // MIs[10] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/11, /*MI*/2, /*OpIdx*/9, // MIs[11]
        GIM_CheckOpcode, /*MI*/11, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/11, /*Predicate*/GIPFP_I64_Predicate_immi32Cst7,
        // MIs[11] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/12, /*MI*/2, /*OpIdx*/10, // MIs[12]
        GIM_CheckOpcode, /*MI*/12, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/12, /*Predicate*/GIPFP_I64_Predicate_immi32Cst7,
        // MIs[12] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/13, /*MI*/2, /*OpIdx*/11, // MIs[13]
        GIM_CheckOpcode, /*MI*/13, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/13, /*Predicate*/GIPFP_I64_Predicate_immi32Cst7,
        // MIs[13] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/14, /*MI*/2, /*OpIdx*/12, // MIs[14]
        GIM_CheckOpcode, /*MI*/14, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/14, /*Predicate*/GIPFP_I64_Predicate_immi32Cst7,
        // MIs[14] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/15, /*MI*/2, /*OpIdx*/13, // MIs[15]
        GIM_CheckOpcode, /*MI*/15, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/15, /*Predicate*/GIPFP_I64_Predicate_immi32Cst7,
        // MIs[15] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/16, /*MI*/2, /*OpIdx*/14, // MIs[16]
        GIM_CheckOpcode, /*MI*/16, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/16, /*Predicate*/GIPFP_I64_Predicate_immi32Cst7,
        // MIs[16] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/17, /*MI*/2, /*OpIdx*/15, // MIs[17]
        GIM_CheckOpcode, /*MI*/17, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/17, /*Predicate*/GIPFP_I64_Predicate_immi32Cst7,
        // MIs[17] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/18, /*MI*/2, /*OpIdx*/16, // MIs[18]
        GIM_CheckOpcode, /*MI*/18, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/18, /*Predicate*/GIPFP_I64_Predicate_immi32Cst7,
        // MIs[18] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        GIM_CheckIsSafeToFold, /*InsnID*/5,
        GIM_CheckIsSafeToFold, /*InsnID*/6,
        GIM_CheckIsSafeToFold, /*InsnID*/7,
        GIM_CheckIsSafeToFold, /*InsnID*/8,
        GIM_CheckIsSafeToFold, /*InsnID*/9,
        GIM_CheckIsSafeToFold, /*InsnID*/10,
        GIM_CheckIsSafeToFold, /*InsnID*/11,
        GIM_CheckIsSafeToFold, /*InsnID*/12,
        GIM_CheckIsSafeToFold, /*InsnID*/13,
        GIM_CheckIsSafeToFold, /*InsnID*/14,
        GIM_CheckIsSafeToFold, /*InsnID*/15,
        GIM_CheckIsSafeToFold, /*InsnID*/16,
        GIM_CheckIsSafeToFold, /*InsnID*/17,
        GIM_CheckIsSafeToFold, /*InsnID*/18,
        // (sra:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$ws, (and:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$wt, (build_vector:{ *:[v16i8] } (imm:{ *:[i32] })<<P:Predicate_immi32Cst7>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst7>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst7>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst7>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst7>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst7>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst7>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst7>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst7>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst7>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst7>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst7>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst7>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst7>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst7>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst7>>)))  =>  (SRA_B:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$ws, v16i8:{ *:[v16i8] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SRA_B,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // wd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // wt
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2035,
        GIR_Done,
      // Label 929: @37086
      GIM_Try, /*On fail goto*//*Label 930*/ 37105, // Rule ID 957 //
        GIM_CheckFeatures, GIFBS_HasMSA_HasStdEnc,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/Mips::MSA128BRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::MSA128BRegClassID,
        // (sra:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (SRA_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/Mips::SRA_B,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 957,
        GIR_Done,
      // Label 930: @37105
      GIM_Reject,
    // Label 927: @37106
    GIM_Reject,
    // Label 906: @37107
    GIM_Reject,
    // Label 25: @37108
    GIM_Try, /*On fail goto*//*Label 931*/ 39611,
      GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
      GIM_SwitchType, /*MI*/0, /*Op*/2, /*[*/1, 3, /*)*//*default:*//*Label 934*/ 37288,
      /*GILLT_s32*//*Label 932*/ 37122,
      /*GILLT_s64*//*Label 933*/ 37205,
      // Label 932: @37122
      GIM_Try, /*On fail goto*//*Label 935*/ 37204,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_Try, /*On fail goto*//*Label 936*/ 37167, // Rule ID 1397 //
          GIM_CheckFeatures, GIFBS_HasStdEnc_NotInMicroMips,
          // MIs[0] Operand 1
          GIM_CheckCmpPredicate, /*MI*/0, /*Op*/1, /*Predicate*/CmpInst::ICMP_EQ,
          GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR32RegClassID,
          GIM_CheckConstantInt, /*MI*/0, /*Op*/3, 0,
          // (setcc:{ *:[i32] } GPR32:{ *:[i32] }:$lhs, 0:{ *:[i32] }, SETEQ:{ *:[Other] })  =>  (SLTiu:{ *:[i32] } GPR32:{ *:[i32] }:$lhs, 1:{ *:[i32] })
          GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SLTiu,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rt
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // lhs
          GIR_AddImm, /*InsnID*/0, /*Imm*/1,
          GIR_EraseFromParent, /*InsnID*/0,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
          // GIR_Coverage, 1397,
          GIR_Done,
        // Label 936: @37167
        GIM_Try, /*On fail goto*//*Label 937*/ 37203, // Rule ID 1398 //
          GIM_CheckFeatures, GIFBS_HasStdEnc_NotInMicroMips,
          // MIs[0] Operand 1
          GIM_CheckCmpPredicate, /*MI*/0, /*Op*/1, /*Predicate*/CmpInst::ICMP_NE,
          GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR32RegClassID,
          GIM_CheckConstantInt, /*MI*/0, /*Op*/3, 0,
          // (setcc:{ *:[i32] } GPR32:{ *:[i32] }:$lhs, 0:{ *:[i32] }, SETNE:{ *:[Other] })  =>  (SLTu:{ *:[i32] } ZERO:{ *:[i32] }, GPR32:{ *:[i32] }:$lhs)
          GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SLTu,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
          GIR_AddRegister, /*InsnID*/0, Mips::ZERO, /*AddRegisterRegFlags*/0,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // lhs
          GIR_EraseFromParent, /*InsnID*/0,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
          // GIR_Coverage, 1398,
          GIR_Done,
        // Label 937: @37203
        GIM_Reject,
      // Label 935: @37204
      GIM_Reject,
      // Label 933: @37205
      GIM_Try, /*On fail goto*//*Label 938*/ 37287,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_Try, /*On fail goto*//*Label 939*/ 37250, // Rule ID 1541 //
          GIM_CheckFeatures, GIFBS_HasMips3_HasStdEnc_IsGP64bit_NotInMicroMips,
          // MIs[0] Operand 1
          GIM_CheckCmpPredicate, /*MI*/0, /*Op*/1, /*Predicate*/CmpInst::ICMP_EQ,
          GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR64RegClassID,
          GIM_CheckConstantInt, /*MI*/0, /*Op*/3, 0,
          // (setcc:{ *:[i32] } GPR64:{ *:[i64] }:$lhs, 0:{ *:[i64] }, SETEQ:{ *:[Other] })  =>  (SLTiu64:{ *:[i32] } GPR64:{ *:[i64] }:$lhs, 1:{ *:[i64] })
          GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SLTiu64,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rt
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // lhs
          GIR_AddImm, /*InsnID*/0, /*Imm*/1,
          GIR_EraseFromParent, /*InsnID*/0,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
          // GIR_Coverage, 1541,
          GIR_Done,
        // Label 939: @37250
        GIM_Try, /*On fail goto*//*Label 940*/ 37286, // Rule ID 1542 //
          GIM_CheckFeatures, GIFBS_HasMips3_HasStdEnc_IsGP64bit_NotInMicroMips,
          // MIs[0] Operand 1
          GIM_CheckCmpPredicate, /*MI*/0, /*Op*/1, /*Predicate*/CmpInst::ICMP_NE,
          GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR64RegClassID,
          GIM_CheckConstantInt, /*MI*/0, /*Op*/3, 0,
          // (setcc:{ *:[i32] } GPR64:{ *:[i64] }:$lhs, 0:{ *:[i64] }, SETNE:{ *:[Other] })  =>  (SLTu64:{ *:[i32] } ZERO_64:{ *:[i64] }, GPR64:{ *:[i64] }:$lhs)
          GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SLTu64,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
          GIR_AddRegister, /*InsnID*/0, Mips::ZERO_64, /*AddRegisterRegFlags*/0,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // lhs
          GIR_EraseFromParent, /*InsnID*/0,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
          // GIR_Coverage, 1542,
          GIR_Done,
        // Label 940: @37286
        GIM_Reject,
      // Label 938: @37287
      GIM_Reject,
      // Label 934: @37288
      GIM_SwitchType, /*MI*/0, /*Op*/2, /*[*/1, 3, /*)*//*default:*//*Label 943*/ 37660,
      /*GILLT_s32*//*Label 941*/ 37296,
      /*GILLT_s64*//*Label 942*/ 37576,
      // Label 941: @37296
      GIM_Try, /*On fail goto*//*Label 944*/ 37575,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_Try, /*On fail goto*//*Label 945*/ 37341, // Rule ID 1837 //
          GIM_CheckFeatures, GIFBS_InMips16Mode,
          GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::CPU16RegsRegClassID,
          // MIs[0] Operand 1
          GIM_CheckCmpPredicate, /*MI*/0, /*Op*/1, /*Predicate*/CmpInst::ICMP_EQ,
          GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::CPU16RegsRegClassID,
          GIM_CheckConstantInt, /*MI*/0, /*Op*/3, 0,
          // (setcc:{ *:[i32] } CPU16Regs:{ *:[i32] }:$lhs, 0:{ *:[i32] }, SETEQ:{ *:[Other] })  =>  (SltiuCCRxImmX16:{ *:[i32] } CPU16Regs:{ *:[i32] }:$lhs, 1:{ *:[i32] })
          GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SltiuCCRxImmX16,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // cc
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // lhs
          GIR_AddImm, /*InsnID*/0, /*Imm*/1,
          GIR_EraseFromParent, /*InsnID*/0,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
          // GIR_Coverage, 1837,
          GIR_Done,
        // Label 945: @37341
        GIM_Try, /*On fail goto*//*Label 946*/ 37415, // Rule ID 1839 //
          GIM_CheckFeatures, GIFBS_InMips16Mode,
          GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::CPU16RegsRegClassID,
          // MIs[0] Operand 1
          GIM_CheckCmpPredicate, /*MI*/0, /*Op*/1, /*Predicate*/CmpInst::ICMP_SGT,
          GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::CPU16RegsRegClassID,
          GIM_CheckConstantInt, /*MI*/0, /*Op*/3, -32769,
          // (setcc:{ *:[i32] } CPU16Regs:{ *:[i32] }:$lhs, -32769:{ *:[i32] }, SETGT:{ *:[Other] })  =>  (XorRxRxRy16:{ *:[i32] } (SltiCCRxImmX16:{ *:[i32] } CPU16Regs:{ *:[i32] }:$lhs, -32768:{ *:[i32] }), (LiRxImmX16:{ *:[i32] } 1:{ *:[i32] }))
          GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
          GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
          GIR_BuildMI, /*InsnID*/2, /*Opcode*/Mips::LiRxImmX16,
          GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
          GIR_AddImm, /*InsnID*/2, /*Imm*/1,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
          GIR_BuildMI, /*InsnID*/1, /*Opcode*/Mips::SltiCCRxImmX16,
          GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
          GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // lhs
          GIR_AddImm, /*InsnID*/1, /*Imm*/-32768,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
          GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::XorRxRxRy16,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rz
          GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
          GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/1, /*TempRegFlags*/0,
          GIR_EraseFromParent, /*InsnID*/0,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
          // GIR_Coverage, 1839,
          GIR_Done,
        // Label 946: @37415
        GIM_Try, /*On fail goto*//*Label 947*/ 37454, // Rule ID 2156 //
          GIM_CheckFeatures, GIFBS_InMicroMips,
          GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
          // MIs[0] Operand 1
          GIM_CheckCmpPredicate, /*MI*/0, /*Op*/1, /*Predicate*/CmpInst::ICMP_EQ,
          GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR32RegClassID,
          GIM_CheckConstantInt, /*MI*/0, /*Op*/3, 0,
          // (setcc:{ *:[i32] } GPR32:{ *:[i32] }:$lhs, 0:{ *:[i32] }, SETEQ:{ *:[Other] })  =>  (SLTiu_MM:{ *:[i32] } GPR32:{ *:[i32] }:$lhs, 1:{ *:[i32] })
          GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SLTiu_MM,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rt
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // lhs
          GIR_AddImm, /*InsnID*/0, /*Imm*/1,
          GIR_EraseFromParent, /*InsnID*/0,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
          // GIR_Coverage, 2156,
          GIR_Done,
        // Label 947: @37454
        GIM_Try, /*On fail goto*//*Label 948*/ 37494, // Rule ID 2157 //
          GIM_CheckFeatures, GIFBS_InMicroMips,
          GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
          // MIs[0] Operand 1
          GIM_CheckCmpPredicate, /*MI*/0, /*Op*/1, /*Predicate*/CmpInst::ICMP_NE,
          GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR32RegClassID,
          GIM_CheckConstantInt, /*MI*/0, /*Op*/3, 0,
          // (setcc:{ *:[i32] } GPR32:{ *:[i32] }:$lhs, 0:{ *:[i32] }, SETNE:{ *:[Other] })  =>  (SLTu_MM:{ *:[i32] } ZERO:{ *:[i32] }, GPR32:{ *:[i32] }:$lhs)
          GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SLTu_MM,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
          GIR_AddRegister, /*InsnID*/0, Mips::ZERO, /*AddRegisterRegFlags*/0,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // lhs
          GIR_EraseFromParent, /*InsnID*/0,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
          // GIR_Coverage, 2157,
          GIR_Done,
        // Label 948: @37494
        GIM_Try, /*On fail goto*//*Label 949*/ 37534, // Rule ID 49 //
          GIM_CheckFeatures, GIFBS_HasStdEnc_NotInMicroMips,
          GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
          // MIs[0] Operand 1
          GIM_CheckCmpPredicate, /*MI*/0, /*Op*/1, /*Predicate*/CmpInst::ICMP_SLT,
          GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR32RegClassID,
          GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::GPR32RegClassID,
          // (setcc:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt, SETLT:{ *:[Other] })  =>  (SLT:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
          GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SLT,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
          GIR_EraseFromParent, /*InsnID*/0,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
          // GIR_Coverage, 49,
          GIR_Done,
        // Label 949: @37534
        GIM_Try, /*On fail goto*//*Label 950*/ 37574, // Rule ID 50 //
          GIM_CheckFeatures, GIFBS_HasStdEnc_NotInMicroMips,
          GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
          // MIs[0] Operand 1
          GIM_CheckCmpPredicate, /*MI*/0, /*Op*/1, /*Predicate*/CmpInst::ICMP_ULT,
          GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR32RegClassID,
          GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::GPR32RegClassID,
          // (setcc:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt, SETULT:{ *:[Other] })  =>  (SLTu:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
          GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SLTu,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
          GIR_EraseFromParent, /*InsnID*/0,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
          // GIR_Coverage, 50,
          GIR_Done,
        // Label 950: @37574
        GIM_Reject,
      // Label 944: @37575
      GIM_Reject,
      // Label 942: @37576
      GIM_Try, /*On fail goto*//*Label 951*/ 37659,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_Try, /*On fail goto*//*Label 952*/ 37622, // Rule ID 198 //
          GIM_CheckFeatures, GIFBS_IsGP64bit_NotInMips16Mode,
          // MIs[0] Operand 1
          GIM_CheckCmpPredicate, /*MI*/0, /*Op*/1, /*Predicate*/CmpInst::ICMP_SLT,
          GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR64RegClassID,
          GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::GPR64RegClassID,
          // (setcc:{ *:[i32] } GPR64Opnd:{ *:[i64] }:$rs, GPR64Opnd:{ *:[i64] }:$rt, SETLT:{ *:[Other] })  =>  (SLT64:{ *:[i32] } GPR64Opnd:{ *:[i64] }:$rs, GPR64Opnd:{ *:[i64] }:$rt)
          GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SLT64,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
          GIR_EraseFromParent, /*InsnID*/0,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
          // GIR_Coverage, 198,
          GIR_Done,
        // Label 952: @37622
        GIM_Try, /*On fail goto*//*Label 953*/ 37658, // Rule ID 199 //
          GIM_CheckFeatures, GIFBS_IsGP64bit_NotInMips16Mode,
          // MIs[0] Operand 1
          GIM_CheckCmpPredicate, /*MI*/0, /*Op*/1, /*Predicate*/CmpInst::ICMP_ULT,
          GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR64RegClassID,
          GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::GPR64RegClassID,
          // (setcc:{ *:[i32] } GPR64Opnd:{ *:[i64] }:$rs, GPR64Opnd:{ *:[i64] }:$rt, SETULT:{ *:[Other] })  =>  (SLTu64:{ *:[i32] } GPR64Opnd:{ *:[i64] }:$rs, GPR64Opnd:{ *:[i64] }:$rt)
          GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SLTu64,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
          GIR_EraseFromParent, /*InsnID*/0,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
          // GIR_Coverage, 199,
          GIR_Done,
        // Label 953: @37658
        GIM_Reject,
      // Label 951: @37659
      GIM_Reject,
      // Label 943: @37660
      GIM_SwitchType, /*MI*/0, /*Op*/2, /*[*/1, 3, /*)*//*default:*//*Label 956*/ 38570,
      /*GILLT_s32*//*Label 954*/ 37668,
      /*GILLT_s64*//*Label 955*/ 38155,
      // Label 954: @37668
      GIM_Try, /*On fail goto*//*Label 957*/ 38154,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/Mips::GPR32RegClassID,
        GIM_Try, /*On fail goto*//*Label 958*/ 37714, // Rule ID 1059 //
          GIM_CheckFeatures, GIFBS_InMicroMips,
          // MIs[0] Operand 1
          GIM_CheckCmpPredicate, /*MI*/0, /*Op*/1, /*Predicate*/CmpInst::ICMP_SLT,
          GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR32RegClassID,
          GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::GPR32RegClassID,
          // (setcc:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt, SETLT:{ *:[Other] })  =>  (SLT_MM:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
          GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SLT_MM,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
          GIR_EraseFromParent, /*InsnID*/0,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
          // GIR_Coverage, 1059,
          GIR_Done,
        // Label 958: @37714
        GIM_Try, /*On fail goto*//*Label 959*/ 37750, // Rule ID 1060 //
          GIM_CheckFeatures, GIFBS_InMicroMips,
          // MIs[0] Operand 1
          GIM_CheckCmpPredicate, /*MI*/0, /*Op*/1, /*Predicate*/CmpInst::ICMP_ULT,
          GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR32RegClassID,
          GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::GPR32RegClassID,
          // (setcc:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt, SETULT:{ *:[Other] })  =>  (SLTu_MM:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
          GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SLTu_MM,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
          GIR_EraseFromParent, /*InsnID*/0,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
          // GIR_Coverage, 1060,
          GIR_Done,
        // Label 959: @37750
        GIM_Try, /*On fail goto*//*Label 960*/ 37805, // Rule ID 1399 //
          GIM_CheckFeatures, GIFBS_HasStdEnc_NotInMicroMips,
          // MIs[0] Operand 1
          GIM_CheckCmpPredicate, /*MI*/0, /*Op*/1, /*Predicate*/CmpInst::ICMP_EQ,
          GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR32RegClassID,
          GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::GPR32RegClassID,
          // (setcc:{ *:[i32] } GPR32:{ *:[i32] }:$lhs, GPR32:{ *:[i32] }:$rhs, SETEQ:{ *:[Other] })  =>  (SLTiu:{ *:[i32] } (XOR:{ *:[i32] } GPR32:{ *:[i32] }:$lhs, GPR32:{ *:[i32] }:$rhs), 1:{ *:[i32] })
          GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
          GIR_BuildMI, /*InsnID*/1, /*Opcode*/Mips::XOR,
          GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
          GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // lhs
          GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // rhs
          GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
          GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SLTiu,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rt
          GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
          GIR_AddImm, /*InsnID*/0, /*Imm*/1,
          GIR_EraseFromParent, /*InsnID*/0,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
          // GIR_Coverage, 1399,
          GIR_Done,
        // Label 960: @37805
        GIM_Try, /*On fail goto*//*Label 961*/ 37861, // Rule ID 1400 //
          GIM_CheckFeatures, GIFBS_HasStdEnc_NotInMicroMips,
          // MIs[0] Operand 1
          GIM_CheckCmpPredicate, /*MI*/0, /*Op*/1, /*Predicate*/CmpInst::ICMP_NE,
          GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR32RegClassID,
          GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::GPR32RegClassID,
          // (setcc:{ *:[i32] } GPR32:{ *:[i32] }:$lhs, GPR32:{ *:[i32] }:$rhs, SETNE:{ *:[Other] })  =>  (SLTu:{ *:[i32] } ZERO:{ *:[i32] }, (XOR:{ *:[i32] } GPR32:{ *:[i32] }:$lhs, GPR32:{ *:[i32] }:$rhs))
          GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
          GIR_BuildMI, /*InsnID*/1, /*Opcode*/Mips::XOR,
          GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
          GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // lhs
          GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // rhs
          GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
          GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SLTu,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
          GIR_AddRegister, /*InsnID*/0, Mips::ZERO, /*AddRegisterRegFlags*/0,
          GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
          GIR_EraseFromParent, /*InsnID*/0,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
          // GIR_Coverage, 1400,
          GIR_Done,
        // Label 961: @37861
        GIM_Try, /*On fail goto*//*Label 962*/ 37916, // Rule ID 1401 //
          GIM_CheckFeatures, GIFBS_HasStdEnc_NotInMicroMips,
          // MIs[0] Operand 1
          GIM_CheckCmpPredicate, /*MI*/0, /*Op*/1, /*Predicate*/CmpInst::ICMP_SLE,
          GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR32RegClassID,
          GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::GPR32RegClassID,
          // (setcc:{ *:[i32] } GPR32:{ *:[i32] }:$lhs, GPR32:{ *:[i32] }:$rhs, SETLE:{ *:[Other] })  =>  (XORi:{ *:[i32] } (SLT:{ *:[i32] } GPR32:{ *:[i32] }:$rhs, GPR32:{ *:[i32] }:$lhs), 1:{ *:[i32] })
          GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
          GIR_BuildMI, /*InsnID*/1, /*Opcode*/Mips::SLT,
          GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
          GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // rhs
          GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // lhs
          GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
          GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::XORi,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rt
          GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
          GIR_AddImm, /*InsnID*/0, /*Imm*/1,
          GIR_EraseFromParent, /*InsnID*/0,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
          // GIR_Coverage, 1401,
          GIR_Done,
        // Label 962: @37916
        GIM_Try, /*On fail goto*//*Label 963*/ 37971, // Rule ID 1402 //
          GIM_CheckFeatures, GIFBS_HasStdEnc_NotInMicroMips,
          // MIs[0] Operand 1
          GIM_CheckCmpPredicate, /*MI*/0, /*Op*/1, /*Predicate*/CmpInst::ICMP_ULE,
          GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR32RegClassID,
          GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::GPR32RegClassID,
          // (setcc:{ *:[i32] } GPR32:{ *:[i32] }:$lhs, GPR32:{ *:[i32] }:$rhs, SETULE:{ *:[Other] })  =>  (XORi:{ *:[i32] } (SLTu:{ *:[i32] } GPR32:{ *:[i32] }:$rhs, GPR32:{ *:[i32] }:$lhs), 1:{ *:[i32] })
          GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
          GIR_BuildMI, /*InsnID*/1, /*Opcode*/Mips::SLTu,
          GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
          GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // rhs
          GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // lhs
          GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
          GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::XORi,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rt
          GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
          GIR_AddImm, /*InsnID*/0, /*Imm*/1,
          GIR_EraseFromParent, /*InsnID*/0,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
          // GIR_Coverage, 1402,
          GIR_Done,
        // Label 963: @37971
        GIM_Try, /*On fail goto*//*Label 964*/ 38007, // Rule ID 1403 //
          GIM_CheckFeatures, GIFBS_HasStdEnc_NotInMicroMips,
          // MIs[0] Operand 1
          GIM_CheckCmpPredicate, /*MI*/0, /*Op*/1, /*Predicate*/CmpInst::ICMP_SGT,
          GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR32RegClassID,
          GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::GPR32RegClassID,
          // (setcc:{ *:[i32] } GPR32:{ *:[i32] }:$lhs, GPR32:{ *:[i32] }:$rhs, SETGT:{ *:[Other] })  =>  (SLT:{ *:[i32] } GPR32:{ *:[i32] }:$rhs, GPR32:{ *:[i32] }:$lhs)
          GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SLT,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rhs
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // lhs
          GIR_EraseFromParent, /*InsnID*/0,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
          // GIR_Coverage, 1403,
          GIR_Done,
        // Label 964: @38007
        GIM_Try, /*On fail goto*//*Label 965*/ 38043, // Rule ID 1404 //
          GIM_CheckFeatures, GIFBS_HasStdEnc_NotInMicroMips,
          // MIs[0] Operand 1
          GIM_CheckCmpPredicate, /*MI*/0, /*Op*/1, /*Predicate*/CmpInst::ICMP_UGT,
          GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/Mips::GPR32RegClassID,
          GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/Mips::GPR32RegClassID,
          // (setcc:{ *:[i32] } GPR32:{ *:[i32] }:$lhs, GPR32:{ *:[i32] }:$rhs, SETUGT:{ *:[Other] })  =>  (SLTu:{ *:[i32] } GPR32:{ *:[i32] }:$rhs, GPR32:{ *:[i32] }:$lhs)
          GIR_BuildMI, /*InsnID*/0, /*Opcode*/Mips::SLTu,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // rd
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rhs
        