/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper.runner.server;

import com.google.caliper.bridge.OpenedSocket;
import com.google.caliper.runner.options.CaliperOptions;
import com.google.caliper.util.Uuids;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.AbstractExecutionThreadService;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import java.io.IOException;
import java.io.InputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.concurrent.GuardedBy;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public final class ServerSocketService
extends AbstractExecutionThreadService {
    private final Lock lock = new ReentrantLock();
    @GuardedBy(value="lock")
    private final Map<UUID, SettableFuture<Socket>> halfFinishedConnections = Maps.newHashMap();
    @GuardedBy(value="lock")
    private final SetMultimap<Source, UUID> connectionState = Multimaps.newSetMultimap((Map)Maps.newEnumMap(Source.class), (Supplier)new Supplier<Set<UUID>>(this){

        public Set<UUID> get() {
            return Sets.newHashSet();
        }
    });
    private final CaliperOptions caliperOptions;
    private ServerSocket serverSocket;
    private static final Function<Socket, OpenedSocket> OPENED_SOCKET_FUNCTION = new Function<Socket, OpenedSocket>(){

        public OpenedSocket apply(Socket socket) {
            try {
                return OpenedSocket.fromSocket((Socket)socket);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    };
    private static final Function<Socket, InputStream> INPUT_STREAM_FUNCTION = new Function<Socket, InputStream>(){

        public InputStream apply(Socket socket) {
            try {
                return socket.getInputStream();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    };

    @Inject
    ServerSocketService(CaliperOptions caliperOptions) {
        this.caliperOptions = caliperOptions;
    }

    public int getPort() {
        this.awaitRunning();
        Preconditions.checkState((this.serverSocket != null ? 1 : 0) != 0, (Object)"Socket has not been opened yet");
        return this.serverSocket.getLocalPort();
    }

    public ListenableFuture<OpenedSocket> getConnection(UUID id) {
        return Futures.transform(this.getSocket(id), OPENED_SOCKET_FUNCTION, (Executor)MoreExecutors.directExecutor());
    }

    public ListenableFuture<InputStream> getInputStream(UUID id) {
        return Futures.transform(this.getSocket(id), INPUT_STREAM_FUNCTION, (Executor)MoreExecutors.directExecutor());
    }

    private ListenableFuture<Socket> getSocket(UUID id) {
        Preconditions.checkState((boolean)this.isRunning(), (String)"You can only get connections from a running service: %s", (Object)((Object)this));
        return this.getSocketImpl(id, Source.REQUEST);
    }

    protected void startUp() throws Exception {
        this.serverSocket = new ServerSocket(this.caliperOptions.localPort());
    }

    protected void run() throws Exception {
        while (this.isRunning()) {
            Socket socket;
            try {
                socket = this.serverSocket.accept();
            }
            catch (SocketException e) {
                return;
            }
            UUID id = this.getId(socket);
            this.getSocketImpl(id, Source.ACCEPT).set((Object)socket);
        }
    }

    private UUID getId(Socket socket) throws IOException {
        return Uuids.readFromChannel((ReadableByteChannel)Channels.newChannel(socket.getInputStream()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SettableFuture<Socket> getSocketImpl(UUID id, Source source) {
        this.lock.lock();
        try {
            Preconditions.checkState((boolean)this.connectionState.put((Object)source, (Object)id), (String)"Connection for %s has already been %s", (Object)id, (Object)((Object)source));
            SettableFuture future = this.halfFinishedConnections.get(id);
            if (future == null) {
                future = SettableFuture.create();
                this.halfFinishedConnections.put(id, (SettableFuture<Socket>)future);
            } else {
                this.halfFinishedConnections.remove(id);
            }
            SettableFuture settableFuture = future;
            return settableFuture;
        }
        finally {
            this.lock.unlock();
        }
    }

    protected void triggerShutdown() {
        try {
            this.serverSocket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected void shutDown() throws Exception {
        this.serverSocket.close();
        this.lock.lock();
        try {
            for (SettableFuture<Socket> future : this.halfFinishedConnections.values()) {
                future.setException((Throwable)new Exception("The socket has been closed"));
            }
            this.halfFinishedConnections.clear();
            this.connectionState.clear();
        }
        finally {
            this.lock.unlock();
        }
    }

    private static enum Source {
        REQUEST,
        ACCEPT;

    }
}

