/*
 * Decompiled with CFR 0.152.
 */
package proguard.analysis.cpa.jvm.state.heap.tree;

import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import proguard.analysis.cpa.defaults.MapAbstractState;
import proguard.analysis.cpa.defaults.SetAbstractState;
import proguard.analysis.cpa.jvm.cfa.nodes.JvmCfaNode;
import proguard.analysis.cpa.jvm.domain.reference.Reference;
import proguard.analysis.cpa.jvm.state.heap.JvmHeapAbstractState;
import proguard.analysis.cpa.jvm.state.heap.tree.HeapNode;
import proguard.analysis.cpa.jvm.state.heap.tree.JvmTreeHeapAbstractState;
import proguard.analysis.cpa.jvm.witness.JvmStackLocation;
import proguard.analysis.cpa.jvm.witness.JvmStaticFieldLocation;
import proguard.analysis.cpa.state.MapAbstractStateFactory;

public class JvmTreeHeapPrincipalAbstractState
extends JvmTreeHeapAbstractState<SetAbstractState<Reference>> {
    public JvmTreeHeapPrincipalAbstractState(MapAbstractStateFactory<Reference, HeapNode<SetAbstractState<Reference>>> heapMapAbstractStateFactory, MapAbstractStateFactory<String, SetAbstractState<Reference>> heapNodeMapAbstractStateFactory) {
        this(heapMapAbstractStateFactory.createMapAbstractState(), heapMapAbstractStateFactory, heapNodeMapAbstractStateFactory);
    }

    private JvmTreeHeapPrincipalAbstractState(MapAbstractState<Reference, HeapNode<SetAbstractState<Reference>>> referenceToNode, MapAbstractStateFactory<Reference, HeapNode<SetAbstractState<Reference>>> heapMapAbstractStateFactory, MapAbstractStateFactory<String, SetAbstractState<Reference>> heapNodeMapAbstractStateFactory) {
        super(referenceToNode, heapMapAbstractStateFactory, heapNodeMapAbstractStateFactory, new SetAbstractState<Reference>(new Reference[0]));
    }

    @Override
    public <T> SetAbstractState<Reference> getFieldOrDefault(T object, String fqn, SetAbstractState<Reference> defaultValue) {
        if (!(object instanceof SetAbstractState)) {
            throw new IllegalStateException(String.format("%s does not support %s as reference type", this.getClass().getName(), object.getClass().getName()));
        }
        return ((SetAbstractState)object).stream().reduce(new SetAbstractState<Reference>(new Reference[0]), (result, reference) -> this.referenceToObject.computeIfAbsent(reference, r -> new HeapNode(this.heapNodeMapAbstractStateFactory.createMapAbstractState())).computeIfAbsent(fqn, d -> new SetAbstractState<Reference>(reference)), SetAbstractState::join);
    }

    @Override
    public <T> void setField(T object, String fqn, SetAbstractState<Reference> value) {
        if (!(object instanceof SetAbstractState)) {
            throw new IllegalStateException(String.format("%s does not support %s as reference type", this.getClass().getName(), object.getClass().getName()));
        }
        SetAbstractState objectReference = (SetAbstractState)object;
        if (objectReference.size() <= 1) {
            objectReference.forEach(reference -> this.referenceToObject.computeIfAbsent(reference, r -> new HeapNode(this.heapNodeMapAbstractStateFactory.createMapAbstractState())).put(fqn, value));
        } else {
            objectReference.forEach(reference -> this.referenceToObject.computeIfAbsent(reference, r -> new HeapNode(this.heapNodeMapAbstractStateFactory.createMapAbstractState())).merge(fqn, value));
        }
    }

    @Override
    public <T> SetAbstractState<Reference> getArrayElementOrDefault(T array, SetAbstractState<Reference> index, SetAbstractState<Reference> defaultValue) {
        if (!(array instanceof SetAbstractState)) {
            throw new IllegalStateException(String.format("%s does not support %s as reference type", this.getClass().getName(), array.getClass().getName()));
        }
        return ((SetAbstractState)array).stream().reduce(new SetAbstractState<Reference>(new Reference[0]), (result, reference) -> this.referenceToObject.computeIfAbsent(reference, r -> new HeapNode(this.heapNodeMapAbstractStateFactory.createMapAbstractState())).computeIfAbsent("[]", d -> new SetAbstractState<Reference>(reference)), SetAbstractState::join);
    }

    @Override
    public <T> void setArrayElement(T array, SetAbstractState<Reference> index, SetAbstractState<Reference> value) {
        if (!(array instanceof SetAbstractState)) {
            throw new IllegalStateException(String.format("%s does not support %s as reference type", this.getClass().getName(), array.getClass().getName()));
        }
        ((SetAbstractState)array).forEach(reference -> this.referenceToObject.computeIfAbsent(reference, r -> new HeapNode(this.heapNodeMapAbstractStateFactory.createMapAbstractState())).merge("[]", value));
    }

    @Override
    public SetAbstractState<Reference> newObject(String className, JvmCfaNode creationCite) {
        return new SetAbstractState<Reference>(new Reference(creationCite, new JvmStackLocation(0)));
    }

    @Override
    public SetAbstractState<Reference> newArray(String type, List<SetAbstractState<Reference>> dimensions, JvmCfaNode creationCite) {
        return new SetAbstractState<Reference>(new Reference(creationCite, new JvmStackLocation(0)));
    }

    public Set<Object> getStaticCreationReferences() {
        return this.referenceToObject.keySet().stream().filter(ref -> ref.creationSite instanceof JvmStaticFieldLocation).collect(Collectors.toSet());
    }

    @Override
    public void reduce(Set<Object> roots) {
        ArrayDeque<Object> worklist = new ArrayDeque<Object>(roots);
        HashSet<Object> discoveredReferences = new HashSet<Object>(roots);
        while (!worklist.isEmpty()) {
            Object reference = worklist.pop();
            HeapNode node = (HeapNode)this.referenceToObject.get(reference);
            if (node == null) continue;
            node.values().forEach(n -> n.stream().filter(discoveredReferences::add).forEach(worklist::add));
        }
        this.referenceToObject.entrySet().removeIf(e -> !discoveredReferences.contains(e.getKey()));
    }

    @Override
    public JvmTreeHeapPrincipalAbstractState join(JvmHeapAbstractState<SetAbstractState<Reference>> abstractState) {
        JvmTreeHeapPrincipalAbstractState other = (JvmTreeHeapPrincipalAbstractState)abstractState;
        MapAbstractState<Reference, HeapNode<SetAbstractState<Reference>>> newReferenceToNode = this.referenceToObject.join(other.referenceToObject);
        if (this.referenceToObject.equals(newReferenceToNode)) {
            return this;
        }
        if (other.referenceToObject.equals(newReferenceToNode)) {
            return other;
        }
        return new JvmTreeHeapPrincipalAbstractState(newReferenceToNode, this.heapMapAbstractStateFactory, this.heapNodeMapAbstractStateFactory);
    }

    @Override
    public JvmTreeHeapPrincipalAbstractState copy() {
        return new JvmTreeHeapPrincipalAbstractState(this.referenceToObject.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((HeapNode)e.getValue()).copy(), HeapNode::join, this.heapMapAbstractStateFactory::createMapAbstractState)), this.heapMapAbstractStateFactory, this.heapNodeMapAbstractStateFactory);
    }
}

