/*
 * Decompiled with CFR 0.152.
 */
package proguard.obfuscate;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import proguard.classfile.ClassPool;
import proguard.classfile.Clazz;
import proguard.classfile.util.ClassUtil;
import proguard.util.StringFunction;

public class ClassNameAdapterFunction
implements StringFunction {
    private final ClassPool classPool;
    private final Map packagePrefixMap;

    public ClassNameAdapterFunction(ClassPool classPool) {
        this.classPool = classPool;
        this.packagePrefixMap = ClassNameAdapterFunction.createPackagePrefixMap(classPool);
    }

    public String transform(String fileName) {
        for (int suffixIndex = fileName.length() - 1; suffixIndex > 0; --suffixIndex) {
            char c = fileName.charAt(suffixIndex);
            if (Character.isLetterOrDigit(c)) continue;
            String className = fileName.substring(0, suffixIndex);
            if (c == '/') break;
            Clazz clazz = this.classPool.getClass(className);
            if (clazz == null) continue;
            String newClassName = clazz.getName();
            if (!className.equals(newClassName)) {
                return newClassName + fileName.substring(suffixIndex);
            }
            return fileName;
        }
        String packagePrefix = fileName;
        while ((packagePrefix = ClassUtil.internalPackagePrefix((String)packagePrefix)).length() != 0) {
            String newPackagePrefix = (String)this.packagePrefixMap.get(packagePrefix);
            if (newPackagePrefix == null) continue;
            if (!packagePrefix.equals(newPackagePrefix)) {
                return newPackagePrefix + fileName.substring(packagePrefix.length());
            }
            return null;
        }
        return null;
    }

    private static Map createPackagePrefixMap(ClassPool classPool) {
        HashMap<String, String> packagePrefixMap = new HashMap<String, String>();
        Iterator iterator = classPool.classNames();
        while (iterator.hasNext()) {
            String className = (String)iterator.next();
            String packagePrefix = ClassUtil.internalPackagePrefix((String)className);
            String mappedNewPackagePrefix = (String)packagePrefixMap.get(packagePrefix);
            if (mappedNewPackagePrefix != null && mappedNewPackagePrefix.equals(packagePrefix)) continue;
            String newClassName = classPool.getClass(className).getName();
            String newPackagePrefix = ClassUtil.internalPackagePrefix((String)newClassName);
            packagePrefixMap.put(packagePrefix, newPackagePrefix);
        }
        return packagePrefixMap;
    }
}

