/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.matchers;

import com.google.common.base.MoreObjects;
import com.google.errorprone.VisitorState;
import com.google.errorprone.matchers.Matcher;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePathScanner;

public class HasIdentifier
implements Matcher<Tree> {
    private final Matcher<IdentifierTree> nodeMatcher;

    public HasIdentifier(Matcher<IdentifierTree> nodeMatcher) {
        this.nodeMatcher = nodeMatcher;
    }

    @Override
    public boolean matches(Tree tree, VisitorState state) {
        Boolean matches = (Boolean)new HasIdentifierScanner(state, this.nodeMatcher).scan(state.getPath(), null);
        return (Boolean)MoreObjects.firstNonNull((Object)matches, (Object)false);
    }

    private static class HasIdentifierScanner
    extends TreePathScanner<Boolean, Void> {
        private Matcher<IdentifierTree> idMatcher;
        private VisitorState ancestorState;

        public HasIdentifierScanner(VisitorState ancestorState, Matcher<IdentifierTree> idMatcher) {
            this.ancestorState = ancestorState;
            this.idMatcher = idMatcher;
        }

        @Override
        public Boolean visitIdentifier(IdentifierTree node, Void v) {
            return this.idMatcher.matches(node, this.ancestorState.withPath(this.getCurrentPath()));
        }

        @Override
        public Boolean reduce(Boolean r1, Boolean r2) {
            return (Boolean)MoreObjects.firstNonNull((Object)r1, (Object)false) != false || (Boolean)MoreObjects.firstNonNull((Object)r2, (Object)false) != false;
        }

        @Override
        public Boolean visitClass(ClassTree node, Void v) {
            return (Boolean)MoreObjects.firstNonNull((Object)((Boolean)super.visitClass(node, null)), (Object)false);
        }
    }
}

