/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Streams;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.suppliers.Supplier;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreeScanner;
import com.sun.tools.javac.code.Flags;
import com.sun.tools.javac.code.Scope;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.util.Name;
import java.io.Serializable;
import java.util.EnumSet;
import java.util.Optional;
import java.util.stream.Stream;
import javax.lang.model.element.ElementKind;
import javax.lang.model.type.TypeKind;

@BugPattern(summary="Finalizer may run before native code finishes execution", severity=BugPattern.SeverityLevel.WARNING)
public class UnsafeFinalization
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final Matcher<ExpressionTree> FENCE_MATCHER = MethodMatchers.staticMethod().onClass("java.lang.ref.Reference").named("reachabilityFence");
    private static final Supplier<Name> FINALIZE = VisitorState.memoize((Supplier & Serializable)state -> state.getName("finalize"));
    private static final Supplier<Type> COM_GOOGLE_COMMON_LABS_BASE_FINALIZER = VisitorState.memoize((Supplier & Serializable)state -> state.getTypeFromString("com.google.common.labs.base.Finalizer"));

    public Description matchMethodInvocation(MethodInvocationTree tree, final VisitorState state) {
        Symbol.MethodSymbol sym = ASTHelpers.getSymbol((MethodInvocationTree)tree);
        if (!sym.isStatic() || !ASTHelpers.asFlagSet((long)sym.flags()).contains((Object)Flags.Flag.NATIVE)) {
            return Description.NO_MATCH;
        }
        MethodTree method = ASTHelpers.findEnclosingMethod((VisitorState)state);
        if (method == null) {
            return Description.NO_MATCH;
        }
        Symbol.MethodSymbol enclosing = ASTHelpers.getSymbol((MethodTree)method);
        if (enclosing.isStatic() || enclosing.isConstructor()) {
            return Description.NO_MATCH;
        }
        ImmutableList arguments = (ImmutableList)tree.getArguments().stream().map(ASTHelpers::getSymbol).filter(x -> x != null).collect(ImmutableList.toImmutableList());
        if (arguments.stream().filter(x -> EnumSet.of(TypeKind.INT, TypeKind.LONG).contains((Object)state.getTypes().unboxedTypeOrType(x.asType()).getKind())).noneMatch(arg -> arg.isMemberOf(enclosing.enclClass(), state.getTypes()))) {
            return Description.NO_MATCH;
        }
        if (arguments.stream().anyMatch(arg -> arg.getSimpleName().contentEquals("this") && arg.isMemberOf(enclosing.enclClass(), state.getTypes()))) {
            return Description.NO_MATCH;
        }
        Symbol finalizeSym = UnsafeFinalization.getFinalizer(state, enclosing.enclClass());
        if (finalizeSym == null || finalizeSym.equals(enclosing)) {
            return Description.NO_MATCH;
        }
        if (finalizeSym.enclClass().equals(state.getSymtab().objectType.asElement())) {
            return Description.NO_MATCH;
        }
        final boolean[] sawFence = new boolean[]{false};
        new TreeScanner<Void, Void>(this){
            final /* synthetic */ UnsafeFinalization this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public Void visitMethodInvocation(MethodInvocationTree tree, Void unused) {
                if (FENCE_MATCHER.matches((Tree)tree, state)) {
                    sawFence[0] = true;
                }
                return null;
            }
        }.scan(state.getPath().getCompilationUnit(), null);
        if (sawFence[0]) {
            return Description.NO_MATCH;
        }
        return this.describeMatch(tree);
    }

    private static Symbol getFinalizer(VisitorState state, Symbol.ClassSymbol enclosing) {
        Type finalizerType = (Type)COM_GOOGLE_COMMON_LABS_BASE_FINALIZER.get(state);
        Optional<Symbol.VarSymbol> finalizerField = state.getTypes().closure((Type)enclosing.asType()).stream().flatMap(s -> UnsafeFinalization.getFields(s.asElement())).filter(s -> ASTHelpers.isSameType((Type)finalizerType, (Type)s.asType(), (VisitorState)state)).findFirst();
        if (finalizerField.isPresent()) {
            return finalizerField.get();
        }
        return ASTHelpers.resolveExistingMethod((VisitorState)state, (Symbol.TypeSymbol)enclosing.enclClass(), (Name)((Name)FINALIZE.get(state)), (Iterable)ImmutableList.of(), (Iterable)ImmutableList.of());
    }

    private static Stream<Symbol.VarSymbol> getFields(Symbol.TypeSymbol s) {
        return Streams.stream((Iterable)ASTHelpers.scope((Scope)s.members()).getSymbols(m -> m.getKind() == ElementKind.FIELD)).map(Symbol.VarSymbol.class::cast);
    }
}

