{
  "format_version": 1,
  "sksl": {
    "entrypoint": "stretch_effect_fragment_main",
    "shader": "// This SkSL shader is autogenerated by spirv-cross.\n\nfloat4 flutter_FragCoord;\n\nuniform vec2 u_size;\nuniform float u_max_stretch_intensity;\nuniform float u_overscroll_x;\nuniform float u_overscroll_y;\nuniform float u_interpolation_strength;\nuniform shader u_texture;\nuniform half2 u_texture_size;\n\nvec4 frag_color;\n\nvec2 FLT_flutter_local_FlutterFragCoord()\n{\n    return flutter_FragCoord.xy;\n}\n\nfloat FLT_flutter_local_ease_in(float t, float d)\n{\n    return t * d;\n}\n\nfloat FLT_flutter_local_compute_overscroll_start(float in_pos, float overscroll, float u_stretch_affected_dist, float u_inverse_stretch_affected_dist, float distance_stretched, float interpolation_strength)\n{\n    float offset_pos = u_stretch_affected_dist - in_pos;\n    float param = offset_pos;\n    float param_1 = u_inverse_stretch_affected_dist;\n    float pos_based_variation = mix(1.0, FLT_flutter_local_ease_in(param, param_1), interpolation_strength);\n    float stretch_intensity = overscroll * pos_based_variation;\n    return distance_stretched - (offset_pos / (1.0 + stretch_intensity));\n}\n\nfloat FLT_flutter_local_compute_overscroll_end(float in_pos, float overscroll, float reverse_stretch_dist, float u_stretch_affected_dist, float u_inverse_stretch_affected_dist, float distance_stretched, float interpolation_strength, float viewport_dimension)\n{\n    float offset_pos = in_pos - reverse_stretch_dist;\n    float param = offset_pos;\n    float param_1 = u_inverse_stretch_affected_dist;\n    float pos_based_variation = mix(1.0, FLT_flutter_local_ease_in(param, param_1), interpolation_strength);\n    float stretch_intensity = (-overscroll) * pos_based_variation;\n    return viewport_dimension - (distance_stretched - (offset_pos / (1.0 + stretch_intensity)));\n}\n\nfloat FLT_flutter_local_compute_streched_effect(float in_pos, float overscroll, float u_stretch_affected_dist, float u_inverse_stretch_affected_dist, float distance_stretched, float distance_diff, float interpolation_strength, float viewport_dimension)\n{\n    if (overscroll > 0.0)\n    {\n        if (in_pos <= u_stretch_affected_dist)\n        {\n            float param = in_pos;\n            float param_1 = overscroll;\n            float param_2 = u_stretch_affected_dist;\n            float param_3 = u_inverse_stretch_affected_dist;\n            float param_4 = distance_stretched;\n            float param_5 = interpolation_strength;\n            return FLT_flutter_local_compute_overscroll_start(param, param_1, param_2, param_3, param_4, param_5);\n        }\n        else\n        {\n            return distance_diff + in_pos;\n        }\n    }\n    else\n    {\n        if (overscroll < 0.0)\n        {\n            float stretch_affected_dist_calc = viewport_dimension - u_stretch_affected_dist;\n            if (in_pos >= stretch_affected_dist_calc)\n            {\n                float param_6 = in_pos;\n                float param_7 = overscroll;\n                float param_8 = stretch_affected_dist_calc;\n                float param_9 = u_stretch_affected_dist;\n                float param_10 = u_inverse_stretch_affected_dist;\n                float param_11 = distance_stretched;\n                float param_12 = interpolation_strength;\n                float param_13 = viewport_dimension;\n                return FLT_flutter_local_compute_overscroll_end(param_6, param_7, param_8, param_9, param_10, param_11, param_12, param_13);\n            }\n            else\n            {\n                return (-distance_diff) + in_pos;\n            }\n        }\n        else\n        {\n            return in_pos;\n        }\n    }\n}\n\nvoid FLT_main()\n{\n    vec2 uv = FLT_flutter_local_FlutterFragCoord() / u_size;\n    float in_u_norm = uv.x;\n    float in_v_norm = uv.y;\n    bool isVertical = u_overscroll_y != 0.0;\n    float overscroll_1 = isVertical ? u_overscroll_y : u_overscroll_x;\n    float norm_distance_stretched = 1.0 / (1.0 + abs(overscroll_1));\n    float norm_dist_diff = norm_distance_stretched - 1.0;\n    float _223;\n    if (isVertical)\n    {\n        _223 = in_u_norm;\n    }\n    else\n    {\n        float param_14 = in_u_norm;\n        float param_15 = overscroll_1;\n        float param_16 = 1.0;\n        float param_17 = 1.0;\n        float param_18 = norm_distance_stretched;\n        float param_19 = norm_dist_diff;\n        float param_20 = u_interpolation_strength;\n        float param_21 = 1.0;\n        _223 = FLT_flutter_local_compute_streched_effect(param_14, param_15, param_16, param_17, param_18, param_19, param_20, param_21);\n    }\n    float out_u_norm = _223;\n    float _246;\n    if (isVertical)\n    {\n        float param_22 = in_v_norm;\n        float param_23 = overscroll_1;\n        float param_24 = 1.0;\n        float param_25 = 1.0;\n        float param_26 = norm_distance_stretched;\n        float param_27 = norm_dist_diff;\n        float param_28 = u_interpolation_strength;\n        float param_29 = 1.0;\n        _246 = FLT_flutter_local_compute_streched_effect(param_22, param_23, param_24, param_25, param_26, param_27, param_28, param_29);\n    }\n    else\n    {\n        _246 = in_v_norm;\n    }\n    float out_v_norm = _246;\n    uv.x = out_u_norm;\n    uv.y = out_v_norm;\n    frag_color = u_texture.eval(u_texture_size * ( uv));\n}\n\nhalf4 main(float2 iFragCoord)\n{\n      flutter_FragCoord = float4(iFragCoord, 0, 0);\n      FLT_main();\n      return frag_color;\n}\n",
    "stage": 1,
    "uniforms": [
      {
        "array_elements": 0,
        "bit_width": 32,
        "columns": 1,
        "location": 0,
        "name": "u_size",
        "rows": 2,
        "type": 10
      },
      {
        "array_elements": 0,
        "bit_width": 0,
        "columns": 1,
        "location": 1,
        "name": "u_texture",
        "rows": 1,
        "type": 12
      },
      {
        "array_elements": 0,
        "bit_width": 32,
        "columns": 1,
        "location": 2,
        "name": "u_max_stretch_intensity",
        "rows": 1,
        "type": 10
      },
      {
        "array_elements": 0,
        "bit_width": 32,
        "columns": 1,
        "location": 3,
        "name": "u_overscroll_x",
        "rows": 1,
        "type": 10
      },
      {
        "array_elements": 0,
        "bit_width": 32,
        "columns": 1,
        "location": 4,
        "name": "u_overscroll_y",
        "rows": 1,
        "type": 10
      },
      {
        "array_elements": 0,
        "bit_width": 32,
        "columns": 1,
        "location": 5,
        "name": "u_interpolation_strength",
        "rows": 1,
        "type": 10
      }
    ]
  }
}