/* A Bison parser, made by GNU Bison 3.8.2.  */

/* Bison implementation for Yacc-like parsers in C

   Copyright (C) 1984, 1989-1990, 2000-2015, 2018-2021 Free Software Foundation,
   Inc.

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <https://www.gnu.org/licenses/>.  */

/* As a special exception, you may create a larger work that contains
   part or all of the Bison parser skeleton and distribute that work
   under terms of your choice, so long as that work isn't itself a
   parser generator using the skeleton or a modified version thereof
   as a parser skeleton.  Alternatively, if you modify or redistribute
   the parser skeleton itself, you may (at your option) remove this
   special exception, which will cause the skeleton and the resulting
   Bison output files to be licensed under the GNU General Public
   License without this special exception.

   This special exception was added by the Free Software Foundation in
   version 2.2 of Bison.  */

/* C LALR(1) parser skeleton written by Richard Stallman, by
   simplifying the original so-called "semantic" parser.  */

/* DO NOT RELY ON FEATURES THAT ARE NOT DOCUMENTED in the manual,
   especially those whose name start with YY_ or yy_.  They are
   private implementation details that can be changed or removed.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output, and Bison version.  */
#define YYBISON 30802

/* Bison version string.  */
#define YYBISON_VERSION "3.8.2"

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 0

/* Push parsers.  */
#define YYPUSH 0

/* Pull parsers.  */
#define YYPULL 1




/* First part of user prologue.  */
#line 24 "parse.y"

#include "got_compat.h"

#include <sys/ioctl.h>
#include <sys/types.h>
#include <sys/queue.h>
#include <sys/socket.h>
#include <sys/stat.h>
#include <sys/un.h>

#include <net/if.h>
#include <netinet/in.h>

#include <arpa/inet.h>

#include <ctype.h>
#include <err.h>
#include <errno.h>
#include <event.h>
#include <ifaddrs.h>
#include <limits.h>
#include <netdb.h>
#include <stdarg.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <syslog.h>
#include <unistd.h>

#include "got_reference.h"
#include "got_object.h"
#include "got_path.h"
#include "got_error.h"

#include "media.h"
#include "gotwebd.h"
#include "log.h"

TAILQ_HEAD(files, file)		 files = TAILQ_HEAD_INITIALIZER(files);
static struct file {
	TAILQ_ENTRY(file)	 entry;
	FILE			*stream;
	char			*name;
	size_t			 ungetpos;
	size_t			 ungetsize;
	unsigned char		*ungetbuf;
	int			 eof_reached;
	int			 lineno;
	int			 errors;
} *file, *topfile;
struct file	*pushfile(const char *, int);
static int	 popfile(void);
int		 check_file_secrecy(int, const char *);
int		 yyparse(void);
int		 yylex(void);
int		 yyerror(const char *, ...)
    __attribute__((__format__ (printf, 1, 2)))
    __attribute__((__nonnull__ (1)));
int		 kw_cmp(const void *, const void *);
int		 lookup(char *);
int		 igetc(void);
int		 lgetc(int);
void		 lungetc(int);
int		 findeol(void);

TAILQ_HEAD(symhead, sym)	 symhead = TAILQ_HEAD_INITIALIZER(symhead);
struct sym {
	TAILQ_ENTRY(sym)	 entry;
	int			 used;
	int			 persist;
	char			*nam;
	char			*val;
};

int	 symset(const char *, const char *, int);
char	*symget(const char *);

static int		 errors;

static struct gotwebd		*gotwebd;
static struct server		*new_srv;
static struct server		*conf_new_server(const char *);
int				 getservice(const char *);
int				 n;
struct media_type		 media;

int		 get_addrs(const char *, const char *);
struct address *get_unix_addr(const char *);
int		 addr_dup_check(struct addresslist *, struct address *);
void		 add_addr(struct address *);

static struct website	*new_website;
static struct website	*conf_new_website(struct server *, const char *);

static struct gotwebd_repo	*new_repo;
static struct gotwebd_repo	*conf_new_repo(struct server *, const char *);
static void			 conf_new_access_rule(
				    struct gotwebd_access_rule_list *,
				    enum gotwebd_access, char *);


typedef struct {
	union {
		long long	 number;
		char		*string;
	} v;
	int lineno;
} YYSTYPE;

static int
mediatype_ok(const char *s)
{
	size_t i;

	for (i = 0; s[i] != '\0'; ++i) {
		if (!isalnum((unsigned char)s[i]) &&
		    s[i] != '-' && s[i] != '+' && s[i] != '.' &&
		    s[i] != '/')
			return (-1);
	}
	return (0);
}


#line 196 "parse.c"

# ifndef YY_CAST
#  ifdef __cplusplus
#   define YY_CAST(Type, Val) static_cast<Type> (Val)
#   define YY_REINTERPRET_CAST(Type, Val) reinterpret_cast<Type> (Val)
#  else
#   define YY_CAST(Type, Val) ((Type) (Val))
#   define YY_REINTERPRET_CAST(Type, Val) ((Type) (Val))
#  endif
# endif
# ifndef YY_NULLPTR
#  if defined __cplusplus
#   if 201103L <= __cplusplus
#    define YY_NULLPTR nullptr
#   else
#    define YY_NULLPTR 0
#   endif
#  else
#   define YY_NULLPTR ((void*)0)
#  endif
# endif


/* Debug traces.  */
#ifndef YYDEBUG
# define YYDEBUG 0
#endif
#if YYDEBUG
extern int yydebug;
#endif

/* Token kinds.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
  enum yytokentype
  {
    YYEMPTY = -2,
    YYEOF = 0,                     /* "end of file"  */
    YYerror = 256,                 /* error  */
    YYUNDEF = 257,                 /* "invalid token"  */
    LISTEN = 258,                  /* LISTEN  */
    GOTWEBD_LOGIN = 259,           /* GOTWEBD_LOGIN  */
    WWW = 260,                     /* WWW  */
    SITE_NAME = 261,               /* SITE_NAME  */
    SITE_OWNER = 262,              /* SITE_OWNER  */
    SITE_LINK = 263,               /* SITE_LINK  */
    LOGO = 264,                    /* LOGO  */
    LOGO_URL = 265,                /* LOGO_URL  */
    SHOW_REPO_OWNER = 266,         /* SHOW_REPO_OWNER  */
    SHOW_REPO_AGE = 267,           /* SHOW_REPO_AGE  */
    SHOW_REPO_DESCRIPTION = 268,   /* SHOW_REPO_DESCRIPTION  */
    MAX_REPOS_DISPLAY = 269,       /* MAX_REPOS_DISPLAY  */
    REPOS_PATH = 270,              /* REPOS_PATH  */
    MAX_COMMITS_DISPLAY = 271,     /* MAX_COMMITS_DISPLAY  */
    ON = 272,                      /* ON  */
    ERROR = 273,                   /* ERROR  */
    SHOW_SITE_OWNER = 274,         /* SHOW_SITE_OWNER  */
    SHOW_REPO_CLONEURL = 275,      /* SHOW_REPO_CLONEURL  */
    PORT = 276,                    /* PORT  */
    PREFORK = 277,                 /* PREFORK  */
    RESPECT_EXPORTOK = 278,        /* RESPECT_EXPORTOK  */
    SERVER = 279,                  /* SERVER  */
    CHROOT = 280,                  /* CHROOT  */
    CUSTOM_CSS = 281,              /* CUSTOM_CSS  */
    SOCKET = 282,                  /* SOCKET  */
    HINT = 283,                    /* HINT  */
    HTDOCS = 284,                  /* HTDOCS  */
    GOTWEB_URL_ROOT = 285,         /* GOTWEB_URL_ROOT  */
    SUMMARY_COMMITS_DISPLAY = 286, /* SUMMARY_COMMITS_DISPLAY  */
    SUMMARY_TAGS_DISPLAY = 287,    /* SUMMARY_TAGS_DISPLAY  */
    USER = 288,                    /* USER  */
    AUTHENTICATION = 289,          /* AUTHENTICATION  */
    ENABLE = 290,                  /* ENABLE  */
    DISABLE = 291,                 /* DISABLE  */
    INSECURE = 292,                /* INSECURE  */
    REPOSITORY = 293,              /* REPOSITORY  */
    REPOSITORIES = 294,            /* REPOSITORIES  */
    PERMIT = 295,                  /* PERMIT  */
    DENY = 296,                    /* DENY  */
    HIDE = 297,                    /* HIDE  */
    WEBSITE = 298,                 /* WEBSITE  */
    PATH = 299,                    /* PATH  */
    BRANCH = 300,                  /* BRANCH  */
    REPOS_URL_PATH = 301,          /* REPOS_URL_PATH  */
    DESCRIPTION = 302,             /* DESCRIPTION  */
    TYPES = 303,                   /* TYPES  */
    INCLUDE = 304,                 /* INCLUDE  */
    GOTWEBD_CONTROL = 305,         /* GOTWEBD_CONTROL  */
    STRING = 306,                  /* STRING  */
    NUMBER = 307                   /* NUMBER  */
  };
  typedef enum yytokentype yytoken_kind_t;
#endif
/* Token kinds.  */
#define YYEMPTY -2
#define YYEOF 0
#define YYerror 256
#define YYUNDEF 257
#define LISTEN 258
#define GOTWEBD_LOGIN 259
#define WWW 260
#define SITE_NAME 261
#define SITE_OWNER 262
#define SITE_LINK 263
#define LOGO 264
#define LOGO_URL 265
#define SHOW_REPO_OWNER 266
#define SHOW_REPO_AGE 267
#define SHOW_REPO_DESCRIPTION 268
#define MAX_REPOS_DISPLAY 269
#define REPOS_PATH 270
#define MAX_COMMITS_DISPLAY 271
#define ON 272
#define ERROR 273
#define SHOW_SITE_OWNER 274
#define SHOW_REPO_CLONEURL 275
#define PORT 276
#define PREFORK 277
#define RESPECT_EXPORTOK 278
#define SERVER 279
#define CHROOT 280
#define CUSTOM_CSS 281
#define SOCKET 282
#define HINT 283
#define HTDOCS 284
#define GOTWEB_URL_ROOT 285
#define SUMMARY_COMMITS_DISPLAY 286
#define SUMMARY_TAGS_DISPLAY 287
#define USER 288
#define AUTHENTICATION 289
#define ENABLE 290
#define DISABLE 291
#define INSECURE 292
#define REPOSITORY 293
#define REPOSITORIES 294
#define PERMIT 295
#define DENY 296
#define HIDE 297
#define WEBSITE 298
#define PATH 299
#define BRANCH 300
#define REPOS_URL_PATH 301
#define DESCRIPTION 302
#define TYPES 303
#define INCLUDE 304
#define GOTWEBD_CONTROL 305
#define STRING 306
#define NUMBER 307

/* Value type.  */


extern YYSTYPE yylval;


int yyparse (void);



/* Symbol kind.  */
enum yysymbol_kind_t
{
  YYSYMBOL_YYEMPTY = -2,
  YYSYMBOL_YYEOF = 0,                      /* "end of file"  */
  YYSYMBOL_YYerror = 1,                    /* error  */
  YYSYMBOL_YYUNDEF = 2,                    /* "invalid token"  */
  YYSYMBOL_LISTEN = 3,                     /* LISTEN  */
  YYSYMBOL_GOTWEBD_LOGIN = 4,              /* GOTWEBD_LOGIN  */
  YYSYMBOL_WWW = 5,                        /* WWW  */
  YYSYMBOL_SITE_NAME = 6,                  /* SITE_NAME  */
  YYSYMBOL_SITE_OWNER = 7,                 /* SITE_OWNER  */
  YYSYMBOL_SITE_LINK = 8,                  /* SITE_LINK  */
  YYSYMBOL_LOGO = 9,                       /* LOGO  */
  YYSYMBOL_LOGO_URL = 10,                  /* LOGO_URL  */
  YYSYMBOL_SHOW_REPO_OWNER = 11,           /* SHOW_REPO_OWNER  */
  YYSYMBOL_SHOW_REPO_AGE = 12,             /* SHOW_REPO_AGE  */
  YYSYMBOL_SHOW_REPO_DESCRIPTION = 13,     /* SHOW_REPO_DESCRIPTION  */
  YYSYMBOL_MAX_REPOS_DISPLAY = 14,         /* MAX_REPOS_DISPLAY  */
  YYSYMBOL_REPOS_PATH = 15,                /* REPOS_PATH  */
  YYSYMBOL_MAX_COMMITS_DISPLAY = 16,       /* MAX_COMMITS_DISPLAY  */
  YYSYMBOL_ON = 17,                        /* ON  */
  YYSYMBOL_ERROR = 18,                     /* ERROR  */
  YYSYMBOL_SHOW_SITE_OWNER = 19,           /* SHOW_SITE_OWNER  */
  YYSYMBOL_SHOW_REPO_CLONEURL = 20,        /* SHOW_REPO_CLONEURL  */
  YYSYMBOL_PORT = 21,                      /* PORT  */
  YYSYMBOL_PREFORK = 22,                   /* PREFORK  */
  YYSYMBOL_RESPECT_EXPORTOK = 23,          /* RESPECT_EXPORTOK  */
  YYSYMBOL_SERVER = 24,                    /* SERVER  */
  YYSYMBOL_CHROOT = 25,                    /* CHROOT  */
  YYSYMBOL_CUSTOM_CSS = 26,                /* CUSTOM_CSS  */
  YYSYMBOL_SOCKET = 27,                    /* SOCKET  */
  YYSYMBOL_HINT = 28,                      /* HINT  */
  YYSYMBOL_HTDOCS = 29,                    /* HTDOCS  */
  YYSYMBOL_GOTWEB_URL_ROOT = 30,           /* GOTWEB_URL_ROOT  */
  YYSYMBOL_SUMMARY_COMMITS_DISPLAY = 31,   /* SUMMARY_COMMITS_DISPLAY  */
  YYSYMBOL_SUMMARY_TAGS_DISPLAY = 32,      /* SUMMARY_TAGS_DISPLAY  */
  YYSYMBOL_USER = 33,                      /* USER  */
  YYSYMBOL_AUTHENTICATION = 34,            /* AUTHENTICATION  */
  YYSYMBOL_ENABLE = 35,                    /* ENABLE  */
  YYSYMBOL_DISABLE = 36,                   /* DISABLE  */
  YYSYMBOL_INSECURE = 37,                  /* INSECURE  */
  YYSYMBOL_REPOSITORY = 38,                /* REPOSITORY  */
  YYSYMBOL_REPOSITORIES = 39,              /* REPOSITORIES  */
  YYSYMBOL_PERMIT = 40,                    /* PERMIT  */
  YYSYMBOL_DENY = 41,                      /* DENY  */
  YYSYMBOL_HIDE = 42,                      /* HIDE  */
  YYSYMBOL_WEBSITE = 43,                   /* WEBSITE  */
  YYSYMBOL_PATH = 44,                      /* PATH  */
  YYSYMBOL_BRANCH = 45,                    /* BRANCH  */
  YYSYMBOL_REPOS_URL_PATH = 46,            /* REPOS_URL_PATH  */
  YYSYMBOL_DESCRIPTION = 47,               /* DESCRIPTION  */
  YYSYMBOL_TYPES = 48,                     /* TYPES  */
  YYSYMBOL_INCLUDE = 49,                   /* INCLUDE  */
  YYSYMBOL_GOTWEBD_CONTROL = 50,           /* GOTWEBD_CONTROL  */
  YYSYMBOL_STRING = 51,                    /* STRING  */
  YYSYMBOL_NUMBER = 52,                    /* NUMBER  */
  YYSYMBOL_53_n_ = 53,                     /* '\n'  */
  YYSYMBOL_54_ = 54,                       /* '='  */
  YYSYMBOL_55_ = 55,                       /* '*'  */
  YYSYMBOL_56_ = 56,                       /* '{'  */
  YYSYMBOL_57_ = 57,                       /* '}'  */
  YYSYMBOL_58_ = 58,                       /* '/'  */
  YYSYMBOL_59_ = 59,                       /* ';'  */
  YYSYMBOL_YYACCEPT = 60,                  /* $accept  */
  YYSYMBOL_grammar = 61,                   /* grammar  */
  YYSYMBOL_include = 62,                   /* include  */
  YYSYMBOL_varset = 63,                    /* varset  */
  YYSYMBOL_numberstring = 64,              /* numberstring  */
  YYSYMBOL_boolean = 65,                   /* boolean  */
  YYSYMBOL_listen_addr = 66,               /* listen_addr  */
  YYSYMBOL_main = 67,                      /* main  */
  YYSYMBOL_server = 68,                    /* server  */
  YYSYMBOL_69_1 = 69,                      /* $@1  */
  YYSYMBOL_serveropts1 = 70,               /* serveropts1  */
  YYSYMBOL_serveropts2 = 71,               /* serveropts2  */
  YYSYMBOL_websiteopts2 = 72,              /* websiteopts2  */
  YYSYMBOL_websiteopts1 = 73,              /* websiteopts1  */
  YYSYMBOL_website = 74,                   /* website  */
  YYSYMBOL_75_2 = 75,                      /* $@2  */
  YYSYMBOL_repository = 76,                /* repository  */
  YYSYMBOL_77_3 = 77,                      /* $@3  */
  YYSYMBOL_repoopts2 = 78,                 /* repoopts2  */
  YYSYMBOL_repoopts1 = 79,                 /* repoopts1  */
  YYSYMBOL_types = 80,                     /* types  */
  YYSYMBOL_mediaopts_l = 81,               /* mediaopts_l  */
  YYSYMBOL_mediaoptsl = 82,                /* mediaoptsl  */
  YYSYMBOL_mediastring = 83,               /* mediastring  */
  YYSYMBOL_medianames_l = 84,              /* medianames_l  */
  YYSYMBOL_medianamesl = 85,               /* medianamesl  */
  YYSYMBOL_nl = 86,                        /* nl  */
  YYSYMBOL_optsemicolon = 87,              /* optsemicolon  */
  YYSYMBOL_optnl = 88                      /* optnl  */
};
typedef enum yysymbol_kind_t yysymbol_kind_t;




#ifdef short
# undef short
#endif

/* On compilers that do not define __PTRDIFF_MAX__ etc., make sure
   <limits.h> and (if available) <stdint.h> are included
   so that the code can choose integer types of a good width.  */

#ifndef __PTRDIFF_MAX__
# include <limits.h> /* INFRINGES ON USER NAME SPACE */
# if defined __STDC_VERSION__ && 199901 <= __STDC_VERSION__
#  include <stdint.h> /* INFRINGES ON USER NAME SPACE */
#  define YY_STDINT_H
# endif
#endif

/* Narrow types that promote to a signed type and that can represent a
   signed or unsigned integer of at least N bits.  In tables they can
   save space and decrease cache pressure.  Promoting to a signed type
   helps avoid bugs in integer arithmetic.  */

#ifdef __INT_LEAST8_MAX__
typedef __INT_LEAST8_TYPE__ yytype_int8;
#elif defined YY_STDINT_H
typedef int_least8_t yytype_int8;
#else
typedef signed char yytype_int8;
#endif

#ifdef __INT_LEAST16_MAX__
typedef __INT_LEAST16_TYPE__ yytype_int16;
#elif defined YY_STDINT_H
typedef int_least16_t yytype_int16;
#else
typedef short yytype_int16;
#endif

/* Work around bug in HP-UX 11.23, which defines these macros
   incorrectly for preprocessor constants.  This workaround can likely
   be removed in 2023, as HPE has promised support for HP-UX 11.23
   (aka HP-UX 11i v2) only through the end of 2022; see Table 2 of
   <https://h20195.www2.hpe.com/V2/getpdf.aspx/4AA4-7673ENW.pdf>.  */
#ifdef __hpux
# undef UINT_LEAST8_MAX
# undef UINT_LEAST16_MAX
# define UINT_LEAST8_MAX 255
# define UINT_LEAST16_MAX 65535
#endif

#if defined __UINT_LEAST8_MAX__ && __UINT_LEAST8_MAX__ <= __INT_MAX__
typedef __UINT_LEAST8_TYPE__ yytype_uint8;
#elif (!defined __UINT_LEAST8_MAX__ && defined YY_STDINT_H \
       && UINT_LEAST8_MAX <= INT_MAX)
typedef uint_least8_t yytype_uint8;
#elif !defined __UINT_LEAST8_MAX__ && UCHAR_MAX <= INT_MAX
typedef unsigned char yytype_uint8;
#else
typedef short yytype_uint8;
#endif

#if defined __UINT_LEAST16_MAX__ && __UINT_LEAST16_MAX__ <= __INT_MAX__
typedef __UINT_LEAST16_TYPE__ yytype_uint16;
#elif (!defined __UINT_LEAST16_MAX__ && defined YY_STDINT_H \
       && UINT_LEAST16_MAX <= INT_MAX)
typedef uint_least16_t yytype_uint16;
#elif !defined __UINT_LEAST16_MAX__ && USHRT_MAX <= INT_MAX
typedef unsigned short yytype_uint16;
#else
typedef int yytype_uint16;
#endif

#ifndef YYPTRDIFF_T
# if defined __PTRDIFF_TYPE__ && defined __PTRDIFF_MAX__
#  define YYPTRDIFF_T __PTRDIFF_TYPE__
#  define YYPTRDIFF_MAXIMUM __PTRDIFF_MAX__
# elif defined PTRDIFF_MAX
#  ifndef ptrdiff_t
#   include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  endif
#  define YYPTRDIFF_T ptrdiff_t
#  define YYPTRDIFF_MAXIMUM PTRDIFF_MAX
# else
#  define YYPTRDIFF_T long
#  define YYPTRDIFF_MAXIMUM LONG_MAX
# endif
#endif

#ifndef YYSIZE_T
# ifdef __SIZE_TYPE__
#  define YYSIZE_T __SIZE_TYPE__
# elif defined size_t
#  define YYSIZE_T size_t
# elif defined __STDC_VERSION__ && 199901 <= __STDC_VERSION__
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# else
#  define YYSIZE_T unsigned
# endif
#endif

#define YYSIZE_MAXIMUM                                  \
  YY_CAST (YYPTRDIFF_T,                                 \
           (YYPTRDIFF_MAXIMUM < YY_CAST (YYSIZE_T, -1)  \
            ? YYPTRDIFF_MAXIMUM                         \
            : YY_CAST (YYSIZE_T, -1)))

#define YYSIZEOF(X) YY_CAST (YYPTRDIFF_T, sizeof (X))


/* Stored state numbers (used for stacks). */
typedef yytype_uint8 yy_state_t;

/* State numbers in computations.  */
typedef int yy_state_fast_t;

#ifndef YY_
# if defined YYENABLE_NLS && YYENABLE_NLS
#  if ENABLE_NLS
#   include <libintl.h> /* INFRINGES ON USER NAME SPACE */
#   define YY_(Msgid) dgettext ("bison-runtime", Msgid)
#  endif
# endif
# ifndef YY_
#  define YY_(Msgid) Msgid
# endif
#endif


#ifndef YY_ATTRIBUTE_PURE
# if defined __GNUC__ && 2 < __GNUC__ + (96 <= __GNUC_MINOR__)
#  define YY_ATTRIBUTE_PURE __attribute__ ((__pure__))
# else
#  define YY_ATTRIBUTE_PURE
# endif
#endif

#ifndef YY_ATTRIBUTE_UNUSED
# if defined __GNUC__ && 2 < __GNUC__ + (7 <= __GNUC_MINOR__)
#  define YY_ATTRIBUTE_UNUSED __attribute__ ((__unused__))
# else
#  define YY_ATTRIBUTE_UNUSED
# endif
#endif

/* Suppress unused-variable warnings by "using" E.  */
#if ! defined lint || defined __GNUC__
# define YY_USE(E) ((void) (E))
#else
# define YY_USE(E) /* empty */
#endif

/* Suppress an incorrect diagnostic about yylval being uninitialized.  */
#if defined __GNUC__ && ! defined __ICC && 406 <= __GNUC__ * 100 + __GNUC_MINOR__
# if __GNUC__ * 100 + __GNUC_MINOR__ < 407
#  define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN                           \
    _Pragma ("GCC diagnostic push")                                     \
    _Pragma ("GCC diagnostic ignored \"-Wuninitialized\"")
# else
#  define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN                           \
    _Pragma ("GCC diagnostic push")                                     \
    _Pragma ("GCC diagnostic ignored \"-Wuninitialized\"")              \
    _Pragma ("GCC diagnostic ignored \"-Wmaybe-uninitialized\"")
# endif
# define YY_IGNORE_MAYBE_UNINITIALIZED_END      \
    _Pragma ("GCC diagnostic pop")
#else
# define YY_INITIAL_VALUE(Value) Value
#endif
#ifndef YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_END
#endif
#ifndef YY_INITIAL_VALUE
# define YY_INITIAL_VALUE(Value) /* Nothing. */
#endif

#if defined __cplusplus && defined __GNUC__ && ! defined __ICC && 6 <= __GNUC__
# define YY_IGNORE_USELESS_CAST_BEGIN                          \
    _Pragma ("GCC diagnostic push")                            \
    _Pragma ("GCC diagnostic ignored \"-Wuseless-cast\"")
# define YY_IGNORE_USELESS_CAST_END            \
    _Pragma ("GCC diagnostic pop")
#endif
#ifndef YY_IGNORE_USELESS_CAST_BEGIN
# define YY_IGNORE_USELESS_CAST_BEGIN
# define YY_IGNORE_USELESS_CAST_END
#endif


#define YY_ASSERT(E) ((void) (0 && (E)))

#if !defined yyoverflow

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_USE_ALLOCA
#  if YYSTACK_USE_ALLOCA
#   ifdef __GNUC__
#    define YYSTACK_ALLOC __builtin_alloca
#   elif defined __BUILTIN_VA_ARG_INCR
#    include <alloca.h> /* INFRINGES ON USER NAME SPACE */
#   elif defined _AIX
#    define YYSTACK_ALLOC __alloca
#   elif defined _MSC_VER
#    include <malloc.h> /* INFRINGES ON USER NAME SPACE */
#    define alloca _alloca
#   else
#    define YYSTACK_ALLOC alloca
#    if ! defined _ALLOCA_H && ! defined EXIT_SUCCESS
#     include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
      /* Use EXIT_SUCCESS as a witness for stdlib.h.  */
#     ifndef EXIT_SUCCESS
#      define EXIT_SUCCESS 0
#     endif
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's 'empty if-body' warning.  */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
#  ifndef YYSTACK_ALLOC_MAXIMUM
    /* The OS might guarantee only one guard page at the bottom of the stack,
       and a page size can be as small as 4096 bytes.  So we cannot safely
       invoke alloca (N) if N exceeds 4096.  Use a slightly smaller number
       to allow for a few compiler-allocated temporary stack slots.  */
#   define YYSTACK_ALLOC_MAXIMUM 4032 /* reasonable circa 2006 */
#  endif
# else
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
#  ifndef YYSTACK_ALLOC_MAXIMUM
#   define YYSTACK_ALLOC_MAXIMUM YYSIZE_MAXIMUM
#  endif
#  if (defined __cplusplus && ! defined EXIT_SUCCESS \
       && ! ((defined YYMALLOC || defined malloc) \
             && (defined YYFREE || defined free)))
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   ifndef EXIT_SUCCESS
#    define EXIT_SUCCESS 0
#   endif
#  endif
#  ifndef YYMALLOC
#   define YYMALLOC malloc
#   if ! defined malloc && ! defined EXIT_SUCCESS
void *malloc (YYSIZE_T); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
#  ifndef YYFREE
#   define YYFREE free
#   if ! defined free && ! defined EXIT_SUCCESS
void free (void *); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
# endif
#endif /* !defined yyoverflow */

#if (! defined yyoverflow \
     && (! defined __cplusplus \
         || (defined YYSTYPE_IS_TRIVIAL && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  yy_state_t yyss_alloc;
  YYSTYPE yyvs_alloc;
};

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (YYSIZEOF (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (YYSIZEOF (yy_state_t) + YYSIZEOF (YYSTYPE)) \
      + YYSTACK_GAP_MAXIMUM)

# define YYCOPY_NEEDED 1

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack_alloc, Stack)                           \
    do                                                                  \
      {                                                                 \
        YYPTRDIFF_T yynewbytes;                                         \
        YYCOPY (&yyptr->Stack_alloc, Stack, yysize);                    \
        Stack = &yyptr->Stack_alloc;                                    \
        yynewbytes = yystacksize * YYSIZEOF (*Stack) + YYSTACK_GAP_MAXIMUM; \
        yyptr += yynewbytes / YYSIZEOF (*yyptr);                        \
      }                                                                 \
    while (0)

#endif

#if defined YYCOPY_NEEDED && YYCOPY_NEEDED
/* Copy COUNT objects from SRC to DST.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined __GNUC__ && 1 < __GNUC__
#   define YYCOPY(Dst, Src, Count) \
      __builtin_memcpy (Dst, Src, YY_CAST (YYSIZE_T, (Count)) * sizeof (*(Src)))
#  else
#   define YYCOPY(Dst, Src, Count)              \
      do                                        \
        {                                       \
          YYPTRDIFF_T yyi;                      \
          for (yyi = 0; yyi < (Count); yyi++)   \
            (Dst)[yyi] = (Src)[yyi];            \
        }                                       \
      while (0)
#  endif
# endif
#endif /* !YYCOPY_NEEDED */

/* YYFINAL -- State number of the termination state.  */
#define YYFINAL  2
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   237

/* YYNTOKENS -- Number of terminals.  */
#define YYNTOKENS  60
/* YYNNTS -- Number of nonterminals.  */
#define YYNNTS  29
/* YYNRULES -- Number of rules.  */
#define YYNRULES  108
/* YYNSTATES -- Number of states.  */
#define YYNSTATES  215

/* YYMAXUTOK -- Last valid token kind.  */
#define YYMAXUTOK   307


/* YYTRANSLATE(TOKEN-NUM) -- Symbol number corresponding to TOKEN-NUM
   as returned by yylex, with out-of-bounds checking.  */
#define YYTRANSLATE(YYX)                                \
  (0 <= (YYX) && (YYX) <= YYMAXUTOK                     \
   ? YY_CAST (yysymbol_kind_t, yytranslate[YYX])        \
   : YYSYMBOL_YYUNDEF)

/* YYTRANSLATE[TOKEN-NUM] -- Symbol number corresponding to TOKEN-NUM
   as returned by yylex.  */
static const yytype_int8 yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
      53,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,    55,     2,     2,     2,     2,    58,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,    59,
       2,    54,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,    56,     2,    57,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52
};

#if YYDEBUG
/* YYRLINE[YYN] -- Source line where rule number YYN was defined.  */
static const yytype_int16 yyrline[] =
{
       0,   167,   167,   168,   169,   170,   171,   172,   173,   176,
     191,   209,   210,   219,   233,   234,   243,   244,   247,   255,
     278,   286,   302,   314,   320,   326,   334,   342,   350,   354,
     358,   372,   384,   404,   421,   452,   482,   498,   513,   513,
     531,   541,   551,   561,   571,   580,   590,   600,   603,   606,
     609,   612,   615,   618,   621,   633,   653,   661,   669,   677,
     685,   694,   703,   712,   716,   720,   737,   767,   797,   798,
     801,   802,   805,   806,   808,   820,   840,   852,   861,   870,
     879,   883,   889,   889,   896,   896,   915,   916,   919,   928,
     937,   946,   950,   954,   957,   970,   973,   974,   977,   978,
     981,  1005,  1006,  1009,  1032,  1035,  1036,  1039,  1040
};
#endif

/** Accessing symbol of state STATE.  */
#define YY_ACCESSING_SYMBOL(State) YY_CAST (yysymbol_kind_t, yystos[State])

#if YYDEBUG || 0
/* The user-facing name of the symbol whose (internal) number is
   YYSYMBOL.  No bounds checking.  */
static const char *yysymbol_name (yysymbol_kind_t yysymbol) YY_ATTRIBUTE_UNUSED;

/* YYTNAME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals.  */
static const char *const yytname[] =
{
  "\"end of file\"", "error", "\"invalid token\"", "LISTEN",
  "GOTWEBD_LOGIN", "WWW", "SITE_NAME", "SITE_OWNER", "SITE_LINK", "LOGO",
  "LOGO_URL", "SHOW_REPO_OWNER", "SHOW_REPO_AGE", "SHOW_REPO_DESCRIPTION",
  "MAX_REPOS_DISPLAY", "REPOS_PATH", "MAX_COMMITS_DISPLAY", "ON", "ERROR",
  "SHOW_SITE_OWNER", "SHOW_REPO_CLONEURL", "PORT", "PREFORK",
  "RESPECT_EXPORTOK", "SERVER", "CHROOT", "CUSTOM_CSS", "SOCKET", "HINT",
  "HTDOCS", "GOTWEB_URL_ROOT", "SUMMARY_COMMITS_DISPLAY",
  "SUMMARY_TAGS_DISPLAY", "USER", "AUTHENTICATION", "ENABLE", "DISABLE",
  "INSECURE", "REPOSITORY", "REPOSITORIES", "PERMIT", "DENY", "HIDE",
  "WEBSITE", "PATH", "BRANCH", "REPOS_URL_PATH", "DESCRIPTION", "TYPES",
  "INCLUDE", "GOTWEBD_CONTROL", "STRING", "NUMBER", "'\\n'", "'='", "'*'",
  "'{'", "'}'", "'/'", "';'", "$accept", "grammar", "include", "varset",
  "numberstring", "boolean", "listen_addr", "main", "server", "$@1",
  "serveropts1", "serveropts2", "websiteopts2", "websiteopts1", "website",
  "$@2", "repository", "$@3", "repoopts2", "repoopts1", "types",
  "mediaopts_l", "mediaoptsl", "mediastring", "medianames_l",
  "medianamesl", "nl", "optsemicolon", "optnl", YY_NULLPTR
};

static const char *
yysymbol_name (yysymbol_kind_t yysymbol)
{
  return yytname[yysymbol];
}
#endif

#define YYPACT_NINF (-91)

#define yypact_value_is_default(Yyn) \
  ((Yyn) == YYPACT_NINF)

#define YYTABLE_NINF (-39)

#define yytable_value_is_error(Yyn) \
  0

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
static const yytype_int16 yypact[] =
{
     -91,   143,   -91,   -35,     6,   -19,     3,     0,     2,     4,
       5,     8,    13,    41,    44,   -22,   -22,    28,    27,    58,
      35,   -91,    39,    40,    43,    49,   -91,   -23,    53,   -16,
      56,   -91,    52,   -91,   -91,   -91,   -91,    72,   -91,   -91,
     -91,   -91,   -91,   -91,    57,    62,    70,   -91,   -91,   -91,
     -91,    76,   -91,   -91,   108,   -91,    78,    81,   -91,    80,
     -91,    57,   -25,   -91,   -91,   -91,   -18,   -91,   -91,    57,
     -91,    83,    77,   -91,    19,    84,   -22,   -91,   -91,   191,
     -91,    87,   -91,    84,    57,   -91,   -91,    74,   -91,   111,
      89,    90,    91,    94,    98,    -3,    -3,    -3,    99,   101,
     102,    -3,    -3,    -3,   104,   105,   106,   107,   112,   116,
     119,   109,   -22,   -22,   124,   115,   118,    57,    31,   -91,
     -91,   -91,   -91,   -91,   -91,   -91,   -91,    -2,   -91,   -91,
     -91,   -91,   -91,   -91,   -91,   -91,   -91,   -91,   -91,   -91,
     -91,   -91,   -91,   -91,   -91,   -91,   -91,   -91,   -91,   -91,
     121,   -91,   -91,   -91,   -91,    -3,   -91,   -91,   -91,   -91,
      84,   122,   126,   -91,   125,   -91,   129,   -91,   -91,   -91,
      57,    57,   -20,    79,   141,   146,   -22,   -22,   144,   135,
      59,    57,   153,   154,   139,   -22,   -22,   157,   158,    46,
      57,   155,   -91,   -91,   -91,    -3,   -91,   -91,    84,   -91,
     175,   -91,   -91,   -91,   -91,   -91,   -91,   -91,    84,   -91,
     -91,   -91,   -91,   -91,   -91
};

/* YYDEFACT[STATE-NUM] -- Default reduction number in state STATE-NUM.
   Performed when YYTABLE does not specify something else to do.  Zero
   means the default is an error.  */
static const yytype_int8 yydefact[] =
{
       2,     0,     1,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     3,     0,     0,     0,     0,     8,     0,     0,     0,
       0,    18,    37,    19,    33,    34,    23,    26,    25,    11,
      12,    28,    29,    35,   108,     0,     0,     4,     5,     6,
       7,     0,    17,    16,     0,    30,     0,     0,    24,     0,
      27,   108,     0,    36,    10,    22,     0,    32,    31,   108,
     107,     0,     0,    99,     0,     0,     0,    20,    21,     0,
       9,     0,    95,     0,   108,    97,   103,   106,   102,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   108,     0,    69,
      68,   100,    96,   104,   105,   101,    98,     0,    41,    42,
      43,    44,    45,    14,    13,    15,    48,    49,    50,    56,
      40,    57,    47,    51,    52,    46,    65,    66,    58,    59,
      61,    60,    84,    63,    64,     0,    82,    67,    71,    39,
       0,     0,     0,    62,     0,    53,     0,    70,    55,    54,
     108,   108,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   108,     0,     0,     0,     0,     0,     0,     0,     0,
     108,    89,    88,    91,    92,     0,    94,    85,     0,    87,
      78,    77,    74,    80,    81,    75,    76,    83,     0,    73,
      90,    93,    86,    79,    72
};

/* YYPGOTO[NTERM-NUM].  */
static const yytype_int16 yypgoto[] =
{
     -91,   -91,   -91,   -91,   -15,   -90,   -91,   -91,   -91,   -91,
      95,   -91,   -91,    26,   -91,   -91,   -91,   -91,   -91,    36,
     -91,   -91,   145,   -91,   -91,   131,   -80,   -91,   -59
};

/* YYDEFGOTO[NTERM-NUM].  */
static const yytype_uint8 yydefgoto[] =
{
       0,     1,    73,    22,    86,   136,    54,    23,    24,    59,
     117,   118,   189,   190,   119,   166,   120,   164,   180,   181,
      25,    74,    75,    76,    87,    88,    85,   126,    62
};

/* YYTABLE[YYPACT[STATE-NUM]] -- What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule whose
   number is the opposite.  If YYTABLE_NINF, syntax error.  */
static const yytype_int16 yytable[] =
{
      41,    42,    70,   122,    51,    56,   137,   138,    28,    29,
      79,   142,   143,   144,   133,   174,   175,    57,    26,   161,
     176,   177,   178,    27,    71,   123,    72,   179,    52,    39,
      40,   162,    53,    77,    78,    89,    30,    90,    91,    92,
      93,    94,    95,    96,    97,    98,    99,   100,   134,   135,
     101,   102,    31,    32,   103,    33,    34,   104,   158,    35,
     105,   106,   107,   108,    36,   165,   109,   110,    71,   111,
      72,   112,   113,   114,   115,    37,    82,   116,    38,    43,
     167,   182,   183,    44,   184,    45,   185,   186,   159,    46,
     187,   188,    47,    48,   174,   175,    49,   153,   154,   176,
     177,   178,    50,   207,    55,   211,   179,    58,   -38,    60,
      61,   172,   173,    63,   182,   183,   197,   184,   212,   185,
     186,    64,   199,   187,   188,    39,    40,    65,   214,    66,
      67,   209,    68,   124,    80,    81,    69,    84,   121,   127,
     128,   129,   130,     2,     3,   131,     4,     5,     6,   132,
     150,   139,   140,   151,   141,   145,   146,   147,   163,   148,
     152,   193,   194,   155,   149,     7,   156,     8,     9,   157,
     203,   204,    10,    11,   168,   191,    12,   169,    13,    14,
     192,   170,   195,    15,    16,   171,   196,   200,   201,    17,
     202,    18,   210,    19,    20,    89,    21,    90,    91,    92,
      93,    94,    95,    96,    97,    98,    99,   100,   205,   206,
     101,   102,   213,   160,   103,   208,   198,   104,   125,    83,
     105,   106,   107,   108,     0,     0,   109,   110,     0,   111,
       0,   112,   113,   114,   115,     0,     0,   116
};

static const yytype_int16 yycheck[] =
{
      15,    16,    61,    83,    27,    21,    96,    97,    27,    28,
      69,   101,   102,   103,    17,    35,    36,    33,    53,    21,
      40,    41,    42,    17,    49,    84,    51,    47,    51,    51,
      52,    33,    55,    51,    52,     4,    33,     6,     7,     8,
       9,    10,    11,    12,    13,    14,    15,    16,    51,    52,
      19,    20,    52,    51,    23,    51,    51,    26,   117,    51,
      29,    30,    31,    32,    51,   155,    35,    36,    49,    38,
      51,    40,    41,    42,    43,    34,    57,    46,    34,    51,
     160,    35,    36,    56,    38,    27,    40,    41,    57,    54,
      44,    45,    53,    53,    35,    36,    53,   112,   113,    40,
      41,    42,    53,    57,    51,   195,    47,    51,    56,    37,
      53,   170,   171,    51,    35,    36,    57,    38,   198,    40,
      41,    51,   181,    44,    45,    51,    52,    51,   208,    21,
      52,   190,    51,    59,    51,    58,    56,    53,    51,    28,
      51,    51,    51,     0,     1,    51,     3,     4,     5,    51,
      34,    52,    51,    34,    52,    51,    51,    51,    37,    52,
      51,   176,   177,    39,    52,    22,    51,    24,    25,    51,
     185,   186,    29,    30,    52,    34,    33,    51,    35,    36,
      34,    56,    38,    40,    41,    56,    51,    34,    34,    46,
      51,    48,    37,    50,    51,     4,    53,     6,     7,     8,
       9,    10,    11,    12,    13,    14,    15,    16,    51,    51,
      19,    20,    37,   118,    23,   189,   180,    26,    87,    74,
      29,    30,    31,    32,    -1,    -1,    35,    36,    -1,    38,
      -1,    40,    41,    42,    43,    -1,    -1,    46
};

/* YYSTOS[STATE-NUM] -- The symbol kind of the accessing symbol of
   state STATE-NUM.  */
static const yytype_int8 yystos[] =
{
       0,    61,     0,     1,     3,     4,     5,    22,    24,    25,
      29,    30,    33,    35,    36,    40,    41,    46,    48,    50,
      51,    53,    63,    67,    68,    80,    53,    17,    27,    28,
      33,    52,    51,    51,    51,    51,    51,    34,    34,    51,
      52,    64,    64,    51,    56,    27,    54,    53,    53,    53,
      53,    27,    51,    55,    66,    51,    21,    33,    51,    69,
      37,    53,    88,    51,    51,    51,    21,    52,    51,    56,
      88,    49,    51,    62,    81,    82,    83,    51,    52,    88,
      51,    58,    57,    82,    53,    86,    64,    84,    85,     4,
       6,     7,     8,     9,    10,    11,    12,    13,    14,    15,
      16,    19,    20,    23,    26,    29,    30,    31,    32,    35,
      36,    38,    40,    41,    42,    43,    46,    70,    71,    74,
      76,    51,    86,    88,    59,    85,    87,    28,    51,    51,
      51,    51,    51,    17,    51,    52,    65,    65,    65,    52,
      51,    52,    65,    65,    65,    51,    51,    51,    52,    52,
      34,    34,    51,    64,    64,    39,    51,    51,    88,    57,
      70,    21,    33,    37,    77,    65,    75,    86,    52,    51,
      56,    56,    88,    88,    35,    36,    40,    41,    42,    47,
      78,    79,    35,    36,    38,    40,    41,    44,    45,    72,
      73,    34,    34,    64,    64,    38,    51,    57,    79,    88,
      34,    34,    51,    64,    64,    51,    51,    57,    73,    88,
      37,    65,    86,    37,    86
};

/* YYR1[RULE-NUM] -- Symbol kind of the left-hand side of rule RULE-NUM.  */
static const yytype_int8 yyr1[] =
{
       0,    60,    61,    61,    61,    61,    61,    61,    61,    62,
      63,    64,    64,    65,    65,    65,    66,    66,    67,    67,
      67,    67,    67,    67,    67,    67,    67,    67,    67,    67,
      67,    67,    67,    67,    67,    67,    67,    68,    69,    68,
      70,    70,    70,    70,    70,    70,    70,    70,    70,    70,
      70,    70,    70,    70,    70,    70,    70,    70,    70,    70,
      70,    70,    70,    70,    70,    70,    70,    70,    70,    70,
      71,    71,    72,    72,    73,    73,    73,    73,    73,    73,
      73,    73,    75,    74,    77,    76,    78,    78,    79,    79,
      79,    79,    79,    79,    79,    80,    81,    81,    82,    82,
      83,    84,    84,    85,    86,    87,    87,    88,    88
};

/* YYR2[RULE-NUM] -- Number of symbols on the right-hand side of rule RULE-NUM.  */
static const yytype_int8 yyr2[] =
{
       0,     2,     0,     2,     3,     3,     3,     3,     3,     2,
       3,     1,     1,     1,     1,     1,     1,     1,     2,     2,
       5,     5,     4,     2,     3,     2,     2,     3,     2,     2,
       3,     4,     4,     2,     2,     2,     3,     2,     0,     7,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     3,     4,     4,     2,     2,     2,     2,
       2,     2,     3,     2,     2,     2,     2,     2,     1,     1,
       3,     2,     3,     2,     2,     2,     2,     2,     2,     3,
       2,     2,     0,     7,     0,     7,     3,     2,     2,     2,
       3,     2,     2,     3,     2,     5,     3,     2,     3,     1,
       3,     2,     1,     1,     2,     1,     0,     2,     0
};


enum { YYENOMEM = -2 };

#define yyerrok         (yyerrstatus = 0)
#define yyclearin       (yychar = YYEMPTY)

#define YYACCEPT        goto yyacceptlab
#define YYABORT         goto yyabortlab
#define YYERROR         goto yyerrorlab
#define YYNOMEM         goto yyexhaustedlab


#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)                                    \
  do                                                              \
    if (yychar == YYEMPTY)                                        \
      {                                                           \
        yychar = (Token);                                         \
        yylval = (Value);                                         \
        YYPOPSTACK (yylen);                                       \
        yystate = *yyssp;                                         \
        goto yybackup;                                            \
      }                                                           \
    else                                                          \
      {                                                           \
        yyerror (YY_("syntax error: cannot back up")); \
        YYERROR;                                                  \
      }                                                           \
  while (0)

/* Backward compatibility with an undocumented macro.
   Use YYerror or YYUNDEF. */
#define YYERRCODE YYUNDEF


/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)                        \
do {                                            \
  if (yydebug)                                  \
    YYFPRINTF Args;                             \
} while (0)




# define YY_SYMBOL_PRINT(Title, Kind, Value, Location)                    \
do {                                                                      \
  if (yydebug)                                                            \
    {                                                                     \
      YYFPRINTF (stderr, "%s ", Title);                                   \
      yy_symbol_print (stderr,                                            \
                  Kind, Value); \
      YYFPRINTF (stderr, "\n");                                           \
    }                                                                     \
} while (0)


/*-----------------------------------.
| Print this symbol's value on YYO.  |
`-----------------------------------*/

static void
yy_symbol_value_print (FILE *yyo,
                       yysymbol_kind_t yykind, YYSTYPE const * const yyvaluep)
{
  FILE *yyoutput = yyo;
  YY_USE (yyoutput);
  if (!yyvaluep)
    return;
  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  YY_USE (yykind);
  YY_IGNORE_MAYBE_UNINITIALIZED_END
}


/*---------------------------.
| Print this symbol on YYO.  |
`---------------------------*/

static void
yy_symbol_print (FILE *yyo,
                 yysymbol_kind_t yykind, YYSTYPE const * const yyvaluep)
{
  YYFPRINTF (yyo, "%s %s (",
             yykind < YYNTOKENS ? "token" : "nterm", yysymbol_name (yykind));

  yy_symbol_value_print (yyo, yykind, yyvaluep);
  YYFPRINTF (yyo, ")");
}

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (included).                                                   |
`------------------------------------------------------------------*/

static void
yy_stack_print (yy_state_t *yybottom, yy_state_t *yytop)
{
  YYFPRINTF (stderr, "Stack now");
  for (; yybottom <= yytop; yybottom++)
    {
      int yybot = *yybottom;
      YYFPRINTF (stderr, " %d", yybot);
    }
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)                            \
do {                                                            \
  if (yydebug)                                                  \
    yy_stack_print ((Bottom), (Top));                           \
} while (0)


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

static void
yy_reduce_print (yy_state_t *yyssp, YYSTYPE *yyvsp,
                 int yyrule)
{
  int yylno = yyrline[yyrule];
  int yynrhs = yyr2[yyrule];
  int yyi;
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %d):\n",
             yyrule - 1, yylno);
  /* The symbols being reduced.  */
  for (yyi = 0; yyi < yynrhs; yyi++)
    {
      YYFPRINTF (stderr, "   $%d = ", yyi + 1);
      yy_symbol_print (stderr,
                       YY_ACCESSING_SYMBOL (+yyssp[yyi + 1 - yynrhs]),
                       &yyvsp[(yyi + 1) - (yynrhs)]);
      YYFPRINTF (stderr, "\n");
    }
}

# define YY_REDUCE_PRINT(Rule)          \
do {                                    \
  if (yydebug)                          \
    yy_reduce_print (yyssp, yyvsp, Rule); \
} while (0)

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args) ((void) 0)
# define YY_SYMBOL_PRINT(Title, Kind, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !YYDEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   YYSTACK_ALLOC_MAXIMUM < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif






/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

static void
yydestruct (const char *yymsg,
            yysymbol_kind_t yykind, YYSTYPE *yyvaluep)
{
  YY_USE (yyvaluep);
  if (!yymsg)
    yymsg = "Deleting";
  YY_SYMBOL_PRINT (yymsg, yykind, yyvaluep, yylocationp);

  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  YY_USE (yykind);
  YY_IGNORE_MAYBE_UNINITIALIZED_END
}


/* Lookahead token kind.  */
int yychar;

/* The semantic value of the lookahead symbol.  */
YYSTYPE yylval;
/* Number of syntax errors so far.  */
int yynerrs;




/*----------.
| yyparse.  |
`----------*/

int
yyparse (void)
{
    yy_state_fast_t yystate = 0;
    /* Number of tokens to shift before error messages enabled.  */
    int yyerrstatus = 0;

    /* Refer to the stacks through separate pointers, to allow yyoverflow
       to reallocate them elsewhere.  */

    /* Their size.  */
    YYPTRDIFF_T yystacksize = YYINITDEPTH;

    /* The state stack: array, bottom, top.  */
    yy_state_t yyssa[YYINITDEPTH];
    yy_state_t *yyss = yyssa;
    yy_state_t *yyssp = yyss;

    /* The semantic value stack: array, bottom, top.  */
    YYSTYPE yyvsa[YYINITDEPTH];
    YYSTYPE *yyvs = yyvsa;
    YYSTYPE *yyvsp = yyvs;

  int yyn;
  /* The return value of yyparse.  */
  int yyresult;
  /* Lookahead symbol kind.  */
  yysymbol_kind_t yytoken = YYSYMBOL_YYEMPTY;
  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;



#define YYPOPSTACK(N)   (yyvsp -= (N), yyssp -= (N))

  /* The number of symbols on the RHS of the reduced rule.
     Keep to zero when no symbol should be popped.  */
  int yylen = 0;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yychar = YYEMPTY; /* Cause a token to be read.  */

  goto yysetstate;


/*------------------------------------------------------------.
| yynewstate -- push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed.  So pushing a state here evens the stacks.  */
  yyssp++;


/*--------------------------------------------------------------------.
| yysetstate -- set current state (the top of the stack) to yystate.  |
`--------------------------------------------------------------------*/
yysetstate:
  YYDPRINTF ((stderr, "Entering state %d\n", yystate));
  YY_ASSERT (0 <= yystate && yystate < YYNSTATES);
  YY_IGNORE_USELESS_CAST_BEGIN
  *yyssp = YY_CAST (yy_state_t, yystate);
  YY_IGNORE_USELESS_CAST_END
  YY_STACK_PRINT (yyss, yyssp);

  if (yyss + yystacksize - 1 <= yyssp)
#if !defined yyoverflow && !defined YYSTACK_RELOCATE
    YYNOMEM;
#else
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYPTRDIFF_T yysize = yyssp - yyss + 1;

# if defined yyoverflow
      {
        /* Give user a chance to reallocate the stack.  Use copies of
           these so that the &'s don't force the real ones into
           memory.  */
        yy_state_t *yyss1 = yyss;
        YYSTYPE *yyvs1 = yyvs;

        /* Each stack pointer address is followed by the size of the
           data in use in that stack, in bytes.  This used to be a
           conditional around just the two extra args, but that might
           be undefined if yyoverflow is a macro.  */
        yyoverflow (YY_("memory exhausted"),
                    &yyss1, yysize * YYSIZEOF (*yyssp),
                    &yyvs1, yysize * YYSIZEOF (*yyvsp),
                    &yystacksize);
        yyss = yyss1;
        yyvs = yyvs1;
      }
# else /* defined YYSTACK_RELOCATE */
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
        YYNOMEM;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
        yystacksize = YYMAXDEPTH;

      {
        yy_state_t *yyss1 = yyss;
        union yyalloc *yyptr =
          YY_CAST (union yyalloc *,
                   YYSTACK_ALLOC (YY_CAST (YYSIZE_T, YYSTACK_BYTES (yystacksize))));
        if (! yyptr)
          YYNOMEM;
        YYSTACK_RELOCATE (yyss_alloc, yyss);
        YYSTACK_RELOCATE (yyvs_alloc, yyvs);
#  undef YYSTACK_RELOCATE
        if (yyss1 != yyssa)
          YYSTACK_FREE (yyss1);
      }
# endif

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;

      YY_IGNORE_USELESS_CAST_BEGIN
      YYDPRINTF ((stderr, "Stack size increased to %ld\n",
                  YY_CAST (long, yystacksize)));
      YY_IGNORE_USELESS_CAST_END

      if (yyss + yystacksize - 1 <= yyssp)
        YYABORT;
    }
#endif /* !defined yyoverflow && !defined YYSTACK_RELOCATE */


  if (yystate == YYFINAL)
    YYACCEPT;

  goto yybackup;


/*-----------.
| yybackup.  |
`-----------*/
yybackup:
  /* Do appropriate processing given the current state.  Read a
     lookahead token if we need one and don't already have one.  */

  /* First try to decide what to do without reference to lookahead token.  */
  yyn = yypact[yystate];
  if (yypact_value_is_default (yyn))
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* YYCHAR is either empty, or end-of-input, or a valid lookahead.  */
  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token\n"));
      yychar = yylex ();
    }

  if (yychar <= YYEOF)
    {
      yychar = YYEOF;
      yytoken = YYSYMBOL_YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else if (yychar == YYerror)
    {
      /* The scanner already issued an error message, process directly
         to error recovery.  But do not keep the error token as
         lookahead, it is too special and may lead us to an endless
         loop in error recovery. */
      yychar = YYUNDEF;
      yytoken = YYSYMBOL_YYerror;
      goto yyerrlab1;
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YY_SYMBOL_PRINT ("Next token is", yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    goto yydefault;
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yytable_value_is_error (yyn))
        goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  /* Shift the lookahead token.  */
  YY_SYMBOL_PRINT ("Shifting", yytoken, &yylval, &yylloc);
  yystate = yyn;
  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END

  /* Discard the shifted token.  */
  yychar = YYEMPTY;
  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     '$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];


  YY_REDUCE_PRINT (yyn);
  switch (yyn)
    {
  case 8: /* grammar: grammar error '\n'  */
#line 173 "parse.y"
                                                { file->errors++; }
#line 1556 "parse.c"
    break;

  case 9: /* include: INCLUDE STRING  */
#line 176 "parse.y"
                                                {
			struct file	*nfile;

			if ((nfile = pushfile((yyvsp[0].v.string), 0)) == NULL) {
				yyerror("failed to include file %s", (yyvsp[0].v.string));
				free((yyvsp[0].v.string));
				YYERROR;
			}
			free((yyvsp[0].v.string));

			file = nfile;
			lungetc('\n');
		}
#line 1574 "parse.c"
    break;

  case 10: /* varset: STRING '=' STRING  */
#line 191 "parse.y"
                                        {
			char *s = (yyvsp[-2].v.string);
			while (*s++) {
				if (isspace((unsigned char)*s)) {
					yyerror("macro name cannot contain "
					    "whitespace");
					free((yyvsp[-2].v.string));
					free((yyvsp[0].v.string));
					YYERROR;
				}
			}
			if (symset((yyvsp[-2].v.string), (yyvsp[0].v.string), 0) == -1)
				fatal("cannot store variable");
			free((yyvsp[-2].v.string));
			free((yyvsp[0].v.string));
		}
#line 1595 "parse.c"
    break;

  case 12: /* numberstring: NUMBER  */
#line 210 "parse.y"
                         {
			if (asprintf(&(yyval.v.string), "%lld", (long long)(yyvsp[0].v.number)) == -1) {
				yyerror("asprintf: %s", strerror(errno));
				YYERROR;
			}
		}
#line 1606 "parse.c"
    break;

  case 13: /* boolean: STRING  */
#line 219 "parse.y"
                         {
			if (strcasecmp((yyvsp[0].v.string), "1") == 0 ||
			    strcasecmp((yyvsp[0].v.string), "on") == 0)
				(yyval.v.number) = 1;
			else if (strcasecmp((yyvsp[0].v.string), "0") == 0 ||
			    strcasecmp((yyvsp[0].v.string), "off") == 0)
				(yyval.v.number) = 0;
			else {
				yyerror("invalid boolean value '%s'", (yyvsp[0].v.string));
				free((yyvsp[0].v.string));
				YYERROR;
			}
			free((yyvsp[0].v.string));
		}
#line 1625 "parse.c"
    break;

  case 14: /* boolean: ON  */
#line 233 "parse.y"
                     { (yyval.v.number) = 1; }
#line 1631 "parse.c"
    break;

  case 15: /* boolean: NUMBER  */
#line 234 "parse.y"
                         {
			if ((yyvsp[0].v.number) != 0 && (yyvsp[0].v.number) != 1) {
				yyerror("invalid boolean value '%lld'", (yyvsp[0].v.number));
				YYERROR;
			}
			(yyval.v.number) = (yyvsp[0].v.number);
		}
#line 1643 "parse.c"
    break;

  case 16: /* listen_addr: '*'  */
#line 243 "parse.y"
                      { (yyval.v.string) = NULL; }
#line 1649 "parse.c"
    break;

  case 18: /* main: PREFORK NUMBER  */
#line 247 "parse.y"
                                 {
			if ((yyvsp[0].v.number) <= 0 || (yyvsp[0].v.number) > PROC_MAX_INSTANCES) {
				yyerror("prefork is %s: %lld",
				    (yyvsp[0].v.number) <= 0 ? "too small" : "too large", (yyvsp[0].v.number));
				YYERROR;
			}
			gotwebd->prefork = (yyvsp[0].v.number);
		}
#line 1662 "parse.c"
    break;

  case 19: /* main: CHROOT STRING  */
#line 255 "parse.y"
                                {
			if (*(yyvsp[0].v.string) == '\0') {
				yyerror("chroot path can't be an empty"
				    " string");
				free((yyvsp[0].v.string));
				YYERROR;
			}

			n = strlcpy(gotwebd->httpd_chroot, (yyvsp[0].v.string),
			    sizeof(gotwebd->httpd_chroot));
			if (n >= sizeof(gotwebd->httpd_chroot)) {
				yyerror("chroot path too long: %s", (yyvsp[0].v.string));
				free((yyvsp[0].v.string));
				YYERROR;
			}
			if (gotwebd->httpd_chroot[0] != '/') {
				yyerror("chroot path must be an absolute path: "
				    "bad path %s", gotwebd->httpd_chroot);
				free((yyvsp[0].v.string));
				YYERROR;
			}
			free((yyvsp[0].v.string));
		}
#line 1690 "parse.c"
    break;

  case 20: /* main: LISTEN ON listen_addr PORT STRING  */
#line 278 "parse.y"
                                                    {
			if (get_addrs((yyvsp[-2].v.string), (yyvsp[0].v.string)) == -1) {
				yyerror("could not get addrs");
				YYERROR;
			}
			free((yyvsp[-2].v.string));
			free((yyvsp[0].v.string));
		}
#line 1703 "parse.c"
    break;

  case 21: /* main: LISTEN ON listen_addr PORT NUMBER  */
#line 286 "parse.y"
                                                    {
			char portno[32];
			int n;

			n = snprintf(portno, sizeof(portno), "%lld",
			    (long long)(yyvsp[0].v.number));
			if (n < 0 || (size_t)n >= sizeof(portno))
				fatalx("port number too long: %lld",
				    (long long)(yyvsp[0].v.number));

			if (get_addrs((yyvsp[-2].v.string), portno) == -1) {
				yyerror("could not get addrs");
				YYERROR;
			}
			free((yyvsp[-2].v.string));
		}
#line 1724 "parse.c"
    break;

  case 22: /* main: LISTEN ON SOCKET STRING  */
#line 302 "parse.y"
                                          {
			struct address *h;

			h = get_unix_addr((yyvsp[0].v.string));
			if (h == NULL) {
				yyerror("can't listen on %s", (yyvsp[0].v.string));
				free((yyvsp[0].v.string));
				YYERROR;
			}
			add_addr(h);
			free((yyvsp[0].v.string));
		}
#line 1741 "parse.c"
    break;

  case 23: /* main: USER STRING  */
#line 314 "parse.y"
                              {
			if (gotwebd->user != NULL)
				yyerror("user already specified");
			free(gotwebd->user);
			gotwebd->user = (yyvsp[0].v.string);
		}
#line 1752 "parse.c"
    break;

  case 24: /* main: WWW USER STRING  */
#line 320 "parse.y"
                                  {
			if (gotwebd->www_user != NULL)
				yyerror("www user already specified");
			free(gotwebd->www_user);
			gotwebd->www_user = (yyvsp[0].v.string);
		}
#line 1763 "parse.c"
    break;

  case 25: /* main: DISABLE AUTHENTICATION  */
#line 326 "parse.y"
                                         {
			if (gotwebd->auth_config != 0) {
				yyerror("ambiguous global authentication "
				    "setting");
				YYERROR;
			}
			gotwebd->auth_config = GOTWEBD_AUTH_DISABLED;
		}
#line 1776 "parse.c"
    break;

  case 26: /* main: ENABLE AUTHENTICATION  */
#line 334 "parse.y"
                                        {
			if (gotwebd->auth_config != 0) {
				yyerror("ambiguous global authentication "
				    "setting");
				YYERROR;
			}
			gotwebd->auth_config = GOTWEBD_AUTH_SECURE;
		}
#line 1789 "parse.c"
    break;

  case 27: /* main: ENABLE AUTHENTICATION INSECURE  */
#line 342 "parse.y"
                                                 {
			if (gotwebd->auth_config != 0) {
				yyerror("ambiguous global authentication "
				    "setting");
				YYERROR;
			}
			gotwebd->auth_config = GOTWEBD_AUTH_INSECURE;
		}
#line 1802 "parse.c"
    break;

  case 28: /* main: PERMIT numberstring  */
#line 350 "parse.y"
                                      {
			conf_new_access_rule(&gotwebd->access_rules,
			    GOTWEBD_ACCESS_PERMITTED, (yyvsp[0].v.string));
		}
#line 1811 "parse.c"
    break;

  case 29: /* main: DENY numberstring  */
#line 354 "parse.y"
                                    {
			conf_new_access_rule(&gotwebd->access_rules,
			    GOTWEBD_ACCESS_DENIED, (yyvsp[0].v.string));
		}
#line 1820 "parse.c"
    break;

  case 30: /* main: GOTWEBD_LOGIN SOCKET STRING  */
#line 358 "parse.y"
                                              {
			struct address *h;
			h = get_unix_addr((yyvsp[0].v.string));
			if (h == NULL) {
				yyerror("can't listen on %s", (yyvsp[0].v.string));
				free((yyvsp[0].v.string));
				YYERROR;
			}
			if (gotwebd->login_sock != NULL)
				free(gotwebd->login_sock);
			gotwebd->login_sock = sockets_conf_new_socket(-1, h);
			free(h);
			free((yyvsp[0].v.string));
		}
#line 1839 "parse.c"
    break;

  case 31: /* main: GOTWEBD_LOGIN HINT USER STRING  */
#line 372 "parse.y"
                                                 {
			n = strlcpy(gotwebd->login_hint_user, (yyvsp[0].v.string),
			    sizeof(gotwebd->login_hint_user));
			if (n >= sizeof(gotwebd->login_hint_user)) {
				yyerror("login hint user name too long, "
				    "exceeds %zd bytes",
				    sizeof(gotwebd->login_hint_user) - 1);
				free((yyvsp[0].v.string));
				YYERROR;
			}
			free((yyvsp[0].v.string));
		}
#line 1856 "parse.c"
    break;

  case 32: /* main: GOTWEBD_LOGIN HINT PORT NUMBER  */
#line 384 "parse.y"
                                                 {
			int n;

			if ((yyvsp[0].v.number) < 1 || (yyvsp[0].v.number) > USHRT_MAX) {
				fatalx("port number invalid: %lld",
				    (long long)(yyvsp[0].v.number));
			}

			n = snprintf(gotwebd->login_hint_port,
			    sizeof(gotwebd->login_hint_port), "%lld",
			    (long long)(yyvsp[0].v.number));
			if (n < 0) {
				fatal("snprintf: port number %lld:",
				    (long long)(yyvsp[0].v.number));
			}
			if ((size_t)n >= sizeof(gotwebd->login_hint_port)) {
				fatalx("port number too long: %lld",
				    (long long)(yyvsp[0].v.number));
			}
		}
#line 1881 "parse.c"
    break;

  case 33: /* main: HTDOCS STRING  */
#line 404 "parse.y"
                                {
			if (*(yyvsp[0].v.string) == '\0') {
				yyerror("htdocs path can't be an empty"
				    " string");
				free((yyvsp[0].v.string));
				YYERROR;
			}

			n = strlcpy(gotwebd->htdocs_path, (yyvsp[0].v.string),
			    sizeof(gotwebd->htdocs_path));
			if (n >= sizeof(gotwebd->htdocs_path)) {
				yyerror("htdocs path too long: %s", (yyvsp[0].v.string));
				free((yyvsp[0].v.string));
				YYERROR;
			}
			free((yyvsp[0].v.string));
		}
#line 1903 "parse.c"
    break;

  case 34: /* main: GOTWEB_URL_ROOT STRING  */
#line 421 "parse.y"
                                         {
			if (*(yyvsp[0].v.string) == '\0') {
				yyerror("gotweb_url_root can't be an empty"
				    " string");
				free((yyvsp[0].v.string));
				YYERROR;
			}

			if (!got_path_is_root_dir((yyvsp[0].v.string)))
				got_path_strip_trailing_slashes((yyvsp[0].v.string));

			n = strlcpy(gotwebd->gotweb_url_root, (yyvsp[0].v.string),
			    sizeof(gotwebd->gotweb_url_root));
			if (n >= sizeof(gotwebd->gotweb_url_root)) {
				yyerror("gotweb_url_root too long, exceeds "
				    "%zd bytes: %s",
				    sizeof(gotwebd->gotweb_url_root), (yyvsp[0].v.string));
				free((yyvsp[0].v.string));
				YYERROR;
			}

			if (gotwebd->gotweb_url_root[0] != '/') {
				yyerror("gotweb_url_root must be an absolute "
				    "path: bad path %s", (yyvsp[0].v.string));
				free((yyvsp[0].v.string));
				YYERROR;
			}


			free((yyvsp[0].v.string));
		}
#line 1939 "parse.c"
    break;

  case 35: /* main: REPOS_URL_PATH STRING  */
#line 452 "parse.y"
                                        {
			if (*(yyvsp[0].v.string) == '\0') {
				yyerror("repos_url_path can't be an empty"
				    " string");
				free((yyvsp[0].v.string));
				YYERROR;
			}

			if (!got_path_is_root_dir((yyvsp[0].v.string)))
				got_path_strip_trailing_slashes((yyvsp[0].v.string));

			n = strlcpy(gotwebd->repos_url_path, (yyvsp[0].v.string),
			    sizeof(gotwebd->repos_url_path));
			if (n >= sizeof(gotwebd->repos_url_path)) {
				yyerror("repos_url_path too long, exceeds "
				    "%zd bytes: %s",
				    sizeof(gotwebd->repos_url_path), (yyvsp[0].v.string));
				free((yyvsp[0].v.string));
				YYERROR;
			}

			if (gotwebd->repos_url_path[0] != '/') {
				yyerror("repos_url_path must be an absolute "
				    "path: bad path %s", (yyvsp[0].v.string));
				free((yyvsp[0].v.string));
				YYERROR;
			}

			free((yyvsp[0].v.string));
		}
#line 1974 "parse.c"
    break;

  case 36: /* main: GOTWEBD_CONTROL SOCKET STRING  */
#line 482 "parse.y"
                                                {
			struct address *h;
			h = get_unix_addr((yyvsp[0].v.string));
			if (h == NULL) {
				yyerror("can't listen on %s", (yyvsp[0].v.string));
				free((yyvsp[0].v.string));
				YYERROR;
			}
			if (gotwebd->control_sock != NULL)
				free(gotwebd->control_sock);
			gotwebd->control_sock = sockets_conf_new_socket(-1, h);
			free(h);
			free((yyvsp[0].v.string));
		}
#line 1993 "parse.c"
    break;

  case 37: /* server: SERVER STRING  */
#line 498 "parse.y"
                                {
			struct server *srv;

			TAILQ_FOREACH(srv, &gotwebd->servers, entry) {
				if (strcmp(srv->name, (yyvsp[0].v.string)) == 0) {
					yyerror("server name exists '%s'", (yyvsp[0].v.string));
					free((yyvsp[0].v.string));
					YYERROR;
				}
			}

			new_srv = conf_new_server((yyvsp[0].v.string));
			log_debug("adding server %s", (yyvsp[0].v.string));
			free((yyvsp[0].v.string));
		}
#line 2013 "parse.c"
    break;

  case 38: /* $@1: %empty  */
#line 513 "parse.y"
                                {
			struct server *srv;

			TAILQ_FOREACH(srv, &gotwebd->servers, entry) {
				if (strcmp(srv->name, (yyvsp[0].v.string)) == 0) {
					yyerror("server name exists '%s'", (yyvsp[0].v.string));
					free((yyvsp[0].v.string));
					YYERROR;
				}
			}

			new_srv = conf_new_server((yyvsp[0].v.string));
			log_debug("adding server %s", (yyvsp[0].v.string));
			free((yyvsp[0].v.string));
		}
#line 2033 "parse.c"
    break;

  case 39: /* server: SERVER STRING $@1 '{' optnl serveropts2 '}'  */
#line 527 "parse.y"
                                            {
		}
#line 2040 "parse.c"
    break;

  case 40: /* serveropts1: REPOS_PATH STRING  */
#line 531 "parse.y"
                                    {
			n = strlcpy(new_srv->repos_path, (yyvsp[0].v.string),
			    sizeof(new_srv->repos_path));
			if (n >= sizeof(new_srv->repos_path)) {
				yyerror("%s: repos_path truncated", __func__);
				free((yyvsp[0].v.string));
				YYERROR;
			}
			free((yyvsp[0].v.string));
		}
#line 2055 "parse.c"
    break;

  case 41: /* serveropts1: SITE_NAME STRING  */
#line 541 "parse.y"
                                   {
			n = strlcpy(new_srv->site_name, (yyvsp[0].v.string),
			    sizeof(new_srv->site_name));
			if (n >= sizeof(new_srv->site_name)) {
				yyerror("%s: site_name truncated", __func__);
				free((yyvsp[0].v.string));
				YYERROR;
			}
			free((yyvsp[0].v.string));
		}
#line 2070 "parse.c"
    break;

  case 42: /* serveropts1: SITE_OWNER STRING  */
#line 551 "parse.y"
                                    {
			n = strlcpy(new_srv->site_owner, (yyvsp[0].v.string),
			    sizeof(new_srv->site_owner));
			if (n >= sizeof(new_srv->site_owner)) {
				yyerror("%s: site_owner truncated", __func__);
				free((yyvsp[0].v.string));
				YYERROR;
			}
			free((yyvsp[0].v.string));
		}
#line 2085 "parse.c"
    break;

  case 43: /* serveropts1: SITE_LINK STRING  */
#line 561 "parse.y"
                                   {
			n = strlcpy(new_srv->site_link, (yyvsp[0].v.string),
			    sizeof(new_srv->site_link));
			if (n >= sizeof(new_srv->site_link)) {
				yyerror("%s: site_link truncated", __func__);
				free((yyvsp[0].v.string));
				YYERROR;
			}
			free((yyvsp[0].v.string));
		}
#line 2100 "parse.c"
    break;

  case 44: /* serveropts1: LOGO STRING  */
#line 571 "parse.y"
                              {
			n = strlcpy(new_srv->logo, (yyvsp[0].v.string), sizeof(new_srv->logo));
			if (n >= sizeof(new_srv->logo)) {
				yyerror("%s: logo truncated", __func__);
				free((yyvsp[0].v.string));
				YYERROR;
			}
			free((yyvsp[0].v.string));
		}
#line 2114 "parse.c"
    break;

  case 45: /* serveropts1: LOGO_URL STRING  */
#line 580 "parse.y"
                                  {
			n = strlcpy(new_srv->logo_url, (yyvsp[0].v.string),
			    sizeof(new_srv->logo_url));
			if (n >= sizeof(new_srv->logo_url)) {
				yyerror("%s: logo_url truncated", __func__);
				free((yyvsp[0].v.string));
				YYERROR;
			}
			free((yyvsp[0].v.string));
		}
#line 2129 "parse.c"
    break;

  case 46: /* serveropts1: CUSTOM_CSS STRING  */
#line 590 "parse.y"
                                    {
			n = strlcpy(new_srv->custom_css, (yyvsp[0].v.string),
			    sizeof(new_srv->custom_css));
			if (n >= sizeof(new_srv->custom_css)) {
				yyerror("%s: custom_css truncated", __func__);
				free((yyvsp[0].v.string));
				YYERROR;
			}
			free((yyvsp[0].v.string));
		}
#line 2144 "parse.c"
    break;

  case 47: /* serveropts1: SHOW_SITE_OWNER boolean  */
#line 600 "parse.y"
                                          {
			new_srv->show_site_owner = (yyvsp[0].v.number);
		}
#line 2152 "parse.c"
    break;

  case 48: /* serveropts1: SHOW_REPO_OWNER boolean  */
#line 603 "parse.y"
                                          {
			new_srv->show_repo_owner = (yyvsp[0].v.number);
		}
#line 2160 "parse.c"
    break;

  case 49: /* serveropts1: SHOW_REPO_AGE boolean  */
#line 606 "parse.y"
                                        {
			new_srv->show_repo_age = (yyvsp[0].v.number);
		}
#line 2168 "parse.c"
    break;

  case 50: /* serveropts1: SHOW_REPO_DESCRIPTION boolean  */
#line 609 "parse.y"
                                                {
			new_srv->show_repo_description = (yyvsp[0].v.number);
		}
#line 2176 "parse.c"
    break;

  case 51: /* serveropts1: SHOW_REPO_CLONEURL boolean  */
#line 612 "parse.y"
                                             {
			new_srv->show_repo_cloneurl = (yyvsp[0].v.number);
		}
#line 2184 "parse.c"
    break;

  case 52: /* serveropts1: RESPECT_EXPORTOK boolean  */
#line 615 "parse.y"
                                           {
			new_srv->respect_exportok = (yyvsp[0].v.number);
		}
#line 2192 "parse.c"
    break;

  case 53: /* serveropts1: HIDE REPOSITORIES boolean  */
#line 618 "parse.y"
                                            {
			new_srv->hide_repositories = (yyvsp[0].v.number);
		}
#line 2200 "parse.c"
    break;

  case 54: /* serveropts1: GOTWEBD_LOGIN HINT USER STRING  */
#line 621 "parse.y"
                                                 {
			n = strlcpy(new_srv->login_hint_user, (yyvsp[0].v.string),
			    sizeof(new_srv->login_hint_user));
			if (n >= sizeof(new_srv->login_hint_user)) {
				yyerror("login hint user name too long, "
				    "exceeds %zd bytes",
				    sizeof(new_srv->login_hint_user) - 1);
				free((yyvsp[0].v.string));
				YYERROR;
			}
			free((yyvsp[0].v.string));
		}
#line 2217 "parse.c"
    break;

  case 55: /* serveropts1: GOTWEBD_LOGIN HINT PORT NUMBER  */
#line 633 "parse.y"
                                                 {
			int n;

			if ((yyvsp[0].v.number) < 1 || (yyvsp[0].v.number) > USHRT_MAX) {
				fatalx("port number invalid: %lld",
				    (long long)(yyvsp[0].v.number));
			}

			n = snprintf(new_srv->login_hint_port,
			    sizeof(new_srv->login_hint_port), "%lld",
			    (long long)(yyvsp[0].v.number));
			if (n < 0) {
				fatal("snprintf: port number %lld:",
				    (long long)(yyvsp[0].v.number));
			}
			if ((size_t)n >= sizeof(new_srv->login_hint_port)) {
				fatalx("port number too long: %lld",
				    (long long)(yyvsp[0].v.number));
			}
		}
#line 2242 "parse.c"
    break;

  case 56: /* serveropts1: MAX_REPOS_DISPLAY NUMBER  */
#line 653 "parse.y"
                                           {
			if ((yyvsp[0].v.number) < 0) {
				yyerror("max_repos_display is too small: %lld",
				    (yyvsp[0].v.number));
				YYERROR;
			}
			new_srv->max_repos_display = (yyvsp[0].v.number);
		}
#line 2255 "parse.c"
    break;

  case 57: /* serveropts1: MAX_COMMITS_DISPLAY NUMBER  */
#line 661 "parse.y"
                                             {
			if ((yyvsp[0].v.number) <= 1) {
				yyerror("max_commits_display is too small:"
				    " %lld", (yyvsp[0].v.number));
				YYERROR;
			}
			new_srv->max_commits_display = (yyvsp[0].v.number);
		}
#line 2268 "parse.c"
    break;

  case 58: /* serveropts1: SUMMARY_COMMITS_DISPLAY NUMBER  */
#line 669 "parse.y"
                                                 {
			if ((yyvsp[0].v.number) < 1) {
				yyerror("summary_commits_display is too small:"
				    " %lld", (yyvsp[0].v.number));
				YYERROR;
			}
			new_srv->summary_commits_display = (yyvsp[0].v.number);
		}
#line 2281 "parse.c"
    break;

  case 59: /* serveropts1: SUMMARY_TAGS_DISPLAY NUMBER  */
#line 677 "parse.y"
                                              {
			if ((yyvsp[0].v.number) < 1) {
				yyerror("summary_tags_display is too small:"
				    " %lld", (yyvsp[0].v.number));
				YYERROR;
			}
			new_srv->summary_tags_display = (yyvsp[0].v.number);
		}
#line 2294 "parse.c"
    break;

  case 60: /* serveropts1: DISABLE AUTHENTICATION  */
#line 685 "parse.y"
                                         {
			if (new_srv->auth_config != 0) {
				yyerror("ambiguous authentication "
				    "setting for server %s",
				    new_srv->name);
				YYERROR;
			}
			new_srv->auth_config = GOTWEBD_AUTH_DISABLED;
		}
#line 2308 "parse.c"
    break;

  case 61: /* serveropts1: ENABLE AUTHENTICATION  */
#line 694 "parse.y"
                                        {
			if (new_srv->auth_config != 0) {
				yyerror("ambiguous authentication "
				    "setting for server %s",
				    new_srv->name);
				YYERROR;
			}
			new_srv->auth_config = GOTWEBD_AUTH_SECURE;
		}
#line 2322 "parse.c"
    break;

  case 62: /* serveropts1: ENABLE AUTHENTICATION INSECURE  */
#line 703 "parse.y"
                                                 {
			if (new_srv->auth_config != 0) {
				yyerror("ambiguous authentication "
				    "setting for server %s",
				    new_srv->name);
				YYERROR;
			}
			new_srv->auth_config = GOTWEBD_AUTH_INSECURE;
		}
#line 2336 "parse.c"
    break;

  case 63: /* serveropts1: PERMIT numberstring  */
#line 712 "parse.y"
                                      {
			conf_new_access_rule(&new_srv->access_rules,
			    GOTWEBD_ACCESS_PERMITTED, (yyvsp[0].v.string));
		}
#line 2345 "parse.c"
    break;

  case 64: /* serveropts1: DENY numberstring  */
#line 716 "parse.y"
                                    {
			conf_new_access_rule(&new_srv->access_rules,
			    GOTWEBD_ACCESS_DENIED, (yyvsp[0].v.string));
		}
#line 2354 "parse.c"
    break;

  case 65: /* serveropts1: HTDOCS STRING  */
#line 720 "parse.y"
                                {
			if (*(yyvsp[0].v.string) == '\0') {
				yyerror("htdocs path can't be an empty"
				    " string");
				free((yyvsp[0].v.string));
				YYERROR;
			}

			n = strlcpy(new_srv->htdocs_path, (yyvsp[0].v.string),
			    sizeof(new_srv->htdocs_path));
			if (n >= sizeof(new_srv->htdocs_path)) {
				yyerror("htdocs path too long: %s", (yyvsp[0].v.string));
				free((yyvsp[0].v.string));
				YYERROR;
			}
			free((yyvsp[0].v.string));
		}
#line 2376 "parse.c"
    break;

  case 66: /* serveropts1: GOTWEB_URL_ROOT STRING  */
#line 737 "parse.y"
                                         {
			if (*(yyvsp[0].v.string) == '\0') {
				yyerror("gotweb_url_root can't be an empty"
				    " string");
				free((yyvsp[0].v.string));
				YYERROR;
			}

			if (!got_path_is_root_dir((yyvsp[0].v.string)))
				got_path_strip_trailing_slashes((yyvsp[0].v.string));

			n = strlcpy(new_srv->gotweb_url_root, (yyvsp[0].v.string),
			    sizeof(new_srv->gotweb_url_root));
			if (n >= sizeof(new_srv->gotweb_url_root)) {
				yyerror("gotweb_url_root too long, exceeds "
				    "%zd bytes: %s",
				    sizeof(new_srv->gotweb_url_root), (yyvsp[0].v.string));
				free((yyvsp[0].v.string));
				YYERROR;
			}

			if (new_srv->gotweb_url_root[0] != '/') {
				yyerror("gotweb_url_root must be an absolute "
				    "path: bad path %s", (yyvsp[0].v.string));
				free((yyvsp[0].v.string));
				YYERROR;
			}

			free((yyvsp[0].v.string));
		}
#line 2411 "parse.c"
    break;

  case 67: /* serveropts1: REPOS_URL_PATH STRING  */
#line 767 "parse.y"
                                        {
			if (*(yyvsp[0].v.string) == '\0') {
				yyerror("repos_url_path can't be an empty"
				    " string");
				free((yyvsp[0].v.string));
				YYERROR;
			}

			if (!got_path_is_root_dir((yyvsp[0].v.string)))
				got_path_strip_trailing_slashes((yyvsp[0].v.string));

			n = strlcpy(new_srv->repos_url_path, (yyvsp[0].v.string),
			    sizeof(new_srv->repos_url_path));
			if (n >= sizeof(new_srv->repos_url_path)) {
				yyerror("repos_url_path too long, exceeds "
				    "%zd bytes: %s",
				    sizeof(new_srv->repos_url_path), (yyvsp[0].v.string));
				free((yyvsp[0].v.string));
				YYERROR;
			}

			if (new_srv->repos_url_path[0] != '/') {
				yyerror("repos_url_path must be an absolute "
				    "path: bad path %s", (yyvsp[0].v.string));
				free((yyvsp[0].v.string));
				YYERROR;
			}

			free((yyvsp[0].v.string));
		}
#line 2446 "parse.c"
    break;

  case 74: /* websiteopts1: REPOSITORY STRING  */
#line 808 "parse.y"
                                    {
			n = strlcpy(new_website->repo_name, (yyvsp[0].v.string),
			    sizeof(new_website->repo_name));
			if (n >= sizeof(new_website->repo_name)) {
				yyerror("website repository name too long, "
				    "exceeds %zd bytes",
				    sizeof(new_website->repo_name) - 1);
				free((yyvsp[0].v.string));
				YYERROR;
			}
			free((yyvsp[0].v.string));
		}
#line 2463 "parse.c"
    break;

  case 75: /* websiteopts1: PATH STRING  */
#line 820 "parse.y"
                              {
			n = strlcpy(new_website->path, (yyvsp[0].v.string),
			    sizeof(new_website->path));
			if (n >= sizeof(new_website->path)) {
				yyerror("website in-repository path too long, "
				    "exceeds %zd bytes",
				    sizeof(new_website->path) - 1);
				free((yyvsp[0].v.string));
				YYERROR;
			}

			if (new_website->path[0] != '/') {
				yyerror("a website path must be an absolute "
				    "path: bad path %s", (yyvsp[0].v.string));
				free((yyvsp[0].v.string));
				YYERROR;
			}

			free((yyvsp[0].v.string));
		}
#line 2488 "parse.c"
    break;

  case 76: /* websiteopts1: BRANCH STRING  */
#line 840 "parse.y"
                                {
			n = strlcpy(new_website->branch_name, (yyvsp[0].v.string),
			    sizeof(new_website->branch_name));
			if (n >= sizeof(new_website->branch_name)) {
				yyerror("website branch name too long, "
				    "exceeds %zd bytes",
				    sizeof(new_website->branch_name) - 1);
				free((yyvsp[0].v.string));
				YYERROR;
			}
			free((yyvsp[0].v.string));
		}
#line 2505 "parse.c"
    break;

  case 77: /* websiteopts1: DISABLE AUTHENTICATION  */
#line 852 "parse.y"
                                         {
			if (new_website->auth_config != 0) {
				yyerror("ambiguous authentication "
				    "setting for website %s",
				    new_website->path);
				YYERROR;
			}
			new_website->auth_config = GOTWEBD_AUTH_DISABLED;
		}
#line 2519 "parse.c"
    break;

  case 78: /* websiteopts1: ENABLE AUTHENTICATION  */
#line 861 "parse.y"
                                        {
			if (new_website->auth_config != 0) {
				yyerror("ambiguous authentication "
				    "setting for website %s",
				    new_website->path);
				YYERROR;
			}
			new_website->auth_config = GOTWEBD_AUTH_SECURE;
		}
#line 2533 "parse.c"
    break;

  case 79: /* websiteopts1: ENABLE AUTHENTICATION INSECURE  */
#line 870 "parse.y"
                                                 {
			if (new_website->auth_config != 0) {
				yyerror("ambiguous authentication "
				    "setting for website %s",
				    new_website->path);
				YYERROR;
			}
			new_website->auth_config = GOTWEBD_AUTH_INSECURE;
		}
#line 2547 "parse.c"
    break;

  case 80: /* websiteopts1: PERMIT numberstring  */
#line 879 "parse.y"
                                      {
			conf_new_access_rule(&new_website->access_rules,
			    GOTWEBD_ACCESS_PERMITTED, (yyvsp[0].v.string));
		}
#line 2556 "parse.c"
    break;

  case 81: /* websiteopts1: DENY numberstring  */
#line 883 "parse.y"
                                    {
			conf_new_access_rule(&new_website->access_rules,
			    GOTWEBD_ACCESS_DENIED, (yyvsp[0].v.string));
		}
#line 2565 "parse.c"
    break;

  case 82: /* $@2: %empty  */
#line 889 "parse.y"
                                 {
			new_website = conf_new_website(new_srv, (yyvsp[0].v.string));
			free((yyvsp[0].v.string));
		}
#line 2574 "parse.c"
    break;

  case 83: /* website: WEBSITE STRING $@2 '{' optnl websiteopts2 '}'  */
#line 892 "parse.y"
                                             {
		}
#line 2581 "parse.c"
    break;

  case 84: /* $@3: %empty  */
#line 896 "parse.y"
                                    {
			struct gotwebd_repo *repo;

			TAILQ_FOREACH(repo, &new_srv->repos, entry) {
				if (strcmp(repo->name, (yyvsp[0].v.string)) == 0) {
					yyerror("duplicate repository "
					    "'%s' in server '%s'", (yyvsp[0].v.string),
					    new_srv->name);
					free((yyvsp[0].v.string));
					YYERROR;
				}
			}

			new_repo = conf_new_repo(new_srv, (yyvsp[0].v.string));
			free((yyvsp[0].v.string));
		}
#line 2602 "parse.c"
    break;

  case 85: /* repository: REPOSITORY STRING $@3 '{' optnl repoopts2 '}'  */
#line 911 "parse.y"
                                          {
		}
#line 2609 "parse.c"
    break;

  case 88: /* repoopts1: DISABLE AUTHENTICATION  */
#line 919 "parse.y"
                                         {
			if (new_repo->auth_config != 0) {
				yyerror("ambiguous authentication "
				    "setting for repository %s",
				    new_repo->name);
				YYERROR;
			}
			new_repo->auth_config = GOTWEBD_AUTH_DISABLED;
		}
#line 2623 "parse.c"
    break;

  case 89: /* repoopts1: ENABLE AUTHENTICATION  */
#line 928 "parse.y"
                                        {
			if (new_repo->auth_config != 0) {
				yyerror("ambiguous authentication "
				    "setting for repository %s",
				    new_repo->name);
				YYERROR;
			}
			new_repo->auth_config = GOTWEBD_AUTH_SECURE;
		}
#line 2637 "parse.c"
    break;

  case 90: /* repoopts1: ENABLE AUTHENTICATION INSECURE  */
#line 937 "parse.y"
                                                 {
			if (new_repo->auth_config != 0) {
				yyerror("ambiguous authentication "
				    "setting for repository %s",
				    new_repo->name);
				YYERROR;
			}
			new_repo->auth_config = GOTWEBD_AUTH_INSECURE;
		}
#line 2651 "parse.c"
    break;

  case 91: /* repoopts1: PERMIT numberstring  */
#line 946 "parse.y"
                                      {
			conf_new_access_rule(&new_repo->access_rules,
			    GOTWEBD_ACCESS_PERMITTED, (yyvsp[0].v.string));
		}
#line 2660 "parse.c"
    break;

  case 92: /* repoopts1: DENY numberstring  */
#line 950 "parse.y"
                                    {
			conf_new_access_rule(&new_repo->access_rules,
			    GOTWEBD_ACCESS_DENIED, (yyvsp[0].v.string));
		}
#line 2669 "parse.c"
    break;

  case 93: /* repoopts1: HIDE REPOSITORY boolean  */
#line 954 "parse.y"
                                          {
			new_repo->hidden = (yyvsp[0].v.number);
		}
#line 2677 "parse.c"
    break;

  case 94: /* repoopts1: DESCRIPTION STRING  */
#line 957 "parse.y"
                                     {
			n = strlcpy(new_repo->description, (yyvsp[0].v.string),
			    sizeof(new_repo->description));
			if (n >= sizeof(new_repo->description)) {
				yyerror("repository description too long, "
				    "exceeds %zd bytes",
				    sizeof(new_repo->description) - 1);
				free((yyvsp[0].v.string));
				YYERROR;
			}
		}
#line 2693 "parse.c"
    break;

  case 100: /* mediastring: STRING '/' STRING  */
#line 981 "parse.y"
                                        {
			if (mediatype_ok((yyvsp[-2].v.string)) == -1 || mediatype_ok((yyvsp[0].v.string)) == -1) {
				yyerror("malformed media type: %s/%s", (yyvsp[-2].v.string), (yyvsp[0].v.string));
				free((yyvsp[-2].v.string));
				free((yyvsp[0].v.string));
				YYERROR;
			}

			if (strlcpy(media.media_type, (yyvsp[-2].v.string),
			    sizeof(media.media_type)) >=
			    sizeof(media.media_type) ||
			    strlcpy(media.media_subtype, (yyvsp[0].v.string),
			    sizeof(media.media_subtype)) >=
			    sizeof(media.media_subtype)) {
				yyerror("media type too long");
				free((yyvsp[-2].v.string));
				free((yyvsp[0].v.string));
				YYERROR;
			}
			free((yyvsp[-2].v.string));
			free((yyvsp[0].v.string));
		}
#line 2720 "parse.c"
    break;

  case 103: /* medianamesl: numberstring  */
#line 1009 "parse.y"
                                                        {
			if (mediatype_ok((yyvsp[0].v.string)) == -1) {
				yyerror("malformed media name");
				free((yyvsp[0].v.string));
				YYERROR;
			}

			if (strlcpy(media.media_name, (yyvsp[0].v.string),
			    sizeof(media.media_name)) >=
			    sizeof(media.media_name)) {
				yyerror("media name too long");
				free((yyvsp[0].v.string));
				YYERROR;
			}
			free((yyvsp[0].v.string));

			if (media_add(&gotwebd->mediatypes, &media) == NULL) {
				yyerror("failed to add media type");
				YYERROR;
			}
		}
#line 2746 "parse.c"
    break;


#line 2750 "parse.c"

      default: break;
    }
  /* User semantic actions sometimes alter yychar, and that requires
     that yytoken be updated with the new translation.  We take the
     approach of translating immediately before every use of yytoken.
     One alternative is translating here after every semantic action,
     but that translation would be missed if the semantic action invokes
     YYABORT, YYACCEPT, or YYERROR immediately after altering yychar or
     if it invokes YYBACKUP.  In the case of YYABORT or YYACCEPT, an
     incorrect destructor might then be invoked immediately.  In the
     case of YYERROR or YYBACKUP, subsequent parser actions might lead
     to an incorrect destructor call or verbose syntax error message
     before the lookahead is translated.  */
  YY_SYMBOL_PRINT ("-> $$ =", YY_CAST (yysymbol_kind_t, yyr1[yyn]), &yyval, &yyloc);

  YYPOPSTACK (yylen);
  yylen = 0;

  *++yyvsp = yyval;

  /* Now 'shift' the result of the reduction.  Determine what state
     that goes to, based on the state we popped back to and the rule
     number reduced by.  */
  {
    const int yylhs = yyr1[yyn] - YYNTOKENS;
    const int yyi = yypgoto[yylhs] + *yyssp;
    yystate = (0 <= yyi && yyi <= YYLAST && yycheck[yyi] == *yyssp
               ? yytable[yyi]
               : yydefgoto[yylhs]);
  }

  goto yynewstate;


/*--------------------------------------.
| yyerrlab -- here on detecting error.  |
`--------------------------------------*/
yyerrlab:
  /* Make sure we have latest lookahead translation.  See comments at
     user semantic actions for why this is necessary.  */
  yytoken = yychar == YYEMPTY ? YYSYMBOL_YYEMPTY : YYTRANSLATE (yychar);
  /* If not already recovering from an error, report this error.  */
  if (!yyerrstatus)
    {
      ++yynerrs;
      yyerror (YY_("syntax error"));
    }

  if (yyerrstatus == 3)
    {
      /* If just tried and failed to reuse lookahead token after an
         error, discard it.  */

      if (yychar <= YYEOF)
        {
          /* Return failure if at end of input.  */
          if (yychar == YYEOF)
            YYABORT;
        }
      else
        {
          yydestruct ("Error: discarding",
                      yytoken, &yylval);
          yychar = YYEMPTY;
        }
    }

  /* Else will try to reuse lookahead token after shifting the error
     token.  */
  goto yyerrlab1;


/*---------------------------------------------------.
| yyerrorlab -- error raised explicitly by YYERROR.  |
`---------------------------------------------------*/
yyerrorlab:
  /* Pacify compilers when the user code never invokes YYERROR and the
     label yyerrorlab therefore never appears in user code.  */
  if (0)
    YYERROR;
  ++yynerrs;

  /* Do not reclaim the symbols of the rule whose action triggered
     this YYERROR.  */
  YYPOPSTACK (yylen);
  yylen = 0;
  YY_STACK_PRINT (yyss, yyssp);
  yystate = *yyssp;
  goto yyerrlab1;


/*-------------------------------------------------------------.
| yyerrlab1 -- common code for both syntax error and YYERROR.  |
`-------------------------------------------------------------*/
yyerrlab1:
  yyerrstatus = 3;      /* Each real token shifted decrements this.  */

  /* Pop stack until we find a state that shifts the error token.  */
  for (;;)
    {
      yyn = yypact[yystate];
      if (!yypact_value_is_default (yyn))
        {
          yyn += YYSYMBOL_YYerror;
          if (0 <= yyn && yyn <= YYLAST && yycheck[yyn] == YYSYMBOL_YYerror)
            {
              yyn = yytable[yyn];
              if (0 < yyn)
                break;
            }
        }

      /* Pop the current state because it cannot handle the error token.  */
      if (yyssp == yyss)
        YYABORT;


      yydestruct ("Error: popping",
                  YY_ACCESSING_SYMBOL (yystate), yyvsp);
      YYPOPSTACK (1);
      yystate = *yyssp;
      YY_STACK_PRINT (yyss, yyssp);
    }

  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END


  /* Shift the error token.  */
  YY_SYMBOL_PRINT ("Shifting", YY_ACCESSING_SYMBOL (yyn), yyvsp, yylsp);

  yystate = yyn;
  goto yynewstate;


/*-------------------------------------.
| yyacceptlab -- YYACCEPT comes here.  |
`-------------------------------------*/
yyacceptlab:
  yyresult = 0;
  goto yyreturnlab;


/*-----------------------------------.
| yyabortlab -- YYABORT comes here.  |
`-----------------------------------*/
yyabortlab:
  yyresult = 1;
  goto yyreturnlab;


/*-----------------------------------------------------------.
| yyexhaustedlab -- YYNOMEM (memory exhaustion) comes here.  |
`-----------------------------------------------------------*/
yyexhaustedlab:
  yyerror (YY_("memory exhausted"));
  yyresult = 2;
  goto yyreturnlab;


/*----------------------------------------------------------.
| yyreturnlab -- parsing is finished, clean up and return.  |
`----------------------------------------------------------*/
yyreturnlab:
  if (yychar != YYEMPTY)
    {
      /* Make sure we have latest lookahead translation.  See comments at
         user semantic actions for why this is necessary.  */
      yytoken = YYTRANSLATE (yychar);
      yydestruct ("Cleanup: discarding lookahead",
                  yytoken, &yylval);
    }
  /* Do not reclaim the symbols of the rule whose action triggered
     this YYABORT or YYACCEPT.  */
  YYPOPSTACK (yylen);
  YY_STACK_PRINT (yyss, yyssp);
  while (yyssp != yyss)
    {
      yydestruct ("Cleanup: popping",
                  YY_ACCESSING_SYMBOL (+*yyssp), yyvsp);
      YYPOPSTACK (1);
    }
#ifndef yyoverflow
  if (yyss != yyssa)
    YYSTACK_FREE (yyss);
#endif

  return yyresult;
}

#line 1043 "parse.y"


struct keywords {
	const char	*k_name;
	int		 k_val;
};

int
yyerror(const char *fmt, ...)
{
	va_list ap;
	char *msg;

	file->errors++;
	va_start(ap, fmt);
	if (vasprintf(&msg, fmt, ap) == -1)
		fatalx("yyerror vasprintf");
	va_end(ap);
	logit(LOG_CRIT, "%s:%d: %s", file->name, yylval.lineno, msg);
	free(msg);
	return (0);
}

int
kw_cmp(const void *k, const void *e)
{
	return (strcmp(k, ((const struct keywords *)e)->k_name));
}

int
lookup(char *s)
{
	/* This has to be sorted always. */
	static const struct keywords keywords[] = {
		{ "authentication",		AUTHENTICATION },
		{ "branch",			BRANCH },
		{ "chroot",			CHROOT },
		{ "control",			GOTWEBD_CONTROL },
		{ "custom_css",			CUSTOM_CSS },
		{ "deny",			DENY },
		{ "description",		DESCRIPTION },
		{ "disable",			DISABLE },
		{ "enable",			ENABLE },
		{ "gotweb_url_root",		GOTWEB_URL_ROOT },
		{ "hide",			HIDE },
		{ "hint",			HINT },
		{ "htdocs",			HTDOCS },
		{ "include",			INCLUDE },
		{ "insecure",			INSECURE },
		{ "listen",			LISTEN },
		{ "login",			GOTWEBD_LOGIN },
		{ "logo",			LOGO },
		{ "logo_url",			LOGO_URL },
		{ "max_commits_display",	MAX_COMMITS_DISPLAY },
		{ "max_repos_display",		MAX_REPOS_DISPLAY },
		{ "on",				ON },
		{ "path",			PATH },
		{ "permit",			PERMIT },
		{ "port",			PORT },
		{ "prefork",			PREFORK },
		{ "repos_path",			REPOS_PATH },
		{ "repos_url_path",		REPOS_URL_PATH },
		{ "repositories",		REPOSITORIES },
		{ "repository",			REPOSITORY },
		{ "respect_exportok",		RESPECT_EXPORTOK },
		{ "server",			SERVER },
		{ "show_repo_age",		SHOW_REPO_AGE },
		{ "show_repo_cloneurl",		SHOW_REPO_CLONEURL },
		{ "show_repo_description",	SHOW_REPO_DESCRIPTION },
		{ "show_repo_owner",		SHOW_REPO_OWNER },
		{ "show_site_owner",		SHOW_SITE_OWNER },
		{ "site_link",			SITE_LINK },
		{ "site_name",			SITE_NAME },
		{ "site_owner",			SITE_OWNER },
		{ "socket",			SOCKET },
		{ "summary_commits_display",	SUMMARY_COMMITS_DISPLAY },
		{ "summary_tags_display",	SUMMARY_TAGS_DISPLAY },
		{ "types",			TYPES },
		{ "user",			USER },
		{ "website",			WEBSITE },
		{ "www",			WWW },
	};
	const struct keywords *p;

	p = bsearch(s, keywords, sizeof(keywords)/sizeof(keywords[0]),
	    sizeof(keywords[0]), kw_cmp);

	if (p)
		return (p->k_val);
	else
		return (STRING);
}

#define START_EXPAND	1
#define DONE_EXPAND	2

static int	expanding;

int
igetc(void)
{
	int	c;

	while (1) {
		if (file->ungetpos > 0)
			c = file->ungetbuf[--file->ungetpos];
		else
			c = getc(file->stream);

		if (c == START_EXPAND)
			expanding = 1;
		else if (c == DONE_EXPAND)
			expanding = 0;
		else
			break;
	}
	return c;
}

int
lgetc(int quotec)
{
	int c, next;

	if (quotec) {
		if ((c = igetc()) == EOF) {
			yyerror("reached end of file while parsing "
			    "quoted string");
			if (file == topfile || popfile() == EOF)
				return EOF;
			return quotec;
		}
		return c;
	}

	while ((c = igetc()) == '\\') {
		next = igetc();
		if (next != '\n') {
			c = next;
			break;
		}
		yylval.lineno = file->lineno;
		file->lineno++;
	}

	if (c == EOF) {
		/*
		 * Fake EOL when hit EOF for the first time. This gets line
		 * count right if last line in included file is syntactically
		 * invalid and has no newline.
		 */
		if (file->eof_reached == 0) {
			file->eof_reached = 1;
			return '\n';
		}
		while (c == EOF) {
			if (file == topfile || popfile() == EOF)
				return EOF;
			c = igetc();
		}
	}
	return (c);
}

void
lungetc(int c)
{
	if (c == EOF)
		return;
	if (file->ungetpos >= file->ungetsize) {
		void *p = reallocarray(file->ungetbuf, file->ungetsize, 2);
		if (p == NULL)
			fatal("reallocarray");
		file->ungetbuf = p;
		file->ungetsize *= 2;
	}
	file->ungetbuf[file->ungetpos++] = c;
}

int
findeol(void)
{
	int c;

	/* Skip to either EOF or the first real EOL. */
	while (1) {
		c = lgetc(0);
		if (c == '\n') {
			file->lineno++;
			break;
		}
		if (c == EOF)
			break;
	}
	return (ERROR);
}

int
yylex(void)
{
	unsigned char buf[8096];
	unsigned char *p, *val;
	int quotec, next, c;
	int token;

 top:
	p = buf;
	c = lgetc(0);
	while (c == ' ' || c == '\t')
		c = lgetc(0); /* nothing */

	yylval.lineno = file->lineno;
	if (c == '#') {
		c = lgetc(0);
		while (c != '\n' && c != EOF)
			c = lgetc(0); /* nothing */
	}
	if (c == '$' && !expanding) {
		while (1) {
			c = lgetc(0);
			if (c == EOF)
				return (0);

			if (p + 1 >= buf + sizeof(buf) - 1) {
				yyerror("string too long");
				return (findeol());
			}
			if (isalnum(c) || c == '_') {
				*p++ = c;
				continue;
			}
			*p = '\0';
			lungetc(c);
			break;
		}
		val = symget(buf);
		if (val == NULL) {
			yyerror("macro '%s' not defined", buf);
			return (findeol());
		}
		p = val + strlen(val) - 1;
		lungetc(DONE_EXPAND);
		while (p >= val) {
			lungetc((unsigned char)*p);
			p--;
		}
		lungetc(START_EXPAND);
		goto top;
	}

	switch (c) {
	case '\'':
	case '"':
		quotec = c;
		while (1) {
			c = lgetc(quotec);
			if (c == EOF)
				return (0);
			if (c == '\n') {
				file->lineno++;
				continue;
			} else if (c == '\\') {
				next = lgetc(quotec);
				if (next == EOF)
					return (0);
				if (next == quotec || c == ' ' || c == '\t')
					c = next;
				else if (next == '\n') {
					file->lineno++;
					continue;
				} else
					lungetc(next);
			} else if (c == quotec) {
				*p = '\0';
				break;
			} else if (c == '\0') {
				yyerror("syntax error");
				return (findeol());
			}
			if (p + 1 >= buf + sizeof(buf) - 1) {
				yyerror("string too long");
				return (findeol());
			}
			*p++ = c;
		}
		yylval.v.string = strdup(buf);
		if (yylval.v.string == NULL)
			err(1, "yylex: strdup");
		return (STRING);
	}

#define allowed_to_end_number(x) \
	(isspace(x) || x == ')' || x ==',' || x == '/' || x == '}' || x == '=')

	if (c == '-' || isdigit(c)) {
		do {
			*p++ = c;
			if ((unsigned)(p-buf) >= sizeof(buf)) {
				yyerror("string too long");
				return (findeol());
			}
			c = lgetc(0);
		} while (c != EOF && isdigit(c));
		lungetc(c);
		if (p == buf + 1 && buf[0] == '-')
			goto nodigits;
		if (c == EOF || allowed_to_end_number(c)) {
			const char *errstr = NULL;

			*p = '\0';
			yylval.v.number = strtonum(buf, LLONG_MIN,
			    LLONG_MAX, &errstr);
			if (errstr) {
				yyerror("\"%s\" invalid number: %s",
				    buf, errstr);
				return (findeol());
			}
			return (NUMBER);
		} else {
nodigits:
			while (p > buf + 1)
				lungetc(*--p);
			c = *--p;
			if (c == '-')
				return (c);
		}
	}

#define allowed_in_string(x) \
	(isalnum(x) || (ispunct(x) && x != '(' && x != ')' && \
	x != '{' && x != '}' && \
	x != '!' && x != '=' && x != '#' && \
	x != ',' && x != '/'))

	if (isalnum(c) || c == ':' || c == '_') {
		do {
			*p++ = c;
			if ((unsigned)(p-buf) >= sizeof(buf)) {
				yyerror("string too long");
				return (findeol());
			}
			c = lgetc(0);
		} while (c != EOF && (allowed_in_string(c)));
		lungetc(c);
		*p = '\0';
		token = lookup(buf);
		if (token == STRING) {
			yylval.v.string = strdup(buf);
			if (yylval.v.string == NULL)
				err(1, "yylex: strdup");
		}
		return (token);
	}
	if (c == '\n') {
		yylval.lineno = file->lineno;
		file->lineno++;
	}
	if (c == EOF)
		return (0);
	return (c);
}

int
check_file_secrecy(int fd, const char *fname)
{
	struct stat st;

	if (fstat(fd, &st)) {
		log_warn("cannot stat %s", fname);
		return (-1);
	}
	if (st.st_uid != 0 && st.st_uid != getuid()) {
		log_warnx("%s: owner not root or current user", fname);
		return (-1);
	}
	if (st.st_mode & (S_IWGRP | S_IXGRP | S_IRWXO)) {
		log_warnx("%s: group writable or world read/writable", fname);
		return (-1);
	}
	return (0);
}

struct file *
pushfile(const char *name, int secret)
{
	struct file *nfile;

	nfile = calloc(1, sizeof(struct file));
	if (nfile == NULL) {
		log_warn("calloc");
		return (NULL);
	}
	nfile->name = strdup(name);
	if (nfile->name == NULL) {
		log_warn("strdup");
		free(nfile);
		return (NULL);
	}
	nfile->stream = fopen(nfile->name, "r");
	if (nfile->stream == NULL) {
		/* no warning, we don't require a conf file */
		if (topfile != NULL)
			log_warn("can't open %s", nfile->name);
		free(nfile->name);
		free(nfile);
		return (NULL);
	} else if (secret &&
	    check_file_secrecy(fileno(nfile->stream), nfile->name)) {
		fclose(nfile->stream);
		free(nfile->name);
		free(nfile);
		return (NULL);
	}
	nfile->lineno = TAILQ_EMPTY(&files) ? 1 : 0;
	nfile->ungetsize = 16;
	nfile->ungetbuf = calloc(1, nfile->ungetsize);
	if (nfile->ungetbuf == NULL) {
		log_warn("calloc");
		fclose(nfile->stream);
		free(nfile->name);
		free(nfile);
		return (NULL);
	}
	TAILQ_INSERT_TAIL(&files, nfile, entry);
	return (nfile);
}

static int
popfile(void)
{
	struct file	*prev;

	if ((prev = TAILQ_PREV(file, files, entry)) != NULL)
		prev->errors += file->errors;

	TAILQ_REMOVE(&files, file, entry);
	fclose(file->stream);
	free(file->name);
	free(file->ungetbuf);
	free(file);
	file = prev;
	return file ? 0 : EOF;
}

static void
add_default_server(void)
{
	new_srv = conf_new_server(D_SITENAME);
	log_debug("%s: adding default server %s", __func__, D_SITENAME);
}

int
parse_config(const char *filename, struct gotwebd *env)
{
	struct sym *sym, *next;
	struct server *srv;
	struct gotwebd_repo *repo;

	if (config_init(env) == -1)
		fatalx("failed to initialize configuration");

	gotwebd = env;

	file = pushfile(filename, 0);
	if (file != NULL) {
		/* we don't require a config file */
		topfile = file;
		yyparse();
		errors = file->errors;
		while (popfile() != EOF)
			;
	}

	if (errors)
		return -1;

	/* Free macros and check which have not been used. */
	TAILQ_FOREACH_SAFE(sym, &symhead, entry, next) {
		if ((gotwebd->gotwebd_verbose > 1) && !sym->used)
			fprintf(stderr, "warning: macro '%s' not used\n",
			    sym->nam);
		if (!sym->persist) {
			free(sym->nam);
			free(sym->val);
			TAILQ_REMOVE(&symhead, sym, entry);
			free(sym);
		}
	}

	/* just add default server if no config specified */
	if (TAILQ_EMPTY(&gotwebd->servers))
		add_default_server();

	/* load default mimes */
	if (RB_EMPTY(&gotwebd->mediatypes)) {
		struct media_type defaults[] = {
			{
				.media_name = "css",
				.media_type = "text",
				.media_subtype = "css",
			},
			{
				.media_name = "gif",
				.media_type = "image",
				.media_subtype = "gif",
			},
			{
				.media_name = "html",
				.media_type = "text",
				.media_subtype = "html",
			},
			{
				.media_name = "ico",
				.media_type = "image",
				.media_subtype = "x-icon",
			},
			{
				.media_name = "png",
				.media_type = "image",
				.media_subtype = "png",
			},
			{
				.media_name = "jpeg",
				.media_type = "image",
				.media_subtype = "jpeg",
			},
			{
				.media_name = "jpg",
				.media_type = "image",
				.media_subtype = "jpeg",
			},
			{
				.media_name = "js",
				.media_type = "application",
				.media_subtype = "javascript",
			},
			{
				.media_name = "svg",
				.media_type = "image",
				.media_subtype = "svg+xml",
			},
			{
				.media_name = "txt",
				.media_type = "text",
				.media_subtype = "plain",
			},
			{
				.media_name = "webmanifest",
				.media_type = "application",
				.media_subtype = "manifest+json",
			},
			{
				.media_name = "xml",
				.media_type = "text",
				.media_subtype = "xml",
			},
		};
		size_t i;

		for (i = 0; i < nitems(defaults); ++i) {
			if (media_add(&gotwebd->mediatypes, &defaults[i]) == NULL) {
				fprintf(stderr, "failed to load default"
				    " MIME types\n");
				return -1;
			}
		}
	}

	/* add the implicit listen on socket */
	if (TAILQ_EMPTY(&gotwebd->addresses)) {
		char path[_POSIX_PATH_MAX];
		struct address *h;

		if (strlcpy(path, gotwebd->httpd_chroot, sizeof(path))
		    >= sizeof(path)) {
			fprintf(stderr, "chroot path too long: %s",
			    gotwebd->httpd_chroot);
			return -1;
		}
		if (strlcat(path, D_UNIX_SOCKET, sizeof(path))
		    >= sizeof(path)) {
			fprintf(stderr, "chroot path too long: %s",
			    gotwebd->httpd_chroot);
			return -1;
		}
		h = get_unix_addr(path);
		if (h == NULL) {
			fprintf(stderr, "can't listen on %s", path);
			return -1;
		} else
			add_addr(h);
	}


	/* setup our listening sockets */
	sockets_parse_sockets(env);

	/* Add implicit login socket */
	if (gotwebd->login_sock == NULL) {
		struct address *h;
		h = get_unix_addr(GOTWEBD_LOGIN_SOCKET);
		if (h == NULL) {
			fprintf(stderr, "cannot listen on %s",
			    GOTWEBD_LOGIN_SOCKET);
			return (-1);
		}
		gotwebd->login_sock = sockets_conf_new_socket(-1, h);
		free(h);
	}

	/* Add implicit control socket */
	if (gotwebd->control_sock == NULL) {
		struct address *h;
		h = get_unix_addr(GOTWEBD_CONTROL_SOCKET);
		if (h == NULL) {
			fprintf(stderr, "cannot listen on %s",
			    GOTWEBD_CONTROL_SOCKET);
			return (-1);
		}
		gotwebd->control_sock = sockets_conf_new_socket(-1, h);
		free(h);
	}

	/*
	 * Disable authentication if not explicitly configured.
	 * Authentication requires access rules to be configured, and we want
	 * gotwebd to work out of the box if no configuration file exists.
	 */
	switch (env->auth_config) {
	case GOTWEBD_AUTH_SECURE:
	case GOTWEBD_AUTH_INSECURE:
	case GOTWEBD_AUTH_DISABLED:
		break;
	default:
		env->auth_config = GOTWEBD_AUTH_DISABLED;
		break;
	}

	/* Inherit implicit configuration from parent scope. */
	TAILQ_FOREACH(srv, &env->servers, entry) {
		if (srv->auth_config == 0)
			srv->auth_config = env->auth_config;
		TAILQ_FOREACH(repo, &srv->repos, entry) {
			if (repo->auth_config == 0)
				repo->auth_config = srv->auth_config;
			if (repo->hidden == -1)
				repo->hidden = srv->hide_repositories;
		}

		if (srv->login_hint_user[0] == '\0') {
			if (strlcpy(srv->login_hint_user, env->login_hint_user,
			    sizeof(srv->login_hint_user)) >=
			    sizeof(srv->login_hint_user)) {
				fprintf(stderr, "login hint user name too "
				    "long, exceeds %zd bytes",
				    sizeof(srv->login_hint_user) - 1);
				return -1;
			}
		}

		if (srv->login_hint_port[0] == '\0') {
			if (strlcpy(srv->login_hint_port, env->login_hint_port,
			    sizeof(srv->login_hint_port)) >=
			    sizeof(srv->login_hint_port)) {
				fprintf(stderr, "login hint port number too "
				    "long, exceeds %zd bytes",
				    sizeof(srv->login_hint_port) - 1);
				return -1;
			}
		}

		if (srv->gotweb_url_root[0] == '\0') {
			if (strlcpy(srv->gotweb_url_root,
			    env->gotweb_url_root,
			    sizeof(srv->gotweb_url_root)) >=
			    sizeof(srv->gotweb_url_root)) {
				fprintf(stderr, "gotweb_url_root too long, "
				    "exceeds %zd bytes",
				    sizeof(srv->gotweb_url_root) - 1);
				return -1;
			}
		}

		if (srv->repos_url_path[0] == '\0') {
			if (strlcpy(srv->repos_url_path,
			    env->repos_url_path,
			    sizeof(srv->repos_url_path)) >=
			    sizeof(srv->repos_url_path)) {
				fprintf(stderr, "repos_url_path too long, "
				    "exceeds %zd bytes",
				    sizeof(srv->repos_url_path) - 1);
				return -1;
			}
		}
	}

	TAILQ_FOREACH(srv, &env->servers, entry) {
		const char *gotweb_url_root = srv->gotweb_url_root;
		const char *repos_url_path = srv->repos_url_path;
		struct got_pathlist_entry *pe;
		int ret;

		while (gotweb_url_root[0] == '/')
			gotweb_url_root++;

		while (repos_url_path[0] == '/')
			repos_url_path++;

		if (gotweb_url_root[0] == '\0' && repos_url_path[0] == '\0') {
			srv->full_repos_url_path[0] = '/';
			srv->full_repos_url_path[1] = '\0';
		} else {
			ret = snprintf(srv->full_repos_url_path,
			    sizeof(srv->full_repos_url_path),
			    "/%s%s%s", gotweb_url_root,
			    gotweb_url_root[0] ? "/" : "",
			    repos_url_path);
			if (ret == -1)
				fatal("snprintf");
			if ((size_t)ret >= sizeof(srv->full_repos_url_path)) {
				fprintf(stderr, "gotweb_url_root and "
				"repos_url_path too long, exceed %zd bytes",
				    sizeof(srv->full_repos_url_path) - 1);
				return -1;
			}
		}

		if (!got_path_is_root_dir(srv->full_repos_url_path)) {
			got_path_strip_trailing_slashes(
			    srv->full_repos_url_path);
		}

		RB_FOREACH(pe, got_pathlist_head, &srv->websites) {
			const char *url_path = pe->path;
			struct website *site = pe->data;

			if (site->auth_config == 0)
				site->auth_config = srv->auth_config;

			if (site->repo_name[0] == '\0') {
				fprintf(stderr, "no repository defined for "
				    "website %s' on server %s", url_path,
				    srv->name);
				return -1;
			}
		}
	}

	return (0);
}

struct server *
conf_new_server(const char *name)
{
	struct server *srv = NULL;

	srv = calloc(1, sizeof(*srv));
	if (srv == NULL)
		fatalx("%s: calloc", __func__);

	n = strlcpy(srv->name, name, sizeof(srv->name));
	if (n >= sizeof(srv->name))
		fatalx("%s: strlcpy", __func__);
	n = strlcpy(srv->repos_path, gotwebd->httpd_chroot,
	    sizeof(srv->repos_path));
	if (n >= sizeof(srv->repos_path))
		fatalx("%s: strlcpy", __func__);
	n = strlcat(srv->repos_path, D_GOTPATH,
	    sizeof(srv->repos_path));
	if (n >= sizeof(srv->repos_path))
		fatalx("%s: strlcat", __func__);
	n = strlcpy(srv->htdocs_path, D_HTDOCS_PATH,
	    sizeof(srv->htdocs_path));
	if (n >= sizeof(srv->htdocs_path))
		fatalx("%s: strlcpy", __func__);
	n = strlcpy(srv->site_name, D_SITENAME,
	    sizeof(srv->site_name));
	if (n >= sizeof(srv->site_name))
		fatalx("%s: strlcpy", __func__);
	n = strlcpy(srv->site_owner, D_SITEOWNER,
	    sizeof(srv->site_owner));
	if (n >= sizeof(srv->site_owner))
		fatalx("%s: strlcpy", __func__);
	n = strlcpy(srv->site_link, D_SITELINK,
	    sizeof(srv->site_link));
	if (n >= sizeof(srv->site_link))
		fatalx("%s: strlcpy", __func__);
	n = strlcpy(srv->logo, D_GOTLOGO,
	    sizeof(srv->logo));
	if (n >= sizeof(srv->logo))
		fatalx("%s: strlcpy", __func__);
	n = strlcpy(srv->logo_url, D_GOTURL, sizeof(srv->logo_url));
	if (n >= sizeof(srv->logo_url))
		fatalx("%s: strlcpy", __func__);
	n = strlcpy(srv->custom_css, D_GOTWEBCSS, sizeof(srv->custom_css));
	if (n >= sizeof(srv->custom_css))
		fatalx("%s: strlcpy", __func__);

	srv->show_site_owner = D_SHOWSOWNER;
	srv->show_repo_owner = D_SHOWROWNER;
	srv->show_repo_age = D_SHOWAGE;
	srv->show_repo_description = D_SHOWDESC;
	srv->show_repo_cloneurl = D_SHOWURL;
	srv->respect_exportok = D_RESPECTEXPORTOK;
	srv->hide_repositories = D_HIDE_REPOSITORIES;

	srv->max_repos_display = D_MAXREPODISP;
	srv->max_commits_display = D_MAXCOMMITDISP;
	srv->summary_commits_display = D_MAXSLCOMMDISP;
	srv->summary_tags_display = D_MAXSLTAGDISP;

	STAILQ_INIT(&srv->access_rules);
	TAILQ_INIT(&srv->repos);
	RB_INIT(&srv->websites);

	TAILQ_INSERT_TAIL(&gotwebd->servers, srv, entry);

	return srv;
};

int
symset(const char *nam, const char *val, int persist)
{
	struct sym *sym;

	TAILQ_FOREACH(sym, &symhead, entry) {
		if (strcmp(nam, sym->nam) == 0)
			break;
	}

	if (sym != NULL) {
		if (sym->persist == 1)
			return (0);
		else {
			free(sym->nam);
			free(sym->val);
			TAILQ_REMOVE(&symhead, sym, entry);
			free(sym);
		}
	}
	sym = calloc(1, sizeof(*sym));
	if (sym == NULL)
		return (-1);

	sym->nam = strdup(nam);
	if (sym->nam == NULL) {
		free(sym);
		return (-1);
	}
	sym->val = strdup(val);
	if (sym->val == NULL) {
		free(sym->nam);
		free(sym);
		return (-1);
	}
	sym->used = 0;
	sym->persist = persist;
	TAILQ_INSERT_TAIL(&symhead, sym, entry);
	return (0);
}

int
cmdline_symset(char *s)
{
	char *sym, *val;
	int ret;

	val = strrchr(s, '=');
	if (val == NULL)
		return (-1);

	sym = strndup(s, val - s);
	if (sym == NULL)
		fatal("%s: strndup", __func__);

	ret = symset(sym, val + 1, 1);
	free(sym);

	return (ret);
}

char *
symget(const char *nam)
{
	struct sym *sym;

	TAILQ_FOREACH(sym, &symhead, entry) {
		if (strcmp(nam, sym->nam) == 0) {
			sym->used = 1;
			return (sym->val);
		}
	}
	return (NULL);
}

int
get_addrs(const char *hostname, const char *servname)
{
	struct addrinfo hints, *res0, *res;
	int error;
	struct sockaddr_in *sin;
	struct sockaddr_in6 *sin6;
	struct address *h;

	memset(&hints, 0, sizeof(hints));
	hints.ai_family = AF_UNSPEC;
	hints.ai_socktype = SOCK_STREAM;
	hints.ai_flags = AI_PASSIVE | AI_ADDRCONFIG;
	error = getaddrinfo(hostname, servname, &hints, &res0);
	if (error) {
		log_warnx("%s: could not parse \"%s:%s\": %s", __func__,
		    hostname, servname, gai_strerror(error));
		return (-1);
	}

	for (res = res0; res; res = res->ai_next) {
		if ((h = calloc(1, sizeof(*h))) == NULL)
			fatal(__func__);

		if (hostname == NULL) {
			strlcpy(h->ifname, "*", sizeof(h->ifname));
		} else {
			if (strlcpy(h->ifname, hostname, sizeof(h->ifname)) >=
			    sizeof(h->ifname)) {
				log_warnx("%s: address truncated: %s",
				    __func__, hostname);
				freeaddrinfo(res0);
				free(h);
				return (-1);
			}
		}

		h->ai_family = res->ai_family;
		h->ai_socktype = res->ai_socktype;
		h->ai_protocol = res->ai_protocol;
		memcpy(&h->ss, res->ai_addr, res->ai_addrlen);
		h->slen = res->ai_addrlen;

		switch (res->ai_family) {
		case AF_INET:
			sin = (struct sockaddr_in *)res->ai_addr;
			h->port = ntohs(sin->sin_port);
			break;
		case AF_INET6:
			sin6 = (struct sockaddr_in6 *)res->ai_addr;
			h->port = ntohs(sin6->sin6_port);
			break;
		default:
			fatalx("unknown address family %d", res->ai_family);
		}

		add_addr(h);
	}
	freeaddrinfo(res0);
	return (0);
}

struct address *
get_unix_addr(const char *path)
{
	struct address *h;
	struct sockaddr_un *sun;

	if ((h = calloc(1, sizeof(*h))) == NULL)
		fatal("%s: calloc", __func__);

	h->ai_family = AF_UNIX;
	h->ai_socktype = SOCK_STREAM;
	h->ai_protocol = PF_UNSPEC;
	h->slen = sizeof(*sun);

	sun = (struct sockaddr_un *)&h->ss;
	sun->sun_family = AF_UNIX;
	if (strlcpy(sun->sun_path, path, sizeof(sun->sun_path)) >=
	    sizeof(sun->sun_path)) {
		log_warnx("socket path too long: %s", sun->sun_path);
		return NULL;
	}

	return h;
}

int
addr_dup_check(struct addresslist *al, struct address *h)
{
	struct address *a;

	TAILQ_FOREACH(a, al, entry) {
		if (a->ai_family != h->ai_family ||
		    a->ai_socktype != h->ai_socktype ||
		    a->ai_protocol != h->ai_protocol ||
		    a->slen != h->slen ||
		    memcmp(&a->ss, &h->ss, a->slen) != 0)
			continue;
		return -1;
	}

	return 0;
}

void
add_addr(struct address *h)
{
	if (addr_dup_check(&gotwebd->addresses, h) == 0) {
		TAILQ_INSERT_TAIL(&gotwebd->addresses, h, entry);
		return;
	}

	free(h);
}

static struct website *
conf_new_website(struct server *server, const char *url_path)
{
	const struct got_error *error;
	struct website *site;
	struct got_pathlist_entry *new;

	if (url_path[0] == '\0') {
		fatalx("syntax error: empty URL path found in %s",
		    file->name);
	}

	if (strchr(url_path, '\n') != NULL)
		fatalx("URL path must not contain linefeeds: %s", url_path);
	
	site = calloc(1, sizeof(*site));
	if (site == NULL)
		fatal("calloc");

	STAILQ_INIT(&site->access_rules);

	if (!got_path_is_absolute(url_path)) {
		int ret;

		ret = snprintf(site->url_path, sizeof(site->url_path),
		    "/%s", url_path);
		if (ret == -1)
			fatal("snprintf");
		if ((size_t)ret >= sizeof(site->url_path)) {
			fatalx("URL path too long (exceeds %zd bytes): %s",
			    sizeof(site->url_path) - 1, url_path);
		}
	} else {
		if (strlcpy(site->url_path, url_path,
		    sizeof(site->url_path)) >=
		    sizeof(site->url_path)) {
			fatalx("URL path too long (exceeds %zd bytes): %s",
			    sizeof(site->url_path) - 1, url_path);
		}
	}

	error = got_pathlist_insert(&new, &server->websites,
	    site->url_path, site);
	if (error)
		fatalx("%s: %s", __func__, error->msg);
	if (new == NULL) {
		fatalx("duplicate web site '%s' in server '%s'",
		    url_path, server->name);
	}

	return site;
}

struct gotwebd_repo *
gotwebd_new_repo(const char *name)
{
	struct gotwebd_repo *repo;

	repo = calloc(1, sizeof(*repo));
	if (repo == NULL)
		return NULL;

	STAILQ_INIT(&repo->access_rules);

	if (strlcpy(repo->name, name, sizeof(repo->name)) >=
	    sizeof(repo->name)) {
		free(repo);
		errno = ENOSPC;
		return NULL;
	}

	return repo;
}

static struct gotwebd_repo *
conf_new_repo(struct server *server, const char *name)
{
	struct gotwebd_repo *repo;

	if (name[0] == '\0') {
		fatalx("syntax error: empty repository name found in %s",
		    file->name);
	}

	if (strchr(name, '/') != NULL)
		fatalx("repository names must not contain slashes: %s", name);

	if (strchr(name, '\n') != NULL)
		fatalx("repository names must not contain linefeeds: %s", name);

	repo = gotwebd_new_repo(name);
	if (repo == NULL)
		fatal("gotwebd_new_repo");

	repo->hidden = -1;
	TAILQ_INSERT_TAIL(&server->repos, repo, entry);

	return repo;
};

static void
conf_new_access_rule(struct gotwebd_access_rule_list *rules,
    enum gotwebd_access access, char *identifier)
{
	struct gotwebd_access_rule *rule;

	rule = calloc(1, sizeof(*rule));
	if (rule == NULL)
		fatal("calloc");

	rule->access = access;
	if (strlcpy(rule->identifier, identifier,
	    sizeof(rule->identifier)) >= sizeof(rule->identifier))
		fatalx("identifier too long (max %zu bytes): %s",
		    sizeof(rule->identifier) - 1, identifier);

	STAILQ_INSERT_TAIL(rules, rule, entry);
}
