/*
 * Decompiled with CFR 0.152.
 */
package org.kordamp.jarviz.reporting;

import org.kordamp.jarviz.reporting.Node;
import org.kordamp.jarviz.reporting.Report;

public abstract class Formatter {
    protected static final String INDENT = "  ";
    protected static final String SPACE = " ";
    protected static final String EMPTY = "";

    public String write(Node node) {
        Report report = new Report();
        this.append(report, node);
        return report.toString();
    }

    protected abstract void append(Report var1, Node var2);

    protected int indentAdjustment() {
        return 0;
    }

    protected int indentationFor(Node node) {
        return this.indentationFor(node, 0);
    }

    protected int indentationFor(Node node, int offset) {
        return Math.max(0, node.getIndentation() - this.indentAdjustment() + offset);
    }

    protected String formatValue(Node node) {
        String value = node.getValue();
        if (!value.contains(System.lineSeparator())) {
            return this.formatValue(value);
        }
        String indentation = INDENT.repeat(this.indentationFor(node, 1));
        StringBuilder b = new StringBuilder(System.lineSeparator());
        for (String line : value.split(System.lineSeparator())) {
            b.append(indentation).append(this.formatValue(line)).append(System.lineSeparator());
        }
        return b.toString();
    }

    protected String formatValue(String value) {
        return value.trim();
    }
}

