/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.extensions.internal.mustache;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.EnumSet;
import java.util.Locale;
import java.util.function.Function;
import java.util.function.ToLongFunction;
import java.util.function.UnaryOperator;
import org.apache.commons.text.StringEscapeUtils;
import org.commonmark.node.Node;
import org.commonmark.parser.Parser;
import org.commonmark.renderer.html.HtmlRenderer;
import org.commonmark.renderer.text.TextContentRenderer;
import org.jreleaser.bundle.RB;
import org.jreleaser.extensions.api.mustache.MustacheExtensionPoint;
import org.jreleaser.mustache.MustacheUtils;
import org.jreleaser.mustache.TemplateContext;
import org.jreleaser.util.Algorithm;
import org.jreleaser.util.ChecksumUtils;
import org.jreleaser.util.MarkdownUtils;
import org.jreleaser.util.StringUtils;

public final class DefaultMustacheExtensionPoint
implements MustacheExtensionPoint {
    public void apply(TemplateContext context) {
        ZonedDateTime now = (ZonedDateTime)context.get("__ZonedDateTime_now__");
        if (null == now) {
            now = ZonedDateTime.now();
        }
        context.set("f_now", (Object)new TimeFormatFunction(now));
        context.set("f_now_gmt", (Object)new TimeFormatFunction(now.withZoneSameInstant(ZoneId.of("GMT"))));
        context.set("f_trim", (Object)new TrimFunction());
        context.set("f_underscore", (Object)new UnderscoreFunction());
        context.set("f_dash", (Object)new DashFunction());
        context.set("f_slash", (Object)new SlashFunction());
        context.set("f_upper", (Object)new UpperFunction());
        context.set("f_lower", (Object)new LowerFunction());
        context.set("f_capitalize", (Object)new CapitalizeFunction());
        context.set("f_uncapitalize", (Object)new UncapitalizeFunction());
        context.set("f_md2html", (Object)new MarkdownToHtmlFunction());
        context.set("f_file_exists", (Object)new FileExistsFunction());
        context.set("f_file_read", (Object)new FileReadFunction());
        context.set("f_file_size", (Object)new FileSizeFunction());
        EnumSet.allOf(Algorithm.class).forEach(algorithm -> context.set("f_checksum_" + algorithm.formatted(), (Object)new FileChecksumFunction((Algorithm)algorithm)));
        context.set("f_json", (Object)new JsonFunction());
        context.set("f_escape_csv", (Object)new DelegatingFunction(StringEscapeUtils::escapeCsv));
        context.set("f_escape_ecma_script", (Object)new DelegatingFunction(StringEscapeUtils::escapeEcmaScript));
        context.set("f_escape_html3", (Object)new DelegatingFunction(StringEscapeUtils::escapeHtml3));
        context.set("f_escape_html4", (Object)new DelegatingFunction(StringEscapeUtils::escapeHtml4));
        context.set("f_escape_java", (Object)new DelegatingFunction(StringEscapeUtils::escapeJava));
        context.set("f_escape_json", (Object)new DelegatingFunction(StringEscapeUtils::escapeJson));
        context.set("f_escape_xml10", (Object)new DelegatingFunction(StringEscapeUtils::escapeXml10));
        context.set("f_escape_xml11", (Object)new DelegatingFunction(StringEscapeUtils::escapeXml11));
        context.set("f_escape_xsi", (Object)new DelegatingFunction(StringEscapeUtils::escapeXSI));
        context.set("f_chop", (Object)new DelegatingFunction(org.apache.commons.lang3.StringUtils::chop));
        context.set("f_chomp", (Object)new DelegatingFunction(org.apache.commons.lang3.StringUtils::chomp));
        context.set("f_delete_whitespace", (Object)new DelegatingFunction(org.apache.commons.lang3.StringUtils::deleteWhitespace));
        context.set("f_normalize_whitespace", (Object)new DelegatingFunction(org.apache.commons.lang3.StringUtils::normalizeSpace));
        context.set("f_reverse", (Object)new DelegatingFunction(org.apache.commons.lang3.StringUtils::reverse));
        context.set("f_strip", (Object)new DelegatingFunction(org.apache.commons.lang3.StringUtils::strip));
        context.set("f_swapcase", (Object)new DelegatingFunction(org.apache.commons.lang3.StringUtils::swapCase));
        context.set("f_recursive_eval", (Object)new RecursiveEvalFunction(context));
    }

    private static class TimeFormatFunction
    implements UnaryOperator<String> {
        private final ZonedDateTime now;

        private TimeFormatFunction(ZonedDateTime now) {
            this.now = now;
        }

        @Override
        public String apply(String input) {
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern(input);
            return this.now.format(formatter);
        }
    }

    private static class TrimFunction
    implements UnaryOperator<String> {
        private TrimFunction() {
        }

        @Override
        public String apply(String input) {
            return input.trim();
        }
    }

    private static class UnderscoreFunction
    implements UnaryOperator<String> {
        private UnderscoreFunction() {
        }

        @Override
        public String apply(String input) {
            return input.replace(".", "_").replace("-", "_").replace("+", "_");
        }
    }

    private static class DashFunction
    implements UnaryOperator<String> {
        private DashFunction() {
        }

        @Override
        public String apply(String input) {
            return input.replace(".", "-").replace("_", "-").replace("+", "-");
        }
    }

    private static class SlashFunction
    implements UnaryOperator<String> {
        private SlashFunction() {
        }

        @Override
        public String apply(String input) {
            return input.replace(".", "/").replace("-", "/").replace("+", "/");
        }
    }

    private static class UpperFunction
    implements UnaryOperator<String> {
        private UpperFunction() {
        }

        @Override
        public String apply(String input) {
            return input.toUpperCase(Locale.ENGLISH);
        }
    }

    private static class LowerFunction
    implements UnaryOperator<String> {
        private LowerFunction() {
        }

        @Override
        public String apply(String input) {
            return input.toLowerCase(Locale.ENGLISH);
        }
    }

    private static class CapitalizeFunction
    implements UnaryOperator<String> {
        private CapitalizeFunction() {
        }

        @Override
        public String apply(String input) {
            return StringUtils.capitalize((String)input);
        }
    }

    private static class UncapitalizeFunction
    implements UnaryOperator<String> {
        private UncapitalizeFunction() {
        }

        @Override
        public String apply(String input) {
            return StringUtils.uncapitalize((String)input);
        }
    }

    private static class MarkdownToHtmlFunction
    implements UnaryOperator<String> {
        private MarkdownToHtmlFunction() {
        }

        @Override
        public String apply(String input) {
            Parser parser = MarkdownUtils.createMarkdownParser();
            TextContentRenderer markdown = MarkdownUtils.createTextContentRenderer();
            String normalizedInput = markdown.render(parser.parse(input));
            Node document = parser.parse(normalizedInput);
            HtmlRenderer renderer = HtmlRenderer.builder().build();
            return renderer.render(document).trim();
        }
    }

    private static class FileExistsFunction
    implements Function<Object, Boolean> {
        private FileExistsFunction() {
        }

        @Override
        public Boolean apply(Object input) {
            if (input instanceof Path) {
                return Files.exists((Path)input, new LinkOption[0]);
            }
            if (input instanceof File) {
                return Files.exists(((File)input).toPath(), new LinkOption[0]);
            }
            if (input instanceof CharSequence) {
                return Files.exists(Paths.get(String.valueOf(input).trim(), new String[0]), new LinkOption[0]);
            }
            throw new IllegalStateException(RB.$((String)"ERROR_invalid_file_input", (Object[])new Object[]{input}));
        }
    }

    private static class FileReadFunction
    implements Function<Object, String> {
        private FileReadFunction() {
        }

        @Override
        public String apply(Object input) {
            try {
                if (input instanceof Path) {
                    return new String(Files.readAllBytes((Path)input), StandardCharsets.UTF_8);
                }
                if (input instanceof File) {
                    return new String(Files.readAllBytes(((File)input).toPath()), StandardCharsets.UTF_8);
                }
                if (input instanceof CharSequence) {
                    return new String(Files.readAllBytes(Paths.get(String.valueOf(input).trim(), new String[0])), StandardCharsets.UTF_8);
                }
            }
            catch (IOException e) {
                throw new IllegalStateException(RB.$((String)"ERROR_unexpected_file_read", (Object[])new Object[]{input}), e);
            }
            throw new IllegalStateException(RB.$((String)"ERROR_invalid_file_input", (Object[])new Object[]{input}));
        }
    }

    private static class FileSizeFunction
    implements ToLongFunction<Object> {
        private FileSizeFunction() {
        }

        @Override
        public long applyAsLong(Object input) {
            try {
                if (input instanceof Path) {
                    return Files.size((Path)input);
                }
                if (input instanceof File) {
                    return Files.size(((File)input).toPath());
                }
                if (input instanceof CharSequence) {
                    return Files.size(Paths.get(String.valueOf(input).trim(), new String[0]));
                }
            }
            catch (IOException e) {
                throw new IllegalStateException(RB.$((String)"ERROR_unexpected_file_read", (Object[])new Object[]{input}), e);
            }
            throw new IllegalStateException(RB.$((String)"ERROR_invalid_file_input", (Object[])new Object[]{input}));
        }
    }

    private static class JsonFunction
    implements Function<Object, String> {
        private JsonFunction() {
        }

        @Override
        public String apply(Object input) {
            try {
                ObjectMapper objectMapper = new ObjectMapper();
                return objectMapper.writeValueAsString(input);
            }
            catch (JsonProcessingException e) {
                throw new IllegalStateException(RB.$((String)"ERROR_invalid_json_input", (Object[])new Object[]{input}));
            }
        }
    }

    private static class DelegatingFunction
    implements UnaryOperator<String> {
        private final UnaryOperator<String> delegate;

        private DelegatingFunction(UnaryOperator<String> delegate) {
            this.delegate = delegate;
        }

        @Override
        public String apply(String input) {
            return (String)this.delegate.apply(input);
        }
    }

    private static class RecursiveEvalFunction
    implements UnaryOperator<String> {
        private final TemplateContext context;

        public RecursiveEvalFunction(TemplateContext context) {
            this.context = context;
        }

        @Override
        public String apply(String input) {
            return MustacheUtils.applyTemplate((String)input, (TemplateContext)this.context);
        }
    }

    private static class FileChecksumFunction
    implements Function<Object, String> {
        private final Algorithm algorithm;

        public FileChecksumFunction(Algorithm algorithm) {
            this.algorithm = algorithm;
        }

        @Override
        public String apply(Object input) {
            try {
                if (input instanceof Path) {
                    return ChecksumUtils.checksum((Algorithm)this.algorithm, (byte[])Files.readAllBytes((Path)input));
                }
                if (input instanceof File) {
                    return ChecksumUtils.checksum((Algorithm)this.algorithm, (byte[])Files.readAllBytes(((File)input).toPath()));
                }
                if (input instanceof CharSequence) {
                    return ChecksumUtils.checksum((Algorithm)this.algorithm, (byte[])Files.readAllBytes(Paths.get(String.valueOf(input).trim(), new String[0])));
                }
            }
            catch (IOException e) {
                throw new IllegalStateException(RB.$((String)"ERROR_unexpected_file_read", (Object[])new Object[]{input}), e);
            }
            throw new IllegalStateException(RB.$((String)"ERROR_invalid_file_input", (Object[])new Object[]{input}));
        }
    }
}

