/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.packagers;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jreleaser.model.internal.common.Icon;
import org.jreleaser.model.internal.common.Screenshot;
import org.jreleaser.model.internal.packagers.AbstractRepositoryPackager;
import org.jreleaser.model.internal.packagers.RepositoryPackager;

public abstract class AbstractAppdataPackager<A extends org.jreleaser.model.api.packagers.RepositoryPackager, S extends AbstractAppdataPackager<A, S>>
extends AbstractRepositoryPackager<A, S>
implements RepositoryPackager<A> {
    private static final long serialVersionUID = -7192006991401574870L;
    private final List<Screenshot> screenshots = new ArrayList<Screenshot>();
    private final List<String> categories = new ArrayList<String>();
    private final List<Icon> icons = new ArrayList<Icon>();
    private final Set<String> skipReleases = new LinkedHashSet<String>();
    private String componentId;
    private String developerId;
    private String developerName;

    protected AbstractAppdataPackager(String type) {
        super(type);
    }

    @Override
    public void merge(S source) {
        super.merge(source);
        this.componentId = this.merge(this.componentId, ((AbstractAppdataPackager)source).getComponentId());
        this.developerId = this.merge(this.developerId, ((AbstractAppdataPackager)source).getDeveloperId());
        this.developerName = this.merge(this.developerName, ((AbstractAppdataPackager)source).getDeveloperName());
        this.setCategories(this.merge(this.categories, ((AbstractAppdataPackager)source).getCategories()));
        this.setScreenshots(this.merge(this.screenshots, ((AbstractAppdataPackager)source).getScreenshots()));
        this.setIcons(this.merge(this.icons, ((AbstractAppdataPackager)source).getIcons()));
        this.setSkipReleases(this.merge(this.skipReleases, ((AbstractAppdataPackager)source).getSkipReleases()));
    }

    public String getComponentId() {
        return this.componentId;
    }

    public void setComponentId(String componentId) {
        this.componentId = componentId;
    }

    public List<String> getCategories() {
        return this.categories;
    }

    public void setCategories(List<String> tags) {
        this.categories.clear();
        this.categories.addAll(tags);
    }

    public String getDeveloperId() {
        return this.developerId;
    }

    public void setDeveloperId(String developerId) {
        this.developerId = developerId;
    }

    public String getDeveloperName() {
        return this.developerName;
    }

    public void setDeveloperName(String developerName) {
        this.developerName = developerName;
    }

    public List<Screenshot> getScreenshots() {
        return this.screenshots;
    }

    public void setScreenshots(List<Screenshot> screenshots) {
        this.screenshots.clear();
        this.screenshots.addAll(screenshots);
    }

    public void addScreenshot(Screenshot screenshot) {
        if (null != screenshot) {
            this.screenshots.add(screenshot);
        }
    }

    public List<Icon> getIcons() {
        return this.icons;
    }

    public void setIcons(List<Icon> icons) {
        this.icons.clear();
        this.icons.addAll(icons);
    }

    public void addIcon(Icon icon) {
        if (null != icon) {
            this.icons.add(icon);
        }
    }

    public Set<String> getSkipReleases() {
        return this.skipReleases;
    }

    public void setSkipReleases(Set<String> tags) {
        this.skipReleases.clear();
        this.skipReleases.addAll(tags);
    }

    @Override
    protected void asMap(boolean full, Map<String, Object> props) {
        super.asMap(full, props);
        props.put("componentId", this.componentId);
        props.put("categories", this.categories);
        props.put("developerId", this.developerId);
        props.put("developerName", this.developerName);
        LinkedHashMap<String, Map<String, Object>> sm = new LinkedHashMap<String, Map<String, Object>>();
        int i = 0;
        for (Screenshot screenshot : this.screenshots) {
            sm.put("screenshot " + i++, screenshot.asMap(full));
        }
        props.put("screenshots", sm);
        sm = new LinkedHashMap();
        i = 0;
        for (Icon icon : this.icons) {
            sm.put("icon " + i++, icon.asMap(full));
        }
        props.put("icons", sm);
        props.put("skipReleases", this.skipReleases);
    }
}

