/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.validation.packagers;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.JReleaserModel;
import org.jreleaser.model.internal.common.Activatable;
import org.jreleaser.model.internal.common.Artifact;
import org.jreleaser.model.internal.distributions.Distribution;
import org.jreleaser.model.internal.packagers.ChocolateyPackager;
import org.jreleaser.model.internal.project.Project;
import org.jreleaser.model.internal.release.BaseReleaser;
import org.jreleaser.model.internal.validation.common.ExtraPropertiesValidator;
import org.jreleaser.model.internal.validation.common.TemplateValidator;
import org.jreleaser.model.internal.validation.common.Validator;
import org.jreleaser.model.internal.validation.distributions.DistributionsValidator;
import org.jreleaser.mustache.TemplateContext;
import org.jreleaser.mustache.Templates;
import org.jreleaser.util.CollectionUtils;
import org.jreleaser.util.Errors;
import org.jreleaser.util.StringUtils;
import org.jreleaser.version.ChronVer;
import org.jreleaser.version.JavaModuleVersion;
import org.jreleaser.version.JavaRuntimeVersion;
import org.jreleaser.version.SemanticVersion;

public final class ChocolateyPackagerValidator {
    private ChocolateyPackagerValidator() {
    }

    public static void validateChocolatey(JReleaserContext context, Distribution distribution, ChocolateyPackager packager, Errors errors) {
        context.getLogger().debug("distribution.{}." + packager.getType(), new Object[]{distribution.getName()});
        JReleaserModel model = context.getModel();
        ChocolateyPackager parentPackager = model.getPackagers().getChocolatey();
        Validator.resolveActivatable(context, (Activatable)packager, "distributions." + distribution.getName() + "." + packager.getType(), parentPackager);
        Project project = context.getModel().getProject();
        if (!packager.resolveEnabled(project, distribution)) {
            context.getLogger().debug(RB.$((String)"validation.disabled", (Object[])new Object[0]));
            return;
        }
        BaseReleaser<?, ?> service = model.getRelease().getReleaser();
        if (!service.isReleaseSupported()) {
            context.getLogger().debug(RB.$((String)"validation.disabled.release", (Object[])new Object[0]));
            packager.disable();
            return;
        }
        List<Artifact> candidateArtifacts = packager.resolveCandidateArtifacts(context, distribution);
        if (candidateArtifacts.isEmpty()) {
            context.getLogger().debug(RB.$((String)"validation.disabled.no.artifacts", (Object[])new Object[0]));
            errors.warning(RB.$((String)"WARNING.validation.packager.no.artifacts", (Object[])new Object[]{distribution.getName(), packager.getType(), packager.getSupportedFileExtensions(distribution.getType())}));
            packager.disable();
            return;
        }
        if (candidateArtifacts.size() > 1) {
            errors.configuration(RB.$((String)"validation_packager_multiple_artifacts", (Object[])new Object[]{"distribution." + distribution.getName() + ".chocolatey"}));
            context.getLogger().debug(RB.$((String)"validation.disabled.multiple.artifacts", (Object[])new Object[0]));
            errors.warning(RB.$((String)"WARNING.validation.packager.multiple.artifacts", (Object[])new Object[]{distribution.getName(), packager.getType(), candidateArtifacts.stream().map(Artifact::getPath).collect(Collectors.toList())}));
            packager.disable();
            return;
        }
        Validator.validateCommitAuthor(packager, parentPackager);
        ChocolateyPackager.ChocolateyRepository bucket = packager.getRepository();
        Validator.validateRepository(context, distribution, bucket, parentPackager.getRepository(), "chocolatey.repository");
        TemplateValidator.validateTemplate(context, distribution, packager, parentPackager, errors);
        ExtraPropertiesValidator.mergeExtraProperties(packager, parentPackager);
        Validator.validateContinueOnError(packager, parentPackager);
        if (StringUtils.isBlank((String)packager.getDownloadUrl())) {
            packager.setDownloadUrl(parentPackager.getDownloadUrl());
        }
        if (StringUtils.isBlank((String)packager.getPackageName())) {
            packager.setPackageName(parentPackager.getPackageName());
            if (StringUtils.isBlank((String)packager.getPackageName())) {
                packager.setPackageName(distribution.getName());
            }
        }
        if (StringUtils.isBlank((String)packager.getPackageVersion())) {
            packager.setPackageVersion(parentPackager.getPackageVersion());
            if (StringUtils.isBlank((String)packager.getPackageVersion())) {
                packager.setPackageVersion(model.getProject().getResolvedVersion());
            }
        }
        if (StringUtils.isBlank((String)packager.getUsername())) {
            packager.setUsername(service.getOwner());
        }
        if (!packager.isRemoteBuildSet() && parentPackager.isRemoteBuildSet()) {
            packager.setRemoteBuild(parentPackager.isRemoteBuild());
        }
        if (StringUtils.isBlank((String)packager.getTitle())) {
            packager.setTitle(parentPackager.getTitle());
        }
        if (StringUtils.isBlank((String)packager.getTitle())) {
            packager.setTitle(model.getProject().getName());
        }
        if (StringUtils.isBlank((String)packager.getIconUrl())) {
            packager.setIconUrl(parentPackager.getIconUrl());
        }
        if (StringUtils.isBlank((String)packager.getSource())) {
            packager.setSource(parentPackager.getSource());
        }
        if (StringUtils.isBlank((String)packager.getSource())) {
            packager.setSource("https://push.chocolatey.org/");
        }
        if (!packager.isRemoteBuild()) {
            if (StringUtils.isBlank((String)packager.getApiKey())) {
                packager.setApiKey(parentPackager.getApiKey());
            }
            packager.setApiKey(Validator.checkProperty(context, (Collection<String>)CollectionUtils.listOf((Object[])new String[]{"distributions." + distribution.getName() + ".chocolatey.api.key", "CHOCOLATEY_API_KEY"}), "distributions." + distribution.getName() + ".chocolatey.apiKey", packager.getApiKey(), errors, context.isDryrun()));
        }
        DistributionsValidator.validateArtifactPlatforms(distribution, packager, candidateArtifacts, errors);
        try {
            String packageVersion = Templates.resolveTemplate((String)packager.getPackageVersion(), (TemplateContext)context.getModel().props());
            switch (project.versionPattern().getType()) {
                case SEMVER: {
                    ChocolateyPackagerValidator.checkSemver(SemanticVersion.of((String)packageVersion));
                    break;
                }
                case JAVA_RUNTIME: {
                    ChocolateyPackagerValidator.checkJavaRuntime(JavaRuntimeVersion.of((String)packageVersion));
                    break;
                }
                case JAVA_MODULE: {
                    ChocolateyPackagerValidator.checkJavaModule(JavaModuleVersion.of((String)packageVersion));
                    break;
                }
                case CHRONVER: {
                    ChocolateyPackagerValidator.checkChronVer(ChronVer.of((String)packageVersion));
                    break;
                }
            }
        }
        catch (IllegalArgumentException e) {
            errors.configuration(RB.$((String)"validation_chocolatey_package_version", (Object[])new Object[]{packager.getPackageVersion()}));
        }
        if (errors.hasErrors()) {
            packager.disable();
        }
    }

    private static void checkSemver(SemanticVersion version) {
        block6: {
            if (version.hasBuild()) {
                throw new IllegalArgumentException();
            }
            if (!version.hasTag() || "-".equals(version.getTagsep())) {
                return;
            }
            String tag = version.getTag();
            try {
                Integer.parseInt(tag);
                if (tag.length() != 8) break block6;
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd");
                try {
                    dateFormat.parse(tag);
                }
                catch (ParseException e) {
                    throw new IllegalArgumentException();
                }
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException();
            }
        }
    }

    private static void checkJavaRuntime(JavaRuntimeVersion version) {
        if (version.hasBuild()) {
            throw new IllegalArgumentException();
        }
        if (!version.hasPrerelease() && version.hasOptional()) {
            throw new IllegalArgumentException();
        }
    }

    private static void checkJavaModule(JavaModuleVersion version) {
        if (version.hasBuild()) {
            throw new IllegalArgumentException();
        }
    }

    private static void checkChronVer(ChronVer version) {
        ChronVer.Changeset changeset;
        if (version.hasChangeset() && ((changeset = version.getChangeset()).hasTag() || changeset.hasChange2())) {
            throw new IllegalArgumentException();
        }
    }

    public static void postValidateChocolatey(JReleaserContext context, Distribution distribution, ChocolateyPackager packager, Errors errors) {
        if (!packager.isEnabled()) {
            return;
        }
        context.getLogger().debug("distribution.{}.chocolatey", new Object[]{distribution.getName()});
        Project project = context.getModel().getProject();
        if (distribution.getTags().isEmpty()) {
            errors.configuration(RB.$((String)"validation_must_not_be_empty", (Object[])new Object[]{"distribution.tags"}));
        }
        if (StringUtils.isBlank((String)project.getLinks().getLicense())) {
            errors.configuration(RB.$((String)"ERROR_project_no_license_url", (Object[])new Object[0]));
        }
    }
}

