/*
 * Decompiled with CFR 0.152.
 */
package com.github.sbaudoin.yamllint.rules;

import com.github.sbaudoin.yamllint.LintProblem;
import com.github.sbaudoin.yamllint.Parser;
import com.github.sbaudoin.yamllint.rules.CommentRule;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class Comments
extends CommentRule {
    public static final String OPTION_REQUIRE_STARTING_SPACE = "require-starting-space";
    public static final String OPTION_IGNORE_SHEBANG = "ignore-shebangs";
    public static final String OPTION_MIN_SPACES_FROM_CONTENT = "min-spaces-from-content";

    public Comments() {
        this.registerOption(OPTION_REQUIRE_STARTING_SPACE, true);
        this.registerOption(OPTION_IGNORE_SHEBANG, true);
        this.registerOption(OPTION_MIN_SPACES_FROM_CONTENT, 2);
    }

    @Override
    public List<LintProblem> check(Map<Object, Object> conf, Parser.Comment comment) {
        ArrayList<LintProblem> problems = new ArrayList<LintProblem>();
        if ((Integer)conf.get(OPTION_MIN_SPACES_FROM_CONTENT) != -1 && comment.isInline() && comment.getPointer() - comment.getTokenBefore().getEndMark().getPointer() < (Integer)conf.get(OPTION_MIN_SPACES_FROM_CONTENT)) {
            problems.add(new LintProblem(comment.getLineNo(), comment.getColumnNo(), "too few spaces before comment"));
        }
        if (((Boolean)conf.get(OPTION_REQUIRE_STARTING_SPACE)).booleanValue()) {
            int textStart;
            for (textStart = comment.getPointer() + 1; textStart < comment.getBuffer().length() && comment.getBuffer().charAt(textStart) == '#'; ++textStart) {
            }
            if (textStart < comment.getBuffer().length()) {
                if (((Boolean)conf.get(OPTION_IGNORE_SHEBANG)).booleanValue() && comment.getLineNo() == 1 && comment.getColumnNo() == 1 && comment.getBuffer().charAt(textStart) == '!') {
                    return problems;
                }
                if (Arrays.binarySearch(new char[]{'\u0000', '\n', ' '}, comment.getBuffer().charAt(textStart)) < 0) {
                    problems.add(new LintProblem(comment.getLineNo(), comment.getColumnNo() + textStart - comment.getPointer(), "missing starting space in comment"));
                }
            }
        }
        return problems;
    }
}

