/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl3;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.jexl3.JexlContext;
import org.apache.commons.jexl3.JexlEngine;
import org.apache.commons.jexl3.JexlOperator;
import org.apache.commons.jexl3.JexlOptions;
import org.apache.commons.jexl3.internal.IntegerRange;
import org.apache.commons.jexl3.internal.LongRange;
import org.apache.commons.jexl3.internal.introspection.ArrayListWrapper;
import org.apache.commons.jexl3.introspection.JexlMethod;

public class JexlArithmetic {
    protected static final BigDecimal BIGD_DOUBLE_MAX_VALUE = BigDecimal.valueOf(Double.MAX_VALUE);
    protected static final BigDecimal BIGD_DOUBLE_MIN_VALUE = BigDecimal.valueOf(-1.7976931348623157E308);
    protected static final BigInteger BIGI_LONG_MAX_VALUE = BigInteger.valueOf(Long.MAX_VALUE);
    protected static final BigInteger BIGI_LONG_MIN_VALUE = BigInteger.valueOf(Long.MIN_VALUE);
    protected static final int BIGD_SCALE = -1;
    public static final Pattern FLOAT_PATTERN = Pattern.compile("^[+-]?\\d*(\\.\\d*)?([eE][+-]?\\d+)?$");
    private final boolean strict;
    private final MathContext mathContext;
    private final int mathScale;
    private final Constructor<? extends JexlArithmetic> ctor;
    private final boolean compare321 = JexlArithmetic.computeCompare321(this);

    private static Object arrayWrap(Object container) {
        return container.getClass().isArray() ? new ArrayListWrapper(container) : container;
    }

    private static boolean computeCompare321(JexlArithmetic arithmetic) {
        Class<?> arithmeticClass = arithmetic.getClass();
        while (arithmeticClass != JexlArithmetic.class) {
            try {
                Method cmp = arithmeticClass.getDeclaredMethod("compare", Object.class, Object.class, String.class);
                if (cmp.getDeclaringClass() == JexlArithmetic.class) continue;
                return true;
            }
            catch (NoSuchMethodException xany) {
                arithmeticClass = arithmeticClass.getSuperclass();
            }
        }
        return false;
    }

    protected static boolean isMultiplyExact(long x, long y, long r) {
        long ay;
        long ax = Math.abs(x);
        return (ax | (ay = Math.abs(y))) >>> 31 == 0L || (y == 0L || r / y == x) && (x != Long.MIN_VALUE || y != -1L);
    }

    public JexlArithmetic(boolean astrict) {
        this(astrict, null, Integer.MIN_VALUE);
    }

    public JexlArithmetic(boolean astrict, MathContext bigdContext, int bigdScale) {
        this.strict = astrict;
        this.mathContext = bigdContext == null ? MathContext.DECIMAL128 : bigdContext;
        this.mathScale = bigdScale == Integer.MIN_VALUE ? -1 : bigdScale;
        Constructor<?> actor = null;
        try {
            actor = this.getClass().getConstructor(Boolean.TYPE, MathContext.class, Integer.TYPE);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.ctor = actor;
    }

    public Object add(Object left, Object right) {
        boolean strconcat;
        if (left == null && right == null) {
            return this.controlNullNullOperands(JexlOperator.ADD);
        }
        boolean bl = this.strict ? left instanceof String || right instanceof String : (strconcat = left instanceof String && right instanceof String);
        if (!strconcat) {
            try {
                boolean strictCast = this.isStrict(JexlOperator.ADD);
                Number ln = this.asLongNumber(strictCast, left);
                Number rn = this.asLongNumber(strictCast, right);
                if (ln != null && rn != null) {
                    long y;
                    long result;
                    long x = ln.longValue();
                    if (((x ^ (result = x + (y = rn.longValue()))) & (y ^ result)) < 0L) {
                        return BigInteger.valueOf(x).add(BigInteger.valueOf(y));
                    }
                    return this.narrowLong(left, right, result);
                }
                if (left instanceof BigDecimal || right instanceof BigDecimal) {
                    BigDecimal l = this.toBigDecimal(strictCast, left);
                    BigDecimal r = this.toBigDecimal(strictCast, right);
                    return l.add(r, this.getMathContext());
                }
                if (this.isFloatingPointNumber(left) || this.isFloatingPointNumber(right)) {
                    double l = this.toDouble(strictCast, left);
                    double r = this.toDouble(strictCast, right);
                    return l + r;
                }
                BigInteger l = this.toBigInteger(strictCast, left);
                BigInteger r = this.toBigInteger(strictCast, right);
                BigInteger result = l.add(r);
                return this.narrowBigInteger(left, right, result);
            }
            catch (ArithmeticException arithmeticException) {
                // empty catch block
            }
        }
        return (left == null ? "" : this.toString(left)).concat(right == null ? "" : this.toString(right));
    }

    public Object and(Object left, Object right) {
        long l = this.toLong(left);
        long r = this.toLong(right);
        return l & r;
    }

    @Deprecated
    public ArrayBuilder arrayBuilder(int size) {
        return this.arrayBuilder(size, false);
    }

    public ArrayBuilder arrayBuilder(int size, boolean extended) {
        return new org.apache.commons.jexl3.internal.ArrayBuilder(size, extended);
    }

    protected Number asLongNumber(boolean strict, Object value) {
        if (value instanceof Long || value instanceof Integer || value instanceof Short || value instanceof Byte) {
            return (Number)value;
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false ? 1L : 0L;
        }
        if (value instanceof AtomicBoolean) {
            AtomicBoolean b = (AtomicBoolean)value;
            return b.get() ? 1L : 0L;
        }
        if (value == null && !strict) {
            return 0L;
        }
        return null;
    }

    protected Number asLongNumber(Object value) {
        return this.asLongNumber(this.strict, value);
    }

    @Deprecated
    public final Object bitwiseAnd(Object lhs, Object rhs) {
        return this.and(lhs, rhs);
    }

    @Deprecated
    public final Object bitwiseOr(Object lhs, Object rhs) {
        return this.or(lhs, rhs);
    }

    @Deprecated
    public final Object bitwiseXor(Object lhs, Object rhs) {
        return this.xor(lhs, rhs);
    }

    protected Boolean collectionContains(Object collection, Object value) {
        Object left = JexlArithmetic.arrayWrap(collection);
        if (left instanceof Collection) {
            Object right = JexlArithmetic.arrayWrap(value);
            if (right instanceof Collection) {
                return ((Collection)left).containsAll((Collection)right);
            }
            return ((Collection)left).contains(value);
        }
        return null;
    }

    protected int compare(Object left, Object right, JexlOperator operator) {
        return this.compare321 ? this.compare(left, right, operator.toString()) : this.doCompare(left, right, operator);
    }

    @Deprecated
    protected int compare(Object left, Object right, String symbol) {
        JexlOperator operator;
        try {
            operator = JexlOperator.valueOf(symbol);
        }
        catch (IllegalArgumentException xill) {
            operator = JexlOperator.EQ;
        }
        return this.doCompare(left, right, operator);
    }

    public Object complement(Object val) {
        boolean strictCast = this.isStrict(JexlOperator.COMPLEMENT);
        long l = this.toLong(strictCast, val);
        return l ^ 0xFFFFFFFFFFFFFFFFL;
    }

    public Boolean contains(Object container, Object value) {
        if (value == null && container == null) {
            return true;
        }
        if (value == null || container == null) {
            return false;
        }
        if (container instanceof Pattern) {
            return ((Pattern)container).matcher(value.toString()).matches();
        }
        if (container instanceof CharSequence) {
            return value.toString().matches(container.toString());
        }
        if (container instanceof Map) {
            if (value instanceof Map) {
                return ((Map)container).keySet().containsAll(((Map)value).keySet());
            }
            return ((Map)container).containsKey(value);
        }
        return this.collectionContains(container, value);
    }

    @Deprecated
    protected Object controlNullNullOperands() {
        if (this.isStrict()) {
            throw new NullOperand();
        }
        return 0;
    }

    protected Object controlNullNullOperands(JexlOperator operator) {
        if (this.isStrict(operator)) {
            throw new NullOperand();
        }
        return 0;
    }

    @Deprecated
    protected void controlNullOperand() {
        if (this.isStrict()) {
            throw new NullOperand();
        }
    }

    protected <T> T controlNullOperand(boolean strictCast, T defaultValue) {
        if (strictCast) {
            throw new NullOperand();
        }
        return defaultValue;
    }

    public Object controlReturn(Object returned) {
        return returned;
    }

    public Iterable<?> createRange(Object from, Object to) throws ArithmeticException {
        long lfrom = this.toLong(from);
        long lto = this.toLong(to);
        if (lfrom >= Integer.MIN_VALUE && lfrom <= Integer.MAX_VALUE && lto >= Integer.MIN_VALUE && lto <= Integer.MAX_VALUE) {
            return IntegerRange.create((int)lfrom, (int)lto);
        }
        return LongRange.create(lfrom, lto);
    }

    protected JexlArithmetic createWithOptions(boolean astrict, MathContext bigdContext, int bigdScale) {
        if (this.ctor != null) {
            try {
                return this.ctor.newInstance(astrict, bigdContext, bigdScale);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException exception) {
                // empty catch block
            }
        }
        return new JexlArithmetic(astrict, bigdContext, bigdScale);
    }

    public Object decrement(Object val) {
        return this.increment(val, -1);
    }

    public Object divide(Object left, Object right) {
        if (left == null && right == null) {
            return this.controlNullNullOperands(JexlOperator.DIVIDE);
        }
        boolean strictCast = this.isStrict(JexlOperator.DIVIDE);
        Number ln = this.asLongNumber(strictCast, left);
        Number rn = this.asLongNumber(strictCast, right);
        if (ln != null && rn != null) {
            long x = ln.longValue();
            long y = rn.longValue();
            if (y == 0L) {
                throw new ArithmeticException("/");
            }
            long result = x / y;
            return this.narrowLong(left, right, result);
        }
        if (left instanceof BigDecimal || right instanceof BigDecimal) {
            BigDecimal l = this.toBigDecimal(strictCast, left);
            BigDecimal r = this.toBigDecimal(strictCast, right);
            if (BigDecimal.ZERO.equals(r)) {
                throw new ArithmeticException("/");
            }
            return l.divide(r, this.getMathContext());
        }
        if (this.isFloatingPointNumber(left) || this.isFloatingPointNumber(right)) {
            double l = this.toDouble(strictCast, left);
            double r = this.toDouble(strictCast, right);
            if (r == 0.0) {
                throw new ArithmeticException("/");
            }
            return l / r;
        }
        BigInteger l = this.toBigInteger(strictCast, left);
        BigInteger r = this.toBigInteger(strictCast, right);
        if (BigInteger.ZERO.equals(r)) {
            throw new ArithmeticException("/");
        }
        BigInteger result = l.divide(r);
        return this.narrowBigInteger(left, right, result);
    }

    private int doCompare(Object left, Object right, JexlOperator operator) {
        boolean strictCast = this.isStrict(operator);
        if (left != null && right != null) {
            Comparable comparable;
            try {
                if (left instanceof BigDecimal || right instanceof BigDecimal) {
                    BigDecimal l = this.toBigDecimal(strictCast, left);
                    BigDecimal r = this.toBigDecimal(strictCast, right);
                    return l.compareTo(r);
                }
                if (left instanceof BigInteger || right instanceof BigInteger) {
                    BigInteger l = this.toBigInteger(strictCast, left);
                    BigInteger r = this.toBigInteger(strictCast, right);
                    return l.compareTo(r);
                }
                if (this.isFloatingPoint(left) || this.isFloatingPoint(right)) {
                    double lhs = this.toDouble(strictCast, left);
                    double rhs = this.toDouble(strictCast, right);
                    if (Double.isNaN(lhs)) {
                        if (Double.isNaN(rhs)) {
                            return 0;
                        }
                        return -1;
                    }
                    if (Double.isNaN(rhs)) {
                        return 1;
                    }
                    return Double.compare(lhs, rhs);
                }
                if (this.isNumberable(left) || this.isNumberable(right)) {
                    long lhs = this.toLong(strictCast, left);
                    long rhs = this.toLong(strictCast, right);
                    return Long.compare(lhs, rhs);
                }
                if (left instanceof String || right instanceof String) {
                    return this.toString(left).compareTo(this.toString(right));
                }
            }
            catch (CoercionException lhs) {
                // empty catch block
            }
            if (JexlOperator.EQ == operator) {
                return left.equals(right) ? 0 : -1;
            }
            if (left instanceof Comparable) {
                comparable = (Comparable)left;
                try {
                    return comparable.compareTo(right);
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
            }
            if (right instanceof Comparable) {
                comparable = (Comparable)right;
                try {
                    return -Integer.signum(comparable.compareTo(left));
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
            }
        }
        throw new ArithmeticException("Object comparison:(" + left + " " + operator.getOperatorSymbol() + " " + right + ")");
    }

    public Boolean empty(Object object) {
        return object == null || this.isEmpty(object, false) != false;
    }

    public Boolean endsWith(Object left, Object right) {
        if (left == null && right == null) {
            return true;
        }
        if (left == null || right == null) {
            return false;
        }
        if (left instanceof CharSequence) {
            return this.toString(left).endsWith(this.toString(right));
        }
        return null;
    }

    public boolean equals(Object left, Object right) {
        if (left == right) {
            return true;
        }
        if (left == null || right == null) {
            return false;
        }
        boolean strictCast = this.isStrict(JexlOperator.EQ);
        if (left instanceof Boolean || right instanceof Boolean) {
            return this.toBoolean(left) == this.toBoolean(strictCast, right);
        }
        return this.compare(left, right, JexlOperator.EQ) == 0;
    }

    public MathContext getMathContext() {
        return this.mathContext;
    }

    public int getMathScale() {
        return this.mathScale;
    }

    public boolean greaterThan(Object left, Object right) {
        if (left == right || left == null || right == null) {
            return false;
        }
        return this.compare(left, right, JexlOperator.GT) > 0;
    }

    public boolean greaterThanOrEqual(Object left, Object right) {
        if (left == right) {
            return true;
        }
        if (left == null || right == null) {
            return false;
        }
        return this.compare(left, right, JexlOperator.GTE) >= 0;
    }

    public Object increment(Object val) {
        return this.increment(val, 1);
    }

    protected Object increment(Object val, int incr) {
        if (val == null) {
            return incr;
        }
        if (val instanceof Integer) {
            return (Integer)val + incr;
        }
        if (val instanceof Double) {
            return (Double)val + (double)incr;
        }
        if (val instanceof Long) {
            return (Long)val + (long)incr;
        }
        if (val instanceof BigDecimal) {
            BigDecimal bd = (BigDecimal)val;
            return bd.add(BigDecimal.valueOf(incr), this.mathContext);
        }
        if (val instanceof BigInteger) {
            BigInteger bi = (BigInteger)val;
            return bi.add(BigInteger.valueOf(incr));
        }
        if (val instanceof Float) {
            return Float.valueOf(((Float)val).floatValue() + (float)incr);
        }
        if (val instanceof Short) {
            return (short)((Short)val + incr);
        }
        if (val instanceof Byte) {
            return (byte)((Byte)val + incr);
        }
        throw new ArithmeticException("Object " + (incr < 0 ? "decrement" : "increment") + ":(" + val + ")");
    }

    public Boolean isEmpty(Object object) {
        return this.isEmpty(object, object == null);
    }

    public Boolean isEmpty(Object object, Boolean def) {
        if (object != null) {
            if (object instanceof Number) {
                double d = ((Number)object).doubleValue();
                return Double.isNaN(d) || d == 0.0;
            }
            if (object instanceof CharSequence) {
                return ((CharSequence)object).length() == 0;
            }
            if (object.getClass().isArray()) {
                return Array.getLength(object) == 0;
            }
            if (object instanceof Collection) {
                return ((Collection)object).isEmpty();
            }
            if (object instanceof Map) {
                return ((Map)object).isEmpty();
            }
        }
        return def;
    }

    protected boolean isFloatingPoint(Object o) {
        return o instanceof Float || o instanceof Double;
    }

    protected boolean isFloatingPointNumber(Object val) {
        if (val instanceof Float || val instanceof Double) {
            return true;
        }
        if (val instanceof CharSequence) {
            Matcher m = FLOAT_PATTERN.matcher((CharSequence)val);
            return m.matches() && (m.start(1) >= 0 || m.start(2) >= 0);
        }
        return false;
    }

    public boolean isNegateStable() {
        return true;
    }

    protected boolean isNullOperand(Object value) {
        return value == null;
    }

    protected boolean isNumberable(Object o) {
        return o instanceof Integer || o instanceof Long || o instanceof Byte || o instanceof Short || o instanceof Character;
    }

    public boolean isPositivizeStable() {
        return true;
    }

    public boolean isStrict() {
        return this.strict;
    }

    public boolean isStrict(JexlOperator operator) {
        if (operator != null) {
            switch (operator) {
                case EQ: 
                case EQSTRICT: 
                case ARRAY_GET: 
                case ARRAY_SET: 
                case PROPERTY_GET: 
                case PROPERTY_SET: 
                case EMPTY: 
                case SIZE: 
                case CONTAINS: {
                    return false;
                }
            }
            return this.isStrict();
        }
        return this.isStrict();
    }

    public boolean lessThan(Object left, Object right) {
        if (left == right || left == null || right == null) {
            return false;
        }
        return this.compare(left, right, JexlOperator.LT) < 0;
    }

    public boolean lessThanOrEqual(Object left, Object right) {
        if (left == right) {
            return true;
        }
        if (left == null || right == null) {
            return false;
        }
        return this.compare(left, right, JexlOperator.LTE) <= 0;
    }

    @Deprecated
    public final Object logicalNot(Object arg) {
        return this.not(arg);
    }

    @Deprecated
    public MapBuilder mapBuilder(int size) {
        return this.mapBuilder(size, false);
    }

    public MapBuilder mapBuilder(int size, boolean extended) {
        return new org.apache.commons.jexl3.internal.MapBuilder(size, extended);
    }

    @Deprecated
    public final Object matches(Object lhs, Object rhs) {
        return this.contains(rhs, lhs);
    }

    public Object mod(Object left, Object right) {
        if (left == null && right == null) {
            return this.controlNullNullOperands(JexlOperator.MOD);
        }
        boolean strictCast = this.isStrict(JexlOperator.MOD);
        Number ln = this.asLongNumber(strictCast, left);
        Number rn = this.asLongNumber(strictCast, right);
        if (ln != null && rn != null) {
            long x = ln.longValue();
            long y = rn.longValue();
            if (y == 0L) {
                throw new ArithmeticException("%");
            }
            long result = x % y;
            return this.narrowLong(left, right, result);
        }
        if (left instanceof BigDecimal || right instanceof BigDecimal) {
            BigDecimal l = this.toBigDecimal(strictCast, left);
            BigDecimal r = this.toBigDecimal(strictCast, right);
            if (BigDecimal.ZERO.equals(r)) {
                throw new ArithmeticException("%");
            }
            return l.remainder(r, this.getMathContext());
        }
        if (this.isFloatingPointNumber(left) || this.isFloatingPointNumber(right)) {
            double l = this.toDouble(strictCast, left);
            double r = this.toDouble(strictCast, right);
            if (r == 0.0) {
                throw new ArithmeticException("%");
            }
            return l % r;
        }
        BigInteger l = this.toBigInteger(strictCast, left);
        BigInteger r = this.toBigInteger(strictCast, right);
        if (BigInteger.ZERO.equals(r)) {
            throw new ArithmeticException("%");
        }
        BigInteger result = l.mod(r);
        return this.narrowBigInteger(left, right, result);
    }

    public Object multiply(Object left, Object right) {
        if (left == null && right == null) {
            return this.controlNullNullOperands(JexlOperator.MULTIPLY);
        }
        boolean strictCast = this.isStrict(JexlOperator.MULTIPLY);
        Number ln = this.asLongNumber(strictCast, left);
        Number rn = this.asLongNumber(strictCast, right);
        if (ln != null && rn != null) {
            long result;
            long y;
            long x = ln.longValue();
            if (!JexlArithmetic.isMultiplyExact(x, y = rn.longValue(), result = x * y)) {
                return BigInteger.valueOf(x).multiply(BigInteger.valueOf(y));
            }
            return this.narrowLong(left, right, result);
        }
        if (left instanceof BigDecimal || right instanceof BigDecimal) {
            BigDecimal l = this.toBigDecimal(strictCast, left);
            BigDecimal r = this.toBigDecimal(strictCast, right);
            return l.multiply(r, this.getMathContext());
        }
        if (this.isFloatingPointNumber(left) || this.isFloatingPointNumber(right)) {
            double l = this.toDouble(strictCast, left);
            double r = this.toDouble(strictCast, right);
            return l * r;
        }
        BigInteger l = this.toBigInteger(strictCast, left);
        BigInteger r = this.toBigInteger(strictCast, right);
        BigInteger result = l.multiply(r);
        return this.narrowBigInteger(left, right, result);
    }

    private Number narrow(Class<?> narrow, double value) {
        return this.narrowAccept(narrow, Float.class) && (double)((float)value) == value ? (double)((float)value) : value;
    }

    public Number narrow(Number original) {
        return this.narrowNumber(original, null);
    }

    protected boolean narrowAccept(Class<?> narrow, Class<?> source) {
        return narrow == null || narrow.equals(source);
    }

    public boolean narrowArguments(Object[] args) {
        boolean narrowed = false;
        if (args != null) {
            for (int a = 0; a < args.length; ++a) {
                Number narrow;
                Number narg;
                Object arg = args[a];
                if (!(arg instanceof Number) || (narg = (Number)arg).equals(narrow = this.narrow(narg))) continue;
                args[a] = narrow;
                narrowed = true;
            }
        }
        return narrowed;
    }

    protected Number narrowBigDecimal(Object lhs, Object rhs, BigDecimal big) {
        if (this.isNumberable(lhs) || this.isNumberable(rhs)) {
            try {
                long l = big.longValueExact();
                if ((long)((int)l) == l) {
                    return (int)l;
                }
                return l;
            }
            catch (ArithmeticException arithmeticException) {
                // empty catch block
            }
        }
        return big;
    }

    protected Number narrowBigInteger(Object lhs, Object rhs, BigInteger big) {
        if (this.isNumberable(lhs) || this.isNumberable(rhs)) {
            try {
                long l = big.longValueExact();
                if ((long)((int)l) == l) {
                    return (int)l;
                }
                return l;
            }
            catch (ArithmeticException arithmeticException) {
                // empty catch block
            }
        }
        return big;
    }

    protected Number narrowLong(Object lhs, Object rhs, long r) {
        if (!(lhs instanceof Long) && !(rhs instanceof Long) && (long)((int)r) == r) {
            return (int)r;
        }
        return r;
    }

    public Number narrowNumber(Number original, Class<?> narrow) {
        if (original != null) {
            long value;
            if (original instanceof BigDecimal) {
                BigDecimal big = (BigDecimal)original;
                try {
                    value = big.longValueExact();
                }
                catch (ArithmeticException xa) {
                    if (big.compareTo(BIGD_DOUBLE_MAX_VALUE) > 0 || big.compareTo(BIGD_DOUBLE_MIN_VALUE) < 0) {
                        return original;
                    }
                    return this.narrow(narrow, original.doubleValue());
                }
            } else {
                BigInteger bigi;
                if (this.isFloatingPoint(original)) {
                    double doubleValue = original.doubleValue();
                    if ((double)((long)doubleValue) != doubleValue) {
                        return this.narrow(narrow, doubleValue);
                    }
                } else if (original instanceof BigInteger && !BigInteger.valueOf((bigi = (BigInteger)original).longValue()).equals(bigi)) {
                    return original;
                }
                value = original.longValue();
            }
            if (this.narrowAccept(narrow, Byte.class) && (long)((byte)value) == value) {
                return (byte)value;
            }
            if (this.narrowAccept(narrow, Short.class) && (long)((short)value) == value) {
                return (short)value;
            }
            if (this.narrowAccept(narrow, Integer.class) && (long)((int)value) == value) {
                return (int)value;
            }
        }
        return original;
    }

    public Object negate(Object val) {
        if (val == null) {
            return null;
        }
        if (val instanceof Integer) {
            return -((Integer)val).intValue();
        }
        if (val instanceof Double) {
            return -((Double)val).doubleValue();
        }
        if (val instanceof Long) {
            return -((Long)val).longValue();
        }
        if (val instanceof BigDecimal) {
            return ((BigDecimal)val).negate();
        }
        if (val instanceof BigInteger) {
            return ((BigInteger)val).negate();
        }
        if (val instanceof Float) {
            return Float.valueOf(-((Float)val).floatValue());
        }
        if (val instanceof Short) {
            return -((Short)val).shortValue();
        }
        if (val instanceof Byte) {
            return -((Byte)val).byteValue();
        }
        if (val instanceof Boolean) {
            return (Boolean)val == false;
        }
        if (val instanceof AtomicBoolean) {
            return !((AtomicBoolean)val).get();
        }
        throw new ArithmeticException("Object negate:(" + val + ")");
    }

    public Object not(Object val) {
        boolean strictCast = this.isStrict(JexlOperator.NOT);
        return !this.toBoolean(strictCast, val);
    }

    public JexlArithmetic options(JexlContext context) {
        if (context instanceof JexlContext.OptionsHandle) {
            return this.options(((JexlContext.OptionsHandle)((Object)context)).getEngineOptions());
        }
        if (context instanceof JexlEngine.Options) {
            return this.options((JexlEngine.Options)((Object)context));
        }
        return this;
    }

    @Deprecated
    public JexlArithmetic options(JexlEngine.Options options) {
        if (options != null) {
            int bigdScale;
            boolean isstrict = Boolean.TRUE == options.isStrictArithmetic() || this.isStrict();
            MathContext bigdContext = options.getArithmeticMathContext();
            if (bigdContext == null) {
                bigdContext = this.getMathContext();
            }
            if ((bigdScale = options.getArithmeticMathScale()) == Integer.MIN_VALUE) {
                bigdScale = this.getMathScale();
            }
            if (isstrict != this.isStrict() || bigdScale != this.getMathScale() || bigdContext != this.getMathContext()) {
                return this.createWithOptions(isstrict, bigdContext, bigdScale);
            }
        }
        return this;
    }

    public JexlArithmetic options(JexlOptions options) {
        if (options != null) {
            int bigdScale;
            boolean ostrict = options.isStrictArithmetic();
            MathContext bigdContext = options.getMathContext();
            if (bigdContext == null) {
                bigdContext = this.getMathContext();
            }
            if ((bigdScale = options.getMathScale()) == Integer.MIN_VALUE) {
                bigdScale = this.getMathScale();
            }
            if (ostrict != this.isStrict() || bigdScale != this.getMathScale() || bigdContext != this.getMathContext()) {
                return this.createWithOptions(ostrict, bigdContext, bigdScale);
            }
        }
        return this;
    }

    public Object or(Object left, Object right) {
        long l = this.toLong(left);
        long r = this.toLong(right);
        return l | r;
    }

    private BigDecimal parseBigDecimal(String arg) throws ArithmeticException {
        try {
            return arg.isEmpty() ? BigDecimal.ZERO : new BigDecimal(arg, this.getMathContext());
        }
        catch (NumberFormatException e) {
            throw new CoercionException("BigDecimal coercion: (" + arg + ")", e);
        }
    }

    private BigInteger parseBigInteger(String arg) throws ArithmeticException {
        try {
            return arg.isEmpty() ? BigInteger.ZERO : new BigInteger(arg);
        }
        catch (NumberFormatException e) {
            throw new CoercionException("BigDecimal coercion: (" + arg + ")", e);
        }
    }

    private double parseDouble(String arg) throws ArithmeticException {
        try {
            return arg.isEmpty() ? Double.NaN : Double.parseDouble(arg);
        }
        catch (NumberFormatException e) {
            throw new CoercionException("Double coercion: (" + arg + ")", e);
        }
    }

    private int parseInteger(String arg) throws ArithmeticException {
        long l = this.parseLong(arg);
        int i = (int)l;
        if ((long)i == l) {
            return i;
        }
        throw new CoercionException("Int coercion: (" + arg + ")");
    }

    private long parseLong(String arg) throws ArithmeticException {
        double d = this.parseDouble(arg);
        if (Double.isNaN(d)) {
            return 0L;
        }
        double f = StrictMath.floor(d);
        if (d == f) {
            return (long)d;
        }
        throw new CoercionException("Long coercion: (" + arg + ")");
    }

    public static Integer parseIdentifier(Object id) {
        CharSequence str;
        int length;
        if (id instanceof Number) {
            return ((Number)id).intValue();
        }
        if (id instanceof CharSequence && (length = (str = (CharSequence)id).length()) > 0 && length <= 10) {
            int val = 0;
            for (int i = 0; i < length; ++i) {
                char c = str.charAt(i);
                if (c == '0' && val == 0 && length > 1 || c < '0' || c > '9') {
                    return null;
                }
                val *= 10;
                val += c - 48;
            }
            return val;
        }
        return null;
    }

    public Object positivize(Object val) {
        if (val == null) {
            return null;
        }
        if (val instanceof Short) {
            return ((Short)val).intValue();
        }
        if (val instanceof Byte) {
            return ((Byte)val).intValue();
        }
        if (val instanceof Number) {
            return val;
        }
        if (val instanceof Character) {
            return (int)((Character)val).charValue();
        }
        if (val instanceof Boolean) {
            return val;
        }
        if (val instanceof AtomicBoolean) {
            return ((AtomicBoolean)val).get();
        }
        throw new ArithmeticException("Object positivize:(" + val + ")");
    }

    protected BigDecimal roundBigDecimal(BigDecimal number) {
        int mscale = this.getMathScale();
        if (mscale >= 0) {
            return number.setScale(mscale, this.getMathContext().getRoundingMode());
        }
        return number;
    }

    @Deprecated
    public SetBuilder setBuilder(int size) {
        return this.setBuilder(size, false);
    }

    public SetBuilder setBuilder(int size, boolean extended) {
        return new org.apache.commons.jexl3.internal.SetBuilder(size, extended);
    }

    public Object shiftLeft(Object left, Object right) {
        long l = this.toLong(left);
        int r = this.toInteger(right);
        return l << r;
    }

    public Object shiftRight(Object left, Object right) {
        long l = this.toLong(left);
        long r = this.toInteger(right);
        return l >> (int)r;
    }

    public Object shiftRightUnsigned(Object left, Object right) {
        long l = this.toLong(left);
        long r = this.toInteger(right);
        return l >>> (int)r;
    }

    public Integer size(Object object) {
        return this.size(object, object == null ? 0 : 1);
    }

    public Integer size(Object object, Integer def) {
        if (object instanceof CharSequence) {
            return ((CharSequence)object).length();
        }
        if (object.getClass().isArray()) {
            return Array.getLength(object);
        }
        if (object instanceof Collection) {
            return ((Collection)object).size();
        }
        if (object instanceof Map) {
            return ((Map)object).size();
        }
        return def;
    }

    public Boolean startsWith(Object left, Object right) {
        if (left == null && right == null) {
            return true;
        }
        if (left == null || right == null) {
            return false;
        }
        if (left instanceof CharSequence) {
            return this.toString(left).startsWith(this.toString(right));
        }
        return null;
    }

    public boolean strictEquals(Object left, Object right) {
        if (left == right) {
            return true;
        }
        if (left == null || right == null) {
            return false;
        }
        if (left.getClass().equals(right.getClass())) {
            return left.equals(right);
        }
        return false;
    }

    public Object subtract(Object left, Object right) {
        if (left == null && right == null) {
            return this.controlNullNullOperands(JexlOperator.SUBTRACT);
        }
        boolean strictCast = this.isStrict(JexlOperator.SUBTRACT);
        Number ln = this.asLongNumber(strictCast, left);
        Number rn = this.asLongNumber(strictCast, right);
        if (ln != null && rn != null) {
            long result;
            long y;
            long x = ln.longValue();
            if (((x ^ (y = rn.longValue())) & (x ^ (result = x - y))) < 0L) {
                return BigInteger.valueOf(x).subtract(BigInteger.valueOf(y));
            }
            return this.narrowLong(left, right, result);
        }
        if (left instanceof BigDecimal || right instanceof BigDecimal) {
            BigDecimal l = this.toBigDecimal(strictCast, left);
            BigDecimal r = this.toBigDecimal(strictCast, right);
            return l.subtract(r, this.getMathContext());
        }
        if (this.isFloatingPointNumber(left) || this.isFloatingPointNumber(right)) {
            double l = this.toDouble(strictCast, left);
            double r = this.toDouble(strictCast, right);
            return l - r;
        }
        BigInteger l = this.toBigInteger(strictCast, left);
        BigInteger r = this.toBigInteger(strictCast, right);
        BigInteger result = l.subtract(r);
        return this.narrowBigInteger(left, right, result);
    }

    public boolean testPredicate(Object object) {
        boolean strictCast = this.isStrict(JexlOperator.CONDITION);
        return this.toBoolean(strictCast, object);
    }

    protected BigDecimal toBigDecimal(boolean strict, Object val) {
        return this.isNullOperand(val) ? this.controlNullOperand(strict, BigDecimal.ZERO) : this.toBigDecimal(val);
    }

    public BigDecimal toBigDecimal(Object val) {
        if (val instanceof BigDecimal) {
            return this.roundBigDecimal((BigDecimal)val);
        }
        if (val instanceof Double) {
            if (Double.isNaN((Double)val)) {
                return BigDecimal.ZERO;
            }
            return this.roundBigDecimal(new BigDecimal(val.toString(), this.getMathContext()));
        }
        if (val instanceof Number) {
            return this.roundBigDecimal(this.parseBigDecimal(val.toString()));
        }
        if (val instanceof Boolean) {
            return BigDecimal.valueOf((Boolean)val != false ? 1.0 : 0.0);
        }
        if (val instanceof AtomicBoolean) {
            return BigDecimal.valueOf(((AtomicBoolean)val).get() ? 1L : 0L);
        }
        if (val instanceof String) {
            return this.roundBigDecimal(this.parseBigDecimal((String)val));
        }
        if (val instanceof Character) {
            return new BigDecimal(((Character)val).charValue());
        }
        if (val == null) {
            return this.controlNullOperand(this.strict, BigDecimal.ZERO);
        }
        throw new CoercionException("BigDecimal coercion: " + val.getClass().getName() + ":(" + val + ")");
    }

    protected BigInteger toBigInteger(boolean strict, Object val) {
        return this.isNullOperand(val) ? this.controlNullOperand(strict, BigInteger.ZERO) : this.toBigInteger(val);
    }

    public BigInteger toBigInteger(Object val) {
        if (val instanceof BigInteger) {
            return (BigInteger)val;
        }
        if (val instanceof Double) {
            Double dval = (Double)val;
            if (Double.isNaN(dval)) {
                return BigInteger.ZERO;
            }
            return BigInteger.valueOf(dval.longValue());
        }
        if (val instanceof BigDecimal) {
            return ((BigDecimal)val).toBigInteger();
        }
        if (val instanceof Number) {
            return BigInteger.valueOf(((Number)val).longValue());
        }
        if (val instanceof Boolean) {
            return BigInteger.valueOf((Boolean)val != false ? 1L : 0L);
        }
        if (val instanceof AtomicBoolean) {
            return BigInteger.valueOf(((AtomicBoolean)val).get() ? 1L : 0L);
        }
        if (val instanceof String) {
            return this.parseBigInteger((String)val);
        }
        if (val instanceof Character) {
            char i = ((Character)val).charValue();
            return BigInteger.valueOf(i);
        }
        if (val == null) {
            return this.controlNullOperand(this.strict, BigInteger.ZERO);
        }
        throw new CoercionException("BigInteger coercion: " + val.getClass().getName() + ":(" + val + ")");
    }

    protected boolean toBoolean(boolean strict, Object val) {
        return this.isNullOperand(val) ? this.controlNullOperand(strict, false).booleanValue() : this.toBoolean(val);
    }

    public boolean toBoolean(Object val) {
        if (val instanceof Boolean) {
            return (Boolean)val;
        }
        if (val instanceof Number) {
            double number = this.toDouble(this.strict, val);
            return !Double.isNaN(number) && number != 0.0;
        }
        if (val instanceof AtomicBoolean) {
            return ((AtomicBoolean)val).get();
        }
        if (val instanceof String) {
            String strval = val.toString();
            return !strval.isEmpty() && !"false".equals(strval);
        }
        if (val == null) {
            return this.controlNullOperand(this.strict, false);
        }
        return true;
    }

    protected double toDouble(boolean strict, Object val) {
        return this.isNullOperand(val) ? this.controlNullOperand(strict, 0.0).doubleValue() : this.toDouble(val);
    }

    public double toDouble(Object val) {
        if (val instanceof Double) {
            return (Double)val;
        }
        if (val instanceof Number) {
            return ((Number)val).doubleValue();
        }
        if (val instanceof Boolean) {
            return (Boolean)val != false ? 1.0 : 0.0;
        }
        if (val instanceof AtomicBoolean) {
            return ((AtomicBoolean)val).get() ? 1.0 : 0.0;
        }
        if (val instanceof String) {
            return this.parseDouble((String)val);
        }
        if (val instanceof Character) {
            return ((Character)val).charValue();
        }
        if (val == null) {
            return this.controlNullOperand(this.strict, 0.0);
        }
        throw new CoercionException("Double coercion: " + val.getClass().getName() + ":(" + val + ")");
    }

    protected int toInteger(boolean strict, Object val) {
        return this.isNullOperand(val) ? this.controlNullOperand(strict, 0).intValue() : this.toInteger(val);
    }

    public int toInteger(Object val) {
        if (val instanceof Double) {
            double dval = (Double)val;
            return Double.isNaN(dval) ? 0 : (int)dval;
        }
        if (val instanceof Number) {
            return ((Number)val).intValue();
        }
        if (val instanceof String) {
            return this.parseInteger((String)val);
        }
        if (val instanceof Boolean) {
            return (Boolean)val != false ? 1 : 0;
        }
        if (val instanceof AtomicBoolean) {
            return ((AtomicBoolean)val).get() ? 1 : 0;
        }
        if (val instanceof Character) {
            return ((Character)val).charValue();
        }
        if (val == null) {
            return this.controlNullOperand(this.strict, 0);
        }
        throw new CoercionException("Integer coercion: " + val.getClass().getName() + ":(" + val + ")");
    }

    protected long toLong(boolean strict, Object val) {
        return this.isNullOperand(val) ? this.controlNullOperand(strict, 0L).longValue() : this.toLong(val);
    }

    public long toLong(Object val) {
        if (val instanceof Double) {
            double dval = (Double)val;
            return Double.isNaN(dval) ? 0L : (long)dval;
        }
        if (val instanceof Number) {
            return ((Number)val).longValue();
        }
        if (val instanceof String) {
            return this.parseLong((String)val);
        }
        if (val instanceof Boolean) {
            return (Boolean)val != false ? 1L : 0L;
        }
        if (val instanceof AtomicBoolean) {
            return ((AtomicBoolean)val).get() ? 1L : 0L;
        }
        if (val instanceof Character) {
            return ((Character)val).charValue();
        }
        if (val == null) {
            return this.controlNullOperand(this.strict, 0L);
        }
        throw new CoercionException("Long coercion: " + val.getClass().getName() + ":(" + val + ")");
    }

    protected String toString(boolean strict, Object val) {
        return this.isNullOperand(val) ? this.controlNullOperand(strict, "") : this.toString(val);
    }

    public String toString(Object val) {
        if (val instanceof Double) {
            Double dval = (Double)val;
            if (Double.isNaN(dval)) {
                return "";
            }
            return dval.toString();
        }
        return val == null ? this.controlNullOperand(this.strict, "") : val.toString();
    }

    public Object xor(Object left, Object right) {
        long l = this.toLong(left);
        long r = this.toLong(right);
        return l ^ r;
    }

    public static interface ArrayBuilder {
        public void add(Object var1);

        public Object create(boolean var1);
    }

    public static class NullOperand
    extends ArithmeticException {
        private static final long serialVersionUID = 4720876194840764770L;
    }

    public static class CoercionException
    extends ArithmeticException {
        private static final long serialVersionUID = 202402081150L;

        public CoercionException(String msg) {
            super(msg);
        }

        public CoercionException(String msg, Throwable cause) {
            super(msg);
            this.initCause(cause);
        }
    }

    public static interface MapBuilder {
        public Object create();

        public void put(Object var1, Object var2);
    }

    public static interface SetBuilder {
        public void add(Object var1);

        public Object create();
    }

    public static interface Uberspect {
        public JexlMethod getOperator(JexlOperator var1, Object ... var2);

        public boolean overloads(JexlOperator var1);
    }
}

