/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.sdk.ftp;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Set;
import org.apache.commons.net.ftp.FTPClient;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.api.upload.FtpUploader;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.common.Artifact;
import org.jreleaser.model.spi.upload.UploadException;
import org.jreleaser.sdk.commons.AbstractArtifactUploader;
import org.jreleaser.sdk.ftp.FtpUtils;

public class FtpArtifactUploader
extends AbstractArtifactUploader<FtpUploader, org.jreleaser.model.internal.upload.FtpUploader> {
    private org.jreleaser.model.internal.upload.FtpUploader uploader;

    public FtpArtifactUploader(JReleaserContext context) {
        super(context);
    }

    public org.jreleaser.model.internal.upload.FtpUploader getUploader() {
        return this.uploader;
    }

    public void setUploader(org.jreleaser.model.internal.upload.FtpUploader uploader) {
        this.uploader = uploader;
    }

    public String getType() {
        return "ftp";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void upload(String name) throws UploadException {
        Set artifacts = this.collectArtifacts();
        if (artifacts.isEmpty()) {
            this.context.getLogger().info(RB.$((String)"artifacts.no.match", (Object[])new Object[0]));
        }
        FTPClient ftp = FtpUtils.open(this.context, this.uploader);
        try {
            for (Artifact artifact : artifacts) {
                Path path = artifact.getEffectivePath(this.context);
                this.context.getLogger().info(" - {}", new Object[]{path.getFileName()});
                if (this.context.isDryrun()) continue;
                try {
                    InputStream in = Files.newInputStream(path, new OpenOption[0]);
                    try {
                        String uploadPath = this.uploader.getResolvedPath(this.context, artifact);
                        this.context.getLogger().debug("   " + RB.$((String)"uploader.uploading.to", (Object[])new Object[]{uploadPath}));
                        ftp.storeFile(uploadPath, in);
                    }
                    finally {
                        if (in == null) continue;
                        in.close();
                    }
                }
                catch (IOException e) {
                    this.context.getLogger().trace((Throwable)e);
                    throw new UploadException(RB.$((String)"ERROR_unexpected_upload", (Object[])new Object[]{this.context.getBasedir().relativize(path)}), (Throwable)e);
                    return;
                }
            }
        }
        finally {
            FtpUtils.close(this.uploader, ftp);
        }
    }
}

