/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.sdk.mattermost;

import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.announce.WebhookAnnouncer;
import org.jreleaser.model.spi.announce.AnnounceException;
import org.jreleaser.model.spi.announce.Announcer;
import org.jreleaser.sdk.webhooks.WebhooksAnnouncer;

public class MattermostAnnouncer
implements Announcer<org.jreleaser.model.api.announce.MattermostAnnouncer> {
    private final JReleaserContext context;
    private final org.jreleaser.model.internal.announce.MattermostAnnouncer mattermost;

    public MattermostAnnouncer(JReleaserContext context) {
        this.context = context;
        this.mattermost = context.getModel().getAnnounce().getMattermost();
    }

    public org.jreleaser.model.api.announce.MattermostAnnouncer getAnnouncer() {
        return this.mattermost.asImmutable();
    }

    public String getName() {
        return "mattermost";
    }

    public boolean isEnabled() {
        return this.mattermost.isEnabled();
    }

    public void announce() throws AnnounceException {
        this.context.getLogger().setPrefix("webhook." + this.getName());
        try {
            WebhooksAnnouncer.announce((JReleaserContext)this.context, (WebhookAnnouncer)this.mattermost.asWebhookAnnouncer(), (boolean)false);
        }
        catch (AnnounceException x) {
            this.context.getLogger().warn(x.getMessage().trim());
        }
        finally {
            this.context.getLogger().restorePrefix();
        }
    }
}

