/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.sdk.command;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jreleaser.util.PlatformUtils;

public class Command {
    private final List<String> args = new ArrayList<String>();
    private final boolean supportsArgsfile;

    public Command() {
        this.supportsArgsfile = false;
    }

    public Command(String arg) {
        this.supportsArgsfile = false;
        this.args.add(arg);
    }

    public Command(String arg, boolean supportsArgsfile) {
        this.supportsArgsfile = supportsArgsfile;
        this.args.add(arg);
    }

    public Command(List<String> args) {
        this.supportsArgsfile = false;
        this.args.addAll(args);
    }

    public boolean isSupportsArgsfile() {
        return this.supportsArgsfile;
    }

    public List<String> getArgs() {
        return Collections.unmodifiableList(this.args);
    }

    public boolean hasArg(String arg) {
        return this.args.contains(arg);
    }

    public Command arg(String arg) {
        this.args.add(arg);
        return this;
    }

    public Command args(Collection<String> args) {
        this.args.addAll(args);
        return this;
    }

    public List<String> asCommandLine() throws IOException {
        if (!this.supportsArgsfile) {
            return this.getArgs();
        }
        if (PlatformUtils.isWindows()) {
            File argsFile = File.createTempFile("jreleaser-command", "args");
            argsFile.deleteOnExit();
            Files.write(argsFile.toPath(), this.args.stream().skip(1L)::iterator, new OpenOption[0]);
            String cmd = this.args.get(0);
            this.args.clear();
            this.args.add(cmd);
            this.args.add("@" + argsFile);
        }
        return this.getArgs();
    }

    public static class Result {
        private final String out;
        private final String err;
        private final int exitValue;

        public static Result empty() {
            return new Result("", "", -1);
        }

        public static Result of(String err, int exitValue) {
            return new Result("", err, exitValue);
        }

        public static Result of(String out, String err, int exitValue) {
            return new Result(out, err, exitValue);
        }

        private Result(String out, String err, int exitValue) {
            this.out = out.trim();
            this.err = err.trim();
            this.exitValue = exitValue;
        }

        public String getOut() {
            return this.out;
        }

        public String getErr() {
            return this.err;
        }

        public int getExitValue() {
            return this.exitValue;
        }
    }
}

