/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.sdk.gitlab;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.UpdateSection;
import org.jreleaser.model.api.common.Apply;
import org.jreleaser.model.api.common.ExtraProperties;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.common.Artifact;
import org.jreleaser.model.internal.distributions.Distribution;
import org.jreleaser.model.internal.release.BaseReleaser;
import org.jreleaser.model.internal.upload.Uploader;
import org.jreleaser.model.internal.util.Artifacts;
import org.jreleaser.model.internal.util.VersionUtils;
import org.jreleaser.model.spi.release.Asset;
import org.jreleaser.model.spi.release.Release;
import org.jreleaser.model.spi.release.ReleaseException;
import org.jreleaser.model.spi.release.Repository;
import org.jreleaser.model.spi.release.User;
import org.jreleaser.mustache.TemplateContext;
import org.jreleaser.mustache.Templates;
import org.jreleaser.sdk.commons.RestAPIException;
import org.jreleaser.sdk.git.ChangelogProvider;
import org.jreleaser.sdk.git.GitSdk;
import org.jreleaser.sdk.git.release.AbstractReleaser;
import org.jreleaser.sdk.gitlab.Gitlab;
import org.jreleaser.sdk.gitlab.api.GlFileUpload;
import org.jreleaser.sdk.gitlab.api.GlIssue;
import org.jreleaser.sdk.gitlab.api.GlLabel;
import org.jreleaser.sdk.gitlab.api.GlLink;
import org.jreleaser.sdk.gitlab.api.GlLinkRequest;
import org.jreleaser.sdk.gitlab.api.GlMilestone;
import org.jreleaser.sdk.gitlab.api.GlProject;
import org.jreleaser.sdk.gitlab.api.GlRelease;
import org.jreleaser.util.StringUtils;

public class GitlabReleaser
extends AbstractReleaser<org.jreleaser.model.api.release.GitlabReleaser> {
    private static final long serialVersionUID = 1079387159817891884L;
    private final org.jreleaser.model.internal.release.GitlabReleaser gitlab;

    public GitlabReleaser(JReleaserContext context, Set<Asset> assets) {
        super(context, assets);
        this.gitlab = context.getModel().getRelease().getGitlab();
    }

    public org.jreleaser.model.api.release.GitlabReleaser getReleaser() {
        return this.gitlab.asImmutable();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void createRelease() throws ReleaseException {
        String pullBranch = this.gitlab.getBranch();
        String pushBranch = this.gitlab.getResolvedBranchPush(this.context.getModel());
        boolean mustCheckoutBranch = !pushBranch.equals(pullBranch);
        this.context.getLogger().info(RB.$((String)"git.releaser.releasing", (Object[])new Object[0]), new Object[]{this.gitlab.getResolvedRepoUrl(this.context.getModel()), pushBranch});
        String tagName = this.gitlab.getEffectiveTagName(this.context.getModel());
        try {
            Gitlab api = new Gitlab(this.context.asImmutable(), this.gitlab.getApiEndpoint(), this.gitlab.getToken(), this.gitlab.getConnectTimeout(), this.gitlab.getReadTimeout());
            if (!this.context.isDryrun()) {
                List<String> branchNames = api.listBranches(this.gitlab.getOwner(), this.gitlab.getName(), this.gitlab.getProjectIdentifier());
                GitSdk.of((JReleaserContext)this.context).checkoutBranch((BaseReleaser)this.gitlab, pushBranch, mustCheckoutBranch, !branchNames.contains(pushBranch));
            }
            String changelog = this.context.getChangelog().getResolvedChangelog();
            this.context.getLogger().debug(RB.$((String)"git.releaser.release.lookup", (Object[])new Object[0]), new Object[]{tagName, this.gitlab.getCanonicalRepoName()});
            GlRelease release = this.findReleaseByTag(api, tagName);
            boolean snapshot = this.context.getModel().getProject().isSnapshot();
            if (null != release) {
                this.context.getLogger().debug(RB.$((String)"git.releaser.release.exists", (Object[])new Object[0]), new Object[]{tagName});
                if (this.gitlab.isOverwrite() || snapshot) {
                    this.context.getLogger().debug(RB.$((String)"git.releaser.release.delete", (Object[])new Object[0]), new Object[]{tagName});
                    if (!this.context.isDryrun()) {
                        api.deleteRelease(this.gitlab.getOwner(), this.gitlab.getName(), this.gitlab.getProjectIdentifier(), tagName);
                    }
                    this.context.getLogger().debug(RB.$((String)"git.releaser.release.create", (Object[])new Object[0]), new Object[]{tagName});
                    this.createRelease(api, tagName, changelog, this.gitlab.isMatch());
                    return;
                }
                if (this.gitlab.getUpdate().isEnabled()) {
                    this.context.getLogger().debug(RB.$((String)"git.releaser.release.update", (Object[])new Object[0]), new Object[]{tagName});
                    if (this.context.isDryrun()) return;
                    boolean update = false;
                    GlRelease updater = new GlRelease();
                    if (this.gitlab.getUpdate().getSections().contains(UpdateSection.TITLE)) {
                        update = true;
                        this.context.getLogger().info(RB.$((String)"git.releaser.release.update.title", (Object[])new Object[0]), new Object[]{this.gitlab.getEffectiveReleaseName()});
                        updater.setName(this.gitlab.getEffectiveReleaseName());
                    }
                    if (this.gitlab.getUpdate().getSections().contains(UpdateSection.BODY)) {
                        update = true;
                        this.context.getLogger().info(RB.$((String)"git.releaser.release.update.body", (Object[])new Object[0]));
                        updater.setDescription(changelog);
                    }
                    if (update) {
                        api.updateRelease(this.gitlab.getOwner(), this.gitlab.getName(), this.gitlab.getProjectIdentifier(), updater);
                    }
                    if (this.gitlab.getUpdate().getSections().contains(UpdateSection.ASSETS)) {
                        this.updateAssets(api, release);
                    }
                    this.updateIssues(this.gitlab, api);
                    return;
                }
                if (this.context.isDryrun()) {
                    this.context.getLogger().debug(RB.$((String)"git.releaser.release.create", (Object[])new Object[0]), new Object[]{tagName});
                    this.createRelease(api, tagName, changelog, false);
                    return;
                }
                throw new IllegalStateException(RB.$((String)"ERROR_git_releaser_cannot_release", (Object[])new Object[]{"GitLab", tagName}));
            }
            this.context.getLogger().debug(RB.$((String)"git.releaser.release.not.found", (Object[])new Object[0]), new Object[]{tagName});
            this.context.getLogger().debug(RB.$((String)"git.releaser.release.create", (Object[])new Object[0]), new Object[]{tagName});
            this.createRelease(api, tagName, changelog, snapshot && this.gitlab.isMatch());
            return;
        }
        catch (IOException | IllegalStateException | RestAPIException e) {
            this.context.getLogger().trace(e);
            throw new ReleaseException(e);
        }
    }

    private GlRelease findReleaseByTag(Gitlab api, String tagName) {
        if (this.context.isDryrun()) {
            return null;
        }
        return api.findReleaseByTag(this.gitlab.getOwner(), this.gitlab.getName(), this.gitlab.getProjectIdentifier(), tagName);
    }

    public Repository maybeCreateRepository(String owner, String repo, String password, ExtraProperties extraProperties) throws IOException {
        GlProject project;
        Gitlab api;
        block4: {
            this.context.getLogger().debug(RB.$((String)"git.repository.lookup", (Object[])new Object[0]), new Object[]{owner, repo});
            api = new Gitlab(this.context.asImmutable(), this.gitlab.getApiEndpoint(), password, this.gitlab.getConnectTimeout(), this.gitlab.getReadTimeout());
            project = null;
            try {
                String projectIdentifier = extraProperties.getExtraProperty("projectIdentifier");
                if (StringUtils.isNotBlank((String)projectIdentifier)) {
                    project = api.findProject(repo, projectIdentifier);
                }
            }
            catch (RestAPIException e) {
                if (e.isNotFound()) break block4;
                throw e;
            }
        }
        if (null == project) {
            project = api.createProject(owner, repo);
        }
        return new Repository(Repository.Kind.GITLAB, owner, repo, project.getWebUrl(), project.getHttpUrlToRepo());
    }

    public Optional<User> findUser(String email, String name) {
        try {
            return new Gitlab(this.context.asImmutable(), this.gitlab.getApiEndpoint(), this.gitlab.getToken(), this.gitlab.getConnectTimeout(), this.gitlab.getReadTimeout()).findUser(email, name);
        }
        catch (RestAPIException e) {
            this.context.getLogger().trace((Throwable)e);
            this.context.getLogger().debug(RB.$((String)"git.releaser.user.not.found", (Object[])new Object[0]), new Object[]{email});
            return Optional.empty();
        }
    }

    public List<Release> listReleases(String owner, String repo) throws IOException {
        Gitlab api = new Gitlab(this.context.asImmutable(), this.gitlab.getApiEndpoint(), this.gitlab.getToken(), this.gitlab.getConnectTimeout(), this.gitlab.getReadTimeout());
        List<Release> releases = api.listReleases(owner, repo, this.gitlab.getProjectIdentifier());
        VersionUtils.clearUnparseableTags();
        Pattern versionPattern = VersionUtils.resolveVersionPattern((JReleaserContext)this.context);
        for (Release release : releases) {
            release.setVersion(VersionUtils.version((JReleaserContext)this.context, (String)release.getTagName(), (Pattern)versionPattern));
        }
        releases.sort((r1, r2) -> r2.getVersion().compareTo((Object)r1.getVersion()));
        return releases;
    }

    private void createRelease(Gitlab api, String tagName, String changelog, boolean deleteTags) throws IOException {
        Collection<GlLinkRequest> links = this.collectUploadLinks(this.gitlab);
        if (this.context.isDryrun()) {
            if (!this.assets.isEmpty()) {
                for (Asset asset : this.assets) {
                    if (0L == Files.size(asset.getPath()) || !Files.exists(asset.getPath(), new LinkOption[0])) continue;
                    this.context.getLogger().info(" " + RB.$((String)"git.upload.asset", (Object[])new Object[0]), new Object[]{asset.getFilename()});
                }
            }
            if (!links.isEmpty()) {
                for (GlLinkRequest link : links) {
                    this.context.getLogger().info(" " + RB.$((String)"git.upload.asset", (Object[])new Object[0]), new Object[]{link.getName()});
                }
            }
            this.updateIssues(this.gitlab, api);
            return;
        }
        Integer projectIdentifier = api.findProject(this.gitlab.getName(), this.gitlab.getProjectIdentifier()).getId();
        if (deleteTags) {
            this.deleteTags(api, this.gitlab.getOwner(), this.gitlab.getName(), projectIdentifier, tagName);
        }
        if (deleteTags || !this.gitlab.isSkipTag()) {
            this.context.getLogger().debug(RB.$((String)"git.releaser.repository.tag", (Object[])new Object[0]), new Object[]{tagName, this.context.getModel().getCommit().getShortHash()});
            GitSdk.of((JReleaserContext)this.context).tag(tagName, true, this.context);
        }
        GlRelease release = new GlRelease();
        release.setName(this.gitlab.getEffectiveReleaseName());
        release.setTagName(tagName);
        release.setRef(this.gitlab.getResolvedBranchPush(this.context.getModel()));
        release.setDescription(changelog);
        api.createRelease(this.gitlab.getOwner(), this.gitlab.getName(), projectIdentifier, release);
        if (!this.assets.isEmpty()) {
            Collection<GlFileUpload> uploads = api.uploadAssets(this.gitlab.getOwner(), this.gitlab.getName(), projectIdentifier, this.assets);
            api.linkReleaseAssets(this.gitlab.getOwner(), this.gitlab.getName(), release, projectIdentifier, uploads);
        }
        if (!links.isEmpty()) {
            api.linkAssets(this.gitlab.getOwner(), this.gitlab.getName(), release, projectIdentifier, links);
        }
        if (this.gitlab.getMilestone().isClose() && !this.context.getModel().getProject().isSnapshot()) {
            Optional<GlMilestone> milestone = api.findMilestoneByName(this.gitlab.getOwner(), this.gitlab.getName(), projectIdentifier, this.gitlab.getMilestone().getEffectiveName());
            milestone.ifPresent(glMilestone -> api.closeMilestone(this.gitlab.getOwner(), this.gitlab.getName(), projectIdentifier, (GlMilestone)glMilestone));
        }
        this.updateIssues(this.gitlab, api);
    }

    private void updateAssets(Gitlab api, GlRelease release) throws IOException {
        TreeSet<Asset> assetsToBeUpdated = new TreeSet<Asset>();
        TreeSet<Asset> assetsToBeUploaded = new TreeSet<Asset>();
        Integer projectIdentifier = api.findProject(this.gitlab.getName(), this.gitlab.getProjectIdentifier()).getId();
        String tagName = this.gitlab.getEffectiveTagName(this.context.getModel());
        Map<String, GlLink> existingAssets = api.listLinks(projectIdentifier, tagName);
        LinkedHashMap assetsToBePublished = new LinkedHashMap();
        this.assets.forEach(asset -> assetsToBePublished.put(asset.getFilename(), asset));
        assetsToBePublished.keySet().forEach(name -> {
            if (existingAssets.containsKey(name)) {
                assetsToBeUpdated.add((Asset)assetsToBePublished.get(name));
            } else {
                assetsToBeUploaded.add((Asset)assetsToBePublished.get(name));
            }
        });
        this.updateAssets(api, release, assetsToBeUpdated, projectIdentifier, tagName, existingAssets);
        this.uploadAssets(api, release, assetsToBeUploaded, projectIdentifier);
        if (!this.gitlab.getUploadLinks().isEmpty()) {
            Collection<GlLinkRequest> links = this.collectUploadLinks(this.gitlab);
            api.linkAssets(this.gitlab.getOwner(), this.gitlab.getName(), release, projectIdentifier, links);
        }
    }

    private void updateAssets(Gitlab api, GlRelease release, Set<Asset> assetsToBeUpdated, Integer projectIdentifier, String tagName, Map<String, GlLink> existingLinks) throws IOException {
        if (!assetsToBeUpdated.isEmpty()) {
            for (Asset asset : assetsToBeUpdated) {
                GlLink existingLink = existingLinks.get(asset.getFilename());
                api.deleteLinkedAsset(this.gitlab.getToken(), projectIdentifier, tagName, existingLink);
            }
            Collection<GlFileUpload> uploads = api.uploadAssets(this.gitlab.getOwner(), this.gitlab.getName(), projectIdentifier, assetsToBeUpdated);
            api.linkReleaseAssets(this.gitlab.getOwner(), this.gitlab.getName(), release, projectIdentifier, uploads);
        }
    }

    private void uploadAssets(Gitlab api, GlRelease release, Set<Asset> assetsToBeUploaded, Integer projectIdentifier) throws IOException {
        if (!assetsToBeUploaded.isEmpty()) {
            Collection<GlFileUpload> uploads = api.uploadAssets(this.gitlab.getOwner(), this.gitlab.getName(), projectIdentifier, assetsToBeUploaded);
            api.linkReleaseAssets(this.gitlab.getOwner(), this.gitlab.getName(), release, projectIdentifier, uploads);
        }
    }

    private void updateIssues(org.jreleaser.model.internal.release.GitlabReleaser gitlab, Gitlab api) throws IOException {
        if (!gitlab.getIssues().isEnabled()) {
            return;
        }
        List issueNumbers = ChangelogProvider.getIssues((JReleaserContext)this.context);
        if (!issueNumbers.isEmpty()) {
            this.context.getLogger().info(RB.$((String)"git.issue.release.mark", (Object[])new Object[]{issueNumbers.size()}));
        }
        if (this.context.isDryrun()) {
            for (String issueNumber : issueNumbers) {
                this.context.getLogger().debug(RB.$((String)"git.issue.release", (Object[])new Object[]{issueNumber}));
            }
            return;
        }
        Integer projectIdentifier = api.findProject(gitlab.getName(), gitlab.getProjectIdentifier()).getId();
        String tagName = gitlab.getEffectiveTagName(this.context.getModel());
        String labelName = gitlab.getIssues().getLabel().getName();
        String labelColor = gitlab.getIssues().getLabel().getColor();
        TemplateContext props = gitlab.props(this.context.getModel());
        gitlab.fillProps(props, this.context.getModel());
        String comment = Templates.resolveTemplate((String)gitlab.getIssues().getComment(), (TemplateContext)props);
        if (!labelColor.startsWith("#")) {
            try {
                Integer.parseInt(labelColor, 16);
                labelColor = "#" + labelColor;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        GlLabel glLabel = null;
        try {
            glLabel = api.getOrCreateLabel(projectIdentifier, labelName, labelColor, gitlab.getIssues().getLabel().getDescription());
        }
        catch (IOException e) {
            throw new IllegalStateException(RB.$((String)"ERROR_git_releaser_fetch_label", (Object[])new Object[]{tagName, labelName}), e);
        }
        Optional<Object> milestone = Optional.empty();
        Apply applyMilestone = gitlab.getIssues().getApplyMilestone();
        if (gitlab.getMilestone().isClose() && !this.context.getModel().getProject().isSnapshot() && !(milestone = api.findMilestoneByName(gitlab.getOwner(), gitlab.getName(), projectIdentifier, gitlab.getMilestone().getEffectiveName())).isPresent()) {
            milestone = api.findClosedMilestoneByName(gitlab.getOwner(), gitlab.getName(), projectIdentifier, gitlab.getMilestone().getEffectiveName());
        }
        List<GlIssue> issues = api.listIssues(projectIdentifier);
        for (String issueNumber : issueNumbers) {
            GlIssue glIssue;
            Integer in = Integer.parseInt(issueNumber);
            Optional<GlIssue> op = issues.stream().filter(i -> i.getIid().equals(in)).findFirst();
            if (!op.isPresent() || !"closed".equals((glIssue = op.get()).getState()) || !glIssue.getLabels().stream().noneMatch(l -> l.equals(labelName))) continue;
            this.context.getLogger().debug(RB.$((String)"git.issue.release", (Object[])new Object[]{issueNumber}));
            try {
                api.addLabelToIssue(projectIdentifier, glIssue, glLabel);
                api.commentOnIssue(projectIdentifier, glIssue, comment);
                milestone.ifPresent(glMilestone -> this.applyMilestone(api, projectIdentifier, issueNumber, glIssue, applyMilestone, (GlMilestone)glMilestone));
            }
            catch (RestAPIException e) {
                if (e.isForbidden()) {
                    this.context.getLogger().warn(e.getMessage());
                    continue;
                }
                throw e;
            }
        }
    }

    private void applyMilestone(Gitlab api, Integer projectIdentifier, String issueNumber, GlIssue glIssue, Apply applyMilestone, GlMilestone targetMilestone) {
        GlMilestone issueMilestone = glIssue.getMilestone();
        String targetMilestoneTitle = targetMilestone.getTitle();
        if (null == issueMilestone) {
            this.context.getLogger().debug(RB.$((String)"git.issue.milestone.apply", (Object[])new Object[]{targetMilestoneTitle, issueNumber}));
            api.setMilestoneOnIssue(projectIdentifier, glIssue, targetMilestone);
        } else {
            String milestoneTitle = issueMilestone.getTitle();
            if (applyMilestone == Apply.ALWAYS) {
                this.context.getLogger().debug(StringUtils.uncapitalize((String)RB.$((String)"git.issue.milestone.warn", (Object[])new Object[]{issueNumber, milestoneTitle})));
            } else if (applyMilestone == Apply.WARN) {
                if (!milestoneTitle.equals(targetMilestoneTitle)) {
                    this.context.getLogger().warn(RB.$((String)"git.issue.milestone.warn", (Object[])new Object[]{issueNumber, milestoneTitle}));
                }
            } else if (applyMilestone == Apply.FORCE) {
                if (!milestoneTitle.equals(targetMilestoneTitle)) {
                    this.context.getLogger().warn(RB.$((String)"git.issue.milestone.force", (Object[])new Object[]{targetMilestoneTitle, issueNumber, milestoneTitle}));
                    api.setMilestoneOnIssue(projectIdentifier, glIssue, targetMilestone);
                } else {
                    this.context.getLogger().debug(StringUtils.uncapitalize((String)RB.$((String)"git.issue.milestone.warn", (Object[])new Object[]{issueNumber, milestoneTitle})));
                }
            }
        }
    }

    private Collection<GlLinkRequest> collectUploadLinks(org.jreleaser.model.internal.release.GitlabReleaser gitlab) {
        ArrayList<GlLinkRequest> links = new ArrayList<GlLinkRequest>();
        for (Map.Entry e : gitlab.getUploadLinks().entrySet()) {
            Optional uploader = this.context.getModel().getUpload().getActiveUploader((String)e.getKey(), (String)e.getValue());
            if (!uploader.isPresent()) continue;
            this.collectUploadLinks((Uploader)uploader.get(), links);
        }
        return links;
    }

    private void collectUploadLinks(Uploader<?> uploader, List<GlLinkRequest> links) {
        List keys = uploader.resolveSkipKeys();
        keys.add("skipGitlabLinks");
        ArrayList<Object> artifacts = new ArrayList<Object>();
        if (uploader.isFiles()) {
            for (Artifact artifact : Artifacts.resolveFiles((JReleaserContext)this.context)) {
                if (!artifact.isActiveAndSelected()) continue;
                Path path = artifact.getEffectivePath(this.context);
                if (this.isSkip((org.jreleaser.model.internal.common.ExtraProperties)artifact, keys) || !Files.exists(path, new LinkOption[0]) || 0L == path.toFile().length()) continue;
                artifacts.add(artifact);
            }
        }
        if (uploader.isArtifacts()) {
            for (Distribution distribution : this.context.getModel().getActiveDistributions()) {
                if (this.isSkip((org.jreleaser.model.internal.common.ExtraProperties)distribution, keys)) continue;
                for (Artifact artifact : distribution.getArtifacts()) {
                    if (!artifact.isActiveAndSelected()) continue;
                    Path path = artifact.getEffectivePath(this.context, distribution);
                    if (this.isSkip((org.jreleaser.model.internal.common.ExtraProperties)artifact, keys) || !Files.exists(path, new LinkOption[0]) || 0L == path.toFile().length()) continue;
                    String platform = artifact.getPlatform();
                    String platformReplaced = distribution.getPlatform().applyReplacements(platform);
                    if (StringUtils.isNotBlank((String)platformReplaced)) {
                        artifact.getExtraProperties().put("platformReplaced", platformReplaced);
                    }
                    artifacts.add(artifact);
                }
            }
        }
        if (uploader.isSignatures() && this.context.getModel().getSigning().isEnabled()) {
            String extension = this.context.getModel().getSigning().isArmored() ? ".asc" : ".sig";
            ArrayList<Artifact> arrayList = new ArrayList<Artifact>();
            for (Artifact artifact : artifacts) {
                Path signaturePath;
                if (artifact.extraPropertyIsTrue("skipSigning") || !Files.exists(signaturePath = this.context.getSignaturesDirectory().resolve(artifact.getEffectivePath(this.context).getFileName() + extension), new LinkOption[0]) || 0L == signaturePath.toFile().length()) continue;
                arrayList.add(Artifact.of((Path)signaturePath));
            }
            artifacts.addAll(arrayList);
        }
        for (Artifact artifact : artifacts) {
            links.add(GitlabReleaser.toLinkRequest(artifact.getEffectivePath(), uploader.getResolvedDownloadUrl(this.context, artifact)));
        }
    }

    private boolean isSkip(org.jreleaser.model.internal.common.ExtraProperties props, List<String> keys) {
        for (String key : keys) {
            if (!props.extraPropertyIsTrue(key)) continue;
            return true;
        }
        return false;
    }

    private void deleteTags(Gitlab api, String owner, String repo, Integer projectIdentifier, String tagName) {
        try {
            api.deleteTag(owner, repo, projectIdentifier, tagName);
        }
        catch (RestAPIException restAPIException) {
            // empty catch block
        }
    }

    private static GlLinkRequest toLinkRequest(Path path, String url) {
        GlLinkRequest link = new GlLinkRequest();
        link.setName(path.getFileName().toString());
        link.setUrl(url);
        link.setFilepath("/" + link.getName());
        return link;
    }
}

