/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.mustache;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public final class TemplateContext {
    private final Map<String, Object> properties = new LinkedHashMap<String, Object>();

    public static TemplateContext empty() {
        return new TemplateContext();
    }

    public static TemplateContext from(Map<String, Object> props) {
        if (props != null) {
            return new TemplateContext(props);
        }
        return new TemplateContext();
    }

    public TemplateContext() {
    }

    public TemplateContext(Map<String, Object> props) {
        this.properties.putAll(props);
    }

    public TemplateContext(TemplateContext other) {
        this.setAll(other);
    }

    public boolean isEmpty() {
        return this.properties.isEmpty();
    }

    public Set<String> keys() {
        return this.properties.keySet();
    }

    public Set<Map.Entry<String, Object>> entries() {
        return this.properties.entrySet();
    }

    public boolean contains(String key) {
        return this.properties.containsKey(key);
    }

    public <V> V get(String key) {
        return (V)this.properties.get(key);
    }

    public TemplateContext setAll(TemplateContext other) {
        if (null != other) {
            this.properties.putAll(other.properties);
        }
        return this;
    }

    public <V> TemplateContext setAll(Map<String, V> props) {
        if (null == props || props.isEmpty()) {
            return this;
        }
        props.forEach(this::set);
        return this;
    }

    public <V> V set(String key, V value) {
        Object previousValue = this.properties.get(key);
        if (null != value) {
            this.properties.put(key, value);
        }
        return (V)previousValue;
    }

    public <V> V set(String key, V value, V defaultValue) {
        Object previousValue = this.properties.get(key);
        if (null != value && null != defaultValue) {
            this.properties.put(key, value);
        }
        return (V)previousValue;
    }

    public <V> V remove(String key) {
        return (V)this.properties.remove(key);
    }

    public Map<String, Object> asMap() {
        return this.properties;
    }
}

