/*
 * Decompiled with CFR 0.152.
 */
package feign;

import feign.Client;
import feign.DefaultAsyncClient;
import feign.Experimental;
import feign.Request;
import feign.Response;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;

@Experimental
public interface AsyncClient<C> {
    public CompletableFuture<Response> execute(Request var1, Request.Options var2, Optional<C> var3);

    public static class Pseudo<C>
    implements AsyncClient<C> {
        private final Client client;

        public Pseudo(Client client) {
            this.client = client;
        }

        @Override
        public CompletableFuture<Response> execute(Request request, Request.Options options, Optional<C> requestContext) {
            CompletableFuture<Response> result = new CompletableFuture<Response>();
            try {
                result.complete(this.client.execute(request, options));
            }
            catch (Exception e) {
                result.completeExceptionally(e);
            }
            return result;
        }
    }

    @Deprecated
    public static class Default<C>
    extends DefaultAsyncClient<C> {
        public Default(Client client, ExecutorService executorService) {
            super(client, executorService);
        }
    }
}

