/*
 * Decompiled with CFR 0.152.
 */
package feign.codec;

import feign.Response;
import feign.Util;
import feign.codec.DefaultErrorDecoder;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.concurrent.TimeUnit;

public interface ErrorDecoder {
    public Exception decode(String var1, Response var2);

    public static class RetryAfterDecoder {
        private final DateTimeFormatter dateTimeFormatter;

        RetryAfterDecoder() {
            this(DateTimeFormatter.RFC_1123_DATE_TIME);
        }

        RetryAfterDecoder(DateTimeFormatter dateTimeFormatter) {
            this.dateTimeFormatter = Util.checkNotNull(dateTimeFormatter, "dateTimeFormatter", new Object[0]);
        }

        protected long currentTimeMillis() {
            return System.currentTimeMillis();
        }

        public Long apply(String retryAfter) {
            if (retryAfter == null) {
                return null;
            }
            if (retryAfter.matches("^[0-9]+\\.?0*$")) {
                retryAfter = retryAfter.replaceAll("\\.0*$", "");
                long deltaMillis = TimeUnit.SECONDS.toMillis(Long.parseLong(retryAfter));
                return this.currentTimeMillis() + deltaMillis;
            }
            try {
                return ZonedDateTime.parse(retryAfter, this.dateTimeFormatter).toInstant().toEpochMilli();
            }
            catch (NullPointerException | DateTimeParseException ignored) {
                return null;
            }
        }
    }

    @Deprecated
    public static class Default
    extends DefaultErrorDecoder {
        public Default() {
        }

        public Default(Integer maxBodyBytesLength, Integer maxBodyCharsLength) {
            super(maxBodyBytesLength, maxBodyCharsLength);
        }
    }
}

