/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.engine.sign;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.catalog.sbom.SbomCataloger;
import org.jreleaser.model.internal.common.Artifact;
import org.jreleaser.model.internal.distributions.Distribution;
import org.jreleaser.model.internal.signing.SigningTool;
import org.jreleaser.model.internal.util.Artifacts;
import org.jreleaser.model.spi.catalog.sbom.SbomCatalogerProcessorHelper;
import org.jreleaser.sdk.signing.SigningUtils;
import org.jreleaser.util.Algorithm;

public abstract class AbstractSigner {
    protected final JReleaserContext context;
    protected final SigningTool tool;

    protected AbstractSigner(JReleaserContext context, SigningTool tool) {
        this.context = context;
        this.tool = tool;
    }

    protected List<SigningUtils.FilePair> collectArtifacts(Predicate<SigningUtils.FilePair> validator) {
        return this.collectArtifacts(false, validator);
    }

    protected List<SigningUtils.FilePair> collectArtifacts(boolean forceSign, Predicate<SigningUtils.FilePair> validator) {
        SigningUtils.FilePair pair;
        Path output;
        ArrayList<SigningUtils.FilePair> files = new ArrayList<SigningUtils.FilePair>();
        Path signaturesDirectory = this.context.getSignaturesDirectory();
        if (this.tool.isFiles()) {
            for (Artifact artifact : Artifacts.resolveFiles((JReleaserContext)this.context)) {
                if (!artifact.isActiveAndSelected() || artifact.extraPropertyIsTrue("skipSigning") || artifact.isOptional(this.context) && !artifact.resolvedPathExists()) continue;
                Path input = artifact.getEffectivePath(this.context);
                output = signaturesDirectory.resolve(input.getFileName().toString().concat(this.tool.getSignatureExtension()));
                pair = new SigningUtils.FilePair(input, output);
                if (!forceSign) {
                    pair.setValid(validator.test(pair));
                }
                files.add(pair);
            }
        }
        if (this.tool.isArtifacts()) {
            for (Object distribution : this.context.getModel().getActiveDistributions()) {
                if (distribution.extraPropertyIsTrue("skipSigning")) continue;
                for (Object artifact : distribution.getArtifacts()) {
                    if (!artifact.isActiveAndSelected() || artifact.extraPropertyIsTrue("skipSigning")) continue;
                    Path input = artifact.getEffectivePath(this.context, (Distribution)distribution);
                    if (artifact.isOptional(this.context) && !artifact.resolvedPathExists()) continue;
                    Path output2 = signaturesDirectory.resolve(input.getFileName().toString().concat(this.tool.getSignatureExtension()));
                    SigningUtils.FilePair pair2 = new SigningUtils.FilePair(input, output2);
                    if (!forceSign) {
                        pair2.setValid(validator.test(pair2));
                    }
                    files.add(pair2);
                }
            }
        }
        if (this.tool.isCatalogs()) {
            List catalogers = this.context.getModel().getCatalog().getSbom().findAllActiveSbomCatalogers();
            for (SbomCataloger cataloger : catalogers) {
                if (!cataloger.getPack().isEnabled()) continue;
                for (Artifact artifact : SbomCatalogerProcessorHelper.resolveArtifacts((JReleaserContext)this.context, (SbomCataloger)cataloger)) {
                    Path input = artifact.getEffectivePath(this.context);
                    Path output3 = signaturesDirectory.resolve(input.getFileName().toString().concat(this.tool.getSignatureExtension()));
                    SigningUtils.FilePair pair3 = new SigningUtils.FilePair(input, output3);
                    if (!forceSign) {
                        pair3.setValid(validator.test(pair3));
                    }
                    files.add(pair3);
                }
            }
        }
        if (this.tool.isChecksums()) {
            for (Algorithm algorithm : this.context.getModel().getChecksum().getAlgorithms()) {
                Path checksums = this.context.getChecksumsDirectory().resolve(this.context.getModel().getChecksum().getResolvedName(this.context, algorithm));
                if (!Files.exists(checksums, new LinkOption[0])) continue;
                output = signaturesDirectory.resolve(checksums.getFileName().toString().concat(this.tool.getSignatureExtension()));
                pair = new SigningUtils.FilePair(checksums, output);
                if (!forceSign) {
                    pair.setValid(validator.test(pair));
                }
                files.add(pair);
            }
        }
        return files;
    }
}

