/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal;

import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import org.jreleaser.model.JReleaserException;
import org.jreleaser.util.StringUtils;

public abstract class JReleaserModelPrinter {
    private static final String SECRET_KEYWORDS = "password,secret,credential,token,apikey,login,passphrase,consumerkey,publickey,accesskey,webhook";
    private final PrintWriter out;

    protected JReleaserModelPrinter(PrintWriter out) {
        this.out = out;
    }

    public void print(Object value) {
        this.print(value, 0);
    }

    public void print(Object value, int offset) {
        if (value instanceof Map) {
            this.doPrintMap((Map)value, offset);
        } else if (value instanceof Collection) {
            this.doPrintCollection((Collection)value, offset);
        } else if (null != value) {
            Class<?> clazz = value.getClass();
            if (clazz.isArray()) {
                this.doPrintArray((Object[])value, offset);
            } else {
                this.doPrintElement(value, offset);
            }
        }
    }

    private void doPrintMap(Map<String, ?> map, int offset) {
        if (null != map) {
            map.forEach((key, value) -> {
                if (value instanceof Map) {
                    if (!((Map)value).isEmpty()) {
                        this.out.println(JReleaserModelPrinter.multiply("    ", offset) + key + ":");
                        this.doPrintMap((Map)value, offset + 1);
                    }
                } else if (value instanceof Collection) {
                    if (!((Collection)value).isEmpty()) {
                        this.out.println(JReleaserModelPrinter.multiply("    ", offset) + key + ":");
                        this.doPrintCollection((Collection)value, offset + 1);
                    }
                } else if (null != value && value.getClass().isArray()) {
                    if (((Object[])value).length > 0) {
                        this.out.println(JReleaserModelPrinter.multiply("    ", offset) + key + ":");
                        this.doPrintArray((Object[])value, offset + 1);
                    }
                } else if (this.isNotNullNorBlank(value)) {
                    this.doPrintMapEntry((String)key, value, offset);
                }
                if (offset == 0) {
                    this.out.println(" ");
                }
            });
        }
    }

    private void doPrintMapEntry(String key, Object value, int offset) {
        if (value instanceof Map) {
            this.doPrintMap(key, (Map)value, offset);
        } else if (value instanceof Collection) {
            this.doPrintCollection(key, (Collection)value, offset);
        } else if (null != value) {
            Class<?> clazz = value.getClass();
            if (clazz.isArray()) {
                this.doPrintArray(key, (Object[])value, offset);
            } else {
                String result = this.formatValue(value, JReleaserModelPrinter.isSecret(key));
                if (this.isNotNullNorBlank(result)) {
                    this.out.println(JReleaserModelPrinter.multiply("    ", offset) + key + ": " + result);
                }
            }
        }
    }

    private void doPrintCollection(Collection<?> collection, int offset) {
        if (null != collection) {
            collection.forEach(value -> {
                if (value instanceof Map) {
                    if (!((Map)value).isEmpty()) {
                        this.doPrintMap((Map)value, offset);
                    }
                } else if (value instanceof Collection) {
                    if (!((Collection)value).isEmpty()) {
                        this.doPrintCollection((Collection)value, offset + 1);
                    }
                } else if (null != value && value.getClass().isArray()) {
                    if (((Object[])value).length > 0) {
                        this.doPrintArray((Object[])value, offset + 1);
                    }
                } else if (this.isNotNullNorBlank(value)) {
                    this.doPrintElement(value, offset);
                }
            });
        }
    }

    private void doPrintArray(Object[] array, int offset) {
        if (null != array) {
            Arrays.stream(array).forEach(value -> {
                if (value instanceof Map) {
                    if (!((Map)value).isEmpty()) {
                        this.doPrintMap((Map)value, offset);
                    }
                } else if (value instanceof Collection) {
                    if (!((Collection)value).isEmpty()) {
                        this.doPrintCollection((Collection)value, offset + 1);
                    }
                } else if (null != value && value.getClass().isArray()) {
                    if (((Object[])value).length > 0) {
                        this.doPrintArray((Object[])value, offset + 1);
                    }
                } else if (this.isNotNullNorBlank(value)) {
                    this.doPrintElement(value, offset);
                }
            });
        }
    }

    private void doPrintMap(String key, Map<String, ?> map, int offset) {
        if (null != map && !map.isEmpty()) {
            this.out.println(JReleaserModelPrinter.multiply("    ", offset) + key + ':');
            this.doPrintMap(map, offset + 1);
        }
    }

    private void doPrintCollection(String key, Collection<?> collection, int offset) {
        if (null != collection && !collection.isEmpty()) {
            this.out.println(JReleaserModelPrinter.multiply("    ", offset) + key + ':');
            this.doPrintCollection(collection, offset + 1);
        }
    }

    private void doPrintArray(String key, Object[] array, int offset) {
        if (null != array && array.length > 0) {
            this.out.println(JReleaserModelPrinter.multiply("    ", offset) + key + ':');
            this.doPrintArray(array, offset + 1);
        }
    }

    private void doPrintElement(Object value, int offset) {
        String result = this.formatValue(value);
        if (this.isNotNullNorBlank(result)) {
            this.out.println(JReleaserModelPrinter.multiply("    ", offset) + result);
        }
    }

    private boolean isNotNullNorBlank(Object value) {
        if (value instanceof CharSequence) {
            return StringUtils.isNotBlank((String)String.valueOf(value));
        }
        return null != value;
    }

    private String formatValue(Object value) {
        return this.formatValue(value, false);
    }

    private String formatValue(Object value, boolean secret) {
        if (value instanceof Boolean) {
            Boolean b = (Boolean)value;
            return b != false ? this.green(String.valueOf(b)) : this.red(String.valueOf(b));
        }
        if (value instanceof Number) {
            return this.cyan(String.valueOf(value));
        }
        if (null != value) {
            String r;
            String s = String.valueOf(value);
            if (secret && !"**unset**".equals(s)) {
                s = "************";
            }
            if (null != (r = this.parseAsBoolean(s))) {
                return r;
            }
            r = this.parseAsInteger(s);
            if (null != r) {
                return r;
            }
            r = this.parseAsDouble(s);
            if (null != r) {
                return r;
            }
            return secret ? this.magenta(s) : this.yellow(s);
        }
        return String.valueOf(value);
    }

    private String parseAsBoolean(String s) {
        if ("true".equalsIgnoreCase(s) || "false".equalsIgnoreCase(s)) {
            boolean b = Boolean.parseBoolean(s);
            return b ? this.green(String.valueOf(b)) : this.red(String.valueOf(b));
        }
        return null;
    }

    private String parseAsInteger(String s) {
        try {
            Integer.parseInt(s);
            return this.cyan(s);
        }
        catch (Exception e) {
            return null;
        }
    }

    private String parseAsDouble(String s) {
        try {
            Double.parseDouble(s);
            return this.cyan(s);
        }
        catch (Exception e) {
            return null;
        }
    }

    private String cyan(String s) {
        return this.color("cyan", s);
    }

    private String red(String s) {
        return this.color("red", s);
    }

    private String green(String s) {
        return this.color("green", s);
    }

    private String magenta(String s) {
        return this.color("magenta", s);
    }

    private String yellow(String s) {
        return this.color("yellow", s);
    }

    protected abstract String color(String var1, String var2);

    public static boolean isSecret(String key) {
        String lower = key.toLowerCase(Locale.ENGLISH);
        for (String keyword : SECRET_KEYWORDS.split(",")) {
            if (!lower.contains(keyword.trim().toLowerCase(Locale.ENGLISH))) continue;
            return true;
        }
        return false;
    }

    private static String multiply(CharSequence self, Number factor) {
        int size = factor.intValue();
        if (size == 0) {
            return "";
        }
        if (size < 0) {
            throw new JReleaserException("multiply() should be called with a number of 0 or greater not: " + size);
        }
        StringBuilder answer = new StringBuilder(self);
        for (int i = 1; i < size; ++i) {
            answer.append(self);
        }
        return answer.toString();
    }

    public static class Plain
    extends JReleaserModelPrinter {
        public Plain(PrintWriter out) {
            super(out);
        }

        @Override
        protected String color(String color, String input) {
            return input;
        }
    }
}

