// NOTE: Assertions have been autogenerated by utils/update_cc_test_checks.py
// RUN: %clang_cc1 -triple riscv32 -target-feature +zbkb -emit-llvm %s -o - \
// RUN:     | FileCheck %s  -check-prefix=RV32ZBKB

// RV32ZBKB-LABEL: @brev8(
// RV32ZBKB-NEXT:  entry:
// RV32ZBKB-NEXT:    [[RS1_ADDR:%.*]] = alloca i32, align 4
// RV32ZBKB-NEXT:    store i32 [[RS1:%.*]], ptr [[RS1_ADDR]], align 4
// RV32ZBKB-NEXT:    [[TMP0:%.*]] = load i32, ptr [[RS1_ADDR]], align 4
// RV32ZBKB-NEXT:    [[TMP1:%.*]] = call i32 @llvm.riscv.brev8.i32(i32 [[TMP0]])
// RV32ZBKB-NEXT:    ret i32 [[TMP1]]
//
long brev8(long rs1)
{
  return __builtin_riscv_brev8(rs1);
}

// RV32ZBKB-LABEL: @zip(
// RV32ZBKB-NEXT:  entry:
// RV32ZBKB-NEXT:    [[RS1_ADDR:%.*]] = alloca i32, align 4
// RV32ZBKB-NEXT:    store i32 [[RS1:%.*]], ptr [[RS1_ADDR]], align 4
// RV32ZBKB-NEXT:    [[TMP0:%.*]] = load i32, ptr [[RS1_ADDR]], align 4
// RV32ZBKB-NEXT:    [[TMP1:%.*]] = call i32 @llvm.riscv.zip.i32(i32 [[TMP0]])
// RV32ZBKB-NEXT:    ret i32 [[TMP1]]
//
int zip(int rs1)
{
  return __builtin_riscv_zip_32(rs1);
}

// RV32ZBKB-LABEL: @unzip(
// RV32ZBKB-NEXT:  entry:
// RV32ZBKB-NEXT:    [[RS1_ADDR:%.*]] = alloca i32, align 4
// RV32ZBKB-NEXT:    store i32 [[RS1:%.*]], ptr [[RS1_ADDR]], align 4
// RV32ZBKB-NEXT:    [[TMP0:%.*]] = load i32, ptr [[RS1_ADDR]], align 4
// RV32ZBKB-NEXT:    [[TMP1:%.*]] = call i32 @llvm.riscv.unzip.i32(i32 [[TMP0]])
// RV32ZBKB-NEXT:    ret i32 [[TMP1]]
//
int unzip(int rs1)
{
  return __builtin_riscv_unzip_32(rs1);
}
