/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.examples.xssf.usermodel;

import java.awt.Color;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.PrintOrientation;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.util.LocaleUtil;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFPrintSetup;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class CalendarDemo {
    private static final String[] days = new String[]{"Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"};
    private static final String[] months = new String[]{"January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"};

    public static void main(String[] args) throws Exception {
        Calendar calendar = LocaleUtil.getLocaleCalendar();
        if (args.length > 0) {
            calendar.set(1, Integer.parseInt(args[0]));
        }
        int year = calendar.get(1);
        try (XSSFWorkbook wb = new XSSFWorkbook();){
            Map<String, XSSFCellStyle> styles = CalendarDemo.createStyles(wb);
            block18: for (int month = 0; month < 12; ++month) {
                calendar.set(2, month);
                calendar.set(5, 1);
                XSSFSheet sheet = wb.createSheet(months[month]);
                sheet.setDisplayGridlines(false);
                sheet.setPrintGridlines(false);
                XSSFPrintSetup printSetup = sheet.getPrintSetup();
                printSetup.setOrientation(PrintOrientation.LANDSCAPE);
                sheet.setFitToPage(true);
                sheet.setHorizontallyCenter(true);
                XSSFRow headerRow = sheet.createRow(0);
                headerRow.setHeightInPoints(80.0f);
                XSSFCell titleCell = headerRow.createCell(0);
                titleCell.setCellValue(months[month] + " " + year);
                titleCell.setCellStyle((CellStyle)styles.get("title"));
                sheet.addMergedRegion(CellRangeAddress.valueOf((String)"$A$1:$N$1"));
                XSSFRow monthRow = sheet.createRow(1);
                for (int i = 0; i < days.length; ++i) {
                    sheet.setColumnWidth(i * 2, 1280);
                    sheet.setColumnWidth(i * 2 + 1, 3328);
                    sheet.addMergedRegion(new CellRangeAddress(1, 1, i * 2, i * 2 + 1));
                    XSSFCell monthCell = monthRow.createCell(i * 2);
                    monthCell.setCellValue(days[i]);
                    monthCell.setCellStyle((CellStyle)styles.get("month"));
                }
                int cnt = 1;
                int day = 1;
                int rownum = 2;
                for (int j = 0; j < 6; ++j) {
                    XSSFRow row = sheet.createRow(rownum++);
                    row.setHeightInPoints(100.0f);
                    for (int i = 0; i < days.length; ++i) {
                        XSSFCell dayCell_1 = row.createCell(i * 2);
                        XSSFCell dayCell_2 = row.createCell(i * 2 + 1);
                        int day_of_week = calendar.get(7);
                        if (cnt >= day_of_week && calendar.get(2) == month) {
                            dayCell_1.setCellValue((double)day);
                            calendar.set(5, ++day);
                            if (i == 0 || i == days.length - 1) {
                                dayCell_1.setCellStyle((CellStyle)styles.get("weekend_left"));
                                dayCell_2.setCellStyle((CellStyle)styles.get("weekend_right"));
                            } else {
                                dayCell_1.setCellStyle((CellStyle)styles.get("workday_left"));
                                dayCell_2.setCellStyle((CellStyle)styles.get("workday_right"));
                            }
                        } else {
                            dayCell_1.setCellStyle((CellStyle)styles.get("grey_left"));
                            dayCell_2.setCellStyle((CellStyle)styles.get("grey_right"));
                        }
                        ++cnt;
                    }
                    if (calendar.get(2) > month) continue block18;
                }
            }
            try (FileOutputStream out = new FileOutputStream("calendar-" + year + ".xlsx");){
                wb.write((OutputStream)out);
            }
        }
    }

    private static Map<String, XSSFCellStyle> createStyles(XSSFWorkbook wb) {
        HashMap<String, XSSFCellStyle> styles = new HashMap<String, XSSFCellStyle>();
        XSSFFont titleFont = wb.createFont();
        titleFont.setFontHeightInPoints((short)48);
        titleFont.setColor(new XSSFColor(new Color(39, 51, 89), wb.getStylesSource().getIndexedColors()));
        XSSFCellStyle style = wb.createCellStyle();
        style.setAlignment(HorizontalAlignment.CENTER);
        style.setVerticalAlignment(VerticalAlignment.CENTER);
        style.setFont((Font)titleFont);
        styles.put("title", style);
        XSSFFont monthFont = wb.createFont();
        monthFont.setFontHeightInPoints((short)12);
        monthFont.setColor(new XSSFColor(new Color(255, 255, 255), wb.getStylesSource().getIndexedColors()));
        monthFont.setBold(true);
        style = wb.createCellStyle();
        style.setAlignment(HorizontalAlignment.CENTER);
        style.setVerticalAlignment(VerticalAlignment.CENTER);
        style.setFillForegroundColor(new XSSFColor(new Color(39, 51, 89), wb.getStylesSource().getIndexedColors()));
        style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        style.setFont((Font)monthFont);
        styles.put("month", style);
        XSSFFont dayFont = wb.createFont();
        dayFont.setFontHeightInPoints((short)14);
        dayFont.setBold(true);
        style = wb.createCellStyle();
        style.setAlignment(HorizontalAlignment.LEFT);
        style.setVerticalAlignment(VerticalAlignment.TOP);
        style.setFillForegroundColor(new XSSFColor(new Color(228, 232, 243), wb.getStylesSource().getIndexedColors()));
        style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        style.setBorderLeft(BorderStyle.THIN);
        style.setLeftBorderColor(new XSSFColor(new Color(39, 51, 89), wb.getStylesSource().getIndexedColors()));
        style.setBorderBottom(BorderStyle.THIN);
        style.setBottomBorderColor(new XSSFColor(new Color(39, 51, 89), wb.getStylesSource().getIndexedColors()));
        style.setFont((Font)dayFont);
        styles.put("weekend_left", style);
        style = wb.createCellStyle();
        style.setAlignment(HorizontalAlignment.CENTER);
        style.setVerticalAlignment(VerticalAlignment.TOP);
        style.setFillForegroundColor(new XSSFColor(new Color(228, 232, 243), wb.getStylesSource().getIndexedColors()));
        style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        style.setBorderRight(BorderStyle.THIN);
        style.setRightBorderColor(new XSSFColor(new Color(39, 51, 89), wb.getStylesSource().getIndexedColors()));
        style.setBorderBottom(BorderStyle.THIN);
        style.setBottomBorderColor(new XSSFColor(new Color(39, 51, 89), wb.getStylesSource().getIndexedColors()));
        styles.put("weekend_right", style);
        style = wb.createCellStyle();
        style.setAlignment(HorizontalAlignment.LEFT);
        style.setVerticalAlignment(VerticalAlignment.TOP);
        style.setBorderLeft(BorderStyle.THIN);
        style.setFillForegroundColor(new XSSFColor(new Color(255, 255, 255), wb.getStylesSource().getIndexedColors()));
        style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        style.setLeftBorderColor(new XSSFColor(new Color(39, 51, 89), wb.getStylesSource().getIndexedColors()));
        style.setBorderBottom(BorderStyle.THIN);
        style.setBottomBorderColor(new XSSFColor(new Color(39, 51, 89), wb.getStylesSource().getIndexedColors()));
        style.setFont((Font)dayFont);
        styles.put("workday_left", style);
        style = wb.createCellStyle();
        style.setAlignment(HorizontalAlignment.CENTER);
        style.setVerticalAlignment(VerticalAlignment.TOP);
        style.setFillForegroundColor(new XSSFColor(new Color(255, 255, 255), wb.getStylesSource().getIndexedColors()));
        style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        style.setBorderRight(BorderStyle.THIN);
        style.setRightBorderColor(new XSSFColor(new Color(39, 51, 89), wb.getStylesSource().getIndexedColors()));
        style.setBorderBottom(BorderStyle.THIN);
        style.setBottomBorderColor(new XSSFColor(new Color(39, 51, 89), wb.getStylesSource().getIndexedColors()));
        styles.put("workday_right", style);
        style = wb.createCellStyle();
        style.setBorderLeft(BorderStyle.THIN);
        style.setFillForegroundColor(new XSSFColor(new Color(234, 234, 234), wb.getStylesSource().getIndexedColors()));
        style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        style.setBorderBottom(BorderStyle.THIN);
        style.setBottomBorderColor(new XSSFColor(new Color(39, 51, 89), wb.getStylesSource().getIndexedColors()));
        styles.put("grey_left", style);
        style = wb.createCellStyle();
        style.setFillForegroundColor(new XSSFColor(new Color(234, 234, 234), wb.getStylesSource().getIndexedColors()));
        style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        style.setBorderRight(BorderStyle.THIN);
        style.setRightBorderColor(new XSSFColor(new Color(39, 51, 89), wb.getStylesSource().getIndexedColors()));
        style.setBorderBottom(BorderStyle.THIN);
        style.setBottomBorderColor(new XSSFColor(new Color(39, 51, 89), wb.getStylesSource().getIndexedColors()));
        styles.put("grey_right", style);
        return styles;
    }
}

