//============================================================================
//  The contents of this file are covered by the Viskores license. See
//  LICENSE.txt for details.
//
//  By contributing to this file, all contributors agree to the Developer
//  Certificate of Origin Version 1.1 (DCO 1.1) as stated in DCO.txt.
//============================================================================

//============================================================================
//  Copyright (c) Kitware, Inc.
//  All rights reserved.
//  See LICENSE.txt for details.
//
//  This software is distributed WITHOUT ANY WARRANTY; without even
//  the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
//  PURPOSE.  See the above copyright notice for more information.
//============================================================================
#include <viskores/cont/Initialize.h>
#include <viskores/io/VTKDataSetReader.h>
#include <viskores/io/VTKDataSetWriter.h>

// Note that to see all of the logging output generated by this example, run
// the program with the --viskores-log-level=1 argument.

int main(int argc, char** argv)
{
  auto opts = viskores::cont::InitializeOptions::AddHelp;

  // SetLogLevelName must be called before Initialize
  viskores::cont::SetLogLevelName(viskores::cont::LogLevel::UserFirst, "tlog");
  viskores::cont::InitializeResult config = viskores::cont::Initialize(argc, argv, opts);

  const std::string input = "data/kitchen.vtk";
  viskores::io::VTKDataSetReader reader(input);
  VISKORES_LOG_F(viskores::cont::LogLevel::Info, "Reading from file %s", input.c_str());
  viskores::cont::DataSet ds_from_file = reader.ReadDataSet();
  VISKORES_LOG_F(viskores::cont::LogLevel::Info, "Done reading from file %s", input.c_str());

  const std::string output = "out_logging.vtk";
  VISKORES_LOG_S(viskores::cont::LogLevel::UserFirst, "Writing to file" << output);
  viskores::io::VTKDataSetWriter writer(output);
  writer.WriteDataSet(ds_from_file);
  VISKORES_LOG_S(viskores::cont::LogLevel::UserFirst, "Done writing to file" << output);

  return 0;
}
